import datetime
import typing

import QuantConnect.Data
import QuantConnect.Data.Custom.TradingEconomics
import System
import System.Collections.Generic

JsonConverter = typing.Any


class TradingEconomics(System.Object):
    """TradingEconomics static class contains shortcut definitions of major Trading Economics Indicators available"""

    class Indicator(System.Object):
        """Indicator group"""

        class Afghanistan(System.Object):
            """This class has no documentation."""

            Currency: str = "USDAFN"
            """Afghanistan Currency"""

        class Albania(System.Object):
            """This class has no documentation."""

            Currency: str = "USDALL"
            """Albania Currency"""

        class Algeria(System.Object):
            """This class has no documentation."""

            Currency: str = "USDDZD"
            """Algeria Currency"""

        class Angola(System.Object):
            """This class has no documentation."""

            Currency: str = "USDAOA"
            """Angola Currency"""

        class Argentina(System.Object):
            """This class has no documentation."""

            InterestRate: str = "APDR1T"
            """Argentina Interest Rate"""

            DepositInterestRate: str = "ARGFRINRDPST"
            """Argentina Deposit Interest Rate"""

            StockMarket: str = "MERVAL"
            """Argentina Stock Market"""

            Currency: str = "USDARS"
            """Argentina Currency"""

        class Armenia(System.Object):
            """This class has no documentation."""

            Currency: str = "USDAMD"
            """Armenia Currency"""

        class Australia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "AS51"
            """Australia Stock Market"""

            Currency: str = "AUDUSD"
            """Australia Currency"""

            TwoYearNoteYield: str = "AUSTRALIA2YNY"
            """Australia 2 Year Note Yield"""

            CentralBankBalanceSheet: str = "AUSTRALIACENBANBALSH"
            """Australia Central Bank Balance Sheet"""

            InflationExpectations: str = "AUSTRALIAINFEXP"
            """Australia Inflation Expectations"""

            GovernmentBond10y: str = "GACGB10"
            """Australia Government Bond 10Y"""

            ConsumerConfidence: str = "WMCCCONPCT"
            """Australia Consumer Confidence"""

        class Austria(System.Object):
            """This class has no documentation."""

            StockMarket: str = "ATX"
            """Austria Stock Market"""

            Currency: str = "EURUSD"
            """Austria Currency"""

            GovernmentBond10y: str = "GAGB10YR"
            """Austria Government Bond 10Y"""

        class Bahamas(System.Object):
            """This class has no documentation."""

            Currency: str = "USDBSD"
            """Bahamas Currency"""

        class Bahrain(System.Object):
            """This class has no documentation."""

            InterbankRate: str = "BAHRAININTRAT"
            """Bahrain Interbank Rate"""

            StockMarket: str = "BHSEEI"
            """Bahrain Stock Market"""

            Currency: str = "USDBHD"
            """Bahrain Currency"""

        class Bangladesh(System.Object):
            """This class has no documentation."""

            InterestRate: str = "BANGLADESHINTRATE"
            """Bangladesh Interest Rate"""

            StockMarket: str = "DHAKA"
            """Bangladesh Stock Market"""

            Currency: str = "USDBDT"
            """Bangladesh Currency"""

        class Belarus(System.Object):
            """This class has no documentation."""

            Currency: str = "USDBYR"
            """Belarus Currency"""

        class Belgium(System.Object):
            """This class has no documentation."""

            StockMarket: str = "BEL20"
            """Belgium Stock Market"""

            GovernmentBond10y: str = "GBGB10YR"
            """Belgium Government Bond 10Y"""

        class Bermuda(System.Object):
            """This class has no documentation."""

            StockMarket: str = "BSX"
            """Bermuda Stock Market"""

        class Bolivia(System.Object):
            """This class has no documentation."""

            Currency: str = "USDBOB"
            """Bolivia Currency"""

        class BosniaAndHerzegovina(System.Object):
            """This class has no documentation."""

            StockMarket: str = "SASX10"
            """BosniaAndHerzegovina Stock Market"""

            Currency: str = "USDBIH"
            """BosniaAndHerzegovina Currency"""

        class Botswana(System.Object):
            """This class has no documentation."""

            StockMarket: str = "BGSMDC"
            """Botswana Stock Market"""

            Currency: str = "USDBWP"
            """Botswana Currency"""

        class Brazil(System.Object):
            """This class has no documentation."""

            CashReserveRatio: str = "BRAZILCASRESRAT"
            """Brazil Cash Reserve Ratio"""

            InterbankRate: str = "BRAZILINTRAT"
            """Brazil Interbank Rate"""

            MinimumWages: str = "BRAZILMINWAG"
            """Brazil Minimum Wages"""

            GovernmentBond10y: str = "GEBU10Y"
            """Brazil Government Bond 10Y"""

            StockMarket: str = "IBOV"
            """Brazil Stock Market"""

            Currency: str = "USDBRL"
            """Brazil Currency"""

        class Brunei(System.Object):
            """This class has no documentation."""

            Currency: str = "USDBND"
            """Brunei Currency"""

        class Bulgaria(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "BULGARIAGOVBON10Y"
            """Bulgaria Government Bond 10Y"""

            InterbankRate: str = "BULGARIAINTRAT"
            """Bulgaria Interbank Rate"""

            StockMarket: str = "SOFIX"
            """Bulgaria Stock Market"""

            Currency: str = "USDBGN"
            """Bulgaria Currency"""

        class Burundi(System.Object):
            """This class has no documentation."""

            Currency: str = "USDBIF"
            """Burundi Currency"""

        class Cambodia(System.Object):
            """This class has no documentation."""

            Currency: str = "USDKHR"
            """Cambodia Currency"""

        class Canada(System.Object):
            """This class has no documentation."""

            BankLendingRate: str = "CANADABANLENRAT"
            """Canada Bank Lending Rate"""

            InterbankRate: str = "CANADAINTRAT"
            """Canada Interbank Rate"""

            DepositInterestRate: str = "CANFRINRDPST"
            """Canada Deposit Interest Rate"""

            InterestRate: str = "CCLR"
            """Canada Interest Rate"""

            GovernmentBond10y: str = "GCAN10YR"
            """Canada Government Bond 10Y"""

            ConsumerConfidence: str = "OECAI001"
            """Canada Consumer Confidence"""

            StockMarket: str = "SPTSX"
            """Canada Stock Market"""

            Currency: str = "USDCAD"
            """Canada Currency"""

        class CapeVerde(System.Object):
            """This class has no documentation."""

            Currency: str = "USDCVE"
            """CapeVerde Currency"""

        class CaymanIslands(System.Object):
            """This class has no documentation."""

            Currency: str = "USDKYD"
            """CaymanIslands Currency"""

        class Chile(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "CHILEGOVBON10Y"
            """Chile Government Bond 10y"""

            InterbankRate: str = "CHILEINTRAT"
            """Chile Interbank Rate"""

            StockMarket: str = "IGPA"
            """Chile Stock Market"""

            Currency: str = "USDCLP"
            """Chile Currency"""

        class China(System.Object):
            """This class has no documentation."""

            CashReserveRatio: str = "CHINACASRESRAT"
            """China Cash Reserve Ratio"""

            InterbankRate: str = "CHINAINTRAT"
            """China Interbank Rate"""

            ReverseRepoRate: str = "CHINAREVREPRAT"
            """China Reverse Repo Rate"""

            GovernmentBond10y: str = "GCNY10YR"
            """China Government Bond 10Y"""

            StockMarket: str = "SHCOMP"
            """China Stock Market"""

            Currency: str = "USDCNY"
            """China Currency"""

        class Colombia(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "COGR10Y"
            """Colombia Government Bond 10Y"""

            StockMarket: str = "COLCAP"
            """Colombia Stock Market"""

            InterbankRate: str = "COLOMBIAINTRAT"
            """Colombia Interbank Rate"""

            Currency: str = "USDCOP"
            """Colombia Currency"""

        class Commodity(System.Object):
            """This class has no documentation."""

            BalticExchangeDryIndex: str = "BALTIC"
            """Commodity Baltic Exchange Dry Index"""

            Beef: str = "BEEF"
            """Commodity Beef"""

            Bitumen: str = "BIT"
            """Commodity Bitumen"""

            Corn: str = "C-1"
            """Commodity Corn"""

            Cocoa: str = "CC1"
            """Commodity Cocoa"""

            Cheese: str = "CHEESE1"
            """Commodity Cheese"""

            CrudeOil: str = "CL1"
            """Commodity Crude oil"""

            BrentCrudeOil: str = "CO1"
            """Commodity Brent crude oil"""

            Coal: str = "COAL"
            """Commodity Coal"""

            Cobalt: str = "COBALT"
            """Commodity Cobalt"""

            CrbCommodityIndex: str = "CRB"
            """Commodity CRB Commodity Index"""

            Cotton: str = "CT1"
            """Commodity Cotton"""

            Ethanol: str = "DL1"
            """Commodity Ethanol"""

            FeederCattle: str = "FC1"
            """Commodity Feeder Cattle"""

            GsciCommodityIndex: str = "GSCI"
            """Commodity GSCI Commodity Index"""

            Copper: str = "HG1"
            """Commodity Copper"""

            HeatingOil: str = "HO1"
            """Commodity Heating oil"""

            ManganeseOre: str = "IMR"
            """Commodity Manganese Ore"""

            IronOre: str = "IRONORE"
            """Commodity Iron Ore"""

            Rubber: str = "JN1"
            """Commodity Rubber"""

            OrangeJuice: str = "JO1"
            """Commodity Orange Juice"""

            Coffee: str = "KC1"
            """Commodity Coffee"""

            Lumber: str = "LB1"
            """Commodity Lumber"""

            LiveCattle: str = "LC1"
            """Commodity Live Cattle"""

            LeanHogs: str = "LH1"
            """Commodity Lean Hogs"""

            Lithium: str = "LITHIUM"
            """Commodity Lithium"""

            Aluminum: str = "LMAHDS03"
            """Commodity Aluminum"""

            LmeIndex: str = "LME"
            """Commodity LME Index"""

            Molybdenum: str = "LMMLDS03"
            """Commodity Molybdenum"""

            Nickel: str = "LMNIDS03"
            """Commodity Nickel"""

            Lead: str = "LMPBDS03"
            """Commodity Lead"""

            Tin: str = "LMSNDS03"
            """Commodity Tin"""

            Zinc: str = "LMZSDS03"
            """Commodity Zinc"""

            Milk: str = "MILK"
            """Commodity Milk"""

            Naphtha: str = "NAPHTHA"
            """Commodity Naphtha"""

            NaturalGas: str = "NG1"
            """Commodity Natural gas"""

            Oat: str = "O-1"
            """Commodity Oat"""

            Wool: str = "OL1"
            """Commodity Wool"""

            PalmOil: str = "PALMOIL"
            """Commodity Palm Oil"""

            Propane: str = "PROPANE"
            """Commodity Propane"""

            Rhodium: str = "RHODIUM"
            """Commodity RHODIUM"""

            Rice: str = "RR1"
            """Commodity Rice"""

            Canola: str = "RS1"
            """Commodity Canola"""

            Soybeans: str = "S-1"
            """Commodity Soybeans"""

            Sugar: str = "SB1"
            """Commodity Sugar"""

            SodaAsh: str = "SODASH"
            """Commodity Soda Ash"""

            Neodymium: str = "SREMNDM"
            """Commodity Neodymium"""

            Steel: str = "STEEL"
            """Commodity Steel"""

            IronOre62PercentFe: str = "TIOC"
            """Commodity Iron Ore 62% FE"""

            Uranium: str = "URANIUM"
            """Commodity Uranium"""

            Wheat: str = "W-1"
            """Commodity Wheat"""

            Silver: str = "XAGUSD"
            """Commodity Silver"""

            Gold: str = "XAUUSD"
            """Commodity Gold"""

            Gasoline: str = "XB1"
            """Commodity Gasoline"""

            Palladium: str = "XPDUSD"
            """Commodity Palladium"""

            Platinum: str = "XPTUSD"
            """Commodity Platinum"""

        class Comoros(System.Object):
            """This class has no documentation."""

            Currency: str = "USDKMF"
            """Comoros Currency"""

        class Congo(System.Object):
            """This class has no documentation."""

            Currency: str = "USDCDF"
            """Congo Currency"""

        class CostaRica(System.Object):
            """This class has no documentation."""

            StockMarket: str = "CRSMBCT"
            """CostaRica Stock Market"""

            Currency: str = "USDCRC"
            """CostaRica Currency"""

        class Croatia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "CRO"
            """Croatia Stock Market"""

            GovernmentBond10y: str = "CROATIAGOVD10Y"
            """Croatia Government Bond 10Y"""

            InterbankRate: str = "CROATIAINTRAT"
            """Croatia Interbank Rate"""

            Currency: str = "USDHRV"
            """Croatia Currency"""

        class Cuba(System.Object):
            """This class has no documentation."""

            Currency: str = "USDCUC"
            """Cuba Currency"""

        class Cyprus(System.Object):
            """This class has no documentation."""

            StockMarket: str = "CYSMMAPA"
            """Cyprus Stock Market"""

        class CzechRepublic(System.Object):
            """This class has no documentation."""

            InterbankRate: str = "CZECHREPUINTRAT"
            """CzechRepublic Interbank Rate"""

            GovernmentBond10y: str = "CZGB10YR"
            """CzechRepublic Government Bond 10Y"""

            StockMarket: str = "PX"
            """CzechRepublic Stock Market"""

            Currency: str = "USDCZK"
            """CzechRepublic Currency"""

        class Denmark(System.Object):
            """This class has no documentation."""

            InterbankRate: str = "DENMARKINTRAT"
            """Denmark Interbank Rate"""

            GovernmentBond10y: str = "GDGB10YR"
            """Denmark Government Bond 10Y"""

            StockMarket: str = "KFX"
            """Denmark Stock Market"""

            Currency: str = "USDDKK"
            """Denmark Currency"""

        class Djibouti(System.Object):
            """This class has no documentation."""

            Currency: str = "USDDJF"
            """Djibouti Currency"""

        class DominicanRepublic(System.Object):
            """This class has no documentation."""

            Currency: str = "USDDOP"
            """DominicanRepublic Currency"""

        class Ecuador(System.Object):
            """This class has no documentation."""

            StockMarket: str = "ECU"
            """Ecuador Stock Market"""

            InterbankRate: str = "ECUADORINTRATI"
            """Ecuador Interbank Rate"""

        class Egypt(System.Object):
            """This class has no documentation."""

            StockMarket: str = "CASE"
            """Egypt Stock Market"""

            InterbankRate: str = "EGYPTINTRAT"
            """Egypt Interbank Rate"""

            InterestRate: str = "EGYPTINTRATE"
            """Egypt Interest Rate"""

            LendingRate: str = "EGYPTLENRAT"
            """Egypt Lending Rate"""

            Currency: str = "USDEGP"
            """Egypt Currency"""

        class Eritrea(System.Object):
            """This class has no documentation."""

            Currency: str = "USDERN"
            """Eritrea Currency"""

        class Estonia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "TALSE"
            """Estonia Stock Market"""

        class Ethiopia(System.Object):
            """This class has no documentation."""

            Currency: str = "USDETB"
            """Ethiopia Currency"""

        class EuroArea(System.Object):
            """This class has no documentation."""

            InterbankRate: str = "EMUEVOLVINTRAT"
            """EuroArea Interbank Rate"""

            LendingRate: str = "EUROAREALENRAT"
            """EuroArea Lending Rate"""

            ZewEconomicSentimentIndex: str = "EUROAREAZEWECOSENIND"
            """EuroArea Zew Economic Sentiment Index"""

            StockMarket: str = "SX5E"
            """EuroArea Stock Market"""

        class Fiji(System.Object):
            """This class has no documentation."""

            Currency: str = "USDFJD"
            """Fiji Currency"""

        class Finland(System.Object):
            """This class has no documentation."""

            InterbankRate: str = "FINLANDINTRAT"
            """Finland Interbank Rate"""

            GovernmentBond10y: str = "GFIN10YR"
            """Finland Government Bond 10Y"""

            StockMarket: str = "HEX25"
            """Finland Stock Market"""

        class France(System.Object):
            """This class has no documentation."""

            StockMarket: str = "CAC"
            """France Stock Market"""

            GovernmentBond10y: str = "GFRN10"
            """France Government Bond 10Y"""

        class Gambia(System.Object):
            """This class has no documentation."""

            Currency: str = "USDGMD"
            """Gambia Currency"""

        class Georgia(System.Object):
            """This class has no documentation."""

            Currency: str = "USDGEL"
            """Georgia Currency"""

        class Germany(System.Object):
            """This class has no documentation."""

            StockMarket: str = "DAX"
            """Germany Stock Market"""

            GovernmentBond10y: str = "GDBR10"
            """Germany Government Bond 10Y"""

            TwoYearNoteYield: str = "GERMANY2YNY"
            """Germany 2 Year Note Yield"""

            ZewEconomicSentimentIndex: str = "GERMANYZEWECOSENIND"
            """Germany Zew Economic Sentiment Index"""

            ConsumerConfidence: str = "GRCCI"
            """Germany Consumer Confidence"""

        class Ghana(System.Object):
            """This class has no documentation."""

            StockMarket: str = "GGSECI"
            """Ghana Stock Market"""

            Currency: str = "USDGHS"
            """Ghana Currency"""

        class Greece(System.Object):
            """This class has no documentation."""

            StockMarket: str = "ASE"
            """Greece Stock Market"""

            GovernmentBond10y: str = "GGGB10YR"
            """Greece Government Bond 10Y"""

            TwoYearNoteYield: str = "GREECE2YNY"
            """Greece 2 Year Note Yield"""

        class Guatemala(System.Object):
            """This class has no documentation."""

            Currency: str = "USDGTQ"
            """Guatemala Currency"""

        class Guinea(System.Object):
            """This class has no documentation."""

            Currency: str = "USDGNF"
            """Guinea Currency"""

        class Guyana(System.Object):
            """This class has no documentation."""

            Currency: str = "USDGYD"
            """Guyana Currency"""

        class Haiti(System.Object):
            """This class has no documentation."""

            Currency: str = "USDHTG"
            """Haiti Currency"""

        class Honduras(System.Object):
            """This class has no documentation."""

            InterestRate: str = "HONURASINTTRATE"
            """Honduras Interest Rate"""

            Currency: str = "USDHNL"
            """Honduras Currency"""

        class HongKong(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GHKGB10Y"
            """HongKong Government Bond 10Y"""

            InterbankRate: str = "HONGKONGINTRAT"
            """HongKong Interbank Rate"""

            StockMarket: str = "HSI"
            """HongKong Stock Market"""

            Currency: str = "USDHKD"
            """HongKong Currency"""

        class Hungary(System.Object):
            """This class has no documentation."""

            StockMarket: str = "BUX"
            """Hungary Stock Market"""

            GovernmentBond10y: str = "GHGB10YR"
            """Hungary Government Bond 10Y"""

            InterbankRate: str = "HUNGARYINTRAT"
            """Hungary Interbank Rate"""

            Currency: str = "USDHUF"
            """Hungary Currency"""

        class Iceland(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "ICELANDGOVBON10Y"
            """Iceland Government Bond 10y"""

            InterbankRate: str = "ICELANDINTRAT"
            """Iceland Interbank Rate"""

            StockMarket: str = "ICEXI"
            """Iceland Stock Market"""

            Currency: str = "USDISK"
            """Iceland Currency"""

        class India(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GIND10YR"
            """India Government Bond 10Y"""

            CashReserveRatio: str = "INDIACASRESRAT"
            """India Cash Reserve Ratio"""

            InterestRate: str = "RSPOYLD"
            """India Interest Rate"""

            StockMarket: str = "SENSEX"
            """India Stock Market"""

            Currency: str = "USDINR"
            """India Currency"""

        class Indonesia(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GIDN10YR"
            """Indonesia Government Bond 10Y"""

            InterbankRate: str = "INDONESIAINTRAT"
            """Indonesia Interbank Rate"""

            StockMarket: str = "JCI"
            """Indonesia Stock Market"""

            Currency: str = "USDIDR"
            """Indonesia Currency"""

        class Iraq(System.Object):
            """This class has no documentation."""

            Currency: str = "USDIQD"
            """Iraq Currency"""

        class Ireland(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GIGB10YR"
            """Ireland Government Bond 10Y"""

            StockMarket: str = "ISEQ"
            """Ireland Stock Market"""

        class Israel(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GISR10YR"
            """Israel Government Bond 10Y"""

            InterestRate: str = "ISBRATE"
            """Israel Interest Rate"""

            InterbankRate: str = "ISRAELINTRAT"
            """Israel Interbank Rate"""

            StockMarket: str = "TA-100"
            """Israel Stock Market"""

            Currency: str = "USDILS"
            """Israel Currency"""

        class Italy(System.Object):
            """This class has no documentation."""

            StockMarket: str = "FTSEMIB"
            """Italy Stock Market"""

            GovernmentBond10y: str = "GBTPGR10"
            """Italy Government Bond 10Y"""

            TwoYearNoteYield: str = "ITALY2YNY"
            """Italy 2 Year Note Yield"""

        class IvoryCoast(System.Object):
            """This class has no documentation."""

            Currency: str = "USDXOF"
            """IvoryCoast Currency"""

        class Jamaica(System.Object):
            """This class has no documentation."""

            InterestRate: str = "JAMAICAINTTRATE"
            """Jamaica Interest Rate"""

            StockMarket: str = "JMSMX"
            """Jamaica Stock Market"""

            Currency: str = "USDJMD"
            """Jamaica Currency"""

        class Japan(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GJGB10"
            """Japan Government Bond 10Y"""

            TwoYearNoteYield: str = "JAPAN2YNY"
            """Japan 2 Year Note Yield"""

            InterbankRate: str = "JAPANINTRAT"
            """Japan Interbank Rate"""

            DepositInterestRate: str = "JPNFRINRDPST"
            """Japan Deposit Interest Rate"""

            StockMarket: str = "NKY"
            """Japan Stock Market"""

            Currency: str = "USDJPY"
            """Japan Currency"""

        class Jordan(System.Object):
            """This class has no documentation."""

            StockMarket: str = "JOSMGNFF"
            """Jordan Stock Market"""

            Currency: str = "USDJOR"
            """Jordan Currency"""

        class Kazakhstan(System.Object):
            """This class has no documentation."""

            InterbankRate: str = "KAZAKHSTANINTRAT"
            """Kazakhstan Interbank Rate"""

            InterestRate: str = "KAZAKHSTANINTRATE"
            """Kazakhstan Interest Rate"""

            StockMarket: str = "KZKAK"
            """Kazakhstan Stock Market"""

            Currency: str = "USDKZT"
            """Kazakhstan Currency"""

        class Kenya(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "KENYAGOVBON10Y"
            """Kenya Government Bond 10y"""

            StockMarket: str = "KNSMIDX"
            """Kenya Stock Market"""

            Currency: str = "USDKES"
            """Kenya Currency"""

        class Kuwait(System.Object):
            """This class has no documentation."""

            InterbankRate: str = "KUWAITINTRAT"
            """Kuwait Interbank Rate"""

            Currency: str = "USDKWD"
            """Kuwait Currency"""

        class Kyrgyzstan(System.Object):
            """This class has no documentation."""

            InterestRate: str = "KYRSTANINTTRATE"
            """Kyrgyzstan Interest Rate"""

            Currency: str = "USDKGS"
            """Kyrgyzstan Currency"""

        class Laos(System.Object):
            """This class has no documentation."""

            StockMarket: str = "LSXC"
            """Laos Stock Market"""

            Currency: str = "USDLAK"
            """Laos Currency"""

        class Latvia(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "LATVIAGOVBON10Y"
            """Latvia Government Bond 10y"""

            InterbankRate: str = "LATVIAINTRAT"
            """Latvia Interbank Rate"""

            StockMarket: str = "RIGSE"
            """Latvia Stock Market"""

        class Lebanon(System.Object):
            """This class has no documentation."""

            StockMarket: str = "BLOM"
            """Lebanon Stock Market"""

            Currency: str = "USDLBP"
            """Lebanon Currency"""

        class Lesotho(System.Object):
            """This class has no documentation."""

            Currency: str = "USDLSL"
            """Lesotho Currency"""

        class Liberia(System.Object):
            """This class has no documentation."""

            Currency: str = "USDLRD"
            """Liberia Currency"""

        class Libya(System.Object):
            """This class has no documentation."""

            Currency: str = "USDLYD"
            """Libya Currency"""

        class Lithuania(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "LITHUANIAGOVBON10Y"
            """Lithuania Government Bond 10y"""

            StockMarket: str = "VILSE"
            """Lithuania Stock Market"""

        class Luxembourg(System.Object):
            """This class has no documentation."""

            StockMarket: str = "LUXXX"
            """Luxembourg Stock Market"""

        class Macau(System.Object):
            """This class has no documentation."""

            InterbankRate: str = "MACAOINTRAT"
            """Macau Interbank Rate"""

            Currency: str = "USDMOP"
            """Macau Currency"""

        class Macedonia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "MBI"
            """Macedonia Stock Market"""

            Currency: str = "USDMKD"
            """Macedonia Currency"""

        class Madagascar(System.Object):
            """This class has no documentation."""

            Currency: str = "USDMGA"
            """Madagascar Currency"""

        class Malawi(System.Object):
            """This class has no documentation."""

            Currency: str = "USDMWK"
            """Malawi Currency"""

        class Malaysia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "FBMKLCI"
            """Malaysia Stock Market"""

            InterbankRate: str = "MALAYSIAINTRAT"
            """Malaysia Interbank Rate"""

            InterestRate: str = "MAOPRATE"
            """Malaysia Interest Rate"""

            GovernmentBond10y: str = "MGIY10Y"
            """Malaysia Government Bond 10Y"""

            Currency: str = "USDMYR"
            """Malaysia Currency"""

        class Maldives(System.Object):
            """This class has no documentation."""

            Currency: str = "USDMVR"
            """Maldives Currency"""

        class Malta(System.Object):
            """This class has no documentation."""

            StockMarket: str = "MALTEX"
            """Malta Stock Market"""

        class Mauritius(System.Object):
            """This class has no documentation."""

            StockMarket: str = "SEMDEX"
            """Mauritius Stock Market"""

            Currency: str = "USDMUR"
            """Mauritius Currency"""

        class Mexico(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GMXN10YR"
            """Mexico Government Bond 10Y"""

            StockMarket: str = "MEXBOL"
            """Mexico Stock Market"""

            InterestRate: str = "MXONBR"
            """Mexico Interest Rate"""

            Currency: str = "USDMXN"
            """Mexico Currency"""

        class Moldova(System.Object):
            """This class has no documentation."""

            Currency: str = "USDMDL"
            """Moldova Currency"""

        class Mongolia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "MSETOP"
            """Mongolia Stock Market"""

            Currency: str = "USDMNT"
            """Mongolia Currency"""

        class Morocco(System.Object):
            """This class has no documentation."""

            StockMarket: str = "MOSENEW"
            """Morocco Stock Market"""

            Currency: str = "USDMAD"
            """Morocco Currency"""

        class Mozambique(System.Object):
            """This class has no documentation."""

            Currency: str = "USDMZN"
            """Mozambique Currency"""

        class Myanmar(System.Object):
            """This class has no documentation."""

            Currency: str = "USDMMK"
            """Myanmar Currency"""

        class Namibia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "FTN098"
            """Namibia Stock Market"""

            Currency: str = "USDNAD"
            """Namibia Currency"""

        class Nepal(System.Object):
            """This class has no documentation."""

            Currency: str = "USDNPR"
            """Nepal Currency"""

        class Netherlands(System.Object):
            """This class has no documentation."""

            StockMarket: str = "AEX"
            """Netherlands Stock Market"""

            GovernmentBond10y: str = "GNTH10YR"
            """Netherlands Government Bond 10Y"""

        class NewCaledonia(System.Object):
            """This class has no documentation."""

            Currency: str = "USDXPF"
            """NewCaledonia Currency"""

        class NewZealand(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GNZGB10"
            """NewZealand Government Bond 10Y"""

            GlobalDairyTradePriceIndex: str = "NEWZEALANGDTPI"
            """NewZealand Global Dairy Trade Price Index"""

            Currency: str = "NZDUSD"
            """NewZealand Currency"""

            DepositInterestRate: str = "NZLFRINRDPST"
            """NewZealand Deposit Interest Rate"""

            InterestRate: str = "NZOCRS"
            """NewZealand Interest Rate"""

            StockMarket: str = "NZSE50FG"
            """NewZealand Stock Market"""

        class Nicaragua(System.Object):
            """This class has no documentation."""

            Currency: str = "USDNIO"
            """Nicaragua Currency"""

        class Nigeria(System.Object):
            """This class has no documentation."""

            StockMarket: str = "NGSEINDX"
            """Nigeria Stock Market"""

            CashReserveRatio: str = "NIGERIACASRESRAT"
            """Nigeria Cash Reserve Ratio"""

            GovernmentBond10y: str = "NIGERIAGOVBON10Y"
            """Nigeria Government Bond 10y"""

            InterbankRate: str = "NIGERIAINTRAT"
            """Nigeria Interbank Rate"""

            Currency: str = "USDNGN"
            """Nigeria Currency"""

        class NorthKorea(System.Object):
            """This class has no documentation."""

            Currency: str = "NORTHKORECUR"
            """NorthKorea Currency"""

        class Norway(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GNOR10YR"
            """Norway Government Bond 10Y"""

            InterbankRate: str = "NORWAYINTRAT"
            """Norway Interbank Rate"""

            StockMarket: str = "OSEAX"
            """Norway Stock Market"""

            Currency: str = "USDNOK"
            """Norway Currency"""

        class Oman(System.Object):
            """This class has no documentation."""

            StockMarket: str = "MSM30"
            """Oman Stock Market"""

            Currency: str = "USDOMR"
            """Oman Currency"""

        class Pakistan(System.Object):
            """This class has no documentation."""

            StockMarket: str = "KSE100"
            """Pakistan Stock Market"""

            InterestRate: str = "PAPRSBP"
            """Pakistan Interest Rate"""

            GovernmentBond10y: str = "PKIB10YR"
            """Pakistan Government Bond 10Y"""

            Currency: str = "USDPKR"
            """Pakistan Currency"""

        class Panama(System.Object):
            """This class has no documentation."""

            StockMarket: str = "BVPSBVPS"
            """Panama Stock Market"""

            Currency: str = "USDPAB"
            """Panama Currency"""

        class PapuaNewGuinea(System.Object):
            """This class has no documentation."""

            Currency: str = "USDPGK"
            """PapuaNewGuinea Currency"""

        class Paraguay(System.Object):
            """This class has no documentation."""

            Currency: str = "USDPYG"
            """Paraguay Currency"""

        class Peru(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GRPE10Y"
            """Peru Government Bond 10Y"""

            StockMarket: str = "IGBVL"
            """Peru Stock Market"""

            InterbankRate: str = "PERUINTRAT"
            """Peru Interbank Rate"""

            InterestRate: str = "PRRRONUS"
            """Peru Interest Rate"""

            Currency: str = "USDPEN"
            """Peru Currency"""

        class Philippines(System.Object):
            """This class has no documentation."""

            StockMarket: str = "PCOMP"
            """Philippines Stock Market"""

            GovernmentBond10y: str = "PHILIPPINEGOVBON10Y"
            """Philippines Government Bond 10y"""

            InterbankRate: str = "PHILIPPINEINTRAT"
            """Philippines Interbank Rate"""

            InterestRate: str = "PHILIPPINESINTRATE"
            """Philippines Interest Rate"""

            Currency: str = "USDPHP"
            """Philippines Currency"""

        class Poland(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "POGB10YR"
            """Poland Government Bond 10Y"""

            InterbankRate: str = "POLANDINTRAT"
            """Poland Interbank Rate"""

            DepositInterestRate: str = "POLFRINRDPST"
            """Poland Deposit Interest Rate"""

            Currency: str = "USDPLN"
            """Poland Currency"""

            StockMarket: str = "WIG"
            """Poland Stock Market"""

        class Portugal(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GSPT10YR"
            """Portugal Government Bond 10Y"""

            TwoYearNoteYield: str = "PORTUGAL2YNY"
            """Portugal 2 Year Note Yield"""

            StockMarket: str = "PSI20"
            """Portugal Stock Market"""

        class Qatar(System.Object):
            """This class has no documentation."""

            StockMarket: str = "DSM"
            """Qatar Stock Market"""

            GovernmentBond10y: str = "QATARGOVBON10Y"
            """Qatar Government Bond 10y"""

            ReverseRepoRate: str = "QATARREVREPRAT"
            """Qatar Reverse Repo Rate"""

            Currency: str = "USDQAR"
            """Qatar Currency"""

        class Romania(System.Object):
            """This class has no documentation."""

            StockMarket: str = "BET"
            """Romania Stock Market"""

            GovernmentBond10y: str = "ROMANIAGOVBON10Y"
            """Romania Government Bond 10Y"""

            InterbankRate: str = "ROMANIAINTRAT"
            """Romania Interbank Rate"""

            Currency: str = "USDRON"
            """Romania Currency"""

        class Russia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "INDEXCF"
            """Russia Stock Market"""

            GovernmentBond10y: str = "RUGE10Y"
            """Russia Government Bond 10Y"""

            CentralBankBalanceSheet: str = "RUSSIACENBANBALSHE"
            """Russia Central Bank Balance Sheet"""

            Currency: str = "USDRUB"
            """Russia Currency"""

        class Rwanda(System.Object):
            """This class has no documentation."""

            Currency: str = "USDRWF"
            """Rwanda Currency"""

        class SaoTomeAndPrincipe(System.Object):
            """This class has no documentation."""

            Currency: str = "USDSTD"
            """SaoTomeAndPrincipe Currency"""

        class SaudiArabia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "SASEIDX"
            """SaudiArabia Stock Market"""

            ReverseRepoRate: str = "SAUDIARABREVREPRAT"
            """SaudiArabia Reverse Repo Rate"""

            DepositInterestRate: str = "SAUFRINRDPST"
            """SaudiArabia Deposit Interest Rate"""

            Currency: str = "USDSAR"
            """SaudiArabia Currency"""

        class Serbia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "BELEX15"
            """Serbia Stock Market"""

            InterbankRate: str = "SERBIAINTRAT"
            """Serbia Interbank Rate"""

            InterestRate: str = "SERRBIAINTTRATE"
            """Serbia Interest Rate"""

            DepositInterestRate: str = "SRBFRINRDPST"
            """Serbia Deposit Interest Rate"""

            Currency: str = "USDSRB"
            """Serbia Currency"""

        class Seychelles(System.Object):
            """This class has no documentation."""

            Currency: str = "USDSCR"
            """Seychelles Currency"""

        class SierraLeone(System.Object):
            """This class has no documentation."""

            Currency: str = "USDSLL"
            """SierraLeone Currency"""

        class Singapore(System.Object):
            """This class has no documentation."""

            StockMarket: str = "FSSTI"
            """Singapore Stock Market"""

            GovernmentBond10y: str = "MASB10Y"
            """Singapore Government Bond 10Y"""

            InterbankRate: str = "SINGAPOREINTRAT"
            """Singapore Interbank Rate"""

            Currency: str = "USDSGD"
            """Singapore Currency"""

        class Slovakia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "SKSM"
            """Slovakia Stock Market"""

            GovernmentBond10y: str = "SLOVAKIAGOVBON10Y"
            """Slovakia Government Bond 10y"""

        class Slovenia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "SBITOP"
            """Slovenia Stock Market"""

            GovernmentBond10y: str = "SLOVENIAGOVBON10Y"
            """Slovenia Government Bond 10y"""

        class Somalia(System.Object):
            """This class has no documentation."""

            Currency: str = "USDSOS"
            """Somalia Currency"""

        class SouthAfrica(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GSAB10YR"
            """SouthAfrica Government Bond 10Y"""

            StockMarket: str = "JALSH"
            """SouthAfrica Stock Market"""

            InterbankRate: str = "SOUTHAFRIINTRAT"
            """SouthAfrica Interbank Rate"""

            Currency: str = "USDZAR"
            """SouthAfrica Currency"""

        class SouthKorea(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GVSK10YR"
            """SouthKorea Government Bond 10Y"""

            StockMarket: str = "KOSPI"
            """SouthKorea Stock Market"""

            InterbankRate: str = "SOUTHKOREINTRAT"
            """SouthKorea Interbank Rate"""

            Currency: str = "USDKRW"
            """SouthKorea Currency"""

        class Spain(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GSPG10YR"
            """Spain Government Bond 10Y"""

            StockMarket: str = "IBEX"
            """Spain Stock Market"""

            InterbankRate: str = "SPAININTRAT"
            """Spain Interbank Rate"""

        class SriLanka(System.Object):
            """This class has no documentation."""

            StockMarket: str = "CSEALL"
            """SriLanka Stock Market"""

            InterestRate: str = "SRI-LANKAINTRATE"
            """SriLanka Interest Rate"""

            CashReserveRatio: str = "SRILANKACASRESRAT"
            """SriLanka Cash Reserve Ratio"""

            InterbankRate: str = "SRILANKAINTRAT"
            """SriLanka Interbank Rate"""

            LendingRate: str = "SRILANKALENRAT"
            """SriLanka Lending Rate"""

            Currency: str = "USDLKR"
            """SriLanka Currency"""

        class Sudan(System.Object):
            """This class has no documentation."""

            Currency: str = "USDSDG"
            """Sudan Currency"""

        class Suriname(System.Object):
            """This class has no documentation."""

            Currency: str = "USDSRD"
            """Suriname Currency"""

        class Swaziland(System.Object):
            """This class has no documentation."""

            Currency: str = "USDSZL"
            """Swaziland Currency"""

        class Sweden(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GSGB10YR"
            """Sweden Government Bond 10Y"""

            StockMarket: str = "OMX"
            """Sweden Stock Market"""

            InterbankRate: str = "SWEDENINTRAT"
            """Sweden Interbank Rate"""

            Currency: str = "USDSEK"
            """Sweden Currency"""

        class Switzerland(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "GSWISS10"
            """Switzerland Government Bond 10Y"""

            StockMarket: str = "SMI"
            """Switzerland Stock Market"""

            InterbankRate: str = "SWITZERLANINTRAT"
            """Switzerland Interbank Rate"""

            Currency: str = "USDCHF"
            """Switzerland Currency"""

        class Syria(System.Object):
            """This class has no documentation."""

            Currency: str = "USDSYP"
            """Syria Currency"""

        class Taiwan(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "TAIWANGOVBON10Y"
            """Taiwan Government Bond 10y"""

            InterbankRate: str = "TAIWANINTRAT"
            """Taiwan Interbank Rate"""

            InterestRate: str = "TAIWANIR"
            """Taiwan Interest Rate"""

            StockMarket: str = "TWSE"
            """Taiwan Stock Market"""

            Currency: str = "USDTWD"
            """Taiwan Currency"""

        class Tajikistan(System.Object):
            """This class has no documentation."""

            Currency: str = "USDTJS"
            """Tajikistan Currency"""

        class Tanzania(System.Object):
            """This class has no documentation."""

            StockMarket: str = "DARSDSEI"
            """Tanzania Stock Market"""

            Currency: str = "USDTZS"
            """Tanzania Currency"""

        class Thailand(System.Object):
            """This class has no documentation."""

            InterestRate: str = "BTRR1DAY"
            """Thailand Interest Rate"""

            GovernmentBond10y: str = "GVTL10YR"
            """Thailand Government Bond 10Y"""

            StockMarket: str = "SET50"
            """Thailand Stock Market"""

            InterbankRate: str = "THAILANDINTRAT"
            """Thailand Interbank Rate"""

            Currency: str = "USDTHB"
            """Thailand Currency"""

        class TrinidadAndTobago(System.Object):
            """This class has no documentation."""

            Currency: str = "USDTTD"
            """TrinidadAndTobago Currency"""

        class Tunisia(System.Object):
            """This class has no documentation."""

            StockMarket: str = "TUSISE"
            """Tunisia Stock Market"""

            Currency: str = "USDTND"
            """Tunisia Currency"""

        class Turkey(System.Object):
            """This class has no documentation."""

            GovernmentBond10y: str = "TURKEYGOVBON10Y"
            """Turkey Government Bond 10y"""

            InterbankRate: str = "TURKEYINTRAT"
            """Turkey Interbank Rate"""

            Currency: str = "USDTRY"
            """Turkey Currency"""

            StockMarket: str = "XU100"
            """Turkey Stock Market"""

        class Turkmenistan(System.Object):
            """This class has no documentation."""

            Currency: str = "USDTMT"
            """Turkmenistan Currency"""

        class Uganda(System.Object):
            """This class has no documentation."""

            Currency: str = "USDUGX"
            """Uganda Currency"""

        class Ukraine(System.Object):
            """This class has no documentation."""

            StockMarket: str = "PFTS"
            """Ukraine Stock Market"""

            InterbankRate: str = "UKRAINEINTRAT"
            """Ukraine Interbank Rate"""

            Currency: str = "USDUAH"
            """Ukraine Currency"""

        class UnitedArabEmirates(System.Object):
            """This class has no documentation."""

            StockMarket: str = "ADSMI"
            """UnitedArabEmirates Stock Market"""

            InterbankRate: str = "UNITEDARAINTRAT"
            """UnitedArabEmirates Interbank Rate"""

            Currency: str = "USDAED"
            """UnitedArabEmirates Currency"""

        class UnitedKingdom(System.Object):
            """This class has no documentation."""

            Currency: str = "GBPUSD"
            """UnitedKingdom Currency"""

            GovernmentBond10y: str = "GUKG10"
            """UnitedKingdom Government Bond 10Y"""

            StockMarket: str = "UKX"
            """UnitedKingdom Stock Market"""

            TwoYearNoteYield: str = "UNITEDKIN2YNY"
            """UnitedKingdom 2 Year Note Yield"""

            InterbankRate: str = "UNITEDKININTRAT"
            """UnitedKingdom Interbank Rate"""

        class UnitedStates(System.Object):
            """This class has no documentation."""

            Currency: str = "DXY"
            """UnitedStates Currency"""

            InterestRate: str = "FDTR"
            """UnitedStates Interest Rate"""

            StockMarket: str = "INDU"
            """UnitedStates Stock Market"""

            TwoYearNoteYield: str = "UNITEDSTA2YEANOTYIE"
            """UnitedStates 2 Year Note Yield"""

            EconomicOptimismIndex: str = "UNITEDSTAECOOPTIND"
            """UnitedStates Economic Optimism Index"""

            ForeignDirectInvestment: str = "UNITEDSTAFORDIRINV"
            """UnitedStates Foreign Direct Investment"""

            InterbankRate: str = "UNITEDSTAINTRAT"
            """UnitedStates Interbank Rate"""

            NahbHousingMarketIndex: str = "UNITEDSTANAHHOUMARIN"
            """UnitedStates Nahb Housing Market Index"""

            NyEmpireStateManufacturingIndex: str = "UNITEDSTANYEMPSTAMAN"
            """UnitedStates NY Empire State Manufacturing Index"""

            RedbookIndex: str = "UNITEDSTAREDIND"
            """UnitedStates Redbook Index"""

            GovernmentBond10y: str = "USGG10YR"
            """UnitedStates Government Bond 10Y"""

            CrudeOilRigs: str = "USOILRIGS"
            """UnitedStates Crude Oil Rigs"""

        class Uruguay(System.Object):
            """This class has no documentation."""

            Currency: str = "USDURY"
            """Uruguay Currency"""

        class Uzbekistan(System.Object):
            """This class has no documentation."""

            Currency: str = "USDUZS"
            """Uzbekistan Currency"""

        class Venezuela(System.Object):
            """This class has no documentation."""

            StockMarket: str = "IBVC"
            """Venezuela Stock Market"""

            Currency: str = "USDVES"
            """Venezuela Currency"""

            GovernmentBond10y: str = "VENEZUELAGOVBON10Y"
            """Venezuela Government Bond 10y"""

            DepositInterestRate: str = "VENFRINRDPST"
            """Venezuela Deposit Interest Rate"""

        class Vietnam(System.Object):
            """This class has no documentation."""

            Currency: str = "USDVND"
            """Vietnam Currency"""

            GovernmentBond10y: str = "VIETNAMGOVBON10Y"
            """Vietnam Government Bond 10y"""

            InterbankRate: str = "VIETNAMINTRAT"
            """Vietnam Interbank Rate"""

            StockMarket: str = "VNINDEX"
            """Vietnam Stock Market"""

        class Yemen(System.Object):
            """This class has no documentation."""

            Currency: str = "USDYER"
            """Yemen Currency"""

        class Zambia(System.Object):
            """This class has no documentation."""

            Currency: str = "USDZMK"
            """Zambia Currency"""

            GovernmentBond10y: str = "ZAMBIAGOVBON10Y"
            """Zambia Government Bond 10y"""

            InterestRate: str = "ZAMMBIAINTTRATE"
            """Zambia Interest Rate"""

        class Zimbabwe(System.Object):
            """This class has no documentation."""

            StockMarket: str = "INDZI"
            """Zimbabwe Stock Market"""

    class Calendar(System.Object):
        """Calendar group"""

        class Australia(System.Object):
            """Australia"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BuildingPermits: str = ...
            """Building Permits"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            BusinessInventories: str = ...
            """Business Inventories"""

            Calendar: str = ...
            """Calendar"""

            CarRegistrations: str = ...
            """Car Registrations"""

            CompositePmi: str = ...
            """Composite Pmi"""

            ConstructionOutput: str = ...
            """Construction Output"""

            ConstructionPmi: str = ...
            """Construction Pmi"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            ConsumerPriceIndexCPI: str = ...
            """Consumer Price Index (CPI)"""

            ConsumerSpending: str = ...
            """Consumer Spending"""

            CoreInflationRate: str = ...
            """Core Inflation Rate"""

            CorporateProfits: str = ...
            """Corporate Profits"""

            CurrentAccount: str = ...
            """Current Account"""

            EmploymentChange: str = ...
            """Employment Change"""

            ExportPrices: str = ...
            """Export Prices"""

            Exports: str = ...
            """Exports"""

            FullTimeEmployment: str = ...
            """Full Time Employment"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPDeflator: str = ...
            """GDP Deflator"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GrossFixedCapitalFormation: str = ...
            """Gross Fixed Capital Formation"""

            Holidays: str = ...
            """Holidays"""

            HomeLoans: str = ...
            """Home Loans"""

            HousingIndex: str = ...
            """Housing Index"""

            ImportPrices: str = ...
            """Import Prices"""

            Imports: str = ...
            """Imports"""

            IndustrialSentiment: str = ...
            """Industrial Sentiment"""

            InflationExpectations: str = ...
            """Inflation Expectations"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            JobAdvertisements: str = ...
            """Job Advertisements"""

            LaborForceParticipationRate: str = ...
            """Labor Force Participation Rate"""

            LeadingEconomicIndex: str = ...
            """Leading Economic Index"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            NewHomeSales: str = ...
            """New Home Sales"""

            PartTimeEmployment: str = ...
            """Part Time Employment"""

            PrivateInvestment: str = ...
            """Private Investment"""

            PrivateSectorCredit: str = ...
            """Private Sector Credit"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ServicesPmi: str = ...
            """Services Pmi"""

            ServicesSentiment: str = ...
            """Services Sentiment"""

            TotalVehicleSales: str = ...
            """Total Vehicle Sales"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WageGrowth: str = ...
            """Wage Growth"""

        class Austria(System.Object):
            """Austria"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            HarmonisedConsumerPrices: str = ...
            """Harmonised Consumer Prices"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemployedPersons: str = ...
            """Unemployed Persons"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WholesalePrices: str = ...
            """Wholesale Prices"""

        class Belgium(System.Object):
            """Belgium"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Canada(System.Object):
            """Canada"""

            AdpEmploymentChange: str = ...
            """Adp Employment Change"""

            AverageHourlyEarnings: str = ...
            """Average Hourly Earnings"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BuildingPermits: str = ...
            """Building Permits"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            CapacityUtilization: str = ...
            """Capacity Utilization"""

            CarRegistrations: str = ...
            """Car Registrations"""

            CoreInflationRate: str = ...
            """Core Inflation Rate"""

            CurrentAccount: str = ...
            """Current Account"""

            EmploymentChange: str = ...
            """Employment Change"""

            Exports: str = ...
            """Exports"""

            ForeignStockInvestment: str = ...
            """Foreign Stock Investment"""

            FullTimeEmployment: str = ...
            """Full Time Employment"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPDeflator: str = ...
            """GDP Deflator"""

            GdpGrowthAnnualized: str = ...
            """Gdp Growth Annualized"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GovernmentBudgetValue: str = ...
            """Government Budget Value"""

            Holidays: str = ...
            """Holidays"""

            HousingIndex: str = ...
            """Housing Index"""

            HousingStarts: str = ...
            """Housing Starts"""

            Imports: str = ...
            """Imports"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            JobVacancies: str = ...
            """Job Vacancies"""

            LaborForceParticipationRate: str = ...
            """Labor Force Participation Rate"""

            LeadingEconomicIndex: str = ...
            """Leading Economic Index"""

            ManufacturingPMI: str = ...
            """Manufacturing PMI"""

            ManufacturingSales: str = ...
            """Manufacturing Sales"""

            PartTimeEmployment: str = ...
            """Part Time Employment"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            Productivity: str = ...
            """Productivity"""

            RetailSalesExAutos: str = ...
            """Retail Sales Ex Autos"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WageGrowth: str = ...
            """Wage Growth"""

            WholesalePrices: str = ...
            """Wholesale Prices"""

            WholesaleSales: str = ...
            """Wholesale Sales"""

        class China(System.Object):
            """China"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BanksBalanceSheet: str = ...
            """Banks Balance Sheet"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            CapacityUtilization: str = ...
            """Capacity Utilization"""

            CapitalFlows: str = ...
            """Capital Flows"""

            CompositePmi: str = ...
            """Composite Pmi"""

            CorporateProfits: str = ...
            """Corporate Profits"""

            CurrentAccount: str = ...
            """Current Account"""

            Exports: str = ...
            """Exports"""

            FixedAssetInvestment: str = ...
            """Fixed Asset Investment"""

            ForeignDirectInvestment: str = ...
            """Foreign Direct Investment"""

            ForeignExchangeReserves: str = ...
            """Foreign Exchange Reserves"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            Holidays: str = ...
            """Holidays"""

            HousingIndex: str = ...
            """Housing Index"""

            Imports: str = ...
            """Imports"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            LoanGrowth: str = ...
            """Loan Growth"""

            LoansToPrivateSector: str = ...
            """Loans to Private Sector"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            MniBusinessSentiment: str = ...
            """Mni Business Sentiment"""

            MniConsumerSentiment: str = ...
            """Mni Consumer Sentiment"""

            MoneySupplyMTwo: str = ...
            """Money Supply M2"""

            NonManufacturingPmi: str = ...
            """Non Manufacturing Pmi"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ServicesPmi: str = ...
            """Services Pmi"""

            TotalVehicleSales: str = ...
            """Total Vehicle Sales"""

        class Cyprus(System.Object):
            """Cyprus"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConstructionOutput: str = ...
            """Construction Output"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            HarmonisedConsumerPrices: str = ...
            """Harmonised Consumer Prices"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WageGrowth: str = ...
            """Wage Growth"""

        class Estonia(System.Object):
            """Estonia"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            Holidays: str = ...
            """Holidays"""

            Imports: str = ...
            """Imports"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Finland(System.Object):
            """Finland"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            ExportPrices: str = ...
            """Export Prices"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            Holidays: str = ...
            """Holidays"""

            ImportPrices: str = ...
            """Import Prices"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            LeadingEconomicIndex: str = ...
            """Leading Economic Index"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales Mom"""

            RetailSalesYoy: str = ...
            """Retail Sales Yoy"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class France(System.Object):
            """France"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            CompositePmi: str = ...
            """Composite Pmi"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            FiftyTwoWeekBillYield: str = ...
            """52 Week Bill Yield"""

            FiveYearNoteYield: str = ...
            """5 Year Note Yield"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GovernmentBondTenY: str = ...
            """Government Bond 10Y"""

            GovernmentBudgetValue: str = ...
            """Government Budget Value"""

            HarmonisedConsumerPrices: str = ...
            """Harmonised Consumer Prices"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InitialJoblessClaims: str = ...
            """Initial Jobless Claims"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            NonFarmPayrolls: str = ...
            """Non Farm Payrolls"""

            NonfarmPayrollsPrivate: str = ...
            """Nonfarm Payrolls Private"""

            PersonalSpending: str = ...
            """Personal Spending"""

            ProducerPrices: str = ...
            """Producer Prices"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ServicesPmi: str = ...
            """Services Pmi"""

            SixMonthBillYield: str = ...
            """6 Month Bill Yield"""

            ThreeMonthBillYield: str = ...
            """3 Month Bill Yield"""

            ThreeYearNoteYield: str = ...
            """3 Year Note Yield"""

            UnemployedPersons: str = ...
            """Unemployed Persons"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Germany(System.Object):
            """Germany"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            CompositePmi: str = ...
            """Composite Pmi"""

            ConstructionPmi: str = ...
            """Construction Pmi"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            EmployedPersons: str = ...
            """Employed Persons"""

            Exports: str = ...
            """Exports"""

            FactoryOrders: str = ...
            """Factory Orders"""

            FiftyTwoWeekBillYield: str = ...
            """52 Week Bill Yield"""

            FiveYearNoteYield: str = ...
            """5 Year Note Yield"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GovernmentBondTenY: str = ...
            """Government Bond 10Y"""

            GovernmentBudget: str = ...
            """Government Budget"""

            HarmonisedConsumerPrices: str = ...
            """Harmonised Consumer Prices"""

            Holidays: str = ...
            """Holidays"""

            ImportPrices: str = ...
            """Import Prices"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            JobVacancies: str = ...
            """Job Vacancies"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ServicesPmi: str = ...
            """Services Pmi"""

            ThirtyYearBondYield: str = ...
            """30 Year Bond Yield"""

            TwoYearNoteYield: str = ...
            """2 Year Note Yield"""

            UnemployedPersons: str = ...
            """Unemployed Persons"""

            UnemploymentChange: str = ...
            """Unemployment Change"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WholesalePrices: str = ...
            """Wholesale Prices"""

            ZewEconomicSentimentIndex: str = ...
            """Zew Economic Sentiment Index"""

        class Greece(System.Object):
            """Greece"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConstructionOutput: str = ...
            """Construction Output"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            HarmonisedConsumerPrices: str = ...
            """Harmonised Consumer Prices"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            LoanGrowth: str = ...
            """Loan Growth"""

            LoansToPrivateSector: str = ...
            """Loans to Private Sector"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            PrivateSectorCredit: str = ...
            """Private Sector Credit"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            SixMonthBillYield: str = ...
            """6 Month Bill Yield"""

            ThreeMonthBillYield: str = ...
            """3 Month Bill Yield"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Ireland(System.Object):
            """Ireland"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            Calendar: str = ...
            """Calendar"""

            ConstructionOutput: str = ...
            """Construction Output"""

            ConstructionPmi: str = ...
            """Construction Pmi"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CoreInflationRate: str = ...
            """Core Inflation Rate"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GrossNationalProduct: str = ...
            """Gross National Product"""

            HarmonisedConsumerPrices: str = ...
            """Harmonised Consumer Prices"""

            Holidays: str = ...
            """Holidays"""

            HousingIndex: str = ...
            """Housing Index"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            PersonalSavings: str = ...
            """Personal Savings"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ServicesPmi: str = ...
            """Services Pmi"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WageGrowth: str = ...
            """Wage Growth"""

        class Italy(System.Object):
            """Italy"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConstructionOutput: str = ...
            """Construction Output"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            FactoryOrders: str = ...
            """Factory Orders"""

            FiftyTwoWeekBillYield: str = ...
            """52 Week Bill Yield"""

            FiveYearNoteYield: str = ...
            """5 Year Note Yield"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GovernmentBondTenY: str = ...
            """Government Bond 10Y"""

            GovernmentBudget: str = ...
            """Government Budget"""

            HarmonisedConsumerPrices: str = ...
            """Harmonised Consumer Prices"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            ManufacturingSales: str = ...
            """Manufacturing Sales"""

            NewOrders: str = ...
            """New Orders"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ServicesPmi: str = ...
            """Services Pmi"""

            SevenYearNoteYield: str = ...
            """7 Year Note Yield"""

            SixMonthBillYield: str = ...
            """6 Month Bill Yield"""

            ThirtyYearBondYield: str = ...
            """30 Year Bond Yield"""

            ThreeYearNoteYield: str = ...
            """3 Year Note Yield"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WageGrowth: str = ...
            """Wage Growth"""

        class Japan(System.Object):
            """Japan"""

            AllIndustryActivityIndex: str = ...
            """All Industry Activity Index"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            CapacityUtilization: str = ...
            """Capacity Utilization"""

            CoincidentIndex: str = ...
            """Coincident Index"""

            CompositePmi: str = ...
            """Composite Pmi"""

            ConstructionOrders: str = ...
            """Construction Orders"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            ConsumerSpending: str = ...
            """Consumer Spending"""

            CoreInflationRate: str = ...
            """Core Inflation Rate"""

            CurrentAccount: str = ...
            """Current Account"""

            EconomyWatchersSurvey: str = ...
            """Economy Watchers Survey"""

            Exports: str = ...
            """Exports"""

            ForeignBondInvestment: str = ...
            """Foreign Bond Investment"""

            ForeignExchangeReserves: str = ...
            """Foreign Exchange Reserves"""

            ForeignStockInvestment: str = ...
            """Foreign Stock Investment"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPDeflator: str = ...
            """GDP Deflator"""

            GdpGrowthAnnualized: str = ...
            """Gdp Growth Annualized"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GovernmentBondTenY: str = ...
            """Government Bond 10Y"""

            GrossFixedCapitalFormation: str = ...
            """Gross Fixed Capital Formation"""

            Holidays: str = ...
            """Holidays"""

            HouseholdSpending: str = ...
            """Household Spending"""

            HousingStarts: str = ...
            """Housing Starts"""

            Imports: str = ...
            """Imports"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            JobsToApplicationsRatio: str = ...
            """Jobs To Applications Ratio"""

            LeadingCompositeIndex: str = ...
            """Leading Composite Index"""

            LeadingEconomicIndex: str = ...
            """Leading Economic Index"""

            LoanGrowth: str = ...
            """Loan Growth"""

            MachineryOrders: str = ...
            """Machinery Orders"""

            MachineToolOrders: str = ...
            """Machine Tool Orders"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            NonManufacturingPmi: str = ...
            """Non Manufacturing Pmi"""

            PrivateInvestment: str = ...
            """Private Investment"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ReutersTankanIndex: str = ...
            """Reuters Tankan Index"""

            ServicesPmi: str = ...
            """Services Pmi"""

            SmallBusinessSentiment: str = ...
            """Small Business Sentiment"""

            TertiaryIndustryIndex: str = ...
            """Tertiary Industry Index"""

            ThirtyYearBondYield: str = ...
            """30 Year Bond Yield"""

            TokyoCpi: str = ...
            """Tokyo Cpi"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WageGrowth: str = ...
            """Wage Growth"""

        class Latvia(System.Object):
            """Latvia"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            Calendar: str = ...
            """Calendar"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Lithuania(System.Object):
            """Lithuania"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Luxembourg(System.Object):
            """Luxembourg"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales Mom"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Malta(System.Object):
            """Malta"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Netherlands(System.Object):
            """Netherlands"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GovernmentBondTenY: str = ...
            """Government Bond 10Y"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            ManufacturingProduction: str = ...
            """Manufacturing Production"""

            PersonalSpending: str = ...
            """Personal Spending"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            SixMonthBillYield: str = ...
            """6 Month Bill Yield"""

            ThreeMonthBillYield: str = ...
            """3 Month Bill Yield"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class NewZealand(System.Object):
            """New Zealand"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BuildingPermits: str = ...
            """Building Permits"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            CapacityUtilization: str = ...
            """Capacity Utilization"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CreditCardSpending: str = ...
            """Credit Card Spending"""

            CurrentAccount: str = ...
            """Current Account"""

            EmploymentChange: str = ...
            """Employment Change"""

            ExportPrices: str = ...
            """Export Prices"""

            Exports: str = ...
            """Exports"""

            FoodInflation: str = ...
            """Food Inflation"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GlobalDairyTradePriceIndex: str = ...
            """Global Dairy Trade Price Index"""

            Holidays: str = ...
            """Holidays"""

            HousingIndex: str = ...
            """Housing Index"""

            ImportPrices: str = ...
            """Import Prices"""

            Imports: str = ...
            """Imports"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationExpectations: str = ...
            """Inflation Expectations"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            LaborForceParticipationRate: str = ...
            """Labor Force Participation Rate"""

            LabourCosts: str = ...
            """Labour Costs"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            ProducerPrices: str = ...
            """Producer Prices"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ServicesPmi: str = ...
            """Services Pmi"""

            TermsOfTrade: str = ...
            """Terms of Trade"""

            TouristArrivals: str = ...
            """Tourist Arrivals"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Portugal(System.Object):
            """Portugal"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            Exports: str = ...
            """Exports"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GovernmentBudgetValue: str = ...
            """Government Budget Value"""

            Holidays: str = ...
            """Holidays"""

            Imports: str = ...
            """Imports"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            LeadingEconomicIndex: str = ...
            """Leading Economic Index"""

            PersonalSpending: str = ...
            """Personal Spending"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Slovakia(System.Object):
            """Slovakia"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConstructionOutput: str = ...
            """Construction Output"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CoreConsumerPrices: str = ...
            """Core Consumer Prices"""

            CoreInflationRate: str = ...
            """Core Inflation Rate"""

            CurrentAccount: str = ...
            """Current Account"""

            Exports: str = ...
            """Exports"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            HarmonisedConsumerPrices: str = ...
            """Harmonised Consumer Prices"""

            Holidays: str = ...
            """Holidays"""

            Imports: str = ...
            """Imports"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WageGrowth: str = ...
            """Wage Growth"""

        class Slovenia(System.Object):
            """Slovenia"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            HarmonisedConsumerPrices: str = ...
            """Harmonised Consumer Prices"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            InterestRate: str = ...
            """Interest Rate"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            TouristArrivals: str = ...
            """Tourist Arrivals"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Spain(System.Object):
            """Spain"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            FactoryOrders: str = ...
            """Factory Orders"""

            FiftyTwoWeekBillYield: str = ...
            """52 Week Bill Yield"""

            FiveYearNoteYield: str = ...
            """5 Year Note Yield"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GovernmentBondTenY: str = ...
            """Government Bond 10Y"""

            HarmonisedConsumerPrices: str = ...
            """Harmonised Consumer Prices"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ServicesPmi: str = ...
            """Services Pmi"""

            SixMonthBillYield: str = ...
            """6 Month Bill Yield"""

            ThreeMonthBillYield: str = ...
            """3 Month Bill Yield"""

            ThreeYearNoteYield: str = ...
            """3 Year Note Yield"""

            TotalVehicleSales: str = ...
            """Total Vehicle Sales"""

            TouristArrivals: str = ...
            """Tourist Arrivals"""

            UnemploymentChange: str = ...
            """Unemployment Change"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Sweden(System.Object):
            """Sweden"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            BusinessInventories: str = ...
            """Business Inventories"""

            Calendar: str = ...
            """Calendar"""

            CapacityUtilization: str = ...
            """Capacity Utilization"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CoreConsumerPrices: str = ...
            """Core Consumer Prices"""

            CoreInflationRate: str = ...
            """Core Inflation Rate"""

            CurrentAccount: str = ...
            """Current Account"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            Holidays: str = ...
            """Holidays"""

            HouseholdSpending: str = ...
            """Household Spending"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationExpectations: str = ...
            """Inflation Expectations"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            LoanGrowth: str = ...
            """Loan Growth"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            NewOrders: str = ...
            """New Orders"""

            PrivateSectorCredit: str = ...
            """Private Sector Credit"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ServicesPmi: str = ...
            """Services Pmi"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

        class Switzerland(System.Object):
            """Switzerland"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            CurrentAccount: str = ...
            """Current Account"""

            FactoryOrders: str = ...
            """Factory Orders"""

            ForeignExchangeReserves: str = ...
            """Foreign Exchange Reserves"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            Holidays: str = ...
            """Holidays"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            NonFarmPayrolls: str = ...
            """Non Farm Payrolls"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            ZewEconomicSentimentIndex: str = ...
            """Zew Economic Sentiment Index"""

        class UnitedKingdom(System.Object):
            """United Kingdom"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            Calendar: str = ...
            """Calendar"""

            CarRegistrations: str = ...
            """Car Registrations"""

            CBIDistributiveTrades: str = ...
            """CBI Distributive Trades"""

            ClaimantCountChange: str = ...
            """Claimant Count Change"""

            CompositePmi: str = ...
            """Composite Pmi"""

            ConstructionOrders: str = ...
            """Construction Orders"""

            ConstructionOutput: str = ...
            """Construction Output"""

            ConstructionPmi: str = ...
            """Construction Pmi"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            ConsumerCredit: str = ...
            """Consumer Credit"""

            CoreConsumerPrices: str = ...
            """Core Consumer Prices"""

            CoreInflationRate: str = ...
            """Core Inflation Rate"""

            CoreProducerPrices: str = ...
            """Core Producer Prices"""

            CurrentAccount: str = ...
            """Current Account"""

            EconomicActivityIndex: str = ...
            """Economic Activity Index"""

            EmploymentChange: str = ...
            """Employment Change"""

            FactoryOrders: str = ...
            """Factory Orders"""

            FiveYearNoteYield: str = ...
            """5 Year Note Yield"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GoodsTradeBalance: str = ...
            """Goods Trade Balance"""

            GovernmentBondTenY: str = ...
            """Government Bond 10Y"""

            GovernmentDebt: str = ...
            """Government Debt"""

            Holidays: str = ...
            """Holidays"""

            HomeLoans: str = ...
            """Home Loans"""

            HousingIndex: str = ...
            """Housing Index"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationExpectations: str = ...
            """Inflation Expectations"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InterestRate: str = ...
            """Interest Rate"""

            LabourCosts: str = ...
            """Labour Costs"""

            LeadingEconomicIndex: str = ...
            """Leading Economic Index"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            ManufacturingProduction: str = ...
            """Manufacturing Production"""

            MortgageApplications: str = ...
            """Mortgage Applications"""

            MortgageApprovals: str = ...
            """Mortgage Approvals"""

            NationwideHousingPrices: str = ...
            """Nationwide Housing Prices"""

            PrivateInvestment: str = ...
            """Private Investment"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            Productivity: str = ...
            """Productivity"""

            RetailPriceIndex: str = ...
            """Retail Price Index"""

            RetailSalesExFuel: str = ...
            """Retail Sales Ex Fuel"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            ServicesPmi: str = ...
            """Services Pmi"""

            ThirtyYearBondYield: str = ...
            """30 Year Bond Yield"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WageGrowth: str = ...
            """Wage Growth"""

        class UnitedStates(System.Object):
            """United States"""

            AdpEmploymentChange: str = ...
            """Adp Employment Change"""

            APICrudeOilStockChange: str = ...
            """API Crude Oil Stock Change"""

            AverageHourlyEarnings: str = ...
            """Average Hourly Earnings"""

            AverageWeeklyHours: str = ...
            """Average Weekly Hours"""

            BalanceOfTrade: str = ...
            """Balance of Trade"""

            BuildingPermits: str = ...
            """Building Permits"""

            BusinessConfidence: str = ...
            """Business Confidence"""

            BusinessInventories: str = ...
            """Business Inventories"""

            Calendar: str = ...
            """Calendar"""

            CapacityUtilization: str = ...
            """Capacity Utilization"""

            CapitalFlows: str = ...
            """Capital Flows"""

            CaseShillerHomePriceIndex: str = ...
            """Case Shiller Home Price Index"""

            ChainStoreSales: str = ...
            """Chain Store Sales"""

            ChallengerJobCuts: str = ...
            """Challenger Job Cuts"""

            ChicagoFedNationalActivityIndex: str = ...
            """Chicago Fed National Activity Index"""

            ChicagoPmi: str = ...
            """Chicago Pmi"""

            CompositePmi: str = ...
            """Composite Pmi"""

            ConstructionSpending: str = ...
            """Construction Spending"""

            ConsumerConfidence: str = ...
            """Consumer Confidence"""

            ConsumerCredit: str = ...
            """Consumer Credit"""

            ConsumerPriceIndexCPI: str = ...
            """Consumer Price Index (CPI)"""

            ConsumerSpending: str = ...
            """Consumer Spending"""

            ContinuingJoblessClaims: str = ...
            """Continuing Jobless Claims"""

            CoreConsumerPrices: str = ...
            """Core Consumer Prices"""

            CoreInflationRate: str = ...
            """Core Inflation Rate"""

            CorePcePriceIndex: str = ...
            """Core Pce Price Index"""

            CoreProducerPrices: str = ...
            """Core Producer Prices"""

            CorporateProfits: str = ...
            """Corporate Profits"""

            CrudeOilImports: str = ...
            """Crude Oil Imports"""

            CrudeOilRigs: str = ...
            """Crude Oil Rigs"""

            CrudeOilStocksChange: str = ...
            """Crude Oil Stocks Change"""

            CurrentAccount: str = ...
            """Current Account"""

            CushingCrudeOilStocks: str = ...
            """Cushing Crude Oil Stocks"""

            DallasFedManufacturingIndex: str = ...
            """Dallas Fed Manufacturing Index"""

            DistillateFuelProduction: str = ...
            """Distillate Fuel Production"""

            DistillateStocks: str = ...
            """Distillate Stocks"""

            DurableGoodsOrders: str = ...
            """Durable Goods Orders"""

            DurableGoodsOrdersExDefense: str = ...
            """Durable Goods Orders Ex Defense"""

            DurableGoodsOrdersExTransportation: str = ...
            """Durable Goods Orders Ex Transportation"""

            EconomicOptimismIndex: str = ...
            """Economic Optimism Index"""

            EmploymentCostIndex: str = ...
            """Employment Cost Index"""

            ExistingHomeSales: str = ...
            """Existing Home Sales"""

            ExportPrices: str = ...
            """Export Prices"""

            Exports: str = ...
            """Exports"""

            FactoryOrders: str = ...
            """Factory Orders"""

            FactoryOrdersExTransportation: str = ...
            """Factory Orders Ex Transportation"""

            FiftyTwoWeekBillYield: str = ...
            """52 Week Bill Yield"""

            FiveYearNoteYield: str = ...
            """5 Year Note Yield"""

            ForeignBondInvestment: str = ...
            """Foreign Bond Investment"""

            FourWeekBillYield: str = ...
            """4 Week Bill Yield"""

            GasolineProduction: str = ...
            """Gasoline Production"""

            GasolineStocksChange: str = ...
            """Gasoline Stocks Change"""

            GDPAnnualGrowthRate: str = ...
            """GDP Annual Growth Rate"""

            GdpDeflator: str = ...
            """Gdp Deflator"""

            GDPGrowthRate: str = ...
            """GDP Growth Rate"""

            GoodsTradeBalance: str = ...
            """Goods Trade Balance"""

            GovernmentBondTenY: str = ...
            """Government Bond 10Y"""

            GovernmentBudgetValue: str = ...
            """Government Budget Value"""

            GovernmentPayrolls: str = ...
            """Government Payrolls"""

            Holidays: str = ...
            """Holidays"""

            HousingIndex: str = ...
            """Housing Index"""

            HousingStarts: str = ...
            """Housing Starts"""

            ImportPrices: str = ...
            """Import Prices"""

            Imports: str = ...
            """Imports"""

            IndustrialProduction: str = ...
            """Industrial Production"""

            IndustrialProductionMom: str = ...
            """Industrial Production Mom"""

            InflationExpectations: str = ...
            """Inflation Expectations"""

            InflationRate: str = ...
            """Inflation Rate"""

            InflationRateMom: str = ...
            """Inflation Rate Mom"""

            InitialJoblessClaims: str = ...
            """Initial Jobless Claims"""

            InterestRate: str = ...
            """Interest Rate"""

            IsmNewYorkIndex: str = ...
            """Ism New York Index"""

            JobOffers: str = ...
            """Job Offers"""

            KansasFedManufacturingIndex: str = ...
            """Kansas Fed Manufacturing Index"""

            LaborForceParticipationRate: str = ...
            """Labor Force Participation Rate"""

            LaborMarketConditionsIndex: str = ...
            """Labor Market Conditions Index"""

            LabourCosts: str = ...
            """Labour Costs"""

            LeadingEconomicIndex: str = ...
            """Leading Economic Index"""

            ManufacturingPayrolls: str = ...
            """Manufacturing Payrolls"""

            ManufacturingPmi: str = ...
            """Manufacturing Pmi"""

            ManufacturingProduction: str = ...
            """Manufacturing Production"""

            MortgageApplications: str = ...
            """Mortgage Applications"""

            MortgageRate: str = ...
            """Mortgage Rate"""

            NahbHousingMarketIndex: str = ...
            """Nahb Housing Market Index"""

            NaturalGasStocksChange: str = ...
            """Natural Gas Stocks Change"""

            NetLongTermTicFlows: str = ...
            """Net Long-term Tic Flows"""

            NewHomeSales: str = ...
            """New Home Sales"""

            NfibBusinessOptimismIndex: str = ...
            """Nfib Business Optimism Index"""

            NonFarmPayrolls: str = ...
            """Non Farm Payrolls"""

            NonfarmPayrollsPrivate: str = ...
            """Nonfarm Payrolls - Private"""

            NonManufacturingPmi: str = ...
            """Non Manufacturing Pmi"""

            NyEmpireStateManufacturingIndex: str = ...
            """Ny Empire State Manufacturing Index"""

            PcePriceIndex: str = ...
            """Pce Price Index"""

            PendingHomeSales: str = ...
            """Pending Home Sales"""

            PersonalIncome: str = ...
            """Personal Income"""

            PersonalSpending: str = ...
            """Personal Spending"""

            PhiladelphiaFedManufacturingIndex: str = ...
            """Philadelphia Fed Manufacturing Index"""

            ProducerPrices: str = ...
            """Producer Prices"""

            ProducerPricesChange: str = ...
            """Producer Prices Change"""

            Productivity: str = ...
            """Productivity"""

            RedbookIndex: str = ...
            """Redbook Index"""

            RefineryCrudeRuns: str = ...
            """Refinery Crude Runs"""

            RetailSalesExAutos: str = ...
            """Retail Sales Ex Autos"""

            RetailSalesMom: str = ...
            """Retail Sales MoM"""

            RetailSalesYoy: str = ...
            """Retail Sales YoY"""

            RichmondFedManufacturingIndex: str = ...
            """Richmond Fed Manufacturing Index"""

            ServicesPmi: str = ...
            """Services Pmi"""

            SevenYearNoteYield: str = ...
            """7 Year Note Yield"""

            SixMonthBillYield: str = ...
            """6 Month Bill Yield"""

            ThirtyYearBondYield: str = ...
            """30 Year Bond Yield"""

            ThreeMonthBillYield: str = ...
            """3 Month Bill Yield"""

            ThreeYearNoteYield: str = ...
            """3 Year Note Yield"""

            TotalVehicleSales: str = ...
            """Total Vehicle Sales"""

            TwoYearNoteYield: str = ...
            """2 Year Note Yield"""

            UnemploymentRate: str = ...
            """Unemployment Rate"""

            WholesaleInventories: str = ...
            """Wholesale Inventories"""

        Delimiter: str = "//"
        """Delimiter used to separate country from ticker in TradingEconomics.Calendar entries"""

    class Event(System.Object):
        """The Event class contains all events normalized for your convenience"""

        class Australia(System.Object):
            """Australia"""

            AigPerformanceConstructionIndex: str = "aig performance construction index"
            """AiG Performance Construction Index"""

            AigPerformanceManufacturingIndex: str = "aig performance manufacturing index"
            """AiG Performance of Mfg Index"""

            AigPerformanceServicesIndex: str = "aig performance services index"
            """AiG Performance of Services Index"""

            AnzacDay: str = "anzac day"
            """ANZAC Day"""

            AnzInternetJobAdvertisementsMoM: str = "anz internet job advertisements mom"
            """ANZ Internet Job Ads MoM"""

            AnzJobAdvertisements: str = "anz job advertisements"
            """ANZ Job Advertisements"""

            AnzJobAdvertisementsMoM: str = "anz job advertisements mom"
            """ANZ Job Advertisement MoM"""

            AnzNewspaperJobAdvertisementsMoM: str = "anz newspaper job advertisements mom"
            """ANZ Newspaper Job Ads MoM"""

            AustraliaDay: str = "australia day"
            """Australia Day"""

            AustraliaDayObserved: str = "australia day observed"
            """Australia Day (Observed)"""

            AustraliaDaySubstituteDay: str = "australia day substitute day"
            """Australia Day (substitute day)"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BuildingPermitsMoM: str = "building permits mom"
            """Building Permits (MoM)"""

            BuildingPermitsYoY: str = "building permits yoy"
            """Building Permits (YoY)"""

            BusinessInventoriesQoQ: str = "business inventories qoq"
            """Business Inventories QoQ"""

            CapitalExpenditureQoQ: str = "capital expenditure qoq"
            """Capital Expenditure QoQ"""

            CbLeadingEconomicIndex: str = "cb leading economic index"
            """CB Leading Index"""

            CbLeadingEconomicIndexMoM: str = "cb leading economic index mom"
            """CB Leading Index MoM"""

            CbLeadingEconomicIndicators: str = "cb leading economic indicators"
            """CB Leading Indicator"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            CommbankCompositePurchasingManagersIndexFinal: str = "commbank composite purchasing managers index final"
            """CommBank Composite PMI Final"""

            CommbankCompositePurchasingManagersIndexFlash: str = "commbank composite purchasing managers index flash"
            """CommBank Composite PMI Flash"""

            CommbankManufacturingPurchasingManagersIndexFinal: str = "commbank manufacturing purchasing managers index final"
            """CommBank Manufacturing PMI Final"""

            CommbankManufacturingPurchasingManagersIndexFlash: str = "commbank manufacturing purchasing managers index flash"
            """CommBank Manufacturing PMI Flash"""

            CommbankServicesPurchasingManagersIndexFinal: str = "commbank services purchasing managers index final"
            """CommBank Services PMI Final"""

            CommbankServicesPurchasingManagersIndexFlash: str = "commbank services purchasing managers index flash"
            """CommBank Services PMI Flash"""

            CompanyGrossOperatingProfitsQoQ: str = "company gross operating profits qoq"
            """Company Gross Operating Profits (QoQ)"""

            CompanyGrossProfitsQoQ: str = "company gross profits qoq"
            """Company Gross Profits QoQ"""

            ConstructionWorkDone: str = "construction work done"
            """Construction Work Done"""

            ConstructionWorkDoneQoQ: str = "construction work done qoq"
            """Construction Work Done QoQ"""

            ConsumerInflationExpectations: str = "consumer inflation expectations"
            """Consumer Inflation Expectation"""

            ConsumerPriceIndex: str = "consumer price index"
            """Consumer Price Index"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EasterSaturday: str = "easter saturday"
            """Easter Saturday"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            EmploymentChange: str = "employment change"
            """Employment Change"""

            EmploymentChangeSeasonallyAdjusted: str = "employment change seasonally adjusted"
            """Employment Change s.a."""

            ExportPricesQoQ: str = "export prices qoq"
            """Export Price Index QoQ"""

            ExportsMoM: str = "exports mom"
            """Exports MoM"""

            ExportsYoY: str = "exports yoy"
            """Exports YoY"""

            FamilyDay: str = "family day"
            """Family Day"""

            FederalElection: str = "federal election"
            """Federal Election"""

            FullTimeEmploymentChange: str = "full time employment change"
            """Fulltime Employment"""

            GdpAnnualGrowthRateYoY: str = "gdp annual growth rate yoy"
            """GDP Annual Growth Rate YoY"""

            GdpCapitalExpenditure: str = "gdp capital expenditure"
            """GDP Capital Expenditure"""

            GdpCapitalExpenditureQoQ: str = "gdp capital expenditure qoq"
            """GDP Capital Expenditure QoQ"""

            GdpDeflator: str = "gdp deflator"
            """GDP Deflator"""

            GdpDeflatorQoQ: str = "gdp deflator qoq"
            """GDP Deflator QoQ"""

            GdpFinalConsumption: str = "gdp final consumption"
            """GDP Final Consumption"""

            GdpFinalConsumptionQoQ: str = "gdp final consumption qoq"
            """GDP Final Consumption QoQ"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            GTwentyMeeting: str = "g20 meeting"
            """G20 Meeting"""

            HiaNewHomeSalesMoM: str = "hia new home sales mom"
            """HIA New Home Sales (MoM)"""

            HomeLoansMoM: str = "home loans mom"
            """Home Loans MoM"""

            HousePriceIndexQoQ: str = "house price index qoq"
            """House Price Index QoQ"""

            HousePriceIndexYoY: str = "house price index yoy"
            """House Price Index YoY"""

            ImportPricesQoQ: str = "import prices qoq"
            """Import Price Index QoQ"""

            ImportsMoM: str = "imports mom"
            """Imports MoM"""

            ImportsYoY: str = "imports yoy"
            """Imports YoY"""

            InflationRateQoQ: str = "inflation rate qoq"
            """Inflation Rate QoQ"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InvestmentLendingForHomes: str = "investment lending for homes"
            """Investment Lending for Homes"""

            LaborDay: str = "labor day"
            """Labour Day"""

            MidYearEconomicAndFiscalOutlook: str = "mid year economic and fiscal outlook"
            """Mid-Year Economic and Fiscal Outlook"""

            NabBusinessConfidence: str = "nab business confidence"
            """NAB Business Confidence"""

            NabBusinessSurvey: str = "nab business survey"
            """NAB Business Survey"""

            NewMotorVehicleSalesMoM: str = "new motor vehicle sales mom"
            """New Motor Vehicle Sales (MoM)"""

            NewMotorVehicleSalesYoY: str = "new motor vehicle sales yoy"
            """New Motor Vehicle Sales (YoY)"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NewYearsDaySubstituteDay: str = "new years day substitute day"
            """New Year's Day (Substitute Day)"""

            ParticipationRate: str = "participation rate"
            """Participation Rate"""

            PartTimeEmploymentChange: str = "part time employment change"
            """Part Time Employment Chg"""

            PrivateCapitalExpenditureQoQ: str = "private capital expenditure qoq"
            """Private Capital Expenditure QoQ"""

            PrivateNewCapitalExpenditureQoQ: str = "private new capital expenditure qoq"
            """Private New Capital Expenditure QoQ"""

            PrivateSectorCreditMoM: str = "private sector credit mom"
            """Private Sector Credit (MoM)"""

            PrivateSectorCreditYoY: str = "private sector credit yoy"
            """Private Sector Credit (YoY)"""

            ProducerPriceIndexQoQ: str = "producer price index qoq"
            """Producer Price Index QoQ"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            QueensBirthday: str = "queens birthday"
            """Queen's Birthday"""

            QueensBirthdayDay: str = "queens birthday day"
            """Queen's Birthday Day"""

            RbaAssistGovEdeySpeech: str = "rba assist gov edey speech"
            """RBA Assist Gov Edey Speech"""

            RbaAssistGovKentSpeech: str = "rba assist gov kent speech"
            """RBA Assist Gov Kent Speech"""

            RbaAylmerSpeech: str = "rba aylmer speech"
            """RBA Aylmer Speech"""

            RbaBoultonSpeech: str = "rba boulton speech"
            """RBA Boulton Speech"""

            RbaBulletin: str = "rba bulletin"
            """RBA Bulletin"""

            RbaBullockSpeech: str = "rba bullock speech"
            """RBA Bullock Speech"""

            RbaChartPack: str = "rba chart pack"
            """RBA Chart Pack"""

            RbaCommodityIndexSdrYoY: str = "rba commodity index sdr yoy"
            """RBA Commodity Index SDR (YoY)"""

            RbaCoombsSpeech: str = "rba coombs speech"
            """RBA Coombs Speech"""

            RbaDebelleSpeech: str = "rba debelle speech"
            """RBA Debelle Speech"""

            RbaDeputyGovLoweSpeech: str = "rba deputy gov lowe speech"
            """RBA Deputy Gov Lowe Speech"""

            RbaEdeySpeech: str = "rba edey speech"
            """RBA Edey Speech"""

            RbaEllisSpeech: str = "rba ellis speech"
            """RBA Ellis Speech"""

            RbaFinancialStabilityReview: str = "rba financial stability review"
            """RBA Financial Stability Review"""

            RbaGirnSpeech: str = "rba girn speech"
            """RBA Girn Speech"""

            RbaGovDebelleSpeech: str = "rba gov debelle speech"
            """RBA Gov Debelle Speech"""

            RbaGovernorStevensSpeaks: str = "rba governor stevens speaks"
            """RBA Governor Stevens Speaks"""

            RbaGovGlennSpeech: str = "rba gov glenn speech"
            """RBA Gov Glenn Speech"""

            RbaGovGlennStevensSpeech: str = "rba gov glenn stevens speech"
            """RBA Gov. Glenn Stevens Speech"""

            RbaGovKentSpeech: str = "rba gov kent speech"
            """RBA Gov Kent Speech"""

            RbaGovLoweSpeech: str = "rba gov lowe speech"
            """RBA Gov Lowe Speech"""

            RbaHeathSpeech: str = "rba heath speech"
            """RBA Heath Speech"""

            RbaInterestRateDecision: str = "rba interest rate decision"
            """RBA Interest Rate Decision"""

            RbaKentSpeech: str = "rba kent speech"
            """RBA Kent Speech"""

            RbaKohlerSpeech: str = "rba kohler speech"
            """RBA Kohler Speech"""

            RbaLoweSpeaksBeforeParliament: str = "rba lowe speaks before parliament"
            """RBA Lowe Speaks before Parliament"""

            RbaLoweSpeech: str = "rba lowe speech"
            """RBA Lowe Speech"""

            RbaMeetingMinutes: str = "rba meeting minutes"
            """RBA Meeting Minutes"""

            RbaMeetingsMinutes: str = "rba meetings minutes"
            """RBA Meetings Minutes"""

            RbaMonetaryPolicyStatement: str = "rba monetary policy statement"
            """RBA Monetary Policy Statement"""

            RbaRateStatement: str = "rba rate statement"
            """RBA Rate Statement"""

            RbaRichardsSpeech: str = "rba richards speech"
            """RBA Richards Speech"""

            RbaRyanSpeech: str = "rba ryan speech"
            """RBA Ryan Speech"""

            RbasGovernorGlennStevensSpeech: str = "rbas governor glenn stevens speech"
            """RBA's Governor Glenn Stevens Speech"""

            RbasGovStevensSpeech: str = "rbas gov stevens speech"
            """RBA's Gov Stevens Speech"""

            RbaSimonSpeech: str = "rba simon speech"
            """RBA Simon Speech"""

            RbaStatementOnMonetaryPolicy: str = "rba statement on monetary policy"
            """RBA Statement on Monetary Policy"""

            RbaTrimmedMeanConsumerPriceIndexQoQ: str = "rba trimmed mean consumer price index qoq"
            """RBA trimmed mean CPI QoQ"""

            RbaTrimmedMeanConsumerPriceIndexYoY: str = "rba trimmed mean consumer price index yoy"
            """RBA trimmed mean CPI YoY"""

            RbaWeightedMeanConsumerPriceIndexQoQ: str = "rba weighted mean consumer price index qoq"
            """RBA Weighted Mean CPI QoQ"""

            RbaWeightedMeanConsumerPriceIndexYoY: str = "rba weighted mean consumer price index yoy"
            """RBA Weighted Mean CPI YoY"""

            ReconciliationDay: str = "reconciliation day"
            """Reconciliation Day"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            StatementOnMonetaryPolicy: str = "statement on monetary policy"
            """Statement on Monetary Policy"""

            TdMelbourneInstituteInflationGaugeMoM: str = "td melbourne institute inflation gauge mom"
            """TD-MI Inflation Gauge MoM"""

            TdSecuritiesInflationMoM: str = "td securities inflation mom"
            """TD Securities Inflation MoM"""

            TdSecuritiesInflationYoY: str = "td securities inflation yoy"
            """TD Securities Inflation (YoY)"""

            TwoThousandSeventeenEighteenBudgetRelease: str = "2017 18 budget release"
            """2017-18 Budget Release"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            WagePriceIndexQoQ: str = "wage price index qoq"
            """Wage Price Index QoQ"""

            WagePriceIndexYoY: str = "wage price index yoy"
            """Wage Price Index YoY"""

            WestpacConsumerConfidence: str = "westpac consumer confidence"
            """Westpac Consumer Confidence"""

            WestpacConsumerConfidenceChange: str = "westpac consumer confidence change"
            """Westpac Cons. Conf. Change"""

            WestpacConsumerConfidenceMoM: str = "westpac consumer confidence mom"
            """Westpac Consumer Confidence MoM"""

            WestpacLeadingIndex: str = "westpac leading index"
            """Westpac Leading Index"""

            WestpacLeadingIndexMoM: str = "westpac leading index mom"
            """Westpac Leading Index MoM"""

        class Austria(System.Object):
            """Austria"""

            AllSaintsDay: str = "all saints day"
            """All Saint's Day"""

            AscensionDay: str = "ascension day"
            """Ascension Day"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BankOfAustriaManufacturingPurchasingManagersIndex: str = "bank of austria manufacturing purchasing managers index"
            """Bank Austria Manufacturing PMI"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ChristmasEve: str = "christmas eve"
            """Christmas Eve"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CorpusChristi: str = "corpus christi"
            """Corpus Christi"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            Epiphany: str = "epiphany"
            """Epiphany"""

            FinanceMinisterSchellingSpeech: str = "finance minister schelling speech"
            """Finance Minister Schelling Speech"""

            GdpAnnualGrowthRateYoY: str = "gdp annual growth rate yoy"
            """GDP Annual Growth Rate YoY"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQFlash: str = "gdp growth rate qoq flash"
            """GDP Growth Rate QoQ Flash"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYFlash: str = "gdp growth rate yoy flash"
            """GDP Growth Rate YoY Flash"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            HarmonizedInflationRateMoM: str = "harmonized inflation rate mom"
            """Harmonised Inflation Rate MoM"""

            HarmonizedInflationRateYoY: str = "harmonized inflation rate yoy"
            """Harmonised Inflation Rate YoY"""

            ImfLagardeSpeech: str = "imf lagarde speech"
            """IMF Lagarde Speech"""

            ImmaculateConception: str = "immaculate conception"
            """Immaculate Conception"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            LaborDay: str = "labor day"
            """Labour Day"""

            NationalDay: str = "national day"
            """National Day"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            OenbGovNowotnySpeech: str = "oenb gov nowotny speech"
            """OeNB Gov Nowotny Speech"""

            OpecMeeting: str = "opec meeting"
            """OPEC Meeting"""

            PresidentialElection: str = "presidential election"
            """Presidential Election"""

            PresidentialElections: str = "presidential elections"
            """Presidential Elections"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            PurchasingManagersIndexManufacturing: str = "purchasing managers index manufacturing"
            """PMI Manufacturing"""

            RegionalElections: str = "regional elections"
            """Regional Elections"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            StStephensDay: str = "st stephens day"
            """St Stephen's Day"""

            UnemployedPersons: str = "unemployed persons"
            """Unemployed Persons"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            WhitMonday: str = "whit monday"
            """Whit Monday"""

            WholesalePricesMoM: str = "wholesale prices mom"
            """Wholesale Prices MoM"""

            WholesalePricesNotSeasonallyAdjustedMoM: str = "wholesale prices not seasonally adjusted mom"
            """Wholesale Prices n.s.a (MoM)"""

            WholesalePricesNotSeasonallyAdjustedYoY: str = "wholesale prices not seasonally adjusted yoy"
            """Wholesale Prices n.s.a (YoY)"""

            WholesalePricesYoY: str = "wholesale prices yoy"
            """Wholesale Prices YoY"""

        class Belgium(System.Object):
            """Belgium"""

            AllSaintsDay: str = "all saints day"
            """All Saints' Day"""

            ArmisticeDay: str = "armistice day"
            """Armistice Day"""

            AscensionDay: str = "ascension day"
            """Ascension Day"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EuChinaSummit: str = "eu china summit"
            """EU-China Summit"""

            GdpAnnualGrowthRateYoY: str = "gdp annual growth rate yoy"
            """GDP Annual Growth Rate YoY"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQAdv: str = "gdp growth rate qoq adv"
            """GDP Growth Rate QoQ Adv"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQSecondEstimate: str = "gdp growth rate qoq second estimate"
            """GDP Growth Rate QoQ 2nd Est"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYAdv: str = "gdp growth rate yoy adv"
            """GDP Growth Rate YoY Adv"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY 2nd Est"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            LaborDay: str = "labor day"
            """Labour Day"""

            LocalElections: str = "local elections"
            """Local Elections"""

            NationalDay: str = "national day"
            """National Day"""

            NatoSummit: str = "nato summit"
            """NATO Summit"""

            NbbBusinessClimate: str = "nbb business climate"
            """NBB Business Climate"""

            NbbBusinessConfidence: str = "nbb business confidence"
            """NBB Business Confidence"""

            NewYearsDay: str = "new years day"
            """New Year’s Day"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            WhitMonday: str = "whit monday"
            """Whit Monday"""

        class Canada(System.Object):
            """Canada"""

            AdpEmploymentChange: str = "adp employment change"
            """ADP Employment Change"""

            AlbertaGeneralElection: str = "alberta general election"
            """Alberta General Election"""

            AverageHourlyWagesYoY: str = "average hourly wages yoy"
            """Average Hourly Wages YoY"""

            AverageWeeklyEarningsYoY: str = "average weekly earnings yoy"
            """Average Weekly Earnings YoY"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BankOfCanadaBeaudrySpeech: str = "bank of canada beaudry speech"
            """BoC Beaudry Speech"""

            BankOfCanadaBusinessOutlookSurvey: str = "bank of canada business outlook survey"
            """Bank of Canada Business Outlook Survey"""

            BankOfCanadaConsumerPriceIndexCoreMoM: str = "bank of canada consumer price index core mom"
            """Bank of Canada Consumer Price Index Core MoM"""

            BankOfCanadaConsumerPriceIndexCoreYoY: str = "bank of canada consumer price index core yoy"
            """Bank of Canada Consumer Price Index Core YoY"""

            BankOfCanadaCoreInflationMoM: str = "bank of canada core inflation mom"
            """Bank of Canada Core Inflation MoM"""

            BankOfCanadaCoreInflationYoY: str = "bank of canada core inflation yoy"
            """Bank of Canada Core Inflation YoY"""

            BankOfCanadaDeputyGovPattersonSpeech: str = "bank of canada deputy gov patterson speech"
            """BoC Deputy Gov Patterson Speech"""

            BankOfCanadaDeputyGovSchembriSpeech: str = "bank of canada deputy gov schembri speech"
            """BoC Deputy Gov Schembri Speech"""

            BankOfCanadaDeputyGovWilkinsSpeech: str = "bank of canada deputy gov wilkins speech"
            """BoC Deputy Gov Wilkins Speech"""

            BankOfCanadaFinancialSystemReview: str = "bank of canada financial system review"
            """BoC Financial System Review"""

            BankOfCanadaGovCarneySpeaks: str = "bank of canada gov carney speaks"
            """BoC Gov Carney Speaks"""

            BankOfCanadaGovPolozPressConference: str = "bank of canada gov poloz press conference"
            """BoC Gov Poloz Press Conference"""

            BankOfCanadaGovPolozSpeaks: str = "bank of canada gov poloz speaks"
            """BoC Gov Poloz Speaks"""

            BankOfCanadaGovPolozSpeech: str = "bank of canada gov poloz speech"
            """BoC Gov Poloz Speech"""

            BankOfCanadaGravelleSpeech: str = "bank of canada gravelle speech"
            """BoC Gravelle Speech"""

            BankOfCanadaInterestRateDecision: str = "bank of canada interest rate decision"
            """BoC Interest Rate Decision"""

            BankOfCanadaLaneSpeech: str = "bank of canada lane speech"
            """BoC Lane Speech"""

            BankOfCanadaLeducSpeech: str = "bank of canada leduc speech"
            """BoC Leduc Speech"""

            BankOfCanadaMonetaryPolicyReport: str = "bank of canada monetary policy report"
            """BoC Monetary Policy Report"""

            BankOfCanadaPattersonSpeech: str = "bank of canada patterson speech"
            """BoC Patterson Speech"""

            BankOfCanadaPressConference: str = "bank of canada press conference"
            """BoC Press Conference"""

            BankOfCanadaRateStatement: str = "bank of canada rate statement"
            """BoC Rate Statement"""

            BankOfCanadaReview: str = "bank of canada review"
            """BoC Review"""

            BankOfCanadaSchembriSpeech: str = "bank of canada schembri speech"
            """BoC Schembri Speech"""

            BankOfCanadaWilkinsSpeech: str = "bank of canada wilkins speech"
            """BoC Wilkins Speech"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BudgetBalance: str = "budget balance"
            """Budget Balance"""

            BuildingPermitsMoM: str = "building permits mom"
            """Building Permits (MoM)"""

            CanadaDay: str = "canada day"
            """Canada Day"""

            CanadaDaySubstituteDay: str = "canada day substitute day"
            """Canada Day (Substitute Day)"""

            CanadianInvestmentInForeignSecurities: str = "canadian investment in foreign securities"
            """Canadian portfolio investment in foreign securities"""

            CapacityUtilization: str = "capacity utilization"
            """Capacity Utilization"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            CivicHoliday: str = "civic holiday"
            """Civic Holiday"""

            ConsumerPriceIndexCoreMoM: str = "consumer price index core mom"
            """Consumer Price Index - Core MoM"""

            CoreConsumerPriceIndexYoY: str = "core consumer price index yoy"
            """Core CPI YoY"""

            CoreInflationRateMoM: str = "core inflation rate mom"
            """Core Inflation Rate MoM"""

            CoreInflationRateYoY: str = "core inflation rate yoy"
            """Core Inflation Rate YoY"""

            CoreRetailSalesMoM: str = "core retail sales mom"
            """Core Retail Sales MoM"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EmploymentChange: str = "employment change"
            """Employment Change"""

            Exports: str = "exports"
            """Exports"""

            FamilyDay: str = "family day"
            """Family Day"""

            FederalElection: str = "federal election"
            """Federal Election"""

            FinanceMinisterMorneauSpeech: str = "finance minister morneau speech"
            """Finance Minister Morneau Speech"""

            ForeignInvestmentInCanadianSecurities: str = "foreign investment in canadian securities"
            """Foreign portfolio investment in Canadian securities"""

            ForeignSecuritiesPurchases: str = "foreign securities purchases"
            """Foreign Securities Purchases"""

            ForeignSecuritiesPurchasesByCanadians: str = "foreign securities purchases by canadians"
            """Foreign Securities Purchases by Canadians"""

            FullEmploymentChange: str = "full employment change"
            """Full Employment Change"""

            FullTimeEmploymentChange: str = "full time employment change"
            """Full Time Employment Chg"""

            GdpGrowthRateAnnualized: str = "gdp growth rate annualized"
            """GDP Growth Rate Annualized"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpImplicitPriceQoQ: str = "gdp implicit price qoq"
            """GDP Implicit Price QoQ"""

            GdpMoM: str = "gdp mom"
            """GDP MoM"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            GrossDomesticProductMoM: str = "gross domestic product mom"
            """Gross Domestic Product (MoM)"""

            GSevenSummit: str = "g7 summit"
            """G7 Summit"""

            HousingStarts: str = "housing starts"
            """Housing Starts"""

            HousingStartsSeasonallyAdjustedYoY: str = "housing starts seasonally adjusted yoy"
            """Housing Starts s.a YoY"""

            HousingStartsYoY: str = "housing starts yoy"
            """Housing Starts YoY"""

            Imports: str = "imports"
            """Imports"""

            IndustrialProductPriceMoM: str = "industrial product price mom"
            """Industrial Product Price MoM"""

            IndustrialProductPriceYoY: str = "industrial product price yoy"
            """Industrial Product Price YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InvestmentInForeignSecurities: str = "investment in foreign securities"
            """Portfolio investment in foreign securities"""

            IveyPurchasingManagersIndexSeasonallyAdjusted: str = "ivey purchasing managers index seasonally adjusted"
            """Ivey PMI s.a"""

            JobVacancies: str = "job vacancies"
            """Job Vacancies"""

            LaborDay: str = "labor day"
            """Labour Day"""

            LaborProductivityQoQ: str = "labor productivity qoq"
            """Labor Productivity QoQ"""

            ManufacturingSalesMoM: str = "manufacturing sales mom"
            """Manufacturing Sales MoM"""

            ManufacturingSalesYoY: str = "manufacturing sales yoy"
            """Manufacturing Sales YoY"""

            ManufacturingShipmentsMoM: str = "manufacturing shipments mom"
            """Manufacturing Shipments MoM"""

            ManufacturingShipmentsYoY: str = "manufacturing shipments yoy"
            """Manufacturing Shipments YoY"""

            MarkitManufacturingPurchasingManagersIndex: str = "markit manufacturing purchasing managers index"
            """Markit Manufacturing PMI"""

            NetChangeInEmployment: str = "net change in employment"
            """Net Change in Employment"""

            NewBrunswickProvincialElections: str = "new brunswick provincial elections"
            """New Brunswick Provincial Elections"""

            NewHousingPriceIndexMoM: str = "new housing price index mom"
            """New Housing Price Index (MoM)"""

            NewHousingPriceIndexYoY: str = "new housing price index yoy"
            """New Housing Price Index (YoY)"""

            NewMotorVehicleSales: str = "new motor vehicle sales"
            """New Motor Vehicle Sales"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NewYearsDaySubstituteDay: str = "new years day substitute day"
            """New Year's Day (Substitute Day)"""

            OntarioProvincialElections: str = "ontario provincial elections"
            """Ontario Provincial Elections"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            ParticipationRate: str = "participation rate"
            """Participation rate"""

            PartTimeEmploymentChange: str = "part time employment change"
            """Part Time Employment Chg"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            QuebecProvincialElections: str = "quebec provincial elections"
            """Quebec Provincial Elections"""

            RawMaterialsPriceIndexMoM: str = "raw materials price index mom"
            """Raw Materials Price Index MoM"""

            RawMaterialsPriceIndexYoY: str = "raw materials price index yoy"
            """Raw Materials Price Index YoY"""

            RbcManufacturingPurchasingManagersIndex: str = "rbc manufacturing purchasing managers index"
            """RBC Manufacturing PMI"""

            RemembranceDay: str = "remembrance day"
            """Remembrance Day"""

            RetailSalesExcludingAutosMoM: str = "retail sales excluding autos mom"
            """Retail Sales Ex Autos MoM"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            StockInvestmentByForeigners: str = "stock investment by foreigners"
            """Stock Investment by Foreigners"""

            ThanksgivingDay: str = "thanksgiving day"
            """Thanksgiving Day"""

            TwoThousandSixteenBudgetAnnouncement: str = "2016 budget announcement"
            """2016 Budget Announcement"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            VictoriaDay: str = "victoria day"
            """Victoria Day"""

            WholesaleSalesMoM: str = "wholesale sales mom"
            """Wholesale Sales MoM"""

            WholesaleSalesYoY: str = "wholesale sales yoy"
            """Wholesale Sales YoY"""

        class China(System.Object):
            """China"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BeltAndRoadForum: str = "belt and road forum"
            """Belt and Road Forum"""

            CaixinCompositePurchasingManagersIndex: str = "caixin composite purchasing managers index"
            """Caixin Composite PMI"""

            CaixinManufacturingPurchasingManagersIndex: str = "caixin manufacturing purchasing managers index"
            """Caixin Manufacturing PMI"""

            CaixinManufacturingPurchasingManagersIndexFinal: str = "caixin manufacturing purchasing managers index final"
            """Caixin Manufacturing PMI Final"""

            CaixinManufacturingPurchasingManagersIndexFlash: str = "caixin manufacturing purchasing managers index flash"
            """Caixin Manufacturing PMI Flash"""

            CaixinServicesPurchasingManagersIndex: str = "caixin services purchasing managers index"
            """Caixin Services PMI"""

            CapitalFlows: str = "capital flows"
            """Capital Flows"""

            CbLeadingEconomicIndex: str = "cb leading economic index"
            """CB Leading Economic Index"""

            CentralEconomicWorkConference: str = "central economic work conference"
            """Central Economic Work Conference"""

            ChineseNewYear: str = "chinese new year"
            """Chinese New Year"""

            ChinesePeoplesPoliticalConsultativeConference: str = "chinese peoples political consultative conference"
            """Chinese People’s Political Consultative Conference"""

            CurrentAccount: str = "current account"
            """Current Account"""

            DragonBoatFestival: str = "dragon boat festival"
            """Dragon Boat Festival"""

            EuChinaSummit: str = "eu china summit"
            """EU-China Summit"""

            Exports: str = "exports"
            """Exports"""

            ExportsYoY: str = "exports yoy"
            """Exports YoY"""

            FirstDayNationalPeoplesCongress: str = "first day national peoples congress"
            """1st Day National People's Congress"""

            FixedAssetInvestmentYtdYoY: str = "fixed asset investment ytd yoy"
            """Fixed Asset Investment (YTD) YoY"""

            ForeignDirectInvestmentYtdYoY: str = "foreign direct investment ytd yoy"
            """FDI (YTD) YoY"""

            ForeignExchangeReserves: str = "foreign exchange reserves"
            """Foreign Exchange Reserves"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GTwentyFinMinistersAndCbGovernorsMeeting: str = "g20 fin ministers and cb governors meeting"
            """G20 Fin Ministers and CB Governors Meeting"""

            GTwentyMeeting: str = "g20 meeting"
            """G20 Meeting"""

            HousePriceIndexMoM: str = "house price index mom"
            """House Price Index MoM"""

            HousePriceIndexYoY: str = "house price index yoy"
            """House Price Index YoY"""

            HsbcChinaServicesPurchasingManagersIndex: str = "hsbc china services purchasing managers index"
            """HSBC China Services PMI"""

            HsbcManufacturingPurchasingManagersIndex: str = "hsbc manufacturing purchasing managers index"
            """HSBC Manufacturing PMI"""

            HsbcManufacturingPurchasingManagersIndexFinal: str = "hsbc manufacturing purchasing managers index final"
            """HSBC Manufacturing PMI Final"""

            HsbcManufacturingPurchasingManagersIndexFlash: str = "hsbc manufacturing purchasing managers index flash"
            """HSBC Manufacturing PMI Flash"""

            HsbcManufacturingPurchasingManagersIndexPreliminary: str = "hsbc manufacturing purchasing managers index preliminary"
            """HSBC Manufacturing PMI Prel."""

            HsbcServicesPurchasingManagersIndex: str = "hsbc services purchasing managers index"
            """HSBC Services PMI"""

            Imports: str = "imports"
            """Imports"""

            ImportsYoY: str = "imports yoy"
            """Imports YoY"""

            IndustrialCapacityUtilization: str = "industrial capacity utilization"
            """Industrial Capacity Capacity Utilization"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            IndustrialProfitsYtdYoY: str = "industrial profits ytd yoy"
            """Industrial Profits (YTD) YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InterestRateDecision: str = "interest rate decision"
            """Interest Rate Decision"""

            LaborDay: str = "labor day"
            """Labour Day"""

            LoanPrimeRateFiveYear: str = "loan prime rate 5y"
            """Loan Prime Rate 5Y"""

            LoanPrimeRateOneYear: str = "loan prime rate 1y"
            """Loan Prime Rate 1Y"""

            MidAutumnFestival: str = "mid autumn festival"
            """Mid-Autumn Festival"""

            MidAutumnHoliday: str = "mid autumn holiday"
            """Mid-Autumn Holiday"""

            MniBusinessSentiment: str = "mni business sentiment"
            """MNI Business Sentiment"""

            MTwoMoneySupplyYoY: str = "m2 money supply yoy"
            """M2 Money Supply YoY"""

            NationalDay: str = "national day"
            """National Day"""

            NationalPeoplesCongress: str = "national peoples congress"
            """National People’s Congress"""

            NbsManufacturingPurchasingManagersIndex: str = "nbs manufacturing purchasing managers index"
            """NBS Manufacturing PMI"""

            NbsPressConference: str = "nbs press conference"
            """NBS Press Conference"""

            NewLoans: str = "new loans"
            """New Loans"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NewYuanLoans: str = "new yuan loans"
            """New Yuan Loans"""

            NonManufacturingPurchasingManagersIndex: str = "non manufacturing purchasing managers index"
            """Non Manufacturing PMI"""

            OutstandingLoanGrowthYoY: str = "outstanding loan growth yoy"
            """Outstanding Loan Growth YoY"""

            PresidentJinpingSpeechAtBoaoForum: str = "president jinping speech at boao forum"
            """President Jinping Speech at Boao Forum"""

            PresidentXiJinpingSpeech: str = "president xi jinping speech"
            """President Xi Jinping Speech"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            QingMingJie: str = "qing ming jie"
            """Qing Ming Jie"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            TotalSocialFinancing: str = "total social financing"
            """Total Social Financing"""

            UrbanInvestmentYoY: str = "urban investment yoy"
            """Urban Investment YoY"""

            UrbanInvestmentYtd: str = "urban investment ytd"
            """Urban Investment YTD"""

            UrbanInvestmentYtdYoY: str = "urban investment ytd yoy"
            """Urban investment (YTD) (YoY)"""

            UsChinaTradeTalks: str = "us china trade talks"
            """US-China Trade Talks"""

            VehicleSalesYoY: str = "vehicle sales yoy"
            """Vehicle Sales YoY"""

            VictoryDay: str = "victory day"
            """Victory Day"""

            WestpacMniConsumerSentiment: str = "westpac mni consumer sentiment"
            """Westpac MNI Consumer Sentiment Indicator"""

        class Cyprus(System.Object):
            """Cyprus"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            CatholicChristmasDay: str = "catholic christmas day"
            """Catholic Christmas Day"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            CleanMonday: str = "clean monday"
            """Clean Monday"""

            ConstructionOutputYoY: str = "construction output yoy"
            """Construction Output YoY"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CurrentAccount: str = "current account"
            """Current Account"""

            Epiphany: str = "epiphany"
            """Epiphany"""

            GdpAnnualGrowthRateYoY: str = "gdp annual growth rate yoy"
            """GDP Annual Growth Rate YoY"""

            GdpGrowthRateFinal: str = "gdp growth rate final"
            """GDP Growth Rate - Final"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQFlash: str = "gdp growth rate qoq flash"
            """GDP Growth Rate QoQ Flash"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYFlash: str = "gdp growth rate yoy flash"
            """GDP Growth Rate YoY Flash"""

            GreekIndependenceDay: str = "greek independence day"
            """Greek Independence Day"""

            HarmonizedInflationRateYoY: str = "harmonized inflation rate yoy"
            """Harmonised Inflation Rate YoY"""

            IndependenceDay: str = "independence day"
            """Independence Day"""

            IndustrialProduction: str = "industrial production"
            """Industrial Production"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            LaborDay: str = "labor day"
            """Labour Day"""

            NationalDay: str = "national day"
            """National Day"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            OchiDay: str = "ochi day"
            """Ochi Day"""

            OrthodoxEasterMonday: str = "orthodox easter monday"
            """Orthodox Easter Monday"""

            OrthodoxEasterSunday: str = "orthodox easter sunday"
            """Orthodox Easter Sunday"""

            OrthodoxEasterTuesday: str = "orthodox easter tuesday"
            """Orthodox Easter Tuesday"""

            OrthodoxGoodFriday: str = "orthodox good friday"
            """Orthodox Good Friday"""

            OrthodoxWhitMonday: str = "orthodox whit monday"
            """Orthodox Whit Monday"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            ParliamentVoteOnDepositLevyForBailoutPlan: str = "parliament vote on deposit levy for bailout plan"
            """Parliament Vote on Deposit Levy for Bailout Plan"""

            PresidentialElection: str = "presidential election"
            """Presidential Election"""

            PresidentialElectionRoundTwo: str = "presidential election round 2"
            """Presidential Election Round 2"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            WageGrowthYoY: str = "wage growth yoy"
            """Wage Growth YoY"""

        class Estonia(System.Object):
            """Estonia"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ChristmasEve: str = "christmas eve"
            """Christmas Eve"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            EestiPankEconomicForecast: str = "eesti pank economic forecast"
            """Eesti Pank Economic Forecast"""

            EestiPankGovHanssonSpeech: str = "eesti pank gov hansson speech"
            """Eesti Pank Gov Hansson Speech"""

            GdpAnnualGrowthRateYoY: str = "gdp annual growth rate yoy"
            """GDP Annual Growth Rate YoY"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateQoQSecondEstimate: str = "gdp growth rate qoq second estimate"
            """GDP Growth Rate QoQ Second Estimate"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY Prel"""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY 2nd Est"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            Imports: str = "imports"
            """Imports"""

            IndependenceDay: str = "independence day"
            """Independence Day"""

            IndependenceRestorationDay: str = "independence restoration day"
            """Independence Restoration Day"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            MidsummerDay: str = "midsummer day"
            """Midsummer Day"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            Pentecost: str = "pentecost"
            """Pentecost"""

            PresidentialElections: str = "presidential elections"
            """Presidential Elections"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            SpringDay: str = "spring day"
            """Spring Day"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            VictoryDay: str = "victory day"
            """Victory Day"""

        class Finland(System.Object):
            """Finland"""

            AllSaintsDay: str = "all saints day"
            """All Saints' Day"""

            AscensionDay: str = "ascension day"
            """Ascension Day"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BofGovLiikanenSpeech: str = "bof gov liikanen speech"
            """BoF Gov Liikanen Speech"""

            BofLiikanenSpeech: str = "bof liikanen speech"
            """BoF Liikanen Speech"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ChristmasEve: str = "christmas eve"
            """Christmas Eve"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            Epiphany: str = "epiphany"
            """Epiphany"""

            EpiphanyDay: str = "epiphany day"
            """Epiphany Day"""

            ExportPricesYoY: str = "export prices yoy"
            """Export Prices YoY"""

            GdpGrowthRate: str = "gdp growth rate"
            """GDP Growth Rate"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQFlash: str = "gdp growth rate qoq flash"
            """GDP Growth Rate QoQ - Flash"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY Prel"""

            GdpYoY: str = "gdp yoy"
            """GDP YoY"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            ImportPrices: str = "import prices"
            """Import Prices"""

            ImportPricesYoY: str = "import prices yoy"
            """Import Prices YoY"""

            IndependenceDay: str = "independence day"
            """Independence Day"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            MidsummerDay: str = "midsummer day"
            """Midsummer Day"""

            MidsummerEve: str = "midsummer eve"
            """Midsummer Eve"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            Pentecost: str = "pentecost"
            """Pentecost"""

            PresidentialElection: str = "presidential election"
            """Presidential Election"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            VappuMayDay: str = "vappu may day"
            """Vappu (May Day)"""

        class France(System.Object):
            """France"""

            AllSaintsDay: str = "all saints day"
            """All Saints' Day"""

            ArmisticeDay: str = "armistice day"
            """Armistice Day"""

            AscensionDay: str = "ascension day"
            """Ascension Day"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BastilleDay: str = "bastille day"
            """Bastille Day"""

            BudgetBalance: str = "budget balance"
            """Budget balance"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            ConsumerSpendingMoM: str = "consumer spending mom"
            """Consumer Spending MoM"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            FinanceSummitTwoThousandNineteen: str = "finance summit 2019"
            """Finance Summit 2019"""

            FiveYearBtanAuction: str = "5 year btan auction"
            """5-Year BTAN Auction"""

            FourYearBtanAuction: str = "4 year btan auction"
            """4-Year BTAN Auction"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQFirstEstimate: str = "gdp growth rate qoq first estimate"
            """GDP Growth Rate QoQ 1st Est"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateQoQSecondEstimate: str = "gdp growth rate qoq second estimate"
            """GDP Growth Rate QoQ 2nd Est"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYFirstEstimate: str = "gdp growth rate yoy first estimate"
            """GDP Growth Rate YoY 1st Est"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY Prel"""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY 2nd Est"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            GSevenFinanceMinistersAndCentralBankGovernorsMeeting: str = "g7 finance ministers and central bank governors meeting"
            """G7 Finance Ministers and Central Bank Governors Meeting"""

            GSevenSummit: str = "g7 summit"
            """G7 Summit"""

            HarmonizedInflationRateMoM: str = "harmonized inflation rate mom"
            """Harmonised Inflation Rate MoM"""

            HarmonizedInflationRateMoMFinal: str = "harmonized inflation rate mom final"
            """Harmonised Inflation Rate MoM Final"""

            HarmonizedInflationRateMoMPreliminary: str = "harmonized inflation rate mom preliminary"
            """Harmonised Inflation Rate MoM Prel"""

            HarmonizedInflationRateYoY: str = "harmonized inflation rate yoy"
            """Harmonised Inflation Rate YoY"""

            HarmonizedInflationRateYoYFinal: str = "harmonized inflation rate yoy final"
            """Harmonised Inflation Rate YoY Final"""

            HarmonizedInflationRateYoYPreliminary: str = "harmonized inflation rate yoy preliminary"
            """Harmonised Inflation Rate YoY Prel"""

            HouseholdConsumptionMoM: str = "household consumption mom"
            """Household Consumption MoM"""

            IeaOilMarketReport: str = "iea oil market report"
            """IEA Oil Market Report"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateMoMFinal: str = "inflation rate mom final"
            """Inflation Rate MoM Final"""

            InflationRateMoMPreliminary: str = "inflation rate mom preliminary"
            """Inflation Rate MoM Prel"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InflationRateYoYFinal: str = "inflation rate yoy final"
            """Inflation Rate YoY Final"""

            InflationRateYoYPreliminary: str = "inflation rate yoy preliminary"
            """Inflation Rate YoY Prel"""

            JobseekersTotal: str = "jobseekers total"
            """Jobseekers Total"""

            LaborDay: str = "labor day"
            """Labour Day"""

            ManufacturingPurchasingManagersIndex: str = "manufacturing purchasing managers index"
            """Manufacturing PMI"""

            MarkitCompositePurchasingManagersIndexFinal: str = "markit composite purchasing managers index final"
            """Markit Composite PMI Final"""

            MarkitCompositePurchasingManagersIndexFlash: str = "markit composite purchasing managers index flash"
            """Markit Composite PMI Flash"""

            MarkitManufacturingPurchasingManagersIndex: str = "markit manufacturing purchasing managers index"
            """Markit Manufacturing PMI"""

            MarkitManufacturingPurchasingManagersIndexFinal: str = "markit manufacturing purchasing managers index final"
            """Markit Manufacturing Pmi Final"""

            MarkitManufacturingPurchasingManagersIndexFlash: str = "markit manufacturing purchasing managers index flash"
            """Markit Manufacturing PMI Flash"""

            MarkitServicesPurchasingManagersIndex: str = "markit services purchasing managers index"
            """Markit Services PMI"""

            MarkitServicesPurchasingManagersIndexFinal: str = "markit services purchasing managers index final"
            """Markit Services PMI Final"""

            MarkitServicesPurchasingManagersIndexFlash: str = "markit services purchasing managers index flash"
            """Markit Services PMI Flash"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NonFarmPayrollsQoQ: str = "non farm payrolls qoq"
            """Nonfarm Payrolls QoQ"""

            NonFarmPayrollsQoQFinal: str = "non farm payrolls qoq final"
            """Non Farm Payrolls QoQ Final"""

            NonFarmPayrollsQoQPreliminary: str = "non farm payrolls qoq preliminary"
            """Non Farm Payrolls QoQ Prel"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            Pentecost: str = "pentecost"
            """Pentecost"""

            PresidentialElections: str = "presidential elections"
            """Presidential Elections"""

            PrivateNonFarmPayrollsQoQFinal: str = "private non farm payrolls qoq final"
            """Private Non Farm Payrolls QoQ Final"""

            PrivateNonFarmPayrollsQoQPreliminary: str = "private non farm payrolls qoq preliminary"
            """Private Non Farm Payrolls QoQ Prel"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            ServicesPurchasingManagersIndex: str = "services purchasing managers index"
            """Services PMI"""

            SixMonthBtfAuction: str = "6 month btf auction"
            """6-Month BTF Auction"""

            TenYearOatAuction: str = "10 year oat auction"
            """10-Year OAT Auction"""

            ThreeMonthBtfAuction: str = "3 month btf auction"
            """3-Month BTF Auction"""

            ThreeYearBtanAuction: str = "3 year btan auction"
            """3-Year BTAN Auction"""

            TwelveMonthBtfAuction: str = "12 month btf auction"
            """12-Month BTF Auction"""

            TwoYearBtanAuction: str = "2 year btan auction"
            """2-Year BTAN Auction"""

            UnemploymentBenefitClaims: str = "unemployment benefit claims"
            """Unemployment Benefit Claims"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            WhitMonday: str = "whit monday"
            """Whit Monday"""

            WwiiVictoryDay: str = "wwii victory day"
            """WWII Victory Day"""

        class Germany(System.Object):
            """Germany"""

            AllSaintsDay: str = "all saints day"
            """All Saints' Day"""

            AscensionDay: str = "ascension day"
            """Ascension Day"""

            AsianDevelopmentBankAnnualMeeting: str = "asian development bank annual meeting"
            """Asian Development Bank Annual Meeting"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BadenWrttembergStateElection: str = "baden wrttemberg state election"
            """Baden-Württemberg State Election"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BalanceOfTradeSeasonallyAdjusted: str = "balance of trade seasonally adjusted"
            """Balance of Trade s.a"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BundesbankAnnualReport: str = "bundesbank annual report"
            """Bundesbank Annual Report"""

            BundesbankAnnualReportTwoThousandSeventeen: str = "bundesbank annual report 2017"
            """Bundesbank Annual Report 2017"""

            BundesbankBalzSpeech: str = "bundesbank balz speech"
            """Bundesbank Balz Speech"""

            BundesbankBeermannSpeech: str = "bundesbank beermann speech"
            """Bundesbank Beermann Speech"""

            BundesbankBuchSpeech: str = "bundesbank buch speech"
            """Bundesbank Buch Speech"""

            BundesbankDombretSpeech: str = "bundesbank dombret speech"
            """Bundesbank Dombret Speech"""

            BundesbankMaudererSpeech: str = "bundesbank mauderer speech"
            """Bundesbank Mauderer Speech"""

            BundesbankMonthlyReport: str = "bundesbank monthly report"
            """Bundesbank Monthly Report"""

            BundesbankPresidentWeidmannSpeech: str = "bundesbank president weidmann speech"
            """Bundesbank President Weidmann Speech"""

            BundesbankSemiAnnualForecasts: str = "bundesbank semi annual forecasts"
            """Bundesbank Semi-Annual Forecasts"""

            BundesbankThieleSpeech: str = "bundesbank thiele speech"
            """Bundesbank Thiele Speech"""

            BundesbankWeidmannSpeech: str = "bundesbank weidmann speech"
            """Bundesbank Weidmann Speech"""

            BundesbankWuermelingSpeech: str = "bundesbank wuermeling speech"
            """Bundesbank Wuermeling Speech"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConstructionPurchasingManagersIndex: str = "construction purchasing managers index"
            """Construction PMI"""

            CorpusChristi: str = "corpus christi"
            """Corpus Christi"""

            CurrentAccount: str = "current account"
            """Current Account"""

            DayOfGermanUnity: str = "day of german unity"
            """Day of German Unity"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EmployedPersons: str = "employed persons"
            """Employed Persons"""

            Epiphany: str = "epiphany"
            """Epiphany"""

            EuroFinanceWeek: str = "euro finance week"
            """Euro Finance Week"""

            EuroFinanceWeekTwoThousandSeventeen: str = "euro finance week 2017"
            """Euro Finance Week 2017"""

            ExportsMoM: str = "exports mom"
            """Exports MoM"""

            ExportsMoMSeasonallyAdjusted: str = "exports mom seasonally adjusted"
            """Exports MoM s.a"""

            FactoryOrdersMoM: str = "factory orders mom"
            """Factory Orders MoM"""

            FactoryOrdersYoY: str = "factory orders yoy"
            """Factory Orders YoY"""

            FederalElection: str = "federal election"
            """Federal election"""

            FinanceMinisterSchubleSpeech: str = "finance minister schuble speech"
            """Finance Minister Schäuble Speech"""

            FiveYearBoblAuction: str = "5 year bobl auction"
            """5-Year Bobl Auction"""

            FrankfurtFinanceSummitTwoThousandSeventeen: str = "frankfurt finance summit 2017"
            """Frankfurt Finance Summit 2017"""

            FrankfurtFinanceSummitTwoThousandSixteen: str = "frankfurt finance summit 2016"
            """Frankfurt Finance Summit 2016"""

            FullYearGdpGrowth: str = "full year gdp growth"
            """Full Year GDP Growth"""

            GdpGrowthRate: str = "gdp growth rate"
            """GDP Growth Rate"""

            GdpGrowthRateFlash: str = "gdp growth rate flash"
            """GDP Growth Rate 2015 Flash"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQFlash: str = "gdp growth rate qoq flash"
            """GDP Growth Rate QoQ Flash"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYFlash: str = "gdp growth rate yoy flash"
            """GDP Growth Rate YoY Flash"""

            GermanBubaPresidentWeidmannSpeech: str = "german buba president weidmann speech"
            """German Buba President Weidmann speech"""

            GfkConsumerConfidence: str = "gfk consumer confidence"
            """Gfk Consumer Confidence"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            GovernmentBudget: str = "government budget"
            """Government Budget"""

            GSevenFinanceMinistersMeeting: str = "g7 finance ministers meeting"
            """G7 Finance Ministers' Meeting"""

            GTwentyConference: str = "g20 conference"
            """G20-Conference"""

            GTwentyFinanceMinistersAndCbGovernorsMeeting: str = "g20 finance ministers and cb governors meeting"
            """G20 Finance Ministers and CB Governors Meeting"""

            GTwentyForeignMinistersMeeting: str = "g20 foreign ministers meeting"
            """G20 Foreign Ministers Meeting"""

            GTwentySummit: str = "g20 summit"
            """G20 Summit"""

            HarmonizedInflationRateMoM: str = "harmonized inflation rate mom"
            """Harmonised Inflation Rate MoM"""

            HarmonizedInflationRateMoMFinal: str = "harmonized inflation rate mom final"
            """Harmonised Inflation Rate MoM Final"""

            HarmonizedInflationRateMoMPreliminary: str = "harmonized inflation rate mom preliminary"
            """Harmonised Inflation Rate MoM Prel"""

            HarmonizedInflationRateYoY: str = "harmonized inflation rate yoy"
            """Harmonised Inflation Rate YoY"""

            HarmonizedInflationRateYoYFinal: str = "harmonized inflation rate yoy final"
            """Harmonised Inflation Rate YoY Final"""

            HarmonizedInflationRateYoYPreliminary: str = "harmonized inflation rate yoy preliminary"
            """Harmonised Inflation Rate YoY Prel"""

            IfoBusinessClimate: str = "ifo business climate"
            """IFO Business Climate"""

            IfoCurrentAssessment: str = "ifo current assessment"
            """IFO - Current Assessment"""

            IfoCurrentConditions: str = "ifo current conditions"
            """IFO Current Conditions"""

            IfoExpectations: str = "ifo expectations"
            """IFO Expectations"""

            ImfLagardeSpeech: str = "imf lagarde speech"
            """IMF Lagarde Speech"""

            ImportPricesMoM: str = "import prices mom"
            """Import Prices MoM"""

            ImportPricesYoY: str = "import prices yoy"
            """Import Prices YoY"""

            ImportsMoMSeasonallyAdjusted: str = "imports mom seasonally adjusted"
            """Imports MoM s.a"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateMoMFinal: str = "inflation rate mom final"
            """Inflation Rate MoM Final"""

            InflationRateMoMFlash: str = "inflation rate mom flash"
            """Inflation Rate MoM Flash"""

            InflationRateMoMPreliminary: str = "inflation rate mom preliminary"
            """Inflation Rate MoM Prel"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InflationRateYoYFinal: str = "inflation rate yoy final"
            """Inflation Rate YoY Final"""

            InflationRateYoYPreliminary: str = "inflation rate yoy preliminary"
            """Inflation Rate YoY Prel"""

            JobVacancies: str = "job vacancies"
            """Job Vacancies"""

            LaborDay: str = "labor day"
            """Labour Day"""

            MarkitBmeManufacturingPurchasingManagersIndexFinal: str = "markit bme manufacturing purchasing managers index final"
            """Markit/BME Manufacturing Pmi Final"""

            MarkitBmeManufacturingPurchasingManagersIndexFlash: str = "markit bme manufacturing purchasing managers index flash"
            """Markit/BME Manufacturing PMI Flash"""

            MarkitCompositePurchasingManagersIndexFinal: str = "markit composite purchasing managers index final"
            """Markit Composite PMI Final"""

            MarkitCompositePurchasingManagersIndexFlash: str = "markit composite purchasing managers index flash"
            """Markit Composite PMI Flash"""

            MarkitManufacturingPurchasingManagersIndex: str = "markit manufacturing purchasing managers index"
            """Markit Manufacturing PMI"""

            MarkitManufacturingPurchasingManagersIndexFinal: str = "markit manufacturing purchasing managers index final"
            """Markit Manufacturing PMI Final"""

            MarkitManufacturingPurchasingManagersIndexFlash: str = "markit manufacturing purchasing managers index flash"
            """Markit Manufacturing PMI Flash"""

            MarkitServicesPurchasingManagersIndex: str = "markit services purchasing managers index"
            """Markit Services PMI"""

            MarkitServicesPurchasingManagersIndexFinal: str = "markit services purchasing managers index final"
            """Markit Services PMI Final"""

            MarkitServicesPurchasingManagersIndexFlash: str = "markit services purchasing managers index flash"
            """Markit Services PMI Flash"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            PresidentialElections: str = "presidential elections"
            """Presidential Elections"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            ReformationDay: str = "reformation day"
            """Reformation Day"""

            RepentanceDay: str = "repentance day"
            """Repentance Day"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            RhinelandPalatinateStateElection: str = "rhineland palatinate state election"
            """Rhineland-Palatinate State Election"""

            SaxonyAnhaltStateElection: str = "saxony anhalt state election"
            """Saxony-Anhalt State Election"""

            ServicesPurchasingManagersIndex: str = "services purchasing managers index"
            """Services PMI"""

            StStephensDay: str = "st stephens day"
            """St Stephen's Day"""

            TenYearBundAuction: str = "10 year bund auction"
            """10-Year Bund Auction"""

            ThirtyYearBundAuction: str = "30 year bund auction"
            """30-Year Bund Auction"""

            TwelveMonthBubillAuction: str = "12 month bubill auction"
            """12-Month Bubill Auction"""

            TwoYearSchatzAuction: str = "2 year schatz auction"
            """2-Year Schatz Auction"""

            UnemployedPersonsNotSeasonallyAdjusted: str = "unemployed persons not seasonally adjusted"
            """Unemployed Persons NSA"""

            UnemploymentChange: str = "unemployment change"
            """Unemployment Change"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            UnemploymentRateHarmonized: str = "unemployment rate harmonized"
            """Unemployment Rate Harmonised"""

            WhitMonday: str = "whit monday"
            """Whit Monday"""

            WholesalePricesMoM: str = "wholesale prices mom"
            """Wholesale Prices MoM"""

            WholesalePricesYoY: str = "wholesale prices yoy"
            """Wholesale Prices YoY"""

            ZewCurrentConditions: str = "zew current conditions"
            """ZEW Current Conditions"""

            ZewEconomicSentimentIndex: str = "zew economic sentiment index"
            """ZEW Economic Sentiment Index"""

        class Greece(System.Object):
            """Greece"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            CleanMonday: str = "clean monday"
            """Clean Monday"""

            ConstructionOutputYoY: str = "construction output yoy"
            """Construction Output YoY"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CreditExpansionYoY: str = "credit expansion yoy"
            """Credit Expansion YoY"""

            CurrentAccount: str = "current account"
            """Current Account"""

            DebtRepaymentOfEurThirtyFiveBDueToEcb: str = "debt repayment of eur 35b due to ecb"
            """Debt Repayment of EUR 3.5B Due to ECB"""

            Epiphany: str = "epiphany"
            """Epiphany"""

            EpiphanyDay: str = "epiphany day"
            """Epiphany Day"""

            EuBailoutExpiration: str = "eu bailout expiration"
            """EU Bailout Expiration"""

            GdpAnnualGrowthRateYoY: str = "gdp annual growth rate yoy"
            """GDP Annual Growth Rate YoY"""

            GdpAnnualGrowthRateYoYPreliminary: str = "gdp annual growth rate yoy preliminary"
            """GDP Annual Growth Rate YoY - Preliminary"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYAdv: str = "gdp growth rate yoy adv"
            """GDP Growth Rate YoY Adv"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYFlash: str = "gdp growth rate yoy flash"
            """GDP Growth Rate YoY Flash"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY - P."""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY 2nd Est"""

            GreekParliamentElections: str = "greek parliament elections"
            """Greek Parliament Elections"""

            GreekThirdBailoutProgramsVote: str = "greek third bailout programs vote"
            """Greek Third Bailout Program's Vote"""

            HarmonizedInflationRateYoY: str = "harmonized inflation rate yoy"
            """Harmonized Inflation Rate YoY"""

            HolySpiritMonday: str = "holy spirit monday"
            """Holy Spirit Monday"""

            IndependenceDay: str = "independence day"
            """Independence Day"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            LaborDay: str = "labor day"
            """Labour Day"""

            LaborDaySubstituteDay: str = "labor day substitute day"
            """Labour Day (Substitute Day)"""

            LoansToPrivateSector: str = "loans to private sector"
            """Loans to Private Sector"""

            LoansToPrivateSectorYoY: str = "loans to private sector yoy"
            """Loans to Private Sector YoY"""

            MarkitManufacturingPurchasingManagersIndex: str = "markit manufacturing purchasing managers index"
            """Markit Manufacturing PMI"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            OchiDay: str = "ochi day"
            """Ochi Day"""

            OrthodoxEasterMonday: str = "orthodox easter monday"
            """Orthodox Easter Monday"""

            OrthodoxEasterSunday: str = "orthodox easter sunday"
            """Orthodox Easter Sunday"""

            OrthodoxGoodFriday: str = "orthodox good friday"
            """Orthodox Good Friday"""

            OrthodoxWhitMonday: str = "orthodox whit monday"
            """Orthodox Whit Monday"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            ReferendumOnBailoutTerms: str = "referendum on bailout terms"
            """Referendum on Bailout Terms"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            StStephensDay: str = "st stephens day"
            """St Stephen's Day"""

            TheOchiDay: str = "the ochi day"
            """The Ochi Day"""

            ThirteenWeekBillAuction: str = "13 week bill auction"
            """13-Weeks Bill Auction"""

            TotalCreditYoY: str = "total credit yoy"
            """Total Credit YoY"""

            TwentySixWeekBillAuction: str = "26 week bill auction"
            """26-Weeks Bill Auction"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

        class Ireland(System.Object):
            """Ireland"""

            AibManufacturingPurchasingManagersIndex: str = "aib manufacturing purchasing managers index"
            """AIB Manufacturing PMI"""

            AibServicesPurchasingManagersIndex: str = "aib services purchasing managers index"
            """AIB Services PMI"""

            AugustBankHoliday: str = "august bank holiday"
            """August Bank Holiday"""

            AverageWeeklyEarningsYoY: str = "average weekly earnings yoy"
            """Average Weekly Earnings YoY"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BalanceOfTradeFinal: str = "balance of trade final"
            """Balance of Trade-Final"""

            BankHoliday: str = "bank holiday"
            """Bank Holiday"""

            CbiGovLaneSpeech: str = "cbi gov lane speech"
            """CBI Gov Lane Speech"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConstructionOutputYoY: str = "construction output yoy"
            """Construction Output YoY"""

            ConstructionPurchasingManagersIndex: str = "construction purchasing managers index"
            """Construction PMI"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CoreInflationRate: str = "core inflation rate"
            """Core Inflation Rate"""

            CoreInflationRateYoY: str = "core inflation rate yoy"
            """Core Inflation Rate YoY"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EsriConsumerSentimentIndex: str = "esri consumer sentiment index"
            """ESRI Consumer Sentiment Index"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GnpQoQ: str = "gnp qoq"
            """GNP QoQ"""

            GnpYoY: str = "gnp yoy"
            """GNP YoY"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            HarmonizedInflationRateMoM: str = "harmonized inflation rate mom"
            """Harmonised Inflation Rate MoM"""

            HarmonizedInflationRateYoY: str = "harmonized inflation rate yoy"
            """Harmonised Inflation Rate YoY"""

            HouseholdSavingRatio: str = "household saving ratio"
            """Household Saving Ratio"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRate: str = "inflation rate"
            """Inflation Rate"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InvestecManufacturingPurchasingManagersIndex: str = "investec manufacturing purchasing managers index"
            """Investec Manufacturing Pmi"""

            InvestecServicesPurchasingManagersIndex: str = "investec services purchasing managers index"
            """Investec Services PMI"""

            JuneBankHoliday: str = "june bank holiday"
            """June Bank Holiday"""

            MarkitServicesPurchasingManagersIndex: str = "markit services purchasing managers index"
            """Markit Services PMI"""

            MayBankHoliday: str = "may bank holiday"
            """May Bank Holiday"""

            MayDay: str = "may day"
            """May Day"""

            NewYearsDay: str = "new years day"
            """New Year’s Day"""

            NewYearsDaySubstituteDay: str = "new years day substitute day"
            """New Year’s Day (Substitute Day)"""

            OctoberBankHoliday: str = "october bank holiday"
            """October Bank Holiday"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            PurchasingManagerIndexManufacturing: str = "purchasing manager index manufacturing"
            """Purchasing Manager Index Manufacturing"""

            PurchasingManagerIndexServices: str = "purchasing manager index services"
            """Purchasing Manager Index Services"""

            PurchasingManagersIndexServices: str = "purchasing managers index services"
            """PMI services"""

            ResidentialPropertyPricesMoM: str = "residential property prices mom"
            """Residential Property Prices MoM"""

            ResidentialPropertyPricesYoY: str = "residential property prices yoy"
            """Residential Property Prices YoY"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            StPatricksDay: str = "st patricks day"
            """St. Patricks Day"""

            StStephensDay: str = "st stephens day"
            """St Stephen's Day"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            WholesalePricesMoM: str = "wholesale prices mom"
            """Wholesale Prices MoM"""

            WholesalePricesYoY: str = "wholesale prices yoy"
            """Wholesale Prices YoY"""

        class Italy(System.Object):
            """Italy"""

            AllSaintsDay: str = "all saints day"
            """All Saints' Day"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BoiRossiSpeech: str = "boi rossi speech"
            """BoI Rossi Speech"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConstructionOutputYoY: str = "construction output yoy"
            """Construction Output YoY"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            ConsumerPriceIndexEuNormMoM: str = "consumer price index eu norm mom"
            """Consumer Price Index (EU Norm) (MoM)"""

            ConsumerPriceIndexEuNormYoY: str = "consumer price index eu norm yoy"
            """Consumer Price Index (EU Norm) (YoY)"""

            ConsumerPriceIndexMoM: str = "consumer price index mom"
            """Consumer Price Index (MoM)"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            EconomyAndFinanceMinisterPadoanSpeech: str = "economy and finance minister padoan speech"
            """Economy and Finance Minister Padoan Speech"""

            Epiphany: str = "epiphany"
            """Epiphany"""

            FiveYBondAuction: str = "5 y bond auction"
            """5-y Bond Auction"""

            FiveYearBtpAuction: str = "5 year btp auction"
            """5-Year BTP Auction"""

            FullYearGdpGrowth: str = "full year gdp growth"
            """Full Year GDP Growth"""

            GdpAnnualGrowthRateYoY: str = "gdp annual growth rate yoy"
            """GDP Annual Growth Rate YoY"""

            GdpGrowthRate: str = "gdp growth rate"
            """GDP Growth Rate 2015"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQAdv: str = "gdp growth rate qoq adv"
            """GDP Growth Rate QoQ Adv"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYAdv: str = "gdp growth rate yoy adv"
            """GDP Growth Rate YoY Adv"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GeneralElections: str = "general elections"
            """General Elections"""

            GovernmentBudget: str = "government budget"
            """Government Budget"""

            GSevenFinMinistersAndCbGovernorsMeeting: str = "g7 fin ministers and cb governors meeting"
            """G7 Fin Ministers and CB Governors Meeting"""

            GSevenForeignMinistersMeeting: str = "g7 foreign ministers meeting"
            """G7 Foreign Ministers Meeting"""

            GSevenSummit: str = "g7 summit"
            """G7 Summit"""

            HarmonizedInflationRateMoMFinal: str = "harmonized inflation rate mom final"
            """Harmonised Inflation Rate MoM Final"""

            HarmonizedInflationRateMoMPreliminary: str = "harmonized inflation rate mom preliminary"
            """Harmonised Inflation Rate MoM Prel"""

            HarmonizedInflationRateYoYFinal: str = "harmonized inflation rate yoy final"
            """Harmonised Inflation Rate YoY Final"""

            HarmonizedInflationRateYoYPreliminary: str = "harmonized inflation rate yoy preliminary"
            """Harmonised Inflation Rate YoY Prel"""

            ImmaculateConception: str = "immaculate conception"
            """Immaculate Conception"""

            IndustrialOrdersMoM: str = "industrial orders mom"
            """Industrial Orders MoM"""

            IndustrialOrdersYoY: str = "industrial orders yoy"
            """Industrial Orders YoY"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            IndustrialSalesMoM: str = "industrial sales mom"
            """Industrial Sales MoM"""

            IndustrialSalesYoY: str = "industrial sales yoy"
            """Industrial Sales YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateMoMFinal: str = "inflation rate mom final"
            """Inflation Rate MoM Final"""

            InflationRateMoMPreliminary: str = "inflation rate mom preliminary"
            """Inflation Rate MoM Prel"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InflationRateYoYFinal: str = "inflation rate yoy final"
            """Inflation Rate YoY Final"""

            InflationRateYoYPreliminary: str = "inflation rate yoy preliminary"
            """Inflation Rate YoY Prel"""

            LaborDay: str = "labor day"
            """Labour Day"""

            LiberationDay: str = "liberation day"
            """Liberation Day"""

            ManufacturingPurchasingManagersIndex: str = "manufacturing purchasing managers index"
            """Manufacturing PMI"""

            MarkitAdaciManufacturingPurchasingManagersIndex: str = "markit adaci manufacturing purchasing managers index"
            """Markit/ADACI Manufacturing PMI"""

            MarkitAdaciServicesPurchasingManagersIndex: str = "markit adaci services purchasing managers index"
            """Markit/ADACI Services PMI"""

            NewYearsDay: str = "new years day"
            """New Year’s Day"""

            PmContePressConference: str = "pm conte press conference"
            """PM Conte Press Conference"""

            PmConteSpeechInTheSenate: str = "pm conte speech in the senate"
            """PM Conte Speech in the Senate"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            ReferendumOnConstitutionalReform: str = "referendum on constitutional reform"
            """Referendum on Constitutional Reform"""

            RegionalElections: str = "regional elections"
            """Regional Elections"""

            RenziMerkelHollandeMeetOnBrexit: str = "renzi merkel hollande meet on brexit"
            """Renzi, Merkel, Hollande Meet on Brexit"""

            RepublicDay: str = "republic day"
            """Republic Day"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            SevenYearBtpAuction: str = "7 year btp auction"
            """7-Year BTP Auction"""

            SixMonthBotAuction: str = "6 month bot auction"
            """6-Month BOT Auction"""

            StStephensDay: str = "st stephens day"
            """St Stephen's Day"""

            TenYearBondAuction: str = "10 year bond auction"
            """10-Year Bond Auction"""

            TenYearBtpAuction: str = "10 year btp auction"
            """10-Year BTP Auction"""

            ThirtyYearBtpAuction: str = "30 year btp auction"
            """30-Year BTP Auction"""

            ThreeYearBtpAuction: str = "3 year btp auction"
            """3-Year BTP Auction"""

            TwelveMonthBotAuction: str = "12 month bot auction"
            """12-Month BOT Auction"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            WageInflationMoM: str = "wage inflation mom"
            """Wage Inflation MoM"""

            WageInflationYoY: str = "wage inflation yoy"
            """Wage Inflation YoY"""

        class Japan(System.Object):
            """Japan"""

            AllIndustryActivityIndexMoM: str = "all industry activity index mom"
            """All Industry Activity Index MoM"""

            AutumnEquinoxDay: str = "autumn equinox day"
            """Autumn Equinox Day"""

            AverageCashEarningsYoY: str = "average cash earnings yoy"
            """Average Cash Earnings YoY"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BankHoliday: str = "bank holiday"
            """Bank Holiday"""

            BankLendingYoY: str = "bank lending yoy"
            """Bank lending YoY"""

            BankOfJapanAmamiyaSpeech: str = "bank of japan amamiya speech"
            """BoJ Amamiya Speech"""

            BankOfJapanDeputyGovIwataSpeech: str = "bank of japan deputy gov iwata speech"
            """BoJ Deputy Gov Iwata Speech"""

            BankOfJapanDeputyGovNakasoSpeech: str = "bank of japan deputy gov nakaso speech"
            """BoJ Deputy Gov Nakaso Speech"""

            BankOfJapanFunoSpeech: str = "bank of japan funo speech"
            """BoJ Funo Speech"""

            BankOfJapanGovKurodaSpeaks: str = "bank of japan gov kuroda speaks"
            """BoJ Gov Kuroda Speaks"""

            BankOfJapanGovKurodaSpeech: str = "bank of japan gov kuroda speech"
            """BoJ Gov Kuroda Speech"""

            BankOfJapanHaradaSpeech: str = "bank of japan harada speech"
            """BoJ Harada Speech"""

            BankOfJapanInterestRateDecision: str = "bank of japan interest rate decision"
            """BoJ Interest Rate Decision"""

            BankOfJapanIwataSpeech: str = "bank of japan iwata speech"
            """BoJ Iwata Speech"""

            BankOfJapanKataokaSpeech: str = "bank of japan kataoka speech"
            """BoJ Kataoka Speech"""

            BankOfJapanKiuchiSpeech: str = "bank of japan kiuchi speech"
            """BoJ Kiuchi Speech"""

            BankOfJapanKurodaSpeech: str = "bank of japan kuroda speech"
            """BoJ Kuroda Speech"""

            BankOfJapanKuwabaraSpeech: str = "bank of japan kuwabara speech"
            """BoJ Kuwabara Speech"""

            BankOfJapanMasaiSpeech: str = "bank of japan masai speech"
            """BoJ Masai Speech"""

            BankOfJapanMonetaryPolicyMeetingMinutes: str = "bank of japan monetary policy meeting minutes"
            """BoJ Monetary Policy Meeting Minutes"""

            BankOfJapanMonetaryPolicyStatement: str = "bank of japan monetary policy statement"
            """BOJ Monetary Policy Statement"""

            BankOfJapanMonetaryPolicyStatementAndPressConference: str = "bank of japan monetary policy statement and press conference"
            """BoJ Monetary Policy Statement and press conference"""

            BankOfJapanMonthlyReport: str = "bank of japan monthly report"
            """BoJ Monthly Report"""

            BankOfJapanNakasoSpeech: str = "bank of japan nakaso speech"
            """BoJ Nakaso Speech"""

            BankOfJapanPressConference: str = "bank of japan press conference"
            """BoJ Press Conference"""

            BankOfJapanQuarterlyOutlookReport: str = "bank of japan quarterly outlook report"
            """BoJ Quarterly Outlook Report"""

            BankOfJapanQuarterlyReport: str = "bank of japan quarterly report"
            """BoJ Quarterly Report"""

            BankOfJapanSakuraiSpeech: str = "bank of japan sakurai speech"
            """BoJ Sakurai Speech"""

            BankOfJapanSatoSpeech: str = "bank of japan sato speech"
            """BoJ Sato Speech"""

            BankOfJapanSummaryOfOpinions: str = "bank of japan summary of opinions"
            """BoJ Summary of Opinions"""

            BankOfJapanSuzukiSpeech: str = "bank of japan suzuki speech"
            """BoJ Suzuki Speech"""

            BankOfJapanWakatabeSpeech: str = "bank of japan wakatabe speech"
            """BoJ Wakatabe Speech"""

            BusinessSurveyIndexLargeManufacturingQoQ: str = "business survey index large manufacturing qoq"
            """BSI Large Manufacturing QoQ"""

            CapacityUtilizationMoM: str = "capacity utilization mom"
            """Capacity Utilization MoM"""

            CapitalSpendingYoY: str = "capital spending yoy"
            """Capital Spending YoY"""

            ChildrensDay: str = "childrens day"
            """Children's Day"""

            CoincidentIndex: str = "coincident index"
            """Coincident Index"""

            CoincidentIndexFinal: str = "coincident index final"
            """Coincident Index Final"""

            CoincidentIndexPreliminary: str = "coincident index preliminary"
            """Coincident Index Prel"""

            ComingOfAgeDay: str = "coming of age day"
            """Coming of Age Day"""

            ConstitutionDay: str = "constitution day"
            """Constitution Day"""

            ConstructionOrdersYoY: str = "construction orders yoy"
            """Construction Orders YoY"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            ConsumerConfidenceHouseholds: str = "consumer confidence households"
            """Consumer Confidence Households"""

            ConsumerPriceIndexExcludingFreshFoodYoY: str = "consumer price index excluding fresh food yoy"
            """CPI Ex-Fresh Food YoY"""

            CoreInflationRateYoY: str = "core inflation rate yoy"
            """Core Inflation Rate YoY"""

            CorporateServicePriceYoY: str = "corporate service price yoy"
            """Corporate Service Price YoY"""

            CultureDay: str = "culture day"
            """Culture Day"""

            CurrentAccount: str = "current account"
            """Current Account"""

            DomesticCorporateGoodsPriceIndexMoM: str = "domestic corporate goods price index mom"
            """Domestic Corporate Goods Price Index (MoM)"""

            DomesticCorporateGoodsPriceIndexYoY: str = "domestic corporate goods price index yoy"
            """Domestic Corporate Goods Price Index (YoY)"""

            EcoWatchersSurveyCurrent: str = "eco watchers survey current"
            """Eco Watchers Survey Current"""

            EcoWatchersSurveyOutlook: str = "eco watchers survey outlook"
            """Eco Watchers Survey Outlook"""

            EmperorsBirthday: str = "emperors birthday"
            """Emperor's Birthday"""

            EuJapanSummit: str = "eu japan summit"
            """EU-Japan Summit"""

            Exports: str = "exports"
            """Exports"""

            ExportsYoY: str = "exports yoy"
            """Exports YoY"""

            FinanceMinisterAsoSpeech: str = "finance minister aso speech"
            """Finance Minister Aso Speech"""

            ForeignBondInvestment: str = "foreign bond investment"
            """Foreign bond investment"""

            ForeignExchangeReserves: str = "foreign exchange reserves"
            """Foreign Exchange Reserves"""

            ForeignInvestmentInJapanStocks: str = "foreign investment in japan stocks"
            """Foreign investment in Japan stocks"""

            GdpAnnualGrowthRateYoYFinal: str = "gdp annual growth rate yoy final"
            """GDP Annual Growth Rate YoY Final"""

            GdpCapitalExpenditureQoQ: str = "gdp capital expenditure qoq"
            """GDP Capital Expenditure QoQ"""

            GdpCapitalExpenditureQoQFinal: str = "gdp capital expenditure qoq final"
            """GDP Capital Expenditure QoQ Final"""

            GdpCapitalExpenditureQoQPreliminary: str = "gdp capital expenditure qoq preliminary"
            """GDP Capital Expenditure QoQ Prel"""

            GdpDeflatorYoYFinal: str = "gdp deflator yoy final"
            """GDP Deflator YoY Final"""

            GdpDeflatorYoYPreliminary: str = "gdp deflator yoy preliminary"
            """GDP Deflator YoY Prel"""

            GdpExternalDemandQoQ: str = "gdp external demand qoq"
            """GDP External Demand QoQ"""

            GdpExternalDemandQoQFinal: str = "gdp external demand qoq final"
            """GDP External Demand QoQ Final"""

            GdpExternalDemandQoQPreliminary: str = "gdp external demand qoq preliminary"
            """GDP External Demand QoQ Prel"""

            GdpGrowthAnnualizedFinal: str = "gdp growth annualized final"
            """Gdp Growth Annualized Final"""

            GdpGrowthAnnualizedPreliminary: str = "gdp growth annualized preliminary"
            """Gdp Growth Annualized Prel."""

            GdpGrowthAnnualizedQoQ: str = "gdp growth annualized qoq"
            """GDP Growth Annualized QoQ"""

            GdpGrowthAnnualizedQoQFinal: str = "gdp growth annualized qoq final"
            """GDP Growth Annualized QoQ Final"""

            GdpGrowthAnnualizedQoQPreliminary: str = "gdp growth annualized qoq preliminary"
            """GDP Growth Annualized QoQ Prel."""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpPriceIndexYoYFinal: str = "gdp price index yoy final"
            """GDP Price Index YoY Final"""

            GdpPriceIndexYoYPreliminary: str = "gdp price index yoy preliminary"
            """GDP Price Index YoY Prel"""

            GdpPrivateConsumptionQoQ: str = "gdp private consumption qoq"
            """GDP Private Consumption QoQ"""

            GdpPrivateConsumptionQoQFinal: str = "gdp private consumption qoq final"
            """GDP Private Consumption QoQ Final"""

            GdpPrivateConsumptionQoQPreliminary: str = "gdp private consumption qoq preliminary"
            """GDP Private Consumption QoQ Prel"""

            GeneralElections: str = "general elections"
            """General Elections"""

            GreeneryDay: str = "greenery day"
            """Greenery Day"""

            GrossDomesticProductAnnualizedFinal: str = "gross domestic product annualized final"
            """Gross Domestic Product Annualized Final"""

            GrossDomesticProductAnnualizedRevised: str = "gross domestic product annualized revised"
            """Gross Domestic Product Annualized (R)"""

            GSevenFinanceMinistersAndCentralBankGovernorsMeeting: str = "g7 finance ministers and central bank governors meeting"
            """G7 Finance Ministers and Central Bank Governors’ Meeting"""

            GSevenSummit: str = "g7 summit"
            """G7 Summit"""

            GTwentyMeeting: str = "g20 meeting"
            """G20 Meeting"""

            GTwentySummitMeeting: str = "g20 summit meeting"
            """G20 Summit Meeting"""

            HealthSportsDay: str = "health sports day"
            """Health-Sports Day"""

            Holiday: str = "holiday"
            """Holiday"""

            HouseholdSpendingMoM: str = "household spending mom"
            """Household Spending MoM"""

            HouseholdSpendingYoY: str = "household spending yoy"
            """Household Spending YoY"""

            HouseOfCouncillorsElection: str = "house of councillors election"
            """House of Councillors Election"""

            HousingStartsYoY: str = "housing starts yoy"
            """Housing Starts YoY"""

            Imports: str = "imports"
            """Imports"""

            ImportsYoY: str = "imports yoy"
            """Imports YoY"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionMoMFinal: str = "industrial production mom final"
            """Industrial Production MoM Final"""

            IndustrialProductionMoMPreliminary: str = "industrial production mom preliminary"
            """Industrial Production MoM Prel."""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            IndustrialProductionYoYFinal: str = "industrial production yoy final"
            """Industrial Production YoY Final"""

            IndustrialProductionYoYPreliminary: str = "industrial production yoy preliminary"
            """Industrial Production YoY Prel"""

            InflationRateExcludingFoodAndEnergyYoY: str = "inflation rate excluding food and energy yoy"
            """Inflation Rate Ex-Food and Energy YoY"""

            InflationRateExcludingFreshFoodYoY: str = "inflation rate excluding fresh food yoy"
            """Inflation Rate Ex-Fresh Food YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            JibunBankCompositePurchasingManagersIndexFinal: str = "jibun bank composite purchasing managers index final"
            """Jibun Bank Composite PMI Final"""

            JibunBankCompositePurchasingManagersIndexFlash: str = "jibun bank composite purchasing managers index flash"
            """Jibun Bank Composite PMI Flash"""

            JibunBankManufacturingPurchasingManagersIndexFinal: str = "jibun bank manufacturing purchasing managers index final"
            """Jibun Bank Manufacturing PMI Final"""

            JibunBankManufacturingPurchasingManagersIndexFlash: str = "jibun bank manufacturing purchasing managers index flash"
            """Jibun Bank Manufacturing PMI Flash"""

            JibunBankServicesPurchasingManagersIndex: str = "jibun bank services purchasing managers index"
            """Jibun Bank Services PMI"""

            JibunBankServicesPurchasingManagersIndexFinal: str = "jibun bank services purchasing managers index final"
            """Jibun Bank Services PMI Final"""

            JibunBankServicesPurchasingManagersIndexFlash: str = "jibun bank services purchasing managers index flash"
            """Jibun Bank Services PMI Flash"""

            JobsApplicationsRatio: str = "jobs applications ratio"
            """Jobs/applications ratio"""

            JpForeignReserves: str = "jp foreign reserves"
            """JP Foreign Reserves"""

            LaborThanksgivingDay: str = "labor thanksgiving day"
            """Labour Thanksgiving Day"""

            LargeRetailerSales: str = "large retailer sales"
            """Large Retailer Sales"""

            LargeRetailersSales: str = "large retailers sales"
            """Large Retailer's Sales"""

            LeadingCompositeIndexFinal: str = "leading composite index final"
            """Leading Composite Index Final"""

            LeadingCompositeIndexPreliminary: str = "leading composite index preliminary"
            """Leading Composite Index Prel"""

            LeadingEconomicIndex: str = "leading economic index"
            """Leading Economic Index"""

            LeadingEconomicIndexFinal: str = "leading economic index final"
            """Leading Economic Index Final"""

            LeadingEconomicIndexPreliminary: str = "leading economic index preliminary"
            """Leading Economic Index Prel"""

            MachineryOrdersMoM: str = "machinery orders mom"
            """Machinery Orders (MoM)"""

            MachineryOrdersYoY: str = "machinery orders yoy"
            """Machinery Orders (YoY)"""

            MachineToolOrdersYoY: str = "machine tool orders yoy"
            """Machine Tool Orders YoY"""

            ManufacturingPurchasingManagersIndex: str = "manufacturing purchasing managers index"
            """Manufacturing PMI"""

            MarkitJmmaManufacturingPurchasingManagersIndex: str = "markit jmma manufacturing purchasing managers index"
            """Markit/JMMA Manufacturing PMI"""

            MarkitJmmaManufacturingPurchasingManagersIndexFinal: str = "markit jmma manufacturing purchasing managers index final"
            """Markit/JMMA Manufacturing PMI Final"""

            MarkitJmmaManufacturingPurchasingManagersIndexFlash: str = "markit jmma manufacturing purchasing managers index flash"
            """Markit/JMMA Manufacturing PMI Flash"""

            MarkitNikkeiServicesPurchasingManagersIndex: str = "markit nikkei services purchasing managers index"
            """Nikkei Markit Services PMI"""

            MarkitServicesPurchasingManagersIndex: str = "markit services purchasing managers index"
            """Markit Services PMI"""

            MofAsakawaSpeech: str = "mof asakawa speech"
            """MOF Asakawa Speech"""

            MonetaryBaseYoY: str = "monetary base yoy"
            """Monetary Base (YoY)"""

            MoneySupplyMTwocdYoY: str = "money supply m2cd yoy"
            """Money Supply M2+CD (YoY)"""

            MountainDay: str = "mountain day"
            """Mountain Day"""

            NationalCoreInflationRateYoY: str = "national core inflation rate yoy"
            """National Core Inflation Rate YoY"""

            NationalFoundingDay: str = "national founding day"
            """National Founding Day"""

            NationalHoliday: str = "national holiday"
            """National Holiday"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NewYearssDay: str = "new yearss day"
            """New Years's Day"""

            NikkeiManufacturingPurchasingManagersIndexFinal: str = "nikkei manufacturing purchasing managers index final"
            """Nikkei Manufacturing PMI Final"""

            NikkeiManufacturingPurchasingManagersIndexFlash: str = "nikkei manufacturing purchasing managers index flash"
            """Nikkei Manufacturing PMI Flash"""

            NikkeiServicesPurchasingManagersIndex: str = "nikkei services purchasing managers index"
            """Nikkei Services PMI"""

            NomuraJmmaManufacturingPurchasingManagersIndex: str = "nomura jmma manufacturing purchasing managers index"
            """Nomura/JMMA Manufacturing PMI"""

            OceanDay: str = "ocean day"
            """Ocean Day"""

            OecdHeadAngelGurriaSpeech: str = "oecd head angel gurria speech"
            """OECD Head Angel Gurria Speech"""

            OverallHouseholdSpendingYoY: str = "overall household spending yoy"
            """Overall Household Spending YoY"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            PmShinzoAbeToDissolveParliament: str = "pm shinzo abe to dissolve parliament"
            """PM Shinzo Abe to Dissolve Parliament"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            RespectForTheAgedDay: str = "respect for the aged day"
            """Respect for the Aged Day"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            RetailTradeSeasonallyAdjustedMoM: str = "retail trade seasonally adjusted mom"
            """Retail Trade s.a (MoM)"""

            RetailTradeYoY: str = "retail trade yoy"
            """Retail Trade (YoY)"""

            ReutersTankanIndex: str = "reuters tankan index"
            """Reuters Tankan Index"""

            ShowaDay: str = "showa day"
            """Showa Day"""

            SpringEquinoxDay: str = "spring equinox day"
            """Spring Equinox Day"""

            StockInvestmentByForeigners: str = "stock investment by foreigners"
            """Stock Investment by Foreigners"""

            TankanAllLargeIndustryCapitalExpenditure: str = "tankan all large industry capital expenditure"
            """Tankan Large All Industry Capex"""

            TankanAllSmallIndustryCapitalExpenditure: str = "tankan all small industry capital expenditure"
            """Tankan All Small Industry CAPEX"""

            TankanLargeManufacturingIndex: str = "tankan large manufacturing index"
            """Tankan Large Manufacturers Index"""

            TankanLargeManufacturingOutlook: str = "tankan large manufacturing outlook"
            """Tankan Large Manufacturing Outlook"""

            TankanLargeNonManufacturingIndex: str = "tankan large non manufacturing index"
            """Tankan Large Non-Manufacturing Index"""

            TankanNonManufacturingIndex: str = "tankan non manufacturing index"
            """Tankan Non-Manufacturing Index"""

            TankanNonManufacturingOutlook: str = "tankan non manufacturing outlook"
            """Tankan Non-Manufacturing Outlook"""

            TankanSmallManufacturingIndex: str = "tankan small manufacturing index"
            """Tankan Small Manufacturers Index"""

            TankanSmallManufacturingOutlook: str = "tankan small manufacturing outlook"
            """Tankan Small Manufacturing Outlook"""

            TankanSmallNonManufacturingIndex: str = "tankan small non manufacturing index"
            """Tankan Small Non-Manufacturing Index"""

            TankanSmallNonManufacturingOutlook: str = "tankan small non manufacturing outlook"
            """Tankan Small Non-Manufacturing Outlook"""

            TenYearJgbAuction: str = "10 year jgb auction"
            """10-Year JGB Auction"""

            TertiaryIndustryIndexMoM: str = "tertiary industry index mom"
            """Tertiary Industry Index MoM"""

            TheEmperorsBirthday: str = "the emperors birthday"
            """The Emperor's Birthday"""

            ThirtyYearJgbAuction: str = "30 year jgb auction"
            """30-Year JGB Auction"""

            TokyoConsumerPriceIndexYoY: str = "tokyo consumer price index yoy"
            """Tokyo CPI YoY"""

            TokyoCoreConsumerPriceIndexYoY: str = "tokyo core consumer price index yoy"
            """Tokyo Core CPI YoY"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            UpperHouseElections: str = "upper house elections"
            """Upper House Elections"""

            UsJapanTradeTalks: str = "us japan trade talks"
            """US-Japan Trade Talks"""

            VehicleSalesYoY: str = "vehicle sales yoy"
            """Vehicle Sales (YoY)"""

            YutakaHaradaSpeech: str = "yutaka harada speech"
            """Yutaka Harada Speech"""

        class Latvia(System.Object):
            """Latvia"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BankHoliday: str = "bank holiday"
            """Bank Holiday"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ChristmasEve: str = "christmas eve"
            """Christmas Eve"""

            CurrentAccount: str = "current account"
            """Current Account"""

            DeclarationOfIndependence: str = "declaration of independence"
            """Declaration of Independence"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQFlash: str = "gdp growth rate qoq flash"
            """GDP Growth Rate QoQ Flash"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateQoQSecondEstimate: str = "gdp growth rate qoq second estimate"
            """GDP Growth Rate QoQ 2nd Est"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYFlash: str = "gdp growth rate yoy flash"
            """GDP Growth Rate YoY Flash"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY Prel"""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY 2nd Est"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            LaborDay: str = "labor day"
            """Labour Day"""

            MidsummerDay: str = "midsummer day"
            """Midsummer Day"""

            NationalDay: str = "national day"
            """National Day"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NewYearsEve: str = "new years eve"
            """New Year's Eve"""

            ProclemationOfTheRepublic: str = "proclemation of the republic"
            """Proclemation of The Republic"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            StJohnsDay: str = "st johns day"
            """St John's Day"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

        class Lithuania(System.Object):
            """Lithuania"""

            AllSaintsDay: str = "all saints day"
            """All Saint's Day"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ChristmasEve: str = "christmas eve"
            """Christmas Eve"""

            ChristmasHoliday: str = "christmas holiday"
            """Christmas Holiday"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            FathersDay: str = "fathers day"
            """Father’s Day"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ - F."""

            GdpGrowthRateQoQFlash: str = "gdp growth rate qoq flash"
            """GDP Growth Rate QoQ Flash"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateQoQSecondEstimate: str = "gdp growth rate qoq second estimate"
            """GDP Growth Rate QoQ 2nd Est"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY - F."""

            GdpGrowthRateYoYFlash: str = "gdp growth rate yoy flash"
            """GDP Growth Rate YoY Flash"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY Prel"""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY 2nd Est"""

            IndependenceDay: str = "independence day"
            """Independence Day"""

            IndependenceRestorationDay: str = "independence restoration day"
            """Independence Restoration Day"""

            IndustrialProduction: str = "industrial production"
            """Industrial Production"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            KingMindaugasCoronationDay: str = "king mindaugas coronation day"
            """King Mindaugas’ Coronation Day"""

            LaborDay: str = "labor day"
            """Labour Day"""

            MothersDay: str = "mothers day"
            """Mother’s Day"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            ParliamentaryElectionsSecondRound: str = "parliamentary elections second round"
            """Parliamentary Elections 2nd Round"""

            PresidentialElection: str = "presidential election"
            """Presidential Election"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            RestorationOfIndependenceDay: str = "restoration of independence day"
            """Restoration of Independence Day"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            SecondDayOfChristmas: str = "second day of christmas"
            """2nd Day of Christmas"""

            StJohnsDay: str = "st johns day"
            """St John's Day"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

        class Luxembourg(System.Object):
            """Luxembourg"""

            AllSaintsDay: str = "all saints day"
            """All Saint's Day"""

            AscensionDay: str = "ascension day"
            """Ascension Day"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ChristmasEve: str = "christmas eve"
            """Christmas Eve"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EuropeDay: str = "europe day"
            """Europe Day"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            LaborDay: str = "labor day"
            """Labour Day"""

            NationalDay: str = "national day"
            """National Day"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            StStephensDay: str = "st stephens day"
            """St Stephen's Day"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            WhitMonday: str = "whit monday"
            """Whit Monday"""

        class Malta(System.Object):
            """Malta"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            FeastOfOurLadyOfVictories: str = "feast of our lady of victories"
            """Feast of our Lady of Victories"""

            FeastOfStJoseph: str = "feast of st joseph"
            """Feast of St Joseph"""

            FeastOfStPaulsShipwreck: str = "feast of st pauls shipwreck"
            """Feast of St Paul's Shipwreck"""

            FeastOfStPeterAndStPaul: str = "feast of st peter and st paul"
            """Feast of St Peter and St Paul"""

            FreedomDay: str = "freedom day"
            """Freedom Day"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            ImmaculateConception: str = "immaculate conception"
            """Immaculate Conception"""

            IndependenceDay: str = "independence day"
            """Independence Day"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRate: str = "inflation rate"
            """Inflation Rate"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            LaborDay: str = "labor day"
            """Labour Day"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            RepublicDay: str = "republic day"
            """Republic Day"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            SetteGiugno: str = "sette giugno"
            """Sette Giugno"""

            StJosephsDay: str = "st josephs day"
            """St Joseph's Day"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

        class Netherlands(System.Object):
            """Netherlands"""

            AscensionDay: str = "ascension day"
            """Ascension Day"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            ConsumerSpendingVolume: str = "consumer spending volume"
            """Consumer Spending Volume"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQFlash: str = "gdp growth rate qoq flash"
            """GDP Growth Rate QoQ Flash"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateQoQSecondEstimate: str = "gdp growth rate qoq second estimate"
            """GDP Growth Rate QoQ 2nd Est"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYFlash: str = "gdp growth rate yoy flash"
            """GDP Growth Rate YoY Flash"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY Prel"""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY 2nd Est"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            HouseholdConsumptionYoY: str = "household consumption yoy"
            """Household Consumption YoY"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            KingsDay: str = "kings day"
            """King's Day"""

            LiberationDay: str = "liberation day"
            """Liberation Day"""

            LocalElections: str = "local elections"
            """Local Elections"""

            ManufacturingConfidence: str = "manufacturing confidence"
            """Manufacturing Confidence"""

            ManufacturingProductionYoY: str = "manufacturing production yoy"
            """Manufacturing Prod YoY"""

            NeviManufacturingPurchasingManagersIndex: str = "nevi manufacturing purchasing managers index"
            """NEVI Manufacturing PMI"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            Pentecost: str = "pentecost"
            """Pentecost"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            SixMonthBillAuction: str = "6 month bill auction"
            """6-Month Bill Auction"""

            TenYearBondAuction: str = "10 year bond auction"
            """10-Year Bond Auction"""

            ThreeMonthBillAuction: str = "3 month bill auction"
            """3-Month Bill Auction"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            WhitMonday: str = "whit monday"
            """Whit Monday"""

        class NewZealand(System.Object):
            """New Zealand"""

            AnzacDay: str = "anzac day"
            """ANZAC Day"""

            AnzBusinessConfidence: str = "anz business confidence"
            """ANZ Business Confidence"""

            AnzCommodityPrice: str = "anz commodity price"
            """ANZ Commodity Price"""

            AnzRoyMorganConsumerConfidence: str = "anz roy morgan consumer confidence"
            """ANZ Roy Morgan Consumer Confidence"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BuildingPermitsMoM: str = "building permits mom"
            """Building Permits MoM"""

            BuildingPermitsSeasonallyAdjustedMoM: str = "building permits seasonally adjusted mom"
            """Building Permits s.a. (MoM)"""

            BusinessInflationExpectations: str = "business inflation expectations"
            """Business Inflation Expectations"""

            BusinessNzPurchasingManagersIndex: str = "business nz purchasing managers index"
            """Business NZ PMI"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            CurrentAccount: str = "current account"
            """Current Account"""

            DayAfterNewYearsDay: str = "day after new years day"
            """Day After New Year's Day"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            ElectronicCardRetailSalesMoM: str = "electronic card retail sales mom"
            """Electronic Card Retail Sales  (MoM)"""

            ElectronicCardRetailSalesYoY: str = "electronic card retail sales yoy"
            """Electronic Card Retail Sales (YoY)"""

            ElectronicRetailCardSpendingMoM: str = "electronic retail card spending mom"
            """Electronic Retail Card Spending MoM"""

            ElectronicRetailCardSpendingYoY: str = "electronic retail card spending yoy"
            """Electronic Retail Card Spending YoY"""

            EmploymentChangeQoQ: str = "employment change qoq"
            """Employment Change QoQ"""

            ExportPricesQoQ: str = "export prices qoq"
            """Export Prices QoQ"""

            Exports: str = "exports"
            """Exports"""

            FinancialStabilityReport: str = "financial stability report"
            """Financial Stability Report"""

            FirstDayFlagReferendum: str = "first day flag referendum"
            """1st Day Flag Referendum"""

            FoodInflationYoY: str = "food inflation yoy"
            """Food Inflation YoY"""

            FoodPriceIndexMoM: str = "food price index mom"
            """Food Price Index (MoM)"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GeneralElections: str = "general elections"
            """General Elections"""

            GlobalDairyTradePriceIndex: str = "global dairy trade price index"
            """Global Dairy Trade Price Index"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            ImportPricesQoQ: str = "import prices qoq"
            """Import Prices QoQ"""

            Imports: str = "imports"
            """Imports"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateQoQ: str = "inflation rate qoq"
            """Inflation Rate QoQ"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InterestRateDecision: str = "interest rate decision"
            """Interest Rate Decision"""

            LaborCostsIndexQoQ: str = "labor costs index qoq"
            """Labour cost index QoQ"""

            LaborCostsIndexYoY: str = "labor costs index yoy"
            """Labour cost index YoY"""

            LaborDay: str = "labor day"
            """Labour Day"""

            LastDayFlagReferendum: str = "last day flag referendum"
            """Last Day Flag Referendum"""

            ManufacturingProductionYoY: str = "manufacturing production yoy"
            """Manufacturing Production YoY"""

            ManufacturingSales: str = "manufacturing sales"
            """Manufacturing sales"""

            ManufacturingSalesYoY: str = "manufacturing sales yoy"
            """Manufacturing Sales YoY"""

            MarkitBusinessNzPurchasingManagersIndex: str = "markit business nz purchasing managers index"
            """Business NZ/Markit PMI"""

            MonetaryPolicyStatement: str = "monetary policy statement"
            """Monetary Policy Statement"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NzierBusinessConfidence: str = "nzier business confidence"
            """NZIER Business Confidence"""

            NzierBusinessConfidenceQoQ: str = "nzier business confidence qoq"
            """NZIER Business Confidence QoQ"""

            NzierCapacityUtilization: str = "nzier capacity utilization"
            """NZIER Capacity Utilization"""

            NzierQsboCapacityUtilization: str = "nzier qsbo capacity utilization"
            """NZIER QSBO Capacity Utilization"""

            ParticipationRate: str = "participation rate"
            """Participation Rate"""

            ProducerPriceIndexInputQoQ: str = "producer price index input qoq"
            """PPI Input QoQ"""

            ProducerPriceIndexOutputQoQ: str = "producer price index output qoq"
            """PPI Output QoQ"""

            QueensBirthdayDay: str = "queens birthday day"
            """Queen's Birthday Day"""

            RbnzEconomicAssesment: str = "rbnz economic assesment"
            """RBNZ Economic Assesment"""

            RbnzFinancialStabilityReport: str = "rbnz financial stability report"
            """RBNZ Financial Stability Report"""

            RbnzGovOrrSpeech: str = "rbnz gov orr speech"
            """RBNZ Gov Orr Speech"""

            RbnzGovWheelerSpeech: str = "rbnz gov wheeler speech"
            """RBNZ Gov Wheeler Speech"""

            RbnzInflationExpectationsYoY: str = "rbnz inflation expectations yoy"
            """RBNZ Inflation Expectations (YoY)"""

            RbnzMcdermottSpeech: str = "rbnz mcdermott speech"
            """RBNZ McDermott Speech"""

            RbnzPressConference: str = "rbnz press conference"
            """RBNZ Press Conference"""

            RbnzWheelerSpeech: str = "rbnz wheeler speech"
            """RBNZ Wheeler Speech"""

            ReinzHousePriceIndexMoM: str = "reinz house price index mom"
            """REINZ House Price Index MoM"""

            RetailSalesQoQ: str = "retail sales qoq"
            """Retail Sales QoQ"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            ServicesNzPerformanceOfServicesIndex: str = "services nz performance of services index"
            """Services NZ PSI"""

            TermsOfTradeQoQ: str = "terms of trade qoq"
            """Terms of Trade QoQ"""

            TradeBalanceMoM: str = "trade balance mom"
            """Trade Balance (MoM)"""

            TradeBalanceYoY: str = "trade balance yoy"
            """Trade Balance (YoY)"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            VisitorArrivalsMoM: str = "visitor arrivals mom"
            """Visitor Arrivals MoM"""

            VisitorArrivalsYoY: str = "visitor arrivals yoy"
            """Visitor Arrivals (YoY)"""

            WaitangiDay: str = "waitangi day"
            """Waitangi Day"""

            WestpacConsumerConfidence: str = "westpac consumer confidence"
            """Consumer Confidence WESTPAC"""

            WestpacConsumerSurvey: str = "westpac consumer survey"
            """Westpac consumer survey"""

        class Portugal(System.Object):
            """Portugal"""

            AllSaintsDay: str = "all saints day"
            """All Saints' Day"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BdpGovCostaSpeech: str = "bdp gov costa speech"
            """BdP Gov Costa Speech"""

            BudgetBalance: str = "budget balance"
            """Budget Balance"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CorpusChristi: str = "corpus christi"
            """Corpus Christi"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            EcbForumOnCentralBanking: str = "ecb forum on central banking"
            """ECB Forum on Central Banking"""

            EconomicActivityYoY: str = "economic activity yoy"
            """Economic Activity YoY"""

            Exports: str = "exports"
            """Exports"""

            GdpAnnualGrowthRateYoY: str = "gdp annual growth rate yoy"
            """GDP Annual Growth Rate YoY"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateQoQSecondEstimate: str = "gdp growth rate qoq second estimate"
            """GDP Growth Rate QoQ 2nd Est"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY Prel"""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY 2nd Est"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            ImmaculateConception: str = "immaculate conception"
            """Immaculate Conception"""

            Imports: str = "imports"
            """Imports"""

            IndustrialProduction: str = "industrial production"
            """Industrial Production"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateMoMFinal: str = "inflation rate mom final"
            """Inflation Rate MoM Final"""

            InflationRateMoMPreliminary: str = "inflation rate mom preliminary"
            """Inflation Rate MoM Prel"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InflationRateYoYFinal: str = "inflation rate yoy final"
            """Inflation Rate YoY Final"""

            InflationRateYoYPreliminary: str = "inflation rate yoy preliminary"
            """Inflation Rate YoY Prel"""

            LaborDay: str = "labor day"
            """Labour Day"""

            LibertyDay: str = "liberty day"
            """Liberty Day"""

            NationalDay: str = "national day"
            """National Day"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            PrivateConsumptionYoY: str = "private consumption yoy"
            """Private Consumption YoY"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            RepublicImplantation: str = "republic implantation"
            """Republic Implantation"""

            RestorationOfIndependence: str = "restoration of independence"
            """Restoration of Independence"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

        class Slovakia(System.Object):
            """Slovakia"""

            AllSaintsDay: str = "all saints day"
            """All Saint's Day"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ChristmasEve: str = "christmas eve"
            """Christmas Eve"""

            ConstitutionDay: str = "constitution day"
            """Constitution Day"""

            ConstructionOutputYoY: str = "construction output yoy"
            """Construction Output YoY"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CoreInflationRateMoM: str = "core inflation rate mom"
            """Core Inflation Rate MoM"""

            CoreInflationRateYoY: str = "core inflation rate yoy"
            """Core Inflation Rate YoY"""

            CurrentAccount: str = "current account"
            """Current Account"""

            DayOfOurLadyOfSorrows: str = "day of our lady of sorrows"
            """Day of Our Lady of Sorrows"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EndOfWorldWarIi: str = "end of world war ii"
            """End of World War II"""

            Epiphany: str = "epiphany"
            """Epiphany"""

            EpiphanyDay: str = "epiphany day"
            """Epiphany Day"""

            EstablishmentOfTheSlovakRepublic: str = "establishment of the slovak republic"
            """Establishment of the Slovak Republic"""

            EuropeanCouncilMeeting: str = "european council meeting"
            """European Council Meeting"""

            Exports: str = "exports"
            """Exports"""

            FinanceMinistryEconomicForecasts: str = "finance ministry economic forecasts"
            """Finance Ministry Economic Forecasts"""

            GdpAnnualGrowthRateYoY: str = "gdp annual growth rate yoy"
            """GDP Annual Growth Rate YoY"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQFlash: str = "gdp growth rate qoq flash"
            """GDP Growth Rate QoQ Flash"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateQoQSecondEstimate: str = "gdp growth rate qoq second estimate"
            """GDP Growth Rate QoQ 2nd Est"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYFlash: str = "gdp growth rate yoy flash"
            """GDP Growth Rate YoY Flash"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY Prel"""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY 2nd Est"""

            GdpGrowthRateYoYSecondFinal: str = "gdp growth rate yoy second final"
            """GDP Growth Rate YoY 2nd Final"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            HarmonizedInflationRateMoM: str = "harmonized inflation rate mom"
            """Harmonised Inflation Rate MoM"""

            HarmonizedInflationRateYoY: str = "harmonized inflation rate yoy"
            """Harmonised Inflation Rate YoY"""

            Imports: str = "imports"
            """Imports"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InformalEcofinMeeting: str = "informal ecofin meeting"
            """Informal Ecofin Meeting"""

            LaborDay: str = "labor day"
            """Labour Day"""

            NationalUprisingDay: str = "national uprising day"
            """National Uprising Day"""

            NbsGovMakuchSpeech: str = "nbs gov makuch speech"
            """NBS Gov Makuch Speech"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            PresidentialElection: str = "presidential election"
            """Presidential Election"""

            RealWagesYoY: str = "real wages yoy"
            """Real Wages YoY"""

            RepublicDay: str = "republic day"
            """Republic Day"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            StCyrilAndMethodiusDay: str = "st cyril and methodius day"
            """St Cyril and Methodius Day"""

            StruggleForFreedomAndDemocracyDay: str = "struggle for freedom and democracy day"
            """Struggle for Freedom and Democracy Day"""

            StStephensDay: str = "st stephens day"
            """St Stephen's Day"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

        class Slovenia(System.Object):
            """Slovenia"""

            AllSaintsDay: str = "all saints day"
            """All Saint's Day"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BosFesticSpeech: str = "bos festic speech"
            """BoS Festic Speech"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            DayOfUprisingAgainstOccupation: str = "day of uprising against occupation"
            """Day of Uprising Against Occupation"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            FinanceMinisterMramorSpeech: str = "finance minister mramor speech"
            """Finance Minister Mramor Speech"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            HarmonizedInflationRateYoY: str = "harmonized inflation rate yoy"
            """Harmonised Inflation Rate YoY"""

            IndependenceAndUnitDay: str = "independence and unit day"
            """Independence and Unit Day"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            LaborDay: str = "labor day"
            """Labour Day"""

            LaborDaySubstituteDay: str = "labor day substitute day"
            """Labour Day (Substitute Day)"""

            MayDay: str = "may day"
            """May Day"""

            MayDayHoliday: str = "may day holiday"
            """May Day Holiday"""

            NationalDay: str = "national day"
            """National Day"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NewYearsHoliday: str = "new years holiday"
            """New Year's Holiday"""

            Pentecost: str = "pentecost"
            """Pentecost"""

            PreerenDay: str = "preeren day"
            """Prešeren Day"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            ReformationDay: str = "reformation day"
            """Reformation Day"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            RethinkingMonetaryFiscalPolicyCoordinationSeminar: str = "rethinking monetary fiscal policy coordination seminar"
            """Rethinking Monetary-Fiscal Policy Coordination Seminar"""

            TouristArrivalsYoY: str = "tourist arrivals yoy"
            """Tourist Arrivals YoY"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            UprisingAgainstTheOccupationDay: str = "uprising against the occupation day"
            """Uprising Against the Occupation Day"""

        class Spain(System.Object):
            """Spain"""

            AllSaintsDay: str = "all saints day"
            """All Saints' Day"""

            AssumptionOfMary: str = "assumption of mary"
            """Assumption of Mary"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BdeGovLindeSpeech: str = "bde gov linde speech"
            """BdE Gov Linde Speech"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            CatalonianParlimentaryElections: str = "catalonian parlimentary elections"
            """Catalonian Parlimentary Elections"""

            CataloniaParliamentaryElection: str = "catalonia parliamentary election"
            """Catalonia Parliamentary Election"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConstitutionDay: str = "constitution day"
            """Constitution Day"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CurrentAccount: str = "current account"
            """Current Account"""

            Epiphany: str = "epiphany"
            """Epiphany"""

            EpiphanyHoliday: str = "epiphany holiday"
            """Epiphany Holiday"""

            FinanceMinisterGuindosSpeech: str = "finance minister guindos speech"
            """Finance Minister Guindos Speech"""

            FiveYearBonosAuction: str = "5 year bonos auction"
            """5-Year Bonos Auction"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQFlash: str = "gdp growth rate qoq flash"
            """GDP Growth Rate QoQ Flash"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYFlash: str = "gdp growth rate yoy flash"
            """GDP Growth Rate YoY Flash"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY Prel"""

            GeneralElection: str = "general election"
            """General Election"""

            GeneralElections: str = "general elections"
            """General Elections"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            HarmonizedInflationRateMoMFinal: str = "harmonized inflation rate mom final"
            """Harmonised Inflation Rate MoM Final"""

            HarmonizedInflationRateMoMPreliminary: str = "harmonized inflation rate mom preliminary"
            """Harmonised Inflation Rate MoM Prel"""

            HarmonizedInflationRateYoYFinal: str = "harmonized inflation rate yoy final"
            """Harmonised Inflation Rate YoY Final"""

            HarmonizedInflationRateYoYPreliminary: str = "harmonized inflation rate yoy preliminary"
            """Harmonised Inflation Rate YoY Prel"""

            HispanicDay: str = "hispanic day"
            """Hispanic Day"""

            IifSpringMembershipMeetingTwoThousandSixteen: str = "iif spring membership meeting 2016"
            """IIF Spring Membership Meeting 2016"""

            ImmaculateConception: str = "immaculate conception"
            """Immaculate Conception"""

            IndustrialOrdersYoY: str = "industrial orders yoy"
            """Industrial Orders YoY"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateMoMFinal: str = "inflation rate mom final"
            """Inflation Rate MoM Final"""

            InflationRateMoMPreliminary: str = "inflation rate mom preliminary"
            """Inflation Rate MoM Prel"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InflationRateYoYFinal: str = "inflation rate yoy final"
            """Inflation Rate YoY Final"""

            InflationRateYoYPreliminary: str = "inflation rate yoy preliminary"
            """Inflation Rate YoY Prel"""

            LaborDay: str = "labor day"
            """Labour Day"""

            LaborDaySubstituteDay: str = "labor day substitute day"
            """Labour Day (Substitute Day)"""

            MarkitManufacturingPurchasingManagersIndex: str = "markit manufacturing purchasing managers index"
            """Markit Manufacturing PMI"""

            MarkitServicesPurchasingManagersIndex: str = "markit services purchasing managers index"
            """Markit Services PMI"""

            MaundyThursday: str = "maundy thursday"
            """Maundy Thursday"""

            NationalDay: str = "national day"
            """National Day"""

            NewCarSalesYoY: str = "new car sales yoy"
            """New Car Sales YoY"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NewYearsDaySubstituteDay: str = "new years day substitute day"
            """New Year's Day (Substitute Day)"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            ParliamentaryVoteOnTwoThousandNineteenBudget: str = "parliamentary vote on 2019 budget"
            """Parliamentary Vote on 2019 Budget"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            ServicesPurchasingManagersIndex: str = "services purchasing managers index"
            """Services PMI"""

            SixMonthLetrasAuction: str = "6 month letras auction"
            """6-Month Letras Auction"""

            StJosephsDay: str = "st josephs day"
            """St. Joseph's Day"""

            TenYearObligacionAuction: str = "10 year obligacion auction"
            """10-Year Obligacion Auction"""

            ThreeMonthLetrasAuction: str = "3 month letras auction"
            """3-Month Letras Auction"""

            ThreeYearBonosAuction: str = "3 year bonos auction"
            """3-Year Bonos Auction"""

            TouristArrivalsYoY: str = "tourist arrivals yoy"
            """Tourist Arrivals YoY"""

            TwelveMonthLetrasAuction: str = "12 month letras auction"
            """12-Month Letras Auction"""

            UnemploymentChange: str = "unemployment change"
            """Unemployment Change"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

        class Sweden(System.Object):
            """Sweden"""

            AllSaintsDay: str = "all saints day"
            """All Saint's Day"""

            AscensionDay: str = "ascension day"
            """Ascension Day"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            CapacityUtilizationQoQ: str = "capacity utilization qoq"
            """Capacity Utilization QoQ"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ChristmasEve: str = "christmas eve"
            """Christmas Eve"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            ConsumerInflationExpectations: str = "consumer inflation expectations"
            """Consumer Inflation Expectations"""

            ConsumerPriceIndexFixedInterestRateMoM: str = "consumer price index fixed interest rate mom"
            """CPIF MoM"""

            ConsumerPriceIndexFixedInterestRateYoY: str = "consumer price index fixed interest rate yoy"
            """CPIF YoY"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterEve: str = "easter eve"
            """Easter Eve"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EasterSunday: str = "easter sunday"
            """Easter Sunday"""

            Epiphany: str = "epiphany"
            """Epiphany"""

            EpiphanyDay: str = "epiphany day"
            """Epiphany Day"""

            FinancialStabilityReportTwoThousandEighteen: str = "financial stability report 2018"
            """Financial Stability Report 2018"""

            FinancialStabilityReportTwoThousandSeventeen: str = "financial stability report 2017"
            """Financial Stability Report 2017"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQFlash: str = "gdp growth rate qoq flash"
            """GDP Growth Rate QoQ Flash"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYFlash: str = "gdp growth rate yoy flash"
            """GDP Growth Rate YoY Flash"""

            GeneralElections: str = "general elections"
            """General Elections"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            HouseholdConsumptionMoM: str = "household consumption mom"
            """Household Consumption MM"""

            HouseholdLendingGrowthYoY: str = "household lending growth yoy"
            """Household Lending Growth YoY"""

            IndustrialInventoriesQoQ: str = "industrial inventories qoq"
            """Industrial Inventories QoQ"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            LaborDay: str = "labor day"
            """Labour Day"""

            LendingToHouseholdsYoY: str = "lending to households yoy"
            """Lending to Households YoY"""

            MarkitServicesPurchasingManagersIndex: str = "markit services purchasing managers index"
            """Markit Services PMI"""

            MidsummerDay: str = "midsummer day"
            """Midsummer Day"""

            MidsummerEve: str = "midsummer eve"
            """Midsummer Eve"""

            MonetaryPolicyMeetingMinutes: str = "monetary policy meeting minutes"
            """Monetary Policy Meeting Minutes"""

            MonetaryPolicyReport: str = "monetary policy report"
            """Monetary Policy Report"""

            NationalDay: str = "national day"
            """National Day"""

            NewOrders: str = "new orders"
            """New Orders"""

            NewOrdersYoY: str = "new orders yoy"
            """New Orders Manufacturing YoY"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NewYearsEve: str = "new years eve"
            """New Year's Eve"""

            Pentecost: str = "pentecost"
            """Pentecost"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            PurchasingManagersIndexServices: str = "purchasing managers index services"
            """PMI Services"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            RiksbankGovIngvesSpeech: str = "riksbank gov ingves speech"
            """Riksbank Gov Ingves Speech"""

            RiksbankIngvesSpeaksBeforeParliament: str = "riksbank ingves speaks before parliament"
            """Riksbank Ingves Speaks before Parliament"""

            RiksbankIngvesSpeech: str = "riksbank ingves speech"
            """Riksbank Ingves Speech"""

            RiksbankInterestRate: str = "riksbank interest rate"
            """Riksbank Interest Rate"""

            RiksbankMeetingMinutes: str = "riksbank meeting minutes"
            """Riksbank Meeting Minutes"""

            RiksbankMonetaryPolicyReport: str = "riksbank monetary policy report"
            """Riksbank Monetary Policy Report"""

            RiksbankRateDecision: str = "riksbank rate decision"
            """Riksbank Rate Decision"""

            RiksbankSkingsleySpeech: str = "riksbank skingsley speech"
            """Riksbank Skingsley Speech"""

            ServicesPurchasingManagersIndex: str = "services purchasing managers index"
            """Services PMI"""

            SwedbankManufacturingPurchasingManagersIndex: str = "swedbank manufacturing purchasing managers index"
            """Swedbank Manufacturing PMI"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            Whitsun: str = "whitsun"
            """Whitsun"""

        class Switzerland(System.Object):
            """Switzerland"""

            AscensionDay: str = "ascension day"
            """Ascension Day"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EconomicSentimentIndex: str = "economic sentiment index"
            """Economic Sentiment Index"""

            EmploymentLevelQoQ: str = "employment level qoq"
            """Employment Level (QoQ)"""

            FederalFastDay: str = "federal fast day"
            """Federal Fast Day"""

            ForeignCurrencyReserves: str = "foreign currency reserves"
            """Foreign Currency Reserves"""

            ForeignExchangeReserves: str = "foreign exchange reserves"
            """Foreign Exchange Reserves"""

            FxReserves: str = "fx reserves"
            """FX Reserves"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            IndustrialOrdersYoY: str = "industrial orders yoy"
            """Industrial Orders YoY"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            KofLeadingIndicators: str = "kof leading indicators"
            """KOF Leading Indicator"""

            LaborDay: str = "labor day"
            """Labour Day"""

            NationalDay: str = "national day"
            """National Day"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NonFarmPayrolls: str = "non farm payrolls"
            """Non Farm Payrolls"""

            NuclearWithdrawalInitiativeReferendum: str = "nuclear withdrawal initiative referendum"
            """Nuclear Withdrawal Initiative Referendum"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            ProcurechManufacturingPurchasingManagersIndex: str = "procurech manufacturing purchasing managers index"
            """procure.ch Manufacturing PMI"""

            ProducerAndImportPricesMoM: str = "producer and import prices mom"
            """Producer and Import Prices MoM"""

            ProducerAndImportPricesYoY: str = "producer and import prices yoy"
            """Producer and Import Prices YoY"""

            ProducerImportPricesMoM: str = "producer import prices mom"
            """Producer/Import Prices MoM"""

            ProducerImportPricesYoY: str = "producer import prices yoy"
            """Producer/Import Prices YoY"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            ReferendumOnCorporateTaxUnification: str = "referendum on corporate tax unification"
            """Referendum on Corporate Tax Unification"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            SecoEconomicForecasts: str = "seco economic forecasts"
            """SECO Economic Forecasts"""

            SnbAnnualReport: str = "snb annual report"
            """SNB Annual Report"""

            SnbChairJordanSpeaks: str = "snb chair jordan speaks"
            """SNB Chair Jordan Speaks"""

            SnbChairJordanSpeech: str = "snb chair jordan speech"
            """SNB Chair Jordan Speech"""

            SnbChairmanJordanSpeech: str = "snb chairman jordan speech"
            """SNB Chairman Jordan Speech"""

            SnbFinancialStabilityReport: str = "snb financial stability report"
            """SNB Financial Stability Report"""

            SnbInterestRateDecison: str = "snb interest rate decison"
            """SNB Interest Rate Decison"""

            SnbJordanSpeech: str = "snb jordan speech"
            """SNB Jordan Speech"""

            SnbMaechlerSpeech: str = "snb maechler speech"
            """SNB Maechler Speech"""

            SnbMonthlyBulletin: str = "snb monthly bulletin"
            """SNB Monthly Bulletin"""

            SnbMoserSpeech: str = "snb moser speech"
            """SNB Moser Speech"""

            SnbPresidentStuderSpeech: str = "snb president studer speech"
            """SNB President Studer Speech"""

            SnbPressConference: str = "snb press conference"
            """SNB press conference"""

            SnbQuarterlyBulletin: str = "snb quarterly bulletin"
            """SNB Quarterly Bulletin"""

            SnbStuderSpeech: str = "snb studer speech"
            """SNB Studer Speech"""

            SnbZurbrggSpeech: str = "snb zurbrgg speech"
            """SNB Zurbrügg Speech"""

            SnbZurbrueggSpeech: str = "snb zurbruegg speech"
            """SNB Zurbruegg Speech"""

            StBerchtold: str = "st berchtold"
            """St. Berchtold"""

            StStephensDay: str = "st stephens day"
            """St Stephen's Day"""

            SvmeManufacturingPurchasingManagersIndex: str = "svme manufacturing purchasing managers index"
            """SVME - Purchasing Managers Index"""

            SvmePurchasingManagersIndex: str = "svme manufacturing purchasing managers index"
            """SVME - Purchasing Managers  Index"""

            UbsConsumptionIndicators: str = "ubs consumption indicators"
            """UBS Consumption Indicator"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            UsdConsumptionIndicators: str = "usd consumption indicators"
            """USD Consumption Indicator"""

            UsPresidentTrumpSpeech: str = "us president trump speech"
            """US President Trump Speech"""

            WhitMonday: str = "whit monday"
            """Whit Monday"""

            WorldEconomicForumAnnualMeeting: str = "world economic forum annual meeting"
            """World Economic Forum Annual Meeting"""

            WorldEconomicForumDavos: str = "world economic forum davos"
            """World Economic Forum - Davos"""

            ZewEconomicSentimentIndex: str = "zew economic sentiment index"
            """ZEW Economic Sentiment Index"""

            ZewExpectations: str = "zew expectations"
            """ZEW Expectations"""

            ZewInvestorSentiment: str = "zew investor sentiment"
            """ZEW investor sentiment"""

            ZewSurveyExpectations: str = "zew survey expectations"
            """ZEW Survey - Expectations"""

        class UnitedKingdom(System.Object):
            """United Kingdom"""

            ArticleFiftyBrexitProcessStarts: str = "article 50 brexit process starts"
            """Article 50 Brexit Process Starts"""

            AutumnBudget: str = "autumn budget"
            """Autumn Budget"""

            AutumnBudgetTwoThousandEighteen: str = "autumn budget 2018"
            """Autumn Budget 2018"""

            AverageEarningsExcludingBonus: str = "average earnings excluding bonus"
            """Average Earnings excl. Bonus"""

            AverageEarningsIncludingBonus: str = "average earnings including bonus"
            """Average Earnings incl. Bonus"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BankHoliday: str = "bank holiday"
            """Bank Holiday"""

            BankOfEnglandAssetPurchaseFacility: str = "bank of england asset purchase facility"
            """BoE Asset Purchase Facility"""

            BankOfEnglandBaileySpeech: str = "bank of england bailey speech"
            """BoE Bailey Speech"""

            BankOfEnglandBrazierSpeech: str = "bank of england brazier speech"
            """BoE Brazier Speech"""

            BankOfEnglandBreedenSpeech: str = "bank of england breeden speech"
            """BoE Breeden Speech"""

            BankOfEnglandBroadbentSpeech: str = "bank of england broadbent speech"
            """BoE Broadbent Speech"""

            BankOfEnglandCarneySpeaks: str = "bank of england carney speaks"
            """BoE Carney Speaks"""

            BankOfEnglandCarneySpeaksInParliamentOnBrexit: str = "bank of england carney speaks in parliament on brexit"
            """BoE Carney Speaks in Parliament on Brexit"""

            BankOfEnglandCarneySpeech: str = "bank of england carney speech"
            """BoE Carney Speech"""

            BankOfEnglandChiefEconomistHaldaneSpeech: str = "bank of england chief economist haldane speech"
            """BoE Chief Economist Haldane Speech"""

            BankOfEnglandChurmSpeech: str = "bank of england churm speech"
            """BoE Churm Speech"""

            BankOfEnglandClelandSpeech: str = "bank of england cleland speech"
            """BoE Cleland Speech"""

            BankOfEnglandConsumerCredit: str = "bank of england consumer credit"
            """BoE Consumer Credit"""

            BankOfEnglandCreditConditionsSurvey: str = "bank of england credit conditions survey"
            """BOE Credit Conditions Survey"""

            BankOfEnglandCunliffeSpeech: str = "bank of england cunliffe speech"
            """BoE Cunliffe Speech"""

            BankOfEnglandDeputyGovBaileySpeech: str = "bank of england deputy gov bailey speech"
            """BoE Deputy Gov Bailey Speech"""

            BankOfEnglandDeputyGovBroadbentSpeech: str = "bank of england deputy gov broadbent speech"
            """BoE Deputy Gov Broadbent Speech"""

            BankOfEnglandDeputyGovCunliffeSpeech: str = "bank of england deputy gov cunliffe speech"
            """BoE Deputy Gov Cunliffe Speech"""

            BankOfEnglandDeputyGovWoodsSpeech: str = "bank of england deputy gov woods speech"
            """BoE Deputy Gov Woods Speech"""

            BankOfEnglandFinancialStabilityReport: str = "bank of england financial stability report"
            """BoE Financial Stability Report"""

            BankOfEnglandForbesSpeech: str = "bank of england forbes speech"
            """BoE Forbes Speech"""

            BankOfEnglandFpcMeeting: str = "bank of england fpc meeting"
            """BoE FPC Meeting"""

            BankOfEnglandFpcMinutes: str = "bank of england fpc minutes"
            """BoE FPC Minutes"""

            BankOfEnglandFpcRecord: str = "bank of england fpc record"
            """BoE FPC Record"""

            BankOfEnglandFpcStatement: str = "bank of england fpc statement"
            """BoE FPC Statement"""

            BankOfEnglandGovCarneySpeech: str = "bank of england gov carney speech"
            """BoE Gov Carney Speech"""

            BankOfEnglandGovernorKingSpeech: str = "bank of england governor king speech"
            """BoE Governor King Speech"""

            BankOfEnglandHaldaneSpeech: str = "bank of england haldane speech"
            """BoE Haldane Speech"""

            BankOfEnglandHaskelSpeech: str = "bank of england haskel speech"
            """BoE Haskel Speech"""

            BankOfEnglandHauserSpeech: str = "bank of england hauser speech"
            """BoE Hauser Speech"""

            BankOfEnglandHoggSpeech: str = "bank of england hogg speech"
            """BoE Hogg Speech"""

            BankOfEnglandInflationReport: str = "bank of england inflation report"
            """BoE Inflation Report"""

            BankOfEnglandInflationReportHearings: str = "bank of england inflation report hearings"
            """BoE Inflation Report Hearings"""

            BankOfEnglandInterestRateDecision: str = "bank of england interest rate decision"
            """BoE Interest Rate Decision"""

            BankOfEnglandKohnSpeech: str = "bank of england kohn speech"
            """BoE Kohn Speech"""

            BankOfEnglandMccaffertySpeech: str = "bank of england mccafferty speech"
            """BoE McCafferty Speech"""

            BankOfEnglandMoulderSpeech: str = "bank of england moulder speech"
            """BoE Moulder Speech"""

            BankOfEnglandMpcVoteCut: str = "bank of england mpc vote cut"
            """BoE MPC Vote Cut"""

            BankOfEnglandMpcVoteHike: str = "bank of england mpc vote hike"
            """BoE MPC Vote Hike"""

            BankOfEnglandMpcVoteUnchanged: str = "bank of england mpc vote unchanged"
            """BoE MPC Vote Unchanged"""

            BankOfEnglandPressConference: str = "bank of england press conference"
            """BoE Press Conference"""

            BankOfEnglandProudmanSpeech: str = "bank of england proudman speech"
            """BoE Proudman Speech"""

            BankOfEnglandQuantitativeEasing: str = "bank of england quantitative easing"
            """BOE Quantitative Easing"""

            BankOfEnglandQuarterlyBulletin: str = "bank of england quarterly bulletin"
            """BoE Quarterly Bulletin"""

            BankOfEnglandQuarterlyBulletinQTwo: str = "bank of england quarterly bulletin q2"
            """BoE Quarterly Bulletin Q2"""

            BankOfEnglandQuarterlyInflationReport: str = "bank of england quarterly inflation report"
            """Bank of England Quarterly Inflation Report"""

            BankOfEnglandRamsdenSpeech: str = "bank of england ramsden speech"
            """BoE Ramsden Speech"""

            BankOfEnglandReportOnEuWithdrawalScenarios: str = "bank of england report on eu withdrawal scenarios"
            """BoE Report on EU Withdrawal Scenarios"""

            BankOfEnglandRuleSpeech: str = "bank of england rule speech"
            """BoE Rule Speech"""

            BankOfEnglandSalmonSpeech: str = "bank of england salmon speech"
            """BoE Salmon Speech"""

            BankOfEnglandSaportaSpeech: str = "bank of england saporta speech"
            """BoE Saporta Speech"""

            BankOfEnglandSaundersSpeech: str = "bank of england saunders speech"
            """BoE Saunders Speech"""

            BankOfEnglandShafikSpeech: str = "bank of england shafik speech"
            """BoE Shafik Speech"""

            BankOfEnglandSharpSpeech: str = "bank of england sharp speech"
            """BoE Sharp Speech"""

            BankOfEnglandStressTestResults: str = "bank of england stress test results"
            """BoE Stress Test Results"""

            BankOfEnglandSystemicRiskSurveyResults: str = "bank of england systemic risk survey results"
            """BoE Systemic Risk Survey Results"""

            BankOfEnglandTenreyroSpeech: str = "bank of england tenreyro speech"
            """BoE Tenreyro Speech"""

            BankOfEnglandVliegheSpeech: str = "bank of england vlieghe speech"
            """BoE Vlieghe Speech"""

            BankOfEnglandWealeSpeech: str = "bank of england weale speech"
            """BoE Weale Speech"""

            BankOfEnglandWoodsSpeech: str = "bank of england woods speech"
            """BoE Woods Speech"""

            BankStressTests: str = "bank stress tests"
            """Bank Stress Tests"""

            BbaMortgageApprovals: str = "bba mortgage approvals"
            """BBA Mortgage Approvals"""

            BccQuarterlyEconomicSurvey: str = "bcc quarterly economic survey"
            """BCC Quarterly Economic Survey"""

            BennBillDebate: str = "benn bill debate"
            """Benn Bill Debate"""

            BoesCarneyAndCunliffeSpeakInParliament: str = "boes carney and cunliffe speak in parliament"
            """BoE's Carney and Cunliffe Speak in Parliament"""

            BoesGovCarneySpeech: str = "boes gov carney speech"
            """BOE's Gov Carney speech"""

            BoesGovernorCarneySpeaks: str = "boes governor carney speaks"
            """BoE's Governor Carney Speaks"""

            BoesGovernorCarneySpeaksAtParliament: str = "boes governor carney speaks at parliament"
            """BoE's Governor Carney Speaks at Parliament"""

            BoesGovernorCarneySpeech: str = "boes governor carney speech"
            """BOE's Governor Carney Speech"""

            BoesGovernorKingSpeech: str = "boes governor king speech"
            """BoEs Governor King Speech"""

            BoxingDay: str = "boxing day"
            """Boxing Day"""

            BrcRetailSalesYoY: str = "brc retail sales yoy"
            """BRC Retail Sales Monitor - All (YoY)"""

            BrcShopPriceIndexMoM: str = "brc shop price index mom"
            """BRC Shop Price Index (MoM)"""

            BrcShopPriceIndexYoY: str = "brc shop price index yoy"
            """BRC Shop Price Index YoY"""

            BrexitBillDebate: str = "brexit bill debate"
            """Brexit Bill Debate"""

            BudgetReport: str = "budget report"
            """Budget Report"""

            BusinessConfidence: str = "business confidence"
            """Business Confidence"""

            BusinessInvestmentQoQ: str = "business investment qoq"
            """Business Investment QoQ"""

            BusinessInvestmentQoQFinal: str = "business investment qoq final"
            """Business Investment QoQ Final"""

            BusinessInvestmentQoQPreliminary: str = "business investment qoq preliminary"
            """Business Investment QoQ Prel"""

            BusinessInvestmentYoY: str = "business investment yoy"
            """Business Investment YoY"""

            BusinessInvestmentYoYFinal: str = "business investment yoy final"
            """Business Investment YoY Final"""

            BusinessInvestmentYoYPreliminary: str = "business investment yoy preliminary"
            """Business Investment YoY Prel"""

            CabinetMeetingOnBrexitDraftDeal: str = "cabinet meeting on brexit draft deal"
            """Cabinet Meeting on Brexit Draft Deal"""

            CbiBusinessOptimismIndex: str = "cbi business optimism index"
            """CBI Business Optimism Index"""

            CbiDistributiveTrades: str = "cbi distributive trades"
            """CBI Distributive Trades"""

            CbiIndustrialTrendsOrders: str = "cbi industrial trends orders"
            """CBI Industrial Trends Orders"""

            CbLeadingEconomicIndex: str = "cb leading economic index"
            """CB Leading Index"""

            CbLeadingEconomicIndexMoM: str = "cb leading economic index mom"
            """CB Leading Economic Index MoM"""

            ChancellorHammondBudgetStatement: str = "chancellor hammond budget statement"
            """Chancellor Hammond Budget Statement"""

            ChancellorOsborneBudgetStatement: str = "chancellor osborne budget statement"
            """Chancellor Osborne Budget Statement"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ChristmasDaySubstituteDay: str = "christmas day substitute day"
            """Christmas Day (Substitute Day)"""

            ClaimantCountChange: str = "claimant count change"
            """Claimant Count Change"""

            ClaimantCountRate: str = "claimant count rate"
            """Claimant Count Rate"""

            ConstructionOrdersYoY: str = "construction orders yoy"
            """Construction Orders YoY"""

            ConstructionOutputYoY: str = "construction output yoy"
            """Construction Output YoY"""

            ConstructionPurchasingManagersIndex: str = "construction purchasing managers index"
            """Construction PMI"""

            ConsumerInflationExpectations: str = "consumer inflation expectations"
            """Consumer Inflation Expectations"""

            CoreInflationRateMoM: str = "core inflation rate mom"
            """Core Inflation Rate MoM"""

            CoreInflationRateYoY: str = "core inflation rate yoy"
            """Core Inflation Rate YoY"""

            CoreRetailPriceIndexMoM: str = "core retail price index mom"
            """Core RPI MoM"""

            CoreRetailPriceIndexYoY: str = "core retail price index yoy"
            """Core RPI YoY"""

            CoreRetailSalesYoY: str = "core retail sales yoy"
            """Core Retail Sales YoY"""

            CurrentAccount: str = "current account"
            """Current Account"""

            EarlyMayBankHoliday: str = "early may bank holiday"
            """Early May Bank Holiday"""

            EasterMonday: str = "easter monday"
            """Easter Monday"""

            EmploymentChange: str = "employment change"
            """Employment Change"""

            EuMembershipReferendumFinalResults: str = "eu membership referendum final results"
            """EU Membership Referendum - Final Results"""

            EuropeanUnionMembershipReferendum: str = "european union membership referendum"
            """European Union Membership Referendum"""

            FinanceMinisterOsborneSpeech: str = "finance minister osborne speech"
            """Finance Minister Osborne Speech"""

            FinanceMinOsborneSpeaksOnBrexit: str = "finance min osborne speaks on brexit"
            """Finance Min Osborne Speaks on Brexit"""

            FinancialStabilityReport: str = "financial stability report"
            """Financial Stability Report"""

            FinMinisterHammondSpeech: str = "fin minister hammond speech"
            """Fin Minister Hammond Speech"""

            FinMinisterOsborneSpeaksInParliament: str = "fin minister osborne speaks in parliament"
            """Fin Minister Osborne Speaks in Parliament"""

            FiveYearTreasuryGiltAuction: str = "5 year treasury gilt auction"
            """5-Year Treasury Gilt Auction"""

            GdpGrowthRate: str = "gdp growth rate"
            """GDP Growth Rate"""

            GdpGrowthRateQoQ: str = "gdp growth rate qoq"
            """GDP Growth Rate QoQ"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQPreliminary: str = "gdp growth rate qoq preliminary"
            """GDP Growth Rate QoQ Prel"""

            GdpGrowthRateQoQSecondEstimate: str = "gdp growth rate qoq second estimate"
            """GDP Growth Rate QoQ 2nd Est"""

            GdpGrowthRateYoY: str = "gdp growth rate yoy"
            """GDP Growth Rate YoY"""

            GdpGrowthRateYoYFinal: str = "gdp growth rate yoy final"
            """GDP Growth Rate YoY Final"""

            GdpGrowthRateYoYPreliminary: str = "gdp growth rate yoy preliminary"
            """GDP Growth Rate YoY Prel"""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY 2nd Est"""

            GdpGrowthYoY: str = "gdp growth yoy"
            """GDP Growth YoY"""

            GdpMoM: str = "gdp mom"
            """GDP MoM"""

            GdpThreeMonthAvg: str = "gdp 3 month avg"
            """GDP 3-Month Avg"""

            GdpYoY: str = "gdp yoy"
            """GDP YoY"""

            GeneralElection: str = "general election"
            """General Election"""

            GfkConsumerConfidence: str = "gfk consumer confidence"
            """Gfk Consumer Confidence"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            GoodsTradeBalance: str = "goods trade balance"
            """Goods Trade Balance"""

            GovernmentAutumnForecasts: str = "government autumn forecasts"
            """Government Autumn Forecasts"""

            HalifaxHousePriceIndexMoM: str = "halifax house price index mom"
            """Halifax House Price Index MoM"""

            HalifaxHousePriceIndexYoY: str = "halifax house price index yoy"
            """Halifax House Price Index YoY"""

            HammondPresentsAutumnStatement: str = "hammond presents autumn statement"
            """Hammond Presents Autumn Statement"""

            HometrackHousingPricesMoM: str = "hometrack housing prices mom"
            """Hometrack Housing Prices MoM"""

            HometrackHousingPricesSeasonallyAdjusted: str = "hometrack housing prices seasonally adjusted"
            """Hometrack Housing Prices s.a"""

            HousePriceIndexMoM: str = "house price index mom"
            """House Price Index MoM"""

            HousePriceIndexYoY: str = "house price index yoy"
            """House Price Index YoY"""

            IndexOfServicesThreeMThreeM: str = "index of services 3m 3m"
            """Index of Services (3M/3M)"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InflationReportHearings: str = "inflation report hearings"
            """Inflation Report Hearings"""

            InterestRateDecision: str = "interest rate decision"
            """Interest Rate Decision"""

            LaborCostsIndexQoQ: str = "labor costs index qoq"
            """Labour Costs QoQ"""

            LaborProductivityQoQ: str = "labor productivity qoq"
            """Labour Productivity QoQ"""

            LaborProductivityQoQFinal: str = "labor productivity qoq final"
            """Labour Productivity QoQ Final"""

            LaborProductivityQoQPreliminary: str = "labor productivity qoq preliminary"
            """Labour Productivity QoQ Prel"""

            LocalElections: str = "local elections"
            """Local Elections"""

            LondonAssemblyElection: str = "london assembly election"
            """London Assembly Election"""

            LondonMayoralElection: str = "london mayoral election"
            """London Mayoral Election"""

            ManufacturingProductionMoM: str = "manufacturing production mom"
            """Manufacturing Production MoM"""

            ManufacturingProductionYoY: str = "manufacturing production yoy"
            """Manufacturing Production YoY"""

            MarkCarneyWillBecomeTheNewBankOfEnglandGovernor: str = "mark carney will become the new bank of england governor"
            """Mark Carney will become the new Bank of England Governor"""

            MarkitCipsCompositePurchasingManagersIndexFinal: str = "markit cips composite purchasing managers index final"
            """Markit/CIPS Composite PMI Final"""

            MarkitCipsCompositePurchasingManagersIndexFlash: str = "markit cips composite purchasing managers index flash"
            """Markit/CIPS Composite PMI Flash"""

            MarkitCipsManufacturingPurchasingManagersIndex: str = "markit cips manufacturing purchasing managers index"
            """Markit/CIPS Manufacturing PMI"""

            MarkitCipsManufacturingPurchasingManagersIndexFinal: str = "markit cips manufacturing purchasing managers index final"
            """Markit/CIPS Manufacturing PMI Final"""

            MarkitCipsManufacturingPurchasingManagersIndexFlash: str = "markit cips manufacturing purchasing managers index flash"
            """Markit/CIPS Manufacturing PMI Flash"""

            MarkitCipsUkServicesPurchasingManagersIndex: str = "markit cips uk services purchasing managers index"
            """Markit/CIPS UK Services PMI"""

            MarkitCipsUkServicesPurchasingManagersIndexFinal: str = "markit cips uk services purchasing managers index final"
            """Markit/CIPS UK Services PMI Final"""

            MarkitCipsUkServicesPurchasingManagersIndexFlash: str = "markit cips uk services purchasing managers index flash"
            """Markit/CIPS UK Services PMI Flash"""

            MarkitManufacturingPurchasingManagersIndex: str = "markit manufacturing purchasing managers index"
            """Markit Manufacturing PMI"""

            MarkitServicesPurchasingManagersIndex: str = "markit services purchasing managers index"
            """Markit Services PMI"""

            MayDay: str = "may day"
            """May Day"""

            MayNoConfidenceVoteResult: str = "may no confidence vote result"
            """May No Confidence Vote Result"""

            MFourMoneySupplyMoM: str = "m4 money supply mom"
            """M4 Money Supply (MoM)"""

            MFourMoneySupplyYoY: str = "m4 money supply yoy"
            """M4 Money Supply (YoY)"""

            MonthlyGdp: str = "monthly gdp"
            """Monthly GDP"""

            MonthlyGdpThreeMonthAvg: str = "monthly gdp 3 month avg"
            """Monthly GDP 3-Month Avg"""

            MortgageApprovals: str = "mortgage approvals"
            """Mortgage Approvals"""

            MortgageLending: str = "mortgage lending"
            """Mortgage Lending"""

            MpcMeetingMinutes: str = "mpc meeting minutes"
            """MPC Meeting Minutes"""

            MpcMemberBeanSpeech: str = "mpc member bean speech"
            """MPC Member Bean Speech"""

            MpcMemberPaulFisherSpeech: str = "mpc member paul fisher speech"
            """MPC Member Paul Fisher Speech"""

            MpsVoteOnBennBill: str = "mps vote on benn bill"
            """MPs Vote on Benn Bill"""

            MpsVoteOnBrexitBill: str = "mps vote on brexit bill"
            """MPs Vote on Brexit Bill"""

            MpsVoteOnBrexitTimetable: str = "mps vote on brexit timetable"
            """MPs Vote on Brexit Timetable"""

            MpsVoteOnPmElectionCall: str = "mps vote on pm election call"
            """MPs Vote on PM Election Call"""

            MpsVoteOnWithdrawalAgreementBill: str = "mps vote on withdrawal agreement bill"
            """MPs Vote on Withdrawal Agreement Bill"""

            NationalAssemblyForWalesElections: str = "national assembly for wales elections"
            """National Assembly for Wales Elections"""

            NationwideHousingPricesMoM: str = "nationwide housing prices mom"
            """Nationwide Housing Prices MoM"""

            NationwideHousingPricesYoY: str = "nationwide housing prices yoy"
            """Nationwide Housing Prices YoY"""

            NetLendingToIndividualsMoM: str = "net lending to individuals mom"
            """Net Lending to Individuals MoM"""

            NewCarSalesYoY: str = "new car sales yoy"
            """New Car Sales YoY"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NewYearsDaySubstituteDay: str = "new years day substitute day"
            """New Year’s Day (Substitute Day)"""

            NiesrGdpEstimateThreeMonths: str = "niesr gdp estimate 3m"
            """NIESR GDP Est (3M)"""

            NiesrMonthlyGdpTracker: str = "niesr monthly gdp tracker"
            """NIESR Monthly GDP Tracker"""

            NorthernIrelandAssemblyElection: str = "northern ireland assembly election"
            """Northern Ireland Assembly Election"""

            ObrFiscalForecasts: str = "obr fiscal forecasts"
            """OBR Fiscal Forecasts"""

            ObrFiscalRisksReport: str = "obr fiscal risks report"
            """OBR Fiscal Risks Report"""

            OecdGurriaSpeechOnUkReferendum: str = "oecd gurria speech on uk referendum"
            """OECD Gurria Speech on UK Referendum"""

            ParliamentaryDebateAndVoteOnPartOfBrexitDeal: str = "parliamentary debate and vote on part of brexit deal"
            """Parliamentary Debate & Vote on Part of Brexit Deal"""

            ParliamentaryElections: str = "parliamentary elections"
            """Parliamentary Elections"""

            ParliamentaryVoteOnArtFiftyExtension: str = "parliamentary vote on art 50 extension"
            """Parliamentary Vote on Art 50 Extension"""

            ParliamentaryVoteOnBrexitAmendments: str = "parliamentary vote on brexit amendments"
            """Parliamentary Vote on Brexit Amendments"""

            ParliamentaryVoteOnBrexitDeal: str = "parliamentary vote on brexit deal"
            """Parliamentary Vote on Brexit Deal"""

            ParliamentaryVoteOnNoDealBrexit: str = "parliamentary vote on no deal brexit"
            """Parliamentary Vote on No-Deal Brexit"""

            ParliamentaryVotesOnBrexitAlternatives: str = "parliamentary votes on brexit alternatives"
            """Parliamentary Votes on Brexit Alternatives"""

            ParliamentDebateOnBrexit: str = "parliament debate on brexit"
            """Parliament Debate on Brexit"""

            ParliamentDebateOnBrexitAlternatives: str = "parliament debate on brexit alternatives"
            """Parliament Debate on Brexit Alternatives"""

            PmMayNoConfidenceVote: str = "pm may no confidence vote"
            """PM May No Confidence Vote"""

            PmMaysPlanBStatementOnBrexit: str = "pm mays plan b statement on brexit"
            """PM May's Plan B Statement on Brexit"""

            PmMaysStatementOnBrexit: str = "pm mays statement on brexit"
            """PM May's Statement on Brexit"""

            PmMayStatementOnNewBrexitDeal: str = "pm may statement on new brexit deal"
            """PM May Statement on New Brexit Deal"""

            PrimeMinisterMaySpeech: str = "prime minister may speech"
            """Prime Minister May Speech"""

            PrimeMinisterMaySpeechOnBrexit: str = "prime minister may speech on brexit"
            """Prime Minister May Speech on Brexit"""

            PrimeMinisterTheresaMaySpeech: str = "prime minister theresa may speech"
            """Prime Minister Theresa May Speech"""

            ProducerPriceIndexCoreOutputMoM: str = "producer price index core output mom"
            """PPI Core Output MoM"""

            ProducerPriceIndexCoreOutputYoY: str = "producer price index core output yoy"
            """PPI Core Output YoY"""

            ProducerPriceIndexInputMoM: str = "producer price index input mom"
            """PPI Input MoM"""

            ProducerPriceIndexInputYoY: str = "producer price index input yoy"
            """PPI Input YoY"""

            ProducerPriceIndexOutputMoM: str = "producer price index output mom"
            """PPI Output MoM"""

            ProducerPriceIndexOutputYoY: str = "producer price index output yoy"
            """PPI Output YoY"""

            PublicSectorBorrowingMoM: str = "public sector borrowing mom"
            """Public Sector Borrowing MoM"""

            PublicSectorNetBorrowing: str = "public sector net borrowing"
            """Public Sector Net Borrowing"""

            QueensSpeechAtTheParliament: str = "queens speech at the parliament"
            """Queen's Speech at The Parliament"""

            RetailPriceIndexMoM: str = "retail price index mom"
            """Retail Price Index MoM"""

            RetailPriceIndexYoY: str = "retail price index yoy"
            """Retail Price Index YoY"""

            RetailSalesExcludingFuelMoM: str = "retail sales excluding fuel mom"
            """Retail Sales ex Fuel MoM"""

            RetailSalesExcludingFuelYoY: str = "retail sales excluding fuel yoy"
            """Retail Sales ex Fuel YoY"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            RicsHousePriceBalance: str = "rics house price balance"
            """RICS House Price Balance"""

            ScottishIndependenceReferendum: str = "scottish independence referendum"
            """Scottish Independence Referendum"""

            ScottishParliamentElection: str = "scottish parliament election"
            """Scottish Parliament Election"""

            SpringBankHoliday: str = "spring bank holiday"
            """Spring Bank Holiday"""

            SpringBudgetTwoThousandEighteen: str = "spring budget 2018"
            """Spring Budget 2018"""

            SpringBudgetTwoThousandNineteen: str = "spring budget 2019"
            """Spring Budget 2019"""

            SummerBankHoliday: str = "summer bank holiday"
            """Summer Bank Holiday"""

            TenYearTreasuryGiltAuction: str = "10 year treasury gilt auction"
            """10-Year Treasury Gilt Auction"""

            ThirtyYearTreasuryGiltAuction: str = "30 year treasury gilt auction"
            """30-Year Treasury Gilt Auction"""

            TotalBusinessInvestmentQoQ: str = "total business investment qoq"
            """Total Business Investment (QoQ)"""

            TotalBusinessInvestmentYoY: str = "total business investment yoy"
            """Total Business Investment (YoY)"""

            TreasuryCommitteeHearingInflationReport: str = "treasury committee hearing inflation report"
            """Treasury Committee Hearing – Inflation Report"""

            TreasurySelectCommitteeHearing: str = "treasury select committee hearing"
            """Treasury Select Committee Hearing"""

            TwoThousandSixteenAnnualBudgetAnnouncement: str = "2016 annual budget announcement"
            """2016 Annual Budget Announcement"""

            UkFinanceMortgageApprovals: str = "uk finance mortgage approvals"
            """UK Finance Mortgage Approvals"""

            UkGeneralElection: str = "uk general election"
            """UK General Election"""

            UkMayEuJunckerMeeting: str = "uk may eu juncker meeting"
            """UK May - EU Juncker Meeting"""

            UkPmStatementOnBrexit: str = "uk pm statement on brexit"
            """UK PM Statement on Brexit"""

            UkSupremeCourtRulingOnArticleFifty: str = "uk supreme court ruling on article 50"
            """UK Supreme Court Ruling On Article 50"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

        class UnitedStates(System.Object):
            """United States"""

            AdpEmploymentChange: str = "adp employment change"
            """ADP Employment Change"""

            AllCarSales: str = "all car sales"
            """All Car Sales"""

            AllTruckSales: str = "all truck sales"
            """All Truck Sales"""

            ApiWeeklyCrudeStockChange: str = "api weekly crude stock change"
            """API Weekly Crude Stock Change"""

            ApiWeeklyGasolineStockChange: str = "api weekly gasoline stock change"
            """API Weekly Gasoline Stock Change"""

            AverageHourlyEarningsMoM: str = "average hourly earnings mom"
            """Average Hourly Earnings MoM"""

            AverageHourlyEarningsYoY: str = "average hourly earnings yoy"
            """Average Hourly Earnings YoY"""

            AverageWeeklyHours: str = "average weekly hours"
            """Average Weekly Hours"""

            BakerHughesOilRigCount: str = "baker hughes oil rig count"
            """Baker Hughes Oil Rig Count"""

            BalanceOfTrade: str = "balance of trade"
            """Balance of Trade"""

            BeigeBook: str = "beige book"
            """Beige Book"""

            BirthdayOfMartinLutherKingJr: str = "birthday of martin luther king jr"
            """Birthday of Martin Luther King, Jr."""

            BuildingPermits: str = "building permits"
            """Building Permits"""

            BuildingPermitsMoM: str = "building permits mom"
            """Building Permits MoM"""

            BusinessInventoriesMoM: str = "business inventories mom"
            """Business Inventories MoM"""

            CapacityUtilization: str = "capacity utilization"
            """Capacity Utilization"""

            CbConsumerConfidence: str = "cb consumer confidence"
            """CB Consumer Confidence"""

            CbEmploymentTrendsIndex: str = "cb employment trends index"
            """CB Employment Trends Index"""

            CbLeadingEconomicIndexMoM: str = "cb leading economic index mom"
            """CB Leading Index MoM"""

            ChainStoresSalesWoW: str = "chain stores sales wow"
            """Chain stores WoW"""

            ChainStoresSalesYoY: str = "chain stores sales yoy"
            """Chain Stores Sales YoY"""

            ChallengerJobCuts: str = "challenger job cuts"
            """Challenger Job Cuts"""

            ChicagoFedNationalActivityIndex: str = "chicago fed national activity index"
            """Chicago Fed National Activity Index"""

            ChicagoPurchasingManagersIndex: str = "chicago purchasing managers index"
            """Chicago PMI"""

            ChristmasDay: str = "christmas day"
            """Christmas Day"""

            ChristmasDaySubstituteDay: str = "christmas day substitute day"
            """Christmas Day (Substitute Day)"""

            ColumbusDay: str = "columbus day"
            """Columbus Day"""

            ConstructionSpendingMoM: str = "construction spending mom"
            """Construction Spending MoM"""

            ConsumerConfidence: str = "consumer confidence"
            """Consumer Confidence"""

            ConsumerCreditChange: str = "consumer credit change"
            """Consumer Credit Change"""

            ConsumerInflationExpectations: str = "consumer inflation expectations"
            """Consumer Inflation Expectations"""

            ConsumerPriceIndex: str = "consumer price index"
            """Consumer Price Index"""

            ConsumerPriceIndexExcludingFoodAndEnergyMoM: str = "consumer price index excluding food and energy mom"
            """Consumer Price Index Ex Food & Energy (MoM)"""

            ConsumerPriceIndexExcludingFoodAndEnergyYoY: str = "consumer price index excluding food and energy yoy"
            """Consumer Price Index Ex Food & Energy (YoY)"""

            ConsumerPriceIndexRealEarningsMoM: str = "consumer price index real earnings mom"
            """CPI Real Earnings MoM"""

            ContinuingJoblessClaims: str = "continuing jobless claims"
            """Continuing Jobless Claims"""

            CoreConsumerPriceIndex: str = "core consumer price index"
            """Core Consumer Price Index"""

            CoreDurableGoodsOrders: str = "core durable goods orders"
            """Core Durable Goods Orders"""

            CoreDurableGoodsOrdersMoM: str = "core durable goods orders mom"
            """Core Durable Goods Orders MoM"""

            CoreInflationRateMoM: str = "core inflation rate mom"
            """Core Inflation Rate MoM"""

            CoreInflationRateYoY: str = "core inflation rate yoy"
            """Core Inflation Rate YoY"""

            CorePersonalConsumptionExpenditurePriceIndexMoM: str = "core personal consumption expenditure price index mom"
            """Core Personal Consumption Expenditure - Price Index (MoM)"""

            CorePersonalConsumptionExpenditurePriceIndexQoQ: str = "core personal consumption expenditure price index qoq"
            """Core Personal Consumption Expenditures QoQ"""

            CorePersonalConsumptionExpenditurePriceIndexQoQAdv: str = "core personal consumption expenditure price index qoq adv"
            """Core PCE Prices QoQ Adv"""

            CorePersonalConsumptionExpenditurePriceIndexQoQFinal: str = "core personal consumption expenditure price index qoq final"
            """Core PCE Prices QoQ Final"""

            CorePersonalConsumptionExpenditurePriceIndexQoQSecondEstimate: str = "core personal consumption expenditure price index qoq second estimate"
            """Core PCE Prices QoQ 2 Est"""

            CorePersonalConsumptionExpenditurePriceIndexYoY: str = "core personal consumption expenditure price index yoy"
            """Core PCE Price Index YoY"""

            CoreProducerPriceIndexMoM: str = "core producer price index mom"
            """Core PPI MoM"""

            CoreProducerPriceIndexYoY: str = "core producer price index yoy"
            """Core PPI YoY"""

            CoreRetailSalesMoM: str = "core retail sales mom"
            """Core Retail Sales MoM"""

            CorporateProfitsQoQ: str = "corporate profits qoq"
            """Corporate Profits QoQ"""

            CorporateProfitsQoQFinal: str = "corporate profits qoq final"
            """Corporate Profits QoQ Final"""

            CorporateProfitsQoQPreliminary: str = "corporate profits qoq preliminary"
            """Corporate Profits QoQ Prel"""

            CurrentAccount: str = "current account"
            """Current Account"""

            DallasFedManufacturingIndex: str = "dallas fed manufacturing index"
            """Dallas Fed Manufacturing Index"""

            DeadlineForFundingForNewFiscalYear: str = "deadline for funding for new fiscal year"
            """Deadline for Funding For New Fiscal Year"""

            DomesticCarSales: str = "domestic car sales"
            """Domestic Car Sales"""

            DomesticTruckSales: str = "domestic truck sales"
            """Domestic Truck Sales"""

            DurableGoodsOrdersExcludingDefenseMoM: str = "durable goods orders excluding defense mom"
            """Durable Goods Orders Ex Defense MoM"""

            DurableGoodsOrdersExcludingTransportationMoM: str = "durable goods orders excluding transportation mom"
            """Durable Goods Orders Ex Transp MoM"""

            DurableGoodsOrdersMoM: str = "durable goods orders mom"
            """Durable Goods Orders MoM"""

            EiaCrudeOilImports: str = "eia crude oil imports"
            """EIA Crude Oil Imports"""

            EiaCrudeOilImportsChange: str = "eia crude oil imports change"
            """EIA Crude Oil Imports Change"""

            EiaCrudeOilStocksChange: str = "eia crude oil stocks change"
            """EIA Crude Oil Stocks Change"""

            EiaCushingCrudeOilStocksChange: str = "eia cushing crude oil stocks change"
            """EIA Cushing Crude Oil Stocks Change"""

            EiaDistillateFuelProductionChange: str = "eia distillate fuel production change"
            """EIA Distillate Fuel Production Change"""

            EiaDistillateStocks: str = "eia distillate stocks"
            """EIA Distillate Stocks"""

            EiaDistillateStocksChange: str = "eia distillate stocks change"
            """EIA Distillate Stocks Change"""

            EiaGasolineProduction: str = "eia gasoline production"
            """EIA Gasoline Production"""

            EiaGasolineProductionChange: str = "eia gasoline production change"
            """EIA Gasoline Production Change"""

            EiaGasolineStocksChange: str = "eia gasoline stocks change"
            """EIA Gasoline Stocks Change"""

            EiaNaturalGasStocksChange: str = "eia natural gas stocks change"
            """EIA Natural Gas Stocks Change"""

            EiaRefineryCrudeRunsChange: str = "eia refinery crude runs change"
            """EIA Refinery Crude Runs Change"""

            EightWeekBillAuction: str = "8 week bill auction"
            """8-Week Bill Auction"""

            EmploymentBenefitsQoQ: str = "employment benefits qoq"
            """Employment Benefits QoQ"""

            EmploymentCostsBenefitsQoQ: str = "employment costs benefits qoq"
            """Employment Cost - Benefits QoQ"""

            EmploymentCostsIndexQoQ: str = "employment costs index qoq"
            """Employment Cost Index QoQ"""

            EmploymentCostsWagesQoQ: str = "employment costs wages qoq"
            """Employment Cost - Wages QoQ"""

            EmploymentWagesQoQ: str = "employment wages qoq"
            """Employment Wages QoQ"""

            ExistingHomeSales: str = "existing home sales"
            """Existing Home Sales"""

            ExistingHomeSalesMoM: str = "existing home sales mom"
            """Existing Home Sales MoM"""

            ExportPricesMoM: str = "export prices mom"
            """Export Prices MoM"""

            ExportPricesYoY: str = "export prices yoy"
            """Export Prices YoY"""

            Exports: str = "exports"
            """Exports"""

            FactoryOrdersExcludingTransportation: str = "factory orders excluding transportation"
            """Factory Orders ex Transportation"""

            FactoryOrdersMoM: str = "factory orders mom"
            """Factory Orders MoM"""

            FedBarkinSpeech: str = "fed barkin speech"
            """Fed Barkin Speech"""

            FedBeigeBook: str = "fed beige book"
            """Fed Beige Book"""

            FedBernankeSpeech: str = "fed bernanke speech"
            """Fed Bernanke Speech"""

            FedBernankeTestifies: str = "fed bernanke testifies"
            """Fed Bernanke testifies"""

            FedBosticSpeech: str = "fed bostic speech"
            """Fed Bostic Speech"""

            FedBowmanSpeech: str = "fed bowman speech"
            """Fed Bowman Speech"""

            FedBowmanTestimony: str = "fed bowman testimony"
            """Fed Bowman Testimony"""

            FedBrainardSpeaks: str = "fed brainard speaks"
            """Fed Brainard Speaks"""

            FedBrainardSpeech: str = "fed brainard speech"
            """Fed Brainard Speech"""

            FedBrainardTestimony: str = "fed brainard testimony"
            """Fed Brainard Testimony"""

            FedBullardSpeaks: str = "fed bullard speaks"
            """Fed Bullard Speaks"""

            FedBullardSpeech: str = "fed bullard speech"
            """Fed Bullard Speech"""

            FedCcarForBigBanks: str = "fed ccar for big banks"
            """Fed CCAR For Big Banks"""

            FedCcarResultsForBigBanks: str = "fed ccar results for big banks"
            """Fed CCAR Results For Big Banks"""

            FedChairmanBernankeSpeaks: str = "fed chairman bernanke speaks"
            """Fed Chairman Bernanke Speaks"""

            FedChairmanBernankeSpeech: str = "fed chairman bernanke speech"
            """Fed Chairman Bernanke Speech"""

            FedChairmanBernankeTestifies: str = "fed chairman bernanke testifies"
            """Fed Chairman Bernanke Testifies"""

            FedChairmanNominationVote: str = "fed chairman nomination vote"
            """Fed Chairman Nomination Vote"""

            FedChairmanYellenSpeaks: str = "fed chairman yellen speaks"
            """Fed Chairman Yellen Speaks"""

            FedChairPowellSpeech: str = "fed chair powell speech"
            """Fed Chair Powell Speech"""

            FedChairPowellTestimony: str = "fed chair powell testimony"
            """Fed Chair Powell Testimony"""

            FedChairYellenSpeaks: str = "fed chair yellen speaks"
            """Fed Chair Yellen Speaks"""

            FedClaridaSpeech: str = "fed clarida speech"
            """Fed Clarida Speech"""

            FedDalySpeech: str = "fed daly speech"
            """Fed Daly Speech"""

            FedDudleySpeech: str = "fed dudley speech"
            """Fed Dudley Speech"""

            FedDukeSpeech: str = "fed duke speech"
            """Fed Duke Speech"""

            FederalBudgetBalance: str = "federal budget balance"
            """Federal Budget Balance"""

            FedEvansSpeaks: str = "fed evans speaks"
            """Fed Evans Speaks"""

            FedEvansSpeech: str = "fed evans speech"
            """Fed Evans Speech"""

            FedFischerSpeech: str = "fed fischer speech"
            """Fed Fischer Speech"""

            FedGeorgeSpeech: str = "fed george speech"
            """Fed George Speech"""

            FedGeorgeTestimony: str = "fed george testimony"
            """Fed George Testimony"""

            FedHarkerMesterAndLockhartSpeech: str = "fed harker mester and lockhart speech"
            """Fed Harker, Mester & Lockhart Speech"""

            FedHarkerSpeech: str = "fed harker speech"
            """Fed Harker Speech"""

            FedInterestRateDecision: str = "fed interest rate decision"
            """Fed Interest Rate Decision"""

            FedKaplanSpeech: str = "fed kaplan speech"
            """Fed Kaplan Speech"""

            FedKashkariSpeech: str = "fed kashkari speech"
            """Fed Kashkari Speech"""

            FedKocherlakotaSpeech: str = "fed kocherlakota speech"
            """Fed Kocherlakota Speech"""

            FedLaborMarketConditionsIndexMoM: str = "fed labor market conditions index mom"
            """Fed Labor Market Conditions Index (MoM)"""

            FedLackerSpeech: str = "fed lacker speech"
            """Fed Lacker Speech"""

            FedLockhartSpeech: str = "fed lockhart speech"
            """Fed Lockhart speech"""

            FedMeetingUnderExpeditedProcedures: str = "fed meeting under expedited procedures"
            """Fed Meeting under Expedited Procedures"""

            FedMesterSpeech: str = "fed mester speech"
            """Fed Mester Speech"""

            FedMonetaryPolicyStatementAndPressConference: str = "fed monetary policy statement and press conference"
            """Fed Monetary Policy Statement and press conference"""

            FedOpenBoardMeeting: str = "fed open board meeting"
            """Fed Open Board Meeting"""

            FedPaceOfMortgageBackedSecuritiesPurchaseProgram: str = "fed pace of mortgage backed securities purchase program"
            """Fed Pace of MBS Purchase Program"""

            FedPaceOfTreasuryPurchaseProgram: str = "fed pace of treasury purchase program"
            """Fed Pace of Treasury Purchase Program"""

            FedPowellSpeech: str = "fed powell speech"
            """Fed Powell Speech"""

            FedPressConference: str = "fed press conference"
            """Fed press conference"""

            FedQuarlesSpeech: str = "fed quarles speech"
            """Fed Quarles Speech"""

            FedQuarlesTestimony: str = "fed quarles testimony"
            """Fed Quarles Testimony"""

            FedRichardFisherSpeech: str = "fed richard fisher speech"
            """Fed Richard Fisher speech"""

            FedRosengrenSpeech: str = "fed rosengren speech"
            """Fed Rosengren Speech"""

            FedsBeigeBook: str = "feds beige book"
            """FED´s Beige Book"""

            FedStressTestResultsForBigBanks: str = "fed stress test results for big banks"
            """Fed Stress Test Results For Big Banks"""

            FedTarulloSpeech: str = "fed tarullo speech"
            """Fed Tarullo Speech"""

            FedTarulloTestifies: str = "fed tarullo testifies"
            """Fed Tarullo Testifies"""

            FedWilliamsSpeech: str = "fed williams speech"
            """Fed Williams Speech"""

            FedYellenAndImfsLagardeSpeech: str = "fed yellen and imfs lagarde speech"
            """Fed Yellen & IMF's Lagarde Speech"""

            FedYellenSpeaks: str = "fed yellen speaks"
            """Fed Yellen Speaks"""

            FedYellenSpeaksAtJacksonHole: str = "fed yellen speaks at jackson hole"
            """Fed Yellen Speaks At Jackson Hole"""

            FedYellenSpeech: str = "fed yellen speech"
            """Fed Yellen Speech"""

            FedYellenTestifies: str = "fed yellen testifies"
            """Fed Yellen testifies"""

            FedYellenTestimony: str = "fed yellen testimony"
            """Fed Yellen Testimony"""

            FedYellenTestimonyBeforeCongress: str = "fed yellen testimony before congress"
            """Fed Yellen Testimony Before Congress"""

            FedYellenTestimonyHfsc: str = "fed yellen testimony hfsc"
            """Fed Yellen Testimony HFSC"""

            FedYellenTestimonySbc: str = "fed yellen testimony sbc"
            """Fed Yellen Testimony SBC"""

            FedYellenTestimonyToTheCongress: str = "fed yellen testimony to the congress"
            """Fed Yellen Testimony to the Congress"""

            FedYellenTestimonyToTheSenate: str = "fed yellen testimony to the senate"
            """Fed Yellen Testimony to the Senate"""

            FedYellenTestymonyHouse: str = "fed yellen testymony house"
            """Fed Yellen Testymony - House"""

            FedYellenTestymonySenate: str = "fed yellen testymony senate"
            """Fed Yellen Testymony - Senate"""

            FiftyTwoWeekBillAuction: str = "52 week bill auction"
            """52-Week Bill Auction"""

            FinancialAccountsOfTheUs: str = "financial accounts of the us"
            """Financial Accounts of the US"""

            FiveYearNoteAuction: str = "5 year note auction"
            """5-Year Note Auction"""

            FiveYearTipsAuction: str = "5 year tips auction"
            """5-Year TIPS Auction"""

            FomcEconomicProjections: str = "fomc economic projections"
            """FOMC Economic Projections"""

            FomcMemberYellenSpeech: str = "fomc member yellen speech"
            """FOMC Member Yellen Speech"""

            FomcMinutes: str = "fomc minutes"
            """FOMC Minutes"""

            FomcPolicyStatementAndPressConference: str = "fomc policy statement and press conference"
            """FOMC Policy Statement and press conference"""

            FomcPressConference: str = "fomc press conference"
            """FOMC Press Conference"""

            ForeignBondInvestment: str = "foreign bond investment"
            """Foreign Bond Investment"""

            FourWeekBillAuction: str = "4 week bill auction"
            """4-Week Bill Auction"""

            GasolineInventories: str = "gasoline inventories"
            """Gasoline Inventories"""

            GdpConsumerSpendingQoQAdv: str = "gdp consumer spending qoq adv"
            """GDP Consumer Spending QoQ Adv"""

            GdpConsumerSpendingQoQFinal: str = "gdp consumer spending qoq final"
            """GDP Consumer Spending QoQ Final"""

            GdpConsumerSpendingYoY: str = "gdp consumer spending yoy"
            """GDP Consumer Spending YoY"""

            GdpDeflatorQoQ: str = "gdp deflator qoq"
            """GDP Deflator QoQ"""

            GdpGrowthRate: str = "gdp growth rate"
            """GDP Growth Rate"""

            GdpGrowthRateQoQAdv: str = "gdp growth rate qoq adv"
            """GDP Growth Rate QoQ Adv"""

            GdpGrowthRateQoQFinal: str = "gdp growth rate qoq final"
            """GDP Growth Rate QoQ Final"""

            GdpGrowthRateQoQSecondEstimate: str = "gdp growth rate qoq second estimate"
            """GDP Growth Rate QoQ 2nd Est"""

            GdpGrowthRateSecondEstimate: str = "gdp growth rate second estimate"
            """GDP Growth Rate 2nd Est"""

            GdpGrowthRateYoYAdv: str = "gdp growth rate yoy adv"
            """GDP Growth Rate YoY Adv"""

            GdpGrowthRateYoYSecondEstimate: str = "gdp growth rate yoy second estimate"
            """GDP Growth Rate YoY Second Est"""

            GdpGrowthRateYoYThirdEstimate: str = "gdp growth rate yoy third estimate"
            """GDP Growth Rate YoY Third Estimate"""

            GdpPriceIndex: str = "gdp price index"
            """GDP Price Index"""

            GdpPriceIndexQoQ: str = "gdp price index qoq"
            """GDP Price Index QoQ"""

            GdpPriceIndexQoQAdv: str = "gdp price index qoq adv"
            """GDP Price Index QoQ Adv"""

            GdpPriceIndexQoQFinal: str = "gdp price index qoq final"
            """GDP Price Index QoQ Final"""

            GdpPriceIndexQoQSecondEstimate: str = "gdp price index qoq second estimate"
            """GDP Price Index QoQ 2nd Est"""

            GoodFriday: str = "good friday"
            """Good Friday"""

            GoodsTradeBalance: str = "goods trade balance"
            """Goods Trade Balance"""

            GoodsTradeBalanceAdv: str = "goods trade balance adv"
            """Goods Trade Balance Adv"""

            GovernmentPayrolls: str = "government payrolls"
            """Government Payrolls"""

            GrossDomesticProductPriceIndex: str = "gross domestic product price index"
            """Gross Domestic Product Price Index"""

            GThirtyInternationalBankingSeminar: str = "g30 international banking seminar"
            """G30 International Banking Seminar"""

            GTwentyFinanceMinistersAndCbGovernorsMeeting: str = "g20 finance ministers and cb governors meeting"
            """G20 Finance Ministers and CB Governors Meeting"""

            GTwentyFinMinistersAndCbGovernorsMeeting: str = "g20 fin ministers and cb governors meeting"
            """G20 Fin Ministers and CB Governors Meeting"""

            GTwentyMeeting: str = "g20 meeting"
            """G20 Meeting"""

            HousePriceIndexMoM: str = "house price index mom"
            """House Price Index MoM"""

            HousePriceIndexYoY: str = "house price index yoy"
            """House Price Index YoY"""

            HousingStarts: str = "housing starts"
            """Housing Starts"""

            HousingStartsMoM: str = "housing starts mom"
            """Housing Starts MoM"""

            HsbcServicesPurchasingManagersIndex: str = "hsbc services purchasing managers index"
            """HSBC Services PMI"""

            IbdTippEconomicOptimism: str = "ibd tipp economic optimism"
            """IBD/TIPP Economic Optimism"""

            IeaOilMarketReport: str = "iea oil market report"
            """IEA Oil Market Report"""

            ImfMeeting: str = "imf meeting"
            """IMF Meeting"""

            ImfSpringMeeting: str = "imf spring meeting"
            """IMF Spring Meeting"""

            ImfWorldBankAnnualMeetings: str = "imf world bank annual meetings"
            """IMF/World Bank Annual Meetings"""

            ImportPricesMoM: str = "import prices mom"
            """Import Prices MoM"""

            ImportPricesYoY: str = "import prices yoy"
            """Import Prices YoY"""

            Imports: str = "imports"
            """Imports"""

            IndependenceDay: str = "independence day"
            """Independence Day"""

            IndependenceDayObserved: str = "independence day observed"
            """Independence Day Observed"""

            IndustrialProductionMoM: str = "industrial production mom"
            """Industrial Production MoM"""

            IndustrialProductionYoY: str = "industrial production yoy"
            """Industrial Production YoY"""

            InflationRateMoM: str = "inflation rate mom"
            """Inflation Rate MoM"""

            InflationRateYoY: str = "inflation rate yoy"
            """Inflation Rate YoY"""

            InitialJoblessClaims: str = "initial jobless claims"
            """Initial Jobless Claims"""

            IsmManufacturingEmployment: str = "ism manufacturing employment"
            """ISM Manufacturing Employment"""

            IsmManufacturingNewOrders: str = "ism manufacturing new orders"
            """ISM Manufacturing New Orders"""

            IsmManufacturingPrices: str = "ism manufacturing prices"
            """ISM Manufacturing Prices"""

            IsmManufacturingPricesPaid: str = "ism manufacturing prices paid"
            """ISM Manufacturing Prices Paid"""

            IsmManufacturingPurchasingManagersIndex: str = "ism manufacturing purchasing managers index"
            """ISM Manufacturing PMI"""

            IsmNewYorkIndex: str = "ism new york index"
            """ISM New York index"""

            IsmNonManufacturingBusinessActivity: str = "ism non manufacturing business activity"
            """ISM Non-Manufacturing Business Activity"""

            IsmNonManufacturingEmployment: str = "ism non manufacturing employment"
            """ISM Non-Manufacturing Employment"""

            IsmNonManufacturingNewOrders: str = "ism non manufacturing new orders"
            """ISM Non-Manufacturing New Orders"""

            IsmNonManufacturingPrices: str = "ism non manufacturing prices"
            """ISM Non-Manufacturing Prices"""

            IsmNonManufacturingPurchasingManagersIndex: str = "ism non manufacturing purchasing managers index"
            """ISM Non-Manufacturing PMI"""

            IsmPricesPaid: str = "ism prices paid"
            """ISM Prices Paid"""

            JacksonHoleEconomicPolicySymposium: str = "jackson hole economic policy symposium"
            """Jackson Hole Economic Policy Symposium"""

            JacksonHoleSymposium: str = "jackson hole symposium"
            """Jackson Hole Symposium"""

            JoltsJobOpenings: str = "jolts job openings"
            """JOLTs Job Openings"""

            KansasFedManufacturingIndex: str = "kansas fed manufacturing index"
            """Kansas Fed Manufacturing Index"""

            LaborCostsIndexQoQ: str = "labor costs index qoq"
            """Labor Costs QoQ"""

            LaborDay: str = "labor day"
            """Labor Day"""

            LoanOfficerSurvey: str = "loan officer survey"
            """Loan Officer Survey"""

            ManufacturingPayrolls: str = "manufacturing payrolls"
            """Manufacturing Payrolls"""

            ManufacturingProductionMoM: str = "manufacturing production mom"
            """Manufacturing Production MoM"""

            ManufacturingProductionYoY: str = "manufacturing production yoy"
            """Manufacturing Production YoY"""

            MarkitCompositePurchasingManagersIndexFinal: str = "markit composite purchasing managers index final"
            """Markit Composite PMI Final"""

            MarkitCompositePurchasingManagersIndexFlash: str = "markit composite purchasing managers index flash"
            """Markit Composite PMI Flash"""

            MarkitManufacturingPurchasingManagersIndex: str = "markit manufacturing purchasing managers index"
            """Markit Manufacturing PMI"""

            MarkitManufacturingPurchasingManagersIndexFinal: str = "markit manufacturing purchasing managers index final"
            """Markit Manufacturing PMI Final"""

            MarkitManufacturingPurchasingManagersIndexFlash: str = "markit manufacturing purchasing managers index flash"
            """Markit Manufacturing PMI Flash"""

            MarkitServicesPurchasingManagersIndexFinal: str = "markit services purchasing managers index final"
            """Markit Services PMI Final"""

            MarkitServicesPurchasingManagersIndexFlash: str = "markit services purchasing managers index flash"
            """Markit Services PMI Flash"""

            MarkitServicesPurchasingManagersIndexPreliminary: str = "markit services purchasing managers index preliminary"
            """Markit Services PMI Prel"""

            MartinLKingDay: str = "martin l king day"
            """Martin L. King Day"""

            MartinLKingsBirthday: str = "martin l kings birthday"
            """Martin L. King's Birthday"""

            MartinLutherKingJrDay: str = "martin luther king jr day"
            """Martin Luther King, Jr. Day"""

            MassLayoffs: str = "mass layoffs"
            """Mass Layoffs"""

            MbaMortgageApplications: str = "mba mortgage applications"
            """MBA Mortgage Applications"""

            MbaMortgageApplicationsWoW: str = "mba mortgage applications wow"
            """MBA Mortgage Applications WoW"""

            MbaThirtyYearMortgageRate: str = "mba 30 year mortgage rate"
            """MBA 30-Year Mortgage Rate"""

            MemorialDay: str = "memorial day"
            """Memorial Day"""

            MemorialDayHoliday: str = "memorial day holiday"
            """Memorial Day Holiday"""

            MichiganConsumerExpectationsFinal: str = "michigan consumer expectations final"
            """Michigan Consumer Expectations Final"""

            MichiganConsumerExpectationsPreliminary: str = "michigan consumer expectations preliminary"
            """Michigan Consumer Expectations Prel"""

            MichiganConsumerSentimentFinal: str = "michigan consumer sentiment final"
            """Michigan Consumer Sentiment Final"""

            MichiganConsumerSentimentPreliminary: str = "michigan consumer sentiment preliminary"
            """Michigan Consumer Sentiment Prel"""

            MichiganCurrentConditionsFinal: str = "michigan current conditions final"
            """Michigan Current Conditions Final"""

            MichiganCurrentConditionsPreliminary: str = "michigan current conditions preliminary"
            """Michigan Current Conditions Prel"""

            MichiganFiveYearInflationExpectationsFinal: str = "michigan 5 year inflation expectations final"
            """Michigan 5 Year Inflation Expectations Final"""

            MichiganFiveYearInflationExpectationsPreliminary: str = "michigan 5 year inflation expectations preliminary"
            """Michigan 5 Year Inflation Expectations Prel"""

            MichiganInflationExpectationsFinal: str = "michigan inflation expectations final"
            """Michigan Inflation Expectations Final"""

            MichiganInflationExpectationsPreliminary: str = "michigan inflation expectations preliminary"
            """Michigan Inflation Expectations Prel"""

            MidtermElections: str = "midterm elections"
            """Midterm Elections"""

            MidTermElections: str = "mid term elections"
            """Mid-Term Elections"""

            MonetaryPolicyReport: str = "monetary policy report"
            """Monetary Policy Report"""

            MonthlyBudgetStatement: str = "monthly budget statement"
            """Monthly Budget Statement"""

            NahbHousingMarketIndex: str = "nahb housing market index"
            """NAHB Housing Market Index"""

            NationalActivityIndex: str = "national activity index"
            """National activity index"""

            NetLongTermTicFlows: str = "net long term tic flows"
            """Net Long-Term Tic Flows"""

            NewHomeSales: str = "new home sales"
            """New Home Sales"""

            NewHomeSalesMoM: str = "new home sales mom"
            """New Home Sales MoM"""

            NewYearsDay: str = "new years day"
            """New Year's Day"""

            NewYearsDaySubstituteDay: str = "new years day substitute day"
            """New Year's Day (Substitute Day)"""

            NfibBusinessOptimismIndex: str = "nfib business optimism index"
            """NFIB Business Optimism Index"""

            NonFarmPayrolls: str = "non farm payrolls"
            """Non Farm Payrolls"""

            NonFarmPayrollsPrivate: str = "non farm payrolls private"
            """Nonfarm Payrolls Private"""

            NonFarmProductivityQoQ: str = "non farm productivity qoq"
            """Nonfarm Productivity QoQ"""

            NonFarmProductivityQoQFinal: str = "non farm productivity qoq final"
            """Nonfarm Productivity QoQ Final"""

            NonFarmProductivityQoQPreliminary: str = "non farm productivity qoq preliminary"
            """Nonfarm Productivity QoQ Prel"""

            NonFarmProductivityYoY: str = "non farm productivity yoy"
            """Nonfarm Productivity YoY"""

            NonManufacturingBusinessActivity: str = "non manufacturing business activity"
            """Non-Manufacturing Business Activity"""

            NyEmpireStateManufacturingIndex: str = "ny empire state manufacturing index"
            """NY Empire State Manufacturing Index"""

            ObamacareRepealVotePulled: str = "obamacare repeal vote pulled"
            """Obamacare Repeal Vote - Pulled"""

            OverallNetCapitalFlows: str = "overall net capital flows"
            """Overall Net Capital Flows"""

            ParticipationRate: str = "participation rate"
            """Participation Rate"""

            PendingHomeSalesMoM: str = "pending home sales mom"
            """Pending Home Sales MoM"""

            PendingHomeSalesYoY: str = "pending home sales yoy"
            """Pending Home Sales YoY"""

            PersonalConsumptionExpenditurePriceIndexMoM: str = "personal consumption expenditure price index mom"
            """PCE Price Index MoM"""

            PersonalConsumptionExpenditurePriceIndexQoQ: str = "personal consumption expenditure price index qoq"
            """PCE Prices QoQ"""

            PersonalConsumptionExpenditurePriceIndexQoQAdv: str = "personal consumption expenditure price index qoq adv"
            """PCE Prices QoQ Adv"""

            PersonalConsumptionExpenditurePriceIndexQoQFinal: str = "personal consumption expenditure price index qoq final"
            """PCE Prices QoQ Final"""

            PersonalConsumptionExpenditurePriceIndexQoQSecondEstimate: str = "personal consumption expenditure price index qoq second estimate"
            """PCE Prices QoQ 2 Est"""

            PersonalConsumptionExpenditurePriceIndexYoY: str = "personal consumption expenditure price index yoy"
            """PCE Price Index YoY"""

            PersonalIncomeMoM: str = "personal income mom"
            """Personal Income (MoM)"""

            PersonalSpendingMoM: str = "personal spending mom"
            """Personal Spending MoM"""

            PhiladelphiaFedManufacturingIndex: str = "philadelphia fed manufacturing index"
            """Philadelphia Fed Manufacturing Index"""

            PhiladelphiaFedPlosserSpeech: str = "philadelphia fed plosser speech"
            """Philadelphia Fed Plosser speech"""

            PresidentElectTrumpSpeech: str = "president elect trump speech"
            """President-Elect Trump Speech"""

            PresidentialElectionResults: str = "presidential election results"
            """Presidential Election Results"""

            PresidentialElections: str = "presidential elections"
            """Presidential Elections"""

            PresidentObamaSpeech: str = "president obama speech"
            """President Obama Speech"""

            PresidentObamaStatementOnTheEconomy: str = "president obama statement on the economy"
            """President Obama Statement on the Economy"""

            PresidentsDay: str = "presidents day"
            """President's Day"""

            PresidentTrumpAndPresidentXiJinpingMeeting: str = "president trump and president xi jinping meeting"
            """President Trump and President Xi Jinping Meeting"""

            PresidentTrumpSpeech: str = "president trump speech"
            """President Trump Speech"""

            PresidentTrumpSpeechOnIranDeal: str = "president trump speech on iran deal"
            """President Trump Speech on Iran Deal"""

            PresidentTrumpStateOfTheUnionSpeech: str = "president trump state of the union speech"
            """President Trump State of the Union Speech"""

            PresidentTrumpTaxSpeech: str = "president trump tax speech"
            """President Trump tax speech"""

            ProducerPriceIndexExcludingFoodAndEnergyMoM: str = "producer price index excluding food and energy mom"
            """Producer Price Index ex Food & Energy (MoM)"""

            ProducerPriceIndexExcludingFoodAndEnergyYoY: str = "producer price index excluding food and energy yoy"
            """Producer Price Index ex Food & Energy (YoY)"""

            ProducerPriceIndexMoM: str = "producer price index mom"
            """PPI MoM"""

            ProducerPriceIndexYoY: str = "producer price index yoy"
            """PPI YoY"""

            QuantitativeEasingMortgageBackedSecurities: str = "quantitative easing mortgage backed securities"
            """QE MBS"""

            QuantitativeEasingTotal: str = "quantitative easing total"
            """QE total"""

            QuantitativeEasingTreasuries: str = "quantitative easing treasuries"
            """QE Treasuries"""

            RealConsumerSpending: str = "real consumer spending"
            """Real Consumer Spending"""

            RedbookMoM: str = "redbook mom"
            """Redbook MoM"""

            RedbookYoY: str = "redbook yoy"
            """Redbook YoY"""

            RetailSalesExcludingAutosMoM: str = "retail sales excluding autos mom"
            """Retail Sales Ex Autos MoM"""

            RetailSalesExcludingGasAutosMoM: str = "retail sales excluding gas autos mom"
            """Retail Sales Ex Gas/Autos  MoM"""

            RetailSalesMoM: str = "retail sales mom"
            """Retail Sales MoM"""

            RetailSalesYoY: str = "retail sales yoy"
            """Retail Sales YoY"""

            ReutersMichiganConsumerExpectations: str = "reuters michigan consumer expectations"
            """Reuters Michigan Consumer Expectations"""

            ReutersMichiganConsumerExpectationsFinal: str = "reuters michigan consumer expectations final"
            """Reuters Michigan Consumer Expectations Final"""

            ReutersMichiganConsumerExpectationsPreliminary: str = "reuters michigan consumer expectations preliminary"
            """Reuters Michigan Consumer Expectations Prel"""

            ReutersMichiganConsumerSentimentFinal: str = "reuters michigan consumer sentiment final"
            """Reuters Michigan Consumer Sentiment Final"""

            ReutersMichiganConsumerSentimentIndex: str = "reuters michigan consumer sentiment index"
            """Reuters/Michigan Consumer Sentiment Index"""

            ReutersMichiganConsumerSentimentPreliminary: str = "reuters michigan consumer sentiment preliminary"
            """Reuters Michigan Consumer Sentiment  Prel"""

            ReutersMichiganCurrentConditions: str = "reuters michigan current conditions"
            """Reuters Michigan Current Conditions"""

            ReutersMichiganCurrentConditionsFinal: str = "reuters michigan current conditions final"
            """Reuters Michigan Current Conditions Final"""

            ReutersMichiganCurrentConditionsPreliminary: str = "reuters michigan current conditions preliminary"
            """Reuters Michigan Current Conditions Prel"""

            ReutersMichiganInflationExpectationsPreliminary: str = "reuters michigan inflation expectations preliminary"
            """Reuters Michigan Inflation Expectations Prel"""

            RichmondFedManufacturingIndex: str = "richmond fed manufacturing index"
            """Richmond Fed Manufacturing Index"""

            SandpCaseShillerHomePriceMoM: str = "sandp case shiller home price mom"
            """S&P/Case-Shiller Home Price MoM"""

            SandpCaseShillerHomePriceYoY: str = "sandp case shiller home price yoy"
            """S&P/Case-Shiller Home Price YoY"""

            SevenYearNoteAuction: str = "7 year note auction"
            """7-Year Note Auction"""

            SixMonthBillAuction: str = "6 month bill auction"
            """6-Month Bill Auction"""

            SpringMeetingOfTheWorldBankGroupImf: str = "spring meeting of the world bank group imf"
            """Spring Meeting of the World Bank Group-IMF"""

            TenYearNoteAuction: str = "10 year note auction"
            """10-Year Note Auction"""

            TenYearTipsAuction: str = "10 year tips auction"
            """10-Year TIPS Auction"""

            ThanksgivingDay: str = "thanksgiving day"
            """Thanksgiving Day"""

            ThirtyYearBondAuction: str = "30 year bond auction"
            """30-Year Bond Auction"""

            ThirtyYearNoteAuction: str = "30 year note auction"
            """30-Year Note Auction"""

            ThreeMonthBillAuction: str = "3 month bill auction"
            """3-Month Bill Auction"""

            ThreeYearNoteAuction: str = "3 year note auction"
            """3-Year Note Auction"""

            TotalNetTicFlows: str = "total net tic flows"
            """Total Net TIC Flows"""

            TotalVehicleSales: str = "total vehicle sales"
            """Total Vehicle Sales"""

            TreasurySecLewSpeaks: str = "treasury sec lew speaks"
            """Treasury Sec Lew Speaks"""

            TreasurySecretaryLewSpeaks: str = "treasury secretary lew speaks"
            """Treasury Secretary Lew Speaks"""

            TreasurySecretaryMnuchinSpeech: str = "treasury secretary mnuchin speech"
            """Treasury Secretary Mnuchin Speech"""

            TwoThousandNineteenUsMonetaryPolicyForum: str = "2019 us monetary policy forum"
            """2019 US Monetary Policy Forum"""

            TwoYearFrnAuction: str = "2 year frn auction"
            """2-Year FRN Auction"""

            TwoYearNoteAuction: str = "2 year note auction"
            """2-Year Note Auction"""

            UnemploymentRate: str = "unemployment rate"
            """Unemployment Rate"""

            UnGeneralAssembly: str = "un general assembly"
            """UN General Assembly"""

            UnitLaborCostsIndexQoQ: str = "unit labor costs index qoq"
            """Unit Labor Costs QoQ"""

            UnitLaborCostsIndexQoQFinal: str = "unit labor costs index qoq final"
            """Unit Labor Costs QoQ Final"""

            UnitLaborCostsIndexQoQPreliminary: str = "unit labor costs index qoq preliminary"
            """Unit Labor Costs QoQ Prel"""

            UnitLaborCostsYoY: str = "unit labor costs yoy"
            """Unit Labor Costs YoY"""

            UsChinaPhaseOneTradeDealSignature: str = "us china phase 1 trade deal signature"
            """US-China Phase 1 Trade Deal Signature"""

            UsChinaTradeTalks: str = "us china trade talks"
            """US-China Trade Talks"""

            UsGovTemporaryFundingExpires: str = "us gov temporary funding expires"
            """US Gov Temporary Funding Expires"""

            UsmcaTradeDealSignature: str = "usmca trade deal signature"
            """USMCA Trade Deal Signature"""

            UsMexicoTradeTalks: str = "us mexico trade talks"
            """US-Mexico Trade Talks"""

            UsMonetaryPolicyForum: str = "us monetary policy forum"
            """US Monetary Policy Forum"""

            UsNorthKoreaSummit: str = "us north korea summit"
            """US-North Korea Summit"""

            UsRussiaSummit: str = "us russia summit"
            """US-Russia Summit"""

            VeteransDay: str = "veterans day"
            """Veterans Day"""

            VeteransDaySubstituteDay: str = "veterans day substitute day"
            """Veterans Day (Substitute Day)"""

            WasdeReport: str = "wasde report"
            """WASDE Report"""

            WashingtonsBirthday: str = "washingtons birthday"
            """Washington's Birthday"""

            WhiteHouseJobsAnnouncement: str = "white house jobs announcement"
            """White House Jobs Announcement"""

            WholesaleInventoriesMoM: str = "wholesale inventories mom"
            """Wholesale Inventories MoM"""

            WholesaleInventoriesMoMAdv: str = "wholesale inventories mom adv"
            """Wholesale Inventories MoM Adv"""


class TradingEconomicsEventFilter(System.Object):
    """Provides methods to filter and standardize Trading Economics calendar event names."""

    @staticmethod
    def FilterEvent(eventName: str) -> str:
        """
        Convert and normalizes the Trading Economics calendar "Event" field.
        
        :param eventName: Raw event name
        :returns: Event name normalized.
        """
        ...


class TradingEconomicsDateTimeConverter(JsonConverter):
    """DateTime JSON Converter that handles null value"""

    def ReadJson(self, reader: typing.Any, objectType: typing.Type, existingValue: typing.Any, serializer: typing.Any) -> System.Object:
        """Parse Trading Economics DateTime to C# DateTime"""
        ...

    def WriteJson(self, writer: typing.Any, value: typing.Any, serializer: typing.Any) -> None:
        """Write DateTime objects to JSON"""
        ...

    def CanConvert(self, objectType: typing.Type) -> bool:
        """Indicate if we can convert this object."""
        ...


class TradingEconomicsEarnings(QuantConnect.Data.BaseData):
    """
    Represents the Trading Economics Earnings information.
    https://docs.tradingeconomics.com/#earnings
    """

    @property
    def EndTime(self) -> datetime.datetime:
        """Release time and date in UTC"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """Release time and date in UTC"""
        ...

    @property
    def Symbol(self) -> str:
        """Unique symbol used by Trading Economics"""
        ...

    @Symbol.setter
    def Symbol(self, value: str):
        """Unique symbol used by Trading Economics"""
        ...

    @property
    def EarningsType(self) -> int:
        """This property contains the int value of a member of the QuantConnect.Data.Custom.TradingEconomics.EarningsType enum."""
        ...

    @EarningsType.setter
    def EarningsType(self, value: int):
        """This property contains the int value of a member of the QuantConnect.Data.Custom.TradingEconomics.EarningsType enum."""
        ...

    @property
    def Name(self) -> str:
        """Company name"""
        ...

    @Name.setter
    def Name(self, value: str):
        """Company name"""
        ...

    @property
    def Actual(self) -> typing.Optional[float]:
        """Earnings per share"""
        ...

    @Actual.setter
    def Actual(self, value: typing.Optional[float]):
        """Earnings per share"""
        ...

    @property
    def Value(self) -> float:
        """Earnings per share"""
        ...

    @Value.setter
    def Value(self, value: float):
        """Earnings per share"""
        ...

    @property
    def Forecast(self) -> typing.Optional[float]:
        """Average forecast among a representative group of analysts"""
        ...

    @Forecast.setter
    def Forecast(self, value: typing.Optional[float]):
        """Average forecast among a representative group of analysts"""
        ...

    @property
    def FiscalTag(self) -> str:
        """Fiscal year and quarter"""
        ...

    @FiscalTag.setter
    def FiscalTag(self, value: str):
        """Fiscal year and quarter"""
        ...

    @property
    def FiscalReference(self) -> str:
        """Fiscal year and quarter in different format"""
        ...

    @FiscalReference.setter
    def FiscalReference(self, value: str):
        """Fiscal year and quarter in different format"""
        ...

    @property
    def CalendarReference(self) -> str:
        """Calendar quarter for the release"""
        ...

    @CalendarReference.setter
    def CalendarReference(self, value: str):
        """Calendar quarter for the release"""
        ...

    @property
    def Country(self) -> str:
        """Country name"""
        ...

    @Country.setter
    def Country(self, value: str):
        """Country name"""
        ...

    @property
    def Currency(self) -> str:
        """Currency"""
        ...

    @Currency.setter
    def Currency(self, value: str):
        """Currency"""
        ...

    @property
    def LastUpdate(self) -> datetime.datetime:
        """Time when new data was inserted or changed"""
        ...

    @LastUpdate.setter
    def LastUpdate(self, value: datetime.datetime):
        """Time when new data was inserted or changed"""
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The DateTimeZone of this data type.
        """
        ...


class EarningsType(System.Enum):
    """Earnings type: earnings, ipo, dividends"""

    Earnings = 0
    """Earnings"""

    IPO = 1
    """IPO"""

    Dividends = 2
    """Dividends"""

    Split = 3
    """Stock Splits"""


class TradingEconomicsCalendar(QuantConnect.Data.BaseData):
    """
    Represents the Trading Economics Calendar information:
    The economic calendar covers around 1600 events for more than 150 countries a month.
    https://docs.tradingeconomics.com/#events
    """

    IsAuthCodeSet: bool
    """Determines if the API key has been set"""

    AuthCode: str
    """API key for Trading Economics"""

    @property
    def CalendarId(self) -> str:
        """Unique calendar ID used by Trading Economics"""
        ...

    @CalendarId.setter
    def CalendarId(self, value: str):
        """Unique calendar ID used by Trading Economics"""
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """Release time and date in UTC"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """Release time and date in UTC"""
        ...

    @property
    def Country(self) -> str:
        """Country name"""
        ...

    @Country.setter
    def Country(self, value: str):
        """Country name"""
        ...

    @property
    def Category(self) -> str:
        """Indicator category name"""
        ...

    @Category.setter
    def Category(self, value: str):
        """Indicator category name"""
        ...

    @property
    def Event(self) -> str:
        """Specific event name in the calendar"""
        ...

    @Event.setter
    def Event(self, value: str):
        """Specific event name in the calendar"""
        ...

    @property
    def EventRaw(self) -> str:
        """Raw event name as provided by Trading Economics"""
        ...

    @EventRaw.setter
    def EventRaw(self, value: str):
        """Raw event name as provided by Trading Economics"""
        ...

    @property
    def Reference(self) -> str:
        """The period for which released data refers to"""
        ...

    @Reference.setter
    def Reference(self, value: str):
        """The period for which released data refers to"""
        ...

    @property
    def Source(self) -> str:
        """Source of data"""
        ...

    @Source.setter
    def Source(self, value: str):
        """Source of data"""
        ...

    @property
    def Actual(self) -> typing.Optional[float]:
        """Latest released value"""
        ...

    @Actual.setter
    def Actual(self, value: typing.Optional[float]):
        """Latest released value"""
        ...

    @property
    def Previous(self) -> typing.Optional[float]:
        """Value for the previous period after the revision (if revision is applicable)"""
        ...

    @Previous.setter
    def Previous(self, value: typing.Optional[float]):
        """Value for the previous period after the revision (if revision is applicable)"""
        ...

    @property
    def Forecast(self) -> typing.Optional[float]:
        """Average forecast among a representative group of economists"""
        ...

    @Forecast.setter
    def Forecast(self, value: typing.Optional[float]):
        """Average forecast among a representative group of economists"""
        ...

    @property
    def TradingEconomicsForecast(self) -> typing.Optional[float]:
        """TradingEconomics own projections"""
        ...

    @TradingEconomicsForecast.setter
    def TradingEconomicsForecast(self, value: typing.Optional[float]):
        """TradingEconomics own projections"""
        ...

    @property
    def DateSpan(self) -> str:
        """
        0 indicates that the time of the event is known,
        1 indicates that we only know the date of event, the exact time of event is unknown
        """
        ...

    @DateSpan.setter
    def DateSpan(self, value: str):
        """
        0 indicates that the time of the event is known,
        1 indicates that we only know the date of event, the exact time of event is unknown
        """
        ...

    @property
    def Importance(self) -> int:
        """
        Importance of a TradingEconomics information
        
        This property contains the int value of a member of the QuantConnect.Data.Custom.TradingEconomics.TradingEconomicsImportance enum.
        """
        ...

    @Importance.setter
    def Importance(self, value: int):
        """
        Importance of a TradingEconomics information
        
        This property contains the int value of a member of the QuantConnect.Data.Custom.TradingEconomics.TradingEconomicsImportance enum.
        """
        ...

    @property
    def LastUpdate(self) -> datetime.datetime:
        """Time when new data was inserted or changed"""
        ...

    @LastUpdate.setter
    def LastUpdate(self, value: datetime.datetime):
        """Time when new data was inserted or changed"""
        ...

    @property
    def Revised(self) -> typing.Optional[float]:
        """Value reported in the previous period after revision"""
        ...

    @Revised.setter
    def Revised(self, value: typing.Optional[float]):
        """Value reported in the previous period after revision"""
        ...

    @property
    def OCountry(self) -> str:
        """Country's original name"""
        ...

    @OCountry.setter
    def OCountry(self, value: str):
        """Country's original name"""
        ...

    @property
    def OCategory(self) -> str:
        """Category's original name"""
        ...

    @OCategory.setter
    def OCategory(self, value: str):
        """Category's original name"""
        ...

    @property
    def Ticker(self) -> str:
        """Unique ticker used by Trading Economics"""
        ...

    @Ticker.setter
    def Ticker(self, value: str):
        """Unique ticker used by Trading Economics"""
        ...

    @property
    def IsPercentage(self) -> bool:
        """Indicates whether the Actual, Previous, Forecast, TradingEconomicsForecast fields are reported as percent values"""
        ...

    @IsPercentage.setter
    def IsPercentage(self, value: bool):
        """Indicates whether the Actual, Previous, Forecast, TradingEconomicsForecast fields are reported as percent values"""
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: datetime.datetime, isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the Subscription Data Source gained from the URL
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Subscription Data Source.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: datetime.datetime, isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Reader converts each line of the data source into BaseData objects.
        
        :param config: Subscription data config setup object
        :param line: Line from the data source
        :param date: Date of the requested data
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: TradingEconomicsCalendar or BaseDataCollection object containing TradingEconomicsCalendar as its Data.
        """
        ...

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Clones the data. This is required for some custom data
        
        :returns: A new cloned instance.
        """
        ...

    def ToString(self) -> str:
        """Formats a string with the Trading Economics Calendar information."""
        ...

    def ToCsv(self) -> str:
        """
        Convert this instance to a CSV file
        
        :returns: string as CSV.
        """
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The DateTimeZone of this data type.
        """
        ...

    @staticmethod
    def SetAuthCode(authCode: str) -> None:
        """
        Sets the Trading Economics API key.
        
        :param authCode: The Trading Economics API key
        """
        ...

    @staticmethod
    def ProcessAPIResponse(content: str) -> System.Collections.Generic.List[QuantConnect.Data.Custom.TradingEconomics.TradingEconomicsCalendar]:
        """
        Parses the raw Trading Economics calendar API result
        
        :param content: Contents of returned data
        :returns: List of instances of the current class.
        """
        ...

    @staticmethod
    def ParseDecimal(value: str, inPercent: bool) -> typing.Optional[float]:
        """
        Parse decimal from calendar data
        
        :param value: Value to parse
        :param inPercent: Is the value a percentage
        :returns: Nullable decimal.
        """
        ...

    @staticmethod
    def CountryToCurrencyCode(country: str) -> str:
        """
        Converts country name to currency code (ISO 4217)
        
        :param country: Country name
        :returns: ISO 4217 currency code.
        """
        ...


class TradingEconomicsImportance(System.Enum):
    """Importance of a TradingEconomics information"""

    Low = 0
    """Low importance"""

    Medium = 1
    """Medium importance"""

    High = 2
    """High importance"""


class TradingEconomicsIndicator(QuantConnect.Data.BaseData):
    """
    Represents the Trading Economics Indicator information.
    https://docs.tradingeconomics.com/#indicators
    """

    @property
    def Country(self) -> str:
        """Country name"""
        ...

    @Country.setter
    def Country(self, value: str):
        """Country name"""
        ...

    @property
    def Category(self) -> str:
        """Indicator category name"""
        ...

    @Category.setter
    def Category(self, value: str):
        """Indicator category name"""
        ...

    @property
    def EndTime(self) -> datetime.datetime:
        """Release time and date in UTC"""
        ...

    @EndTime.setter
    def EndTime(self, value: datetime.datetime):
        """Release time and date in UTC"""
        ...

    @property
    def Value(self) -> float:
        """Value"""
        ...

    @Value.setter
    def Value(self, value: float):
        """Value"""
        ...

    @property
    def Frequency(self) -> str:
        """Frequency of the indicator"""
        ...

    @Frequency.setter
    def Frequency(self, value: str):
        """Frequency of the indicator"""
        ...

    @property
    def LastUpdate(self) -> datetime.datetime:
        """Time when new data was inserted or changed"""
        ...

    @LastUpdate.setter
    def LastUpdate(self, value: datetime.datetime):
        """Time when new data was inserted or changed"""
        ...

    @property
    def HistoricalDataSymbol(self) -> str:
        """Unique symbol used by Trading Economics"""
        ...

    @HistoricalDataSymbol.setter
    def HistoricalDataSymbol(self, value: str):
        """Unique symbol used by Trading Economics"""
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: datetime.datetime, isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """
        Return the Subscription Data Source gained from the URL
        
        :param config: Configuration object
        :param date: Date of this source file
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Subscription Data Source.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, content: str, date: datetime.datetime, isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """
        Reader converts each line of the data source into BaseData objects.
        
        :param config: Subscription data config setup object
        :param content: Content of the source document
        :param date: Date of the requested data
        :param isLiveMode: true if we're in live mode, false for backtesting mode
        :returns: Collection of TradingEconomicsIndicator objects.
        """
        ...

    def Clone(self) -> QuantConnect.Data.BaseData:
        """
        Clones the data. This is required for some custom data
        
        :returns: A new cloned instance.
        """
        ...

    def ToString(self) -> str:
        """Formats a string with the Trading Economics Indicator information."""
        ...

    def DataTimeZone(self) -> typing.Any:
        """
        Specifies the data time zone for this data type. This is useful for custom data types
        
        :returns: The DateTimeZone of this data type.
        """
        ...


