import abc
import datetime
import typing

import QuantConnect
import QuantConnect.Data
import QuantConnect.Data.Fundamental
import System
import System.Collections.Generic


class CompanyReference(System.Object):
    """Definition of the CompanyReference class"""

    @property
    def CompanyId(self) -> str:
        """10-digit unique and unchanging Morningstar identifier assigned to every company."""
        ...

    @CompanyId.setter
    def CompanyId(self, value: str):
        """10-digit unique and unchanging Morningstar identifier assigned to every company."""
        ...

    @property
    def ShortName(self) -> str:
        """
        25-character max abbreviated name of the firm.  In most cases, the short name will simply be the Legal Name less the
        "Corporation", "Corp.", "Inc.", "Incorporated", etc...
        """
        ...

    @ShortName.setter
    def ShortName(self, value: str):
        """
        25-character max abbreviated name of the firm.  In most cases, the short name will simply be the Legal Name less the
        "Corporation", "Corp.", "Inc.", "Incorporated", etc...
        """
        ...

    @property
    def StandardName(self) -> str:
        """The English translation of the foreign legal name if/when applicable."""
        ...

    @StandardName.setter
    def StandardName(self, value: str):
        """The English translation of the foreign legal name if/when applicable."""
        ...

    @property
    def LegalName(self) -> str:
        """The full name of the registrant as specified in its charter, and most often found on the front cover of the 10K/10Q/20F filing."""
        ...

    @LegalName.setter
    def LegalName(self, value: str):
        """The full name of the registrant as specified in its charter, and most often found on the front cover of the 10K/10Q/20F filing."""
        ...

    @property
    def CountryId(self) -> str:
        """3 Character ISO code of the country where the firm is domiciled. See separate reference document for Country Mappings."""
        ...

    @CountryId.setter
    def CountryId(self, value: str):
        """3 Character ISO code of the country where the firm is domiciled. See separate reference document for Country Mappings."""
        ...

    @property
    def CIK(self) -> str:
        """The Central Index Key; a corporate identifier assigned by the Securities and Exchange Commission (SEC)."""
        ...

    @CIK.setter
    def CIK(self, value: str):
        """The Central Index Key; a corporate identifier assigned by the Securities and Exchange Commission (SEC)."""
        ...

    @property
    def CompanyStatus(self) -> str:
        """
        At the Company level; each company is assigned to 1 of 3 possible status classifications; (U) Public, (V) Private, or (O) Obsolete:
        - Public-Firm is operating and currently has at least one common share class that is currently trading on a public exchange.
        - Private-Firm is operating but does not have any common share classes currently trading on a public exchange.
        - Obsolete-Firm is no longer operating because it closed its business, or was acquired.
        """
        ...

    @CompanyStatus.setter
    def CompanyStatus(self, value: str):
        """
        At the Company level; each company is assigned to 1 of 3 possible status classifications; (U) Public, (V) Private, or (O) Obsolete:
        - Public-Firm is operating and currently has at least one common share class that is currently trading on a public exchange.
        - Private-Firm is operating but does not have any common share classes currently trading on a public exchange.
        - Obsolete-Firm is no longer operating because it closed its business, or was acquired.
        """
        ...

    @property
    def FiscalYearEnd(self) -> int:
        """The Month of the company's latest fiscal year."""
        ...

    @FiscalYearEnd.setter
    def FiscalYearEnd(self, value: int):
        """The Month of the company's latest fiscal year."""
        ...

    @property
    def IndustryTemplateCode(self) -> str:
        """
        This indicator will denote which one of the six industry data collection templates applies to the company.  Each industry data
        collection template includes data elements that are commonly reported by companies in that industry.  N=Normal
        (Manufacturing), M=Mining,  U=Utility, T=Transportation, B=Bank, I=Insurance
        """
        ...

    @IndustryTemplateCode.setter
    def IndustryTemplateCode(self, value: str):
        """
        This indicator will denote which one of the six industry data collection templates applies to the company.  Each industry data
        collection template includes data elements that are commonly reported by companies in that industry.  N=Normal
        (Manufacturing), M=Mining,  U=Utility, T=Transportation, B=Bank, I=Insurance
        """
        ...

    @property
    def PrimaryShareClassID(self) -> str:
        """
        The 10-digit unique and unchanging Morningstar identifier assigned to the Primary Share class of a company. The primary share of a
        company is defined as the first share that was traded publicly and is still actively trading. If this share is no longer trading, the
        primary share will be the share with the highest volume.
        """
        ...

    @PrimaryShareClassID.setter
    def PrimaryShareClassID(self, value: str):
        """
        The 10-digit unique and unchanging Morningstar identifier assigned to the Primary Share class of a company. The primary share of a
        company is defined as the first share that was traded publicly and is still actively trading. If this share is no longer trading, the
        primary share will be the share with the highest volume.
        """
        ...

    @property
    def PrimarySymbol(self) -> str:
        """
        The symbol of the Primary Share of the company, composed of an arrangement of characters (often letters) representing a
        particular security listed on an exchange or otherwise traded publicly.   The primary share of a company is defined as the first share
        that was traded publicly and is still actively trading. If this share is no longer trading, the primary share will be the share with the
        highest volume. Note: Morningstar's multi-share class symbols will often contain a "period" within the symbol; e.g. BRK.B for
        Berkshire Hathaway Class B.
        """
        ...

    @PrimarySymbol.setter
    def PrimarySymbol(self, value: str):
        """
        The symbol of the Primary Share of the company, composed of an arrangement of characters (often letters) representing a
        particular security listed on an exchange or otherwise traded publicly.   The primary share of a company is defined as the first share
        that was traded publicly and is still actively trading. If this share is no longer trading, the primary share will be the share with the
        highest volume. Note: Morningstar's multi-share class symbols will often contain a "period" within the symbol; e.g. BRK.B for
        Berkshire Hathaway Class B.
        """
        ...

    @property
    def PrimaryExchangeID(self) -> str:
        """
        The Id representing the stock exchange of the Primary Share of the company.  See separate reference document for Exchange
        Mappings. The primary share of a company is defined as the first share that was traded publicly with and is still actively trading. If
        this share is no longer trading, the primary share will be the share with the highest volume.
        """
        ...

    @PrimaryExchangeID.setter
    def PrimaryExchangeID(self, value: str):
        """
        The Id representing the stock exchange of the Primary Share of the company.  See separate reference document for Exchange
        Mappings. The primary share of a company is defined as the first share that was traded publicly with and is still actively trading. If
        this share is no longer trading, the primary share will be the share with the highest volume.
        """
        ...

    @property
    def BusinessCountryID(self) -> str:
        """
        In some cases, different from the country of domicile (CountryId; DataID 5).  This element is a three (3) Character ISO code of the
        business country of the security.  It is determined by a few factors, including:
        """
        ...

    @BusinessCountryID.setter
    def BusinessCountryID(self, value: str):
        """
        In some cases, different from the country of domicile (CountryId; DataID 5).  This element is a three (3) Character ISO code of the
        business country of the security.  It is determined by a few factors, including:
        """
        ...

    @property
    def LegalNameLanguageCode(self) -> str:
        """The language code for the foreign legal name if/when applicable.  Related to  DataID 4 (LegalName)."""
        ...

    @LegalNameLanguageCode.setter
    def LegalNameLanguageCode(self, value: str):
        """The language code for the foreign legal name if/when applicable.  Related to  DataID 4 (LegalName)."""
        ...

    @property
    def Auditor(self) -> str:
        """
        The legal (registered) name of the company's current auditor. Distinct from DataID 28000 Period Auditor that identifies the Auditor
        related to that period's financial statements.
        """
        ...

    @Auditor.setter
    def Auditor(self, value: str):
        """
        The legal (registered) name of the company's current auditor. Distinct from DataID 28000 Period Auditor that identifies the Auditor
        related to that period's financial statements.
        """
        ...

    @property
    def AuditorLanguageCode(self) -> str:
        """The ISO code denoting the language text for Auditor's name and contact information."""
        ...

    @AuditorLanguageCode.setter
    def AuditorLanguageCode(self, value: str):
        """The ISO code denoting the language text for Auditor's name and contact information."""
        ...

    @property
    def Advisor(self) -> str:
        """The legal (registered) name of the current legal Advisor of the company."""
        ...

    @Advisor.setter
    def Advisor(self, value: str):
        """The legal (registered) name of the current legal Advisor of the company."""
        ...

    @property
    def AdvisorLanguageCode(self) -> str:
        """The ISO code denoting the language text for Advisor's name and contact information."""
        ...

    @AdvisorLanguageCode.setter
    def AdvisorLanguageCode(self, value: str):
        """The ISO code denoting the language text for Advisor's name and contact information."""
        ...

    @property
    def IsLimitedPartnership(self) -> bool:
        """
        Indicator to denote if the company is a limited partnership, which is a form of business structure comprised of a general partner and
        limited partners. 1 denotes it is a LP; otherwise 0.
        """
        ...

    @IsLimitedPartnership.setter
    def IsLimitedPartnership(self, value: bool):
        """
        Indicator to denote if the company is a limited partnership, which is a form of business structure comprised of a general partner and
        limited partners. 1 denotes it is a LP; otherwise 0.
        """
        ...

    @property
    def IsREIT(self) -> bool:
        """Indicator to denote if the company is a real estate investment trust (REIT). 1 denotes it is a REIT; otherwise 0."""
        ...

    @IsREIT.setter
    def IsREIT(self, value: bool):
        """Indicator to denote if the company is a real estate investment trust (REIT). 1 denotes it is a REIT; otherwise 0."""
        ...

    @property
    def PrimaryMIC(self) -> str:
        """
        The MIC (market identifier code) of the PrimarySymbol of the company. See Data Appendix A for the relevant MIC to exchange
        name mapping.
        """
        ...

    @PrimaryMIC.setter
    def PrimaryMIC(self, value: str):
        """
        The MIC (market identifier code) of the PrimarySymbol of the company. See Data Appendix A for the relevant MIC to exchange
        name mapping.
        """
        ...

    @property
    def ReportStyle(self) -> int:
        """
        This refers to the financial template used to collect the company's financial statements. There are two report styles representing
        two different financial template structures. Report style "1" is most commonly used by US and Canadian companies, and Report
        style "3" is most commonly used by the rest of the universe. Contact your client manager for access to the respective templates.
        """
        ...

    @ReportStyle.setter
    def ReportStyle(self, value: int):
        """
        This refers to the financial template used to collect the company's financial statements. There are two report styles representing
        two different financial template structures. Report style "1" is most commonly used by US and Canadian companies, and Report
        style "3" is most commonly used by the rest of the universe. Contact your client manager for access to the respective templates.
        """
        ...

    @property
    def YearofEstablishment(self) -> str:
        """The year a company was founded."""
        ...

    @YearofEstablishment.setter
    def YearofEstablishment(self, value: str):
        """The year a company was founded."""
        ...

    @property
    def IsLimitedLiabilityCompany(self) -> bool:
        """Indicator to denote if the company is a limited liability company. 1 denotes it is a LLC; otherwise 0."""
        ...

    @IsLimitedLiabilityCompany.setter
    def IsLimitedLiabilityCompany(self, value: bool):
        """Indicator to denote if the company is a limited liability company. 1 denotes it is a LLC; otherwise 0."""
        ...

    @property
    def ExpectedFiscalYearEnd(self) -> datetime.datetime:
        """
        The upcoming expected year end for the company. It is calculated based on current year end (from latest available annual report)
        + 1 year.
        """
        ...

    @ExpectedFiscalYearEnd.setter
    def ExpectedFiscalYearEnd(self, value: datetime.datetime):
        """
        The upcoming expected year end for the company. It is calculated based on current year end (from latest available annual report)
        + 1 year.
        """
        ...

    def __init__(self) -> None:
        """Creates an instance of the CompanyReference class"""
        ...

    def UpdateValues(self, update: QuantConnect.Data.Fundamental.CompanyReference) -> None:
        """
        Applies updated values from  to this instance
        
        :param update: The next data update for this instance
        """
        ...


class SecurityReference(System.Object):
    """Definition of the SecurityReference class"""

    @property
    def SecuritySymbol(self) -> str:
        """
        An arrangement of characters (often letters) representing a particular security listed on an exchange or otherwise traded publicly.
        Note: Morningstar's multi-share class symbols will often contain a "period" within the symbol; e.g. BRK.B for Berkshire Hathaway
        Class B.
        """
        ...

    @SecuritySymbol.setter
    def SecuritySymbol(self, value: str):
        """
        An arrangement of characters (often letters) representing a particular security listed on an exchange or otherwise traded publicly.
        Note: Morningstar's multi-share class symbols will often contain a "period" within the symbol; e.g. BRK.B for Berkshire Hathaway
        Class B.
        """
        ...

    @property
    def ExchangeId(self) -> str:
        """
        The Id representing the stock exchange that the particular share class is trading.  See separate reference document for Exchange
        Mappings.
        """
        ...

    @ExchangeId.setter
    def ExchangeId(self, value: str):
        """
        The Id representing the stock exchange that the particular share class is trading.  See separate reference document for Exchange
        Mappings.
        """
        ...

    @property
    def CurrencyId(self) -> str:
        """
        3 Character ISO code of the currency that the exchange price is denominated in; i.e. the trading currency of the security.  See
        separate reference document for Currency Mappings.
        """
        ...

    @CurrencyId.setter
    def CurrencyId(self, value: str):
        """
        3 Character ISO code of the currency that the exchange price is denominated in; i.e. the trading currency of the security.  See
        separate reference document for Currency Mappings.
        """
        ...

    @property
    def Valoren(self) -> str:
        """"""
        ...

    @Valoren.setter
    def Valoren(self, value: str):
        """"""
        ...

    @property
    def IPODate(self) -> datetime.datetime:
        """The initial day that the share begins trading on a public exchange."""
        ...

    @IPODate.setter
    def IPODate(self, value: datetime.datetime):
        """The initial day that the share begins trading on a public exchange."""
        ...

    @property
    def IsDepositaryReceipt(self) -> bool:
        """Indicator to denote if the share class is a depository receipt. 1 denotes it is an ADR or GDR; otherwise 0."""
        ...

    @IsDepositaryReceipt.setter
    def IsDepositaryReceipt(self, value: bool):
        """Indicator to denote if the share class is a depository receipt. 1 denotes it is an ADR or GDR; otherwise 0."""
        ...

    @property
    def DepositaryReceiptRatio(self) -> float:
        """The number of underlying common shares backing each American Depository Receipt traded."""
        ...

    @DepositaryReceiptRatio.setter
    def DepositaryReceiptRatio(self, value: float):
        """The number of underlying common shares backing each American Depository Receipt traded."""
        ...

    @property
    def SecurityType(self) -> str:
        """
        Each security will be assigned to one of the below security type classifications;
        - Common Stock (ST00000001)
        - Preferred Stock (ST00000002)
        - Units (ST000000A1)
        """
        ...

    @SecurityType.setter
    def SecurityType(self, value: str):
        """
        Each security will be assigned to one of the below security type classifications;
        - Common Stock (ST00000001)
        - Preferred Stock (ST00000002)
        - Units (ST000000A1)
        """
        ...

    @property
    def ShareClassDescription(self) -> str:
        """
        Provides information when applicable such as whether the share class is Class A or Class B, an ADR, GDR, or a business
        development company (BDC).  For preferred stocks, this field provides more detail about the preferred share class.
        """
        ...

    @ShareClassDescription.setter
    def ShareClassDescription(self, value: str):
        """
        Provides information when applicable such as whether the share class is Class A or Class B, an ADR, GDR, or a business
        development company (BDC).  For preferred stocks, this field provides more detail about the preferred share class.
        """
        ...

    @property
    def ShareClassStatus(self) -> str:
        """
        At the ShareClass level; each share is assigned to 1 of 4 possible status classifications; (A) Active, (D) Deactive, (I) Inactive, or (O)
        Obsolete:
        - Active-Share class is currently trading in a public market, and we have fundamental data available.
        - Deactive-Share class was once Active, but is no longer trading due to share being delisted from the exchange.
        - Inactive-Share class is currently trading in a public market, but no fundamental data is available.
        - Obsolete-Share class was once Inactive, but is no longer trading due to share being delisted from the exchange.
        """
        ...

    @ShareClassStatus.setter
    def ShareClassStatus(self, value: str):
        """
        At the ShareClass level; each share is assigned to 1 of 4 possible status classifications; (A) Active, (D) Deactive, (I) Inactive, or (O)
        Obsolete:
        - Active-Share class is currently trading in a public market, and we have fundamental data available.
        - Deactive-Share class was once Active, but is no longer trading due to share being delisted from the exchange.
        - Inactive-Share class is currently trading in a public market, but no fundamental data is available.
        - Obsolete-Share class was once Inactive, but is no longer trading due to share being delisted from the exchange.
        """
        ...

    @property
    def IsPrimaryShare(self) -> bool:
        """
        This indicator will denote if the indicated share is the primary share for the company. A "1" denotes the primary share, a "0"
        denotes a share that is not the primary share. The primary share is defined as the first share that a company IPO'd with and is still
        actively trading. If this share is no longer trading, we will denote the primary share as the share with the highest volume.
        """
        ...

    @IsPrimaryShare.setter
    def IsPrimaryShare(self, value: bool):
        """
        This indicator will denote if the indicated share is the primary share for the company. A "1" denotes the primary share, a "0"
        denotes a share that is not the primary share. The primary share is defined as the first share that a company IPO'd with and is still
        actively trading. If this share is no longer trading, we will denote the primary share as the share with the highest volume.
        """
        ...

    @property
    def IsDividendReinvest(self) -> bool:
        """Shareholder election plan to re-invest cash dividend into additional shares."""
        ...

    @IsDividendReinvest.setter
    def IsDividendReinvest(self, value: bool):
        """Shareholder election plan to re-invest cash dividend into additional shares."""
        ...

    @property
    def IsDirectInvest(self) -> bool:
        """A plan to make it possible for individual investors to invest in public companies without going through a stock broker."""
        ...

    @IsDirectInvest.setter
    def IsDirectInvest(self, value: bool):
        """A plan to make it possible for individual investors to invest in public companies without going through a stock broker."""
        ...

    @property
    def InvestmentId(self) -> str:
        """Identifier assigned to each security Morningstar covers."""
        ...

    @InvestmentId.setter
    def InvestmentId(self, value: str):
        """Identifier assigned to each security Morningstar covers."""
        ...

    @property
    def IPOOfferPrice(self) -> float:
        """
        IPO offer price indicates the price at which an issuer sells its shares under an initial public offering (IPO). The offer price is set by
        issuer and its underwriters.
        """
        ...

    @IPOOfferPrice.setter
    def IPOOfferPrice(self, value: float):
        """
        IPO offer price indicates the price at which an issuer sells its shares under an initial public offering (IPO). The offer price is set by
        issuer and its underwriters.
        """
        ...

    @property
    def DelistingDate(self) -> datetime.datetime:
        """The date on which an inactive security was delisted from an exchange."""
        ...

    @DelistingDate.setter
    def DelistingDate(self, value: datetime.datetime):
        """The date on which an inactive security was delisted from an exchange."""
        ...

    @property
    def DelistingReason(self) -> str:
        """
        The reason for an inactive security's delisting from an exchange. The full list of Delisting Reason codes can be found within the Data
        Definitions- Appendix A DelistingReason Codes tab.
        """
        ...

    @DelistingReason.setter
    def DelistingReason(self, value: str):
        """
        The reason for an inactive security's delisting from an exchange. The full list of Delisting Reason codes can be found within the Data
        Definitions- Appendix A DelistingReason Codes tab.
        """
        ...

    @property
    def MIC(self) -> str:
        """
        The MIC (market identifier code) of the related shareclass of the company. See Data Appendix A for the relevant MIC to exchange
        name mapping.
        """
        ...

    @MIC.setter
    def MIC(self, value: str):
        """
        The MIC (market identifier code) of the related shareclass of the company. See Data Appendix A for the relevant MIC to exchange
        name mapping.
        """
        ...

    @property
    def CommonShareSubType(self) -> str:
        """
        Refers to the type of securities that can be found within the equity database. For the vast majority, this value will populate as null
        for regular common shares. For a minority of shareclasses, this will populate as either "Participating Preferred", "Closed-End Fund",
        "Foreign Share", or "Foreign Participated Preferred" which reflects our limited coverage of these types of securities within our
        equity database.
        """
        ...

    @CommonShareSubType.setter
    def CommonShareSubType(self, value: str):
        """
        Refers to the type of securities that can be found within the equity database. For the vast majority, this value will populate as null
        for regular common shares. For a minority of shareclasses, this will populate as either "Participating Preferred", "Closed-End Fund",
        "Foreign Share", or "Foreign Participated Preferred" which reflects our limited coverage of these types of securities within our
        equity database.
        """
        ...

    @property
    def IPOOfferPriceRange(self) -> str:
        """
        The estimated offer price range (low-high) for a new IPO. The field should be used until the final IPO price becomes available, as
        populated in the data field "IPOPrice".
        """
        ...

    @IPOOfferPriceRange.setter
    def IPOOfferPriceRange(self, value: str):
        """
        The estimated offer price range (low-high) for a new IPO. The field should be used until the final IPO price becomes available, as
        populated in the data field "IPOPrice".
        """
        ...

    @property
    def ExchangeSubMarketGlobalId(self) -> str:
        """Classification to denote different Marketplace or Market tiers within a stock exchange."""
        ...

    @ExchangeSubMarketGlobalId.setter
    def ExchangeSubMarketGlobalId(self, value: str):
        """Classification to denote different Marketplace or Market tiers within a stock exchange."""
        ...

    @property
    def ConversionRatio(self) -> float:
        """The relationship between the chosen share class and the primary share class."""
        ...

    @ConversionRatio.setter
    def ConversionRatio(self, value: float):
        """The relationship between the chosen share class and the primary share class."""
        ...

    @property
    def ParValue(self) -> float:
        """Nominal value of a security determined by the issuing company."""
        ...

    @ParValue.setter
    def ParValue(self, value: float):
        """Nominal value of a security determined by the issuing company."""
        ...

    @property
    def TradingStatus(self) -> bool:
        """"""
        ...

    @TradingStatus.setter
    def TradingStatus(self, value: bool):
        """"""
        ...

    @property
    def MarketDataID(self) -> str:
        """"""
        ...

    @MarketDataID.setter
    def MarketDataID(self, value: str):
        """"""
        ...

    def __init__(self) -> None:
        """Creates an instance of the SecurityReference class"""
        ...

    def UpdateValues(self, update: QuantConnect.Data.Fundamental.SecurityReference) -> None:
        """
        Applies updated values from  to this instance
        
        :param update: The next data update for this instance
        """
        ...


class MultiPeriodField(System.Object, metaclass=abc.ABCMeta):
    """Abstract base class for multi-period fields"""

    class PeriodField:
        """
        Helper, and internal struct use to hold the values for a period.
        
        This class is protected.
        """

        @property
        def Period(self) -> int:
            """The period associated with this value PeriodAsByte"""
            ...

        @Period.setter
        def Period(self, value: int):
            """The period associated with this value PeriodAsByte"""
            ...

        @property
        def Value(self) -> float:
            """The value for this period"""
            ...

        @Value.setter
        def Value(self, value: float):
            """The value for this period"""
            ...

        def __init__(self, period: int, value: float) -> None:
            """Creates a new period field instance"""
            ...

    @property
    def Store(self) -> typing.List[QuantConnect.Data.Fundamental.MultiPeriodField.PeriodField]:
        """
        The dictionary store containing all values for the multi-period field
        
        This field is protected.
        """
        ...

    @Store.setter
    def Store(self, value: typing.List[QuantConnect.Data.Fundamental.MultiPeriodField.PeriodField]):
        """
        The dictionary store containing all values for the multi-period field
        
        This field is protected.
        """
        ...

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def HasValue(self) -> bool:
        """Returns true if the field contains a value for the default period"""
        ...

    @property
    def Value(self) -> float:
        """Returns the default value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """
        Creates a new instance
        
        This method is protected.
        """
        ...

    @typing.overload
    def GetPeriodValue(self, period: str) -> float:
        """
        Gets the value of the field for the requested period
        
        :param period: The requested period
        :returns: The value for the period.
        """
        ...

    @typing.overload
    def GetPeriodValue(self, period: int) -> float:
        """
        Internal implementation which gets the value of the field for the requested period
        
        This method is protected.
        """
        ...

    def HasPeriodValue(self, period: str) -> bool:
        """
        Returns true if the field contains a value for the requested period
        
        :param period: The requested period
        """
        ...

    def GetPeriodNames(self) -> System.Collections.Generic.IEnumerable[str]:
        """
        Gets the list of available period names for the field
        
        :returns: The list of periods.
        """
        ...

    def GetPeriodValues(self) -> System.Collections.Generic.IReadOnlyDictionary[str, float]:
        """
        Gets a dictionary of period names and values for the field
        
        :returns: The dictionary of period names and values.
        """
        ...

    @typing.overload
    def SetPeriodValue(self, period: str, value: float) -> None:
        """
        Sets the value of the field for the specified period
        
        :param period: The period
        :param value: The value to be set
        """
        ...

    @typing.overload
    def SetPeriodValue(self, period: int, value: float) -> None:
        """
        Internal implementation which sets the value of the field for the specified period
        
        This method is protected.
        """
        ...

    def HasValues(self) -> bool:
        """Returns true if the field has at least one value for one period"""
        ...

    def UpdateValues(self, update: QuantConnect.Data.Fundamental.MultiPeriodField) -> None:
        """
        Applies updated values from  to this instance
        
        :param update: The next data update for this instance
        """
        ...

    def ToString(self) -> str:
        """
        Returns a string that represents the current object.
        
        :returns: A string that represents the current object.
        """
        ...


class TotalRiskBasedCapital(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The sum of Tier 1 and Tier 2 Capital. Tier 1 capital consists of common shareholders equity, perpetual preferred shareholders equity
    with non-cumulative dividends, retained earnings, and minority interests in the equity accounts of consolidated subsidiaries. Tier 2
    capital consists of subordinated debt, intermediate-term preferred stock, cumulative and long-term preferred stock, and a portion of
    a bank's allowance for loan and lease losses.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalRiskBasedCapital class"""
        ...


class AmortizationIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The non-cash expense recognized on intangible assets over the benefit period of the asset."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AmortizationIncomeStatement class"""
        ...


class SecuritiesAmortizationIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The gradual elimination of a liability, such as a mortgage, in regular payments over a specified period of time. Such payments must
    be sufficient to cover both principal and interest.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the SecuritiesAmortizationIncomeStatement class"""
        ...


class CostOfRevenueIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The aggregate cost of goods produced and sold and services rendered during the reporting PeriodAsByte. It excludes all operating
    expenses such as depreciation, depletion, amortization, and SG&A. For the must have cost industry, if the number is not reported
    by the company, it will be calculated based on accounting equation.
    Cost of Revenue = Revenue - Operating Expenses - Operating Profit.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CostOfRevenueIncomeStatement class"""
        ...


class DepletionIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The non-cash expense recognized on natural resources (eg. Oil and mineral deposits) over the benefit period of the asset."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DepletionIncomeStatement class"""
        ...


class DepreciationIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The current period non-cash expense recognized on tangible assets used in the normal course of business, by allocating the cost of
    assets over their useful lives, in the Income Statement. Examples of tangible asset include buildings, production and equipment.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DepreciationIncomeStatement class"""
        ...


class DepreciationAndAmortizationIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The sum of depreciation and amortization expense in the Income Statement.
    Depreciation is the non-cash expense recognized on tangible assets used in the normal course of business, by allocating the cost of
    assets over their useful lives
    Amortization is the non-cash expense recognized on intangible assets over the benefit period of the asset.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DepreciationAndAmortizationIncomeStatement class"""
        ...


class DepreciationAmortizationDepletionIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The sum of depreciation, amortization and depletion expense in the Income Statement.
    Depreciation is the non-cash expense recognized on tangible assets used in the normal course of business, by allocating the cost of
    assets over their useful lives
    Amortization is the non-cash expense recognized on intangible assets over the benefit period of the asset.
    Depletion is the non-cash expense recognized on natural resources (eg. Oil and mineral deposits) over the benefit period of the
    asset.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DepreciationAmortizationDepletionIncomeStatement class"""
        ...


class NetIncomeDiscontinuousOperationsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    To be classified as discontinued operations, if both of the following conditions are met:
    1: The operations and cash flow of the component have been or will be removed from the ongoing operations of the entity as a
    result of the disposal transaction, and
    2: The entity will have no significant continuing involvement in the operations of the component after the disposal transaction.
    The discontinued operation is reported net of tax.
    Gains/Loss on Disposal of Discontinued Operations: Any gains or loss recognized on disposal of discontinued operations,
    which is the difference between the carrying value of the division and its fair value less costs to sell.
    Provision for Gain/Loss on Disposal: The amount of current expense charged in order to prepare for the disposal of
    discontinued operations.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetIncomeDiscontinuousOperationsIncomeStatement class"""
        ...


class ExciseTaxesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Excise taxes are taxes paid when purchases are made on a specific good, such as gasoline. Excise taxes are often included in the
    price of the product. There are also excise taxes on activities, such as on wagering or on highway usage by trucks.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ExciseTaxesIncomeStatement class"""
        ...


class NetIncomeExtraordinaryIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Gains (losses), whether arising from extinguishment of debt, prior period adjustments, or from other events or transactions, that are
    both unusual in nature and infrequent in occurrence thereby meeting the criteria for an event or transaction to be classified as an
    extraordinary item.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetIncomeExtraordinaryIncomeStatement class"""
        ...


class FeeRevenueAndOtherIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of fees, commissions, and other income."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FeeRevenueAndOtherIncomeIncomeStatement class"""
        ...


class GeneralAndAdministrativeExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate total of general managing and administering expenses for the company."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GeneralAndAdministrativeExpenseIncomeStatement class"""
        ...


class GrossProfitIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Total revenue less cost of revenue. The number is as reported by the company on the income statement; however, the number will
    be calculated if it is not reported. This field is null if the cost of revenue is not given.
    Gross Profit = Total Revenue - Cost of Revenue.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GrossProfitIncomeStatement class"""
        ...


class InterestExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Relates to the general cost of borrowing money. It is the price that a lender charges a borrower for the use of the lender's money."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InterestExpenseIncomeStatement class"""
        ...


class InterestExpenseNonOperatingIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Interest expense caused by long term financing activities; such as interest expense incurred on trading liabilities, commercial paper,
    long-term debt, capital leases, deposits, and all other borrowings.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InterestExpenseNonOperatingIncomeStatement class"""
        ...


class InterestIncomeAfterProvisionForLoanLossIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Net interest and dividend income or expense, including any amortization and accretion (as applicable) of discounts and premiums,
    including consideration of the provisions for loan, lease, credit, and other related losses, if any.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InterestIncomeAfterProvisionForLoanLossIncomeStatement class"""
        ...


class InterestIncomeNonOperatingIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Interest income earned from long term financing activities."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InterestIncomeNonOperatingIncomeStatement class"""
        ...


class NetNonOperatingInterestIncomeExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Net-Non Operating interest income or expenses caused by financing activities."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetNonOperatingInterestIncomeExpenseIncomeStatement class"""
        ...


class LossAdjustmentExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Losses generally refer to (1) the amount of reduction in the value of an insured's property caused by an insured peril, (2) the amount
    sought through an insured's claim, or (3) the amount paid on behalf of an insured under an insurance contract.  Loss Adjustment
    Expenses is expenses incurred in the course of investigating and settling claims that includes any legal and adjusters' fees and the
    costs of paying claims and all related expenses.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the LossAdjustmentExpenseIncomeStatement class"""
        ...


class MinorityInterestsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Represents par or stated value of the subsidiary stock not owned by the parent company plus the minority interest's equity in the
    surplus of the subsidiary. This item includes preferred dividend averages on the minority preferred stock (preferred shares not
    owned by the reporting parent company). Minority interest also refers to stockholders who own less than 50% of a subsidiary's
    outstanding voting common stock. The minority stockholders hold an interest in the subsidiary's net assets and share earnings with
    the parent company.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the MinorityInterestsIncomeStatement class"""
        ...


class NetIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Includes all the operations (continuing and discontinued) and all the other income or charges (extraordinary, accounting changes,
    tax loss carry forward, and other gains and losses).
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetIncomeIncomeStatement class"""
        ...


class NetIncomeCommonStockholdersIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Net income minus the preferred dividends paid as presented in the Income Statement."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetIncomeCommonStockholdersIncomeStatement class"""
        ...


class NetIncomeContinuousOperationsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Revenue less expenses and taxes from the entity's ongoing operations and before income (loss) from: Preferred Dividends;
    Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing Operation; Income from Tax
    Loss Carry forward; Other Gains/Losses.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetIncomeContinuousOperationsIncomeStatement class"""
        ...


class NetInterestIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Total interest income minus total interest expense. It represents the difference between interest and dividends earned on interest-
    bearing assets and interest paid to depositors and other creditors.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetInterestIncomeIncomeStatement class"""
        ...


class NetInvestmentIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Total of interest, dividends, and other earnings derived from the insurance company's invested assets minus the expenses
    associated with these investments. Excluded from this income are capital gains or losses as the result of the sale of assets, as well
    as any unrealized capital gains or losses.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetInvestmentIncomeIncomeStatement class"""
        ...


class TotalRevenueIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    All sales, business revenues and income that the company makes from its business operations, net of excise taxes. This applies for
    all companies and can be used as comparison for all industries.
    For Normal, Mining, Transportation and Utility templates companies, this is the sum of Operating Revenues, Excise Taxes and Fees.
    For Bank template companies, this is the sum of Net Interest Income and Non-Interest Income.
    For Insurance template companies, this is the sum of Premiums, Interest Income, Fees, Investment and Other Income.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalRevenueIncomeStatement class"""
        ...


class NonInterestExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Any expenses that not related to interest. It includes labor and related expense, occupancy and equipment, commission,
    professional expense and contract services expenses, selling, general and administrative, research and development depreciation,
    amortization and depletion, and any other special income/charges.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NonInterestExpenseIncomeStatement class"""
        ...


class NonInterestIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The total amount of non-interest income which may be derived from: (1) fees and commissions; (2) premiums earned; (3) equity
    investment; (4) the sale or disposal of assets; and (5) other sources not otherwise specified.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NonInterestIncomeIncomeStatement class"""
        ...


class OperatingExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Operating expenses are primary recurring costs associated with central operations (other than cost of goods sold) that are incurred
    in order to generate sales.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OperatingExpenseIncomeStatement class"""
        ...


class OperatingIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Income from normal business operations after deducting cost of revenue and operating expenses. It does not include income from
    any investing activities.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OperatingIncomeIncomeStatement class"""
        ...


class OperatingRevenueIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Sales and income that the company makes from its business operations. This applies only to non-bank and insurance companies.
    For Utility template companies, this is the sum of revenue from electric, gas, transportation and other operating revenue.
    For Transportation template companies, this is the sum of revenue-passenger, revenue-cargo, and other operating revenue.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OperatingRevenueIncomeStatement class"""
        ...


class OtherIncomeExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income or expense that comes from miscellaneous sources."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherIncomeExpenseIncomeStatement class"""
        ...


class PolicyAcquisitionExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Costs that vary with and are primarily related to the acquisition of new and renewal insurance contracts. Also referred to as
    underwriting expenses.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PolicyAcquisitionExpenseIncomeStatement class"""
        ...


class NetPolicyholderBenefitsAndClaimsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The net provision in current period for future policy benefits, claims, and claims settlement expenses incurred in the claims
    settlement process before the effects of reinsurance arrangements. The value is net of the effects of contracts assumed and
    ceded.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetPolicyholderBenefitsAndClaimsIncomeStatement class"""
        ...


class PreferredStockDividendsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The amount of dividends declared or paid in the period to preferred shareholders, or the amount for which the obligation to pay
    them dividends arose in the PeriodAsByte. Preferred dividends are the amount required for the current year only, and not for any amount
    required in past years.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PreferredStockDividendsIncomeStatement class"""
        ...


class TotalPremiumsEarnedIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Premiums earned is the portion of an insurance written premium which is considered "earned" by the insurer, based on the part of
    the policy period that the insurance has been in effect, and during which the insurer has been exposed to loss.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalPremiumsEarnedIncomeStatement class"""
        ...


class PretaxIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Reported income before the deduction or benefit of income taxes."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PretaxIncomeIncomeStatement class"""
        ...


class TaxProvisionIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Include any taxes on income, net of any investment tax credits for the current accounting PeriodAsByte."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TaxProvisionIncomeStatement class"""
        ...


class CreditLossesProvisionIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    A charge to income which represents an expense deemed adequate by management given the composition of a bank's credit
    portfolios, their probability of default, the economic environment and the allowance for credit losses already established. Specific
    provisions are established to reduce the book value of specific assets (primarily loans) to establish the amount expected to be
    recovered on the loans.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CreditLossesProvisionIncomeStatement class"""
        ...


class ResearchAndDevelopmentIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of research and development expenses during the year."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ResearchAndDevelopmentIncomeStatement class"""
        ...


class SellingAndMarketingExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate total amount of expenses directly related to the marketing or selling of products or services."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the SellingAndMarketingExpenseIncomeStatement class"""
        ...


class SellingGeneralAndAdministrationIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The aggregate total costs related to selling a firm's product and services, as well as all other general and administrative expenses.
    Selling expenses are those directly related to the company's efforts to generate sales (e.g., sales salaries, commissions,
    advertising, delivery expenses). General and administrative expenses are expenses related to general administration of the
    company's operation (e.g., officers and office salaries, office supplies, telephone, accounting and legal services, and business
    licenses and fees).
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the SellingGeneralAndAdministrationIncomeStatement class"""
        ...


class SpecialIncomeChargesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Earnings or losses attributable to occurrences or actions by the firm that is either infrequent or unusual."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the SpecialIncomeChargesIncomeStatement class"""
        ...


class TotalExpensesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The sum of operating expense and cost of revenue. If the company does not give the reported number, it will be calculated by
    adding operating expense and cost of revenue.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalExpensesIncomeStatement class"""
        ...


class InterestIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income generated from interest-bearing deposits or accounts."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InterestIncomeIncomeStatement class"""
        ...


class EBITIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Earnings minus expenses (excluding interest and tax expenses)."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the EBITIncomeStatement class"""
        ...


class EBITDAIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Earnings minus expenses (excluding interest, tax, depreciation, and amortization expenses)."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the EBITDAIncomeStatement class"""
        ...


class NetIncomeContinuousOperationsNetMinorityInterestIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Revenue less expenses and taxes from the entity's ongoing operations net of minority interest and before income (loss) from:
    Preferred Dividends; Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing
    Operation; Income from Tax Loss Carry forward; Other Gains/Losses.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetIncomeContinuousOperationsNetMinorityInterestIncomeStatement class"""
        ...


class CededPremiumsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The amount of premiums paid and payable to another insurer as a result of reinsurance arrangements in order to exchange for that
    company accepting all or part of insurance on a risk or exposure. This item is usually only available for insurance industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CededPremiumsIncomeStatement class"""
        ...


class CommissionExpensesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """"""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CommissionExpensesIncomeStatement class"""
        ...


class CreditCardIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Income earned from credit card services including late, over limit, and annual fees. This item is usually only available for bank
    industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CreditCardIncomeStatement class"""
        ...


class DividendIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Dividends earned from equity investment securities. This item is usually only available for bank industry."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DividendIncomeIncomeStatement class"""
        ...


class EarningsFromEquityInterestIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The earnings from equity interest can be a result of any of the following: Income from earnings distribution of the business, either
    as dividends paid to corporate shareholders or as drawings in a partnership; Capital gain realized upon sale of the business; Capital
    gain realized from selling his or her interest to other partners. This item is usually not available for bank and insurance industries.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the EarningsFromEquityInterestIncomeStatement class"""
        ...


class EquipmentIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Equipment expenses include depreciation, repairs, rentals, and service contract costs. This also includes equipment purchases
    which do not qualify for capitalization in accordance with the entity's accounting policy. This item may also include furniture
    expenses. This item is usually only available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the EquipmentIncomeStatement class"""
        ...


class ExplorationDevelopmentAndMineralPropertyLeaseExpensesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Costs incurred in identifying areas that may warrant examination and in examining specific areas that are considered to have
    prospects of containing energy or metal reserves, including costs of drilling exploratory wells. Development expense is the
    capitalized costs incurred to obtain access to proved reserves and to provide facilities for extracting, treating, gathering and storing
    the energy and metal. Mineral property includes oil and gas wells, mines, and other natural deposits (including geothermal
    deposits). The payment for leasing those properties is called mineral property lease expense. Exploration expense is included in
    operation expenses for mining industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ExplorationDevelopmentAndMineralPropertyLeaseExpensesIncomeStatement class"""
        ...


class FeesAndCommissionsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Total fees and commissions earned from providing services such as leasing of space or maintaining: (1) depositor accounts; (2)
    transfer agent; (3) fiduciary and trust; (4) brokerage and underwriting; (5) mortgage; (6) credit cards; (7) correspondent clearing;
    and (8) other such services and activities performed for others. This item is usually available for bank and insurance industries.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FeesAndCommissionsIncomeStatement class"""
        ...


class ForeignExchangeTradingGainsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Trading revenues that result from foreign exchange exposures such as cash instruments and off-balance sheet derivative
    instruments. This item is usually only available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ForeignExchangeTradingGainsIncomeStatement class"""
        ...


class FuelIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The aggregate amount of fuel cost for current period associated with the revenue generation. This item is usually only available for
    transportation industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FuelIncomeStatement class"""
        ...


class FuelAndPurchasePowerIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Cost of fuel, purchase power and gas associated with revenue generation. This item is usually only available for utility industry."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FuelAndPurchasePowerIncomeStatement class"""
        ...


class GainOnSaleOfBusinessIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The amount of excess earned in comparison to fair value when selling a business. This item is usually not available for insurance
    industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GainOnSaleOfBusinessIncomeStatement class"""
        ...


class GainOnSaleOfPPEIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The amount of excess earned in comparison to the net book value for sale of property, plant, equipment. This item is usually not
    available for bank and insurance industries.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GainOnSaleOfPPEIncomeStatement class"""
        ...


class GainOnSaleOfSecurityIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The amount of excess earned in comparison to the original purchase value of the security."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GainOnSaleOfSecurityIncomeStatement class"""
        ...


class GrossPremiumsWrittenIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Total premiums generated from all policies written by an insurance company within a given period of time. This item is usually only
    available for insurance industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GrossPremiumsWrittenIncomeStatement class"""
        ...


class ImpairmentOfCapitalAssetsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Impairments are considered to be permanent, which is a downward revaluation of fixed assets. If the sum of all estimated future
    cash flows is less than the carrying value of the asset, then the asset would be considered impaired and would have to be written
    down to its fair value. Once an asset is written down, it may only be written back up under very few circumstances. Usually the
    company uses the sum of undiscounted future cash flows to determine if the impairment should occur, and uses the sum of
    discounted future cash flows to make the impairment judgment. The impairment decision emphasizes on capital assets' future
    profit collection ability.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ImpairmentOfCapitalAssetsIncomeStatement class"""
        ...


class IncreaseDecreaseInNetUnearnedPremiumReservesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Premium might contain a portion of the amount that has been paid in advance for insurance that has not yet been provided, which
    is called unearned premium. If either party cancels the contract, the insurer must have the unearned premium ready to refund.
    Hence, the amount of premium reserve maintained by insurers is called unearned premium reserves, which is prepared for
    liquidation.  This item is usually only available for insurance industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the IncreaseDecreaseInNetUnearnedPremiumReservesIncomeStatement class"""
        ...


class InsuranceAndClaimsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Insurance and claims are the expenses in the period incurred with respect to protection provided by insurance entities against risks
    other than risks associated with production (which is allocated to cost of sales). This item is usually not available for insurance
    industries.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InsuranceAndClaimsIncomeStatement class"""
        ...


class InterestExpenseForDepositIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Includes interest expense on the following deposit accounts: Interest-bearing Demand deposit; Checking account; Savings account;
    Deposit in foreign offices; Money Market Certificates & Deposit Accounts. This item is usually only available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InterestExpenseForDepositIncomeStatement class"""
        ...


class InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Gross expenses on the purchase of Federal funds at a specified price with a simultaneous agreement to sell the same to the same
    counterparty at a fixed or determinable price at a future date. This item is usually only available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement class"""
        ...


class InterestExpenseForLongTermDebtAndCapitalSecuritiesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The aggregate interest expenses incurred on long-term borrowings and any interest expenses on fixed assets (property, plant,
    equipment) that are leased due longer than one year. This item is usually only available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InterestExpenseForLongTermDebtAndCapitalSecuritiesIncomeStatement class"""
        ...


class InterestExpenseForShortTermDebtIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The aggregate interest expenses incurred on short-term borrowings and any interest expenses on fixed assets (property, plant,
    equipment) that are leased within one year. This item is usually only available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InterestExpenseForShortTermDebtIncomeStatement class"""
        ...


class InterestIncomeFromDepositsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Interest income generated from all deposit accounts. This item is usually only available for bank industry."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InterestIncomeFromDepositsIncomeStatement class"""
        ...


class InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The carrying value of funds outstanding loaned in the form of security resale agreements if the agreement requires the purchaser to
    resell the identical security purchased or a security that meets the definition of ""substantially the same"" in the case of a dollar roll.
    Also includes purchases of participations in pools of securities that are subject to a resale agreement; This category includes all
    interest income generated from federal funds sold and securities purchases under agreements to resell; This category includes all
    interest income generated from federal funds sold and securities purchases under agreements to resell.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement class"""
        ...


class InterestIncomeFromLeasesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Includes interest and fee income generated by direct lease financing. This item is usually only available for bank industry."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InterestIncomeFromLeasesIncomeStatement class"""
        ...


class InterestIncomeFromLoansIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Loan is a common field to banks. Interest Income from Loans is interest and fee income generated from all loans, which includes
    Commercial loans; Credit loans; Other consumer loans; Real Estate - Construction; Real Estate - Mortgage; Foreign loans. Banks
    earn interest from loans. This item is usually only available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InterestIncomeFromLoansIncomeStatement class"""
        ...


class InterestIncomeFromLoansAndLeaseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total interest and fee income generated by loans and lease. This item is usually only available for bank industry."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InterestIncomeFromLoansAndLeaseIncomeStatement class"""
        ...


class InterestIncomeFromSecuritiesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Represents total interest and dividend income from U.S. Treasury securities, U.S. government agency and corporation obligations,
    securities issued by states and political subdivisions, other domestic debt securities, foreign debt securities, and equity securities
    (including investments in mutual funds). Excludes interest income from securities held in trading accounts. This item is usually only
    available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InterestIncomeFromSecuritiesIncomeStatement class"""
        ...


class InvestmentBankingProfitIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Includes (1) underwriting revenue (the spread between the resale price received and the cost of the securities and related
    expenses) generated through the purchasing, distributing and reselling of new issues of securities (alternatively, could be a
    secondary offering of a large block of previously issued securities); and (2) fees earned for mergers, acquisitions, divestitures,
    restructurings, and other types of financial advisory services. This item is usually only available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InvestmentBankingProfitIncomeStatement class"""
        ...


class MaintenanceAndRepairsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The aggregate amount of maintenance and repair expenses in the current period associated with the revenue generation. Mainly
    for fixed assets. This item is usually only available for transportation industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the MaintenanceAndRepairsIncomeStatement class"""
        ...


class NetForeignExchangeGainLossIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The aggregate foreign currency translation gain or loss (both realized and unrealized) included as part of revenue. This item is
    usually only available for insurance industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetForeignExchangeGainLossIncomeStatement class"""
        ...


class NetOccupancyExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Occupancy expense may include items, such as depreciation of facilities and equipment, lease expenses, property taxes and
    property and casualty insurance expense. This item is usually only available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetOccupancyExpenseIncomeStatement class"""
        ...


class NetPremiumsWrittenIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Net premiums written are gross premiums written less ceded premiums. This item is usually only available for insurance industry."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetPremiumsWrittenIncomeStatement class"""
        ...


class NetRealizedGainLossOnInvestmentsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Gain or loss realized during the period of time for all kinds of investment securities. In might include trading, available-for-sale, or
    held-to-maturity securities. This item is usually only available for insurance industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetRealizedGainLossOnInvestmentsIncomeStatement class"""
        ...


class OccupancyAndEquipmentIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Includes total expenses of occupancy and equipment. This item is usually only available for bank industry."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OccupancyAndEquipmentIncomeStatement class"""
        ...


class OperationAndMaintenanceIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The aggregate amount of operation and maintenance expenses, which is the one important operating expense for the utility
    industry. It includes any costs related to production and maintenance cost of the property during the revenue generation process.
    This item is usually only available for mining and utility industries.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OperationAndMaintenanceIncomeStatement class"""
        ...


class OtherCustomerServicesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Represents fees and commissions earned from provide other services. This item is usually only available for bank industry."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherCustomerServicesIncomeStatement class"""
        ...


class OtherInterestExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All other interest expense that is not otherwise classified"""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherInterestExpenseIncomeStatement class"""
        ...


class OtherInterestIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All other interest income that is not otherwise classified"""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherInterestIncomeIncomeStatement class"""
        ...


class OtherNonInterestExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All other non interest expense that is not otherwise classified"""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherNonInterestExpenseIncomeStatement class"""
        ...


class OtherSpecialChargesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All other special charges that are not otherwise classified"""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherSpecialChargesIncomeStatement class"""
        ...


class OtherTaxesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Any taxes that are not part of income taxes. This item is usually not available for bank and insurance industries."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherTaxesIncomeStatement class"""
        ...


class PolicyholderBenefitsCededIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The provision in current period for future policy benefits, claims, and claims settlement, which is under reinsurance arrangements.
    This item is usually only available for insurance industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PolicyholderBenefitsCededIncomeStatement class"""
        ...


class PolicyholderBenefitsGrossIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The gross amount of provision in current period for future policyholder benefits, claims, and claims settlement, incurred in the
    claims settlement process before the effects of reinsurance arrangements. This item is usually only available for insurance industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PolicyholderBenefitsGrossIncomeStatement class"""
        ...


class PolicyholderDividendsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Payments made or credits extended to the insured by the company, usually at the end of a policy year results in reducing the net
    insurance cost to the policyholder. Such dividends may be paid in cash to the insured or applied by the insured as reductions of the
    premiums due for the next policy year. This item is usually only available for insurance industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PolicyholderDividendsIncomeStatement class"""
        ...


class PolicyholderInterestIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The periodic income payment provided to the annuitant by the insurance company, which is determined by the assumed interest
    rate (AIR) and other factors. This item is usually only available for insurance industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PolicyholderInterestIncomeStatement class"""
        ...


class ProfessionalExpenseAndContractServicesExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Professional and contract service expense includes cost reimbursements for support services related to contracted projects,
    outsourced management, technical and staff support. This item is usually only available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ProfessionalExpenseAndContractServicesExpenseIncomeStatement class"""
        ...


class ProvisionForDoubtfulAccountsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Amount of the current period expense charged against operations, the offset which is generally to the allowance for doubtful
    accounts for the purpose of reducing receivables, including notes receivable, to an amount that approximates their net realizable
    value (the amount expected to be collected). The category includes provision for loan losses, provision for any doubtful account
    receivable, and bad debt expenses. This item is usually not available for bank and insurance industries.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ProvisionForDoubtfulAccountsIncomeStatement class"""
        ...


class RentAndLandingFeesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Rent fees are the cost of occupying space during the accounting PeriodAsByte. Landing fees are a change paid to an airport company for
    landing at a particular airport. This item is not available for insurance industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the RentAndLandingFeesIncomeStatement class"""
        ...


class RestructuringAndMergernAcquisitionIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Expenses are related to restructuring, merger, or acquisitions. Restructuring expenses are charges associated with the
    consolidation and relocation of operations, disposition or abandonment of operations or productive assets. Merger and acquisition
    expenses are the amount of costs of a business combination including legal, accounting, and other costs that were charged to
    expense during the PeriodAsByte.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the RestructuringAndMergernAcquisitionIncomeStatement class"""
        ...


class SalariesAndWagesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All salary, wages, compensation, management fees, and employee benefit expenses."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the SalariesAndWagesIncomeStatement class"""
        ...


class SecuritiesActivitiesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income/Loss from Securities and Activities"""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the SecuritiesActivitiesIncomeStatement class"""
        ...


class ServiceChargeOnDepositorAccountsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Includes any service charges on following accounts: Demand Deposit; Checking account; Savings account; Deposit in foreign
    offices; ESCROW accounts; Money Market Certificates & Deposit accounts, CDs (Negotiable Certificates of Deposits); NOW
    Accounts (Negotiable Order of Withdrawal); IRAs (Individual Retirement Accounts). This item is usually only available for bank
    industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ServiceChargeOnDepositorAccountsIncomeStatement class"""
        ...


class TradingGainLossIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    A broker-dealer or other financial entity may buy and sell securities exclusively for its own account, sometimes referred to as
    proprietary trading. The profit or loss is measured by the difference between the acquisition cost and the selling price or current
    market or fair value. The net gain or loss, includes both realized and unrealized, from trading cash instruments, equities and
    derivative contracts (including commodity contracts) that has been recognized during the accounting period for the broker dealer or
    other financial entity's own account. This item is typically available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TradingGainLossIncomeStatement class"""
        ...


class TrustFeesbyCommissionsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Bank manages funds on behalf of its customers through the operation of various trust accounts. Any fees earned through managing
    those funds are called trust fees, which are recognized when earned. This item is typically available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TrustFeesbyCommissionsIncomeStatement class"""
        ...


class UnderwritingExpensesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Also known as Policy Acquisition Costs; and reported by insurance companies.  The cost incurred by an insurer when deciding
    whether to accept or decline a risk; may include meetings with the insureds or brokers, actuarial review of loss history, or physical
    inspections of exposures. Also, expenses deducted from insurance company revenues (including incurred losses and acquisition
    costs) to determine underwriting profit.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the UnderwritingExpensesIncomeStatement class"""
        ...


class WriteOffIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A reduction in the value of an asset or earnings by the amount of an expense or loss."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the WriteOffIncomeStatement class"""
        ...


class OtherNonInterestIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Usually available for the banking industry.  This is Non-Interest Income that is not otherwise classified."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherNonInterestIncomeIncomeStatement class"""
        ...


class AmortizationOfIntangiblesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The aggregate expense charged against earnings to allocate the cost of intangible assets (nonphysical assets not used in
    production) in a systematic and rational manner to the periods expected to benefit from such assets.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AmortizationOfIntangiblesIncomeStatement class"""
        ...


class NetIncomeFromContinuingAndDiscontinuedOperationIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Net Income from Continuing Operations and Discontinued Operations, added together."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetIncomeFromContinuingAndDiscontinuedOperationIncomeStatement class"""
        ...


class NetIncomeFromTaxLossCarryforwardIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Occurs if a company has had a net loss from operations on a previous year that can be carried forward to reduce net income for tax
    purposes.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetIncomeFromTaxLossCarryforwardIncomeStatement class"""
        ...


class OtherOperatingExpensesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The aggregate amount of operating expenses associated with normal operations. Will not include any gain, loss, benefit, or income;
    and its value reported by the company should be <0.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherOperatingExpensesIncomeStatement class"""
        ...


class TotalMoneyMarketInvestmentsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The sum of the money market investments held by a bank's depositors, which are FDIC insured."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalMoneyMarketInvestmentsIncomeStatement class"""
        ...


class ReconciledCostOfRevenueIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The Cost Of Revenue plus Depreciation, Depletion & Amortization from the IncomeStatement; minus Depreciation, Depletion &
    Amortization from the Cash Flow Statement
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ReconciledCostOfRevenueIncomeStatement class"""
        ...


class ReconciledDepreciationIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Is Depreciation, Depletion & Amortization from the Cash Flow Statement"""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ReconciledDepreciationIncomeStatement class"""
        ...


class NormalizedIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    This calculation represents earnings adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This can be
    used to fairly measure a company's profitability. This is calculated using Net Income from Continuing Operations plus/minus any tax
    affected unusual Items and Goodwill Impairments/Write Offs.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NormalizedIncomeIncomeStatement class"""
        ...


class NetIncomeFromContinuingOperationNetMinorityInterestIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Revenue less expenses and taxes from the entity's ongoing operations net of minority interest and before income (loss) from:
    Preferred Dividends; Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing
    Operation; Income from Tax Loss Carry forward; Other Gains/Losses.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetIncomeFromContinuingOperationNetMinorityInterestIncomeStatement class"""
        ...


class GainLossonSaleofAssetsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Any gain (loss) recognized on the sale of assets or a sale which generates profit or loss, which is a difference between sales price
    and net book value at the disposal time.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GainLossonSaleofAssetsIncomeStatement class"""
        ...


class GainonSaleofLoansIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Gain on sale of any loans investment."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GainonSaleofLoansIncomeStatement class"""
        ...


class GainonSaleofInvestmentPropertyIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Gain on the disposal of investment property."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GainonSaleofInvestmentPropertyIncomeStatement class"""
        ...


class LossonExtinguishmentofDebtIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Loss on extinguishment of debt is the accounting loss that results from a debt extinguishment. A debt shall be accounted for as
    having been extinguished in a number of circumstances, including when it has been settled through repayment or replacement by
    another liability. It generally results in an accounting gain or loss. Amount represents the difference between the fair value of the
    payments made and the carrying amount of the debt at the time of its extinguishment.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the LossonExtinguishmentofDebtIncomeStatement class"""
        ...


class EarningsfromEquityInterestNetOfTaxIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income from other equity interest reported after Provision of Tax. This applies to all industries."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the EarningsfromEquityInterestNetOfTaxIncomeStatement class"""
        ...


class NetIncomeIncludingNoncontrollingInterestsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Net income of the group after the adjustment of all expenses and benefit."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetIncomeIncludingNoncontrollingInterestsIncomeStatement class"""
        ...


class OtherunderPreferredStockDividendIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Dividend paid to the preferred shareholders before the common stock shareholders."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherunderPreferredStockDividendIncomeStatement class"""
        ...


class StaffCostsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total staff cost which is paid to the employees that is not part of Selling, General, and Administration expense."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the StaffCostsIncomeStatement class"""
        ...


class SocialSecurityCostsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Benefits paid to the employees in respect of their work."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the SocialSecurityCostsIncomeStatement class"""
        ...


class PensionCostsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The expense that a company incurs each year by providing a pension plan for its employees. Major expenses in the pension cost
    include employer matching contributions and management fees.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PensionCostsIncomeStatement class"""
        ...


class OtherOperatingIncomeTotalIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total Other Operating Income- including interest income, dividend income and other types of operating income."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherOperatingIncomeTotalIncomeStatement class"""
        ...


class IncomefromAssociatesandOtherParticipatingInterestsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total income from the associates and joint venture via investment, accounted for in the Non-Operating section."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the IncomefromAssociatesandOtherParticipatingInterestsIncomeStatement class"""
        ...


class TotalOtherFinanceCostIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Any other finance cost which is not clearly defined in the Non-Operating section."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalOtherFinanceCostIncomeStatement class"""
        ...


class GrossDividendPaymentIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total amount paid in dividends to investors- this includes dividends paid on equity and non-equity shares."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GrossDividendPaymentIncomeStatement class"""
        ...


class FeesandCommissionIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Fees and commission income earned by bank and insurance companies on the rendering services."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FeesandCommissionIncomeIncomeStatement class"""
        ...


class FeesandCommissionExpenseIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Cost incurred by bank and insurance companies for fees and commission income."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FeesandCommissionExpenseIncomeStatement class"""
        ...


class NetTradingIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Any trading income on the securities."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetTradingIncomeIncomeStatement class"""
        ...


class OtherStaffCostsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other costs in incurred in lieu of the employees that cannot be identified by other specific items in the Staff Costs section."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherStaffCostsIncomeStatement class"""
        ...


class GainonInvestmentPropertiesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Gain on disposal and change in fair value of investment properties."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GainonInvestmentPropertiesIncomeStatement class"""
        ...


class AverageDilutionEarningsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Adjustments to reported net income to calculate Diluted EPS, by assuming that all convertible instruments are converted to
    Common Equity. The adjustments usually include the interest expense of debentures when assumed converted and preferred
    dividends of convertible preferred stock when assumed converted.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AverageDilutionEarningsIncomeStatement class"""
        ...


class GainLossonFinancialInstrumentsDesignatedasCashFlowHedgesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Gain/Loss through hedging activities."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GainLossonFinancialInstrumentsDesignatedasCashFlowHedgesIncomeStatement class"""
        ...


class GainLossonDerecognitionofAvailableForSaleFinancialAssetsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Gain/loss on the write-off of financial assets available-for-sale."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GainLossonDerecognitionofAvailableForSaleFinancialAssetsIncomeStatement class"""
        ...


class NegativeGoodwillImmediatelyRecognizedIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Negative Goodwill recognized in the Income Statement. Negative Goodwill arises where the net assets at the date of acquisition,
    fairly valued, falls below the cost of acquisition.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NegativeGoodwillImmediatelyRecognizedIncomeStatement class"""
        ...


class GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotalIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Gain or loss on derivatives investment due to the fair value adjustment."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotalIncomeStatement class"""
        ...


class ImpairmentLossesReversalsFinancialInstrumentsNetIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Impairment or reversal of impairment on financial instrument such as derivative. This is a contra account under Total Revenue in
    banks.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ImpairmentLossesReversalsFinancialInstrumentsNetIncomeStatement class"""
        ...


class ClaimsandPaidIncurredIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All reported claims arising out of incidents in that year are considered incurred grouped with claims paid out."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ClaimsandPaidIncurredIncomeStatement class"""
        ...


class ReinsuranceRecoveriesClaimsandBenefitsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Claim on the reinsurance company and take the benefits."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ReinsuranceRecoveriesClaimsandBenefitsIncomeStatement class"""
        ...


class ChangeinInsuranceLiabilitiesNetofReinsuranceIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income/Expense due to changes between periods in insurance liabilities."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ChangeinInsuranceLiabilitiesNetofReinsuranceIncomeStatement class"""
        ...


class ChangeinInvestmentContractIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income/Expense due to changes between periods in Investment Contracts."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ChangeinInvestmentContractIncomeStatement class"""
        ...


class CreditRiskProvisionsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Provision for the risk of loss of principal or loss of a financial reward stemming from a borrower's failure to repay a loan or otherwise
    meet a contractual obligation. Credit risk arises whenever a borrower is expecting to use future cash flows to pay a current debt.
    Investors are compensated for assuming credit risk by way of interest payments from the borrower or issuer of a debt obligation.
    This is a contra account under Total Revenue in banks.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CreditRiskProvisionsIncomeStatement class"""
        ...


class WagesandSalariesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This is the portion under Staff Costs that represents salary paid to the employees in respect of their work."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the WagesandSalariesIncomeStatement class"""
        ...


class OtherNonOperatingIncomeExpensesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total other income and expense of the company that cannot be identified by other specific items in the Non-Operating section."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherNonOperatingIncomeExpensesIncomeStatement class"""
        ...


class OtherNonOperatingIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other income of the company that cannot be identified by other specific items in the Non-Operating section."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherNonOperatingIncomeIncomeStatement class"""
        ...


class OtherNonOperatingExpensesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other expenses of the company that cannot be identified by other specific items in the Non-Operating section."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherNonOperatingExpensesIncomeStatement class"""
        ...


class TotalUnusualItemsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total unusual items including Negative Goodwill."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalUnusualItemsIncomeStatement class"""
        ...


class TotalUnusualItemsExcludingGoodwillIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The sum of all the identifiable operating and non-operating unusual items."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalUnusualItemsExcludingGoodwillIncomeStatement class"""
        ...


class TaxRateForCalcsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Tax rate used for Morningstar calculations."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TaxRateForCalcsIncomeStatement class"""
        ...


class TaxEffectOfUnusualItemsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Tax effect of the usual items"""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TaxEffectOfUnusualItemsIncomeStatement class"""
        ...


class NormalizedEBITDAIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """EBITDA less Total Unusual Items"""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NormalizedEBITDAIncomeStatement class"""
        ...


class StockBasedCompensationIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The cost to the company for granting stock options to reward employees."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the StockBasedCompensationIncomeStatement class"""
        ...


class DilutedNIAvailtoComStockholdersIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Net income to calculate Diluted EPS, accounting for adjustments assuming that all the convertible instruments are being converted
    to Common Equity.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DilutedNIAvailtoComStockholdersIncomeStatement class"""
        ...


class InvestmentContractLiabilitiesIncurredIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income/Expenses due to the insurer's liabilities incurred in Investment Contracts."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InvestmentContractLiabilitiesIncurredIncomeStatement class"""
        ...


class ReinsuranceRecoveriesofInvestmentContractIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income/Expense due to recoveries from reinsurers for Investment Contracts."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ReinsuranceRecoveriesofInvestmentContractIncomeStatement class"""
        ...


class TotalDividendPaymentofEquitySharesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total amount paid in dividends to equity securities investors."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalDividendPaymentofEquitySharesIncomeStatement class"""
        ...


class TotalDividendPaymentofNonEquitySharesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total amount paid in dividends to Non-Equity securities investors."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalDividendPaymentofNonEquitySharesIncomeStatement class"""
        ...


class ChangeinTheGrossProvisionforUnearnedPremiumsIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The change in the amount of the unearned premium reserves maintained by insurers."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ChangeinTheGrossProvisionforUnearnedPremiumsIncomeStatement class"""
        ...


class ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShareIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The change in the amount of unearned premium reserve to be covered by reinsurers."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShareIncomeStatement class"""
        ...


class ClaimsandChangeinInsuranceLiabilitiesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income/Expense due to the insurer's changes in insurance liabilities."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ClaimsandChangeinInsuranceLiabilitiesIncomeStatement class"""
        ...


class ReinsuranceRecoveriesofInsuranceLiabilitiesIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income/Expense due to recoveries from reinsurers for insurance liabilities."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ReinsuranceRecoveriesofInsuranceLiabilitiesIncomeStatement class"""
        ...


class TotalOperatingIncomeAsReportedIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Operating profit/loss as reported by the company, may be the same or not the same as Morningstar's standardized definition."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalOperatingIncomeAsReportedIncomeStatement class"""
        ...


class OtherGAIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Other General and Administrative Expenses not categorized that the company incurs that are not directly tied to a specific function
    such as manufacturing, production, or sales.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherGAIncomeStatement class"""
        ...


class OtherCostofRevenueIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other costs associated with the revenue-generating activities of the company not categorized above."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherCostofRevenueIncomeStatement class"""
        ...


class RentandLandingFeesCostofRevenueIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Costs paid to use the facilities necessary to generate revenue during the accounting PeriodAsByte."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the RentandLandingFeesCostofRevenueIncomeStatement class"""
        ...


class DDACostofRevenueIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Costs of depreciation and amortization on assets used for the revenue-generating activities during the accounting period"""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DDACostofRevenueIncomeStatement class"""
        ...


class RentExpenseSupplementalIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The sum of all rent expenses incurred by the company for operating leases during the year, it is a supplemental value which would
    be reported outside consolidated statements or consolidated statement's footnotes.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the RentExpenseSupplementalIncomeStatement class"""
        ...


class NormalizedPreTaxIncomeIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    This calculation represents pre-tax earnings adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This
    can be used to fairly measure a company's profitability. This is calculated using Pre-Tax Income plus/minus any unusual Items and
    Goodwill Impairments/Write Offs.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NormalizedPreTaxIncomeIncomeStatement class"""
        ...


class ResearchAndDevelopmentExpensesSupplementalIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The aggregate amount of research and development expenses during the year. It is a supplemental value which would be reported
    outside consolidated statements.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ResearchAndDevelopmentExpensesSupplementalIncomeStatement class"""
        ...


class DepreciationSupplementalIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The current period expense charged against earnings on tangible asset over its useful life. It is a supplemental value which would
    be reported outside consolidated statements.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DepreciationSupplementalIncomeStatement class"""
        ...


class AmortizationSupplementalIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The current period expense charged against earnings on intangible asset over its useful life. It is a supplemental value which would
    be reported outside consolidated statements.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AmortizationSupplementalIncomeStatement class"""
        ...


class TotalRevenueAsReportedIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total revenue as reported by the company, may be the same or not the same as Morningstar's standardized definition."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalRevenueAsReportedIncomeStatement class"""
        ...


class OperatingExpenseAsReportedIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Operating expense as reported by the company, may be the same or not the same as Morningstar's standardized definition."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OperatingExpenseAsReportedIncomeStatement class"""
        ...


class NormalizedIncomeAsReportedIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Earnings adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This can be used to fairly measure a
    company's profitability. This is as reported by the company, may be the same or not the same as Morningstar's standardized
    definition.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NormalizedIncomeAsReportedIncomeStatement class"""
        ...


class NormalizedEBITDAAsReportedIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    EBITDA less Total Unusual Items. This is as reported by the company, may be the same or not the same as Morningstar's
    standardized definition.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NormalizedEBITDAAsReportedIncomeStatement class"""
        ...


class NormalizedEBITAsReportedIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    EBIT less Total Unusual Items. This is as reported by the company, may be the same or not the same as Morningstar's standardized
    definition.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NormalizedEBITAsReportedIncomeStatement class"""
        ...


class NormalizedOperatingProfitAsReportedIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Operating profit adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This can be used to fairly
    measure a company's profitability. This is as reported by the company, may be the same or not the same as Morningstar's
    standardized definition.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NormalizedOperatingProfitAsReportedIncomeStatement class"""
        ...


class EffectiveTaxRateAsReportedIncomeStatement(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The average tax rate for the period as reported by the company, may be the same or not the same as Morningstar's standardized
    definition.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the EffectiveTaxRateAsReportedIncomeStatement class"""
        ...


class IncomeStatement(System.Object):
    """Definition of the IncomeStatement class"""

    @property
    def Amortization(self) -> QuantConnect.Data.Fundamental.AmortizationIncomeStatement:
        """The non-cash expense recognized on intangible assets over the benefit period of the asset."""
        ...

    @Amortization.setter
    def Amortization(self, value: QuantConnect.Data.Fundamental.AmortizationIncomeStatement):
        """The non-cash expense recognized on intangible assets over the benefit period of the asset."""
        ...

    @property
    def SecuritiesAmortization(self) -> QuantConnect.Data.Fundamental.SecuritiesAmortizationIncomeStatement:
        """
        The gradual elimination of a liability, such as a mortgage, in regular payments over a specified period of time. Such payments must
        be sufficient to cover both principal and interest.
        """
        ...

    @SecuritiesAmortization.setter
    def SecuritiesAmortization(self, value: QuantConnect.Data.Fundamental.SecuritiesAmortizationIncomeStatement):
        """
        The gradual elimination of a liability, such as a mortgage, in regular payments over a specified period of time. Such payments must
        be sufficient to cover both principal and interest.
        """
        ...

    @property
    def CostOfRevenue(self) -> QuantConnect.Data.Fundamental.CostOfRevenueIncomeStatement:
        """
        The aggregate cost of goods produced and sold and services rendered during the reporting period. It excludes all operating
        expenses such as depreciation, depletion, amortization, and SG&A. For the must have cost industry, if the number is not reported
        by the company, it will be calculated based on accounting equation.
        Cost of Revenue = Revenue - Operating Expenses - Operating Profit.
        """
        ...

    @CostOfRevenue.setter
    def CostOfRevenue(self, value: QuantConnect.Data.Fundamental.CostOfRevenueIncomeStatement):
        """
        The aggregate cost of goods produced and sold and services rendered during the reporting period. It excludes all operating
        expenses such as depreciation, depletion, amortization, and SG&A. For the must have cost industry, if the number is not reported
        by the company, it will be calculated based on accounting equation.
        Cost of Revenue = Revenue - Operating Expenses - Operating Profit.
        """
        ...

    @property
    def Depletion(self) -> QuantConnect.Data.Fundamental.DepletionIncomeStatement:
        """The non-cash expense recognized on natural resources (eg. Oil and mineral deposits) over the benefit period of the asset."""
        ...

    @Depletion.setter
    def Depletion(self, value: QuantConnect.Data.Fundamental.DepletionIncomeStatement):
        """The non-cash expense recognized on natural resources (eg. Oil and mineral deposits) over the benefit period of the asset."""
        ...

    @property
    def Depreciation(self) -> QuantConnect.Data.Fundamental.DepreciationIncomeStatement:
        """
        The current period non-cash expense recognized on tangible assets used in the normal course of business, by allocating the cost of
        assets over their useful lives, in the Income Statement. Examples of tangible asset include buildings, production and equipment.
        """
        ...

    @Depreciation.setter
    def Depreciation(self, value: QuantConnect.Data.Fundamental.DepreciationIncomeStatement):
        """
        The current period non-cash expense recognized on tangible assets used in the normal course of business, by allocating the cost of
        assets over their useful lives, in the Income Statement. Examples of tangible asset include buildings, production and equipment.
        """
        ...

    @property
    def DepreciationAndAmortization(self) -> QuantConnect.Data.Fundamental.DepreciationAndAmortizationIncomeStatement:
        """
        The sum of depreciation and amortization expense in the Income Statement.
        Depreciation is the non-cash expense recognized on tangible assets used in the normal course of business, by allocating the cost of
        assets over their useful lives
        Amortization is the non-cash expense recognized on intangible assets over the benefit period of the asset.
        """
        ...

    @DepreciationAndAmortization.setter
    def DepreciationAndAmortization(self, value: QuantConnect.Data.Fundamental.DepreciationAndAmortizationIncomeStatement):
        """
        The sum of depreciation and amortization expense in the Income Statement.
        Depreciation is the non-cash expense recognized on tangible assets used in the normal course of business, by allocating the cost of
        assets over their useful lives
        Amortization is the non-cash expense recognized on intangible assets over the benefit period of the asset.
        """
        ...

    @property
    def DepreciationAmortizationDepletion(self) -> QuantConnect.Data.Fundamental.DepreciationAmortizationDepletionIncomeStatement:
        """
        The sum of depreciation, amortization and depletion expense in the Income Statement.
        Depreciation is the non-cash expense recognized on tangible assets used in the normal course of business, by allocating the cost of
        assets over their useful lives
        Amortization is the non-cash expense recognized on intangible assets over the benefit period of the asset.
        Depletion is the non-cash expense recognized on natural resources (eg. Oil and mineral deposits) over the benefit period of the
        asset.
        """
        ...

    @DepreciationAmortizationDepletion.setter
    def DepreciationAmortizationDepletion(self, value: QuantConnect.Data.Fundamental.DepreciationAmortizationDepletionIncomeStatement):
        """
        The sum of depreciation, amortization and depletion expense in the Income Statement.
        Depreciation is the non-cash expense recognized on tangible assets used in the normal course of business, by allocating the cost of
        assets over their useful lives
        Amortization is the non-cash expense recognized on intangible assets over the benefit period of the asset.
        Depletion is the non-cash expense recognized on natural resources (eg. Oil and mineral deposits) over the benefit period of the
        asset.
        """
        ...

    @property
    def NetIncomeDiscontinuousOperations(self) -> QuantConnect.Data.Fundamental.NetIncomeDiscontinuousOperationsIncomeStatement:
        """
        To be classified as discontinued operations, if both of the following conditions are met:
        1: The operations and cash flow of the component have been or will be removed from the ongoing operations of the entity as a
        result of the disposal transaction, and
        2: The entity will have no significant continuing involvement in the operations of the component after the disposal transaction.
        The discontinued operation is reported net of tax.
        Gains/Loss on Disposal of Discontinued Operations: Any gains or loss recognized on disposal of discontinued operations,
        which is the difference between the carrying value of the division and its fair value less costs to sell.
        Provision for Gain/Loss on Disposal: The amount of current expense charged in order to prepare for the disposal of
        discontinued operations.
        """
        ...

    @NetIncomeDiscontinuousOperations.setter
    def NetIncomeDiscontinuousOperations(self, value: QuantConnect.Data.Fundamental.NetIncomeDiscontinuousOperationsIncomeStatement):
        """
        To be classified as discontinued operations, if both of the following conditions are met:
        1: The operations and cash flow of the component have been or will be removed from the ongoing operations of the entity as a
        result of the disposal transaction, and
        2: The entity will have no significant continuing involvement in the operations of the component after the disposal transaction.
        The discontinued operation is reported net of tax.
        Gains/Loss on Disposal of Discontinued Operations: Any gains or loss recognized on disposal of discontinued operations,
        which is the difference between the carrying value of the division and its fair value less costs to sell.
        Provision for Gain/Loss on Disposal: The amount of current expense charged in order to prepare for the disposal of
        discontinued operations.
        """
        ...

    @property
    def ExciseTaxes(self) -> QuantConnect.Data.Fundamental.ExciseTaxesIncomeStatement:
        """
        Excise taxes are taxes paid when purchases are made on a specific good, such as gasoline. Excise taxes are often included in the
        price of the product. There are also excise taxes on activities, such as on wagering or on highway usage by trucks.
        """
        ...

    @ExciseTaxes.setter
    def ExciseTaxes(self, value: QuantConnect.Data.Fundamental.ExciseTaxesIncomeStatement):
        """
        Excise taxes are taxes paid when purchases are made on a specific good, such as gasoline. Excise taxes are often included in the
        price of the product. There are also excise taxes on activities, such as on wagering or on highway usage by trucks.
        """
        ...

    @property
    def NetIncomeExtraordinary(self) -> QuantConnect.Data.Fundamental.NetIncomeExtraordinaryIncomeStatement:
        """
        Gains (losses), whether arising from extinguishment of debt, prior period adjustments, or from other events or transactions, that are
        both unusual in nature and infrequent in occurrence thereby meeting the criteria for an event or transaction to be classified as an
        extraordinary item.
        """
        ...

    @NetIncomeExtraordinary.setter
    def NetIncomeExtraordinary(self, value: QuantConnect.Data.Fundamental.NetIncomeExtraordinaryIncomeStatement):
        """
        Gains (losses), whether arising from extinguishment of debt, prior period adjustments, or from other events or transactions, that are
        both unusual in nature and infrequent in occurrence thereby meeting the criteria for an event or transaction to be classified as an
        extraordinary item.
        """
        ...

    @property
    def FeeRevenueAndOtherIncome(self) -> QuantConnect.Data.Fundamental.FeeRevenueAndOtherIncomeIncomeStatement:
        """The aggregate amount of fees, commissions, and other income."""
        ...

    @FeeRevenueAndOtherIncome.setter
    def FeeRevenueAndOtherIncome(self, value: QuantConnect.Data.Fundamental.FeeRevenueAndOtherIncomeIncomeStatement):
        """The aggregate amount of fees, commissions, and other income."""
        ...

    @property
    def GeneralAndAdministrativeExpense(self) -> QuantConnect.Data.Fundamental.GeneralAndAdministrativeExpenseIncomeStatement:
        """The aggregate total of general managing and administering expenses for the company."""
        ...

    @GeneralAndAdministrativeExpense.setter
    def GeneralAndAdministrativeExpense(self, value: QuantConnect.Data.Fundamental.GeneralAndAdministrativeExpenseIncomeStatement):
        """The aggregate total of general managing and administering expenses for the company."""
        ...

    @property
    def GrossProfit(self) -> QuantConnect.Data.Fundamental.GrossProfitIncomeStatement:
        """
        Total revenue less cost of revenue. The number is as reported by the company on the income statement; however, the number will
        be calculated if it is not reported. This field is null if the cost of revenue is not given.
        Gross Profit = Total Revenue - Cost of Revenue.
        """
        ...

    @GrossProfit.setter
    def GrossProfit(self, value: QuantConnect.Data.Fundamental.GrossProfitIncomeStatement):
        """
        Total revenue less cost of revenue. The number is as reported by the company on the income statement; however, the number will
        be calculated if it is not reported. This field is null if the cost of revenue is not given.
        Gross Profit = Total Revenue - Cost of Revenue.
        """
        ...

    @property
    def InterestExpense(self) -> QuantConnect.Data.Fundamental.InterestExpenseIncomeStatement:
        """Relates to the general cost of borrowing money. It is the price that a lender charges a borrower for the use of the lender's money."""
        ...

    @InterestExpense.setter
    def InterestExpense(self, value: QuantConnect.Data.Fundamental.InterestExpenseIncomeStatement):
        """Relates to the general cost of borrowing money. It is the price that a lender charges a borrower for the use of the lender's money."""
        ...

    @property
    def InterestExpenseNonOperating(self) -> QuantConnect.Data.Fundamental.InterestExpenseNonOperatingIncomeStatement:
        """
        Interest expense caused by long term financing activities; such as interest expense incurred on trading liabilities, commercial paper,
        long-term debt, capital leases, deposits, and all other borrowings.
        """
        ...

    @InterestExpenseNonOperating.setter
    def InterestExpenseNonOperating(self, value: QuantConnect.Data.Fundamental.InterestExpenseNonOperatingIncomeStatement):
        """
        Interest expense caused by long term financing activities; such as interest expense incurred on trading liabilities, commercial paper,
        long-term debt, capital leases, deposits, and all other borrowings.
        """
        ...

    @property
    def InterestIncomeAfterProvisionForLoanLoss(self) -> QuantConnect.Data.Fundamental.InterestIncomeAfterProvisionForLoanLossIncomeStatement:
        """
        Net interest and dividend income or expense, including any amortization and accretion (as applicable) of discounts and premiums,
        including consideration of the provisions for loan, lease, credit, and other related losses, if any.
        """
        ...

    @InterestIncomeAfterProvisionForLoanLoss.setter
    def InterestIncomeAfterProvisionForLoanLoss(self, value: QuantConnect.Data.Fundamental.InterestIncomeAfterProvisionForLoanLossIncomeStatement):
        """
        Net interest and dividend income or expense, including any amortization and accretion (as applicable) of discounts and premiums,
        including consideration of the provisions for loan, lease, credit, and other related losses, if any.
        """
        ...

    @property
    def InterestIncomeNonOperating(self) -> QuantConnect.Data.Fundamental.InterestIncomeNonOperatingIncomeStatement:
        """Interest income earned from long term financing activities."""
        ...

    @InterestIncomeNonOperating.setter
    def InterestIncomeNonOperating(self, value: QuantConnect.Data.Fundamental.InterestIncomeNonOperatingIncomeStatement):
        """Interest income earned from long term financing activities."""
        ...

    @property
    def NetNonOperatingInterestIncomeExpense(self) -> QuantConnect.Data.Fundamental.NetNonOperatingInterestIncomeExpenseIncomeStatement:
        """Net-Non Operating interest income or expenses caused by financing activities."""
        ...

    @NetNonOperatingInterestIncomeExpense.setter
    def NetNonOperatingInterestIncomeExpense(self, value: QuantConnect.Data.Fundamental.NetNonOperatingInterestIncomeExpenseIncomeStatement):
        """Net-Non Operating interest income or expenses caused by financing activities."""
        ...

    @property
    def LossAdjustmentExpense(self) -> QuantConnect.Data.Fundamental.LossAdjustmentExpenseIncomeStatement:
        """
        Losses generally refer to (1) the amount of reduction in the value of an insured's property caused by an insured peril, (2) the amount
        sought through an insured's claim, or (3) the amount paid on behalf of an insured under an insurance contract.  Loss Adjustment
        Expenses is expenses incurred in the course of investigating and settling claims that includes any legal and adjusters' fees and the
        costs of paying claims and all related expenses.
        """
        ...

    @LossAdjustmentExpense.setter
    def LossAdjustmentExpense(self, value: QuantConnect.Data.Fundamental.LossAdjustmentExpenseIncomeStatement):
        """
        Losses generally refer to (1) the amount of reduction in the value of an insured's property caused by an insured peril, (2) the amount
        sought through an insured's claim, or (3) the amount paid on behalf of an insured under an insurance contract.  Loss Adjustment
        Expenses is expenses incurred in the course of investigating and settling claims that includes any legal and adjusters' fees and the
        costs of paying claims and all related expenses.
        """
        ...

    @property
    def MinorityInterests(self) -> QuantConnect.Data.Fundamental.MinorityInterestsIncomeStatement:
        """
        Represents par or stated value of the subsidiary stock not owned by the parent company plus the minority interest's equity in the
        surplus of the subsidiary. This item includes preferred dividend averages on the minority preferred stock (preferred shares not
        owned by the reporting parent company). Minority interest also refers to stockholders who own less than 50% of a subsidiary's
        outstanding voting common stock. The minority stockholders hold an interest in the subsidiary's net assets and share earnings with
        the parent company.
        """
        ...

    @MinorityInterests.setter
    def MinorityInterests(self, value: QuantConnect.Data.Fundamental.MinorityInterestsIncomeStatement):
        """
        Represents par or stated value of the subsidiary stock not owned by the parent company plus the minority interest's equity in the
        surplus of the subsidiary. This item includes preferred dividend averages on the minority preferred stock (preferred shares not
        owned by the reporting parent company). Minority interest also refers to stockholders who own less than 50% of a subsidiary's
        outstanding voting common stock. The minority stockholders hold an interest in the subsidiary's net assets and share earnings with
        the parent company.
        """
        ...

    @property
    def NetIncome(self) -> QuantConnect.Data.Fundamental.NetIncomeIncomeStatement:
        """
        Includes all the operations (continuing and discontinued) and all the other income or charges (extraordinary, accounting changes,
        tax loss carry forward, and other gains and losses).
        """
        ...

    @NetIncome.setter
    def NetIncome(self, value: QuantConnect.Data.Fundamental.NetIncomeIncomeStatement):
        """
        Includes all the operations (continuing and discontinued) and all the other income or charges (extraordinary, accounting changes,
        tax loss carry forward, and other gains and losses).
        """
        ...

    @property
    def NetIncomeCommonStockholders(self) -> QuantConnect.Data.Fundamental.NetIncomeCommonStockholdersIncomeStatement:
        """Net income minus the preferred dividends paid as presented in the Income Statement."""
        ...

    @NetIncomeCommonStockholders.setter
    def NetIncomeCommonStockholders(self, value: QuantConnect.Data.Fundamental.NetIncomeCommonStockholdersIncomeStatement):
        """Net income minus the preferred dividends paid as presented in the Income Statement."""
        ...

    @property
    def NetIncomeContinuousOperations(self) -> QuantConnect.Data.Fundamental.NetIncomeContinuousOperationsIncomeStatement:
        """
        Revenue less expenses and taxes from the entity's ongoing operations and before income (loss) from: Preferred Dividends;
        Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing Operation; Income from Tax
        Loss Carry forward; Other Gains/Losses.
        """
        ...

    @NetIncomeContinuousOperations.setter
    def NetIncomeContinuousOperations(self, value: QuantConnect.Data.Fundamental.NetIncomeContinuousOperationsIncomeStatement):
        """
        Revenue less expenses and taxes from the entity's ongoing operations and before income (loss) from: Preferred Dividends;
        Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing Operation; Income from Tax
        Loss Carry forward; Other Gains/Losses.
        """
        ...

    @property
    def NetInterestIncome(self) -> QuantConnect.Data.Fundamental.NetInterestIncomeIncomeStatement:
        """
        Total interest income minus total interest expense. It represents the difference between interest and dividends earned on interest-
        bearing assets and interest paid to depositors and other creditors.
        """
        ...

    @NetInterestIncome.setter
    def NetInterestIncome(self, value: QuantConnect.Data.Fundamental.NetInterestIncomeIncomeStatement):
        """
        Total interest income minus total interest expense. It represents the difference between interest and dividends earned on interest-
        bearing assets and interest paid to depositors and other creditors.
        """
        ...

    @property
    def NetInvestmentIncome(self) -> QuantConnect.Data.Fundamental.NetInvestmentIncomeIncomeStatement:
        """
        Total of interest, dividends, and other earnings derived from the insurance company's invested assets minus the expenses
        associated with these investments. Excluded from this income are capital gains or losses as the result of the sale of assets, as well
        as any unrealized capital gains or losses.
        """
        ...

    @NetInvestmentIncome.setter
    def NetInvestmentIncome(self, value: QuantConnect.Data.Fundamental.NetInvestmentIncomeIncomeStatement):
        """
        Total of interest, dividends, and other earnings derived from the insurance company's invested assets minus the expenses
        associated with these investments. Excluded from this income are capital gains or losses as the result of the sale of assets, as well
        as any unrealized capital gains or losses.
        """
        ...

    @property
    def TotalRevenue(self) -> QuantConnect.Data.Fundamental.TotalRevenueIncomeStatement:
        """
        All sales, business revenues and income that the company makes from its business operations, net of excise taxes. This applies for
        all companies and can be used as comparison for all industries.
        For Normal, Mining, Transportation and Utility templates companies, this is the sum of Operating Revenues, Excise Taxes and Fees.
        For Bank template companies, this is the sum of Net Interest Income and Non-Interest Income.
        For Insurance template companies, this is the sum of Premiums, Interest Income, Fees, Investment and Other Income.
        """
        ...

    @TotalRevenue.setter
    def TotalRevenue(self, value: QuantConnect.Data.Fundamental.TotalRevenueIncomeStatement):
        """
        All sales, business revenues and income that the company makes from its business operations, net of excise taxes. This applies for
        all companies and can be used as comparison for all industries.
        For Normal, Mining, Transportation and Utility templates companies, this is the sum of Operating Revenues, Excise Taxes and Fees.
        For Bank template companies, this is the sum of Net Interest Income and Non-Interest Income.
        For Insurance template companies, this is the sum of Premiums, Interest Income, Fees, Investment and Other Income.
        """
        ...

    @property
    def NonInterestExpense(self) -> QuantConnect.Data.Fundamental.NonInterestExpenseIncomeStatement:
        """
        Any expenses that not related to interest. It includes labor and related expense, occupancy and equipment, commission,
        professional expense and contract services expenses, selling, general and administrative, research and development depreciation,
        amortization and depletion, and any other special income/charges.
        """
        ...

    @NonInterestExpense.setter
    def NonInterestExpense(self, value: QuantConnect.Data.Fundamental.NonInterestExpenseIncomeStatement):
        """
        Any expenses that not related to interest. It includes labor and related expense, occupancy and equipment, commission,
        professional expense and contract services expenses, selling, general and administrative, research and development depreciation,
        amortization and depletion, and any other special income/charges.
        """
        ...

    @property
    def NonInterestIncome(self) -> QuantConnect.Data.Fundamental.NonInterestIncomeIncomeStatement:
        """
        The total amount of non-interest income which may be derived from: (1) fees and commissions; (2) premiums earned; (3) equity
        investment; (4) the sale or disposal of assets; and (5) other sources not otherwise specified.
        """
        ...

    @NonInterestIncome.setter
    def NonInterestIncome(self, value: QuantConnect.Data.Fundamental.NonInterestIncomeIncomeStatement):
        """
        The total amount of non-interest income which may be derived from: (1) fees and commissions; (2) premiums earned; (3) equity
        investment; (4) the sale or disposal of assets; and (5) other sources not otherwise specified.
        """
        ...

    @property
    def OperatingExpense(self) -> QuantConnect.Data.Fundamental.OperatingExpenseIncomeStatement:
        """
        Operating expenses are primary recurring costs associated with central operations (other than cost of goods sold) that are incurred
        in order to generate sales.
        """
        ...

    @OperatingExpense.setter
    def OperatingExpense(self, value: QuantConnect.Data.Fundamental.OperatingExpenseIncomeStatement):
        """
        Operating expenses are primary recurring costs associated with central operations (other than cost of goods sold) that are incurred
        in order to generate sales.
        """
        ...

    @property
    def OperatingIncome(self) -> QuantConnect.Data.Fundamental.OperatingIncomeIncomeStatement:
        """
        Income from normal business operations after deducting cost of revenue and operating expenses. It does not include income from
        any investing activities.
        """
        ...

    @OperatingIncome.setter
    def OperatingIncome(self, value: QuantConnect.Data.Fundamental.OperatingIncomeIncomeStatement):
        """
        Income from normal business operations after deducting cost of revenue and operating expenses. It does not include income from
        any investing activities.
        """
        ...

    @property
    def OperatingRevenue(self) -> QuantConnect.Data.Fundamental.OperatingRevenueIncomeStatement:
        """
        Sales and income that the company makes from its business operations. This applies only to non-bank and insurance companies.
        For Utility template companies, this is the sum of revenue from electric, gas, transportation and other operating revenue.
        For Transportation template companies, this is the sum of revenue-passenger, revenue-cargo, and other operating revenue.
        """
        ...

    @OperatingRevenue.setter
    def OperatingRevenue(self, value: QuantConnect.Data.Fundamental.OperatingRevenueIncomeStatement):
        """
        Sales and income that the company makes from its business operations. This applies only to non-bank and insurance companies.
        For Utility template companies, this is the sum of revenue from electric, gas, transportation and other operating revenue.
        For Transportation template companies, this is the sum of revenue-passenger, revenue-cargo, and other operating revenue.
        """
        ...

    @property
    def OtherIncomeExpense(self) -> QuantConnect.Data.Fundamental.OtherIncomeExpenseIncomeStatement:
        """Income or expense that comes from miscellaneous sources."""
        ...

    @OtherIncomeExpense.setter
    def OtherIncomeExpense(self, value: QuantConnect.Data.Fundamental.OtherIncomeExpenseIncomeStatement):
        """Income or expense that comes from miscellaneous sources."""
        ...

    @property
    def PolicyAcquisitionExpense(self) -> QuantConnect.Data.Fundamental.PolicyAcquisitionExpenseIncomeStatement:
        """
        Costs that vary with and are primarily related to the acquisition of new and renewal insurance contracts. Also referred to as
        underwriting expenses.
        """
        ...

    @PolicyAcquisitionExpense.setter
    def PolicyAcquisitionExpense(self, value: QuantConnect.Data.Fundamental.PolicyAcquisitionExpenseIncomeStatement):
        """
        Costs that vary with and are primarily related to the acquisition of new and renewal insurance contracts. Also referred to as
        underwriting expenses.
        """
        ...

    @property
    def NetPolicyholderBenefitsAndClaims(self) -> QuantConnect.Data.Fundamental.NetPolicyholderBenefitsAndClaimsIncomeStatement:
        """
        The net provision in current period for future policy benefits, claims, and claims settlement expenses incurred in the claims
        settlement process before the effects of reinsurance arrangements. The value is net of the effects of contracts assumed and
        ceded.
        """
        ...

    @NetPolicyholderBenefitsAndClaims.setter
    def NetPolicyholderBenefitsAndClaims(self, value: QuantConnect.Data.Fundamental.NetPolicyholderBenefitsAndClaimsIncomeStatement):
        """
        The net provision in current period for future policy benefits, claims, and claims settlement expenses incurred in the claims
        settlement process before the effects of reinsurance arrangements. The value is net of the effects of contracts assumed and
        ceded.
        """
        ...

    @property
    def PreferredStockDividends(self) -> QuantConnect.Data.Fundamental.PreferredStockDividendsIncomeStatement:
        """
        The amount of dividends declared or paid in the period to preferred shareholders, or the amount for which the obligation to pay
        them dividends arose in the period. Preferred dividends are the amount required for the current year only, and not for any amount
        required in past years.
        """
        ...

    @PreferredStockDividends.setter
    def PreferredStockDividends(self, value: QuantConnect.Data.Fundamental.PreferredStockDividendsIncomeStatement):
        """
        The amount of dividends declared or paid in the period to preferred shareholders, or the amount for which the obligation to pay
        them dividends arose in the period. Preferred dividends are the amount required for the current year only, and not for any amount
        required in past years.
        """
        ...

    @property
    def TotalPremiumsEarned(self) -> QuantConnect.Data.Fundamental.TotalPremiumsEarnedIncomeStatement:
        """
        Premiums earned is the portion of an insurance written premium which is considered "earned" by the insurer, based on the part of
        the policy period that the insurance has been in effect, and during which the insurer has been exposed to loss.
        """
        ...

    @TotalPremiumsEarned.setter
    def TotalPremiumsEarned(self, value: QuantConnect.Data.Fundamental.TotalPremiumsEarnedIncomeStatement):
        """
        Premiums earned is the portion of an insurance written premium which is considered "earned" by the insurer, based on the part of
        the policy period that the insurance has been in effect, and during which the insurer has been exposed to loss.
        """
        ...

    @property
    def PretaxIncome(self) -> QuantConnect.Data.Fundamental.PretaxIncomeIncomeStatement:
        """Reported income before the deduction or benefit of income taxes."""
        ...

    @PretaxIncome.setter
    def PretaxIncome(self, value: QuantConnect.Data.Fundamental.PretaxIncomeIncomeStatement):
        """Reported income before the deduction or benefit of income taxes."""
        ...

    @property
    def TaxProvision(self) -> QuantConnect.Data.Fundamental.TaxProvisionIncomeStatement:
        """Include any taxes on income, net of any investment tax credits for the current accounting period."""
        ...

    @TaxProvision.setter
    def TaxProvision(self, value: QuantConnect.Data.Fundamental.TaxProvisionIncomeStatement):
        """Include any taxes on income, net of any investment tax credits for the current accounting period."""
        ...

    @property
    def CreditLossesProvision(self) -> QuantConnect.Data.Fundamental.CreditLossesProvisionIncomeStatement:
        """
        A charge to income which represents an expense deemed adequate by management given the composition of a bank's credit
        portfolios, their probability of default, the economic environment and the allowance for credit losses already established. Specific
        provisions are established to reduce the book value of specific assets (primarily loans) to establish the amount expected to be
        recovered on the loans.
        """
        ...

    @CreditLossesProvision.setter
    def CreditLossesProvision(self, value: QuantConnect.Data.Fundamental.CreditLossesProvisionIncomeStatement):
        """
        A charge to income which represents an expense deemed adequate by management given the composition of a bank's credit
        portfolios, their probability of default, the economic environment and the allowance for credit losses already established. Specific
        provisions are established to reduce the book value of specific assets (primarily loans) to establish the amount expected to be
        recovered on the loans.
        """
        ...

    @property
    def ResearchAndDevelopment(self) -> QuantConnect.Data.Fundamental.ResearchAndDevelopmentIncomeStatement:
        """The aggregate amount of research and development expenses during the year."""
        ...

    @ResearchAndDevelopment.setter
    def ResearchAndDevelopment(self, value: QuantConnect.Data.Fundamental.ResearchAndDevelopmentIncomeStatement):
        """The aggregate amount of research and development expenses during the year."""
        ...

    @property
    def SellingAndMarketingExpense(self) -> QuantConnect.Data.Fundamental.SellingAndMarketingExpenseIncomeStatement:
        """The aggregate total amount of expenses directly related to the marketing or selling of products or services."""
        ...

    @SellingAndMarketingExpense.setter
    def SellingAndMarketingExpense(self, value: QuantConnect.Data.Fundamental.SellingAndMarketingExpenseIncomeStatement):
        """The aggregate total amount of expenses directly related to the marketing or selling of products or services."""
        ...

    @property
    def SellingGeneralAndAdministration(self) -> QuantConnect.Data.Fundamental.SellingGeneralAndAdministrationIncomeStatement:
        """
        The aggregate total costs related to selling a firm's product and services, as well as all other general and administrative expenses.
        Selling expenses are those directly related to the company's efforts to generate sales (e.g., sales salaries, commissions,
        advertising, delivery expenses). General and administrative expenses are expenses related to general administration of the
        company's operation (e.g., officers and office salaries, office supplies, telephone, accounting and legal services, and business
        licenses and fees).
        """
        ...

    @SellingGeneralAndAdministration.setter
    def SellingGeneralAndAdministration(self, value: QuantConnect.Data.Fundamental.SellingGeneralAndAdministrationIncomeStatement):
        """
        The aggregate total costs related to selling a firm's product and services, as well as all other general and administrative expenses.
        Selling expenses are those directly related to the company's efforts to generate sales (e.g., sales salaries, commissions,
        advertising, delivery expenses). General and administrative expenses are expenses related to general administration of the
        company's operation (e.g., officers and office salaries, office supplies, telephone, accounting and legal services, and business
        licenses and fees).
        """
        ...

    @property
    def SpecialIncomeCharges(self) -> QuantConnect.Data.Fundamental.SpecialIncomeChargesIncomeStatement:
        """Earnings or losses attributable to occurrences or actions by the firm that is either infrequent or unusual."""
        ...

    @SpecialIncomeCharges.setter
    def SpecialIncomeCharges(self, value: QuantConnect.Data.Fundamental.SpecialIncomeChargesIncomeStatement):
        """Earnings or losses attributable to occurrences or actions by the firm that is either infrequent or unusual."""
        ...

    @property
    def TotalExpenses(self) -> QuantConnect.Data.Fundamental.TotalExpensesIncomeStatement:
        """
        The sum of operating expense and cost of revenue. If the company does not give the reported number, it will be calculated by
        adding operating expense and cost of revenue.
        """
        ...

    @TotalExpenses.setter
    def TotalExpenses(self, value: QuantConnect.Data.Fundamental.TotalExpensesIncomeStatement):
        """
        The sum of operating expense and cost of revenue. If the company does not give the reported number, it will be calculated by
        adding operating expense and cost of revenue.
        """
        ...

    @property
    def InterestIncome(self) -> QuantConnect.Data.Fundamental.InterestIncomeIncomeStatement:
        """Income generated from interest-bearing deposits or accounts."""
        ...

    @InterestIncome.setter
    def InterestIncome(self, value: QuantConnect.Data.Fundamental.InterestIncomeIncomeStatement):
        """Income generated from interest-bearing deposits or accounts."""
        ...

    @property
    def EBIT(self) -> QuantConnect.Data.Fundamental.EBITIncomeStatement:
        """Earnings minus expenses (excluding interest and tax expenses)."""
        ...

    @EBIT.setter
    def EBIT(self, value: QuantConnect.Data.Fundamental.EBITIncomeStatement):
        """Earnings minus expenses (excluding interest and tax expenses)."""
        ...

    @property
    def EBITDA(self) -> QuantConnect.Data.Fundamental.EBITDAIncomeStatement:
        """Earnings minus expenses (excluding interest, tax, depreciation, and amortization expenses)."""
        ...

    @EBITDA.setter
    def EBITDA(self, value: QuantConnect.Data.Fundamental.EBITDAIncomeStatement):
        """Earnings minus expenses (excluding interest, tax, depreciation, and amortization expenses)."""
        ...

    @property
    def NetIncomeContinuousOperationsNetMinorityInterest(self) -> QuantConnect.Data.Fundamental.NetIncomeContinuousOperationsNetMinorityInterestIncomeStatement:
        """
        Revenue less expenses and taxes from the entity's ongoing operations net of minority interest and before income (loss) from:
        Preferred Dividends; Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing
        Operation; Income from Tax Loss Carry forward; Other Gains/Losses.
        """
        ...

    @NetIncomeContinuousOperationsNetMinorityInterest.setter
    def NetIncomeContinuousOperationsNetMinorityInterest(self, value: QuantConnect.Data.Fundamental.NetIncomeContinuousOperationsNetMinorityInterestIncomeStatement):
        """
        Revenue less expenses and taxes from the entity's ongoing operations net of minority interest and before income (loss) from:
        Preferred Dividends; Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing
        Operation; Income from Tax Loss Carry forward; Other Gains/Losses.
        """
        ...

    @property
    def CededPremiums(self) -> QuantConnect.Data.Fundamental.CededPremiumsIncomeStatement:
        """
        The amount of premiums paid and payable to another insurer as a result of reinsurance arrangements in order to exchange for that
        company accepting all or part of insurance on a risk or exposure. This item is usually only available for insurance industry.
        """
        ...

    @CededPremiums.setter
    def CededPremiums(self, value: QuantConnect.Data.Fundamental.CededPremiumsIncomeStatement):
        """
        The amount of premiums paid and payable to another insurer as a result of reinsurance arrangements in order to exchange for that
        company accepting all or part of insurance on a risk or exposure. This item is usually only available for insurance industry.
        """
        ...

    @property
    def CommissionExpenses(self) -> QuantConnect.Data.Fundamental.CommissionExpensesIncomeStatement:
        """"""
        ...

    @CommissionExpenses.setter
    def CommissionExpenses(self, value: QuantConnect.Data.Fundamental.CommissionExpensesIncomeStatement):
        """"""
        ...

    @property
    def CreditCard(self) -> QuantConnect.Data.Fundamental.CreditCardIncomeStatement:
        """
        Income earned from credit card services including late, over limit, and annual fees. This item is usually only available for bank
        industry.
        """
        ...

    @CreditCard.setter
    def CreditCard(self, value: QuantConnect.Data.Fundamental.CreditCardIncomeStatement):
        """
        Income earned from credit card services including late, over limit, and annual fees. This item is usually only available for bank
        industry.
        """
        ...

    @property
    def DividendIncome(self) -> QuantConnect.Data.Fundamental.DividendIncomeIncomeStatement:
        """Dividends earned from equity investment securities. This item is usually only available for bank industry."""
        ...

    @DividendIncome.setter
    def DividendIncome(self, value: QuantConnect.Data.Fundamental.DividendIncomeIncomeStatement):
        """Dividends earned from equity investment securities. This item is usually only available for bank industry."""
        ...

    @property
    def EarningsFromEquityInterest(self) -> QuantConnect.Data.Fundamental.EarningsFromEquityInterestIncomeStatement:
        """
        The earnings from equity interest can be a result of any of the following: Income from earnings distribution of the business, either
        as dividends paid to corporate shareholders or as drawings in a partnership; Capital gain realized upon sale of the business; Capital
        gain realized from selling his or her interest to other partners. This item is usually not available for bank and insurance industries.
        """
        ...

    @EarningsFromEquityInterest.setter
    def EarningsFromEquityInterest(self, value: QuantConnect.Data.Fundamental.EarningsFromEquityInterestIncomeStatement):
        """
        The earnings from equity interest can be a result of any of the following: Income from earnings distribution of the business, either
        as dividends paid to corporate shareholders or as drawings in a partnership; Capital gain realized upon sale of the business; Capital
        gain realized from selling his or her interest to other partners. This item is usually not available for bank and insurance industries.
        """
        ...

    @property
    def Equipment(self) -> QuantConnect.Data.Fundamental.EquipmentIncomeStatement:
        """
        Equipment expenses include depreciation, repairs, rentals, and service contract costs. This also includes equipment purchases
        which do not qualify for capitalization in accordance with the entity's accounting policy. This item may also include furniture
        expenses. This item is usually only available for bank industry.
        """
        ...

    @Equipment.setter
    def Equipment(self, value: QuantConnect.Data.Fundamental.EquipmentIncomeStatement):
        """
        Equipment expenses include depreciation, repairs, rentals, and service contract costs. This also includes equipment purchases
        which do not qualify for capitalization in accordance with the entity's accounting policy. This item may also include furniture
        expenses. This item is usually only available for bank industry.
        """
        ...

    @property
    def ExplorationDevelopmentAndMineralPropertyLeaseExpenses(self) -> QuantConnect.Data.Fundamental.ExplorationDevelopmentAndMineralPropertyLeaseExpensesIncomeStatement:
        """
        Costs incurred in identifying areas that may warrant examination and in examining specific areas that are considered to have
        prospects of containing energy or metal reserves, including costs of drilling exploratory wells. Development expense is the
        capitalized costs incurred to obtain access to proved reserves and to provide facilities for extracting, treating, gathering and storing
        the energy and metal. Mineral property includes oil and gas wells, mines, and other natural deposits (including geothermal
        deposits). The payment for leasing those properties is called mineral property lease expense. Exploration expense is included in
        operation expenses for mining industry.
        """
        ...

    @ExplorationDevelopmentAndMineralPropertyLeaseExpenses.setter
    def ExplorationDevelopmentAndMineralPropertyLeaseExpenses(self, value: QuantConnect.Data.Fundamental.ExplorationDevelopmentAndMineralPropertyLeaseExpensesIncomeStatement):
        """
        Costs incurred in identifying areas that may warrant examination and in examining specific areas that are considered to have
        prospects of containing energy or metal reserves, including costs of drilling exploratory wells. Development expense is the
        capitalized costs incurred to obtain access to proved reserves and to provide facilities for extracting, treating, gathering and storing
        the energy and metal. Mineral property includes oil and gas wells, mines, and other natural deposits (including geothermal
        deposits). The payment for leasing those properties is called mineral property lease expense. Exploration expense is included in
        operation expenses for mining industry.
        """
        ...

    @property
    def FeesAndCommissions(self) -> QuantConnect.Data.Fundamental.FeesAndCommissionsIncomeStatement:
        """
        Total fees and commissions earned from providing services such as leasing of space or maintaining: (1) depositor accounts; (2)
        transfer agent; (3) fiduciary and trust; (4) brokerage and underwriting; (5) mortgage; (6) credit cards; (7) correspondent clearing;
        and (8) other such services and activities performed for others. This item is usually available for bank and insurance industries.
        """
        ...

    @FeesAndCommissions.setter
    def FeesAndCommissions(self, value: QuantConnect.Data.Fundamental.FeesAndCommissionsIncomeStatement):
        """
        Total fees and commissions earned from providing services such as leasing of space or maintaining: (1) depositor accounts; (2)
        transfer agent; (3) fiduciary and trust; (4) brokerage and underwriting; (5) mortgage; (6) credit cards; (7) correspondent clearing;
        and (8) other such services and activities performed for others. This item is usually available for bank and insurance industries.
        """
        ...

    @property
    def ForeignExchangeTradingGains(self) -> QuantConnect.Data.Fundamental.ForeignExchangeTradingGainsIncomeStatement:
        """
        Trading revenues that result from foreign exchange exposures such as cash instruments and off-balance sheet derivative
        instruments. This item is usually only available for bank industry.
        """
        ...

    @ForeignExchangeTradingGains.setter
    def ForeignExchangeTradingGains(self, value: QuantConnect.Data.Fundamental.ForeignExchangeTradingGainsIncomeStatement):
        """
        Trading revenues that result from foreign exchange exposures such as cash instruments and off-balance sheet derivative
        instruments. This item is usually only available for bank industry.
        """
        ...

    @property
    def Fuel(self) -> QuantConnect.Data.Fundamental.FuelIncomeStatement:
        """
        The aggregate amount of fuel cost for current period associated with the revenue generation. This item is usually only available for
        transportation industry.
        """
        ...

    @Fuel.setter
    def Fuel(self, value: QuantConnect.Data.Fundamental.FuelIncomeStatement):
        """
        The aggregate amount of fuel cost for current period associated with the revenue generation. This item is usually only available for
        transportation industry.
        """
        ...

    @property
    def FuelAndPurchasePower(self) -> QuantConnect.Data.Fundamental.FuelAndPurchasePowerIncomeStatement:
        """Cost of fuel, purchase power and gas associated with revenue generation. This item is usually only available for utility industry."""
        ...

    @FuelAndPurchasePower.setter
    def FuelAndPurchasePower(self, value: QuantConnect.Data.Fundamental.FuelAndPurchasePowerIncomeStatement):
        """Cost of fuel, purchase power and gas associated with revenue generation. This item is usually only available for utility industry."""
        ...

    @property
    def GainOnSaleOfBusiness(self) -> QuantConnect.Data.Fundamental.GainOnSaleOfBusinessIncomeStatement:
        """
        The amount of excess earned in comparison to fair value when selling a business. This item is usually not available for insurance
        industry.
        """
        ...

    @GainOnSaleOfBusiness.setter
    def GainOnSaleOfBusiness(self, value: QuantConnect.Data.Fundamental.GainOnSaleOfBusinessIncomeStatement):
        """
        The amount of excess earned in comparison to fair value when selling a business. This item is usually not available for insurance
        industry.
        """
        ...

    @property
    def GainOnSaleOfPPE(self) -> QuantConnect.Data.Fundamental.GainOnSaleOfPPEIncomeStatement:
        """
        The amount of excess earned in comparison to the net book value for sale of property, plant, equipment. This item is usually not
        available for bank and insurance industries.
        """
        ...

    @GainOnSaleOfPPE.setter
    def GainOnSaleOfPPE(self, value: QuantConnect.Data.Fundamental.GainOnSaleOfPPEIncomeStatement):
        """
        The amount of excess earned in comparison to the net book value for sale of property, plant, equipment. This item is usually not
        available for bank and insurance industries.
        """
        ...

    @property
    def GainOnSaleOfSecurity(self) -> QuantConnect.Data.Fundamental.GainOnSaleOfSecurityIncomeStatement:
        """The amount of excess earned in comparison to the original purchase value of the security."""
        ...

    @GainOnSaleOfSecurity.setter
    def GainOnSaleOfSecurity(self, value: QuantConnect.Data.Fundamental.GainOnSaleOfSecurityIncomeStatement):
        """The amount of excess earned in comparison to the original purchase value of the security."""
        ...

    @property
    def GrossPremiumsWritten(self) -> QuantConnect.Data.Fundamental.GrossPremiumsWrittenIncomeStatement:
        """
        Total premiums generated from all policies written by an insurance company within a given period of time. This item is usually only
        available for insurance industry.
        """
        ...

    @GrossPremiumsWritten.setter
    def GrossPremiumsWritten(self, value: QuantConnect.Data.Fundamental.GrossPremiumsWrittenIncomeStatement):
        """
        Total premiums generated from all policies written by an insurance company within a given period of time. This item is usually only
        available for insurance industry.
        """
        ...

    @property
    def ImpairmentOfCapitalAssets(self) -> QuantConnect.Data.Fundamental.ImpairmentOfCapitalAssetsIncomeStatement:
        """
        Impairments are considered to be permanent, which is a downward revaluation of fixed assets. If the sum of all estimated future
        cash flows is less than the carrying value of the asset, then the asset would be considered impaired and would have to be written
        down to its fair value. Once an asset is written down, it may only be written back up under very few circumstances. Usually the
        company uses the sum of undiscounted future cash flows to determine if the impairment should occur, and uses the sum of
        discounted future cash flows to make the impairment judgment. The impairment decision emphasizes on capital assets' future
        profit collection ability.
        """
        ...

    @ImpairmentOfCapitalAssets.setter
    def ImpairmentOfCapitalAssets(self, value: QuantConnect.Data.Fundamental.ImpairmentOfCapitalAssetsIncomeStatement):
        """
        Impairments are considered to be permanent, which is a downward revaluation of fixed assets. If the sum of all estimated future
        cash flows is less than the carrying value of the asset, then the asset would be considered impaired and would have to be written
        down to its fair value. Once an asset is written down, it may only be written back up under very few circumstances. Usually the
        company uses the sum of undiscounted future cash flows to determine if the impairment should occur, and uses the sum of
        discounted future cash flows to make the impairment judgment. The impairment decision emphasizes on capital assets' future
        profit collection ability.
        """
        ...

    @property
    def IncreaseDecreaseInNetUnearnedPremiumReserves(self) -> QuantConnect.Data.Fundamental.IncreaseDecreaseInNetUnearnedPremiumReservesIncomeStatement:
        """
        Premium might contain a portion of the amount that has been paid in advance for insurance that has not yet been provided, which
        is called unearned premium. If either party cancels the contract, the insurer must have the unearned premium ready to refund.
        Hence, the amount of premium reserve maintained by insurers is called unearned premium reserves, which is prepared for
        liquidation.  This item is usually only available for insurance industry.
        """
        ...

    @IncreaseDecreaseInNetUnearnedPremiumReserves.setter
    def IncreaseDecreaseInNetUnearnedPremiumReserves(self, value: QuantConnect.Data.Fundamental.IncreaseDecreaseInNetUnearnedPremiumReservesIncomeStatement):
        """
        Premium might contain a portion of the amount that has been paid in advance for insurance that has not yet been provided, which
        is called unearned premium. If either party cancels the contract, the insurer must have the unearned premium ready to refund.
        Hence, the amount of premium reserve maintained by insurers is called unearned premium reserves, which is prepared for
        liquidation.  This item is usually only available for insurance industry.
        """
        ...

    @property
    def InsuranceAndClaims(self) -> QuantConnect.Data.Fundamental.InsuranceAndClaimsIncomeStatement:
        """
        Insurance and claims are the expenses in the period incurred with respect to protection provided by insurance entities against risks
        other than risks associated with production (which is allocated to cost of sales). This item is usually not available for insurance
        industries.
        """
        ...

    @InsuranceAndClaims.setter
    def InsuranceAndClaims(self, value: QuantConnect.Data.Fundamental.InsuranceAndClaimsIncomeStatement):
        """
        Insurance and claims are the expenses in the period incurred with respect to protection provided by insurance entities against risks
        other than risks associated with production (which is allocated to cost of sales). This item is usually not available for insurance
        industries.
        """
        ...

    @property
    def InterestExpenseForDeposit(self) -> QuantConnect.Data.Fundamental.InterestExpenseForDepositIncomeStatement:
        """
        Includes interest expense on the following deposit accounts: Interest-bearing Demand deposit; Checking account; Savings account;
        Deposit in foreign offices; Money Market Certificates & Deposit Accounts. This item is usually only available for bank industry.
        """
        ...

    @InterestExpenseForDeposit.setter
    def InterestExpenseForDeposit(self, value: QuantConnect.Data.Fundamental.InterestExpenseForDepositIncomeStatement):
        """
        Includes interest expense on the following deposit accounts: Interest-bearing Demand deposit; Checking account; Savings account;
        Deposit in foreign offices; Money Market Certificates & Deposit Accounts. This item is usually only available for bank industry.
        """
        ...

    @property
    def InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell(self) -> QuantConnect.Data.Fundamental.InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement:
        """
        Gross expenses on the purchase of Federal funds at a specified price with a simultaneous agreement to sell the same to the same
        counterparty at a fixed or determinable price at a future date. This item is usually only available for bank industry.
        """
        ...

    @InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell.setter
    def InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell(self, value: QuantConnect.Data.Fundamental.InterestExpenseForFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement):
        """
        Gross expenses on the purchase of Federal funds at a specified price with a simultaneous agreement to sell the same to the same
        counterparty at a fixed or determinable price at a future date. This item is usually only available for bank industry.
        """
        ...

    @property
    def InterestExpenseForLongTermDebtAndCapitalSecurities(self) -> QuantConnect.Data.Fundamental.InterestExpenseForLongTermDebtAndCapitalSecuritiesIncomeStatement:
        """
        The aggregate interest expenses incurred on long-term borrowings and any interest expenses on fixed assets (property, plant,
        equipment) that are leased due longer than one year. This item is usually only available for bank industry.
        """
        ...

    @InterestExpenseForLongTermDebtAndCapitalSecurities.setter
    def InterestExpenseForLongTermDebtAndCapitalSecurities(self, value: QuantConnect.Data.Fundamental.InterestExpenseForLongTermDebtAndCapitalSecuritiesIncomeStatement):
        """
        The aggregate interest expenses incurred on long-term borrowings and any interest expenses on fixed assets (property, plant,
        equipment) that are leased due longer than one year. This item is usually only available for bank industry.
        """
        ...

    @property
    def InterestExpenseForShortTermDebt(self) -> QuantConnect.Data.Fundamental.InterestExpenseForShortTermDebtIncomeStatement:
        """
        The aggregate interest expenses incurred on short-term borrowings and any interest expenses on fixed assets (property, plant,
        equipment) that are leased within one year. This item is usually only available for bank industry.
        """
        ...

    @InterestExpenseForShortTermDebt.setter
    def InterestExpenseForShortTermDebt(self, value: QuantConnect.Data.Fundamental.InterestExpenseForShortTermDebtIncomeStatement):
        """
        The aggregate interest expenses incurred on short-term borrowings and any interest expenses on fixed assets (property, plant,
        equipment) that are leased within one year. This item is usually only available for bank industry.
        """
        ...

    @property
    def InterestIncomeFromDeposits(self) -> QuantConnect.Data.Fundamental.InterestIncomeFromDepositsIncomeStatement:
        """Interest income generated from all deposit accounts. This item is usually only available for bank industry."""
        ...

    @InterestIncomeFromDeposits.setter
    def InterestIncomeFromDeposits(self, value: QuantConnect.Data.Fundamental.InterestIncomeFromDepositsIncomeStatement):
        """Interest income generated from all deposit accounts. This item is usually only available for bank industry."""
        ...

    @property
    def InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell(self) -> QuantConnect.Data.Fundamental.InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement:
        """
        The carrying value of funds outstanding loaned in the form of security resale agreements if the agreement requires the purchaser to
        resell the identical security purchased or a security that meets the definition of ""substantially the same"" in the case of a dollar roll.
        Also includes purchases of participations in pools of securities that are subject to a resale agreement; This category includes all
        interest income generated from federal funds sold and securities purchases under agreements to resell; This category includes all
        interest income generated from federal funds sold and securities purchases under agreements to resell.
        """
        ...

    @InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell.setter
    def InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResell(self, value: QuantConnect.Data.Fundamental.InterestIncomeFromFederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellIncomeStatement):
        """
        The carrying value of funds outstanding loaned in the form of security resale agreements if the agreement requires the purchaser to
        resell the identical security purchased or a security that meets the definition of ""substantially the same"" in the case of a dollar roll.
        Also includes purchases of participations in pools of securities that are subject to a resale agreement; This category includes all
        interest income generated from federal funds sold and securities purchases under agreements to resell; This category includes all
        interest income generated from federal funds sold and securities purchases under agreements to resell.
        """
        ...

    @property
    def InterestIncomeFromLeases(self) -> QuantConnect.Data.Fundamental.InterestIncomeFromLeasesIncomeStatement:
        """Includes interest and fee income generated by direct lease financing. This item is usually only available for bank industry."""
        ...

    @InterestIncomeFromLeases.setter
    def InterestIncomeFromLeases(self, value: QuantConnect.Data.Fundamental.InterestIncomeFromLeasesIncomeStatement):
        """Includes interest and fee income generated by direct lease financing. This item is usually only available for bank industry."""
        ...

    @property
    def InterestIncomeFromLoans(self) -> QuantConnect.Data.Fundamental.InterestIncomeFromLoansIncomeStatement:
        """
        Loan is a common field to banks. Interest Income from Loans is interest and fee income generated from all loans, which includes
        Commercial loans; Credit loans; Other consumer loans; Real Estate - Construction; Real Estate - Mortgage; Foreign loans. Banks
        earn interest from loans. This item is usually only available for bank industry.
        """
        ...

    @InterestIncomeFromLoans.setter
    def InterestIncomeFromLoans(self, value: QuantConnect.Data.Fundamental.InterestIncomeFromLoansIncomeStatement):
        """
        Loan is a common field to banks. Interest Income from Loans is interest and fee income generated from all loans, which includes
        Commercial loans; Credit loans; Other consumer loans; Real Estate - Construction; Real Estate - Mortgage; Foreign loans. Banks
        earn interest from loans. This item is usually only available for bank industry.
        """
        ...

    @property
    def InterestIncomeFromLoansAndLease(self) -> QuantConnect.Data.Fundamental.InterestIncomeFromLoansAndLeaseIncomeStatement:
        """Total interest and fee income generated by loans and lease. This item is usually only available for bank industry."""
        ...

    @InterestIncomeFromLoansAndLease.setter
    def InterestIncomeFromLoansAndLease(self, value: QuantConnect.Data.Fundamental.InterestIncomeFromLoansAndLeaseIncomeStatement):
        """Total interest and fee income generated by loans and lease. This item is usually only available for bank industry."""
        ...

    @property
    def InterestIncomeFromSecurities(self) -> QuantConnect.Data.Fundamental.InterestIncomeFromSecuritiesIncomeStatement:
        """
        Represents total interest and dividend income from U.S. Treasury securities, U.S. government agency and corporation obligations,
        securities issued by states and political subdivisions, other domestic debt securities, foreign debt securities, and equity securities
        (including investments in mutual funds). Excludes interest income from securities held in trading accounts. This item is usually only
        available for bank industry.
        """
        ...

    @InterestIncomeFromSecurities.setter
    def InterestIncomeFromSecurities(self, value: QuantConnect.Data.Fundamental.InterestIncomeFromSecuritiesIncomeStatement):
        """
        Represents total interest and dividend income from U.S. Treasury securities, U.S. government agency and corporation obligations,
        securities issued by states and political subdivisions, other domestic debt securities, foreign debt securities, and equity securities
        (including investments in mutual funds). Excludes interest income from securities held in trading accounts. This item is usually only
        available for bank industry.
        """
        ...

    @property
    def InvestmentBankingProfit(self) -> QuantConnect.Data.Fundamental.InvestmentBankingProfitIncomeStatement:
        """
        Includes (1) underwriting revenue (the spread between the resale price received and the cost of the securities and related
        expenses) generated through the purchasing, distributing and reselling of new issues of securities (alternatively, could be a
        secondary offering of a large block of previously issued securities); and (2) fees earned for mergers, acquisitions, divestitures,
        restructurings, and other types of financial advisory services. This item is usually only available for bank industry.
        """
        ...

    @InvestmentBankingProfit.setter
    def InvestmentBankingProfit(self, value: QuantConnect.Data.Fundamental.InvestmentBankingProfitIncomeStatement):
        """
        Includes (1) underwriting revenue (the spread between the resale price received and the cost of the securities and related
        expenses) generated through the purchasing, distributing and reselling of new issues of securities (alternatively, could be a
        secondary offering of a large block of previously issued securities); and (2) fees earned for mergers, acquisitions, divestitures,
        restructurings, and other types of financial advisory services. This item is usually only available for bank industry.
        """
        ...

    @property
    def MaintenanceAndRepairs(self) -> QuantConnect.Data.Fundamental.MaintenanceAndRepairsIncomeStatement:
        """
        The aggregate amount of maintenance and repair expenses in the current period associated with the revenue generation. Mainly
        for fixed assets. This item is usually only available for transportation industry.
        """
        ...

    @MaintenanceAndRepairs.setter
    def MaintenanceAndRepairs(self, value: QuantConnect.Data.Fundamental.MaintenanceAndRepairsIncomeStatement):
        """
        The aggregate amount of maintenance and repair expenses in the current period associated with the revenue generation. Mainly
        for fixed assets. This item is usually only available for transportation industry.
        """
        ...

    @property
    def NetForeignExchangeGainLoss(self) -> QuantConnect.Data.Fundamental.NetForeignExchangeGainLossIncomeStatement:
        """
        The aggregate foreign currency translation gain or loss (both realized and unrealized) included as part of revenue. This item is
        usually only available for insurance industry.
        """
        ...

    @NetForeignExchangeGainLoss.setter
    def NetForeignExchangeGainLoss(self, value: QuantConnect.Data.Fundamental.NetForeignExchangeGainLossIncomeStatement):
        """
        The aggregate foreign currency translation gain or loss (both realized and unrealized) included as part of revenue. This item is
        usually only available for insurance industry.
        """
        ...

    @property
    def NetOccupancyExpense(self) -> QuantConnect.Data.Fundamental.NetOccupancyExpenseIncomeStatement:
        """
        Occupancy expense may include items, such as depreciation of facilities and equipment, lease expenses, property taxes and
        property and casualty insurance expense. This item is usually only available for bank industry.
        """
        ...

    @NetOccupancyExpense.setter
    def NetOccupancyExpense(self, value: QuantConnect.Data.Fundamental.NetOccupancyExpenseIncomeStatement):
        """
        Occupancy expense may include items, such as depreciation of facilities and equipment, lease expenses, property taxes and
        property and casualty insurance expense. This item is usually only available for bank industry.
        """
        ...

    @property
    def NetPremiumsWritten(self) -> QuantConnect.Data.Fundamental.NetPremiumsWrittenIncomeStatement:
        """Net premiums written are gross premiums written less ceded premiums. This item is usually only available for insurance industry."""
        ...

    @NetPremiumsWritten.setter
    def NetPremiumsWritten(self, value: QuantConnect.Data.Fundamental.NetPremiumsWrittenIncomeStatement):
        """Net premiums written are gross premiums written less ceded premiums. This item is usually only available for insurance industry."""
        ...

    @property
    def NetRealizedGainLossOnInvestments(self) -> QuantConnect.Data.Fundamental.NetRealizedGainLossOnInvestmentsIncomeStatement:
        """
        Gain or loss realized during the period of time for all kinds of investment securities. In might include trading, available-for-sale, or
        held-to-maturity securities. This item is usually only available for insurance industry.
        """
        ...

    @NetRealizedGainLossOnInvestments.setter
    def NetRealizedGainLossOnInvestments(self, value: QuantConnect.Data.Fundamental.NetRealizedGainLossOnInvestmentsIncomeStatement):
        """
        Gain or loss realized during the period of time for all kinds of investment securities. In might include trading, available-for-sale, or
        held-to-maturity securities. This item is usually only available for insurance industry.
        """
        ...

    @property
    def OccupancyAndEquipment(self) -> QuantConnect.Data.Fundamental.OccupancyAndEquipmentIncomeStatement:
        """Includes total expenses of occupancy and equipment. This item is usually only available for bank industry."""
        ...

    @OccupancyAndEquipment.setter
    def OccupancyAndEquipment(self, value: QuantConnect.Data.Fundamental.OccupancyAndEquipmentIncomeStatement):
        """Includes total expenses of occupancy and equipment. This item is usually only available for bank industry."""
        ...

    @property
    def OperationAndMaintenance(self) -> QuantConnect.Data.Fundamental.OperationAndMaintenanceIncomeStatement:
        """
        The aggregate amount of operation and maintenance expenses, which is the one important operating expense for the utility
        industry. It includes any costs related to production and maintenance cost of the property during the revenue generation process.
        This item is usually only available for mining and utility industries.
        """
        ...

    @OperationAndMaintenance.setter
    def OperationAndMaintenance(self, value: QuantConnect.Data.Fundamental.OperationAndMaintenanceIncomeStatement):
        """
        The aggregate amount of operation and maintenance expenses, which is the one important operating expense for the utility
        industry. It includes any costs related to production and maintenance cost of the property during the revenue generation process.
        This item is usually only available for mining and utility industries.
        """
        ...

    @property
    def OtherCustomerServices(self) -> QuantConnect.Data.Fundamental.OtherCustomerServicesIncomeStatement:
        """Represents fees and commissions earned from provide other services. This item is usually only available for bank industry."""
        ...

    @OtherCustomerServices.setter
    def OtherCustomerServices(self, value: QuantConnect.Data.Fundamental.OtherCustomerServicesIncomeStatement):
        """Represents fees and commissions earned from provide other services. This item is usually only available for bank industry."""
        ...

    @property
    def OtherInterestExpense(self) -> QuantConnect.Data.Fundamental.OtherInterestExpenseIncomeStatement:
        """All other interest expense that is not otherwise classified"""
        ...

    @OtherInterestExpense.setter
    def OtherInterestExpense(self, value: QuantConnect.Data.Fundamental.OtherInterestExpenseIncomeStatement):
        """All other interest expense that is not otherwise classified"""
        ...

    @property
    def OtherInterestIncome(self) -> QuantConnect.Data.Fundamental.OtherInterestIncomeIncomeStatement:
        """All other interest income that is not otherwise classified"""
        ...

    @OtherInterestIncome.setter
    def OtherInterestIncome(self, value: QuantConnect.Data.Fundamental.OtherInterestIncomeIncomeStatement):
        """All other interest income that is not otherwise classified"""
        ...

    @property
    def OtherNonInterestExpense(self) -> QuantConnect.Data.Fundamental.OtherNonInterestExpenseIncomeStatement:
        """All other non interest expense that is not otherwise classified"""
        ...

    @OtherNonInterestExpense.setter
    def OtherNonInterestExpense(self, value: QuantConnect.Data.Fundamental.OtherNonInterestExpenseIncomeStatement):
        """All other non interest expense that is not otherwise classified"""
        ...

    @property
    def OtherSpecialCharges(self) -> QuantConnect.Data.Fundamental.OtherSpecialChargesIncomeStatement:
        """All other special charges that are not otherwise classified"""
        ...

    @OtherSpecialCharges.setter
    def OtherSpecialCharges(self, value: QuantConnect.Data.Fundamental.OtherSpecialChargesIncomeStatement):
        """All other special charges that are not otherwise classified"""
        ...

    @property
    def OtherTaxes(self) -> QuantConnect.Data.Fundamental.OtherTaxesIncomeStatement:
        """Any taxes that are not part of income taxes. This item is usually not available for bank and insurance industries."""
        ...

    @OtherTaxes.setter
    def OtherTaxes(self, value: QuantConnect.Data.Fundamental.OtherTaxesIncomeStatement):
        """Any taxes that are not part of income taxes. This item is usually not available for bank and insurance industries."""
        ...

    @property
    def PolicyholderBenefitsCeded(self) -> QuantConnect.Data.Fundamental.PolicyholderBenefitsCededIncomeStatement:
        """
        The provision in current period for future policy benefits, claims, and claims settlement, which is under reinsurance arrangements.
        This item is usually only available for insurance industry.
        """
        ...

    @PolicyholderBenefitsCeded.setter
    def PolicyholderBenefitsCeded(self, value: QuantConnect.Data.Fundamental.PolicyholderBenefitsCededIncomeStatement):
        """
        The provision in current period for future policy benefits, claims, and claims settlement, which is under reinsurance arrangements.
        This item is usually only available for insurance industry.
        """
        ...

    @property
    def PolicyholderBenefitsGross(self) -> QuantConnect.Data.Fundamental.PolicyholderBenefitsGrossIncomeStatement:
        """
        The gross amount of provision in current period for future policyholder benefits, claims, and claims settlement, incurred in the
        claims settlement process before the effects of reinsurance arrangements. This item is usually only available for insurance industry.
        """
        ...

    @PolicyholderBenefitsGross.setter
    def PolicyholderBenefitsGross(self, value: QuantConnect.Data.Fundamental.PolicyholderBenefitsGrossIncomeStatement):
        """
        The gross amount of provision in current period for future policyholder benefits, claims, and claims settlement, incurred in the
        claims settlement process before the effects of reinsurance arrangements. This item is usually only available for insurance industry.
        """
        ...

    @property
    def PolicyholderDividends(self) -> QuantConnect.Data.Fundamental.PolicyholderDividendsIncomeStatement:
        """
        Payments made or credits extended to the insured by the company, usually at the end of a policy year results in reducing the net
        insurance cost to the policyholder. Such dividends may be paid in cash to the insured or applied by the insured as reductions of the
        premiums due for the next policy year. This item is usually only available for insurance industry.
        """
        ...

    @PolicyholderDividends.setter
    def PolicyholderDividends(self, value: QuantConnect.Data.Fundamental.PolicyholderDividendsIncomeStatement):
        """
        Payments made or credits extended to the insured by the company, usually at the end of a policy year results in reducing the net
        insurance cost to the policyholder. Such dividends may be paid in cash to the insured or applied by the insured as reductions of the
        premiums due for the next policy year. This item is usually only available for insurance industry.
        """
        ...

    @property
    def PolicyholderInterest(self) -> QuantConnect.Data.Fundamental.PolicyholderInterestIncomeStatement:
        """
        The periodic income payment provided to the annuitant by the insurance company, which is determined by the assumed interest
        rate (AIR) and other factors. This item is usually only available for insurance industry.
        """
        ...

    @PolicyholderInterest.setter
    def PolicyholderInterest(self, value: QuantConnect.Data.Fundamental.PolicyholderInterestIncomeStatement):
        """
        The periodic income payment provided to the annuitant by the insurance company, which is determined by the assumed interest
        rate (AIR) and other factors. This item is usually only available for insurance industry.
        """
        ...

    @property
    def ProfessionalExpenseAndContractServicesExpense(self) -> QuantConnect.Data.Fundamental.ProfessionalExpenseAndContractServicesExpenseIncomeStatement:
        """
        Professional and contract service expense includes cost reimbursements for support services related to contracted projects,
        outsourced management, technical and staff support. This item is usually only available for bank industry.
        """
        ...

    @ProfessionalExpenseAndContractServicesExpense.setter
    def ProfessionalExpenseAndContractServicesExpense(self, value: QuantConnect.Data.Fundamental.ProfessionalExpenseAndContractServicesExpenseIncomeStatement):
        """
        Professional and contract service expense includes cost reimbursements for support services related to contracted projects,
        outsourced management, technical and staff support. This item is usually only available for bank industry.
        """
        ...

    @property
    def ProvisionForDoubtfulAccounts(self) -> QuantConnect.Data.Fundamental.ProvisionForDoubtfulAccountsIncomeStatement:
        """
        Amount of the current period expense charged against operations, the offset which is generally to the allowance for doubtful
        accounts for the purpose of reducing receivables, including notes receivable, to an amount that approximates their net realizable
        value (the amount expected to be collected). The category includes provision for loan losses, provision for any doubtful account
        receivable, and bad debt expenses. This item is usually not available for bank and insurance industries.
        """
        ...

    @ProvisionForDoubtfulAccounts.setter
    def ProvisionForDoubtfulAccounts(self, value: QuantConnect.Data.Fundamental.ProvisionForDoubtfulAccountsIncomeStatement):
        """
        Amount of the current period expense charged against operations, the offset which is generally to the allowance for doubtful
        accounts for the purpose of reducing receivables, including notes receivable, to an amount that approximates their net realizable
        value (the amount expected to be collected). The category includes provision for loan losses, provision for any doubtful account
        receivable, and bad debt expenses. This item is usually not available for bank and insurance industries.
        """
        ...

    @property
    def RentAndLandingFees(self) -> QuantConnect.Data.Fundamental.RentAndLandingFeesIncomeStatement:
        """
        Rent fees are the cost of occupying space during the accounting period. Landing fees are a change paid to an airport company for
        landing at a particular airport. This item is not available for insurance industry.
        """
        ...

    @RentAndLandingFees.setter
    def RentAndLandingFees(self, value: QuantConnect.Data.Fundamental.RentAndLandingFeesIncomeStatement):
        """
        Rent fees are the cost of occupying space during the accounting period. Landing fees are a change paid to an airport company for
        landing at a particular airport. This item is not available for insurance industry.
        """
        ...

    @property
    def RestructuringAndMergernAcquisition(self) -> QuantConnect.Data.Fundamental.RestructuringAndMergernAcquisitionIncomeStatement:
        """
        Expenses are related to restructuring, merger, or acquisitions. Restructuring expenses are charges associated with the
        consolidation and relocation of operations, disposition or abandonment of operations or productive assets. Merger and acquisition
        expenses are the amount of costs of a business combination including legal, accounting, and other costs that were charged to
        expense during the period.
        """
        ...

    @RestructuringAndMergernAcquisition.setter
    def RestructuringAndMergernAcquisition(self, value: QuantConnect.Data.Fundamental.RestructuringAndMergernAcquisitionIncomeStatement):
        """
        Expenses are related to restructuring, merger, or acquisitions. Restructuring expenses are charges associated with the
        consolidation and relocation of operations, disposition or abandonment of operations or productive assets. Merger and acquisition
        expenses are the amount of costs of a business combination including legal, accounting, and other costs that were charged to
        expense during the period.
        """
        ...

    @property
    def SalariesAndWages(self) -> QuantConnect.Data.Fundamental.SalariesAndWagesIncomeStatement:
        """All salary, wages, compensation, management fees, and employee benefit expenses."""
        ...

    @SalariesAndWages.setter
    def SalariesAndWages(self, value: QuantConnect.Data.Fundamental.SalariesAndWagesIncomeStatement):
        """All salary, wages, compensation, management fees, and employee benefit expenses."""
        ...

    @property
    def SecuritiesActivities(self) -> QuantConnect.Data.Fundamental.SecuritiesActivitiesIncomeStatement:
        """Income/Loss from Securities and Activities"""
        ...

    @SecuritiesActivities.setter
    def SecuritiesActivities(self, value: QuantConnect.Data.Fundamental.SecuritiesActivitiesIncomeStatement):
        """Income/Loss from Securities and Activities"""
        ...

    @property
    def ServiceChargeOnDepositorAccounts(self) -> QuantConnect.Data.Fundamental.ServiceChargeOnDepositorAccountsIncomeStatement:
        """
        Includes any service charges on following accounts: Demand Deposit; Checking account; Savings account; Deposit in foreign
        offices; ESCROW accounts; Money Market Certificates & Deposit accounts, CDs (Negotiable Certificates of Deposits); NOW
        Accounts (Negotiable Order of Withdrawal); IRAs (Individual Retirement Accounts). This item is usually only available for bank
        industry.
        """
        ...

    @ServiceChargeOnDepositorAccounts.setter
    def ServiceChargeOnDepositorAccounts(self, value: QuantConnect.Data.Fundamental.ServiceChargeOnDepositorAccountsIncomeStatement):
        """
        Includes any service charges on following accounts: Demand Deposit; Checking account; Savings account; Deposit in foreign
        offices; ESCROW accounts; Money Market Certificates & Deposit accounts, CDs (Negotiable Certificates of Deposits); NOW
        Accounts (Negotiable Order of Withdrawal); IRAs (Individual Retirement Accounts). This item is usually only available for bank
        industry.
        """
        ...

    @property
    def TradingGainLoss(self) -> QuantConnect.Data.Fundamental.TradingGainLossIncomeStatement:
        """
        A broker-dealer or other financial entity may buy and sell securities exclusively for its own account, sometimes referred to as
        proprietary trading. The profit or loss is measured by the difference between the acquisition cost and the selling price or current
        market or fair value. The net gain or loss, includes both realized and unrealized, from trading cash instruments, equities and
        derivative contracts (including commodity contracts) that has been recognized during the accounting period for the broker dealer or
        other financial entity's own account. This item is typically available for bank industry.
        """
        ...

    @TradingGainLoss.setter
    def TradingGainLoss(self, value: QuantConnect.Data.Fundamental.TradingGainLossIncomeStatement):
        """
        A broker-dealer or other financial entity may buy and sell securities exclusively for its own account, sometimes referred to as
        proprietary trading. The profit or loss is measured by the difference between the acquisition cost and the selling price or current
        market or fair value. The net gain or loss, includes both realized and unrealized, from trading cash instruments, equities and
        derivative contracts (including commodity contracts) that has been recognized during the accounting period for the broker dealer or
        other financial entity's own account. This item is typically available for bank industry.
        """
        ...

    @property
    def TrustFeesbyCommissions(self) -> QuantConnect.Data.Fundamental.TrustFeesbyCommissionsIncomeStatement:
        """
        Bank manages funds on behalf of its customers through the operation of various trust accounts. Any fees earned through managing
        those funds are called trust fees, which are recognized when earned. This item is typically available for bank industry.
        """
        ...

    @TrustFeesbyCommissions.setter
    def TrustFeesbyCommissions(self, value: QuantConnect.Data.Fundamental.TrustFeesbyCommissionsIncomeStatement):
        """
        Bank manages funds on behalf of its customers through the operation of various trust accounts. Any fees earned through managing
        those funds are called trust fees, which are recognized when earned. This item is typically available for bank industry.
        """
        ...

    @property
    def UnderwritingExpenses(self) -> QuantConnect.Data.Fundamental.UnderwritingExpensesIncomeStatement:
        """
        Also known as Policy Acquisition Costs; and reported by insurance companies.  The cost incurred by an insurer when deciding
        whether to accept or decline a risk; may include meetings with the insureds or brokers, actuarial review of loss history, or physical
        inspections of exposures. Also, expenses deducted from insurance company revenues (including incurred losses and acquisition
        costs) to determine underwriting profit.
        """
        ...

    @UnderwritingExpenses.setter
    def UnderwritingExpenses(self, value: QuantConnect.Data.Fundamental.UnderwritingExpensesIncomeStatement):
        """
        Also known as Policy Acquisition Costs; and reported by insurance companies.  The cost incurred by an insurer when deciding
        whether to accept or decline a risk; may include meetings with the insureds or brokers, actuarial review of loss history, or physical
        inspections of exposures. Also, expenses deducted from insurance company revenues (including incurred losses and acquisition
        costs) to determine underwriting profit.
        """
        ...

    @property
    def WriteOff(self) -> QuantConnect.Data.Fundamental.WriteOffIncomeStatement:
        """A reduction in the value of an asset or earnings by the amount of an expense or loss."""
        ...

    @WriteOff.setter
    def WriteOff(self, value: QuantConnect.Data.Fundamental.WriteOffIncomeStatement):
        """A reduction in the value of an asset or earnings by the amount of an expense or loss."""
        ...

    @property
    def OtherNonInterestIncome(self) -> QuantConnect.Data.Fundamental.OtherNonInterestIncomeIncomeStatement:
        """Usually available for the banking industry.  This is Non-Interest Income that is not otherwise classified."""
        ...

    @OtherNonInterestIncome.setter
    def OtherNonInterestIncome(self, value: QuantConnect.Data.Fundamental.OtherNonInterestIncomeIncomeStatement):
        """Usually available for the banking industry.  This is Non-Interest Income that is not otherwise classified."""
        ...

    @property
    def AmortizationOfIntangibles(self) -> QuantConnect.Data.Fundamental.AmortizationOfIntangiblesIncomeStatement:
        """
        The aggregate expense charged against earnings to allocate the cost of intangible assets (nonphysical assets not used in
        production) in a systematic and rational manner to the periods expected to benefit from such assets.
        """
        ...

    @AmortizationOfIntangibles.setter
    def AmortizationOfIntangibles(self, value: QuantConnect.Data.Fundamental.AmortizationOfIntangiblesIncomeStatement):
        """
        The aggregate expense charged against earnings to allocate the cost of intangible assets (nonphysical assets not used in
        production) in a systematic and rational manner to the periods expected to benefit from such assets.
        """
        ...

    @property
    def NetIncomeFromContinuingAndDiscontinuedOperation(self) -> QuantConnect.Data.Fundamental.NetIncomeFromContinuingAndDiscontinuedOperationIncomeStatement:
        """Net Income from Continuing Operations and Discontinued Operations, added together."""
        ...

    @NetIncomeFromContinuingAndDiscontinuedOperation.setter
    def NetIncomeFromContinuingAndDiscontinuedOperation(self, value: QuantConnect.Data.Fundamental.NetIncomeFromContinuingAndDiscontinuedOperationIncomeStatement):
        """Net Income from Continuing Operations and Discontinued Operations, added together."""
        ...

    @property
    def NetIncomeFromTaxLossCarryforward(self) -> QuantConnect.Data.Fundamental.NetIncomeFromTaxLossCarryforwardIncomeStatement:
        """
        Occurs if a company has had a net loss from operations on a previous year that can be carried forward to reduce net income for tax
        purposes.
        """
        ...

    @NetIncomeFromTaxLossCarryforward.setter
    def NetIncomeFromTaxLossCarryforward(self, value: QuantConnect.Data.Fundamental.NetIncomeFromTaxLossCarryforwardIncomeStatement):
        """
        Occurs if a company has had a net loss from operations on a previous year that can be carried forward to reduce net income for tax
        purposes.
        """
        ...

    @property
    def OtherOperatingExpenses(self) -> QuantConnect.Data.Fundamental.OtherOperatingExpensesIncomeStatement:
        """
        The aggregate amount of operating expenses associated with normal operations. Will not include any gain, loss, benefit, or income;
        and its value reported by the company should be <0.
        """
        ...

    @OtherOperatingExpenses.setter
    def OtherOperatingExpenses(self, value: QuantConnect.Data.Fundamental.OtherOperatingExpensesIncomeStatement):
        """
        The aggregate amount of operating expenses associated with normal operations. Will not include any gain, loss, benefit, or income;
        and its value reported by the company should be <0.
        """
        ...

    @property
    def TotalMoneyMarketInvestments(self) -> QuantConnect.Data.Fundamental.TotalMoneyMarketInvestmentsIncomeStatement:
        """The sum of the money market investments held by a bank's depositors, which are FDIC insured."""
        ...

    @TotalMoneyMarketInvestments.setter
    def TotalMoneyMarketInvestments(self, value: QuantConnect.Data.Fundamental.TotalMoneyMarketInvestmentsIncomeStatement):
        """The sum of the money market investments held by a bank's depositors, which are FDIC insured."""
        ...

    @property
    def ReconciledCostOfRevenue(self) -> QuantConnect.Data.Fundamental.ReconciledCostOfRevenueIncomeStatement:
        """
        The Cost Of Revenue plus Depreciation, Depletion & Amortization from the IncomeStatement; minus Depreciation, Depletion &
        Amortization from the Cash Flow Statement
        """
        ...

    @ReconciledCostOfRevenue.setter
    def ReconciledCostOfRevenue(self, value: QuantConnect.Data.Fundamental.ReconciledCostOfRevenueIncomeStatement):
        """
        The Cost Of Revenue plus Depreciation, Depletion & Amortization from the IncomeStatement; minus Depreciation, Depletion &
        Amortization from the Cash Flow Statement
        """
        ...

    @property
    def ReconciledDepreciation(self) -> QuantConnect.Data.Fundamental.ReconciledDepreciationIncomeStatement:
        """Is Depreciation, Depletion & Amortization from the Cash Flow Statement"""
        ...

    @ReconciledDepreciation.setter
    def ReconciledDepreciation(self, value: QuantConnect.Data.Fundamental.ReconciledDepreciationIncomeStatement):
        """Is Depreciation, Depletion & Amortization from the Cash Flow Statement"""
        ...

    @property
    def NormalizedIncome(self) -> QuantConnect.Data.Fundamental.NormalizedIncomeIncomeStatement:
        """
        This calculation represents earnings adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This can be
        used to fairly measure a company's profitability. This is calculated using Net Income from Continuing Operations plus/minus any tax
        affected unusual Items and Goodwill Impairments/Write Offs.
        """
        ...

    @NormalizedIncome.setter
    def NormalizedIncome(self, value: QuantConnect.Data.Fundamental.NormalizedIncomeIncomeStatement):
        """
        This calculation represents earnings adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This can be
        used to fairly measure a company's profitability. This is calculated using Net Income from Continuing Operations plus/minus any tax
        affected unusual Items and Goodwill Impairments/Write Offs.
        """
        ...

    @property
    def NetIncomeFromContinuingOperationNetMinorityInterest(self) -> QuantConnect.Data.Fundamental.NetIncomeFromContinuingOperationNetMinorityInterestIncomeStatement:
        """
        Revenue less expenses and taxes from the entity's ongoing operations net of minority interest and before income (loss) from:
        Preferred Dividends; Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing
        Operation; Income from Tax Loss Carry forward; Other Gains/Losses.
        """
        ...

    @NetIncomeFromContinuingOperationNetMinorityInterest.setter
    def NetIncomeFromContinuingOperationNetMinorityInterest(self, value: QuantConnect.Data.Fundamental.NetIncomeFromContinuingOperationNetMinorityInterestIncomeStatement):
        """
        Revenue less expenses and taxes from the entity's ongoing operations net of minority interest and before income (loss) from:
        Preferred Dividends; Extraordinary Gains and Losses; Income from Cumulative Effects of Accounting Change; Discontinuing
        Operation; Income from Tax Loss Carry forward; Other Gains/Losses.
        """
        ...

    @property
    def GainLossonSaleofAssets(self) -> QuantConnect.Data.Fundamental.GainLossonSaleofAssetsIncomeStatement:
        """
        Any gain (loss) recognized on the sale of assets or a sale which generates profit or loss, which is a difference between sales price
        and net book value at the disposal time.
        """
        ...

    @GainLossonSaleofAssets.setter
    def GainLossonSaleofAssets(self, value: QuantConnect.Data.Fundamental.GainLossonSaleofAssetsIncomeStatement):
        """
        Any gain (loss) recognized on the sale of assets or a sale which generates profit or loss, which is a difference between sales price
        and net book value at the disposal time.
        """
        ...

    @property
    def GainonSaleofLoans(self) -> QuantConnect.Data.Fundamental.GainonSaleofLoansIncomeStatement:
        """Gain on sale of any loans investment."""
        ...

    @GainonSaleofLoans.setter
    def GainonSaleofLoans(self, value: QuantConnect.Data.Fundamental.GainonSaleofLoansIncomeStatement):
        """Gain on sale of any loans investment."""
        ...

    @property
    def GainonSaleofInvestmentProperty(self) -> QuantConnect.Data.Fundamental.GainonSaleofInvestmentPropertyIncomeStatement:
        """Gain on the disposal of investment property."""
        ...

    @GainonSaleofInvestmentProperty.setter
    def GainonSaleofInvestmentProperty(self, value: QuantConnect.Data.Fundamental.GainonSaleofInvestmentPropertyIncomeStatement):
        """Gain on the disposal of investment property."""
        ...

    @property
    def LossonExtinguishmentofDebt(self) -> QuantConnect.Data.Fundamental.LossonExtinguishmentofDebtIncomeStatement:
        """
        Loss on extinguishment of debt is the accounting loss that results from a debt extinguishment. A debt shall be accounted for as
        having been extinguished in a number of circumstances, including when it has been settled through repayment or replacement by
        another liability. It generally results in an accounting gain or loss. Amount represents the difference between the fair value of the
        payments made and the carrying amount of the debt at the time of its extinguishment.
        """
        ...

    @LossonExtinguishmentofDebt.setter
    def LossonExtinguishmentofDebt(self, value: QuantConnect.Data.Fundamental.LossonExtinguishmentofDebtIncomeStatement):
        """
        Loss on extinguishment of debt is the accounting loss that results from a debt extinguishment. A debt shall be accounted for as
        having been extinguished in a number of circumstances, including when it has been settled through repayment or replacement by
        another liability. It generally results in an accounting gain or loss. Amount represents the difference between the fair value of the
        payments made and the carrying amount of the debt at the time of its extinguishment.
        """
        ...

    @property
    def EarningsfromEquityInterestNetOfTax(self) -> QuantConnect.Data.Fundamental.EarningsfromEquityInterestNetOfTaxIncomeStatement:
        """Income from other equity interest reported after Provision of Tax. This applies to all industries."""
        ...

    @EarningsfromEquityInterestNetOfTax.setter
    def EarningsfromEquityInterestNetOfTax(self, value: QuantConnect.Data.Fundamental.EarningsfromEquityInterestNetOfTaxIncomeStatement):
        """Income from other equity interest reported after Provision of Tax. This applies to all industries."""
        ...

    @property
    def NetIncomeIncludingNoncontrollingInterests(self) -> QuantConnect.Data.Fundamental.NetIncomeIncludingNoncontrollingInterestsIncomeStatement:
        """Net income of the group after the adjustment of all expenses and benefit."""
        ...

    @NetIncomeIncludingNoncontrollingInterests.setter
    def NetIncomeIncludingNoncontrollingInterests(self, value: QuantConnect.Data.Fundamental.NetIncomeIncludingNoncontrollingInterestsIncomeStatement):
        """Net income of the group after the adjustment of all expenses and benefit."""
        ...

    @property
    def OtherunderPreferredStockDividend(self) -> QuantConnect.Data.Fundamental.OtherunderPreferredStockDividendIncomeStatement:
        """Dividend paid to the preferred shareholders before the common stock shareholders."""
        ...

    @OtherunderPreferredStockDividend.setter
    def OtherunderPreferredStockDividend(self, value: QuantConnect.Data.Fundamental.OtherunderPreferredStockDividendIncomeStatement):
        """Dividend paid to the preferred shareholders before the common stock shareholders."""
        ...

    @property
    def StaffCosts(self) -> QuantConnect.Data.Fundamental.StaffCostsIncomeStatement:
        """Total staff cost which is paid to the employees that is not part of Selling, General, and Administration expense."""
        ...

    @StaffCosts.setter
    def StaffCosts(self, value: QuantConnect.Data.Fundamental.StaffCostsIncomeStatement):
        """Total staff cost which is paid to the employees that is not part of Selling, General, and Administration expense."""
        ...

    @property
    def SocialSecurityCosts(self) -> QuantConnect.Data.Fundamental.SocialSecurityCostsIncomeStatement:
        """Benefits paid to the employees in respect of their work."""
        ...

    @SocialSecurityCosts.setter
    def SocialSecurityCosts(self, value: QuantConnect.Data.Fundamental.SocialSecurityCostsIncomeStatement):
        """Benefits paid to the employees in respect of their work."""
        ...

    @property
    def PensionCosts(self) -> QuantConnect.Data.Fundamental.PensionCostsIncomeStatement:
        """
        The expense that a company incurs each year by providing a pension plan for its employees. Major expenses in the pension cost
        include employer matching contributions and management fees.
        """
        ...

    @PensionCosts.setter
    def PensionCosts(self, value: QuantConnect.Data.Fundamental.PensionCostsIncomeStatement):
        """
        The expense that a company incurs each year by providing a pension plan for its employees. Major expenses in the pension cost
        include employer matching contributions and management fees.
        """
        ...

    @property
    def OtherOperatingIncomeTotal(self) -> QuantConnect.Data.Fundamental.OtherOperatingIncomeTotalIncomeStatement:
        """Total Other Operating Income- including interest income, dividend income and other types of operating income."""
        ...

    @OtherOperatingIncomeTotal.setter
    def OtherOperatingIncomeTotal(self, value: QuantConnect.Data.Fundamental.OtherOperatingIncomeTotalIncomeStatement):
        """Total Other Operating Income- including interest income, dividend income and other types of operating income."""
        ...

    @property
    def IncomefromAssociatesandOtherParticipatingInterests(self) -> QuantConnect.Data.Fundamental.IncomefromAssociatesandOtherParticipatingInterestsIncomeStatement:
        """Total income from the associates and joint venture via investment, accounted for in the Non-Operating section."""
        ...

    @IncomefromAssociatesandOtherParticipatingInterests.setter
    def IncomefromAssociatesandOtherParticipatingInterests(self, value: QuantConnect.Data.Fundamental.IncomefromAssociatesandOtherParticipatingInterestsIncomeStatement):
        """Total income from the associates and joint venture via investment, accounted for in the Non-Operating section."""
        ...

    @property
    def TotalOtherFinanceCost(self) -> QuantConnect.Data.Fundamental.TotalOtherFinanceCostIncomeStatement:
        """Any other finance cost which is not clearly defined in the Non-Operating section."""
        ...

    @TotalOtherFinanceCost.setter
    def TotalOtherFinanceCost(self, value: QuantConnect.Data.Fundamental.TotalOtherFinanceCostIncomeStatement):
        """Any other finance cost which is not clearly defined in the Non-Operating section."""
        ...

    @property
    def GrossDividendPayment(self) -> QuantConnect.Data.Fundamental.GrossDividendPaymentIncomeStatement:
        """Total amount paid in dividends to investors- this includes dividends paid on equity and non-equity shares."""
        ...

    @GrossDividendPayment.setter
    def GrossDividendPayment(self, value: QuantConnect.Data.Fundamental.GrossDividendPaymentIncomeStatement):
        """Total amount paid in dividends to investors- this includes dividends paid on equity and non-equity shares."""
        ...

    @property
    def FeesandCommissionIncome(self) -> QuantConnect.Data.Fundamental.FeesandCommissionIncomeIncomeStatement:
        """Fees and commission income earned by bank and insurance companies on the rendering services."""
        ...

    @FeesandCommissionIncome.setter
    def FeesandCommissionIncome(self, value: QuantConnect.Data.Fundamental.FeesandCommissionIncomeIncomeStatement):
        """Fees and commission income earned by bank and insurance companies on the rendering services."""
        ...

    @property
    def FeesandCommissionExpense(self) -> QuantConnect.Data.Fundamental.FeesandCommissionExpenseIncomeStatement:
        """Cost incurred by bank and insurance companies for fees and commission income."""
        ...

    @FeesandCommissionExpense.setter
    def FeesandCommissionExpense(self, value: QuantConnect.Data.Fundamental.FeesandCommissionExpenseIncomeStatement):
        """Cost incurred by bank and insurance companies for fees and commission income."""
        ...

    @property
    def NetTradingIncome(self) -> QuantConnect.Data.Fundamental.NetTradingIncomeIncomeStatement:
        """Any trading income on the securities."""
        ...

    @NetTradingIncome.setter
    def NetTradingIncome(self, value: QuantConnect.Data.Fundamental.NetTradingIncomeIncomeStatement):
        """Any trading income on the securities."""
        ...

    @property
    def OtherStaffCosts(self) -> QuantConnect.Data.Fundamental.OtherStaffCostsIncomeStatement:
        """Other costs in incurred in lieu of the employees that cannot be identified by other specific items in the Staff Costs section."""
        ...

    @OtherStaffCosts.setter
    def OtherStaffCosts(self, value: QuantConnect.Data.Fundamental.OtherStaffCostsIncomeStatement):
        """Other costs in incurred in lieu of the employees that cannot be identified by other specific items in the Staff Costs section."""
        ...

    @property
    def GainonInvestmentProperties(self) -> QuantConnect.Data.Fundamental.GainonInvestmentPropertiesIncomeStatement:
        """Gain on disposal and change in fair value of investment properties."""
        ...

    @GainonInvestmentProperties.setter
    def GainonInvestmentProperties(self, value: QuantConnect.Data.Fundamental.GainonInvestmentPropertiesIncomeStatement):
        """Gain on disposal and change in fair value of investment properties."""
        ...

    @property
    def AverageDilutionEarnings(self) -> QuantConnect.Data.Fundamental.AverageDilutionEarningsIncomeStatement:
        """
        Adjustments to reported net income to calculate Diluted EPS, by assuming that all convertible instruments are converted to
        Common Equity. The adjustments usually include the interest expense of debentures when assumed converted and preferred
        dividends of convertible preferred stock when assumed converted.
        """
        ...

    @AverageDilutionEarnings.setter
    def AverageDilutionEarnings(self, value: QuantConnect.Data.Fundamental.AverageDilutionEarningsIncomeStatement):
        """
        Adjustments to reported net income to calculate Diluted EPS, by assuming that all convertible instruments are converted to
        Common Equity. The adjustments usually include the interest expense of debentures when assumed converted and preferred
        dividends of convertible preferred stock when assumed converted.
        """
        ...

    @property
    def GainLossonFinancialInstrumentsDesignatedasCashFlowHedges(self) -> QuantConnect.Data.Fundamental.GainLossonFinancialInstrumentsDesignatedasCashFlowHedgesIncomeStatement:
        """Gain/Loss through hedging activities."""
        ...

    @GainLossonFinancialInstrumentsDesignatedasCashFlowHedges.setter
    def GainLossonFinancialInstrumentsDesignatedasCashFlowHedges(self, value: QuantConnect.Data.Fundamental.GainLossonFinancialInstrumentsDesignatedasCashFlowHedgesIncomeStatement):
        """Gain/Loss through hedging activities."""
        ...

    @property
    def GainLossonDerecognitionofAvailableForSaleFinancialAssets(self) -> QuantConnect.Data.Fundamental.GainLossonDerecognitionofAvailableForSaleFinancialAssetsIncomeStatement:
        """Gain/loss on the write-off of financial assets available-for-sale."""
        ...

    @GainLossonDerecognitionofAvailableForSaleFinancialAssets.setter
    def GainLossonDerecognitionofAvailableForSaleFinancialAssets(self, value: QuantConnect.Data.Fundamental.GainLossonDerecognitionofAvailableForSaleFinancialAssetsIncomeStatement):
        """Gain/loss on the write-off of financial assets available-for-sale."""
        ...

    @property
    def NegativeGoodwillImmediatelyRecognized(self) -> QuantConnect.Data.Fundamental.NegativeGoodwillImmediatelyRecognizedIncomeStatement:
        """
        Negative Goodwill recognized in the Income Statement. Negative Goodwill arises where the net assets at the date of acquisition,
        fairly valued, falls below the cost of acquisition.
        """
        ...

    @NegativeGoodwillImmediatelyRecognized.setter
    def NegativeGoodwillImmediatelyRecognized(self, value: QuantConnect.Data.Fundamental.NegativeGoodwillImmediatelyRecognizedIncomeStatement):
        """
        Negative Goodwill recognized in the Income Statement. Negative Goodwill arises where the net assets at the date of acquisition,
        fairly valued, falls below the cost of acquisition.
        """
        ...

    @property
    def GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotal(self) -> QuantConnect.Data.Fundamental.GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotalIncomeStatement:
        """Gain or loss on derivatives investment due to the fair value adjustment."""
        ...

    @GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotal.setter
    def GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotal(self, value: QuantConnect.Data.Fundamental.GainsLossesonFinancialInstrumentsDuetoFairValueAdjustmentsinHedgeAccountingTotalIncomeStatement):
        """Gain or loss on derivatives investment due to the fair value adjustment."""
        ...

    @property
    def ImpairmentLossesReversalsFinancialInstrumentsNet(self) -> QuantConnect.Data.Fundamental.ImpairmentLossesReversalsFinancialInstrumentsNetIncomeStatement:
        """
        Impairment or reversal of impairment on financial instrument such as derivative. This is a contra account under Total Revenue in
        banks.
        """
        ...

    @ImpairmentLossesReversalsFinancialInstrumentsNet.setter
    def ImpairmentLossesReversalsFinancialInstrumentsNet(self, value: QuantConnect.Data.Fundamental.ImpairmentLossesReversalsFinancialInstrumentsNetIncomeStatement):
        """
        Impairment or reversal of impairment on financial instrument such as derivative. This is a contra account under Total Revenue in
        banks.
        """
        ...

    @property
    def ClaimsandPaidIncurred(self) -> QuantConnect.Data.Fundamental.ClaimsandPaidIncurredIncomeStatement:
        """All reported claims arising out of incidents in that year are considered incurred grouped with claims paid out."""
        ...

    @ClaimsandPaidIncurred.setter
    def ClaimsandPaidIncurred(self, value: QuantConnect.Data.Fundamental.ClaimsandPaidIncurredIncomeStatement):
        """All reported claims arising out of incidents in that year are considered incurred grouped with claims paid out."""
        ...

    @property
    def ReinsuranceRecoveriesClaimsandBenefits(self) -> QuantConnect.Data.Fundamental.ReinsuranceRecoveriesClaimsandBenefitsIncomeStatement:
        """Claim on the reinsurance company and take the benefits."""
        ...

    @ReinsuranceRecoveriesClaimsandBenefits.setter
    def ReinsuranceRecoveriesClaimsandBenefits(self, value: QuantConnect.Data.Fundamental.ReinsuranceRecoveriesClaimsandBenefitsIncomeStatement):
        """Claim on the reinsurance company and take the benefits."""
        ...

    @property
    def ChangeinInsuranceLiabilitiesNetofReinsurance(self) -> QuantConnect.Data.Fundamental.ChangeinInsuranceLiabilitiesNetofReinsuranceIncomeStatement:
        """Income/Expense due to changes between periods in insurance liabilities."""
        ...

    @ChangeinInsuranceLiabilitiesNetofReinsurance.setter
    def ChangeinInsuranceLiabilitiesNetofReinsurance(self, value: QuantConnect.Data.Fundamental.ChangeinInsuranceLiabilitiesNetofReinsuranceIncomeStatement):
        """Income/Expense due to changes between periods in insurance liabilities."""
        ...

    @property
    def ChangeinInvestmentContract(self) -> QuantConnect.Data.Fundamental.ChangeinInvestmentContractIncomeStatement:
        """Income/Expense due to changes between periods in Investment Contracts."""
        ...

    @ChangeinInvestmentContract.setter
    def ChangeinInvestmentContract(self, value: QuantConnect.Data.Fundamental.ChangeinInvestmentContractIncomeStatement):
        """Income/Expense due to changes between periods in Investment Contracts."""
        ...

    @property
    def CreditRiskProvisions(self) -> QuantConnect.Data.Fundamental.CreditRiskProvisionsIncomeStatement:
        """
        Provision for the risk of loss of principal or loss of a financial reward stemming from a borrower's failure to repay a loan or otherwise
        meet a contractual obligation. Credit risk arises whenever a borrower is expecting to use future cash flows to pay a current debt.
        Investors are compensated for assuming credit risk by way of interest payments from the borrower or issuer of a debt obligation.
        This is a contra account under Total Revenue in banks.
        """
        ...

    @CreditRiskProvisions.setter
    def CreditRiskProvisions(self, value: QuantConnect.Data.Fundamental.CreditRiskProvisionsIncomeStatement):
        """
        Provision for the risk of loss of principal or loss of a financial reward stemming from a borrower's failure to repay a loan or otherwise
        meet a contractual obligation. Credit risk arises whenever a borrower is expecting to use future cash flows to pay a current debt.
        Investors are compensated for assuming credit risk by way of interest payments from the borrower or issuer of a debt obligation.
        This is a contra account under Total Revenue in banks.
        """
        ...

    @property
    def WagesandSalaries(self) -> QuantConnect.Data.Fundamental.WagesandSalariesIncomeStatement:
        """This is the portion under Staff Costs that represents salary paid to the employees in respect of their work."""
        ...

    @WagesandSalaries.setter
    def WagesandSalaries(self, value: QuantConnect.Data.Fundamental.WagesandSalariesIncomeStatement):
        """This is the portion under Staff Costs that represents salary paid to the employees in respect of their work."""
        ...

    @property
    def OtherNonOperatingIncomeExpenses(self) -> QuantConnect.Data.Fundamental.OtherNonOperatingIncomeExpensesIncomeStatement:
        """Total other income and expense of the company that cannot be identified by other specific items in the Non-Operating section."""
        ...

    @OtherNonOperatingIncomeExpenses.setter
    def OtherNonOperatingIncomeExpenses(self, value: QuantConnect.Data.Fundamental.OtherNonOperatingIncomeExpensesIncomeStatement):
        """Total other income and expense of the company that cannot be identified by other specific items in the Non-Operating section."""
        ...

    @property
    def OtherNonOperatingIncome(self) -> QuantConnect.Data.Fundamental.OtherNonOperatingIncomeIncomeStatement:
        """Other income of the company that cannot be identified by other specific items in the Non-Operating section."""
        ...

    @OtherNonOperatingIncome.setter
    def OtherNonOperatingIncome(self, value: QuantConnect.Data.Fundamental.OtherNonOperatingIncomeIncomeStatement):
        """Other income of the company that cannot be identified by other specific items in the Non-Operating section."""
        ...

    @property
    def OtherNonOperatingExpenses(self) -> QuantConnect.Data.Fundamental.OtherNonOperatingExpensesIncomeStatement:
        """Other expenses of the company that cannot be identified by other specific items in the Non-Operating section."""
        ...

    @OtherNonOperatingExpenses.setter
    def OtherNonOperatingExpenses(self, value: QuantConnect.Data.Fundamental.OtherNonOperatingExpensesIncomeStatement):
        """Other expenses of the company that cannot be identified by other specific items in the Non-Operating section."""
        ...

    @property
    def TotalUnusualItems(self) -> QuantConnect.Data.Fundamental.TotalUnusualItemsIncomeStatement:
        """Total unusual items including Negative Goodwill."""
        ...

    @TotalUnusualItems.setter
    def TotalUnusualItems(self, value: QuantConnect.Data.Fundamental.TotalUnusualItemsIncomeStatement):
        """Total unusual items including Negative Goodwill."""
        ...

    @property
    def TotalUnusualItemsExcludingGoodwill(self) -> QuantConnect.Data.Fundamental.TotalUnusualItemsExcludingGoodwillIncomeStatement:
        """The sum of all the identifiable operating and non-operating unusual items."""
        ...

    @TotalUnusualItemsExcludingGoodwill.setter
    def TotalUnusualItemsExcludingGoodwill(self, value: QuantConnect.Data.Fundamental.TotalUnusualItemsExcludingGoodwillIncomeStatement):
        """The sum of all the identifiable operating and non-operating unusual items."""
        ...

    @property
    def TaxRateForCalcs(self) -> QuantConnect.Data.Fundamental.TaxRateForCalcsIncomeStatement:
        """Tax rate used for Morningstar calculations."""
        ...

    @TaxRateForCalcs.setter
    def TaxRateForCalcs(self, value: QuantConnect.Data.Fundamental.TaxRateForCalcsIncomeStatement):
        """Tax rate used for Morningstar calculations."""
        ...

    @property
    def TaxEffectOfUnusualItems(self) -> QuantConnect.Data.Fundamental.TaxEffectOfUnusualItemsIncomeStatement:
        """Tax effect of the usual items"""
        ...

    @TaxEffectOfUnusualItems.setter
    def TaxEffectOfUnusualItems(self, value: QuantConnect.Data.Fundamental.TaxEffectOfUnusualItemsIncomeStatement):
        """Tax effect of the usual items"""
        ...

    @property
    def NormalizedEBITDA(self) -> QuantConnect.Data.Fundamental.NormalizedEBITDAIncomeStatement:
        """EBITDA less Total Unusual Items"""
        ...

    @NormalizedEBITDA.setter
    def NormalizedEBITDA(self, value: QuantConnect.Data.Fundamental.NormalizedEBITDAIncomeStatement):
        """EBITDA less Total Unusual Items"""
        ...

    @property
    def StockBasedCompensation(self) -> QuantConnect.Data.Fundamental.StockBasedCompensationIncomeStatement:
        """The cost to the company for granting stock options to reward employees."""
        ...

    @StockBasedCompensation.setter
    def StockBasedCompensation(self, value: QuantConnect.Data.Fundamental.StockBasedCompensationIncomeStatement):
        """The cost to the company for granting stock options to reward employees."""
        ...

    @property
    def ISFileDate(self) -> datetime.datetime:
        """Filing date of the Income Statement."""
        ...

    @ISFileDate.setter
    def ISFileDate(self, value: datetime.datetime):
        """Filing date of the Income Statement."""
        ...

    @property
    def DilutedNIAvailtoComStockholders(self) -> QuantConnect.Data.Fundamental.DilutedNIAvailtoComStockholdersIncomeStatement:
        """
        Net income to calculate Diluted EPS, accounting for adjustments assuming that all the convertible instruments are being converted
        to Common Equity.
        """
        ...

    @DilutedNIAvailtoComStockholders.setter
    def DilutedNIAvailtoComStockholders(self, value: QuantConnect.Data.Fundamental.DilutedNIAvailtoComStockholdersIncomeStatement):
        """
        Net income to calculate Diluted EPS, accounting for adjustments assuming that all the convertible instruments are being converted
        to Common Equity.
        """
        ...

    @property
    def InvestmentContractLiabilitiesIncurred(self) -> QuantConnect.Data.Fundamental.InvestmentContractLiabilitiesIncurredIncomeStatement:
        """Income/Expenses due to the insurer's liabilities incurred in Investment Contracts."""
        ...

    @InvestmentContractLiabilitiesIncurred.setter
    def InvestmentContractLiabilitiesIncurred(self, value: QuantConnect.Data.Fundamental.InvestmentContractLiabilitiesIncurredIncomeStatement):
        """Income/Expenses due to the insurer's liabilities incurred in Investment Contracts."""
        ...

    @property
    def ReinsuranceRecoveriesofInvestmentContract(self) -> QuantConnect.Data.Fundamental.ReinsuranceRecoveriesofInvestmentContractIncomeStatement:
        """Income/Expense due to recoveries from reinsurers for Investment Contracts."""
        ...

    @ReinsuranceRecoveriesofInvestmentContract.setter
    def ReinsuranceRecoveriesofInvestmentContract(self, value: QuantConnect.Data.Fundamental.ReinsuranceRecoveriesofInvestmentContractIncomeStatement):
        """Income/Expense due to recoveries from reinsurers for Investment Contracts."""
        ...

    @property
    def TotalDividendPaymentofEquityShares(self) -> QuantConnect.Data.Fundamental.TotalDividendPaymentofEquitySharesIncomeStatement:
        """Total amount paid in dividends to equity securities investors."""
        ...

    @TotalDividendPaymentofEquityShares.setter
    def TotalDividendPaymentofEquityShares(self, value: QuantConnect.Data.Fundamental.TotalDividendPaymentofEquitySharesIncomeStatement):
        """Total amount paid in dividends to equity securities investors."""
        ...

    @property
    def TotalDividendPaymentofNonEquityShares(self) -> QuantConnect.Data.Fundamental.TotalDividendPaymentofNonEquitySharesIncomeStatement:
        """Total amount paid in dividends to Non-Equity securities investors."""
        ...

    @TotalDividendPaymentofNonEquityShares.setter
    def TotalDividendPaymentofNonEquityShares(self, value: QuantConnect.Data.Fundamental.TotalDividendPaymentofNonEquitySharesIncomeStatement):
        """Total amount paid in dividends to Non-Equity securities investors."""
        ...

    @property
    def ChangeinTheGrossProvisionforUnearnedPremiums(self) -> QuantConnect.Data.Fundamental.ChangeinTheGrossProvisionforUnearnedPremiumsIncomeStatement:
        """The change in the amount of the unearned premium reserves maintained by insurers."""
        ...

    @ChangeinTheGrossProvisionforUnearnedPremiums.setter
    def ChangeinTheGrossProvisionforUnearnedPremiums(self, value: QuantConnect.Data.Fundamental.ChangeinTheGrossProvisionforUnearnedPremiumsIncomeStatement):
        """The change in the amount of the unearned premium reserves maintained by insurers."""
        ...

    @property
    def ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShare(self) -> QuantConnect.Data.Fundamental.ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShareIncomeStatement:
        """The change in the amount of unearned premium reserve to be covered by reinsurers."""
        ...

    @ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShare.setter
    def ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShare(self, value: QuantConnect.Data.Fundamental.ChangeinTheGrossProvisionforUnearnedPremiumsReinsurersShareIncomeStatement):
        """The change in the amount of unearned premium reserve to be covered by reinsurers."""
        ...

    @property
    def ClaimsandChangeinInsuranceLiabilities(self) -> QuantConnect.Data.Fundamental.ClaimsandChangeinInsuranceLiabilitiesIncomeStatement:
        """Income/Expense due to the insurer's changes in insurance liabilities."""
        ...

    @ClaimsandChangeinInsuranceLiabilities.setter
    def ClaimsandChangeinInsuranceLiabilities(self, value: QuantConnect.Data.Fundamental.ClaimsandChangeinInsuranceLiabilitiesIncomeStatement):
        """Income/Expense due to the insurer's changes in insurance liabilities."""
        ...

    @property
    def ReinsuranceRecoveriesofInsuranceLiabilities(self) -> QuantConnect.Data.Fundamental.ReinsuranceRecoveriesofInsuranceLiabilitiesIncomeStatement:
        """Income/Expense due to recoveries from reinsurers for insurance liabilities."""
        ...

    @ReinsuranceRecoveriesofInsuranceLiabilities.setter
    def ReinsuranceRecoveriesofInsuranceLiabilities(self, value: QuantConnect.Data.Fundamental.ReinsuranceRecoveriesofInsuranceLiabilitiesIncomeStatement):
        """Income/Expense due to recoveries from reinsurers for insurance liabilities."""
        ...

    @property
    def TotalOperatingIncomeAsReported(self) -> QuantConnect.Data.Fundamental.TotalOperatingIncomeAsReportedIncomeStatement:
        """Operating profit/loss as reported by the company, may be the same or not the same as Morningstar's standardized definition."""
        ...

    @TotalOperatingIncomeAsReported.setter
    def TotalOperatingIncomeAsReported(self, value: QuantConnect.Data.Fundamental.TotalOperatingIncomeAsReportedIncomeStatement):
        """Operating profit/loss as reported by the company, may be the same or not the same as Morningstar's standardized definition."""
        ...

    @property
    def OtherGA(self) -> QuantConnect.Data.Fundamental.OtherGAIncomeStatement:
        """
        Other General and Administrative Expenses not categorized that the company incurs that are not directly tied to a specific function
        such as manufacturing, production, or sales.
        """
        ...

    @OtherGA.setter
    def OtherGA(self, value: QuantConnect.Data.Fundamental.OtherGAIncomeStatement):
        """
        Other General and Administrative Expenses not categorized that the company incurs that are not directly tied to a specific function
        such as manufacturing, production, or sales.
        """
        ...

    @property
    def OtherCostofRevenue(self) -> QuantConnect.Data.Fundamental.OtherCostofRevenueIncomeStatement:
        """Other costs associated with the revenue-generating activities of the company not categorized above."""
        ...

    @OtherCostofRevenue.setter
    def OtherCostofRevenue(self, value: QuantConnect.Data.Fundamental.OtherCostofRevenueIncomeStatement):
        """Other costs associated with the revenue-generating activities of the company not categorized above."""
        ...

    @property
    def RentandLandingFeesCostofRevenue(self) -> QuantConnect.Data.Fundamental.RentandLandingFeesCostofRevenueIncomeStatement:
        """Costs paid to use the facilities necessary to generate revenue during the accounting period."""
        ...

    @RentandLandingFeesCostofRevenue.setter
    def RentandLandingFeesCostofRevenue(self, value: QuantConnect.Data.Fundamental.RentandLandingFeesCostofRevenueIncomeStatement):
        """Costs paid to use the facilities necessary to generate revenue during the accounting period."""
        ...

    @property
    def DDACostofRevenue(self) -> QuantConnect.Data.Fundamental.DDACostofRevenueIncomeStatement:
        """Costs of depreciation and amortization on assets used for the revenue-generating activities during the accounting period"""
        ...

    @DDACostofRevenue.setter
    def DDACostofRevenue(self, value: QuantConnect.Data.Fundamental.DDACostofRevenueIncomeStatement):
        """Costs of depreciation and amortization on assets used for the revenue-generating activities during the accounting period"""
        ...

    @property
    def RentExpenseSupplemental(self) -> QuantConnect.Data.Fundamental.RentExpenseSupplementalIncomeStatement:
        """
        The sum of all rent expenses incurred by the company for operating leases during the year, it is a supplemental value which would
        be reported outside consolidated statements or consolidated statement's footnotes.
        """
        ...

    @RentExpenseSupplemental.setter
    def RentExpenseSupplemental(self, value: QuantConnect.Data.Fundamental.RentExpenseSupplementalIncomeStatement):
        """
        The sum of all rent expenses incurred by the company for operating leases during the year, it is a supplemental value which would
        be reported outside consolidated statements or consolidated statement's footnotes.
        """
        ...

    @property
    def NormalizedPreTaxIncome(self) -> QuantConnect.Data.Fundamental.NormalizedPreTaxIncomeIncomeStatement:
        """
        This calculation represents pre-tax earnings adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This
        can be used to fairly measure a company's profitability. This is calculated using Pre-Tax Income plus/minus any unusual Items and
        Goodwill Impairments/Write Offs.
        """
        ...

    @NormalizedPreTaxIncome.setter
    def NormalizedPreTaxIncome(self, value: QuantConnect.Data.Fundamental.NormalizedPreTaxIncomeIncomeStatement):
        """
        This calculation represents pre-tax earnings adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This
        can be used to fairly measure a company's profitability. This is calculated using Pre-Tax Income plus/minus any unusual Items and
        Goodwill Impairments/Write Offs.
        """
        ...

    @property
    def ResearchAndDevelopmentExpensesSupplemental(self) -> QuantConnect.Data.Fundamental.ResearchAndDevelopmentExpensesSupplementalIncomeStatement:
        """
        The aggregate amount of research and development expenses during the year. It is a supplemental value which would be reported
        outside consolidated statements.
        """
        ...

    @ResearchAndDevelopmentExpensesSupplemental.setter
    def ResearchAndDevelopmentExpensesSupplemental(self, value: QuantConnect.Data.Fundamental.ResearchAndDevelopmentExpensesSupplementalIncomeStatement):
        """
        The aggregate amount of research and development expenses during the year. It is a supplemental value which would be reported
        outside consolidated statements.
        """
        ...

    @property
    def DepreciationSupplemental(self) -> QuantConnect.Data.Fundamental.DepreciationSupplementalIncomeStatement:
        """
        The current period expense charged against earnings on tangible asset over its useful life. It is a supplemental value which would
        be reported outside consolidated statements.
        """
        ...

    @DepreciationSupplemental.setter
    def DepreciationSupplemental(self, value: QuantConnect.Data.Fundamental.DepreciationSupplementalIncomeStatement):
        """
        The current period expense charged against earnings on tangible asset over its useful life. It is a supplemental value which would
        be reported outside consolidated statements.
        """
        ...

    @property
    def AmortizationSupplemental(self) -> QuantConnect.Data.Fundamental.AmortizationSupplementalIncomeStatement:
        """
        The current period expense charged against earnings on intangible asset over its useful life. It is a supplemental value which would
        be reported outside consolidated statements.
        """
        ...

    @AmortizationSupplemental.setter
    def AmortizationSupplemental(self, value: QuantConnect.Data.Fundamental.AmortizationSupplementalIncomeStatement):
        """
        The current period expense charged against earnings on intangible asset over its useful life. It is a supplemental value which would
        be reported outside consolidated statements.
        """
        ...

    @property
    def TotalRevenueAsReported(self) -> QuantConnect.Data.Fundamental.TotalRevenueAsReportedIncomeStatement:
        """Total revenue as reported by the company, may be the same or not the same as Morningstar's standardized definition."""
        ...

    @TotalRevenueAsReported.setter
    def TotalRevenueAsReported(self, value: QuantConnect.Data.Fundamental.TotalRevenueAsReportedIncomeStatement):
        """Total revenue as reported by the company, may be the same or not the same as Morningstar's standardized definition."""
        ...

    @property
    def OperatingExpenseAsReported(self) -> QuantConnect.Data.Fundamental.OperatingExpenseAsReportedIncomeStatement:
        """Operating expense as reported by the company, may be the same or not the same as Morningstar's standardized definition."""
        ...

    @OperatingExpenseAsReported.setter
    def OperatingExpenseAsReported(self, value: QuantConnect.Data.Fundamental.OperatingExpenseAsReportedIncomeStatement):
        """Operating expense as reported by the company, may be the same or not the same as Morningstar's standardized definition."""
        ...

    @property
    def NormalizedIncomeAsReported(self) -> QuantConnect.Data.Fundamental.NormalizedIncomeAsReportedIncomeStatement:
        """
        Earnings adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This can be used to fairly measure a
        company's profitability. This is as reported by the company, may be the same or not the same as Morningstar's standardized
        definition.
        """
        ...

    @NormalizedIncomeAsReported.setter
    def NormalizedIncomeAsReported(self, value: QuantConnect.Data.Fundamental.NormalizedIncomeAsReportedIncomeStatement):
        """
        Earnings adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This can be used to fairly measure a
        company's profitability. This is as reported by the company, may be the same or not the same as Morningstar's standardized
        definition.
        """
        ...

    @property
    def NormalizedEBITDAAsReported(self) -> QuantConnect.Data.Fundamental.NormalizedEBITDAAsReportedIncomeStatement:
        """
        EBITDA less Total Unusual Items. This is as reported by the company, may be the same or not the same as Morningstar's
        standardized definition.
        """
        ...

    @NormalizedEBITDAAsReported.setter
    def NormalizedEBITDAAsReported(self, value: QuantConnect.Data.Fundamental.NormalizedEBITDAAsReportedIncomeStatement):
        """
        EBITDA less Total Unusual Items. This is as reported by the company, may be the same or not the same as Morningstar's
        standardized definition.
        """
        ...

    @property
    def NormalizedEBITAsReported(self) -> QuantConnect.Data.Fundamental.NormalizedEBITAsReportedIncomeStatement:
        """
        EBIT less Total Unusual Items. This is as reported by the company, may be the same or not the same as Morningstar's standardized
        definition.
        """
        ...

    @NormalizedEBITAsReported.setter
    def NormalizedEBITAsReported(self, value: QuantConnect.Data.Fundamental.NormalizedEBITAsReportedIncomeStatement):
        """
        EBIT less Total Unusual Items. This is as reported by the company, may be the same or not the same as Morningstar's standardized
        definition.
        """
        ...

    @property
    def NormalizedOperatingProfitAsReported(self) -> QuantConnect.Data.Fundamental.NormalizedOperatingProfitAsReportedIncomeStatement:
        """
        Operating profit adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This can be used to fairly
        measure a company's profitability. This is as reported by the company, may be the same or not the same as Morningstar's
        standardized definition.
        """
        ...

    @NormalizedOperatingProfitAsReported.setter
    def NormalizedOperatingProfitAsReported(self, value: QuantConnect.Data.Fundamental.NormalizedOperatingProfitAsReportedIncomeStatement):
        """
        Operating profit adjusted for items that are irregular or unusual in nature, and/or are non-recurring. This can be used to fairly
        measure a company's profitability. This is as reported by the company, may be the same or not the same as Morningstar's
        standardized definition.
        """
        ...

    @property
    def EffectiveTaxRateAsReported(self) -> QuantConnect.Data.Fundamental.EffectiveTaxRateAsReportedIncomeStatement:
        """
        The average tax rate for the period as reported by the company, may be the same or not the same as Morningstar's standardized
        definition.
        """
        ...

    @EffectiveTaxRateAsReported.setter
    def EffectiveTaxRateAsReported(self, value: QuantConnect.Data.Fundamental.EffectiveTaxRateAsReportedIncomeStatement):
        """
        The average tax rate for the period as reported by the company, may be the same or not the same as Morningstar's standardized
        definition.
        """
        ...

    def __init__(self) -> None:
        """Creates an instance of the IncomeStatement class"""
        ...

    def UpdateValues(self, update: QuantConnect.Data.Fundamental.IncomeStatement) -> None:
        """
        Applies updated values from  to this instance
        
        :param update: The next data update for this instance
        """
        ...


class AccountsPayableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Any money that a company owes its suppliers for goods and services purchased on credit and is expected to pay within the next
    year or operating cycle.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AccountsPayableBalanceSheet class"""
        ...


class AccountsReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Accounts owed to a company by customers within a year as a result of exchanging goods or services on credit."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AccountsReceivableBalanceSheet class"""
        ...


class CurrentAccruedExpensesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    An expense recognized before it is paid for. Includes compensation, interest, pensions and all other miscellaneous accruals
    reported by the company. Expenses incurred during the accounting period, but not required to be paid until a later date.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CurrentAccruedExpensesBalanceSheet class"""
        ...


class NonCurrentAccruedExpensesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    An expense that has occurred but the transaction has not been entered in the accounting records. Accordingly, an adjusting entry
    is made to debit the appropriate expense account and to credit a liability account such as accrued expenses payable or accounts
    payable.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NonCurrentAccruedExpensesBalanceSheet class"""
        ...


class AccruedInvestmentIncomeBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Interest, dividends, rents, ancillary and other revenues earned but not yet received by the entity on its investments."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AccruedInvestmentIncomeBalanceSheet class"""
        ...


class AccumulatedDepreciationBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The cumulative amount of wear and tear or obsolescence charged against the fixed assets of a company."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AccumulatedDepreciationBalanceSheet class"""
        ...


class GainsLossesNotAffectingRetainedEarningsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of gains or losses that are not part of retained earnings. It is also called other comprehensive income."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GainsLossesNotAffectingRetainedEarningsBalanceSheet class"""
        ...


class AdditionalPaidInCapitalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Excess of issue price over par or stated value of the entity's capital stock and amounts received from other transactions involving
    the entity's stock or stockholders. Includes adjustments to additional paid in capital. There are two major categories of additional
    paid in capital: 1) Paid in capital in excess of par/stated value, which is the difference between the actual issue price of the shares
    and the shares' par/stated value. 2) Paid in capital from other transactions which includes treasury stock, retirement of stock, stock
    dividends recorded at market, lapse of stock purchase warrants, conversion of convertible bonds in excess of the par value of the
    stock, and any other additional capital from the company's own stock transactions.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AdditionalPaidInCapitalBalanceSheet class"""
        ...


class AllowanceForLoansAndLeaseLossesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A contra account sets aside as an allowance for bad loans (e.g. customer defaults)."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AllowanceForLoansAndLeaseLossesBalanceSheet class"""
        ...


class AvailableForSaleSecuritiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    For an unclassified balance sheet, this item represents equity securities categorized neither as held-to-maturity nor trading. Equity
    securities represent ownership interests or the right to acquire ownership interests in corporations and other legal entities which
    ownership interest is represented by shares of common or preferred stock (which is not mandatory redeemable or redeemable at
    the option of the holder), convertible securities, stock rights, or stock warrants. This category includes preferred stocks, available-
    for-sale and common stock, available-for-sale.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AvailableForSaleSecuritiesBalanceSheet class"""
        ...


class CapitalStockBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The total amount of stock authorized for issue by a corporation, including common and preferred stock."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CapitalStockBalanceSheet class"""
        ...


class CashBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Cash includes currency on hand as well as demand deposits with banks or financial institutions. It also includes other kinds of
    accounts that have the general characteristics of demand deposits in that the customer may deposit additional funds at any time
    and also effectively may withdraw funds at any time without prior notice or penalty.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CashBalanceSheet class"""
        ...


class CashEquivalentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Cash equivalents, excluding items classified as marketable securities, include short-term, highly liquid investments that are both
    readily convertible to known amounts of cash, and so near their maturity that they present insignificant risk of changes in value
    because of changes in interest rates.  Generally, only investments with original maturities of three months or less qualify under this
    definition. Original maturity means original maturity to the entity holding the investment. For example, both a three-month US
    Treasury bill and a three-year Treasury note purchased three months from maturity qualify as cash equivalents. However, a Treasury
    note purchased three years ago does not become a cash equivalent when its remaining maturity is three months.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CashEquivalentsBalanceSheet class"""
        ...


class CashAndCashEquivalentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Includes unrestricted cash on hand, money market instruments and other debt securities which can be converted to cash
    immediately.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CashAndCashEquivalentsBalanceSheet class"""
        ...


class CashAndDueFromBanksBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Includes cash on hand (currency and coin), cash items in process of collection, non-interest bearing deposits due from other
    financial institutions (including corporate credit unions), and balances with the Federal Reserve Banks, Federal Home Loan Banks
    and central banks.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CashAndDueFromBanksBalanceSheet class"""
        ...


class CashCashEquivalentsAndFederalFundsSoldBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of cash, cash equivalents, and federal funds sold."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CashCashEquivalentsAndFederalFundsSoldBalanceSheet class"""
        ...


class CashCashEquivalentsAndMarketableSecuritiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of cash, cash equivalents, and marketable securities."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CashCashEquivalentsAndMarketableSecuritiesBalanceSheet class"""
        ...


class CommonStockBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Common stock (all issues) at par value, as reported within the Stockholder's Equity section of the balance sheet; i.e. it is one
    component of Common Stockholder's Equity
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CommonStockBalanceSheet class"""
        ...


class CurrentAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The total amount of assets considered to be convertible into cash within a relatively short period of time, usually a year."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CurrentAssetsBalanceSheet class"""
        ...


class CurrentDebtBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Represents the total amount of long-term debt such as bank loans and commercial paper, which is due within one year."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CurrentDebtBalanceSheet class"""
        ...


class CurrentDebtAndCapitalLeaseObligationBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    All borrowings due within one year including current portions of long-term debt and capital leases as well as short-term debt such
    as bank loans and commercial paper.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CurrentDebtAndCapitalLeaseObligationBalanceSheet class"""
        ...


class CurrentLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The debts or obligations of the firm that are due within one year."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CurrentLiabilitiesBalanceSheet class"""
        ...


class CurrentCapitalLeaseObligationBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Represents the total amount of long-term capital leases that must be paid within the next accounting PeriodAsByte. Capital lease
    obligations are contractual obligations that arise from obtaining the use of property or equipment via a capital lease contract.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CurrentCapitalLeaseObligationBalanceSheet class"""
        ...


class DeferredAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """An amount owed to a firm that is not expected to be received by the firm within one year from the date of the balance sheet."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DeferredAssetsBalanceSheet class"""
        ...


class DeferredCostsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    An expenditure not recognized as a cost of operation of the period in which incurred, but carried forward to be written off in future
    periods.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DeferredCostsBalanceSheet class"""
        ...


class NonCurrentDeferredLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Represents the non-current portion of obligations, which is a liability that usually would have been paid but is now past due."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NonCurrentDeferredLiabilitiesBalanceSheet class"""
        ...


class CurrentDeferredLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Represents the current portion of obligations, which is a liability that usually would have been paid but is now past due."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CurrentDeferredLiabilitiesBalanceSheet class"""
        ...


class DeferredPolicyAcquisitionCostsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Net amount of deferred policy acquisition costs capitalized on contracts remaining in force as of the balance sheet date."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DeferredPolicyAcquisitionCostsBalanceSheet class"""
        ...


class CurrentDeferredRevenueBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Represents collections of cash or other assets related to revenue producing activity for which revenue has not yet been recognized.
    Generally, an entity records deferred revenue when it receives consideration from a customer before achieving certain criteria that
    must be met for revenue to be recognized in conformity with GAAP. It can be either current or non-current item. Also called
    unearned revenue.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CurrentDeferredRevenueBalanceSheet class"""
        ...


class NonCurrentDeferredRevenueBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The non-current portion of deferred revenue amount as of the balance sheet date. Deferred revenue is a liability related to revenue
    producing activity for which revenue has not yet been recognized, and is not expected be recognized in the next twelve months.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NonCurrentDeferredRevenueBalanceSheet class"""
        ...


class DeferredTaxAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    An asset on a company's balance sheet that may be used to reduce any subsequent period's income tax expense. Deferred tax
    assets can arise due to net loss carryovers, which are only recorded as assets if it is deemed more likely than not that the asset
    will be used in future fiscal periods.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DeferredTaxAssetsBalanceSheet class"""
        ...


class CurrentDeferredTaxesAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Meaning a future tax asset, resulting from temporary differences between book (accounting) value of assets and liabilities and their
    tax value, or timing differences between the recognition of gains and losses in financial statements and their recognition in a tax
    computation. It is also called future tax.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CurrentDeferredTaxesAssetsBalanceSheet class"""
        ...


class CurrentDeferredTaxesLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Meaning a future tax liability, resulting from temporary differences between book (accounting) value of assets and liabilities and
    their tax value, or timing differences between the recognition of gains and losses in financial statements and their recognition in a
    tax computation. Deferred tax liabilities generally arise where tax relief is provided in advance of an accounting expense, or income
    is accrued but not taxed until received.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CurrentDeferredTaxesLiabilitiesBalanceSheet class"""
        ...


class NonCurrentDeferredTaxesAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    A result of timing differences between taxable incomes reported on the income statement and taxable income from the company's
    tax return. Depending on the positioning of deferred income taxes, the field may be either current (within current assets) or non-
    current (below total current assets). Typically a company will have two deferred income taxes fields.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NonCurrentDeferredTaxesAssetsBalanceSheet class"""
        ...


class NonCurrentDeferredTaxesLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The estimated future tax obligations, which usually arise when different accounting methods are used for financial statements and
    tax statement It is also an add-back to the cash flow statement. Deferred income taxes include accumulated tax deferrals due to
    accelerated depreciation and investment credit.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NonCurrentDeferredTaxesLiabilitiesBalanceSheet class"""
        ...


class EquityInvestmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This asset represents equity securities categorized neither as held-to-maturity nor trading."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the EquityInvestmentsBalanceSheet class"""
        ...


class FederalFundsPurchasedAndSecuritiesSoldUnderAgreementToRepurchaseBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    This liability refers to the amount shown on the books that a bank with insufficient reserves borrows, at the federal funds rate, from
    another bank to meet its reserve requirements; and the amount of securities that an institution sells and agrees to repurchase at a
    specified date for a specified price, net of any reductions or offsets.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FederalFundsPurchasedAndSecuritiesSoldUnderAgreementToRepurchaseBalanceSheet class"""
        ...


class FederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This asset refers to very-short-term loans of funds to other banks and securities dealers."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FederalFundsSoldAndSecuritiesPurchaseUnderAgreementsToResellBalanceSheet class"""
        ...


class FixedMaturityInvestmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    This asset refers to types of investments that may be contained within the fixed maturity category which securities are having a
    stated final repayment date. Examples of items within this category may include bonds, including convertibles and bonds with
    warrants, and redeemable preferred stocks.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FixedMaturityInvestmentsBalanceSheet class"""
        ...


class FuturePolicyBenefitsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Accounting policy pertaining to an insurance entity's net liability for future benefits (for example, death, cash surrender value) to be
    paid to or on behalf of policyholders, describing the bases, methodologies and components of the reserve, and assumptions
    regarding estimates of expected investment yields, mortality, morbidity, terminations and expenses.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FuturePolicyBenefitsBalanceSheet class"""
        ...


class GeneralPartnershipCapitalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    In a limited partnership or master limited partnership form of business, this represents the balance of capital held by the general
    partners.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GeneralPartnershipCapitalBalanceSheet class"""
        ...


class GoodwillBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The excess of the cost of an acquired company over the sum of the fair market value of its identifiable individual assets less the
    liabilities.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GoodwillBalanceSheet class"""
        ...


class GoodwillAndOtherIntangibleAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Rights or economic benefits, such as patents and goodwill, that is not physical in nature. They are those that are neither physical
    nor financial in nature, nevertheless, have value to the company. Intangibles are listed net of accumulated amortization.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GoodwillAndOtherIntangibleAssetsBalanceSheet class"""
        ...


class GrossLoanBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Represents the sum of all loans (commercial, consumer, mortgage, etc.) as well as leases before any provisions for loan losses or
    unearned discounts.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GrossLoanBalanceSheet class"""
        ...


class GrossPPEBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Carrying amount at the balance sheet date for long-lived physical assets used in the normal conduct of business and not intended
    for resale. This can include land, physical structures, machinery, vehicles, furniture, computer equipment, construction in progress,
    and similar items. Amount does not include depreciation.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GrossPPEBalanceSheet class"""
        ...


class HeldToMaturitySecuritiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Debt securities that a firm has the ability and intent to hold until maturity."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the HeldToMaturitySecuritiesBalanceSheet class"""
        ...


class IncomeTaxPayableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A current liability account which reflects the amount of income taxes currently due to the federal, state, and local governments."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the IncomeTaxPayableBalanceSheet class"""
        ...


class InterestBearingDepositsLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate of all domestic and foreign deposits in the bank that earns interests."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InterestBearingDepositsLiabilitiesBalanceSheet class"""
        ...


class InterestPayableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Sum of the carrying values as of the balance sheet date of interest payable on all forms of debt, including trade payable that has
    been incurred.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InterestPayableBalanceSheet class"""
        ...


class InterestBearingDepositsAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Deposit of money with a financial institution, in consideration of which the financial institution pays or credits interest, or amounts in the nature
    of interest.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InterestBearingDepositsAssetsBalanceSheet class"""
        ...


class InventoryBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A company's merchandise, raw materials, and finished and unfinished products which have not yet been sold."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InventoryBalanceSheet class"""
        ...


class InvestmentsAndAdvancesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All investments in affiliates, real estate, securities, etc. Non-current investment, not including marketable securities."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InvestmentsAndAdvancesBalanceSheet class"""
        ...


class LimitedPartnershipCapitalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    In a limited partnership or master limited partnership form of business, this represents the balance of capital held by the limited
    partners.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the LimitedPartnershipCapitalBalanceSheet class"""
        ...


class LongTermDebtBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Sum of the carrying values as of the balance sheet date of all long-term debt, which is debt initially having maturities due after one
    year or beyond the operating cycle, if longer, but excluding the portions thereof scheduled to be repaid within one year or the
    normal operating cycle, if longer. Long-term debt includes notes payable, bonds payable, mortgage loans, convertible debt,
    subordinated debt and other types of long term debt.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the LongTermDebtBalanceSheet class"""
        ...


class LongTermDebtAndCapitalLeaseObligationBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All borrowings lasting over one year including long-term debt and long-term portion of capital lease obligations."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the LongTermDebtAndCapitalLeaseObligationBalanceSheet class"""
        ...


class LongTermInvestmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Often referred to simply as "investments". Long-term investments are to be held for many years and are not intended to be
    disposed in the near future. This group usually consists of four types of investments.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the LongTermInvestmentsBalanceSheet class"""
        ...


class LongTermCapitalLeaseObligationBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Represents the total liability for long-term leases lasting over one year. Amount equal to the present value (the principal) at the
    beginning of the lease term less lease payments during the lease term.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the LongTermCapitalLeaseObligationBalanceSheet class"""
        ...


class MinorityInterestBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Carrying amount of the equity interests owned by non-controlling shareholders, partners, or other equity holders in one or more of
    the entities included in the reporting entity's consolidated financial statements.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the MinorityInterestBalanceSheet class"""
        ...


class MoneyMarketInvestmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Short-term (typical maturity is less than one year), highly liquid government or corporate debt instrument such as bankers'
    acceptance, promissory notes, and treasury bills.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the MoneyMarketInvestmentsBalanceSheet class"""
        ...


class NetLoanBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Represents the value of all loans after deduction of the appropriate allowances for loan and lease losses."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetLoanBalanceSheet class"""
        ...


class NetPPEBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Tangible assets that are held by an entity for use in the production or supply of goods and services, for rental to others, or for
    administrative purposes and that are expected to provide economic benefit for more than one year; net of accumulated
    depreciation.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetPPEBalanceSheet class"""
        ...


class NonInterestBearingDepositsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of all domestic and foreign deposits in the banks that do not draw interest."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NonInterestBearingDepositsBalanceSheet class"""
        ...


class CurrentNotesPayableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Written promises to pay a stated sum at one or more specified dates in the future, within the accounting PeriodAsByte."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CurrentNotesPayableBalanceSheet class"""
        ...


class NotesReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    An amount representing an agreement for an unconditional promise by the maker to pay the entity (holder) a definite sum of money
    at a future date(s) within one year of the balance sheet date or the normal operating cycle, whichever is longer. Such amount may
    include accrued interest receivable in accordance with the terms of the note. The note also may contain provisions including a
    discount or premium, payable on demand, secured, or unsecured, interest bearing or non-interest bearing, among a myriad of other
    features and characteristics.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NotesReceivableBalanceSheet class"""
        ...


class NonCurrentNoteReceivablesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    An amount representing an agreement for an unconditional promise by the maker to pay the entity (holder) a definite sum of money
    at a future date(s), excluding the portion that is expected to be received within one year of the balance sheet date or the normal
    operating cycle, whichever is longer.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NonCurrentNoteReceivablesBalanceSheet class"""
        ...


class OtherCurrentLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Other current liabilities = Total current liabilities - Payables and accrued Expenses - Current debt and capital lease obligation -
    provisions, current - deferred liabilities, current.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherCurrentLiabilitiesBalanceSheet class"""
        ...


class OtherIntangibleAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Sum of the carrying amounts of all intangible assets, excluding goodwill."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherIntangibleAssetsBalanceSheet class"""
        ...


class OtherShortTermInvestmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The aggregate amount of short term investments, which will be expired within one year that are not specifically classified as
    Available-for-Sale, Held-to-Maturity,  nor Trading investments.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherShortTermInvestmentsBalanceSheet class"""
        ...


class PayablesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The sum of all payables owed and expected to be paid within one year or one operating cycle, including accounts payables, taxes
    payable, dividends payable and all other current payables.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PayablesBalanceSheet class"""
        ...


class PayablesAndAccruedExpensesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This balance sheet account includes all current payables and accrued expenses."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PayablesAndAccruedExpensesBalanceSheet class"""
        ...


class PolicyReservesBenefitsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Accounting policy pertaining to an insurance entity's net liability for future benefits (for example, death, cash surrender value) to be
    paid to or on behalf of policyholders, describing the bases, methodologies and components of the reserve, and assumptions
    regarding estimates of expected investment yields, mortality, morbidity, terminations and expenses.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PolicyReservesBenefitsBalanceSheet class"""
        ...


class PolicyholderFundsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The total liability as of the balance sheet date of amounts due to policy holders, excluding future policy benefits and claims,
    including unpaid policy dividends, retrospective refunds, and undistributed earnings on participating business.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PolicyholderFundsBalanceSheet class"""
        ...


class PreferredSecuritiesOutsideStockEquityBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Preferred securities that that firm treats as a liability. It includes convertible preferred stock or redeemable preferred stock."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PreferredSecuritiesOutsideStockEquityBalanceSheet class"""
        ...


class PreferredStockBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Preferred stock (all issues) at par value, as reported within the Stockholder's Equity section of the balance sheet."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PreferredStockBalanceSheet class"""
        ...


class PrepaidAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Sum of the carrying amounts that are paid in advance for expenses, which will be charged against earnings in subsequent periods."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PrepaidAssetsBalanceSheet class"""
        ...


class NonCurrentPrepaidAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Sum of the carrying amounts that are paid in advance for expenses, which will be charged against earnings in periods after one
    year or beyond the operating cycle, if longer.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NonCurrentPrepaidAssetsBalanceSheet class"""
        ...


class ReceivablesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The sum of all receivables owed by customers and affiliates within one year, including accounts receivable, notes receivable,
    premiums receivable, and other current receivables.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ReceivablesBalanceSheet class"""
        ...


class ReinsuranceRecoverableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The amount of benefits the ceding insurer expects to recover on insurance policies ceded to other insurance entities as of the
    balance sheet date for all guaranteed benefit types. It includes estimated amounts for claims incurred but not reported, and policy
    benefits, net of any related valuation allowance.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ReinsuranceRecoverableBalanceSheet class"""
        ...


class RetainedEarningsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The cumulative net income of the company from the date of its inception (or reorganization) to the date of the financial statement
    less the cumulative distributions to shareholders either directly (dividends) or indirectly (treasury stock).
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the RetainedEarningsBalanceSheet class"""
        ...


class SecuritiesLendingCollateralBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The carrying value as of the balance sheet date of the liabilities collateral securities loaned to other broker-dealers. Borrowers of
    securities generally are required to provide collateral to the lenders of securities, commonly cash but sometimes other securities or
    standby letters of credit, with a value slightly higher than that of the securities borrowed.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the SecuritiesLendingCollateralBalanceSheet class"""
        ...


class SecurityAgreeToBeResellBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The carrying value of funds outstanding loaned in the form of security resale agreements if the agreement requires the purchaser to
    resell the identical security purchased or a security that meets the definition of "substantially the same" in the case of a dollar roll.
    Also includes purchases of participations in pools of securities that are subject to a resale agreement.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the SecurityAgreeToBeResellBalanceSheet class"""
        ...


class SecuritySoldNotYetRepurchasedBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Represent obligations of the company to deliver the specified security at the contracted price and, thereby, create a liability to
    purchase the security in the market at prevailing prices.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the SecuritySoldNotYetRepurchasedBalanceSheet class"""
        ...


class SeparateAccountAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The fair value of the assets held by the company for the benefit of separate account policyholders."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the SeparateAccountAssetsBalanceSheet class"""
        ...


class SeparateAccountBusinessBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Refers to revenue that is generated that is not part of typical operations."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the SeparateAccountBusinessBalanceSheet class"""
        ...


class ShortTermInvestmentsAvailableForSaleBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The current assets section of a company's balance sheet that contains the investments that a company holds with the purpose for
    trading.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ShortTermInvestmentsAvailableForSaleBalanceSheet class"""
        ...


class ShortTermInvestmentsHeldToMaturityBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The current assets section of a company's balance sheet that contains the investments that a company has made that will expire
    at a fixed date within one year.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ShortTermInvestmentsHeldToMaturityBalanceSheet class"""
        ...


class ShortTermInvestmentsTradingBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The current assets section of a company's balance sheet that contains the investments that a company can trade at any moment."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ShortTermInvestmentsTradingBalanceSheet class"""
        ...


class StockholdersEquityBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The residual interest in the assets of the enterprise that remains after deducting its liabilities. Equity is increased by owners'
    investments and by comprehensive income, and it is reduced by distributions to the owners.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the StockholdersEquityBalanceSheet class"""
        ...


class TotalTaxPayableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    A liability that reflects the taxes owed to federal, state, and local tax authorities. It is the carrying value as of the balance sheet
    date of obligations incurred and payable for statutory income, sales, use, payroll, excise, real, property and other taxes.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalTaxPayableBalanceSheet class"""
        ...


class TotalAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The aggregate amount of probable future economic benefits obtained or controlled by a particular enterprise as a result of past
    transactions or events.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalAssetsBalanceSheet class"""
        ...


class TotalDepositsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A liability account which represents the total amount of funds deposited."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalDepositsBalanceSheet class"""
        ...


class TotalInvestmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Asset that refers to the sum of all available for sale securities and other investments often reported on the balance sheet of
    insurance firms.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalInvestmentsBalanceSheet class"""
        ...


class TotalNonCurrentAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Sum of the carrying amounts as of the balance sheet date of all assets that are expected to be realized in cash, sold or consumed
    after one year or beyond the normal operating cycle, if longer.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalNonCurrentAssetsBalanceSheet class"""
        ...


class TotalPartnershipCapitalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Ownership interest of different classes of partners in the publicly listed limited partnership or master limited partnership. Partners
    include general, limited and preferred partners.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalPartnershipCapitalBalanceSheet class"""
        ...


class TradingAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Trading account assets are bought and held principally for the purpose of selling them in the near term (thus held for only a short
    period of time). Unrealized holding gains and losses for trading securities are included in earnings.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TradingAssetsBalanceSheet class"""
        ...


class TradingLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The carrying amount of liabilities as of the balance sheet date that pertain to principal and customer trading transactions, or which
    may be incurred with the objective of generating a profit from short-term fluctuations in price as part of an entity's market-making,
    hedging and proprietary trading. Examples include short positions in securities, derivatives and commodities, obligations under
    repurchase agreements, and securities borrowed arrangements.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TradingLiabilitiesBalanceSheet class"""
        ...


class TradingSecuritiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The total of financial instruments that are bought and held principally for the purpose of selling them in the near term (thus held for
    only a short period of time) or for debt and equity securities formerly categorized as available-for-sale or held-to-maturity which the
    company held as of the date it opted to account for such securities at fair value.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TradingSecuritiesBalanceSheet class"""
        ...


class TreasuryStockBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The portion of shares that a company keeps in their own treasury. Treasury stock may have come from a repurchase or buyback
    from shareholders; or it may have never been issued to the public in the first place. These shares don't pay dividends, have no
    voting rights, and are not included in shares outstanding calculations.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TreasuryStockBalanceSheet class"""
        ...


class UnearnedIncomeBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Income received but not yet earned, it represents the unearned amount that is netted against the total loan."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the UnearnedIncomeBalanceSheet class"""
        ...


class UnearnedPremiumsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Carrying amount of premiums written on insurance contracts that have not been earned as of the balance sheet date."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the UnearnedPremiumsBalanceSheet class"""
        ...


class UnpaidLossAndLossReserveBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Liability amount that reflects claims that are expected based upon statistical projections, but which have not been reported to the
    insurer.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the UnpaidLossAndLossReserveBalanceSheet class"""
        ...


class InvestedCapitalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Invested capital = common shareholders' equity + long term debt + current debt"""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InvestedCapitalBalanceSheet class"""
        ...


class CurrentDeferredAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Payments that will be assigned as expenses with one accounting period, but that are paid in advance and temporarily set up as
    current assets on the balance sheet.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CurrentDeferredAssetsBalanceSheet class"""
        ...


class NonCurrentDeferredAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Payments that will be assigned as expenses longer than one accounting period, but that are paid in advance and temporarily set up
    as non-current assets on the balance sheet.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NonCurrentDeferredAssetsBalanceSheet class"""
        ...


class SecuritiesAndInvestmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Asset, often applicable to Banks, which refers to the aggregate amount of all securities and investments."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the SecuritiesAndInvestmentsBalanceSheet class"""
        ...


class TotalLiabilitiesNetMinorityInterestBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Probable future sacrifices of economic benefits arising from present obligations of an enterprise to transfer assets or provide
    services to others in the future as a result of past transactions or events, excluding minority interest.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalLiabilitiesNetMinorityInterestBalanceSheet class"""
        ...


class TotalNonCurrentLiabilitiesNetMinorityInterestBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Total obligations, net minority interest, incurred as part of normal operations that is expected to be repaid beyond the following
    twelve months or one business cycle; excludes minority interest.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalNonCurrentLiabilitiesNetMinorityInterestBalanceSheet class"""
        ...


class TotalEquityGrossMinorityInterestBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Residual interest, including minority interest, that remains in the assets of the enterprise after deducting its liabilities. Equity is
    increased by owners' investments and by comprehensive income, and it is reduced by distributions to the owners.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalEquityGrossMinorityInterestBalanceSheet class"""
        ...


class GrossAccountsReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Accounts owed to a company by customers within a year as a result of exchanging goods or services on credit."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GrossAccountsReceivableBalanceSheet class"""
        ...


class NonCurrentAccountsReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Accounts receivable represents sums owed to the business that the business records as revenue. Gross accounts receivable is
    accounts receivable before the business deducts uncollectable accounts to calculate the true value of accounts receivable.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NonCurrentAccountsReceivableBalanceSheet class"""
        ...


class AccruedInterestReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    This account shows the amount of unpaid interest accrued to the date of purchase and included in the purchase price of securities
    purchased between interest dates.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AccruedInterestReceivableBalanceSheet class"""
        ...


class AdvanceFromFederalHomeLoanBanksBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    This item is typically available for bank industry. It's the amount of borrowings as of the balance sheet date from the Federal Home
    Loan Bank, which are primarily used to cover shortages in the required reserve balance and liquidity shortages.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AdvanceFromFederalHomeLoanBanksBalanceSheet class"""
        ...


class AllowanceForDoubtfulAccountsReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """An Allowance for Doubtful Accounts measures receivables recorded but not expected to be collected."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AllowanceForDoubtfulAccountsReceivableBalanceSheet class"""
        ...


class AllowanceForNotesReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    This item is typically available for bank industry. It represents a provision relating to a written agreement to receive money  with the
    terms of the note (at a specified future date(s) within one year from the reporting date (or the normal operating cycle, whichever is
    longer), consisting of principal as well as any accrued interest) for the portion that is expected to be uncollectible.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AllowanceForNotesReceivableBalanceSheet class"""
        ...


class AssetsHeldForSaleBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This item is typically available for bank industry. It's a part of long-lived assets, which has been decided for sale in the future."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AssetsHeldForSaleBalanceSheet class"""
        ...


class AssetsOfDiscontinuedOperationsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A portion of a company's business that has been disposed of or sold."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AssetsOfDiscontinuedOperationsBalanceSheet class"""
        ...


class BankIndebtednessBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    All indebtedness for borrowed money or the deferred purchase price of property or services, including without limitation
    reimbursement and other obligations with respect to surety bonds and letters of credit, all obligations evidenced by notes, bonds
    debentures or similar instruments, all capital lease obligations and all contingent obligations.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the BankIndebtednessBalanceSheet class"""
        ...


class BankOwnedLifeInsuranceBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The carrying amount of a life insurance policy on an officer, executive or employee for which the reporting entity (a bank) is entitled
    to proceeds from the policy upon death of the insured or surrender of the insurance policy.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the BankOwnedLifeInsuranceBalanceSheet class"""
        ...


class SecurityBorrowedBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The securities borrowed or on loan, which is the temporary loan of securities by a lender to a borrower in exchange for cash.  This
    item is usually only available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the SecurityBorrowedBalanceSheet class"""
        ...


class BuildingsAndImprovementsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Fixed assets that specifically deal with the facilities a company owns. Include the improvements associated with buildings."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the BuildingsAndImprovementsBalanceSheet class"""
        ...


class CommercialLoanBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Short-term loan, typically 90 days, used by a company to finance seasonal working capital needs."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CommercialLoanBalanceSheet class"""
        ...


class CommercialPaperBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Commercial paper is a money-market security issued by large banks and corporations. It represents the current obligation for the
    company. There are four basic kinds of commercial paper: promissory notes, drafts, checks, and certificates of deposit. The
    maturities of these money market securities generally do not exceed 270 days.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CommercialPaperBalanceSheet class"""
        ...


class CommonStockEquityBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The portion of the Stockholders' Equity that reflects the amount of common stock, which are units of ownership."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CommonStockEquityBalanceSheet class"""
        ...


class ConstructionInProgressBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    It represents carrying amount of long-lived asset under construction that includes construction costs to date on capital projects.
    Assets constructed, but not completed.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ConstructionInProgressBalanceSheet class"""
        ...


class ConsumerLoanBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    A loan that establishes consumer credit that is granted for personal use; usually unsecured and based on the borrower's integrity
    and ability to pay.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ConsumerLoanBalanceSheet class"""
        ...


class MinimumPensionLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The company's minimum pension obligations to its former employees, paid into a defined pension plan to satisfy all pension
    entitlements that have been earned by employees to date.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the MinimumPensionLiabilitiesBalanceSheet class"""
        ...


class CustomerAcceptancesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Amounts receivable from customers on short-term negotiable time drafts drawn on and accepted by the institution (also known as
    banker's acceptance transactions) that are outstanding on the reporting date.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CustomerAcceptancesBalanceSheet class"""
        ...


class DefinedPensionBenefitBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The recognition of an asset where pension fund assets exceed promised benefits."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DefinedPensionBenefitBalanceSheet class"""
        ...


class DerivativeProductLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Fair values of all liabilities resulting from contracts that meet the criteria of being accounted for as derivative instruments; and
    which are expected to be extinguished or otherwise disposed of after one year or beyond the normal operating cycle.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DerivativeProductLiabilitiesBalanceSheet class"""
        ...


class DerivativeAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Fair values of assets resulting from contracts that meet the criteria of being accounted for as derivative instruments, net of the
    effects of master netting arrangements.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DerivativeAssetsBalanceSheet class"""
        ...


class DividendsPayableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Sum of the carrying values of dividends declared but unpaid on equity securities issued and outstanding (also includes dividends
    collected on behalf of another owner of securities that are being held by entity) by the entity.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DividendsPayableBalanceSheet class"""
        ...


class EmployeeBenefitsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Carrying amount as of the balance sheet date of the portion of the obligations recognized for the various benefits provided to former
    or inactive employees, their beneficiaries, and covered dependents after employment but before retirement.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the EmployeeBenefitsBalanceSheet class"""
        ...


class FederalFundsPurchasedBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The amount borrowed by a bank, at the federal funds rate, from another bank to meet its reserve requirements.  This item is
    typically available for the bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FederalFundsPurchasedBalanceSheet class"""
        ...


class FederalFundsSoldBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Federal funds transactions involve lending (federal funds sold) or borrowing (federal funds purchased) of immediately available
    reserve balances.  This item is typically available for the bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FederalFundsSoldBalanceSheet class"""
        ...


class FederalHomeLoanBankStockBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Federal Home Loan Bank stock represents an equity interest in a FHLB. It does not have a readily determinable fair value because
    its ownership is restricted and it lacks a market (liquidity).  This item is typically available for the bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FederalHomeLoanBankStockBalanceSheet class"""
        ...


class FinancialAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Fair values as of the balance sheet date of all assets resulting from contracts that meet the criteria of being accounted for as
    derivative instruments, net of the effects of master netting arrangements.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FinancialAssetsBalanceSheet class"""
        ...


class FinancialInstrumentsSoldUnderAgreementsToRepurchaseBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The carrying value as of the balance sheet date of securities that an institution sells and agrees to repurchase (the identical or
    substantially the same securities) as a seller-borrower at a specified date for a specified price, also known as a repurchase
    agreement.  This item is typically available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FinancialInstrumentsSoldUnderAgreementsToRepurchaseBalanceSheet class"""
        ...


class FinishedGoodsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The carrying amount as of the balance sheet date of merchandise or goods held by the company that are readily available for sale.
    This item is typically available for mining and manufacturing industries.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FinishedGoodsBalanceSheet class"""
        ...


class FlightFleetVehicleAndRelatedEquipmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    It is one of the important fixed assets for transportation industry, which includes bicycles, cars, motorcycles, trains, ships, boats,
    and aircraft.  This item is typically available for transportation industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FlightFleetVehicleAndRelatedEquipmentsBalanceSheet class"""
        ...


class ForeclosedAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The carrying amount as of the balance sheet date of all assets obtained in full or partial satisfaction of a debt arrangement through
    foreclosure proceedings or defeasance; includes real and personal property; equity interests in corporations, partnerships, and joint
    ventures; and beneficial interest in trusts.  This item is typically typically available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ForeclosedAssetsBalanceSheet class"""
        ...


class ForeignCurrencyTranslationAdjustmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Changes to accumulated comprehensive income that results from the process of translating subsidiary financial statements and
    foreign equity investments into functional currency of the reporting company.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ForeignCurrencyTranslationAdjustmentsBalanceSheet class"""
        ...


class InventoriesAdjustmentsAllowancesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    This item represents certain charges made in the current period in inventory resulting from such factors as breakage, spoilage,
    employee theft and shoplifting. This item is typically available for manufacturing, mining and utility industries.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InventoriesAdjustmentsAllowancesBalanceSheet class"""
        ...


class InvestmentsInOtherVenturesUnderEquityMethodBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    This item represents the carrying amount on the company's balance sheet of its investments in common stock of an equity method.
    This item is typically available for the insurance industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InvestmentsInOtherVenturesUnderEquityMethodBalanceSheet class"""
        ...


class LandAndImprovementsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Fixed Assets that specifically deal with land a company owns. Includes the improvements associated with land. This excludes land
    held for sale.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the LandAndImprovementsBalanceSheet class"""
        ...


class LeasesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Carrying amount at the balance sheet date of a long-lived, depreciable asset that is an addition or improvement to assets held
    under lease arrangement. This item is usually not available for the insurance industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the LeasesBalanceSheet class"""
        ...


class LiabilitiesOfDiscontinuedOperationsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The obligations arising from the sale, disposal, or planned sale in the near future (generally within one year) of a disposal group,
    including a component of the entity (discontinued operation). This item is typically available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the LiabilitiesOfDiscontinuedOperationsBalanceSheet class"""
        ...


class LineOfCreditBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The carrying value as of the balance sheet date of obligations drawn from a line of credit, which is a bank's commitment to make
    loans up to a specific amount.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the LineOfCreditBalanceSheet class"""
        ...


class LoansHeldForSaleBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    It means the aggregate amount of loans receivable that will be sold to other entities.  This item is typically available for bank
    industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the LoansHeldForSaleBalanceSheet class"""
        ...


class LoansReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Reflects the carrying amount of unpaid loans issued to other institutions for cash needs or an asset purchase."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the LoansReceivableBalanceSheet class"""
        ...


class MachineryFurnitureEquipmentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Fixed assets specifically dealing with tools, equipment and office furniture. This item is usually not available for the insurance and
    utility industries.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the MachineryFurnitureEquipmentBalanceSheet class"""
        ...


class MaterialsAndSuppliesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Aggregated amount of unprocessed materials to be used in manufacturing or production process and supplies that will be
    consumed. This item is typically available for the utility industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the MaterialsAndSuppliesBalanceSheet class"""
        ...


class MineralPropertiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A fixed asset that represents strictly mineral type properties.  This item is typically available for mining industry."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the MineralPropertiesBalanceSheet class"""
        ...


class MortgageLoanBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This is a lien on real estate to protect a lender.  This item is typically available for bank industry."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the MortgageLoanBalanceSheet class"""
        ...


class MortgageAndConsumerloansBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """It means the aggregate amount of mortgage and consumer loans.  This item is typically available for the insurance industry."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the MortgageAndConsumerloansBalanceSheet class"""
        ...


class GrossNotesReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    An amount representing an agreement for an unconditional promise by the maker to pay the entity (holder) a definite sum of money
    at a future date(s) within one year of the balance sheet date or the normal operating cycle. Such amount may include accrued
    interest receivable in accordance with the terms of the note. The note also may contain provisions including a discount or premium,
    payable on demand, secured, or unsecured, interest bearing or non-interest bearing, among myriad other features and
    characteristics. This item is typically available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the GrossNotesReceivableBalanceSheet class"""
        ...


class OtherAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other non-current assets that are not otherwise classified."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherAssetsBalanceSheet class"""
        ...


class OtherCapitalStockBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other Capital Stock that is not otherwise classified."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherCapitalStockBalanceSheet class"""
        ...


class OtherCurrentAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other current assets that are not otherwise classified."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherCurrentAssetsBalanceSheet class"""
        ...


class OtherCurrentBorrowingsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Short Term Borrowings that are not otherwise classified."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherCurrentBorrowingsBalanceSheet class"""
        ...


class OtherEquityAdjustmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other adjustments to stockholders' equity that is not otherwise classified, including other reserves."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherEquityAdjustmentsBalanceSheet class"""
        ...


class OtherInventoriesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other non-current inventories not otherwise classified."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherInventoriesBalanceSheet class"""
        ...


class OtherInvestedAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    An item represents all the other investments or/and securities that cannot be defined into any category above. This item is typically
    available for the insurance industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherInvestedAssetsBalanceSheet class"""
        ...


class OtherNonCurrentAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other non-current assets that are not otherwise classified."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherNonCurrentAssetsBalanceSheet class"""
        ...


class OtherPropertiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other fixed assets not otherwise classified."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherPropertiesBalanceSheet class"""
        ...


class OtherRealEstateOwnedBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The Carrying amount as of the balance sheet date of other real estate, which may include real estate investments, real estate loans
    that qualify as investments in real estate, and premises that are no longer used in operations may also be included in real estate
    owned. This does not include real estate assets taken in settlement of troubled loans through surrender or foreclosure.  This item is
    typically available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherRealEstateOwnedBalanceSheet class"""
        ...


class OtherReceivablesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other non-current receivables not otherwise classified."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherReceivablesBalanceSheet class"""
        ...


class NonCurrentPensionAndOtherPostretirementBenefitPlansBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    A loan issued by an insurance company that uses the cash value of a person's life insurance policy as collateral.  This item is usually
    only available in the insurance industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NonCurrentPensionAndOtherPostretirementBenefitPlansBalanceSheet class"""
        ...


class PolicyLoansBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    A loan issued by an insurance company that uses the cash value of a person's life insurance policy as collateral. This item is usually
    only available for insurance industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PolicyLoansBalanceSheet class"""
        ...


class PreferredStockEquityBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    A class of ownership in a company that has a higher claim on the assets and earnings than common stock. Preferred stock
    generally has a dividend that must be paid out before dividends to common stockholders and the shares usually do not have voting
    rights.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PreferredStockEquityBalanceSheet class"""
        ...


class PropertiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Tangible assets that are held by an entity for use in the production or supply of goods and services, for rental to others, or for
    administrative purposes and that are expected to provide economic benefit for more than one year. This item is available for
    manufacturing, bank and transportation industries.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PropertiesBalanceSheet class"""
        ...


class CurrentProvisionsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Provisions are created to protect the interests of one or both parties named in a contract or legal document which is a preparatory
    action or measure. Current provision is expired within one accounting PeriodAsByte.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CurrentProvisionsBalanceSheet class"""
        ...


class LongTermProvisionsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Provisions are created to protect the interests of one or both parties named in a contract or legal document which is a preparatory
    action or measure. Long-term provision is expired beyond one accounting PeriodAsByte.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the LongTermProvisionsBalanceSheet class"""
        ...


class RawMaterialsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Carrying amount as of the balance sheet data of unprocessed items to be consumed in the manufacturing or production process.
    This item is available for manufacturing and mining industries.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the RawMaterialsBalanceSheet class"""
        ...


class ReceivablesAdjustmentsAllowancesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    A provision relating to a written agreement to receive money at a specified future date(s) (within one year from the reporting date
    or the normal operating cycle, whichever is longer), consisting of principal as well as any accrued interest).
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ReceivablesAdjustmentsAllowancesBalanceSheet class"""
        ...


class RegulatoryAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Carrying amount as of the balance sheet date of capitalized costs of regulated entities that are expected to be recovered through
    revenue sources over one year or beyond the normal operating cycle.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the RegulatoryAssetsBalanceSheet class"""
        ...


class RegulatoryLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The amount for the individual regulatory noncurrent liability as itemized in a table of regulatory noncurrent liabilities as of the end of
    the PeriodAsByte. Such things as the costs of energy efficiency programs and low-income energy assistances programs and deferred fuel.
    This item is usually only available for utility industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the RegulatoryLiabilitiesBalanceSheet class"""
        ...


class ReinsuranceBalancesPayableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The carrying amount as of the balance sheet date of the known and estimated amounts owed to insurers under reinsurance
    treaties or other arrangements. This item is usually only available for insurance industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ReinsuranceBalancesPayableBalanceSheet class"""
        ...


class RestrictedCashBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The carrying amounts of cash and cash equivalent items, which are restricted as to withdrawal or usage. Restrictions may include
    legally restricted deposits held as compensating balances against short-term borrowing arrangements, contracts entered into with
    others, or entity statements of intention with regard to particular deposits; however, time deposits and short-term certificates of
    deposit are not generally included in legally restricted deposits. Excludes compensating balance arrangements that are not
    agreements, which legally restrict the use of cash amounts shown on the balance sheet. For a classified balance sheet, represents
    the current portion only (the non-current portion has a separate concept); for an unclassified balance sheet represents the entire
    amount. This item is usually not available for bank and insurance industries.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the RestrictedCashBalanceSheet class"""
        ...


class RestrictedCashAndCashEquivalentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The carrying amounts of cash and cash equivalent items which are restricted as to withdrawal or usage. This item is available for
    bank and insurance industries.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the RestrictedCashAndCashEquivalentsBalanceSheet class"""
        ...


class RestrictedCashAndInvestmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The cash and investments whose use in whole or in part is restricted for the long-term, generally by contractual agreements or
    regulatory requirements. This item is usually only available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the RestrictedCashAndInvestmentsBalanceSheet class"""
        ...


class RestrictedCommonStockBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Shares of stock for which sale is contractually or governmentally restricted for a given period of time. Stock that is acquired through
    an employee stock option plan or other private means may not be transferred. Restricted stock must be traded in compliance with
    special SEC regulations.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the RestrictedCommonStockBalanceSheet class"""
        ...


class RestrictedInvestmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Investments whose use is restricted in whole or in part, generally by contractual agreements or regulatory requirements. This item
    is usually only available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the RestrictedInvestmentsBalanceSheet class"""
        ...


class TaxesReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Carrying amount due within one year of the balance sheet date (or one operating cycle, if longer) from tax authorities as of the
    balance sheet date representing refunds of overpayments or recoveries based on agreed-upon resolutions of disputes. This item is
    usually not available for bank industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TaxesReceivableBalanceSheet class"""
        ...


class TotalCapitalizationBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Stockholder's Equity plus Long Term Debt."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalCapitalizationBalanceSheet class"""
        ...


class TotalDeferredCreditsAndOtherNonCurrentLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Revenue received by a firm but not yet reported as income.  This item is usually only available for utility industry."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalDeferredCreditsAndOtherNonCurrentLiabilitiesBalanceSheet class"""
        ...


class UnbilledReceivablesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Revenues that are not currently billed from the customer under the terms of the contract.  This item is usually only available for
    utility industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the UnbilledReceivablesBalanceSheet class"""
        ...


class UnrealizedGainLossBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A profit or loss that results from holding onto an asset rather than cashing it in and officially taking the profit or loss."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the UnrealizedGainLossBalanceSheet class"""
        ...


class WorkInProcessBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Work, or goods, in the process of being fabricated or manufactured but not yet completed as finished goods. This item is usually
    available for manufacturing and mining industries.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the WorkInProcessBalanceSheet class"""
        ...


class OtherNonCurrentLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This item is usually not available for bank and insurance industries."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherNonCurrentLiabilitiesBalanceSheet class"""
        ...


class CapitalLeaseObligationsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Current Portion of Capital Lease Obligation plus Long Term Portion of Capital Lease Obligation."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CapitalLeaseObligationsBalanceSheet class"""
        ...


class OtherLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """This item is available for bank and insurance industries."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherLiabilitiesBalanceSheet class"""
        ...


class OtherPayableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Payables and Accrued Expenses that are not defined as Trade, Tax or Dividends related."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherPayableBalanceSheet class"""
        ...


class TangibleBookValueBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The company's total book value less the value of any intangible assets.
    Methodology: Common Stock Equity minus Goodwill and Other Intangible Assets
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TangibleBookValueBalanceSheet class"""
        ...


class TotalEquityBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total Equity equals Preferred Stock Equity + Common Stock Equity."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalEquityBalanceSheet class"""
        ...


class WorkingCapitalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Current Assets minus Current Liabilities.  This item is usually not available for bank and insurance industries."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the WorkingCapitalBalanceSheet class"""
        ...


class TotalDebtBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """All borrowings incurred by the company including debt and capital lease obligations."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalDebtBalanceSheet class"""
        ...


class CommonUtilityPlantBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The amount for the other plant related to the utility industry fix assets."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CommonUtilityPlantBalanceSheet class"""
        ...


class ElectricUtilityPlantBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The amount for the electric plant related to the utility industry."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ElectricUtilityPlantBalanceSheet class"""
        ...


class NaturalGasFuelAndOtherBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The amount for the natural gas, fuel and other items related to the utility industry, which might include oil and gas wells, the
    properties to exploit oil and gas or liquefied natural gas sites.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NaturalGasFuelAndOtherBalanceSheet class"""
        ...


class NetUtilityPlantBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Net utility plant might include water production, electric utility plan, natural gas, fuel and other, common utility plant and
    accumulated depreciation. This item is usually only available for utility industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetUtilityPlantBalanceSheet class"""
        ...


class WaterProductionBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The amount for a facility and plant that provides water which might include wells, reservoirs, pumping stations, and control
    facilities; and waste water systems which includes the waste treatment and disposal facility and equipment. This item is usually
    only available for utility industry.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the WaterProductionBalanceSheet class"""
        ...


class OrdinarySharesNumberBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Number of Common or Ordinary Shares."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OrdinarySharesNumberBalanceSheet class"""
        ...


class PreferredSharesNumberBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Number of Preferred Shares."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PreferredSharesNumberBalanceSheet class"""
        ...


class TreasurySharesNumberBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Number of Treasury Shares."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TreasurySharesNumberBalanceSheet class"""
        ...


class TradingAndOtherReceivableBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    This will serve as the "parent" value to AccountsReceivable (DataId 23001) and OtherReceivables (DataId 23342) for all company
    financials reported in the IFRS GAAP.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TradingAndOtherReceivableBalanceSheet class"""
        ...


class EquityAttributableToOwnersOfParentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """"""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the EquityAttributableToOwnersOfParentBalanceSheet class"""
        ...


class SecuritiesLoanedBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The carrying value as of the balance sheet date of securities loaned to other broker dealers, typically used by such parties to cover
    short sales, secured by cash or other securities furnished by such parties until the borrowing is closed.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the SecuritiesLoanedBalanceSheet class"""
        ...


class NetTangibleAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Net assets in physical form. This is calculated using Stockholders' Equity less Intangible Assets (including Goodwill)."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def OneMonth(self) -> float:
        """Gets/sets the OneMonth period value for the field"""
        ...

    @OneMonth.setter
    def OneMonth(self, value: float):
        """Gets/sets the OneMonth period value for the field"""
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def SixMonths(self) -> float:
        """Gets/sets the SixMonths period value for the field"""
        ...

    @SixMonths.setter
    def SixMonths(self, value: float):
        """Gets/sets the SixMonths period value for the field"""
        ...

    @property
    def NineMonths(self) -> float:
        """Gets/sets the NineMonths period value for the field"""
        ...

    @NineMonths.setter
    def NineMonths(self, value: float):
        """Gets/sets the NineMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NetTangibleAssetsBalanceSheet class"""
        ...


class DuefromRelatedPartiesCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Amounts owed to the company from a non-arm's length entity, due within the company's current operating cycle."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DuefromRelatedPartiesCurrentBalanceSheet class"""
        ...


class DuefromRelatedPartiesNonCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Amounts owed to the company from a non-arm's length entity, due after the company's current operating cycle."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DuefromRelatedPartiesNonCurrentBalanceSheet class"""
        ...


class DuetoRelatedPartiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Amounts owed by the company to a non-arm's length entity."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DuetoRelatedPartiesBalanceSheet class"""
        ...


class DuetoRelatedPartiesCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Amounts owed by the company to a non-arm's length entity that has to be repaid within the company's current operating cycle."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DuetoRelatedPartiesCurrentBalanceSheet class"""
        ...


class DuetoRelatedPartiesNonCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Amounts owed by the company to a non-arm's length entity that has to be repaid after the company's current operating cycle."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DuetoRelatedPartiesNonCurrentBalanceSheet class"""
        ...


class InvestmentPropertiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Company's investments in properties net of accumulated depreciation, which generate a return."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InvestmentPropertiesBalanceSheet class"""
        ...


class InvestmentsinSubsidiariesatCostBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A stake in any company which is more than 51%."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InvestmentsinSubsidiariesatCostBalanceSheet class"""
        ...


class InvestmentsinAssociatesatCostBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A stake in any company which is more than 20% but less than 50%."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InvestmentsinAssociatesatCostBalanceSheet class"""
        ...


class InvestmentsinJointVenturesatCostBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A 50% stake in any company in which remaining 50% belongs to other company."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InvestmentsinJointVenturesatCostBalanceSheet class"""
        ...


class InvestmentinFinancialAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Represents the sum of all financial investments (trading securities, available-for-sale securities, held-to-maturity securities, etc.)"""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InvestmentinFinancialAssetsBalanceSheet class"""
        ...


class FinanceLeaseReceivablesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Accounts owed to the bank in relation to capital leases. Capital/ finance lease obligation are contractual obligations that arise from
    obtaining the use of property or equipment via a capital lease contract.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FinanceLeaseReceivablesBalanceSheet class"""
        ...


class ConvertibleLoansCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    This represents loans that entitle the lender (or the holder of loan debenture) to convert the loan to common or preferred stock
    (ordinary or preference shares) within the next 12 months or operating cycle.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ConvertibleLoansCurrentBalanceSheet class"""
        ...


class BankLoansCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    A debt financing obligation issued by a bank or similar financial institution to a company, that entitles the lender or holder of the
    instrument to interest payments and the repayment of principal at a specified time within the next 12 months or operating cycle.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the BankLoansCurrentBalanceSheet class"""
        ...


class OtherLoansCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Other loans between the customer and bank which cannot be identified by other specific items in the Debt section, due within the
    next 12 months or operating cycle.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherLoansCurrentBalanceSheet class"""
        ...


class AccruedandDeferredIncomeBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Sum of accrued liabilities and deferred income (amount received in advance but the services are not provided in respect of
    amount).
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AccruedandDeferredIncomeBalanceSheet class"""
        ...


class BankLoansNonCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    A debt financing obligation issued by a bank or similar financial institution to a company, that entitles the lender or holder of the
    instrument to interest payments and the repayment of principal at a specified time beyond the current accounting PeriodAsByte.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the BankLoansNonCurrentBalanceSheet class"""
        ...


class OtherLoansNonCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Other loans between the customer and bank which cannot be identified by other specific items in the Debt section, due beyond the
    current operating cycle.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherLoansNonCurrentBalanceSheet class"""
        ...


class OtherReservesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other reserves owned by the company that cannot be identified by other specific items in the Reserves section."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherReservesBalanceSheet class"""
        ...


class LoansandAdvancestoBankBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of loans and advances made to a bank or financial institution."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the LoansandAdvancestoBankBalanceSheet class"""
        ...


class LoansandAdvancestoCustomerBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """The aggregate amount of loans and advances made to customers."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the LoansandAdvancestoCustomerBalanceSheet class"""
        ...


class TreasuryBillsandOtherEligibleBillsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Investments backed by the central government, it usually carries less risk than other investments."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TreasuryBillsandOtherEligibleBillsBalanceSheet class"""
        ...


class EquitySharesInvestmentsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Investments in shares of a company representing ownership in that company."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the EquitySharesInvestmentsBalanceSheet class"""
        ...


class DepositsbyBankBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Banks investment in the ongoing entity."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DepositsbyBankBalanceSheet class"""
        ...


class CustomerAccountsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Carrying value of amounts transferred by customers to third parties for security purposes that are expected to be returned or
    applied towards payment after one year or beyond the operating cycle, if longer.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the CustomerAccountsBalanceSheet class"""
        ...


class ItemsinTheCourseofTransmissiontoOtherBanksBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Carrying amount as of the balance sheet date of drafts and bills of exchange that have been accepted by the reporting bank or by
    others for its own account, as its liability to holders of the drafts.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ItemsinTheCourseofTransmissiontoOtherBanksBalanceSheet class"""
        ...


class TradingandFinancialLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total carrying amount of total trading, financial liabilities and debt in a non-differentiated balance sheet."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TradingandFinancialLiabilitiesBalanceSheet class"""
        ...


class DebtSecuritiesinIssueBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Any debt financial instrument issued instead of cash loan."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DebtSecuritiesinIssueBalanceSheet class"""
        ...


class SubordinatedLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    The total carrying value of securities loaned to other broker dealers, typically used by such parties to cover short sales, secured by
    cash or other securities furnished by such parties until the borrowing is closed; in a Non-Differentiated Balance Sheet.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the SubordinatedLiabilitiesBalanceSheet class"""
        ...


class ProvisionsTotalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Provisions are created to protect the interests of one or both parties named in a contract or legal document, which is a preparatory
    action or measure. Current provision is expired within one accounting PeriodAsByte.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ProvisionsTotalBalanceSheet class"""
        ...


class OperatingLeaseAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    A contract that allows for the use of an asset, but does not convey rights of ownership of the asset. An operating lease is not
    capitalized; it is accounted for as a rental expense in what is known as "off balance sheet financing." For the lessor, the asset being
    leased is accounted for as an asset and is depreciated as such.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OperatingLeaseAssetsBalanceSheet class"""
        ...


class ClaimsOutstandingBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Amounts owing to policy holders who have filed claims but have not yet been settled or paid."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ClaimsOutstandingBalanceSheet class"""
        ...


class LiabilitiesHeldforSaleCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Liabilities due within the next 12 months related from an asset classified as Held for Sale."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the LiabilitiesHeldforSaleCurrentBalanceSheet class"""
        ...


class LiabilitiesHeldforSaleNonCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Liabilities related to an asset classified as held for sale excluding the portion due the next 12 months or operating cycle."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the LiabilitiesHeldforSaleNonCurrentBalanceSheet class"""
        ...


class DebtSecuritiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Debt securities held as investments."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DebtSecuritiesBalanceSheet class"""
        ...


class TotalFinancialLeaseObligationsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Represents the total amount of long-term capital leases that must be paid within the next accounting period for a Non-
    Differentiated Balance Sheet. Capital lease obligations are contractual obligations that arise from obtaining the use of property or
    equipment via a capital lease contract.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TotalFinancialLeaseObligationsBalanceSheet class"""
        ...


class AccruedandDeferredIncomeCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Sum of Accrued Liabilities and Deferred Income (amount received in advance but the services are not provided in respect of
    amount) due within 1 year.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AccruedandDeferredIncomeCurrentBalanceSheet class"""
        ...


class AccruedandDeferredIncomeNonCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Sum of Accrued Liabilities and Deferred Income (amount received in advance but the services are not provided in respect of
    amount) due after 1 year.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AccruedandDeferredIncomeNonCurrentBalanceSheet class"""
        ...


class FinanceLeaseReceivablesCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Accounts owed to the bank in relation to capital leases to be received within the next accounting PeriodAsByte. Capital/ finance lease
    obligations are contractual obligations that arise from obtaining the use of property or equipment via a capital lease contract.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FinanceLeaseReceivablesCurrentBalanceSheet class"""
        ...


class FinanceLeaseReceivablesNonCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Accounts owed to the bank in relation to capital leases to be received beyond the next accounting PeriodAsByte. Capital/ finance lease
    obligations are contractual obligations that arise from obtaining the use of property or equipment via a capital lease contract.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FinanceLeaseReceivablesNonCurrentBalanceSheet class"""
        ...


class FinancialLiabilitiesCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Financial related liabilities due within one year, including short term and current portions of long-term debt, capital leases and
    derivative liabilities.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FinancialLiabilitiesCurrentBalanceSheet class"""
        ...


class FinancialLiabilitiesNonCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Financial related liabilities due beyond one year, including long term debt, capital leases and derivative liabilities."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FinancialLiabilitiesNonCurrentBalanceSheet class"""
        ...


class FinancialAssetsDesignatedasFairValueThroughProfitorLossTotalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Financial assets that are held at fair value through profit or loss comprise assets held for trading and those financial assets
    designated as being held at fair value through profit or loss.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FinancialAssetsDesignatedasFairValueThroughProfitorLossTotalBalanceSheet class"""
        ...


class TaxesAssetsCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Carrying amount due within one year of the balance sheet date (or one operating cycle, if longer) from tax authorities as of the
    balance sheet date representing refunds of overpayments or recoveries based on agreed-upon resolutions of disputes, and current
    deferred tax assets.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TaxesAssetsCurrentBalanceSheet class"""
        ...


class OtherEquityInterestBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other equity instruments issued by the company that cannot be identified by other specific items in the Equity section."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherEquityInterestBalanceSheet class"""
        ...


class InterestBearingBorrowingsNonCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Carrying amount of any interest-bearing loan which is due after one year."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InterestBearingBorrowingsNonCurrentBalanceSheet class"""
        ...


class NonInterestBearingBorrowingsNonCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Non-interest bearing borrowings due after a year."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NonInterestBearingBorrowingsNonCurrentBalanceSheet class"""
        ...


class TradeandOtherPayablesNonCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Sum of all non-current payables and accrued expenses."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TradeandOtherPayablesNonCurrentBalanceSheet class"""
        ...


class NonInterestBearingBorrowingsCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Non-interest bearing deposits in other financial institutions for short periods of time, usually less than 12 months."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NonInterestBearingBorrowingsCurrentBalanceSheet class"""
        ...


class PensionandOtherPostRetirementBenefitPlansCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Total of the carrying values as of the balance sheet date of obligations incurred through that date and payable for obligations related
    to services received from employees, such as accrued salaries and bonuses, payroll taxes and fringe benefits.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PensionandOtherPostRetirementBenefitPlansCurrentBalanceSheet class"""
        ...


class OtherLoanAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Reflects the carrying amount of any other unpaid loans, an asset of the bank."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherLoanAssetsBalanceSheet class"""
        ...


class AssetsPledgedasCollateralSubjecttoSaleorRepledgingTotalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Total value collateral assets pledged to the bank that can be sold or used as collateral for other loans."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AssetsPledgedasCollateralSubjecttoSaleorRepledgingTotalBalanceSheet class"""
        ...


class TaxAssetsTotalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Sum of total tax assets in a Non-Differentiated Balance Sheet, includes Tax Receivables and Deferred Tax Assets."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the TaxAssetsTotalBalanceSheet class"""
        ...


class AdvancesfromCentralBanksBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Borrowings from the central bank, which are primarily used to cover shortages in the required reserve balance and liquidity
    shortages.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AdvancesfromCentralBanksBalanceSheet class"""
        ...


class DepositCertificatesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    A savings certificate entitling the bearer to receive interest. A CD bears a maturity date, a specified fixed interest rate and can be
    issued in any denomination.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DepositCertificatesBalanceSheet class"""
        ...


class NonInterestBearingBorrowingsTotalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Non-interest bearing deposits in other financial institutions for relatively short periods of time; on a Non-Differentiated Balance
    Sheet.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the NonInterestBearingBorrowingsTotalBalanceSheet class"""
        ...


class OtherBorrowedFundsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Other borrowings by the bank to fund its activities that cannot be identified by other specific items in the Liabilities section."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the OtherBorrowedFundsBalanceSheet class"""
        ...


class FinancialLiabilitiesDesignatedasFairValueThroughProfitorLossTotalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Financial liabilities that are held at fair value through profit or loss."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FinancialLiabilitiesDesignatedasFairValueThroughProfitorLossTotalBalanceSheet class"""
        ...


class FinancialLiabilitiesMeasuredatAmortizedCostTotalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Financial liabilities carried at amortized cost."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the FinancialLiabilitiesMeasuredatAmortizedCostTotalBalanceSheet class"""
        ...


class AccruedLiabilitiesTotalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Liabilities which have occurred, but have not been paid or logged under accounts payable during an accounting PeriodAsByte. In other
    words, obligations for goods and services provided to a company for which invoices have not yet been received; on a Non-
    Differentiated Balance Sheet.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def TwoMonths(self) -> float:
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @TwoMonths.setter
    def TwoMonths(self, value: float):
        """Gets/sets the TwoMonths period value for the field"""
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the AccruedLiabilitiesTotalBalanceSheet class"""
        ...


class DeferredIncomeTotalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Collections of cash or other assets related to revenue producing activity for which revenue has not yet been recognized on a Non-
    Differentiated Balance Sheet.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DeferredIncomeTotalBalanceSheet class"""
        ...


class DeferredTaxLiabilitiesTotalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    A future tax liability, resulting from temporary differences between book (accounting) value of assets and liabilities and their tax
    value or timing differences between the recognition of gains and losses in financial statements, on a Non-Differentiated Balance
    Sheet.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DeferredTaxLiabilitiesTotalBalanceSheet class"""
        ...


class ReinsuranceAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Reinsurance asset is insurance that is purchased by an insurance company from another insurance company."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ReinsuranceAssetsBalanceSheet class"""
        ...


class DepositsMadeunderAssumedReinsuranceContractBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Deposits made under reinsurance."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DepositsMadeunderAssumedReinsuranceContractBalanceSheet class"""
        ...


class InsuranceContractAssetsBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    A contract under which one party (the insurer) accepts significant insurance risk from another party (the policyholder) by agreeing
    to compensate the policyholder if a specified uncertain future event (the insured event) adversely affects the policyholder. This
    includes Insurance Receivables and Premiums Receivables.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InsuranceContractAssetsBalanceSheet class"""
        ...


class InsuranceContractLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Any type of insurance policy that protects an individual or business from the risk that they may be sued and held legally liable for
    something such as malpractice, injury or negligence. Liability insurance policies cover both legal costs and any legal payouts for
    which the insured would be responsible if found legally liable. Intentional damage and contractual liabilities are typically not covered
    in these types of policies.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InsuranceContractLiabilitiesBalanceSheet class"""
        ...


class DepositsReceivedunderCededInsuranceContractBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Deposit received through ceded insurance contract."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the DepositsReceivedunderCededInsuranceContractBalanceSheet class"""
        ...


class InvestmentContractLiabilitiesBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Liabilities due on the insurance investment contract."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the InvestmentContractLiabilitiesBalanceSheet class"""
        ...


class PensionAndOtherPostretirementBenefitPlansTotalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Total of the carrying values as of the balance sheet date of obligations incurred through that date and payable for obligations related
    to services received from employees, such as accrued salaries and bonuses, payroll taxes and fringe benefits. Used to reflect the
    current portion of the liabilities (due within one year or within the normal operating cycle if longer).
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the PensionAndOtherPostretirementBenefitPlansTotalBalanceSheet class"""
        ...


class LiabilitiesHeldforSaleTotalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """Liabilities related to an asset classified as held for sale."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the LiabilitiesHeldforSaleTotalBalanceSheet class"""
        ...


class HedgingAssetsCurrentBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """A security transaction which expires within a 12 month period that reduces the risk on an existing investment position."""

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the HedgingAssetsCurrentBalanceSheet class"""
        ...


class ConvertibleLoansTotalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Loans that entitles the lender (or the holder of loan debenture) to convert the loan to common or preferred stock (ordinary or
    preference shares) at a specified rate conversion rate and a specified time frame; in a Non-Differentiated Balance Sheet.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> float:
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @ThreeMonths.setter
    def ThreeMonths(self, value: float):
        """Gets/sets the ThreeMonths period value for the field"""
        ...

    @property
    def TwelveMonths(self) -> float:
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    @TwelveMonths.setter
    def TwelveMonths(self, value: float):
        """Gets/sets the TwelveMonths period value for the field"""
        ...

    def __init__(self, store: System.Collections.Generic.IDictionary[str, float] = None) -> None:
        """Creates an instance of the ConvertibleLoansTotalBalanceSheet class"""
        ...


class BankLoansTotalBalanceSheet(QuantConnect.Data.Fundamental.MultiPeriodField):
    """
    Total debt financing obligation issued by a bank or similar financial institution to a company that entitles the lender or holder of the
    instrument to interest payments and the repayment of principal at a specified time; in a Non-Differentiated Balance Sheet.
    """

    @property
    def DefaultPeriod(self) -> int:
        """
        Gets the default period for the field
        
        This property is protected.
        """
        ...

    @property
    def ThreeMonths(self) -> floa