import abc
import datetime
import typing

import QuantConnect
import QuantConnect.Data
import QuantConnect.Data.Market
import QuantConnect.Indicators
import System
import System.Collections
import System.Collections.Generic

QuantConnect_Indicators_CompositeIndicator_IndicatorComposer = typing.Any
PyObject = typing.Any
QuantConnect_Indicators_IndicatorUpdatedHandler = typing.Any
QuantConnect_Indicators_IIndicator = typing.Any
QuantConnect_Indicators_IndicatorDataPoint = typing.Any

QuantConnect_Indicators_CompositeIndicator_T = typing.TypeVar("QuantConnect_Indicators_CompositeIndicator_T")
QuantConnect_Indicators_IndicatorExtensions_Of_T = typing.TypeVar("QuantConnect_Indicators_IndicatorExtensions_Of_T")
QuantConnect_Indicators_IndicatorExtensions_WeightedBy_TWeight = typing.TypeVar("QuantConnect_Indicators_IndicatorExtensions_WeightedBy_TWeight")
QuantConnect_Indicators_IndicatorExtensions_WeightedBy_T = typing.TypeVar("QuantConnect_Indicators_IndicatorExtensions_WeightedBy_T")
QuantConnect_Indicators_IndicatorExtensions_Plus_T = typing.TypeVar("QuantConnect_Indicators_IndicatorExtensions_Plus_T")
QuantConnect_Indicators_IndicatorExtensions_Minus_T = typing.TypeVar("QuantConnect_Indicators_IndicatorExtensions_Minus_T")
QuantConnect_Indicators_IndicatorExtensions_Over_T = typing.TypeVar("QuantConnect_Indicators_IndicatorExtensions_Over_T")
QuantConnect_Indicators_IndicatorExtensions_Times_T = typing.TypeVar("QuantConnect_Indicators_IndicatorExtensions_Times_T")
QuantConnect_Indicators_IndicatorExtensions_EMA_T = typing.TypeVar("QuantConnect_Indicators_IndicatorExtensions_EMA_T")
QuantConnect_Indicators_IndicatorExtensions_MIN_T = typing.TypeVar("QuantConnect_Indicators_IndicatorExtensions_MIN_T")
QuantConnect_Indicators_IndicatorExtensions_SMA_T = typing.TypeVar("QuantConnect_Indicators_IndicatorExtensions_SMA_T")
QuantConnect_Indicators_IndicatorBase_T = typing.TypeVar("QuantConnect_Indicators_IndicatorBase_T")
QuantConnect_Indicators_FunctionalIndicator_T = typing.TypeVar("QuantConnect_Indicators_FunctionalIndicator_T")
QuantConnect_Indicators_WindowIndicator_T = typing.TypeVar("QuantConnect_Indicators_WindowIndicator_T")
QuantConnect_Indicators_ConstantIndicator_T = typing.TypeVar("QuantConnect_Indicators_ConstantIndicator_T")
QuantConnect_Indicators_IReadOnlyWindow_T = typing.TypeVar("QuantConnect_Indicators_IReadOnlyWindow_T")
QuantConnect_Indicators_IIndicator_T = typing.TypeVar("QuantConnect_Indicators_IIndicator_T")
QuantConnect_Indicators_RollingWindow_T = typing.TypeVar("QuantConnect_Indicators_RollingWindow_T")


class IndicatorDataPoint(QuantConnect.Data.BaseData, System.IEquatable[QuantConnect_Indicators_IndicatorDataPoint], System.IComparable[QuantConnect_Indicators_IndicatorDataPoint]):
    """Represents a piece of data at a specific time"""

    @typing.overload
    def __init__(self) -> None:
        """
        Initializes a new default instance of IndicatorDataPoint with a time of
        DateTime.MinValue and a Value of 0m.
        """
        ...

    @typing.overload
    def __init__(self, time: datetime.datetime, value: float) -> None:
        """
        Initializes a new instance of the DataPoint type using the specified time/data
        
        :param time: The time this data was produced
        :param value: The data
        """
        ...

    @typing.overload
    def __init__(self, symbol: typing.Union[QuantConnect.Symbol, str], time: datetime.datetime, value: float) -> None:
        """
        Initializes a new instance of the DataPoint type using the specified time/data
        
        :param symbol: The symbol associated with this data
        :param time: The time this data was produced
        :param value: The data
        """
        ...

    @typing.overload
    def Equals(self, other: QuantConnect.Indicators.IndicatorDataPoint) -> bool:
        """
        Indicates whether the current object is equal to another object of the same type.
        
        :param other: An object to compare with this object.
        :returns: true if the current object is equal to the  parameter; otherwise, false.
        """
        ...

    @typing.overload
    def CompareTo(self, other: QuantConnect.Indicators.IndicatorDataPoint) -> int:
        """
        Compares the current object with another object of the same type.
        
        :param other: An object to compare with this object.
        :returns: A value that indicates the relative order of the objects being compared. The return value has the following meanings: Value Meaning Less than zero This object is less than the  parameter.Zero This object is equal to . Greater than zero This object is greater than .
        """
        ...

    @typing.overload
    def CompareTo(self, obj: typing.Any) -> int:
        """
        Compares the current instance with another object of the same type and returns an integer that indicates whether the current instance precedes, follows, or occurs in the same position in the sort order as the other object.
        
        :param obj: An object to compare with this instance.
        :returns: A value that indicates the relative order of the objects being compared. The return value has these meanings: Value Meaning Less than zero This instance precedes  in the sort order. Zero This instance occurs in the same position in the sort order as . Greater than zero This instance follows  in the sort order.
        """
        ...

    def ToString(self) -> str:
        """
        Returns a string representation of this DataPoint instance using ISO8601 formatting for the date
        
        :returns: A System.String containing a fully qualified type name.
        """
        ...

    @typing.overload
    def Equals(self, obj: typing.Any) -> bool:
        """
        Indicates whether this instance and a specified object are equal.
        
        :param obj: Another object to compare to.
        :returns: true if  and this instance are the same type and represent the same value; otherwise, false.
        """
        ...

    def GetHashCode(self) -> int:
        """
        Returns the hash code for this instance.
        
        :returns: A 32-bit signed integer that is the hash code for this instance.
        """
        ...

    def Reader(self, config: QuantConnect.Data.SubscriptionDataConfig, line: str, date: datetime.datetime, isLiveMode: bool) -> QuantConnect.Data.BaseData:
        """This function is purposefully not implemented."""
        ...

    def GetSource(self, config: QuantConnect.Data.SubscriptionDataConfig, date: datetime.datetime, isLiveMode: bool) -> QuantConnect.Data.SubscriptionDataSource:
        """This function is purposefully not implemented."""
        ...


class IIndicator(typing.Generic[QuantConnect_Indicators_IIndicator_T], System.IComparable[QuantConnect_Indicators_IIndicator], QuantConnect_Indicators_IIndicator, metaclass=abc.ABCMeta):
    """
    KEEPING THIS INTERFACE FOR BACKWARDS COMPATIBILITY.
    Represents an indicator that can receive data updates and emit events when the value of
    the indicator has changed.
    """

    @property
    @abc.abstractmethod
    def Updated(self) -> typing.List[QuantConnect_Indicators_IndicatorUpdatedHandler]:
        """Event handler that fires after this indicator is updated"""
        ...

    @Updated.setter
    @abc.abstractmethod
    def Updated(self, value: typing.List[QuantConnect_Indicators_IndicatorUpdatedHandler]):
        """Event handler that fires after this indicator is updated"""
        ...

    @property
    @abc.abstractmethod
    def Name(self) -> str:
        """Gets a name for this indicator"""
        ...

    @property
    @abc.abstractmethod
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    @abc.abstractmethod
    def Current(self) -> QuantConnect.Indicators.IndicatorDataPoint:
        """
        Gets the current state of this indicator. If the state has not been updated
        then the time on the value will equal DateTime.MinValue.
        """
        ...

    @property
    @abc.abstractmethod
    def Samples(self) -> int:
        """Gets the number of samples processed by this indicator"""
        ...

    def Update(self, input: QuantConnect.Data.IBaseData) -> bool:
        """
        Updates the state of this indicator with the given value and returns true
        if this indicator is ready, false otherwise
        
        :param input: The value to use to update this indicator
        :returns: True if this indicator is ready, false otherwise.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class IndicatorStatus(System.Enum):
    """The possible states returned by IndicatorBase{T}.ComputeNextValue"""

    Success = 0
    """The indicator successfully calculated a value for the input data"""

    InvalidInput = 1
    """The indicator detected an invalid input data point or tradebar"""

    MathError = 2
    """The indicator encountered a math error during calculations"""

    ValueNotReady = 3
    """The indicator value is not ready"""


class IndicatorResult(System.Object):
    """Represents the result of an indicator's calculations"""

    @property
    def Value(self) -> float:
        """The indicator output value"""
        ...

    @Value.setter
    def Value(self, value: float):
        """The indicator output value"""
        ...

    @property
    def Status(self) -> int:
        """
        The indicator status
        
        This property contains the int value of a member of the QuantConnect.Indicators.IndicatorStatus enum.
        """
        ...

    @Status.setter
    def Status(self, value: int):
        """
        The indicator status
        
        This property contains the int value of a member of the QuantConnect.Indicators.IndicatorStatus enum.
        """
        ...

    def __init__(self, value: float, status: QuantConnect.Indicators.IndicatorStatus = ...) -> None:
        """
        Initializes a new instance of the IndicatorResult class
        
        :param value: The value output by the indicator
        :param status: The status returned by the indicator
        """
        ...


class IndicatorBase(typing.Generic[QuantConnect_Indicators_IndicatorBase_T], System.Object, QuantConnect.Indicators.IIndicator[QuantConnect_Indicators_IndicatorBase_T], metaclass=abc.ABCMeta):
    """Provides a base type for all indicators"""

    @property
    def Updated(self) -> typing.List[QuantConnect_Indicators_IndicatorUpdatedHandler]:
        """Event handler that fires after this indicator is updated"""
        ...

    @Updated.setter
    def Updated(self, value: typing.List[QuantConnect_Indicators_IndicatorUpdatedHandler]):
        """Event handler that fires after this indicator is updated"""
        ...

    @property
    def Name(self) -> str:
        """Gets a name for this indicator"""
        ...

    @Name.setter
    def Name(self, value: str):
        """Gets a name for this indicator"""
        ...

    @property
    @abc.abstractmethod
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def Current(self) -> QuantConnect.Indicators.IndicatorDataPoint:
        """
        Gets the current state of this indicator. If the state has not been updated
        then the time on the value will equal DateTime.MinValue.
        """
        ...

    @Current.setter
    def Current(self, value: QuantConnect.Indicators.IndicatorDataPoint):
        """
        Gets the current state of this indicator. If the state has not been updated
        then the time on the value will equal DateTime.MinValue.
        """
        ...

    @property
    def Samples(self) -> int:
        """Gets the number of samples processed by this indicator"""
        ...

    @Samples.setter
    def Samples(self, value: int):
        """Gets the number of samples processed by this indicator"""
        ...

    def __init__(self, name: str) -> None:
        """
        Initializes a new instance of the Indicator class using the specified name.
        
        This method is protected.
        
        :param name: The name of this indicator
        """
        ...

    @typing.overload
    def Update(self, input: QuantConnect.Data.IBaseData) -> bool:
        """
        Updates the state of this indicator with the given value and returns true
        if this indicator is ready, false otherwise
        
        :param input: The value to use to update this indicator
        :returns: True if this indicator is ready, false otherwise.
        """
        ...

    @typing.overload
    def Update(self, time: datetime.datetime, value: float) -> bool:
        """
        Updates the state of this indicator with the given value and returns true
        if this indicator is ready, false otherwise
        
        :param time: The time associated with the value
        :param value: The value to use to update this indicator
        :returns: True if this indicator is ready, false otherwise.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...

    @typing.overload
    def CompareTo(self, other: QuantConnect.Indicators.IIndicator[QuantConnect_Indicators_IndicatorBase_T]) -> int:
        """
        Compares the current object with another object of the same type.
        
        :param other: An object to compare with this object.
        :returns: A value that indicates the relative order of the objects being compared. The return value has the following meanings: Value Meaning Less than zero This object is less than the  parameter.Zero This object is equal to . Greater than zero This object is greater than .
        """
        ...

    @typing.overload
    def CompareTo(self, obj: typing.Any) -> int:
        """
        Compares the current instance with another object of the same type and returns an integer that indicates whether the current instance precedes, follows, or occurs in the same position in the sort order as the other object.
        
        :param obj: An object to compare with this instance.
        :returns: A value that indicates the relative order of the objects being compared. The return value has these meanings: Value Meaning Less than zero This instance precedes  in the sort order. Zero This instance occurs in the same position in the sort order as . Greater than zero This instance follows  in the sort order.
        """
        ...

    def Equals(self, obj: typing.Any) -> bool:
        """
        Determines whether the specified object is equal to the current object.
        
        :param obj: The object to compare with the current object.
        :returns: true if the specified object  is equal to the current object; otherwise, false.
        """
        ...

    def ToString(self) -> str:
        """
        ToString Overload for Indicator Base
        
        :returns: String representation of the indicator.
        """
        ...

    def ToDetailedString(self) -> str:
        """
        Provides a more detailed string of this indicator in the form of {Name} - {Value}
        
        :returns: A detailed string of this indicator's current state.
        """
        ...

    def ComputeNextValue(self, input: QuantConnect_Indicators_IndicatorBase_T) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def ValidateAndComputeNextValue(self, input: QuantConnect_Indicators_IndicatorBase_T) -> QuantConnect.Indicators.IndicatorResult:
        """
        Computes the next value of this indicator from the given state
        and returns an instance of the IndicatorResult class
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: An IndicatorResult object including the status of the indicator.
        """
        ...

    def OnUpdated(self, consolidated: QuantConnect.Indicators.IndicatorDataPoint) -> None:
        """
        Event invocator for the Updated event
        
        This method is protected.
        
        :param consolidated: This is the new piece of data produced by this indicator
        """
        ...


class BarIndicator(QuantConnect.Indicators.IndicatorBase[QuantConnect.Data.Market.IBaseDataBar], metaclass=abc.ABCMeta):
    """
    The BarIndicator is an indicator that accepts IBaseDataBar data as its input.
    
    This type is more of a shim/typedef to reduce the need to refer to things as IndicatorBase<IBaseDataBar>
    """

    def __init__(self, name: str) -> None:
        """
        Creates a new TradeBarIndicator with the specified name
        
        This method is protected.
        
        :param name: The name of this indicator
        """
        ...


class IIndicatorWarmUpPeriodProvider(metaclass=abc.ABCMeta):
    """Represents an indicator with a warm up period provider."""

    @property
    @abc.abstractmethod
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...


class FisherTransform(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    The Fisher transform is a mathematical process which is used to convert any data set to a modified
    data set whose Probability Distribution Function is approximately Gaussian. Once the Fisher transform
    is computed, the transformed data can then be analyzed in terms of it's deviation from the mean.
    
    The equation is y = .5 * ln [ 1 + x / 1 - x ] where
    x is the input
    y is the output
    ln is the natural logarithm
    
    The Fisher transform has much sharper turning points than other indicators such as MACD
    
    For more info, read chapter 1 of Cybernetic Analysis for Stocks and Futures by John F. Ehlers
    
    We are implementing the latest version of this indicator found at Fig. 4 of
    http://www.mesasoftware.com/papers/UsingTheFisherTransform.pdf
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the FisherTransform class with the default name and period
        
        :param period: The period of the WMA
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        A Fisher Transform of Prices
        
        :param name: string - the name of the indicator
        :param period: The number of periods for the indicator
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value in the transform.
        value1 is a function used to normalize price withing the last _period day range.
        value1 is centered on its midpoint and then doubled so that value1 wil swing between -1 and +1.
        value1 is also smoothed with an exponential moving average whose alpha is 0.33.
        
        Since the smoothing may allow value1 to exceed the _period day price range, limits are introduced to
        preclude the transform from blowing up by having an input larger than unity.
        
        This method is protected.
        
        :param input: IndicatorDataPoint - the time and value of the next price
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class CoppockCurve(QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    A momentum indicator developed by Edwin “Sedge” Coppock in October 1965.
    The goal of this indicator is to identify long-term buying opportunities in the S&P500 and Dow Industrials.
    Source: http://stockcharts.com/school/doku.php?id=chart_school:technical_indicators:coppock_curve
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self) -> None:
        """Initializes a new instance of the CoppockCurve indicator with its default values."""
        ...

    @typing.overload
    def __init__(self, shortRocPeriod: int, longRocPeriod: int, lwmaPeriod: int) -> None:
        """
        Initializes a new instance of the CoppockCurve indicator
        
        :param shortRocPeriod: The period for the short ROC
        :param longRocPeriod: The period for the long ROC
        :param lwmaPeriod: The period for the LWMA
        """
        ...

    @typing.overload
    def __init__(self, name: str, shortRocPeriod: int, longRocPeriod: int, lwmaPeriod: int) -> None:
        """
        Initializes a new instance of the CoppockCurve indicator
        
        :param name: A name for the indicator
        :param shortRocPeriod: The period for the short ROC
        :param longRocPeriod: The period for the long ROC
        :param lwmaPeriod: The period for the LWMA
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class Indicator(QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint], metaclass=abc.ABCMeta):
    """
    Represents a type capable of ingesting a piece of data and producing a new piece of data.
    Indicators can be used to filter and transform data into a new, more informative form.
    """

    def __init__(self, name: str) -> None:
        """
        Initializes a new instance of the Indicator class using the specified name.
        
        This method is protected.
        
        :param name: The name of this indicator
        """
        ...


class T3MovingAverage(QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the T3 Moving Average (T3).
    The T3 Moving Average is calculated with the following formula:
    EMA1(x, Period) = EMA(x, Period)
    EMA2(x, Period) = EMA(EMA1(x, Period),Period)
    GD(x, Period, volumeFactor) = (EMA1(x, Period)*(1+volumeFactor)) - (EMA2(x, Period)* volumeFactor)
    T3 = GD(GD(GD(t, Period, volumeFactor), Period, volumeFactor), Period, volumeFactor);
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int, volumeFactor: float = 0.7) -> None:
        """
        Initializes a new instance of the T3MovingAverage class using the specified name and period.
        
        :param name: The name of this indicator
        :param period: The period of the T3MovingAverage
        :param volumeFactor: The volume factor of the T3MovingAverage (value must be in the [0,1] range, defaults to 0.7)
        """
        ...

    @typing.overload
    def __init__(self, period: int, volumeFactor: float = 0.7) -> None:
        """
        Initializes a new instance of the T3MovingAverage class using the specified period.
        
        :param period: The period of the T3MovingAverage
        :param volumeFactor: The volume factor of the T3MovingAverage (value must be in the [0,1] range, defaults to 0.7)
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class TradeBarIndicator(QuantConnect.Indicators.IndicatorBase[QuantConnect.Data.Market.TradeBar], metaclass=abc.ABCMeta):
    """
    The TradeBarIndicator is an indicator that accepts TradeBar data as its input.
    
    This type is more of a shim/typedef to reduce the need to refer to things as IndicatorBase<TradeBar>
    """

    def __init__(self, name: str) -> None:
        """
        Creates a new TradeBarIndicator with the specified name
        
        This method is protected.
        
        :param name: The name of this indicator
        """
        ...


class AccumulationDistributionOscillator(QuantConnect.Indicators.TradeBarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the Accumulation/Distribution Oscillator (ADOSC)
    The Accumulation/Distribution Oscillator is calculated using the following formula:
    ADOSC = EMA(fast,AD) - EMA(slow,AD)
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, fastPeriod: int, slowPeriod: int) -> None:
        """
        Initializes a new instance of the AccumulationDistributionOscillator class using the specified parameters
        
        :param fastPeriod: The fast moving average period
        :param slowPeriod: The slow moving average period
        """
        ...

    @typing.overload
    def __init__(self, name: str, fastPeriod: int, slowPeriod: int) -> None:
        """
        Initializes a new instance of the AccumulationDistributionOscillator class using the specified parameters
        
        :param name: The name of this indicator
        :param fastPeriod: The fast moving average period
        :param slowPeriod: The slow moving average period
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.TradeBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class CompositeIndicator(typing.Generic[QuantConnect_Indicators_CompositeIndicator_T], QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]):
    """
    This indicator is capable of wiring up two separate indicators into a single indicator
    such that the output of each will be sent to a user specified function.
    """

    @property
    def Left(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_CompositeIndicator_T]:
        """Gets the 'left' indicator for the delegate"""
        ...

    @Left.setter
    def Left(self, value: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_CompositeIndicator_T]):
        """Gets the 'left' indicator for the delegate"""
        ...

    @property
    def Right(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_CompositeIndicator_T]:
        """Gets the 'right' indicator for the delegate"""
        ...

    @Right.setter
    def Right(self, value: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_CompositeIndicator_T]):
        """Gets the 'right' indicator for the delegate"""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    def IndicatorComposer(self, left: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_CompositeIndicator_T], right: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_CompositeIndicator_T]) -> QuantConnect.Indicators.IndicatorResult:
        """
        Delegate type used to compose the output of two indicators into a new value.
        
        :param left: The left indicator
        :param right: The right indicator
        :returns: And indicator result representing the composition of the two indicators.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...

    @typing.overload
    def __init__(self, name: str, left: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_CompositeIndicator_T], right: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_CompositeIndicator_T], composer: QuantConnect_Indicators_CompositeIndicator_IndicatorComposer) -> None:
        """
        Creates a new CompositeIndicator capable of taking the output from the left and right indicators
        and producing a new value via the composer delegate specified
        
        :param name: The name of this indicator
        :param left: The left indicator for the 'composer'
        :param right: The right indidcator for the 'composoer'
        :param composer: Function used to compose the left and right indicators
        """
        ...

    @typing.overload
    def __init__(self, left: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_CompositeIndicator_T], right: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_CompositeIndicator_T], composer: QuantConnect_Indicators_CompositeIndicator_IndicatorComposer) -> None:
        """
        Creates a new CompositeIndicator capable of taking the output from the left and right indicators
        and producing a new value via the composer delegate specified
        
        :param left: The left indicator for the 'composer'
        :param right: The right indidcator for the 'composoer'
        :param composer: Function used to compose the left and right indicators
        """
        ...

    def ValidateAndComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> QuantConnect.Indicators.IndicatorResult:
        """
        Computes the next value of this indicator from the given state
        and returns an instance of the IndicatorResult class
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: An IndicatorResult object including the status of the indicator.
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class IReadOnlyWindow(typing.Generic[QuantConnect_Indicators_IReadOnlyWindow_T], System.Collections.Generic.IEnumerable[QuantConnect_Indicators_IReadOnlyWindow_T], metaclass=abc.ABCMeta):
    """Interface type used to pass windows around without worry of external modification"""

    @property
    @abc.abstractmethod
    def Size(self) -> int:
        """Gets the size of this window"""
        ...

    @property
    @abc.abstractmethod
    def Count(self) -> int:
        """Gets the current number of elements in this window"""
        ...

    @property
    @abc.abstractmethod
    def Samples(self) -> float:
        """Gets the number of samples that have been added to this window over its lifetime"""
        ...

    @property
    @abc.abstractmethod
    def IsReady(self) -> bool:
        """
        Gets a value indicating whether or not this window is ready, i.e,
            it has been filled to its capacity, this is when the Size==Count
        """
        ...

    @property
    @abc.abstractmethod
    def MostRecentlyRemoved(self) -> QuantConnect_Indicators_IReadOnlyWindow_T:
        """
        Gets the most recently removed item from the window. This is the
            piece of data that just 'fell off' as a result of the most recent
            add. If no items have been removed, this will throw an exception.
        """
        ...

    def __getitem__(self, i: int) -> QuantConnect_Indicators_IReadOnlyWindow_T:
        """
        Indexes into this window, where index 0 is the most recently
            entered value
        
        :param i: the index, i
        :returns: the ith most recent entry.
        """
        ...


class WindowIndicator(typing.Generic[QuantConnect_Indicators_WindowIndicator_T], QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_WindowIndicator_T], metaclass=abc.ABCMeta):
    """Represents an indicator that acts on a rolling window of data"""

    @property
    def Period(self) -> int:
        """Gets the period of this window indicator"""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the WindowIndicator class
        
        This method is protected.
        
        :param name: The name of this indicator
        :param period: The number of data points to hold in the window
        """
        ...

    @typing.overload
    def ComputeNextValue(self, input: QuantConnect_Indicators_WindowIndicator_T) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...

    @typing.overload
    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect_Indicators_WindowIndicator_T], input: QuantConnect_Indicators_WindowIndicator_T) -> float:
        """
        Computes the next value for this indicator from the given state.
        
        This method is protected.
        
        :param window: The window of data held in this indicator
        :param input: The input value to this indicator on this time step
        :returns: A new value for this indicator.
        """
        ...


class Minimum(QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """Represents an indicator capable of tracking the minimum value and how many periods ago it occurred"""

    @property
    def PeriodsSinceMinimum(self) -> int:
        """The number of periods since the minimum value was encountered"""
        ...

    @PeriodsSinceMinimum.setter
    def PeriodsSinceMinimum(self, value: int):
        """The number of periods since the minimum value was encountered"""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Creates a new Minimum indicator with the specified period
        
        :param period: The period over which to look back
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Creates a new Minimum indicator with the specified period
        
        :param name: The name of this indicator
        :param period: The period over which to look back
        """
        ...

    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect.Indicators.IndicatorDataPoint], input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """This method is protected."""
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class TrueRange(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the True Range (TR).
    The True Range is the greatest of the following values:
    value1 = distance from today's high to today's low.
    value2 = distance from yesterday's close to today's high.
    value3 = distance from yesterday's close to today's low.
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self) -> None:
        """Initializes a new instance of the TrueRange class using the specified name."""
        ...

    @typing.overload
    def __init__(self, name: str) -> None:
        """
        Initializes a new instance of the TrueRange class using the specified name.
        
        :param name: The name of this indicator
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class AdvanceDeclineIndicator(QuantConnect.Indicators.TradeBarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider, metaclass=abc.ABCMeta):
    """
    The advance-decline indicator compares the number of stocks
    that closed higher against the number of stocks
    that closed lower than their previous day's closing prices.
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    def __init__(self, name: str, compute: typing.Callable[[System.Collections.Generic.IEnumerable[QuantConnect.Data.Market.TradeBar]], float]) -> None:
        """Initializes a new instance of the AdvanceDeclineRatio class"""
        ...

    def AddStock(self, symbol: typing.Union[QuantConnect.Symbol, str]) -> None:
        """
        Add tracking stock issue
        
        :param symbol: tracking stock issue
        """
        ...

    def RemoveStock(self, symbol: typing.Union[QuantConnect.Symbol, str]) -> None:
        """
        Remove tracking stock issue
        
        :param symbol: tracking stock issue
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.TradeBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def ValidateAndComputeNextValue(self, input: QuantConnect.Data.Market.TradeBar) -> QuantConnect.Indicators.IndicatorResult:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class AdvanceDeclineRatio(QuantConnect.Indicators.AdvanceDeclineIndicator):
    """
    The advance-decline ratio (ADR) compares the number of stocks
    that closed higher against the number of stocks
    that closed lower than their previous day's closing prices.
    """

    def __init__(self, name: str) -> None:
        """Initializes a new instance of the AdvanceDeclineRatio class"""
        ...


class RateOfChange(QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the n-period rate of change in a value using the following:
    (value_0 - value_n) / value_n
    """

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Creates a new RateOfChange indicator with the specified period
        
        :param period: The period over which to perform to computation
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Creates a new RateOfChange indicator with the specified period
        
        :param name: The name of this indicator
        :param period: The period over which to perform to computation
        """
        ...

    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect.Indicators.IndicatorDataPoint], input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value for this indicator from the given state.
        
        This method is protected.
        
        :param window: The window of data held in this indicator
        :param input: The input value to this indicator on this time step
        :returns: A new value for this indicator.
        """
        ...


class RateOfChangeRatio(QuantConnect.Indicators.RateOfChange):
    """
    This indicator computes the Rate Of Change Ratio (ROCR).
    The Rate Of Change Ratio is calculated with the following formula:
    ROCR = price / prevPrice
    """

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the RateOfChangeRatio class using the specified name and period.
        
        :param name: The name of this indicator
        :param period: The period of the ROCR
        """
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the RateOfChangeRatio class using the specified period.
        
        :param period: The period of the ROCR
        """
        ...

    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect.Indicators.IndicatorDataPoint], input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value for this indicator from the given state.
        
        This method is protected.
        
        :param window: The window of data held in this indicator
        :param input: The input value to this indicator on this time step
        :returns: A new value for this indicator.
        """
        ...


class RateOfChangePercent(QuantConnect.Indicators.RateOfChange):
    """
    This indicator computes the n-period percentage rate of change in a value using the following:
    100 * (value_0 - value_n) / value_n
    """

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Creates a new RateOfChangePercent indicator with the specified period
        
        :param period: The period over which to perform to computation
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Creates a new RateOfChangePercent indicator with the specified period
        
        :param name: The name of this indicator
        :param period: The period over which to perform to computation
        """
        ...

    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect.Indicators.IndicatorDataPoint], input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value for this indicator from the given state.
        
        This method is protected.
        
        :param window: The window of data held in this indicator
        :param input: The input value to this indicator on this time step
        :returns: A new value for this indicator.
        """
        ...


class IchimokuKinkoHyo(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the Ichimoku Kinko Hyo indicator. It consists of the following main indicators:
    Tenkan-sen: (Highest High + Lowest Low) / 2 for the specific period (normally 9)
    Kijun-sen: (Highest High + Lowest Low) / 2 for the specific period (normally 26)
    Senkou A Span: (Tenkan-sen + Kijun-sen )/ 2 from a specific number of periods ago (normally 26)
    Senkou B Span: (Highest High + Lowest Low) / 2 for the specific period (normally 52), from a specific number of periods ago (normally 26)
    """

    @property
    def Tenkan(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """The Tenkan-sen component of the Ichimoku indicator"""
        ...

    @property
    def Kijun(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """The Kijun-sen component of the Ichimoku indicator"""
        ...

    @property
    def SenkouA(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """The Senkou A Span component of the Ichimoku indicator"""
        ...

    @property
    def SenkouB(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """The Senkou B Span component of the Ichimoku indicator"""
        ...

    @property
    def Chikou(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """The Chikou Span component of the Ichimoku indicator"""
        ...

    @property
    def TenkanMaximum(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """The Tenkan-sen Maximum component of the Ichimoku indicator"""
        ...

    @property
    def TenkanMinimum(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """The Tenkan-sen Minimum component of the Ichimoku indicator"""
        ...

    @property
    def KijunMaximum(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """The Kijun-sen Maximum component of the Ichimoku indicator"""
        ...

    @property
    def KijunMinimum(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """The Kijun-sen Minimum component of the Ichimoku indicator"""
        ...

    @property
    def SenkouBMaximum(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """The Senkou B Maximum component of the Ichimoku indicator"""
        ...

    @property
    def SenkouBMinimum(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """The Senkou B Minimum component of the Ichimoku indicator"""
        ...

    @property
    def DelayedTenkanSenkouA(self) -> QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint]:
        """The Delayed Tenkan Senkou A component of the Ichimoku indicator"""
        ...

    @property
    def DelayedKijunSenkouA(self) -> QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint]:
        """The Delayed Kijun Senkou A component of the Ichimoku indicator"""
        ...

    @property
    def DelayedMaximumSenkouB(self) -> QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint]:
        """The Delayed Maximum Senkou B component of the Ichimoku indicator"""
        ...

    @property
    def DelayedMinimumSenkouB(self) -> QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint]:
        """The Delayed Minimum Senkou B component of the Ichimoku indicator"""
        ...

    @property
    def IsReady(self) -> bool:
        """Returns true if all of the sub-components of the Ichimoku indicator is ready"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, tenkanPeriod: int = 9, kijunPeriod: int = 26, senkouAPeriod: int = 26, senkouBPeriod: int = 52, senkouADelayPeriod: int = 26, senkouBDelayPeriod: int = 26) -> None:
        """
        Creates a new IchimokuKinkoHyo indicator from the specific periods
        
        :param tenkanPeriod: The Tenkan-sen period
        :param kijunPeriod: The Kijun-sen period
        :param senkouAPeriod: The Senkou A Span period
        :param senkouBPeriod: The Senkou B Span period
        :param senkouADelayPeriod: The Senkou A Span delay
        :param senkouBDelayPeriod: The Senkou B Span delay
        """
        ...

    @typing.overload
    def __init__(self, name: str, tenkanPeriod: int = 9, kijunPeriod: int = 26, senkouAPeriod: int = 26, senkouBPeriod: int = 52, senkouADelayPeriod: int = 26, senkouBDelayPeriod: int = 26) -> None:
        """
        Creates a new IchimokuKinkoHyo indicator from the specific periods
        
        :param name: The name of this indicator
        :param tenkanPeriod: The Tenkan-sen period
        :param kijunPeriod: The Kijun-sen period
        :param senkouAPeriod: The Senkou A Span period
        :param senkouBPeriod: The Senkou B Span period
        :param senkouADelayPeriod: The Senkou A Span delay
        :param senkouBDelayPeriod: The Senkou B Span delay
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class WilderMovingAverage(QuantConnect.Indicators.Indicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    Represents the moving average indicator defined by Welles Wilder in his book:
    New Concepts in Technical Trading Systems.
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the WilderMovingAverage class with the specified name and period
        
        :param name: The name of this indicator
        :param period: The period of the Wilder Moving Average
        """
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the WilderMovingAverage class with the default name and period
        
        :param period: The period of the Wilder Moving Average
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class DetrendedPriceOscillator(QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    The Detrended Price Oscillator is an indicator designed to remove trend from price
    and make it easier to identify cycles.
    DPO does not extend to the last date because it is based on a displaced moving average.
    Is estimated as Price {X/2 + 1} periods ago less the X-period simple moving average.
    E.g.DPO(20) equals price 11 days ago less the 20-day SMA.
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the DetrendedPriceOscillator class.
        
        :param name: The name for the indicator.
        :param period: The number of periods to calculate the DPO.
        """
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the DetrendedPriceOscillator class.
        
        :param period: The number of periods to calculate the DPO.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class PythonIndicator(QuantConnect.Indicators.IndicatorBase[QuantConnect.Data.IBaseData]):
    """Provides a wrapper for IndicatorBase{IBaseData} implementations written in python"""

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @typing.overload
    def __init__(self) -> None:
        """Initializes a new instance of the PythonIndicator class using the specified name."""
        ...

    @typing.overload
    def __init__(self, *args: PyObject) -> None:
        """Initializes a new instance of the PythonIndicator class using the specified name."""
        ...

    @typing.overload
    def __init__(self, indicator: typing.Any) -> None:
        """
        Initializes a new instance of the PythonIndicator class using the specified name.
        
        :param indicator: The python implementation of IndicatorBase{IBaseDataBar}
        """
        ...

    def SetIndicator(self, indicator: typing.Any) -> None:
        """
        Sets the python implementation of the indicator
        
        :param indicator: The python implementation of IndicatorBase{IBaseDataBar}
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.IBaseData) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class MovingAverageType(System.Enum):
    """Defines the different types of moving averages"""

    Simple = 0
    """An unweighted, arithmetic mean"""

    Exponential = 1
    """The standard exponential moving average, using a smoothing factor of 2/(n+1)"""

    Wilders = 2
    """An exponential moving average, using a smoothing factor of 1/n and simple moving average as seeding"""

    LinearWeightedMovingAverage = 3
    """A weighted moving average type"""

    DoubleExponential = 4
    """The double exponential moving average"""

    TripleExponential = 5
    """The triple exponential moving average"""

    Triangular = 6
    """The triangular moving average"""

    T3 = 7
    """The T3 moving average"""

    Kama = 8
    """The Kaufman Adaptive Moving Average"""

    Hull = 9
    """The Hull Moving Average"""

    Alma = 10
    """The Arnaud Legoux Moving Average"""


class MovingAverageConvergenceDivergence(QuantConnect.Indicators.Indicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator creates two moving averages defined on a base indicator and produces the difference
    between the fast and slow averages.
    """

    @property
    def Fast(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the fast average indicator"""
        ...

    @property
    def Slow(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the slow average indicator"""
        ...

    @property
    def Signal(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the signal of the MACD"""
        ...

    @property
    def Histogram(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """
        Developed by Thomas Aspray in 1986, the MACD-Histogram measures the distance between MACD and its signal line,
        is an oscillator that fluctuates above and below the zero line.
        Bullish or bearish divergences in the MACD-Histogram can alert chartists to an imminent signal line crossover in MACD.
        """
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, fastPeriod: int, slowPeriod: int, signalPeriod: int, type: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Creates a new MACD with the specified parameters
        
        :param fastPeriod: The fast moving average period
        :param slowPeriod: The slow moving average period
        :param signalPeriod: The signal period
        :param type: The type of moving averages to use
        """
        ...

    @typing.overload
    def __init__(self, name: str, fastPeriod: int, slowPeriod: int, signalPeriod: int, type: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Creates a new MACD with the specified parameters
        
        :param name: The name of this indicator
        :param fastPeriod: The fast moving average period
        :param slowPeriod: The slow moving average period
        :param signalPeriod: The signal period
        :param type: The type of moving averages to use
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class AbsolutePriceOscillator(QuantConnect.Indicators.MovingAverageConvergenceDivergence):
    """
    This indicator computes the Absolute Price Oscillator (APO)
    The Absolute Price Oscillator is calculated using the following formula:
    APO[i] = FastMA[i] - SlowMA[i]
    """

    @typing.overload
    def __init__(self, name: str, fastPeriod: int, slowPeriod: int, movingAverageType: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Initializes a new instance of the AbsolutePriceOscillator class using the specified name and parameters.
        
        :param name: The name of this indicator
        :param fastPeriod: The fast moving average period
        :param slowPeriod: The slow moving average period
        :param movingAverageType: The type of moving average to use
        """
        ...

    @typing.overload
    def __init__(self, fastPeriod: int, slowPeriod: int, movingAverageType: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Initializes a new instance of the AbsolutePriceOscillator class using the specified parameters.
        
        :param fastPeriod: The fast moving average period
        :param slowPeriod: The slow moving average period
        :param movingAverageType: The type of moving average to use
        """
        ...


class PercentagePriceOscillator(QuantConnect.Indicators.AbsolutePriceOscillator):
    """
    This indicator computes the Percentage Price Oscillator (PPO)
    The Percentage Price Oscillator is calculated using the following formula:
    PPO[i] = 100 * (FastMA[i] - SlowMA[i]) / SlowMA[i]
    """

    @typing.overload
    def __init__(self, name: str, fastPeriod: int, slowPeriod: int, movingAverageType: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Initializes a new instance of the PercentagePriceOscillator class using the specified name and parameters.
        
        :param name: The name of this indicator
        :param fastPeriod: The fast moving average period
        :param slowPeriod: The slow moving average period
        :param movingAverageType: The type of moving average to use
        """
        ...

    @typing.overload
    def __init__(self, fastPeriod: int, slowPeriod: int, movingAverageType: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Initializes a new instance of the PercentagePriceOscillator class using the specified parameters.
        
        :param fastPeriod: The fast moving average period
        :param slowPeriod: The slow moving average period
        :param movingAverageType: The type of moving average to use
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class CommodityChannelIndex(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    Represents the traditional commodity channel index (CCI)
    
    CCI = (Typical Price - 20-period SMA of TP) / (.015 * Mean Deviation)
    Typical Price (TP) = (High + Low + Close)/3
    Constant = 0.015
    
    There are four steps to calculating the Mean Deviation, first, subtract
    the most recent 20-period average of the typical price from each period's
    typical price. Second, take the absolute values of these numbers. Third,
    sum the absolute values. Fourth, divide by the total number of periods (20).
    """

    @property
    def MovingAverageType(self) -> int:
        """
        Gets the type of moving average
        
        This property contains the int value of a member of the QuantConnect.Indicators.MovingAverageType enum.
        """
        ...

    @property
    def TypicalPriceAverage(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Keep track of the simple moving average of the typical price"""
        ...

    @property
    def TypicalPriceMeanDeviation(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Keep track of the mean absolute deviation of the typical price"""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int, movingAverageType: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Initializes a new instance of the CommodityChannelIndex class
        
        :param period: The period of the standard deviation and moving average (middle band)
        :param movingAverageType: The type of moving average to be used
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int, movingAverageType: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Initializes a new instance of the CommodityChannelIndex class
        
        :param name: The name of this indicator
        :param period: The period of the standard deviation and moving average (middle band)
        :param movingAverageType: The type of moving average to be used
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class MoneyFlowIndex(QuantConnect.Indicators.TradeBarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    The Money Flow Index (MFI) is an oscillator that uses both price and volume to
    measure buying and selling pressure
    
    Typical Price = (High + Low + Close)/3
    Money Flow = Typical Price x Volume
    Positive Money Flow = Sum of the money flows of all days where the typical
        price is greater than the previous day's typical price
    Negative Money Flow = Sum of the money flows of all days where the typical
        price is less than the previous day's typical price
    Money Flow Ratio = (14-period Positive Money Flow)/(14-period Negative Money Flow)
    
    Money Flow Index = 100 x  Positive Money Flow / ( Positive Money Flow + Negative Money Flow)
    """

    @property
    def PositiveMoneyFlow(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """The sum of positive money flow to compute money flow ratio"""
        ...

    @property
    def NegativeMoneyFlow(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """The sum of negative money flow to compute money flow ratio"""
        ...

    @property
    def PreviousTypicalPrice(self) -> float:
        """The current and previous typical price is used to determine positive or negative money flow"""
        ...

    @PreviousTypicalPrice.setter
    def PreviousTypicalPrice(self, value: float):
        """The current and previous typical price is used to determine positive or negative money flow"""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the MoneyFlowIndex class
        
        :param period: The period of the negative and positive money flow
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the MoneyFlowIndex class
        
        :param name: The name of this indicator
        :param period: The period of the negative and positive money flow
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.TradeBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class LeastSquaresMovingAverage(QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    The Least Squares Moving Average (LSMA) first calculates a least squares regression line
    over the preceding time periods, and then projects it forward to the current period. In
    essence, it calculates what the value would be if the regression line continued.
    Source: https://rtmath.net/helpFinAnalysis/html/b3fab79c-f4b2-40fb-8709-fdba43cdb363.htm
    """

    @property
    def Intercept(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """The point where the regression line crosses the y-axis (price-axis)"""
        ...

    @property
    def Slope(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """The regression line slope"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the LeastSquaresMovingAverage class.
        
        :param name: The name of this indicator
        :param period: The number of data points to hold in the window
        """
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the LeastSquaresMovingAverage class.
        
        :param period: The number of data points to hold in the window.
        """
        ...

    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect.Indicators.IndicatorDataPoint], input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator and all sub-indicators (Intercept, Slope)"""
        ...


class RegressionChannel(QuantConnect.Indicators.Indicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    The Regression Channel indicator extends the LeastSquaresMovingAverage
    with the inclusion of two (upper and lower) channel lines that are distanced from
    the linear regression line by a user defined number of standard deviations.
    Reference: http://www.onlinetradingconcepts.com/TechnicalAnalysis/LinRegChannel.html
    """

    @property
    def LinearRegression(self) -> QuantConnect.Indicators.LeastSquaresMovingAverage:
        """Gets the linear regression"""
        ...

    @property
    def UpperChannel(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the upper channel (linear regression + k * stdDev)"""
        ...

    @property
    def LowerChannel(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the lower channel (linear regression - k * stdDev)"""
        ...

    @property
    def Intercept(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """The point where the regression line crosses the y-axis (price-axis)"""
        ...

    @property
    def Slope(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """The regression line slope"""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int, k: float) -> None:
        """
        Initializes a new instance of the RegressionChannel class.
        
        :param name: The name of this indicator
        :param period: The number of data points to hold in the window
        :param k: The number of standard deviations specifying the distance between the linear regression and upper or lower channel lines
        """
        ...

    @typing.overload
    def __init__(self, period: int, k: float) -> None:
        """
        Initializes a new instance of the LeastSquaresMovingAverage class.
        
        :param period: The number of data points to hold in the window.
        :param k: The number of standard deviations specifying the distance between the linear regression and upper or lower channel lines
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator and all sub-indicators (StandardDeviation, LowerBand, MiddleBand, UpperBand)"""
        ...


class BollingerBands(QuantConnect.Indicators.Indicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator creates a moving average (middle band) with an upper band and lower band
    fixed at k standard deviations above and below the moving average.
    """

    @property
    def MovingAverageType(self) -> int:
        """
        Gets the type of moving average
        
        This property contains the int value of a member of the QuantConnect.Indicators.MovingAverageType enum.
        """
        ...

    @property
    def StandardDeviation(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the standard deviation"""
        ...

    @property
    def MiddleBand(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the middle Bollinger band (moving average)"""
        ...

    @property
    def UpperBand(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the upper Bollinger band (middleBand + k * stdDev)"""
        ...

    @property
    def LowerBand(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the lower Bollinger band (middleBand - k * stdDev)"""
        ...

    @property
    def BandWidth(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """
        Gets the Bollinger BandWidth indicator
        BandWidth = ((Upper Band - Lower Band) / Middle Band) * 100
        """
        ...

    @property
    def PercentB(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """
        Gets the Bollinger %B
        %B = (Price - Lower Band)/(Upper Band - Lower Band)
        """
        ...

    @property
    def Price(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the Price level"""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int, k: float, movingAverageType: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Initializes a new instance of the BollingerBands class
        
        :param period: The period of the standard deviation and moving average (middle band)
        :param k: The number of standard deviations specifying the distance between the middle band and upper or lower bands
        :param movingAverageType: The type of moving average to be used
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int, k: float, movingAverageType: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Initializes a new instance of the BollingerBands class
        
        :param name: The name of this indicator
        :param period: The period of the standard deviation and moving average (middle band)
        :param k: The number of standard deviations specifying the distance between the middle band and upper or lower bands
        :param movingAverageType: The type of moving average to be used
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of the following sub-indicators from the given state:
        StandardDeviation, MiddleBand, UpperBand, LowerBand, BandWidth, %B
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: The input is returned unmodified.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator and all sub-indicators (StandardDeviation, LowerBand, MiddleBand, UpperBand, BandWidth, %B)"""
        ...


class Delay(QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """An indicator that delays its input for a certain period"""

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Creates a new Delay indicator that delays its input by the specified period
        
        :param period: The period to delay input, must be greater than zero
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Creates a new Delay indicator that delays its input by the specified period
        
        :param name: Name of the delay window indicator
        :param period: The period to delay input, must be greater than zero
        """
        ...

    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect.Indicators.IndicatorDataPoint], input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value for this indicator from the given state.
        
        This method is protected.
        
        :param window: The window of data held in this indicator
        :param input: The input value to this indicator on this time step
        :returns: A new value for this indicator.
        """
        ...


class NormalizedAverageTrueRange(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the Normalized Average True Range (NATR).
    The Normalized Average True Range is calculated with the following formula:
    NATR = (ATR(period) / Close) * 100
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the NormalizedAverageTrueRange class using the specified name and period.
        
        :param name: The name of this indicator
        :param period: The period of the NATR
        """
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the NormalizedAverageTrueRange class using the specified period.
        
        :param period: The period of the NATR
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class ExponentialMovingAverage(QuantConnect.Indicators.Indicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """Represents the traditional exponential moving average indicator (EMA)"""

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the ExponentialMovingAverage class with the specified name and period
        
        :param name: The name of this indicator
        :param period: The period of the EMA
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int, smoothingFactor: float) -> None:
        """
        Initializes a new instance of the ExponentialMovingAverage class with the specified name and period
        
        :param name: The name of this indicator
        :param period: The period of the EMA
        :param smoothingFactor: The percentage of data from the previous value to be carried into the next value
        """
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the ExponentialMovingAverage class with the default name and period
        
        :param period: The period of the EMA
        """
        ...

    @typing.overload
    def __init__(self, period: int, smoothingFactor: float) -> None:
        """
        Initializes a new instance of the ExponentialMovingAverage class with the default name and period
        
        :param period: The period of the EMA
        :param smoothingFactor: The percentage of data from the previous value to be carried into the next value
        """
        ...

    @staticmethod
    def SmoothingFactorDefault(period: int) -> float:
        """
        Calculates the default smoothing factor for an ExponentialMovingAverage indicator
        
        :param period: The period of the EMA
        :returns: The default smoothing factor.
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class Maximum(QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """Represents an indicator capable of tracking the maximum value and how many periods ago it occurred"""

    @property
    def PeriodsSinceMaximum(self) -> int:
        """The number of periods since the maximum value was encountered"""
        ...

    @PeriodsSinceMaximum.setter
    def PeriodsSinceMaximum(self, value: int):
        """The number of periods since the maximum value was encountered"""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Creates a new Maximum indicator with the specified period
        
        :param period: The period over which to look back
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Creates a new Maximum indicator with the specified period
        
        :param name: The name of this indicator
        :param period: The period over which to look back
        """
        ...

    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect.Indicators.IndicatorDataPoint], input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """This method is protected."""
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class SimpleMovingAverage(QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """Represents the traditional simple moving average indicator (SMA)"""

    @property
    def RollingSum(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """A rolling sum for computing the average for the given period"""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the SimpleMovingAverage class with the specified name and period
        
        :param name: The name of this indicator
        :param period: The period of the SMA
        """
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the SimpleMovingAverage class with the default name and period
        
        :param period: The period of the SMA
        """
        ...

    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect.Indicators.IndicatorDataPoint], input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value for this indicator from the given state.
        
        This method is protected.
        
        :param window: The window of data held in this indicator
        :param input: The input value to this indicator on this time step
        :returns: A new value for this indicator.
        """
        ...


class IndicatorExtensions(System.Object):
    """Provides extension methods for Indicator"""

    @staticmethod
    def Update(indicator: QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint], time: datetime.datetime, value: float) -> bool:
        """
        Updates the state of this indicator with the given value and returns true
        if this indicator is ready, false otherwise
        
        :param indicator: The indicator to be updated
        :param time: The time associated with the value
        :param value: The value to use to update this indicator
        :returns: True if this indicator is ready, false otherwise.
        """
        ...

    @staticmethod
    @typing.overload
    def Of(second: QuantConnect_Indicators_IndicatorExtensions_Of_T, first: QuantConnect.Indicators.IIndicator, waitForFirstToReady: bool = True) -> QuantConnect_Indicators_IndicatorExtensions_Of_T:
        """
        Configures the second indicator to receive automatic updates from the first by attaching an event handler
        to first.DataConsolidated
        
        :param second: The indicator that receives data from the first
        :param first: The indicator that sends data via DataConsolidated even to the second
        :param waitForFirstToReady: True to only send updates to the second if first.IsReady returns true, false to always send updates to second
        :returns: The reference to the second indicator to allow for method chaining.
        """
        ...

    @staticmethod
    @typing.overload
    def WeightedBy(value: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_WeightedBy_T], weight: QuantConnect_Indicators_IndicatorExtensions_WeightedBy_TWeight, period: int) -> QuantConnect.Indicators.CompositeIndicator[QuantConnect.Indicators.IndicatorDataPoint]:
        """
        Creates a new CompositeIndicator such that the result will be average of a first indicator weighted by a second one
        
        :param value: Indicator that will be averaged
        :param weight: Indicator that provides the average weights
        :param period: Average period
        :returns: Indicator that results of the average of first by weights given by second.
        """
        ...

    @staticmethod
    @typing.overload
    def Plus(left: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_Plus_T], constant: float) -> QuantConnect.Indicators.CompositeIndicator[QuantConnect_Indicators_IndicatorExtensions_Plus_T]:
        """
        Creates a new CompositeIndicator such that the result will be the sum of the left and the constant
        
        :param left: The left indicator
        :param constant: The addend
        :returns: The sum of the left and right indicators.
        """
        ...

    @staticmethod
    @typing.overload
    def Plus(left: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_Plus_T], right: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_Plus_T]) -> QuantConnect.Indicators.CompositeIndicator[QuantConnect_Indicators_IndicatorExtensions_Plus_T]:
        """
        Creates a new CompositeIndicator such that the result will be the sum of the left and right
        
        :param left: The left indicator
        :param right: The right indicator
        :returns: The sum of the left and right indicators.
        """
        ...

    @staticmethod
    @typing.overload
    def Plus(left: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_Plus_T], right: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_Plus_T], name: str) -> QuantConnect.Indicators.CompositeIndicator[QuantConnect_Indicators_IndicatorExtensions_Plus_T]:
        """
        Creates a new CompositeIndicator such that the result will be the sum of the left and right
        
        :param left: The left indicator
        :param right: The right indicator
        :param name: The name of this indicator
        :returns: The sum of the left and right indicators.
        """
        ...

    @staticmethod
    @typing.overload
    def Minus(left: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_Minus_T], constant: float) -> QuantConnect.Indicators.CompositeIndicator[QuantConnect_Indicators_IndicatorExtensions_Minus_T]:
        """
        Creates a new CompositeIndicator such that the result will be the difference of the left and constant
        
        :param left: The left indicator
        :param constant: The subtrahend
        :returns: The difference of the left and right indicators.
        """
        ...

    @staticmethod
    @typing.overload
    def Minus(left: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_Minus_T], right: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_Minus_T]) -> QuantConnect.Indicators.CompositeIndicator[QuantConnect_Indicators_IndicatorExtensions_Minus_T]:
        """
        Creates a new CompositeIndicator such that the result will be the difference of the left and right
        
        :param left: The left indicator
        :param right: The right indicator
        :returns: The difference of the left and right indicators.
        """
        ...

    @staticmethod
    @typing.overload
    def Minus(left: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_Minus_T], right: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_Minus_T], name: str) -> QuantConnect.Indicators.CompositeIndicator[QuantConnect_Indicators_IndicatorExtensions_Minus_T]:
        """
        Creates a new CompositeIndicator such that the result will be the difference of the left and right
        
        :param left: The left indicator
        :param right: The right indicator
        :param name: The name of this indicator
        :returns: The difference of the left and right indicators.
        """
        ...

    @staticmethod
    @typing.overload
    def Over(left: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_Over_T], constant: float) -> QuantConnect.Indicators.CompositeIndicator[QuantConnect_Indicators_IndicatorExtensions_Over_T]:
        """
        Creates a new CompositeIndicator such that the result will be the ratio of the left to the constant
        
        :param left: The left indicator
        :param constant: The constant value denominator
        :returns: The ratio of the left to the right indicator.
        """
        ...

    @staticmethod
    @typing.overload
    def Over(left: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_Over_T], right: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_Over_T]) -> QuantConnect.Indicators.CompositeIndicator[QuantConnect_Indicators_IndicatorExtensions_Over_T]:
        """
        Creates a new CompositeIndicator such that the result will be the ratio of the left to the right
        
        :param left: The left indicator
        :param right: The right indicator
        :returns: The ratio of the left to the right indicator.
        """
        ...

    @staticmethod
    @typing.overload
    def Over(left: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_Over_T], right: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_Over_T], name: str) -> QuantConnect.Indicators.CompositeIndicator[QuantConnect_Indicators_IndicatorExtensions_Over_T]:
        """
        Creates a new CompositeIndicator such that the result will be the ratio of the left to the right
        
        :param left: The left indicator
        :param right: The right indicator
        :param name: The name of this indicator
        :returns: The ratio of the left to the right indicator.
        """
        ...

    @staticmethod
    @typing.overload
    def Times(left: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_Times_T], constant: float) -> QuantConnect.Indicators.CompositeIndicator[QuantConnect_Indicators_IndicatorExtensions_Times_T]:
        """
        Creates a new CompositeIndicator such that the result will be the product of the left and the constant
        
        :param left: The left indicator
        :param constant: The constant value to multiple by
        :returns: The product of the left to the right indicators.
        """
        ...

    @staticmethod
    @typing.overload
    def Times(left: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_Times_T], right: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_Times_T]) -> QuantConnect.Indicators.CompositeIndicator[QuantConnect_Indicators_IndicatorExtensions_Times_T]:
        """
        Creates a new CompositeIndicator such that the result will be the product of the left to the right
        
        :param left: The left indicator
        :param right: The right indicator
        :returns: The product of the left to the right indicators.
        """
        ...

    @staticmethod
    @typing.overload
    def Times(left: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_Times_T], right: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_Times_T], name: str) -> QuantConnect.Indicators.CompositeIndicator[QuantConnect_Indicators_IndicatorExtensions_Times_T]:
        """
        Creates a new CompositeIndicator such that the result will be the product of the left to the right
        
        :param left: The left indicator
        :param right: The right indicator
        :param name: The name of this indicator
        :returns: The product of the left to the right indicators.
        """
        ...

    @staticmethod
    @typing.overload
    def EMA(left: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_EMA_T], period: int, smoothingFactor: typing.Optional[float] = None, waitForFirstToReady: bool = True) -> QuantConnect.Indicators.ExponentialMovingAverage:
        """
        Creates a new ExponentialMovingAverage indicator with the specified period and smoothingFactor from the left indicator
        
        :param left: The ExponentialMovingAverage indicator will be created using the data from left
        :param period: The period of the ExponentialMovingAverage indicators
        :param smoothingFactor: The percentage of data from the previous value to be carried into the next value
        :param waitForFirstToReady: True to only send updates to the second if left.IsReady returns true, false to always send updates
        :returns: A reference to the ExponentialMovingAverage indicator to allow for method chaining.
        """
        ...

    @staticmethod
    @typing.overload
    def MAX(left: QuantConnect.Indicators.IIndicator, period: int, waitForFirstToReady: bool = True) -> QuantConnect.Indicators.Maximum:
        """
        Creates a new Maximum indicator with the specified period from the left indicator
        
        :param left: The Maximum indicator will be created using the data from left
        :param period: The period of the Maximum indicator
        :param waitForFirstToReady: True to only send updates to the second if left.IsReady returns true, false to always send updates
        :returns: A reference to the Maximum indicator to allow for method chaining.
        """
        ...

    @staticmethod
    @typing.overload
    def MIN(left: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_MIN_T], period: int, waitForFirstToReady: bool = True) -> QuantConnect.Indicators.Minimum:
        """
        Creates a new Minimum indicator with the specified period from the left indicator
        
        :param left: The Minimum indicator will be created using the data from left
        :param period: The period of the Minimum indicator
        :param waitForFirstToReady: True to only send updates to the second if left.IsReady returns true, false to always send updates
        :returns: A reference to the Minimum indicator to allow for method chaining.
        """
        ...

    @staticmethod
    @typing.overload
    def SMA(left: QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_IndicatorExtensions_SMA_T], period: int, waitForFirstToReady: bool = True) -> QuantConnect.Indicators.SimpleMovingAverage:
        """
        Initializes a new instance of the SimpleMovingAverage class with the specified name and period from the left indicator
        
        :param left: The SimpleMovingAverage indicator will be created using the data from left
        :param period: The period of the SMA
        :param waitForFirstToReady: True to only send updates to the second if first.IsReady returns true, false to always send updates to second
        :returns: The reference to the SimpleMovingAverage indicator to allow for method chaining.
        """
        ...

    @staticmethod
    @typing.overload
    def Of(second: typing.Any, first: typing.Any, waitForFirstToReady: bool = True) -> System.Object:
        ...

    @staticmethod
    @typing.overload
    def WeightedBy(value: typing.Any, weight: typing.Any, period: int) -> QuantConnect.Indicators.CompositeIndicator[QuantConnect.Indicators.IndicatorDataPoint]:
        """
        Creates a new CompositeIndicator such that the result will be average of a first indicator weighted by a second one
        
        :param value: Indicator that will be averaged
        :param weight: Indicator that provides the average weights
        :param period: Average period
        :returns: Indicator that results of the average of first by weights given by second.
        """
        ...

    @staticmethod
    @typing.overload
    def EMA(left: typing.Any, period: int, smoothingFactor: typing.Optional[float] = None, waitForFirstToReady: bool = True) -> QuantConnect.Indicators.ExponentialMovingAverage:
        """
        Creates a new ExponentialMovingAverage indicator with the specified period and smoothingFactor from the left indicator
        
        :param left: The ExponentialMovingAverage indicator will be created using the data from left
        :param period: The period of the ExponentialMovingAverage indicators
        :param smoothingFactor: The percentage of data from the previous value to be carried into the next value
        :param waitForFirstToReady: True to only send updates to the second if left.IsReady returns true, false to always send updates
        :returns: A reference to the ExponentialMovingAverage indicator to allow for method chaining.
        """
        ...

    @staticmethod
    @typing.overload
    def MAX(left: typing.Any, period: int, waitForFirstToReady: bool = True) -> QuantConnect.Indicators.Maximum:
        """
        Creates a new Maximum indicator with the specified period from the left indicator
        
        :param left: The Maximum indicator will be created using the data from left
        :param period: The period of the Maximum indicator
        :param waitForFirstToReady: True to only send updates to the second if left.IsReady returns true, false to always send updates
        :returns: A reference to the Maximum indicator to allow for method chaining.
        """
        ...

    @staticmethod
    @typing.overload
    def MIN(left: typing.Any, period: int, waitForFirstToReady: bool = True) -> QuantConnect.Indicators.Minimum:
        """
        Creates a new Minimum indicator with the specified period from the left indicator
        
        :param left: The Minimum indicator will be created using the data from left
        :param period: The period of the Minimum indicator
        :param waitForFirstToReady: True to only send updates to the second if left.IsReady returns true, false to always send updates
        :returns: A reference to the Minimum indicator to allow for method chaining.
        """
        ...

    @staticmethod
    @typing.overload
    def SMA(left: typing.Any, period: int, waitForFirstToReady: bool = True) -> QuantConnect.Indicators.SimpleMovingAverage:
        """
        Initializes a new instance of the SimpleMovingAverage class with the specified name and period from the left indicator
        
        :param left: The SimpleMovingAverage indicator will be created using the data from left
        :param period: The period of the SMA
        :param waitForFirstToReady: True to only send updates to the second if first.IsReady returns true, false to always send updates to second
        :returns: The reference to the SimpleMovingAverage indicator to allow for method chaining.
        """
        ...

    @staticmethod
    @typing.overload
    def Over(left: typing.Any, constant: float) -> System.Object:
        """
        Creates a new CompositeIndicator such that the result will be the ratio of the left to the constant
        
        :param left: The left indicator
        :param constant: The constant value denominator
        :returns: The ratio of the left to the right indicator.
        """
        ...

    @staticmethod
    @typing.overload
    def Over(left: typing.Any, right: typing.Any, name: str = ...) -> System.Object:
        """
        Creates a new CompositeIndicator such that the result will be the ratio of the left to the right
        
        :param left: The left indicator
        :param right: The right indicator
        :param name: The name of this indicator
        :returns: The ratio of the left to the right indicator.
        """
        ...

    @staticmethod
    @typing.overload
    def Minus(left: typing.Any, constant: float) -> System.Object:
        """
        Creates a new CompositeIndicator such that the result will be the difference of the left and constant
        
        :param left: The left indicator
        :param constant: The subtrahend
        :returns: The difference of the left and right indicators.
        """
        ...

    @staticmethod
    @typing.overload
    def Minus(left: typing.Any, right: typing.Any, name: str = ...) -> System.Object:
        """
        Creates a new CompositeIndicator such that the result will be the difference of the left and right
        
        :param left: The left indicator
        :param right: The right indicator
        :param name: The name of this indicator
        :returns: The difference of the left and right indicators.
        """
        ...

    @staticmethod
    @typing.overload
    def Times(left: typing.Any, constant: float) -> System.Object:
        """
        Creates a new CompositeIndicator such that the result will be the product of the left and the constant
        
        :param left: The left indicator
        :param constant: The constant value to multiple by
        :returns: The product of the left to the right indicators.
        """
        ...

    @staticmethod
    @typing.overload
    def Times(left: typing.Any, right: typing.Any, name: str = ...) -> System.Object:
        """
        Creates a new CompositeIndicator such that the result will be the product of the left to the right
        
        :param left: The left indicator
        :param right: The right indicator
        :param name: The name of this indicator
        :returns: The product of the left to the right indicators.
        """
        ...

    @staticmethod
    @typing.overload
    def Plus(left: typing.Any, constant: float) -> System.Object:
        """
        Creates a new CompositeIndicator such that the result will be the sum of the left and the constant
        
        :param left: The left indicator
        :param constant: The addend
        :returns: The sum of the left and right indicators.
        """
        ...

    @staticmethod
    @typing.overload
    def Plus(left: typing.Any, right: typing.Any, name: str = ...) -> System.Object:
        """
        Creates a new CompositeIndicator such that the result will be the sum of the left and right
        
        :param left: The left indicator
        :param right: The right indicator
        :param name: The name of this indicator
        :returns: The sum of the left and right indicators.
        """
        ...


class FilteredIdentity(QuantConnect.Indicators.IndicatorBase[QuantConnect.Data.IBaseData]):
    """
    Represents an indicator that is a ready after ingesting a single sample and
    always returns the same value as it is given if it passes a filter condition
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    def __init__(self, name: str, filter: typing.Callable[[QuantConnect.Data.IBaseData], bool]) -> None:
        """
        Initializes a new instance of the FilteredIdentity indicator with the specified name
        
        :param name: The name of the indicator
        :param filter: Filters the IBaseData send into the indicator, if null defaults to true (x => true) which means no filter
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.IBaseData) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class VolumeWeightedAveragePriceIndicator(QuantConnect.Indicators.TradeBarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    Volume Weighted Average Price (VWAP) Indicator:
    It is calculated by adding up the dollars traded for every transaction (price multiplied
    by number of shares traded) and then dividing by the total shares traded for the day.
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the VWAP class with the default name and period
        
        :param period: The period of the VWAP
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the VWAP class with a given name and period
        
        :param name: string - the name of the indicator
        :param period: The period of the VWAP
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.TradeBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def GetTimeWeightedAveragePrice(self, input: QuantConnect.Data.Market.TradeBar) -> float:
        """
        Gets an estimated average price to use for the interval covered by the input trade bar.
        
        This method is protected.
        
        :param input: The current trade bar input
        :returns: An estimated average price over the trade bar's interval.
        """
        ...


class FractalAdaptiveMovingAverage(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """The Fractal Adaptive Moving Average (FRAMA) by John Ehlers"""

    @property
    def IsReady(self) -> bool:
        """Returns whether the indicator will return valid results"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, n: int, longPeriod: int) -> None:
        """
        Initializes a new instance of the average class
        
        :param name: The name of the indicator instance
        :param n: The window period (must be even). Example value: 16
        :param longPeriod: The average period. Example value: 198
        """
        ...

    @typing.overload
    def __init__(self, n: int, longPeriod: int) -> None:
        """
        Initializes a new instance of the average class
        
        :param n: The window period (must be even). Example value: 16
        :param longPeriod: The average period. Example value: 198
        """
        ...

    @typing.overload
    def __init__(self, n: int) -> None:
        """
        Initializes a new instance of the average class
        
        :param n: The window period (must be even). Example value: 16
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the average value
        
        This method is protected.
        
        :param input: The data for the calculation
        :returns: The average value.
        """
        ...

    def Reset(self) -> None:
        """Resets the average to its initial state"""
        ...


class WilliamsPercentR(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    Williams %R, or just %R, is the current closing price in relation to the high and low of
    the past N days (for a given N). The value of this indicator fluctuates between -100 and 0.
    The symbol is said to be oversold when the oscillator is below -80%,
    and overbought when the oscillator is above -20%.
    """

    @property
    def Maximum(self) -> QuantConnect.Indicators.Maximum:
        """Gets the Maximum indicator"""
        ...

    @property
    def Minimum(self) -> QuantConnect.Indicators.Minimum:
        """Gets the Minimum indicator"""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Creates a new Williams %R.
        
        :param period: The look-back period to determine the Williams %R
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Creates a new Williams %R.
        
        :param name: The name of this indicator
        :param period: The look-back period to determine the Williams %R
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator and both sub-indicators (Max and Min)"""
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class SwissArmyKnifeTool(System.Enum):
    """The tools of the Swiss Army Knife. Some of the tools lend well to chaining with the "Of" Method, others may be treated as moving averages"""

    Gauss = 0
    """Two Pole Gaussian Filter"""

    Butter = 1
    """Two Pole Butterworth Filter"""

    HighPass = 2
    """High Pass Filter"""

    TwoPoleHighPass = 3
    """Two Pole High Pass Filter"""

    BandPass = 4
    """BandPass Filter"""


class SwissArmyKnife(QuantConnect.Indicators.Indicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """Swiss Army Knife indicator by John Ehlers"""

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int, delta: float, tool: QuantConnect.Indicators.SwissArmyKnifeTool) -> None:
        """Swiss Army Knife indicator by John Ehlers"""
        ...

    @typing.overload
    def __init__(self, name: str, period: int, delta: float, tool: QuantConnect.Indicators.SwissArmyKnifeTool) -> None:
        """Swiss Army Knife indicator by John Ehlers"""
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets to the initial state"""
        ...


class Identity(QuantConnect.Indicators.Indicator):
    """
    Represents an indicator that is a ready after ingesting a single sample and
        always returns the same value as it is given.
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    def __init__(self, name: str) -> None:
        """
        Initializes a new instance of the Identity indicator with the specified name
        
        :param name: The name of the indicator
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class SharpeRatio(QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    Calculation of the Sharpe Ratio (SR) developed by William F. Sharpe.
    
    Reference: https://www.investopedia.com/articles/07/sharpe_ratio.asp
    Formula: S(x) = (Rx - Rf) / stdDev(Rx)
    Where:
    S(x) - sharpe ratio of x
    Rx - average rate of return for x
    Rf - risk-free rate
    """

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @property
    def IsReady(self) -> bool:
        """Returns whether the indicator is properly initialized with data"""
        ...

    @typing.overload
    def __init__(self, name: str, period: int, riskFreeRate: float = 0.0) -> None:
        """
        Creates a new Sharpe Ratio indicator using the specified periods
        
        :param name: The name of this indicator
        :param period: Period of historical observation for sharpe ratio calculation
        :param riskFreeRate: Risk-free rate for sharpe ratio calculation
        """
        ...

    @typing.overload
    def __init__(self, period: int, riskFreeRate: float = 0.0) -> None:
        """
        Creates a new SharpeRatio indicator using the specified periods
        
        :param period: Period of historical observation for sharpe ratio calculation
        :param riskFreeRate: Risk-free rate for sharpe ratio calculation
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value for this indicator from the given state.
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class TimeSeriesIndicator(QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider, metaclass=abc.ABCMeta):
    """The base class for any Time Series-type indicator, containing methods common to most of such models."""

    @property
    def _diffHeads(self) -> typing.List[float]:
        """
        "Integration" constants
        
        This field is protected.
        """
        ...

    @_diffHeads.setter
    def _diffHeads(self, value: typing.List[float]):
        """
        "Integration" constants
        
        This field is protected.
        """
        ...

    @property
    @abc.abstractmethod
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    def __init__(self, name: str) -> None:
        """
        A constructor for a basic Time Series indicator.
        
        This method is protected.
        
        :param name: The name of this indicator
        """
        ...

    @staticmethod
    def DifferenceSeries(d: int, series: typing.List[float], diffHeads: typing.List[float]) -> typing.List[float]:
        """
        Differences a time series d times.
        
        :param d: The differencing order
        :param series: Series to difference
        :param diffHeads: "Integration" constants
        """
        ...

    @staticmethod
    def InverseDifferencedSeries(series: typing.List[float], diffHeads: typing.List[float]) -> typing.List[float]:
        """
        Undoes the differencing of a time series which has been differenced using DifferenceSeries.
        https://github.com/statsmodels/statsmodels/blob/04f00006a7aeb1c93d6894caa420698400da6c33/statsmodels/tsa/tsatools.py#L758
        
        :param series: Series to un-difference
        :param diffHeads: Series of "integration" constants for un-differencing
        """
        ...

    @staticmethod
    def LaggedSeries(p: int, series: typing.List[float], includeT: bool = False) -> typing.List[typing.List[float]]:
        """
        Returns an array of lagged series for each of {1,...,p} lags.
        
        :param p: Max lag order
        :param series: Series to calculate the lags of
        :param includeT: Whether or not to include t with its lags in the output array
        :returns: A list such that index i returns the series for i+1 lags.
        """
        ...

    @staticmethod
    def CumulativeSum(series: System.Collections.Generic.List[float], reverse: bool = False) -> System.Collections.Generic.List[float]:
        """
        Returns a series where each spot is taken by the cumulative sum of all points up to and including
        the value at that spot in the original series.
        
        :param series: Series to cumulatively sum over.
        :param reverse: Whether to reverse the series before applying the cumulative sum.
        :returns: Cumulatively summed series.
        """
        ...


class AutoRegressiveIntegratedMovingAverage(QuantConnect.Indicators.TimeSeriesIndicator):
    """
    An Autoregressive Intergrated Moving Average (ARIMA) is a time series model which can be used to describe a set of data.
    In particular,with Xₜ representing the series, the model assumes the data are of form
    (after differencing _diffOrder times):
    
        Xₜ = c + εₜ + ΣᵢφᵢXₜ₋ᵢ +  Σᵢθᵢεₜ₋ᵢ
    
    where the first sum has an upper limit of _arOrder and the second _maOrder.
    """

    @property
    def ArParameters(self) -> typing.List[float]:
        """Fitted AR parameters (φ terms)."""
        ...

    @ArParameters.setter
    def ArParameters(self, value: typing.List[float]):
        """Fitted AR parameters (φ terms)."""
        ...

    @property
    def MaParameters(self) -> typing.List[float]:
        """Fitted MA parameters (θ terms)."""
        ...

    @MaParameters.setter
    def MaParameters(self, value: typing.List[float]):
        """Fitted MA parameters (θ terms)."""
        ...

    @property
    def Intercept(self) -> float:
        """Fitted intercept (c term)."""
        ...

    @Intercept.setter
    def Intercept(self, value: float):
        """Fitted intercept (c term)."""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @property
    def ArResidualError(self) -> float:
        """The variance of the residuals (Var(ε)) from the first step of TwoStepFit."""
        ...

    @ArResidualError.setter
    def ArResidualError(self, value: float):
        """The variance of the residuals (Var(ε)) from the first step of TwoStepFit."""
        ...

    @property
    def MaResidualError(self) -> float:
        """The variance of the residuals (Var(ε)) from the second step of TwoStepFit."""
        ...

    @MaResidualError.setter
    def MaResidualError(self, value: float):
        """The variance of the residuals (Var(ε)) from the second step of TwoStepFit."""
        ...

    @typing.overload
    def __init__(self, name: str, arOrder: int, diffOrder: int, maOrder: int, period: int, intercept: bool = True) -> None:
        """
        Fits an ARIMA(arOrder,diffOrder,maOrder) model of form (after differencing it _diffOrder times):
        
            Xₜ = c + εₜ + ΣᵢφᵢXₜ₋ᵢ +  Σᵢθᵢεₜ₋ᵢ
        
        where the first sum has an upper limit of _arOrder and the second _maOrder.
        This particular constructor fits the model by means of TwoStepFit for a specified name.
        
        :param name: The name of the indicator
        :param arOrder: AR order (p) -- defines the number of past values to consider in the AR component of the model.
        :param diffOrder: Difference order (d) -- defines how many times to difference the model before fitting parameters.
        :param maOrder: MA order -- defines the number of past values to consider in the MA component of the model.
        :param period: Size of the rolling series to fit onto
        :param intercept: Whether ot not to include the intercept term
        """
        ...

    @typing.overload
    def __init__(self, arOrder: int, diffOrder: int, maOrder: int, period: int, intercept: bool) -> None:
        """
        Fits an ARIMA(arOrder,diffOrder,maOrder) model of form (after differencing it _diffOrder times):
        
            Xₜ = c + εₜ + ΣᵢφᵢXₜ₋ᵢ +  Σᵢθᵢεₜ₋ᵢ
        
        where the first sum has an upper limit of _arOrder and the second _maOrder.
        This particular constructor fits the model by means of TwoStepFit using ordinary least squares.
        
        :param arOrder: AR order (p) -- defines the number of past values to consider in the AR component of the model.
        :param diffOrder: Difference order (d) -- defines how many times to difference the model before fitting parameters.
        :param maOrder: MA order (q) -- defines the number of past values to consider in the MA component of the model.
        :param period: Size of the rolling series to fit onto
        :param intercept: Whether to include an intercept term (c)
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Forecasts the series of the fitted model one point ahead.
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class Sum(QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """Represents an indicator capable of tracking the sum for the given period"""

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the Sum class with the specified name and period
        
        :param name: The name of this indicator
        :param period: The period of the SMA
        """
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the Sum class with the default name and period
        
        :param period: The period of the SMA
        """
        ...

    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect.Indicators.IndicatorDataPoint], input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value for this indicator from the given state.
        
        This method is protected.
        
        :param window: The window of data held in this indicator
        :param input: The input value to this indicator on this time step
        :returns: A new value for this indicator.
        """
        ...


class DeMarkerIndicator(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    In the DeMarker strategy, for some period of size N, set:
    
    DeMax = High - Previous High, and
    DeMin = Previous Low - Low
    
    where, in the prior, if either term is less than zero (DeMax or DeMin), set it to zero.
    We can now define the indicator itself, DEM, as:
    
    DEM = MA(DeMax)/(MA(DeMax)+MA(DeMin))
    
    where MA denotes a Moving Average of period N.
    
    https://www.investopedia.com/terms/d/demarkerindicator.asp
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int, type: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Initializes a new instance of the DeMarkerIndicator class with the specified period
        
        :param period: The period of the  DeMarker Indicator
        :param type: The type of moving average to use in calculations
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int, type: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Initializes a new instance of the DeMarkerIndicator class with the specified name and period
        
        :param name: The name of this indicator
        :param period: The period of the  DeMarker Indicator
        :param type: The type of moving average to use in calculations
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class AroonOscillator(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    The Aroon Oscillator is the difference between AroonUp and AroonDown. The value of this
    indicator fluctuates between -100 and +100. An upward trend bias is present when the oscillator
    is positive, and a negative trend bias is present when the oscillator is negative. AroonUp/Down
    values over 75 identify strong trends in their respective direction.
    """

    @property
    def AroonUp(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the AroonUp indicator"""
        ...

    @property
    def AroonDown(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the AroonDown indicator"""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, upPeriod: int, downPeriod: int) -> None:
        """
        Creates a new AroonOscillator from the specified up/down periods.
        
        :param upPeriod: The lookback period to determine the highest high for the AroonDown
        :param downPeriod: The lookback period to determine the lowest low for the AroonUp
        """
        ...

    @typing.overload
    def __init__(self, name: str, upPeriod: int, downPeriod: int) -> None:
        """
        Creates a new AroonOscillator from the specified up/down periods.
        
        :param name: The name of this indicator
        :param upPeriod: The lookback period to determine the highest high for the AroonDown
        :param downPeriod: The lookback period to determine the lowest low for the AroonUp
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator and both sub-indicators (AroonUp and AroonDown)"""
        ...


class AwesomeOscillator(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    The Awesome Oscillator Indicator tracks the price midpoint-movement of a security. Specifically,
    
    AO = MAfast[(H+L)/2] - MAslow[(H+L)/2]
    
    where MAfast and MAslow denote simple moving averages wherein fast has a shorter period.
    https://www.barchart.com/education/technical-indicators/awesome_oscillator
    """

    @property
    def SlowAo(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the indicators slow period moving average."""
        ...

    @property
    def FastAo(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the indicators fast period moving average."""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, fastPeriod: int, slowPeriod: int, type: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Creates a new Awesome Oscillator from the specified periods.
        
        :param fastPeriod: The period of the fast moving average associated with the AO
        :param slowPeriod: The period of the slow moving average associated with the AO
        :param type: The type of moving average used when computing the fast and slow term. Defaults to simple moving average.
        """
        ...

    @typing.overload
    def __init__(self, name: str, fastPeriod: int, slowPeriod: int, type: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Creates a new Awesome Oscillator from the specified periods.
        
        :param name: The name of this indicator
        :param fastPeriod: The period of the fast moving average associated with the AO
        :param slowPeriod: The period of the slow moving average associated with the AO
        :param type: The type of moving average used when computing the fast and slow term. Defaults to simple moving average.
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value of this indicator from the given state.
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator"""
        ...


class IntradayVwap(QuantConnect.Indicators.IndicatorBase[QuantConnect.Data.BaseData]):
    """Defines the canonical intraday VWAP indicator"""

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    def __init__(self, name: str) -> None:
        """
        Initializes a new instance of the IntradayVwap class
        
        :param name: The name of the indicator
        """
        ...

    def ValidateAndComputeNextValue(self, input: QuantConnect.Data.BaseData) -> QuantConnect.Indicators.IndicatorResult:
        """
        Computes the new VWAP
        
        This method is protected.
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.BaseData) -> float:
        """
        Computes the next value of this indicator from the given state.
        NOTE: This must be overriden since it's abstract in the base, but
        will never be invoked since we've override the validate method above.
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def TryGetVolumeAndAveragePrice(self, input: QuantConnect.Data.BaseData, volume: float, averagePrice: float) -> bool:
        """
        Determines the volume and price to be used for the current input in the VWAP computation
        
        This method is protected.
        """
        ...


class FunctionalIndicator(typing.Generic[QuantConnect_Indicators_FunctionalIndicator_T], QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_FunctionalIndicator_T]):
    """
    The functional indicator is used to lift any function into an indicator. This can be very useful
    when trying to combine output of several indicators, or for expression a mathematical equation
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @typing.overload
    def __init__(self, name: str, computeNextValue: typing.Callable[[QuantConnect_Indicators_FunctionalIndicator_T], float], isReady: typing.Callable[[QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_FunctionalIndicator_T]], bool]) -> None:
        """
        Creates a new FunctionalIndicator using the specified functions as its implementation.
        
        :param name: The name of this indicator
        :param computeNextValue: A function accepting the input value and returning this indicator's output value
        :param isReady: A function accepting this indicator and returning true if the indicator is ready, false otherwise
        """
        ...

    @typing.overload
    def __init__(self, name: str, computeNextValue: typing.Callable[[QuantConnect_Indicators_FunctionalIndicator_T], float], isReady: typing.Callable[[QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_FunctionalIndicator_T]], bool], reset: System.Action) -> None:
        """
        Creates a new FunctionalIndicator using the specified functions as its implementation.
        
        :param name: The name of this indicator
        :param computeNextValue: A function accepting the input value and returning this indicator's output value
        :param isReady: A function accepting this indicator and returning true if the indicator is ready, false otherwise
        :param reset: Function called to reset this indicator and any indicators this is dependent on
        """
        ...

    def ComputeNextValue(self, input: QuantConnect_Indicators_FunctionalIndicator_T) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state, optionally using the reset action passed via the constructor"""
        ...


class ChandeMomentumOscillator(QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the Chande Momentum Oscillator (CMO).
    CMO calculation is mostly identical to RSI.
    The only difference is in the last step of calculation:
    RSI = gain / (gain+loss)
    CMO = (gain-loss) / (gain+loss)
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the ChandeMomentumOscillator class using the specified period.
        
        :param period: The period of the indicator
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the ChandeMomentumOscillator class using the specified name and period.
        
        :param name: The name of this indicator
        :param period: The period of the indicator
        """
        ...

    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect.Indicators.IndicatorDataPoint], input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param window: The window for the input history
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class RelativeStrengthIndex(QuantConnect.Indicators.Indicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    Represents the  Relative Strength Index (RSI) developed by K. Welles Wilder.
    You can optionally specified a different moving average type to be used in the computation
    """

    @property
    def MovingAverageType(self) -> int:
        """
        Gets the type of indicator used to compute AverageGain and AverageLoss
        
        This property contains the int value of a member of the QuantConnect.Indicators.MovingAverageType enum.
        """
        ...

    @property
    def AverageLoss(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the EMA for the down days"""
        ...

    @property
    def AverageGain(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the indicator for average gain"""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int, movingAverageType: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Initializes a new instance of the RelativeStrengthIndex class with the specified name and period
        
        :param period: The period used for up and down days
        :param movingAverageType: The type of moving average to be used for computing the average gain/loss values
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int, movingAverageType: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Initializes a new instance of the RelativeStrengthIndex class with the specified name and period
        
        :param name: The name of this indicator
        :param period: The period used for up and down days
        :param movingAverageType: The type of moving average to be used for computing the average gain/loss values
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class UltimateOscillator(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the Ultimate Oscillator (ULTOSC)
    The Ultimate Oscillator is calculated as explained here:
    http://stockcharts.com/school/doku.php?id=chart_school:technical_indicators:ultimate_oscillator
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period1: int, period2: int, period3: int) -> None:
        """
        Initializes a new instance of the UltimateOscillator class using the specified parameters
        
        :param period1: The first period
        :param period2: The second period
        :param period3: The third period
        """
        ...

    @typing.overload
    def __init__(self, name: str, period1: int, period2: int, period3: int) -> None:
        """
        Initializes a new instance of the UltimateOscillator class using the specified parameters
        
        :param name: The name of this indicator
        :param period1: The first period
        :param period2: The second period
        :param period3: The third period
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class TriangularMovingAverage(QuantConnect.Indicators.Indicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the Triangular Moving Average (TRIMA).
    The Triangular Moving Average is calculated with the following formula:
    (1) When the period is even, TRIMA(x,period)=SMA(SMA(x,period/2),(period/2)+1)
    (2) When the period is odd,  TRIMA(x,period)=SMA(SMA(x,(period+1)/2),(period+1)/2)
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the TriangularMovingAverage class using the specified name and period.
        
        :param name: The name of this indicator
        :param period: The period of the indicator
        """
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the TriangularMovingAverage class using the specified period.
        
        :param period: The period of the indicator
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class DoubleExponentialMovingAverage(QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the Double Exponential Moving Average (DEMA).
    The Double Exponential Moving Average is calculated with the following formula:
    EMA2 = EMA(EMA(t,period),period)
    DEMA = 2 * EMA(t,period) - EMA2
    The Generalized DEMA (GD) is calculated with the following formula:
    GD = (volumeFactor+1) * EMA(t,period) - volumeFactor * EMA2
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int, volumeFactor: float = 1) -> None:
        """
        Initializes a new instance of the DoubleExponentialMovingAverage class using the specified name and period.
        
        :param name: The name of this indicator
        :param period: The period of the DEMA
        :param volumeFactor: The volume factor of the DEMA (value must be in the [0,1] range, set to 1 for standard DEMA)
        """
        ...

    @typing.overload
    def __init__(self, period: int, volumeFactor: float = 1) -> None:
        """
        Initializes a new instance of the DoubleExponentialMovingAverage class using the specified period.
        
        :param period: The period of the DEMA
        :param volumeFactor: The volume factor of the DEMA (value must be in the [0,1] range, set to 1 for standard DEMA)
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class ChaikinMoneyFlow(QuantConnect.Indicators.TradeBarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    The Chaikin Money Flow Index (CMF) is a volume-weighted average of accumulation and distribution over
    a specified period.
    
    CMF = n-day Sum of [(((C - L) - (H - C)) / (H - L)) x Vol] / n-day Sum of Vol
    
    Where:
    n = number of periods, typically 21
    H = high
    L = low
    C = close
    Vol = volume
    
    https://www.fidelity.com/learning-center/trading-investing/technical-analysis/technical-indicator-guide/cmf
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...

    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the ChaikinMoneyFlow class
        
        :param name: A name for the indicator
        :param period: The period over which to perform computation
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.TradeBar) -> float:
        """
        Computes the next value for this indicator from the given state.
        
        This method is protected.
        
        :param input: The input value to this indicator on this time step
        :returns: A new value for this indicator.
        """
        ...


class AdvanceDeclineVolumeRatio(QuantConnect.Indicators.AdvanceDeclineIndicator):
    """
    The Advance Decline Volume Ratio is a Breadth indicator calculated as ratio of
    summary volume of advancing stocks to summary volume of declining stocks.
    AD Volume Ratio is used in technical analysis to see where the main trading activity is focused.
    """

    def __init__(self, name: str) -> None:
        """Initializes a new instance of the AdvanceDeclineVolumeRatio class"""
        ...


class MidPoint(QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the MidPoint (MIDPOINT)
    The MidPoint is calculated using the following formula:
    MIDPOINT = (Highest Value + Lowest Value) / 2
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the MidPoint class using the specified name and period.
        
        :param name: The name of this indicator
        :param period: The period of the MIDPOINT
        """
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the MidPoint class using the specified period.
        
        :param period: The period of the MIDPOINT
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class Stochastic(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the Slow Stochastics %K and %D. The Fast Stochastics %K is is computed by
    (Current Close Price - Lowest Price of given Period) / (Highest Price of given Period - Lowest Price of given Period)
    multiplied by 100. Once the Fast Stochastics %K is calculated the Slow Stochastic %K is calculated by the average/smoothed price of
    of the Fast %K with the given period. The Slow Stochastics %D is then derived from the Slow Stochastics %K with the given period.
    """

    @property
    def FastStoch(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Data.Market.IBaseDataBar]:
        """Gets the value of the Fast Stochastics %K given Period."""
        ...

    @property
    def StochK(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Data.Market.IBaseDataBar]:
        """Gets the value of the Slow Stochastics given Period K."""
        ...

    @property
    def StochD(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Data.Market.IBaseDataBar]:
        """Gets the value of the Slow Stochastics given Period D."""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int, kPeriod: int, dPeriod: int) -> None:
        """
        Creates a new Stochastics Indicator from the specified periods.
        
        :param name: The name of this indicator.
        :param period: The period given to calculate the Fast %K
        :param kPeriod: The K period given to calculated the Slow %K
        :param dPeriod: The D period given to calculated the Slow %D
        """
        ...

    @typing.overload
    def __init__(self, period: int, kPeriod: int, dPeriod: int) -> None:
        """
        Creates a new Stochastic indicator from the specified inputs.
        
        :param period: The period given to calculate the Fast %K
        :param kPeriod: The K period given to calculated the Slow %K
        :param dPeriod: The D period given to calculated the Slow %D
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class KeltnerChannels(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator creates a moving average (middle band) with an upper band and lower band
    fixed at k average true range multiples away from the middle band.
    """

    @property
    def MiddleBand(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the middle band of the channel"""
        ...

    @property
    def UpperBand(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Data.Market.IBaseDataBar]:
        """Gets the upper band of the channel"""
        ...

    @property
    def LowerBand(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Data.Market.IBaseDataBar]:
        """Gets the lower band of the channel"""
        ...

    @property
    def AverageTrueRange(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Data.Market.IBaseDataBar]:
        """Gets the average true range"""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int, k: float, movingAverageType: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Initializes a new instance of the KeltnerChannels class
        
        :param period: The period of the average true range and moving average (middle band)
        :param k: The number of multiplies specifying the distance between the middle band and upper or lower bands
        :param movingAverageType: The type of moving average to be used
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int, k: float, movingAverageType: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Initializes a new instance of the KeltnerChannels class
        
        :param name: The name of this indicator
        :param period: The period of the average true range and moving average (middle band)
        :param k: The number of multiples specifying the distance between the middle band and upper or lower bands
        :param movingAverageType: The type of moving average to be used
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value for this indicator from the given state.
        
        This method is protected.
        
        :param input: The TradeBar to this indicator on this time step
        :returns: A new value for this indicator.
        """
        ...


class HeikinAshi(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the Heikin-Ashi bar (HA)
    The Heikin-Ashi bar is calculated using the following formulas:
    HA_Close[0] = (Open[0] + High[0] + Low[0] + Close[0]) / 4
    HA_Open[0] = (HA_Open[1] + HA_Close[1]) / 2
    HA_High[0] = MAX(High[0], HA_Open[0], HA_Close[0])
    HA_Low[0] = MIN(Low[0], HA_Open[0], HA_Close[0])
    """

    @property
    def Open(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the Heikin-Ashi Open"""
        ...

    @property
    def High(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the Heikin-Ashi High"""
        ...

    @property
    def Low(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the Heikin-Ashi Low"""
        ...

    @property
    def Close(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the Heikin-Ashi Close"""
        ...

    @property
    def Volume(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the Heikin-Ashi Volume"""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str) -> None:
        """
        Initializes a new instance of the HeikinAshi class using the specified name.
        
        :param name: The name of this indicator
        """
        ...

    @typing.overload
    def __init__(self) -> None:
        """Initializes a new instance of the HeikinAshi class."""
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class Variance(QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """This indicator computes the n-period population variance."""

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the Variance class using the specified period.
        
        :param period: The period of the indicator
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the Variance class using the specified name and period.
        
        :param name: The name of this indicator
        :param period: The period of the indicator
        """
        ...

    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect.Indicators.IndicatorDataPoint], input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param window: The window for the input history
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class ArmsIndex(QuantConnect.Indicators.TradeBarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    The Arms Index, also called the Short-Term Trading Index (TRIN)
    is a technical analysis indicator that compares the number of advancing
    and declining stocks (AD Ratio) to advancing and declining volume (AD volume).
    """

    @property
    def ADRatio(self) -> QuantConnect.Indicators.AdvanceDeclineRatio:
        """Gets the Advance/Decline Ratio (ADR) indicator"""
        ...

    @property
    def ADVRatio(self) -> QuantConnect.Indicators.AdvanceDeclineVolumeRatio:
        """Gets the Advance/Decline Volume Ratio (ADVR) indicator"""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    def __init__(self, name: str) -> None:
        """Initializes a new instance of the ArmsIndex class"""
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.TradeBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...

    def AddStock(self, symbol: typing.Union[QuantConnect.Symbol, str]) -> None:
        """
        Add Tracking stock issue
        
        :param symbol: the tracking stock issue
        """
        ...

    def RemoveStock(self, symbol: typing.Union[QuantConnect.Symbol, str]) -> None:
        """
        Remove Tracking stock issue
        
        :param symbol: the tracking stock issue
        """
        ...


class AverageDirectionalIndex(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes Average Directional Index which measures trend strength without regard to trend direction.
    Firstly, it calculates the Directional Movement and the True Range value, and then the values are accumulated and smoothed
    using a custom smoothing method proposed by Wilder. For an n period smoothing, 1/n of each period's value is added to the total period.
    From these accumulated values we are therefore able to derived the 'Positive Directional Index' (+DI) and 'Negative Directional Index' (-DI)
    which is used to calculate the Average Directional Index.
    Computation source:
    https://stockcharts.com/school/doku.php?id=chart_school:technical_indicators:average_directional_index_adx
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def PositiveDirectionalIndex(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the index of the Plus Directional Indicator"""
        ...

    @property
    def NegativeDirectionalIndex(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the index of the Minus Directional Indicator"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the AverageDirectionalIndex class.
        
        :param period: The period.
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the AverageDirectionalIndex class.
        
        :param name: The name.
        :param period: The period.
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class AverageDirectionalMovementIndexRating(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the Average Directional Movement Index Rating (ADXR).
    The Average Directional Movement Index Rating is calculated with the following formula:
    ADXR[i] = (ADX[i] + ADX[i - period + 1]) / 2
    """

    @property
    def ADX(self) -> QuantConnect.Indicators.AverageDirectionalIndex:
        """The Average Directional Index indicator instance being used"""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the AverageDirectionalMovementIndexRating class using the specified name and period.
        
        :param name: The name of this indicator
        :param period: The period of the ADXR
        """
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the AverageDirectionalMovementIndexRating class using the specified period.
        
        :param period: The period of the ADXR
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class MidPrice(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the MidPrice (MIDPRICE).
    The MidPrice is calculated using the following formula:
    MIDPRICE = (Highest High + Lowest Low) / 2
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the MidPrice class using the specified name and period.
        
        :param name: The name of this indicator
        :param period: The period of the MIDPRICE
        """
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the MidPrice class using the specified period.
        
        :param period: The period of the MIDPRICE
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class RelativeVigorIndexSignal(QuantConnect.Indicators.Indicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """The signal for the Relative Vigor Index, itself an indicator."""

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Resets this indicator to its initial state"""
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class MomentumPercent(QuantConnect.Indicators.RateOfChangePercent):
    """
    This indicator computes the n-period percentage rate of change in a value using the following:
    100 * (value_0 - value_n) / value_n
    
    This indicator yields the same results of RateOfChangePercent
    """

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Creates a new MomentumPercent indicator with the specified period
        
        :param period: The period over which to perform to computation
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Creates a new MomentumPercent indicator with the specified period
        
        :param name: The name of this indicator
        :param period: The period over which to perform to computation
        """
        ...


class StandardDeviation(QuantConnect.Indicators.Variance):
    """This indicator computes the n-period population standard deviation."""

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the StandardDeviation class with the specified period.
        
        Evaluates the standard deviation of samples in the look-back period.
        On a data set of size N will use an N normalizer and would thus be biased if applied to a subset.
        
        :param period: The sample size of the standard deviation
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the StandardDeviation class with the specified name and period.
        
        Evaluates the standard deviation of samples in the look-back period.
        On a data set of size N will use an N normalizer and would thus be biased if applied to a subset.
        
        :param name: The name of this indicator
        :param period: The sample size of the standard deviation
        """
        ...

    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect.Indicators.IndicatorDataPoint], input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param window: The window for the input history
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class WindowIdentity(QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint]):
    """
    Represents an indicator that is a ready after ingesting enough samples (# samples > period)
    and always returns the same value as it is given.
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the WindowIdentity class with the specified name and period
        
        :param name: The name of this indicator
        :param period: The period of the WindowIdentity
        """
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the WindowIdentity class with the default name and period
        
        :param period: The period of the WindowIdentity
        """
        ...

    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect.Indicators.IndicatorDataPoint], input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value for this indicator from the given state.
        
        This method is protected.
        
        :param window: The window of data held in this indicator
        :param input: The input value to this indicator on this time step
        :returns: A new value for this indicator.
        """
        ...


class ParabolicStopAndReverse(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    Parabolic SAR Indicator
    Based on TA-Lib implementation
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, afStart: float = 0.02, afIncrement: float = 0.02, afMax: float = 0.2) -> None:
        """
        Create new Parabolic SAR
        
        :param name: The name of this indicator
        :param afStart: Acceleration factor start value
        :param afIncrement: Acceleration factor increment value
        :param afMax: Acceleration factor max value
        """
        ...

    @typing.overload
    def __init__(self, afStart: float = 0.02, afIncrement: float = 0.02, afMax: float = 0.2) -> None:
        """
        Create new Parabolic SAR
        
        :param afStart: Acceleration factor start value
        :param afIncrement: Acceleration factor increment value
        :param afMax: Acceleration factor max value
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The trade bar input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class HullMovingAverage(QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    Produces a Hull Moving Average as explained at http://www.alanhull.com/hull-moving-average/
    and derived from the instructions for the Excel VBA code at http://finance4traders.blogspot.com/2009/06/how-to-calculate-hull-moving-average.html
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        A Hull Moving Average
        
        :param name: string - a name for the indicator
        :param period: int - the number of periods to calculate the HMA - the period of the slower LWMA
        """
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        A Hull Moving Average.
        
        :param period: int - the number of periods over which to calculate the HMA - the length of the slower LWMA
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class SchaffTrendCycle(QuantConnect.Indicators.Indicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """This indicator creates the Schaff Trend Cycle"""

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, cyclePeriod: int = 10, fastPeriod: int = 23, slowPeriod: int = 50, type: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Creates the name string and calls on the indicator constructor with given parameters
        https://www.tradingpedia.com/forex-trading-indicators/schaff-trend-cycle
        
        :param cyclePeriod: The signal period
        :param fastPeriod: The fast moving average period
        :param slowPeriod: The slow moving average period
        :param type: The type of moving averages to use
        """
        ...

    @typing.overload
    def __init__(self, name: str, cyclePeriod: int, fastPeriod: int, slowPeriod: int, type: QuantConnect.Indicators.MovingAverageType) -> None:
        """
        Creates a new schaff trend cycle with the specified parameters
        
        :param name: The name of this indicator
        :param cyclePeriod: The signal period
        :param fastPeriod: The fast moving average period
        :param slowPeriod: The slow moving average period
        :param type: The type of moving averages to use
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class BalanceOfPower(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the Balance Of Power (BOP).
    The Balance Of Power is calculated with the following formula:
    BOP = (Close - Open) / (High - Low)
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self) -> None:
        """Initializes a new instance of the BalanceOfPower class using the specified name."""
        ...

    @typing.overload
    def __init__(self, name: str) -> None:
        """
        Initializes a new instance of the BalanceOfPower class using the specified name.
        
        :param name: The name of this indicator
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class Trix(QuantConnect.Indicators.Indicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the TRIX (1-period ROC of a Triple EMA)
    The TRIX is calculated as explained here:
    http://stockcharts.com/school/doku.php?id=chart_school:technical_indicators:trix
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the Trix class using the specified name and period.
        
        :param name: The name of this indicator
        :param period: The period of the indicator
        """
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the Trix class using the specified period.
        
        :param period: The period of the indicator
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class AverageTrueRange(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    The AverageTrueRange indicator is a measure of volatility introduced by Welles Wilder in his
    book: New Concepts in Technical Trading Systems. This indicator computes the TrueRange and then
    smoothes the TrueRange over a given period.
    
    TrueRange is defined as the maximum of the following:
      High - Low
      ABS(High - PreviousClose)
      ABS(Low - PreviousClose)
    """

    @property
    def TrueRange(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Data.Market.IBaseDataBar]:
        """Gets the true range which is the more volatile calculation to be smoothed by this indicator"""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int, movingAverageType: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Creates a new AverageTrueRange indicator using the specified period and moving average type
        
        :param name: The name of this indicator
        :param period: The smoothing period used to smooth the true range values
        :param movingAverageType: The type of smoothing used to smooth the true range values
        """
        ...

    @typing.overload
    def __init__(self, period: int, movingAverageType: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Creates a new AverageTrueRange indicator using the specified period and moving average type
        
        :param period: The smoothing period used to smooth the true range values
        :param movingAverageType: The type of smoothing used to smooth the true range values
        """
        ...

    @staticmethod
    def ComputeTrueRange(previous: QuantConnect.Data.Market.IBaseDataBar, current: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the TrueRange from the current and previous trade bars
        
        TrueRange is defined as the maximum of the following:
          High - Low
          ABS(High - PreviousClose)
          ABS(Low - PreviousClose)
        
        :param previous: The previous trade bar
        :param current: The current trade bar
        :returns: The true range.
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class MassIndex(QuantConnect.Indicators.TradeBarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    The Mass Index uses the high-low range to identify trend reversals based on range expansions.
    In this sense, the Mass Index is a volatility indicator that does not have a directional
    bias. Instead, the Mass Index identifies range bulges that can foreshadow a reversal of the
    current trend. Developed by Donald Dorsey.
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, emaPeriod: int, sumPeriod: int) -> None:
        """
        Initializes a new instance of the MassIndex class.
        
        :param name: The name for this instance.
        :param emaPeriod: The period used by both EMA.
        :param sumPeriod: The sum period.
        """
        ...

    @typing.overload
    def __init__(self, emaPeriod: int = 9, sumPeriod: int = 25) -> None:
        """
        Initializes a new instance of the MassIndex class.
        
        :param emaPeriod: The period used by both EMA.
        :param sumPeriod: The sum period.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.TradeBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class KaufmanAdaptiveMovingAverage(QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the Kaufman Adaptive Moving Average (KAMA).
    The Kaufman Adaptive Moving Average is calculated as explained here:
    http://stockcharts.com/school/doku.php?id=chart_school:technical_indicators:kaufman_s_adaptive_moving_average
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int, fastEmaPeriod: int = 2, slowEmaPeriod: int = 30) -> None:
        """
        Initializes a new instance of the KaufmanAdaptiveMovingAverage class using the specified name and period.
        
        :param name: The name of this indicator
        :param period: The period of the Efficiency Ratio (ER)
        :param fastEmaPeriod: The period of the fast EMA used to calculate the Smoothing Constant (SC)
        :param slowEmaPeriod: The period of the slow EMA used to calculate the Smoothing Constant (SC)
        """
        ...

    @typing.overload
    def __init__(self, period: int, fastEmaPeriod: int = 2, slowEmaPeriod: int = 30) -> None:
        """
        Initializes a new instance of the KaufmanAdaptiveMovingAverage class using the specified period.
        
        :param period: The period of the Efficiency Ratio (ER)
        :param fastEmaPeriod: The period of the fast EMA used to calculate the Smoothing Constant (SC)
        :param slowEmaPeriod: The period of the slow EMA used to calculate the Smoothing Constant (SC)
        """
        ...

    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect.Indicators.IndicatorDataPoint], input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param window: The window for the input history
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class AccelerationBands(QuantConnect.Indicators.IndicatorBase[QuantConnect.Data.Market.IBaseDataBar], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """The Acceleration Bands created by Price Headley plots upper and lower envelope bands around a moving average."""

    @property
    def MovingAverageType(self) -> int:
        """
        Gets the type of moving average
        
        This property contains the int value of a member of the QuantConnect.Indicators.MovingAverageType enum.
        """
        ...

    @property
    def MiddleBand(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the middle acceleration band (moving average)"""
        ...

    @property
    def UpperBand(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the upper acceleration band  (High * ( 1 + Width * (High - Low) / (High + Low)))"""
        ...

    @property
    def LowerBand(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the lower acceleration band  (Low * (1 - Width * (High - Low)/ (High + Low)))"""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int, width: float, movingAverageType: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Initializes a new instance of the AccelerationBands class.
        
        :param name: The name of this indicator.
        :param period: The period of the three moving average (middle, upper and lower band).
        :param width: A coefficient specifying the distance between the middle band and upper or lower bands.
        :param movingAverageType: Type of the moving average.
        """
        ...

    @typing.overload
    def __init__(self, period: int, width: float) -> None:
        """
        Initializes a new instance of the AccelerationBands class.
        
        :param period: The period of the three moving average (middle, upper and lower band).
        :param width: A coefficient specifying the distance between the middle band and upper or lower bands.
        """
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the AccelerationBands class.
        
        :param period: The period of the three moving average (middle, upper and lower band).
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class Momentum(QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the n-period change in a value using the following:
    value_0 - value_n
    """

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Creates a new Momentum indicator with the specified period
        
        :param period: The period over which to perform to computation
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Creates a new Momentum indicator with the specified period
        
        :param name: The name of this indicator
        :param period: The period over which to perform to computation
        """
        ...

    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect.Indicators.IndicatorDataPoint], input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value for this indicator from the given state.
        
        This method is protected.
        
        :param window: The window of data held in this indicator
        :param input: The input value to this indicator on this time step
        :returns: A new value for this indicator.
        """
        ...


class LogReturn(QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    Represents the LogReturn indicator (LOGR)
    - log returns are useful for identifying price convergence/divergence in a given period
    - logr = log (current price / last price in period)
    """

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the LogReturn class with the specified name and period
        
        :param name: The name of this indicator
        :param period: The period of the LOGR
        """
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the LogReturn class with the default name and period
        
        :param period: The period of the SMA
        """
        ...

    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect.Indicators.IndicatorDataPoint], input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value for this indicator from the given state.
        - logr = log (current price / last price in period)
        
        This method is protected.
        
        :param window: The window of data held in this indicator
        :param input: The input value to this indicator on this time step
        :returns: A new value for this indicator.
        """
        ...


class DonchianChannel(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the upper and lower band of the Donchian Channel.
    The upper band is computed by finding the highest high over the given period.
    The lower band is computed by finding the lowest low over the given period.
    The primary output value of the indicator is the mean of the upper and lower band for
    the given timeframe.
    """

    @property
    def UpperBand(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the upper band of the Donchian Channel."""
        ...

    @property
    def LowerBand(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the lower band of the Donchian Channel."""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the DonchianChannel class.
        
        :param period: The period for both the upper and lower channels.
        """
        ...

    @typing.overload
    def __init__(self, upperPeriod: int, lowerPeriod: int) -> None:
        """
        Initializes a new instance of the DonchianChannel class.
        
        :param upperPeriod: The period for the upper channel.
        :param lowerPeriod: The period for the lower channel
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the DonchianChannel class.
        
        :param name: The name.
        :param period: The period for both the upper and lower channels.
        """
        ...

    @typing.overload
    def __init__(self, name: str, upperPeriod: int, lowerPeriod: int) -> None:
        """
        Initializes a new instance of the DonchianChannel class.
        
        :param name: The name.
        :param upperPeriod: The period for the upper channel.
        :param lowerPeriod: The period for the lower channel
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator, which by convention is the mean value of the upper band and lower band.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class ConstantIndicator(typing.Generic[QuantConnect_Indicators_ConstantIndicator_T], QuantConnect.Indicators.IndicatorBase[QuantConnect_Indicators_ConstantIndicator_T]):
    """An indicator that will always return the same value."""

    @property
    def IsReady(self) -> bool:
        """Gets true since the ConstantIndicator is always ready to return the same value"""
        ...

    def __init__(self, name: str, value: float) -> None:
        """
        Creates a new ConstantIndicator that will always return the specified value
        
        :param name: The name of this indicator
        :param value: The constant value to be returned
        """
        ...

    def ComputeNextValue(self, input: QuantConnect_Indicators_ConstantIndicator_T) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class MovingAverageTypeExtensions(System.Object):
    """Provides extension methods for the MovingAverageType enumeration"""

    @staticmethod
    @typing.overload
    def AsIndicator(movingAverageType: QuantConnect.Indicators.MovingAverageType, period: int) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """
        Creates a new indicator from the specified MovingAverageType. So if MovingAverageType.Simple
        is specified, then a new SimpleMovingAverage will be returned.
        
        :param movingAverageType: The type of averaging indicator to create
        :param period: The smoothing period
        :returns: A new indicator that matches the MovingAverageType.
        """
        ...

    @staticmethod
    @typing.overload
    def AsIndicator(movingAverageType: QuantConnect.Indicators.MovingAverageType, name: str, period: int) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """
        Creates a new indicator from the specified MovingAverageType. So if MovingAverageType.Simple
        is specified, then a new SimpleMovingAverage will be returned.
        
        :param movingAverageType: The type of averaging indicator to create
        :param name: The name of the new indicator
        :param period: The smoothing period
        :returns: A new indicator that matches the MovingAverageType.
        """
        ...


class EaseOfMovementValue(QuantConnect.Indicators.TradeBarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the n-period Ease of Movement Value using the following:
    MID = (high_1 + low_1)/2 - (high_0 + low_0)/2
    RATIO = (currentVolume/10000) / (high_1 - low_1)
    EMV = MID/RATIO
    _SMA = n-period of EMV
    Returns _SMA
    Source: https://www.investopedia.com/terms/e/easeofmovement.asp
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int = 1, scale: int = 10000) -> None:
        """
        Initializeds a new instance of the EaseOfMovement class using the specufued period
        
        :param period: The period over which to perform to computation
        :param scale: The size of the number outputed by EMV
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int, scale: int) -> None:
        """
        Creates a new EaseOfMovement indicator with the specified period
        
        :param name: The name of this indicator
        :param period: The period over which to perform to computation
        :param scale: The size of the number outputed by EMV
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.TradeBar) -> float:
        """
        Computes the next value for this indicator from the given state.
        
        This method is protected.
        
        :param input: The input value to this indicator on this time step
        :returns: A a value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class AccumulationDistribution(QuantConnect.Indicators.TradeBarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the Accumulation/Distribution (AD)
    The Accumulation/Distribution is calculated using the following formula:
    AD = AD + ((Close - Low) - (High - Close)) / (High - Low) * Volume
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self) -> None:
        """Initializes a new instance of the AccumulationDistribution class using the specified name."""
        ...

    @typing.overload
    def __init__(self, name: str) -> None:
        """
        Initializes a new instance of the AccumulationDistribution class using the specified name.
        
        :param name: The name of this indicator
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.TradeBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class ArnaudLegouxMovingAverage(QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    Smooth and high sensitive moving Average. This moving average reduce lag of the information
    but still being smooth to reduce noises.
    Is a weighted moving average, which weights have a Normal shape;
    the parameters Sigma and Offset affect the kurtosis and skewness of the weights respectively.
    Source: http://www.arnaudlegoux.com/index.html
    """

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int, sigma: int = 6, offset: float = 0.85) -> None:
        """
        Initializes a new instance of the ArnaudLegouxMovingAverage class.
        
        :param name: string - a name for the indicator
        :param period: int - the number of periods to calculate the ALMA
        :param sigma: int - this parameter is responsible for the shape of the curve coefficients. It affects the weight vector kurtosis.
        :param offset: decimal - This parameter allows regulating the smoothness and high sensitivity of the Moving Average. The range for this parameter is [0, 1]. It affects the weight vector skewness.
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the ArnaudLegouxMovingAverage class.
        
        :param name: string - a name for the indicator
        :param period: int - the number of periods to calculate the ALMA.
        """
        ...

    @typing.overload
    def __init__(self, period: int, sigma: int, offset: float = 0.85) -> None:
        """
        Initializes a new instance of the ArnaudLegouxMovingAverage class.
        
        :param period: int - the number of periods to calculate the ALMA
        :param sigma: int - this parameter is responsible for the shape of the curve coefficients. It affects the weight vector kurtosis.
        :param offset: decimal -  This parameter allows regulating the smoothness and high sensitivity of the Moving Average. The range for this parameter is [0, 1]. It affects the weight vector skewness.
        """
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the ArnaudLegouxMovingAverage class.
        
        :param period: int - the number of periods to calculate the ALMA.
        """
        ...

    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect.Indicators.IndicatorDataPoint], input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value for this indicator from the given state.
        
        This method is protected.
        
        :param window: The window of data held in this indicator
        :param input: The input value to this indicator on this time step
        :returns: A new value for this indicator.
        """
        ...


class MomersionIndicator(QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    Oscillator indicator that measures momentum and mean-reversion over a specified
    period n.
    Source: Harris, Michael. "Momersion Indicator." Price Action Lab.,
                13 Aug. 2015. Web. http://www.priceactionlab.com/Blog/2015/08/momersion-indicator/.
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, minPeriod: typing.Optional[int], fullPeriod: int) -> None:
        """
        Initializes a new instance of the MomersionIndicator class.
        
        :param name: The name.
        :param minPeriod: The minimum period.
        :param fullPeriod: The full period.
        """
        ...

    @typing.overload
    def __init__(self, minPeriod: typing.Optional[int], fullPeriod: int) -> None:
        """
        Initializes a new instance of the MomersionIndicator class.
        
        :param minPeriod: The minimum period.
        :param fullPeriod: The full period.
        """
        ...

    @typing.overload
    def __init__(self, fullPeriod: int) -> None:
        """
        Initializes a new instance of the MomersionIndicator class.
        
        :param fullPeriod: The full period.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...

    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect.Indicators.IndicatorDataPoint], input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...


class LinearWeightedMovingAverage(QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    Represents the traditional Weighted Moving Average indicator. The weight are linearly
    distributed according to the number of periods in the indicator.
    
    For example, a 4 period indicator will have a numerator of (4 * window[0]) + (3 * window[1]) + (2 * window[2]) + window[3]
    and a denominator of 4 + 3 + 2 + 1 = 10
    
    During the warm up period, IsReady will return false, but the LWMA will still be computed correctly because
    the denominator will be the minimum of Samples factorial or Size factorial and
    the computation iterates over that minimum value.
    
    The RollingWindow of inputs is created when the indicator is created.
    A RollingWindow of LWMAs is not saved.  That is up to the caller.
    """

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the LinearWeightedMovingAverage class with the specified name and period
        
        :param name: The name of this indicator
        :param period: The period of the LWMA
        """
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the LinearWeightedMovingAverage class with the default name and period
        
        :param period: The period of the LWMA
        """
        ...

    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect.Indicators.IndicatorDataPoint], input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value for this indicator from the given state.
        
        This method is protected.
        
        :param window: The window of data held in this indicator
        :param input: The input value to this indicator on this time step
        :returns: A new value for this indicator.
        """
        ...


class RelativeVigorIndex(QuantConnect.Indicators.BarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    The Relative Vigor Index (RVI) compares the ratio of the closing price of a security to its trading range.
    For illustration, let:
    a = Close−Openb = Close−Open of One Bar Prior to ac = Close−Open of One Bar Prior to bd = Close−Open of One Bar Prior to ce = High−Low of Bar af = High−Low of Bar bg = High−Low of Bar ch = High−Low of Bar d
    
    Then let (a+2*(b+c)+d)/6 be NUM and (e+2*(f+g)+h)/6 be DENOM.
    RVI = SMA(NUM)/SMA(DENOM)
    for a specified period.
    
    https://www.investopedia.com/terms/r/relative_vigor_index.asp
    """

    @property
    def Signal(self) -> QuantConnect.Indicators.RelativeVigorIndexSignal:
        """A signal line which behaves like a slowed version of the RVI."""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int, type: QuantConnect.Indicators.MovingAverageType) -> None:
        """
        Initializes a new instance of the RelativeVigorIndex (RVI) class.
        
        :param period: The period for the RelativeVigorIndex.
        :param type: The type of Moving Average to use
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int, type: QuantConnect.Indicators.MovingAverageType = ...) -> None:
        """
        Initializes a new instance of the RelativeVigorIndex (RVI) class.
        
        :param name: The name of this indicator.
        :param period: The period for the RelativeVigorIndex.
        :param type: The type of Moving Average to use
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.IBaseDataBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class MeanAbsoluteDeviation(QuantConnect.Indicators.WindowIndicator[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """This indicator computes the n-period mean absolute deviation."""

    @property
    def Mean(self) -> QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint]:
        """Gets the mean used to compute the deviation"""
        ...

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the MeanAbsoluteDeviation class with the specified period.
        
        Evaluates the mean absolute deviation of samples in the lookback period.
        
        :param period: The sample size of the standard deviation
        """
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the MeanAbsoluteDeviation class with the specified period.
        
        Evaluates the mean absolute deviation of samples in the look-back period.
        
        :param name: The name of this indicator
        :param period: The sample size of the mean absolute deviation
        """
        ...

    def ComputeNextValue(self, window: QuantConnect.Indicators.IReadOnlyWindow[QuantConnect.Indicators.IndicatorDataPoint], input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param window: The window for the input history
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator and its sub-indicator Mean to their initial state"""
        ...


class OnBalanceVolume(QuantConnect.Indicators.TradeBarIndicator, QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the On Balance Volume (OBV).
    The On Balance Volume is calculated by determining the price of the current close price and previous close price.
    If the current close price is equivalent to the previous price the OBV remains the same,
    If the current close price is higher the volume of that day is added to the OBV, while a lower close price will
    result in negative value.
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self) -> None:
        """Initializes a new instance of the Indicator class using the specified name."""
        ...

    @typing.overload
    def __init__(self, name: str) -> None:
        """
        Initializes a new instance of the Indicator class using the specified name.
        
        :param name: The name of this indicator
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Data.Market.TradeBar) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class TripleExponentialMovingAverage(QuantConnect.Indicators.IndicatorBase[QuantConnect.Indicators.IndicatorDataPoint], QuantConnect.Indicators.IIndicatorWarmUpPeriodProvider):
    """
    This indicator computes the Triple Exponential Moving Average (TEMA).
    The Triple Exponential Moving Average is calculated with the following formula:
    EMA1 = EMA(t,period)
    EMA2 = EMA(EMA(t,period),period)
    EMA3 = EMA(EMA(EMA(t,period),period),period)
    TEMA = 3 * EMA1 - 3 * EMA2 + EMA3
    """

    @property
    def IsReady(self) -> bool:
        """Gets a flag indicating when this indicator is ready and fully initialized"""
        ...

    @property
    def WarmUpPeriod(self) -> int:
        """Required period, in data points, for the indicator to be ready and fully initialized."""
        ...

    @typing.overload
    def __init__(self, name: str, period: int) -> None:
        """
        Initializes a new instance of the TripleExponentialMovingAverage class using the specified name and period.
        
        :param name: The name of this indicator
        :param period: The period of the TEMA
        """
        ...

    @typing.overload
    def __init__(self, period: int) -> None:
        """
        Initializes a new instance of the TripleExponentialMovingAverage class using the specified period.
        
        :param period: The period of the TEMA
        """
        ...

    def ComputeNextValue(self, input: QuantConnect.Indicators.IndicatorDataPoint) -> float:
        """
        Computes the next value of this indicator from the given state
        
        This method is protected.
        
        :param input: The input given to the indicator
        :returns: A new value for this indicator.
        """
        ...

    def Reset(self) -> None:
        """Resets this indicator to its initial state"""
        ...


class RollingWindow(typing.Generic[QuantConnect_Indicators_RollingWindow_T], System.Object, QuantConnect.Indicators.IReadOnlyWindow[QuantConnect_Indicators_RollingWindow_T], typing.Iterable[QuantConnect_Indicators_RollingWindow_T]):
    """
    This is a window that allows for list access semantics,
        where this[0] refers to the most recent item in the
        window and this[Count-1] refers to the last item in the window
    """

    @property
    def Size(self) -> int:
        """Gets the size of this window"""
        ...

    @property
    def Count(self) -> int:
        """Gets the current number of elements in this window"""
        ...

    @property
    def Samples(self) -> float:
        """Gets the number of samples that have been added to this window over its lifetime"""
        ...

    @property
    def MostRecentlyRemoved(self) -> QuantConnect_Indicators_RollingWindow_T:
        """
        Gets the most recently removed item from the window. This is the
            piece of data that just 'fell off' as a result of the most recent
            add. If no items have been removed, this will throw an exception.
        """
        ...

    @property
    def IsReady(self) -> bool:
        """
        Gets a value indicating whether or not this window is ready, i.e,
            it has been filled to its capacity
        """
        ...

    def __init__(self, size: int) -> None:
        """
        Initializes a new instance of the RollwingWindow class with the specified window size.
        
        :param size: The number of items to hold in the window
        """
        ...

    def __getitem__(self, i: int) -> QuantConnect_Indicators_RollingWindow_T:
        """
        Indexes into this window, where index 0 is the most recently
            entered value
        
        :param i: the index, i
        :returns: the ith most recent entry.
        """
        ...

    def __setitem__(self, i: int, value: QuantConnect_Indicators_RollingWindow_T) -> None:
        """
        Indexes into this window, where index 0 is the most recently
            entered value
        
        :param i: the index, i
        :returns: the ith most recent entry.
        """
        ...

    @typing.overload
    def GetEnumerator(self) -> System.Collections.Generic.IEnumerator[QuantConnect_Indicators_RollingWindow_T]:
        """
        Returns an enumerator that iterates through the collection.
        
        :returns: A System.Collections.Generic.IEnumerator`1 that can be used to iterate through the collection.
        """
        ...

    @typing.overload
    def GetEnumerator(self) -> System.Collections.IEnumerator:
        """
        Returns an enumerator that iterates through a collection.
        
        :returns: An System.Collections.IEnumerator object that can be used to iterate through the collection.
        """
        ...

    def Add(self, item: QuantConnect_Indicators_RollingWindow_T) -> None:
        """
        Adds an item to this window and shifts all other elements
        
        :param item: The item to be added
        """
        ...

    def Reset(self) -> None:
        """Clears this window of all data"""
        ...


