import numpy as np
from .spherical_data import SphericalData as SphericalData
from _typeshed import Incomplete
from panorai.preprocessing.preprocessor import Preprocessor as Preprocessor

class EquirectangularImage(SphericalData):
    shadow_angle: Incomplete
    sampler: Incomplete
    projection: Incomplete
    def __init__(self, data: np.ndarray | dict, shadow_angle: float = 0.0, lat: float = 0.0, lon: float = 0.0) -> None: ...
    def attach_sampler(self, name: str, **kwargs): ...
    def attach_projection(self, name: str, lat: float = 0.0, lon: float = 0.0, fov: float = 90.0, **kwargs): ...
    data: Incomplete
    def preprocess(self, delta_lat: float = 0.0, delta_lon: float = 0.0, shadow_angle: float = 0.0, resize_factor: float | None = None, preprocessing_config: dict = None): ...
    def to_gnomonic(self, lat: float, lon: float, fov: float, **kwargs) -> GnomonicFace: ...
    def to_gnomonic_face_set(self, fov: float = 90.0, sampling_method: str | None = None, rotations: list[tuple[float, float]] = []) -> GnomonicFaceSet: ...
    def augment_with_rotations(self, tangent_points: list[tuple[float, float]], rotations: list[tuple[float, float]]) -> list[tuple[float, float]]: ...
    def to_pcd(self, grad_threshold: float = 1.0, min_radius: float = 0.5, max_radius: float = 30.0): ...
    def clone(self) -> EquirectangularImage: ...
    @property
    def shape(self) -> tuple[int, ...]: ...
    def show(self) -> None: ...
