import numpy as np
from ..utils.exceptions import ChannelMismatchError as ChannelMismatchError, InvalidDataError as InvalidDataError
from .utils.shape_manager import ShapeManager as ShapeManager
from _typeshed import Incomplete
from typing import Callable

TensorOrArray: Incomplete
MultiChannelDict = dict[str, TensorOrArray]

class MultiChannelHandler:
    data: np.ndarray | dict[str, np.ndarray]
    def __init__(self, data: np.ndarray | dict[str, np.ndarray]) -> None: ...
    def is_multi_channel(self) -> bool: ...
    def get_channels(self) -> list[str]: ...
    def stack(self) -> tuple[np.ndarray, list[str], list[int]]: ...
    def unstack(self, stacked_data: np.ndarray, keys_order: list[str], channel_counts: list[int]) -> None: ...
    def apply_on_stacked(self, func: Callable[[np.ndarray], np.ndarray]) -> MultiChannelHandler: ...
    def apply_projection(self, projection: Callable[[np.ndarray], np.ndarray]) -> np.ndarray | dict[str, np.ndarray]: ...
    def preprocess(self, preprocess_func: Callable[[np.ndarray], np.ndarray]) -> None: ...
    def get_shape(self) -> tuple[int, int, int]: ...
    def data_clone(self) -> np.ndarray | MultiChannelDict: ...
    def set_type(self) -> None: ...
    def squeeze_singleton_channels(self) -> None: ...
