import numpy as np
from .array_data import ArrayLikeData as ArrayLikeData
from .multi_data import MultiChannelData as MultiChannelData
from _typeshed import Incomplete
from abc import ABC

class SphericalData(ArrayLikeData, MultiChannelData, ABC):
    lat: Incomplete
    lon: Incomplete
    projection: Incomplete
    def __init__(self, data: np.ndarray | dict[str, np.ndarray], lat: float = 0.0, lon: float = 0.0) -> None: ...
    def update_attributes(self, lat, lon, fov): ...
    def dynamic_projection(self, lat: Incomplete | None = None, lon: Incomplete | None = None, fov: Incomplete | None = None, **kwargs): ...
    def get_data(self) -> np.ndarray: ...
    @property
    def data(self) -> np.ndarray | dict[str, np.ndarray]: ...
    @data.setter
    def data(self, new_data: np.ndarray | dict[str, np.ndarray]): ...
    def attach_projection(self, name: str, **kwargs): ...
    def attach_sampler(self, name: str, **kwargs): ...
    def to_numpy(self, dtype: Incomplete | None = None, copy: bool = True) -> np.ndarray: ...
