import numpy as np
from .data import PCD as PCD
from _typeshed import Incomplete

class PCDHandler:
    @staticmethod
    def create_axis_arrows(scale: float = 1.0, shift: float = 1.0): ...
    @staticmethod
    def mask_high_gradient(depth_map: np.ndarray, threshold: float = 0.1) -> np.ndarray: ...
    @staticmethod
    def to_xyz(lat, lon, R: float = 1.0): ...
    @staticmethod
    def compute_rotation_matrices(lat, lon): ...
    @staticmethod
    def rotate_ccs_to_wcs(xyz_points: np.ndarray, lat: float, lon: float) -> np.ndarray: ...
    @staticmethod
    def gnomonic_face_to_pcd(face, model, depth: np.ndarray = None, grad_threshold: float = 0.1, min_radius: float = 0.0, max_radius: float = 10.0, inter_mask: np.ndarray = None): ...
    def gnomonic_faceset_to_pcd(faceset, model, depth, eq_shape=(512, 1024), grad_threshold: float = 0.1, min_radius: float = 0.0, max_radius: float = 20.0, feather_exp: float = 1.0, blender_name: str = 'simple'): ...
    @staticmethod
    def equirectangular_image_to_pcd(eq_img, eq_radial: Incomplete | None = None, grad_threshold: float = 1.0, min_radius: float = 0.0, max_radius: float = 999999.0): ...
