from ...config.registry import ConfigRegistry as ConfigRegistry
from ...utils.exceptions import ConfigurationError as ConfigurationError
from _typeshed import Incomplete
from enum import Enum
from pydantic import BaseModel
from typing import Any

ConfigDict = dict
logger: Incomplete

class OpenCVInterpolation(Enum):
    INTER_NEAREST = ...
    INTER_LINEAR = ...
    INTER_CUBIC = ...
    INTER_LANCZOS4 = ...

class OpenCVBorderMode(Enum):
    BORDER_CONSTANT = ...
    BORDER_REPLICATE = ...
    BORDER_REFLECT = ...
    BORDER_WRAP = ...
    BORDER_REFLECT_101 = ...
    BORDER_TRANSPARENT = ...

class GnomonicConfigModel(BaseModel):
    R: float
    phi1_deg: float
    lam0_deg: float
    fov_deg: float
    x_points: int
    y_points: int
    lon_points: int
    lat_points: int
    lon_min: float
    lon_max: float
    lat_min: float
    lat_max: float
    interpolation: OpenCVInterpolation
    borderMode: OpenCVBorderMode
    borderValue: Any | None
    def validate_fov(cls, v): ...
    model_config: Incomplete

class GnomonicConfig:
    def __init__(self, **kwargs: Any) -> None: ...
    def update(self, **kwargs: Any) -> None: ...
    def __getattr__(self, item: str) -> Any: ...
    def __getitem__(self, key: str) -> Any: ...
    def __iter__(self): ...
