import { IConstruct } from 'constructs';
import { PolicyStatement } from './policy-statement';
import { AddToPrincipalPolicyResult, IPrincipal, PrincipalPolicyFragment } from './principals';
/**
 * Properties for an UnknownPrincipal.
 *
 * @stability stable
 */
export interface UnknownPrincipalProps {
    /**
     * The resource the role proxy is for.
     *
     * @stability stable
     */
    readonly resource: IConstruct;
}
/**
 * A principal for use in resources that need to have a role but it's unknown.
 *
 * Some resources have roles associated with them which they assume, such as
 * Lambda Functions, CodeBuild projects, StepFunctions machines, etc.
 *
 * When those resources are imported, their actual roles are not always
 * imported with them. When that happens, we use an instance of this class
 * instead, which will add user warnings when statements are attempted to be
 * added to it.
 *
 * @stability stable
 */
export declare class UnknownPrincipal implements IPrincipal {
    /**
     * When this Principal is used in an AssumeRole policy, the action to use.
     *
     * @stability stable
     */
    readonly assumeRoleAction: string;
    /**
     * The principal to grant permissions to.
     *
     * @stability stable
     */
    readonly grantPrincipal: IPrincipal;
    private readonly resource;
    /**
     * @stability stable
     */
    constructor(props: UnknownPrincipalProps);
    /**
     * Return the policy fragment that identifies this principal in a Policy.
     *
     * @stability stable
     */
    get policyFragment(): PrincipalPolicyFragment;
    /**
     * Add to the policy of this principal.
     *
     * @stability stable
     */
    addToPrincipalPolicy(statement: PolicyStatement): AddToPrincipalPolicyResult;
    /**
     * Add to the policy of this principal.
     *
     * @stability stable
     */
    addToPolicy(statement: PolicyStatement): boolean;
}
