"""File generated by TLObjects' generator. All changes will be ERASED"""
from ...tl.tlobject import TLObject
from ...tl.tlobject import TLRequest
from typing import Optional, List, Union, TYPE_CHECKING
import os
import struct
from datetime import datetime
if TYPE_CHECKING:
    from ...tl.types import TypeChatBannedRights, TypeInlineBotSwitchPM, TypeInputBotInlineMessageID, TypeInputBotInlineResult, TypeInputChatPhoto, TypeInputDialogPeer, TypeInputDocument, TypeInputEncryptedChat, TypeInputEncryptedFile, TypeInputGeoPoint, TypeInputMedia, TypeInputMessage, TypeInputPeer, TypeInputSingleMedia, TypeInputStickerSet, TypeInputStickeredMedia, TypeInputUser, TypeMessageEntity, TypeMessagesFilter, TypeReplyMarkup, TypeReportReason, TypeSendMessageAction, TypeShippingOption



class AcceptEncryptionRequest(TLRequest):
    CONSTRUCTOR_ID = 0x3dbc0415
    SUBCLASS_OF_ID = 0x6d28a37a

    def __init__(self, peer: 'TypeInputEncryptedChat', g_b: bytes, key_fingerprint: int):
        """
        :returns EncryptedChat: Instance of either EncryptedChatEmpty, EncryptedChatWaiting, EncryptedChatRequested, EncryptedChat, EncryptedChatDiscarded.
        """
        self.peer = peer
        self.g_b = g_b
        self.key_fingerprint = key_fingerprint

    def to_dict(self):
        return {
            '_': 'AcceptEncryptionRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'g_b': self.g_b,
            'key_fingerprint': self.key_fingerprint
        }

    def __bytes__(self):
        return b''.join((
            b'\x15\x04\xbc=',
            bytes(self.peer),
            self.serialize_bytes(self.g_b),
            struct.pack('<q', self.key_fingerprint),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _g_b = reader.tgread_bytes()
        _key_fingerprint = reader.read_long()
        return cls(peer=_peer, g_b=_g_b, key_fingerprint=_key_fingerprint)


class AcceptUrlAuthRequest(TLRequest):
    CONSTRUCTOR_ID = 0xf729ea98
    SUBCLASS_OF_ID = 0x7765cb1e

    def __init__(self, peer: 'TypeInputPeer', msg_id: int, button_id: int, write_allowed: Optional[bool]=None):
        """
        :returns UrlAuthResult: Instance of either UrlAuthResultRequest, UrlAuthResultAccepted, UrlAuthResultDefault.
        """
        self.peer = peer
        self.msg_id = msg_id
        self.button_id = button_id
        self.write_allowed = write_allowed

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'AcceptUrlAuthRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'msg_id': self.msg_id,
            'button_id': self.button_id,
            'write_allowed': self.write_allowed
        }

    def __bytes__(self):
        return b''.join((
            b'\x98\xea)\xf7',
            struct.pack('<I', (0 if self.write_allowed is None or self.write_allowed is False else 1)),
            bytes(self.peer),
            struct.pack('<i', self.msg_id),
            struct.pack('<i', self.button_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _write_allowed = bool(flags & 1)
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        _button_id = reader.read_int()
        return cls(peer=_peer, msg_id=_msg_id, button_id=_button_id, write_allowed=_write_allowed)


class AddChatUserRequest(TLRequest):
    CONSTRUCTOR_ID = 0xf9a0aa09
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, chat_id: int, user_id: 'TypeInputUser', fwd_limit: int):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.chat_id = chat_id
        self.user_id = user_id
        self.fwd_limit = fwd_limit

    async def resolve(self, client, utils):
        self.chat_id = await client.get_peer_id(self.chat_id, add_mark=False)
        self.user_id = utils.get_input_user(await client.get_input_entity(self.user_id))

    def to_dict(self):
        return {
            '_': 'AddChatUserRequest',
            'chat_id': self.chat_id,
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id,
            'fwd_limit': self.fwd_limit
        }

    def __bytes__(self):
        return b''.join((
            b'\t\xaa\xa0\xf9',
            struct.pack('<i', self.chat_id),
            bytes(self.user_id),
            struct.pack('<i', self.fwd_limit),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_int()
        _user_id = reader.tgread_object()
        _fwd_limit = reader.read_int()
        return cls(chat_id=_chat_id, user_id=_user_id, fwd_limit=_fwd_limit)


class CheckChatInviteRequest(TLRequest):
    CONSTRUCTOR_ID = 0x3eadb1bb
    SUBCLASS_OF_ID = 0x4561736

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: str):
        """
        :returns ChatInvite: Instance of either ChatInviteAlready, ChatInvite.
        """
        self.hash = hash

    def to_dict(self):
        return {
            '_': 'CheckChatInviteRequest',
            'hash': self.hash
        }

    def __bytes__(self):
        return b''.join((
            b'\xbb\xb1\xad>',
            self.serialize_bytes(self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.tgread_string()
        return cls(hash=_hash)


class ClearAllDraftsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x7e58ee9c
    SUBCLASS_OF_ID = 0xf5b399ac

    def to_dict(self):
        return {
            '_': 'ClearAllDraftsRequest'
        }

    def __bytes__(self):
        return b''.join((
            b'\x9c\xeeX~',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ClearRecentStickersRequest(TLRequest):
    CONSTRUCTOR_ID = 0x8999602d
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, attached: Optional[bool]=None):
        """
        :returns Bool: This type has no constructors.
        """
        self.attached = attached

    def to_dict(self):
        return {
            '_': 'ClearRecentStickersRequest',
            'attached': self.attached
        }

    def __bytes__(self):
        return b''.join((
            b'-`\x99\x89',
            struct.pack('<I', (0 if self.attached is None or self.attached is False else 1)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _attached = bool(flags & 1)
        return cls(attached=_attached)


class CreateChatRequest(TLRequest):
    CONSTRUCTOR_ID = 0x9cb126e
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, users: List['TypeInputUser'], title: str):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.users = users
        self.title = title

    async def resolve(self, client, utils):
        _tmp = []
        for _x in self.users:
            _tmp.append(utils.get_input_user(await client.get_input_entity(_x)))

        self.users = _tmp

    def to_dict(self):
        return {
            '_': 'CreateChatRequest',
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users],
            'title': self.title
        }

    def __bytes__(self):
        return b''.join((
            b'n\x12\xcb\t',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(bytes(x) for x in self.users),
            self.serialize_bytes(self.title),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        _title = reader.tgread_string()
        return cls(users=_users, title=_title)


class DeleteChatUserRequest(TLRequest):
    CONSTRUCTOR_ID = 0xe0611f16
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, chat_id: int, user_id: 'TypeInputUser'):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.chat_id = chat_id
        self.user_id = user_id

    async def resolve(self, client, utils):
        self.chat_id = await client.get_peer_id(self.chat_id, add_mark=False)
        self.user_id = utils.get_input_user(await client.get_input_entity(self.user_id))

    def to_dict(self):
        return {
            '_': 'DeleteChatUserRequest',
            'chat_id': self.chat_id,
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id
        }

    def __bytes__(self):
        return b''.join((
            b'\x16\x1fa\xe0',
            struct.pack('<i', self.chat_id),
            bytes(self.user_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_int()
        _user_id = reader.tgread_object()
        return cls(chat_id=_chat_id, user_id=_user_id)


class DeleteHistoryRequest(TLRequest):
    CONSTRUCTOR_ID = 0x1c015b09
    SUBCLASS_OF_ID = 0x2c49c116

    def __init__(self, peer: 'TypeInputPeer', max_id: int, just_clear: Optional[bool]=None, revoke: Optional[bool]=None):
        """
        :returns messages.AffectedHistory: Instance of AffectedHistory.
        """
        self.peer = peer
        self.max_id = max_id
        self.just_clear = just_clear
        self.revoke = revoke

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'DeleteHistoryRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'max_id': self.max_id,
            'just_clear': self.just_clear,
            'revoke': self.revoke
        }

    def __bytes__(self):
        return b''.join((
            b'\t[\x01\x1c',
            struct.pack('<I', (0 if self.just_clear is None or self.just_clear is False else 1) | (0 if self.revoke is None or self.revoke is False else 2)),
            bytes(self.peer),
            struct.pack('<i', self.max_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _just_clear = bool(flags & 1)
        _revoke = bool(flags & 2)
        _peer = reader.tgread_object()
        _max_id = reader.read_int()
        return cls(peer=_peer, max_id=_max_id, just_clear=_just_clear, revoke=_revoke)


class DeleteMessagesRequest(TLRequest):
    CONSTRUCTOR_ID = 0xe58e95d2
    SUBCLASS_OF_ID = 0xced3c06e

    # noinspection PyShadowingBuiltins
    def __init__(self, id: List[int], revoke: Optional[bool]=None):
        """
        :returns messages.AffectedMessages: Instance of AffectedMessages.
        """
        self.id = id
        self.revoke = revoke

    def to_dict(self):
        return {
            '_': 'DeleteMessagesRequest',
            'id': [] if self.id is None else self.id[:],
            'revoke': self.revoke
        }

    def __bytes__(self):
        return b''.join((
            b'\xd2\x95\x8e\xe5',
            struct.pack('<I', (0 if self.revoke is None or self.revoke is False else 1)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _revoke = bool(flags & 1)
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        return cls(id=_id, revoke=_revoke)


class DeleteScheduledMessagesRequest(TLRequest):
    CONSTRUCTOR_ID = 0x59ae2b16
    SUBCLASS_OF_ID = 0x8af52aac

    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: List[int]):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.peer = peer
        self.id = id

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'DeleteScheduledMessagesRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'id': [] if self.id is None else self.id[:]
        }

    def __bytes__(self):
        return b''.join((
            b'\x16+\xaeY',
            bytes(self.peer),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        return cls(peer=_peer, id=_id)


class DiscardEncryptionRequest(TLRequest):
    CONSTRUCTOR_ID = 0xedd923c5
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, chat_id: int):
        """
        :returns Bool: This type has no constructors.
        """
        self.chat_id = chat_id

    def to_dict(self):
        return {
            '_': 'DiscardEncryptionRequest',
            'chat_id': self.chat_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xc5#\xd9\xed',
            struct.pack('<i', self.chat_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_int()
        return cls(chat_id=_chat_id)


class EditChatAboutRequest(TLRequest):
    CONSTRUCTOR_ID = 0xdef60797
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, peer: 'TypeInputPeer', about: str):
        """
        :returns Bool: This type has no constructors.
        """
        self.peer = peer
        self.about = about

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'EditChatAboutRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'about': self.about
        }

    def __bytes__(self):
        return b''.join((
            b'\x97\x07\xf6\xde',
            bytes(self.peer),
            self.serialize_bytes(self.about),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _about = reader.tgread_string()
        return cls(peer=_peer, about=_about)


class EditChatAdminRequest(TLRequest):
    CONSTRUCTOR_ID = 0xa9e69f2e
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, chat_id: int, user_id: 'TypeInputUser', is_admin: bool):
        """
        :returns Bool: This type has no constructors.
        """
        self.chat_id = chat_id
        self.user_id = user_id
        self.is_admin = is_admin

    async def resolve(self, client, utils):
        self.chat_id = await client.get_peer_id(self.chat_id, add_mark=False)
        self.user_id = utils.get_input_user(await client.get_input_entity(self.user_id))

    def to_dict(self):
        return {
            '_': 'EditChatAdminRequest',
            'chat_id': self.chat_id,
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id,
            'is_admin': self.is_admin
        }

    def __bytes__(self):
        return b''.join((
            b'.\x9f\xe6\xa9',
            struct.pack('<i', self.chat_id),
            bytes(self.user_id),
            b'\xb5ur\x99' if self.is_admin else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_int()
        _user_id = reader.tgread_object()
        _is_admin = reader.tgread_bool()
        return cls(chat_id=_chat_id, user_id=_user_id, is_admin=_is_admin)


class EditChatDefaultBannedRightsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xa5866b41
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, peer: 'TypeInputPeer', banned_rights: 'TypeChatBannedRights'):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.peer = peer
        self.banned_rights = banned_rights

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'EditChatDefaultBannedRightsRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'banned_rights': self.banned_rights.to_dict() if isinstance(self.banned_rights, TLObject) else self.banned_rights
        }

    def __bytes__(self):
        return b''.join((
            b'Ak\x86\xa5',
            bytes(self.peer),
            bytes(self.banned_rights),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _banned_rights = reader.tgread_object()
        return cls(peer=_peer, banned_rights=_banned_rights)


class EditChatPhotoRequest(TLRequest):
    CONSTRUCTOR_ID = 0xca4c79d8
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, chat_id: int, photo: 'TypeInputChatPhoto'):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.chat_id = chat_id
        self.photo = photo

    async def resolve(self, client, utils):
        self.chat_id = await client.get_peer_id(self.chat_id, add_mark=False)
        self.photo = utils.get_input_chat_photo(self.photo)

    def to_dict(self):
        return {
            '_': 'EditChatPhotoRequest',
            'chat_id': self.chat_id,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo
        }

    def __bytes__(self):
        return b''.join((
            b'\xd8yL\xca',
            struct.pack('<i', self.chat_id),
            bytes(self.photo),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_int()
        _photo = reader.tgread_object()
        return cls(chat_id=_chat_id, photo=_photo)


class EditChatTitleRequest(TLRequest):
    CONSTRUCTOR_ID = 0xdc452855
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, chat_id: int, title: str):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.chat_id = chat_id
        self.title = title

    async def resolve(self, client, utils):
        self.chat_id = await client.get_peer_id(self.chat_id, add_mark=False)

    def to_dict(self):
        return {
            '_': 'EditChatTitleRequest',
            'chat_id': self.chat_id,
            'title': self.title
        }

    def __bytes__(self):
        return b''.join((
            b'U(E\xdc',
            struct.pack('<i', self.chat_id),
            self.serialize_bytes(self.title),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_int()
        _title = reader.tgread_string()
        return cls(chat_id=_chat_id, title=_title)


class EditInlineBotMessageRequest(TLRequest):
    CONSTRUCTOR_ID = 0x83557dba
    SUBCLASS_OF_ID = 0xf5b399ac

    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputBotInlineMessageID', no_webpage: Optional[bool]=None, message: Optional[str]=None, media: Optional['TypeInputMedia']=None, reply_markup: Optional['TypeReplyMarkup']=None, entities: Optional[List['TypeMessageEntity']]=None):
        """
        :returns Bool: This type has no constructors.
        """
        self.id = id
        self.no_webpage = no_webpage
        self.message = message
        self.media = media
        self.reply_markup = reply_markup
        self.entities = entities

    async def resolve(self, client, utils):
        if self.media:
            self.media = utils.get_input_media(self.media)

    def to_dict(self):
        return {
            '_': 'EditInlineBotMessageRequest',
            'id': self.id.to_dict() if isinstance(self.id, TLObject) else self.id,
            'no_webpage': self.no_webpage,
            'message': self.message,
            'media': self.media.to_dict() if isinstance(self.media, TLObject) else self.media,
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities]
        }

    def __bytes__(self):
        return b''.join((
            b'\xba}U\x83',
            struct.pack('<I', (0 if self.no_webpage is None or self.no_webpage is False else 2) | (0 if self.message is None or self.message is False else 2048) | (0 if self.media is None or self.media is False else 16384) | (0 if self.reply_markup is None or self.reply_markup is False else 4) | (0 if self.entities is None or self.entities is False else 8)),
            bytes(self.id),
            b'' if self.message is None or self.message is False else (self.serialize_bytes(self.message)),
            b'' if self.media is None or self.media is False else (bytes(self.media)),
            b'' if self.reply_markup is None or self.reply_markup is False else (bytes(self.reply_markup)),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(bytes(x) for x in self.entities))),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _no_webpage = bool(flags & 2)
        _id = reader.tgread_object()
        if flags & 2048:
            _message = reader.tgread_string()
        else:
            _message = None
        if flags & 16384:
            _media = reader.tgread_object()
        else:
            _media = None
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        if flags & 8:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        return cls(id=_id, no_webpage=_no_webpage, message=_message, media=_media, reply_markup=_reply_markup, entities=_entities)


class EditMessageRequest(TLRequest):
    CONSTRUCTOR_ID = 0x48f71778
    SUBCLASS_OF_ID = 0x8af52aac

    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: int, no_webpage: Optional[bool]=None, message: Optional[str]=None, media: Optional['TypeInputMedia']=None, reply_markup: Optional['TypeReplyMarkup']=None, entities: Optional[List['TypeMessageEntity']]=None, schedule_date: Optional[datetime]=None):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.peer = peer
        self.id = id
        self.no_webpage = no_webpage
        self.message = message
        self.media = media
        self.reply_markup = reply_markup
        self.entities = entities
        self.schedule_date = schedule_date

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))
        if self.media:
            self.media = utils.get_input_media(self.media)

    def to_dict(self):
        return {
            '_': 'EditMessageRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'id': self.id,
            'no_webpage': self.no_webpage,
            'message': self.message,
            'media': self.media.to_dict() if isinstance(self.media, TLObject) else self.media,
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities],
            'schedule_date': self.schedule_date
        }

    def __bytes__(self):
        return b''.join((
            b'x\x17\xf7H',
            struct.pack('<I', (0 if self.no_webpage is None or self.no_webpage is False else 2) | (0 if self.message is None or self.message is False else 2048) | (0 if self.media is None or self.media is False else 16384) | (0 if self.reply_markup is None or self.reply_markup is False else 4) | (0 if self.entities is None or self.entities is False else 8) | (0 if self.schedule_date is None or self.schedule_date is False else 32768)),
            bytes(self.peer),
            struct.pack('<i', self.id),
            b'' if self.message is None or self.message is False else (self.serialize_bytes(self.message)),
            b'' if self.media is None or self.media is False else (bytes(self.media)),
            b'' if self.reply_markup is None or self.reply_markup is False else (bytes(self.reply_markup)),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(bytes(x) for x in self.entities))),
            b'' if self.schedule_date is None or self.schedule_date is False else (self.serialize_datetime(self.schedule_date)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _no_webpage = bool(flags & 2)
        _peer = reader.tgread_object()
        _id = reader.read_int()
        if flags & 2048:
            _message = reader.tgread_string()
        else:
            _message = None
        if flags & 16384:
            _media = reader.tgread_object()
        else:
            _media = None
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        if flags & 8:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 32768:
            _schedule_date = reader.tgread_date()
        else:
            _schedule_date = None
        return cls(peer=_peer, id=_id, no_webpage=_no_webpage, message=_message, media=_media, reply_markup=_reply_markup, entities=_entities, schedule_date=_schedule_date)


class ExportChatInviteRequest(TLRequest):
    CONSTRUCTOR_ID = 0xdf7534c
    SUBCLASS_OF_ID = 0xb4748a58

    def __init__(self, peer: 'TypeInputPeer'):
        """
        :returns ExportedChatInvite: Instance of either ChatInviteEmpty, ChatInviteExported.
        """
        self.peer = peer

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'ExportChatInviteRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def __bytes__(self):
        return b''.join((
            b'LS\xf7\r',
            bytes(self.peer),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


class FaveStickerRequest(TLRequest):
    CONSTRUCTOR_ID = 0xb9ffc55b
    SUBCLASS_OF_ID = 0xf5b399ac

    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputDocument', unfave: bool):
        """
        :returns Bool: This type has no constructors.
        """
        self.id = id
        self.unfave = unfave

    async def resolve(self, client, utils):
        self.id = utils.get_input_document(self.id)

    def to_dict(self):
        return {
            '_': 'FaveStickerRequest',
            'id': self.id.to_dict() if isinstance(self.id, TLObject) else self.id,
            'unfave': self.unfave
        }

    def __bytes__(self):
        return b''.join((
            b'[\xc5\xff\xb9',
            bytes(self.id),
            b'\xb5ur\x99' if self.unfave else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_object()
        _unfave = reader.tgread_bool()
        return cls(id=_id, unfave=_unfave)


class ForwardMessagesRequest(TLRequest):
    CONSTRUCTOR_ID = 0xd9fee60e
    SUBCLASS_OF_ID = 0x8af52aac

    # noinspection PyShadowingBuiltins
    def __init__(self, from_peer: 'TypeInputPeer', id: List[int], to_peer: 'TypeInputPeer', silent: Optional[bool]=None, background: Optional[bool]=None, with_my_score: Optional[bool]=None, grouped: Optional[bool]=None, random_id: List[int]=None, schedule_date: Optional[datetime]=None):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.from_peer = from_peer
        self.id = id
        self.to_peer = to_peer
        self.silent = silent
        self.background = background
        self.with_my_score = with_my_score
        self.grouped = grouped
        self.random_id = random_id if random_id is not None else [int.from_bytes(os.urandom(8), 'big', signed=True) for _ in range(len(id))]
        self.schedule_date = schedule_date

    async def resolve(self, client, utils):
        self.from_peer = utils.get_input_peer(await client.get_input_entity(self.from_peer))
        self.to_peer = utils.get_input_peer(await client.get_input_entity(self.to_peer))

    def to_dict(self):
        return {
            '_': 'ForwardMessagesRequest',
            'from_peer': self.from_peer.to_dict() if isinstance(self.from_peer, TLObject) else self.from_peer,
            'id': [] if self.id is None else self.id[:],
            'to_peer': self.to_peer.to_dict() if isinstance(self.to_peer, TLObject) else self.to_peer,
            'silent': self.silent,
            'background': self.background,
            'with_my_score': self.with_my_score,
            'grouped': self.grouped,
            'random_id': [] if self.random_id is None else self.random_id[:],
            'schedule_date': self.schedule_date
        }

    def __bytes__(self):
        return b''.join((
            b'\x0e\xe6\xfe\xd9',
            struct.pack('<I', (0 if self.silent is None or self.silent is False else 32) | (0 if self.background is None or self.background is False else 64) | (0 if self.with_my_score is None or self.with_my_score is False else 256) | (0 if self.grouped is None or self.grouped is False else 512) | (0 if self.schedule_date is None or self.schedule_date is False else 1024)),
            bytes(self.from_peer),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.random_id)),b''.join(struct.pack('<q', x) for x in self.random_id),
            bytes(self.to_peer),
            b'' if self.schedule_date is None or self.schedule_date is False else (self.serialize_datetime(self.schedule_date)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _silent = bool(flags & 32)
        _background = bool(flags & 64)
        _with_my_score = bool(flags & 256)
        _grouped = bool(flags & 512)
        _from_peer = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        reader.read_int()
        _random_id = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _random_id.append(_x)

        _to_peer = reader.tgread_object()
        if flags & 1024:
            _schedule_date = reader.tgread_date()
        else:
            _schedule_date = None
        return cls(from_peer=_from_peer, id=_id, to_peer=_to_peer, silent=_silent, background=_background, with_my_score=_with_my_score, grouped=_grouped, random_id=_random_id, schedule_date=_schedule_date)


class GetAllChatsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xeba80ff0
    SUBCLASS_OF_ID = 0x99d5cb14

    def __init__(self, except_ids: List[int]):
        """
        :returns messages.Chats: Instance of either Chats, ChatsSlice.
        """
        self.except_ids = except_ids

    def to_dict(self):
        return {
            '_': 'GetAllChatsRequest',
            'except_ids': [] if self.except_ids is None else self.except_ids[:]
        }

    def __bytes__(self):
        return b''.join((
            b'\xf0\x0f\xa8\xeb',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.except_ids)),b''.join(struct.pack('<i', x) for x in self.except_ids),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _except_ids = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _except_ids.append(_x)

        return cls(except_ids=_except_ids)


class GetAllDraftsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x6a3f8d65
    SUBCLASS_OF_ID = 0x8af52aac

    def to_dict(self):
        return {
            '_': 'GetAllDraftsRequest'
        }

    def __bytes__(self):
        return b''.join((
            b'e\x8d?j',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class GetAllStickersRequest(TLRequest):
    CONSTRUCTOR_ID = 0x1c9618b1
    SUBCLASS_OF_ID = 0x45834829

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int):
        """
        :returns messages.AllStickers: Instance of either AllStickersNotModified, AllStickers.
        """
        self.hash = hash

    def to_dict(self):
        return {
            '_': 'GetAllStickersRequest',
            'hash': self.hash
        }

    def __bytes__(self):
        return b''.join((
            b'\xb1\x18\x96\x1c',
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.read_int()
        return cls(hash=_hash)


class GetArchivedStickersRequest(TLRequest):
    CONSTRUCTOR_ID = 0x57f17692
    SUBCLASS_OF_ID = 0x7296d771

    def __init__(self, offset_id: int, limit: int, masks: Optional[bool]=None):
        """
        :returns messages.ArchivedStickers: Instance of ArchivedStickers.
        """
        self.offset_id = offset_id
        self.limit = limit
        self.masks = masks

    def to_dict(self):
        return {
            '_': 'GetArchivedStickersRequest',
            'offset_id': self.offset_id,
            'limit': self.limit,
            'masks': self.masks
        }

    def __bytes__(self):
        return b''.join((
            b'\x92v\xf1W',
            struct.pack('<I', (0 if self.masks is None or self.masks is False else 1)),
            struct.pack('<q', self.offset_id),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _masks = bool(flags & 1)
        _offset_id = reader.read_long()
        _limit = reader.read_int()
        return cls(offset_id=_offset_id, limit=_limit, masks=_masks)


class GetAttachedStickersRequest(TLRequest):
    CONSTRUCTOR_ID = 0xcc5b67cc
    SUBCLASS_OF_ID = 0xcc125f6b

    def __init__(self, media: 'TypeInputStickeredMedia'):
        """
        :returns Vector<StickerSetCovered>: This type has no constructors.
        """
        self.media = media

    def to_dict(self):
        return {
            '_': 'GetAttachedStickersRequest',
            'media': self.media.to_dict() if isinstance(self.media, TLObject) else self.media
        }

    def __bytes__(self):
        return b''.join((
            b'\xccg[\xcc',
            bytes(self.media),
        ))

    @classmethod
    def from_reader(cls, reader):
        _media = reader.tgread_object()
        return cls(media=_media)


class GetBotCallbackAnswerRequest(TLRequest):
    CONSTRUCTOR_ID = 0x810a9fec
    SUBCLASS_OF_ID = 0x6c4dd18c

    def __init__(self, peer: 'TypeInputPeer', msg_id: int, game: Optional[bool]=None, data: Optional[bytes]=None):
        """
        :returns messages.BotCallbackAnswer: Instance of BotCallbackAnswer.
        """
        self.peer = peer
        self.msg_id = msg_id
        self.game = game
        self.data = data

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'GetBotCallbackAnswerRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'msg_id': self.msg_id,
            'game': self.game,
            'data': self.data
        }

    def __bytes__(self):
        return b''.join((
            b'\xec\x9f\n\x81',
            struct.pack('<I', (0 if self.game is None or self.game is False else 2) | (0 if self.data is None or self.data is False else 1)),
            bytes(self.peer),
            struct.pack('<i', self.msg_id),
            b'' if self.data is None or self.data is False else (self.serialize_bytes(self.data)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _game = bool(flags & 2)
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        if flags & 1:
            _data = reader.tgread_bytes()
        else:
            _data = None
        return cls(peer=_peer, msg_id=_msg_id, game=_game, data=_data)


class GetChatsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x3c6aa187
    SUBCLASS_OF_ID = 0x99d5cb14

    # noinspection PyShadowingBuiltins
    def __init__(self, id: List[int]):
        """
        :returns messages.Chats: Instance of either Chats, ChatsSlice.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'GetChatsRequest',
            'id': [] if self.id is None else self.id[:]
        }

    def __bytes__(self):
        return b''.join((
            b'\x87\xa1j<',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        return cls(id=_id)


class GetCommonChatsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xd0a48c4
    SUBCLASS_OF_ID = 0x99d5cb14

    def __init__(self, user_id: 'TypeInputUser', max_id: int, limit: int):
        """
        :returns messages.Chats: Instance of either Chats, ChatsSlice.
        """
        self.user_id = user_id
        self.max_id = max_id
        self.limit = limit

    async def resolve(self, client, utils):
        self.user_id = utils.get_input_user(await client.get_input_entity(self.user_id))

    def to_dict(self):
        return {
            '_': 'GetCommonChatsRequest',
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id,
            'max_id': self.max_id,
            'limit': self.limit
        }

    def __bytes__(self):
        return b''.join((
            b'\xc4H\n\r',
            bytes(self.user_id),
            struct.pack('<i', self.max_id),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.tgread_object()
        _max_id = reader.read_int()
        _limit = reader.read_int()
        return cls(user_id=_user_id, max_id=_max_id, limit=_limit)


class GetDhConfigRequest(TLRequest):
    CONSTRUCTOR_ID = 0x26cf8950
    SUBCLASS_OF_ID = 0xe488ed8b

    def __init__(self, version: int, random_length: int):
        """
        :returns messages.DhConfig: Instance of either DhConfigNotModified, DhConfig.
        """
        self.version = version
        self.random_length = random_length

    def to_dict(self):
        return {
            '_': 'GetDhConfigRequest',
            'version': self.version,
            'random_length': self.random_length
        }

    def __bytes__(self):
        return b''.join((
            b'P\x89\xcf&',
            struct.pack('<i', self.version),
            struct.pack('<i', self.random_length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _version = reader.read_int()
        _random_length = reader.read_int()
        return cls(version=_version, random_length=_random_length)


class GetDialogUnreadMarksRequest(TLRequest):
    CONSTRUCTOR_ID = 0x22e24e22
    SUBCLASS_OF_ID = 0xbec64ad9

    def to_dict(self):
        return {
            '_': 'GetDialogUnreadMarksRequest'
        }

    def __bytes__(self):
        return b''.join((
            b'"N\xe2"',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class GetDialogsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xa0ee3b73
    SUBCLASS_OF_ID = 0xe1b52ee

    # noinspection PyShadowingBuiltins
    def __init__(self, offset_date: Optional[datetime], offset_id: int, offset_peer: 'TypeInputPeer', limit: int, hash: int, exclude_pinned: Optional[bool]=None, folder_id: Optional[int]=None):
        """
        :returns messages.Dialogs: Instance of either Dialogs, DialogsSlice, DialogsNotModified.
        """
        self.offset_date = offset_date
        self.offset_id = offset_id
        self.offset_peer = offset_peer
        self.limit = limit
        self.hash = hash
        self.exclude_pinned = exclude_pinned
        self.folder_id = folder_id

    async def resolve(self, client, utils):
        self.offset_peer = utils.get_input_peer(await client.get_input_entity(self.offset_peer))

    def to_dict(self):
        return {
            '_': 'GetDialogsRequest',
            'offset_date': self.offset_date,
            'offset_id': self.offset_id,
            'offset_peer': self.offset_peer.to_dict() if isinstance(self.offset_peer, TLObject) else self.offset_peer,
            'limit': self.limit,
            'hash': self.hash,
            'exclude_pinned': self.exclude_pinned,
            'folder_id': self.folder_id
        }

    def __bytes__(self):
        return b''.join((
            b's;\xee\xa0',
            struct.pack('<I', (0 if self.exclude_pinned is None or self.exclude_pinned is False else 1) | (0 if self.folder_id is None or self.folder_id is False else 2)),
            b'' if self.folder_id is None or self.folder_id is False else (struct.pack('<i', self.folder_id)),
            self.serialize_datetime(self.offset_date),
            struct.pack('<i', self.offset_id),
            bytes(self.offset_peer),
            struct.pack('<i', self.limit),
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _exclude_pinned = bool(flags & 1)
        if flags & 2:
            _folder_id = reader.read_int()
        else:
            _folder_id = None
        _offset_date = reader.tgread_date()
        _offset_id = reader.read_int()
        _offset_peer = reader.tgread_object()
        _limit = reader.read_int()
        _hash = reader.read_int()
        return cls(offset_date=_offset_date, offset_id=_offset_id, offset_peer=_offset_peer, limit=_limit, hash=_hash, exclude_pinned=_exclude_pinned, folder_id=_folder_id)


class GetDocumentByHashRequest(TLRequest):
    CONSTRUCTOR_ID = 0x338e2464
    SUBCLASS_OF_ID = 0x211fe820

    def __init__(self, sha256: bytes, size: int, mime_type: str):
        """
        :returns Document: Instance of either DocumentEmpty, Document.
        """
        self.sha256 = sha256
        self.size = size
        self.mime_type = mime_type

    def to_dict(self):
        return {
            '_': 'GetDocumentByHashRequest',
            'sha256': self.sha256,
            'size': self.size,
            'mime_type': self.mime_type
        }

    def __bytes__(self):
        return b''.join((
            b'd$\x8e3',
            self.serialize_bytes(self.sha256),
            struct.pack('<i', self.size),
            self.serialize_bytes(self.mime_type),
        ))

    @classmethod
    def from_reader(cls, reader):
        _sha256 = reader.tgread_bytes()
        _size = reader.read_int()
        _mime_type = reader.tgread_string()
        return cls(sha256=_sha256, size=_size, mime_type=_mime_type)


class GetEmojiKeywordsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x35a0e062
    SUBCLASS_OF_ID = 0xd279c672

    def __init__(self, lang_code: str):
        """
        :returns EmojiKeywordsDifference: Instance of EmojiKeywordsDifference.
        """
        self.lang_code = lang_code

    def to_dict(self):
        return {
            '_': 'GetEmojiKeywordsRequest',
            'lang_code': self.lang_code
        }

    def __bytes__(self):
        return b''.join((
            b'b\xe0\xa05',
            self.serialize_bytes(self.lang_code),
        ))

    @classmethod
    def from_reader(cls, reader):
        _lang_code = reader.tgread_string()
        return cls(lang_code=_lang_code)


class GetEmojiKeywordsDifferenceRequest(TLRequest):
    CONSTRUCTOR_ID = 0x1508b6af
    SUBCLASS_OF_ID = 0xd279c672

    def __init__(self, lang_code: str, from_version: int):
        """
        :returns EmojiKeywordsDifference: Instance of EmojiKeywordsDifference.
        """
        self.lang_code = lang_code
        self.from_version = from_version

    def to_dict(self):
        return {
            '_': 'GetEmojiKeywordsDifferenceRequest',
            'lang_code': self.lang_code,
            'from_version': self.from_version
        }

    def __bytes__(self):
        return b''.join((
            b'\xaf\xb6\x08\x15',
            self.serialize_bytes(self.lang_code),
            struct.pack('<i', self.from_version),
        ))

    @classmethod
    def from_reader(cls, reader):
        _lang_code = reader.tgread_string()
        _from_version = reader.read_int()
        return cls(lang_code=_lang_code, from_version=_from_version)


class GetEmojiKeywordsLanguagesRequest(TLRequest):
    CONSTRUCTOR_ID = 0x4e9963b2
    SUBCLASS_OF_ID = 0xe795d387

    def __init__(self, lang_codes: List[str]):
        """
        :returns Vector<EmojiLanguage>: This type has no constructors.
        """
        self.lang_codes = lang_codes

    def to_dict(self):
        return {
            '_': 'GetEmojiKeywordsLanguagesRequest',
            'lang_codes': [] if self.lang_codes is None else self.lang_codes[:]
        }

    def __bytes__(self):
        return b''.join((
            b'\xb2c\x99N',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.lang_codes)),b''.join(self.serialize_bytes(x) for x in self.lang_codes),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _lang_codes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_string()
            _lang_codes.append(_x)

        return cls(lang_codes=_lang_codes)


class GetEmojiURLRequest(TLRequest):
    CONSTRUCTOR_ID = 0xd5b10c26
    SUBCLASS_OF_ID = 0x1fa08a19

    def __init__(self, lang_code: str):
        """
        :returns EmojiURL: Instance of EmojiURL.
        """
        self.lang_code = lang_code

    def to_dict(self):
        return {
            '_': 'GetEmojiURLRequest',
            'lang_code': self.lang_code
        }

    def __bytes__(self):
        return b''.join((
            b'&\x0c\xb1\xd5',
            self.serialize_bytes(self.lang_code),
        ))

    @classmethod
    def from_reader(cls, reader):
        _lang_code = reader.tgread_string()
        return cls(lang_code=_lang_code)


class GetFavedStickersRequest(TLRequest):
    CONSTRUCTOR_ID = 0x21ce0b0e
    SUBCLASS_OF_ID = 0x8e736fb9

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int):
        """
        :returns messages.FavedStickers: Instance of either FavedStickersNotModified, FavedStickers.
        """
        self.hash = hash

    def to_dict(self):
        return {
            '_': 'GetFavedStickersRequest',
            'hash': self.hash
        }

    def __bytes__(self):
        return b''.join((
            b'\x0e\x0b\xce!',
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.read_int()
        return cls(hash=_hash)


class GetFeaturedStickersRequest(TLRequest):
    CONSTRUCTOR_ID = 0x2dacca4f
    SUBCLASS_OF_ID = 0x2614b722

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int):
        """
        :returns messages.FeaturedStickers: Instance of either FeaturedStickersNotModified, FeaturedStickers.
        """
        self.hash = hash

    def to_dict(self):
        return {
            '_': 'GetFeaturedStickersRequest',
            'hash': self.hash
        }

    def __bytes__(self):
        return b''.join((
            b'O\xca\xac-',
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.read_int()
        return cls(hash=_hash)


class GetFullChatRequest(TLRequest):
    CONSTRUCTOR_ID = 0x3b831c66
    SUBCLASS_OF_ID = 0x225a5109

    def __init__(self, chat_id: int):
        """
        :returns messages.ChatFull: Instance of ChatFull.
        """
        self.chat_id = chat_id

    async def resolve(self, client, utils):
        self.chat_id = await client.get_peer_id(self.chat_id, add_mark=False)

    def to_dict(self):
        return {
            '_': 'GetFullChatRequest',
            'chat_id': self.chat_id
        }

    def __bytes__(self):
        return b''.join((
            b'f\x1c\x83;',
            struct.pack('<i', self.chat_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_int()
        return cls(chat_id=_chat_id)


class GetGameHighScoresRequest(TLRequest):
    CONSTRUCTOR_ID = 0xe822649d
    SUBCLASS_OF_ID = 0x6ccd95fd

    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: int, user_id: 'TypeInputUser'):
        """
        :returns messages.HighScores: Instance of HighScores.
        """
        self.peer = peer
        self.id = id
        self.user_id = user_id

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))
        self.user_id = utils.get_input_user(await client.get_input_entity(self.user_id))

    def to_dict(self):
        return {
            '_': 'GetGameHighScoresRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'id': self.id,
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id
        }

    def __bytes__(self):
        return b''.join((
            b'\x9dd"\xe8',
            bytes(self.peer),
            struct.pack('<i', self.id),
            bytes(self.user_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _id = reader.read_int()
        _user_id = reader.tgread_object()
        return cls(peer=_peer, id=_id, user_id=_user_id)


class GetHistoryRequest(TLRequest):
    CONSTRUCTOR_ID = 0xdcbb8260
    SUBCLASS_OF_ID = 0xd4b40b5e

    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', offset_id: int, offset_date: Optional[datetime], add_offset: int, limit: int, max_id: int, min_id: int, hash: int):
        """
        :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
        """
        self.peer = peer
        self.offset_id = offset_id
        self.offset_date = offset_date
        self.add_offset = add_offset
        self.limit = limit
        self.max_id = max_id
        self.min_id = min_id
        self.hash = hash

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'GetHistoryRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'offset_id': self.offset_id,
            'offset_date': self.offset_date,
            'add_offset': self.add_offset,
            'limit': self.limit,
            'max_id': self.max_id,
            'min_id': self.min_id,
            'hash': self.hash
        }

    def __bytes__(self):
        return b''.join((
            b'`\x82\xbb\xdc',
            bytes(self.peer),
            struct.pack('<i', self.offset_id),
            self.serialize_datetime(self.offset_date),
            struct.pack('<i', self.add_offset),
            struct.pack('<i', self.limit),
            struct.pack('<i', self.max_id),
            struct.pack('<i', self.min_id),
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _offset_id = reader.read_int()
        _offset_date = reader.tgread_date()
        _add_offset = reader.read_int()
        _limit = reader.read_int()
        _max_id = reader.read_int()
        _min_id = reader.read_int()
        _hash = reader.read_int()
        return cls(peer=_peer, offset_id=_offset_id, offset_date=_offset_date, add_offset=_add_offset, limit=_limit, max_id=_max_id, min_id=_min_id, hash=_hash)


class GetInlineBotResultsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x514e999d
    SUBCLASS_OF_ID = 0x3ed4d9c9

    def __init__(self, bot: 'TypeInputUser', peer: 'TypeInputPeer', query: str, offset: str, geo_point: Optional['TypeInputGeoPoint']=None):
        """
        :returns messages.BotResults: Instance of BotResults.
        """
        self.bot = bot
        self.peer = peer
        self.query = query
        self.offset = offset
        self.geo_point = geo_point

    async def resolve(self, client, utils):
        self.bot = utils.get_input_user(await client.get_input_entity(self.bot))
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'GetInlineBotResultsRequest',
            'bot': self.bot.to_dict() if isinstance(self.bot, TLObject) else self.bot,
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'query': self.query,
            'offset': self.offset,
            'geo_point': self.geo_point.to_dict() if isinstance(self.geo_point, TLObject) else self.geo_point
        }

    def __bytes__(self):
        return b''.join((
            b'\x9d\x99NQ',
            struct.pack('<I', (0 if self.geo_point is None or self.geo_point is False else 1)),
            bytes(self.bot),
            bytes(self.peer),
            b'' if self.geo_point is None or self.geo_point is False else (bytes(self.geo_point)),
            self.serialize_bytes(self.query),
            self.serialize_bytes(self.offset),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _bot = reader.tgread_object()
        _peer = reader.tgread_object()
        if flags & 1:
            _geo_point = reader.tgread_object()
        else:
            _geo_point = None
        _query = reader.tgread_string()
        _offset = reader.tgread_string()
        return cls(bot=_bot, peer=_peer, query=_query, offset=_offset, geo_point=_geo_point)


class GetInlineGameHighScoresRequest(TLRequest):
    CONSTRUCTOR_ID = 0xf635e1b
    SUBCLASS_OF_ID = 0x6ccd95fd

    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputBotInlineMessageID', user_id: 'TypeInputUser'):
        """
        :returns messages.HighScores: Instance of HighScores.
        """
        self.id = id
        self.user_id = user_id

    async def resolve(self, client, utils):
        self.user_id = utils.get_input_user(await client.get_input_entity(self.user_id))

    def to_dict(self):
        return {
            '_': 'GetInlineGameHighScoresRequest',
            'id': self.id.to_dict() if isinstance(self.id, TLObject) else self.id,
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id
        }

    def __bytes__(self):
        return b''.join((
            b'\x1b^c\x0f',
            bytes(self.id),
            bytes(self.user_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_object()
        _user_id = reader.tgread_object()
        return cls(id=_id, user_id=_user_id)


class GetMaskStickersRequest(TLRequest):
    CONSTRUCTOR_ID = 0x65b8c79f
    SUBCLASS_OF_ID = 0x45834829

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int):
        """
        :returns messages.AllStickers: Instance of either AllStickersNotModified, AllStickers.
        """
        self.hash = hash

    def to_dict(self):
        return {
            '_': 'GetMaskStickersRequest',
            'hash': self.hash
        }

    def __bytes__(self):
        return b''.join((
            b'\x9f\xc7\xb8e',
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.read_int()
        return cls(hash=_hash)


class GetMessageEditDataRequest(TLRequest):
    CONSTRUCTOR_ID = 0xfda68d36
    SUBCLASS_OF_ID = 0xfb47949d

    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: int):
        """
        :returns messages.MessageEditData: Instance of MessageEditData.
        """
        self.peer = peer
        self.id = id

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'GetMessageEditDataRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'id': self.id
        }

    def __bytes__(self):
        return b''.join((
            b'6\x8d\xa6\xfd',
            bytes(self.peer),
            struct.pack('<i', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _id = reader.read_int()
        return cls(peer=_peer, id=_id)


class GetMessagesRequest(TLRequest):
    CONSTRUCTOR_ID = 0x63c66506
    SUBCLASS_OF_ID = 0xd4b40b5e

    # noinspection PyShadowingBuiltins
    def __init__(self, id: List['TypeInputMessage']):
        """
        :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
        """
        self.id = id

    async def resolve(self, client, utils):
        _tmp = []
        for _x in self.id:
            _tmp.append(utils.get_input_message(_x))

        self.id = _tmp

    def to_dict(self):
        return {
            '_': 'GetMessagesRequest',
            'id': [] if self.id is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.id]
        }

    def __bytes__(self):
        return b''.join((
            b'\x06e\xc6c',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(bytes(x) for x in self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _id.append(_x)

        return cls(id=_id)


class GetMessagesViewsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xc4c8a55d
    SUBCLASS_OF_ID = 0x5026710f

    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: List[int], increment: bool):
        """
        :returns Vector<int>: This type has no constructors.
        """
        self.peer = peer
        self.id = id
        self.increment = increment

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'GetMessagesViewsRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'id': [] if self.id is None else self.id[:],
            'increment': self.increment
        }

    def __bytes__(self):
        return b''.join((
            b']\xa5\xc8\xc4',
            bytes(self.peer),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
            b'\xb5ur\x99' if self.increment else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        _increment = reader.tgread_bool()
        return cls(peer=_peer, id=_id, increment=_increment)

    @staticmethod
    def read_result(reader):
        reader.read_int()  # Vector ID
        return [reader.read_int() for _ in range(reader.read_int())]


class GetOnlinesRequest(TLRequest):
    CONSTRUCTOR_ID = 0x6e2be050
    SUBCLASS_OF_ID = 0x8c81903a

    def __init__(self, peer: 'TypeInputPeer'):
        """
        :returns ChatOnlines: Instance of ChatOnlines.
        """
        self.peer = peer

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'GetOnlinesRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def __bytes__(self):
        return b''.join((
            b'P\xe0+n',
            bytes(self.peer),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


class GetPeerDialogsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xe470bcfd
    SUBCLASS_OF_ID = 0x3ac70132

    def __init__(self, peers: List['TypeInputDialogPeer']):
        """
        :returns messages.PeerDialogs: Instance of PeerDialogs.
        """
        self.peers = peers

    async def resolve(self, client, utils):
        _tmp = []
        for _x in self.peers:
            _tmp.append(await client._get_input_dialog(_x))

        self.peers = _tmp

    def to_dict(self):
        return {
            '_': 'GetPeerDialogsRequest',
            'peers': [] if self.peers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.peers]
        }

    def __bytes__(self):
        return b''.join((
            b'\xfd\xbcp\xe4',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.peers)),b''.join(bytes(x) for x in self.peers),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _peers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _peers.append(_x)

        return cls(peers=_peers)


class GetPeerSettingsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x3672e09c
    SUBCLASS_OF_ID = 0xf6a79f84

    def __init__(self, peer: 'TypeInputPeer'):
        """
        :returns PeerSettings: Instance of PeerSettings.
        """
        self.peer = peer

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'GetPeerSettingsRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def __bytes__(self):
        return b''.join((
            b'\x9c\xe0r6',
            bytes(self.peer),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


class GetPinnedDialogsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xd6b94df2
    SUBCLASS_OF_ID = 0x3ac70132

    def __init__(self, folder_id: int):
        """
        :returns messages.PeerDialogs: Instance of PeerDialogs.
        """
        self.folder_id = folder_id

    def to_dict(self):
        return {
            '_': 'GetPinnedDialogsRequest',
            'folder_id': self.folder_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xf2M\xb9\xd6',
            struct.pack('<i', self.folder_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _folder_id = reader.read_int()
        return cls(folder_id=_folder_id)


class GetPollResultsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x73bb643b
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, peer: 'TypeInputPeer', msg_id: int):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.peer = peer
        self.msg_id = msg_id

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'GetPollResultsRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'msg_id': self.msg_id
        }

    def __bytes__(self):
        return b''.join((
            b';d\xbbs',
            bytes(self.peer),
            struct.pack('<i', self.msg_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        return cls(peer=_peer, msg_id=_msg_id)


class GetRecentLocationsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xbbc45b09
    SUBCLASS_OF_ID = 0xd4b40b5e

    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', limit: int, hash: int):
        """
        :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
        """
        self.peer = peer
        self.limit = limit
        self.hash = hash

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'GetRecentLocationsRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'limit': self.limit,
            'hash': self.hash
        }

    def __bytes__(self):
        return b''.join((
            b'\t[\xc4\xbb',
            bytes(self.peer),
            struct.pack('<i', self.limit),
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _limit = reader.read_int()
        _hash = reader.read_int()
        return cls(peer=_peer, limit=_limit, hash=_hash)


class GetRecentStickersRequest(TLRequest):
    CONSTRUCTOR_ID = 0x5ea192c9
    SUBCLASS_OF_ID = 0xf76f8683

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, attached: Optional[bool]=None):
        """
        :returns messages.RecentStickers: Instance of either RecentStickersNotModified, RecentStickers.
        """
        self.hash = hash
        self.attached = attached

    def to_dict(self):
        return {
            '_': 'GetRecentStickersRequest',
            'hash': self.hash,
            'attached': self.attached
        }

    def __bytes__(self):
        return b''.join((
            b'\xc9\x92\xa1^',
            struct.pack('<I', (0 if self.attached is None or self.attached is False else 1)),
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _attached = bool(flags & 1)
        _hash = reader.read_int()
        return cls(hash=_hash, attached=_attached)


class GetSavedGifsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x83bf3d52
    SUBCLASS_OF_ID = 0xa68b61f5

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int):
        """
        :returns messages.SavedGifs: Instance of either SavedGifsNotModified, SavedGifs.
        """
        self.hash = hash

    def to_dict(self):
        return {
            '_': 'GetSavedGifsRequest',
            'hash': self.hash
        }

    def __bytes__(self):
        return b''.join((
            b'R=\xbf\x83',
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.read_int()
        return cls(hash=_hash)


class GetScheduledHistoryRequest(TLRequest):
    CONSTRUCTOR_ID = 0xe2c2685b
    SUBCLASS_OF_ID = 0xd4b40b5e

    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', hash: int):
        """
        :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
        """
        self.peer = peer
        self.hash = hash

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'GetScheduledHistoryRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'hash': self.hash
        }

    def __bytes__(self):
        return b''.join((
            b'[h\xc2\xe2',
            bytes(self.peer),
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _hash = reader.read_int()
        return cls(peer=_peer, hash=_hash)


class GetScheduledMessagesRequest(TLRequest):
    CONSTRUCTOR_ID = 0xbdbb0464
    SUBCLASS_OF_ID = 0xd4b40b5e

    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: List[int]):
        """
        :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
        """
        self.peer = peer
        self.id = id

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'GetScheduledMessagesRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'id': [] if self.id is None else self.id[:]
        }

    def __bytes__(self):
        return b''.join((
            b'd\x04\xbb\xbd',
            bytes(self.peer),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        return cls(peer=_peer, id=_id)


class GetSearchCountersRequest(TLRequest):
    CONSTRUCTOR_ID = 0x732eef00
    SUBCLASS_OF_ID = 0x6bde3c6e

    def __init__(self, peer: 'TypeInputPeer', filters: List['TypeMessagesFilter']):
        """
        :returns Vector<messages.SearchCounter>: This type has no constructors.
        """
        self.peer = peer
        self.filters = filters

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'GetSearchCountersRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'filters': [] if self.filters is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.filters]
        }

    def __bytes__(self):
        return b''.join((
            b'\x00\xef.s',
            bytes(self.peer),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.filters)),b''.join(bytes(x) for x in self.filters),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        reader.read_int()
        _filters = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _filters.append(_x)

        return cls(peer=_peer, filters=_filters)


class GetSplitRangesRequest(TLRequest):
    CONSTRUCTOR_ID = 0x1cff7e08
    SUBCLASS_OF_ID = 0x5ba52504

    def to_dict(self):
        return {
            '_': 'GetSplitRangesRequest'
        }

    def __bytes__(self):
        return b''.join((
            b'\x08~\xff\x1c',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class GetStatsURLRequest(TLRequest):
    CONSTRUCTOR_ID = 0x812c2ae6
    SUBCLASS_OF_ID = 0x8d4c94c0

    def __init__(self, peer: 'TypeInputPeer', params: str, dark: Optional[bool]=None):
        """
        :returns StatsURL: Instance of StatsURL.
        """
        self.peer = peer
        self.params = params
        self.dark = dark

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'GetStatsURLRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'params': self.params,
            'dark': self.dark
        }

    def __bytes__(self):
        return b''.join((
            b'\xe6*,\x81',
            struct.pack('<I', (0 if self.dark is None or self.dark is False else 1)),
            bytes(self.peer),
            self.serialize_bytes(self.params),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _dark = bool(flags & 1)
        _peer = reader.tgread_object()
        _params = reader.tgread_string()
        return cls(peer=_peer, params=_params, dark=_dark)


class GetStickerSetRequest(TLRequest):
    CONSTRUCTOR_ID = 0x2619a90e
    SUBCLASS_OF_ID = 0x9b704a5a

    def __init__(self, stickerset: 'TypeInputStickerSet'):
        """
        :returns messages.StickerSet: Instance of StickerSet.
        """
        self.stickerset = stickerset

    def to_dict(self):
        return {
            '_': 'GetStickerSetRequest',
            'stickerset': self.stickerset.to_dict() if isinstance(self.stickerset, TLObject) else self.stickerset
        }

    def __bytes__(self):
        return b''.join((
            b'\x0e\xa9\x19&',
            bytes(self.stickerset),
        ))

    @classmethod
    def from_reader(cls, reader):
        _stickerset = reader.tgread_object()
        return cls(stickerset=_stickerset)


class GetStickersRequest(TLRequest):
    CONSTRUCTOR_ID = 0x43d4f2c
    SUBCLASS_OF_ID = 0xd73bb9de

    # noinspection PyShadowingBuiltins
    def __init__(self, emoticon: str, hash: int):
        """
        :returns messages.Stickers: Instance of either StickersNotModified, Stickers.
        """
        self.emoticon = emoticon
        self.hash = hash

    def to_dict(self):
        return {
            '_': 'GetStickersRequest',
            'emoticon': self.emoticon,
            'hash': self.hash
        }

    def __bytes__(self):
        return b''.join((
            b',O=\x04',
            self.serialize_bytes(self.emoticon),
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _emoticon = reader.tgread_string()
        _hash = reader.read_int()
        return cls(emoticon=_emoticon, hash=_hash)


class GetUnreadMentionsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x46578472
    SUBCLASS_OF_ID = 0xd4b40b5e

    def __init__(self, peer: 'TypeInputPeer', offset_id: int, add_offset: int, limit: int, max_id: int, min_id: int):
        """
        :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
        """
        self.peer = peer
        self.offset_id = offset_id
        self.add_offset = add_offset
        self.limit = limit
        self.max_id = max_id
        self.min_id = min_id

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'GetUnreadMentionsRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'offset_id': self.offset_id,
            'add_offset': self.add_offset,
            'limit': self.limit,
            'max_id': self.max_id,
            'min_id': self.min_id
        }

    def __bytes__(self):
        return b''.join((
            b'r\x84WF',
            bytes(self.peer),
            struct.pack('<i', self.offset_id),
            struct.pack('<i', self.add_offset),
            struct.pack('<i', self.limit),
            struct.pack('<i', self.max_id),
            struct.pack('<i', self.min_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _offset_id = reader.read_int()
        _add_offset = reader.read_int()
        _limit = reader.read_int()
        _max_id = reader.read_int()
        _min_id = reader.read_int()
        return cls(peer=_peer, offset_id=_offset_id, add_offset=_add_offset, limit=_limit, max_id=_max_id, min_id=_min_id)


class GetWebPageRequest(TLRequest):
    CONSTRUCTOR_ID = 0x32ca8f91
    SUBCLASS_OF_ID = 0x55a97481

    # noinspection PyShadowingBuiltins
    def __init__(self, url: str, hash: int):
        """
        :returns WebPage: Instance of either WebPageEmpty, WebPagePending, WebPage, WebPageNotModified.
        """
        self.url = url
        self.hash = hash

    def to_dict(self):
        return {
            '_': 'GetWebPageRequest',
            'url': self.url,
            'hash': self.hash
        }

    def __bytes__(self):
        return b''.join((
            b'\x91\x8f\xca2',
            self.serialize_bytes(self.url),
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        _hash = reader.read_int()
        return cls(url=_url, hash=_hash)


class GetWebPagePreviewRequest(TLRequest):
    CONSTRUCTOR_ID = 0x8b68b0cc
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, message: str, entities: Optional[List['TypeMessageEntity']]=None):
        """
        :returns MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll.
        """
        self.message = message
        self.entities = entities

    def to_dict(self):
        return {
            '_': 'GetWebPagePreviewRequest',
            'message': self.message,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities]
        }

    def __bytes__(self):
        return b''.join((
            b'\xcc\xb0h\x8b',
            struct.pack('<I', (0 if self.entities is None or self.entities is False else 8)),
            self.serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(bytes(x) for x in self.entities))),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _message = reader.tgread_string()
        if flags & 8:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        return cls(message=_message, entities=_entities)


class HidePeerSettingsBarRequest(TLRequest):
    CONSTRUCTOR_ID = 0x4facb138
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, peer: 'TypeInputPeer'):
        """
        :returns Bool: This type has no constructors.
        """
        self.peer = peer

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'HidePeerSettingsBarRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def __bytes__(self):
        return b''.join((
            b'8\xb1\xacO',
            bytes(self.peer),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


class ImportChatInviteRequest(TLRequest):
    CONSTRUCTOR_ID = 0x6c50051c
    SUBCLASS_OF_ID = 0x8af52aac

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: str):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.hash = hash

    def to_dict(self):
        return {
            '_': 'ImportChatInviteRequest',
            'hash': self.hash
        }

    def __bytes__(self):
        return b''.join((
            b'\x1c\x05Pl',
            self.serialize_bytes(self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.tgread_string()
        return cls(hash=_hash)


class InstallStickerSetRequest(TLRequest):
    CONSTRUCTOR_ID = 0xc78fe460
    SUBCLASS_OF_ID = 0x67cb3fe8

    def __init__(self, stickerset: 'TypeInputStickerSet', archived: bool):
        """
        :returns messages.StickerSetInstallResult: Instance of either StickerSetInstallResultSuccess, StickerSetInstallResultArchive.
        """
        self.stickerset = stickerset
        self.archived = archived

    def to_dict(self):
        return {
            '_': 'InstallStickerSetRequest',
            'stickerset': self.stickerset.to_dict() if isinstance(self.stickerset, TLObject) else self.stickerset,
            'archived': self.archived
        }

    def __bytes__(self):
        return b''.join((
            b'`\xe4\x8f\xc7',
            bytes(self.stickerset),
            b'\xb5ur\x99' if self.archived else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _stickerset = reader.tgread_object()
        _archived = reader.tgread_bool()
        return cls(stickerset=_stickerset, archived=_archived)


class MarkDialogUnreadRequest(TLRequest):
    CONSTRUCTOR_ID = 0xc286d98f
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, peer: 'TypeInputDialogPeer', unread: Optional[bool]=None):
        """
        :returns Bool: This type has no constructors.
        """
        self.peer = peer
        self.unread = unread

    async def resolve(self, client, utils):
        self.peer = await client._get_input_dialog(self.peer)

    def to_dict(self):
        return {
            '_': 'MarkDialogUnreadRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'unread': self.unread
        }

    def __bytes__(self):
        return b''.join((
            b'\x8f\xd9\x86\xc2',
            struct.pack('<I', (0 if self.unread is None or self.unread is False else 1)),
            bytes(self.peer),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _unread = bool(flags & 1)
        _peer = reader.tgread_object()
        return cls(peer=_peer, unread=_unread)


class MigrateChatRequest(TLRequest):
    CONSTRUCTOR_ID = 0x15a3b8e3
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, chat_id: int):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.chat_id = chat_id

    async def resolve(self, client, utils):
        self.chat_id = await client.get_peer_id(self.chat_id, add_mark=False)

    def to_dict(self):
        return {
            '_': 'MigrateChatRequest',
            'chat_id': self.chat_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xe3\xb8\xa3\x15',
            struct.pack('<i', self.chat_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_int()
        return cls(chat_id=_chat_id)


class ReadEncryptedHistoryRequest(TLRequest):
    CONSTRUCTOR_ID = 0x7f4b690a
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, peer: 'TypeInputEncryptedChat', max_date: Optional[datetime]):
        """
        :returns Bool: This type has no constructors.
        """
        self.peer = peer
        self.max_date = max_date

    def to_dict(self):
        return {
            '_': 'ReadEncryptedHistoryRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'max_date': self.max_date
        }

    def __bytes__(self):
        return b''.join((
            b'\niK\x7f',
            bytes(self.peer),
            self.serialize_datetime(self.max_date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _max_date = reader.tgread_date()
        return cls(peer=_peer, max_date=_max_date)


class ReadFeaturedStickersRequest(TLRequest):
    CONSTRUCTOR_ID = 0x5b118126
    SUBCLASS_OF_ID = 0xf5b399ac

    # noinspection PyShadowingBuiltins
    def __init__(self, id: List[int]):
        """
        :returns Bool: This type has no constructors.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'ReadFeaturedStickersRequest',
            'id': [] if self.id is None else self.id[:]
        }

    def __bytes__(self):
        return b''.join((
            b'&\x81\x11[',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<q', x) for x in self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _id.append(_x)

        return cls(id=_id)


class ReadHistoryRequest(TLRequest):
    CONSTRUCTOR_ID = 0xe306d3a
    SUBCLASS_OF_ID = 0xced3c06e

    def __init__(self, peer: 'TypeInputPeer', max_id: int):
        """
        :returns messages.AffectedMessages: Instance of AffectedMessages.
        """
        self.peer = peer
        self.max_id = max_id

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'ReadHistoryRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'max_id': self.max_id
        }

    def __bytes__(self):
        return b''.join((
            b':m0\x0e',
            bytes(self.peer),
            struct.pack('<i', self.max_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _max_id = reader.read_int()
        return cls(peer=_peer, max_id=_max_id)


class ReadMentionsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xf0189d3
    SUBCLASS_OF_ID = 0x2c49c116

    def __init__(self, peer: 'TypeInputPeer'):
        """
        :returns messages.AffectedHistory: Instance of AffectedHistory.
        """
        self.peer = peer

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'ReadMentionsRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def __bytes__(self):
        return b''.join((
            b'\xd3\x89\x01\x0f',
            bytes(self.peer),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


class ReadMessageContentsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x36a73f77
    SUBCLASS_OF_ID = 0xced3c06e

    # noinspection PyShadowingBuiltins
    def __init__(self, id: List[int]):
        """
        :returns messages.AffectedMessages: Instance of AffectedMessages.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'ReadMessageContentsRequest',
            'id': [] if self.id is None else self.id[:]
        }

    def __bytes__(self):
        return b''.join((
            b'w?\xa76',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        return cls(id=_id)


class ReceivedMessagesRequest(TLRequest):
    CONSTRUCTOR_ID = 0x5a954c0
    SUBCLASS_OF_ID = 0x8565f897

    def __init__(self, max_id: int):
        """
        :returns Vector<ReceivedNotifyMessage>: This type has no constructors.
        """
        self.max_id = max_id

    def to_dict(self):
        return {
            '_': 'ReceivedMessagesRequest',
            'max_id': self.max_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xc0T\xa9\x05',
            struct.pack('<i', self.max_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _max_id = reader.read_int()
        return cls(max_id=_max_id)


class ReceivedQueueRequest(TLRequest):
    CONSTRUCTOR_ID = 0x55a5bb66
    SUBCLASS_OF_ID = 0x8918e168

    def __init__(self, max_qts: int):
        """
        :returns Vector<long>: This type has no constructors.
        """
        self.max_qts = max_qts

    def to_dict(self):
        return {
            '_': 'ReceivedQueueRequest',
            'max_qts': self.max_qts
        }

    def __bytes__(self):
        return b''.join((
            b'f\xbb\xa5U',
            struct.pack('<i', self.max_qts),
        ))

    @classmethod
    def from_reader(cls, reader):
        _max_qts = reader.read_int()
        return cls(max_qts=_max_qts)

    @staticmethod
    def read_result(reader):
        reader.read_int()  # Vector ID
        return [reader.read_long() for _ in range(reader.read_int())]


class ReorderPinnedDialogsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x3b1adf37
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, folder_id: int, order: List['TypeInputDialogPeer'], force: Optional[bool]=None):
        """
        :returns Bool: This type has no constructors.
        """
        self.folder_id = folder_id
        self.order = order
        self.force = force

    async def resolve(self, client, utils):
        _tmp = []
        for _x in self.order:
            _tmp.append(await client._get_input_dialog(_x))

        self.order = _tmp

    def to_dict(self):
        return {
            '_': 'ReorderPinnedDialogsRequest',
            'folder_id': self.folder_id,
            'order': [] if self.order is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.order],
            'force': self.force
        }

    def __bytes__(self):
        return b''.join((
            b'7\xdf\x1a;',
            struct.pack('<I', (0 if self.force is None or self.force is False else 1)),
            struct.pack('<i', self.folder_id),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.order)),b''.join(bytes(x) for x in self.order),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _force = bool(flags & 1)
        _folder_id = reader.read_int()
        reader.read_int()
        _order = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _order.append(_x)

        return cls(folder_id=_folder_id, order=_order, force=_force)


class ReorderStickerSetsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x78337739
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, order: List[int], masks: Optional[bool]=None):
        """
        :returns Bool: This type has no constructors.
        """
        self.order = order
        self.masks = masks

    def to_dict(self):
        return {
            '_': 'ReorderStickerSetsRequest',
            'order': [] if self.order is None else self.order[:],
            'masks': self.masks
        }

    def __bytes__(self):
        return b''.join((
            b'9w3x',
            struct.pack('<I', (0 if self.masks is None or self.masks is False else 1)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.order)),b''.join(struct.pack('<q', x) for x in self.order),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _masks = bool(flags & 1)
        reader.read_int()
        _order = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _order.append(_x)

        return cls(order=_order, masks=_masks)


class ReportRequest(TLRequest):
    CONSTRUCTOR_ID = 0xbd82b658
    SUBCLASS_OF_ID = 0xf5b399ac

    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: List[int], reason: 'TypeReportReason'):
        """
        :returns Bool: This type has no constructors.
        """
        self.peer = peer
        self.id = id
        self.reason = reason

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'ReportRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'id': [] if self.id is None else self.id[:],
            'reason': self.reason.to_dict() if isinstance(self.reason, TLObject) else self.reason
        }

    def __bytes__(self):
        return b''.join((
            b'X\xb6\x82\xbd',
            bytes(self.peer),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
            bytes(self.reason),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        _reason = reader.tgread_object()
        return cls(peer=_peer, id=_id, reason=_reason)


class ReportEncryptedSpamRequest(TLRequest):
    CONSTRUCTOR_ID = 0x4b0c8c0f
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, peer: 'TypeInputEncryptedChat'):
        """
        :returns Bool: This type has no constructors.
        """
        self.peer = peer

    def to_dict(self):
        return {
            '_': 'ReportEncryptedSpamRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def __bytes__(self):
        return b''.join((
            b'\x0f\x8c\x0cK',
            bytes(self.peer),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


class ReportSpamRequest(TLRequest):
    CONSTRUCTOR_ID = 0xcf1592db
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, peer: 'TypeInputPeer'):
        """
        :returns Bool: This type has no constructors.
        """
        self.peer = peer

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'ReportSpamRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def __bytes__(self):
        return b''.join((
            b'\xdb\x92\x15\xcf',
            bytes(self.peer),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


class RequestEncryptionRequest(TLRequest):
    CONSTRUCTOR_ID = 0xf64daf43
    SUBCLASS_OF_ID = 0x6d28a37a

    def __init__(self, user_id: 'TypeInputUser', g_a: bytes, random_id: int=None):
        """
        :returns EncryptedChat: Instance of either EncryptedChatEmpty, EncryptedChatWaiting, EncryptedChatRequested, EncryptedChat, EncryptedChatDiscarded.
        """
        self.user_id = user_id
        self.g_a = g_a
        self.random_id = random_id if random_id is not None else int.from_bytes(os.urandom(4), 'big', signed=True)

    async def resolve(self, client, utils):
        self.user_id = utils.get_input_user(await client.get_input_entity(self.user_id))

    def to_dict(self):
        return {
            '_': 'RequestEncryptionRequest',
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id,
            'g_a': self.g_a,
            'random_id': self.random_id
        }

    def __bytes__(self):
        return b''.join((
            b'C\xafM\xf6',
            bytes(self.user_id),
            struct.pack('<i', self.random_id),
            self.serialize_bytes(self.g_a),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.tgread_object()
        _random_id = reader.read_int()
        _g_a = reader.tgread_bytes()
        return cls(user_id=_user_id, g_a=_g_a, random_id=_random_id)


class RequestUrlAuthRequest(TLRequest):
    CONSTRUCTOR_ID = 0xe33f5613
    SUBCLASS_OF_ID = 0x7765cb1e

    def __init__(self, peer: 'TypeInputPeer', msg_id: int, button_id: int):
        """
        :returns UrlAuthResult: Instance of either UrlAuthResultRequest, UrlAuthResultAccepted, UrlAuthResultDefault.
        """
        self.peer = peer
        self.msg_id = msg_id
        self.button_id = button_id

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'RequestUrlAuthRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'msg_id': self.msg_id,
            'button_id': self.button_id
        }

    def __bytes__(self):
        return b''.join((
            b'\x13V?\xe3',
            bytes(self.peer),
            struct.pack('<i', self.msg_id),
            struct.pack('<i', self.button_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        _button_id = reader.read_int()
        return cls(peer=_peer, msg_id=_msg_id, button_id=_button_id)


class SaveDraftRequest(TLRequest):
    CONSTRUCTOR_ID = 0xbc39e14b
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, peer: 'TypeInputPeer', message: str, no_webpage: Optional[bool]=None, reply_to_msg_id: Optional[int]=None, entities: Optional[List['TypeMessageEntity']]=None):
        """
        :returns Bool: This type has no constructors.
        """
        self.peer = peer
        self.message = message
        self.no_webpage = no_webpage
        self.reply_to_msg_id = reply_to_msg_id
        self.entities = entities

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'SaveDraftRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'message': self.message,
            'no_webpage': self.no_webpage,
            'reply_to_msg_id': self.reply_to_msg_id,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities]
        }

    def __bytes__(self):
        return b''.join((
            b'K\xe19\xbc',
            struct.pack('<I', (0 if self.no_webpage is None or self.no_webpage is False else 2) | (0 if self.reply_to_msg_id is None or self.reply_to_msg_id is False else 1) | (0 if self.entities is None or self.entities is False else 8)),
            b'' if self.reply_to_msg_id is None or self.reply_to_msg_id is False else (struct.pack('<i', self.reply_to_msg_id)),
            bytes(self.peer),
            self.serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(bytes(x) for x in self.entities))),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _no_webpage = bool(flags & 2)
        if flags & 1:
            _reply_to_msg_id = reader.read_int()
        else:
            _reply_to_msg_id = None
        _peer = reader.tgread_object()
        _message = reader.tgread_string()
        if flags & 8:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        return cls(peer=_peer, message=_message, no_webpage=_no_webpage, reply_to_msg_id=_reply_to_msg_id, entities=_entities)


class SaveGifRequest(TLRequest):
    CONSTRUCTOR_ID = 0x327a30cb
    SUBCLASS_OF_ID = 0xf5b399ac

    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputDocument', unsave: bool):
        """
        :returns Bool: This type has no constructors.
        """
        self.id = id
        self.unsave = unsave

    async def resolve(self, client, utils):
        self.id = utils.get_input_document(self.id)

    def to_dict(self):
        return {
            '_': 'SaveGifRequest',
            'id': self.id.to_dict() if isinstance(self.id, TLObject) else self.id,
            'unsave': self.unsave
        }

    def __bytes__(self):
        return b''.join((
            b'\xcb0z2',
            bytes(self.id),
            b'\xb5ur\x99' if self.unsave else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_object()
        _unsave = reader.tgread_bool()
        return cls(id=_id, unsave=_unsave)


class SaveRecentStickerRequest(TLRequest):
    CONSTRUCTOR_ID = 0x392718f8
    SUBCLASS_OF_ID = 0xf5b399ac

    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputDocument', unsave: bool, attached: Optional[bool]=None):
        """
        :returns Bool: This type has no constructors.
        """
        self.id = id
        self.unsave = unsave
        self.attached = attached

    async def resolve(self, client, utils):
        self.id = utils.get_input_document(self.id)

    def to_dict(self):
        return {
            '_': 'SaveRecentStickerRequest',
            'id': self.id.to_dict() if isinstance(self.id, TLObject) else self.id,
            'unsave': self.unsave,
            'attached': self.attached
        }

    def __bytes__(self):
        return b''.join((
            b"\xf8\x18'9",
            struct.pack('<I', (0 if self.attached is None or self.attached is False else 1)),
            bytes(self.id),
            b'\xb5ur\x99' if self.unsave else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _attached = bool(flags & 1)
        _id = reader.tgread_object()
        _unsave = reader.tgread_bool()
        return cls(id=_id, unsave=_unsave, attached=_attached)


class SearchRequest(TLRequest):
    CONSTRUCTOR_ID = 0x8614ef68
    SUBCLASS_OF_ID = 0xd4b40b5e

    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', q: str, filter: 'TypeMessagesFilter', min_date: Optional[datetime], max_date: Optional[datetime], offset_id: int, add_offset: int, limit: int, max_id: int, min_id: int, hash: int, from_id: Optional['TypeInputUser']=None):
        """
        :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
        """
        self.peer = peer
        self.q = q
        self.filter = filter
        self.min_date = min_date
        self.max_date = max_date
        self.offset_id = offset_id
        self.add_offset = add_offset
        self.limit = limit
        self.max_id = max_id
        self.min_id = min_id
        self.hash = hash
        self.from_id = from_id

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))
        if self.from_id:
            self.from_id = utils.get_input_user(await client.get_input_entity(self.from_id))

    def to_dict(self):
        return {
            '_': 'SearchRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'q': self.q,
            'filter': self.filter.to_dict() if isinstance(self.filter, TLObject) else self.filter,
            'min_date': self.min_date,
            'max_date': self.max_date,
            'offset_id': self.offset_id,
            'add_offset': self.add_offset,
            'limit': self.limit,
            'max_id': self.max_id,
            'min_id': self.min_id,
            'hash': self.hash,
            'from_id': self.from_id.to_dict() if isinstance(self.from_id, TLObject) else self.from_id
        }

    def __bytes__(self):
        return b''.join((
            b'h\xef\x14\x86',
            struct.pack('<I', (0 if self.from_id is None or self.from_id is False else 1)),
            bytes(self.peer),
            self.serialize_bytes(self.q),
            b'' if self.from_id is None or self.from_id is False else (bytes(self.from_id)),
            bytes(self.filter),
            self.serialize_datetime(self.min_date),
            self.serialize_datetime(self.max_date),
            struct.pack('<i', self.offset_id),
            struct.pack('<i', self.add_offset),
            struct.pack('<i', self.limit),
            struct.pack('<i', self.max_id),
            struct.pack('<i', self.min_id),
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _peer = reader.tgread_object()
        _q = reader.tgread_string()
        if flags & 1:
            _from_id = reader.tgread_object()
        else:
            _from_id = None
        _filter = reader.tgread_object()
        _min_date = reader.tgread_date()
        _max_date = reader.tgread_date()
        _offset_id = reader.read_int()
        _add_offset = reader.read_int()
        _limit = reader.read_int()
        _max_id = reader.read_int()
        _min_id = reader.read_int()
        _hash = reader.read_int()
        return cls(peer=_peer, q=_q, filter=_filter, min_date=_min_date, max_date=_max_date, offset_id=_offset_id, add_offset=_add_offset, limit=_limit, max_id=_max_id, min_id=_min_id, hash=_hash, from_id=_from_id)


class SearchGifsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xbf9a776b
    SUBCLASS_OF_ID = 0xe799ea7

    def __init__(self, q: str, offset: int):
        """
        :returns messages.FoundGifs: Instance of FoundGifs.
        """
        self.q = q
        self.offset = offset

    def to_dict(self):
        return {
            '_': 'SearchGifsRequest',
            'q': self.q,
            'offset': self.offset
        }

    def __bytes__(self):
        return b''.join((
            b'kw\x9a\xbf',
            self.serialize_bytes(self.q),
            struct.pack('<i', self.offset),
        ))

    @classmethod
    def from_reader(cls, reader):
        _q = reader.tgread_string()
        _offset = reader.read_int()
        return cls(q=_q, offset=_offset)


class SearchGlobalRequest(TLRequest):
    CONSTRUCTOR_ID = 0xbf7225a4
    SUBCLASS_OF_ID = 0xd4b40b5e

    def __init__(self, q: str, offset_rate: Optional[datetime], offset_peer: 'TypeInputPeer', offset_id: int, limit: int, folder_id: Optional[int]=None):
        """
        :returns messages.Messages: Instance of either Messages, MessagesSlice, ChannelMessages, MessagesNotModified.
        """
        self.q = q
        self.offset_rate = offset_rate
        self.offset_peer = offset_peer
        self.offset_id = offset_id
        self.limit = limit
        self.folder_id = folder_id

    async def resolve(self, client, utils):
        self.offset_peer = utils.get_input_peer(await client.get_input_entity(self.offset_peer))

    def to_dict(self):
        return {
            '_': 'SearchGlobalRequest',
            'q': self.q,
            'offset_rate': self.offset_rate,
            'offset_peer': self.offset_peer.to_dict() if isinstance(self.offset_peer, TLObject) else self.offset_peer,
            'offset_id': self.offset_id,
            'limit': self.limit,
            'folder_id': self.folder_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xa4%r\xbf',
            struct.pack('<I', (0 if self.folder_id is None or self.folder_id is False else 1)),
            b'' if self.folder_id is None or self.folder_id is False else (struct.pack('<i', self.folder_id)),
            self.serialize_bytes(self.q),
            self.serialize_datetime(self.offset_rate),
            bytes(self.offset_peer),
            struct.pack('<i', self.offset_id),
            struct.pack('<i', self.limit),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _folder_id = reader.read_int()
        else:
            _folder_id = None
        _q = reader.tgread_string()
        _offset_rate = reader.tgread_date()
        _offset_peer = reader.tgread_object()
        _offset_id = reader.read_int()
        _limit = reader.read_int()
        return cls(q=_q, offset_rate=_offset_rate, offset_peer=_offset_peer, offset_id=_offset_id, limit=_limit, folder_id=_folder_id)


class SearchStickerSetsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xc2b7d08b
    SUBCLASS_OF_ID = 0x40df361

    # noinspection PyShadowingBuiltins
    def __init__(self, q: str, hash: int, exclude_featured: Optional[bool]=None):
        """
        :returns messages.FoundStickerSets: Instance of either FoundStickerSetsNotModified, FoundStickerSets.
        """
        self.q = q
        self.hash = hash
        self.exclude_featured = exclude_featured

    def to_dict(self):
        return {
            '_': 'SearchStickerSetsRequest',
            'q': self.q,
            'hash': self.hash,
            'exclude_featured': self.exclude_featured
        }

    def __bytes__(self):
        return b''.join((
            b'\x8b\xd0\xb7\xc2',
            struct.pack('<I', (0 if self.exclude_featured is None or self.exclude_featured is False else 1)),
            self.serialize_bytes(self.q),
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _exclude_featured = bool(flags & 1)
        _q = reader.tgread_string()
        _hash = reader.read_int()
        return cls(q=_q, hash=_hash, exclude_featured=_exclude_featured)


class SendEncryptedRequest(TLRequest):
    CONSTRUCTOR_ID = 0xa9776773
    SUBCLASS_OF_ID = 0xc99e3e50

    def __init__(self, peer: 'TypeInputEncryptedChat', data: bytes, random_id: int=None):
        """
        :returns messages.SentEncryptedMessage: Instance of either SentEncryptedMessage, SentEncryptedFile.
        """
        self.peer = peer
        self.data = data
        self.random_id = random_id if random_id is not None else int.from_bytes(os.urandom(8), 'big', signed=True)

    def to_dict(self):
        return {
            '_': 'SendEncryptedRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'data': self.data,
            'random_id': self.random_id
        }

    def __bytes__(self):
        return b''.join((
            b'sgw\xa9',
            bytes(self.peer),
            struct.pack('<q', self.random_id),
            self.serialize_bytes(self.data),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _random_id = reader.read_long()
        _data = reader.tgread_bytes()
        return cls(peer=_peer, data=_data, random_id=_random_id)


class SendEncryptedFileRequest(TLRequest):
    CONSTRUCTOR_ID = 0x9a901b66
    SUBCLASS_OF_ID = 0xc99e3e50

    def __init__(self, peer: 'TypeInputEncryptedChat', data: bytes, file: 'TypeInputEncryptedFile', random_id: int=None):
        """
        :returns messages.SentEncryptedMessage: Instance of either SentEncryptedMessage, SentEncryptedFile.
        """
        self.peer = peer
        self.data = data
        self.file = file
        self.random_id = random_id if random_id is not None else int.from_bytes(os.urandom(8), 'big', signed=True)

    def to_dict(self):
        return {
            '_': 'SendEncryptedFileRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'data': self.data,
            'file': self.file.to_dict() if isinstance(self.file, TLObject) else self.file,
            'random_id': self.random_id
        }

    def __bytes__(self):
        return b''.join((
            b'f\x1b\x90\x9a',
            bytes(self.peer),
            struct.pack('<q', self.random_id),
            self.serialize_bytes(self.data),
            bytes(self.file),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _random_id = reader.read_long()
        _data = reader.tgread_bytes()
        _file = reader.tgread_object()
        return cls(peer=_peer, data=_data, file=_file, random_id=_random_id)


class SendEncryptedServiceRequest(TLRequest):
    CONSTRUCTOR_ID = 0x32d439a4
    SUBCLASS_OF_ID = 0xc99e3e50

    def __init__(self, peer: 'TypeInputEncryptedChat', data: bytes, random_id: int=None):
        """
        :returns messages.SentEncryptedMessage: Instance of either SentEncryptedMessage, SentEncryptedFile.
        """
        self.peer = peer
        self.data = data
        self.random_id = random_id if random_id is not None else int.from_bytes(os.urandom(8), 'big', signed=True)

    def to_dict(self):
        return {
            '_': 'SendEncryptedServiceRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'data': self.data,
            'random_id': self.random_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xa49\xd42',
            bytes(self.peer),
            struct.pack('<q', self.random_id),
            self.serialize_bytes(self.data),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _random_id = reader.read_long()
        _data = reader.tgread_bytes()
        return cls(peer=_peer, data=_data, random_id=_random_id)


class SendInlineBotResultRequest(TLRequest):
    CONSTRUCTOR_ID = 0x220815b0
    SUBCLASS_OF_ID = 0x8af52aac

    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', query_id: int, id: str, silent: Optional[bool]=None, background: Optional[bool]=None, clear_draft: Optional[bool]=None, hide_via: Optional[bool]=None, reply_to_msg_id: Optional[int]=None, random_id: int=None, schedule_date: Optional[datetime]=None):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.peer = peer
        self.query_id = query_id
        self.id = id
        self.silent = silent
        self.background = background
        self.clear_draft = clear_draft
        self.hide_via = hide_via
        self.reply_to_msg_id = reply_to_msg_id
        self.random_id = random_id if random_id is not None else int.from_bytes(os.urandom(8), 'big', signed=True)
        self.schedule_date = schedule_date

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'SendInlineBotResultRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'query_id': self.query_id,
            'id': self.id,
            'silent': self.silent,
            'background': self.background,
            'clear_draft': self.clear_draft,
            'hide_via': self.hide_via,
            'reply_to_msg_id': self.reply_to_msg_id,
            'random_id': self.random_id,
            'schedule_date': self.schedule_date
        }

    def __bytes__(self):
        return b''.join((
            b'\xb0\x15\x08"',
            struct.pack('<I', (0 if self.silent is None or self.silent is False else 32) | (0 if self.background is None or self.background is False else 64) | (0 if self.clear_draft is None or self.clear_draft is False else 128) | (0 if self.hide_via is None or self.hide_via is False else 2048) | (0 if self.reply_to_msg_id is None or self.reply_to_msg_id is False else 1) | (0 if self.schedule_date is None or self.schedule_date is False else 1024)),
            bytes(self.peer),
            b'' if self.reply_to_msg_id is None or self.reply_to_msg_id is False else (struct.pack('<i', self.reply_to_msg_id)),
            struct.pack('<q', self.random_id),
            struct.pack('<q', self.query_id),
            self.serialize_bytes(self.id),
            b'' if self.schedule_date is None or self.schedule_date is False else (self.serialize_datetime(self.schedule_date)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _silent = bool(flags & 32)
        _background = bool(flags & 64)
        _clear_draft = bool(flags & 128)
        _hide_via = bool(flags & 2048)
        _peer = reader.tgread_object()
        if flags & 1:
            _reply_to_msg_id = reader.read_int()
        else:
            _reply_to_msg_id = None
        _random_id = reader.read_long()
        _query_id = reader.read_long()
        _id = reader.tgread_string()
        if flags & 1024:
            _schedule_date = reader.tgread_date()
        else:
            _schedule_date = None
        return cls(peer=_peer, query_id=_query_id, id=_id, silent=_silent, background=_background, clear_draft=_clear_draft, hide_via=_hide_via, reply_to_msg_id=_reply_to_msg_id, random_id=_random_id, schedule_date=_schedule_date)


class SendMediaRequest(TLRequest):
    CONSTRUCTOR_ID = 0x3491eba9
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, peer: 'TypeInputPeer', media: 'TypeInputMedia', message: str, silent: Optional[bool]=None, background: Optional[bool]=None, clear_draft: Optional[bool]=None, reply_to_msg_id: Optional[int]=None, random_id: int=None, reply_markup: Optional['TypeReplyMarkup']=None, entities: Optional[List['TypeMessageEntity']]=None, schedule_date: Optional[datetime]=None):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.peer = peer
        self.media = media
        self.message = message
        self.silent = silent
        self.background = background
        self.clear_draft = clear_draft
        self.reply_to_msg_id = reply_to_msg_id
        self.random_id = random_id if random_id is not None else int.from_bytes(os.urandom(8), 'big', signed=True)
        self.reply_markup = reply_markup
        self.entities = entities
        self.schedule_date = schedule_date

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))
        self.media = utils.get_input_media(self.media)

    def to_dict(self):
        return {
            '_': 'SendMediaRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'media': self.media.to_dict() if isinstance(self.media, TLObject) else self.media,
            'message': self.message,
            'silent': self.silent,
            'background': self.background,
            'clear_draft': self.clear_draft,
            'reply_to_msg_id': self.reply_to_msg_id,
            'random_id': self.random_id,
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities],
            'schedule_date': self.schedule_date
        }

    def __bytes__(self):
        return b''.join((
            b'\xa9\xeb\x914',
            struct.pack('<I', (0 if self.silent is None or self.silent is False else 32) | (0 if self.background is None or self.background is False else 64) | (0 if self.clear_draft is None or self.clear_draft is False else 128) | (0 if self.reply_to_msg_id is None or self.reply_to_msg_id is False else 1) | (0 if self.reply_markup is None or self.reply_markup is False else 4) | (0 if self.entities is None or self.entities is False else 8) | (0 if self.schedule_date is None or self.schedule_date is False else 1024)),
            bytes(self.peer),
            b'' if self.reply_to_msg_id is None or self.reply_to_msg_id is False else (struct.pack('<i', self.reply_to_msg_id)),
            bytes(self.media),
            self.serialize_bytes(self.message),
            struct.pack('<q', self.random_id),
            b'' if self.reply_markup is None or self.reply_markup is False else (bytes(self.reply_markup)),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(bytes(x) for x in self.entities))),
            b'' if self.schedule_date is None or self.schedule_date is False else (self.serialize_datetime(self.schedule_date)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _silent = bool(flags & 32)
        _background = bool(flags & 64)
        _clear_draft = bool(flags & 128)
        _peer = reader.tgread_object()
        if flags & 1:
            _reply_to_msg_id = reader.read_int()
        else:
            _reply_to_msg_id = None
        _media = reader.tgread_object()
        _message = reader.tgread_string()
        _random_id = reader.read_long()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        if flags & 8:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 1024:
            _schedule_date = reader.tgread_date()
        else:
            _schedule_date = None
        return cls(peer=_peer, media=_media, message=_message, silent=_silent, background=_background, clear_draft=_clear_draft, reply_to_msg_id=_reply_to_msg_id, random_id=_random_id, reply_markup=_reply_markup, entities=_entities, schedule_date=_schedule_date)


class SendMessageRequest(TLRequest):
    CONSTRUCTOR_ID = 0x520c3870
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, peer: 'TypeInputPeer', message: str, no_webpage: Optional[bool]=None, silent: Optional[bool]=None, background: Optional[bool]=None, clear_draft: Optional[bool]=None, reply_to_msg_id: Optional[int]=None, random_id: int=None, reply_markup: Optional['TypeReplyMarkup']=None, entities: Optional[List['TypeMessageEntity']]=None, schedule_date: Optional[datetime]=None):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.peer = peer
        self.message = message
        self.no_webpage = no_webpage
        self.silent = silent
        self.background = background
        self.clear_draft = clear_draft
        self.reply_to_msg_id = reply_to_msg_id
        self.random_id = random_id if random_id is not None else int.from_bytes(os.urandom(8), 'big', signed=True)
        self.reply_markup = reply_markup
        self.entities = entities
        self.schedule_date = schedule_date

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'SendMessageRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'message': self.message,
            'no_webpage': self.no_webpage,
            'silent': self.silent,
            'background': self.background,
            'clear_draft': self.clear_draft,
            'reply_to_msg_id': self.reply_to_msg_id,
            'random_id': self.random_id,
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities],
            'schedule_date': self.schedule_date
        }

    def __bytes__(self):
        return b''.join((
            b'p8\x0cR',
            struct.pack('<I', (0 if self.no_webpage is None or self.no_webpage is False else 2) | (0 if self.silent is None or self.silent is False else 32) | (0 if self.background is None or self.background is False else 64) | (0 if self.clear_draft is None or self.clear_draft is False else 128) | (0 if self.reply_to_msg_id is None or self.reply_to_msg_id is False else 1) | (0 if self.reply_markup is None or self.reply_markup is False else 4) | (0 if self.entities is None or self.entities is False else 8) | (0 if self.schedule_date is None or self.schedule_date is False else 1024)),
            bytes(self.peer),
            b'' if self.reply_to_msg_id is None or self.reply_to_msg_id is False else (struct.pack('<i', self.reply_to_msg_id)),
            self.serialize_bytes(self.message),
            struct.pack('<q', self.random_id),
            b'' if self.reply_markup is None or self.reply_markup is False else (bytes(self.reply_markup)),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(bytes(x) for x in self.entities))),
            b'' if self.schedule_date is None or self.schedule_date is False else (self.serialize_datetime(self.schedule_date)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _no_webpage = bool(flags & 2)
        _silent = bool(flags & 32)
        _background = bool(flags & 64)
        _clear_draft = bool(flags & 128)
        _peer = reader.tgread_object()
        if flags & 1:
            _reply_to_msg_id = reader.read_int()
        else:
            _reply_to_msg_id = None
        _message = reader.tgread_string()
        _random_id = reader.read_long()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        if flags & 8:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 1024:
            _schedule_date = reader.tgread_date()
        else:
            _schedule_date = None
        return cls(peer=_peer, message=_message, no_webpage=_no_webpage, silent=_silent, background=_background, clear_draft=_clear_draft, reply_to_msg_id=_reply_to_msg_id, random_id=_random_id, reply_markup=_reply_markup, entities=_entities, schedule_date=_schedule_date)


class SendMultiMediaRequest(TLRequest):
    CONSTRUCTOR_ID = 0xcc0110cb
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, peer: 'TypeInputPeer', multi_media: List['TypeInputSingleMedia'], silent: Optional[bool]=None, background: Optional[bool]=None, clear_draft: Optional[bool]=None, reply_to_msg_id: Optional[int]=None, schedule_date: Optional[datetime]=None):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.peer = peer
        self.multi_media = multi_media
        self.silent = silent
        self.background = background
        self.clear_draft = clear_draft
        self.reply_to_msg_id = reply_to_msg_id
        self.schedule_date = schedule_date

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'SendMultiMediaRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'multi_media': [] if self.multi_media is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.multi_media],
            'silent': self.silent,
            'background': self.background,
            'clear_draft': self.clear_draft,
            'reply_to_msg_id': self.reply_to_msg_id,
            'schedule_date': self.schedule_date
        }

    def __bytes__(self):
        return b''.join((
            b'\xcb\x10\x01\xcc',
            struct.pack('<I', (0 if self.silent is None or self.silent is False else 32) | (0 if self.background is None or self.background is False else 64) | (0 if self.clear_draft is None or self.clear_draft is False else 128) | (0 if self.reply_to_msg_id is None or self.reply_to_msg_id is False else 1) | (0 if self.schedule_date is None or self.schedule_date is False else 1024)),
            bytes(self.peer),
            b'' if self.reply_to_msg_id is None or self.reply_to_msg_id is False else (struct.pack('<i', self.reply_to_msg_id)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.multi_media)),b''.join(bytes(x) for x in self.multi_media),
            b'' if self.schedule_date is None or self.schedule_date is False else (self.serialize_datetime(self.schedule_date)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _silent = bool(flags & 32)
        _background = bool(flags & 64)
        _clear_draft = bool(flags & 128)
        _peer = reader.tgread_object()
        if flags & 1:
            _reply_to_msg_id = reader.read_int()
        else:
            _reply_to_msg_id = None
        reader.read_int()
        _multi_media = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _multi_media.append(_x)

        if flags & 1024:
            _schedule_date = reader.tgread_date()
        else:
            _schedule_date = None
        return cls(peer=_peer, multi_media=_multi_media, silent=_silent, background=_background, clear_draft=_clear_draft, reply_to_msg_id=_reply_to_msg_id, schedule_date=_schedule_date)


class SendScheduledMessagesRequest(TLRequest):
    CONSTRUCTOR_ID = 0xbd38850a
    SUBCLASS_OF_ID = 0x8af52aac

    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: List[int]):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.peer = peer
        self.id = id

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'SendScheduledMessagesRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'id': [] if self.id is None else self.id[:]
        }

    def __bytes__(self):
        return b''.join((
            b'\n\x858\xbd',
            bytes(self.peer),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.id)),b''.join(struct.pack('<i', x) for x in self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        reader.read_int()
        _id = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _id.append(_x)

        return cls(peer=_peer, id=_id)


class SendScreenshotNotificationRequest(TLRequest):
    CONSTRUCTOR_ID = 0xc97df020
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, peer: 'TypeInputPeer', reply_to_msg_id: int, random_id: int=None):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.peer = peer
        self.reply_to_msg_id = reply_to_msg_id
        self.random_id = random_id if random_id is not None else int.from_bytes(os.urandom(8), 'big', signed=True)

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'SendScreenshotNotificationRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'reply_to_msg_id': self.reply_to_msg_id,
            'random_id': self.random_id
        }

    def __bytes__(self):
        return b''.join((
            b' \xf0}\xc9',
            bytes(self.peer),
            struct.pack('<i', self.reply_to_msg_id),
            struct.pack('<q', self.random_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _reply_to_msg_id = reader.read_int()
        _random_id = reader.read_long()
        return cls(peer=_peer, reply_to_msg_id=_reply_to_msg_id, random_id=_random_id)


class SendVoteRequest(TLRequest):
    CONSTRUCTOR_ID = 0x10ea6184
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, peer: 'TypeInputPeer', msg_id: int, options: List[bytes]):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.peer = peer
        self.msg_id = msg_id
        self.options = options

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'SendVoteRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'msg_id': self.msg_id,
            'options': [] if self.options is None else self.options[:]
        }

    def __bytes__(self):
        return b''.join((
            b'\x84a\xea\x10',
            bytes(self.peer),
            struct.pack('<i', self.msg_id),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.options)),b''.join(self.serialize_bytes(x) for x in self.options),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        reader.read_int()
        _options = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_bytes()
            _options.append(_x)

        return cls(peer=_peer, msg_id=_msg_id, options=_options)


class SetBotCallbackAnswerRequest(TLRequest):
    CONSTRUCTOR_ID = 0xd58f130a
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, query_id: int, cache_time: int, alert: Optional[bool]=None, message: Optional[str]=None, url: Optional[str]=None):
        """
        :returns Bool: This type has no constructors.
        """
        self.query_id = query_id
        self.cache_time = cache_time
        self.alert = alert
        self.message = message
        self.url = url

    def to_dict(self):
        return {
            '_': 'SetBotCallbackAnswerRequest',
            'query_id': self.query_id,
            'cache_time': self.cache_time,
            'alert': self.alert,
            'message': self.message,
            'url': self.url
        }

    def __bytes__(self):
        return b''.join((
            b'\n\x13\x8f\xd5',
            struct.pack('<I', (0 if self.alert is None or self.alert is False else 2) | (0 if self.message is None or self.message is False else 1) | (0 if self.url is None or self.url is False else 4)),
            struct.pack('<q', self.query_id),
            b'' if self.message is None or self.message is False else (self.serialize_bytes(self.message)),
            b'' if self.url is None or self.url is False else (self.serialize_bytes(self.url)),
            struct.pack('<i', self.cache_time),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _alert = bool(flags & 2)
        _query_id = reader.read_long()
        if flags & 1:
            _message = reader.tgread_string()
        else:
            _message = None
        if flags & 4:
            _url = reader.tgread_string()
        else:
            _url = None
        _cache_time = reader.read_int()
        return cls(query_id=_query_id, cache_time=_cache_time, alert=_alert, message=_message, url=_url)


class SetBotPrecheckoutResultsRequest(TLRequest):
    CONSTRUCTOR_ID = 0x9c2dd95
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, query_id: int, success: Optional[bool]=None, error: Optional[str]=None):
        """
        :returns Bool: This type has no constructors.
        """
        self.query_id = query_id
        self.success = success
        self.error = error

    def to_dict(self):
        return {
            '_': 'SetBotPrecheckoutResultsRequest',
            'query_id': self.query_id,
            'success': self.success,
            'error': self.error
        }

    def __bytes__(self):
        return b''.join((
            b'\x95\xdd\xc2\t',
            struct.pack('<I', (0 if self.success is None or self.success is False else 2) | (0 if self.error is None or self.error is False else 1)),
            struct.pack('<q', self.query_id),
            b'' if self.error is None or self.error is False else (self.serialize_bytes(self.error)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _success = bool(flags & 2)
        _query_id = reader.read_long()
        if flags & 1:
            _error = reader.tgread_string()
        else:
            _error = None
        return cls(query_id=_query_id, success=_success, error=_error)


class SetBotShippingResultsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xe5f672fa
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, query_id: int, error: Optional[str]=None, shipping_options: Optional[List['TypeShippingOption']]=None):
        """
        :returns Bool: This type has no constructors.
        """
        self.query_id = query_id
        self.error = error
        self.shipping_options = shipping_options

    def to_dict(self):
        return {
            '_': 'SetBotShippingResultsRequest',
            'query_id': self.query_id,
            'error': self.error,
            'shipping_options': [] if self.shipping_options is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.shipping_options]
        }

    def __bytes__(self):
        return b''.join((
            b'\xfar\xf6\xe5',
            struct.pack('<I', (0 if self.error is None or self.error is False else 1) | (0 if self.shipping_options is None or self.shipping_options is False else 2)),
            struct.pack('<q', self.query_id),
            b'' if self.error is None or self.error is False else (self.serialize_bytes(self.error)),
            b'' if self.shipping_options is None or self.shipping_options is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.shipping_options)),b''.join(bytes(x) for x in self.shipping_options))),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _query_id = reader.read_long()
        if flags & 1:
            _error = reader.tgread_string()
        else:
            _error = None
        if flags & 2:
            reader.read_int()
            _shipping_options = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _shipping_options.append(_x)

        else:
            _shipping_options = None
        return cls(query_id=_query_id, error=_error, shipping_options=_shipping_options)


class SetEncryptedTypingRequest(TLRequest):
    CONSTRUCTOR_ID = 0x791451ed
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, peer: 'TypeInputEncryptedChat', typing: bool):
        """
        :returns Bool: This type has no constructors.
        """
        self.peer = peer
        self.typing = typing

    def to_dict(self):
        return {
            '_': 'SetEncryptedTypingRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'typing': self.typing
        }

    def __bytes__(self):
        return b''.join((
            b'\xedQ\x14y',
            bytes(self.peer),
            b'\xb5ur\x99' if self.typing else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _typing = reader.tgread_bool()
        return cls(peer=_peer, typing=_typing)


class SetGameScoreRequest(TLRequest):
    CONSTRUCTOR_ID = 0x8ef8ecc0
    SUBCLASS_OF_ID = 0x8af52aac

    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: int, user_id: 'TypeInputUser', score: int, edit_message: Optional[bool]=None, force: Optional[bool]=None):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.peer = peer
        self.id = id
        self.user_id = user_id
        self.score = score
        self.edit_message = edit_message
        self.force = force

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))
        self.user_id = utils.get_input_user(await client.get_input_entity(self.user_id))

    def to_dict(self):
        return {
            '_': 'SetGameScoreRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'id': self.id,
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id,
            'score': self.score,
            'edit_message': self.edit_message,
            'force': self.force
        }

    def __bytes__(self):
        return b''.join((
            b'\xc0\xec\xf8\x8e',
            struct.pack('<I', (0 if self.edit_message is None or self.edit_message is False else 1) | (0 if self.force is None or self.force is False else 2)),
            bytes(self.peer),
            struct.pack('<i', self.id),
            bytes(self.user_id),
            struct.pack('<i', self.score),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _edit_message = bool(flags & 1)
        _force = bool(flags & 2)
        _peer = reader.tgread_object()
        _id = reader.read_int()
        _user_id = reader.tgread_object()
        _score = reader.read_int()
        return cls(peer=_peer, id=_id, user_id=_user_id, score=_score, edit_message=_edit_message, force=_force)


class SetInlineBotResultsRequest(TLRequest):
    CONSTRUCTOR_ID = 0xeb5ea206
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, query_id: int, results: List['TypeInputBotInlineResult'], cache_time: int, gallery: Optional[bool]=None, private: Optional[bool]=None, next_offset: Optional[str]=None, switch_pm: Optional['TypeInlineBotSwitchPM']=None):
        """
        :returns Bool: This type has no constructors.
        """
        self.query_id = query_id
        self.results = results
        self.cache_time = cache_time
        self.gallery = gallery
        self.private = private
        self.next_offset = next_offset
        self.switch_pm = switch_pm

    def to_dict(self):
        return {
            '_': 'SetInlineBotResultsRequest',
            'query_id': self.query_id,
            'results': [] if self.results is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.results],
            'cache_time': self.cache_time,
            'gallery': self.gallery,
            'private': self.private,
            'next_offset': self.next_offset,
            'switch_pm': self.switch_pm.to_dict() if isinstance(self.switch_pm, TLObject) else self.switch_pm
        }

    def __bytes__(self):
        return b''.join((
            b'\x06\xa2^\xeb',
            struct.pack('<I', (0 if self.gallery is None or self.gallery is False else 1) | (0 if self.private is None or self.private is False else 2) | (0 if self.next_offset is None or self.next_offset is False else 4) | (0 if self.switch_pm is None or self.switch_pm is False else 8)),
            struct.pack('<q', self.query_id),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.results)),b''.join(bytes(x) for x in self.results),
            struct.pack('<i', self.cache_time),
            b'' if self.next_offset is None or self.next_offset is False else (self.serialize_bytes(self.next_offset)),
            b'' if self.switch_pm is None or self.switch_pm is False else (bytes(self.switch_pm)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _gallery = bool(flags & 1)
        _private = bool(flags & 2)
        _query_id = reader.read_long()
        reader.read_int()
        _results = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _results.append(_x)

        _cache_time = reader.read_int()
        if flags & 4:
            _next_offset = reader.tgread_string()
        else:
            _next_offset = None
        if flags & 8:
            _switch_pm = reader.tgread_object()
        else:
            _switch_pm = None
        return cls(query_id=_query_id, results=_results, cache_time=_cache_time, gallery=_gallery, private=_private, next_offset=_next_offset, switch_pm=_switch_pm)


class SetInlineGameScoreRequest(TLRequest):
    CONSTRUCTOR_ID = 0x15ad9f64
    SUBCLASS_OF_ID = 0xf5b399ac

    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputBotInlineMessageID', user_id: 'TypeInputUser', score: int, edit_message: Optional[bool]=None, force: Optional[bool]=None):
        """
        :returns Bool: This type has no constructors.
        """
        self.id = id
        self.user_id = user_id
        self.score = score
        self.edit_message = edit_message
        self.force = force

    async def resolve(self, client, utils):
        self.user_id = utils.get_input_user(await client.get_input_entity(self.user_id))

    def to_dict(self):
        return {
            '_': 'SetInlineGameScoreRequest',
            'id': self.id.to_dict() if isinstance(self.id, TLObject) else self.id,
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id,
            'score': self.score,
            'edit_message': self.edit_message,
            'force': self.force
        }

    def __bytes__(self):
        return b''.join((
            b'd\x9f\xad\x15',
            struct.pack('<I', (0 if self.edit_message is None or self.edit_message is False else 1) | (0 if self.force is None or self.force is False else 2)),
            bytes(self.id),
            bytes(self.user_id),
            struct.pack('<i', self.score),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _edit_message = bool(flags & 1)
        _force = bool(flags & 2)
        _id = reader.tgread_object()
        _user_id = reader.tgread_object()
        _score = reader.read_int()
        return cls(id=_id, user_id=_user_id, score=_score, edit_message=_edit_message, force=_force)


class SetTypingRequest(TLRequest):
    CONSTRUCTOR_ID = 0xa3825e50
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, peer: 'TypeInputPeer', action: 'TypeSendMessageAction'):
        """
        :returns Bool: This type has no constructors.
        """
        self.peer = peer
        self.action = action

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'SetTypingRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'action': self.action.to_dict() if isinstance(self.action, TLObject) else self.action
        }

    def __bytes__(self):
        return b''.join((
            b'P^\x82\xa3',
            bytes(self.peer),
            bytes(self.action),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _action = reader.tgread_object()
        return cls(peer=_peer, action=_action)


class StartBotRequest(TLRequest):
    CONSTRUCTOR_ID = 0xe6df7378
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, bot: 'TypeInputUser', peer: 'TypeInputPeer', start_param: str, random_id: int=None):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.bot = bot
        self.peer = peer
        self.start_param = start_param
        self.random_id = random_id if random_id is not None else int.from_bytes(os.urandom(8), 'big', signed=True)

    async def resolve(self, client, utils):
        self.bot = utils.get_input_user(await client.get_input_entity(self.bot))
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'StartBotRequest',
            'bot': self.bot.to_dict() if isinstance(self.bot, TLObject) else self.bot,
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'start_param': self.start_param,
            'random_id': self.random_id
        }

    def __bytes__(self):
        return b''.join((
            b'xs\xdf\xe6',
            bytes(self.bot),
            bytes(self.peer),
            struct.pack('<q', self.random_id),
            self.serialize_bytes(self.start_param),
        ))

    @classmethod
    def from_reader(cls, reader):
        _bot = reader.tgread_object()
        _peer = reader.tgread_object()
        _random_id = reader.read_long()
        _start_param = reader.tgread_string()
        return cls(bot=_bot, peer=_peer, start_param=_start_param, random_id=_random_id)


class ToggleDialogPinRequest(TLRequest):
    CONSTRUCTOR_ID = 0xa731e257
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, peer: 'TypeInputDialogPeer', pinned: Optional[bool]=None):
        """
        :returns Bool: This type has no constructors.
        """
        self.peer = peer
        self.pinned = pinned

    async def resolve(self, client, utils):
        self.peer = await client._get_input_dialog(self.peer)

    def to_dict(self):
        return {
            '_': 'ToggleDialogPinRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'pinned': self.pinned
        }

    def __bytes__(self):
        return b''.join((
            b'W\xe21\xa7',
            struct.pack('<I', (0 if self.pinned is None or self.pinned is False else 1)),
            bytes(self.peer),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _pinned = bool(flags & 1)
        _peer = reader.tgread_object()
        return cls(peer=_peer, pinned=_pinned)


class UninstallStickerSetRequest(TLRequest):
    CONSTRUCTOR_ID = 0xf96e55de
    SUBCLASS_OF_ID = 0xf5b399ac

    def __init__(self, stickerset: 'TypeInputStickerSet'):
        """
        :returns Bool: This type has no constructors.
        """
        self.stickerset = stickerset

    def to_dict(self):
        return {
            '_': 'UninstallStickerSetRequest',
            'stickerset': self.stickerset.to_dict() if isinstance(self.stickerset, TLObject) else self.stickerset
        }

    def __bytes__(self):
        return b''.join((
            b'\xdeUn\xf9',
            bytes(self.stickerset),
        ))

    @classmethod
    def from_reader(cls, reader):
        _stickerset = reader.tgread_object()
        return cls(stickerset=_stickerset)


class UpdatePinnedMessageRequest(TLRequest):
    CONSTRUCTOR_ID = 0xd2aaf7ec
    SUBCLASS_OF_ID = 0x8af52aac

    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: int, silent: Optional[bool]=None):
        """
        :returns Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.peer = peer
        self.id = id
        self.silent = silent

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))

    def to_dict(self):
        return {
            '_': 'UpdatePinnedMessageRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'id': self.id,
            'silent': self.silent
        }

    def __bytes__(self):
        return b''.join((
            b'\xec\xf7\xaa\xd2',
            struct.pack('<I', (0 if self.silent is None or self.silent is False else 1)),
            bytes(self.peer),
            struct.pack('<i', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _silent = bool(flags & 1)
        _peer = reader.tgread_object()
        _id = reader.read_int()
        return cls(peer=_peer, id=_id, silent=_silent)


class UploadEncryptedFileRequest(TLRequest):
    CONSTRUCTOR_ID = 0x5057c497
    SUBCLASS_OF_ID = 0x842a67c0

    def __init__(self, peer: 'TypeInputEncryptedChat', file: 'TypeInputEncryptedFile'):
        """
        :returns EncryptedFile: Instance of either EncryptedFileEmpty, EncryptedFile.
        """
        self.peer = peer
        self.file = file

    def to_dict(self):
        return {
            '_': 'UploadEncryptedFileRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'file': self.file.to_dict() if isinstance(self.file, TLObject) else self.file
        }

    def __bytes__(self):
        return b''.join((
            b'\x97\xc4WP',
            bytes(self.peer),
            bytes(self.file),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _file = reader.tgread_object()
        return cls(peer=_peer, file=_file)


class UploadMediaRequest(TLRequest):
    CONSTRUCTOR_ID = 0x519bc2b1
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, peer: 'TypeInputPeer', media: 'TypeInputMedia'):
        """
        :returns MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll.
        """
        self.peer = peer
        self.media = media

    async def resolve(self, client, utils):
        self.peer = utils.get_input_peer(await client.get_input_entity(self.peer))
        self.media = utils.get_input_media(self.media)

    def to_dict(self):
        return {
            '_': 'UploadMediaRequest',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'media': self.media.to_dict() if isinstance(self.media, TLObject) else self.media
        }

    def __bytes__(self):
        return b''.join((
            b'\xb1\xc2\x9bQ',
            bytes(self.peer),
            bytes(self.media),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _media = reader.tgread_object()
        return cls(peer=_peer, media=_media)

