"""File generated by TLObjects' generator. All changes will be ERASED"""
from ...tl.tlobject import TLObject
from typing import Optional, List, Union, TYPE_CHECKING
from . import account, auth, channels, contacts, help, messages, payments, phone, photos, storage, updates, upload, wallet
import os
import struct
from datetime import datetime
if TYPE_CHECKING:
    from ...tl.types import Typefuture_salt



class AccessPointRule(TLObject):
    CONSTRUCTOR_ID = 0x4679b65f
    SUBCLASS_OF_ID = 0xb1aca0fd

    def __init__(self, phone_prefix_rules: str, dc_id: int, ips: List['TypeIpPort']):
        """
        Constructor for AccessPointRule: Instance of AccessPointRule.
        """
        self.phone_prefix_rules = phone_prefix_rules
        self.dc_id = dc_id
        self.ips = ips

    def to_dict(self):
        return {
            '_': 'AccessPointRule',
            'phone_prefix_rules': self.phone_prefix_rules,
            'dc_id': self.dc_id,
            'ips': [] if self.ips is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.ips]
        }

    def __bytes__(self):
        return b''.join((
            b'_\xb6yF',
            self.serialize_bytes(self.phone_prefix_rules),
            struct.pack('<i', self.dc_id),
            struct.pack('<i', len(self.ips)),b''.join(bytes(x) for x in self.ips),
        ))

    @classmethod
    def from_reader(cls, reader):
        _phone_prefix_rules = reader.tgread_string()
        _dc_id = reader.read_int()
        _ips = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _ips.append(_x)

        return cls(phone_prefix_rules=_phone_prefix_rules, dc_id=_dc_id, ips=_ips)


class AccountDaysTTL(TLObject):
    CONSTRUCTOR_ID = 0xb8d0afdf
    SUBCLASS_OF_ID = 0xbaa39d88

    def __init__(self, days: int):
        """
        Constructor for AccountDaysTTL: Instance of AccountDaysTTL.
        """
        self.days = days

    def to_dict(self):
        return {
            '_': 'AccountDaysTTL',
            'days': self.days
        }

    def __bytes__(self):
        return b''.join((
            b'\xdf\xaf\xd0\xb8',
            struct.pack('<i', self.days),
        ))

    @classmethod
    def from_reader(cls, reader):
        _days = reader.read_int()
        return cls(days=_days)


class Authorization(TLObject):
    CONSTRUCTOR_ID = 0xad01d61d
    SUBCLASS_OF_ID = 0xc913c01a

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, device_model: str, platform: str, system_version: str, api_id: int, app_name: str, app_version: str, date_created: Optional[datetime], date_active: Optional[datetime], ip: str, country: str, region: str, current: Optional[bool]=None, official_app: Optional[bool]=None, password_pending: Optional[bool]=None):
        """
        Constructor for Authorization: Instance of Authorization.
        """
        self.hash = hash
        self.device_model = device_model
        self.platform = platform
        self.system_version = system_version
        self.api_id = api_id
        self.app_name = app_name
        self.app_version = app_version
        self.date_created = date_created
        self.date_active = date_active
        self.ip = ip
        self.country = country
        self.region = region
        self.current = current
        self.official_app = official_app
        self.password_pending = password_pending

    def to_dict(self):
        return {
            '_': 'Authorization',
            'hash': self.hash,
            'device_model': self.device_model,
            'platform': self.platform,
            'system_version': self.system_version,
            'api_id': self.api_id,
            'app_name': self.app_name,
            'app_version': self.app_version,
            'date_created': self.date_created,
            'date_active': self.date_active,
            'ip': self.ip,
            'country': self.country,
            'region': self.region,
            'current': self.current,
            'official_app': self.official_app,
            'password_pending': self.password_pending
        }

    def __bytes__(self):
        return b''.join((
            b'\x1d\xd6\x01\xad',
            struct.pack('<I', (0 if self.current is None or self.current is False else 1) | (0 if self.official_app is None or self.official_app is False else 2) | (0 if self.password_pending is None or self.password_pending is False else 4)),
            struct.pack('<q', self.hash),
            self.serialize_bytes(self.device_model),
            self.serialize_bytes(self.platform),
            self.serialize_bytes(self.system_version),
            struct.pack('<i', self.api_id),
            self.serialize_bytes(self.app_name),
            self.serialize_bytes(self.app_version),
            self.serialize_datetime(self.date_created),
            self.serialize_datetime(self.date_active),
            self.serialize_bytes(self.ip),
            self.serialize_bytes(self.country),
            self.serialize_bytes(self.region),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _current = bool(flags & 1)
        _official_app = bool(flags & 2)
        _password_pending = bool(flags & 4)
        _hash = reader.read_long()
        _device_model = reader.tgread_string()
        _platform = reader.tgread_string()
        _system_version = reader.tgread_string()
        _api_id = reader.read_int()
        _app_name = reader.tgread_string()
        _app_version = reader.tgread_string()
        _date_created = reader.tgread_date()
        _date_active = reader.tgread_date()
        _ip = reader.tgread_string()
        _country = reader.tgread_string()
        _region = reader.tgread_string()
        return cls(hash=_hash, device_model=_device_model, platform=_platform, system_version=_system_version, api_id=_api_id, app_name=_app_name, app_version=_app_version, date_created=_date_created, date_active=_date_active, ip=_ip, country=_country, region=_region, current=_current, official_app=_official_app, password_pending=_password_pending)


class AutoDownloadSettings(TLObject):
    CONSTRUCTOR_ID = 0xd246fd47
    SUBCLASS_OF_ID = 0x512819c7

    def __init__(self, photo_size_max: int, video_size_max: int, file_size_max: int, disabled: Optional[bool]=None, video_preload_large: Optional[bool]=None, audio_preload_next: Optional[bool]=None, phonecalls_less_data: Optional[bool]=None):
        """
        Constructor for AutoDownloadSettings: Instance of AutoDownloadSettings.
        """
        self.photo_size_max = photo_size_max
        self.video_size_max = video_size_max
        self.file_size_max = file_size_max
        self.disabled = disabled
        self.video_preload_large = video_preload_large
        self.audio_preload_next = audio_preload_next
        self.phonecalls_less_data = phonecalls_less_data

    def to_dict(self):
        return {
            '_': 'AutoDownloadSettings',
            'photo_size_max': self.photo_size_max,
            'video_size_max': self.video_size_max,
            'file_size_max': self.file_size_max,
            'disabled': self.disabled,
            'video_preload_large': self.video_preload_large,
            'audio_preload_next': self.audio_preload_next,
            'phonecalls_less_data': self.phonecalls_less_data
        }

    def __bytes__(self):
        return b''.join((
            b'G\xfdF\xd2',
            struct.pack('<I', (0 if self.disabled is None or self.disabled is False else 1) | (0 if self.video_preload_large is None or self.video_preload_large is False else 2) | (0 if self.audio_preload_next is None or self.audio_preload_next is False else 4) | (0 if self.phonecalls_less_data is None or self.phonecalls_less_data is False else 8)),
            struct.pack('<i', self.photo_size_max),
            struct.pack('<i', self.video_size_max),
            struct.pack('<i', self.file_size_max),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _disabled = bool(flags & 1)
        _video_preload_large = bool(flags & 2)
        _audio_preload_next = bool(flags & 4)
        _phonecalls_less_data = bool(flags & 8)
        _photo_size_max = reader.read_int()
        _video_size_max = reader.read_int()
        _file_size_max = reader.read_int()
        return cls(photo_size_max=_photo_size_max, video_size_max=_video_size_max, file_size_max=_file_size_max, disabled=_disabled, video_preload_large=_video_preload_large, audio_preload_next=_audio_preload_next, phonecalls_less_data=_phonecalls_less_data)


class BadMsgNotification(TLObject):
    CONSTRUCTOR_ID = 0xa7eff811
    SUBCLASS_OF_ID = 0xcebaa157

    def __init__(self, bad_msg_id: int, bad_msg_seqno: int, error_code: int):
        """
        Constructor for BadMsgNotification: Instance of either BadMsgNotification, BadServerSalt.
        """
        self.bad_msg_id = bad_msg_id
        self.bad_msg_seqno = bad_msg_seqno
        self.error_code = error_code

    def to_dict(self):
        return {
            '_': 'BadMsgNotification',
            'bad_msg_id': self.bad_msg_id,
            'bad_msg_seqno': self.bad_msg_seqno,
            'error_code': self.error_code
        }

    def __bytes__(self):
        return b''.join((
            b'\x11\xf8\xef\xa7',
            struct.pack('<q', self.bad_msg_id),
            struct.pack('<i', self.bad_msg_seqno),
            struct.pack('<i', self.error_code),
        ))

    @classmethod
    def from_reader(cls, reader):
        _bad_msg_id = reader.read_long()
        _bad_msg_seqno = reader.read_int()
        _error_code = reader.read_int()
        return cls(bad_msg_id=_bad_msg_id, bad_msg_seqno=_bad_msg_seqno, error_code=_error_code)


class BadServerSalt(TLObject):
    CONSTRUCTOR_ID = 0xedab447b
    SUBCLASS_OF_ID = 0xcebaa157

    def __init__(self, bad_msg_id: int, bad_msg_seqno: int, error_code: int, new_server_salt: int):
        """
        Constructor for BadMsgNotification: Instance of either BadMsgNotification, BadServerSalt.
        """
        self.bad_msg_id = bad_msg_id
        self.bad_msg_seqno = bad_msg_seqno
        self.error_code = error_code
        self.new_server_salt = new_server_salt

    def to_dict(self):
        return {
            '_': 'BadServerSalt',
            'bad_msg_id': self.bad_msg_id,
            'bad_msg_seqno': self.bad_msg_seqno,
            'error_code': self.error_code,
            'new_server_salt': self.new_server_salt
        }

    def __bytes__(self):
        return b''.join((
            b'{D\xab\xed',
            struct.pack('<q', self.bad_msg_id),
            struct.pack('<i', self.bad_msg_seqno),
            struct.pack('<i', self.error_code),
            struct.pack('<q', self.new_server_salt),
        ))

    @classmethod
    def from_reader(cls, reader):
        _bad_msg_id = reader.read_long()
        _bad_msg_seqno = reader.read_int()
        _error_code = reader.read_int()
        _new_server_salt = reader.read_long()
        return cls(bad_msg_id=_bad_msg_id, bad_msg_seqno=_bad_msg_seqno, error_code=_error_code, new_server_salt=_new_server_salt)


class BotCommand(TLObject):
    CONSTRUCTOR_ID = 0xc27ac8c7
    SUBCLASS_OF_ID = 0xe1e62c2

    def __init__(self, command: str, description: str):
        """
        Constructor for BotCommand: Instance of BotCommand.
        """
        self.command = command
        self.description = description

    def to_dict(self):
        return {
            '_': 'BotCommand',
            'command': self.command,
            'description': self.description
        }

    def __bytes__(self):
        return b''.join((
            b'\xc7\xc8z\xc2',
            self.serialize_bytes(self.command),
            self.serialize_bytes(self.description),
        ))

    @classmethod
    def from_reader(cls, reader):
        _command = reader.tgread_string()
        _description = reader.tgread_string()
        return cls(command=_command, description=_description)


class BotInfo(TLObject):
    CONSTRUCTOR_ID = 0x98e81d3a
    SUBCLASS_OF_ID = 0xf1f701db

    def __init__(self, user_id: int, description: str, commands: List['TypeBotCommand']):
        """
        Constructor for BotInfo: Instance of BotInfo.
        """
        self.user_id = user_id
        self.description = description
        self.commands = commands

    def to_dict(self):
        return {
            '_': 'BotInfo',
            'user_id': self.user_id,
            'description': self.description,
            'commands': [] if self.commands is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.commands]
        }

    def __bytes__(self):
        return b''.join((
            b':\x1d\xe8\x98',
            struct.pack('<i', self.user_id),
            self.serialize_bytes(self.description),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.commands)),b''.join(bytes(x) for x in self.commands),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        _description = reader.tgread_string()
        reader.read_int()
        _commands = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _commands.append(_x)

        return cls(user_id=_user_id, description=_description, commands=_commands)


class BotInlineMediaResult(TLObject):
    CONSTRUCTOR_ID = 0x17db940b
    SUBCLASS_OF_ID = 0x3832b3d5

    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, type: str, send_message: 'TypeBotInlineMessage', photo: Optional['TypePhoto']=None, document: Optional['TypeDocument']=None, title: Optional[str]=None, description: Optional[str]=None):
        """
        Constructor for BotInlineResult: Instance of either BotInlineResult, BotInlineMediaResult.
        """
        self.id = id
        self.type = type
        self.send_message = send_message
        self.photo = photo
        self.document = document
        self.title = title
        self.description = description

    def to_dict(self):
        return {
            '_': 'BotInlineMediaResult',
            'id': self.id,
            'type': self.type,
            'send_message': self.send_message.to_dict() if isinstance(self.send_message, TLObject) else self.send_message,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'document': self.document.to_dict() if isinstance(self.document, TLObject) else self.document,
            'title': self.title,
            'description': self.description
        }

    def __bytes__(self):
        return b''.join((
            b'\x0b\x94\xdb\x17',
            struct.pack('<I', (0 if self.photo is None or self.photo is False else 1) | (0 if self.document is None or self.document is False else 2) | (0 if self.title is None or self.title is False else 4) | (0 if self.description is None or self.description is False else 8)),
            self.serialize_bytes(self.id),
            self.serialize_bytes(self.type),
            b'' if self.photo is None or self.photo is False else (bytes(self.photo)),
            b'' if self.document is None or self.document is False else (bytes(self.document)),
            b'' if self.title is None or self.title is False else (self.serialize_bytes(self.title)),
            b'' if self.description is None or self.description is False else (self.serialize_bytes(self.description)),
            bytes(self.send_message),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.tgread_string()
        _type = reader.tgread_string()
        if flags & 1:
            _photo = reader.tgread_object()
        else:
            _photo = None
        if flags & 2:
            _document = reader.tgread_object()
        else:
            _document = None
        if flags & 4:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 8:
            _description = reader.tgread_string()
        else:
            _description = None
        _send_message = reader.tgread_object()
        return cls(id=_id, type=_type, send_message=_send_message, photo=_photo, document=_document, title=_title, description=_description)


class BotInlineMessageMediaAuto(TLObject):
    CONSTRUCTOR_ID = 0x764cf810
    SUBCLASS_OF_ID = 0xc4910f88

    def __init__(self, message: str, entities: Optional[List['TypeMessageEntity']]=None, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for BotInlineMessage: Instance of either BotInlineMessageMediaAuto, BotInlineMessageText, BotInlineMessageMediaGeo, BotInlineMessageMediaVenue, BotInlineMessageMediaContact.
        """
        self.message = message
        self.entities = entities
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'BotInlineMessageMediaAuto',
            'message': self.message,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities],
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def __bytes__(self):
        return b''.join((
            b'\x10\xf8Lv',
            struct.pack('<I', (0 if self.entities is None or self.entities is False else 2) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(bytes(x) for x in self.entities))),
            b'' if self.reply_markup is None or self.reply_markup is False else (bytes(self.reply_markup)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _message = reader.tgread_string()
        if flags & 2:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(message=_message, entities=_entities, reply_markup=_reply_markup)


class BotInlineMessageMediaContact(TLObject):
    CONSTRUCTOR_ID = 0x18d1cdc2
    SUBCLASS_OF_ID = 0xc4910f88

    def __init__(self, phone_number: str, first_name: str, last_name: str, vcard: str, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for BotInlineMessage: Instance of either BotInlineMessageMediaAuto, BotInlineMessageText, BotInlineMessageMediaGeo, BotInlineMessageMediaVenue, BotInlineMessageMediaContact.
        """
        self.phone_number = phone_number
        self.first_name = first_name
        self.last_name = last_name
        self.vcard = vcard
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'BotInlineMessageMediaContact',
            'phone_number': self.phone_number,
            'first_name': self.first_name,
            'last_name': self.last_name,
            'vcard': self.vcard,
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def __bytes__(self):
        return b''.join((
            b'\xc2\xcd\xd1\x18',
            struct.pack('<I', (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.serialize_bytes(self.phone_number),
            self.serialize_bytes(self.first_name),
            self.serialize_bytes(self.last_name),
            self.serialize_bytes(self.vcard),
            b'' if self.reply_markup is None or self.reply_markup is False else (bytes(self.reply_markup)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _phone_number = reader.tgread_string()
        _first_name = reader.tgread_string()
        _last_name = reader.tgread_string()
        _vcard = reader.tgread_string()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(phone_number=_phone_number, first_name=_first_name, last_name=_last_name, vcard=_vcard, reply_markup=_reply_markup)


class BotInlineMessageMediaGeo(TLObject):
    CONSTRUCTOR_ID = 0xb722de65
    SUBCLASS_OF_ID = 0xc4910f88

    def __init__(self, geo: 'TypeGeoPoint', period: int, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for BotInlineMessage: Instance of either BotInlineMessageMediaAuto, BotInlineMessageText, BotInlineMessageMediaGeo, BotInlineMessageMediaVenue, BotInlineMessageMediaContact.
        """
        self.geo = geo
        self.period = period
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'BotInlineMessageMediaGeo',
            'geo': self.geo.to_dict() if isinstance(self.geo, TLObject) else self.geo,
            'period': self.period,
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def __bytes__(self):
        return b''.join((
            b'e\xde"\xb7',
            struct.pack('<I', (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            bytes(self.geo),
            struct.pack('<i', self.period),
            b'' if self.reply_markup is None or self.reply_markup is False else (bytes(self.reply_markup)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _geo = reader.tgread_object()
        _period = reader.read_int()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(geo=_geo, period=_period, reply_markup=_reply_markup)


class BotInlineMessageMediaVenue(TLObject):
    CONSTRUCTOR_ID = 0x8a86659c
    SUBCLASS_OF_ID = 0xc4910f88

    def __init__(self, geo: 'TypeGeoPoint', title: str, address: str, provider: str, venue_id: str, venue_type: str, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for BotInlineMessage: Instance of either BotInlineMessageMediaAuto, BotInlineMessageText, BotInlineMessageMediaGeo, BotInlineMessageMediaVenue, BotInlineMessageMediaContact.
        """
        self.geo = geo
        self.title = title
        self.address = address
        self.provider = provider
        self.venue_id = venue_id
        self.venue_type = venue_type
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'BotInlineMessageMediaVenue',
            'geo': self.geo.to_dict() if isinstance(self.geo, TLObject) else self.geo,
            'title': self.title,
            'address': self.address,
            'provider': self.provider,
            'venue_id': self.venue_id,
            'venue_type': self.venue_type,
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def __bytes__(self):
        return b''.join((
            b'\x9ce\x86\x8a',
            struct.pack('<I', (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            bytes(self.geo),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.address),
            self.serialize_bytes(self.provider),
            self.serialize_bytes(self.venue_id),
            self.serialize_bytes(self.venue_type),
            b'' if self.reply_markup is None or self.reply_markup is False else (bytes(self.reply_markup)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _geo = reader.tgread_object()
        _title = reader.tgread_string()
        _address = reader.tgread_string()
        _provider = reader.tgread_string()
        _venue_id = reader.tgread_string()
        _venue_type = reader.tgread_string()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(geo=_geo, title=_title, address=_address, provider=_provider, venue_id=_venue_id, venue_type=_venue_type, reply_markup=_reply_markup)


class BotInlineMessageText(TLObject):
    CONSTRUCTOR_ID = 0x8c7f65e2
    SUBCLASS_OF_ID = 0xc4910f88

    def __init__(self, message: str, no_webpage: Optional[bool]=None, entities: Optional[List['TypeMessageEntity']]=None, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for BotInlineMessage: Instance of either BotInlineMessageMediaAuto, BotInlineMessageText, BotInlineMessageMediaGeo, BotInlineMessageMediaVenue, BotInlineMessageMediaContact.
        """
        self.message = message
        self.no_webpage = no_webpage
        self.entities = entities
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'BotInlineMessageText',
            'message': self.message,
            'no_webpage': self.no_webpage,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities],
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def __bytes__(self):
        return b''.join((
            b'\xe2e\x7f\x8c',
            struct.pack('<I', (0 if self.no_webpage is None or self.no_webpage is False else 1) | (0 if self.entities is None or self.entities is False else 2) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(bytes(x) for x in self.entities))),
            b'' if self.reply_markup is None or self.reply_markup is False else (bytes(self.reply_markup)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _no_webpage = bool(flags & 1)
        _message = reader.tgread_string()
        if flags & 2:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(message=_message, no_webpage=_no_webpage, entities=_entities, reply_markup=_reply_markup)


class BotInlineResult(TLObject):
    CONSTRUCTOR_ID = 0x11965f3a
    SUBCLASS_OF_ID = 0x3832b3d5

    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, type: str, send_message: 'TypeBotInlineMessage', title: Optional[str]=None, description: Optional[str]=None, url: Optional[str]=None, thumb: Optional['TypeWebDocument']=None, content: Optional['TypeWebDocument']=None):
        """
        Constructor for BotInlineResult: Instance of either BotInlineResult, BotInlineMediaResult.
        """
        self.id = id
        self.type = type
        self.send_message = send_message
        self.title = title
        self.description = description
        self.url = url
        self.thumb = thumb
        self.content = content

    def to_dict(self):
        return {
            '_': 'BotInlineResult',
            'id': self.id,
            'type': self.type,
            'send_message': self.send_message.to_dict() if isinstance(self.send_message, TLObject) else self.send_message,
            'title': self.title,
            'description': self.description,
            'url': self.url,
            'thumb': self.thumb.to_dict() if isinstance(self.thumb, TLObject) else self.thumb,
            'content': self.content.to_dict() if isinstance(self.content, TLObject) else self.content
        }

    def __bytes__(self):
        return b''.join((
            b':_\x96\x11',
            struct.pack('<I', (0 if self.title is None or self.title is False else 2) | (0 if self.description is None or self.description is False else 4) | (0 if self.url is None or self.url is False else 8) | (0 if self.thumb is None or self.thumb is False else 16) | (0 if self.content is None or self.content is False else 32)),
            self.serialize_bytes(self.id),
            self.serialize_bytes(self.type),
            b'' if self.title is None or self.title is False else (self.serialize_bytes(self.title)),
            b'' if self.description is None or self.description is False else (self.serialize_bytes(self.description)),
            b'' if self.url is None or self.url is False else (self.serialize_bytes(self.url)),
            b'' if self.thumb is None or self.thumb is False else (bytes(self.thumb)),
            b'' if self.content is None or self.content is False else (bytes(self.content)),
            bytes(self.send_message),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.tgread_string()
        _type = reader.tgread_string()
        if flags & 2:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 4:
            _description = reader.tgread_string()
        else:
            _description = None
        if flags & 8:
            _url = reader.tgread_string()
        else:
            _url = None
        if flags & 16:
            _thumb = reader.tgread_object()
        else:
            _thumb = None
        if flags & 32:
            _content = reader.tgread_object()
        else:
            _content = None
        _send_message = reader.tgread_object()
        return cls(id=_id, type=_type, send_message=_send_message, title=_title, description=_description, url=_url, thumb=_thumb, content=_content)


class CdnConfig(TLObject):
    CONSTRUCTOR_ID = 0x5725e40a
    SUBCLASS_OF_ID = 0xecda397c

    def __init__(self, public_keys: List['TypeCdnPublicKey']):
        """
        Constructor for CdnConfig: Instance of CdnConfig.
        """
        self.public_keys = public_keys

    def to_dict(self):
        return {
            '_': 'CdnConfig',
            'public_keys': [] if self.public_keys is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.public_keys]
        }

    def __bytes__(self):
        return b''.join((
            b'\n\xe4%W',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.public_keys)),b''.join(bytes(x) for x in self.public_keys),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _public_keys = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _public_keys.append(_x)

        return cls(public_keys=_public_keys)


class CdnPublicKey(TLObject):
    CONSTRUCTOR_ID = 0xc982eaba
    SUBCLASS_OF_ID = 0x16db47f3

    def __init__(self, dc_id: int, public_key: str):
        """
        Constructor for CdnPublicKey: Instance of CdnPublicKey.
        """
        self.dc_id = dc_id
        self.public_key = public_key

    def to_dict(self):
        return {
            '_': 'CdnPublicKey',
            'dc_id': self.dc_id,
            'public_key': self.public_key
        }

    def __bytes__(self):
        return b''.join((
            b'\xba\xea\x82\xc9',
            struct.pack('<i', self.dc_id),
            self.serialize_bytes(self.public_key),
        ))

    @classmethod
    def from_reader(cls, reader):
        _dc_id = reader.read_int()
        _public_key = reader.tgread_string()
        return cls(dc_id=_dc_id, public_key=_public_key)


class Channel(TLObject):
    CONSTRUCTOR_ID = 0xd31a961e
    SUBCLASS_OF_ID = 0xc5af5d94

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, title: str, photo: 'TypeChatPhoto', date: Optional[datetime], version: int, creator: Optional[bool]=None, left: Optional[bool]=None, broadcast: Optional[bool]=None, verified: Optional[bool]=None, megagroup: Optional[bool]=None, restricted: Optional[bool]=None, signatures: Optional[bool]=None, min: Optional[bool]=None, scam: Optional[bool]=None, has_link: Optional[bool]=None, has_geo: Optional[bool]=None, slowmode_enabled: Optional[bool]=None, access_hash: Optional[int]=None, username: Optional[str]=None, restriction_reason: Optional[List['TypeRestrictionReason']]=None, admin_rights: Optional['TypeChatAdminRights']=None, banned_rights: Optional['TypeChatBannedRights']=None, default_banned_rights: Optional['TypeChatBannedRights']=None, participants_count: Optional[int]=None):
        """
        Constructor for Chat: Instance of either ChatEmpty, Chat, ChatForbidden, Channel, ChannelForbidden.
        """
        self.id = id
        self.title = title
        self.photo = photo
        self.date = date
        self.version = version
        self.creator = creator
        self.left = left
        self.broadcast = broadcast
        self.verified = verified
        self.megagroup = megagroup
        self.restricted = restricted
        self.signatures = signatures
        self.min = min
        self.scam = scam
        self.has_link = has_link
        self.has_geo = has_geo
        self.slowmode_enabled = slowmode_enabled
        self.access_hash = access_hash
        self.username = username
        self.restriction_reason = restriction_reason
        self.admin_rights = admin_rights
        self.banned_rights = banned_rights
        self.default_banned_rights = default_banned_rights
        self.participants_count = participants_count

    def to_dict(self):
        return {
            '_': 'Channel',
            'id': self.id,
            'title': self.title,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'date': self.date,
            'version': self.version,
            'creator': self.creator,
            'left': self.left,
            'broadcast': self.broadcast,
            'verified': self.verified,
            'megagroup': self.megagroup,
            'restricted': self.restricted,
            'signatures': self.signatures,
            'min': self.min,
            'scam': self.scam,
            'has_link': self.has_link,
            'has_geo': self.has_geo,
            'slowmode_enabled': self.slowmode_enabled,
            'access_hash': self.access_hash,
            'username': self.username,
            'restriction_reason': [] if self.restriction_reason is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.restriction_reason],
            'admin_rights': self.admin_rights.to_dict() if isinstance(self.admin_rights, TLObject) else self.admin_rights,
            'banned_rights': self.banned_rights.to_dict() if isinstance(self.banned_rights, TLObject) else self.banned_rights,
            'default_banned_rights': self.default_banned_rights.to_dict() if isinstance(self.default_banned_rights, TLObject) else self.default_banned_rights,
            'participants_count': self.participants_count
        }

    def __bytes__(self):
        assert ((self.restricted or self.restricted is not None) and (self.restriction_reason or self.restriction_reason is not None)) or ((self.restricted is None or self.restricted is False) and (self.restriction_reason is None or self.restriction_reason is False)), 'restricted, restriction_reason parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\x1e\x96\x1a\xd3',
            struct.pack('<I', (0 if self.creator is None or self.creator is False else 1) | (0 if self.left is None or self.left is False else 4) | (0 if self.broadcast is None or self.broadcast is False else 32) | (0 if self.verified is None or self.verified is False else 128) | (0 if self.megagroup is None or self.megagroup is False else 256) | (0 if self.restricted is None or self.restricted is False else 512) | (0 if self.signatures is None or self.signatures is False else 2048) | (0 if self.min is None or self.min is False else 4096) | (0 if self.scam is None or self.scam is False else 524288) | (0 if self.has_link is None or self.has_link is False else 1048576) | (0 if self.has_geo is None or self.has_geo is False else 2097152) | (0 if self.slowmode_enabled is None or self.slowmode_enabled is False else 4194304) | (0 if self.access_hash is None or self.access_hash is False else 8192) | (0 if self.username is None or self.username is False else 64) | (0 if self.restriction_reason is None or self.restriction_reason is False else 512) | (0 if self.admin_rights is None or self.admin_rights is False else 16384) | (0 if self.banned_rights is None or self.banned_rights is False else 32768) | (0 if self.default_banned_rights is None or self.default_banned_rights is False else 262144) | (0 if self.participants_count is None or self.participants_count is False else 131072)),
            struct.pack('<i', self.id),
            b'' if self.access_hash is None or self.access_hash is False else (struct.pack('<q', self.access_hash)),
            self.serialize_bytes(self.title),
            b'' if self.username is None or self.username is False else (self.serialize_bytes(self.username)),
            bytes(self.photo),
            self.serialize_datetime(self.date),
            struct.pack('<i', self.version),
            b'' if self.restriction_reason is None or self.restriction_reason is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.restriction_reason)),b''.join(bytes(x) for x in self.restriction_reason))),
            b'' if self.admin_rights is None or self.admin_rights is False else (bytes(self.admin_rights)),
            b'' if self.banned_rights is None or self.banned_rights is False else (bytes(self.banned_rights)),
            b'' if self.default_banned_rights is None or self.default_banned_rights is False else (bytes(self.default_banned_rights)),
            b'' if self.participants_count is None or self.participants_count is False else (struct.pack('<i', self.participants_count)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _creator = bool(flags & 1)
        _left = bool(flags & 4)
        _broadcast = bool(flags & 32)
        _verified = bool(flags & 128)
        _megagroup = bool(flags & 256)
        _restricted = bool(flags & 512)
        _signatures = bool(flags & 2048)
        _min = bool(flags & 4096)
        _scam = bool(flags & 524288)
        _has_link = bool(flags & 1048576)
        _has_geo = bool(flags & 2097152)
        _slowmode_enabled = bool(flags & 4194304)
        _id = reader.read_int()
        if flags & 8192:
            _access_hash = reader.read_long()
        else:
            _access_hash = None
        _title = reader.tgread_string()
        if flags & 64:
            _username = reader.tgread_string()
        else:
            _username = None
        _photo = reader.tgread_object()
        _date = reader.tgread_date()
        _version = reader.read_int()
        if flags & 512:
            reader.read_int()
            _restriction_reason = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _restriction_reason.append(_x)

        else:
            _restriction_reason = None
        if flags & 16384:
            _admin_rights = reader.tgread_object()
        else:
            _admin_rights = None
        if flags & 32768:
            _banned_rights = reader.tgread_object()
        else:
            _banned_rights = None
        if flags & 262144:
            _default_banned_rights = reader.tgread_object()
        else:
            _default_banned_rights = None
        if flags & 131072:
            _participants_count = reader.read_int()
        else:
            _participants_count = None
        return cls(id=_id, title=_title, photo=_photo, date=_date, version=_version, creator=_creator, left=_left, broadcast=_broadcast, verified=_verified, megagroup=_megagroup, restricted=_restricted, signatures=_signatures, min=_min, scam=_scam, has_link=_has_link, has_geo=_has_geo, slowmode_enabled=_slowmode_enabled, access_hash=_access_hash, username=_username, restriction_reason=_restriction_reason, admin_rights=_admin_rights, banned_rights=_banned_rights, default_banned_rights=_default_banned_rights, participants_count=_participants_count)


class ChannelAdminLogEvent(TLObject):
    CONSTRUCTOR_ID = 0x3b5a3e40
    SUBCLASS_OF_ID = 0x408f0999

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, date: Optional[datetime], user_id: int, action: 'TypeChannelAdminLogEventAction'):
        """
        Constructor for ChannelAdminLogEvent: Instance of ChannelAdminLogEvent.
        """
        self.id = id
        self.date = date
        self.user_id = user_id
        self.action = action

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEvent',
            'id': self.id,
            'date': self.date,
            'user_id': self.user_id,
            'action': self.action.to_dict() if isinstance(self.action, TLObject) else self.action
        }

    def __bytes__(self):
        return b''.join((
            b'@>Z;',
            struct.pack('<q', self.id),
            self.serialize_datetime(self.date),
            struct.pack('<i', self.user_id),
            bytes(self.action),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _date = reader.tgread_date()
        _user_id = reader.read_int()
        _action = reader.tgread_object()
        return cls(id=_id, date=_date, user_id=_user_id, action=_action)


class ChannelAdminLogEventActionChangeAbout(TLObject):
    CONSTRUCTOR_ID = 0x55188a2e
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_value: str, new_value: str):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode.
        """
        self.prev_value = prev_value
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionChangeAbout',
            'prev_value': self.prev_value,
            'new_value': self.new_value
        }

    def __bytes__(self):
        return b''.join((
            b'.\x8a\x18U',
            self.serialize_bytes(self.prev_value),
            self.serialize_bytes(self.new_value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_value = reader.tgread_string()
        _new_value = reader.tgread_string()
        return cls(prev_value=_prev_value, new_value=_new_value)


class ChannelAdminLogEventActionChangeLinkedChat(TLObject):
    CONSTRUCTOR_ID = 0xa26f881b
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_value: int, new_value: int):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode.
        """
        self.prev_value = prev_value
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionChangeLinkedChat',
            'prev_value': self.prev_value,
            'new_value': self.new_value
        }

    def __bytes__(self):
        return b''.join((
            b'\x1b\x88o\xa2',
            struct.pack('<i', self.prev_value),
            struct.pack('<i', self.new_value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_value = reader.read_int()
        _new_value = reader.read_int()
        return cls(prev_value=_prev_value, new_value=_new_value)


class ChannelAdminLogEventActionChangeLocation(TLObject):
    CONSTRUCTOR_ID = 0xe6b76ae
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_value: 'TypeChannelLocation', new_value: 'TypeChannelLocation'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode.
        """
        self.prev_value = prev_value
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionChangeLocation',
            'prev_value': self.prev_value.to_dict() if isinstance(self.prev_value, TLObject) else self.prev_value,
            'new_value': self.new_value.to_dict() if isinstance(self.new_value, TLObject) else self.new_value
        }

    def __bytes__(self):
        return b''.join((
            b'\xaevk\x0e',
            bytes(self.prev_value),
            bytes(self.new_value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_value = reader.tgread_object()
        _new_value = reader.tgread_object()
        return cls(prev_value=_prev_value, new_value=_new_value)


class ChannelAdminLogEventActionChangePhoto(TLObject):
    CONSTRUCTOR_ID = 0x434bd2af
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_photo: 'TypePhoto', new_photo: 'TypePhoto'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode.
        """
        self.prev_photo = prev_photo
        self.new_photo = new_photo

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionChangePhoto',
            'prev_photo': self.prev_photo.to_dict() if isinstance(self.prev_photo, TLObject) else self.prev_photo,
            'new_photo': self.new_photo.to_dict() if isinstance(self.new_photo, TLObject) else self.new_photo
        }

    def __bytes__(self):
        return b''.join((
            b'\xaf\xd2KC',
            bytes(self.prev_photo),
            bytes(self.new_photo),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_photo = reader.tgread_object()
        _new_photo = reader.tgread_object()
        return cls(prev_photo=_prev_photo, new_photo=_new_photo)


class ChannelAdminLogEventActionChangeStickerSet(TLObject):
    CONSTRUCTOR_ID = 0xb1c3caa7
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_stickerset: 'TypeInputStickerSet', new_stickerset: 'TypeInputStickerSet'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode.
        """
        self.prev_stickerset = prev_stickerset
        self.new_stickerset = new_stickerset

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionChangeStickerSet',
            'prev_stickerset': self.prev_stickerset.to_dict() if isinstance(self.prev_stickerset, TLObject) else self.prev_stickerset,
            'new_stickerset': self.new_stickerset.to_dict() if isinstance(self.new_stickerset, TLObject) else self.new_stickerset
        }

    def __bytes__(self):
        return b''.join((
            b'\xa7\xca\xc3\xb1',
            bytes(self.prev_stickerset),
            bytes(self.new_stickerset),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_stickerset = reader.tgread_object()
        _new_stickerset = reader.tgread_object()
        return cls(prev_stickerset=_prev_stickerset, new_stickerset=_new_stickerset)


class ChannelAdminLogEventActionChangeTitle(TLObject):
    CONSTRUCTOR_ID = 0xe6dfb825
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_value: str, new_value: str):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode.
        """
        self.prev_value = prev_value
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionChangeTitle',
            'prev_value': self.prev_value,
            'new_value': self.new_value
        }

    def __bytes__(self):
        return b''.join((
            b'%\xb8\xdf\xe6',
            self.serialize_bytes(self.prev_value),
            self.serialize_bytes(self.new_value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_value = reader.tgread_string()
        _new_value = reader.tgread_string()
        return cls(prev_value=_prev_value, new_value=_new_value)


class ChannelAdminLogEventActionChangeUsername(TLObject):
    CONSTRUCTOR_ID = 0x6a4afc38
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_value: str, new_value: str):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode.
        """
        self.prev_value = prev_value
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionChangeUsername',
            'prev_value': self.prev_value,
            'new_value': self.new_value
        }

    def __bytes__(self):
        return b''.join((
            b'8\xfcJj',
            self.serialize_bytes(self.prev_value),
            self.serialize_bytes(self.new_value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_value = reader.tgread_string()
        _new_value = reader.tgread_string()
        return cls(prev_value=_prev_value, new_value=_new_value)


class ChannelAdminLogEventActionDefaultBannedRights(TLObject):
    CONSTRUCTOR_ID = 0x2df5fc0a
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_banned_rights: 'TypeChatBannedRights', new_banned_rights: 'TypeChatBannedRights'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode.
        """
        self.prev_banned_rights = prev_banned_rights
        self.new_banned_rights = new_banned_rights

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionDefaultBannedRights',
            'prev_banned_rights': self.prev_banned_rights.to_dict() if isinstance(self.prev_banned_rights, TLObject) else self.prev_banned_rights,
            'new_banned_rights': self.new_banned_rights.to_dict() if isinstance(self.new_banned_rights, TLObject) else self.new_banned_rights
        }

    def __bytes__(self):
        return b''.join((
            b'\n\xfc\xf5-',
            bytes(self.prev_banned_rights),
            bytes(self.new_banned_rights),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_banned_rights = reader.tgread_object()
        _new_banned_rights = reader.tgread_object()
        return cls(prev_banned_rights=_prev_banned_rights, new_banned_rights=_new_banned_rights)


class ChannelAdminLogEventActionDeleteMessage(TLObject):
    CONSTRUCTOR_ID = 0x42e047bb
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, message: 'TypeMessage'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode.
        """
        self.message = message

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionDeleteMessage',
            'message': self.message.to_dict() if isinstance(self.message, TLObject) else self.message
        }

    def __bytes__(self):
        return b''.join((
            b'\xbbG\xe0B',
            bytes(self.message),
        ))

    @classmethod
    def from_reader(cls, reader):
        _message = reader.tgread_object()
        return cls(message=_message)


class ChannelAdminLogEventActionEditMessage(TLObject):
    CONSTRUCTOR_ID = 0x709b2405
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_message: 'TypeMessage', new_message: 'TypeMessage'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode.
        """
        self.prev_message = prev_message
        self.new_message = new_message

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionEditMessage',
            'prev_message': self.prev_message.to_dict() if isinstance(self.prev_message, TLObject) else self.prev_message,
            'new_message': self.new_message.to_dict() if isinstance(self.new_message, TLObject) else self.new_message
        }

    def __bytes__(self):
        return b''.join((
            b'\x05$\x9bp',
            bytes(self.prev_message),
            bytes(self.new_message),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_message = reader.tgread_object()
        _new_message = reader.tgread_object()
        return cls(prev_message=_prev_message, new_message=_new_message)


class ChannelAdminLogEventActionParticipantInvite(TLObject):
    CONSTRUCTOR_ID = 0xe31c34d8
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, participant: 'TypeChannelParticipant'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode.
        """
        self.participant = participant

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionParticipantInvite',
            'participant': self.participant.to_dict() if isinstance(self.participant, TLObject) else self.participant
        }

    def __bytes__(self):
        return b''.join((
            b'\xd84\x1c\xe3',
            bytes(self.participant),
        ))

    @classmethod
    def from_reader(cls, reader):
        _participant = reader.tgread_object()
        return cls(participant=_participant)


class ChannelAdminLogEventActionParticipantJoin(TLObject):
    CONSTRUCTOR_ID = 0x183040d3
    SUBCLASS_OF_ID = 0xb2b987f3

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionParticipantJoin'
        }

    def __bytes__(self):
        return b''.join((
            b'\xd3@0\x18',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ChannelAdminLogEventActionParticipantLeave(TLObject):
    CONSTRUCTOR_ID = 0xf89777f2
    SUBCLASS_OF_ID = 0xb2b987f3

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionParticipantLeave'
        }

    def __bytes__(self):
        return b''.join((
            b'\xf2w\x97\xf8',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ChannelAdminLogEventActionParticipantToggleAdmin(TLObject):
    CONSTRUCTOR_ID = 0xd5676710
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_participant: 'TypeChannelParticipant', new_participant: 'TypeChannelParticipant'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode.
        """
        self.prev_participant = prev_participant
        self.new_participant = new_participant

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionParticipantToggleAdmin',
            'prev_participant': self.prev_participant.to_dict() if isinstance(self.prev_participant, TLObject) else self.prev_participant,
            'new_participant': self.new_participant.to_dict() if isinstance(self.new_participant, TLObject) else self.new_participant
        }

    def __bytes__(self):
        return b''.join((
            b'\x10gg\xd5',
            bytes(self.prev_participant),
            bytes(self.new_participant),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_participant = reader.tgread_object()
        _new_participant = reader.tgread_object()
        return cls(prev_participant=_prev_participant, new_participant=_new_participant)


class ChannelAdminLogEventActionParticipantToggleBan(TLObject):
    CONSTRUCTOR_ID = 0xe6d83d7e
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_participant: 'TypeChannelParticipant', new_participant: 'TypeChannelParticipant'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode.
        """
        self.prev_participant = prev_participant
        self.new_participant = new_participant

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionParticipantToggleBan',
            'prev_participant': self.prev_participant.to_dict() if isinstance(self.prev_participant, TLObject) else self.prev_participant,
            'new_participant': self.new_participant.to_dict() if isinstance(self.new_participant, TLObject) else self.new_participant
        }

    def __bytes__(self):
        return b''.join((
            b'~=\xd8\xe6',
            bytes(self.prev_participant),
            bytes(self.new_participant),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_participant = reader.tgread_object()
        _new_participant = reader.tgread_object()
        return cls(prev_participant=_prev_participant, new_participant=_new_participant)


class ChannelAdminLogEventActionStopPoll(TLObject):
    CONSTRUCTOR_ID = 0x8f079643
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, message: 'TypeMessage'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode.
        """
        self.message = message

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionStopPoll',
            'message': self.message.to_dict() if isinstance(self.message, TLObject) else self.message
        }

    def __bytes__(self):
        return b''.join((
            b'C\x96\x07\x8f',
            bytes(self.message),
        ))

    @classmethod
    def from_reader(cls, reader):
        _message = reader.tgread_object()
        return cls(message=_message)


class ChannelAdminLogEventActionToggleInvites(TLObject):
    CONSTRUCTOR_ID = 0x1b7907ae
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, new_value: bool):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode.
        """
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionToggleInvites',
            'new_value': self.new_value
        }

    def __bytes__(self):
        return b''.join((
            b'\xae\x07y\x1b',
            b'\xb5ur\x99' if self.new_value else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _new_value = reader.tgread_bool()
        return cls(new_value=_new_value)


class ChannelAdminLogEventActionTogglePreHistoryHidden(TLObject):
    CONSTRUCTOR_ID = 0x5f5c95f1
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, new_value: bool):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode.
        """
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionTogglePreHistoryHidden',
            'new_value': self.new_value
        }

    def __bytes__(self):
        return b''.join((
            b'\xf1\x95\\_',
            b'\xb5ur\x99' if self.new_value else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _new_value = reader.tgread_bool()
        return cls(new_value=_new_value)


class ChannelAdminLogEventActionToggleSignatures(TLObject):
    CONSTRUCTOR_ID = 0x26ae0971
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, new_value: bool):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode.
        """
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionToggleSignatures',
            'new_value': self.new_value
        }

    def __bytes__(self):
        return b''.join((
            b'q\t\xae&',
            b'\xb5ur\x99' if self.new_value else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _new_value = reader.tgread_bool()
        return cls(new_value=_new_value)


class ChannelAdminLogEventActionToggleSlowMode(TLObject):
    CONSTRUCTOR_ID = 0x53909779
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_value: int, new_value: int):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode.
        """
        self.prev_value = prev_value
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionToggleSlowMode',
            'prev_value': self.prev_value,
            'new_value': self.new_value
        }

    def __bytes__(self):
        return b''.join((
            b'y\x97\x90S',
            struct.pack('<i', self.prev_value),
            struct.pack('<i', self.new_value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_value = reader.read_int()
        _new_value = reader.read_int()
        return cls(prev_value=_prev_value, new_value=_new_value)


class ChannelAdminLogEventActionUpdatePinned(TLObject):
    CONSTRUCTOR_ID = 0xe9e82c18
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, message: 'TypeMessage'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode.
        """
        self.message = message

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionUpdatePinned',
            'message': self.message.to_dict() if isinstance(self.message, TLObject) else self.message
        }

    def __bytes__(self):
        return b''.join((
            b'\x18,\xe8\xe9',
            bytes(self.message),
        ))

    @classmethod
    def from_reader(cls, reader):
        _message = reader.tgread_object()
        return cls(message=_message)


class ChannelAdminLogEventsFilter(TLObject):
    CONSTRUCTOR_ID = 0xea107ae4
    SUBCLASS_OF_ID = 0x7cbbf319

    def __init__(self, join: Optional[bool]=None, leave: Optional[bool]=None, invite: Optional[bool]=None, ban: Optional[bool]=None, unban: Optional[bool]=None, kick: Optional[bool]=None, unkick: Optional[bool]=None, promote: Optional[bool]=None, demote: Optional[bool]=None, info: Optional[bool]=None, settings: Optional[bool]=None, pinned: Optional[bool]=None, edit: Optional[bool]=None, delete: Optional[bool]=None):
        """
        Constructor for ChannelAdminLogEventsFilter: Instance of ChannelAdminLogEventsFilter.
        """
        self.join = join
        self.leave = leave
        self.invite = invite
        self.ban = ban
        self.unban = unban
        self.kick = kick
        self.unkick = unkick
        self.promote = promote
        self.demote = demote
        self.info = info
        self.settings = settings
        self.pinned = pinned
        self.edit = edit
        self.delete = delete

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventsFilter',
            'join': self.join,
            'leave': self.leave,
            'invite': self.invite,
            'ban': self.ban,
            'unban': self.unban,
            'kick': self.kick,
            'unkick': self.unkick,
            'promote': self.promote,
            'demote': self.demote,
            'info': self.info,
            'settings': self.settings,
            'pinned': self.pinned,
            'edit': self.edit,
            'delete': self.delete
        }

    def __bytes__(self):
        return b''.join((
            b'\xe4z\x10\xea',
            struct.pack('<I', (0 if self.join is None or self.join is False else 1) | (0 if self.leave is None or self.leave is False else 2) | (0 if self.invite is None or self.invite is False else 4) | (0 if self.ban is None or self.ban is False else 8) | (0 if self.unban is None or self.unban is False else 16) | (0 if self.kick is None or self.kick is False else 32) | (0 if self.unkick is None or self.unkick is False else 64) | (0 if self.promote is None or self.promote is False else 128) | (0 if self.demote is None or self.demote is False else 256) | (0 if self.info is None or self.info is False else 512) | (0 if self.settings is None or self.settings is False else 1024) | (0 if self.pinned is None or self.pinned is False else 2048) | (0 if self.edit is None or self.edit is False else 4096) | (0 if self.delete is None or self.delete is False else 8192)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _join = bool(flags & 1)
        _leave = bool(flags & 2)
        _invite = bool(flags & 4)
        _ban = bool(flags & 8)
        _unban = bool(flags & 16)
        _kick = bool(flags & 32)
        _unkick = bool(flags & 64)
        _promote = bool(flags & 128)
        _demote = bool(flags & 256)
        _info = bool(flags & 512)
        _settings = bool(flags & 1024)
        _pinned = bool(flags & 2048)
        _edit = bool(flags & 4096)
        _delete = bool(flags & 8192)
        return cls(join=_join, leave=_leave, invite=_invite, ban=_ban, unban=_unban, kick=_kick, unkick=_unkick, promote=_promote, demote=_demote, info=_info, settings=_settings, pinned=_pinned, edit=_edit, delete=_delete)


class ChannelForbidden(TLObject):
    CONSTRUCTOR_ID = 0x289da732
    SUBCLASS_OF_ID = 0xc5af5d94

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, title: str, broadcast: Optional[bool]=None, megagroup: Optional[bool]=None, until_date: Optional[datetime]=None):
        """
        Constructor for Chat: Instance of either ChatEmpty, Chat, ChatForbidden, Channel, ChannelForbidden.
        """
        self.id = id
        self.access_hash = access_hash
        self.title = title
        self.broadcast = broadcast
        self.megagroup = megagroup
        self.until_date = until_date

    def to_dict(self):
        return {
            '_': 'ChannelForbidden',
            'id': self.id,
            'access_hash': self.access_hash,
            'title': self.title,
            'broadcast': self.broadcast,
            'megagroup': self.megagroup,
            'until_date': self.until_date
        }

    def __bytes__(self):
        return b''.join((
            b'2\xa7\x9d(',
            struct.pack('<I', (0 if self.broadcast is None or self.broadcast is False else 32) | (0 if self.megagroup is None or self.megagroup is False else 256) | (0 if self.until_date is None or self.until_date is False else 65536)),
            struct.pack('<i', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_bytes(self.title),
            b'' if self.until_date is None or self.until_date is False else (self.serialize_datetime(self.until_date)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _broadcast = bool(flags & 32)
        _megagroup = bool(flags & 256)
        _id = reader.read_int()
        _access_hash = reader.read_long()
        _title = reader.tgread_string()
        if flags & 65536:
            _until_date = reader.tgread_date()
        else:
            _until_date = None
        return cls(id=_id, access_hash=_access_hash, title=_title, broadcast=_broadcast, megagroup=_megagroup, until_date=_until_date)


class ChannelFull(TLObject):
    CONSTRUCTOR_ID = 0x2d895c74
    SUBCLASS_OF_ID = 0xd49a2697

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, about: str, read_inbox_max_id: int, read_outbox_max_id: int, unread_count: int, chat_photo: 'TypePhoto', notify_settings: 'TypePeerNotifySettings', exported_invite: 'TypeExportedChatInvite', bot_info: List['TypeBotInfo'], pts: int, can_view_participants: Optional[bool]=None, can_set_username: Optional[bool]=None, can_set_stickers: Optional[bool]=None, hidden_prehistory: Optional[bool]=None, can_view_stats: Optional[bool]=None, can_set_location: Optional[bool]=None, has_scheduled: Optional[bool]=None, participants_count: Optional[int]=None, admins_count: Optional[int]=None, kicked_count: Optional[int]=None, banned_count: Optional[int]=None, online_count: Optional[int]=None, migrated_from_chat_id: Optional[int]=None, migrated_from_max_id: Optional[int]=None, pinned_msg_id: Optional[int]=None, stickerset: Optional['TypeStickerSet']=None, available_min_id: Optional[int]=None, folder_id: Optional[int]=None, linked_chat_id: Optional[int]=None, location: Optional['TypeChannelLocation']=None, slowmode_seconds: Optional[int]=None, slowmode_next_send_date: Optional[datetime]=None):
        """
        Constructor for ChatFull: Instance of either ChatFull, ChannelFull.
        """
        self.id = id
        self.about = about
        self.read_inbox_max_id = read_inbox_max_id
        self.read_outbox_max_id = read_outbox_max_id
        self.unread_count = unread_count
        self.chat_photo = chat_photo
        self.notify_settings = notify_settings
        self.exported_invite = exported_invite
        self.bot_info = bot_info
        self.pts = pts
        self.can_view_participants = can_view_participants
        self.can_set_username = can_set_username
        self.can_set_stickers = can_set_stickers
        self.hidden_prehistory = hidden_prehistory
        self.can_view_stats = can_view_stats
        self.can_set_location = can_set_location
        self.has_scheduled = has_scheduled
        self.participants_count = participants_count
        self.admins_count = admins_count
        self.kicked_count = kicked_count
        self.banned_count = banned_count
        self.online_count = online_count
        self.migrated_from_chat_id = migrated_from_chat_id
        self.migrated_from_max_id = migrated_from_max_id
        self.pinned_msg_id = pinned_msg_id
        self.stickerset = stickerset
        self.available_min_id = available_min_id
        self.folder_id = folder_id
        self.linked_chat_id = linked_chat_id
        self.location = location
        self.slowmode_seconds = slowmode_seconds
        self.slowmode_next_send_date = slowmode_next_send_date

    def to_dict(self):
        return {
            '_': 'ChannelFull',
            'id': self.id,
            'about': self.about,
            'read_inbox_max_id': self.read_inbox_max_id,
            'read_outbox_max_id': self.read_outbox_max_id,
            'unread_count': self.unread_count,
            'chat_photo': self.chat_photo.to_dict() if isinstance(self.chat_photo, TLObject) else self.chat_photo,
            'notify_settings': self.notify_settings.to_dict() if isinstance(self.notify_settings, TLObject) else self.notify_settings,
            'exported_invite': self.exported_invite.to_dict() if isinstance(self.exported_invite, TLObject) else self.exported_invite,
            'bot_info': [] if self.bot_info is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.bot_info],
            'pts': self.pts,
            'can_view_participants': self.can_view_participants,
            'can_set_username': self.can_set_username,
            'can_set_stickers': self.can_set_stickers,
            'hidden_prehistory': self.hidden_prehistory,
            'can_view_stats': self.can_view_stats,
            'can_set_location': self.can_set_location,
            'has_scheduled': self.has_scheduled,
            'participants_count': self.participants_count,
            'admins_count': self.admins_count,
            'kicked_count': self.kicked_count,
            'banned_count': self.banned_count,
            'online_count': self.online_count,
            'migrated_from_chat_id': self.migrated_from_chat_id,
            'migrated_from_max_id': self.migrated_from_max_id,
            'pinned_msg_id': self.pinned_msg_id,
            'stickerset': self.stickerset.to_dict() if isinstance(self.stickerset, TLObject) else self.stickerset,
            'available_min_id': self.available_min_id,
            'folder_id': self.folder_id,
            'linked_chat_id': self.linked_chat_id,
            'location': self.location.to_dict() if isinstance(self.location, TLObject) else self.location,
            'slowmode_seconds': self.slowmode_seconds,
            'slowmode_next_send_date': self.slowmode_next_send_date
        }

    def __bytes__(self):
        assert ((self.kicked_count or self.kicked_count is not None) and (self.banned_count or self.banned_count is not None)) or ((self.kicked_count is None or self.kicked_count is False) and (self.banned_count is None or self.banned_count is False)), 'kicked_count, banned_count parameters must all be False-y (like None) or all me True-y'
        assert ((self.migrated_from_chat_id or self.migrated_from_chat_id is not None) and (self.migrated_from_max_id or self.migrated_from_max_id is not None)) or ((self.migrated_from_chat_id is None or self.migrated_from_chat_id is False) and (self.migrated_from_max_id is None or self.migrated_from_max_id is False)), 'migrated_from_chat_id, migrated_from_max_id parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b't\\\x89-',
            struct.pack('<I', (0 if self.can_view_participants is None or self.can_view_participants is False else 8) | (0 if self.can_set_username is None or self.can_set_username is False else 64) | (0 if self.can_set_stickers is None or self.can_set_stickers is False else 128) | (0 if self.hidden_prehistory is None or self.hidden_prehistory is False else 1024) | (0 if self.can_view_stats is None or self.can_view_stats is False else 4096) | (0 if self.can_set_location is None or self.can_set_location is False else 65536) | (0 if self.has_scheduled is None or self.has_scheduled is False else 524288) | (0 if self.participants_count is None or self.participants_count is False else 1) | (0 if self.admins_count is None or self.admins_count is False else 2) | (0 if self.kicked_count is None or self.kicked_count is False else 4) | (0 if self.banned_count is None or self.banned_count is False else 4) | (0 if self.online_count is None or self.online_count is False else 8192) | (0 if self.migrated_from_chat_id is None or self.migrated_from_chat_id is False else 16) | (0 if self.migrated_from_max_id is None or self.migrated_from_max_id is False else 16) | (0 if self.pinned_msg_id is None or self.pinned_msg_id is False else 32) | (0 if self.stickerset is None or self.stickerset is False else 256) | (0 if self.available_min_id is None or self.available_min_id is False else 512) | (0 if self.folder_id is None or self.folder_id is False else 2048) | (0 if self.linked_chat_id is None or self.linked_chat_id is False else 16384) | (0 if self.location is None or self.location is False else 32768) | (0 if self.slowmode_seconds is None or self.slowmode_seconds is False else 131072) | (0 if self.slowmode_next_send_date is None or self.slowmode_next_send_date is False else 262144)),
            struct.pack('<i', self.id),
            self.serialize_bytes(self.about),
            b'' if self.participants_count is None or self.participants_count is False else (struct.pack('<i', self.participants_count)),
            b'' if self.admins_count is None or self.admins_count is False else (struct.pack('<i', self.admins_count)),
            b'' if self.kicked_count is None or self.kicked_count is False else (struct.pack('<i', self.kicked_count)),
            b'' if self.banned_count is None or self.banned_count is False else (struct.pack('<i', self.banned_count)),
            b'' if self.online_count is None or self.online_count is False else (struct.pack('<i', self.online_count)),
            struct.pack('<i', self.read_inbox_max_id),
            struct.pack('<i', self.read_outbox_max_id),
            struct.pack('<i', self.unread_count),
            bytes(self.chat_photo),
            bytes(self.notify_settings),
            bytes(self.exported_invite),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.bot_info)),b''.join(bytes(x) for x in self.bot_info),
            b'' if self.migrated_from_chat_id is None or self.migrated_from_chat_id is False else (struct.pack('<i', self.migrated_from_chat_id)),
            b'' if self.migrated_from_max_id is None or self.migrated_from_max_id is False else (struct.pack('<i', self.migrated_from_max_id)),
            b'' if self.pinned_msg_id is None or self.pinned_msg_id is False else (struct.pack('<i', self.pinned_msg_id)),
            b'' if self.stickerset is None or self.stickerset is False else (bytes(self.stickerset)),
            b'' if self.available_min_id is None or self.available_min_id is False else (struct.pack('<i', self.available_min_id)),
            b'' if self.folder_id is None or self.folder_id is False else (struct.pack('<i', self.folder_id)),
            b'' if self.linked_chat_id is None or self.linked_chat_id is False else (struct.pack('<i', self.linked_chat_id)),
            b'' if self.location is None or self.location is False else (bytes(self.location)),
            b'' if self.slowmode_seconds is None or self.slowmode_seconds is False else (struct.pack('<i', self.slowmode_seconds)),
            b'' if self.slowmode_next_send_date is None or self.slowmode_next_send_date is False else (self.serialize_datetime(self.slowmode_next_send_date)),
            struct.pack('<i', self.pts),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _can_view_participants = bool(flags & 8)
        _can_set_username = bool(flags & 64)
        _can_set_stickers = bool(flags & 128)
        _hidden_prehistory = bool(flags & 1024)
        _can_view_stats = bool(flags & 4096)
        _can_set_location = bool(flags & 65536)
        _has_scheduled = bool(flags & 524288)
        _id = reader.read_int()
        _about = reader.tgread_string()
        if flags & 1:
            _participants_count = reader.read_int()
        else:
            _participants_count = None
        if flags & 2:
            _admins_count = reader.read_int()
        else:
            _admins_count = None
        if flags & 4:
            _kicked_count = reader.read_int()
        else:
            _kicked_count = None
        if flags & 4:
            _banned_count = reader.read_int()
        else:
            _banned_count = None
        if flags & 8192:
            _online_count = reader.read_int()
        else:
            _online_count = None
        _read_inbox_max_id = reader.read_int()
        _read_outbox_max_id = reader.read_int()
        _unread_count = reader.read_int()
        _chat_photo = reader.tgread_object()
        _notify_settings = reader.tgread_object()
        _exported_invite = reader.tgread_object()
        reader.read_int()
        _bot_info = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _bot_info.append(_x)

        if flags & 16:
            _migrated_from_chat_id = reader.read_int()
        else:
            _migrated_from_chat_id = None
        if flags & 16:
            _migrated_from_max_id = reader.read_int()
        else:
            _migrated_from_max_id = None
        if flags & 32:
            _pinned_msg_id = reader.read_int()
        else:
            _pinned_msg_id = None
        if flags & 256:
            _stickerset = reader.tgread_object()
        else:
            _stickerset = None
        if flags & 512:
            _available_min_id = reader.read_int()
        else:
            _available_min_id = None
        if flags & 2048:
            _folder_id = reader.read_int()
        else:
            _folder_id = None
        if flags & 16384:
            _linked_chat_id = reader.read_int()
        else:
            _linked_chat_id = None
        if flags & 32768:
            _location = reader.tgread_object()
        else:
            _location = None
        if flags & 131072:
            _slowmode_seconds = reader.read_int()
        else:
            _slowmode_seconds = None
        if flags & 262144:
            _slowmode_next_send_date = reader.tgread_date()
        else:
            _slowmode_next_send_date = None
        _pts = reader.read_int()
        return cls(id=_id, about=_about, read_inbox_max_id=_read_inbox_max_id, read_outbox_max_id=_read_outbox_max_id, unread_count=_unread_count, chat_photo=_chat_photo, notify_settings=_notify_settings, exported_invite=_exported_invite, bot_info=_bot_info, pts=_pts, can_view_participants=_can_view_participants, can_set_username=_can_set_username, can_set_stickers=_can_set_stickers, hidden_prehistory=_hidden_prehistory, can_view_stats=_can_view_stats, can_set_location=_can_set_location, has_scheduled=_has_scheduled, participants_count=_participants_count, admins_count=_admins_count, kicked_count=_kicked_count, banned_count=_banned_count, online_count=_online_count, migrated_from_chat_id=_migrated_from_chat_id, migrated_from_max_id=_migrated_from_max_id, pinned_msg_id=_pinned_msg_id, stickerset=_stickerset, available_min_id=_available_min_id, folder_id=_folder_id, linked_chat_id=_linked_chat_id, location=_location, slowmode_seconds=_slowmode_seconds, slowmode_next_send_date=_slowmode_next_send_date)


class ChannelLocation(TLObject):
    CONSTRUCTOR_ID = 0x209b82db
    SUBCLASS_OF_ID = 0xec260b7f

    def __init__(self, geo_point: 'TypeGeoPoint', address: str):
        """
        Constructor for ChannelLocation: Instance of either ChannelLocationEmpty, ChannelLocation.
        """
        self.geo_point = geo_point
        self.address = address

    def to_dict(self):
        return {
            '_': 'ChannelLocation',
            'geo_point': self.geo_point.to_dict() if isinstance(self.geo_point, TLObject) else self.geo_point,
            'address': self.address
        }

    def __bytes__(self):
        return b''.join((
            b'\xdb\x82\x9b ',
            bytes(self.geo_point),
            self.serialize_bytes(self.address),
        ))

    @classmethod
    def from_reader(cls, reader):
        _geo_point = reader.tgread_object()
        _address = reader.tgread_string()
        return cls(geo_point=_geo_point, address=_address)


class ChannelLocationEmpty(TLObject):
    CONSTRUCTOR_ID = 0xbfb5ad8b
    SUBCLASS_OF_ID = 0xec260b7f

    def to_dict(self):
        return {
            '_': 'ChannelLocationEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'\x8b\xad\xb5\xbf',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ChannelMessagesFilter(TLObject):
    CONSTRUCTOR_ID = 0xcd77d957
    SUBCLASS_OF_ID = 0x13336a56

    def __init__(self, ranges: List['TypeMessageRange'], exclude_new_messages: Optional[bool]=None):
        """
        Constructor for ChannelMessagesFilter: Instance of either ChannelMessagesFilterEmpty, ChannelMessagesFilter.
        """
        self.ranges = ranges
        self.exclude_new_messages = exclude_new_messages

    def to_dict(self):
        return {
            '_': 'ChannelMessagesFilter',
            'ranges': [] if self.ranges is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.ranges],
            'exclude_new_messages': self.exclude_new_messages
        }

    def __bytes__(self):
        return b''.join((
            b'W\xd9w\xcd',
            struct.pack('<I', (0 if self.exclude_new_messages is None or self.exclude_new_messages is False else 2)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.ranges)),b''.join(bytes(x) for x in self.ranges),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _exclude_new_messages = bool(flags & 2)
        reader.read_int()
        _ranges = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _ranges.append(_x)

        return cls(ranges=_ranges, exclude_new_messages=_exclude_new_messages)


class ChannelMessagesFilterEmpty(TLObject):
    CONSTRUCTOR_ID = 0x94d42ee7
    SUBCLASS_OF_ID = 0x13336a56

    def to_dict(self):
        return {
            '_': 'ChannelMessagesFilterEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'\xe7.\xd4\x94',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ChannelParticipant(TLObject):
    CONSTRUCTOR_ID = 0x15ebac1d
    SUBCLASS_OF_ID = 0xd9c7fc18

    def __init__(self, user_id: int, date: Optional[datetime]):
        """
        Constructor for ChannelParticipant: Instance of either ChannelParticipant, ChannelParticipantSelf, ChannelParticipantCreator, ChannelParticipantAdmin, ChannelParticipantBanned.
        """
        self.user_id = user_id
        self.date = date

    def to_dict(self):
        return {
            '_': 'ChannelParticipant',
            'user_id': self.user_id,
            'date': self.date
        }

    def __bytes__(self):
        return b''.join((
            b'\x1d\xac\xeb\x15',
            struct.pack('<i', self.user_id),
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        _date = reader.tgread_date()
        return cls(user_id=_user_id, date=_date)


class ChannelParticipantAdmin(TLObject):
    CONSTRUCTOR_ID = 0xccbebbaf
    SUBCLASS_OF_ID = 0xd9c7fc18

    def __init__(self, user_id: int, promoted_by: int, date: Optional[datetime], admin_rights: 'TypeChatAdminRights', can_edit: Optional[bool]=None, is_self: Optional[bool]=None, inviter_id: Optional[int]=None, rank: Optional[str]=None):
        """
        Constructor for ChannelParticipant: Instance of either ChannelParticipant, ChannelParticipantSelf, ChannelParticipantCreator, ChannelParticipantAdmin, ChannelParticipantBanned.
        """
        self.user_id = user_id
        self.promoted_by = promoted_by
        self.date = date
        self.admin_rights = admin_rights
        self.can_edit = can_edit
        self.is_self = is_self
        self.inviter_id = inviter_id
        self.rank = rank

    def to_dict(self):
        return {
            '_': 'ChannelParticipantAdmin',
            'user_id': self.user_id,
            'promoted_by': self.promoted_by,
            'date': self.date,
            'admin_rights': self.admin_rights.to_dict() if isinstance(self.admin_rights, TLObject) else self.admin_rights,
            'can_edit': self.can_edit,
            'is_self': self.is_self,
            'inviter_id': self.inviter_id,
            'rank': self.rank
        }

    def __bytes__(self):
        assert ((self.is_self or self.is_self is not None) and (self.inviter_id or self.inviter_id is not None)) or ((self.is_self is None or self.is_self is False) and (self.inviter_id is None or self.inviter_id is False)), 'is_self, inviter_id parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xaf\xbb\xbe\xcc',
            struct.pack('<I', (0 if self.can_edit is None or self.can_edit is False else 1) | (0 if self.is_self is None or self.is_self is False else 2) | (0 if self.inviter_id is None or self.inviter_id is False else 2) | (0 if self.rank is None or self.rank is False else 4)),
            struct.pack('<i', self.user_id),
            b'' if self.inviter_id is None or self.inviter_id is False else (struct.pack('<i', self.inviter_id)),
            struct.pack('<i', self.promoted_by),
            self.serialize_datetime(self.date),
            bytes(self.admin_rights),
            b'' if self.rank is None or self.rank is False else (self.serialize_bytes(self.rank)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _can_edit = bool(flags & 1)
        _is_self = bool(flags & 2)
        _user_id = reader.read_int()
        if flags & 2:
            _inviter_id = reader.read_int()
        else:
            _inviter_id = None
        _promoted_by = reader.read_int()
        _date = reader.tgread_date()
        _admin_rights = reader.tgread_object()
        if flags & 4:
            _rank = reader.tgread_string()
        else:
            _rank = None
        return cls(user_id=_user_id, promoted_by=_promoted_by, date=_date, admin_rights=_admin_rights, can_edit=_can_edit, is_self=_is_self, inviter_id=_inviter_id, rank=_rank)


class ChannelParticipantBanned(TLObject):
    CONSTRUCTOR_ID = 0x1c0facaf
    SUBCLASS_OF_ID = 0xd9c7fc18

    def __init__(self, user_id: int, kicked_by: int, date: Optional[datetime], banned_rights: 'TypeChatBannedRights', left: Optional[bool]=None):
        """
        Constructor for ChannelParticipant: Instance of either ChannelParticipant, ChannelParticipantSelf, ChannelParticipantCreator, ChannelParticipantAdmin, ChannelParticipantBanned.
        """
        self.user_id = user_id
        self.kicked_by = kicked_by
        self.date = date
        self.banned_rights = banned_rights
        self.left = left

    def to_dict(self):
        return {
            '_': 'ChannelParticipantBanned',
            'user_id': self.user_id,
            'kicked_by': self.kicked_by,
            'date': self.date,
            'banned_rights': self.banned_rights.to_dict() if isinstance(self.banned_rights, TLObject) else self.banned_rights,
            'left': self.left
        }

    def __bytes__(self):
        return b''.join((
            b'\xaf\xac\x0f\x1c',
            struct.pack('<I', (0 if self.left is None or self.left is False else 1)),
            struct.pack('<i', self.user_id),
            struct.pack('<i', self.kicked_by),
            self.serialize_datetime(self.date),
            bytes(self.banned_rights),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _left = bool(flags & 1)
        _user_id = reader.read_int()
        _kicked_by = reader.read_int()
        _date = reader.tgread_date()
        _banned_rights = reader.tgread_object()
        return cls(user_id=_user_id, kicked_by=_kicked_by, date=_date, banned_rights=_banned_rights, left=_left)


class ChannelParticipantCreator(TLObject):
    CONSTRUCTOR_ID = 0x808d15a4
    SUBCLASS_OF_ID = 0xd9c7fc18

    def __init__(self, user_id: int, rank: Optional[str]=None):
        """
        Constructor for ChannelParticipant: Instance of either ChannelParticipant, ChannelParticipantSelf, ChannelParticipantCreator, ChannelParticipantAdmin, ChannelParticipantBanned.
        """
        self.user_id = user_id
        self.rank = rank

    def to_dict(self):
        return {
            '_': 'ChannelParticipantCreator',
            'user_id': self.user_id,
            'rank': self.rank
        }

    def __bytes__(self):
        return b''.join((
            b'\xa4\x15\x8d\x80',
            struct.pack('<I', (0 if self.rank is None or self.rank is False else 1)),
            struct.pack('<i', self.user_id),
            b'' if self.rank is None or self.rank is False else (self.serialize_bytes(self.rank)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _user_id = reader.read_int()
        if flags & 1:
            _rank = reader.tgread_string()
        else:
            _rank = None
        return cls(user_id=_user_id, rank=_rank)


class ChannelParticipantSelf(TLObject):
    CONSTRUCTOR_ID = 0xa3289a6d
    SUBCLASS_OF_ID = 0xd9c7fc18

    def __init__(self, user_id: int, inviter_id: int, date: Optional[datetime]):
        """
        Constructor for ChannelParticipant: Instance of either ChannelParticipant, ChannelParticipantSelf, ChannelParticipantCreator, ChannelParticipantAdmin, ChannelParticipantBanned.
        """
        self.user_id = user_id
        self.inviter_id = inviter_id
        self.date = date

    def to_dict(self):
        return {
            '_': 'ChannelParticipantSelf',
            'user_id': self.user_id,
            'inviter_id': self.inviter_id,
            'date': self.date
        }

    def __bytes__(self):
        return b''.join((
            b'm\x9a(\xa3',
            struct.pack('<i', self.user_id),
            struct.pack('<i', self.inviter_id),
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        _inviter_id = reader.read_int()
        _date = reader.tgread_date()
        return cls(user_id=_user_id, inviter_id=_inviter_id, date=_date)


class ChannelParticipantsAdmins(TLObject):
    CONSTRUCTOR_ID = 0xb4608969
    SUBCLASS_OF_ID = 0xbf4e2753

    def to_dict(self):
        return {
            '_': 'ChannelParticipantsAdmins'
        }

    def __bytes__(self):
        return b''.join((
            b'i\x89`\xb4',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ChannelParticipantsBanned(TLObject):
    CONSTRUCTOR_ID = 0x1427a5e1
    SUBCLASS_OF_ID = 0xbf4e2753

    def __init__(self, q: str):
        """
        Constructor for ChannelParticipantsFilter: Instance of either ChannelParticipantsRecent, ChannelParticipantsAdmins, ChannelParticipantsKicked, ChannelParticipantsBots, ChannelParticipantsBanned, ChannelParticipantsSearch, ChannelParticipantsContacts.
        """
        self.q = q

    def to_dict(self):
        return {
            '_': 'ChannelParticipantsBanned',
            'q': self.q
        }

    def __bytes__(self):
        return b''.join((
            b"\xe1\xa5'\x14",
            self.serialize_bytes(self.q),
        ))

    @classmethod
    def from_reader(cls, reader):
        _q = reader.tgread_string()
        return cls(q=_q)


class ChannelParticipantsBots(TLObject):
    CONSTRUCTOR_ID = 0xb0d1865b
    SUBCLASS_OF_ID = 0xbf4e2753

    def to_dict(self):
        return {
            '_': 'ChannelParticipantsBots'
        }

    def __bytes__(self):
        return b''.join((
            b'[\x86\xd1\xb0',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ChannelParticipantsContacts(TLObject):
    CONSTRUCTOR_ID = 0xbb6ae88d
    SUBCLASS_OF_ID = 0xbf4e2753

    def __init__(self, q: str):
        """
        Constructor for ChannelParticipantsFilter: Instance of either ChannelParticipantsRecent, ChannelParticipantsAdmins, ChannelParticipantsKicked, ChannelParticipantsBots, ChannelParticipantsBanned, ChannelParticipantsSearch, ChannelParticipantsContacts.
        """
        self.q = q

    def to_dict(self):
        return {
            '_': 'ChannelParticipantsContacts',
            'q': self.q
        }

    def __bytes__(self):
        return b''.join((
            b'\x8d\xe8j\xbb',
            self.serialize_bytes(self.q),
        ))

    @classmethod
    def from_reader(cls, reader):
        _q = reader.tgread_string()
        return cls(q=_q)


class ChannelParticipantsKicked(TLObject):
    CONSTRUCTOR_ID = 0xa3b54985
    SUBCLASS_OF_ID = 0xbf4e2753

    def __init__(self, q: str):
        """
        Constructor for ChannelParticipantsFilter: Instance of either ChannelParticipantsRecent, ChannelParticipantsAdmins, ChannelParticipantsKicked, ChannelParticipantsBots, ChannelParticipantsBanned, ChannelParticipantsSearch, ChannelParticipantsContacts.
        """
        self.q = q

    def to_dict(self):
        return {
            '_': 'ChannelParticipantsKicked',
            'q': self.q
        }

    def __bytes__(self):
        return b''.join((
            b'\x85I\xb5\xa3',
            self.serialize_bytes(self.q),
        ))

    @classmethod
    def from_reader(cls, reader):
        _q = reader.tgread_string()
        return cls(q=_q)


class ChannelParticipantsRecent(TLObject):
    CONSTRUCTOR_ID = 0xde3f3c79
    SUBCLASS_OF_ID = 0xbf4e2753

    def to_dict(self):
        return {
            '_': 'ChannelParticipantsRecent'
        }

    def __bytes__(self):
        return b''.join((
            b'y<?\xde',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ChannelParticipantsSearch(TLObject):
    CONSTRUCTOR_ID = 0x656ac4b
    SUBCLASS_OF_ID = 0xbf4e2753

    def __init__(self, q: str):
        """
        Constructor for ChannelParticipantsFilter: Instance of either ChannelParticipantsRecent, ChannelParticipantsAdmins, ChannelParticipantsKicked, ChannelParticipantsBots, ChannelParticipantsBanned, ChannelParticipantsSearch, ChannelParticipantsContacts.
        """
        self.q = q

    def to_dict(self):
        return {
            '_': 'ChannelParticipantsSearch',
            'q': self.q
        }

    def __bytes__(self):
        return b''.join((
            b'K\xacV\x06',
            self.serialize_bytes(self.q),
        ))

    @classmethod
    def from_reader(cls, reader):
        _q = reader.tgread_string()
        return cls(q=_q)


class Chat(TLObject):
    CONSTRUCTOR_ID = 0x3bda1bde
    SUBCLASS_OF_ID = 0xc5af5d94

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, title: str, photo: 'TypeChatPhoto', participants_count: int, date: Optional[datetime], version: int, creator: Optional[bool]=None, kicked: Optional[bool]=None, left: Optional[bool]=None, deactivated: Optional[bool]=None, migrated_to: Optional['TypeInputChannel']=None, admin_rights: Optional['TypeChatAdminRights']=None, default_banned_rights: Optional['TypeChatBannedRights']=None):
        """
        Constructor for Chat: Instance of either ChatEmpty, Chat, ChatForbidden, Channel, ChannelForbidden.
        """
        self.id = id
        self.title = title
        self.photo = photo
        self.participants_count = participants_count
        self.date = date
        self.version = version
        self.creator = creator
        self.kicked = kicked
        self.left = left
        self.deactivated = deactivated
        self.migrated_to = migrated_to
        self.admin_rights = admin_rights
        self.default_banned_rights = default_banned_rights

    def to_dict(self):
        return {
            '_': 'Chat',
            'id': self.id,
            'title': self.title,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'participants_count': self.participants_count,
            'date': self.date,
            'version': self.version,
            'creator': self.creator,
            'kicked': self.kicked,
            'left': self.left,
            'deactivated': self.deactivated,
            'migrated_to': self.migrated_to.to_dict() if isinstance(self.migrated_to, TLObject) else self.migrated_to,
            'admin_rights': self.admin_rights.to_dict() if isinstance(self.admin_rights, TLObject) else self.admin_rights,
            'default_banned_rights': self.default_banned_rights.to_dict() if isinstance(self.default_banned_rights, TLObject) else self.default_banned_rights
        }

    def __bytes__(self):
        return b''.join((
            b'\xde\x1b\xda;',
            struct.pack('<I', (0 if self.creator is None or self.creator is False else 1) | (0 if self.kicked is None or self.kicked is False else 2) | (0 if self.left is None or self.left is False else 4) | (0 if self.deactivated is None or self.deactivated is False else 32) | (0 if self.migrated_to is None or self.migrated_to is False else 64) | (0 if self.admin_rights is None or self.admin_rights is False else 16384) | (0 if self.default_banned_rights is None or self.default_banned_rights is False else 262144)),
            struct.pack('<i', self.id),
            self.serialize_bytes(self.title),
            bytes(self.photo),
            struct.pack('<i', self.participants_count),
            self.serialize_datetime(self.date),
            struct.pack('<i', self.version),
            b'' if self.migrated_to is None or self.migrated_to is False else (bytes(self.migrated_to)),
            b'' if self.admin_rights is None or self.admin_rights is False else (bytes(self.admin_rights)),
            b'' if self.default_banned_rights is None or self.default_banned_rights is False else (bytes(self.default_banned_rights)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _creator = bool(flags & 1)
        _kicked = bool(flags & 2)
        _left = bool(flags & 4)
        _deactivated = bool(flags & 32)
        _id = reader.read_int()
        _title = reader.tgread_string()
        _photo = reader.tgread_object()
        _participants_count = reader.read_int()
        _date = reader.tgread_date()
        _version = reader.read_int()
        if flags & 64:
            _migrated_to = reader.tgread_object()
        else:
            _migrated_to = None
        if flags & 16384:
            _admin_rights = reader.tgread_object()
        else:
            _admin_rights = None
        if flags & 262144:
            _default_banned_rights = reader.tgread_object()
        else:
            _default_banned_rights = None
        return cls(id=_id, title=_title, photo=_photo, participants_count=_participants_count, date=_date, version=_version, creator=_creator, kicked=_kicked, left=_left, deactivated=_deactivated, migrated_to=_migrated_to, admin_rights=_admin_rights, default_banned_rights=_default_banned_rights)


class ChatAdminRights(TLObject):
    CONSTRUCTOR_ID = 0x5fb224d5
    SUBCLASS_OF_ID = 0x863dc7c4

    def __init__(self, change_info: Optional[bool]=None, post_messages: Optional[bool]=None, edit_messages: Optional[bool]=None, delete_messages: Optional[bool]=None, ban_users: Optional[bool]=None, invite_users: Optional[bool]=None, pin_messages: Optional[bool]=None, add_admins: Optional[bool]=None):
        """
        Constructor for ChatAdminRights: Instance of ChatAdminRights.
        """
        self.change_info = change_info
        self.post_messages = post_messages
        self.edit_messages = edit_messages
        self.delete_messages = delete_messages
        self.ban_users = ban_users
        self.invite_users = invite_users
        self.pin_messages = pin_messages
        self.add_admins = add_admins

    def to_dict(self):
        return {
            '_': 'ChatAdminRights',
            'change_info': self.change_info,
            'post_messages': self.post_messages,
            'edit_messages': self.edit_messages,
            'delete_messages': self.delete_messages,
            'ban_users': self.ban_users,
            'invite_users': self.invite_users,
            'pin_messages': self.pin_messages,
            'add_admins': self.add_admins
        }

    def __bytes__(self):
        return b''.join((
            b'\xd5$\xb2_',
            struct.pack('<I', (0 if self.change_info is None or self.change_info is False else 1) | (0 if self.post_messages is None or self.post_messages is False else 2) | (0 if self.edit_messages is None or self.edit_messages is False else 4) | (0 if self.delete_messages is None or self.delete_messages is False else 8) | (0 if self.ban_users is None or self.ban_users is False else 16) | (0 if self.invite_users is None or self.invite_users is False else 32) | (0 if self.pin_messages is None or self.pin_messages is False else 128) | (0 if self.add_admins is None or self.add_admins is False else 512)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _change_info = bool(flags & 1)
        _post_messages = bool(flags & 2)
        _edit_messages = bool(flags & 4)
        _delete_messages = bool(flags & 8)
        _ban_users = bool(flags & 16)
        _invite_users = bool(flags & 32)
        _pin_messages = bool(flags & 128)
        _add_admins = bool(flags & 512)
        return cls(change_info=_change_info, post_messages=_post_messages, edit_messages=_edit_messages, delete_messages=_delete_messages, ban_users=_ban_users, invite_users=_invite_users, pin_messages=_pin_messages, add_admins=_add_admins)


class ChatBannedRights(TLObject):
    CONSTRUCTOR_ID = 0x9f120418
    SUBCLASS_OF_ID = 0x4b5445a9

    def __init__(self, until_date: Optional[datetime], view_messages: Optional[bool]=None, send_messages: Optional[bool]=None, send_media: Optional[bool]=None, send_stickers: Optional[bool]=None, send_gifs: Optional[bool]=None, send_games: Optional[bool]=None, send_inline: Optional[bool]=None, embed_links: Optional[bool]=None, send_polls: Optional[bool]=None, change_info: Optional[bool]=None, invite_users: Optional[bool]=None, pin_messages: Optional[bool]=None):
        """
        Constructor for ChatBannedRights: Instance of ChatBannedRights.
        """
        self.until_date = until_date
        self.view_messages = view_messages
        self.send_messages = send_messages
        self.send_media = send_media
        self.send_stickers = send_stickers
        self.send_gifs = send_gifs
        self.send_games = send_games
        self.send_inline = send_inline
        self.embed_links = embed_links
        self.send_polls = send_polls
        self.change_info = change_info
        self.invite_users = invite_users
        self.pin_messages = pin_messages

    def to_dict(self):
        return {
            '_': 'ChatBannedRights',
            'until_date': self.until_date,
            'view_messages': self.view_messages,
            'send_messages': self.send_messages,
            'send_media': self.send_media,
            'send_stickers': self.send_stickers,
            'send_gifs': self.send_gifs,
            'send_games': self.send_games,
            'send_inline': self.send_inline,
            'embed_links': self.embed_links,
            'send_polls': self.send_polls,
            'change_info': self.change_info,
            'invite_users': self.invite_users,
            'pin_messages': self.pin_messages
        }

    def __bytes__(self):
        return b''.join((
            b'\x18\x04\x12\x9f',
            struct.pack('<I', (0 if self.view_messages is None or self.view_messages is False else 1) | (0 if self.send_messages is None or self.send_messages is False else 2) | (0 if self.send_media is None or self.send_media is False else 4) | (0 if self.send_stickers is None or self.send_stickers is False else 8) | (0 if self.send_gifs is None or self.send_gifs is False else 16) | (0 if self.send_games is None or self.send_games is False else 32) | (0 if self.send_inline is None or self.send_inline is False else 64) | (0 if self.embed_links is None or self.embed_links is False else 128) | (0 if self.send_polls is None or self.send_polls is False else 256) | (0 if self.change_info is None or self.change_info is False else 1024) | (0 if self.invite_users is None or self.invite_users is False else 32768) | (0 if self.pin_messages is None or self.pin_messages is False else 131072)),
            self.serialize_datetime(self.until_date),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _view_messages = bool(flags & 1)
        _send_messages = bool(flags & 2)
        _send_media = bool(flags & 4)
        _send_stickers = bool(flags & 8)
        _send_gifs = bool(flags & 16)
        _send_games = bool(flags & 32)
        _send_inline = bool(flags & 64)
        _embed_links = bool(flags & 128)
        _send_polls = bool(flags & 256)
        _change_info = bool(flags & 1024)
        _invite_users = bool(flags & 32768)
        _pin_messages = bool(flags & 131072)
        _until_date = reader.tgread_date()
        return cls(until_date=_until_date, view_messages=_view_messages, send_messages=_send_messages, send_media=_send_media, send_stickers=_send_stickers, send_gifs=_send_gifs, send_games=_send_games, send_inline=_send_inline, embed_links=_embed_links, send_polls=_send_polls, change_info=_change_info, invite_users=_invite_users, pin_messages=_pin_messages)


class ChatEmpty(TLObject):
    CONSTRUCTOR_ID = 0x9ba2d800
    SUBCLASS_OF_ID = 0xc5af5d94

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        """
        Constructor for Chat: Instance of either ChatEmpty, Chat, ChatForbidden, Channel, ChannelForbidden.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'ChatEmpty',
            'id': self.id
        }

    def __bytes__(self):
        return b''.join((
            b'\x00\xd8\xa2\x9b',
            struct.pack('<i', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_int()
        return cls(id=_id)


class ChatForbidden(TLObject):
    CONSTRUCTOR_ID = 0x7328bdb
    SUBCLASS_OF_ID = 0xc5af5d94

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, title: str):
        """
        Constructor for Chat: Instance of either ChatEmpty, Chat, ChatForbidden, Channel, ChannelForbidden.
        """
        self.id = id
        self.title = title

    def to_dict(self):
        return {
            '_': 'ChatForbidden',
            'id': self.id,
            'title': self.title
        }

    def __bytes__(self):
        return b''.join((
            b'\xdb\x8b2\x07',
            struct.pack('<i', self.id),
            self.serialize_bytes(self.title),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_int()
        _title = reader.tgread_string()
        return cls(id=_id, title=_title)


class ChatFull(TLObject):
    CONSTRUCTOR_ID = 0x1b7c9db3
    SUBCLASS_OF_ID = 0xd49a2697

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, about: str, participants: 'TypeChatParticipants', notify_settings: 'TypePeerNotifySettings', exported_invite: 'TypeExportedChatInvite', can_set_username: Optional[bool]=None, has_scheduled: Optional[bool]=None, chat_photo: Optional['TypePhoto']=None, bot_info: Optional[List['TypeBotInfo']]=None, pinned_msg_id: Optional[int]=None, folder_id: Optional[int]=None):
        """
        Constructor for ChatFull: Instance of either ChatFull, ChannelFull.
        """
        self.id = id
        self.about = about
        self.participants = participants
        self.notify_settings = notify_settings
        self.exported_invite = exported_invite
        self.can_set_username = can_set_username
        self.has_scheduled = has_scheduled
        self.chat_photo = chat_photo
        self.bot_info = bot_info
        self.pinned_msg_id = pinned_msg_id
        self.folder_id = folder_id

    def to_dict(self):
        return {
            '_': 'ChatFull',
            'id': self.id,
            'about': self.about,
            'participants': self.participants.to_dict() if isinstance(self.participants, TLObject) else self.participants,
            'notify_settings': self.notify_settings.to_dict() if isinstance(self.notify_settings, TLObject) else self.notify_settings,
            'exported_invite': self.exported_invite.to_dict() if isinstance(self.exported_invite, TLObject) else self.exported_invite,
            'can_set_username': self.can_set_username,
            'has_scheduled': self.has_scheduled,
            'chat_photo': self.chat_photo.to_dict() if isinstance(self.chat_photo, TLObject) else self.chat_photo,
            'bot_info': [] if self.bot_info is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.bot_info],
            'pinned_msg_id': self.pinned_msg_id,
            'folder_id': self.folder_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xb3\x9d|\x1b',
            struct.pack('<I', (0 if self.can_set_username is None or self.can_set_username is False else 128) | (0 if self.has_scheduled is None or self.has_scheduled is False else 256) | (0 if self.chat_photo is None or self.chat_photo is False else 4) | (0 if self.bot_info is None or self.bot_info is False else 8) | (0 if self.pinned_msg_id is None or self.pinned_msg_id is False else 64) | (0 if self.folder_id is None or self.folder_id is False else 2048)),
            struct.pack('<i', self.id),
            self.serialize_bytes(self.about),
            bytes(self.participants),
            b'' if self.chat_photo is None or self.chat_photo is False else (bytes(self.chat_photo)),
            bytes(self.notify_settings),
            bytes(self.exported_invite),
            b'' if self.bot_info is None or self.bot_info is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.bot_info)),b''.join(bytes(x) for x in self.bot_info))),
            b'' if self.pinned_msg_id is None or self.pinned_msg_id is False else (struct.pack('<i', self.pinned_msg_id)),
            b'' if self.folder_id is None or self.folder_id is False else (struct.pack('<i', self.folder_id)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _can_set_username = bool(flags & 128)
        _has_scheduled = bool(flags & 256)
        _id = reader.read_int()
        _about = reader.tgread_string()
        _participants = reader.tgread_object()
        if flags & 4:
            _chat_photo = reader.tgread_object()
        else:
            _chat_photo = None
        _notify_settings = reader.tgread_object()
        _exported_invite = reader.tgread_object()
        if flags & 8:
            reader.read_int()
            _bot_info = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _bot_info.append(_x)

        else:
            _bot_info = None
        if flags & 64:
            _pinned_msg_id = reader.read_int()
        else:
            _pinned_msg_id = None
        if flags & 2048:
            _folder_id = reader.read_int()
        else:
            _folder_id = None
        return cls(id=_id, about=_about, participants=_participants, notify_settings=_notify_settings, exported_invite=_exported_invite, can_set_username=_can_set_username, has_scheduled=_has_scheduled, chat_photo=_chat_photo, bot_info=_bot_info, pinned_msg_id=_pinned_msg_id, folder_id=_folder_id)


class ChatInvite(TLObject):
    CONSTRUCTOR_ID = 0xdfc2f58e
    SUBCLASS_OF_ID = 0x4561736

    def __init__(self, title: str, photo: 'TypePhoto', participants_count: int, channel: Optional[bool]=None, broadcast: Optional[bool]=None, public: Optional[bool]=None, megagroup: Optional[bool]=None, participants: Optional[List['TypeUser']]=None):
        """
        Constructor for ChatInvite: Instance of either ChatInviteAlready, ChatInvite.
        """
        self.title = title
        self.photo = photo
        self.participants_count = participants_count
        self.channel = channel
        self.broadcast = broadcast
        self.public = public
        self.megagroup = megagroup
        self.participants = participants

    def to_dict(self):
        return {
            '_': 'ChatInvite',
            'title': self.title,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'participants_count': self.participants_count,
            'channel': self.channel,
            'broadcast': self.broadcast,
            'public': self.public,
            'megagroup': self.megagroup,
            'participants': [] if self.participants is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.participants]
        }

    def __bytes__(self):
        return b''.join((
            b'\x8e\xf5\xc2\xdf',
            struct.pack('<I', (0 if self.channel is None or self.channel is False else 1) | (0 if self.broadcast is None or self.broadcast is False else 2) | (0 if self.public is None or self.public is False else 4) | (0 if self.megagroup is None or self.megagroup is False else 8) | (0 if self.participants is None or self.participants is False else 16)),
            self.serialize_bytes(self.title),
            bytes(self.photo),
            struct.pack('<i', self.participants_count),
            b'' if self.participants is None or self.participants is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.participants)),b''.join(bytes(x) for x in self.participants))),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _channel = bool(flags & 1)
        _broadcast = bool(flags & 2)
        _public = bool(flags & 4)
        _megagroup = bool(flags & 8)
        _title = reader.tgread_string()
        _photo = reader.tgread_object()
        _participants_count = reader.read_int()
        if flags & 16:
            reader.read_int()
            _participants = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _participants.append(_x)

        else:
            _participants = None
        return cls(title=_title, photo=_photo, participants_count=_participants_count, channel=_channel, broadcast=_broadcast, public=_public, megagroup=_megagroup, participants=_participants)


class ChatInviteAlready(TLObject):
    CONSTRUCTOR_ID = 0x5a686d7c
    SUBCLASS_OF_ID = 0x4561736

    def __init__(self, chat: 'TypeChat'):
        """
        Constructor for ChatInvite: Instance of either ChatInviteAlready, ChatInvite.
        """
        self.chat = chat

    def to_dict(self):
        return {
            '_': 'ChatInviteAlready',
            'chat': self.chat.to_dict() if isinstance(self.chat, TLObject) else self.chat
        }

    def __bytes__(self):
        return b''.join((
            b'|mhZ',
            bytes(self.chat),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat = reader.tgread_object()
        return cls(chat=_chat)


class ChatInviteEmpty(TLObject):
    CONSTRUCTOR_ID = 0x69df3769
    SUBCLASS_OF_ID = 0xb4748a58

    def to_dict(self):
        return {
            '_': 'ChatInviteEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'i7\xdfi',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ChatInviteExported(TLObject):
    CONSTRUCTOR_ID = 0xfc2e05bc
    SUBCLASS_OF_ID = 0xb4748a58

    def __init__(self, link: str):
        """
        Constructor for ExportedChatInvite: Instance of either ChatInviteEmpty, ChatInviteExported.
        """
        self.link = link

    def to_dict(self):
        return {
            '_': 'ChatInviteExported',
            'link': self.link
        }

    def __bytes__(self):
        return b''.join((
            b'\xbc\x05.\xfc',
            self.serialize_bytes(self.link),
        ))

    @classmethod
    def from_reader(cls, reader):
        _link = reader.tgread_string()
        return cls(link=_link)


class ChatOnlines(TLObject):
    CONSTRUCTOR_ID = 0xf041e250
    SUBCLASS_OF_ID = 0x8c81903a

    def __init__(self, onlines: int):
        """
        Constructor for ChatOnlines: Instance of ChatOnlines.
        """
        self.onlines = onlines

    def to_dict(self):
        return {
            '_': 'ChatOnlines',
            'onlines': self.onlines
        }

    def __bytes__(self):
        return b''.join((
            b'P\xe2A\xf0',
            struct.pack('<i', self.onlines),
        ))

    @classmethod
    def from_reader(cls, reader):
        _onlines = reader.read_int()
        return cls(onlines=_onlines)


class ChatParticipant(TLObject):
    CONSTRUCTOR_ID = 0xc8d7493e
    SUBCLASS_OF_ID = 0x7d7c6f86

    def __init__(self, user_id: int, inviter_id: int, date: Optional[datetime]):
        """
        Constructor for ChatParticipant: Instance of either ChatParticipant, ChatParticipantCreator, ChatParticipantAdmin.
        """
        self.user_id = user_id
        self.inviter_id = inviter_id
        self.date = date

    def to_dict(self):
        return {
            '_': 'ChatParticipant',
            'user_id': self.user_id,
            'inviter_id': self.inviter_id,
            'date': self.date
        }

    def __bytes__(self):
        return b''.join((
            b'>I\xd7\xc8',
            struct.pack('<i', self.user_id),
            struct.pack('<i', self.inviter_id),
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        _inviter_id = reader.read_int()
        _date = reader.tgread_date()
        return cls(user_id=_user_id, inviter_id=_inviter_id, date=_date)


class ChatParticipantAdmin(TLObject):
    CONSTRUCTOR_ID = 0xe2d6e436
    SUBCLASS_OF_ID = 0x7d7c6f86

    def __init__(self, user_id: int, inviter_id: int, date: Optional[datetime]):
        """
        Constructor for ChatParticipant: Instance of either ChatParticipant, ChatParticipantCreator, ChatParticipantAdmin.
        """
        self.user_id = user_id
        self.inviter_id = inviter_id
        self.date = date

    def to_dict(self):
        return {
            '_': 'ChatParticipantAdmin',
            'user_id': self.user_id,
            'inviter_id': self.inviter_id,
            'date': self.date
        }

    def __bytes__(self):
        return b''.join((
            b'6\xe4\xd6\xe2',
            struct.pack('<i', self.user_id),
            struct.pack('<i', self.inviter_id),
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        _inviter_id = reader.read_int()
        _date = reader.tgread_date()
        return cls(user_id=_user_id, inviter_id=_inviter_id, date=_date)


class ChatParticipantCreator(TLObject):
    CONSTRUCTOR_ID = 0xda13538a
    SUBCLASS_OF_ID = 0x7d7c6f86

    def __init__(self, user_id: int):
        """
        Constructor for ChatParticipant: Instance of either ChatParticipant, ChatParticipantCreator, ChatParticipantAdmin.
        """
        self.user_id = user_id

    def to_dict(self):
        return {
            '_': 'ChatParticipantCreator',
            'user_id': self.user_id
        }

    def __bytes__(self):
        return b''.join((
            b'\x8aS\x13\xda',
            struct.pack('<i', self.user_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        return cls(user_id=_user_id)


class ChatParticipants(TLObject):
    CONSTRUCTOR_ID = 0x3f460fed
    SUBCLASS_OF_ID = 0x1fa89571

    def __init__(self, chat_id: int, participants: List['TypeChatParticipant'], version: int):
        """
        Constructor for ChatParticipants: Instance of either ChatParticipantsForbidden, ChatParticipants.
        """
        self.chat_id = chat_id
        self.participants = participants
        self.version = version

    def to_dict(self):
        return {
            '_': 'ChatParticipants',
            'chat_id': self.chat_id,
            'participants': [] if self.participants is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.participants],
            'version': self.version
        }

    def __bytes__(self):
        return b''.join((
            b'\xed\x0fF?',
            struct.pack('<i', self.chat_id),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.participants)),b''.join(bytes(x) for x in self.participants),
            struct.pack('<i', self.version),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_int()
        reader.read_int()
        _participants = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _participants.append(_x)

        _version = reader.read_int()
        return cls(chat_id=_chat_id, participants=_participants, version=_version)


class ChatParticipantsForbidden(TLObject):
    CONSTRUCTOR_ID = 0xfc900c2b
    SUBCLASS_OF_ID = 0x1fa89571

    def __init__(self, chat_id: int, self_participant: Optional['TypeChatParticipant']=None):
        """
        Constructor for ChatParticipants: Instance of either ChatParticipantsForbidden, ChatParticipants.
        """
        self.chat_id = chat_id
        self.self_participant = self_participant

    def to_dict(self):
        return {
            '_': 'ChatParticipantsForbidden',
            'chat_id': self.chat_id,
            'self_participant': self.self_participant.to_dict() if isinstance(self.self_participant, TLObject) else self.self_participant
        }

    def __bytes__(self):
        return b''.join((
            b'+\x0c\x90\xfc',
            struct.pack('<I', (0 if self.self_participant is None or self.self_participant is False else 1)),
            struct.pack('<i', self.chat_id),
            b'' if self.self_participant is None or self.self_participant is False else (bytes(self.self_participant)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _chat_id = reader.read_int()
        if flags & 1:
            _self_participant = reader.tgread_object()
        else:
            _self_participant = None
        return cls(chat_id=_chat_id, self_participant=_self_participant)


class ChatPhoto(TLObject):
    CONSTRUCTOR_ID = 0x475cdbd5
    SUBCLASS_OF_ID = 0xac3ec4e5

    def __init__(self, photo_small: 'TypeFileLocation', photo_big: 'TypeFileLocation', dc_id: int):
        """
        Constructor for ChatPhoto: Instance of either ChatPhotoEmpty, ChatPhoto.
        """
        self.photo_small = photo_small
        self.photo_big = photo_big
        self.dc_id = dc_id

    def to_dict(self):
        return {
            '_': 'ChatPhoto',
            'photo_small': self.photo_small.to_dict() if isinstance(self.photo_small, TLObject) else self.photo_small,
            'photo_big': self.photo_big.to_dict() if isinstance(self.photo_big, TLObject) else self.photo_big,
            'dc_id': self.dc_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xd5\xdb\\G',
            bytes(self.photo_small),
            bytes(self.photo_big),
            struct.pack('<i', self.dc_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _photo_small = reader.tgread_object()
        _photo_big = reader.tgread_object()
        _dc_id = reader.read_int()
        return cls(photo_small=_photo_small, photo_big=_photo_big, dc_id=_dc_id)


class ChatPhotoEmpty(TLObject):
    CONSTRUCTOR_ID = 0x37c1011c
    SUBCLASS_OF_ID = 0xac3ec4e5

    def to_dict(self):
        return {
            '_': 'ChatPhotoEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'\x1c\x01\xc17',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ClientDHInnerData(TLObject):
    CONSTRUCTOR_ID = 0x6643b654
    SUBCLASS_OF_ID = 0xf8eeef6a

    def __init__(self, nonce: int, server_nonce: int, retry_id: int, g_b: bytes):
        """
        Constructor for Client_DH_Inner_Data: Instance of ClientDHInnerData.
        """
        self.nonce = nonce
        self.server_nonce = server_nonce
        self.retry_id = retry_id
        self.g_b = g_b

    def to_dict(self):
        return {
            '_': 'ClientDHInnerData',
            'nonce': self.nonce,
            'server_nonce': self.server_nonce,
            'retry_id': self.retry_id,
            'g_b': self.g_b
        }

    def __bytes__(self):
        return b''.join((
            b'T\xb6Cf',
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            struct.pack('<q', self.retry_id),
            self.serialize_bytes(self.g_b),
        ))

    @classmethod
    def from_reader(cls, reader):
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _retry_id = reader.read_long()
        _g_b = reader.tgread_bytes()
        return cls(nonce=_nonce, server_nonce=_server_nonce, retry_id=_retry_id, g_b=_g_b)


class CodeSettings(TLObject):
    CONSTRUCTOR_ID = 0xdebebe83
    SUBCLASS_OF_ID = 0x48edbc8a

    def __init__(self, allow_flashcall: Optional[bool]=None, current_number: Optional[bool]=None, allow_app_hash: Optional[bool]=None):
        """
        Constructor for CodeSettings: Instance of CodeSettings.
        """
        self.allow_flashcall = allow_flashcall
        self.current_number = current_number
        self.allow_app_hash = allow_app_hash

    def to_dict(self):
        return {
            '_': 'CodeSettings',
            'allow_flashcall': self.allow_flashcall,
            'current_number': self.current_number,
            'allow_app_hash': self.allow_app_hash
        }

    def __bytes__(self):
        return b''.join((
            b'\x83\xbe\xbe\xde',
            struct.pack('<I', (0 if self.allow_flashcall is None or self.allow_flashcall is False else 1) | (0 if self.current_number is None or self.current_number is False else 2) | (0 if self.allow_app_hash is None or self.allow_app_hash is False else 16)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _allow_flashcall = bool(flags & 1)
        _current_number = bool(flags & 2)
        _allow_app_hash = bool(flags & 16)
        return cls(allow_flashcall=_allow_flashcall, current_number=_current_number, allow_app_hash=_allow_app_hash)


class Config(TLObject):
    CONSTRUCTOR_ID = 0x330b4067
    SUBCLASS_OF_ID = 0xd3262a4a

    def __init__(self, date: Optional[datetime], expires: Optional[datetime], test_mode: bool, this_dc: int, dc_options: List['TypeDcOption'], dc_txt_domain_name: str, chat_size_max: int, megagroup_size_max: int, forwarded_count_max: int, online_update_period_ms: int, offline_blur_timeout_ms: int, offline_idle_timeout_ms: int, online_cloud_timeout_ms: int, notify_cloud_delay_ms: int, notify_default_delay_ms: int, push_chat_period_ms: int, push_chat_limit: int, saved_gifs_limit: int, edit_time_limit: int, revoke_time_limit: int, revoke_pm_time_limit: int, rating_e_decay: int, stickers_recent_limit: int, stickers_faved_limit: int, channels_read_media_period: int, pinned_dialogs_count_max: int, pinned_infolder_count_max: int, call_receive_timeout_ms: int, call_ring_timeout_ms: int, call_connect_timeout_ms: int, call_packet_timeout_ms: int, me_url_prefix: str, caption_length_max: int, message_length_max: int, webfile_dc_id: int, phonecalls_enabled: Optional[bool]=None, default_p2p_contacts: Optional[bool]=None, preload_featured_stickers: Optional[bool]=None, ignore_phone_entities: Optional[bool]=None, revoke_pm_inbox: Optional[bool]=None, blocked_mode: Optional[bool]=None, pfs_enabled: Optional[bool]=None, tmp_sessions: Optional[int]=None, autoupdate_url_prefix: Optional[str]=None, gif_search_username: Optional[str]=None, venue_search_username: Optional[str]=None, img_search_username: Optional[str]=None, static_maps_provider: Optional[str]=None, suggested_lang_code: Optional[str]=None, lang_pack_version: Optional[int]=None, base_lang_pack_version: Optional[int]=None):
        """
        Constructor for Config: Instance of Config.
        """
        self.date = date
        self.expires = expires
        self.test_mode = test_mode
        self.this_dc = this_dc
        self.dc_options = dc_options
        self.dc_txt_domain_name = dc_txt_domain_name
        self.chat_size_max = chat_size_max
        self.megagroup_size_max = megagroup_size_max
        self.forwarded_count_max = forwarded_count_max
        self.online_update_period_ms = online_update_period_ms
        self.offline_blur_timeout_ms = offline_blur_timeout_ms
        self.offline_idle_timeout_ms = offline_idle_timeout_ms
        self.online_cloud_timeout_ms = online_cloud_timeout_ms
        self.notify_cloud_delay_ms = notify_cloud_delay_ms
        self.notify_default_delay_ms = notify_default_delay_ms
        self.push_chat_period_ms = push_chat_period_ms
        self.push_chat_limit = push_chat_limit
        self.saved_gifs_limit = saved_gifs_limit
        self.edit_time_limit = edit_time_limit
        self.revoke_time_limit = revoke_time_limit
        self.revoke_pm_time_limit = revoke_pm_time_limit
        self.rating_e_decay = rating_e_decay
        self.stickers_recent_limit = stickers_recent_limit
        self.stickers_faved_limit = stickers_faved_limit
        self.channels_read_media_period = channels_read_media_period
        self.pinned_dialogs_count_max = pinned_dialogs_count_max
        self.pinned_infolder_count_max = pinned_infolder_count_max
        self.call_receive_timeout_ms = call_receive_timeout_ms
        self.call_ring_timeout_ms = call_ring_timeout_ms
        self.call_connect_timeout_ms = call_connect_timeout_ms
        self.call_packet_timeout_ms = call_packet_timeout_ms
        self.me_url_prefix = me_url_prefix
        self.caption_length_max = caption_length_max
        self.message_length_max = message_length_max
        self.webfile_dc_id = webfile_dc_id
        self.phonecalls_enabled = phonecalls_enabled
        self.default_p2p_contacts = default_p2p_contacts
        self.preload_featured_stickers = preload_featured_stickers
        self.ignore_phone_entities = ignore_phone_entities
        self.revoke_pm_inbox = revoke_pm_inbox
        self.blocked_mode = blocked_mode
        self.pfs_enabled = pfs_enabled
        self.tmp_sessions = tmp_sessions
        self.autoupdate_url_prefix = autoupdate_url_prefix
        self.gif_search_username = gif_search_username
        self.venue_search_username = venue_search_username
        self.img_search_username = img_search_username
        self.static_maps_provider = static_maps_provider
        self.suggested_lang_code = suggested_lang_code
        self.lang_pack_version = lang_pack_version
        self.base_lang_pack_version = base_lang_pack_version

    def to_dict(self):
        return {
            '_': 'Config',
            'date': self.date,
            'expires': self.expires,
            'test_mode': self.test_mode,
            'this_dc': self.this_dc,
            'dc_options': [] if self.dc_options is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.dc_options],
            'dc_txt_domain_name': self.dc_txt_domain_name,
            'chat_size_max': self.chat_size_max,
            'megagroup_size_max': self.megagroup_size_max,
            'forwarded_count_max': self.forwarded_count_max,
            'online_update_period_ms': self.online_update_period_ms,
            'offline_blur_timeout_ms': self.offline_blur_timeout_ms,
            'offline_idle_timeout_ms': self.offline_idle_timeout_ms,
            'online_cloud_timeout_ms': self.online_cloud_timeout_ms,
            'notify_cloud_delay_ms': self.notify_cloud_delay_ms,
            'notify_default_delay_ms': self.notify_default_delay_ms,
            'push_chat_period_ms': self.push_chat_period_ms,
            'push_chat_limit': self.push_chat_limit,
            'saved_gifs_limit': self.saved_gifs_limit,
            'edit_time_limit': self.edit_time_limit,
            'revoke_time_limit': self.revoke_time_limit,
            'revoke_pm_time_limit': self.revoke_pm_time_limit,
            'rating_e_decay': self.rating_e_decay,
            'stickers_recent_limit': self.stickers_recent_limit,
            'stickers_faved_limit': self.stickers_faved_limit,
            'channels_read_media_period': self.channels_read_media_period,
            'pinned_dialogs_count_max': self.pinned_dialogs_count_max,
            'pinned_infolder_count_max': self.pinned_infolder_count_max,
            'call_receive_timeout_ms': self.call_receive_timeout_ms,
            'call_ring_timeout_ms': self.call_ring_timeout_ms,
            'call_connect_timeout_ms': self.call_connect_timeout_ms,
            'call_packet_timeout_ms': self.call_packet_timeout_ms,
            'me_url_prefix': self.me_url_prefix,
            'caption_length_max': self.caption_length_max,
            'message_length_max': self.message_length_max,
            'webfile_dc_id': self.webfile_dc_id,
            'phonecalls_enabled': self.phonecalls_enabled,
            'default_p2p_contacts': self.default_p2p_contacts,
            'preload_featured_stickers': self.preload_featured_stickers,
            'ignore_phone_entities': self.ignore_phone_entities,
            'revoke_pm_inbox': self.revoke_pm_inbox,
            'blocked_mode': self.blocked_mode,
            'pfs_enabled': self.pfs_enabled,
            'tmp_sessions': self.tmp_sessions,
            'autoupdate_url_prefix': self.autoupdate_url_prefix,
            'gif_search_username': self.gif_search_username,
            'venue_search_username': self.venue_search_username,
            'img_search_username': self.img_search_username,
            'static_maps_provider': self.static_maps_provider,
            'suggested_lang_code': self.suggested_lang_code,
            'lang_pack_version': self.lang_pack_version,
            'base_lang_pack_version': self.base_lang_pack_version
        }

    def __bytes__(self):
        assert ((self.suggested_lang_code or self.suggested_lang_code is not None) and (self.lang_pack_version or self.lang_pack_version is not None) and (self.base_lang_pack_version or self.base_lang_pack_version is not None)) or ((self.suggested_lang_code is None or self.suggested_lang_code is False) and (self.lang_pack_version is None or self.lang_pack_version is False) and (self.base_lang_pack_version is None or self.base_lang_pack_version is False)), 'suggested_lang_code, lang_pack_version, base_lang_pack_version parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'g@\x0b3',
            struct.pack('<I', (0 if self.phonecalls_enabled is None or self.phonecalls_enabled is False else 2) | (0 if self.default_p2p_contacts is None or self.default_p2p_contacts is False else 8) | (0 if self.preload_featured_stickers is None or self.preload_featured_stickers is False else 16) | (0 if self.ignore_phone_entities is None or self.ignore_phone_entities is False else 32) | (0 if self.revoke_pm_inbox is None or self.revoke_pm_inbox is False else 64) | (0 if self.blocked_mode is None or self.blocked_mode is False else 256) | (0 if self.pfs_enabled is None or self.pfs_enabled is False else 8192) | (0 if self.tmp_sessions is None or self.tmp_sessions is False else 1) | (0 if self.autoupdate_url_prefix is None or self.autoupdate_url_prefix is False else 128) | (0 if self.gif_search_username is None or self.gif_search_username is False else 512) | (0 if self.venue_search_username is None or self.venue_search_username is False else 1024) | (0 if self.img_search_username is None or self.img_search_username is False else 2048) | (0 if self.static_maps_provider is None or self.static_maps_provider is False else 4096) | (0 if self.suggested_lang_code is None or self.suggested_lang_code is False else 4) | (0 if self.lang_pack_version is None or self.lang_pack_version is False else 4) | (0 if self.base_lang_pack_version is None or self.base_lang_pack_version is False else 4)),
            self.serialize_datetime(self.date),
            self.serialize_datetime(self.expires),
            b'\xb5ur\x99' if self.test_mode else b'7\x97y\xbc',
            struct.pack('<i', self.this_dc),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.dc_options)),b''.join(bytes(x) for x in self.dc_options),
            self.serialize_bytes(self.dc_txt_domain_name),
            struct.pack('<i', self.chat_size_max),
            struct.pack('<i', self.megagroup_size_max),
            struct.pack('<i', self.forwarded_count_max),
            struct.pack('<i', self.online_update_period_ms),
            struct.pack('<i', self.offline_blur_timeout_ms),
            struct.pack('<i', self.offline_idle_timeout_ms),
            struct.pack('<i', self.online_cloud_timeout_ms),
            struct.pack('<i', self.notify_cloud_delay_ms),
            struct.pack('<i', self.notify_default_delay_ms),
            struct.pack('<i', self.push_chat_period_ms),
            struct.pack('<i', self.push_chat_limit),
            struct.pack('<i', self.saved_gifs_limit),
            struct.pack('<i', self.edit_time_limit),
            struct.pack('<i', self.revoke_time_limit),
            struct.pack('<i', self.revoke_pm_time_limit),
            struct.pack('<i', self.rating_e_decay),
            struct.pack('<i', self.stickers_recent_limit),
            struct.pack('<i', self.stickers_faved_limit),
            struct.pack('<i', self.channels_read_media_period),
            b'' if self.tmp_sessions is None or self.tmp_sessions is False else (struct.pack('<i', self.tmp_sessions)),
            struct.pack('<i', self.pinned_dialogs_count_max),
            struct.pack('<i', self.pinned_infolder_count_max),
            struct.pack('<i', self.call_receive_timeout_ms),
            struct.pack('<i', self.call_ring_timeout_ms),
            struct.pack('<i', self.call_connect_timeout_ms),
            struct.pack('<i', self.call_packet_timeout_ms),
            self.serialize_bytes(self.me_url_prefix),
            b'' if self.autoupdate_url_prefix is None or self.autoupdate_url_prefix is False else (self.serialize_bytes(self.autoupdate_url_prefix)),
            b'' if self.gif_search_username is None or self.gif_search_username is False else (self.serialize_bytes(self.gif_search_username)),
            b'' if self.venue_search_username is None or self.venue_search_username is False else (self.serialize_bytes(self.venue_search_username)),
            b'' if self.img_search_username is None or self.img_search_username is False else (self.serialize_bytes(self.img_search_username)),
            b'' if self.static_maps_provider is None or self.static_maps_provider is False else (self.serialize_bytes(self.static_maps_provider)),
            struct.pack('<i', self.caption_length_max),
            struct.pack('<i', self.message_length_max),
            struct.pack('<i', self.webfile_dc_id),
            b'' if self.suggested_lang_code is None or self.suggested_lang_code is False else (self.serialize_bytes(self.suggested_lang_code)),
            b'' if self.lang_pack_version is None or self.lang_pack_version is False else (struct.pack('<i', self.lang_pack_version)),
            b'' if self.base_lang_pack_version is None or self.base_lang_pack_version is False else (struct.pack('<i', self.base_lang_pack_version)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _phonecalls_enabled = bool(flags & 2)
        _default_p2p_contacts = bool(flags & 8)
        _preload_featured_stickers = bool(flags & 16)
        _ignore_phone_entities = bool(flags & 32)
        _revoke_pm_inbox = bool(flags & 64)
        _blocked_mode = bool(flags & 256)
        _pfs_enabled = bool(flags & 8192)
        _date = reader.tgread_date()
        _expires = reader.tgread_date()
        _test_mode = reader.tgread_bool()
        _this_dc = reader.read_int()
        reader.read_int()
        _dc_options = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _dc_options.append(_x)

        _dc_txt_domain_name = reader.tgread_string()
        _chat_size_max = reader.read_int()
        _megagroup_size_max = reader.read_int()
        _forwarded_count_max = reader.read_int()
        _online_update_period_ms = reader.read_int()
        _offline_blur_timeout_ms = reader.read_int()
        _offline_idle_timeout_ms = reader.read_int()
        _online_cloud_timeout_ms = reader.read_int()
        _notify_cloud_delay_ms = reader.read_int()
        _notify_default_delay_ms = reader.read_int()
        _push_chat_period_ms = reader.read_int()
        _push_chat_limit = reader.read_int()
        _saved_gifs_limit = reader.read_int()
        _edit_time_limit = reader.read_int()
        _revoke_time_limit = reader.read_int()
        _revoke_pm_time_limit = reader.read_int()
        _rating_e_decay = reader.read_int()
        _stickers_recent_limit = reader.read_int()
        _stickers_faved_limit = reader.read_int()
        _channels_read_media_period = reader.read_int()
        if flags & 1:
            _tmp_sessions = reader.read_int()
        else:
            _tmp_sessions = None
        _pinned_dialogs_count_max = reader.read_int()
        _pinned_infolder_count_max = reader.read_int()
        _call_receive_timeout_ms = reader.read_int()
        _call_ring_timeout_ms = reader.read_int()
        _call_connect_timeout_ms = reader.read_int()
        _call_packet_timeout_ms = reader.read_int()
        _me_url_prefix = reader.tgread_string()
        if flags & 128:
            _autoupdate_url_prefix = reader.tgread_string()
        else:
            _autoupdate_url_prefix = None
        if flags & 512:
            _gif_search_username = reader.tgread_string()
        else:
            _gif_search_username = None
        if flags & 1024:
            _venue_search_username = reader.tgread_string()
        else:
            _venue_search_username = None
        if flags & 2048:
            _img_search_username = reader.tgread_string()
        else:
            _img_search_username = None
        if flags & 4096:
            _static_maps_provider = reader.tgread_string()
        else:
            _static_maps_provider = None
        _caption_length_max = reader.read_int()
        _message_length_max = reader.read_int()
        _webfile_dc_id = reader.read_int()
        if flags & 4:
            _suggested_lang_code = reader.tgread_string()
        else:
            _suggested_lang_code = None
        if flags & 4:
            _lang_pack_version = reader.read_int()
        else:
            _lang_pack_version = None
        if flags & 4:
            _base_lang_pack_version = reader.read_int()
        else:
            _base_lang_pack_version = None
        return cls(date=_date, expires=_expires, test_mode=_test_mode, this_dc=_this_dc, dc_options=_dc_options, dc_txt_domain_name=_dc_txt_domain_name, chat_size_max=_chat_size_max, megagroup_size_max=_megagroup_size_max, forwarded_count_max=_forwarded_count_max, online_update_period_ms=_online_update_period_ms, offline_blur_timeout_ms=_offline_blur_timeout_ms, offline_idle_timeout_ms=_offline_idle_timeout_ms, online_cloud_timeout_ms=_online_cloud_timeout_ms, notify_cloud_delay_ms=_notify_cloud_delay_ms, notify_default_delay_ms=_notify_default_delay_ms, push_chat_period_ms=_push_chat_period_ms, push_chat_limit=_push_chat_limit, saved_gifs_limit=_saved_gifs_limit, edit_time_limit=_edit_time_limit, revoke_time_limit=_revoke_time_limit, revoke_pm_time_limit=_revoke_pm_time_limit, rating_e_decay=_rating_e_decay, stickers_recent_limit=_stickers_recent_limit, stickers_faved_limit=_stickers_faved_limit, channels_read_media_period=_channels_read_media_period, pinned_dialogs_count_max=_pinned_dialogs_count_max, pinned_infolder_count_max=_pinned_infolder_count_max, call_receive_timeout_ms=_call_receive_timeout_ms, call_ring_timeout_ms=_call_ring_timeout_ms, call_connect_timeout_ms=_call_connect_timeout_ms, call_packet_timeout_ms=_call_packet_timeout_ms, me_url_prefix=_me_url_prefix, caption_length_max=_caption_length_max, message_length_max=_message_length_max, webfile_dc_id=_webfile_dc_id, phonecalls_enabled=_phonecalls_enabled, default_p2p_contacts=_default_p2p_contacts, preload_featured_stickers=_preload_featured_stickers, ignore_phone_entities=_ignore_phone_entities, revoke_pm_inbox=_revoke_pm_inbox, blocked_mode=_blocked_mode, pfs_enabled=_pfs_enabled, tmp_sessions=_tmp_sessions, autoupdate_url_prefix=_autoupdate_url_prefix, gif_search_username=_gif_search_username, venue_search_username=_venue_search_username, img_search_username=_img_search_username, static_maps_provider=_static_maps_provider, suggested_lang_code=_suggested_lang_code, lang_pack_version=_lang_pack_version, base_lang_pack_version=_base_lang_pack_version)


class Contact(TLObject):
    CONSTRUCTOR_ID = 0xf911c994
    SUBCLASS_OF_ID = 0x83dfdfa4

    def __init__(self, user_id: int, mutual: bool):
        """
        Constructor for Contact: Instance of Contact.
        """
        self.user_id = user_id
        self.mutual = mutual

    def to_dict(self):
        return {
            '_': 'Contact',
            'user_id': self.user_id,
            'mutual': self.mutual
        }

    def __bytes__(self):
        return b''.join((
            b'\x94\xc9\x11\xf9',
            struct.pack('<i', self.user_id),
            b'\xb5ur\x99' if self.mutual else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        _mutual = reader.tgread_bool()
        return cls(user_id=_user_id, mutual=_mutual)


class ContactBlocked(TLObject):
    CONSTRUCTOR_ID = 0x561bc879
    SUBCLASS_OF_ID = 0xb12d7ac6

    def __init__(self, user_id: int, date: Optional[datetime]):
        """
        Constructor for ContactBlocked: Instance of ContactBlocked.
        """
        self.user_id = user_id
        self.date = date

    def to_dict(self):
        return {
            '_': 'ContactBlocked',
            'user_id': self.user_id,
            'date': self.date
        }

    def __bytes__(self):
        return b''.join((
            b'y\xc8\x1bV',
            struct.pack('<i', self.user_id),
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        _date = reader.tgread_date()
        return cls(user_id=_user_id, date=_date)


class ContactStatus(TLObject):
    CONSTRUCTOR_ID = 0xd3680c61
    SUBCLASS_OF_ID = 0x68c0d74c

    def __init__(self, user_id: int, status: 'TypeUserStatus'):
        """
        Constructor for ContactStatus: Instance of ContactStatus.
        """
        self.user_id = user_id
        self.status = status

    def to_dict(self):
        return {
            '_': 'ContactStatus',
            'user_id': self.user_id,
            'status': self.status.to_dict() if isinstance(self.status, TLObject) else self.status
        }

    def __bytes__(self):
        return b''.join((
            b'a\x0ch\xd3',
            struct.pack('<i', self.user_id),
            bytes(self.status),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        _status = reader.tgread_object()
        return cls(user_id=_user_id, status=_status)


class DataJSON(TLObject):
    CONSTRUCTOR_ID = 0x7d748d04
    SUBCLASS_OF_ID = 0xad0352e8

    def __init__(self, data: str):
        """
        Constructor for DataJSON: Instance of DataJSON.
        """
        self.data = data

    def to_dict(self):
        return {
            '_': 'DataJSON',
            'data': self.data
        }

    def __bytes__(self):
        return b''.join((
            b'\x04\x8dt}',
            self.serialize_bytes(self.data),
        ))

    @classmethod
    def from_reader(cls, reader):
        _data = reader.tgread_string()
        return cls(data=_data)


class DcOption(TLObject):
    CONSTRUCTOR_ID = 0x18b7a10d
    SUBCLASS_OF_ID = 0x9e43e123

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, ip_address: str, port: int, ipv6: Optional[bool]=None, media_only: Optional[bool]=None, tcpo_only: Optional[bool]=None, cdn: Optional[bool]=None, static: Optional[bool]=None, secret: Optional[bytes]=None):
        """
        Constructor for DcOption: Instance of DcOption.
        """
        self.id = id
        self.ip_address = ip_address
        self.port = port
        self.ipv6 = ipv6
        self.media_only = media_only
        self.tcpo_only = tcpo_only
        self.cdn = cdn
        self.static = static
        self.secret = secret

    def to_dict(self):
        return {
            '_': 'DcOption',
            'id': self.id,
            'ip_address': self.ip_address,
            'port': self.port,
            'ipv6': self.ipv6,
            'media_only': self.media_only,
            'tcpo_only': self.tcpo_only,
            'cdn': self.cdn,
            'static': self.static,
            'secret': self.secret
        }

    def __bytes__(self):
        return b''.join((
            b'\r\xa1\xb7\x18',
            struct.pack('<I', (0 if self.ipv6 is None or self.ipv6 is False else 1) | (0 if self.media_only is None or self.media_only is False else 2) | (0 if self.tcpo_only is None or self.tcpo_only is False else 4) | (0 if self.cdn is None or self.cdn is False else 8) | (0 if self.static is None or self.static is False else 16) | (0 if self.secret is None or self.secret is False else 1024)),
            struct.pack('<i', self.id),
            self.serialize_bytes(self.ip_address),
            struct.pack('<i', self.port),
            b'' if self.secret is None or self.secret is False else (self.serialize_bytes(self.secret)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _ipv6 = bool(flags & 1)
        _media_only = bool(flags & 2)
        _tcpo_only = bool(flags & 4)
        _cdn = bool(flags & 8)
        _static = bool(flags & 16)
        _id = reader.read_int()
        _ip_address = reader.tgread_string()
        _port = reader.read_int()
        if flags & 1024:
            _secret = reader.tgread_bytes()
        else:
            _secret = None
        return cls(id=_id, ip_address=_ip_address, port=_port, ipv6=_ipv6, media_only=_media_only, tcpo_only=_tcpo_only, cdn=_cdn, static=_static, secret=_secret)


class DestroyAuthKeyFail(TLObject):
    CONSTRUCTOR_ID = 0xea109b13
    SUBCLASS_OF_ID = 0x8291e68e

    def to_dict(self):
        return {
            '_': 'DestroyAuthKeyFail'
        }

    def __bytes__(self):
        return b''.join((
            b'\x13\x9b\x10\xea',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class DestroyAuthKeyNone(TLObject):
    CONSTRUCTOR_ID = 0xa9f2259
    SUBCLASS_OF_ID = 0x8291e68e

    def to_dict(self):
        return {
            '_': 'DestroyAuthKeyNone'
        }

    def __bytes__(self):
        return b''.join((
            b'Y"\x9f\n',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class DestroyAuthKeyOk(TLObject):
    CONSTRUCTOR_ID = 0xf660e1d4
    SUBCLASS_OF_ID = 0x8291e68e

    def to_dict(self):
        return {
            '_': 'DestroyAuthKeyOk'
        }

    def __bytes__(self):
        return b''.join((
            b'\xd4\xe1`\xf6',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class DestroySessionNone(TLObject):
    CONSTRUCTOR_ID = 0x62d350c9
    SUBCLASS_OF_ID = 0xaf0ce7bd

    def __init__(self, session_id: int):
        """
        Constructor for DestroySessionRes: Instance of either DestroySessionOk, DestroySessionNone.
        """
        self.session_id = session_id

    def to_dict(self):
        return {
            '_': 'DestroySessionNone',
            'session_id': self.session_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xc9P\xd3b',
            struct.pack('<q', self.session_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _session_id = reader.read_long()
        return cls(session_id=_session_id)


class DestroySessionOk(TLObject):
    CONSTRUCTOR_ID = 0xe22045fc
    SUBCLASS_OF_ID = 0xaf0ce7bd

    def __init__(self, session_id: int):
        """
        Constructor for DestroySessionRes: Instance of either DestroySessionOk, DestroySessionNone.
        """
        self.session_id = session_id

    def to_dict(self):
        return {
            '_': 'DestroySessionOk',
            'session_id': self.session_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xfcE \xe2',
            struct.pack('<q', self.session_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _session_id = reader.read_long()
        return cls(session_id=_session_id)


class DhGenFail(TLObject):
    CONSTRUCTOR_ID = 0xa69dae02
    SUBCLASS_OF_ID = 0x55dd6cdb

    def __init__(self, nonce: int, server_nonce: int, new_nonce_hash3: int):
        """
        Constructor for Set_client_DH_params_answer: Instance of either DhGenOk, DhGenRetry, DhGenFail.
        """
        self.nonce = nonce
        self.server_nonce = server_nonce
        self.new_nonce_hash3 = new_nonce_hash3

    def to_dict(self):
        return {
            '_': 'DhGenFail',
            'nonce': self.nonce,
            'server_nonce': self.server_nonce,
            'new_nonce_hash3': self.new_nonce_hash3
        }

    def __bytes__(self):
        return b''.join((
            b'\x02\xae\x9d\xa6',
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce_hash3.to_bytes(16, 'little', signed=True),
        ))

    @classmethod
    def from_reader(cls, reader):
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce_hash3 = reader.read_large_int(bits=128)
        return cls(nonce=_nonce, server_nonce=_server_nonce, new_nonce_hash3=_new_nonce_hash3)


class DhGenOk(TLObject):
    CONSTRUCTOR_ID = 0x3bcbf734
    SUBCLASS_OF_ID = 0x55dd6cdb

    def __init__(self, nonce: int, server_nonce: int, new_nonce_hash1: int):
        """
        Constructor for Set_client_DH_params_answer: Instance of either DhGenOk, DhGenRetry, DhGenFail.
        """
        self.nonce = nonce
        self.server_nonce = server_nonce
        self.new_nonce_hash1 = new_nonce_hash1

    def to_dict(self):
        return {
            '_': 'DhGenOk',
            'nonce': self.nonce,
            'server_nonce': self.server_nonce,
            'new_nonce_hash1': self.new_nonce_hash1
        }

    def __bytes__(self):
        return b''.join((
            b'4\xf7\xcb;',
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce_hash1.to_bytes(16, 'little', signed=True),
        ))

    @classmethod
    def from_reader(cls, reader):
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce_hash1 = reader.read_large_int(bits=128)
        return cls(nonce=_nonce, server_nonce=_server_nonce, new_nonce_hash1=_new_nonce_hash1)


class DhGenRetry(TLObject):
    CONSTRUCTOR_ID = 0x46dc1fb9
    SUBCLASS_OF_ID = 0x55dd6cdb

    def __init__(self, nonce: int, server_nonce: int, new_nonce_hash2: int):
        """
        Constructor for Set_client_DH_params_answer: Instance of either DhGenOk, DhGenRetry, DhGenFail.
        """
        self.nonce = nonce
        self.server_nonce = server_nonce
        self.new_nonce_hash2 = new_nonce_hash2

    def to_dict(self):
        return {
            '_': 'DhGenRetry',
            'nonce': self.nonce,
            'server_nonce': self.server_nonce,
            'new_nonce_hash2': self.new_nonce_hash2
        }

    def __bytes__(self):
        return b''.join((
            b'\xb9\x1f\xdcF',
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce_hash2.to_bytes(16, 'little', signed=True),
        ))

    @classmethod
    def from_reader(cls, reader):
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce_hash2 = reader.read_large_int(bits=128)
        return cls(nonce=_nonce, server_nonce=_server_nonce, new_nonce_hash2=_new_nonce_hash2)


class Dialog(TLObject):
    CONSTRUCTOR_ID = 0x2c171f72
    SUBCLASS_OF_ID = 0x42cddd54

    def __init__(self, peer: 'TypePeer', top_message: int, read_inbox_max_id: int, read_outbox_max_id: int, unread_count: int, unread_mentions_count: int, notify_settings: 'TypePeerNotifySettings', pinned: Optional[bool]=None, unread_mark: Optional[bool]=None, pts: Optional[int]=None, draft: Optional['TypeDraftMessage']=None, folder_id: Optional[int]=None):
        """
        Constructor for Dialog: Instance of either Dialog, DialogFolder.
        """
        self.peer = peer
        self.top_message = top_message
        self.read_inbox_max_id = read_inbox_max_id
        self.read_outbox_max_id = read_outbox_max_id
        self.unread_count = unread_count
        self.unread_mentions_count = unread_mentions_count
        self.notify_settings = notify_settings
        self.pinned = pinned
        self.unread_mark = unread_mark
        self.pts = pts
        self.draft = draft
        self.folder_id = folder_id

    def to_dict(self):
        return {
            '_': 'Dialog',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'top_message': self.top_message,
            'read_inbox_max_id': self.read_inbox_max_id,
            'read_outbox_max_id': self.read_outbox_max_id,
            'unread_count': self.unread_count,
            'unread_mentions_count': self.unread_mentions_count,
            'notify_settings': self.notify_settings.to_dict() if isinstance(self.notify_settings, TLObject) else self.notify_settings,
            'pinned': self.pinned,
            'unread_mark': self.unread_mark,
            'pts': self.pts,
            'draft': self.draft.to_dict() if isinstance(self.draft, TLObject) else self.draft,
            'folder_id': self.folder_id
        }

    def __bytes__(self):
        return b''.join((
            b'r\x1f\x17,',
            struct.pack('<I', (0 if self.pinned is None or self.pinned is False else 4) | (0 if self.unread_mark is None or self.unread_mark is False else 8) | (0 if self.pts is None or self.pts is False else 1) | (0 if self.draft is None or self.draft is False else 2) | (0 if self.folder_id is None or self.folder_id is False else 16)),
            bytes(self.peer),
            struct.pack('<i', self.top_message),
            struct.pack('<i', self.read_inbox_max_id),
            struct.pack('<i', self.read_outbox_max_id),
            struct.pack('<i', self.unread_count),
            struct.pack('<i', self.unread_mentions_count),
            bytes(self.notify_settings),
            b'' if self.pts is None or self.pts is False else (struct.pack('<i', self.pts)),
            b'' if self.draft is None or self.draft is False else (bytes(self.draft)),
            b'' if self.folder_id is None or self.folder_id is False else (struct.pack('<i', self.folder_id)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _pinned = bool(flags & 4)
        _unread_mark = bool(flags & 8)
        _peer = reader.tgread_object()
        _top_message = reader.read_int()
        _read_inbox_max_id = reader.read_int()
        _read_outbox_max_id = reader.read_int()
        _unread_count = reader.read_int()
        _unread_mentions_count = reader.read_int()
        _notify_settings = reader.tgread_object()
        if flags & 1:
            _pts = reader.read_int()
        else:
            _pts = None
        if flags & 2:
            _draft = reader.tgread_object()
        else:
            _draft = None
        if flags & 16:
            _folder_id = reader.read_int()
        else:
            _folder_id = None
        return cls(peer=_peer, top_message=_top_message, read_inbox_max_id=_read_inbox_max_id, read_outbox_max_id=_read_outbox_max_id, unread_count=_unread_count, unread_mentions_count=_unread_mentions_count, notify_settings=_notify_settings, pinned=_pinned, unread_mark=_unread_mark, pts=_pts, draft=_draft, folder_id=_folder_id)


class DialogFolder(TLObject):
    CONSTRUCTOR_ID = 0x71bd134c
    SUBCLASS_OF_ID = 0x42cddd54

    def __init__(self, folder: 'TypeFolder', peer: 'TypePeer', top_message: int, unread_muted_peers_count: int, unread_unmuted_peers_count: int, unread_muted_messages_count: int, unread_unmuted_messages_count: int, pinned: Optional[bool]=None):
        """
        Constructor for Dialog: Instance of either Dialog, DialogFolder.
        """
        self.folder = folder
        self.peer = peer
        self.top_message = top_message
        self.unread_muted_peers_count = unread_muted_peers_count
        self.unread_unmuted_peers_count = unread_unmuted_peers_count
        self.unread_muted_messages_count = unread_muted_messages_count
        self.unread_unmuted_messages_count = unread_unmuted_messages_count
        self.pinned = pinned

    def to_dict(self):
        return {
            '_': 'DialogFolder',
            'folder': self.folder.to_dict() if isinstance(self.folder, TLObject) else self.folder,
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'top_message': self.top_message,
            'unread_muted_peers_count': self.unread_muted_peers_count,
            'unread_unmuted_peers_count': self.unread_unmuted_peers_count,
            'unread_muted_messages_count': self.unread_muted_messages_count,
            'unread_unmuted_messages_count': self.unread_unmuted_messages_count,
            'pinned': self.pinned
        }

    def __bytes__(self):
        return b''.join((
            b'L\x13\xbdq',
            struct.pack('<I', (0 if self.pinned is None or self.pinned is False else 4)),
            bytes(self.folder),
            bytes(self.peer),
            struct.pack('<i', self.top_message),
            struct.pack('<i', self.unread_muted_peers_count),
            struct.pack('<i', self.unread_unmuted_peers_count),
            struct.pack('<i', self.unread_muted_messages_count),
            struct.pack('<i', self.unread_unmuted_messages_count),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _pinned = bool(flags & 4)
        _folder = reader.tgread_object()
        _peer = reader.tgread_object()
        _top_message = reader.read_int()
        _unread_muted_peers_count = reader.read_int()
        _unread_unmuted_peers_count = reader.read_int()
        _unread_muted_messages_count = reader.read_int()
        _unread_unmuted_messages_count = reader.read_int()
        return cls(folder=_folder, peer=_peer, top_message=_top_message, unread_muted_peers_count=_unread_muted_peers_count, unread_unmuted_peers_count=_unread_unmuted_peers_count, unread_muted_messages_count=_unread_muted_messages_count, unread_unmuted_messages_count=_unread_unmuted_messages_count, pinned=_pinned)


class DialogPeer(TLObject):
    CONSTRUCTOR_ID = 0xe56dbf05
    SUBCLASS_OF_ID = 0x256ce1ae

    def __init__(self, peer: 'TypePeer'):
        """
        Constructor for DialogPeer: Instance of either DialogPeer, DialogPeerFolder.
        """
        self.peer = peer

    def to_dict(self):
        return {
            '_': 'DialogPeer',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def __bytes__(self):
        return b''.join((
            b'\x05\xbfm\xe5',
            bytes(self.peer),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


class DialogPeerFolder(TLObject):
    CONSTRUCTOR_ID = 0x514519e2
    SUBCLASS_OF_ID = 0x256ce1ae

    def __init__(self, folder_id: int):
        """
        Constructor for DialogPeer: Instance of either DialogPeer, DialogPeerFolder.
        """
        self.folder_id = folder_id

    def to_dict(self):
        return {
            '_': 'DialogPeerFolder',
            'folder_id': self.folder_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xe2\x19EQ',
            struct.pack('<i', self.folder_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _folder_id = reader.read_int()
        return cls(folder_id=_folder_id)


class Document(TLObject):
    CONSTRUCTOR_ID = 0x9ba29cc1
    SUBCLASS_OF_ID = 0x211fe820

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, file_reference: bytes, date: Optional[datetime], mime_type: str, size: int, dc_id: int, attributes: List['TypeDocumentAttribute'], thumbs: Optional[List['TypePhotoSize']]=None):
        """
        Constructor for Document: Instance of either DocumentEmpty, Document.
        """
        self.id = id
        self.access_hash = access_hash
        self.file_reference = file_reference
        self.date = date
        self.mime_type = mime_type
        self.size = size
        self.dc_id = dc_id
        self.attributes = attributes
        self.thumbs = thumbs

    def to_dict(self):
        return {
            '_': 'Document',
            'id': self.id,
            'access_hash': self.access_hash,
            'file_reference': self.file_reference,
            'date': self.date,
            'mime_type': self.mime_type,
            'size': self.size,
            'dc_id': self.dc_id,
            'attributes': [] if self.attributes is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.attributes],
            'thumbs': [] if self.thumbs is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.thumbs]
        }

    def __bytes__(self):
        return b''.join((
            b'\xc1\x9c\xa2\x9b',
            struct.pack('<I', (0 if self.thumbs is None or self.thumbs is False else 1)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_bytes(self.file_reference),
            self.serialize_datetime(self.date),
            self.serialize_bytes(self.mime_type),
            struct.pack('<i', self.size),
            b'' if self.thumbs is None or self.thumbs is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.thumbs)),b''.join(bytes(x) for x in self.thumbs))),
            struct.pack('<i', self.dc_id),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.attributes)),b''.join(bytes(x) for x in self.attributes),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.read_long()
        _access_hash = reader.read_long()
        _file_reference = reader.tgread_bytes()
        _date = reader.tgread_date()
        _mime_type = reader.tgread_string()
        _size = reader.read_int()
        if flags & 1:
            reader.read_int()
            _thumbs = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _thumbs.append(_x)

        else:
            _thumbs = None
        _dc_id = reader.read_int()
        reader.read_int()
        _attributes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _attributes.append(_x)

        return cls(id=_id, access_hash=_access_hash, file_reference=_file_reference, date=_date, mime_type=_mime_type, size=_size, dc_id=_dc_id, attributes=_attributes, thumbs=_thumbs)


class DocumentAttributeAnimated(TLObject):
    CONSTRUCTOR_ID = 0x11b58939
    SUBCLASS_OF_ID = 0xf729eb9b

    def to_dict(self):
        return {
            '_': 'DocumentAttributeAnimated'
        }

    def __bytes__(self):
        return b''.join((
            b'9\x89\xb5\x11',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class DocumentAttributeAudio(TLObject):
    CONSTRUCTOR_ID = 0x9852f9c6
    SUBCLASS_OF_ID = 0xf729eb9b

    def __init__(self, duration: int, voice: Optional[bool]=None, title: Optional[str]=None, performer: Optional[str]=None, waveform: Optional[bytes]=None):
        """
        Constructor for DocumentAttribute: Instance of either DocumentAttributeImageSize, DocumentAttributeAnimated, DocumentAttributeSticker, DocumentAttributeVideo, DocumentAttributeAudio, DocumentAttributeFilename, DocumentAttributeHasStickers.
        """
        self.duration = duration
        self.voice = voice
        self.title = title
        self.performer = performer
        self.waveform = waveform

    def to_dict(self):
        return {
            '_': 'DocumentAttributeAudio',
            'duration': self.duration,
            'voice': self.voice,
            'title': self.title,
            'performer': self.performer,
            'waveform': self.waveform
        }

    def __bytes__(self):
        return b''.join((
            b'\xc6\xf9R\x98',
            struct.pack('<I', (0 if self.voice is None or self.voice is False else 1024) | (0 if self.title is None or self.title is False else 1) | (0 if self.performer is None or self.performer is False else 2) | (0 if self.waveform is None or self.waveform is False else 4)),
            struct.pack('<i', self.duration),
            b'' if self.title is None or self.title is False else (self.serialize_bytes(self.title)),
            b'' if self.performer is None or self.performer is False else (self.serialize_bytes(self.performer)),
            b'' if self.waveform is None or self.waveform is False else (self.serialize_bytes(self.waveform)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _voice = bool(flags & 1024)
        _duration = reader.read_int()
        if flags & 1:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 2:
            _performer = reader.tgread_string()
        else:
            _performer = None
        if flags & 4:
            _waveform = reader.tgread_bytes()
        else:
            _waveform = None
        return cls(duration=_duration, voice=_voice, title=_title, performer=_performer, waveform=_waveform)


class DocumentAttributeFilename(TLObject):
    CONSTRUCTOR_ID = 0x15590068
    SUBCLASS_OF_ID = 0xf729eb9b

    def __init__(self, file_name: str):
        """
        Constructor for DocumentAttribute: Instance of either DocumentAttributeImageSize, DocumentAttributeAnimated, DocumentAttributeSticker, DocumentAttributeVideo, DocumentAttributeAudio, DocumentAttributeFilename, DocumentAttributeHasStickers.
        """
        self.file_name = file_name

    def to_dict(self):
        return {
            '_': 'DocumentAttributeFilename',
            'file_name': self.file_name
        }

    def __bytes__(self):
        return b''.join((
            b'h\x00Y\x15',
            self.serialize_bytes(self.file_name),
        ))

    @classmethod
    def from_reader(cls, reader):
        _file_name = reader.tgread_string()
        return cls(file_name=_file_name)


class DocumentAttributeHasStickers(TLObject):
    CONSTRUCTOR_ID = 0x9801d2f7
    SUBCLASS_OF_ID = 0xf729eb9b

    def to_dict(self):
        return {
            '_': 'DocumentAttributeHasStickers'
        }

    def __bytes__(self):
        return b''.join((
            b'\xf7\xd2\x01\x98',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class DocumentAttributeImageSize(TLObject):
    CONSTRUCTOR_ID = 0x6c37c15c
    SUBCLASS_OF_ID = 0xf729eb9b

    def __init__(self, w: int, h: int):
        """
        Constructor for DocumentAttribute: Instance of either DocumentAttributeImageSize, DocumentAttributeAnimated, DocumentAttributeSticker, DocumentAttributeVideo, DocumentAttributeAudio, DocumentAttributeFilename, DocumentAttributeHasStickers.
        """
        self.w = w
        self.h = h

    def to_dict(self):
        return {
            '_': 'DocumentAttributeImageSize',
            'w': self.w,
            'h': self.h
        }

    def __bytes__(self):
        return b''.join((
            b'\\\xc17l',
            struct.pack('<i', self.w),
            struct.pack('<i', self.h),
        ))

    @classmethod
    def from_reader(cls, reader):
        _w = reader.read_int()
        _h = reader.read_int()
        return cls(w=_w, h=_h)


class DocumentAttributeSticker(TLObject):
    CONSTRUCTOR_ID = 0x6319d612
    SUBCLASS_OF_ID = 0xf729eb9b

    def __init__(self, alt: str, stickerset: 'TypeInputStickerSet', mask: Optional[bool]=None, mask_coords: Optional['TypeMaskCoords']=None):
        """
        Constructor for DocumentAttribute: Instance of either DocumentAttributeImageSize, DocumentAttributeAnimated, DocumentAttributeSticker, DocumentAttributeVideo, DocumentAttributeAudio, DocumentAttributeFilename, DocumentAttributeHasStickers.
        """
        self.alt = alt
        self.stickerset = stickerset
        self.mask = mask
        self.mask_coords = mask_coords

    def to_dict(self):
        return {
            '_': 'DocumentAttributeSticker',
            'alt': self.alt,
            'stickerset': self.stickerset.to_dict() if isinstance(self.stickerset, TLObject) else self.stickerset,
            'mask': self.mask,
            'mask_coords': self.mask_coords.to_dict() if isinstance(self.mask_coords, TLObject) else self.mask_coords
        }

    def __bytes__(self):
        return b''.join((
            b'\x12\xd6\x19c',
            struct.pack('<I', (0 if self.mask is None or self.mask is False else 2) | (0 if self.mask_coords is None or self.mask_coords is False else 1)),
            self.serialize_bytes(self.alt),
            bytes(self.stickerset),
            b'' if self.mask_coords is None or self.mask_coords is False else (bytes(self.mask_coords)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _mask = bool(flags & 2)
        _alt = reader.tgread_string()
        _stickerset = reader.tgread_object()
        if flags & 1:
            _mask_coords = reader.tgread_object()
        else:
            _mask_coords = None
        return cls(alt=_alt, stickerset=_stickerset, mask=_mask, mask_coords=_mask_coords)


class DocumentAttributeVideo(TLObject):
    CONSTRUCTOR_ID = 0xef02ce6
    SUBCLASS_OF_ID = 0xf729eb9b

    def __init__(self, duration: int, w: int, h: int, round_message: Optional[bool]=None, supports_streaming: Optional[bool]=None):
        """
        Constructor for DocumentAttribute: Instance of either DocumentAttributeImageSize, DocumentAttributeAnimated, DocumentAttributeSticker, DocumentAttributeVideo, DocumentAttributeAudio, DocumentAttributeFilename, DocumentAttributeHasStickers.
        """
        self.duration = duration
        self.w = w
        self.h = h
        self.round_message = round_message
        self.supports_streaming = supports_streaming

    def to_dict(self):
        return {
            '_': 'DocumentAttributeVideo',
            'duration': self.duration,
            'w': self.w,
            'h': self.h,
            'round_message': self.round_message,
            'supports_streaming': self.supports_streaming
        }

    def __bytes__(self):
        return b''.join((
            b'\xe6,\xf0\x0e',
            struct.pack('<I', (0 if self.round_message is None or self.round_message is False else 1) | (0 if self.supports_streaming is None or self.supports_streaming is False else 2)),
            struct.pack('<i', self.duration),
            struct.pack('<i', self.w),
            struct.pack('<i', self.h),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _round_message = bool(flags & 1)
        _supports_streaming = bool(flags & 2)
        _duration = reader.read_int()
        _w = reader.read_int()
        _h = reader.read_int()
        return cls(duration=_duration, w=_w, h=_h, round_message=_round_message, supports_streaming=_supports_streaming)


class DocumentEmpty(TLObject):
    CONSTRUCTOR_ID = 0x36f8c871
    SUBCLASS_OF_ID = 0x211fe820

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        """
        Constructor for Document: Instance of either DocumentEmpty, Document.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'DocumentEmpty',
            'id': self.id
        }

    def __bytes__(self):
        return b''.join((
            b'q\xc8\xf86',
            struct.pack('<q', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        return cls(id=_id)


class DraftMessage(TLObject):
    CONSTRUCTOR_ID = 0xfd8e711f
    SUBCLASS_OF_ID = 0x33d47f45

    def __init__(self, message: str, date: Optional[datetime], no_webpage: Optional[bool]=None, reply_to_msg_id: Optional[int]=None, entities: Optional[List['TypeMessageEntity']]=None):
        """
        Constructor for DraftMessage: Instance of either DraftMessageEmpty, DraftMessage.
        """
        self.message = message
        self.date = date
        self.no_webpage = no_webpage
        self.reply_to_msg_id = reply_to_msg_id
        self.entities = entities

    def to_dict(self):
        return {
            '_': 'DraftMessage',
            'message': self.message,
            'date': self.date,
            'no_webpage': self.no_webpage,
            'reply_to_msg_id': self.reply_to_msg_id,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities]
        }

    def __bytes__(self):
        return b''.join((
            b'\x1fq\x8e\xfd',
            struct.pack('<I', (0 if self.no_webpage is None or self.no_webpage is False else 2) | (0 if self.reply_to_msg_id is None or self.reply_to_msg_id is False else 1) | (0 if self.entities is None or self.entities is False else 8)),
            b'' if self.reply_to_msg_id is None or self.reply_to_msg_id is False else (struct.pack('<i', self.reply_to_msg_id)),
            self.serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(bytes(x) for x in self.entities))),
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _no_webpage = bool(flags & 2)
        if flags & 1:
            _reply_to_msg_id = reader.read_int()
        else:
            _reply_to_msg_id = None
        _message = reader.tgread_string()
        if flags & 8:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        _date = reader.tgread_date()
        return cls(message=_message, date=_date, no_webpage=_no_webpage, reply_to_msg_id=_reply_to_msg_id, entities=_entities)


class DraftMessageEmpty(TLObject):
    CONSTRUCTOR_ID = 0x1b0c841a
    SUBCLASS_OF_ID = 0x33d47f45

    def __init__(self, date: Optional[datetime]=None):
        """
        Constructor for DraftMessage: Instance of either DraftMessageEmpty, DraftMessage.
        """
        self.date = date

    def to_dict(self):
        return {
            '_': 'DraftMessageEmpty',
            'date': self.date
        }

    def __bytes__(self):
        return b''.join((
            b'\x1a\x84\x0c\x1b',
            struct.pack('<I', (0 if self.date is None or self.date is False else 1)),
            b'' if self.date is None or self.date is False else (self.serialize_datetime(self.date)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _date = reader.tgread_date()
        else:
            _date = None
        return cls(date=_date)


class EmojiKeyword(TLObject):
    CONSTRUCTOR_ID = 0xd5b3b9f9
    SUBCLASS_OF_ID = 0x6612a53e

    def __init__(self, keyword: str, emoticons: List[str]):
        """
        Constructor for EmojiKeyword: Instance of either EmojiKeyword, EmojiKeywordDeleted.
        """
        self.keyword = keyword
        self.emoticons = emoticons

    def to_dict(self):
        return {
            '_': 'EmojiKeyword',
            'keyword': self.keyword,
            'emoticons': [] if self.emoticons is None else self.emoticons[:]
        }

    def __bytes__(self):
        return b''.join((
            b'\xf9\xb9\xb3\xd5',
            self.serialize_bytes(self.keyword),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.emoticons)),b''.join(self.serialize_bytes(x) for x in self.emoticons),
        ))

    @classmethod
    def from_reader(cls, reader):
        _keyword = reader.tgread_string()
        reader.read_int()
        _emoticons = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_string()
            _emoticons.append(_x)

        return cls(keyword=_keyword, emoticons=_emoticons)


class EmojiKeywordDeleted(TLObject):
    CONSTRUCTOR_ID = 0x236df622
    SUBCLASS_OF_ID = 0x6612a53e

    def __init__(self, keyword: str, emoticons: List[str]):
        """
        Constructor for EmojiKeyword: Instance of either EmojiKeyword, EmojiKeywordDeleted.
        """
        self.keyword = keyword
        self.emoticons = emoticons

    def to_dict(self):
        return {
            '_': 'EmojiKeywordDeleted',
            'keyword': self.keyword,
            'emoticons': [] if self.emoticons is None else self.emoticons[:]
        }

    def __bytes__(self):
        return b''.join((
            b'"\xf6m#',
            self.serialize_bytes(self.keyword),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.emoticons)),b''.join(self.serialize_bytes(x) for x in self.emoticons),
        ))

    @classmethod
    def from_reader(cls, reader):
        _keyword = reader.tgread_string()
        reader.read_int()
        _emoticons = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_string()
            _emoticons.append(_x)

        return cls(keyword=_keyword, emoticons=_emoticons)


class EmojiKeywordsDifference(TLObject):
    CONSTRUCTOR_ID = 0x5cc761bd
    SUBCLASS_OF_ID = 0xd279c672

    def __init__(self, lang_code: str, from_version: int, version: int, keywords: List['TypeEmojiKeyword']):
        """
        Constructor for EmojiKeywordsDifference: Instance of EmojiKeywordsDifference.
        """
        self.lang_code = lang_code
        self.from_version = from_version
        self.version = version
        self.keywords = keywords

    def to_dict(self):
        return {
            '_': 'EmojiKeywordsDifference',
            'lang_code': self.lang_code,
            'from_version': self.from_version,
            'version': self.version,
            'keywords': [] if self.keywords is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.keywords]
        }

    def __bytes__(self):
        return b''.join((
            b'\xbda\xc7\\',
            self.serialize_bytes(self.lang_code),
            struct.pack('<i', self.from_version),
            struct.pack('<i', self.version),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.keywords)),b''.join(bytes(x) for x in self.keywords),
        ))

    @classmethod
    def from_reader(cls, reader):
        _lang_code = reader.tgread_string()
        _from_version = reader.read_int()
        _version = reader.read_int()
        reader.read_int()
        _keywords = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _keywords.append(_x)

        return cls(lang_code=_lang_code, from_version=_from_version, version=_version, keywords=_keywords)


class EmojiLanguage(TLObject):
    CONSTRUCTOR_ID = 0xb3fb5361
    SUBCLASS_OF_ID = 0xa48d04ee

    def __init__(self, lang_code: str):
        """
        Constructor for EmojiLanguage: Instance of EmojiLanguage.
        """
        self.lang_code = lang_code

    def to_dict(self):
        return {
            '_': 'EmojiLanguage',
            'lang_code': self.lang_code
        }

    def __bytes__(self):
        return b''.join((
            b'aS\xfb\xb3',
            self.serialize_bytes(self.lang_code),
        ))

    @classmethod
    def from_reader(cls, reader):
        _lang_code = reader.tgread_string()
        return cls(lang_code=_lang_code)


class EmojiURL(TLObject):
    CONSTRUCTOR_ID = 0xa575739d
    SUBCLASS_OF_ID = 0x1fa08a19

    def __init__(self, url: str):
        """
        Constructor for EmojiURL: Instance of EmojiURL.
        """
        self.url = url

    def to_dict(self):
        return {
            '_': 'EmojiURL',
            'url': self.url
        }

    def __bytes__(self):
        return b''.join((
            b'\x9dsu\xa5',
            self.serialize_bytes(self.url),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        return cls(url=_url)


class EncryptedChat(TLObject):
    CONSTRUCTOR_ID = 0xfa56ce36
    SUBCLASS_OF_ID = 0x6d28a37a

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, date: Optional[datetime], admin_id: int, participant_id: int, g_a_or_b: bytes, key_fingerprint: int):
        """
        Constructor for EncryptedChat: Instance of either EncryptedChatEmpty, EncryptedChatWaiting, EncryptedChatRequested, EncryptedChat, EncryptedChatDiscarded.
        """
        self.id = id
        self.access_hash = access_hash
        self.date = date
        self.admin_id = admin_id
        self.participant_id = participant_id
        self.g_a_or_b = g_a_or_b
        self.key_fingerprint = key_fingerprint

    def to_dict(self):
        return {
            '_': 'EncryptedChat',
            'id': self.id,
            'access_hash': self.access_hash,
            'date': self.date,
            'admin_id': self.admin_id,
            'participant_id': self.participant_id,
            'g_a_or_b': self.g_a_or_b,
            'key_fingerprint': self.key_fingerprint
        }

    def __bytes__(self):
        return b''.join((
            b'6\xceV\xfa',
            struct.pack('<i', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_datetime(self.date),
            struct.pack('<i', self.admin_id),
            struct.pack('<i', self.participant_id),
            self.serialize_bytes(self.g_a_or_b),
            struct.pack('<q', self.key_fingerprint),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_int()
        _access_hash = reader.read_long()
        _date = reader.tgread_date()
        _admin_id = reader.read_int()
        _participant_id = reader.read_int()
        _g_a_or_b = reader.tgread_bytes()
        _key_fingerprint = reader.read_long()
        return cls(id=_id, access_hash=_access_hash, date=_date, admin_id=_admin_id, participant_id=_participant_id, g_a_or_b=_g_a_or_b, key_fingerprint=_key_fingerprint)


class EncryptedChatDiscarded(TLObject):
    CONSTRUCTOR_ID = 0x13d6dd27
    SUBCLASS_OF_ID = 0x6d28a37a

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        """
        Constructor for EncryptedChat: Instance of either EncryptedChatEmpty, EncryptedChatWaiting, EncryptedChatRequested, EncryptedChat, EncryptedChatDiscarded.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'EncryptedChatDiscarded',
            'id': self.id
        }

    def __bytes__(self):
        return b''.join((
            b"'\xdd\xd6\x13",
            struct.pack('<i', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_int()
        return cls(id=_id)


class EncryptedChatEmpty(TLObject):
    CONSTRUCTOR_ID = 0xab7ec0a0
    SUBCLASS_OF_ID = 0x6d28a37a

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        """
        Constructor for EncryptedChat: Instance of either EncryptedChatEmpty, EncryptedChatWaiting, EncryptedChatRequested, EncryptedChat, EncryptedChatDiscarded.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'EncryptedChatEmpty',
            'id': self.id
        }

    def __bytes__(self):
        return b''.join((
            b'\xa0\xc0~\xab',
            struct.pack('<i', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_int()
        return cls(id=_id)


class EncryptedChatRequested(TLObject):
    CONSTRUCTOR_ID = 0xc878527e
    SUBCLASS_OF_ID = 0x6d28a37a

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, date: Optional[datetime], admin_id: int, participant_id: int, g_a: bytes):
        """
        Constructor for EncryptedChat: Instance of either EncryptedChatEmpty, EncryptedChatWaiting, EncryptedChatRequested, EncryptedChat, EncryptedChatDiscarded.
        """
        self.id = id
        self.access_hash = access_hash
        self.date = date
        self.admin_id = admin_id
        self.participant_id = participant_id
        self.g_a = g_a

    def to_dict(self):
        return {
            '_': 'EncryptedChatRequested',
            'id': self.id,
            'access_hash': self.access_hash,
            'date': self.date,
            'admin_id': self.admin_id,
            'participant_id': self.participant_id,
            'g_a': self.g_a
        }

    def __bytes__(self):
        return b''.join((
            b'~Rx\xc8',
            struct.pack('<i', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_datetime(self.date),
            struct.pack('<i', self.admin_id),
            struct.pack('<i', self.participant_id),
            self.serialize_bytes(self.g_a),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_int()
        _access_hash = reader.read_long()
        _date = reader.tgread_date()
        _admin_id = reader.read_int()
        _participant_id = reader.read_int()
        _g_a = reader.tgread_bytes()
        return cls(id=_id, access_hash=_access_hash, date=_date, admin_id=_admin_id, participant_id=_participant_id, g_a=_g_a)


class EncryptedChatWaiting(TLObject):
    CONSTRUCTOR_ID = 0x3bf703dc
    SUBCLASS_OF_ID = 0x6d28a37a

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, date: Optional[datetime], admin_id: int, participant_id: int):
        """
        Constructor for EncryptedChat: Instance of either EncryptedChatEmpty, EncryptedChatWaiting, EncryptedChatRequested, EncryptedChat, EncryptedChatDiscarded.
        """
        self.id = id
        self.access_hash = access_hash
        self.date = date
        self.admin_id = admin_id
        self.participant_id = participant_id

    def to_dict(self):
        return {
            '_': 'EncryptedChatWaiting',
            'id': self.id,
            'access_hash': self.access_hash,
            'date': self.date,
            'admin_id': self.admin_id,
            'participant_id': self.participant_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xdc\x03\xf7;',
            struct.pack('<i', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_datetime(self.date),
            struct.pack('<i', self.admin_id),
            struct.pack('<i', self.participant_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_int()
        _access_hash = reader.read_long()
        _date = reader.tgread_date()
        _admin_id = reader.read_int()
        _participant_id = reader.read_int()
        return cls(id=_id, access_hash=_access_hash, date=_date, admin_id=_admin_id, participant_id=_participant_id)


class EncryptedFile(TLObject):
    CONSTRUCTOR_ID = 0x4a70994c
    SUBCLASS_OF_ID = 0x842a67c0

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, size: int, dc_id: int, key_fingerprint: int):
        """
        Constructor for EncryptedFile: Instance of either EncryptedFileEmpty, EncryptedFile.
        """
        self.id = id
        self.access_hash = access_hash
        self.size = size
        self.dc_id = dc_id
        self.key_fingerprint = key_fingerprint

    def to_dict(self):
        return {
            '_': 'EncryptedFile',
            'id': self.id,
            'access_hash': self.access_hash,
            'size': self.size,
            'dc_id': self.dc_id,
            'key_fingerprint': self.key_fingerprint
        }

    def __bytes__(self):
        return b''.join((
            b'L\x99pJ',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            struct.pack('<i', self.size),
            struct.pack('<i', self.dc_id),
            struct.pack('<i', self.key_fingerprint),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _size = reader.read_int()
        _dc_id = reader.read_int()
        _key_fingerprint = reader.read_int()
        return cls(id=_id, access_hash=_access_hash, size=_size, dc_id=_dc_id, key_fingerprint=_key_fingerprint)


class EncryptedFileEmpty(TLObject):
    CONSTRUCTOR_ID = 0xc21f497e
    SUBCLASS_OF_ID = 0x842a67c0

    def to_dict(self):
        return {
            '_': 'EncryptedFileEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'~I\x1f\xc2',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class EncryptedMessage(TLObject):
    CONSTRUCTOR_ID = 0xed18c118
    SUBCLASS_OF_ID = 0x239f2e51

    # noinspection PyShadowingBuiltins
    def __init__(self, chat_id: int, date: Optional[datetime], bytes: bytes, file: 'TypeEncryptedFile', random_id: int=None):
        """
        Constructor for EncryptedMessage: Instance of either EncryptedMessage, EncryptedMessageService.
        """
        self.chat_id = chat_id
        self.date = date
        self.bytes = bytes
        self.file = file
        self.random_id = random_id if random_id is not None else int.from_bytes(os.urandom(8), 'big', signed=True)

    def to_dict(self):
        return {
            '_': 'EncryptedMessage',
            'chat_id': self.chat_id,
            'date': self.date,
            'bytes': self.bytes,
            'file': self.file.to_dict() if isinstance(self.file, TLObject) else self.file,
            'random_id': self.random_id
        }

    def __bytes__(self):
        return b''.join((
            b'\x18\xc1\x18\xed',
            struct.pack('<q', self.random_id),
            struct.pack('<i', self.chat_id),
            self.serialize_datetime(self.date),
            self.serialize_bytes(self.bytes),
            bytes(self.file),
        ))

    @classmethod
    def from_reader(cls, reader):
        _random_id = reader.read_long()
        _chat_id = reader.read_int()
        _date = reader.tgread_date()
        _bytes = reader.tgread_bytes()
        _file = reader.tgread_object()
        return cls(chat_id=_chat_id, date=_date, bytes=_bytes, file=_file, random_id=_random_id)


class EncryptedMessageService(TLObject):
    CONSTRUCTOR_ID = 0x23734b06
    SUBCLASS_OF_ID = 0x239f2e51

    # noinspection PyShadowingBuiltins
    def __init__(self, chat_id: int, date: Optional[datetime], bytes: bytes, random_id: int=None):
        """
        Constructor for EncryptedMessage: Instance of either EncryptedMessage, EncryptedMessageService.
        """
        self.chat_id = chat_id
        self.date = date
        self.bytes = bytes
        self.random_id = random_id if random_id is not None else int.from_bytes(os.urandom(8), 'big', signed=True)

    def to_dict(self):
        return {
            '_': 'EncryptedMessageService',
            'chat_id': self.chat_id,
            'date': self.date,
            'bytes': self.bytes,
            'random_id': self.random_id
        }

    def __bytes__(self):
        return b''.join((
            b'\x06Ks#',
            struct.pack('<q', self.random_id),
            struct.pack('<i', self.chat_id),
            self.serialize_datetime(self.date),
            self.serialize_bytes(self.bytes),
        ))

    @classmethod
    def from_reader(cls, reader):
        _random_id = reader.read_long()
        _chat_id = reader.read_int()
        _date = reader.tgread_date()
        _bytes = reader.tgread_bytes()
        return cls(chat_id=_chat_id, date=_date, bytes=_bytes, random_id=_random_id)


class ExportedMessageLink(TLObject):
    CONSTRUCTOR_ID = 0x5dab1af4
    SUBCLASS_OF_ID = 0xdee644cc

    def __init__(self, link: str, html: str):
        """
        Constructor for ExportedMessageLink: Instance of ExportedMessageLink.
        """
        self.link = link
        self.html = html

    def to_dict(self):
        return {
            '_': 'ExportedMessageLink',
            'link': self.link,
            'html': self.html
        }

    def __bytes__(self):
        return b''.join((
            b'\xf4\x1a\xab]',
            self.serialize_bytes(self.link),
            self.serialize_bytes(self.html),
        ))

    @classmethod
    def from_reader(cls, reader):
        _link = reader.tgread_string()
        _html = reader.tgread_string()
        return cls(link=_link, html=_html)


class FileHash(TLObject):
    CONSTRUCTOR_ID = 0x6242c773
    SUBCLASS_OF_ID = 0xead438b3

    # noinspection PyShadowingBuiltins
    def __init__(self, offset: int, limit: int, hash: bytes):
        """
        Constructor for FileHash: Instance of FileHash.
        """
        self.offset = offset
        self.limit = limit
        self.hash = hash

    def to_dict(self):
        return {
            '_': 'FileHash',
            'offset': self.offset,
            'limit': self.limit,
            'hash': self.hash
        }

    def __bytes__(self):
        return b''.join((
            b's\xc7Bb',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.limit),
            self.serialize_bytes(self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _limit = reader.read_int()
        _hash = reader.tgread_bytes()
        return cls(offset=_offset, limit=_limit, hash=_hash)


class FileLocationToBeDeprecated(TLObject):
    CONSTRUCTOR_ID = 0xbc7fc6cd
    SUBCLASS_OF_ID = 0x90f76823

    def __init__(self, volume_id: int, local_id: int):
        """
        Constructor for FileLocation: Instance of FileLocationToBeDeprecated.
        """
        self.volume_id = volume_id
        self.local_id = local_id

    def to_dict(self):
        return {
            '_': 'FileLocationToBeDeprecated',
            'volume_id': self.volume_id,
            'local_id': self.local_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xcd\xc6\x7f\xbc',
            struct.pack('<q', self.volume_id),
            struct.pack('<i', self.local_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _volume_id = reader.read_long()
        _local_id = reader.read_int()
        return cls(volume_id=_volume_id, local_id=_local_id)


class Folder(TLObject):
    CONSTRUCTOR_ID = 0xff544e65
    SUBCLASS_OF_ID = 0xeb0e0cfb

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, title: str, autofill_new_broadcasts: Optional[bool]=None, autofill_public_groups: Optional[bool]=None, autofill_new_correspondents: Optional[bool]=None, photo: Optional['TypeChatPhoto']=None):
        """
        Constructor for Folder: Instance of Folder.
        """
        self.id = id
        self.title = title
        self.autofill_new_broadcasts = autofill_new_broadcasts
        self.autofill_public_groups = autofill_public_groups
        self.autofill_new_correspondents = autofill_new_correspondents
        self.photo = photo

    def to_dict(self):
        return {
            '_': 'Folder',
            'id': self.id,
            'title': self.title,
            'autofill_new_broadcasts': self.autofill_new_broadcasts,
            'autofill_public_groups': self.autofill_public_groups,
            'autofill_new_correspondents': self.autofill_new_correspondents,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo
        }

    def __bytes__(self):
        return b''.join((
            b'eNT\xff',
            struct.pack('<I', (0 if self.autofill_new_broadcasts is None or self.autofill_new_broadcasts is False else 1) | (0 if self.autofill_public_groups is None or self.autofill_public_groups is False else 2) | (0 if self.autofill_new_correspondents is None or self.autofill_new_correspondents is False else 4) | (0 if self.photo is None or self.photo is False else 8)),
            struct.pack('<i', self.id),
            self.serialize_bytes(self.title),
            b'' if self.photo is None or self.photo is False else (bytes(self.photo)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _autofill_new_broadcasts = bool(flags & 1)
        _autofill_public_groups = bool(flags & 2)
        _autofill_new_correspondents = bool(flags & 4)
        _id = reader.read_int()
        _title = reader.tgread_string()
        if flags & 8:
            _photo = reader.tgread_object()
        else:
            _photo = None
        return cls(id=_id, title=_title, autofill_new_broadcasts=_autofill_new_broadcasts, autofill_public_groups=_autofill_public_groups, autofill_new_correspondents=_autofill_new_correspondents, photo=_photo)


class FolderPeer(TLObject):
    CONSTRUCTOR_ID = 0xe9baa668
    SUBCLASS_OF_ID = 0xf3f2283b

    def __init__(self, peer: 'TypePeer', folder_id: int):
        """
        Constructor for FolderPeer: Instance of FolderPeer.
        """
        self.peer = peer
        self.folder_id = folder_id

    def to_dict(self):
        return {
            '_': 'FolderPeer',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'folder_id': self.folder_id
        }

    def __bytes__(self):
        return b''.join((
            b'h\xa6\xba\xe9',
            bytes(self.peer),
            struct.pack('<i', self.folder_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _folder_id = reader.read_int()
        return cls(peer=_peer, folder_id=_folder_id)


class FoundGif(TLObject):
    CONSTRUCTOR_ID = 0x162ecc1f
    SUBCLASS_OF_ID = 0x5bbc92c3

    def __init__(self, url: str, thumb_url: str, content_url: str, content_type: str, w: int, h: int):
        """
        Constructor for FoundGif: Instance of either FoundGif, FoundGifCached.
        """
        self.url = url
        self.thumb_url = thumb_url
        self.content_url = content_url
        self.content_type = content_type
        self.w = w
        self.h = h

    def to_dict(self):
        return {
            '_': 'FoundGif',
            'url': self.url,
            'thumb_url': self.thumb_url,
            'content_url': self.content_url,
            'content_type': self.content_type,
            'w': self.w,
            'h': self.h
        }

    def __bytes__(self):
        return b''.join((
            b'\x1f\xcc.\x16',
            self.serialize_bytes(self.url),
            self.serialize_bytes(self.thumb_url),
            self.serialize_bytes(self.content_url),
            self.serialize_bytes(self.content_type),
            struct.pack('<i', self.w),
            struct.pack('<i', self.h),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        _thumb_url = reader.tgread_string()
        _content_url = reader.tgread_string()
        _content_type = reader.tgread_string()
        _w = reader.read_int()
        _h = reader.read_int()
        return cls(url=_url, thumb_url=_thumb_url, content_url=_content_url, content_type=_content_type, w=_w, h=_h)


class FoundGifCached(TLObject):
    CONSTRUCTOR_ID = 0x9c750409
    SUBCLASS_OF_ID = 0x5bbc92c3

    def __init__(self, url: str, photo: 'TypePhoto', document: 'TypeDocument'):
        """
        Constructor for FoundGif: Instance of either FoundGif, FoundGifCached.
        """
        self.url = url
        self.photo = photo
        self.document = document

    def to_dict(self):
        return {
            '_': 'FoundGifCached',
            'url': self.url,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'document': self.document.to_dict() if isinstance(self.document, TLObject) else self.document
        }

    def __bytes__(self):
        return b''.join((
            b'\t\x04u\x9c',
            self.serialize_bytes(self.url),
            bytes(self.photo),
            bytes(self.document),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        _photo = reader.tgread_object()
        _document = reader.tgread_object()
        return cls(url=_url, photo=_photo, document=_document)


class FutureSalt(TLObject):
    CONSTRUCTOR_ID = 0x949d9dc
    SUBCLASS_OF_ID = 0x45e53dcf

    def __init__(self, valid_since: Optional[datetime], valid_until: Optional[datetime], salt: int):
        """
        Constructor for FutureSalt: Instance of FutureSalt.
        """
        self.valid_since = valid_since
        self.valid_until = valid_until
        self.salt = salt

    def to_dict(self):
        return {
            '_': 'FutureSalt',
            'valid_since': self.valid_since,
            'valid_until': self.valid_until,
            'salt': self.salt
        }

    def __bytes__(self):
        return b''.join((
            b'\xdc\xd9I\t',
            self.serialize_datetime(self.valid_since),
            self.serialize_datetime(self.valid_until),
            struct.pack('<q', self.salt),
        ))

    @classmethod
    def from_reader(cls, reader):
        _valid_since = reader.tgread_date()
        _valid_until = reader.tgread_date()
        _salt = reader.read_long()
        return cls(valid_since=_valid_since, valid_until=_valid_until, salt=_salt)


class FutureSalts(TLObject):
    CONSTRUCTOR_ID = 0xae500895
    SUBCLASS_OF_ID = 0x1090f517

    def __init__(self, req_msg_id: int, now: int, salts: List['Typefuture_salt']):
        """
        Constructor for FutureSalts: Instance of FutureSalts.
        """
        self.req_msg_id = req_msg_id
        self.now = now
        self.salts = salts

    def to_dict(self):
        return {
            '_': 'FutureSalts',
            'req_msg_id': self.req_msg_id,
            'now': self.now,
            'salts': [] if self.salts is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.salts]
        }

    def __bytes__(self):
        return b''.join((
            b'\x95\x08P\xae',
            struct.pack('<q', self.req_msg_id),
            struct.pack('<i', self.now),
            struct.pack('<i', len(self.salts)),b''.join(bytes(x)[4:] for x in self.salts),
        ))

    @classmethod
    def from_reader(cls, reader):
        _req_msg_id = reader.read_long()
        _now = reader.read_int()
        _salts = []
        for _ in range(reader.read_int()):
            from . import FutureSalt
            _x = FutureSalt.from_reader(reader)
            _salts.append(_x)

        return cls(req_msg_id=_req_msg_id, now=_now, salts=_salts)


class Game(TLObject):
    CONSTRUCTOR_ID = 0xbdf9653b
    SUBCLASS_OF_ID = 0x83199eb2

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, short_name: str, title: str, description: str, photo: 'TypePhoto', document: Optional['TypeDocument']=None):
        """
        Constructor for Game: Instance of Game.
        """
        self.id = id
        self.access_hash = access_hash
        self.short_name = short_name
        self.title = title
        self.description = description
        self.photo = photo
        self.document = document

    def to_dict(self):
        return {
            '_': 'Game',
            'id': self.id,
            'access_hash': self.access_hash,
            'short_name': self.short_name,
            'title': self.title,
            'description': self.description,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'document': self.document.to_dict() if isinstance(self.document, TLObject) else self.document
        }

    def __bytes__(self):
        return b''.join((
            b';e\xf9\xbd',
            struct.pack('<I', (0 if self.document is None or self.document is False else 1)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_bytes(self.short_name),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.description),
            bytes(self.photo),
            b'' if self.document is None or self.document is False else (bytes(self.document)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.read_long()
        _access_hash = reader.read_long()
        _short_name = reader.tgread_string()
        _title = reader.tgread_string()
        _description = reader.tgread_string()
        _photo = reader.tgread_object()
        if flags & 1:
            _document = reader.tgread_object()
        else:
            _document = None
        return cls(id=_id, access_hash=_access_hash, short_name=_short_name, title=_title, description=_description, photo=_photo, document=_document)


class GeoPoint(TLObject):
    CONSTRUCTOR_ID = 0x296f104
    SUBCLASS_OF_ID = 0xd610e16d

    def __init__(self, long: float, lat: float, access_hash: int):
        """
        Constructor for GeoPoint: Instance of either GeoPointEmpty, GeoPoint.
        """
        self.long = long
        self.lat = lat
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'GeoPoint',
            'long': self.long,
            'lat': self.lat,
            'access_hash': self.access_hash
        }

    def __bytes__(self):
        return b''.join((
            b'\x04\xf1\x96\x02',
            struct.pack('<d', self.long),
            struct.pack('<d', self.lat),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _long = reader.read_double()
        _lat = reader.read_double()
        _access_hash = reader.read_long()
        return cls(long=_long, lat=_lat, access_hash=_access_hash)


class GeoPointEmpty(TLObject):
    CONSTRUCTOR_ID = 0x1117dd5f
    SUBCLASS_OF_ID = 0xd610e16d

    def to_dict(self):
        return {
            '_': 'GeoPointEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'_\xdd\x17\x11',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class HighScore(TLObject):
    CONSTRUCTOR_ID = 0x58fffcd0
    SUBCLASS_OF_ID = 0xd32b1e35

    def __init__(self, pos: int, user_id: int, score: int):
        """
        Constructor for HighScore: Instance of HighScore.
        """
        self.pos = pos
        self.user_id = user_id
        self.score = score

    def to_dict(self):
        return {
            '_': 'HighScore',
            'pos': self.pos,
            'user_id': self.user_id,
            'score': self.score
        }

    def __bytes__(self):
        return b''.join((
            b'\xd0\xfc\xffX',
            struct.pack('<i', self.pos),
            struct.pack('<i', self.user_id),
            struct.pack('<i', self.score),
        ))

    @classmethod
    def from_reader(cls, reader):
        _pos = reader.read_int()
        _user_id = reader.read_int()
        _score = reader.read_int()
        return cls(pos=_pos, user_id=_user_id, score=_score)


class HttpWait(TLObject):
    CONSTRUCTOR_ID = 0x9299359f
    SUBCLASS_OF_ID = 0x1284aed6

    def __init__(self, max_delay: int, wait_after: int, max_wait: int):
        """
        Constructor for HttpWait: Instance of HttpWait.
        """
        self.max_delay = max_delay
        self.wait_after = wait_after
        self.max_wait = max_wait

    def to_dict(self):
        return {
            '_': 'HttpWait',
            'max_delay': self.max_delay,
            'wait_after': self.wait_after,
            'max_wait': self.max_wait
        }

    def __bytes__(self):
        return b''.join((
            b'\x9f5\x99\x92',
            struct.pack('<i', self.max_delay),
            struct.pack('<i', self.wait_after),
            struct.pack('<i', self.max_wait),
        ))

    @classmethod
    def from_reader(cls, reader):
        _max_delay = reader.read_int()
        _wait_after = reader.read_int()
        _max_wait = reader.read_int()
        return cls(max_delay=_max_delay, wait_after=_wait_after, max_wait=_max_wait)


class ImportedContact(TLObject):
    CONSTRUCTOR_ID = 0xd0028438
    SUBCLASS_OF_ID = 0xb545bbda

    def __init__(self, user_id: int, client_id: int):
        """
        Constructor for ImportedContact: Instance of ImportedContact.
        """
        self.user_id = user_id
        self.client_id = client_id

    def to_dict(self):
        return {
            '_': 'ImportedContact',
            'user_id': self.user_id,
            'client_id': self.client_id
        }

    def __bytes__(self):
        return b''.join((
            b'8\x84\x02\xd0',
            struct.pack('<i', self.user_id),
            struct.pack('<q', self.client_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        _client_id = reader.read_long()
        return cls(user_id=_user_id, client_id=_client_id)


class InlineBotSwitchPM(TLObject):
    CONSTRUCTOR_ID = 0x3c20629f
    SUBCLASS_OF_ID = 0x82b1f73b

    def __init__(self, text: str, start_param: str):
        """
        Constructor for InlineBotSwitchPM: Instance of InlineBotSwitchPM.
        """
        self.text = text
        self.start_param = start_param

    def to_dict(self):
        return {
            '_': 'InlineBotSwitchPM',
            'text': self.text,
            'start_param': self.start_param
        }

    def __bytes__(self):
        return b''.join((
            b'\x9fb <',
            self.serialize_bytes(self.text),
            self.serialize_bytes(self.start_param),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        _start_param = reader.tgread_string()
        return cls(text=_text, start_param=_start_param)


class InputAppEvent(TLObject):
    CONSTRUCTOR_ID = 0x1d1b1245
    SUBCLASS_OF_ID = 0x89322106

    # noinspection PyShadowingBuiltins
    def __init__(self, time: float, type: str, peer: int, data: 'TypeJSONValue'):
        """
        Constructor for InputAppEvent: Instance of InputAppEvent.
        """
        self.time = time
        self.type = type
        self.peer = peer
        self.data = data

    def to_dict(self):
        return {
            '_': 'InputAppEvent',
            'time': self.time,
            'type': self.type,
            'peer': self.peer,
            'data': self.data.to_dict() if isinstance(self.data, TLObject) else self.data
        }

    def __bytes__(self):
        return b''.join((
            b'E\x12\x1b\x1d',
            struct.pack('<d', self.time),
            self.serialize_bytes(self.type),
            struct.pack('<q', self.peer),
            bytes(self.data),
        ))

    @classmethod
    def from_reader(cls, reader):
        _time = reader.read_double()
        _type = reader.tgread_string()
        _peer = reader.read_long()
        _data = reader.tgread_object()
        return cls(time=_time, type=_type, peer=_peer, data=_data)


class InputBotInlineMessageGame(TLObject):
    CONSTRUCTOR_ID = 0x4b425864
    SUBCLASS_OF_ID = 0x53fb4010

    def __init__(self, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame.
        """
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'InputBotInlineMessageGame',
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def __bytes__(self):
        return b''.join((
            b'dXBK',
            struct.pack('<I', (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            b'' if self.reply_markup is None or self.reply_markup is False else (bytes(self.reply_markup)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(reply_markup=_reply_markup)


class InputBotInlineMessageID(TLObject):
    CONSTRUCTOR_ID = 0x890c3d89
    SUBCLASS_OF_ID = 0x2dcd6300

    # noinspection PyShadowingBuiltins
    def __init__(self, dc_id: int, id: int, access_hash: int):
        """
        Constructor for InputBotInlineMessageID: Instance of InputBotInlineMessageID.
        """
        self.dc_id = dc_id
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputBotInlineMessageID',
            'dc_id': self.dc_id,
            'id': self.id,
            'access_hash': self.access_hash
        }

    def __bytes__(self):
        return b''.join((
            b'\x89=\x0c\x89',
            struct.pack('<i', self.dc_id),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _dc_id = reader.read_int()
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(dc_id=_dc_id, id=_id, access_hash=_access_hash)


class InputBotInlineMessageMediaAuto(TLObject):
    CONSTRUCTOR_ID = 0x3380c786
    SUBCLASS_OF_ID = 0x53fb4010

    def __init__(self, message: str, entities: Optional[List['TypeMessageEntity']]=None, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame.
        """
        self.message = message
        self.entities = entities
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'InputBotInlineMessageMediaAuto',
            'message': self.message,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities],
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def __bytes__(self):
        return b''.join((
            b'\x86\xc7\x803',
            struct.pack('<I', (0 if self.entities is None or self.entities is False else 2) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(bytes(x) for x in self.entities))),
            b'' if self.reply_markup is None or self.reply_markup is False else (bytes(self.reply_markup)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _message = reader.tgread_string()
        if flags & 2:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(message=_message, entities=_entities, reply_markup=_reply_markup)


class InputBotInlineMessageMediaContact(TLObject):
    CONSTRUCTOR_ID = 0xa6edbffd
    SUBCLASS_OF_ID = 0x53fb4010

    def __init__(self, phone_number: str, first_name: str, last_name: str, vcard: str, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame.
        """
        self.phone_number = phone_number
        self.first_name = first_name
        self.last_name = last_name
        self.vcard = vcard
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'InputBotInlineMessageMediaContact',
            'phone_number': self.phone_number,
            'first_name': self.first_name,
            'last_name': self.last_name,
            'vcard': self.vcard,
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def __bytes__(self):
        return b''.join((
            b'\xfd\xbf\xed\xa6',
            struct.pack('<I', (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.serialize_bytes(self.phone_number),
            self.serialize_bytes(self.first_name),
            self.serialize_bytes(self.last_name),
            self.serialize_bytes(self.vcard),
            b'' if self.reply_markup is None or self.reply_markup is False else (bytes(self.reply_markup)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _phone_number = reader.tgread_string()
        _first_name = reader.tgread_string()
        _last_name = reader.tgread_string()
        _vcard = reader.tgread_string()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(phone_number=_phone_number, first_name=_first_name, last_name=_last_name, vcard=_vcard, reply_markup=_reply_markup)


class InputBotInlineMessageMediaGeo(TLObject):
    CONSTRUCTOR_ID = 0xc1b15d65
    SUBCLASS_OF_ID = 0x53fb4010

    def __init__(self, geo_point: 'TypeInputGeoPoint', period: int, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame.
        """
        self.geo_point = geo_point
        self.period = period
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'InputBotInlineMessageMediaGeo',
            'geo_point': self.geo_point.to_dict() if isinstance(self.geo_point, TLObject) else self.geo_point,
            'period': self.period,
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def __bytes__(self):
        return b''.join((
            b'e]\xb1\xc1',
            struct.pack('<I', (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            bytes(self.geo_point),
            struct.pack('<i', self.period),
            b'' if self.reply_markup is None or self.reply_markup is False else (bytes(self.reply_markup)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _geo_point = reader.tgread_object()
        _period = reader.read_int()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(geo_point=_geo_point, period=_period, reply_markup=_reply_markup)


class InputBotInlineMessageMediaVenue(TLObject):
    CONSTRUCTOR_ID = 0x417bbf11
    SUBCLASS_OF_ID = 0x53fb4010

    def __init__(self, geo_point: 'TypeInputGeoPoint', title: str, address: str, provider: str, venue_id: str, venue_type: str, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame.
        """
        self.geo_point = geo_point
        self.title = title
        self.address = address
        self.provider = provider
        self.venue_id = venue_id
        self.venue_type = venue_type
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'InputBotInlineMessageMediaVenue',
            'geo_point': self.geo_point.to_dict() if isinstance(self.geo_point, TLObject) else self.geo_point,
            'title': self.title,
            'address': self.address,
            'provider': self.provider,
            'venue_id': self.venue_id,
            'venue_type': self.venue_type,
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def __bytes__(self):
        return b''.join((
            b'\x11\xbf{A',
            struct.pack('<I', (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            bytes(self.geo_point),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.address),
            self.serialize_bytes(self.provider),
            self.serialize_bytes(self.venue_id),
            self.serialize_bytes(self.venue_type),
            b'' if self.reply_markup is None or self.reply_markup is False else (bytes(self.reply_markup)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _geo_point = reader.tgread_object()
        _title = reader.tgread_string()
        _address = reader.tgread_string()
        _provider = reader.tgread_string()
        _venue_id = reader.tgread_string()
        _venue_type = reader.tgread_string()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(geo_point=_geo_point, title=_title, address=_address, provider=_provider, venue_id=_venue_id, venue_type=_venue_type, reply_markup=_reply_markup)


class InputBotInlineMessageText(TLObject):
    CONSTRUCTOR_ID = 0x3dcd7a87
    SUBCLASS_OF_ID = 0x53fb4010

    def __init__(self, message: str, no_webpage: Optional[bool]=None, entities: Optional[List['TypeMessageEntity']]=None, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame.
        """
        self.message = message
        self.no_webpage = no_webpage
        self.entities = entities
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'InputBotInlineMessageText',
            'message': self.message,
            'no_webpage': self.no_webpage,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities],
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def __bytes__(self):
        return b''.join((
            b'\x87z\xcd=',
            struct.pack('<I', (0 if self.no_webpage is None or self.no_webpage is False else 1) | (0 if self.entities is None or self.entities is False else 2) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(bytes(x) for x in self.entities))),
            b'' if self.reply_markup is None or self.reply_markup is False else (bytes(self.reply_markup)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _no_webpage = bool(flags & 1)
        _message = reader.tgread_string()
        if flags & 2:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(message=_message, no_webpage=_no_webpage, entities=_entities, reply_markup=_reply_markup)


class InputBotInlineResult(TLObject):
    CONSTRUCTOR_ID = 0x88bf9319
    SUBCLASS_OF_ID = 0x80a4a3de

    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, type: str, send_message: 'TypeInputBotInlineMessage', title: Optional[str]=None, description: Optional[str]=None, url: Optional[str]=None, thumb: Optional['TypeInputWebDocument']=None, content: Optional['TypeInputWebDocument']=None):
        """
        Constructor for InputBotInlineResult: Instance of either InputBotInlineResult, InputBotInlineResultPhoto, InputBotInlineResultDocument, InputBotInlineResultGame.
        """
        self.id = id
        self.type = type
        self.send_message = send_message
        self.title = title
        self.description = description
        self.url = url
        self.thumb = thumb
        self.content = content

    def to_dict(self):
        return {
            '_': 'InputBotInlineResult',
            'id': self.id,
            'type': self.type,
            'send_message': self.send_message.to_dict() if isinstance(self.send_message, TLObject) else self.send_message,
            'title': self.title,
            'description': self.description,
            'url': self.url,
            'thumb': self.thumb.to_dict() if isinstance(self.thumb, TLObject) else self.thumb,
            'content': self.content.to_dict() if isinstance(self.content, TLObject) else self.content
        }

    def __bytes__(self):
        return b''.join((
            b'\x19\x93\xbf\x88',
            struct.pack('<I', (0 if self.title is None or self.title is False else 2) | (0 if self.description is None or self.description is False else 4) | (0 if self.url is None or self.url is False else 8) | (0 if self.thumb is None or self.thumb is False else 16) | (0 if self.content is None or self.content is False else 32)),
            self.serialize_bytes(self.id),
            self.serialize_bytes(self.type),
            b'' if self.title is None or self.title is False else (self.serialize_bytes(self.title)),
            b'' if self.description is None or self.description is False else (self.serialize_bytes(self.description)),
            b'' if self.url is None or self.url is False else (self.serialize_bytes(self.url)),
            b'' if self.thumb is None or self.thumb is False else (bytes(self.thumb)),
            b'' if self.content is None or self.content is False else (bytes(self.content)),
            bytes(self.send_message),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.tgread_string()
        _type = reader.tgread_string()
        if flags & 2:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 4:
            _description = reader.tgread_string()
        else:
            _description = None
        if flags & 8:
            _url = reader.tgread_string()
        else:
            _url = None
        if flags & 16:
            _thumb = reader.tgread_object()
        else:
            _thumb = None
        if flags & 32:
            _content = reader.tgread_object()
        else:
            _content = None
        _send_message = reader.tgread_object()
        return cls(id=_id, type=_type, send_message=_send_message, title=_title, description=_description, url=_url, thumb=_thumb, content=_content)


class InputBotInlineResultDocument(TLObject):
    CONSTRUCTOR_ID = 0xfff8fdc4
    SUBCLASS_OF_ID = 0x80a4a3de

    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, type: str, document: 'TypeInputDocument', send_message: 'TypeInputBotInlineMessage', title: Optional[str]=None, description: Optional[str]=None):
        """
        Constructor for InputBotInlineResult: Instance of either InputBotInlineResult, InputBotInlineResultPhoto, InputBotInlineResultDocument, InputBotInlineResultGame.
        """
        self.id = id
        self.type = type
        self.document = document
        self.send_message = send_message
        self.title = title
        self.description = description

    def to_dict(self):
        return {
            '_': 'InputBotInlineResultDocument',
            'id': self.id,
            'type': self.type,
            'document': self.document.to_dict() if isinstance(self.document, TLObject) else self.document,
            'send_message': self.send_message.to_dict() if isinstance(self.send_message, TLObject) else self.send_message,
            'title': self.title,
            'description': self.description
        }

    def __bytes__(self):
        return b''.join((
            b'\xc4\xfd\xf8\xff',
            struct.pack('<I', (0 if self.title is None or self.title is False else 2) | (0 if self.description is None or self.description is False else 4)),
            self.serialize_bytes(self.id),
            self.serialize_bytes(self.type),
            b'' if self.title is None or self.title is False else (self.serialize_bytes(self.title)),
            b'' if self.description is None or self.description is False else (self.serialize_bytes(self.description)),
            bytes(self.document),
            bytes(self.send_message),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.tgread_string()
        _type = reader.tgread_string()
        if flags & 2:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 4:
            _description = reader.tgread_string()
        else:
            _description = None
        _document = reader.tgread_object()
        _send_message = reader.tgread_object()
        return cls(id=_id, type=_type, document=_document, send_message=_send_message, title=_title, description=_description)


class InputBotInlineResultGame(TLObject):
    CONSTRUCTOR_ID = 0x4fa417f2
    SUBCLASS_OF_ID = 0x80a4a3de

    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, short_name: str, send_message: 'TypeInputBotInlineMessage'):
        """
        Constructor for InputBotInlineResult: Instance of either InputBotInlineResult, InputBotInlineResultPhoto, InputBotInlineResultDocument, InputBotInlineResultGame.
        """
        self.id = id
        self.short_name = short_name
        self.send_message = send_message

    def to_dict(self):
        return {
            '_': 'InputBotInlineResultGame',
            'id': self.id,
            'short_name': self.short_name,
            'send_message': self.send_message.to_dict() if isinstance(self.send_message, TLObject) else self.send_message
        }

    def __bytes__(self):
        return b''.join((
            b'\xf2\x17\xa4O',
            self.serialize_bytes(self.id),
            self.serialize_bytes(self.short_name),
            bytes(self.send_message),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_string()
        _short_name = reader.tgread_string()
        _send_message = reader.tgread_object()
        return cls(id=_id, short_name=_short_name, send_message=_send_message)


class InputBotInlineResultPhoto(TLObject):
    CONSTRUCTOR_ID = 0xa8d864a7
    SUBCLASS_OF_ID = 0x80a4a3de

    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, type: str, photo: 'TypeInputPhoto', send_message: 'TypeInputBotInlineMessage'):
        """
        Constructor for InputBotInlineResult: Instance of either InputBotInlineResult, InputBotInlineResultPhoto, InputBotInlineResultDocument, InputBotInlineResultGame.
        """
        self.id = id
        self.type = type
        self.photo = photo
        self.send_message = send_message

    def to_dict(self):
        return {
            '_': 'InputBotInlineResultPhoto',
            'id': self.id,
            'type': self.type,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'send_message': self.send_message.to_dict() if isinstance(self.send_message, TLObject) else self.send_message
        }

    def __bytes__(self):
        return b''.join((
            b'\xa7d\xd8\xa8',
            self.serialize_bytes(self.id),
            self.serialize_bytes(self.type),
            bytes(self.photo),
            bytes(self.send_message),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_string()
        _type = reader.tgread_string()
        _photo = reader.tgread_object()
        _send_message = reader.tgread_object()
        return cls(id=_id, type=_type, photo=_photo, send_message=_send_message)


class InputChannel(TLObject):
    CONSTRUCTOR_ID = 0xafeb712e
    SUBCLASS_OF_ID = 0x40f202fd

    def __init__(self, channel_id: int, access_hash: int):
        """
        Constructor for InputChannel: Instance of either InputChannelEmpty, InputChannel, InputChannelFromMessage.
        """
        self.channel_id = channel_id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputChannel',
            'channel_id': self.channel_id,
            'access_hash': self.access_hash
        }

    def __bytes__(self):
        return b''.join((
            b'.q\xeb\xaf',
            struct.pack('<i', self.channel_id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel_id = reader.read_int()
        _access_hash = reader.read_long()
        return cls(channel_id=_channel_id, access_hash=_access_hash)


class InputChannelEmpty(TLObject):
    CONSTRUCTOR_ID = 0xee8c1e86
    SUBCLASS_OF_ID = 0x40f202fd

    def to_dict(self):
        return {
            '_': 'InputChannelEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'\x86\x1e\x8c\xee',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputChannelFromMessage(TLObject):
    CONSTRUCTOR_ID = 0x2a286531
    SUBCLASS_OF_ID = 0x40f202fd

    def __init__(self, peer: 'TypeInputPeer', msg_id: int, channel_id: int):
        """
        Constructor for InputChannel: Instance of either InputChannelEmpty, InputChannel, InputChannelFromMessage.
        """
        self.peer = peer
        self.msg_id = msg_id
        self.channel_id = channel_id

    def to_dict(self):
        return {
            '_': 'InputChannelFromMessage',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'msg_id': self.msg_id,
            'channel_id': self.channel_id
        }

    def __bytes__(self):
        return b''.join((
            b'1e(*',
            bytes(self.peer),
            struct.pack('<i', self.msg_id),
            struct.pack('<i', self.channel_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        _channel_id = reader.read_int()
        return cls(peer=_peer, msg_id=_msg_id, channel_id=_channel_id)


class InputChatPhoto(TLObject):
    CONSTRUCTOR_ID = 0x8953ad37
    SUBCLASS_OF_ID = 0xd4eb2d74

    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputPhoto'):
        """
        Constructor for InputChatPhoto: Instance of either InputChatPhotoEmpty, InputChatUploadedPhoto, InputChatPhoto.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'InputChatPhoto',
            'id': self.id.to_dict() if isinstance(self.id, TLObject) else self.id
        }

    def __bytes__(self):
        return b''.join((
            b'7\xadS\x89',
            bytes(self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_object()
        return cls(id=_id)


class InputChatPhotoEmpty(TLObject):
    CONSTRUCTOR_ID = 0x1ca48f57
    SUBCLASS_OF_ID = 0xd4eb2d74

    def to_dict(self):
        return {
            '_': 'InputChatPhotoEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'W\x8f\xa4\x1c',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputChatUploadedPhoto(TLObject):
    CONSTRUCTOR_ID = 0x927c55b4
    SUBCLASS_OF_ID = 0xd4eb2d74

    def __init__(self, file: 'TypeInputFile'):
        """
        Constructor for InputChatPhoto: Instance of either InputChatPhotoEmpty, InputChatUploadedPhoto, InputChatPhoto.
        """
        self.file = file

    def to_dict(self):
        return {
            '_': 'InputChatUploadedPhoto',
            'file': self.file.to_dict() if isinstance(self.file, TLObject) else self.file
        }

    def __bytes__(self):
        return b''.join((
            b'\xb4U|\x92',
            bytes(self.file),
        ))

    @classmethod
    def from_reader(cls, reader):
        _file = reader.tgread_object()
        return cls(file=_file)


class InputCheckPasswordEmpty(TLObject):
    CONSTRUCTOR_ID = 0x9880f658
    SUBCLASS_OF_ID = 0xd41af560

    def to_dict(self):
        return {
            '_': 'InputCheckPasswordEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'X\xf6\x80\x98',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputCheckPasswordSRP(TLObject):
    CONSTRUCTOR_ID = 0xd27ff082
    SUBCLASS_OF_ID = 0xd41af560

    def __init__(self, srp_id: int, A: bytes, M1: bytes):
        """
        Constructor for InputCheckPasswordSRP: Instance of either InputCheckPasswordEmpty, InputCheckPasswordSRP.
        """
        self.srp_id = srp_id
        self.A = A
        self.M1 = M1

    def to_dict(self):
        return {
            '_': 'InputCheckPasswordSRP',
            'srp_id': self.srp_id,
            'A': self.A,
            'M1': self.M1
        }

    def __bytes__(self):
        return b''.join((
            b'\x82\xf0\x7f\xd2',
            struct.pack('<q', self.srp_id),
            self.serialize_bytes(self.A),
            self.serialize_bytes(self.M1),
        ))

    @classmethod
    def from_reader(cls, reader):
        _srp_id = reader.read_long()
        _A = reader.tgread_bytes()
        _M1 = reader.tgread_bytes()
        return cls(srp_id=_srp_id, A=_A, M1=_M1)


class InputClientProxy(TLObject):
    CONSTRUCTOR_ID = 0x75588b3f
    SUBCLASS_OF_ID = 0x91a4346

    def __init__(self, address: str, port: int):
        """
        Constructor for InputClientProxy: Instance of InputClientProxy.
        """
        self.address = address
        self.port = port

    def to_dict(self):
        return {
            '_': 'InputClientProxy',
            'address': self.address,
            'port': self.port
        }

    def __bytes__(self):
        return b''.join((
            b'?\x8bXu',
            self.serialize_bytes(self.address),
            struct.pack('<i', self.port),
        ))

    @classmethod
    def from_reader(cls, reader):
        _address = reader.tgread_string()
        _port = reader.read_int()
        return cls(address=_address, port=_port)


class InputDialogPeer(TLObject):
    CONSTRUCTOR_ID = 0xfcaafeb7
    SUBCLASS_OF_ID = 0xa21c9795

    def __init__(self, peer: 'TypeInputPeer'):
        """
        Constructor for InputDialogPeer: Instance of either InputDialogPeer, InputDialogPeerFolder.
        """
        self.peer = peer

    def to_dict(self):
        return {
            '_': 'InputDialogPeer',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def __bytes__(self):
        return b''.join((
            b'\xb7\xfe\xaa\xfc',
            bytes(self.peer),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


class InputDialogPeerFolder(TLObject):
    CONSTRUCTOR_ID = 0x64600527
    SUBCLASS_OF_ID = 0xa21c9795

    def __init__(self, folder_id: int):
        """
        Constructor for InputDialogPeer: Instance of either InputDialogPeer, InputDialogPeerFolder.
        """
        self.folder_id = folder_id

    def to_dict(self):
        return {
            '_': 'InputDialogPeerFolder',
            'folder_id': self.folder_id
        }

    def __bytes__(self):
        return b''.join((
            b"'\x05`d",
            struct.pack('<i', self.folder_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _folder_id = reader.read_int()
        return cls(folder_id=_folder_id)


class InputDocument(TLObject):
    CONSTRUCTOR_ID = 0x1abfb575
    SUBCLASS_OF_ID = 0xf33fdb68

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, file_reference: bytes):
        """
        Constructor for InputDocument: Instance of either InputDocumentEmpty, InputDocument.
        """
        self.id = id
        self.access_hash = access_hash
        self.file_reference = file_reference

    def to_dict(self):
        return {
            '_': 'InputDocument',
            'id': self.id,
            'access_hash': self.access_hash,
            'file_reference': self.file_reference
        }

    def __bytes__(self):
        return b''.join((
            b'u\xb5\xbf\x1a',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_bytes(self.file_reference),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _file_reference = reader.tgread_bytes()
        return cls(id=_id, access_hash=_access_hash, file_reference=_file_reference)


class InputDocumentEmpty(TLObject):
    CONSTRUCTOR_ID = 0x72f0eaae
    SUBCLASS_OF_ID = 0xf33fdb68

    def to_dict(self):
        return {
            '_': 'InputDocumentEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'\xae\xea\xf0r',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputDocumentFileLocation(TLObject):
    CONSTRUCTOR_ID = 0xbad07584
    SUBCLASS_OF_ID = 0x1523d462

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, file_reference: bytes, thumb_size: str):
        """
        Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb.
        """
        self.id = id
        self.access_hash = access_hash
        self.file_reference = file_reference
        self.thumb_size = thumb_size

    def to_dict(self):
        return {
            '_': 'InputDocumentFileLocation',
            'id': self.id,
            'access_hash': self.access_hash,
            'file_reference': self.file_reference,
            'thumb_size': self.thumb_size
        }

    def __bytes__(self):
        return b''.join((
            b'\x84u\xd0\xba',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_bytes(self.file_reference),
            self.serialize_bytes(self.thumb_size),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _file_reference = reader.tgread_bytes()
        _thumb_size = reader.tgread_string()
        return cls(id=_id, access_hash=_access_hash, file_reference=_file_reference, thumb_size=_thumb_size)


class InputEncryptedChat(TLObject):
    CONSTRUCTOR_ID = 0xf141b5e1
    SUBCLASS_OF_ID = 0x6c7606c0

    def __init__(self, chat_id: int, access_hash: int):
        """
        Constructor for InputEncryptedChat: Instance of InputEncryptedChat.
        """
        self.chat_id = chat_id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputEncryptedChat',
            'chat_id': self.chat_id,
            'access_hash': self.access_hash
        }

    def __bytes__(self):
        return b''.join((
            b'\xe1\xb5A\xf1',
            struct.pack('<i', self.chat_id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_int()
        _access_hash = reader.read_long()
        return cls(chat_id=_chat_id, access_hash=_access_hash)


class InputEncryptedFile(TLObject):
    CONSTRUCTOR_ID = 0x5a17b5e5
    SUBCLASS_OF_ID = 0x8574c27a

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        """
        Constructor for InputEncryptedFile: Instance of either InputEncryptedFileEmpty, InputEncryptedFileUploaded, InputEncryptedFile, InputEncryptedFileBigUploaded.
        """
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputEncryptedFile',
            'id': self.id,
            'access_hash': self.access_hash
        }

    def __bytes__(self):
        return b''.join((
            b'\xe5\xb5\x17Z',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


class InputEncryptedFileBigUploaded(TLObject):
    CONSTRUCTOR_ID = 0x2dc173c8
    SUBCLASS_OF_ID = 0x8574c27a

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, parts: int, key_fingerprint: int):
        """
        Constructor for InputEncryptedFile: Instance of either InputEncryptedFileEmpty, InputEncryptedFileUploaded, InputEncryptedFile, InputEncryptedFileBigUploaded.
        """
        self.id = id
        self.parts = parts
        self.key_fingerprint = key_fingerprint

    def to_dict(self):
        return {
            '_': 'InputEncryptedFileBigUploaded',
            'id': self.id,
            'parts': self.parts,
            'key_fingerprint': self.key_fingerprint
        }

    def __bytes__(self):
        return b''.join((
            b'\xc8s\xc1-',
            struct.pack('<q', self.id),
            struct.pack('<i', self.parts),
            struct.pack('<i', self.key_fingerprint),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _parts = reader.read_int()
        _key_fingerprint = reader.read_int()
        return cls(id=_id, parts=_parts, key_fingerprint=_key_fingerprint)


class InputEncryptedFileEmpty(TLObject):
    CONSTRUCTOR_ID = 0x1837c364
    SUBCLASS_OF_ID = 0x8574c27a

    def to_dict(self):
        return {
            '_': 'InputEncryptedFileEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'd\xc37\x18',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputEncryptedFileLocation(TLObject):
    CONSTRUCTOR_ID = 0xf5235d55
    SUBCLASS_OF_ID = 0x1523d462

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        """
        Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb.
        """
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputEncryptedFileLocation',
            'id': self.id,
            'access_hash': self.access_hash
        }

    def __bytes__(self):
        return b''.join((
            b'U]#\xf5',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


class InputEncryptedFileUploaded(TLObject):
    CONSTRUCTOR_ID = 0x64bd0306
    SUBCLASS_OF_ID = 0x8574c27a

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, parts: int, md5_checksum: str, key_fingerprint: int):
        """
        Constructor for InputEncryptedFile: Instance of either InputEncryptedFileEmpty, InputEncryptedFileUploaded, InputEncryptedFile, InputEncryptedFileBigUploaded.
        """
        self.id = id
        self.parts = parts
        self.md5_checksum = md5_checksum
        self.key_fingerprint = key_fingerprint

    def to_dict(self):
        return {
            '_': 'InputEncryptedFileUploaded',
            'id': self.id,
            'parts': self.parts,
            'md5_checksum': self.md5_checksum,
            'key_fingerprint': self.key_fingerprint
        }

    def __bytes__(self):
        return b''.join((
            b'\x06\x03\xbdd',
            struct.pack('<q', self.id),
            struct.pack('<i', self.parts),
            self.serialize_bytes(self.md5_checksum),
            struct.pack('<i', self.key_fingerprint),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _parts = reader.read_int()
        _md5_checksum = reader.tgread_string()
        _key_fingerprint = reader.read_int()
        return cls(id=_id, parts=_parts, md5_checksum=_md5_checksum, key_fingerprint=_key_fingerprint)


class InputFile(TLObject):
    CONSTRUCTOR_ID = 0xf52ff27f
    SUBCLASS_OF_ID = 0xe7655f1f

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, parts: int, name: str, md5_checksum: str):
        """
        Constructor for InputFile: Instance of either InputFile, InputFileBig.
        """
        self.id = id
        self.parts = parts
        self.name = name
        self.md5_checksum = md5_checksum

    def to_dict(self):
        return {
            '_': 'InputFile',
            'id': self.id,
            'parts': self.parts,
            'name': self.name,
            'md5_checksum': self.md5_checksum
        }

    def __bytes__(self):
        return b''.join((
            b'\x7f\xf2/\xf5',
            struct.pack('<q', self.id),
            struct.pack('<i', self.parts),
            self.serialize_bytes(self.name),
            self.serialize_bytes(self.md5_checksum),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _parts = reader.read_int()
        _name = reader.tgread_string()
        _md5_checksum = reader.tgread_string()
        return cls(id=_id, parts=_parts, name=_name, md5_checksum=_md5_checksum)


class InputFileBig(TLObject):
    CONSTRUCTOR_ID = 0xfa4f0bb5
    SUBCLASS_OF_ID = 0xe7655f1f

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, parts: int, name: str):
        """
        Constructor for InputFile: Instance of either InputFile, InputFileBig.
        """
        self.id = id
        self.parts = parts
        self.name = name

    def to_dict(self):
        return {
            '_': 'InputFileBig',
            'id': self.id,
            'parts': self.parts,
            'name': self.name
        }

    def __bytes__(self):
        return b''.join((
            b'\xb5\x0bO\xfa',
            struct.pack('<q', self.id),
            struct.pack('<i', self.parts),
            self.serialize_bytes(self.name),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _parts = reader.read_int()
        _name = reader.tgread_string()
        return cls(id=_id, parts=_parts, name=_name)


class InputFileLocation(TLObject):
    CONSTRUCTOR_ID = 0xdfdaabe1
    SUBCLASS_OF_ID = 0x1523d462

    def __init__(self, volume_id: int, local_id: int, secret: int, file_reference: bytes):
        """
        Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb.
        """
        self.volume_id = volume_id
        self.local_id = local_id
        self.secret = secret
        self.file_reference = file_reference

    def to_dict(self):
        return {
            '_': 'InputFileLocation',
            'volume_id': self.volume_id,
            'local_id': self.local_id,
            'secret': self.secret,
            'file_reference': self.file_reference
        }

    def __bytes__(self):
        return b''.join((
            b'\xe1\xab\xda\xdf',
            struct.pack('<q', self.volume_id),
            struct.pack('<i', self.local_id),
            struct.pack('<q', self.secret),
            self.serialize_bytes(self.file_reference),
        ))

    @classmethod
    def from_reader(cls, reader):
        _volume_id = reader.read_long()
        _local_id = reader.read_int()
        _secret = reader.read_long()
        _file_reference = reader.tgread_bytes()
        return cls(volume_id=_volume_id, local_id=_local_id, secret=_secret, file_reference=_file_reference)


class InputFolderPeer(TLObject):
    CONSTRUCTOR_ID = 0xfbd2c296
    SUBCLASS_OF_ID = 0x74825e00

    def __init__(self, peer: 'TypeInputPeer', folder_id: int):
        """
        Constructor for InputFolderPeer: Instance of InputFolderPeer.
        """
        self.peer = peer
        self.folder_id = folder_id

    def to_dict(self):
        return {
            '_': 'InputFolderPeer',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'folder_id': self.folder_id
        }

    def __bytes__(self):
        return b''.join((
            b'\x96\xc2\xd2\xfb',
            bytes(self.peer),
            struct.pack('<i', self.folder_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _folder_id = reader.read_int()
        return cls(peer=_peer, folder_id=_folder_id)


class InputGameID(TLObject):
    CONSTRUCTOR_ID = 0x32c3e77
    SUBCLASS_OF_ID = 0x48d15883

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        """
        Constructor for InputGame: Instance of either InputGameID, InputGameShortName.
        """
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputGameID',
            'id': self.id,
            'access_hash': self.access_hash
        }

    def __bytes__(self):
        return b''.join((
            b'w>,\x03',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


class InputGameShortName(TLObject):
    CONSTRUCTOR_ID = 0xc331e80a
    SUBCLASS_OF_ID = 0x48d15883

    def __init__(self, bot_id: 'TypeInputUser', short_name: str):
        """
        Constructor for InputGame: Instance of either InputGameID, InputGameShortName.
        """
        self.bot_id = bot_id
        self.short_name = short_name

    def to_dict(self):
        return {
            '_': 'InputGameShortName',
            'bot_id': self.bot_id.to_dict() if isinstance(self.bot_id, TLObject) else self.bot_id,
            'short_name': self.short_name
        }

    def __bytes__(self):
        return b''.join((
            b'\n\xe81\xc3',
            bytes(self.bot_id),
            self.serialize_bytes(self.short_name),
        ))

    @classmethod
    def from_reader(cls, reader):
        _bot_id = reader.tgread_object()
        _short_name = reader.tgread_string()
        return cls(bot_id=_bot_id, short_name=_short_name)


class InputGeoPoint(TLObject):
    CONSTRUCTOR_ID = 0xf3b7acc9
    SUBCLASS_OF_ID = 0x430d225

    def __init__(self, lat: float, long: float):
        """
        Constructor for InputGeoPoint: Instance of either InputGeoPointEmpty, InputGeoPoint.
        """
        self.lat = lat
        self.long = long

    def to_dict(self):
        return {
            '_': 'InputGeoPoint',
            'lat': self.lat,
            'long': self.long
        }

    def __bytes__(self):
        return b''.join((
            b'\xc9\xac\xb7\xf3',
            struct.pack('<d', self.lat),
            struct.pack('<d', self.long),
        ))

    @classmethod
    def from_reader(cls, reader):
        _lat = reader.read_double()
        _long = reader.read_double()
        return cls(lat=_lat, long=_long)


class InputGeoPointEmpty(TLObject):
    CONSTRUCTOR_ID = 0xe4c123d6
    SUBCLASS_OF_ID = 0x430d225

    def to_dict(self):
        return {
            '_': 'InputGeoPointEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'\xd6#\xc1\xe4',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputKeyboardButtonUrlAuth(TLObject):
    CONSTRUCTOR_ID = 0xd02e7fd4
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str, url: str, bot: 'TypeInputUser', request_write_access: Optional[bool]=None, fwd_text: Optional[str]=None):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth.
        """
        self.text = text
        self.url = url
        self.bot = bot
        self.request_write_access = request_write_access
        self.fwd_text = fwd_text

    def to_dict(self):
        return {
            '_': 'InputKeyboardButtonUrlAuth',
            'text': self.text,
            'url': self.url,
            'bot': self.bot.to_dict() if isinstance(self.bot, TLObject) else self.bot,
            'request_write_access': self.request_write_access,
            'fwd_text': self.fwd_text
        }

    def __bytes__(self):
        return b''.join((
            b'\xd4\x7f.\xd0',
            struct.pack('<I', (0 if self.request_write_access is None or self.request_write_access is False else 1) | (0 if self.fwd_text is None or self.fwd_text is False else 2)),
            self.serialize_bytes(self.text),
            b'' if self.fwd_text is None or self.fwd_text is False else (self.serialize_bytes(self.fwd_text)),
            self.serialize_bytes(self.url),
            bytes(self.bot),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _request_write_access = bool(flags & 1)
        _text = reader.tgread_string()
        if flags & 2:
            _fwd_text = reader.tgread_string()
        else:
            _fwd_text = None
        _url = reader.tgread_string()
        _bot = reader.tgread_object()
        return cls(text=_text, url=_url, bot=_bot, request_write_access=_request_write_access, fwd_text=_fwd_text)


class InputMediaContact(TLObject):
    CONSTRUCTOR_ID = 0xf8ab7dfb
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, phone_number: str, first_name: str, last_name: str, vcard: str):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaGifExternal, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll.
        """
        self.phone_number = phone_number
        self.first_name = first_name
        self.last_name = last_name
        self.vcard = vcard

    def to_dict(self):
        return {
            '_': 'InputMediaContact',
            'phone_number': self.phone_number,
            'first_name': self.first_name,
            'last_name': self.last_name,
            'vcard': self.vcard
        }

    def __bytes__(self):
        return b''.join((
            b'\xfb}\xab\xf8',
            self.serialize_bytes(self.phone_number),
            self.serialize_bytes(self.first_name),
            self.serialize_bytes(self.last_name),
            self.serialize_bytes(self.vcard),
        ))

    @classmethod
    def from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _first_name = reader.tgread_string()
        _last_name = reader.tgread_string()
        _vcard = reader.tgread_string()
        return cls(phone_number=_phone_number, first_name=_first_name, last_name=_last_name, vcard=_vcard)


class InputMediaDocument(TLObject):
    CONSTRUCTOR_ID = 0x23ab23d2
    SUBCLASS_OF_ID = 0xfaf846f4

    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputDocument', ttl_seconds: Optional[int]=None):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaGifExternal, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll.
        """
        self.id = id
        self.ttl_seconds = ttl_seconds

    def to_dict(self):
        return {
            '_': 'InputMediaDocument',
            'id': self.id.to_dict() if isinstance(self.id, TLObject) else self.id,
            'ttl_seconds': self.ttl_seconds
        }

    def __bytes__(self):
        return b''.join((
            b'\xd2#\xab#',
            struct.pack('<I', (0 if self.ttl_seconds is None or self.ttl_seconds is False else 1)),
            bytes(self.id),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.tgread_object()
        if flags & 1:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(id=_id, ttl_seconds=_ttl_seconds)


class InputMediaDocumentExternal(TLObject):
    CONSTRUCTOR_ID = 0xfb52dc99
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, url: str, ttl_seconds: Optional[int]=None):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaGifExternal, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll.
        """
        self.url = url
        self.ttl_seconds = ttl_seconds

    def to_dict(self):
        return {
            '_': 'InputMediaDocumentExternal',
            'url': self.url,
            'ttl_seconds': self.ttl_seconds
        }

    def __bytes__(self):
        return b''.join((
            b'\x99\xdcR\xfb',
            struct.pack('<I', (0 if self.ttl_seconds is None or self.ttl_seconds is False else 1)),
            self.serialize_bytes(self.url),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _url = reader.tgread_string()
        if flags & 1:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(url=_url, ttl_seconds=_ttl_seconds)


class InputMediaEmpty(TLObject):
    CONSTRUCTOR_ID = 0x9664f57f
    SUBCLASS_OF_ID = 0xfaf846f4

    def to_dict(self):
        return {
            '_': 'InputMediaEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'\x7f\xf5d\x96',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMediaGame(TLObject):
    CONSTRUCTOR_ID = 0xd33f43f3
    SUBCLASS_OF_ID = 0xfaf846f4

    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputGame'):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaGifExternal, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'InputMediaGame',
            'id': self.id.to_dict() if isinstance(self.id, TLObject) else self.id
        }

    def __bytes__(self):
        return b''.join((
            b'\xf3C?\xd3',
            bytes(self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_object()
        return cls(id=_id)


class InputMediaGeoLive(TLObject):
    CONSTRUCTOR_ID = 0xce4e82fd
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, geo_point: 'TypeInputGeoPoint', stopped: Optional[bool]=None, period: Optional[int]=None):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaGifExternal, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll.
        """
        self.geo_point = geo_point
        self.stopped = stopped
        self.period = period

    def to_dict(self):
        return {
            '_': 'InputMediaGeoLive',
            'geo_point': self.geo_point.to_dict() if isinstance(self.geo_point, TLObject) else self.geo_point,
            'stopped': self.stopped,
            'period': self.period
        }

    def __bytes__(self):
        return b''.join((
            b'\xfd\x82N\xce',
            struct.pack('<I', (0 if self.stopped is None or self.stopped is False else 1) | (0 if self.period is None or self.period is False else 2)),
            bytes(self.geo_point),
            b'' if self.period is None or self.period is False else (struct.pack('<i', self.period)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _stopped = bool(flags & 1)
        _geo_point = reader.tgread_object()
        if flags & 2:
            _period = reader.read_int()
        else:
            _period = None
        return cls(geo_point=_geo_point, stopped=_stopped, period=_period)


class InputMediaGeoPoint(TLObject):
    CONSTRUCTOR_ID = 0xf9c44144
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, geo_point: 'TypeInputGeoPoint'):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaGifExternal, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll.
        """
        self.geo_point = geo_point

    def to_dict(self):
        return {
            '_': 'InputMediaGeoPoint',
            'geo_point': self.geo_point.to_dict() if isinstance(self.geo_point, TLObject) else self.geo_point
        }

    def __bytes__(self):
        return b''.join((
            b'DA\xc4\xf9',
            bytes(self.geo_point),
        ))

    @classmethod
    def from_reader(cls, reader):
        _geo_point = reader.tgread_object()
        return cls(geo_point=_geo_point)


class InputMediaGifExternal(TLObject):
    CONSTRUCTOR_ID = 0x4843b0fd
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, url: str, q: str):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaGifExternal, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll.
        """
        self.url = url
        self.q = q

    def to_dict(self):
        return {
            '_': 'InputMediaGifExternal',
            'url': self.url,
            'q': self.q
        }

    def __bytes__(self):
        return b''.join((
            b'\xfd\xb0CH',
            self.serialize_bytes(self.url),
            self.serialize_bytes(self.q),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        _q = reader.tgread_string()
        return cls(url=_url, q=_q)


class InputMediaInvoice(TLObject):
    CONSTRUCTOR_ID = 0xf4e096c3
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, title: str, description: str, invoice: 'TypeInvoice', payload: bytes, provider: str, provider_data: 'TypeDataJSON', start_param: str, photo: Optional['TypeInputWebDocument']=None):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaGifExternal, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll.
        """
        self.title = title
        self.description = description
        self.invoice = invoice
        self.payload = payload
        self.provider = provider
        self.provider_data = provider_data
        self.start_param = start_param
        self.photo = photo

    def to_dict(self):
        return {
            '_': 'InputMediaInvoice',
            'title': self.title,
            'description': self.description,
            'invoice': self.invoice.to_dict() if isinstance(self.invoice, TLObject) else self.invoice,
            'payload': self.payload,
            'provider': self.provider,
            'provider_data': self.provider_data.to_dict() if isinstance(self.provider_data, TLObject) else self.provider_data,
            'start_param': self.start_param,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo
        }

    def __bytes__(self):
        return b''.join((
            b'\xc3\x96\xe0\xf4',
            struct.pack('<I', (0 if self.photo is None or self.photo is False else 1)),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.description),
            b'' if self.photo is None or self.photo is False else (bytes(self.photo)),
            bytes(self.invoice),
            self.serialize_bytes(self.payload),
            self.serialize_bytes(self.provider),
            bytes(self.provider_data),
            self.serialize_bytes(self.start_param),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _title = reader.tgread_string()
        _description = reader.tgread_string()
        if flags & 1:
            _photo = reader.tgread_object()
        else:
            _photo = None
        _invoice = reader.tgread_object()
        _payload = reader.tgread_bytes()
        _provider = reader.tgread_string()
        _provider_data = reader.tgread_object()
        _start_param = reader.tgread_string()
        return cls(title=_title, description=_description, invoice=_invoice, payload=_payload, provider=_provider, provider_data=_provider_data, start_param=_start_param, photo=_photo)


class InputMediaPhoto(TLObject):
    CONSTRUCTOR_ID = 0xb3ba0635
    SUBCLASS_OF_ID = 0xfaf846f4

    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputPhoto', ttl_seconds: Optional[int]=None):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaGifExternal, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll.
        """
        self.id = id
        self.ttl_seconds = ttl_seconds

    def to_dict(self):
        return {
            '_': 'InputMediaPhoto',
            'id': self.id.to_dict() if isinstance(self.id, TLObject) else self.id,
            'ttl_seconds': self.ttl_seconds
        }

    def __bytes__(self):
        return b''.join((
            b'5\x06\xba\xb3',
            struct.pack('<I', (0 if self.ttl_seconds is None or self.ttl_seconds is False else 1)),
            bytes(self.id),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.tgread_object()
        if flags & 1:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(id=_id, ttl_seconds=_ttl_seconds)


class InputMediaPhotoExternal(TLObject):
    CONSTRUCTOR_ID = 0xe5bbfe1a
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, url: str, ttl_seconds: Optional[int]=None):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaGifExternal, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll.
        """
        self.url = url
        self.ttl_seconds = ttl_seconds

    def to_dict(self):
        return {
            '_': 'InputMediaPhotoExternal',
            'url': self.url,
            'ttl_seconds': self.ttl_seconds
        }

    def __bytes__(self):
        return b''.join((
            b'\x1a\xfe\xbb\xe5',
            struct.pack('<I', (0 if self.ttl_seconds is None or self.ttl_seconds is False else 1)),
            self.serialize_bytes(self.url),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _url = reader.tgread_string()
        if flags & 1:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(url=_url, ttl_seconds=_ttl_seconds)


class InputMediaPoll(TLObject):
    CONSTRUCTOR_ID = 0x6b3765b
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, poll: 'TypePoll'):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaGifExternal, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll.
        """
        self.poll = poll

    def to_dict(self):
        return {
            '_': 'InputMediaPoll',
            'poll': self.poll.to_dict() if isinstance(self.poll, TLObject) else self.poll
        }

    def __bytes__(self):
        return b''.join((
            b'[v\xb3\x06',
            bytes(self.poll),
        ))

    @classmethod
    def from_reader(cls, reader):
        _poll = reader.tgread_object()
        return cls(poll=_poll)


class InputMediaUploadedDocument(TLObject):
    CONSTRUCTOR_ID = 0x5b38c6c1
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, file: 'TypeInputFile', mime_type: str, attributes: List['TypeDocumentAttribute'], nosound_video: Optional[bool]=None, thumb: Optional['TypeInputFile']=None, stickers: Optional[List['TypeInputDocument']]=None, ttl_seconds: Optional[int]=None):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaGifExternal, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll.
        """
        self.file = file
        self.mime_type = mime_type
        self.attributes = attributes
        self.nosound_video = nosound_video
        self.thumb = thumb
        self.stickers = stickers
        self.ttl_seconds = ttl_seconds

    def to_dict(self):
        return {
            '_': 'InputMediaUploadedDocument',
            'file': self.file.to_dict() if isinstance(self.file, TLObject) else self.file,
            'mime_type': self.mime_type,
            'attributes': [] if self.attributes is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.attributes],
            'nosound_video': self.nosound_video,
            'thumb': self.thumb.to_dict() if isinstance(self.thumb, TLObject) else self.thumb,
            'stickers': [] if self.stickers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.stickers],
            'ttl_seconds': self.ttl_seconds
        }

    def __bytes__(self):
        return b''.join((
            b'\xc1\xc68[',
            struct.pack('<I', (0 if self.nosound_video is None or self.nosound_video is False else 8) | (0 if self.thumb is None or self.thumb is False else 4) | (0 if self.stickers is None or self.stickers is False else 1) | (0 if self.ttl_seconds is None or self.ttl_seconds is False else 2)),
            bytes(self.file),
            b'' if self.thumb is None or self.thumb is False else (bytes(self.thumb)),
            self.serialize_bytes(self.mime_type),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.attributes)),b''.join(bytes(x) for x in self.attributes),
            b'' if self.stickers is None or self.stickers is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.stickers)),b''.join(bytes(x) for x in self.stickers))),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _nosound_video = bool(flags & 8)
        _file = reader.tgread_object()
        if flags & 4:
            _thumb = reader.tgread_object()
        else:
            _thumb = None
        _mime_type = reader.tgread_string()
        reader.read_int()
        _attributes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _attributes.append(_x)

        if flags & 1:
            reader.read_int()
            _stickers = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _stickers.append(_x)

        else:
            _stickers = None
        if flags & 2:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(file=_file, mime_type=_mime_type, attributes=_attributes, nosound_video=_nosound_video, thumb=_thumb, stickers=_stickers, ttl_seconds=_ttl_seconds)


class InputMediaUploadedPhoto(TLObject):
    CONSTRUCTOR_ID = 0x1e287d04
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, file: 'TypeInputFile', stickers: Optional[List['TypeInputDocument']]=None, ttl_seconds: Optional[int]=None):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaGifExternal, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll.
        """
        self.file = file
        self.stickers = stickers
        self.ttl_seconds = ttl_seconds

    def to_dict(self):
        return {
            '_': 'InputMediaUploadedPhoto',
            'file': self.file.to_dict() if isinstance(self.file, TLObject) else self.file,
            'stickers': [] if self.stickers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.stickers],
            'ttl_seconds': self.ttl_seconds
        }

    def __bytes__(self):
        return b''.join((
            b'\x04}(\x1e',
            struct.pack('<I', (0 if self.stickers is None or self.stickers is False else 1) | (0 if self.ttl_seconds is None or self.ttl_seconds is False else 2)),
            bytes(self.file),
            b'' if self.stickers is None or self.stickers is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.stickers)),b''.join(bytes(x) for x in self.stickers))),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _file = reader.tgread_object()
        if flags & 1:
            reader.read_int()
            _stickers = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _stickers.append(_x)

        else:
            _stickers = None
        if flags & 2:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(file=_file, stickers=_stickers, ttl_seconds=_ttl_seconds)


class InputMediaVenue(TLObject):
    CONSTRUCTOR_ID = 0xc13d1c11
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, geo_point: 'TypeInputGeoPoint', title: str, address: str, provider: str, venue_id: str, venue_type: str):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaGifExternal, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll.
        """
        self.geo_point = geo_point
        self.title = title
        self.address = address
        self.provider = provider
        self.venue_id = venue_id
        self.venue_type = venue_type

    def to_dict(self):
        return {
            '_': 'InputMediaVenue',
            'geo_point': self.geo_point.to_dict() if isinstance(self.geo_point, TLObject) else self.geo_point,
            'title': self.title,
            'address': self.address,
            'provider': self.provider,
            'venue_id': self.venue_id,
            'venue_type': self.venue_type
        }

    def __bytes__(self):
        return b''.join((
            b'\x11\x1c=\xc1',
            bytes(self.geo_point),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.address),
            self.serialize_bytes(self.provider),
            self.serialize_bytes(self.venue_id),
            self.serialize_bytes(self.venue_type),
        ))

    @classmethod
    def from_reader(cls, reader):
        _geo_point = reader.tgread_object()
        _title = reader.tgread_string()
        _address = reader.tgread_string()
        _provider = reader.tgread_string()
        _venue_id = reader.tgread_string()
        _venue_type = reader.tgread_string()
        return cls(geo_point=_geo_point, title=_title, address=_address, provider=_provider, venue_id=_venue_id, venue_type=_venue_type)


class InputMessageEntityMentionName(TLObject):
    CONSTRUCTOR_ID = 0x208e68c9
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int, user_id: 'TypeInputUser'):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length
        self.user_id = user_id

    def to_dict(self):
        return {
            '_': 'InputMessageEntityMentionName',
            'offset': self.offset,
            'length': self.length,
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xc9h\x8e ',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
            bytes(self.user_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        _user_id = reader.tgread_object()
        return cls(offset=_offset, length=_length, user_id=_user_id)


class InputMessageID(TLObject):
    CONSTRUCTOR_ID = 0xa676a322
    SUBCLASS_OF_ID = 0x54b6bcc5

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        """
        Constructor for InputMessage: Instance of either InputMessageID, InputMessageReplyTo, InputMessagePinned.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'InputMessageID',
            'id': self.id
        }

    def __bytes__(self):
        return b''.join((
            b'"\xa3v\xa6',
            struct.pack('<i', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_int()
        return cls(id=_id)


class InputMessagePinned(TLObject):
    CONSTRUCTOR_ID = 0x86872538
    SUBCLASS_OF_ID = 0x54b6bcc5

    def to_dict(self):
        return {
            '_': 'InputMessagePinned'
        }

    def __bytes__(self):
        return b''.join((
            b'8%\x87\x86',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessageReplyTo(TLObject):
    CONSTRUCTOR_ID = 0xbad88395
    SUBCLASS_OF_ID = 0x54b6bcc5

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        """
        Constructor for InputMessage: Instance of either InputMessageID, InputMessageReplyTo, InputMessagePinned.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'InputMessageReplyTo',
            'id': self.id
        }

    def __bytes__(self):
        return b''.join((
            b'\x95\x83\xd8\xba',
            struct.pack('<i', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_int()
        return cls(id=_id)


class InputMessagesFilterChatPhotos(TLObject):
    CONSTRUCTOR_ID = 0x3a20ecb8
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterChatPhotos'
        }

    def __bytes__(self):
        return b''.join((
            b'\xb8\xec :',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterContacts(TLObject):
    CONSTRUCTOR_ID = 0xe062db83
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterContacts'
        }

    def __bytes__(self):
        return b''.join((
            b'\x83\xdbb\xe0',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterDocument(TLObject):
    CONSTRUCTOR_ID = 0x9eddf188
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterDocument'
        }

    def __bytes__(self):
        return b''.join((
            b'\x88\xf1\xdd\x9e',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterEmpty(TLObject):
    CONSTRUCTOR_ID = 0x57e2f66c
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'l\xf6\xe2W',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterGeo(TLObject):
    CONSTRUCTOR_ID = 0xe7026d0d
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterGeo'
        }

    def __bytes__(self):
        return b''.join((
            b'\rm\x02\xe7',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterGif(TLObject):
    CONSTRUCTOR_ID = 0xffc86587
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterGif'
        }

    def __bytes__(self):
        return b''.join((
            b'\x87e\xc8\xff',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterMusic(TLObject):
    CONSTRUCTOR_ID = 0x3751b49e
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterMusic'
        }

    def __bytes__(self):
        return b''.join((
            b'\x9e\xb4Q7',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterMyMentions(TLObject):
    CONSTRUCTOR_ID = 0xc1f8e69a
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterMyMentions'
        }

    def __bytes__(self):
        return b''.join((
            b'\x9a\xe6\xf8\xc1',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterPhoneCalls(TLObject):
    CONSTRUCTOR_ID = 0x80c99768
    SUBCLASS_OF_ID = 0x8a36ec14

    def __init__(self, missed: Optional[bool]=None):
        """
        Constructor for MessagesFilter: Instance of either InputMessagesFilterEmpty, InputMessagesFilterPhotos, InputMessagesFilterVideo, InputMessagesFilterPhotoVideo, InputMessagesFilterDocument, InputMessagesFilterUrl, InputMessagesFilterGif, InputMessagesFilterVoice, InputMessagesFilterMusic, InputMessagesFilterChatPhotos, InputMessagesFilterPhoneCalls, InputMessagesFilterRoundVoice, InputMessagesFilterRoundVideo, InputMessagesFilterMyMentions, InputMessagesFilterGeo, InputMessagesFilterContacts.
        """
        self.missed = missed

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterPhoneCalls',
            'missed': self.missed
        }

    def __bytes__(self):
        return b''.join((
            b'h\x97\xc9\x80',
            struct.pack('<I', (0 if self.missed is None or self.missed is False else 1)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _missed = bool(flags & 1)
        return cls(missed=_missed)


class InputMessagesFilterPhotoVideo(TLObject):
    CONSTRUCTOR_ID = 0x56e9f0e4
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterPhotoVideo'
        }

    def __bytes__(self):
        return b''.join((
            b'\xe4\xf0\xe9V',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterPhotos(TLObject):
    CONSTRUCTOR_ID = 0x9609a51c
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterPhotos'
        }

    def __bytes__(self):
        return b''.join((
            b'\x1c\xa5\t\x96',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterRoundVideo(TLObject):
    CONSTRUCTOR_ID = 0xb549da53
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterRoundVideo'
        }

    def __bytes__(self):
        return b''.join((
            b'S\xdaI\xb5',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterRoundVoice(TLObject):
    CONSTRUCTOR_ID = 0x7a7c17a4
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterRoundVoice'
        }

    def __bytes__(self):
        return b''.join((
            b'\xa4\x17|z',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterUrl(TLObject):
    CONSTRUCTOR_ID = 0x7ef0dd87
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterUrl'
        }

    def __bytes__(self):
        return b''.join((
            b'\x87\xdd\xf0~',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterVideo(TLObject):
    CONSTRUCTOR_ID = 0x9fc00e65
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterVideo'
        }

    def __bytes__(self):
        return b''.join((
            b'e\x0e\xc0\x9f',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterVoice(TLObject):
    CONSTRUCTOR_ID = 0x50f5c392
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterVoice'
        }

    def __bytes__(self):
        return b''.join((
            b'\x92\xc3\xf5P',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputNotifyBroadcasts(TLObject):
    CONSTRUCTOR_ID = 0xb1db7c7e
    SUBCLASS_OF_ID = 0x58981615

    def to_dict(self):
        return {
            '_': 'InputNotifyBroadcasts'
        }

    def __bytes__(self):
        return b''.join((
            b'~|\xdb\xb1',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputNotifyChats(TLObject):
    CONSTRUCTOR_ID = 0x4a95e84e
    SUBCLASS_OF_ID = 0x58981615

    def to_dict(self):
        return {
            '_': 'InputNotifyChats'
        }

    def __bytes__(self):
        return b''.join((
            b'N\xe8\x95J',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputNotifyPeer(TLObject):
    CONSTRUCTOR_ID = 0xb8bc5b0c
    SUBCLASS_OF_ID = 0x58981615

    def __init__(self, peer: 'TypeInputPeer'):
        """
        Constructor for InputNotifyPeer: Instance of either InputNotifyPeer, InputNotifyUsers, InputNotifyChats, InputNotifyBroadcasts.
        """
        self.peer = peer

    def to_dict(self):
        return {
            '_': 'InputNotifyPeer',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def __bytes__(self):
        return b''.join((
            b'\x0c[\xbc\xb8',
            bytes(self.peer),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


class InputNotifyUsers(TLObject):
    CONSTRUCTOR_ID = 0x193b4417
    SUBCLASS_OF_ID = 0x58981615

    def to_dict(self):
        return {
            '_': 'InputNotifyUsers'
        }

    def __bytes__(self):
        return b''.join((
            b'\x17D;\x19',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPaymentCredentials(TLObject):
    CONSTRUCTOR_ID = 0x3417d728
    SUBCLASS_OF_ID = 0x2899a53d

    def __init__(self, data: 'TypeDataJSON', save: Optional[bool]=None):
        """
        Constructor for InputPaymentCredentials: Instance of either InputPaymentCredentialsSaved, InputPaymentCredentials, InputPaymentCredentialsApplePay, InputPaymentCredentialsAndroidPay.
        """
        self.data = data
        self.save = save

    def to_dict(self):
        return {
            '_': 'InputPaymentCredentials',
            'data': self.data.to_dict() if isinstance(self.data, TLObject) else self.data,
            'save': self.save
        }

    def __bytes__(self):
        return b''.join((
            b'(\xd7\x174',
            struct.pack('<I', (0 if self.save is None or self.save is False else 1)),
            bytes(self.data),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _save = bool(flags & 1)
        _data = reader.tgread_object()
        return cls(data=_data, save=_save)


class InputPaymentCredentialsAndroidPay(TLObject):
    CONSTRUCTOR_ID = 0xca05d50e
    SUBCLASS_OF_ID = 0x2899a53d

    def __init__(self, payment_token: 'TypeDataJSON', google_transaction_id: str):
        """
        Constructor for InputPaymentCredentials: Instance of either InputPaymentCredentialsSaved, InputPaymentCredentials, InputPaymentCredentialsApplePay, InputPaymentCredentialsAndroidPay.
        """
        self.payment_token = payment_token
        self.google_transaction_id = google_transaction_id

    def to_dict(self):
        return {
            '_': 'InputPaymentCredentialsAndroidPay',
            'payment_token': self.payment_token.to_dict() if isinstance(self.payment_token, TLObject) else self.payment_token,
            'google_transaction_id': self.google_transaction_id
        }

    def __bytes__(self):
        return b''.join((
            b'\x0e\xd5\x05\xca',
            bytes(self.payment_token),
            self.serialize_bytes(self.google_transaction_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _payment_token = reader.tgread_object()
        _google_transaction_id = reader.tgread_string()
        return cls(payment_token=_payment_token, google_transaction_id=_google_transaction_id)


class InputPaymentCredentialsApplePay(TLObject):
    CONSTRUCTOR_ID = 0xaa1c39f
    SUBCLASS_OF_ID = 0x2899a53d

    def __init__(self, payment_data: 'TypeDataJSON'):
        """
        Constructor for InputPaymentCredentials: Instance of either InputPaymentCredentialsSaved, InputPaymentCredentials, InputPaymentCredentialsApplePay, InputPaymentCredentialsAndroidPay.
        """
        self.payment_data = payment_data

    def to_dict(self):
        return {
            '_': 'InputPaymentCredentialsApplePay',
            'payment_data': self.payment_data.to_dict() if isinstance(self.payment_data, TLObject) else self.payment_data
        }

    def __bytes__(self):
        return b''.join((
            b'\x9f\xc3\xa1\n',
            bytes(self.payment_data),
        ))

    @classmethod
    def from_reader(cls, reader):
        _payment_data = reader.tgread_object()
        return cls(payment_data=_payment_data)


class InputPaymentCredentialsSaved(TLObject):
    CONSTRUCTOR_ID = 0xc10eb2cf
    SUBCLASS_OF_ID = 0x2899a53d

    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, tmp_password: bytes):
        """
        Constructor for InputPaymentCredentials: Instance of either InputPaymentCredentialsSaved, InputPaymentCredentials, InputPaymentCredentialsApplePay, InputPaymentCredentialsAndroidPay.
        """
        self.id = id
        self.tmp_password = tmp_password

    def to_dict(self):
        return {
            '_': 'InputPaymentCredentialsSaved',
            'id': self.id,
            'tmp_password': self.tmp_password
        }

    def __bytes__(self):
        return b''.join((
            b'\xcf\xb2\x0e\xc1',
            self.serialize_bytes(self.id),
            self.serialize_bytes(self.tmp_password),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_string()
        _tmp_password = reader.tgread_bytes()
        return cls(id=_id, tmp_password=_tmp_password)


class InputPeerChannel(TLObject):
    CONSTRUCTOR_ID = 0x20adaef8
    SUBCLASS_OF_ID = 0xc91c90b6

    def __init__(self, channel_id: int, access_hash: int):
        """
        Constructor for InputPeer: Instance of either InputPeerEmpty, InputPeerSelf, InputPeerChat, InputPeerUser, InputPeerChannel, InputPeerUserFromMessage, InputPeerChannelFromMessage.
        """
        self.channel_id = channel_id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputPeerChannel',
            'channel_id': self.channel_id,
            'access_hash': self.access_hash
        }

    def __bytes__(self):
        return b''.join((
            b'\xf8\xae\xad ',
            struct.pack('<i', self.channel_id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel_id = reader.read_int()
        _access_hash = reader.read_long()
        return cls(channel_id=_channel_id, access_hash=_access_hash)


class InputPeerChannelFromMessage(TLObject):
    CONSTRUCTOR_ID = 0x9c95f7bb
    SUBCLASS_OF_ID = 0xc91c90b6

    def __init__(self, peer: 'TypeInputPeer', msg_id: int, channel_id: int):
        """
        Constructor for InputPeer: Instance of either InputPeerEmpty, InputPeerSelf, InputPeerChat, InputPeerUser, InputPeerChannel, InputPeerUserFromMessage, InputPeerChannelFromMessage.
        """
        self.peer = peer
        self.msg_id = msg_id
        self.channel_id = channel_id

    def to_dict(self):
        return {
            '_': 'InputPeerChannelFromMessage',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'msg_id': self.msg_id,
            'channel_id': self.channel_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xbb\xf7\x95\x9c',
            bytes(self.peer),
            struct.pack('<i', self.msg_id),
            struct.pack('<i', self.channel_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        _channel_id = reader.read_int()
        return cls(peer=_peer, msg_id=_msg_id, channel_id=_channel_id)


class InputPeerChat(TLObject):
    CONSTRUCTOR_ID = 0x179be863
    SUBCLASS_OF_ID = 0xc91c90b6

    def __init__(self, chat_id: int):
        """
        Constructor for InputPeer: Instance of either InputPeerEmpty, InputPeerSelf, InputPeerChat, InputPeerUser, InputPeerChannel, InputPeerUserFromMessage, InputPeerChannelFromMessage.
        """
        self.chat_id = chat_id

    def to_dict(self):
        return {
            '_': 'InputPeerChat',
            'chat_id': self.chat_id
        }

    def __bytes__(self):
        return b''.join((
            b'c\xe8\x9b\x17',
            struct.pack('<i', self.chat_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_int()
        return cls(chat_id=_chat_id)


class InputPeerEmpty(TLObject):
    CONSTRUCTOR_ID = 0x7f3b18ea
    SUBCLASS_OF_ID = 0xc91c90b6

    def to_dict(self):
        return {
            '_': 'InputPeerEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'\xea\x18;\x7f',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPeerNotifySettings(TLObject):
    CONSTRUCTOR_ID = 0x9c3d198e
    SUBCLASS_OF_ID = 0x90db0b0d

    def __init__(self, show_previews: Optional[bool]=None, silent: Optional[bool]=None, mute_until: Optional[datetime]=None, sound: Optional[str]=None):
        """
        Constructor for InputPeerNotifySettings: Instance of InputPeerNotifySettings.
        """
        self.show_previews = show_previews
        self.silent = silent
        self.mute_until = mute_until
        self.sound = sound

    def to_dict(self):
        return {
            '_': 'InputPeerNotifySettings',
            'show_previews': self.show_previews,
            'silent': self.silent,
            'mute_until': self.mute_until,
            'sound': self.sound
        }

    def __bytes__(self):
        return b''.join((
            b'\x8e\x19=\x9c',
            struct.pack('<I', (0 if self.show_previews is None or self.show_previews is False else 1) | (0 if self.silent is None or self.silent is False else 2) | (0 if self.mute_until is None or self.mute_until is False else 4) | (0 if self.sound is None or self.sound is False else 8)),
            b'' if self.show_previews is None or self.show_previews is False else (b'\xb5ur\x99' if self.show_previews else b'7\x97y\xbc'),
            b'' if self.silent is None or self.silent is False else (b'\xb5ur\x99' if self.silent else b'7\x97y\xbc'),
            b'' if self.mute_until is None or self.mute_until is False else (self.serialize_datetime(self.mute_until)),
            b'' if self.sound is None or self.sound is False else (self.serialize_bytes(self.sound)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _show_previews = reader.tgread_bool()
        else:
            _show_previews = None
        if flags & 2:
            _silent = reader.tgread_bool()
        else:
            _silent = None
        if flags & 4:
            _mute_until = reader.tgread_date()
        else:
            _mute_until = None
        if flags & 8:
            _sound = reader.tgread_string()
        else:
            _sound = None
        return cls(show_previews=_show_previews, silent=_silent, mute_until=_mute_until, sound=_sound)


class InputPeerPhotoFileLocation(TLObject):
    CONSTRUCTOR_ID = 0x27d69997
    SUBCLASS_OF_ID = 0x1523d462

    def __init__(self, peer: 'TypeInputPeer', volume_id: int, local_id: int, big: Optional[bool]=None):
        """
        Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb.
        """
        self.peer = peer
        self.volume_id = volume_id
        self.local_id = local_id
        self.big = big

    def to_dict(self):
        return {
            '_': 'InputPeerPhotoFileLocation',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'volume_id': self.volume_id,
            'local_id': self.local_id,
            'big': self.big
        }

    def __bytes__(self):
        return b''.join((
            b"\x97\x99\xd6'",
            struct.pack('<I', (0 if self.big is None or self.big is False else 1)),
            bytes(self.peer),
            struct.pack('<q', self.volume_id),
            struct.pack('<i', self.local_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _big = bool(flags & 1)
        _peer = reader.tgread_object()
        _volume_id = reader.read_long()
        _local_id = reader.read_int()
        return cls(peer=_peer, volume_id=_volume_id, local_id=_local_id, big=_big)


class InputPeerSelf(TLObject):
    CONSTRUCTOR_ID = 0x7da07ec9
    SUBCLASS_OF_ID = 0xc91c90b6

    def to_dict(self):
        return {
            '_': 'InputPeerSelf'
        }

    def __bytes__(self):
        return b''.join((
            b'\xc9~\xa0}',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPeerUser(TLObject):
    CONSTRUCTOR_ID = 0x7b8e7de6
    SUBCLASS_OF_ID = 0xc91c90b6

    def __init__(self, user_id: int, access_hash: int):
        """
        Constructor for InputPeer: Instance of either InputPeerEmpty, InputPeerSelf, InputPeerChat, InputPeerUser, InputPeerChannel, InputPeerUserFromMessage, InputPeerChannelFromMessage.
        """
        self.user_id = user_id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputPeerUser',
            'user_id': self.user_id,
            'access_hash': self.access_hash
        }

    def __bytes__(self):
        return b''.join((
            b'\xe6}\x8e{',
            struct.pack('<i', self.user_id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        _access_hash = reader.read_long()
        return cls(user_id=_user_id, access_hash=_access_hash)


class InputPeerUserFromMessage(TLObject):
    CONSTRUCTOR_ID = 0x17bae2e6
    SUBCLASS_OF_ID = 0xc91c90b6

    def __init__(self, peer: 'TypeInputPeer', msg_id: int, user_id: int):
        """
        Constructor for InputPeer: Instance of either InputPeerEmpty, InputPeerSelf, InputPeerChat, InputPeerUser, InputPeerChannel, InputPeerUserFromMessage, InputPeerChannelFromMessage.
        """
        self.peer = peer
        self.msg_id = msg_id
        self.user_id = user_id

    def to_dict(self):
        return {
            '_': 'InputPeerUserFromMessage',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'msg_id': self.msg_id,
            'user_id': self.user_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xe6\xe2\xba\x17',
            bytes(self.peer),
            struct.pack('<i', self.msg_id),
            struct.pack('<i', self.user_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        _user_id = reader.read_int()
        return cls(peer=_peer, msg_id=_msg_id, user_id=_user_id)


class InputPhoneCall(TLObject):
    CONSTRUCTOR_ID = 0x1e36fded
    SUBCLASS_OF_ID = 0xbcaaf240

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        """
        Constructor for InputPhoneCall: Instance of InputPhoneCall.
        """
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputPhoneCall',
            'id': self.id,
            'access_hash': self.access_hash
        }

    def __bytes__(self):
        return b''.join((
            b'\xed\xfd6\x1e',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


class InputPhoneContact(TLObject):
    CONSTRUCTOR_ID = 0xf392b7f4
    SUBCLASS_OF_ID = 0xae696a82

    def __init__(self, client_id: int, phone: str, first_name: str, last_name: str):
        """
        Constructor for InputContact: Instance of InputPhoneContact.
        """
        self.client_id = client_id
        self.phone = phone
        self.first_name = first_name
        self.last_name = last_name

    def to_dict(self):
        return {
            '_': 'InputPhoneContact',
            'client_id': self.client_id,
            'phone': self.phone,
            'first_name': self.first_name,
            'last_name': self.last_name
        }

    def __bytes__(self):
        return b''.join((
            b'\xf4\xb7\x92\xf3',
            struct.pack('<q', self.client_id),
            self.serialize_bytes(self.phone),
            self.serialize_bytes(self.first_name),
            self.serialize_bytes(self.last_name),
        ))

    @classmethod
    def from_reader(cls, reader):
        _client_id = reader.read_long()
        _phone = reader.tgread_string()
        _first_name = reader.tgread_string()
        _last_name = reader.tgread_string()
        return cls(client_id=_client_id, phone=_phone, first_name=_first_name, last_name=_last_name)


class InputPhoto(TLObject):
    CONSTRUCTOR_ID = 0x3bb3b94a
    SUBCLASS_OF_ID = 0x846363e0

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, file_reference: bytes):
        """
        Constructor for InputPhoto: Instance of either InputPhotoEmpty, InputPhoto.
        """
        self.id = id
        self.access_hash = access_hash
        self.file_reference = file_reference

    def to_dict(self):
        return {
            '_': 'InputPhoto',
            'id': self.id,
            'access_hash': self.access_hash,
            'file_reference': self.file_reference
        }

    def __bytes__(self):
        return b''.join((
            b'J\xb9\xb3;',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_bytes(self.file_reference),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _file_reference = reader.tgread_bytes()
        return cls(id=_id, access_hash=_access_hash, file_reference=_file_reference)


class InputPhotoEmpty(TLObject):
    CONSTRUCTOR_ID = 0x1cd7bf0d
    SUBCLASS_OF_ID = 0x846363e0

    def to_dict(self):
        return {
            '_': 'InputPhotoEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'\r\xbf\xd7\x1c',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPhotoFileLocation(TLObject):
    CONSTRUCTOR_ID = 0x40181ffe
    SUBCLASS_OF_ID = 0x1523d462

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, file_reference: bytes, thumb_size: str):
        """
        Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb.
        """
        self.id = id
        self.access_hash = access_hash
        self.file_reference = file_reference
        self.thumb_size = thumb_size

    def to_dict(self):
        return {
            '_': 'InputPhotoFileLocation',
            'id': self.id,
            'access_hash': self.access_hash,
            'file_reference': self.file_reference,
            'thumb_size': self.thumb_size
        }

    def __bytes__(self):
        return b''.join((
            b'\xfe\x1f\x18@',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_bytes(self.file_reference),
            self.serialize_bytes(self.thumb_size),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _file_reference = reader.tgread_bytes()
        _thumb_size = reader.tgread_string()
        return cls(id=_id, access_hash=_access_hash, file_reference=_file_reference, thumb_size=_thumb_size)


class InputPrivacyKeyAddedByPhone(TLObject):
    CONSTRUCTOR_ID = 0xd1219bdd
    SUBCLASS_OF_ID = 0x53627f8

    def to_dict(self):
        return {
            '_': 'InputPrivacyKeyAddedByPhone'
        }

    def __bytes__(self):
        return b''.join((
            b'\xdd\x9b!\xd1',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyKeyChatInvite(TLObject):
    CONSTRUCTOR_ID = 0xbdfb0426
    SUBCLASS_OF_ID = 0x53627f8

    def to_dict(self):
        return {
            '_': 'InputPrivacyKeyChatInvite'
        }

    def __bytes__(self):
        return b''.join((
            b'&\x04\xfb\xbd',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyKeyForwards(TLObject):
    CONSTRUCTOR_ID = 0xa4dd4c08
    SUBCLASS_OF_ID = 0x53627f8

    def to_dict(self):
        return {
            '_': 'InputPrivacyKeyForwards'
        }

    def __bytes__(self):
        return b''.join((
            b'\x08L\xdd\xa4',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyKeyPhoneCall(TLObject):
    CONSTRUCTOR_ID = 0xfabadc5f
    SUBCLASS_OF_ID = 0x53627f8

    def to_dict(self):
        return {
            '_': 'InputPrivacyKeyPhoneCall'
        }

    def __bytes__(self):
        return b''.join((
            b'_\xdc\xba\xfa',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyKeyPhoneNumber(TLObject):
    CONSTRUCTOR_ID = 0x352dafa
    SUBCLASS_OF_ID = 0x53627f8

    def to_dict(self):
        return {
            '_': 'InputPrivacyKeyPhoneNumber'
        }

    def __bytes__(self):
        return b''.join((
            b'\xfa\xdaR\x03',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyKeyPhoneP2P(TLObject):
    CONSTRUCTOR_ID = 0xdb9e70d2
    SUBCLASS_OF_ID = 0x53627f8

    def to_dict(self):
        return {
            '_': 'InputPrivacyKeyPhoneP2P'
        }

    def __bytes__(self):
        return b''.join((
            b'\xd2p\x9e\xdb',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyKeyProfilePhoto(TLObject):
    CONSTRUCTOR_ID = 0x5719bacc
    SUBCLASS_OF_ID = 0x53627f8

    def to_dict(self):
        return {
            '_': 'InputPrivacyKeyProfilePhoto'
        }

    def __bytes__(self):
        return b''.join((
            b'\xcc\xba\x19W',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyKeyStatusTimestamp(TLObject):
    CONSTRUCTOR_ID = 0x4f96cb18
    SUBCLASS_OF_ID = 0x53627f8

    def to_dict(self):
        return {
            '_': 'InputPrivacyKeyStatusTimestamp'
        }

    def __bytes__(self):
        return b''.join((
            b'\x18\xcb\x96O',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyValueAllowAll(TLObject):
    CONSTRUCTOR_ID = 0x184b35ce
    SUBCLASS_OF_ID = 0x5a3b6b22

    def to_dict(self):
        return {
            '_': 'InputPrivacyValueAllowAll'
        }

    def __bytes__(self):
        return b''.join((
            b'\xce5K\x18',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyValueAllowChatParticipants(TLObject):
    CONSTRUCTOR_ID = 0x4c81c1ba
    SUBCLASS_OF_ID = 0x5a3b6b22

    def __init__(self, chats: List[int]):
        """
        Constructor for InputPrivacyRule: Instance of either InputPrivacyValueAllowContacts, InputPrivacyValueAllowAll, InputPrivacyValueAllowUsers, InputPrivacyValueDisallowContacts, InputPrivacyValueDisallowAll, InputPrivacyValueDisallowUsers, InputPrivacyValueAllowChatParticipants, InputPrivacyValueDisallowChatParticipants.
        """
        self.chats = chats

    def to_dict(self):
        return {
            '_': 'InputPrivacyValueAllowChatParticipants',
            'chats': [] if self.chats is None else self.chats[:]
        }

    def __bytes__(self):
        return b''.join((
            b'\xba\xc1\x81L',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(struct.pack('<i', x) for x in self.chats),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _chats.append(_x)

        return cls(chats=_chats)


class InputPrivacyValueAllowContacts(TLObject):
    CONSTRUCTOR_ID = 0xd09e07b
    SUBCLASS_OF_ID = 0x5a3b6b22

    def to_dict(self):
        return {
            '_': 'InputPrivacyValueAllowContacts'
        }

    def __bytes__(self):
        return b''.join((
            b'{\xe0\t\r',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyValueAllowUsers(TLObject):
    CONSTRUCTOR_ID = 0x131cc67f
    SUBCLASS_OF_ID = 0x5a3b6b22

    def __init__(self, users: List['TypeInputUser']):
        """
        Constructor for InputPrivacyRule: Instance of either InputPrivacyValueAllowContacts, InputPrivacyValueAllowAll, InputPrivacyValueAllowUsers, InputPrivacyValueDisallowContacts, InputPrivacyValueDisallowAll, InputPrivacyValueDisallowUsers, InputPrivacyValueAllowChatParticipants, InputPrivacyValueDisallowChatParticipants.
        """
        self.users = users

    def to_dict(self):
        return {
            '_': 'InputPrivacyValueAllowUsers',
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users]
        }

    def __bytes__(self):
        return b''.join((
            b'\x7f\xc6\x1c\x13',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(bytes(x) for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(users=_users)


class InputPrivacyValueDisallowAll(TLObject):
    CONSTRUCTOR_ID = 0xd66b66c9
    SUBCLASS_OF_ID = 0x5a3b6b22

    def to_dict(self):
        return {
            '_': 'InputPrivacyValueDisallowAll'
        }

    def __bytes__(self):
        return b''.join((
            b'\xc9fk\xd6',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyValueDisallowChatParticipants(TLObject):
    CONSTRUCTOR_ID = 0xd82363af
    SUBCLASS_OF_ID = 0x5a3b6b22

    def __init__(self, chats: List[int]):
        """
        Constructor for InputPrivacyRule: Instance of either InputPrivacyValueAllowContacts, InputPrivacyValueAllowAll, InputPrivacyValueAllowUsers, InputPrivacyValueDisallowContacts, InputPrivacyValueDisallowAll, InputPrivacyValueDisallowUsers, InputPrivacyValueAllowChatParticipants, InputPrivacyValueDisallowChatParticipants.
        """
        self.chats = chats

    def to_dict(self):
        return {
            '_': 'InputPrivacyValueDisallowChatParticipants',
            'chats': [] if self.chats is None else self.chats[:]
        }

    def __bytes__(self):
        return b''.join((
            b'\xafc#\xd8',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(struct.pack('<i', x) for x in self.chats),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _chats.append(_x)

        return cls(chats=_chats)


class InputPrivacyValueDisallowContacts(TLObject):
    CONSTRUCTOR_ID = 0xba52007
    SUBCLASS_OF_ID = 0x5a3b6b22

    def to_dict(self):
        return {
            '_': 'InputPrivacyValueDisallowContacts'
        }

    def __bytes__(self):
        return b''.join((
            b'\x07 \xa5\x0b',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyValueDisallowUsers(TLObject):
    CONSTRUCTOR_ID = 0x90110467
    SUBCLASS_OF_ID = 0x5a3b6b22

    def __init__(self, users: List['TypeInputUser']):
        """
        Constructor for InputPrivacyRule: Instance of either InputPrivacyValueAllowContacts, InputPrivacyValueAllowAll, InputPrivacyValueAllowUsers, InputPrivacyValueDisallowContacts, InputPrivacyValueDisallowAll, InputPrivacyValueDisallowUsers, InputPrivacyValueAllowChatParticipants, InputPrivacyValueDisallowChatParticipants.
        """
        self.users = users

    def to_dict(self):
        return {
            '_': 'InputPrivacyValueDisallowUsers',
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users]
        }

    def __bytes__(self):
        return b''.join((
            b'g\x04\x11\x90',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(bytes(x) for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(users=_users)


class InputReportReasonChildAbuse(TLObject):
    CONSTRUCTOR_ID = 0xadf44ee3
    SUBCLASS_OF_ID = 0x8401bd27

    def to_dict(self):
        return {
            '_': 'InputReportReasonChildAbuse'
        }

    def __bytes__(self):
        return b''.join((
            b'\xe3N\xf4\xad',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputReportReasonCopyright(TLObject):
    CONSTRUCTOR_ID = 0x9b89f93a
    SUBCLASS_OF_ID = 0x8401bd27

    def to_dict(self):
        return {
            '_': 'InputReportReasonCopyright'
        }

    def __bytes__(self):
        return b''.join((
            b':\xf9\x89\x9b',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputReportReasonGeoIrrelevant(TLObject):
    CONSTRUCTOR_ID = 0xdbd4feed
    SUBCLASS_OF_ID = 0x8401bd27

    def to_dict(self):
        return {
            '_': 'InputReportReasonGeoIrrelevant'
        }

    def __bytes__(self):
        return b''.join((
            b'\xed\xfe\xd4\xdb',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputReportReasonOther(TLObject):
    CONSTRUCTOR_ID = 0xe1746d0a
    SUBCLASS_OF_ID = 0x8401bd27

    def __init__(self, text: str):
        """
        Constructor for ReportReason: Instance of either InputReportReasonSpam, InputReportReasonViolence, InputReportReasonPornography, InputReportReasonChildAbuse, InputReportReasonOther, InputReportReasonCopyright, InputReportReasonGeoIrrelevant.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'InputReportReasonOther',
            'text': self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\nmt\xe1',
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        return cls(text=_text)


class InputReportReasonPornography(TLObject):
    CONSTRUCTOR_ID = 0x2e59d922
    SUBCLASS_OF_ID = 0x8401bd27

    def to_dict(self):
        return {
            '_': 'InputReportReasonPornography'
        }

    def __bytes__(self):
        return b''.join((
            b'"\xd9Y.',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputReportReasonSpam(TLObject):
    CONSTRUCTOR_ID = 0x58dbcab8
    SUBCLASS_OF_ID = 0x8401bd27

    def to_dict(self):
        return {
            '_': 'InputReportReasonSpam'
        }

    def __bytes__(self):
        return b''.join((
            b'\xb8\xca\xdbX',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputReportReasonViolence(TLObject):
    CONSTRUCTOR_ID = 0x1e22c78d
    SUBCLASS_OF_ID = 0x8401bd27

    def to_dict(self):
        return {
            '_': 'InputReportReasonViolence'
        }

    def __bytes__(self):
        return b''.join((
            b'\x8d\xc7"\x1e',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputSecureFile(TLObject):
    CONSTRUCTOR_ID = 0x5367e5be
    SUBCLASS_OF_ID = 0xdac8adfc

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        """
        Constructor for InputSecureFile: Instance of either InputSecureFileUploaded, InputSecureFile.
        """
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputSecureFile',
            'id': self.id,
            'access_hash': self.access_hash
        }

    def __bytes__(self):
        return b''.join((
            b'\xbe\xe5gS',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


class InputSecureFileLocation(TLObject):
    CONSTRUCTOR_ID = 0xcbc7ee28
    SUBCLASS_OF_ID = 0x1523d462

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        """
        Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb.
        """
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputSecureFileLocation',
            'id': self.id,
            'access_hash': self.access_hash
        }

    def __bytes__(self):
        return b''.join((
            b'(\xee\xc7\xcb',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


class InputSecureFileUploaded(TLObject):
    CONSTRUCTOR_ID = 0x3334b0f0
    SUBCLASS_OF_ID = 0xdac8adfc

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, parts: int, md5_checksum: str, file_hash: bytes, secret: bytes):
        """
        Constructor for InputSecureFile: Instance of either InputSecureFileUploaded, InputSecureFile.
        """
        self.id = id
        self.parts = parts
        self.md5_checksum = md5_checksum
        self.file_hash = file_hash
        self.secret = secret

    def to_dict(self):
        return {
            '_': 'InputSecureFileUploaded',
            'id': self.id,
            'parts': self.parts,
            'md5_checksum': self.md5_checksum,
            'file_hash': self.file_hash,
            'secret': self.secret
        }

    def __bytes__(self):
        return b''.join((
            b'\xf0\xb043',
            struct.pack('<q', self.id),
            struct.pack('<i', self.parts),
            self.serialize_bytes(self.md5_checksum),
            self.serialize_bytes(self.file_hash),
            self.serialize_bytes(self.secret),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _parts = reader.read_int()
        _md5_checksum = reader.tgread_string()
        _file_hash = reader.tgread_bytes()
        _secret = reader.tgread_bytes()
        return cls(id=_id, parts=_parts, md5_checksum=_md5_checksum, file_hash=_file_hash, secret=_secret)


class InputSecureValue(TLObject):
    CONSTRUCTOR_ID = 0xdb21d0a7
    SUBCLASS_OF_ID = 0xb49da1fc

    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', data: Optional['TypeSecureData']=None, front_side: Optional['TypeInputSecureFile']=None, reverse_side: Optional['TypeInputSecureFile']=None, selfie: Optional['TypeInputSecureFile']=None, translation: Optional[List['TypeInputSecureFile']]=None, files: Optional[List['TypeInputSecureFile']]=None, plain_data: Optional['TypeSecurePlainData']=None):
        """
        Constructor for InputSecureValue: Instance of InputSecureValue.
        """
        self.type = type
        self.data = data
        self.front_side = front_side
        self.reverse_side = reverse_side
        self.selfie = selfie
        self.translation = translation
        self.files = files
        self.plain_data = plain_data

    def to_dict(self):
        return {
            '_': 'InputSecureValue',
            'type': self.type.to_dict() if isinstance(self.type, TLObject) else self.type,
            'data': self.data.to_dict() if isinstance(self.data, TLObject) else self.data,
            'front_side': self.front_side.to_dict() if isinstance(self.front_side, TLObject) else self.front_side,
            'reverse_side': self.reverse_side.to_dict() if isinstance(self.reverse_side, TLObject) else self.reverse_side,
            'selfie': self.selfie.to_dict() if isinstance(self.selfie, TLObject) else self.selfie,
            'translation': [] if self.translation is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.translation],
            'files': [] if self.files is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.files],
            'plain_data': self.plain_data.to_dict() if isinstance(self.plain_data, TLObject) else self.plain_data
        }

    def __bytes__(self):
        return b''.join((
            b'\xa7\xd0!\xdb',
            struct.pack('<I', (0 if self.data is None or self.data is False else 1) | (0 if self.front_side is None or self.front_side is False else 2) | (0 if self.reverse_side is None or self.reverse_side is False else 4) | (0 if self.selfie is None or self.selfie is False else 8) | (0 if self.translation is None or self.translation is False else 64) | (0 if self.files is None or self.files is False else 16) | (0 if self.plain_data is None or self.plain_data is False else 32)),
            bytes(self.type),
            b'' if self.data is None or self.data is False else (bytes(self.data)),
            b'' if self.front_side is None or self.front_side is False else (bytes(self.front_side)),
            b'' if self.reverse_side is None or self.reverse_side is False else (bytes(self.reverse_side)),
            b'' if self.selfie is None or self.selfie is False else (bytes(self.selfie)),
            b'' if self.translation is None or self.translation is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.translation)),b''.join(bytes(x) for x in self.translation))),
            b'' if self.files is None or self.files is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.files)),b''.join(bytes(x) for x in self.files))),
            b'' if self.plain_data is None or self.plain_data is False else (bytes(self.plain_data)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _type = reader.tgread_object()
        if flags & 1:
            _data = reader.tgread_object()
        else:
            _data = None
        if flags & 2:
            _front_side = reader.tgread_object()
        else:
            _front_side = None
        if flags & 4:
            _reverse_side = reader.tgread_object()
        else:
            _reverse_side = None
        if flags & 8:
            _selfie = reader.tgread_object()
        else:
            _selfie = None
        if flags & 64:
            reader.read_int()
            _translation = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _translation.append(_x)

        else:
            _translation = None
        if flags & 16:
            reader.read_int()
            _files = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _files.append(_x)

        else:
            _files = None
        if flags & 32:
            _plain_data = reader.tgread_object()
        else:
            _plain_data = None
        return cls(type=_type, data=_data, front_side=_front_side, reverse_side=_reverse_side, selfie=_selfie, translation=_translation, files=_files, plain_data=_plain_data)


class InputSingleMedia(TLObject):
    CONSTRUCTOR_ID = 0x1cc6e91f
    SUBCLASS_OF_ID = 0x21ca8ed8

    def __init__(self, media: 'TypeInputMedia', message: str, random_id: int=None, entities: Optional[List['TypeMessageEntity']]=None):
        """
        Constructor for InputSingleMedia: Instance of InputSingleMedia.
        """
        self.media = media
        self.message = message
        self.random_id = random_id if random_id is not None else int.from_bytes(os.urandom(8), 'big', signed=True)
        self.entities = entities

    def to_dict(self):
        return {
            '_': 'InputSingleMedia',
            'media': self.media.to_dict() if isinstance(self.media, TLObject) else self.media,
            'message': self.message,
            'random_id': self.random_id,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities]
        }

    def __bytes__(self):
        return b''.join((
            b'\x1f\xe9\xc6\x1c',
            struct.pack('<I', (0 if self.entities is None or self.entities is False else 1)),
            bytes(self.media),
            struct.pack('<q', self.random_id),
            self.serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(bytes(x) for x in self.entities))),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _media = reader.tgread_object()
        _random_id = reader.read_long()
        _message = reader.tgread_string()
        if flags & 1:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        return cls(media=_media, message=_message, random_id=_random_id, entities=_entities)


class InputStickerSetAnimatedEmoji(TLObject):
    CONSTRUCTOR_ID = 0x28703c8
    SUBCLASS_OF_ID = 0x3da389aa

    def to_dict(self):
        return {
            '_': 'InputStickerSetAnimatedEmoji'
        }

    def __bytes__(self):
        return b''.join((
            b'\xc8\x03\x87\x02',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputStickerSetEmpty(TLObject):
    CONSTRUCTOR_ID = 0xffb62b95
    SUBCLASS_OF_ID = 0x3da389aa

    def to_dict(self):
        return {
            '_': 'InputStickerSetEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'\x95+\xb6\xff',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputStickerSetID(TLObject):
    CONSTRUCTOR_ID = 0x9de7a269
    SUBCLASS_OF_ID = 0x3da389aa

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        """
        Constructor for InputStickerSet: Instance of either InputStickerSetEmpty, InputStickerSetID, InputStickerSetShortName, InputStickerSetAnimatedEmoji.
        """
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputStickerSetID',
            'id': self.id,
            'access_hash': self.access_hash
        }

    def __bytes__(self):
        return b''.join((
            b'i\xa2\xe7\x9d',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


class InputStickerSetItem(TLObject):
    CONSTRUCTOR_ID = 0xffa0a496
    SUBCLASS_OF_ID = 0xae59f075

    def __init__(self, document: 'TypeInputDocument', emoji: str, mask_coords: Optional['TypeMaskCoords']=None):
        """
        Constructor for InputStickerSetItem: Instance of InputStickerSetItem.
        """
        self.document = document
        self.emoji = emoji
        self.mask_coords = mask_coords

    def to_dict(self):
        return {
            '_': 'InputStickerSetItem',
            'document': self.document.to_dict() if isinstance(self.document, TLObject) else self.document,
            'emoji': self.emoji,
            'mask_coords': self.mask_coords.to_dict() if isinstance(self.mask_coords, TLObject) else self.mask_coords
        }

    def __bytes__(self):
        return b''.join((
            b'\x96\xa4\xa0\xff',
            struct.pack('<I', (0 if self.mask_coords is None or self.mask_coords is False else 1)),
            bytes(self.document),
            self.serialize_bytes(self.emoji),
            b'' if self.mask_coords is None or self.mask_coords is False else (bytes(self.mask_coords)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _document = reader.tgread_object()
        _emoji = reader.tgread_string()
        if flags & 1:
            _mask_coords = reader.tgread_object()
        else:
            _mask_coords = None
        return cls(document=_document, emoji=_emoji, mask_coords=_mask_coords)


class InputStickerSetShortName(TLObject):
    CONSTRUCTOR_ID = 0x861cc8a0
    SUBCLASS_OF_ID = 0x3da389aa

    def __init__(self, short_name: str):
        """
        Constructor for InputStickerSet: Instance of either InputStickerSetEmpty, InputStickerSetID, InputStickerSetShortName, InputStickerSetAnimatedEmoji.
        """
        self.short_name = short_name

    def to_dict(self):
        return {
            '_': 'InputStickerSetShortName',
            'short_name': self.short_name
        }

    def __bytes__(self):
        return b''.join((
            b'\xa0\xc8\x1c\x86',
            self.serialize_bytes(self.short_name),
        ))

    @classmethod
    def from_reader(cls, reader):
        _short_name = reader.tgread_string()
        return cls(short_name=_short_name)


class InputStickerSetThumb(TLObject):
    CONSTRUCTOR_ID = 0xdbaeae9
    SUBCLASS_OF_ID = 0x1523d462

    def __init__(self, stickerset: 'TypeInputStickerSet', volume_id: int, local_id: int):
        """
        Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb.
        """
        self.stickerset = stickerset
        self.volume_id = volume_id
        self.local_id = local_id

    def to_dict(self):
        return {
            '_': 'InputStickerSetThumb',
            'stickerset': self.stickerset.to_dict() if isinstance(self.stickerset, TLObject) else self.stickerset,
            'volume_id': self.volume_id,
            'local_id': self.local_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xe9\xea\xba\r',
            bytes(self.stickerset),
            struct.pack('<q', self.volume_id),
            struct.pack('<i', self.local_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _stickerset = reader.tgread_object()
        _volume_id = reader.read_long()
        _local_id = reader.read_int()
        return cls(stickerset=_stickerset, volume_id=_volume_id, local_id=_local_id)


class InputStickeredMediaDocument(TLObject):
    CONSTRUCTOR_ID = 0x438865b
    SUBCLASS_OF_ID = 0x5146d99e

    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputDocument'):
        """
        Constructor for InputStickeredMedia: Instance of either InputStickeredMediaPhoto, InputStickeredMediaDocument.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'InputStickeredMediaDocument',
            'id': self.id.to_dict() if isinstance(self.id, TLObject) else self.id
        }

    def __bytes__(self):
        return b''.join((
            b'[\x868\x04',
            bytes(self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_object()
        return cls(id=_id)


class InputStickeredMediaPhoto(TLObject):
    CONSTRUCTOR_ID = 0x4a992157
    SUBCLASS_OF_ID = 0x5146d99e

    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputPhoto'):
        """
        Constructor for InputStickeredMedia: Instance of either InputStickeredMediaPhoto, InputStickeredMediaDocument.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'InputStickeredMediaPhoto',
            'id': self.id.to_dict() if isinstance(self.id, TLObject) else self.id
        }

    def __bytes__(self):
        return b''.join((
            b'W!\x99J',
            bytes(self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_object()
        return cls(id=_id)


class InputTakeoutFileLocation(TLObject):
    CONSTRUCTOR_ID = 0x29be5899
    SUBCLASS_OF_ID = 0x1523d462

    def to_dict(self):
        return {
            '_': 'InputTakeoutFileLocation'
        }

    def __bytes__(self):
        return b''.join((
            b'\x99X\xbe)',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputTheme(TLObject):
    CONSTRUCTOR_ID = 0x3c5693e9
    SUBCLASS_OF_ID = 0x7a100f0

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        """
        Constructor for InputTheme: Instance of either InputTheme, InputThemeSlug.
        """
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputTheme',
            'id': self.id,
            'access_hash': self.access_hash
        }

    def __bytes__(self):
        return b''.join((
            b'\xe9\x93V<',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


class InputThemeSlug(TLObject):
    CONSTRUCTOR_ID = 0xf5890df1
    SUBCLASS_OF_ID = 0x7a100f0

    def __init__(self, slug: str):
        """
        Constructor for InputTheme: Instance of either InputTheme, InputThemeSlug.
        """
        self.slug = slug

    def to_dict(self):
        return {
            '_': 'InputThemeSlug',
            'slug': self.slug
        }

    def __bytes__(self):
        return b''.join((
            b'\xf1\r\x89\xf5',
            self.serialize_bytes(self.slug),
        ))

    @classmethod
    def from_reader(cls, reader):
        _slug = reader.tgread_string()
        return cls(slug=_slug)


class InputUser(TLObject):
    CONSTRUCTOR_ID = 0xd8292816
    SUBCLASS_OF_ID = 0xe669bf46

    def __init__(self, user_id: int, access_hash: int):
        """
        Constructor for InputUser: Instance of either InputUserEmpty, InputUserSelf, InputUser, InputUserFromMessage.
        """
        self.user_id = user_id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputUser',
            'user_id': self.user_id,
            'access_hash': self.access_hash
        }

    def __bytes__(self):
        return b''.join((
            b'\x16()\xd8',
            struct.pack('<i', self.user_id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        _access_hash = reader.read_long()
        return cls(user_id=_user_id, access_hash=_access_hash)


class InputUserEmpty(TLObject):
    CONSTRUCTOR_ID = 0xb98886cf
    SUBCLASS_OF_ID = 0xe669bf46

    def to_dict(self):
        return {
            '_': 'InputUserEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'\xcf\x86\x88\xb9',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputUserFromMessage(TLObject):
    CONSTRUCTOR_ID = 0x2d117597
    SUBCLASS_OF_ID = 0xe669bf46

    def __init__(self, peer: 'TypeInputPeer', msg_id: int, user_id: int):
        """
        Constructor for InputUser: Instance of either InputUserEmpty, InputUserSelf, InputUser, InputUserFromMessage.
        """
        self.peer = peer
        self.msg_id = msg_id
        self.user_id = user_id

    def to_dict(self):
        return {
            '_': 'InputUserFromMessage',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'msg_id': self.msg_id,
            'user_id': self.user_id
        }

    def __bytes__(self):
        return b''.join((
            b'\x97u\x11-',
            bytes(self.peer),
            struct.pack('<i', self.msg_id),
            struct.pack('<i', self.user_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        _user_id = reader.read_int()
        return cls(peer=_peer, msg_id=_msg_id, user_id=_user_id)


class InputUserSelf(TLObject):
    CONSTRUCTOR_ID = 0xf7c1b13f
    SUBCLASS_OF_ID = 0xe669bf46

    def to_dict(self):
        return {
            '_': 'InputUserSelf'
        }

    def __bytes__(self):
        return b''.join((
            b'?\xb1\xc1\xf7',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputWallPaper(TLObject):
    CONSTRUCTOR_ID = 0xe630b979
    SUBCLASS_OF_ID = 0xee77201a

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        """
        Constructor for InputWallPaper: Instance of either InputWallPaper, InputWallPaperSlug.
        """
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputWallPaper',
            'id': self.id,
            'access_hash': self.access_hash
        }

    def __bytes__(self):
        return b''.join((
            b'y\xb90\xe6',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


class InputWallPaperSlug(TLObject):
    CONSTRUCTOR_ID = 0x72091c80
    SUBCLASS_OF_ID = 0xee77201a

    def __init__(self, slug: str):
        """
        Constructor for InputWallPaper: Instance of either InputWallPaper, InputWallPaperSlug.
        """
        self.slug = slug

    def to_dict(self):
        return {
            '_': 'InputWallPaperSlug',
            'slug': self.slug
        }

    def __bytes__(self):
        return b''.join((
            b'\x80\x1c\tr',
            self.serialize_bytes(self.slug),
        ))

    @classmethod
    def from_reader(cls, reader):
        _slug = reader.tgread_string()
        return cls(slug=_slug)


class InputWebDocument(TLObject):
    CONSTRUCTOR_ID = 0x9bed434d
    SUBCLASS_OF_ID = 0x8ae8b146

    def __init__(self, url: str, size: int, mime_type: str, attributes: List['TypeDocumentAttribute']):
        """
        Constructor for InputWebDocument: Instance of InputWebDocument.
        """
        self.url = url
        self.size = size
        self.mime_type = mime_type
        self.attributes = attributes

    def to_dict(self):
        return {
            '_': 'InputWebDocument',
            'url': self.url,
            'size': self.size,
            'mime_type': self.mime_type,
            'attributes': [] if self.attributes is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.attributes]
        }

    def __bytes__(self):
        return b''.join((
            b'MC\xed\x9b',
            self.serialize_bytes(self.url),
            struct.pack('<i', self.size),
            self.serialize_bytes(self.mime_type),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.attributes)),b''.join(bytes(x) for x in self.attributes),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        _size = reader.read_int()
        _mime_type = reader.tgread_string()
        reader.read_int()
        _attributes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _attributes.append(_x)

        return cls(url=_url, size=_size, mime_type=_mime_type, attributes=_attributes)


class InputWebFileGeoPointLocation(TLObject):
    CONSTRUCTOR_ID = 0x9f2221c9
    SUBCLASS_OF_ID = 0xf72ed8d9

    def __init__(self, geo_point: 'TypeInputGeoPoint', access_hash: int, w: int, h: int, zoom: int, scale: int):
        """
        Constructor for InputWebFileLocation: Instance of either InputWebFileLocation, InputWebFileGeoPointLocation.
        """
        self.geo_point = geo_point
        self.access_hash = access_hash
        self.w = w
        self.h = h
        self.zoom = zoom
        self.scale = scale

    def to_dict(self):
        return {
            '_': 'InputWebFileGeoPointLocation',
            'geo_point': self.geo_point.to_dict() if isinstance(self.geo_point, TLObject) else self.geo_point,
            'access_hash': self.access_hash,
            'w': self.w,
            'h': self.h,
            'zoom': self.zoom,
            'scale': self.scale
        }

    def __bytes__(self):
        return b''.join((
            b'\xc9!"\x9f',
            bytes(self.geo_point),
            struct.pack('<q', self.access_hash),
            struct.pack('<i', self.w),
            struct.pack('<i', self.h),
            struct.pack('<i', self.zoom),
            struct.pack('<i', self.scale),
        ))

    @classmethod
    def from_reader(cls, reader):
        _geo_point = reader.tgread_object()
        _access_hash = reader.read_long()
        _w = reader.read_int()
        _h = reader.read_int()
        _zoom = reader.read_int()
        _scale = reader.read_int()
        return cls(geo_point=_geo_point, access_hash=_access_hash, w=_w, h=_h, zoom=_zoom, scale=_scale)


class InputWebFileLocation(TLObject):
    CONSTRUCTOR_ID = 0xc239d686
    SUBCLASS_OF_ID = 0xf72ed8d9

    def __init__(self, url: str, access_hash: int):
        """
        Constructor for InputWebFileLocation: Instance of either InputWebFileLocation, InputWebFileGeoPointLocation.
        """
        self.url = url
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputWebFileLocation',
            'url': self.url,
            'access_hash': self.access_hash
        }

    def __bytes__(self):
        return b''.join((
            b'\x86\xd69\xc2',
            self.serialize_bytes(self.url),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        _access_hash = reader.read_long()
        return cls(url=_url, access_hash=_access_hash)


class Invoice(TLObject):
    CONSTRUCTOR_ID = 0xc30aa358
    SUBCLASS_OF_ID = 0x5fd82ed8

    def __init__(self, currency: str, prices: List['TypeLabeledPrice'], test: Optional[bool]=None, name_requested: Optional[bool]=None, phone_requested: Optional[bool]=None, email_requested: Optional[bool]=None, shipping_address_requested: Optional[bool]=None, flexible: Optional[bool]=None, phone_to_provider: Optional[bool]=None, email_to_provider: Optional[bool]=None):
        """
        Constructor for Invoice: Instance of Invoice.
        """
        self.currency = currency
        self.prices = prices
        self.test = test
        self.name_requested = name_requested
        self.phone_requested = phone_requested
        self.email_requested = email_requested
        self.shipping_address_requested = shipping_address_requested
        self.flexible = flexible
        self.phone_to_provider = phone_to_provider
        self.email_to_provider = email_to_provider

    def to_dict(self):
        return {
            '_': 'Invoice',
            'currency': self.currency,
            'prices': [] if self.prices is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.prices],
            'test': self.test,
            'name_requested': self.name_requested,
            'phone_requested': self.phone_requested,
            'email_requested': self.email_requested,
            'shipping_address_requested': self.shipping_address_requested,
            'flexible': self.flexible,
            'phone_to_provider': self.phone_to_provider,
            'email_to_provider': self.email_to_provider
        }

    def __bytes__(self):
        return b''.join((
            b'X\xa3\n\xc3',
            struct.pack('<I', (0 if self.test is None or self.test is False else 1) | (0 if self.name_requested is None or self.name_requested is False else 2) | (0 if self.phone_requested is None or self.phone_requested is False else 4) | (0 if self.email_requested is None or self.email_requested is False else 8) | (0 if self.shipping_address_requested is None or self.shipping_address_requested is False else 16) | (0 if self.flexible is None or self.flexible is False else 32) | (0 if self.phone_to_provider is None or self.phone_to_provider is False else 64) | (0 if self.email_to_provider is None or self.email_to_provider is False else 128)),
            self.serialize_bytes(self.currency),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.prices)),b''.join(bytes(x) for x in self.prices),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _test = bool(flags & 1)
        _name_requested = bool(flags & 2)
        _phone_requested = bool(flags & 4)
        _email_requested = bool(flags & 8)
        _shipping_address_requested = bool(flags & 16)
        _flexible = bool(flags & 32)
        _phone_to_provider = bool(flags & 64)
        _email_to_provider = bool(flags & 128)
        _currency = reader.tgread_string()
        reader.read_int()
        _prices = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _prices.append(_x)

        return cls(currency=_currency, prices=_prices, test=_test, name_requested=_name_requested, phone_requested=_phone_requested, email_requested=_email_requested, shipping_address_requested=_shipping_address_requested, flexible=_flexible, phone_to_provider=_phone_to_provider, email_to_provider=_email_to_provider)


class IpPort(TLObject):
    CONSTRUCTOR_ID = 0xd433ad73
    SUBCLASS_OF_ID = 0xa2a03726

    def __init__(self, ipv4: int, port: int):
        """
        Constructor for IpPort: Instance of either IpPort, IpPortSecret.
        """
        self.ipv4 = ipv4
        self.port = port

    def to_dict(self):
        return {
            '_': 'IpPort',
            'ipv4': self.ipv4,
            'port': self.port
        }

    def __bytes__(self):
        return b''.join((
            b's\xad3\xd4',
            struct.pack('<i', self.ipv4),
            struct.pack('<i', self.port),
        ))

    @classmethod
    def from_reader(cls, reader):
        _ipv4 = reader.read_int()
        _port = reader.read_int()
        return cls(ipv4=_ipv4, port=_port)


class IpPortSecret(TLObject):
    CONSTRUCTOR_ID = 0x37982646
    SUBCLASS_OF_ID = 0xa2a03726

    def __init__(self, ipv4: int, port: int, secret: bytes):
        """
        Constructor for IpPort: Instance of either IpPort, IpPortSecret.
        """
        self.ipv4 = ipv4
        self.port = port
        self.secret = secret

    def to_dict(self):
        return {
            '_': 'IpPortSecret',
            'ipv4': self.ipv4,
            'port': self.port,
            'secret': self.secret
        }

    def __bytes__(self):
        return b''.join((
            b'F&\x987',
            struct.pack('<i', self.ipv4),
            struct.pack('<i', self.port),
            self.serialize_bytes(self.secret),
        ))

    @classmethod
    def from_reader(cls, reader):
        _ipv4 = reader.read_int()
        _port = reader.read_int()
        _secret = reader.tgread_bytes()
        return cls(ipv4=_ipv4, port=_port, secret=_secret)


class JsonArray(TLObject):
    CONSTRUCTOR_ID = 0xf7444763
    SUBCLASS_OF_ID = 0xeb9987b3

    def __init__(self, value: List['TypeJSONValue']):
        """
        Constructor for JSONValue: Instance of either JsonNull, JsonBool, JsonNumber, JsonString, JsonArray, JsonObject.
        """
        self.value = value

    def to_dict(self):
        return {
            '_': 'JsonArray',
            'value': [] if self.value is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.value]
        }

    def __bytes__(self):
        return b''.join((
            b'cGD\xf7',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.value)),b''.join(bytes(x) for x in self.value),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _value = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _value.append(_x)

        return cls(value=_value)


class JsonBool(TLObject):
    CONSTRUCTOR_ID = 0xc7345e6a
    SUBCLASS_OF_ID = 0xeb9987b3

    def __init__(self, value: bool):
        """
        Constructor for JSONValue: Instance of either JsonNull, JsonBool, JsonNumber, JsonString, JsonArray, JsonObject.
        """
        self.value = value

    def to_dict(self):
        return {
            '_': 'JsonBool',
            'value': self.value
        }

    def __bytes__(self):
        return b''.join((
            b'j^4\xc7',
            b'\xb5ur\x99' if self.value else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _value = reader.tgread_bool()
        return cls(value=_value)


class JsonNull(TLObject):
    CONSTRUCTOR_ID = 0x3f6d7b68
    SUBCLASS_OF_ID = 0xeb9987b3

    def to_dict(self):
        return {
            '_': 'JsonNull'
        }

    def __bytes__(self):
        return b''.join((
            b'h{m?',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class JsonNumber(TLObject):
    CONSTRUCTOR_ID = 0x2be0dfa4
    SUBCLASS_OF_ID = 0xeb9987b3

    def __init__(self, value: float):
        """
        Constructor for JSONValue: Instance of either JsonNull, JsonBool, JsonNumber, JsonString, JsonArray, JsonObject.
        """
        self.value = value

    def to_dict(self):
        return {
            '_': 'JsonNumber',
            'value': self.value
        }

    def __bytes__(self):
        return b''.join((
            b'\xa4\xdf\xe0+',
            struct.pack('<d', self.value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _value = reader.read_double()
        return cls(value=_value)


class JsonObject(TLObject):
    CONSTRUCTOR_ID = 0x99c1d49d
    SUBCLASS_OF_ID = 0xeb9987b3

    def __init__(self, value: List['TypeJSONObjectValue']):
        """
        Constructor for JSONValue: Instance of either JsonNull, JsonBool, JsonNumber, JsonString, JsonArray, JsonObject.
        """
        self.value = value

    def to_dict(self):
        return {
            '_': 'JsonObject',
            'value': [] if self.value is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.value]
        }

    def __bytes__(self):
        return b''.join((
            b'\x9d\xd4\xc1\x99',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.value)),b''.join(bytes(x) for x in self.value),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _value = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _value.append(_x)

        return cls(value=_value)


class JsonObjectValue(TLObject):
    CONSTRUCTOR_ID = 0xc0de1bd9
    SUBCLASS_OF_ID = 0x937fceb9

    def __init__(self, key: str, value: 'TypeJSONValue'):
        """
        Constructor for JSONObjectValue: Instance of JsonObjectValue.
        """
        self.key = key
        self.value = value

    def to_dict(self):
        return {
            '_': 'JsonObjectValue',
            'key': self.key,
            'value': self.value.to_dict() if isinstance(self.value, TLObject) else self.value
        }

    def __bytes__(self):
        return b''.join((
            b'\xd9\x1b\xde\xc0',
            self.serialize_bytes(self.key),
            bytes(self.value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _key = reader.tgread_string()
        _value = reader.tgread_object()
        return cls(key=_key, value=_value)


class JsonString(TLObject):
    CONSTRUCTOR_ID = 0xb71e767a
    SUBCLASS_OF_ID = 0xeb9987b3

    def __init__(self, value: str):
        """
        Constructor for JSONValue: Instance of either JsonNull, JsonBool, JsonNumber, JsonString, JsonArray, JsonObject.
        """
        self.value = value

    def to_dict(self):
        return {
            '_': 'JsonString',
            'value': self.value
        }

    def __bytes__(self):
        return b''.join((
            b'zv\x1e\xb7',
            self.serialize_bytes(self.value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _value = reader.tgread_string()
        return cls(value=_value)


class KeyboardButton(TLObject):
    CONSTRUCTOR_ID = 0xa2fa4880
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'KeyboardButton',
            'text': self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\x80H\xfa\xa2',
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        return cls(text=_text)


class KeyboardButtonBuy(TLObject):
    CONSTRUCTOR_ID = 0xafd93fbb
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'KeyboardButtonBuy',
            'text': self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\xbb?\xd9\xaf',
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        return cls(text=_text)


class KeyboardButtonCallback(TLObject):
    CONSTRUCTOR_ID = 0x683a5e46
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str, data: bytes):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth.
        """
        self.text = text
        self.data = data

    def to_dict(self):
        return {
            '_': 'KeyboardButtonCallback',
            'text': self.text,
            'data': self.data
        }

    def __bytes__(self):
        return b''.join((
            b'F^:h',
            self.serialize_bytes(self.text),
            self.serialize_bytes(self.data),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        _data = reader.tgread_bytes()
        return cls(text=_text, data=_data)


class KeyboardButtonGame(TLObject):
    CONSTRUCTOR_ID = 0x50f41ccf
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'KeyboardButtonGame',
            'text': self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\xcf\x1c\xf4P',
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        return cls(text=_text)


class KeyboardButtonRequestGeoLocation(TLObject):
    CONSTRUCTOR_ID = 0xfc796b3f
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'KeyboardButtonRequestGeoLocation',
            'text': self.text
        }

    def __bytes__(self):
        return b''.join((
            b'?ky\xfc',
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        return cls(text=_text)


class KeyboardButtonRequestPhone(TLObject):
    CONSTRUCTOR_ID = 0xb16a6c29
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'KeyboardButtonRequestPhone',
            'text': self.text
        }

    def __bytes__(self):
        return b''.join((
            b')lj\xb1',
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        return cls(text=_text)


class KeyboardButtonRow(TLObject):
    CONSTRUCTOR_ID = 0x77608b83
    SUBCLASS_OF_ID = 0x847730ae

    def __init__(self, buttons: List['TypeKeyboardButton']):
        """
        Constructor for KeyboardButtonRow: Instance of KeyboardButtonRow.
        """
        self.buttons = buttons

    def to_dict(self):
        return {
            '_': 'KeyboardButtonRow',
            'buttons': [] if self.buttons is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.buttons]
        }

    def __bytes__(self):
        return b''.join((
            b'\x83\x8b`w',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.buttons)),b''.join(bytes(x) for x in self.buttons),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _buttons = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _buttons.append(_x)

        return cls(buttons=_buttons)


class KeyboardButtonSwitchInline(TLObject):
    CONSTRUCTOR_ID = 0x568a748
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str, query: str, same_peer: Optional[bool]=None):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth.
        """
        self.text = text
        self.query = query
        self.same_peer = same_peer

    def to_dict(self):
        return {
            '_': 'KeyboardButtonSwitchInline',
            'text': self.text,
            'query': self.query,
            'same_peer': self.same_peer
        }

    def __bytes__(self):
        return b''.join((
            b'H\xa7h\x05',
            struct.pack('<I', (0 if self.same_peer is None or self.same_peer is False else 1)),
            self.serialize_bytes(self.text),
            self.serialize_bytes(self.query),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _same_peer = bool(flags & 1)
        _text = reader.tgread_string()
        _query = reader.tgread_string()
        return cls(text=_text, query=_query, same_peer=_same_peer)


class KeyboardButtonUrl(TLObject):
    CONSTRUCTOR_ID = 0x258aff05
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str, url: str):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth.
        """
        self.text = text
        self.url = url

    def to_dict(self):
        return {
            '_': 'KeyboardButtonUrl',
            'text': self.text,
            'url': self.url
        }

    def __bytes__(self):
        return b''.join((
            b'\x05\xff\x8a%',
            self.serialize_bytes(self.text),
            self.serialize_bytes(self.url),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        _url = reader.tgread_string()
        return cls(text=_text, url=_url)


class KeyboardButtonUrlAuth(TLObject):
    CONSTRUCTOR_ID = 0x10b78d29
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str, url: str, button_id: int, fwd_text: Optional[str]=None):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth.
        """
        self.text = text
        self.url = url
        self.button_id = button_id
        self.fwd_text = fwd_text

    def to_dict(self):
        return {
            '_': 'KeyboardButtonUrlAuth',
            'text': self.text,
            'url': self.url,
            'button_id': self.button_id,
            'fwd_text': self.fwd_text
        }

    def __bytes__(self):
        return b''.join((
            b')\x8d\xb7\x10',
            struct.pack('<I', (0 if self.fwd_text is None or self.fwd_text is False else 1)),
            self.serialize_bytes(self.text),
            b'' if self.fwd_text is None or self.fwd_text is False else (self.serialize_bytes(self.fwd_text)),
            self.serialize_bytes(self.url),
            struct.pack('<i', self.button_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _text = reader.tgread_string()
        if flags & 1:
            _fwd_text = reader.tgread_string()
        else:
            _fwd_text = None
        _url = reader.tgread_string()
        _button_id = reader.read_int()
        return cls(text=_text, url=_url, button_id=_button_id, fwd_text=_fwd_text)


class LabeledPrice(TLObject):
    CONSTRUCTOR_ID = 0xcb296bf8
    SUBCLASS_OF_ID = 0x1c84047a

    def __init__(self, label: str, amount: int):
        """
        Constructor for LabeledPrice: Instance of LabeledPrice.
        """
        self.label = label
        self.amount = amount

    def to_dict(self):
        return {
            '_': 'LabeledPrice',
            'label': self.label,
            'amount': self.amount
        }

    def __bytes__(self):
        return b''.join((
            b'\xf8k)\xcb',
            self.serialize_bytes(self.label),
            struct.pack('<q', self.amount),
        ))

    @classmethod
    def from_reader(cls, reader):
        _label = reader.tgread_string()
        _amount = reader.read_long()
        return cls(label=_label, amount=_amount)


class LangPackDifference(TLObject):
    CONSTRUCTOR_ID = 0xf385c1f6
    SUBCLASS_OF_ID = 0x52662d55

    def __init__(self, lang_code: str, from_version: int, version: int, strings: List['TypeLangPackString']):
        """
        Constructor for LangPackDifference: Instance of LangPackDifference.
        """
        self.lang_code = lang_code
        self.from_version = from_version
        self.version = version
        self.strings = strings

    def to_dict(self):
        return {
            '_': 'LangPackDifference',
            'lang_code': self.lang_code,
            'from_version': self.from_version,
            'version': self.version,
            'strings': [] if self.strings is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.strings]
        }

    def __bytes__(self):
        return b''.join((
            b'\xf6\xc1\x85\xf3',
            self.serialize_bytes(self.lang_code),
            struct.pack('<i', self.from_version),
            struct.pack('<i', self.version),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.strings)),b''.join(bytes(x) for x in self.strings),
        ))

    @classmethod
    def from_reader(cls, reader):
        _lang_code = reader.tgread_string()
        _from_version = reader.read_int()
        _version = reader.read_int()
        reader.read_int()
        _strings = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _strings.append(_x)

        return cls(lang_code=_lang_code, from_version=_from_version, version=_version, strings=_strings)


class LangPackLanguage(TLObject):
    CONSTRUCTOR_ID = 0xeeca5ce3
    SUBCLASS_OF_ID = 0xabac89b7

    def __init__(self, name: str, native_name: str, lang_code: str, plural_code: str, strings_count: int, translated_count: int, translations_url: str, official: Optional[bool]=None, rtl: Optional[bool]=None, beta: Optional[bool]=None, base_lang_code: Optional[str]=None):
        """
        Constructor for LangPackLanguage: Instance of LangPackLanguage.
        """
        self.name = name
        self.native_name = native_name
        self.lang_code = lang_code
        self.plural_code = plural_code
        self.strings_count = strings_count
        self.translated_count = translated_count
        self.translations_url = translations_url
        self.official = official
        self.rtl = rtl
        self.beta = beta
        self.base_lang_code = base_lang_code

    def to_dict(self):
        return {
            '_': 'LangPackLanguage',
            'name': self.name,
            'native_name': self.native_name,
            'lang_code': self.lang_code,
            'plural_code': self.plural_code,
            'strings_count': self.strings_count,
            'translated_count': self.translated_count,
            'translations_url': self.translations_url,
            'official': self.official,
            'rtl': self.rtl,
            'beta': self.beta,
            'base_lang_code': self.base_lang_code
        }

    def __bytes__(self):
        return b''.join((
            b'\xe3\\\xca\xee',
            struct.pack('<I', (0 if self.official is None or self.official is False else 1) | (0 if self.rtl is None or self.rtl is False else 4) | (0 if self.beta is None or self.beta is False else 8) | (0 if self.base_lang_code is None or self.base_lang_code is False else 2)),
            self.serialize_bytes(self.name),
            self.serialize_bytes(self.native_name),
            self.serialize_bytes(self.lang_code),
            b'' if self.base_lang_code is None or self.base_lang_code is False else (self.serialize_bytes(self.base_lang_code)),
            self.serialize_bytes(self.plural_code),
            struct.pack('<i', self.strings_count),
            struct.pack('<i', self.translated_count),
            self.serialize_bytes(self.translations_url),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _official = bool(flags & 1)
        _rtl = bool(flags & 4)
        _beta = bool(flags & 8)
        _name = reader.tgread_string()
        _native_name = reader.tgread_string()
        _lang_code = reader.tgread_string()
        if flags & 2:
            _base_lang_code = reader.tgread_string()
        else:
            _base_lang_code = None
        _plural_code = reader.tgread_string()
        _strings_count = reader.read_int()
        _translated_count = reader.read_int()
        _translations_url = reader.tgread_string()
        return cls(name=_name, native_name=_native_name, lang_code=_lang_code, plural_code=_plural_code, strings_count=_strings_count, translated_count=_translated_count, translations_url=_translations_url, official=_official, rtl=_rtl, beta=_beta, base_lang_code=_base_lang_code)


class LangPackString(TLObject):
    CONSTRUCTOR_ID = 0xcad181f6
    SUBCLASS_OF_ID = 0xdc179ab9

    def __init__(self, key: str, value: str):
        """
        Constructor for LangPackString: Instance of either LangPackString, LangPackStringPluralized, LangPackStringDeleted.
        """
        self.key = key
        self.value = value

    def to_dict(self):
        return {
            '_': 'LangPackString',
            'key': self.key,
            'value': self.value
        }

    def __bytes__(self):
        return b''.join((
            b'\xf6\x81\xd1\xca',
            self.serialize_bytes(self.key),
            self.serialize_bytes(self.value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _key = reader.tgread_string()
        _value = reader.tgread_string()
        return cls(key=_key, value=_value)


class LangPackStringDeleted(TLObject):
    CONSTRUCTOR_ID = 0x2979eeb2
    SUBCLASS_OF_ID = 0xdc179ab9

    def __init__(self, key: str):
        """
        Constructor for LangPackString: Instance of either LangPackString, LangPackStringPluralized, LangPackStringDeleted.
        """
        self.key = key

    def to_dict(self):
        return {
            '_': 'LangPackStringDeleted',
            'key': self.key
        }

    def __bytes__(self):
        return b''.join((
            b'\xb2\xeey)',
            self.serialize_bytes(self.key),
        ))

    @classmethod
    def from_reader(cls, reader):
        _key = reader.tgread_string()
        return cls(key=_key)


class LangPackStringPluralized(TLObject):
    CONSTRUCTOR_ID = 0x6c47ac9f
    SUBCLASS_OF_ID = 0xdc179ab9

    def __init__(self, key: str, other_value: str, zero_value: Optional[str]=None, one_value: Optional[str]=None, two_value: Optional[str]=None, few_value: Optional[str]=None, many_value: Optional[str]=None):
        """
        Constructor for LangPackString: Instance of either LangPackString, LangPackStringPluralized, LangPackStringDeleted.
        """
        self.key = key
        self.other_value = other_value
        self.zero_value = zero_value
        self.one_value = one_value
        self.two_value = two_value
        self.few_value = few_value
        self.many_value = many_value

    def to_dict(self):
        return {
            '_': 'LangPackStringPluralized',
            'key': self.key,
            'other_value': self.other_value,
            'zero_value': self.zero_value,
            'one_value': self.one_value,
            'two_value': self.two_value,
            'few_value': self.few_value,
            'many_value': self.many_value
        }

    def __bytes__(self):
        return b''.join((
            b'\x9f\xacGl',
            struct.pack('<I', (0 if self.zero_value is None or self.zero_value is False else 1) | (0 if self.one_value is None or self.one_value is False else 2) | (0 if self.two_value is None or self.two_value is False else 4) | (0 if self.few_value is None or self.few_value is False else 8) | (0 if self.many_value is None or self.many_value is False else 16)),
            self.serialize_bytes(self.key),
            b'' if self.zero_value is None or self.zero_value is False else (self.serialize_bytes(self.zero_value)),
            b'' if self.one_value is None or self.one_value is False else (self.serialize_bytes(self.one_value)),
            b'' if self.two_value is None or self.two_value is False else (self.serialize_bytes(self.two_value)),
            b'' if self.few_value is None or self.few_value is False else (self.serialize_bytes(self.few_value)),
            b'' if self.many_value is None or self.many_value is False else (self.serialize_bytes(self.many_value)),
            self.serialize_bytes(self.other_value),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _key = reader.tgread_string()
        if flags & 1:
            _zero_value = reader.tgread_string()
        else:
            _zero_value = None
        if flags & 2:
            _one_value = reader.tgread_string()
        else:
            _one_value = None
        if flags & 4:
            _two_value = reader.tgread_string()
        else:
            _two_value = None
        if flags & 8:
            _few_value = reader.tgread_string()
        else:
            _few_value = None
        if flags & 16:
            _many_value = reader.tgread_string()
        else:
            _many_value = None
        _other_value = reader.tgread_string()
        return cls(key=_key, other_value=_other_value, zero_value=_zero_value, one_value=_one_value, two_value=_two_value, few_value=_few_value, many_value=_many_value)


class MaskCoords(TLObject):
    CONSTRUCTOR_ID = 0xaed6dbb2
    SUBCLASS_OF_ID = 0x6bbb2fd

    def __init__(self, n: int, x: float, y: float, zoom: float):
        """
        Constructor for MaskCoords: Instance of MaskCoords.
        """
        self.n = n
        self.x = x
        self.y = y
        self.zoom = zoom

    def to_dict(self):
        return {
            '_': 'MaskCoords',
            'n': self.n,
            'x': self.x,
            'y': self.y,
            'zoom': self.zoom
        }

    def __bytes__(self):
        return b''.join((
            b'\xb2\xdb\xd6\xae',
            struct.pack('<i', self.n),
            struct.pack('<d', self.x),
            struct.pack('<d', self.y),
            struct.pack('<d', self.zoom),
        ))

    @classmethod
    def from_reader(cls, reader):
        _n = reader.read_int()
        _x = reader.read_double()
        _y = reader.read_double()
        _zoom = reader.read_double()
        return cls(n=_n, x=_x, y=_y, zoom=_zoom)
Message = None  # Patched


class MessageActionBotAllowed(TLObject):
    CONSTRUCTOR_ID = 0xabe9affe
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, domain: str):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp.
        """
        self.domain = domain

    def to_dict(self):
        return {
            '_': 'MessageActionBotAllowed',
            'domain': self.domain
        }

    def __bytes__(self):
        return b''.join((
            b'\xfe\xaf\xe9\xab',
            self.serialize_bytes(self.domain),
        ))

    @classmethod
    def from_reader(cls, reader):
        _domain = reader.tgread_string()
        return cls(domain=_domain)


class MessageActionChannelCreate(TLObject):
    CONSTRUCTOR_ID = 0x95d2ac92
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, title: str):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp.
        """
        self.title = title

    def to_dict(self):
        return {
            '_': 'MessageActionChannelCreate',
            'title': self.title
        }

    def __bytes__(self):
        return b''.join((
            b'\x92\xac\xd2\x95',
            self.serialize_bytes(self.title),
        ))

    @classmethod
    def from_reader(cls, reader):
        _title = reader.tgread_string()
        return cls(title=_title)


class MessageActionChannelMigrateFrom(TLObject):
    CONSTRUCTOR_ID = 0xb055eaee
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, title: str, chat_id: int):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp.
        """
        self.title = title
        self.chat_id = chat_id

    def to_dict(self):
        return {
            '_': 'MessageActionChannelMigrateFrom',
            'title': self.title,
            'chat_id': self.chat_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xee\xeaU\xb0',
            self.serialize_bytes(self.title),
            struct.pack('<i', self.chat_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _title = reader.tgread_string()
        _chat_id = reader.read_int()
        return cls(title=_title, chat_id=_chat_id)


class MessageActionChatAddUser(TLObject):
    CONSTRUCTOR_ID = 0x488a7337
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, users: List[int]):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp.
        """
        self.users = users

    def to_dict(self):
        return {
            '_': 'MessageActionChatAddUser',
            'users': [] if self.users is None else self.users[:]
        }

    def __bytes__(self):
        return b''.join((
            b'7s\x8aH',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(struct.pack('<i', x) for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _users.append(_x)

        return cls(users=_users)


class MessageActionChatCreate(TLObject):
    CONSTRUCTOR_ID = 0xa6638b9a
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, title: str, users: List[int]):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp.
        """
        self.title = title
        self.users = users

    def to_dict(self):
        return {
            '_': 'MessageActionChatCreate',
            'title': self.title,
            'users': [] if self.users is None else self.users[:]
        }

    def __bytes__(self):
        return b''.join((
            b'\x9a\x8bc\xa6',
            self.serialize_bytes(self.title),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(struct.pack('<i', x) for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        _title = reader.tgread_string()
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _users.append(_x)

        return cls(title=_title, users=_users)


class MessageActionChatDeletePhoto(TLObject):
    CONSTRUCTOR_ID = 0x95e3fbef
    SUBCLASS_OF_ID = 0x8680d126

    def to_dict(self):
        return {
            '_': 'MessageActionChatDeletePhoto'
        }

    def __bytes__(self):
        return b''.join((
            b'\xef\xfb\xe3\x95',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class MessageActionChatDeleteUser(TLObject):
    CONSTRUCTOR_ID = 0xb2ae9b0c
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, user_id: int):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp.
        """
        self.user_id = user_id

    def to_dict(self):
        return {
            '_': 'MessageActionChatDeleteUser',
            'user_id': self.user_id
        }

    def __bytes__(self):
        return b''.join((
            b'\x0c\x9b\xae\xb2',
            struct.pack('<i', self.user_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        return cls(user_id=_user_id)


class MessageActionChatEditPhoto(TLObject):
    CONSTRUCTOR_ID = 0x7fcb13a8
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, photo: 'TypePhoto'):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp.
        """
        self.photo = photo

    def to_dict(self):
        return {
            '_': 'MessageActionChatEditPhoto',
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo
        }

    def __bytes__(self):
        return b''.join((
            b'\xa8\x13\xcb\x7f',
            bytes(self.photo),
        ))

    @classmethod
    def from_reader(cls, reader):
        _photo = reader.tgread_object()
        return cls(photo=_photo)


class MessageActionChatEditTitle(TLObject):
    CONSTRUCTOR_ID = 0xb5a1ce5a
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, title: str):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp.
        """
        self.title = title

    def to_dict(self):
        return {
            '_': 'MessageActionChatEditTitle',
            'title': self.title
        }

    def __bytes__(self):
        return b''.join((
            b'Z\xce\xa1\xb5',
            self.serialize_bytes(self.title),
        ))

    @classmethod
    def from_reader(cls, reader):
        _title = reader.tgread_string()
        return cls(title=_title)


class MessageActionChatJoinedByLink(TLObject):
    CONSTRUCTOR_ID = 0xf89cf5e8
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, inviter_id: int):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp.
        """
        self.inviter_id = inviter_id

    def to_dict(self):
        return {
            '_': 'MessageActionChatJoinedByLink',
            'inviter_id': self.inviter_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xe8\xf5\x9c\xf8',
            struct.pack('<i', self.inviter_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _inviter_id = reader.read_int()
        return cls(inviter_id=_inviter_id)


class MessageActionChatMigrateTo(TLObject):
    CONSTRUCTOR_ID = 0x51bdb021
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, channel_id: int):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp.
        """
        self.channel_id = channel_id

    def to_dict(self):
        return {
            '_': 'MessageActionChatMigrateTo',
            'channel_id': self.channel_id
        }

    def __bytes__(self):
        return b''.join((
            b'!\xb0\xbdQ',
            struct.pack('<i', self.channel_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel_id = reader.read_int()
        return cls(channel_id=_channel_id)


class MessageActionContactSignUp(TLObject):
    CONSTRUCTOR_ID = 0xf3f25f76
    SUBCLASS_OF_ID = 0x8680d126

    def to_dict(self):
        return {
            '_': 'MessageActionContactSignUp'
        }

    def __bytes__(self):
        return b''.join((
            b'v_\xf2\xf3',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class MessageActionCustomAction(TLObject):
    CONSTRUCTOR_ID = 0xfae69f56
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, message: str):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp.
        """
        self.message = message

    def to_dict(self):
        return {
            '_': 'MessageActionCustomAction',
            'message': self.message
        }

    def __bytes__(self):
        return b''.join((
            b'V\x9f\xe6\xfa',
            self.serialize_bytes(self.message),
        ))

    @classmethod
    def from_reader(cls, reader):
        _message = reader.tgread_string()
        return cls(message=_message)


class MessageActionEmpty(TLObject):
    CONSTRUCTOR_ID = 0xb6aef7b0
    SUBCLASS_OF_ID = 0x8680d126

    def to_dict(self):
        return {
            '_': 'MessageActionEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'\xb0\xf7\xae\xb6',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class MessageActionGameScore(TLObject):
    CONSTRUCTOR_ID = 0x92a72876
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, game_id: int, score: int):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp.
        """
        self.game_id = game_id
        self.score = score

    def to_dict(self):
        return {
            '_': 'MessageActionGameScore',
            'game_id': self.game_id,
            'score': self.score
        }

    def __bytes__(self):
        return b''.join((
            b'v(\xa7\x92',
            struct.pack('<q', self.game_id),
            struct.pack('<i', self.score),
        ))

    @classmethod
    def from_reader(cls, reader):
        _game_id = reader.read_long()
        _score = reader.read_int()
        return cls(game_id=_game_id, score=_score)


class MessageActionHistoryClear(TLObject):
    CONSTRUCTOR_ID = 0x9fbab604
    SUBCLASS_OF_ID = 0x8680d126

    def to_dict(self):
        return {
            '_': 'MessageActionHistoryClear'
        }

    def __bytes__(self):
        return b''.join((
            b'\x04\xb6\xba\x9f',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class MessageActionPaymentSent(TLObject):
    CONSTRUCTOR_ID = 0x40699cd0
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, currency: str, total_amount: int):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp.
        """
        self.currency = currency
        self.total_amount = total_amount

    def to_dict(self):
        return {
            '_': 'MessageActionPaymentSent',
            'currency': self.currency,
            'total_amount': self.total_amount
        }

    def __bytes__(self):
        return b''.join((
            b'\xd0\x9ci@',
            self.serialize_bytes(self.currency),
            struct.pack('<q', self.total_amount),
        ))

    @classmethod
    def from_reader(cls, reader):
        _currency = reader.tgread_string()
        _total_amount = reader.read_long()
        return cls(currency=_currency, total_amount=_total_amount)


class MessageActionPaymentSentMe(TLObject):
    CONSTRUCTOR_ID = 0x8f31b327
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, currency: str, total_amount: int, payload: bytes, charge: 'TypePaymentCharge', info: Optional['TypePaymentRequestedInfo']=None, shipping_option_id: Optional[str]=None):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp.
        """
        self.currency = currency
        self.total_amount = total_amount
        self.payload = payload
        self.charge = charge
        self.info = info
        self.shipping_option_id = shipping_option_id

    def to_dict(self):
        return {
            '_': 'MessageActionPaymentSentMe',
            'currency': self.currency,
            'total_amount': self.total_amount,
            'payload': self.payload,
            'charge': self.charge.to_dict() if isinstance(self.charge, TLObject) else self.charge,
            'info': self.info.to_dict() if isinstance(self.info, TLObject) else self.info,
            'shipping_option_id': self.shipping_option_id
        }

    def __bytes__(self):
        return b''.join((
            b"'\xb31\x8f",
            struct.pack('<I', (0 if self.info is None or self.info is False else 1) | (0 if self.shipping_option_id is None or self.shipping_option_id is False else 2)),
            self.serialize_bytes(self.currency),
            struct.pack('<q', self.total_amount),
            self.serialize_bytes(self.payload),
            b'' if self.info is None or self.info is False else (bytes(self.info)),
            b'' if self.shipping_option_id is None or self.shipping_option_id is False else (self.serialize_bytes(self.shipping_option_id)),
            bytes(self.charge),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _currency = reader.tgread_string()
        _total_amount = reader.read_long()
        _payload = reader.tgread_bytes()
        if flags & 1:
            _info = reader.tgread_object()
        else:
            _info = None
        if flags & 2:
            _shipping_option_id = reader.tgread_string()
        else:
            _shipping_option_id = None
        _charge = reader.tgread_object()
        return cls(currency=_currency, total_amount=_total_amount, payload=_payload, charge=_charge, info=_info, shipping_option_id=_shipping_option_id)


class MessageActionPhoneCall(TLObject):
    CONSTRUCTOR_ID = 0x80e11a7f
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, call_id: int, video: Optional[bool]=None, reason: Optional['TypePhoneCallDiscardReason']=None, duration: Optional[int]=None):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp.
        """
        self.call_id = call_id
        self.video = video
        self.reason = reason
        self.duration = duration

    def to_dict(self):
        return {
            '_': 'MessageActionPhoneCall',
            'call_id': self.call_id,
            'video': self.video,
            'reason': self.reason.to_dict() if isinstance(self.reason, TLObject) else self.reason,
            'duration': self.duration
        }

    def __bytes__(self):
        return b''.join((
            b'\x7f\x1a\xe1\x80',
            struct.pack('<I', (0 if self.video is None or self.video is False else 4) | (0 if self.reason is None or self.reason is False else 1) | (0 if self.duration is None or self.duration is False else 2)),
            struct.pack('<q', self.call_id),
            b'' if self.reason is None or self.reason is False else (bytes(self.reason)),
            b'' if self.duration is None or self.duration is False else (struct.pack('<i', self.duration)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _video = bool(flags & 4)
        _call_id = reader.read_long()
        if flags & 1:
            _reason = reader.tgread_object()
        else:
            _reason = None
        if flags & 2:
            _duration = reader.read_int()
        else:
            _duration = None
        return cls(call_id=_call_id, video=_video, reason=_reason, duration=_duration)


class MessageActionPinMessage(TLObject):
    CONSTRUCTOR_ID = 0x94bd38ed
    SUBCLASS_OF_ID = 0x8680d126

    def to_dict(self):
        return {
            '_': 'MessageActionPinMessage'
        }

    def __bytes__(self):
        return b''.join((
            b'\xed8\xbd\x94',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class MessageActionScreenshotTaken(TLObject):
    CONSTRUCTOR_ID = 0x4792929b
    SUBCLASS_OF_ID = 0x8680d126

    def to_dict(self):
        return {
            '_': 'MessageActionScreenshotTaken'
        }

    def __bytes__(self):
        return b''.join((
            b'\x9b\x92\x92G',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class MessageActionSecureValuesSent(TLObject):
    CONSTRUCTOR_ID = 0xd95c6154
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, types: List['TypeSecureValueType']):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp.
        """
        self.types = types

    def to_dict(self):
        return {
            '_': 'MessageActionSecureValuesSent',
            'types': [] if self.types is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.types]
        }

    def __bytes__(self):
        return b''.join((
            b'Ta\\\xd9',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.types)),b''.join(bytes(x) for x in self.types),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _types = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _types.append(_x)

        return cls(types=_types)


class MessageActionSecureValuesSentMe(TLObject):
    CONSTRUCTOR_ID = 0x1b287353
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, values: List['TypeSecureValue'], credentials: 'TypeSecureCredentialsEncrypted'):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp.
        """
        self.values = values
        self.credentials = credentials

    def to_dict(self):
        return {
            '_': 'MessageActionSecureValuesSentMe',
            'values': [] if self.values is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.values],
            'credentials': self.credentials.to_dict() if isinstance(self.credentials, TLObject) else self.credentials
        }

    def __bytes__(self):
        return b''.join((
            b'Ss(\x1b',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.values)),b''.join(bytes(x) for x in self.values),
            bytes(self.credentials),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _values = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _values.append(_x)

        _credentials = reader.tgread_object()
        return cls(values=_values, credentials=_credentials)
MessageEmpty = None  # Patched


class MessageEntityBlockquote(TLObject):
    CONSTRUCTOR_ID = 0x20df5d0
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityBlockquote',
            'offset': self.offset,
            'length': self.length
        }

    def __bytes__(self):
        return b''.join((
            b'\xd0\xf5\r\x02',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityBold(TLObject):
    CONSTRUCTOR_ID = 0xbd610bc9
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityBold',
            'offset': self.offset,
            'length': self.length
        }

    def __bytes__(self):
        return b''.join((
            b'\xc9\x0ba\xbd',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityBotCommand(TLObject):
    CONSTRUCTOR_ID = 0x6cef8ac7
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityBotCommand',
            'offset': self.offset,
            'length': self.length
        }

    def __bytes__(self):
        return b''.join((
            b'\xc7\x8a\xefl',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityCashtag(TLObject):
    CONSTRUCTOR_ID = 0x4c4e743f
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityCashtag',
            'offset': self.offset,
            'length': self.length
        }

    def __bytes__(self):
        return b''.join((
            b'?tNL',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityCode(TLObject):
    CONSTRUCTOR_ID = 0x28a20571
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityCode',
            'offset': self.offset,
            'length': self.length
        }

    def __bytes__(self):
        return b''.join((
            b'q\x05\xa2(',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityEmail(TLObject):
    CONSTRUCTOR_ID = 0x64e475c2
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityEmail',
            'offset': self.offset,
            'length': self.length
        }

    def __bytes__(self):
        return b''.join((
            b'\xc2u\xe4d',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityHashtag(TLObject):
    CONSTRUCTOR_ID = 0x6f635b0d
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityHashtag',
            'offset': self.offset,
            'length': self.length
        }

    def __bytes__(self):
        return b''.join((
            b'\r[co',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityItalic(TLObject):
    CONSTRUCTOR_ID = 0x826f8b60
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityItalic',
            'offset': self.offset,
            'length': self.length
        }

    def __bytes__(self):
        return b''.join((
            b'`\x8bo\x82',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityMention(TLObject):
    CONSTRUCTOR_ID = 0xfa04579d
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityMention',
            'offset': self.offset,
            'length': self.length
        }

    def __bytes__(self):
        return b''.join((
            b'\x9dW\x04\xfa',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityMentionName(TLObject):
    CONSTRUCTOR_ID = 0x352dca58
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int, user_id: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length
        self.user_id = user_id

    def to_dict(self):
        return {
            '_': 'MessageEntityMentionName',
            'offset': self.offset,
            'length': self.length,
            'user_id': self.user_id
        }

    def __bytes__(self):
        return b''.join((
            b'X\xca-5',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
            struct.pack('<i', self.user_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        _user_id = reader.read_int()
        return cls(offset=_offset, length=_length, user_id=_user_id)


class MessageEntityPhone(TLObject):
    CONSTRUCTOR_ID = 0x9b69e34b
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityPhone',
            'offset': self.offset,
            'length': self.length
        }

    def __bytes__(self):
        return b''.join((
            b'K\xe3i\x9b',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityPre(TLObject):
    CONSTRUCTOR_ID = 0x73924be0
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int, language: str):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length
        self.language = language

    def to_dict(self):
        return {
            '_': 'MessageEntityPre',
            'offset': self.offset,
            'length': self.length,
            'language': self.language
        }

    def __bytes__(self):
        return b''.join((
            b'\xe0K\x92s',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
            self.serialize_bytes(self.language),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        _language = reader.tgread_string()
        return cls(offset=_offset, length=_length, language=_language)


class MessageEntityStrike(TLObject):
    CONSTRUCTOR_ID = 0xbf0693d4
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityStrike',
            'offset': self.offset,
            'length': self.length
        }

    def __bytes__(self):
        return b''.join((
            b'\xd4\x93\x06\xbf',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityTextUrl(TLObject):
    CONSTRUCTOR_ID = 0x76a6d327
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int, url: str):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length
        self.url = url

    def to_dict(self):
        return {
            '_': 'MessageEntityTextUrl',
            'offset': self.offset,
            'length': self.length,
            'url': self.url
        }

    def __bytes__(self):
        return b''.join((
            b"'\xd3\xa6v",
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
            self.serialize_bytes(self.url),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        _url = reader.tgread_string()
        return cls(offset=_offset, length=_length, url=_url)


class MessageEntityUnderline(TLObject):
    CONSTRUCTOR_ID = 0x9c4e7e8b
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityUnderline',
            'offset': self.offset,
            'length': self.length
        }

    def __bytes__(self):
        return b''.join((
            b'\x8b~N\x9c',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityUnknown(TLObject):
    CONSTRUCTOR_ID = 0xbb92ba95
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityUnknown',
            'offset': self.offset,
            'length': self.length
        }

    def __bytes__(self):
        return b''.join((
            b'\x95\xba\x92\xbb',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityUrl(TLObject):
    CONSTRUCTOR_ID = 0x6ed02538
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityUrl',
            'offset': self.offset,
            'length': self.length
        }

    def __bytes__(self):
        return b''.join((
            b'8%\xd0n',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageFwdHeader(TLObject):
    CONSTRUCTOR_ID = 0xec338270
    SUBCLASS_OF_ID = 0x7a286804

    def __init__(self, date: Optional[datetime], from_id: Optional[int]=None, from_name: Optional[str]=None, channel_id: Optional[int]=None, channel_post: Optional[int]=None, post_author: Optional[str]=None, saved_from_peer: Optional['TypePeer']=None, saved_from_msg_id: Optional[int]=None):
        """
        Constructor for MessageFwdHeader: Instance of MessageFwdHeader.
        """
        self.date = date
        self.from_id = from_id
        self.from_name = from_name
        self.channel_id = channel_id
        self.channel_post = channel_post
        self.post_author = post_author
        self.saved_from_peer = saved_from_peer
        self.saved_from_msg_id = saved_from_msg_id

    def to_dict(self):
        return {
            '_': 'MessageFwdHeader',
            'date': self.date,
            'from_id': self.from_id,
            'from_name': self.from_name,
            'channel_id': self.channel_id,
            'channel_post': self.channel_post,
            'post_author': self.post_author,
            'saved_from_peer': self.saved_from_peer.to_dict() if isinstance(self.saved_from_peer, TLObject) else self.saved_from_peer,
            'saved_from_msg_id': self.saved_from_msg_id
        }

    def __bytes__(self):
        assert ((self.saved_from_peer or self.saved_from_peer is not None) and (self.saved_from_msg_id or self.saved_from_msg_id is not None)) or ((self.saved_from_peer is None or self.saved_from_peer is False) and (self.saved_from_msg_id is None or self.saved_from_msg_id is False)), 'saved_from_peer, saved_from_msg_id parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'p\x823\xec',
            struct.pack('<I', (0 if self.from_id is None or self.from_id is False else 1) | (0 if self.from_name is None or self.from_name is False else 32) | (0 if self.channel_id is None or self.channel_id is False else 2) | (0 if self.channel_post is None or self.channel_post is False else 4) | (0 if self.post_author is None or self.post_author is False else 8) | (0 if self.saved_from_peer is None or self.saved_from_peer is False else 16) | (0 if self.saved_from_msg_id is None or self.saved_from_msg_id is False else 16)),
            b'' if self.from_id is None or self.from_id is False else (struct.pack('<i', self.from_id)),
            b'' if self.from_name is None or self.from_name is False else (self.serialize_bytes(self.from_name)),
            self.serialize_datetime(self.date),
            b'' if self.channel_id is None or self.channel_id is False else (struct.pack('<i', self.channel_id)),
            b'' if self.channel_post is None or self.channel_post is False else (struct.pack('<i', self.channel_post)),
            b'' if self.post_author is None or self.post_author is False else (self.serialize_bytes(self.post_author)),
            b'' if self.saved_from_peer is None or self.saved_from_peer is False else (bytes(self.saved_from_peer)),
            b'' if self.saved_from_msg_id is None or self.saved_from_msg_id is False else (struct.pack('<i', self.saved_from_msg_id)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _from_id = reader.read_int()
        else:
            _from_id = None
        if flags & 32:
            _from_name = reader.tgread_string()
        else:
            _from_name = None
        _date = reader.tgread_date()
        if flags & 2:
            _channel_id = reader.read_int()
        else:
            _channel_id = None
        if flags & 4:
            _channel_post = reader.read_int()
        else:
            _channel_post = None
        if flags & 8:
            _post_author = reader.tgread_string()
        else:
            _post_author = None
        if flags & 16:
            _saved_from_peer = reader.tgread_object()
        else:
            _saved_from_peer = None
        if flags & 16:
            _saved_from_msg_id = reader.read_int()
        else:
            _saved_from_msg_id = None
        return cls(date=_date, from_id=_from_id, from_name=_from_name, channel_id=_channel_id, channel_post=_channel_post, post_author=_post_author, saved_from_peer=_saved_from_peer, saved_from_msg_id=_saved_from_msg_id)


class MessageMediaContact(TLObject):
    CONSTRUCTOR_ID = 0xcbf24940
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, phone_number: str, first_name: str, last_name: str, vcard: str, user_id: int):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll.
        """
        self.phone_number = phone_number
        self.first_name = first_name
        self.last_name = last_name
        self.vcard = vcard
        self.user_id = user_id

    def to_dict(self):
        return {
            '_': 'MessageMediaContact',
            'phone_number': self.phone_number,
            'first_name': self.first_name,
            'last_name': self.last_name,
            'vcard': self.vcard,
            'user_id': self.user_id
        }

    def __bytes__(self):
        return b''.join((
            b'@I\xf2\xcb',
            self.serialize_bytes(self.phone_number),
            self.serialize_bytes(self.first_name),
            self.serialize_bytes(self.last_name),
            self.serialize_bytes(self.vcard),
            struct.pack('<i', self.user_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _first_name = reader.tgread_string()
        _last_name = reader.tgread_string()
        _vcard = reader.tgread_string()
        _user_id = reader.read_int()
        return cls(phone_number=_phone_number, first_name=_first_name, last_name=_last_name, vcard=_vcard, user_id=_user_id)


class MessageMediaDocument(TLObject):
    CONSTRUCTOR_ID = 0x9cb070d7
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, document: Optional['TypeDocument']=None, ttl_seconds: Optional[int]=None):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll.
        """
        self.document = document
        self.ttl_seconds = ttl_seconds

    def to_dict(self):
        return {
            '_': 'MessageMediaDocument',
            'document': self.document.to_dict() if isinstance(self.document, TLObject) else self.document,
            'ttl_seconds': self.ttl_seconds
        }

    def __bytes__(self):
        return b''.join((
            b'\xd7p\xb0\x9c',
            struct.pack('<I', (0 if self.document is None or self.document is False else 1) | (0 if self.ttl_seconds is None or self.ttl_seconds is False else 4)),
            b'' if self.document is None or self.document is False else (bytes(self.document)),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _document = reader.tgread_object()
        else:
            _document = None
        if flags & 4:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(document=_document, ttl_seconds=_ttl_seconds)


class MessageMediaEmpty(TLObject):
    CONSTRUCTOR_ID = 0x3ded6320
    SUBCLASS_OF_ID = 0x476cbe32

    def to_dict(self):
        return {
            '_': 'MessageMediaEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b' c\xed=',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class MessageMediaGame(TLObject):
    CONSTRUCTOR_ID = 0xfdb19008
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, game: 'TypeGame'):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll.
        """
        self.game = game

    def to_dict(self):
        return {
            '_': 'MessageMediaGame',
            'game': self.game.to_dict() if isinstance(self.game, TLObject) else self.game
        }

    def __bytes__(self):
        return b''.join((
            b'\x08\x90\xb1\xfd',
            bytes(self.game),
        ))

    @classmethod
    def from_reader(cls, reader):
        _game = reader.tgread_object()
        return cls(game=_game)


class MessageMediaGeo(TLObject):
    CONSTRUCTOR_ID = 0x56e0d474
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, geo: 'TypeGeoPoint'):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll.
        """
        self.geo = geo

    def to_dict(self):
        return {
            '_': 'MessageMediaGeo',
            'geo': self.geo.to_dict() if isinstance(self.geo, TLObject) else self.geo
        }

    def __bytes__(self):
        return b''.join((
            b't\xd4\xe0V',
            bytes(self.geo),
        ))

    @classmethod
    def from_reader(cls, reader):
        _geo = reader.tgread_object()
        return cls(geo=_geo)


class MessageMediaGeoLive(TLObject):
    CONSTRUCTOR_ID = 0x7c3c2609
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, geo: 'TypeGeoPoint', period: int):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll.
        """
        self.geo = geo
        self.period = period

    def to_dict(self):
        return {
            '_': 'MessageMediaGeoLive',
            'geo': self.geo.to_dict() if isinstance(self.geo, TLObject) else self.geo,
            'period': self.period
        }

    def __bytes__(self):
        return b''.join((
            b'\t&<|',
            bytes(self.geo),
            struct.pack('<i', self.period),
        ))

    @classmethod
    def from_reader(cls, reader):
        _geo = reader.tgread_object()
        _period = reader.read_int()
        return cls(geo=_geo, period=_period)


class MessageMediaInvoice(TLObject):
    CONSTRUCTOR_ID = 0x84551347
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, title: str, description: str, currency: str, total_amount: int, start_param: str, shipping_address_requested: Optional[bool]=None, test: Optional[bool]=None, photo: Optional['TypeWebDocument']=None, receipt_msg_id: Optional[int]=None):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll.
        """
        self.title = title
        self.description = description
        self.currency = currency
        self.total_amount = total_amount
        self.start_param = start_param
        self.shipping_address_requested = shipping_address_requested
        self.test = test
        self.photo = photo
        self.receipt_msg_id = receipt_msg_id

    def to_dict(self):
        return {
            '_': 'MessageMediaInvoice',
            'title': self.title,
            'description': self.description,
            'currency': self.currency,
            'total_amount': self.total_amount,
            'start_param': self.start_param,
            'shipping_address_requested': self.shipping_address_requested,
            'test': self.test,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'receipt_msg_id': self.receipt_msg_id
        }

    def __bytes__(self):
        return b''.join((
            b'G\x13U\x84',
            struct.pack('<I', (0 if self.shipping_address_requested is None or self.shipping_address_requested is False else 2) | (0 if self.test is None or self.test is False else 8) | (0 if self.photo is None or self.photo is False else 1) | (0 if self.receipt_msg_id is None or self.receipt_msg_id is False else 4)),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.description),
            b'' if self.photo is None or self.photo is False else (bytes(self.photo)),
            b'' if self.receipt_msg_id is None or self.receipt_msg_id is False else (struct.pack('<i', self.receipt_msg_id)),
            self.serialize_bytes(self.currency),
            struct.pack('<q', self.total_amount),
            self.serialize_bytes(self.start_param),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _shipping_address_requested = bool(flags & 2)
        _test = bool(flags & 8)
        _title = reader.tgread_string()
        _description = reader.tgread_string()
        if flags & 1:
            _photo = reader.tgread_object()
        else:
            _photo = None
        if flags & 4:
            _receipt_msg_id = reader.read_int()
        else:
            _receipt_msg_id = None
        _currency = reader.tgread_string()
        _total_amount = reader.read_long()
        _start_param = reader.tgread_string()
        return cls(title=_title, description=_description, currency=_currency, total_amount=_total_amount, start_param=_start_param, shipping_address_requested=_shipping_address_requested, test=_test, photo=_photo, receipt_msg_id=_receipt_msg_id)


class MessageMediaPhoto(TLObject):
    CONSTRUCTOR_ID = 0x695150d7
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, photo: Optional['TypePhoto']=None, ttl_seconds: Optional[int]=None):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll.
        """
        self.photo = photo
        self.ttl_seconds = ttl_seconds

    def to_dict(self):
        return {
            '_': 'MessageMediaPhoto',
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'ttl_seconds': self.ttl_seconds
        }

    def __bytes__(self):
        return b''.join((
            b'\xd7PQi',
            struct.pack('<I', (0 if self.photo is None or self.photo is False else 1) | (0 if self.ttl_seconds is None or self.ttl_seconds is False else 4)),
            b'' if self.photo is None or self.photo is False else (bytes(self.photo)),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _photo = reader.tgread_object()
        else:
            _photo = None
        if flags & 4:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(photo=_photo, ttl_seconds=_ttl_seconds)


class MessageMediaPoll(TLObject):
    CONSTRUCTOR_ID = 0x4bd6e798
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, poll: 'TypePoll', results: 'TypePollResults'):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll.
        """
        self.poll = poll
        self.results = results

    def to_dict(self):
        return {
            '_': 'MessageMediaPoll',
            'poll': self.poll.to_dict() if isinstance(self.poll, TLObject) else self.poll,
            'results': self.results.to_dict() if isinstance(self.results, TLObject) else self.results
        }

    def __bytes__(self):
        return b''.join((
            b'\x98\xe7\xd6K',
            bytes(self.poll),
            bytes(self.results),
        ))

    @classmethod
    def from_reader(cls, reader):
        _poll = reader.tgread_object()
        _results = reader.tgread_object()
        return cls(poll=_poll, results=_results)


class MessageMediaUnsupported(TLObject):
    CONSTRUCTOR_ID = 0x9f84f49e
    SUBCLASS_OF_ID = 0x476cbe32

    def to_dict(self):
        return {
            '_': 'MessageMediaUnsupported'
        }

    def __bytes__(self):
        return b''.join((
            b'\x9e\xf4\x84\x9f',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class MessageMediaVenue(TLObject):
    CONSTRUCTOR_ID = 0x2ec0533f
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, geo: 'TypeGeoPoint', title: str, address: str, provider: str, venue_id: str, venue_type: str):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll.
        """
        self.geo = geo
        self.title = title
        self.address = address
        self.provider = provider
        self.venue_id = venue_id
        self.venue_type = venue_type

    def to_dict(self):
        return {
            '_': 'MessageMediaVenue',
            'geo': self.geo.to_dict() if isinstance(self.geo, TLObject) else self.geo,
            'title': self.title,
            'address': self.address,
            'provider': self.provider,
            'venue_id': self.venue_id,
            'venue_type': self.venue_type
        }

    def __bytes__(self):
        return b''.join((
            b'?S\xc0.',
            bytes(self.geo),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.address),
            self.serialize_bytes(self.provider),
            self.serialize_bytes(self.venue_id),
            self.serialize_bytes(self.venue_type),
        ))

    @classmethod
    def from_reader(cls, reader):
        _geo = reader.tgread_object()
        _title = reader.tgread_string()
        _address = reader.tgread_string()
        _provider = reader.tgread_string()
        _venue_id = reader.tgread_string()
        _venue_type = reader.tgread_string()
        return cls(geo=_geo, title=_title, address=_address, provider=_provider, venue_id=_venue_id, venue_type=_venue_type)


class MessageMediaWebPage(TLObject):
    CONSTRUCTOR_ID = 0xa32dd600
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, webpage: 'TypeWebPage'):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll.
        """
        self.webpage = webpage

    def to_dict(self):
        return {
            '_': 'MessageMediaWebPage',
            'webpage': self.webpage.to_dict() if isinstance(self.webpage, TLObject) else self.webpage
        }

    def __bytes__(self):
        return b''.join((
            b'\x00\xd6-\xa3',
            bytes(self.webpage),
        ))

    @classmethod
    def from_reader(cls, reader):
        _webpage = reader.tgread_object()
        return cls(webpage=_webpage)


class MessageRange(TLObject):
    CONSTRUCTOR_ID = 0xae30253
    SUBCLASS_OF_ID = 0xbec74577

    def __init__(self, min_id: int, max_id: int):
        """
        Constructor for MessageRange: Instance of MessageRange.
        """
        self.min_id = min_id
        self.max_id = max_id

    def to_dict(self):
        return {
            '_': 'MessageRange',
            'min_id': self.min_id,
            'max_id': self.max_id
        }

    def __bytes__(self):
        return b''.join((
            b'S\x02\xe3\n',
            struct.pack('<i', self.min_id),
            struct.pack('<i', self.max_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _min_id = reader.read_int()
        _max_id = reader.read_int()
        return cls(min_id=_min_id, max_id=_max_id)
MessageService = None  # Patched


class MsgDetailedInfo(TLObject):
    CONSTRUCTOR_ID = 0x276d3ec6
    SUBCLASS_OF_ID = 0x5f32d5ee

    # noinspection PyShadowingBuiltins
    def __init__(self, msg_id: int, answer_msg_id: int, bytes: int, status: int):
        """
        Constructor for MsgDetailedInfo: Instance of either MsgDetailedInfo, MsgNewDetailedInfo.
        """
        self.msg_id = msg_id
        self.answer_msg_id = answer_msg_id
        self.bytes = bytes
        self.status = status

    def to_dict(self):
        return {
            '_': 'MsgDetailedInfo',
            'msg_id': self.msg_id,
            'answer_msg_id': self.answer_msg_id,
            'bytes': self.bytes,
            'status': self.status
        }

    def __bytes__(self):
        return b''.join((
            b"\xc6>m'",
            struct.pack('<q', self.msg_id),
            struct.pack('<q', self.answer_msg_id),
            struct.pack('<i', self.bytes),
            struct.pack('<i', self.status),
        ))

    @classmethod
    def from_reader(cls, reader):
        _msg_id = reader.read_long()
        _answer_msg_id = reader.read_long()
        _bytes = reader.read_int()
        _status = reader.read_int()
        return cls(msg_id=_msg_id, answer_msg_id=_answer_msg_id, bytes=_bytes, status=_status)


class MsgNewDetailedInfo(TLObject):
    CONSTRUCTOR_ID = 0x809db6df
    SUBCLASS_OF_ID = 0x5f32d5ee

    # noinspection PyShadowingBuiltins
    def __init__(self, answer_msg_id: int, bytes: int, status: int):
        """
        Constructor for MsgDetailedInfo: Instance of either MsgDetailedInfo, MsgNewDetailedInfo.
        """
        self.answer_msg_id = answer_msg_id
        self.bytes = bytes
        self.status = status

    def to_dict(self):
        return {
            '_': 'MsgNewDetailedInfo',
            'answer_msg_id': self.answer_msg_id,
            'bytes': self.bytes,
            'status': self.status
        }

    def __bytes__(self):
        return b''.join((
            b'\xdf\xb6\x9d\x80',
            struct.pack('<q', self.answer_msg_id),
            struct.pack('<i', self.bytes),
            struct.pack('<i', self.status),
        ))

    @classmethod
    def from_reader(cls, reader):
        _answer_msg_id = reader.read_long()
        _bytes = reader.read_int()
        _status = reader.read_int()
        return cls(answer_msg_id=_answer_msg_id, bytes=_bytes, status=_status)


class MsgResendReq(TLObject):
    CONSTRUCTOR_ID = 0x7d861a08
    SUBCLASS_OF_ID = 0x2024514

    def __init__(self, msg_ids: List[int]):
        """
        Constructor for MsgResendReq: Instance of MsgResendReq.
        """
        self.msg_ids = msg_ids

    def to_dict(self):
        return {
            '_': 'MsgResendReq',
            'msg_ids': [] if self.msg_ids is None else self.msg_ids[:]
        }

    def __bytes__(self):
        return b''.join((
            b'\x08\x1a\x86}',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.msg_ids)),b''.join(struct.pack('<q', x) for x in self.msg_ids),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _msg_ids = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _msg_ids.append(_x)

        return cls(msg_ids=_msg_ids)


class MsgsAck(TLObject):
    CONSTRUCTOR_ID = 0x62d6b459
    SUBCLASS_OF_ID = 0x827677c4

    def __init__(self, msg_ids: List[int]):
        """
        Constructor for MsgsAck: Instance of MsgsAck.
        """
        self.msg_ids = msg_ids

    def to_dict(self):
        return {
            '_': 'MsgsAck',
            'msg_ids': [] if self.msg_ids is None else self.msg_ids[:]
        }

    def __bytes__(self):
        return b''.join((
            b'Y\xb4\xd6b',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.msg_ids)),b''.join(struct.pack('<q', x) for x in self.msg_ids),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _msg_ids = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _msg_ids.append(_x)

        return cls(msg_ids=_msg_ids)


class MsgsAllInfo(TLObject):
    CONSTRUCTOR_ID = 0x8cc0d131
    SUBCLASS_OF_ID = 0xfa8fcb54

    def __init__(self, msg_ids: List[int], info: str):
        """
        Constructor for MsgsAllInfo: Instance of MsgsAllInfo.
        """
        self.msg_ids = msg_ids
        self.info = info

    def to_dict(self):
        return {
            '_': 'MsgsAllInfo',
            'msg_ids': [] if self.msg_ids is None else self.msg_ids[:],
            'info': self.info
        }

    def __bytes__(self):
        return b''.join((
            b'1\xd1\xc0\x8c',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.msg_ids)),b''.join(struct.pack('<q', x) for x in self.msg_ids),
            self.serialize_bytes(self.info),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _msg_ids = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _msg_ids.append(_x)

        _info = reader.tgread_string()
        return cls(msg_ids=_msg_ids, info=_info)


class MsgsStateInfo(TLObject):
    CONSTRUCTOR_ID = 0x4deb57d
    SUBCLASS_OF_ID = 0x70a0a64

    def __init__(self, req_msg_id: int, info: str):
        """
        Constructor for MsgsStateInfo: Instance of MsgsStateInfo.
        """
        self.req_msg_id = req_msg_id
        self.info = info

    def to_dict(self):
        return {
            '_': 'MsgsStateInfo',
            'req_msg_id': self.req_msg_id,
            'info': self.info
        }

    def __bytes__(self):
        return b''.join((
            b'}\xb5\xde\x04',
            struct.pack('<q', self.req_msg_id),
            self.serialize_bytes(self.info),
        ))

    @classmethod
    def from_reader(cls, reader):
        _req_msg_id = reader.read_long()
        _info = reader.tgread_string()
        return cls(req_msg_id=_req_msg_id, info=_info)


class MsgsStateReq(TLObject):
    CONSTRUCTOR_ID = 0xda69fb52
    SUBCLASS_OF_ID = 0x18f01dd0

    def __init__(self, msg_ids: List[int]):
        """
        Constructor for MsgsStateReq: Instance of MsgsStateReq.
        """
        self.msg_ids = msg_ids

    def to_dict(self):
        return {
            '_': 'MsgsStateReq',
            'msg_ids': [] if self.msg_ids is None else self.msg_ids[:]
        }

    def __bytes__(self):
        return b''.join((
            b'R\xfbi\xda',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.msg_ids)),b''.join(struct.pack('<q', x) for x in self.msg_ids),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _msg_ids = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _msg_ids.append(_x)

        return cls(msg_ids=_msg_ids)


class NearestDc(TLObject):
    CONSTRUCTOR_ID = 0x8e1a1775
    SUBCLASS_OF_ID = 0x3877045f

    def __init__(self, country: str, this_dc: int, nearest_dc: int):
        """
        Constructor for NearestDc: Instance of NearestDc.
        """
        self.country = country
        self.this_dc = this_dc
        self.nearest_dc = nearest_dc

    def to_dict(self):
        return {
            '_': 'NearestDc',
            'country': self.country,
            'this_dc': self.this_dc,
            'nearest_dc': self.nearest_dc
        }

    def __bytes__(self):
        return b''.join((
            b'u\x17\x1a\x8e',
            self.serialize_bytes(self.country),
            struct.pack('<i', self.this_dc),
            struct.pack('<i', self.nearest_dc),
        ))

    @classmethod
    def from_reader(cls, reader):
        _country = reader.tgread_string()
        _this_dc = reader.read_int()
        _nearest_dc = reader.read_int()
        return cls(country=_country, this_dc=_this_dc, nearest_dc=_nearest_dc)


class NewSessionCreated(TLObject):
    CONSTRUCTOR_ID = 0x9ec20908
    SUBCLASS_OF_ID = 0x510d3031

    def __init__(self, first_msg_id: int, unique_id: int, server_salt: int):
        """
        Constructor for NewSession: Instance of NewSessionCreated.
        """
        self.first_msg_id = first_msg_id
        self.unique_id = unique_id
        self.server_salt = server_salt

    def to_dict(self):
        return {
            '_': 'NewSessionCreated',
            'first_msg_id': self.first_msg_id,
            'unique_id': self.unique_id,
            'server_salt': self.server_salt
        }

    def __bytes__(self):
        return b''.join((
            b'\x08\t\xc2\x9e',
            struct.pack('<q', self.first_msg_id),
            struct.pack('<q', self.unique_id),
            struct.pack('<q', self.server_salt),
        ))

    @classmethod
    def from_reader(cls, reader):
        _first_msg_id = reader.read_long()
        _unique_id = reader.read_long()
        _server_salt = reader.read_long()
        return cls(first_msg_id=_first_msg_id, unique_id=_unique_id, server_salt=_server_salt)


class NotifyBroadcasts(TLObject):
    CONSTRUCTOR_ID = 0xd612e8ef
    SUBCLASS_OF_ID = 0xdfe8602e

    def to_dict(self):
        return {
            '_': 'NotifyBroadcasts'
        }

    def __bytes__(self):
        return b''.join((
            b'\xef\xe8\x12\xd6',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class NotifyChats(TLObject):
    CONSTRUCTOR_ID = 0xc007cec3
    SUBCLASS_OF_ID = 0xdfe8602e

    def to_dict(self):
        return {
            '_': 'NotifyChats'
        }

    def __bytes__(self):
        return b''.join((
            b'\xc3\xce\x07\xc0',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class NotifyPeer(TLObject):
    CONSTRUCTOR_ID = 0x9fd40bd8
    SUBCLASS_OF_ID = 0xdfe8602e

    def __init__(self, peer: 'TypePeer'):
        """
        Constructor for NotifyPeer: Instance of either NotifyPeer, NotifyUsers, NotifyChats, NotifyBroadcasts.
        """
        self.peer = peer

    def to_dict(self):
        return {
            '_': 'NotifyPeer',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def __bytes__(self):
        return b''.join((
            b'\xd8\x0b\xd4\x9f',
            bytes(self.peer),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


class NotifyUsers(TLObject):
    CONSTRUCTOR_ID = 0xb4c83b4c
    SUBCLASS_OF_ID = 0xdfe8602e

    def to_dict(self):
        return {
            '_': 'NotifyUsers'
        }

    def __bytes__(self):
        return b''.join((
            b'L;\xc8\xb4',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PQInnerData(TLObject):
    CONSTRUCTOR_ID = 0x83c95aec
    SUBCLASS_OF_ID = 0x41701377

    def __init__(self, pq: bytes, p: bytes, q: bytes, nonce: int, server_nonce: int, new_nonce: int):
        """
        Constructor for P_Q_inner_data: Instance of either PQInnerData, PQInnerDataDc, PQInnerDataTemp, PQInnerDataTempDc.
        """
        self.pq = pq
        self.p = p
        self.q = q
        self.nonce = nonce
        self.server_nonce = server_nonce
        self.new_nonce = new_nonce

    def to_dict(self):
        return {
            '_': 'PQInnerData',
            'pq': self.pq,
            'p': self.p,
            'q': self.q,
            'nonce': self.nonce,
            'server_nonce': self.server_nonce,
            'new_nonce': self.new_nonce
        }

    def __bytes__(self):
        return b''.join((
            b'\xecZ\xc9\x83',
            self.serialize_bytes(self.pq),
            self.serialize_bytes(self.p),
            self.serialize_bytes(self.q),
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce.to_bytes(32, 'little', signed=True),
        ))

    @classmethod
    def from_reader(cls, reader):
        _pq = reader.tgread_bytes()
        _p = reader.tgread_bytes()
        _q = reader.tgread_bytes()
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce = reader.read_large_int(bits=256)
        return cls(pq=_pq, p=_p, q=_q, nonce=_nonce, server_nonce=_server_nonce, new_nonce=_new_nonce)


class PQInnerDataDc(TLObject):
    CONSTRUCTOR_ID = 0xa9f55f95
    SUBCLASS_OF_ID = 0x41701377

    def __init__(self, pq: bytes, p: bytes, q: bytes, nonce: int, server_nonce: int, new_nonce: int, dc: int):
        """
        Constructor for P_Q_inner_data: Instance of either PQInnerData, PQInnerDataDc, PQInnerDataTemp, PQInnerDataTempDc.
        """
        self.pq = pq
        self.p = p
        self.q = q
        self.nonce = nonce
        self.server_nonce = server_nonce
        self.new_nonce = new_nonce
        self.dc = dc

    def to_dict(self):
        return {
            '_': 'PQInnerDataDc',
            'pq': self.pq,
            'p': self.p,
            'q': self.q,
            'nonce': self.nonce,
            'server_nonce': self.server_nonce,
            'new_nonce': self.new_nonce,
            'dc': self.dc
        }

    def __bytes__(self):
        return b''.join((
            b'\x95_\xf5\xa9',
            self.serialize_bytes(self.pq),
            self.serialize_bytes(self.p),
            self.serialize_bytes(self.q),
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce.to_bytes(32, 'little', signed=True),
            struct.pack('<i', self.dc),
        ))

    @classmethod
    def from_reader(cls, reader):
        _pq = reader.tgread_bytes()
        _p = reader.tgread_bytes()
        _q = reader.tgread_bytes()
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce = reader.read_large_int(bits=256)
        _dc = reader.read_int()
        return cls(pq=_pq, p=_p, q=_q, nonce=_nonce, server_nonce=_server_nonce, new_nonce=_new_nonce, dc=_dc)


class PQInnerDataTemp(TLObject):
    CONSTRUCTOR_ID = 0x3c6a84d4
    SUBCLASS_OF_ID = 0x41701377

    def __init__(self, pq: bytes, p: bytes, q: bytes, nonce: int, server_nonce: int, new_nonce: int, expires_in: int):
        """
        Constructor for P_Q_inner_data: Instance of either PQInnerData, PQInnerDataDc, PQInnerDataTemp, PQInnerDataTempDc.
        """
        self.pq = pq
        self.p = p
        self.q = q
        self.nonce = nonce
        self.server_nonce = server_nonce
        self.new_nonce = new_nonce
        self.expires_in = expires_in

    def to_dict(self):
        return {
            '_': 'PQInnerDataTemp',
            'pq': self.pq,
            'p': self.p,
            'q': self.q,
            'nonce': self.nonce,
            'server_nonce': self.server_nonce,
            'new_nonce': self.new_nonce,
            'expires_in': self.expires_in
        }

    def __bytes__(self):
        return b''.join((
            b'\xd4\x84j<',
            self.serialize_bytes(self.pq),
            self.serialize_bytes(self.p),
            self.serialize_bytes(self.q),
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce.to_bytes(32, 'little', signed=True),
            struct.pack('<i', self.expires_in),
        ))

    @classmethod
    def from_reader(cls, reader):
        _pq = reader.tgread_bytes()
        _p = reader.tgread_bytes()
        _q = reader.tgread_bytes()
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce = reader.read_large_int(bits=256)
        _expires_in = reader.read_int()
        return cls(pq=_pq, p=_p, q=_q, nonce=_nonce, server_nonce=_server_nonce, new_nonce=_new_nonce, expires_in=_expires_in)


class PQInnerDataTempDc(TLObject):
    CONSTRUCTOR_ID = 0x56fddf88
    SUBCLASS_OF_ID = 0x41701377

    def __init__(self, pq: bytes, p: bytes, q: bytes, nonce: int, server_nonce: int, new_nonce: int, dc: int, expires_in: int):
        """
        Constructor for P_Q_inner_data: Instance of either PQInnerData, PQInnerDataDc, PQInnerDataTemp, PQInnerDataTempDc.
        """
        self.pq = pq
        self.p = p
        self.q = q
        self.nonce = nonce
        self.server_nonce = server_nonce
        self.new_nonce = new_nonce
        self.dc = dc
        self.expires_in = expires_in

    def to_dict(self):
        return {
            '_': 'PQInnerDataTempDc',
            'pq': self.pq,
            'p': self.p,
            'q': self.q,
            'nonce': self.nonce,
            'server_nonce': self.server_nonce,
            'new_nonce': self.new_nonce,
            'dc': self.dc,
            'expires_in': self.expires_in
        }

    def __bytes__(self):
        return b''.join((
            b'\x88\xdf\xfdV',
            self.serialize_bytes(self.pq),
            self.serialize_bytes(self.p),
            self.serialize_bytes(self.q),
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce.to_bytes(32, 'little', signed=True),
            struct.pack('<i', self.dc),
            struct.pack('<i', self.expires_in),
        ))

    @classmethod
    def from_reader(cls, reader):
        _pq = reader.tgread_bytes()
        _p = reader.tgread_bytes()
        _q = reader.tgread_bytes()
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce = reader.read_large_int(bits=256)
        _dc = reader.read_int()
        _expires_in = reader.read_int()
        return cls(pq=_pq, p=_p, q=_q, nonce=_nonce, server_nonce=_server_nonce, new_nonce=_new_nonce, dc=_dc, expires_in=_expires_in)


class Page(TLObject):
    CONSTRUCTOR_ID = 0xae891bec
    SUBCLASS_OF_ID = 0xb438191e

    def __init__(self, url: str, blocks: List['TypePageBlock'], photos: List['TypePhoto'], documents: List['TypeDocument'], part: Optional[bool]=None, rtl: Optional[bool]=None, v2: Optional[bool]=None):
        """
        Constructor for Page: Instance of Page.
        """
        self.url = url
        self.blocks = blocks
        self.photos = photos
        self.documents = documents
        self.part = part
        self.rtl = rtl
        self.v2 = v2

    def to_dict(self):
        return {
            '_': 'Page',
            'url': self.url,
            'blocks': [] if self.blocks is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.blocks],
            'photos': [] if self.photos is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.photos],
            'documents': [] if self.documents is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.documents],
            'part': self.part,
            'rtl': self.rtl,
            'v2': self.v2
        }

    def __bytes__(self):
        return b''.join((
            b'\xec\x1b\x89\xae',
            struct.pack('<I', (0 if self.part is None or self.part is False else 1) | (0 if self.rtl is None or self.rtl is False else 2) | (0 if self.v2 is None or self.v2 is False else 4)),
            self.serialize_bytes(self.url),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.blocks)),b''.join(bytes(x) for x in self.blocks),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.photos)),b''.join(bytes(x) for x in self.photos),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.documents)),b''.join(bytes(x) for x in self.documents),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _part = bool(flags & 1)
        _rtl = bool(flags & 2)
        _v2 = bool(flags & 4)
        _url = reader.tgread_string()
        reader.read_int()
        _blocks = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _blocks.append(_x)

        reader.read_int()
        _photos = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _photos.append(_x)

        reader.read_int()
        _documents = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _documents.append(_x)

        return cls(url=_url, blocks=_blocks, photos=_photos, documents=_documents, part=_part, rtl=_rtl, v2=_v2)


class PageBlockAnchor(TLObject):
    CONSTRUCTOR_ID = 0xce0d37b0
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, name: str):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.name = name

    def to_dict(self):
        return {
            '_': 'PageBlockAnchor',
            'name': self.name
        }

    def __bytes__(self):
        return b''.join((
            b'\xb07\r\xce',
            self.serialize_bytes(self.name),
        ))

    @classmethod
    def from_reader(cls, reader):
        _name = reader.tgread_string()
        return cls(name=_name)


class PageBlockAudio(TLObject):
    CONSTRUCTOR_ID = 0x804361ea
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, audio_id: int, caption: 'TypePageCaption'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.audio_id = audio_id
        self.caption = caption

    def to_dict(self):
        return {
            '_': 'PageBlockAudio',
            'audio_id': self.audio_id,
            'caption': self.caption.to_dict() if isinstance(self.caption, TLObject) else self.caption
        }

    def __bytes__(self):
        return b''.join((
            b'\xeaaC\x80',
            struct.pack('<q', self.audio_id),
            bytes(self.caption),
        ))

    @classmethod
    def from_reader(cls, reader):
        _audio_id = reader.read_long()
        _caption = reader.tgread_object()
        return cls(audio_id=_audio_id, caption=_caption)


class PageBlockAuthorDate(TLObject):
    CONSTRUCTOR_ID = 0xbaafe5e0
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, author: 'TypeRichText', published_date: Optional[datetime]):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.author = author
        self.published_date = published_date

    def to_dict(self):
        return {
            '_': 'PageBlockAuthorDate',
            'author': self.author.to_dict() if isinstance(self.author, TLObject) else self.author,
            'published_date': self.published_date
        }

    def __bytes__(self):
        return b''.join((
            b'\xe0\xe5\xaf\xba',
            bytes(self.author),
            self.serialize_datetime(self.published_date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _author = reader.tgread_object()
        _published_date = reader.tgread_date()
        return cls(author=_author, published_date=_published_date)


class PageBlockBlockquote(TLObject):
    CONSTRUCTOR_ID = 0x263d7c26
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, text: 'TypeRichText', caption: 'TypeRichText'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.text = text
        self.caption = caption

    def to_dict(self):
        return {
            '_': 'PageBlockBlockquote',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text,
            'caption': self.caption.to_dict() if isinstance(self.caption, TLObject) else self.caption
        }

    def __bytes__(self):
        return b''.join((
            b'&|=&',
            bytes(self.text),
            bytes(self.caption),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        _caption = reader.tgread_object()
        return cls(text=_text, caption=_caption)


class PageBlockChannel(TLObject):
    CONSTRUCTOR_ID = 0xef1751b5
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, channel: 'TypeChat'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.channel = channel

    def to_dict(self):
        return {
            '_': 'PageBlockChannel',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel
        }

    def __bytes__(self):
        return b''.join((
            b'\xb5Q\x17\xef',
            bytes(self.channel),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        return cls(channel=_channel)


class PageBlockCollage(TLObject):
    CONSTRUCTOR_ID = 0x65a0fa4d
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, items: List['TypePageBlock'], caption: 'TypePageCaption'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.items = items
        self.caption = caption

    def to_dict(self):
        return {
            '_': 'PageBlockCollage',
            'items': [] if self.items is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.items],
            'caption': self.caption.to_dict() if isinstance(self.caption, TLObject) else self.caption
        }

    def __bytes__(self):
        return b''.join((
            b'M\xfa\xa0e',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.items)),b''.join(bytes(x) for x in self.items),
            bytes(self.caption),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _items = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _items.append(_x)

        _caption = reader.tgread_object()
        return cls(items=_items, caption=_caption)


class PageBlockCover(TLObject):
    CONSTRUCTOR_ID = 0x39f23300
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, cover: 'TypePageBlock'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.cover = cover

    def to_dict(self):
        return {
            '_': 'PageBlockCover',
            'cover': self.cover.to_dict() if isinstance(self.cover, TLObject) else self.cover
        }

    def __bytes__(self):
        return b''.join((
            b'\x003\xf29',
            bytes(self.cover),
        ))

    @classmethod
    def from_reader(cls, reader):
        _cover = reader.tgread_object()
        return cls(cover=_cover)


class PageBlockDetails(TLObject):
    CONSTRUCTOR_ID = 0x76768bed
    SUBCLASS_OF_ID = 0x1aca5644

    # noinspection PyShadowingBuiltins
    def __init__(self, blocks: List['TypePageBlock'], title: 'TypeRichText', open: Optional[bool]=None):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.blocks = blocks
        self.title = title
        self.open = open

    def to_dict(self):
        return {
            '_': 'PageBlockDetails',
            'blocks': [] if self.blocks is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.blocks],
            'title': self.title.to_dict() if isinstance(self.title, TLObject) else self.title,
            'open': self.open
        }

    def __bytes__(self):
        return b''.join((
            b'\xed\x8bvv',
            struct.pack('<I', (0 if self.open is None or self.open is False else 1)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.blocks)),b''.join(bytes(x) for x in self.blocks),
            bytes(self.title),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _open = bool(flags & 1)
        reader.read_int()
        _blocks = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _blocks.append(_x)

        _title = reader.tgread_object()
        return cls(blocks=_blocks, title=_title, open=_open)


class PageBlockDivider(TLObject):
    CONSTRUCTOR_ID = 0xdb20b188
    SUBCLASS_OF_ID = 0x1aca5644

    def to_dict(self):
        return {
            '_': 'PageBlockDivider'
        }

    def __bytes__(self):
        return b''.join((
            b'\x88\xb1 \xdb',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PageBlockEmbed(TLObject):
    CONSTRUCTOR_ID = 0xa8718dc5
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, caption: 'TypePageCaption', full_width: Optional[bool]=None, allow_scrolling: Optional[bool]=None, url: Optional[str]=None, html: Optional[str]=None, poster_photo_id: Optional[int]=None, w: Optional[int]=None, h: Optional[int]=None):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.caption = caption
        self.full_width = full_width
        self.allow_scrolling = allow_scrolling
        self.url = url
        self.html = html
        self.poster_photo_id = poster_photo_id
        self.w = w
        self.h = h

    def to_dict(self):
        return {
            '_': 'PageBlockEmbed',
            'caption': self.caption.to_dict() if isinstance(self.caption, TLObject) else self.caption,
            'full_width': self.full_width,
            'allow_scrolling': self.allow_scrolling,
            'url': self.url,
            'html': self.html,
            'poster_photo_id': self.poster_photo_id,
            'w': self.w,
            'h': self.h
        }

    def __bytes__(self):
        assert ((self.w or self.w is not None) and (self.h or self.h is not None)) or ((self.w is None or self.w is False) and (self.h is None or self.h is False)), 'w, h parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xc5\x8dq\xa8',
            struct.pack('<I', (0 if self.full_width is None or self.full_width is False else 1) | (0 if self.allow_scrolling is None or self.allow_scrolling is False else 8) | (0 if self.url is None or self.url is False else 2) | (0 if self.html is None or self.html is False else 4) | (0 if self.poster_photo_id is None or self.poster_photo_id is False else 16) | (0 if self.w is None or self.w is False else 32) | (0 if self.h is None or self.h is False else 32)),
            b'' if self.url is None or self.url is False else (self.serialize_bytes(self.url)),
            b'' if self.html is None or self.html is False else (self.serialize_bytes(self.html)),
            b'' if self.poster_photo_id is None or self.poster_photo_id is False else (struct.pack('<q', self.poster_photo_id)),
            b'' if self.w is None or self.w is False else (struct.pack('<i', self.w)),
            b'' if self.h is None or self.h is False else (struct.pack('<i', self.h)),
            bytes(self.caption),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _full_width = bool(flags & 1)
        _allow_scrolling = bool(flags & 8)
        if flags & 2:
            _url = reader.tgread_string()
        else:
            _url = None
        if flags & 4:
            _html = reader.tgread_string()
        else:
            _html = None
        if flags & 16:
            _poster_photo_id = reader.read_long()
        else:
            _poster_photo_id = None
        if flags & 32:
            _w = reader.read_int()
        else:
            _w = None
        if flags & 32:
            _h = reader.read_int()
        else:
            _h = None
        _caption = reader.tgread_object()
        return cls(caption=_caption, full_width=_full_width, allow_scrolling=_allow_scrolling, url=_url, html=_html, poster_photo_id=_poster_photo_id, w=_w, h=_h)


class PageBlockEmbedPost(TLObject):
    CONSTRUCTOR_ID = 0xf259a80b
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, url: str, webpage_id: int, author_photo_id: int, author: str, date: Optional[datetime], blocks: List['TypePageBlock'], caption: 'TypePageCaption'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.url = url
        self.webpage_id = webpage_id
        self.author_photo_id = author_photo_id
        self.author = author
        self.date = date
        self.blocks = blocks
        self.caption = caption

    def to_dict(self):
        return {
            '_': 'PageBlockEmbedPost',
            'url': self.url,
            'webpage_id': self.webpage_id,
            'author_photo_id': self.author_photo_id,
            'author': self.author,
            'date': self.date,
            'blocks': [] if self.blocks is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.blocks],
            'caption': self.caption.to_dict() if isinstance(self.caption, TLObject) else self.caption
        }

    def __bytes__(self):
        return b''.join((
            b'\x0b\xa8Y\xf2',
            self.serialize_bytes(self.url),
            struct.pack('<q', self.webpage_id),
            struct.pack('<q', self.author_photo_id),
            self.serialize_bytes(self.author),
            self.serialize_datetime(self.date),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.blocks)),b''.join(bytes(x) for x in self.blocks),
            bytes(self.caption),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        _webpage_id = reader.read_long()
        _author_photo_id = reader.read_long()
        _author = reader.tgread_string()
        _date = reader.tgread_date()
        reader.read_int()
        _blocks = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _blocks.append(_x)

        _caption = reader.tgread_object()
        return cls(url=_url, webpage_id=_webpage_id, author_photo_id=_author_photo_id, author=_author, date=_date, blocks=_blocks, caption=_caption)


class PageBlockFooter(TLObject):
    CONSTRUCTOR_ID = 0x48870999
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'PageBlockFooter',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\x99\t\x87H',
            bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class PageBlockHeader(TLObject):
    CONSTRUCTOR_ID = 0xbfd064ec
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'PageBlockHeader',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\xecd\xd0\xbf',
            bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class PageBlockKicker(TLObject):
    CONSTRUCTOR_ID = 0x1e148390
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'PageBlockKicker',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\x90\x83\x14\x1e',
            bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class PageBlockList(TLObject):
    CONSTRUCTOR_ID = 0xe4e88011
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, items: List['TypePageListItem']):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.items = items

    def to_dict(self):
        return {
            '_': 'PageBlockList',
            'items': [] if self.items is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.items]
        }

    def __bytes__(self):
        return b''.join((
            b'\x11\x80\xe8\xe4',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.items)),b''.join(bytes(x) for x in self.items),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _items = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _items.append(_x)

        return cls(items=_items)


class PageBlockMap(TLObject):
    CONSTRUCTOR_ID = 0xa44f3ef6
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, geo: 'TypeGeoPoint', zoom: int, w: int, h: int, caption: 'TypePageCaption'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.geo = geo
        self.zoom = zoom
        self.w = w
        self.h = h
        self.caption = caption

    def to_dict(self):
        return {
            '_': 'PageBlockMap',
            'geo': self.geo.to_dict() if isinstance(self.geo, TLObject) else self.geo,
            'zoom': self.zoom,
            'w': self.w,
            'h': self.h,
            'caption': self.caption.to_dict() if isinstance(self.caption, TLObject) else self.caption
        }

    def __bytes__(self):
        return b''.join((
            b'\xf6>O\xa4',
            bytes(self.geo),
            struct.pack('<i', self.zoom),
            struct.pack('<i', self.w),
            struct.pack('<i', self.h),
            bytes(self.caption),
        ))

    @classmethod
    def from_reader(cls, reader):
        _geo = reader.tgread_object()
        _zoom = reader.read_int()
        _w = reader.read_int()
        _h = reader.read_int()
        _caption = reader.tgread_object()
        return cls(geo=_geo, zoom=_zoom, w=_w, h=_h, caption=_caption)


class PageBlockOrderedList(TLObject):
    CONSTRUCTOR_ID = 0x9a8ae1e1
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, items: List['TypePageListOrderedItem']):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.items = items

    def to_dict(self):
        return {
            '_': 'PageBlockOrderedList',
            'items': [] if self.items is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.items]
        }

    def __bytes__(self):
        return b''.join((
            b'\xe1\xe1\x8a\x9a',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.items)),b''.join(bytes(x) for x in self.items),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _items = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _items.append(_x)

        return cls(items=_items)


class PageBlockParagraph(TLObject):
    CONSTRUCTOR_ID = 0x467a0766
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'PageBlockParagraph',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def __bytes__(self):
        return b''.join((
            b'f\x07zF',
            bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class PageBlockPhoto(TLObject):
    CONSTRUCTOR_ID = 0x1759c560
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, photo_id: int, caption: 'TypePageCaption', url: Optional[str]=None, webpage_id: Optional[int]=None):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.photo_id = photo_id
        self.caption = caption
        self.url = url
        self.webpage_id = webpage_id

    def to_dict(self):
        return {
            '_': 'PageBlockPhoto',
            'photo_id': self.photo_id,
            'caption': self.caption.to_dict() if isinstance(self.caption, TLObject) else self.caption,
            'url': self.url,
            'webpage_id': self.webpage_id
        }

    def __bytes__(self):
        assert ((self.url or self.url is not None) and (self.webpage_id or self.webpage_id is not None)) or ((self.url is None or self.url is False) and (self.webpage_id is None or self.webpage_id is False)), 'url, webpage_id parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'`\xc5Y\x17',
            struct.pack('<I', (0 if self.url is None or self.url is False else 1) | (0 if self.webpage_id is None or self.webpage_id is False else 1)),
            struct.pack('<q', self.photo_id),
            bytes(self.caption),
            b'' if self.url is None or self.url is False else (self.serialize_bytes(self.url)),
            b'' if self.webpage_id is None or self.webpage_id is False else (struct.pack('<q', self.webpage_id)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _photo_id = reader.read_long()
        _caption = reader.tgread_object()
        if flags & 1:
            _url = reader.tgread_string()
        else:
            _url = None
        if flags & 1:
            _webpage_id = reader.read_long()
        else:
            _webpage_id = None
        return cls(photo_id=_photo_id, caption=_caption, url=_url, webpage_id=_webpage_id)


class PageBlockPreformatted(TLObject):
    CONSTRUCTOR_ID = 0xc070d93e
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, text: 'TypeRichText', language: str):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.text = text
        self.language = language

    def to_dict(self):
        return {
            '_': 'PageBlockPreformatted',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text,
            'language': self.language
        }

    def __bytes__(self):
        return b''.join((
            b'>\xd9p\xc0',
            bytes(self.text),
            self.serialize_bytes(self.language),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        _language = reader.tgread_string()
        return cls(text=_text, language=_language)


class PageBlockPullquote(TLObject):
    CONSTRUCTOR_ID = 0x4f4456d3
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, text: 'TypeRichText', caption: 'TypeRichText'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.text = text
        self.caption = caption

    def to_dict(self):
        return {
            '_': 'PageBlockPullquote',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text,
            'caption': self.caption.to_dict() if isinstance(self.caption, TLObject) else self.caption
        }

    def __bytes__(self):
        return b''.join((
            b'\xd3VDO',
            bytes(self.text),
            bytes(self.caption),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        _caption = reader.tgread_object()
        return cls(text=_text, caption=_caption)


class PageBlockRelatedArticles(TLObject):
    CONSTRUCTOR_ID = 0x16115a96
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, title: 'TypeRichText', articles: List['TypePageRelatedArticle']):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.title = title
        self.articles = articles

    def to_dict(self):
        return {
            '_': 'PageBlockRelatedArticles',
            'title': self.title.to_dict() if isinstance(self.title, TLObject) else self.title,
            'articles': [] if self.articles is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.articles]
        }

    def __bytes__(self):
        return b''.join((
            b'\x96Z\x11\x16',
            bytes(self.title),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.articles)),b''.join(bytes(x) for x in self.articles),
        ))

    @classmethod
    def from_reader(cls, reader):
        _title = reader.tgread_object()
        reader.read_int()
        _articles = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _articles.append(_x)

        return cls(title=_title, articles=_articles)


class PageBlockSlideshow(TLObject):
    CONSTRUCTOR_ID = 0x31f9590
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, items: List['TypePageBlock'], caption: 'TypePageCaption'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.items = items
        self.caption = caption

    def to_dict(self):
        return {
            '_': 'PageBlockSlideshow',
            'items': [] if self.items is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.items],
            'caption': self.caption.to_dict() if isinstance(self.caption, TLObject) else self.caption
        }

    def __bytes__(self):
        return b''.join((
            b'\x90\x95\x1f\x03',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.items)),b''.join(bytes(x) for x in self.items),
            bytes(self.caption),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _items = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _items.append(_x)

        _caption = reader.tgread_object()
        return cls(items=_items, caption=_caption)


class PageBlockSubheader(TLObject):
    CONSTRUCTOR_ID = 0xf12bb6e1
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'PageBlockSubheader',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\xe1\xb6+\xf1',
            bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class PageBlockSubtitle(TLObject):
    CONSTRUCTOR_ID = 0x8ffa9a1f
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'PageBlockSubtitle',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\x1f\x9a\xfa\x8f',
            bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class PageBlockTable(TLObject):
    CONSTRUCTOR_ID = 0xbf4dea82
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, title: 'TypeRichText', rows: List['TypePageTableRow'], bordered: Optional[bool]=None, striped: Optional[bool]=None):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.title = title
        self.rows = rows
        self.bordered = bordered
        self.striped = striped

    def to_dict(self):
        return {
            '_': 'PageBlockTable',
            'title': self.title.to_dict() if isinstance(self.title, TLObject) else self.title,
            'rows': [] if self.rows is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.rows],
            'bordered': self.bordered,
            'striped': self.striped
        }

    def __bytes__(self):
        return b''.join((
            b'\x82\xeaM\xbf',
            struct.pack('<I', (0 if self.bordered is None or self.bordered is False else 1) | (0 if self.striped is None or self.striped is False else 2)),
            bytes(self.title),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.rows)),b''.join(bytes(x) for x in self.rows),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _bordered = bool(flags & 1)
        _striped = bool(flags & 2)
        _title = reader.tgread_object()
        reader.read_int()
        _rows = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _rows.append(_x)

        return cls(title=_title, rows=_rows, bordered=_bordered, striped=_striped)


class PageBlockTitle(TLObject):
    CONSTRUCTOR_ID = 0x70abc3fd
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'PageBlockTitle',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\xfd\xc3\xabp',
            bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class PageBlockUnsupported(TLObject):
    CONSTRUCTOR_ID = 0x13567e8a
    SUBCLASS_OF_ID = 0x1aca5644

    def to_dict(self):
        return {
            '_': 'PageBlockUnsupported'
        }

    def __bytes__(self):
        return b''.join((
            b'\x8a~V\x13',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PageBlockVideo(TLObject):
    CONSTRUCTOR_ID = 0x7c8fe7b6
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, video_id: int, caption: 'TypePageCaption', autoplay: Optional[bool]=None, loop: Optional[bool]=None):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.video_id = video_id
        self.caption = caption
        self.autoplay = autoplay
        self.loop = loop

    def to_dict(self):
        return {
            '_': 'PageBlockVideo',
            'video_id': self.video_id,
            'caption': self.caption.to_dict() if isinstance(self.caption, TLObject) else self.caption,
            'autoplay': self.autoplay,
            'loop': self.loop
        }

    def __bytes__(self):
        return b''.join((
            b'\xb6\xe7\x8f|',
            struct.pack('<I', (0 if self.autoplay is None or self.autoplay is False else 1) | (0 if self.loop is None or self.loop is False else 2)),
            struct.pack('<q', self.video_id),
            bytes(self.caption),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _autoplay = bool(flags & 1)
        _loop = bool(flags & 2)
        _video_id = reader.read_long()
        _caption = reader.tgread_object()
        return cls(video_id=_video_id, caption=_caption, autoplay=_autoplay, loop=_loop)


class PageCaption(TLObject):
    CONSTRUCTOR_ID = 0x6f747657
    SUBCLASS_OF_ID = 0x29b8eeb3

    def __init__(self, text: 'TypeRichText', credit: 'TypeRichText'):
        """
        Constructor for PageCaption: Instance of PageCaption.
        """
        self.text = text
        self.credit = credit

    def to_dict(self):
        return {
            '_': 'PageCaption',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text,
            'credit': self.credit.to_dict() if isinstance(self.credit, TLObject) else self.credit
        }

    def __bytes__(self):
        return b''.join((
            b'Wvto',
            bytes(self.text),
            bytes(self.credit),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        _credit = reader.tgread_object()
        return cls(text=_text, credit=_credit)


class PageListItemBlocks(TLObject):
    CONSTRUCTOR_ID = 0x25e073fc
    SUBCLASS_OF_ID = 0x8caebcb1

    def __init__(self, blocks: List['TypePageBlock']):
        """
        Constructor for PageListItem: Instance of either PageListItemText, PageListItemBlocks.
        """
        self.blocks = blocks

    def to_dict(self):
        return {
            '_': 'PageListItemBlocks',
            'blocks': [] if self.blocks is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.blocks]
        }

    def __bytes__(self):
        return b''.join((
            b'\xfcs\xe0%',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.blocks)),b''.join(bytes(x) for x in self.blocks),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _blocks = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _blocks.append(_x)

        return cls(blocks=_blocks)


class PageListItemText(TLObject):
    CONSTRUCTOR_ID = 0xb92fb6cd
    SUBCLASS_OF_ID = 0x8caebcb1

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for PageListItem: Instance of either PageListItemText, PageListItemBlocks.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'PageListItemText',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\xcd\xb6/\xb9',
            bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class PageListOrderedItemBlocks(TLObject):
    CONSTRUCTOR_ID = 0x98dd8936
    SUBCLASS_OF_ID = 0xeeda0eb8

    def __init__(self, num: str, blocks: List['TypePageBlock']):
        """
        Constructor for PageListOrderedItem: Instance of either PageListOrderedItemText, PageListOrderedItemBlocks.
        """
        self.num = num
        self.blocks = blocks

    def to_dict(self):
        return {
            '_': 'PageListOrderedItemBlocks',
            'num': self.num,
            'blocks': [] if self.blocks is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.blocks]
        }

    def __bytes__(self):
        return b''.join((
            b'6\x89\xdd\x98',
            self.serialize_bytes(self.num),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.blocks)),b''.join(bytes(x) for x in self.blocks),
        ))

    @classmethod
    def from_reader(cls, reader):
        _num = reader.tgread_string()
        reader.read_int()
        _blocks = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _blocks.append(_x)

        return cls(num=_num, blocks=_blocks)


class PageListOrderedItemText(TLObject):
    CONSTRUCTOR_ID = 0x5e068047
    SUBCLASS_OF_ID = 0xeeda0eb8

    def __init__(self, num: str, text: 'TypeRichText'):
        """
        Constructor for PageListOrderedItem: Instance of either PageListOrderedItemText, PageListOrderedItemBlocks.
        """
        self.num = num
        self.text = text

    def to_dict(self):
        return {
            '_': 'PageListOrderedItemText',
            'num': self.num,
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def __bytes__(self):
        return b''.join((
            b'G\x80\x06^',
            self.serialize_bytes(self.num),
            bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _num = reader.tgread_string()
        _text = reader.tgread_object()
        return cls(num=_num, text=_text)


class PageRelatedArticle(TLObject):
    CONSTRUCTOR_ID = 0xb390dc08
    SUBCLASS_OF_ID = 0x36d05822

    def __init__(self, url: str, webpage_id: int, title: Optional[str]=None, description: Optional[str]=None, photo_id: Optional[int]=None, author: Optional[str]=None, published_date: Optional[datetime]=None):
        """
        Constructor for PageRelatedArticle: Instance of PageRelatedArticle.
        """
        self.url = url
        self.webpage_id = webpage_id
        self.title = title
        self.description = description
        self.photo_id = photo_id
        self.author = author
        self.published_date = published_date

    def to_dict(self):
        return {
            '_': 'PageRelatedArticle',
            'url': self.url,
            'webpage_id': self.webpage_id,
            'title': self.title,
            'description': self.description,
            'photo_id': self.photo_id,
            'author': self.author,
            'published_date': self.published_date
        }

    def __bytes__(self):
        return b''.join((
            b'\x08\xdc\x90\xb3',
            struct.pack('<I', (0 if self.title is None or self.title is False else 1) | (0 if self.description is None or self.description is False else 2) | (0 if self.photo_id is None or self.photo_id is False else 4) | (0 if self.author is None or self.author is False else 8) | (0 if self.published_date is None or self.published_date is False else 16)),
            self.serialize_bytes(self.url),
            struct.pack('<q', self.webpage_id),
            b'' if self.title is None or self.title is False else (self.serialize_bytes(self.title)),
            b'' if self.description is None or self.description is False else (self.serialize_bytes(self.description)),
            b'' if self.photo_id is None or self.photo_id is False else (struct.pack('<q', self.photo_id)),
            b'' if self.author is None or self.author is False else (self.serialize_bytes(self.author)),
            b'' if self.published_date is None or self.published_date is False else (self.serialize_datetime(self.published_date)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _url = reader.tgread_string()
        _webpage_id = reader.read_long()
        if flags & 1:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 2:
            _description = reader.tgread_string()
        else:
            _description = None
        if flags & 4:
            _photo_id = reader.read_long()
        else:
            _photo_id = None
        if flags & 8:
            _author = reader.tgread_string()
        else:
            _author = None
        if flags & 16:
            _published_date = reader.tgread_date()
        else:
            _published_date = None
        return cls(url=_url, webpage_id=_webpage_id, title=_title, description=_description, photo_id=_photo_id, author=_author, published_date=_published_date)


class PageTableCell(TLObject):
    CONSTRUCTOR_ID = 0x34566b6a
    SUBCLASS_OF_ID = 0xb0eb3054

    def __init__(self, header: Optional[bool]=None, align_center: Optional[bool]=None, align_right: Optional[bool]=None, valign_middle: Optional[bool]=None, valign_bottom: Optional[bool]=None, text: Optional['TypeRichText']=None, colspan: Optional[int]=None, rowspan: Optional[int]=None):
        """
        Constructor for PageTableCell: Instance of PageTableCell.
        """
        self.header = header
        self.align_center = align_center
        self.align_right = align_right
        self.valign_middle = valign_middle
        self.valign_bottom = valign_bottom
        self.text = text
        self.colspan = colspan
        self.rowspan = rowspan

    def to_dict(self):
        return {
            '_': 'PageTableCell',
            'header': self.header,
            'align_center': self.align_center,
            'align_right': self.align_right,
            'valign_middle': self.valign_middle,
            'valign_bottom': self.valign_bottom,
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text,
            'colspan': self.colspan,
            'rowspan': self.rowspan
        }

    def __bytes__(self):
        return b''.join((
            b'jkV4',
            struct.pack('<I', (0 if self.header is None or self.header is False else 1) | (0 if self.align_center is None or self.align_center is False else 8) | (0 if self.align_right is None or self.align_right is False else 16) | (0 if self.valign_middle is None or self.valign_middle is False else 32) | (0 if self.valign_bottom is None or self.valign_bottom is False else 64) | (0 if self.text is None or self.text is False else 128) | (0 if self.colspan is None or self.colspan is False else 2) | (0 if self.rowspan is None or self.rowspan is False else 4)),
            b'' if self.text is None or self.text is False else (bytes(self.text)),
            b'' if self.colspan is None or self.colspan is False else (struct.pack('<i', self.colspan)),
            b'' if self.rowspan is None or self.rowspan is False else (struct.pack('<i', self.rowspan)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _header = bool(flags & 1)
        _align_center = bool(flags & 8)
        _align_right = bool(flags & 16)
        _valign_middle = bool(flags & 32)
        _valign_bottom = bool(flags & 64)
        if flags & 128:
            _text = reader.tgread_object()
        else:
            _text = None
        if flags & 2:
            _colspan = reader.read_int()
        else:
            _colspan = None
        if flags & 4:
            _rowspan = reader.read_int()
        else:
            _rowspan = None
        return cls(header=_header, align_center=_align_center, align_right=_align_right, valign_middle=_valign_middle, valign_bottom=_valign_bottom, text=_text, colspan=_colspan, rowspan=_rowspan)


class PageTableRow(TLObject):
    CONSTRUCTOR_ID = 0xe0c0c5e5
    SUBCLASS_OF_ID = 0x59acee11

    def __init__(self, cells: List['TypePageTableCell']):
        """
        Constructor for PageTableRow: Instance of PageTableRow.
        """
        self.cells = cells

    def to_dict(self):
        return {
            '_': 'PageTableRow',
            'cells': [] if self.cells is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.cells]
        }

    def __bytes__(self):
        return b''.join((
            b'\xe5\xc5\xc0\xe0',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.cells)),b''.join(bytes(x) for x in self.cells),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _cells = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _cells.append(_x)

        return cls(cells=_cells)


class PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow(TLObject):
    CONSTRUCTOR_ID = 0x3a912d4a
    SUBCLASS_OF_ID = 0x37bcf5cc

    def __init__(self, salt1: bytes, salt2: bytes, g: int, p: bytes):
        """
        Constructor for PasswordKdfAlgo: Instance of either PasswordKdfAlgoUnknown, PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow.
        """
        self.salt1 = salt1
        self.salt2 = salt2
        self.g = g
        self.p = p

    def to_dict(self):
        return {
            '_': 'PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow',
            'salt1': self.salt1,
            'salt2': self.salt2,
            'g': self.g,
            'p': self.p
        }

    def __bytes__(self):
        return b''.join((
            b'J-\x91:',
            self.serialize_bytes(self.salt1),
            self.serialize_bytes(self.salt2),
            struct.pack('<i', self.g),
            self.serialize_bytes(self.p),
        ))

    @classmethod
    def from_reader(cls, reader):
        _salt1 = reader.tgread_bytes()
        _salt2 = reader.tgread_bytes()
        _g = reader.read_int()
        _p = reader.tgread_bytes()
        return cls(salt1=_salt1, salt2=_salt2, g=_g, p=_p)


class PasswordKdfAlgoUnknown(TLObject):
    CONSTRUCTOR_ID = 0xd45ab096
    SUBCLASS_OF_ID = 0x37bcf5cc

    def to_dict(self):
        return {
            '_': 'PasswordKdfAlgoUnknown'
        }

    def __bytes__(self):
        return b''.join((
            b'\x96\xb0Z\xd4',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PaymentCharge(TLObject):
    CONSTRUCTOR_ID = 0xea02c27e
    SUBCLASS_OF_ID = 0x3cc830d9

    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, provider_charge_id: str):
        """
        Constructor for PaymentCharge: Instance of PaymentCharge.
        """
        self.id = id
        self.provider_charge_id = provider_charge_id

    def to_dict(self):
        return {
            '_': 'PaymentCharge',
            'id': self.id,
            'provider_charge_id': self.provider_charge_id
        }

    def __bytes__(self):
        return b''.join((
            b'~\xc2\x02\xea',
            self.serialize_bytes(self.id),
            self.serialize_bytes(self.provider_charge_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_string()
        _provider_charge_id = reader.tgread_string()
        return cls(id=_id, provider_charge_id=_provider_charge_id)


class PaymentRequestedInfo(TLObject):
    CONSTRUCTOR_ID = 0x909c3f94
    SUBCLASS_OF_ID = 0x8db03146

    def __init__(self, name: Optional[str]=None, phone: Optional[str]=None, email: Optional[str]=None, shipping_address: Optional['TypePostAddress']=None):
        """
        Constructor for PaymentRequestedInfo: Instance of PaymentRequestedInfo.
        """
        self.name = name
        self.phone = phone
        self.email = email
        self.shipping_address = shipping_address

    def to_dict(self):
        return {
            '_': 'PaymentRequestedInfo',
            'name': self.name,
            'phone': self.phone,
            'email': self.email,
            'shipping_address': self.shipping_address.to_dict() if isinstance(self.shipping_address, TLObject) else self.shipping_address
        }

    def __bytes__(self):
        return b''.join((
            b'\x94?\x9c\x90',
            struct.pack('<I', (0 if self.name is None or self.name is False else 1) | (0 if self.phone is None or self.phone is False else 2) | (0 if self.email is None or self.email is False else 4) | (0 if self.shipping_address is None or self.shipping_address is False else 8)),
            b'' if self.name is None or self.name is False else (self.serialize_bytes(self.name)),
            b'' if self.phone is None or self.phone is False else (self.serialize_bytes(self.phone)),
            b'' if self.email is None or self.email is False else (self.serialize_bytes(self.email)),
            b'' if self.shipping_address is None or self.shipping_address is False else (bytes(self.shipping_address)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _name = reader.tgread_string()
        else:
            _name = None
        if flags & 2:
            _phone = reader.tgread_string()
        else:
            _phone = None
        if flags & 4:
            _email = reader.tgread_string()
        else:
            _email = None
        if flags & 8:
            _shipping_address = reader.tgread_object()
        else:
            _shipping_address = None
        return cls(name=_name, phone=_phone, email=_email, shipping_address=_shipping_address)


class PaymentSavedCredentialsCard(TLObject):
    CONSTRUCTOR_ID = 0xcdc27a1f
    SUBCLASS_OF_ID = 0xb3627ee3

    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, title: str):
        """
        Constructor for PaymentSavedCredentials: Instance of PaymentSavedCredentialsCard.
        """
        self.id = id
        self.title = title

    def to_dict(self):
        return {
            '_': 'PaymentSavedCredentialsCard',
            'id': self.id,
            'title': self.title
        }

    def __bytes__(self):
        return b''.join((
            b'\x1fz\xc2\xcd',
            self.serialize_bytes(self.id),
            self.serialize_bytes(self.title),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_string()
        _title = reader.tgread_string()
        return cls(id=_id, title=_title)


class PeerChannel(TLObject):
    CONSTRUCTOR_ID = 0xbddde532
    SUBCLASS_OF_ID = 0x2d45687

    def __init__(self, channel_id: int):
        """
        Constructor for Peer: Instance of either PeerUser, PeerChat, PeerChannel.
        """
        self.channel_id = channel_id

    def to_dict(self):
        return {
            '_': 'PeerChannel',
            'channel_id': self.channel_id
        }

    def __bytes__(self):
        return b''.join((
            b'2\xe5\xdd\xbd',
            struct.pack('<i', self.channel_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel_id = reader.read_int()
        return cls(channel_id=_channel_id)


class PeerChat(TLObject):
    CONSTRUCTOR_ID = 0xbad0e5bb
    SUBCLASS_OF_ID = 0x2d45687

    def __init__(self, chat_id: int):
        """
        Constructor for Peer: Instance of either PeerUser, PeerChat, PeerChannel.
        """
        self.chat_id = chat_id

    def to_dict(self):
        return {
            '_': 'PeerChat',
            'chat_id': self.chat_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xbb\xe5\xd0\xba',
            struct.pack('<i', self.chat_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_int()
        return cls(chat_id=_chat_id)


class PeerLocated(TLObject):
    CONSTRUCTOR_ID = 0xca461b5d
    SUBCLASS_OF_ID = 0xfada34ac

    def __init__(self, peer: 'TypePeer', expires: Optional[datetime], distance: int):
        """
        Constructor for PeerLocated: Instance of PeerLocated.
        """
        self.peer = peer
        self.expires = expires
        self.distance = distance

    def to_dict(self):
        return {
            '_': 'PeerLocated',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'expires': self.expires,
            'distance': self.distance
        }

    def __bytes__(self):
        return b''.join((
            b']\x1bF\xca',
            bytes(self.peer),
            self.serialize_datetime(self.expires),
            struct.pack('<i', self.distance),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _expires = reader.tgread_date()
        _distance = reader.read_int()
        return cls(peer=_peer, expires=_expires, distance=_distance)


class PeerNotifySettings(TLObject):
    CONSTRUCTOR_ID = 0xaf509d20
    SUBCLASS_OF_ID = 0xcf20c074

    def __init__(self, show_previews: Optional[bool]=None, silent: Optional[bool]=None, mute_until: Optional[datetime]=None, sound: Optional[str]=None):
        """
        Constructor for PeerNotifySettings: Instance of PeerNotifySettings.
        """
        self.show_previews = show_previews
        self.silent = silent
        self.mute_until = mute_until
        self.sound = sound

    def to_dict(self):
        return {
            '_': 'PeerNotifySettings',
            'show_previews': self.show_previews,
            'silent': self.silent,
            'mute_until': self.mute_until,
            'sound': self.sound
        }

    def __bytes__(self):
        return b''.join((
            b' \x9dP\xaf',
            struct.pack('<I', (0 if self.show_previews is None or self.show_previews is False else 1) | (0 if self.silent is None or self.silent is False else 2) | (0 if self.mute_until is None or self.mute_until is False else 4) | (0 if self.sound is None or self.sound is False else 8)),
            b'' if self.show_previews is None or self.show_previews is False else (b'\xb5ur\x99' if self.show_previews else b'7\x97y\xbc'),
            b'' if self.silent is None or self.silent is False else (b'\xb5ur\x99' if self.silent else b'7\x97y\xbc'),
            b'' if self.mute_until is None or self.mute_until is False else (self.serialize_datetime(self.mute_until)),
            b'' if self.sound is None or self.sound is False else (self.serialize_bytes(self.sound)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _show_previews = reader.tgread_bool()
        else:
            _show_previews = None
        if flags & 2:
            _silent = reader.tgread_bool()
        else:
            _silent = None
        if flags & 4:
            _mute_until = reader.tgread_date()
        else:
            _mute_until = None
        if flags & 8:
            _sound = reader.tgread_string()
        else:
            _sound = None
        return cls(show_previews=_show_previews, silent=_silent, mute_until=_mute_until, sound=_sound)


class PeerSettings(TLObject):
    CONSTRUCTOR_ID = 0x818426cd
    SUBCLASS_OF_ID = 0xf6a79f84

    def __init__(self, report_spam: Optional[bool]=None, add_contact: Optional[bool]=None, block_contact: Optional[bool]=None, share_contact: Optional[bool]=None, need_contacts_exception: Optional[bool]=None, report_geo: Optional[bool]=None):
        """
        Constructor for PeerSettings: Instance of PeerSettings.
        """
        self.report_spam = report_spam
        self.add_contact = add_contact
        self.block_contact = block_contact
        self.share_contact = share_contact
        self.need_contacts_exception = need_contacts_exception
        self.report_geo = report_geo

    def to_dict(self):
        return {
            '_': 'PeerSettings',
            'report_spam': self.report_spam,
            'add_contact': self.add_contact,
            'block_contact': self.block_contact,
            'share_contact': self.share_contact,
            'need_contacts_exception': self.need_contacts_exception,
            'report_geo': self.report_geo
        }

    def __bytes__(self):
        return b''.join((
            b'\xcd&\x84\x81',
            struct.pack('<I', (0 if self.report_spam is None or self.report_spam is False else 1) | (0 if self.add_contact is None or self.add_contact is False else 2) | (0 if self.block_contact is None or self.block_contact is False else 4) | (0 if self.share_contact is None or self.share_contact is False else 8) | (0 if self.need_contacts_exception is None or self.need_contacts_exception is False else 16) | (0 if self.report_geo is None or self.report_geo is False else 32)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _report_spam = bool(flags & 1)
        _add_contact = bool(flags & 2)
        _block_contact = bool(flags & 4)
        _share_contact = bool(flags & 8)
        _need_contacts_exception = bool(flags & 16)
        _report_geo = bool(flags & 32)
        return cls(report_spam=_report_spam, add_contact=_add_contact, block_contact=_block_contact, share_contact=_share_contact, need_contacts_exception=_need_contacts_exception, report_geo=_report_geo)


class PeerUser(TLObject):
    CONSTRUCTOR_ID = 0x9db1bc6d
    SUBCLASS_OF_ID = 0x2d45687

    def __init__(self, user_id: int):
        """
        Constructor for Peer: Instance of either PeerUser, PeerChat, PeerChannel.
        """
        self.user_id = user_id

    def to_dict(self):
        return {
            '_': 'PeerUser',
            'user_id': self.user_id
        }

    def __bytes__(self):
        return b''.join((
            b'm\xbc\xb1\x9d',
            struct.pack('<i', self.user_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        return cls(user_id=_user_id)


class PhoneCall(TLObject):
    CONSTRUCTOR_ID = 0x8742ae7f
    SUBCLASS_OF_ID = 0xc47f1bd1

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, date: Optional[datetime], admin_id: int, participant_id: int, g_a_or_b: bytes, key_fingerprint: int, protocol: 'TypePhoneCallProtocol', connections: List['TypePhoneConnection'], start_date: Optional[datetime], p2p_allowed: Optional[bool]=None):
        """
        Constructor for PhoneCall: Instance of either PhoneCallEmpty, PhoneCallWaiting, PhoneCallRequested, PhoneCallAccepted, PhoneCall, PhoneCallDiscarded.
        """
        self.id = id
        self.access_hash = access_hash
        self.date = date
        self.admin_id = admin_id
        self.participant_id = participant_id
        self.g_a_or_b = g_a_or_b
        self.key_fingerprint = key_fingerprint
        self.protocol = protocol
        self.connections = connections
        self.start_date = start_date
        self.p2p_allowed = p2p_allowed

    def to_dict(self):
        return {
            '_': 'PhoneCall',
            'id': self.id,
            'access_hash': self.access_hash,
            'date': self.date,
            'admin_id': self.admin_id,
            'participant_id': self.participant_id,
            'g_a_or_b': self.g_a_or_b,
            'key_fingerprint': self.key_fingerprint,
            'protocol': self.protocol.to_dict() if isinstance(self.protocol, TLObject) else self.protocol,
            'connections': [] if self.connections is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.connections],
            'start_date': self.start_date,
            'p2p_allowed': self.p2p_allowed
        }

    def __bytes__(self):
        return b''.join((
            b'\x7f\xaeB\x87',
            struct.pack('<I', (0 if self.p2p_allowed is None or self.p2p_allowed is False else 32)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_datetime(self.date),
            struct.pack('<i', self.admin_id),
            struct.pack('<i', self.participant_id),
            self.serialize_bytes(self.g_a_or_b),
            struct.pack('<q', self.key_fingerprint),
            bytes(self.protocol),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.connections)),b''.join(bytes(x) for x in self.connections),
            self.serialize_datetime(self.start_date),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _p2p_allowed = bool(flags & 32)
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _date = reader.tgread_date()
        _admin_id = reader.read_int()
        _participant_id = reader.read_int()
        _g_a_or_b = reader.tgread_bytes()
        _key_fingerprint = reader.read_long()
        _protocol = reader.tgread_object()
        reader.read_int()
        _connections = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _connections.append(_x)

        _start_date = reader.tgread_date()
        return cls(id=_id, access_hash=_access_hash, date=_date, admin_id=_admin_id, participant_id=_participant_id, g_a_or_b=_g_a_or_b, key_fingerprint=_key_fingerprint, protocol=_protocol, connections=_connections, start_date=_start_date, p2p_allowed=_p2p_allowed)


class PhoneCallAccepted(TLObject):
    CONSTRUCTOR_ID = 0x997c454a
    SUBCLASS_OF_ID = 0xc47f1bd1

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, date: Optional[datetime], admin_id: int, participant_id: int, g_b: bytes, protocol: 'TypePhoneCallProtocol', video: Optional[bool]=None):
        """
        Constructor for PhoneCall: Instance of either PhoneCallEmpty, PhoneCallWaiting, PhoneCallRequested, PhoneCallAccepted, PhoneCall, PhoneCallDiscarded.
        """
        self.id = id
        self.access_hash = access_hash
        self.date = date
        self.admin_id = admin_id
        self.participant_id = participant_id
        self.g_b = g_b
        self.protocol = protocol
        self.video = video

    def to_dict(self):
        return {
            '_': 'PhoneCallAccepted',
            'id': self.id,
            'access_hash': self.access_hash,
            'date': self.date,
            'admin_id': self.admin_id,
            'participant_id': self.participant_id,
            'g_b': self.g_b,
            'protocol': self.protocol.to_dict() if isinstance(self.protocol, TLObject) else self.protocol,
            'video': self.video
        }

    def __bytes__(self):
        return b''.join((
            b'JE|\x99',
            struct.pack('<I', (0 if self.video is None or self.video is False else 32)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_datetime(self.date),
            struct.pack('<i', self.admin_id),
            struct.pack('<i', self.participant_id),
            self.serialize_bytes(self.g_b),
            bytes(self.protocol),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _video = bool(flags & 32)
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _date = reader.tgread_date()
        _admin_id = reader.read_int()
        _participant_id = reader.read_int()
        _g_b = reader.tgread_bytes()
        _protocol = reader.tgread_object()
        return cls(id=_id, access_hash=_access_hash, date=_date, admin_id=_admin_id, participant_id=_participant_id, g_b=_g_b, protocol=_protocol, video=_video)


class PhoneCallDiscardReasonBusy(TLObject):
    CONSTRUCTOR_ID = 0xfaf7e8c9
    SUBCLASS_OF_ID = 0xd89bad3d

    def to_dict(self):
        return {
            '_': 'PhoneCallDiscardReasonBusy'
        }

    def __bytes__(self):
        return b''.join((
            b'\xc9\xe8\xf7\xfa',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PhoneCallDiscardReasonDisconnect(TLObject):
    CONSTRUCTOR_ID = 0xe095c1a0
    SUBCLASS_OF_ID = 0xd89bad3d

    def to_dict(self):
        return {
            '_': 'PhoneCallDiscardReasonDisconnect'
        }

    def __bytes__(self):
        return b''.join((
            b'\xa0\xc1\x95\xe0',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PhoneCallDiscardReasonHangup(TLObject):
    CONSTRUCTOR_ID = 0x57adc690
    SUBCLASS_OF_ID = 0xd89bad3d

    def to_dict(self):
        return {
            '_': 'PhoneCallDiscardReasonHangup'
        }

    def __bytes__(self):
        return b''.join((
            b'\x90\xc6\xadW',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PhoneCallDiscardReasonMissed(TLObject):
    CONSTRUCTOR_ID = 0x85e42301
    SUBCLASS_OF_ID = 0xd89bad3d

    def to_dict(self):
        return {
            '_': 'PhoneCallDiscardReasonMissed'
        }

    def __bytes__(self):
        return b''.join((
            b'\x01#\xe4\x85',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PhoneCallDiscarded(TLObject):
    CONSTRUCTOR_ID = 0x50ca4de1
    SUBCLASS_OF_ID = 0xc47f1bd1

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, need_rating: Optional[bool]=None, need_debug: Optional[bool]=None, video: Optional[bool]=None, reason: Optional['TypePhoneCallDiscardReason']=None, duration: Optional[int]=None):
        """
        Constructor for PhoneCall: Instance of either PhoneCallEmpty, PhoneCallWaiting, PhoneCallRequested, PhoneCallAccepted, PhoneCall, PhoneCallDiscarded.
        """
        self.id = id
        self.need_rating = need_rating
        self.need_debug = need_debug
        self.video = video
        self.reason = reason
        self.duration = duration

    def to_dict(self):
        return {
            '_': 'PhoneCallDiscarded',
            'id': self.id,
            'need_rating': self.need_rating,
            'need_debug': self.need_debug,
            'video': self.video,
            'reason': self.reason.to_dict() if isinstance(self.reason, TLObject) else self.reason,
            'duration': self.duration
        }

    def __bytes__(self):
        return b''.join((
            b'\xe1M\xcaP',
            struct.pack('<I', (0 if self.need_rating is None or self.need_rating is False else 4) | (0 if self.need_debug is None or self.need_debug is False else 8) | (0 if self.video is None or self.video is False else 32) | (0 if self.reason is None or self.reason is False else 1) | (0 if self.duration is None or self.duration is False else 2)),
            struct.pack('<q', self.id),
            b'' if self.reason is None or self.reason is False else (bytes(self.reason)),
            b'' if self.duration is None or self.duration is False else (struct.pack('<i', self.duration)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _need_rating = bool(flags & 4)
        _need_debug = bool(flags & 8)
        _video = bool(flags & 32)
        _id = reader.read_long()
        if flags & 1:
            _reason = reader.tgread_object()
        else:
            _reason = None
        if flags & 2:
            _duration = reader.read_int()
        else:
            _duration = None
        return cls(id=_id, need_rating=_need_rating, need_debug=_need_debug, video=_video, reason=_reason, duration=_duration)


class PhoneCallEmpty(TLObject):
    CONSTRUCTOR_ID = 0x5366c915
    SUBCLASS_OF_ID = 0xc47f1bd1

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        """
        Constructor for PhoneCall: Instance of either PhoneCallEmpty, PhoneCallWaiting, PhoneCallRequested, PhoneCallAccepted, PhoneCall, PhoneCallDiscarded.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'PhoneCallEmpty',
            'id': self.id
        }

    def __bytes__(self):
        return b''.join((
            b'\x15\xc9fS',
            struct.pack('<q', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        return cls(id=_id)


class PhoneCallProtocol(TLObject):
    CONSTRUCTOR_ID = 0xa2bb35cb
    SUBCLASS_OF_ID = 0x783991a3

    def __init__(self, min_layer: int, max_layer: int, udp_p2p: Optional[bool]=None, udp_reflector: Optional[bool]=None):
        """
        Constructor for PhoneCallProtocol: Instance of PhoneCallProtocol.
        """
        self.min_layer = min_layer
        self.max_layer = max_layer
        self.udp_p2p = udp_p2p
        self.udp_reflector = udp_reflector

    def to_dict(self):
        return {
            '_': 'PhoneCallProtocol',
            'min_layer': self.min_layer,
            'max_layer': self.max_layer,
            'udp_p2p': self.udp_p2p,
            'udp_reflector': self.udp_reflector
        }

    def __bytes__(self):
        return b''.join((
            b'\xcb5\xbb\xa2',
            struct.pack('<I', (0 if self.udp_p2p is None or self.udp_p2p is False else 1) | (0 if self.udp_reflector is None or self.udp_reflector is False else 2)),
            struct.pack('<i', self.min_layer),
            struct.pack('<i', self.max_layer),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _udp_p2p = bool(flags & 1)
        _udp_reflector = bool(flags & 2)
        _min_layer = reader.read_int()
        _max_layer = reader.read_int()
        return cls(min_layer=_min_layer, max_layer=_max_layer, udp_p2p=_udp_p2p, udp_reflector=_udp_reflector)


class PhoneCallRequested(TLObject):
    CONSTRUCTOR_ID = 0x87eabb53
    SUBCLASS_OF_ID = 0xc47f1bd1

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, date: Optional[datetime], admin_id: int, participant_id: int, g_a_hash: bytes, protocol: 'TypePhoneCallProtocol', video: Optional[bool]=None):
        """
        Constructor for PhoneCall: Instance of either PhoneCallEmpty, PhoneCallWaiting, PhoneCallRequested, PhoneCallAccepted, PhoneCall, PhoneCallDiscarded.
        """
        self.id = id
        self.access_hash = access_hash
        self.date = date
        self.admin_id = admin_id
        self.participant_id = participant_id
        self.g_a_hash = g_a_hash
        self.protocol = protocol
        self.video = video

    def to_dict(self):
        return {
            '_': 'PhoneCallRequested',
            'id': self.id,
            'access_hash': self.access_hash,
            'date': self.date,
            'admin_id': self.admin_id,
            'participant_id': self.participant_id,
            'g_a_hash': self.g_a_hash,
            'protocol': self.protocol.to_dict() if isinstance(self.protocol, TLObject) else self.protocol,
            'video': self.video
        }

    def __bytes__(self):
        return b''.join((
            b'S\xbb\xea\x87',
            struct.pack('<I', (0 if self.video is None or self.video is False else 32)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_datetime(self.date),
            struct.pack('<i', self.admin_id),
            struct.pack('<i', self.participant_id),
            self.serialize_bytes(self.g_a_hash),
            bytes(self.protocol),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _video = bool(flags & 32)
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _date = reader.tgread_date()
        _admin_id = reader.read_int()
        _participant_id = reader.read_int()
        _g_a_hash = reader.tgread_bytes()
        _protocol = reader.tgread_object()
        return cls(id=_id, access_hash=_access_hash, date=_date, admin_id=_admin_id, participant_id=_participant_id, g_a_hash=_g_a_hash, protocol=_protocol, video=_video)


class PhoneCallWaiting(TLObject):
    CONSTRUCTOR_ID = 0x1b8f4ad1
    SUBCLASS_OF_ID = 0xc47f1bd1

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, date: Optional[datetime], admin_id: int, participant_id: int, protocol: 'TypePhoneCallProtocol', video: Optional[bool]=None, receive_date: Optional[datetime]=None):
        """
        Constructor for PhoneCall: Instance of either PhoneCallEmpty, PhoneCallWaiting, PhoneCallRequested, PhoneCallAccepted, PhoneCall, PhoneCallDiscarded.
        """
        self.id = id
        self.access_hash = access_hash
        self.date = date
        self.admin_id = admin_id
        self.participant_id = participant_id
        self.protocol = protocol
        self.video = video
        self.receive_date = receive_date

    def to_dict(self):
        return {
            '_': 'PhoneCallWaiting',
            'id': self.id,
            'access_hash': self.access_hash,
            'date': self.date,
            'admin_id': self.admin_id,
            'participant_id': self.participant_id,
            'protocol': self.protocol.to_dict() if isinstance(self.protocol, TLObject) else self.protocol,
            'video': self.video,
            'receive_date': self.receive_date
        }

    def __bytes__(self):
        return b''.join((
            b'\xd1J\x8f\x1b',
            struct.pack('<I', (0 if self.video is None or self.video is False else 32) | (0 if self.receive_date is None or self.receive_date is False else 1)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_datetime(self.date),
            struct.pack('<i', self.admin_id),
            struct.pack('<i', self.participant_id),
            bytes(self.protocol),
            b'' if self.receive_date is None or self.receive_date is False else (self.serialize_datetime(self.receive_date)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _video = bool(flags & 32)
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _date = reader.tgread_date()
        _admin_id = reader.read_int()
        _participant_id = reader.read_int()
        _protocol = reader.tgread_object()
        if flags & 1:
            _receive_date = reader.tgread_date()
        else:
            _receive_date = None
        return cls(id=_id, access_hash=_access_hash, date=_date, admin_id=_admin_id, participant_id=_participant_id, protocol=_protocol, video=_video, receive_date=_receive_date)


class PhoneConnection(TLObject):
    CONSTRUCTOR_ID = 0x9d4c17c0
    SUBCLASS_OF_ID = 0xaa8de40d

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, ip: str, ipv6: str, port: int, peer_tag: bytes):
        """
        Constructor for PhoneConnection: Instance of PhoneConnection.
        """
        self.id = id
        self.ip = ip
        self.ipv6 = ipv6
        self.port = port
        self.peer_tag = peer_tag

    def to_dict(self):
        return {
            '_': 'PhoneConnection',
            'id': self.id,
            'ip': self.ip,
            'ipv6': self.ipv6,
            'port': self.port,
            'peer_tag': self.peer_tag
        }

    def __bytes__(self):
        return b''.join((
            b'\xc0\x17L\x9d',
            struct.pack('<q', self.id),
            self.serialize_bytes(self.ip),
            self.serialize_bytes(self.ipv6),
            struct.pack('<i', self.port),
            self.serialize_bytes(self.peer_tag),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _ip = reader.tgread_string()
        _ipv6 = reader.tgread_string()
        _port = reader.read_int()
        _peer_tag = reader.tgread_bytes()
        return cls(id=_id, ip=_ip, ipv6=_ipv6, port=_port, peer_tag=_peer_tag)


class Photo(TLObject):
    CONSTRUCTOR_ID = 0xd07504a5
    SUBCLASS_OF_ID = 0xd576ab1c

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, file_reference: bytes, date: Optional[datetime], sizes: List['TypePhotoSize'], dc_id: int, has_stickers: Optional[bool]=None):
        """
        Constructor for Photo: Instance of either PhotoEmpty, Photo.
        """
        self.id = id
        self.access_hash = access_hash
        self.file_reference = file_reference
        self.date = date
        self.sizes = sizes
        self.dc_id = dc_id
        self.has_stickers = has_stickers

    def to_dict(self):
        return {
            '_': 'Photo',
            'id': self.id,
            'access_hash': self.access_hash,
            'file_reference': self.file_reference,
            'date': self.date,
            'sizes': [] if self.sizes is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.sizes],
            'dc_id': self.dc_id,
            'has_stickers': self.has_stickers
        }

    def __bytes__(self):
        return b''.join((
            b'\xa5\x04u\xd0',
            struct.pack('<I', (0 if self.has_stickers is None or self.has_stickers is False else 1)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_bytes(self.file_reference),
            self.serialize_datetime(self.date),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.sizes)),b''.join(bytes(x) for x in self.sizes),
            struct.pack('<i', self.dc_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _has_stickers = bool(flags & 1)
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _file_reference = reader.tgread_bytes()
        _date = reader.tgread_date()
        reader.read_int()
        _sizes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _sizes.append(_x)

        _dc_id = reader.read_int()
        return cls(id=_id, access_hash=_access_hash, file_reference=_file_reference, date=_date, sizes=_sizes, dc_id=_dc_id, has_stickers=_has_stickers)


class PhotoCachedSize(TLObject):
    CONSTRUCTOR_ID = 0xe9a734fa
    SUBCLASS_OF_ID = 0x17cc29d9

    # noinspection PyShadowingBuiltins
    def __init__(self, type: str, location: 'TypeFileLocation', w: int, h: int, bytes: bytes):
        """
        Constructor for PhotoSize: Instance of either PhotoSizeEmpty, PhotoSize, PhotoCachedSize, PhotoStrippedSize.
        """
        self.type = type
        self.location = location
        self.w = w
        self.h = h
        self.bytes = bytes

    def to_dict(self):
        return {
            '_': 'PhotoCachedSize',
            'type': self.type,
            'location': self.location.to_dict() if isinstance(self.location, TLObject) else self.location,
            'w': self.w,
            'h': self.h,
            'bytes': self.bytes
        }

    def __bytes__(self):
        return b''.join((
            b'\xfa4\xa7\xe9',
            self.serialize_bytes(self.type),
            bytes(self.location),
            struct.pack('<i', self.w),
            struct.pack('<i', self.h),
            self.serialize_bytes(self.bytes),
        ))

    @classmethod
    def from_reader(cls, reader):
        _type = reader.tgread_string()
        _location = reader.tgread_object()
        _w = reader.read_int()
        _h = reader.read_int()
        _bytes = reader.tgread_bytes()
        return cls(type=_type, location=_location, w=_w, h=_h, bytes=_bytes)


class PhotoEmpty(TLObject):
    CONSTRUCTOR_ID = 0x2331b22d
    SUBCLASS_OF_ID = 0xd576ab1c

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        """
        Constructor for Photo: Instance of either PhotoEmpty, Photo.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'PhotoEmpty',
            'id': self.id
        }

    def __bytes__(self):
        return b''.join((
            b'-\xb21#',
            struct.pack('<q', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        return cls(id=_id)


class PhotoSize(TLObject):
    CONSTRUCTOR_ID = 0x77bfb61b
    SUBCLASS_OF_ID = 0x17cc29d9

    # noinspection PyShadowingBuiltins
    def __init__(self, type: str, location: 'TypeFileLocation', w: int, h: int, size: int):
        """
        Constructor for PhotoSize: Instance of either PhotoSizeEmpty, PhotoSize, PhotoCachedSize, PhotoStrippedSize.
        """
        self.type = type
        self.location = location
        self.w = w
        self.h = h
        self.size = size

    def to_dict(self):
        return {
            '_': 'PhotoSize',
            'type': self.type,
            'location': self.location.to_dict() if isinstance(self.location, TLObject) else self.location,
            'w': self.w,
            'h': self.h,
            'size': self.size
        }

    def __bytes__(self):
        return b''.join((
            b'\x1b\xb6\xbfw',
            self.serialize_bytes(self.type),
            bytes(self.location),
            struct.pack('<i', self.w),
            struct.pack('<i', self.h),
            struct.pack('<i', self.size),
        ))

    @classmethod
    def from_reader(cls, reader):
        _type = reader.tgread_string()
        _location = reader.tgread_object()
        _w = reader.read_int()
        _h = reader.read_int()
        _size = reader.read_int()
        return cls(type=_type, location=_location, w=_w, h=_h, size=_size)


class PhotoSizeEmpty(TLObject):
    CONSTRUCTOR_ID = 0xe17e23c
    SUBCLASS_OF_ID = 0x17cc29d9

    # noinspection PyShadowingBuiltins
    def __init__(self, type: str):
        """
        Constructor for PhotoSize: Instance of either PhotoSizeEmpty, PhotoSize, PhotoCachedSize, PhotoStrippedSize.
        """
        self.type = type

    def to_dict(self):
        return {
            '_': 'PhotoSizeEmpty',
            'type': self.type
        }

    def __bytes__(self):
        return b''.join((
            b'<\xe2\x17\x0e',
            self.serialize_bytes(self.type),
        ))

    @classmethod
    def from_reader(cls, reader):
        _type = reader.tgread_string()
        return cls(type=_type)


class PhotoStrippedSize(TLObject):
    CONSTRUCTOR_ID = 0xe0b0bc2e
    SUBCLASS_OF_ID = 0x17cc29d9

    # noinspection PyShadowingBuiltins
    def __init__(self, type: str, bytes: bytes):
        """
        Constructor for PhotoSize: Instance of either PhotoSizeEmpty, PhotoSize, PhotoCachedSize, PhotoStrippedSize.
        """
        self.type = type
        self.bytes = bytes

    def to_dict(self):
        return {
            '_': 'PhotoStrippedSize',
            'type': self.type,
            'bytes': self.bytes
        }

    def __bytes__(self):
        return b''.join((
            b'.\xbc\xb0\xe0',
            self.serialize_bytes(self.type),
            self.serialize_bytes(self.bytes),
        ))

    @classmethod
    def from_reader(cls, reader):
        _type = reader.tgread_string()
        _bytes = reader.tgread_bytes()
        return cls(type=_type, bytes=_bytes)


class Poll(TLObject):
    CONSTRUCTOR_ID = 0xd5529d06
    SUBCLASS_OF_ID = 0x248e557b

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, question: str, answers: List['TypePollAnswer'], closed: Optional[bool]=None):
        """
        Constructor for Poll: Instance of Poll.
        """
        self.id = id
        self.question = question
        self.answers = answers
        self.closed = closed

    def to_dict(self):
        return {
            '_': 'Poll',
            'id': self.id,
            'question': self.question,
            'answers': [] if self.answers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.answers],
            'closed': self.closed
        }

    def __bytes__(self):
        return b''.join((
            b'\x06\x9dR\xd5',
            struct.pack('<q', self.id),
            struct.pack('<I', (0 if self.closed is None or self.closed is False else 1)),
            self.serialize_bytes(self.question),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.answers)),b''.join(bytes(x) for x in self.answers),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        flags = reader.read_int()

        _closed = bool(flags & 1)
        _question = reader.tgread_string()
        reader.read_int()
        _answers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _answers.append(_x)

        return cls(id=_id, question=_question, answers=_answers, closed=_closed)


class PollAnswer(TLObject):
    CONSTRUCTOR_ID = 0x6ca9c2e9
    SUBCLASS_OF_ID = 0x7ea5dd9e

    def __init__(self, text: str, option: bytes):
        """
        Constructor for PollAnswer: Instance of PollAnswer.
        """
        self.text = text
        self.option = option

    def to_dict(self):
        return {
            '_': 'PollAnswer',
            'text': self.text,
            'option': self.option
        }

    def __bytes__(self):
        return b''.join((
            b'\xe9\xc2\xa9l',
            self.serialize_bytes(self.text),
            self.serialize_bytes(self.option),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        _option = reader.tgread_bytes()
        return cls(text=_text, option=_option)


class PollAnswerVoters(TLObject):
    CONSTRUCTOR_ID = 0x3b6ddad2
    SUBCLASS_OF_ID = 0x7ce0cf91

    def __init__(self, option: bytes, voters: int, chosen: Optional[bool]=None):
        """
        Constructor for PollAnswerVoters: Instance of PollAnswerVoters.
        """
        self.option = option
        self.voters = voters
        self.chosen = chosen

    def to_dict(self):
        return {
            '_': 'PollAnswerVoters',
            'option': self.option,
            'voters': self.voters,
            'chosen': self.chosen
        }

    def __bytes__(self):
        return b''.join((
            b'\xd2\xdam;',
            struct.pack('<I', (0 if self.chosen is None or self.chosen is False else 1)),
            self.serialize_bytes(self.option),
            struct.pack('<i', self.voters),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _chosen = bool(flags & 1)
        _option = reader.tgread_bytes()
        _voters = reader.read_int()
        return cls(option=_option, voters=_voters, chosen=_chosen)


class PollResults(TLObject):
    CONSTRUCTOR_ID = 0x5755785a
    SUBCLASS_OF_ID = 0xc3b4f687

    # noinspection PyShadowingBuiltins
    def __init__(self, min: Optional[bool]=None, results: Optional[List['TypePollAnswerVoters']]=None, total_voters: Optional[int]=None):
        """
        Constructor for PollResults: Instance of PollResults.
        """
        self.min = min
        self.results = results
        self.total_voters = total_voters

    def to_dict(self):
        return {
            '_': 'PollResults',
            'min': self.min,
            'results': [] if self.results is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.results],
            'total_voters': self.total_voters
        }

    def __bytes__(self):
        return b''.join((
            b'ZxUW',
            struct.pack('<I', (0 if self.min is None or self.min is False else 1) | (0 if self.results is None or self.results is False else 2) | (0 if self.total_voters is None or self.total_voters is False else 4)),
            b'' if self.results is None or self.results is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.results)),b''.join(bytes(x) for x in self.results))),
            b'' if self.total_voters is None or self.total_voters is False else (struct.pack('<i', self.total_voters)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _min = bool(flags & 1)
        if flags & 2:
            reader.read_int()
            _results = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _results.append(_x)

        else:
            _results = None
        if flags & 4:
            _total_voters = reader.read_int()
        else:
            _total_voters = None
        return cls(min=_min, results=_results, total_voters=_total_voters)


class Pong(TLObject):
    CONSTRUCTOR_ID = 0x347773c5
    SUBCLASS_OF_ID = 0x816aee71

    def __init__(self, msg_id: int, ping_id: int):
        """
        Constructor for Pong: Instance of Pong.
        """
        self.msg_id = msg_id
        self.ping_id = ping_id

    def to_dict(self):
        return {
            '_': 'Pong',
            'msg_id': self.msg_id,
            'ping_id': self.ping_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xc5sw4',
            struct.pack('<q', self.msg_id),
            struct.pack('<q', self.ping_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _msg_id = reader.read_long()
        _ping_id = reader.read_long()
        return cls(msg_id=_msg_id, ping_id=_ping_id)


class PopularContact(TLObject):
    CONSTRUCTOR_ID = 0x5ce14175
    SUBCLASS_OF_ID = 0x409255a

    def __init__(self, client_id: int, importers: int):
        """
        Constructor for PopularContact: Instance of PopularContact.
        """
        self.client_id = client_id
        self.importers = importers

    def to_dict(self):
        return {
            '_': 'PopularContact',
            'client_id': self.client_id,
            'importers': self.importers
        }

    def __bytes__(self):
        return b''.join((
            b'uA\xe1\\',
            struct.pack('<q', self.client_id),
            struct.pack('<i', self.importers),
        ))

    @classmethod
    def from_reader(cls, reader):
        _client_id = reader.read_long()
        _importers = reader.read_int()
        return cls(client_id=_client_id, importers=_importers)


class PostAddress(TLObject):
    CONSTRUCTOR_ID = 0x1e8caaeb
    SUBCLASS_OF_ID = 0x8d7eda2c

    def __init__(self, street_line1: str, street_line2: str, city: str, state: str, country_iso2: str, post_code: str):
        """
        Constructor for PostAddress: Instance of PostAddress.
        """
        self.street_line1 = street_line1
        self.street_line2 = street_line2
        self.city = city
        self.state = state
        self.country_iso2 = country_iso2
        self.post_code = post_code

    def to_dict(self):
        return {
            '_': 'PostAddress',
            'street_line1': self.street_line1,
            'street_line2': self.street_line2,
            'city': self.city,
            'state': self.state,
            'country_iso2': self.country_iso2,
            'post_code': self.post_code
        }

    def __bytes__(self):
        return b''.join((
            b'\xeb\xaa\x8c\x1e',
            self.serialize_bytes(self.street_line1),
            self.serialize_bytes(self.street_line2),
            self.serialize_bytes(self.city),
            self.serialize_bytes(self.state),
            self.serialize_bytes(self.country_iso2),
            self.serialize_bytes(self.post_code),
        ))

    @classmethod
    def from_reader(cls, reader):
        _street_line1 = reader.tgread_string()
        _street_line2 = reader.tgread_string()
        _city = reader.tgread_string()
        _state = reader.tgread_string()
        _country_iso2 = reader.tgread_string()
        _post_code = reader.tgread_string()
        return cls(street_line1=_street_line1, street_line2=_street_line2, city=_city, state=_state, country_iso2=_country_iso2, post_code=_post_code)


class PrivacyKeyAddedByPhone(TLObject):
    CONSTRUCTOR_ID = 0x42ffd42b
    SUBCLASS_OF_ID = 0x824651c3

    def to_dict(self):
        return {
            '_': 'PrivacyKeyAddedByPhone'
        }

    def __bytes__(self):
        return b''.join((
            b'+\xd4\xffB',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PrivacyKeyChatInvite(TLObject):
    CONSTRUCTOR_ID = 0x500e6dfa
    SUBCLASS_OF_ID = 0x824651c3

    def to_dict(self):
        return {
            '_': 'PrivacyKeyChatInvite'
        }

    def __bytes__(self):
        return b''.join((
            b'\xfam\x0eP',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PrivacyKeyForwards(TLObject):
    CONSTRUCTOR_ID = 0x69ec56a3
    SUBCLASS_OF_ID = 0x824651c3

    def to_dict(self):
        return {
            '_': 'PrivacyKeyForwards'
        }

    def __bytes__(self):
        return b''.join((
            b'\xa3V\xeci',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PrivacyKeyPhoneCall(TLObject):
    CONSTRUCTOR_ID = 0x3d662b7b
    SUBCLASS_OF_ID = 0x824651c3

    def to_dict(self):
        return {
            '_': 'PrivacyKeyPhoneCall'
        }

    def __bytes__(self):
        return b''.join((
            b'{+f=',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PrivacyKeyPhoneNumber(TLObject):
    CONSTRUCTOR_ID = 0xd19ae46d
    SUBCLASS_OF_ID = 0x824651c3

    def to_dict(self):
        return {
            '_': 'PrivacyKeyPhoneNumber'
        }

    def __bytes__(self):
        return b''.join((
            b'm\xe4\x9a\xd1',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PrivacyKeyPhoneP2P(TLObject):
    CONSTRUCTOR_ID = 0x39491cc8
    SUBCLASS_OF_ID = 0x824651c3

    def to_dict(self):
        return {
            '_': 'PrivacyKeyPhoneP2P'
        }

    def __bytes__(self):
        return b''.join((
            b'\xc8\x1cI9',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PrivacyKeyProfilePhoto(TLObject):
    CONSTRUCTOR_ID = 0x96151fed
    SUBCLASS_OF_ID = 0x824651c3

    def to_dict(self):
        return {
            '_': 'PrivacyKeyProfilePhoto'
        }

    def __bytes__(self):
        return b''.join((
            b'\xed\x1f\x15\x96',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PrivacyKeyStatusTimestamp(TLObject):
    CONSTRUCTOR_ID = 0xbc2eab30
    SUBCLASS_OF_ID = 0x824651c3

    def to_dict(self):
        return {
            '_': 'PrivacyKeyStatusTimestamp'
        }

    def __bytes__(self):
        return b''.join((
            b'0\xab.\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PrivacyValueAllowAll(TLObject):
    CONSTRUCTOR_ID = 0x65427b82
    SUBCLASS_OF_ID = 0xebb7f270

    def to_dict(self):
        return {
            '_': 'PrivacyValueAllowAll'
        }

    def __bytes__(self):
        return b''.join((
            b'\x82{Be',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PrivacyValueAllowChatParticipants(TLObject):
    CONSTRUCTOR_ID = 0x18be796b
    SUBCLASS_OF_ID = 0xebb7f270

    def __init__(self, chats: List[int]):
        """
        Constructor for PrivacyRule: Instance of either PrivacyValueAllowContacts, PrivacyValueAllowAll, PrivacyValueAllowUsers, PrivacyValueDisallowContacts, PrivacyValueDisallowAll, PrivacyValueDisallowUsers, PrivacyValueAllowChatParticipants, PrivacyValueDisallowChatParticipants.
        """
        self.chats = chats

    def to_dict(self):
        return {
            '_': 'PrivacyValueAllowChatParticipants',
            'chats': [] if self.chats is None else self.chats[:]
        }

    def __bytes__(self):
        return b''.join((
            b'ky\xbe\x18',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(struct.pack('<i', x) for x in self.chats),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _chats.append(_x)

        return cls(chats=_chats)


class PrivacyValueAllowContacts(TLObject):
    CONSTRUCTOR_ID = 0xfffe1bac
    SUBCLASS_OF_ID = 0xebb7f270

    def to_dict(self):
        return {
            '_': 'PrivacyValueAllowContacts'
        }

    def __bytes__(self):
        return b''.join((
            b'\xac\x1b\xfe\xff',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PrivacyValueAllowUsers(TLObject):
    CONSTRUCTOR_ID = 0x4d5bbe0c
    SUBCLASS_OF_ID = 0xebb7f270

    def __init__(self, users: List[int]):
        """
        Constructor for PrivacyRule: Instance of either PrivacyValueAllowContacts, PrivacyValueAllowAll, PrivacyValueAllowUsers, PrivacyValueDisallowContacts, PrivacyValueDisallowAll, PrivacyValueDisallowUsers, PrivacyValueAllowChatParticipants, PrivacyValueDisallowChatParticipants.
        """
        self.users = users

    def to_dict(self):
        return {
            '_': 'PrivacyValueAllowUsers',
            'users': [] if self.users is None else self.users[:]
        }

    def __bytes__(self):
        return b''.join((
            b'\x0c\xbe[M',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(struct.pack('<i', x) for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _users.append(_x)

        return cls(users=_users)


class PrivacyValueDisallowAll(TLObject):
    CONSTRUCTOR_ID = 0x8b73e763
    SUBCLASS_OF_ID = 0xebb7f270

    def to_dict(self):
        return {
            '_': 'PrivacyValueDisallowAll'
        }

    def __bytes__(self):
        return b''.join((
            b'c\xe7s\x8b',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PrivacyValueDisallowChatParticipants(TLObject):
    CONSTRUCTOR_ID = 0xacae0690
    SUBCLASS_OF_ID = 0xebb7f270

    def __init__(self, chats: List[int]):
        """
        Constructor for PrivacyRule: Instance of either PrivacyValueAllowContacts, PrivacyValueAllowAll, PrivacyValueAllowUsers, PrivacyValueDisallowContacts, PrivacyValueDisallowAll, PrivacyValueDisallowUsers, PrivacyValueAllowChatParticipants, PrivacyValueDisallowChatParticipants.
        """
        self.chats = chats

    def to_dict(self):
        return {
            '_': 'PrivacyValueDisallowChatParticipants',
            'chats': [] if self.chats is None else self.chats[:]
        }

    def __bytes__(self):
        return b''.join((
            b'\x90\x06\xae\xac',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(struct.pack('<i', x) for x in self.chats),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _chats.append(_x)

        return cls(chats=_chats)


class PrivacyValueDisallowContacts(TLObject):
    CONSTRUCTOR_ID = 0xf888fa1a
    SUBCLASS_OF_ID = 0xebb7f270

    def to_dict(self):
        return {
            '_': 'PrivacyValueDisallowContacts'
        }

    def __bytes__(self):
        return b''.join((
            b'\x1a\xfa\x88\xf8',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PrivacyValueDisallowUsers(TLObject):
    CONSTRUCTOR_ID = 0xc7f49b7
    SUBCLASS_OF_ID = 0xebb7f270

    def __init__(self, users: List[int]):
        """
        Constructor for PrivacyRule: Instance of either PrivacyValueAllowContacts, PrivacyValueAllowAll, PrivacyValueAllowUsers, PrivacyValueDisallowContacts, PrivacyValueDisallowAll, PrivacyValueDisallowUsers, PrivacyValueAllowChatParticipants, PrivacyValueDisallowChatParticipants.
        """
        self.users = users

    def to_dict(self):
        return {
            '_': 'PrivacyValueDisallowUsers',
            'users': [] if self.users is None else self.users[:]
        }

    def __bytes__(self):
        return b''.join((
            b'\xb7I\x7f\x0c',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(struct.pack('<i', x) for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _users.append(_x)

        return cls(users=_users)


class ReceivedNotifyMessage(TLObject):
    CONSTRUCTOR_ID = 0xa384b779
    SUBCLASS_OF_ID = 0xa962381e

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, flags: int):
        """
        Constructor for ReceivedNotifyMessage: Instance of ReceivedNotifyMessage.
        """
        self.id = id
        self.flags = flags

    def to_dict(self):
        return {
            '_': 'ReceivedNotifyMessage',
            'id': self.id,
            'flags': self.flags
        }

    def __bytes__(self):
        return b''.join((
            b'y\xb7\x84\xa3',
            struct.pack('<i', self.id),
            struct.pack('<i', self.flags),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_int()
        _flags = reader.read_int()
        return cls(id=_id, flags=_flags)


class RecentMeUrlChat(TLObject):
    CONSTRUCTOR_ID = 0xa01b22f9
    SUBCLASS_OF_ID = 0x55a53079

    def __init__(self, url: str, chat_id: int):
        """
        Constructor for RecentMeUrl: Instance of either RecentMeUrlUnknown, RecentMeUrlUser, RecentMeUrlChat, RecentMeUrlChatInvite, RecentMeUrlStickerSet.
        """
        self.url = url
        self.chat_id = chat_id

    def to_dict(self):
        return {
            '_': 'RecentMeUrlChat',
            'url': self.url,
            'chat_id': self.chat_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xf9"\x1b\xa0',
            self.serialize_bytes(self.url),
            struct.pack('<i', self.chat_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        _chat_id = reader.read_int()
        return cls(url=_url, chat_id=_chat_id)


class RecentMeUrlChatInvite(TLObject):
    CONSTRUCTOR_ID = 0xeb49081d
    SUBCLASS_OF_ID = 0x55a53079

    def __init__(self, url: str, chat_invite: 'TypeChatInvite'):
        """
        Constructor for RecentMeUrl: Instance of either RecentMeUrlUnknown, RecentMeUrlUser, RecentMeUrlChat, RecentMeUrlChatInvite, RecentMeUrlStickerSet.
        """
        self.url = url
        self.chat_invite = chat_invite

    def to_dict(self):
        return {
            '_': 'RecentMeUrlChatInvite',
            'url': self.url,
            'chat_invite': self.chat_invite.to_dict() if isinstance(self.chat_invite, TLObject) else self.chat_invite
        }

    def __bytes__(self):
        return b''.join((
            b'\x1d\x08I\xeb',
            self.serialize_bytes(self.url),
            bytes(self.chat_invite),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        _chat_invite = reader.tgread_object()
        return cls(url=_url, chat_invite=_chat_invite)


class RecentMeUrlStickerSet(TLObject):
    CONSTRUCTOR_ID = 0xbc0a57dc
    SUBCLASS_OF_ID = 0x55a53079

    # noinspection PyShadowingBuiltins
    def __init__(self, url: str, set: 'TypeStickerSetCovered'):
        """
        Constructor for RecentMeUrl: Instance of either RecentMeUrlUnknown, RecentMeUrlUser, RecentMeUrlChat, RecentMeUrlChatInvite, RecentMeUrlStickerSet.
        """
        self.url = url
        self.set = set

    def to_dict(self):
        return {
            '_': 'RecentMeUrlStickerSet',
            'url': self.url,
            'set': self.set.to_dict() if isinstance(self.set, TLObject) else self.set
        }

    def __bytes__(self):
        return b''.join((
            b'\xdcW\n\xbc',
            self.serialize_bytes(self.url),
            bytes(self.set),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        _set = reader.tgread_object()
        return cls(url=_url, set=_set)


class RecentMeUrlUnknown(TLObject):
    CONSTRUCTOR_ID = 0x46e1d13d
    SUBCLASS_OF_ID = 0x55a53079

    def __init__(self, url: str):
        """
        Constructor for RecentMeUrl: Instance of either RecentMeUrlUnknown, RecentMeUrlUser, RecentMeUrlChat, RecentMeUrlChatInvite, RecentMeUrlStickerSet.
        """
        self.url = url

    def to_dict(self):
        return {
            '_': 'RecentMeUrlUnknown',
            'url': self.url
        }

    def __bytes__(self):
        return b''.join((
            b'=\xd1\xe1F',
            self.serialize_bytes(self.url),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        return cls(url=_url)


class RecentMeUrlUser(TLObject):
    CONSTRUCTOR_ID = 0x8dbc3336
    SUBCLASS_OF_ID = 0x55a53079

    def __init__(self, url: str, user_id: int):
        """
        Constructor for RecentMeUrl: Instance of either RecentMeUrlUnknown, RecentMeUrlUser, RecentMeUrlChat, RecentMeUrlChatInvite, RecentMeUrlStickerSet.
        """
        self.url = url
        self.user_id = user_id

    def to_dict(self):
        return {
            '_': 'RecentMeUrlUser',
            'url': self.url,
            'user_id': self.user_id
        }

    def __bytes__(self):
        return b''.join((
            b'63\xbc\x8d',
            self.serialize_bytes(self.url),
            struct.pack('<i', self.user_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        _user_id = reader.read_int()
        return cls(url=_url, user_id=_user_id)


class ReplyInlineMarkup(TLObject):
    CONSTRUCTOR_ID = 0x48a30254
    SUBCLASS_OF_ID = 0xe2e10ef2

    def __init__(self, rows: List['TypeKeyboardButtonRow']):
        """
        Constructor for ReplyMarkup: Instance of either ReplyKeyboardHide, ReplyKeyboardForceReply, ReplyKeyboardMarkup, ReplyInlineMarkup.
        """
        self.rows = rows

    def to_dict(self):
        return {
            '_': 'ReplyInlineMarkup',
            'rows': [] if self.rows is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.rows]
        }

    def __bytes__(self):
        return b''.join((
            b'T\x02\xa3H',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.rows)),b''.join(bytes(x) for x in self.rows),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _rows = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _rows.append(_x)

        return cls(rows=_rows)


class ReplyKeyboardForceReply(TLObject):
    CONSTRUCTOR_ID = 0xf4108aa0
    SUBCLASS_OF_ID = 0xe2e10ef2

    def __init__(self, single_use: Optional[bool]=None, selective: Optional[bool]=None):
        """
        Constructor for ReplyMarkup: Instance of either ReplyKeyboardHide, ReplyKeyboardForceReply, ReplyKeyboardMarkup, ReplyInlineMarkup.
        """
        self.single_use = single_use
        self.selective = selective

    def to_dict(self):
        return {
            '_': 'ReplyKeyboardForceReply',
            'single_use': self.single_use,
            'selective': self.selective
        }

    def __bytes__(self):
        return b''.join((
            b'\xa0\x8a\x10\xf4',
            struct.pack('<I', (0 if self.single_use is None or self.single_use is False else 2) | (0 if self.selective is None or self.selective is False else 4)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _single_use = bool(flags & 2)
        _selective = bool(flags & 4)
        return cls(single_use=_single_use, selective=_selective)


class ReplyKeyboardHide(TLObject):
    CONSTRUCTOR_ID = 0xa03e5b85
    SUBCLASS_OF_ID = 0xe2e10ef2

    def __init__(self, selective: Optional[bool]=None):
        """
        Constructor for ReplyMarkup: Instance of either ReplyKeyboardHide, ReplyKeyboardForceReply, ReplyKeyboardMarkup, ReplyInlineMarkup.
        """
        self.selective = selective

    def to_dict(self):
        return {
            '_': 'ReplyKeyboardHide',
            'selective': self.selective
        }

    def __bytes__(self):
        return b''.join((
            b'\x85[>\xa0',
            struct.pack('<I', (0 if self.selective is None or self.selective is False else 4)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _selective = bool(flags & 4)
        return cls(selective=_selective)


class ReplyKeyboardMarkup(TLObject):
    CONSTRUCTOR_ID = 0x3502758c
    SUBCLASS_OF_ID = 0xe2e10ef2

    def __init__(self, rows: List['TypeKeyboardButtonRow'], resize: Optional[bool]=None, single_use: Optional[bool]=None, selective: Optional[bool]=None):
        """
        Constructor for ReplyMarkup: Instance of either ReplyKeyboardHide, ReplyKeyboardForceReply, ReplyKeyboardMarkup, ReplyInlineMarkup.
        """
        self.rows = rows
        self.resize = resize
        self.single_use = single_use
        self.selective = selective

    def to_dict(self):
        return {
            '_': 'ReplyKeyboardMarkup',
            'rows': [] if self.rows is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.rows],
            'resize': self.resize,
            'single_use': self.single_use,
            'selective': self.selective
        }

    def __bytes__(self):
        return b''.join((
            b'\x8cu\x025',
            struct.pack('<I', (0 if self.resize is None or self.resize is False else 1) | (0 if self.single_use is None or self.single_use is False else 2) | (0 if self.selective is None or self.selective is False else 4)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.rows)),b''.join(bytes(x) for x in self.rows),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _resize = bool(flags & 1)
        _single_use = bool(flags & 2)
        _selective = bool(flags & 4)
        reader.read_int()
        _rows = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _rows.append(_x)

        return cls(rows=_rows, resize=_resize, single_use=_single_use, selective=_selective)


class ResPQ(TLObject):
    CONSTRUCTOR_ID = 0x5162463
    SUBCLASS_OF_ID = 0x786986b8

    def __init__(self, nonce: int, server_nonce: int, pq: bytes, server_public_key_fingerprints: List[int]):
        """
        Constructor for ResPQ: Instance of ResPQ.
        """
        self.nonce = nonce
        self.server_nonce = server_nonce
        self.pq = pq
        self.server_public_key_fingerprints = server_public_key_fingerprints

    def to_dict(self):
        return {
            '_': 'ResPQ',
            'nonce': self.nonce,
            'server_nonce': self.server_nonce,
            'pq': self.pq,
            'server_public_key_fingerprints': [] if self.server_public_key_fingerprints is None else self.server_public_key_fingerprints[:]
        }

    def __bytes__(self):
        return b''.join((
            b'c$\x16\x05',
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.serialize_bytes(self.pq),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.server_public_key_fingerprints)),b''.join(struct.pack('<q', x) for x in self.server_public_key_fingerprints),
        ))

    @classmethod
    def from_reader(cls, reader):
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _pq = reader.tgread_bytes()
        reader.read_int()
        _server_public_key_fingerprints = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _server_public_key_fingerprints.append(_x)

        return cls(nonce=_nonce, server_nonce=_server_nonce, pq=_pq, server_public_key_fingerprints=_server_public_key_fingerprints)


class RestrictionReason(TLObject):
    CONSTRUCTOR_ID = 0xd072acb4
    SUBCLASS_OF_ID = 0x6ad95ad

    def __init__(self, platform: str, reason: str, text: str):
        """
        Constructor for RestrictionReason: Instance of RestrictionReason.
        """
        self.platform = platform
        self.reason = reason
        self.text = text

    def to_dict(self):
        return {
            '_': 'RestrictionReason',
            'platform': self.platform,
            'reason': self.reason,
            'text': self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\xb4\xacr\xd0',
            self.serialize_bytes(self.platform),
            self.serialize_bytes(self.reason),
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _platform = reader.tgread_string()
        _reason = reader.tgread_string()
        _text = reader.tgread_string()
        return cls(platform=_platform, reason=_reason, text=_text)


class RpcAnswerDropped(TLObject):
    CONSTRUCTOR_ID = 0xa43ad8b7
    SUBCLASS_OF_ID = 0x4bca7570

    # noinspection PyShadowingBuiltins
    def __init__(self, msg_id: int, seq_no: int, bytes: int):
        """
        Constructor for RpcDropAnswer: Instance of either RpcAnswerUnknown, RpcAnswerDroppedRunning, RpcAnswerDropped.
        """
        self.msg_id = msg_id
        self.seq_no = seq_no
        self.bytes = bytes

    def to_dict(self):
        return {
            '_': 'RpcAnswerDropped',
            'msg_id': self.msg_id,
            'seq_no': self.seq_no,
            'bytes': self.bytes
        }

    def __bytes__(self):
        return b''.join((
            b'\xb7\xd8:\xa4',
            struct.pack('<q', self.msg_id),
            struct.pack('<i', self.seq_no),
            struct.pack('<i', self.bytes),
        ))

    @classmethod
    def from_reader(cls, reader):
        _msg_id = reader.read_long()
        _seq_no = reader.read_int()
        _bytes = reader.read_int()
        return cls(msg_id=_msg_id, seq_no=_seq_no, bytes=_bytes)


class RpcAnswerDroppedRunning(TLObject):
    CONSTRUCTOR_ID = 0xcd78e586
    SUBCLASS_OF_ID = 0x4bca7570

    def to_dict(self):
        return {
            '_': 'RpcAnswerDroppedRunning'
        }

    def __bytes__(self):
        return b''.join((
            b'\x86\xe5x\xcd',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class RpcAnswerUnknown(TLObject):
    CONSTRUCTOR_ID = 0x5e2ad36e
    SUBCLASS_OF_ID = 0x4bca7570

    def to_dict(self):
        return {
            '_': 'RpcAnswerUnknown'
        }

    def __bytes__(self):
        return b''.join((
            b'n\xd3*^',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class RpcError(TLObject):
    CONSTRUCTOR_ID = 0x2144ca19
    SUBCLASS_OF_ID = 0x4a17e265

    def __init__(self, error_code: int, error_message: str):
        """
        Constructor for RpcError: Instance of RpcError.
        """
        self.error_code = error_code
        self.error_message = error_message

    def to_dict(self):
        return {
            '_': 'RpcError',
            'error_code': self.error_code,
            'error_message': self.error_message
        }

    def __bytes__(self):
        return b''.join((
            b'\x19\xcaD!',
            struct.pack('<i', self.error_code),
            self.serialize_bytes(self.error_message),
        ))

    @classmethod
    def from_reader(cls, reader):
        _error_code = reader.read_int()
        _error_message = reader.tgread_string()
        return cls(error_code=_error_code, error_message=_error_message)


class SavedPhoneContact(TLObject):
    CONSTRUCTOR_ID = 0x1142bd56
    SUBCLASS_OF_ID = 0x6db98c4

    def __init__(self, phone: str, first_name: str, last_name: str, date: Optional[datetime]):
        """
        Constructor for SavedContact: Instance of SavedPhoneContact.
        """
        self.phone = phone
        self.first_name = first_name
        self.last_name = last_name
        self.date = date

    def to_dict(self):
        return {
            '_': 'SavedPhoneContact',
            'phone': self.phone,
            'first_name': self.first_name,
            'last_name': self.last_name,
            'date': self.date
        }

    def __bytes__(self):
        return b''.join((
            b'V\xbdB\x11',
            self.serialize_bytes(self.phone),
            self.serialize_bytes(self.first_name),
            self.serialize_bytes(self.last_name),
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _phone = reader.tgread_string()
        _first_name = reader.tgread_string()
        _last_name = reader.tgread_string()
        _date = reader.tgread_date()
        return cls(phone=_phone, first_name=_first_name, last_name=_last_name, date=_date)


class SecureCredentialsEncrypted(TLObject):
    CONSTRUCTOR_ID = 0x33f0ea47
    SUBCLASS_OF_ID = 0x94dc7633

    # noinspection PyShadowingBuiltins
    def __init__(self, data: bytes, hash: bytes, secret: bytes):
        """
        Constructor for SecureCredentialsEncrypted: Instance of SecureCredentialsEncrypted.
        """
        self.data = data
        self.hash = hash
        self.secret = secret

    def to_dict(self):
        return {
            '_': 'SecureCredentialsEncrypted',
            'data': self.data,
            'hash': self.hash,
            'secret': self.secret
        }

    def __bytes__(self):
        return b''.join((
            b'G\xea\xf03',
            self.serialize_bytes(self.data),
            self.serialize_bytes(self.hash),
            self.serialize_bytes(self.secret),
        ))

    @classmethod
    def from_reader(cls, reader):
        _data = reader.tgread_bytes()
        _hash = reader.tgread_bytes()
        _secret = reader.tgread_bytes()
        return cls(data=_data, hash=_hash, secret=_secret)


class SecureData(TLObject):
    CONSTRUCTOR_ID = 0x8aeabec3
    SUBCLASS_OF_ID = 0x7cd41eb4

    def __init__(self, data: bytes, data_hash: bytes, secret: bytes):
        """
        Constructor for SecureData: Instance of SecureData.
        """
        self.data = data
        self.data_hash = data_hash
        self.secret = secret

    def to_dict(self):
        return {
            '_': 'SecureData',
            'data': self.data,
            'data_hash': self.data_hash,
            'secret': self.secret
        }

    def __bytes__(self):
        return b''.join((
            b'\xc3\xbe\xea\x8a',
            self.serialize_bytes(self.data),
            self.serialize_bytes(self.data_hash),
            self.serialize_bytes(self.secret),
        ))

    @classmethod
    def from_reader(cls, reader):
        _data = reader.tgread_bytes()
        _data_hash = reader.tgread_bytes()
        _secret = reader.tgread_bytes()
        return cls(data=_data, data_hash=_data_hash, secret=_secret)


class SecureFile(TLObject):
    CONSTRUCTOR_ID = 0xe0277a62
    SUBCLASS_OF_ID = 0x5db8dbc7

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, size: int, dc_id: int, date: Optional[datetime], file_hash: bytes, secret: bytes):
        """
        Constructor for SecureFile: Instance of either SecureFileEmpty, SecureFile.
        """
        self.id = id
        self.access_hash = access_hash
        self.size = size
        self.dc_id = dc_id
        self.date = date
        self.file_hash = file_hash
        self.secret = secret

    def to_dict(self):
        return {
            '_': 'SecureFile',
            'id': self.id,
            'access_hash': self.access_hash,
            'size': self.size,
            'dc_id': self.dc_id,
            'date': self.date,
            'file_hash': self.file_hash,
            'secret': self.secret
        }

    def __bytes__(self):
        return b''.join((
            b"bz'\xe0",
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            struct.pack('<i', self.size),
            struct.pack('<i', self.dc_id),
            self.serialize_datetime(self.date),
            self.serialize_bytes(self.file_hash),
            self.serialize_bytes(self.secret),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _size = reader.read_int()
        _dc_id = reader.read_int()
        _date = reader.tgread_date()
        _file_hash = reader.tgread_bytes()
        _secret = reader.tgread_bytes()
        return cls(id=_id, access_hash=_access_hash, size=_size, dc_id=_dc_id, date=_date, file_hash=_file_hash, secret=_secret)


class SecureFileEmpty(TLObject):
    CONSTRUCTOR_ID = 0x64199744
    SUBCLASS_OF_ID = 0x5db8dbc7

    def to_dict(self):
        return {
            '_': 'SecureFileEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'D\x97\x19d',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SecurePasswordKdfAlgoPBKDF2HMACSHA512iter100000(TLObject):
    CONSTRUCTOR_ID = 0xbbf2dda0
    SUBCLASS_OF_ID = 0x77262943

    def __init__(self, salt: bytes):
        """
        Constructor for SecurePasswordKdfAlgo: Instance of either SecurePasswordKdfAlgoUnknown, SecurePasswordKdfAlgoPBKDF2HMACSHA512iter100000, SecurePasswordKdfAlgoSHA512.
        """
        self.salt = salt

    def to_dict(self):
        return {
            '_': 'SecurePasswordKdfAlgoPBKDF2HMACSHA512iter100000',
            'salt': self.salt
        }

    def __bytes__(self):
        return b''.join((
            b'\xa0\xdd\xf2\xbb',
            self.serialize_bytes(self.salt),
        ))

    @classmethod
    def from_reader(cls, reader):
        _salt = reader.tgread_bytes()
        return cls(salt=_salt)


class SecurePasswordKdfAlgoSHA512(TLObject):
    CONSTRUCTOR_ID = 0x86471d92
    SUBCLASS_OF_ID = 0x77262943

    def __init__(self, salt: bytes):
        """
        Constructor for SecurePasswordKdfAlgo: Instance of either SecurePasswordKdfAlgoUnknown, SecurePasswordKdfAlgoPBKDF2HMACSHA512iter100000, SecurePasswordKdfAlgoSHA512.
        """
        self.salt = salt

    def to_dict(self):
        return {
            '_': 'SecurePasswordKdfAlgoSHA512',
            'salt': self.salt
        }

    def __bytes__(self):
        return b''.join((
            b'\x92\x1dG\x86',
            self.serialize_bytes(self.salt),
        ))

    @classmethod
    def from_reader(cls, reader):
        _salt = reader.tgread_bytes()
        return cls(salt=_salt)


class SecurePasswordKdfAlgoUnknown(TLObject):
    CONSTRUCTOR_ID = 0x4a8537
    SUBCLASS_OF_ID = 0x77262943

    def to_dict(self):
        return {
            '_': 'SecurePasswordKdfAlgoUnknown'
        }

    def __bytes__(self):
        return b''.join((
            b'7\x85J\x00',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SecurePlainEmail(TLObject):
    CONSTRUCTOR_ID = 0x21ec5a5f
    SUBCLASS_OF_ID = 0x23b2afb6

    def __init__(self, email: str):
        """
        Constructor for SecurePlainData: Instance of either SecurePlainPhone, SecurePlainEmail.
        """
        self.email = email

    def to_dict(self):
        return {
            '_': 'SecurePlainEmail',
            'email': self.email
        }

    def __bytes__(self):
        return b''.join((
            b'_Z\xec!',
            self.serialize_bytes(self.email),
        ))

    @classmethod
    def from_reader(cls, reader):
        _email = reader.tgread_string()
        return cls(email=_email)


class SecurePlainPhone(TLObject):
    CONSTRUCTOR_ID = 0x7d6099dd
    SUBCLASS_OF_ID = 0x23b2afb6

    def __init__(self, phone: str):
        """
        Constructor for SecurePlainData: Instance of either SecurePlainPhone, SecurePlainEmail.
        """
        self.phone = phone

    def to_dict(self):
        return {
            '_': 'SecurePlainPhone',
            'phone': self.phone
        }

    def __bytes__(self):
        return b''.join((
            b'\xdd\x99`}',
            self.serialize_bytes(self.phone),
        ))

    @classmethod
    def from_reader(cls, reader):
        _phone = reader.tgread_string()
        return cls(phone=_phone)


class SecureRequiredType(TLObject):
    CONSTRUCTOR_ID = 0x829d99da
    SUBCLASS_OF_ID = 0x7c7b420a

    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', native_names: Optional[bool]=None, selfie_required: Optional[bool]=None, translation_required: Optional[bool]=None):
        """
        Constructor for SecureRequiredType: Instance of either SecureRequiredType, SecureRequiredTypeOneOf.
        """
        self.type = type
        self.native_names = native_names
        self.selfie_required = selfie_required
        self.translation_required = translation_required

    def to_dict(self):
        return {
            '_': 'SecureRequiredType',
            'type': self.type.to_dict() if isinstance(self.type, TLObject) else self.type,
            'native_names': self.native_names,
            'selfie_required': self.selfie_required,
            'translation_required': self.translation_required
        }

    def __bytes__(self):
        return b''.join((
            b'\xda\x99\x9d\x82',
            struct.pack('<I', (0 if self.native_names is None or self.native_names is False else 1) | (0 if self.selfie_required is None or self.selfie_required is False else 2) | (0 if self.translation_required is None or self.translation_required is False else 4)),
            bytes(self.type),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _native_names = bool(flags & 1)
        _selfie_required = bool(flags & 2)
        _translation_required = bool(flags & 4)
        _type = reader.tgread_object()
        return cls(type=_type, native_names=_native_names, selfie_required=_selfie_required, translation_required=_translation_required)


class SecureRequiredTypeOneOf(TLObject):
    CONSTRUCTOR_ID = 0x27477b4
    SUBCLASS_OF_ID = 0x7c7b420a

    def __init__(self, types: List['TypeSecureRequiredType']):
        """
        Constructor for SecureRequiredType: Instance of either SecureRequiredType, SecureRequiredTypeOneOf.
        """
        self.types = types

    def to_dict(self):
        return {
            '_': 'SecureRequiredTypeOneOf',
            'types': [] if self.types is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.types]
        }

    def __bytes__(self):
        return b''.join((
            b'\xb4wt\x02',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.types)),b''.join(bytes(x) for x in self.types),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _types = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _types.append(_x)

        return cls(types=_types)


class SecureSecretSettings(TLObject):
    CONSTRUCTOR_ID = 0x1527bcac
    SUBCLASS_OF_ID = 0xc6c802fb

    def __init__(self, secure_algo: 'TypeSecurePasswordKdfAlgo', secure_secret: bytes, secure_secret_id: int):
        """
        Constructor for SecureSecretSettings: Instance of SecureSecretSettings.
        """
        self.secure_algo = secure_algo
        self.secure_secret = secure_secret
        self.secure_secret_id = secure_secret_id

    def to_dict(self):
        return {
            '_': 'SecureSecretSettings',
            'secure_algo': self.secure_algo.to_dict() if isinstance(self.secure_algo, TLObject) else self.secure_algo,
            'secure_secret': self.secure_secret,
            'secure_secret_id': self.secure_secret_id
        }

    def __bytes__(self):
        return b''.join((
            b"\xac\xbc'\x15",
            bytes(self.secure_algo),
            self.serialize_bytes(self.secure_secret),
            struct.pack('<q', self.secure_secret_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _secure_algo = reader.tgread_object()
        _secure_secret = reader.tgread_bytes()
        _secure_secret_id = reader.read_long()
        return cls(secure_algo=_secure_algo, secure_secret=_secure_secret, secure_secret_id=_secure_secret_id)


class SecureValue(TLObject):
    CONSTRUCTOR_ID = 0x187fa0ca
    SUBCLASS_OF_ID = 0x51138ae

    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', hash: bytes, data: Optional['TypeSecureData']=None, front_side: Optional['TypeSecureFile']=None, reverse_side: Optional['TypeSecureFile']=None, selfie: Optional['TypeSecureFile']=None, translation: Optional[List['TypeSecureFile']]=None, files: Optional[List['TypeSecureFile']]=None, plain_data: Optional['TypeSecurePlainData']=None):
        """
        Constructor for SecureValue: Instance of SecureValue.
        """
        self.type = type
        self.hash = hash
        self.data = data
        self.front_side = front_side
        self.reverse_side = reverse_side
        self.selfie = selfie
        self.translation = translation
        self.files = files
        self.plain_data = plain_data

    def to_dict(self):
        return {
            '_': 'SecureValue',
            'type': self.type.to_dict() if isinstance(self.type, TLObject) else self.type,
            'hash': self.hash,
            'data': self.data.to_dict() if isinstance(self.data, TLObject) else self.data,
            'front_side': self.front_side.to_dict() if isinstance(self.front_side, TLObject) else self.front_side,
            'reverse_side': self.reverse_side.to_dict() if isinstance(self.reverse_side, TLObject) else self.reverse_side,
            'selfie': self.selfie.to_dict() if isinstance(self.selfie, TLObject) else self.selfie,
            'translation': [] if self.translation is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.translation],
            'files': [] if self.files is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.files],
            'plain_data': self.plain_data.to_dict() if isinstance(self.plain_data, TLObject) else self.plain_data
        }

    def __bytes__(self):
        return b''.join((
            b'\xca\xa0\x7f\x18',
            struct.pack('<I', (0 if self.data is None or self.data is False else 1) | (0 if self.front_side is None or self.front_side is False else 2) | (0 if self.reverse_side is None or self.reverse_side is False else 4) | (0 if self.selfie is None or self.selfie is False else 8) | (0 if self.translation is None or self.translation is False else 64) | (0 if self.files is None or self.files is False else 16) | (0 if self.plain_data is None or self.plain_data is False else 32)),
            bytes(self.type),
            b'' if self.data is None or self.data is False else (bytes(self.data)),
            b'' if self.front_side is None or self.front_side is False else (bytes(self.front_side)),
            b'' if self.reverse_side is None or self.reverse_side is False else (bytes(self.reverse_side)),
            b'' if self.selfie is None or self.selfie is False else (bytes(self.selfie)),
            b'' if self.translation is None or self.translation is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.translation)),b''.join(bytes(x) for x in self.translation))),
            b'' if self.files is None or self.files is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.files)),b''.join(bytes(x) for x in self.files))),
            b'' if self.plain_data is None or self.plain_data is False else (bytes(self.plain_data)),
            self.serialize_bytes(self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _type = reader.tgread_object()
        if flags & 1:
            _data = reader.tgread_object()
        else:
            _data = None
        if flags & 2:
            _front_side = reader.tgread_object()
        else:
            _front_side = None
        if flags & 4:
            _reverse_side = reader.tgread_object()
        else:
            _reverse_side = None
        if flags & 8:
            _selfie = reader.tgread_object()
        else:
            _selfie = None
        if flags & 64:
            reader.read_int()
            _translation = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _translation.append(_x)

        else:
            _translation = None
        if flags & 16:
            reader.read_int()
            _files = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _files.append(_x)

        else:
            _files = None
        if flags & 32:
            _plain_data = reader.tgread_object()
        else:
            _plain_data = None
        _hash = reader.tgread_bytes()
        return cls(type=_type, hash=_hash, data=_data, front_side=_front_side, reverse_side=_reverse_side, selfie=_selfie, translation=_translation, files=_files, plain_data=_plain_data)


class SecureValueError(TLObject):
    CONSTRUCTOR_ID = 0x869d758f
    SUBCLASS_OF_ID = 0x6075fce

    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', hash: bytes, text: str):
        """
        Constructor for SecureValueError: Instance of either SecureValueErrorData, SecureValueErrorFrontSide, SecureValueErrorReverseSide, SecureValueErrorSelfie, SecureValueErrorFile, SecureValueErrorFiles, SecureValueError, SecureValueErrorTranslationFile, SecureValueErrorTranslationFiles.
        """
        self.type = type
        self.hash = hash
        self.text = text

    def to_dict(self):
        return {
            '_': 'SecureValueError',
            'type': self.type.to_dict() if isinstance(self.type, TLObject) else self.type,
            'hash': self.hash,
            'text': self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\x8fu\x9d\x86',
            bytes(self.type),
            self.serialize_bytes(self.hash),
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _type = reader.tgread_object()
        _hash = reader.tgread_bytes()
        _text = reader.tgread_string()
        return cls(type=_type, hash=_hash, text=_text)


class SecureValueErrorData(TLObject):
    CONSTRUCTOR_ID = 0xe8a40bd9
    SUBCLASS_OF_ID = 0x6075fce

    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', data_hash: bytes, field: str, text: str):
        """
        Constructor for SecureValueError: Instance of either SecureValueErrorData, SecureValueErrorFrontSide, SecureValueErrorReverseSide, SecureValueErrorSelfie, SecureValueErrorFile, SecureValueErrorFiles, SecureValueError, SecureValueErrorTranslationFile, SecureValueErrorTranslationFiles.
        """
        self.type = type
        self.data_hash = data_hash
        self.field = field
        self.text = text

    def to_dict(self):
        return {
            '_': 'SecureValueErrorData',
            'type': self.type.to_dict() if isinstance(self.type, TLObject) else self.type,
            'data_hash': self.data_hash,
            'field': self.field,
            'text': self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\xd9\x0b\xa4\xe8',
            bytes(self.type),
            self.serialize_bytes(self.data_hash),
            self.serialize_bytes(self.field),
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _type = reader.tgread_object()
        _data_hash = reader.tgread_bytes()
        _field = reader.tgread_string()
        _text = reader.tgread_string()
        return cls(type=_type, data_hash=_data_hash, field=_field, text=_text)


class SecureValueErrorFile(TLObject):
    CONSTRUCTOR_ID = 0x7a700873
    SUBCLASS_OF_ID = 0x6075fce

    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', file_hash: bytes, text: str):
        """
        Constructor for SecureValueError: Instance of either SecureValueErrorData, SecureValueErrorFrontSide, SecureValueErrorReverseSide, SecureValueErrorSelfie, SecureValueErrorFile, SecureValueErrorFiles, SecureValueError, SecureValueErrorTranslationFile, SecureValueErrorTranslationFiles.
        """
        self.type = type
        self.file_hash = file_hash
        self.text = text

    def to_dict(self):
        return {
            '_': 'SecureValueErrorFile',
            'type': self.type.to_dict() if isinstance(self.type, TLObject) else self.type,
            'file_hash': self.file_hash,
            'text': self.text
        }

    def __bytes__(self):
        return b''.join((
            b's\x08pz',
            bytes(self.type),
            self.serialize_bytes(self.file_hash),
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _type = reader.tgread_object()
        _file_hash = reader.tgread_bytes()
        _text = reader.tgread_string()
        return cls(type=_type, file_hash=_file_hash, text=_text)


class SecureValueErrorFiles(TLObject):
    CONSTRUCTOR_ID = 0x666220e9
    SUBCLASS_OF_ID = 0x6075fce

    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', file_hash: List[bytes], text: str):
        """
        Constructor for SecureValueError: Instance of either SecureValueErrorData, SecureValueErrorFrontSide, SecureValueErrorReverseSide, SecureValueErrorSelfie, SecureValueErrorFile, SecureValueErrorFiles, SecureValueError, SecureValueErrorTranslationFile, SecureValueErrorTranslationFiles.
        """
        self.type = type
        self.file_hash = file_hash
        self.text = text

    def to_dict(self):
        return {
            '_': 'SecureValueErrorFiles',
            'type': self.type.to_dict() if isinstance(self.type, TLObject) else self.type,
            'file_hash': [] if self.file_hash is None else self.file_hash[:],
            'text': self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\xe9 bf',
            bytes(self.type),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.file_hash)),b''.join(self.serialize_bytes(x) for x in self.file_hash),
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _type = reader.tgread_object()
        reader.read_int()
        _file_hash = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_bytes()
            _file_hash.append(_x)

        _text = reader.tgread_string()
        return cls(type=_type, file_hash=_file_hash, text=_text)


class SecureValueErrorFrontSide(TLObject):
    CONSTRUCTOR_ID = 0xbe3dfa
    SUBCLASS_OF_ID = 0x6075fce

    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', file_hash: bytes, text: str):
        """
        Constructor for SecureValueError: Instance of either SecureValueErrorData, SecureValueErrorFrontSide, SecureValueErrorReverseSide, SecureValueErrorSelfie, SecureValueErrorFile, SecureValueErrorFiles, SecureValueError, SecureValueErrorTranslationFile, SecureValueErrorTranslationFiles.
        """
        self.type = type
        self.file_hash = file_hash
        self.text = text

    def to_dict(self):
        return {
            '_': 'SecureValueErrorFrontSide',
            'type': self.type.to_dict() if isinstance(self.type, TLObject) else self.type,
            'file_hash': self.file_hash,
            'text': self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\xfa=\xbe\x00',
            bytes(self.type),
            self.serialize_bytes(self.file_hash),
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _type = reader.tgread_object()
        _file_hash = reader.tgread_bytes()
        _text = reader.tgread_string()
        return cls(type=_type, file_hash=_file_hash, text=_text)


class SecureValueErrorReverseSide(TLObject):
    CONSTRUCTOR_ID = 0x868a2aa5
    SUBCLASS_OF_ID = 0x6075fce

    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', file_hash: bytes, text: str):
        """
        Constructor for SecureValueError: Instance of either SecureValueErrorData, SecureValueErrorFrontSide, SecureValueErrorReverseSide, SecureValueErrorSelfie, SecureValueErrorFile, SecureValueErrorFiles, SecureValueError, SecureValueErrorTranslationFile, SecureValueErrorTranslationFiles.
        """
        self.type = type
        self.file_hash = file_hash
        self.text = text

    def to_dict(self):
        return {
            '_': 'SecureValueErrorReverseSide',
            'type': self.type.to_dict() if isinstance(self.type, TLObject) else self.type,
            'file_hash': self.file_hash,
            'text': self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\xa5*\x8a\x86',
            bytes(self.type),
            self.serialize_bytes(self.file_hash),
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _type = reader.tgread_object()
        _file_hash = reader.tgread_bytes()
        _text = reader.tgread_string()
        return cls(type=_type, file_hash=_file_hash, text=_text)


class SecureValueErrorSelfie(TLObject):
    CONSTRUCTOR_ID = 0xe537ced6
    SUBCLASS_OF_ID = 0x6075fce

    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', file_hash: bytes, text: str):
        """
        Constructor for SecureValueError: Instance of either SecureValueErrorData, SecureValueErrorFrontSide, SecureValueErrorReverseSide, SecureValueErrorSelfie, SecureValueErrorFile, SecureValueErrorFiles, SecureValueError, SecureValueErrorTranslationFile, SecureValueErrorTranslationFiles.
        """
        self.type = type
        self.file_hash = file_hash
        self.text = text

    def to_dict(self):
        return {
            '_': 'SecureValueErrorSelfie',
            'type': self.type.to_dict() if isinstance(self.type, TLObject) else self.type,
            'file_hash': self.file_hash,
            'text': self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\xd6\xce7\xe5',
            bytes(self.type),
            self.serialize_bytes(self.file_hash),
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _type = reader.tgread_object()
        _file_hash = reader.tgread_bytes()
        _text = reader.tgread_string()
        return cls(type=_type, file_hash=_file_hash, text=_text)


class SecureValueErrorTranslationFile(TLObject):
    CONSTRUCTOR_ID = 0xa1144770
    SUBCLASS_OF_ID = 0x6075fce

    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', file_hash: bytes, text: str):
        """
        Constructor for SecureValueError: Instance of either SecureValueErrorData, SecureValueErrorFrontSide, SecureValueErrorReverseSide, SecureValueErrorSelfie, SecureValueErrorFile, SecureValueErrorFiles, SecureValueError, SecureValueErrorTranslationFile, SecureValueErrorTranslationFiles.
        """
        self.type = type
        self.file_hash = file_hash
        self.text = text

    def to_dict(self):
        return {
            '_': 'SecureValueErrorTranslationFile',
            'type': self.type.to_dict() if isinstance(self.type, TLObject) else self.type,
            'file_hash': self.file_hash,
            'text': self.text
        }

    def __bytes__(self):
        return b''.join((
            b'pG\x14\xa1',
            bytes(self.type),
            self.serialize_bytes(self.file_hash),
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _type = reader.tgread_object()
        _file_hash = reader.tgread_bytes()
        _text = reader.tgread_string()
        return cls(type=_type, file_hash=_file_hash, text=_text)


class SecureValueErrorTranslationFiles(TLObject):
    CONSTRUCTOR_ID = 0x34636dd8
    SUBCLASS_OF_ID = 0x6075fce

    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', file_hash: List[bytes], text: str):
        """
        Constructor for SecureValueError: Instance of either SecureValueErrorData, SecureValueErrorFrontSide, SecureValueErrorReverseSide, SecureValueErrorSelfie, SecureValueErrorFile, SecureValueErrorFiles, SecureValueError, SecureValueErrorTranslationFile, SecureValueErrorTranslationFiles.
        """
        self.type = type
        self.file_hash = file_hash
        self.text = text

    def to_dict(self):
        return {
            '_': 'SecureValueErrorTranslationFiles',
            'type': self.type.to_dict() if isinstance(self.type, TLObject) else self.type,
            'file_hash': [] if self.file_hash is None else self.file_hash[:],
            'text': self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\xd8mc4',
            bytes(self.type),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.file_hash)),b''.join(self.serialize_bytes(x) for x in self.file_hash),
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _type = reader.tgread_object()
        reader.read_int()
        _file_hash = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_bytes()
            _file_hash.append(_x)

        _text = reader.tgread_string()
        return cls(type=_type, file_hash=_file_hash, text=_text)


class SecureValueHash(TLObject):
    CONSTRUCTOR_ID = 0xed1ecdb0
    SUBCLASS_OF_ID = 0xd5f5c007

    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', hash: bytes):
        """
        Constructor for SecureValueHash: Instance of SecureValueHash.
        """
        self.type = type
        self.hash = hash

    def to_dict(self):
        return {
            '_': 'SecureValueHash',
            'type': self.type.to_dict() if isinstance(self.type, TLObject) else self.type,
            'hash': self.hash
        }

    def __bytes__(self):
        return b''.join((
            b'\xb0\xcd\x1e\xed',
            bytes(self.type),
            self.serialize_bytes(self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _type = reader.tgread_object()
        _hash = reader.tgread_bytes()
        return cls(type=_type, hash=_hash)


class SecureValueTypeAddress(TLObject):
    CONSTRUCTOR_ID = 0xcbe31e26
    SUBCLASS_OF_ID = 0x8893f596

    def to_dict(self):
        return {
            '_': 'SecureValueTypeAddress'
        }

    def __bytes__(self):
        return b''.join((
            b'&\x1e\xe3\xcb',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SecureValueTypeBankStatement(TLObject):
    CONSTRUCTOR_ID = 0x89137c0d
    SUBCLASS_OF_ID = 0x8893f596

    def to_dict(self):
        return {
            '_': 'SecureValueTypeBankStatement'
        }

    def __bytes__(self):
        return b''.join((
            b'\r|\x13\x89',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SecureValueTypeDriverLicense(TLObject):
    CONSTRUCTOR_ID = 0x6e425c4
    SUBCLASS_OF_ID = 0x8893f596

    def to_dict(self):
        return {
            '_': 'SecureValueTypeDriverLicense'
        }

    def __bytes__(self):
        return b''.join((
            b'\xc4%\xe4\x06',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SecureValueTypeEmail(TLObject):
    CONSTRUCTOR_ID = 0x8e3ca7ee
    SUBCLASS_OF_ID = 0x8893f596

    def to_dict(self):
        return {
            '_': 'SecureValueTypeEmail'
        }

    def __bytes__(self):
        return b''.join((
            b'\xee\xa7<\x8e',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SecureValueTypeIdentityCard(TLObject):
    CONSTRUCTOR_ID = 0xa0d0744b
    SUBCLASS_OF_ID = 0x8893f596

    def to_dict(self):
        return {
            '_': 'SecureValueTypeIdentityCard'
        }

    def __bytes__(self):
        return b''.join((
            b'Kt\xd0\xa0',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SecureValueTypeInternalPassport(TLObject):
    CONSTRUCTOR_ID = 0x99a48f23
    SUBCLASS_OF_ID = 0x8893f596

    def to_dict(self):
        return {
            '_': 'SecureValueTypeInternalPassport'
        }

    def __bytes__(self):
        return b''.join((
            b'#\x8f\xa4\x99',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SecureValueTypePassport(TLObject):
    CONSTRUCTOR_ID = 0x3dac6a00
    SUBCLASS_OF_ID = 0x8893f596

    def to_dict(self):
        return {
            '_': 'SecureValueTypePassport'
        }

    def __bytes__(self):
        return b''.join((
            b'\x00j\xac=',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SecureValueTypePassportRegistration(TLObject):
    CONSTRUCTOR_ID = 0x99e3806a
    SUBCLASS_OF_ID = 0x8893f596

    def to_dict(self):
        return {
            '_': 'SecureValueTypePassportRegistration'
        }

    def __bytes__(self):
        return b''.join((
            b'j\x80\xe3\x99',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SecureValueTypePersonalDetails(TLObject):
    CONSTRUCTOR_ID = 0x9d2a81e3
    SUBCLASS_OF_ID = 0x8893f596

    def to_dict(self):
        return {
            '_': 'SecureValueTypePersonalDetails'
        }

    def __bytes__(self):
        return b''.join((
            b'\xe3\x81*\x9d',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SecureValueTypePhone(TLObject):
    CONSTRUCTOR_ID = 0xb320aadb
    SUBCLASS_OF_ID = 0x8893f596

    def to_dict(self):
        return {
            '_': 'SecureValueTypePhone'
        }

    def __bytes__(self):
        return b''.join((
            b'\xdb\xaa \xb3',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SecureValueTypeRentalAgreement(TLObject):
    CONSTRUCTOR_ID = 0x8b883488
    SUBCLASS_OF_ID = 0x8893f596

    def to_dict(self):
        return {
            '_': 'SecureValueTypeRentalAgreement'
        }

    def __bytes__(self):
        return b''.join((
            b'\x884\x88\x8b',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SecureValueTypeTemporaryRegistration(TLObject):
    CONSTRUCTOR_ID = 0xea02ec33
    SUBCLASS_OF_ID = 0x8893f596

    def to_dict(self):
        return {
            '_': 'SecureValueTypeTemporaryRegistration'
        }

    def __bytes__(self):
        return b''.join((
            b'3\xec\x02\xea',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SecureValueTypeUtilityBill(TLObject):
    CONSTRUCTOR_ID = 0xfc36954e
    SUBCLASS_OF_ID = 0x8893f596

    def to_dict(self):
        return {
            '_': 'SecureValueTypeUtilityBill'
        }

    def __bytes__(self):
        return b''.join((
            b'N\x956\xfc',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SendMessageCancelAction(TLObject):
    CONSTRUCTOR_ID = 0xfd5ec8f5
    SUBCLASS_OF_ID = 0x20b2cc21

    def to_dict(self):
        return {
            '_': 'SendMessageCancelAction'
        }

    def __bytes__(self):
        return b''.join((
            b'\xf5\xc8^\xfd',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SendMessageChooseContactAction(TLObject):
    CONSTRUCTOR_ID = 0x628cbc6f
    SUBCLASS_OF_ID = 0x20b2cc21

    def to_dict(self):
        return {
            '_': 'SendMessageChooseContactAction'
        }

    def __bytes__(self):
        return b''.join((
            b'o\xbc\x8cb',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SendMessageGamePlayAction(TLObject):
    CONSTRUCTOR_ID = 0xdd6a8f48
    SUBCLASS_OF_ID = 0x20b2cc21

    def to_dict(self):
        return {
            '_': 'SendMessageGamePlayAction'
        }

    def __bytes__(self):
        return b''.join((
            b'H\x8fj\xdd',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SendMessageGeoLocationAction(TLObject):
    CONSTRUCTOR_ID = 0x176f8ba1
    SUBCLASS_OF_ID = 0x20b2cc21

    def to_dict(self):
        return {
            '_': 'SendMessageGeoLocationAction'
        }

    def __bytes__(self):
        return b''.join((
            b'\xa1\x8bo\x17',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SendMessageRecordAudioAction(TLObject):
    CONSTRUCTOR_ID = 0xd52f73f7
    SUBCLASS_OF_ID = 0x20b2cc21

    def to_dict(self):
        return {
            '_': 'SendMessageRecordAudioAction'
        }

    def __bytes__(self):
        return b''.join((
            b'\xf7s/\xd5',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SendMessageRecordRoundAction(TLObject):
    CONSTRUCTOR_ID = 0x88f27fbc
    SUBCLASS_OF_ID = 0x20b2cc21

    def to_dict(self):
        return {
            '_': 'SendMessageRecordRoundAction'
        }

    def __bytes__(self):
        return b''.join((
            b'\xbc\x7f\xf2\x88',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SendMessageRecordVideoAction(TLObject):
    CONSTRUCTOR_ID = 0xa187d66f
    SUBCLASS_OF_ID = 0x20b2cc21

    def to_dict(self):
        return {
            '_': 'SendMessageRecordVideoAction'
        }

    def __bytes__(self):
        return b''.join((
            b'o\xd6\x87\xa1',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SendMessageTypingAction(TLObject):
    CONSTRUCTOR_ID = 0x16bf744e
    SUBCLASS_OF_ID = 0x20b2cc21

    def to_dict(self):
        return {
            '_': 'SendMessageTypingAction'
        }

    def __bytes__(self):
        return b''.join((
            b'Nt\xbf\x16',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class SendMessageUploadAudioAction(TLObject):
    CONSTRUCTOR_ID = 0xf351d7ab
    SUBCLASS_OF_ID = 0x20b2cc21

    def __init__(self, progress: int):
        """
        Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction.
        """
        self.progress = progress

    def to_dict(self):
        return {
            '_': 'SendMessageUploadAudioAction',
            'progress': self.progress
        }

    def __bytes__(self):
        return b''.join((
            b'\xab\xd7Q\xf3',
            struct.pack('<i', self.progress),
        ))

    @classmethod
    def from_reader(cls, reader):
        _progress = reader.read_int()
        return cls(progress=_progress)


class SendMessageUploadDocumentAction(TLObject):
    CONSTRUCTOR_ID = 0xaa0cd9e4
    SUBCLASS_OF_ID = 0x20b2cc21

    def __init__(self, progress: int):
        """
        Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction.
        """
        self.progress = progress

    def to_dict(self):
        return {
            '_': 'SendMessageUploadDocumentAction',
            'progress': self.progress
        }

    def __bytes__(self):
        return b''.join((
            b'\xe4\xd9\x0c\xaa',
            struct.pack('<i', self.progress),
        ))

    @classmethod
    def from_reader(cls, reader):
        _progress = reader.read_int()
        return cls(progress=_progress)


class SendMessageUploadPhotoAction(TLObject):
    CONSTRUCTOR_ID = 0xd1d34a26
    SUBCLASS_OF_ID = 0x20b2cc21

    def __init__(self, progress: int):
        """
        Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction.
        """
        self.progress = progress

    def to_dict(self):
        return {
            '_': 'SendMessageUploadPhotoAction',
            'progress': self.progress
        }

    def __bytes__(self):
        return b''.join((
            b'&J\xd3\xd1',
            struct.pack('<i', self.progress),
        ))

    @classmethod
    def from_reader(cls, reader):
        _progress = reader.read_int()
        return cls(progress=_progress)


class SendMessageUploadRoundAction(TLObject):
    CONSTRUCTOR_ID = 0x243e1c66
    SUBCLASS_OF_ID = 0x20b2cc21

    def __init__(self, progress: int):
        """
        Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction.
        """
        self.progress = progress

    def to_dict(self):
        return {
            '_': 'SendMessageUploadRoundAction',
            'progress': self.progress
        }

    def __bytes__(self):
        return b''.join((
            b'f\x1c>$',
            struct.pack('<i', self.progress),
        ))

    @classmethod
    def from_reader(cls, reader):
        _progress = reader.read_int()
        return cls(progress=_progress)


class SendMessageUploadVideoAction(TLObject):
    CONSTRUCTOR_ID = 0xe9763aec
    SUBCLASS_OF_ID = 0x20b2cc21

    def __init__(self, progress: int):
        """
        Constructor for SendMessageAction: Instance of either SendMessageTypingAction, SendMessageCancelAction, SendMessageRecordVideoAction, SendMessageUploadVideoAction, SendMessageRecordAudioAction, SendMessageUploadAudioAction, SendMessageUploadPhotoAction, SendMessageUploadDocumentAction, SendMessageGeoLocationAction, SendMessageChooseContactAction, SendMessageGamePlayAction, SendMessageRecordRoundAction, SendMessageUploadRoundAction.
        """
        self.progress = progress

    def to_dict(self):
        return {
            '_': 'SendMessageUploadVideoAction',
            'progress': self.progress
        }

    def __bytes__(self):
        return b''.join((
            b'\xec:v\xe9',
            struct.pack('<i', self.progress),
        ))

    @classmethod
    def from_reader(cls, reader):
        _progress = reader.read_int()
        return cls(progress=_progress)


class ServerDHInnerData(TLObject):
    CONSTRUCTOR_ID = 0xb5890dba
    SUBCLASS_OF_ID = 0xc69a67bc

    def __init__(self, nonce: int, server_nonce: int, g: int, dh_prime: bytes, g_a: bytes, server_time: int):
        """
        Constructor for Server_DH_inner_data: Instance of ServerDHInnerData.
        """
        self.nonce = nonce
        self.server_nonce = server_nonce
        self.g = g
        self.dh_prime = dh_prime
        self.g_a = g_a
        self.server_time = server_time

    def to_dict(self):
        return {
            '_': 'ServerDHInnerData',
            'nonce': self.nonce,
            'server_nonce': self.server_nonce,
            'g': self.g,
            'dh_prime': self.dh_prime,
            'g_a': self.g_a,
            'server_time': self.server_time
        }

    def __bytes__(self):
        return b''.join((
            b'\xba\r\x89\xb5',
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            struct.pack('<i', self.g),
            self.serialize_bytes(self.dh_prime),
            self.serialize_bytes(self.g_a),
            struct.pack('<i', self.server_time),
        ))

    @classmethod
    def from_reader(cls, reader):
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _g = reader.read_int()
        _dh_prime = reader.tgread_bytes()
        _g_a = reader.tgread_bytes()
        _server_time = reader.read_int()
        return cls(nonce=_nonce, server_nonce=_server_nonce, g=_g, dh_prime=_dh_prime, g_a=_g_a, server_time=_server_time)


class ServerDHParamsFail(TLObject):
    CONSTRUCTOR_ID = 0x79cb045d
    SUBCLASS_OF_ID = 0xa6188d9e

    def __init__(self, nonce: int, server_nonce: int, new_nonce_hash: int):
        """
        Constructor for Server_DH_Params: Instance of either ServerDHParamsFail, ServerDHParamsOk.
        """
        self.nonce = nonce
        self.server_nonce = server_nonce
        self.new_nonce_hash = new_nonce_hash

    def to_dict(self):
        return {
            '_': 'ServerDHParamsFail',
            'nonce': self.nonce,
            'server_nonce': self.server_nonce,
            'new_nonce_hash': self.new_nonce_hash
        }

    def __bytes__(self):
        return b''.join((
            b']\x04\xcby',
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce_hash.to_bytes(16, 'little', signed=True),
        ))

    @classmethod
    def from_reader(cls, reader):
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce_hash = reader.read_large_int(bits=128)
        return cls(nonce=_nonce, server_nonce=_server_nonce, new_nonce_hash=_new_nonce_hash)


class ServerDHParamsOk(TLObject):
    CONSTRUCTOR_ID = 0xd0e8075c
    SUBCLASS_OF_ID = 0xa6188d9e

    def __init__(self, nonce: int, server_nonce: int, encrypted_answer: bytes):
        """
        Constructor for Server_DH_Params: Instance of either ServerDHParamsFail, ServerDHParamsOk.
        """
        self.nonce = nonce
        self.server_nonce = server_nonce
        self.encrypted_answer = encrypted_answer

    def to_dict(self):
        return {
            '_': 'ServerDHParamsOk',
            'nonce': self.nonce,
            'server_nonce': self.server_nonce,
            'encrypted_answer': self.encrypted_answer
        }

    def __bytes__(self):
        return b''.join((
            b'\\\x07\xe8\xd0',
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.serialize_bytes(self.encrypted_answer),
        ))

    @classmethod
    def from_reader(cls, reader):
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _encrypted_answer = reader.tgread_bytes()
        return cls(nonce=_nonce, server_nonce=_server_nonce, encrypted_answer=_encrypted_answer)


class ShippingOption(TLObject):
    CONSTRUCTOR_ID = 0xb6213cdf
    SUBCLASS_OF_ID = 0xf4e94c78

    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, title: str, prices: List['TypeLabeledPrice']):
        """
        Constructor for ShippingOption: Instance of ShippingOption.
        """
        self.id = id
        self.title = title
        self.prices = prices

    def to_dict(self):
        return {
            '_': 'ShippingOption',
            'id': self.id,
            'title': self.title,
            'prices': [] if self.prices is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.prices]
        }

    def __bytes__(self):
        return b''.join((
            b'\xdf<!\xb6',
            self.serialize_bytes(self.id),
            self.serialize_bytes(self.title),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.prices)),b''.join(bytes(x) for x in self.prices),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_string()
        _title = reader.tgread_string()
        reader.read_int()
        _prices = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _prices.append(_x)

        return cls(id=_id, title=_title, prices=_prices)


class StatsURL(TLObject):
    CONSTRUCTOR_ID = 0x47a971e0
    SUBCLASS_OF_ID = 0x8d4c94c0

    def __init__(self, url: str):
        """
        Constructor for StatsURL: Instance of StatsURL.
        """
        self.url = url

    def to_dict(self):
        return {
            '_': 'StatsURL',
            'url': self.url
        }

    def __bytes__(self):
        return b''.join((
            b'\xe0q\xa9G',
            self.serialize_bytes(self.url),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        return cls(url=_url)


class StickerPack(TLObject):
    CONSTRUCTOR_ID = 0x12b299d4
    SUBCLASS_OF_ID = 0x9fefa4d4

    def __init__(self, emoticon: str, documents: List[int]):
        """
        Constructor for StickerPack: Instance of StickerPack.
        """
        self.emoticon = emoticon
        self.documents = documents

    def to_dict(self):
        return {
            '_': 'StickerPack',
            'emoticon': self.emoticon,
            'documents': [] if self.documents is None else self.documents[:]
        }

    def __bytes__(self):
        return b''.join((
            b'\xd4\x99\xb2\x12',
            self.serialize_bytes(self.emoticon),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.documents)),b''.join(struct.pack('<q', x) for x in self.documents),
        ))

    @classmethod
    def from_reader(cls, reader):
        _emoticon = reader.tgread_string()
        reader.read_int()
        _documents = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _documents.append(_x)

        return cls(emoticon=_emoticon, documents=_documents)


class StickerSet(TLObject):
    CONSTRUCTOR_ID = 0xeeb46f27
    SUBCLASS_OF_ID = 0xbad3ff91

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, title: str, short_name: str, count: int, hash: int, archived: Optional[bool]=None, official: Optional[bool]=None, masks: Optional[bool]=None, animated: Optional[bool]=None, installed_date: Optional[datetime]=None, thumb: Optional['TypePhotoSize']=None, thumb_dc_id: Optional[int]=None):
        """
        Constructor for StickerSet: Instance of StickerSet.
        """
        self.id = id
        self.access_hash = access_hash
        self.title = title
        self.short_name = short_name
        self.count = count
        self.hash = hash
        self.archived = archived
        self.official = official
        self.masks = masks
        self.animated = animated
        self.installed_date = installed_date
        self.thumb = thumb
        self.thumb_dc_id = thumb_dc_id

    def to_dict(self):
        return {
            '_': 'StickerSet',
            'id': self.id,
            'access_hash': self.access_hash,
            'title': self.title,
            'short_name': self.short_name,
            'count': self.count,
            'hash': self.hash,
            'archived': self.archived,
            'official': self.official,
            'masks': self.masks,
            'animated': self.animated,
            'installed_date': self.installed_date,
            'thumb': self.thumb.to_dict() if isinstance(self.thumb, TLObject) else self.thumb,
            'thumb_dc_id': self.thumb_dc_id
        }

    def __bytes__(self):
        assert ((self.thumb or self.thumb is not None) and (self.thumb_dc_id or self.thumb_dc_id is not None)) or ((self.thumb is None or self.thumb is False) and (self.thumb_dc_id is None or self.thumb_dc_id is False)), 'thumb, thumb_dc_id parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b"'o\xb4\xee",
            struct.pack('<I', (0 if self.archived is None or self.archived is False else 2) | (0 if self.official is None or self.official is False else 4) | (0 if self.masks is None or self.masks is False else 8) | (0 if self.animated is None or self.animated is False else 32) | (0 if self.installed_date is None or self.installed_date is False else 1) | (0 if self.thumb is None or self.thumb is False else 16) | (0 if self.thumb_dc_id is None or self.thumb_dc_id is False else 16)),
            b'' if self.installed_date is None or self.installed_date is False else (self.serialize_datetime(self.installed_date)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.short_name),
            b'' if self.thumb is None or self.thumb is False else (bytes(self.thumb)),
            b'' if self.thumb_dc_id is None or self.thumb_dc_id is False else (struct.pack('<i', self.thumb_dc_id)),
            struct.pack('<i', self.count),
            struct.pack('<i', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _archived = bool(flags & 2)
        _official = bool(flags & 4)
        _masks = bool(flags & 8)
        _animated = bool(flags & 32)
        if flags & 1:
            _installed_date = reader.tgread_date()
        else:
            _installed_date = None
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _title = reader.tgread_string()
        _short_name = reader.tgread_string()
        if flags & 16:
            _thumb = reader.tgread_object()
        else:
            _thumb = None
        if flags & 16:
            _thumb_dc_id = reader.read_int()
        else:
            _thumb_dc_id = None
        _count = reader.read_int()
        _hash = reader.read_int()
        return cls(id=_id, access_hash=_access_hash, title=_title, short_name=_short_name, count=_count, hash=_hash, archived=_archived, official=_official, masks=_masks, animated=_animated, installed_date=_installed_date, thumb=_thumb, thumb_dc_id=_thumb_dc_id)


class StickerSetCovered(TLObject):
    CONSTRUCTOR_ID = 0x6410a5d2
    SUBCLASS_OF_ID = 0x7f86e4e5

    # noinspection PyShadowingBuiltins
    def __init__(self, set: 'TypeStickerSet', cover: 'TypeDocument'):
        """
        Constructor for StickerSetCovered: Instance of either StickerSetCovered, StickerSetMultiCovered.
        """
        self.set = set
        self.cover = cover

    def to_dict(self):
        return {
            '_': 'StickerSetCovered',
            'set': self.set.to_dict() if isinstance(self.set, TLObject) else self.set,
            'cover': self.cover.to_dict() if isinstance(self.cover, TLObject) else self.cover
        }

    def __bytes__(self):
        return b''.join((
            b'\xd2\xa5\x10d',
            bytes(self.set),
            bytes(self.cover),
        ))

    @classmethod
    def from_reader(cls, reader):
        _set = reader.tgread_object()
        _cover = reader.tgread_object()
        return cls(set=_set, cover=_cover)


class StickerSetMultiCovered(TLObject):
    CONSTRUCTOR_ID = 0x3407e51b
    SUBCLASS_OF_ID = 0x7f86e4e5

    # noinspection PyShadowingBuiltins
    def __init__(self, set: 'TypeStickerSet', covers: List['TypeDocument']):
        """
        Constructor for StickerSetCovered: Instance of either StickerSetCovered, StickerSetMultiCovered.
        """
        self.set = set
        self.covers = covers

    def to_dict(self):
        return {
            '_': 'StickerSetMultiCovered',
            'set': self.set.to_dict() if isinstance(self.set, TLObject) else self.set,
            'covers': [] if self.covers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.covers]
        }

    def __bytes__(self):
        return b''.join((
            b'\x1b\xe5\x074',
            bytes(self.set),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.covers)),b''.join(bytes(x) for x in self.covers),
        ))

    @classmethod
    def from_reader(cls, reader):
        _set = reader.tgread_object()
        reader.read_int()
        _covers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _covers.append(_x)

        return cls(set=_set, covers=_covers)


class TextAnchor(TLObject):
    CONSTRUCTOR_ID = 0x35553762
    SUBCLASS_OF_ID = 0xf1d0b479

    def __init__(self, text: 'TypeRichText', name: str):
        """
        Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
        """
        self.text = text
        self.name = name

    def to_dict(self):
        return {
            '_': 'TextAnchor',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text,
            'name': self.name
        }

    def __bytes__(self):
        return b''.join((
            b'b7U5',
            bytes(self.text),
            self.serialize_bytes(self.name),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        _name = reader.tgread_string()
        return cls(text=_text, name=_name)


class TextBold(TLObject):
    CONSTRUCTOR_ID = 0x6724abc4
    SUBCLASS_OF_ID = 0xf1d0b479

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'TextBold',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\xc4\xab$g',
            bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class TextConcat(TLObject):
    CONSTRUCTOR_ID = 0x7e6260d7
    SUBCLASS_OF_ID = 0xf1d0b479

    def __init__(self, texts: List['TypeRichText']):
        """
        Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
        """
        self.texts = texts

    def to_dict(self):
        return {
            '_': 'TextConcat',
            'texts': [] if self.texts is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.texts]
        }

    def __bytes__(self):
        return b''.join((
            b'\xd7`b~',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.texts)),b''.join(bytes(x) for x in self.texts),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _texts = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _texts.append(_x)

        return cls(texts=_texts)


class TextEmail(TLObject):
    CONSTRUCTOR_ID = 0xde5a0dd6
    SUBCLASS_OF_ID = 0xf1d0b479

    def __init__(self, text: 'TypeRichText', email: str):
        """
        Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
        """
        self.text = text
        self.email = email

    def to_dict(self):
        return {
            '_': 'TextEmail',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text,
            'email': self.email
        }

    def __bytes__(self):
        return b''.join((
            b'\xd6\rZ\xde',
            bytes(self.text),
            self.serialize_bytes(self.email),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        _email = reader.tgread_string()
        return cls(text=_text, email=_email)


class TextEmpty(TLObject):
    CONSTRUCTOR_ID = 0xdc3d824f
    SUBCLASS_OF_ID = 0xf1d0b479

    def to_dict(self):
        return {
            '_': 'TextEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'O\x82=\xdc',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class TextFixed(TLObject):
    CONSTRUCTOR_ID = 0x6c3f19b9
    SUBCLASS_OF_ID = 0xf1d0b479

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'TextFixed',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\xb9\x19?l',
            bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class TextImage(TLObject):
    CONSTRUCTOR_ID = 0x81ccf4f
    SUBCLASS_OF_ID = 0xf1d0b479

    def __init__(self, document_id: int, w: int, h: int):
        """
        Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
        """
        self.document_id = document_id
        self.w = w
        self.h = h

    def to_dict(self):
        return {
            '_': 'TextImage',
            'document_id': self.document_id,
            'w': self.w,
            'h': self.h
        }

    def __bytes__(self):
        return b''.join((
            b'O\xcf\x1c\x08',
            struct.pack('<q', self.document_id),
            struct.pack('<i', self.w),
            struct.pack('<i', self.h),
        ))

    @classmethod
    def from_reader(cls, reader):
        _document_id = reader.read_long()
        _w = reader.read_int()
        _h = reader.read_int()
        return cls(document_id=_document_id, w=_w, h=_h)


class TextItalic(TLObject):
    CONSTRUCTOR_ID = 0xd912a59c
    SUBCLASS_OF_ID = 0xf1d0b479

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'TextItalic',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\x9c\xa5\x12\xd9',
            bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class TextMarked(TLObject):
    CONSTRUCTOR_ID = 0x34b8621
    SUBCLASS_OF_ID = 0xf1d0b479

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'TextMarked',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def __bytes__(self):
        return b''.join((
            b'!\x86K\x03',
            bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class TextPhone(TLObject):
    CONSTRUCTOR_ID = 0x1ccb966a
    SUBCLASS_OF_ID = 0xf1d0b479

    def __init__(self, text: 'TypeRichText', phone: str):
        """
        Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
        """
        self.text = text
        self.phone = phone

    def to_dict(self):
        return {
            '_': 'TextPhone',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text,
            'phone': self.phone
        }

    def __bytes__(self):
        return b''.join((
            b'j\x96\xcb\x1c',
            bytes(self.text),
            self.serialize_bytes(self.phone),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        _phone = reader.tgread_string()
        return cls(text=_text, phone=_phone)


class TextPlain(TLObject):
    CONSTRUCTOR_ID = 0x744694e0
    SUBCLASS_OF_ID = 0xf1d0b479

    def __init__(self, text: str):
        """
        Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'TextPlain',
            'text': self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\xe0\x94Ft',
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        return cls(text=_text)


class TextStrike(TLObject):
    CONSTRUCTOR_ID = 0x9bf8bb95
    SUBCLASS_OF_ID = 0xf1d0b479

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'TextStrike',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\x95\xbb\xf8\x9b',
            bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class TextSubscript(TLObject):
    CONSTRUCTOR_ID = 0xed6a8504
    SUBCLASS_OF_ID = 0xf1d0b479

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'TextSubscript',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\x04\x85j\xed',
            bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class TextSuperscript(TLObject):
    CONSTRUCTOR_ID = 0xc7fb5e01
    SUBCLASS_OF_ID = 0xf1d0b479

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'TextSuperscript',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\x01^\xfb\xc7',
            bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class TextUnderline(TLObject):
    CONSTRUCTOR_ID = 0xc12622c4
    SUBCLASS_OF_ID = 0xf1d0b479

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'TextUnderline',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def __bytes__(self):
        return b''.join((
            b'\xc4"&\xc1',
            bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class TextUrl(TLObject):
    CONSTRUCTOR_ID = 0x3c2884c1
    SUBCLASS_OF_ID = 0xf1d0b479

    def __init__(self, text: 'TypeRichText', url: str, webpage_id: int):
        """
        Constructor for RichText: Instance of either TextEmpty, TextPlain, TextBold, TextItalic, TextUnderline, TextStrike, TextFixed, TextUrl, TextEmail, TextConcat, TextSubscript, TextSuperscript, TextMarked, TextPhone, TextImage, TextAnchor.
        """
        self.text = text
        self.url = url
        self.webpage_id = webpage_id

    def to_dict(self):
        return {
            '_': 'TextUrl',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text,
            'url': self.url,
            'webpage_id': self.webpage_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xc1\x84(<',
            bytes(self.text),
            self.serialize_bytes(self.url),
            struct.pack('<q', self.webpage_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        _url = reader.tgread_string()
        _webpage_id = reader.read_long()
        return cls(text=_text, url=_url, webpage_id=_webpage_id)


class Theme(TLObject):
    CONSTRUCTOR_ID = 0xf7d90ce0
    SUBCLASS_OF_ID = 0x56b4c80c

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, slug: str, title: str, installs_count: int, creator: Optional[bool]=None, default: Optional[bool]=None, document: Optional['TypeDocument']=None):
        """
        Constructor for Theme: Instance of either ThemeDocumentNotModified, Theme.
        """
        self.id = id
        self.access_hash = access_hash
        self.slug = slug
        self.title = title
        self.installs_count = installs_count
        self.creator = creator
        self.default = default
        self.document = document

    def to_dict(self):
        return {
            '_': 'Theme',
            'id': self.id,
            'access_hash': self.access_hash,
            'slug': self.slug,
            'title': self.title,
            'installs_count': self.installs_count,
            'creator': self.creator,
            'default': self.default,
            'document': self.document.to_dict() if isinstance(self.document, TLObject) else self.document
        }

    def __bytes__(self):
        return b''.join((
            b'\xe0\x0c\xd9\xf7',
            struct.pack('<I', (0 if self.creator is None or self.creator is False else 1) | (0 if self.default is None or self.default is False else 2) | (0 if self.document is None or self.document is False else 4)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_bytes(self.slug),
            self.serialize_bytes(self.title),
            b'' if self.document is None or self.document is False else (bytes(self.document)),
            struct.pack('<i', self.installs_count),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _creator = bool(flags & 1)
        _default = bool(flags & 2)
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _slug = reader.tgread_string()
        _title = reader.tgread_string()
        if flags & 4:
            _document = reader.tgread_object()
        else:
            _document = None
        _installs_count = reader.read_int()
        return cls(id=_id, access_hash=_access_hash, slug=_slug, title=_title, installs_count=_installs_count, creator=_creator, default=_default, document=_document)


class ThemeDocumentNotModified(TLObject):
    CONSTRUCTOR_ID = 0x483d270c
    SUBCLASS_OF_ID = 0x56b4c80c

    def to_dict(self):
        return {
            '_': 'ThemeDocumentNotModified'
        }

    def __bytes__(self):
        return b''.join((
            b"\x0c'=H",
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class TlsBlockDomain(TLObject):
    CONSTRUCTOR_ID = 0x10e8636f
    SUBCLASS_OF_ID = 0xf1163490

    def to_dict(self):
        return {
            '_': 'TlsBlockDomain'
        }

    def __bytes__(self):
        return b''.join((
            b'oc\xe8\x10',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class TlsBlockGrease(TLObject):
    CONSTRUCTOR_ID = 0xe675a1c1
    SUBCLASS_OF_ID = 0xf1163490

    def __init__(self, seed: int):
        """
        Constructor for TlsBlock: Instance of either TlsBlockString, TlsBlockRandom, TlsBlockZero, TlsBlockDomain, TlsBlockGrease, TlsBlockScope.
        """
        self.seed = seed

    def to_dict(self):
        return {
            '_': 'TlsBlockGrease',
            'seed': self.seed
        }

    def __bytes__(self):
        return b''.join((
            b'\xc1\xa1u\xe6',
            struct.pack('<i', self.seed),
        ))

    @classmethod
    def from_reader(cls, reader):
        _seed = reader.read_int()
        return cls(seed=_seed)


class TlsBlockRandom(TLObject):
    CONSTRUCTOR_ID = 0x4d4dc41e
    SUBCLASS_OF_ID = 0xf1163490

    def __init__(self, length: int):
        """
        Constructor for TlsBlock: Instance of either TlsBlockString, TlsBlockRandom, TlsBlockZero, TlsBlockDomain, TlsBlockGrease, TlsBlockScope.
        """
        self.length = length

    def to_dict(self):
        return {
            '_': 'TlsBlockRandom',
            'length': self.length
        }

    def __bytes__(self):
        return b''.join((
            b'\x1e\xc4MM',
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _length = reader.read_int()
        return cls(length=_length)


class TlsBlockScope(TLObject):
    CONSTRUCTOR_ID = 0xe725d44f
    SUBCLASS_OF_ID = 0xf1163490

    def __init__(self, entries: List['TypeTlsBlock']):
        """
        Constructor for TlsBlock: Instance of either TlsBlockString, TlsBlockRandom, TlsBlockZero, TlsBlockDomain, TlsBlockGrease, TlsBlockScope.
        """
        self.entries = entries

    def to_dict(self):
        return {
            '_': 'TlsBlockScope',
            'entries': [] if self.entries is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entries]
        }

    def __bytes__(self):
        return b''.join((
            b'O\xd4%\xe7',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entries)),b''.join(bytes(x) for x in self.entries),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _entries = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _entries.append(_x)

        return cls(entries=_entries)


class TlsBlockString(TLObject):
    CONSTRUCTOR_ID = 0x4218a164
    SUBCLASS_OF_ID = 0xf1163490

    def __init__(self, data: str):
        """
        Constructor for TlsBlock: Instance of either TlsBlockString, TlsBlockRandom, TlsBlockZero, TlsBlockDomain, TlsBlockGrease, TlsBlockScope.
        """
        self.data = data

    def to_dict(self):
        return {
            '_': 'TlsBlockString',
            'data': self.data
        }

    def __bytes__(self):
        return b''.join((
            b'd\xa1\x18B',
            self.serialize_bytes(self.data),
        ))

    @classmethod
    def from_reader(cls, reader):
        _data = reader.tgread_string()
        return cls(data=_data)


class TlsBlockZero(TLObject):
    CONSTRUCTOR_ID = 0x9333afb
    SUBCLASS_OF_ID = 0xf1163490

    def __init__(self, length: int):
        """
        Constructor for TlsBlock: Instance of either TlsBlockString, TlsBlockRandom, TlsBlockZero, TlsBlockDomain, TlsBlockGrease, TlsBlockScope.
        """
        self.length = length

    def to_dict(self):
        return {
            '_': 'TlsBlockZero',
            'length': self.length
        }

    def __bytes__(self):
        return b''.join((
            b'\xfb:3\t',
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _length = reader.read_int()
        return cls(length=_length)


class TlsClientHello(TLObject):
    CONSTRUCTOR_ID = 0x6c52c484
    SUBCLASS_OF_ID = 0xbef20920

    def __init__(self, blocks: List['TypeTlsBlock']):
        """
        Constructor for TlsClientHello: Instance of TlsClientHello.
        """
        self.blocks = blocks

    def to_dict(self):
        return {
            '_': 'TlsClientHello',
            'blocks': [] if self.blocks is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.blocks]
        }

    def __bytes__(self):
        return b''.join((
            b'\x84\xc4Rl',
            struct.pack('<i', len(self.blocks)),b''.join(bytes(x) for x in self.blocks),
        ))

    @classmethod
    def from_reader(cls, reader):
        _blocks = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _blocks.append(_x)

        return cls(blocks=_blocks)


class TopPeer(TLObject):
    CONSTRUCTOR_ID = 0xedcdc05b
    SUBCLASS_OF_ID = 0x6916c601

    def __init__(self, peer: 'TypePeer', rating: float):
        """
        Constructor for TopPeer: Instance of TopPeer.
        """
        self.peer = peer
        self.rating = rating

    def to_dict(self):
        return {
            '_': 'TopPeer',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'rating': self.rating
        }

    def __bytes__(self):
        return b''.join((
            b'[\xc0\xcd\xed',
            bytes(self.peer),
            struct.pack('<d', self.rating),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _rating = reader.read_double()
        return cls(peer=_peer, rating=_rating)


class TopPeerCategoryBotsInline(TLObject):
    CONSTRUCTOR_ID = 0x148677e2
    SUBCLASS_OF_ID = 0xddf02502

    def to_dict(self):
        return {
            '_': 'TopPeerCategoryBotsInline'
        }

    def __bytes__(self):
        return b''.join((
            b'\xe2w\x86\x14',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class TopPeerCategoryBotsPM(TLObject):
    CONSTRUCTOR_ID = 0xab661b5b
    SUBCLASS_OF_ID = 0xddf02502

    def to_dict(self):
        return {
            '_': 'TopPeerCategoryBotsPM'
        }

    def __bytes__(self):
        return b''.join((
            b'[\x1bf\xab',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class TopPeerCategoryChannels(TLObject):
    CONSTRUCTOR_ID = 0x161d9628
    SUBCLASS_OF_ID = 0xddf02502

    def to_dict(self):
        return {
            '_': 'TopPeerCategoryChannels'
        }

    def __bytes__(self):
        return b''.join((
            b'(\x96\x1d\x16',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class TopPeerCategoryCorrespondents(TLObject):
    CONSTRUCTOR_ID = 0x637b7ed
    SUBCLASS_OF_ID = 0xddf02502

    def to_dict(self):
        return {
            '_': 'TopPeerCategoryCorrespondents'
        }

    def __bytes__(self):
        return b''.join((
            b'\xed\xb77\x06',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class TopPeerCategoryForwardChats(TLObject):
    CONSTRUCTOR_ID = 0xfbeec0f0
    SUBCLASS_OF_ID = 0xddf02502

    def to_dict(self):
        return {
            '_': 'TopPeerCategoryForwardChats'
        }

    def __bytes__(self):
        return b''.join((
            b'\xf0\xc0\xee\xfb',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class TopPeerCategoryForwardUsers(TLObject):
    CONSTRUCTOR_ID = 0xa8406ca9
    SUBCLASS_OF_ID = 0xddf02502

    def to_dict(self):
        return {
            '_': 'TopPeerCategoryForwardUsers'
        }

    def __bytes__(self):
        return b''.join((
            b'\xa9l@\xa8',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class TopPeerCategoryGroups(TLObject):
    CONSTRUCTOR_ID = 0xbd17a14a
    SUBCLASS_OF_ID = 0xddf02502

    def to_dict(self):
        return {
            '_': 'TopPeerCategoryGroups'
        }

    def __bytes__(self):
        return b''.join((
            b'J\xa1\x17\xbd',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class TopPeerCategoryPeers(TLObject):
    CONSTRUCTOR_ID = 0xfb834291
    SUBCLASS_OF_ID = 0x4aec930

    def __init__(self, category: 'TypeTopPeerCategory', count: int, peers: List['TypeTopPeer']):
        """
        Constructor for TopPeerCategoryPeers: Instance of TopPeerCategoryPeers.
        """
        self.category = category
        self.count = count
        self.peers = peers

    def to_dict(self):
        return {
            '_': 'TopPeerCategoryPeers',
            'category': self.category.to_dict() if isinstance(self.category, TLObject) else self.category,
            'count': self.count,
            'peers': [] if self.peers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.peers]
        }

    def __bytes__(self):
        return b''.join((
            b'\x91B\x83\xfb',
            bytes(self.category),
            struct.pack('<i', self.count),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.peers)),b''.join(bytes(x) for x in self.peers),
        ))

    @classmethod
    def from_reader(cls, reader):
        _category = reader.tgread_object()
        _count = reader.read_int()
        reader.read_int()
        _peers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _peers.append(_x)

        return cls(category=_category, count=_count, peers=_peers)


class TopPeerCategoryPhoneCalls(TLObject):
    CONSTRUCTOR_ID = 0x1e76a78c
    SUBCLASS_OF_ID = 0xddf02502

    def to_dict(self):
        return {
            '_': 'TopPeerCategoryPhoneCalls'
        }

    def __bytes__(self):
        return b''.join((
            b'\x8c\xa7v\x1e',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class UpdateBotCallbackQuery(TLObject):
    CONSTRUCTOR_ID = 0xe73547e1
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, query_id: int, user_id: int, peer: 'TypePeer', msg_id: int, chat_instance: int, data: Optional[bytes]=None, game_short_name: Optional[str]=None):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.query_id = query_id
        self.user_id = user_id
        self.peer = peer
        self.msg_id = msg_id
        self.chat_instance = chat_instance
        self.data = data
        self.game_short_name = game_short_name

    def to_dict(self):
        return {
            '_': 'UpdateBotCallbackQuery',
            'query_id': self.query_id,
            'user_id': self.user_id,
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'msg_id': self.msg_id,
            'chat_instance': self.chat_instance,
            'data': self.data,
            'game_short_name': self.game_short_name
        }

    def __bytes__(self):
        return b''.join((
            b'\xe1G5\xe7',
            struct.pack('<I', (0 if self.data is None or self.data is False else 1) | (0 if self.game_short_name is None or self.game_short_name is False else 2)),
            struct.pack('<q', self.query_id),
            struct.pack('<i', self.user_id),
            bytes(self.peer),
            struct.pack('<i', self.msg_id),
            struct.pack('<q', self.chat_instance),
            b'' if self.data is None or self.data is False else (self.serialize_bytes(self.data)),
            b'' if self.game_short_name is None or self.game_short_name is False else (self.serialize_bytes(self.game_short_name)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _query_id = reader.read_long()
        _user_id = reader.read_int()
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        _chat_instance = reader.read_long()
        if flags & 1:
            _data = reader.tgread_bytes()
        else:
            _data = None
        if flags & 2:
            _game_short_name = reader.tgread_string()
        else:
            _game_short_name = None
        return cls(query_id=_query_id, user_id=_user_id, peer=_peer, msg_id=_msg_id, chat_instance=_chat_instance, data=_data, game_short_name=_game_short_name)


class UpdateBotInlineQuery(TLObject):
    CONSTRUCTOR_ID = 0x54826690
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, query_id: int, user_id: int, query: str, offset: str, geo: Optional['TypeGeoPoint']=None):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.query_id = query_id
        self.user_id = user_id
        self.query = query
        self.offset = offset
        self.geo = geo

    def to_dict(self):
        return {
            '_': 'UpdateBotInlineQuery',
            'query_id': self.query_id,
            'user_id': self.user_id,
            'query': self.query,
            'offset': self.offset,
            'geo': self.geo.to_dict() if isinstance(self.geo, TLObject) else self.geo
        }

    def __bytes__(self):
        return b''.join((
            b'\x90f\x82T',
            struct.pack('<I', (0 if self.geo is None or self.geo is False else 1)),
            struct.pack('<q', self.query_id),
            struct.pack('<i', self.user_id),
            self.serialize_bytes(self.query),
            b'' if self.geo is None or self.geo is False else (bytes(self.geo)),
            self.serialize_bytes(self.offset),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _query_id = reader.read_long()
        _user_id = reader.read_int()
        _query = reader.tgread_string()
        if flags & 1:
            _geo = reader.tgread_object()
        else:
            _geo = None
        _offset = reader.tgread_string()
        return cls(query_id=_query_id, user_id=_user_id, query=_query, offset=_offset, geo=_geo)


class UpdateBotInlineSend(TLObject):
    CONSTRUCTOR_ID = 0xe48f964
    SUBCLASS_OF_ID = 0x9f89304e

    # noinspection PyShadowingBuiltins
    def __init__(self, user_id: int, query: str, id: str, geo: Optional['TypeGeoPoint']=None, msg_id: Optional['TypeInputBotInlineMessageID']=None):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.user_id = user_id
        self.query = query
        self.id = id
        self.geo = geo
        self.msg_id = msg_id

    def to_dict(self):
        return {
            '_': 'UpdateBotInlineSend',
            'user_id': self.user_id,
            'query': self.query,
            'id': self.id,
            'geo': self.geo.to_dict() if isinstance(self.geo, TLObject) else self.geo,
            'msg_id': self.msg_id.to_dict() if isinstance(self.msg_id, TLObject) else self.msg_id
        }

    def __bytes__(self):
        return b''.join((
            b'd\xf9H\x0e',
            struct.pack('<I', (0 if self.geo is None or self.geo is False else 1) | (0 if self.msg_id is None or self.msg_id is False else 2)),
            struct.pack('<i', self.user_id),
            self.serialize_bytes(self.query),
            b'' if self.geo is None or self.geo is False else (bytes(self.geo)),
            self.serialize_bytes(self.id),
            b'' if self.msg_id is None or self.msg_id is False else (bytes(self.msg_id)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _user_id = reader.read_int()
        _query = reader.tgread_string()
        if flags & 1:
            _geo = reader.tgread_object()
        else:
            _geo = None
        _id = reader.tgread_string()
        if flags & 2:
            _msg_id = reader.tgread_object()
        else:
            _msg_id = None
        return cls(user_id=_user_id, query=_query, id=_id, geo=_geo, msg_id=_msg_id)


class UpdateBotPrecheckoutQuery(TLObject):
    CONSTRUCTOR_ID = 0x5d2f3aa9
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, query_id: int, user_id: int, payload: bytes, currency: str, total_amount: int, info: Optional['TypePaymentRequestedInfo']=None, shipping_option_id: Optional[str]=None):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.query_id = query_id
        self.user_id = user_id
        self.payload = payload
        self.currency = currency
        self.total_amount = total_amount
        self.info = info
        self.shipping_option_id = shipping_option_id

    def to_dict(self):
        return {
            '_': 'UpdateBotPrecheckoutQuery',
            'query_id': self.query_id,
            'user_id': self.user_id,
            'payload': self.payload,
            'currency': self.currency,
            'total_amount': self.total_amount,
            'info': self.info.to_dict() if isinstance(self.info, TLObject) else self.info,
            'shipping_option_id': self.shipping_option_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xa9:/]',
            struct.pack('<I', (0 if self.info is None or self.info is False else 1) | (0 if self.shipping_option_id is None or self.shipping_option_id is False else 2)),
            struct.pack('<q', self.query_id),
            struct.pack('<i', self.user_id),
            self.serialize_bytes(self.payload),
            b'' if self.info is None or self.info is False else (bytes(self.info)),
            b'' if self.shipping_option_id is None or self.shipping_option_id is False else (self.serialize_bytes(self.shipping_option_id)),
            self.serialize_bytes(self.currency),
            struct.pack('<q', self.total_amount),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _query_id = reader.read_long()
        _user_id = reader.read_int()
        _payload = reader.tgread_bytes()
        if flags & 1:
            _info = reader.tgread_object()
        else:
            _info = None
        if flags & 2:
            _shipping_option_id = reader.tgread_string()
        else:
            _shipping_option_id = None
        _currency = reader.tgread_string()
        _total_amount = reader.read_long()
        return cls(query_id=_query_id, user_id=_user_id, payload=_payload, currency=_currency, total_amount=_total_amount, info=_info, shipping_option_id=_shipping_option_id)


class UpdateBotShippingQuery(TLObject):
    CONSTRUCTOR_ID = 0xe0cdc940
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, query_id: int, user_id: int, payload: bytes, shipping_address: 'TypePostAddress'):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.query_id = query_id
        self.user_id = user_id
        self.payload = payload
        self.shipping_address = shipping_address

    def to_dict(self):
        return {
            '_': 'UpdateBotShippingQuery',
            'query_id': self.query_id,
            'user_id': self.user_id,
            'payload': self.payload,
            'shipping_address': self.shipping_address.to_dict() if isinstance(self.shipping_address, TLObject) else self.shipping_address
        }

    def __bytes__(self):
        return b''.join((
            b'@\xc9\xcd\xe0',
            struct.pack('<q', self.query_id),
            struct.pack('<i', self.user_id),
            self.serialize_bytes(self.payload),
            bytes(self.shipping_address),
        ))

    @classmethod
    def from_reader(cls, reader):
        _query_id = reader.read_long()
        _user_id = reader.read_int()
        _payload = reader.tgread_bytes()
        _shipping_address = reader.tgread_object()
        return cls(query_id=_query_id, user_id=_user_id, payload=_payload, shipping_address=_shipping_address)


class UpdateBotWebhookJSON(TLObject):
    CONSTRUCTOR_ID = 0x8317c0c3
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, data: 'TypeDataJSON'):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.data = data

    def to_dict(self):
        return {
            '_': 'UpdateBotWebhookJSON',
            'data': self.data.to_dict() if isinstance(self.data, TLObject) else self.data
        }

    def __bytes__(self):
        return b''.join((
            b'\xc3\xc0\x17\x83',
            bytes(self.data),
        ))

    @classmethod
    def from_reader(cls, reader):
        _data = reader.tgread_object()
        return cls(data=_data)


class UpdateBotWebhookJSONQuery(TLObject):
    CONSTRUCTOR_ID = 0x9b9240a6
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, query_id: int, data: 'TypeDataJSON', timeout: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.query_id = query_id
        self.data = data
        self.timeout = timeout

    def to_dict(self):
        return {
            '_': 'UpdateBotWebhookJSONQuery',
            'query_id': self.query_id,
            'data': self.data.to_dict() if isinstance(self.data, TLObject) else self.data,
            'timeout': self.timeout
        }

    def __bytes__(self):
        return b''.join((
            b'\xa6@\x92\x9b',
            struct.pack('<q', self.query_id),
            bytes(self.data),
            struct.pack('<i', self.timeout),
        ))

    @classmethod
    def from_reader(cls, reader):
        _query_id = reader.read_long()
        _data = reader.tgread_object()
        _timeout = reader.read_int()
        return cls(query_id=_query_id, data=_data, timeout=_timeout)


class UpdateChannel(TLObject):
    CONSTRUCTOR_ID = 0xb6d45656
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, channel_id: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.channel_id = channel_id

    def to_dict(self):
        return {
            '_': 'UpdateChannel',
            'channel_id': self.channel_id
        }

    def __bytes__(self):
        return b''.join((
            b'VV\xd4\xb6',
            struct.pack('<i', self.channel_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel_id = reader.read_int()
        return cls(channel_id=_channel_id)


class UpdateChannelAvailableMessages(TLObject):
    CONSTRUCTOR_ID = 0x70db6837
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, channel_id: int, available_min_id: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.channel_id = channel_id
        self.available_min_id = available_min_id

    def to_dict(self):
        return {
            '_': 'UpdateChannelAvailableMessages',
            'channel_id': self.channel_id,
            'available_min_id': self.available_min_id
        }

    def __bytes__(self):
        return b''.join((
            b'7h\xdbp',
            struct.pack('<i', self.channel_id),
            struct.pack('<i', self.available_min_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel_id = reader.read_int()
        _available_min_id = reader.read_int()
        return cls(channel_id=_channel_id, available_min_id=_available_min_id)


class UpdateChannelMessageViews(TLObject):
    CONSTRUCTOR_ID = 0x98a12b4b
    SUBCLASS_OF_ID = 0x9f89304e

    # noinspection PyShadowingBuiltins
    def __init__(self, channel_id: int, id: int, views: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.channel_id = channel_id
        self.id = id
        self.views = views

    def to_dict(self):
        return {
            '_': 'UpdateChannelMessageViews',
            'channel_id': self.channel_id,
            'id': self.id,
            'views': self.views
        }

    def __bytes__(self):
        return b''.join((
            b'K+\xa1\x98',
            struct.pack('<i', self.channel_id),
            struct.pack('<i', self.id),
            struct.pack('<i', self.views),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel_id = reader.read_int()
        _id = reader.read_int()
        _views = reader.read_int()
        return cls(channel_id=_channel_id, id=_id, views=_views)


class UpdateChannelPinnedMessage(TLObject):
    CONSTRUCTOR_ID = 0x98592475
    SUBCLASS_OF_ID = 0x9f89304e

    # noinspection PyShadowingBuiltins
    def __init__(self, channel_id: int, id: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.channel_id = channel_id
        self.id = id

    def to_dict(self):
        return {
            '_': 'UpdateChannelPinnedMessage',
            'channel_id': self.channel_id,
            'id': self.id
        }

    def __bytes__(self):
        return b''.join((
            b'u$Y\x98',
            struct.pack('<i', self.channel_id),
            struct.pack('<i', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel_id = reader.read_int()
        _id = reader.read_int()
        return cls(channel_id=_channel_id, id=_id)


class UpdateChannelReadMessagesContents(TLObject):
    CONSTRUCTOR_ID = 0x89893b45
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, channel_id: int, messages: List[int]):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.channel_id = channel_id
        self.messages = messages

    def to_dict(self):
        return {
            '_': 'UpdateChannelReadMessagesContents',
            'channel_id': self.channel_id,
            'messages': [] if self.messages is None else self.messages[:]
        }

    def __bytes__(self):
        return b''.join((
            b'E;\x89\x89',
            struct.pack('<i', self.channel_id),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(struct.pack('<i', x) for x in self.messages),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel_id = reader.read_int()
        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _messages.append(_x)

        return cls(channel_id=_channel_id, messages=_messages)


class UpdateChannelTooLong(TLObject):
    CONSTRUCTOR_ID = 0xeb0467fb
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, channel_id: int, pts: Optional[int]=None):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.channel_id = channel_id
        self.pts = pts

    def to_dict(self):
        return {
            '_': 'UpdateChannelTooLong',
            'channel_id': self.channel_id,
            'pts': self.pts
        }

    def __bytes__(self):
        return b''.join((
            b'\xfbg\x04\xeb',
            struct.pack('<I', (0 if self.pts is None or self.pts is False else 1)),
            struct.pack('<i', self.channel_id),
            b'' if self.pts is None or self.pts is False else (struct.pack('<i', self.pts)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _channel_id = reader.read_int()
        if flags & 1:
            _pts = reader.read_int()
        else:
            _pts = None
        return cls(channel_id=_channel_id, pts=_pts)


class UpdateChannelWebPage(TLObject):
    CONSTRUCTOR_ID = 0x40771900
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, channel_id: int, webpage: 'TypeWebPage', pts: int, pts_count: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.channel_id = channel_id
        self.webpage = webpage
        self.pts = pts
        self.pts_count = pts_count

    def to_dict(self):
        return {
            '_': 'UpdateChannelWebPage',
            'channel_id': self.channel_id,
            'webpage': self.webpage.to_dict() if isinstance(self.webpage, TLObject) else self.webpage,
            'pts': self.pts,
            'pts_count': self.pts_count
        }

    def __bytes__(self):
        return b''.join((
            b'\x00\x19w@',
            struct.pack('<i', self.channel_id),
            bytes(self.webpage),
            struct.pack('<i', self.pts),
            struct.pack('<i', self.pts_count),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel_id = reader.read_int()
        _webpage = reader.tgread_object()
        _pts = reader.read_int()
        _pts_count = reader.read_int()
        return cls(channel_id=_channel_id, webpage=_webpage, pts=_pts, pts_count=_pts_count)


class UpdateChatDefaultBannedRights(TLObject):
    CONSTRUCTOR_ID = 0x54c01850
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, peer: 'TypePeer', default_banned_rights: 'TypeChatBannedRights', version: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.peer = peer
        self.default_banned_rights = default_banned_rights
        self.version = version

    def to_dict(self):
        return {
            '_': 'UpdateChatDefaultBannedRights',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'default_banned_rights': self.default_banned_rights.to_dict() if isinstance(self.default_banned_rights, TLObject) else self.default_banned_rights,
            'version': self.version
        }

    def __bytes__(self):
        return b''.join((
            b'P\x18\xc0T',
            bytes(self.peer),
            bytes(self.default_banned_rights),
            struct.pack('<i', self.version),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _default_banned_rights = reader.tgread_object()
        _version = reader.read_int()
        return cls(peer=_peer, default_banned_rights=_default_banned_rights, version=_version)


class UpdateChatParticipantAdd(TLObject):
    CONSTRUCTOR_ID = 0xea4b0e5c
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, chat_id: int, user_id: int, inviter_id: int, date: Optional[datetime], version: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.chat_id = chat_id
        self.user_id = user_id
        self.inviter_id = inviter_id
        self.date = date
        self.version = version

    def to_dict(self):
        return {
            '_': 'UpdateChatParticipantAdd',
            'chat_id': self.chat_id,
            'user_id': self.user_id,
            'inviter_id': self.inviter_id,
            'date': self.date,
            'version': self.version
        }

    def __bytes__(self):
        return b''.join((
            b'\\\x0eK\xea',
            struct.pack('<i', self.chat_id),
            struct.pack('<i', self.user_id),
            struct.pack('<i', self.inviter_id),
            self.serialize_datetime(self.date),
            struct.pack('<i', self.version),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_int()
        _user_id = reader.read_int()
        _inviter_id = reader.read_int()
        _date = reader.tgread_date()
        _version = reader.read_int()
        return cls(chat_id=_chat_id, user_id=_user_id, inviter_id=_inviter_id, date=_date, version=_version)


class UpdateChatParticipantAdmin(TLObject):
    CONSTRUCTOR_ID = 0xb6901959
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, chat_id: int, user_id: int, is_admin: bool, version: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.chat_id = chat_id
        self.user_id = user_id
        self.is_admin = is_admin
        self.version = version

    def to_dict(self):
        return {
            '_': 'UpdateChatParticipantAdmin',
            'chat_id': self.chat_id,
            'user_id': self.user_id,
            'is_admin': self.is_admin,
            'version': self.version
        }

    def __bytes__(self):
        return b''.join((
            b'Y\x19\x90\xb6',
            struct.pack('<i', self.chat_id),
            struct.pack('<i', self.user_id),
            b'\xb5ur\x99' if self.is_admin else b'7\x97y\xbc',
            struct.pack('<i', self.version),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_int()
        _user_id = reader.read_int()
        _is_admin = reader.tgread_bool()
        _version = reader.read_int()
        return cls(chat_id=_chat_id, user_id=_user_id, is_admin=_is_admin, version=_version)


class UpdateChatParticipantDelete(TLObject):
    CONSTRUCTOR_ID = 0x6e5f8c22
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, chat_id: int, user_id: int, version: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.chat_id = chat_id
        self.user_id = user_id
        self.version = version

    def to_dict(self):
        return {
            '_': 'UpdateChatParticipantDelete',
            'chat_id': self.chat_id,
            'user_id': self.user_id,
            'version': self.version
        }

    def __bytes__(self):
        return b''.join((
            b'"\x8c_n',
            struct.pack('<i', self.chat_id),
            struct.pack('<i', self.user_id),
            struct.pack('<i', self.version),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_int()
        _user_id = reader.read_int()
        _version = reader.read_int()
        return cls(chat_id=_chat_id, user_id=_user_id, version=_version)


class UpdateChatParticipants(TLObject):
    CONSTRUCTOR_ID = 0x7761198
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, participants: 'TypeChatParticipants'):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.participants = participants

    def to_dict(self):
        return {
            '_': 'UpdateChatParticipants',
            'participants': self.participants.to_dict() if isinstance(self.participants, TLObject) else self.participants
        }

    def __bytes__(self):
        return b''.join((
            b'\x98\x11v\x07',
            bytes(self.participants),
        ))

    @classmethod
    def from_reader(cls, reader):
        _participants = reader.tgread_object()
        return cls(participants=_participants)


class UpdateChatPinnedMessage(TLObject):
    CONSTRUCTOR_ID = 0xe10db349
    SUBCLASS_OF_ID = 0x9f89304e

    # noinspection PyShadowingBuiltins
    def __init__(self, chat_id: int, id: int, version: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.chat_id = chat_id
        self.id = id
        self.version = version

    def to_dict(self):
        return {
            '_': 'UpdateChatPinnedMessage',
            'chat_id': self.chat_id,
            'id': self.id,
            'version': self.version
        }

    def __bytes__(self):
        return b''.join((
            b'I\xb3\r\xe1',
            struct.pack('<i', self.chat_id),
            struct.pack('<i', self.id),
            struct.pack('<i', self.version),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_int()
        _id = reader.read_int()
        _version = reader.read_int()
        return cls(chat_id=_chat_id, id=_id, version=_version)


class UpdateChatUserTyping(TLObject):
    CONSTRUCTOR_ID = 0x9a65ea1f
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, chat_id: int, user_id: int, action: 'TypeSendMessageAction'):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.chat_id = chat_id
        self.user_id = user_id
        self.action = action

    def to_dict(self):
        return {
            '_': 'UpdateChatUserTyping',
            'chat_id': self.chat_id,
            'user_id': self.user_id,
            'action': self.action.to_dict() if isinstance(self.action, TLObject) else self.action
        }

    def __bytes__(self):
        return b''.join((
            b'\x1f\xeae\x9a',
            struct.pack('<i', self.chat_id),
            struct.pack('<i', self.user_id),
            bytes(self.action),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_int()
        _user_id = reader.read_int()
        _action = reader.tgread_object()
        return cls(chat_id=_chat_id, user_id=_user_id, action=_action)


class UpdateConfig(TLObject):
    CONSTRUCTOR_ID = 0xa229dd06
    SUBCLASS_OF_ID = 0x9f89304e

    def to_dict(self):
        return {
            '_': 'UpdateConfig'
        }

    def __bytes__(self):
        return b''.join((
            b'\x06\xdd)\xa2',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class UpdateContactsReset(TLObject):
    CONSTRUCTOR_ID = 0x7084a7be
    SUBCLASS_OF_ID = 0x9f89304e

    def to_dict(self):
        return {
            '_': 'UpdateContactsReset'
        }

    def __bytes__(self):
        return b''.join((
            b'\xbe\xa7\x84p',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class UpdateDcOptions(TLObject):
    CONSTRUCTOR_ID = 0x8e5e9873
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, dc_options: List['TypeDcOption']):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.dc_options = dc_options

    def to_dict(self):
        return {
            '_': 'UpdateDcOptions',
            'dc_options': [] if self.dc_options is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.dc_options]
        }

    def __bytes__(self):
        return b''.join((
            b's\x98^\x8e',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.dc_options)),b''.join(bytes(x) for x in self.dc_options),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _dc_options = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _dc_options.append(_x)

        return cls(dc_options=_dc_options)


class UpdateDeleteChannelMessages(TLObject):
    CONSTRUCTOR_ID = 0xc37521c9
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, channel_id: int, messages: List[int], pts: int, pts_count: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.channel_id = channel_id
        self.messages = messages
        self.pts = pts
        self.pts_count = pts_count

    def to_dict(self):
        return {
            '_': 'UpdateDeleteChannelMessages',
            'channel_id': self.channel_id,
            'messages': [] if self.messages is None else self.messages[:],
            'pts': self.pts,
            'pts_count': self.pts_count
        }

    def __bytes__(self):
        return b''.join((
            b'\xc9!u\xc3',
            struct.pack('<i', self.channel_id),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(struct.pack('<i', x) for x in self.messages),
            struct.pack('<i', self.pts),
            struct.pack('<i', self.pts_count),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel_id = reader.read_int()
        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _messages.append(_x)

        _pts = reader.read_int()
        _pts_count = reader.read_int()
        return cls(channel_id=_channel_id, messages=_messages, pts=_pts, pts_count=_pts_count)


class UpdateDeleteMessages(TLObject):
    CONSTRUCTOR_ID = 0xa20db0e5
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, messages: List[int], pts: int, pts_count: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.messages = messages
        self.pts = pts
        self.pts_count = pts_count

    def to_dict(self):
        return {
            '_': 'UpdateDeleteMessages',
            'messages': [] if self.messages is None else self.messages[:],
            'pts': self.pts,
            'pts_count': self.pts_count
        }

    def __bytes__(self):
        return b''.join((
            b'\xe5\xb0\r\xa2',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(struct.pack('<i', x) for x in self.messages),
            struct.pack('<i', self.pts),
            struct.pack('<i', self.pts_count),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _messages.append(_x)

        _pts = reader.read_int()
        _pts_count = reader.read_int()
        return cls(messages=_messages, pts=_pts, pts_count=_pts_count)


class UpdateDeleteScheduledMessages(TLObject):
    CONSTRUCTOR_ID = 0x90866cee
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, peer: 'TypePeer', messages: List[int]):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.peer = peer
        self.messages = messages

    def to_dict(self):
        return {
            '_': 'UpdateDeleteScheduledMessages',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'messages': [] if self.messages is None else self.messages[:]
        }

    def __bytes__(self):
        return b''.join((
            b'\xeel\x86\x90',
            bytes(self.peer),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(struct.pack('<i', x) for x in self.messages),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _messages.append(_x)

        return cls(peer=_peer, messages=_messages)


class UpdateDialogPinned(TLObject):
    CONSTRUCTOR_ID = 0x6e6fe51c
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, peer: 'TypeDialogPeer', pinned: Optional[bool]=None, folder_id: Optional[int]=None):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.peer = peer
        self.pinned = pinned
        self.folder_id = folder_id

    def to_dict(self):
        return {
            '_': 'UpdateDialogPinned',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'pinned': self.pinned,
            'folder_id': self.folder_id
        }

    def __bytes__(self):
        return b''.join((
            b'\x1c\xe5on',
            struct.pack('<I', (0 if self.pinned is None or self.pinned is False else 1) | (0 if self.folder_id is None or self.folder_id is False else 2)),
            b'' if self.folder_id is None or self.folder_id is False else (struct.pack('<i', self.folder_id)),
            bytes(self.peer),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _pinned = bool(flags & 1)
        if flags & 2:
            _folder_id = reader.read_int()
        else:
            _folder_id = None
        _peer = reader.tgread_object()
        return cls(peer=_peer, pinned=_pinned, folder_id=_folder_id)


class UpdateDialogUnreadMark(TLObject):
    CONSTRUCTOR_ID = 0xe16459c3
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, peer: 'TypeDialogPeer', unread: Optional[bool]=None):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.peer = peer
        self.unread = unread

    def to_dict(self):
        return {
            '_': 'UpdateDialogUnreadMark',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'unread': self.unread
        }

    def __bytes__(self):
        return b''.join((
            b'\xc3Yd\xe1',
            struct.pack('<I', (0 if self.unread is None or self.unread is False else 1)),
            bytes(self.peer),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _unread = bool(flags & 1)
        _peer = reader.tgread_object()
        return cls(peer=_peer, unread=_unread)


class UpdateDraftMessage(TLObject):
    CONSTRUCTOR_ID = 0xee2bb969
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, peer: 'TypePeer', draft: 'TypeDraftMessage'):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.peer = peer
        self.draft = draft

    def to_dict(self):
        return {
            '_': 'UpdateDraftMessage',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'draft': self.draft.to_dict() if isinstance(self.draft, TLObject) else self.draft
        }

    def __bytes__(self):
        return b''.join((
            b'i\xb9+\xee',
            bytes(self.peer),
            bytes(self.draft),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _draft = reader.tgread_object()
        return cls(peer=_peer, draft=_draft)


class UpdateEditChannelMessage(TLObject):
    CONSTRUCTOR_ID = 0x1b3f4df7
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, message: 'TypeMessage', pts: int, pts_count: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.message = message
        self.pts = pts
        self.pts_count = pts_count

    def to_dict(self):
        return {
            '_': 'UpdateEditChannelMessage',
            'message': self.message.to_dict() if isinstance(self.message, TLObject) else self.message,
            'pts': self.pts,
            'pts_count': self.pts_count
        }

    def __bytes__(self):
        return b''.join((
            b'\xf7M?\x1b',
            bytes(self.message),
            struct.pack('<i', self.pts),
            struct.pack('<i', self.pts_count),
        ))

    @classmethod
    def from_reader(cls, reader):
        _message = reader.tgread_object()
        _pts = reader.read_int()
        _pts_count = reader.read_int()
        return cls(message=_message, pts=_pts, pts_count=_pts_count)


class UpdateEditMessage(TLObject):
    CONSTRUCTOR_ID = 0xe40370a3
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, message: 'TypeMessage', pts: int, pts_count: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.message = message
        self.pts = pts
        self.pts_count = pts_count

    def to_dict(self):
        return {
            '_': 'UpdateEditMessage',
            'message': self.message.to_dict() if isinstance(self.message, TLObject) else self.message,
            'pts': self.pts,
            'pts_count': self.pts_count
        }

    def __bytes__(self):
        return b''.join((
            b'\xa3p\x03\xe4',
            bytes(self.message),
            struct.pack('<i', self.pts),
            struct.pack('<i', self.pts_count),
        ))

    @classmethod
    def from_reader(cls, reader):
        _message = reader.tgread_object()
        _pts = reader.read_int()
        _pts_count = reader.read_int()
        return cls(message=_message, pts=_pts, pts_count=_pts_count)


class UpdateEncryptedChatTyping(TLObject):
    CONSTRUCTOR_ID = 0x1710f156
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, chat_id: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.chat_id = chat_id

    def to_dict(self):
        return {
            '_': 'UpdateEncryptedChatTyping',
            'chat_id': self.chat_id
        }

    def __bytes__(self):
        return b''.join((
            b'V\xf1\x10\x17',
            struct.pack('<i', self.chat_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_int()
        return cls(chat_id=_chat_id)


class UpdateEncryptedMessagesRead(TLObject):
    CONSTRUCTOR_ID = 0x38fe25b7
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, chat_id: int, max_date: Optional[datetime], date: Optional[datetime]):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.chat_id = chat_id
        self.max_date = max_date
        self.date = date

    def to_dict(self):
        return {
            '_': 'UpdateEncryptedMessagesRead',
            'chat_id': self.chat_id,
            'max_date': self.max_date,
            'date': self.date
        }

    def __bytes__(self):
        return b''.join((
            b'\xb7%\xfe8',
            struct.pack('<i', self.chat_id),
            self.serialize_datetime(self.max_date),
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_int()
        _max_date = reader.tgread_date()
        _date = reader.tgread_date()
        return cls(chat_id=_chat_id, max_date=_max_date, date=_date)


class UpdateEncryption(TLObject):
    CONSTRUCTOR_ID = 0xb4a2e88d
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, chat: 'TypeEncryptedChat', date: Optional[datetime]):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.chat = chat
        self.date = date

    def to_dict(self):
        return {
            '_': 'UpdateEncryption',
            'chat': self.chat.to_dict() if isinstance(self.chat, TLObject) else self.chat,
            'date': self.date
        }

    def __bytes__(self):
        return b''.join((
            b'\x8d\xe8\xa2\xb4',
            bytes(self.chat),
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat = reader.tgread_object()
        _date = reader.tgread_date()
        return cls(chat=_chat, date=_date)


class UpdateFavedStickers(TLObject):
    CONSTRUCTOR_ID = 0xe511996d
    SUBCLASS_OF_ID = 0x9f89304e

    def to_dict(self):
        return {
            '_': 'UpdateFavedStickers'
        }

    def __bytes__(self):
        return b''.join((
            b'm\x99\x11\xe5',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class UpdateFolderPeers(TLObject):
    CONSTRUCTOR_ID = 0x19360dc0
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, folder_peers: List['TypeFolderPeer'], pts: int, pts_count: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.folder_peers = folder_peers
        self.pts = pts
        self.pts_count = pts_count

    def to_dict(self):
        return {
            '_': 'UpdateFolderPeers',
            'folder_peers': [] if self.folder_peers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.folder_peers],
            'pts': self.pts,
            'pts_count': self.pts_count
        }

    def __bytes__(self):
        return b''.join((
            b'\xc0\r6\x19',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.folder_peers)),b''.join(bytes(x) for x in self.folder_peers),
            struct.pack('<i', self.pts),
            struct.pack('<i', self.pts_count),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _folder_peers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _folder_peers.append(_x)

        _pts = reader.read_int()
        _pts_count = reader.read_int()
        return cls(folder_peers=_folder_peers, pts=_pts, pts_count=_pts_count)


class UpdateInlineBotCallbackQuery(TLObject):
    CONSTRUCTOR_ID = 0xf9d27a5a
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, query_id: int, user_id: int, msg_id: 'TypeInputBotInlineMessageID', chat_instance: int, data: Optional[bytes]=None, game_short_name: Optional[str]=None):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.query_id = query_id
        self.user_id = user_id
        self.msg_id = msg_id
        self.chat_instance = chat_instance
        self.data = data
        self.game_short_name = game_short_name

    def to_dict(self):
        return {
            '_': 'UpdateInlineBotCallbackQuery',
            'query_id': self.query_id,
            'user_id': self.user_id,
            'msg_id': self.msg_id.to_dict() if isinstance(self.msg_id, TLObject) else self.msg_id,
            'chat_instance': self.chat_instance,
            'data': self.data,
            'game_short_name': self.game_short_name
        }

    def __bytes__(self):
        return b''.join((
            b'Zz\xd2\xf9',
            struct.pack('<I', (0 if self.data is None or self.data is False else 1) | (0 if self.game_short_name is None or self.game_short_name is False else 2)),
            struct.pack('<q', self.query_id),
            struct.pack('<i', self.user_id),
            bytes(self.msg_id),
            struct.pack('<q', self.chat_instance),
            b'' if self.data is None or self.data is False else (self.serialize_bytes(self.data)),
            b'' if self.game_short_name is None or self.game_short_name is False else (self.serialize_bytes(self.game_short_name)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _query_id = reader.read_long()
        _user_id = reader.read_int()
        _msg_id = reader.tgread_object()
        _chat_instance = reader.read_long()
        if flags & 1:
            _data = reader.tgread_bytes()
        else:
            _data = None
        if flags & 2:
            _game_short_name = reader.tgread_string()
        else:
            _game_short_name = None
        return cls(query_id=_query_id, user_id=_user_id, msg_id=_msg_id, chat_instance=_chat_instance, data=_data, game_short_name=_game_short_name)


class UpdateLangPack(TLObject):
    CONSTRUCTOR_ID = 0x56022f4d
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, difference: 'TypeLangPackDifference'):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.difference = difference

    def to_dict(self):
        return {
            '_': 'UpdateLangPack',
            'difference': self.difference.to_dict() if isinstance(self.difference, TLObject) else self.difference
        }

    def __bytes__(self):
        return b''.join((
            b'M/\x02V',
            bytes(self.difference),
        ))

    @classmethod
    def from_reader(cls, reader):
        _difference = reader.tgread_object()
        return cls(difference=_difference)


class UpdateLangPackTooLong(TLObject):
    CONSTRUCTOR_ID = 0x46560264
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, lang_code: str):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.lang_code = lang_code

    def to_dict(self):
        return {
            '_': 'UpdateLangPackTooLong',
            'lang_code': self.lang_code
        }

    def __bytes__(self):
        return b''.join((
            b'd\x02VF',
            self.serialize_bytes(self.lang_code),
        ))

    @classmethod
    def from_reader(cls, reader):
        _lang_code = reader.tgread_string()
        return cls(lang_code=_lang_code)


class UpdateMessageID(TLObject):
    CONSTRUCTOR_ID = 0x4e90bfd6
    SUBCLASS_OF_ID = 0x9f89304e

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, random_id: int=None):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.id = id
        self.random_id = random_id if random_id is not None else int.from_bytes(os.urandom(8), 'big', signed=True)

    def to_dict(self):
        return {
            '_': 'UpdateMessageID',
            'id': self.id,
            'random_id': self.random_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xd6\xbf\x90N',
            struct.pack('<i', self.id),
            struct.pack('<q', self.random_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_int()
        _random_id = reader.read_long()
        return cls(id=_id, random_id=_random_id)


class UpdateMessagePoll(TLObject):
    CONSTRUCTOR_ID = 0xaca1657b
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, poll_id: int, results: 'TypePollResults', poll: Optional['TypePoll']=None):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.poll_id = poll_id
        self.results = results
        self.poll = poll

    def to_dict(self):
        return {
            '_': 'UpdateMessagePoll',
            'poll_id': self.poll_id,
            'results': self.results.to_dict() if isinstance(self.results, TLObject) else self.results,
            'poll': self.poll.to_dict() if isinstance(self.poll, TLObject) else self.poll
        }

    def __bytes__(self):
        return b''.join((
            b'{e\xa1\xac',
            struct.pack('<I', (0 if self.poll is None or self.poll is False else 1)),
            struct.pack('<q', self.poll_id),
            b'' if self.poll is None or self.poll is False else (bytes(self.poll)),
            bytes(self.results),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _poll_id = reader.read_long()
        if flags & 1:
            _poll = reader.tgread_object()
        else:
            _poll = None
        _results = reader.tgread_object()
        return cls(poll_id=_poll_id, results=_results, poll=_poll)


class UpdateNewChannelMessage(TLObject):
    CONSTRUCTOR_ID = 0x62ba04d9
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, message: 'TypeMessage', pts: int, pts_count: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.message = message
        self.pts = pts
        self.pts_count = pts_count

    def to_dict(self):
        return {
            '_': 'UpdateNewChannelMessage',
            'message': self.message.to_dict() if isinstance(self.message, TLObject) else self.message,
            'pts': self.pts,
            'pts_count': self.pts_count
        }

    def __bytes__(self):
        return b''.join((
            b'\xd9\x04\xbab',
            bytes(self.message),
            struct.pack('<i', self.pts),
            struct.pack('<i', self.pts_count),
        ))

    @classmethod
    def from_reader(cls, reader):
        _message = reader.tgread_object()
        _pts = reader.read_int()
        _pts_count = reader.read_int()
        return cls(message=_message, pts=_pts, pts_count=_pts_count)


class UpdateNewEncryptedMessage(TLObject):
    CONSTRUCTOR_ID = 0x12bcbd9a
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, message: 'TypeEncryptedMessage', qts: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.message = message
        self.qts = qts

    def to_dict(self):
        return {
            '_': 'UpdateNewEncryptedMessage',
            'message': self.message.to_dict() if isinstance(self.message, TLObject) else self.message,
            'qts': self.qts
        }

    def __bytes__(self):
        return b''.join((
            b'\x9a\xbd\xbc\x12',
            bytes(self.message),
            struct.pack('<i', self.qts),
        ))

    @classmethod
    def from_reader(cls, reader):
        _message = reader.tgread_object()
        _qts = reader.read_int()
        return cls(message=_message, qts=_qts)


class UpdateNewMessage(TLObject):
    CONSTRUCTOR_ID = 0x1f2b0afd
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, message: 'TypeMessage', pts: int, pts_count: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.message = message
        self.pts = pts
        self.pts_count = pts_count

    def to_dict(self):
        return {
            '_': 'UpdateNewMessage',
            'message': self.message.to_dict() if isinstance(self.message, TLObject) else self.message,
            'pts': self.pts,
            'pts_count': self.pts_count
        }

    def __bytes__(self):
        return b''.join((
            b'\xfd\n+\x1f',
            bytes(self.message),
            struct.pack('<i', self.pts),
            struct.pack('<i', self.pts_count),
        ))

    @classmethod
    def from_reader(cls, reader):
        _message = reader.tgread_object()
        _pts = reader.read_int()
        _pts_count = reader.read_int()
        return cls(message=_message, pts=_pts, pts_count=_pts_count)


class UpdateNewScheduledMessage(TLObject):
    CONSTRUCTOR_ID = 0x39a51dfb
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, message: 'TypeMessage'):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.message = message

    def to_dict(self):
        return {
            '_': 'UpdateNewScheduledMessage',
            'message': self.message.to_dict() if isinstance(self.message, TLObject) else self.message
        }

    def __bytes__(self):
        return b''.join((
            b'\xfb\x1d\xa59',
            bytes(self.message),
        ))

    @classmethod
    def from_reader(cls, reader):
        _message = reader.tgread_object()
        return cls(message=_message)


class UpdateNewStickerSet(TLObject):
    CONSTRUCTOR_ID = 0x688a30aa
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, stickerset: 'TypeStickerSet'):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.stickerset = stickerset

    def to_dict(self):
        return {
            '_': 'UpdateNewStickerSet',
            'stickerset': self.stickerset.to_dict() if isinstance(self.stickerset, TLObject) else self.stickerset
        }

    def __bytes__(self):
        return b''.join((
            b'\xaa0\x8ah',
            bytes(self.stickerset),
        ))

    @classmethod
    def from_reader(cls, reader):
        _stickerset = reader.tgread_object()
        return cls(stickerset=_stickerset)


class UpdateNotifySettings(TLObject):
    CONSTRUCTOR_ID = 0xbec268ef
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, peer: 'TypeNotifyPeer', notify_settings: 'TypePeerNotifySettings'):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.peer = peer
        self.notify_settings = notify_settings

    def to_dict(self):
        return {
            '_': 'UpdateNotifySettings',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'notify_settings': self.notify_settings.to_dict() if isinstance(self.notify_settings, TLObject) else self.notify_settings
        }

    def __bytes__(self):
        return b''.join((
            b'\xefh\xc2\xbe',
            bytes(self.peer),
            bytes(self.notify_settings),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _notify_settings = reader.tgread_object()
        return cls(peer=_peer, notify_settings=_notify_settings)


class UpdatePeerLocated(TLObject):
    CONSTRUCTOR_ID = 0xb4afcfb0
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, peers: List['TypePeerLocated']):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.peers = peers

    def to_dict(self):
        return {
            '_': 'UpdatePeerLocated',
            'peers': [] if self.peers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.peers]
        }

    def __bytes__(self):
        return b''.join((
            b'\xb0\xcf\xaf\xb4',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.peers)),b''.join(bytes(x) for x in self.peers),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _peers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _peers.append(_x)

        return cls(peers=_peers)


class UpdatePeerSettings(TLObject):
    CONSTRUCTOR_ID = 0x6a7e7366
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, peer: 'TypePeer', settings: 'TypePeerSettings'):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.peer = peer
        self.settings = settings

    def to_dict(self):
        return {
            '_': 'UpdatePeerSettings',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'settings': self.settings.to_dict() if isinstance(self.settings, TLObject) else self.settings
        }

    def __bytes__(self):
        return b''.join((
            b'fs~j',
            bytes(self.peer),
            bytes(self.settings),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _settings = reader.tgread_object()
        return cls(peer=_peer, settings=_settings)


class UpdatePhoneCall(TLObject):
    CONSTRUCTOR_ID = 0xab0f6b1e
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, phone_call: 'TypePhoneCall'):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.phone_call = phone_call

    def to_dict(self):
        return {
            '_': 'UpdatePhoneCall',
            'phone_call': self.phone_call.to_dict() if isinstance(self.phone_call, TLObject) else self.phone_call
        }

    def __bytes__(self):
        return b''.join((
            b'\x1ek\x0f\xab',
            bytes(self.phone_call),
        ))

    @classmethod
    def from_reader(cls, reader):
        _phone_call = reader.tgread_object()
        return cls(phone_call=_phone_call)


class UpdatePinnedDialogs(TLObject):
    CONSTRUCTOR_ID = 0xfa0f3ca2
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, folder_id: Optional[int]=None, order: Optional[List['TypeDialogPeer']]=None):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.folder_id = folder_id
        self.order = order

    def to_dict(self):
        return {
            '_': 'UpdatePinnedDialogs',
            'folder_id': self.folder_id,
            'order': [] if self.order is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.order]
        }

    def __bytes__(self):
        return b''.join((
            b'\xa2<\x0f\xfa',
            struct.pack('<I', (0 if self.folder_id is None or self.folder_id is False else 2) | (0 if self.order is None or self.order is False else 1)),
            b'' if self.folder_id is None or self.folder_id is False else (struct.pack('<i', self.folder_id)),
            b'' if self.order is None or self.order is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.order)),b''.join(bytes(x) for x in self.order))),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 2:
            _folder_id = reader.read_int()
        else:
            _folder_id = None
        if flags & 1:
            reader.read_int()
            _order = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _order.append(_x)

        else:
            _order = None
        return cls(folder_id=_folder_id, order=_order)


class UpdatePrivacy(TLObject):
    CONSTRUCTOR_ID = 0xee3b272a
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, key: 'TypePrivacyKey', rules: List['TypePrivacyRule']):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.key = key
        self.rules = rules

    def to_dict(self):
        return {
            '_': 'UpdatePrivacy',
            'key': self.key.to_dict() if isinstance(self.key, TLObject) else self.key,
            'rules': [] if self.rules is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.rules]
        }

    def __bytes__(self):
        return b''.join((
            b"*';\xee",
            bytes(self.key),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.rules)),b''.join(bytes(x) for x in self.rules),
        ))

    @classmethod
    def from_reader(cls, reader):
        _key = reader.tgread_object()
        reader.read_int()
        _rules = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _rules.append(_x)

        return cls(key=_key, rules=_rules)


class UpdatePtsChanged(TLObject):
    CONSTRUCTOR_ID = 0x3354678f
    SUBCLASS_OF_ID = 0x9f89304e

    def to_dict(self):
        return {
            '_': 'UpdatePtsChanged'
        }

    def __bytes__(self):
        return b''.join((
            b'\x8fgT3',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class UpdateReadChannelInbox(TLObject):
    CONSTRUCTOR_ID = 0x330b5424
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, channel_id: int, max_id: int, still_unread_count: int, pts: int, folder_id: Optional[int]=None):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.channel_id = channel_id
        self.max_id = max_id
        self.still_unread_count = still_unread_count
        self.pts = pts
        self.folder_id = folder_id

    def to_dict(self):
        return {
            '_': 'UpdateReadChannelInbox',
            'channel_id': self.channel_id,
            'max_id': self.max_id,
            'still_unread_count': self.still_unread_count,
            'pts': self.pts,
            'folder_id': self.folder_id
        }

    def __bytes__(self):
        return b''.join((
            b'$T\x0b3',
            struct.pack('<I', (0 if self.folder_id is None or self.folder_id is False else 1)),
            b'' if self.folder_id is None or self.folder_id is False else (struct.pack('<i', self.folder_id)),
            struct.pack('<i', self.channel_id),
            struct.pack('<i', self.max_id),
            struct.pack('<i', self.still_unread_count),
            struct.pack('<i', self.pts),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _folder_id = reader.read_int()
        else:
            _folder_id = None
        _channel_id = reader.read_int()
        _max_id = reader.read_int()
        _still_unread_count = reader.read_int()
        _pts = reader.read_int()
        return cls(channel_id=_channel_id, max_id=_max_id, still_unread_count=_still_unread_count, pts=_pts, folder_id=_folder_id)


class UpdateReadChannelOutbox(TLObject):
    CONSTRUCTOR_ID = 0x25d6c9c7
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, channel_id: int, max_id: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.channel_id = channel_id
        self.max_id = max_id

    def to_dict(self):
        return {
            '_': 'UpdateReadChannelOutbox',
            'channel_id': self.channel_id,
            'max_id': self.max_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xc7\xc9\xd6%',
            struct.pack('<i', self.channel_id),
            struct.pack('<i', self.max_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel_id = reader.read_int()
        _max_id = reader.read_int()
        return cls(channel_id=_channel_id, max_id=_max_id)


class UpdateReadFeaturedStickers(TLObject):
    CONSTRUCTOR_ID = 0x571d2742
    SUBCLASS_OF_ID = 0x9f89304e

    def to_dict(self):
        return {
            '_': 'UpdateReadFeaturedStickers'
        }

    def __bytes__(self):
        return b''.join((
            b"B'\x1dW",
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class UpdateReadHistoryInbox(TLObject):
    CONSTRUCTOR_ID = 0x9c974fdf
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, peer: 'TypePeer', max_id: int, still_unread_count: int, pts: int, pts_count: int, folder_id: Optional[int]=None):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.peer = peer
        self.max_id = max_id
        self.still_unread_count = still_unread_count
        self.pts = pts
        self.pts_count = pts_count
        self.folder_id = folder_id

    def to_dict(self):
        return {
            '_': 'UpdateReadHistoryInbox',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'max_id': self.max_id,
            'still_unread_count': self.still_unread_count,
            'pts': self.pts,
            'pts_count': self.pts_count,
            'folder_id': self.folder_id
        }

    def __bytes__(self):
        return b''.join((
            b'\xdfO\x97\x9c',
            struct.pack('<I', (0 if self.folder_id is None or self.folder_id is False else 1)),
            b'' if self.folder_id is None or self.folder_id is False else (struct.pack('<i', self.folder_id)),
            bytes(self.peer),
            struct.pack('<i', self.max_id),
            struct.pack('<i', self.still_unread_count),
            struct.pack('<i', self.pts),
            struct.pack('<i', self.pts_count),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _folder_id = reader.read_int()
        else:
            _folder_id = None
        _peer = reader.tgread_object()
        _max_id = reader.read_int()
        _still_unread_count = reader.read_int()
        _pts = reader.read_int()
        _pts_count = reader.read_int()
        return cls(peer=_peer, max_id=_max_id, still_unread_count=_still_unread_count, pts=_pts, pts_count=_pts_count, folder_id=_folder_id)


class UpdateReadHistoryOutbox(TLObject):
    CONSTRUCTOR_ID = 0x2f2f21bf
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, peer: 'TypePeer', max_id: int, pts: int, pts_count: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.peer = peer
        self.max_id = max_id
        self.pts = pts
        self.pts_count = pts_count

    def to_dict(self):
        return {
            '_': 'UpdateReadHistoryOutbox',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'max_id': self.max_id,
            'pts': self.pts,
            'pts_count': self.pts_count
        }

    def __bytes__(self):
        return b''.join((
            b'\xbf!//',
            bytes(self.peer),
            struct.pack('<i', self.max_id),
            struct.pack('<i', self.pts),
            struct.pack('<i', self.pts_count),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _max_id = reader.read_int()
        _pts = reader.read_int()
        _pts_count = reader.read_int()
        return cls(peer=_peer, max_id=_max_id, pts=_pts, pts_count=_pts_count)


class UpdateReadMessagesContents(TLObject):
    CONSTRUCTOR_ID = 0x68c13933
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, messages: List[int], pts: int, pts_count: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.messages = messages
        self.pts = pts
        self.pts_count = pts_count

    def to_dict(self):
        return {
            '_': 'UpdateReadMessagesContents',
            'messages': [] if self.messages is None else self.messages[:],
            'pts': self.pts,
            'pts_count': self.pts_count
        }

    def __bytes__(self):
        return b''.join((
            b'39\xc1h',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.messages)),b''.join(struct.pack('<i', x) for x in self.messages),
            struct.pack('<i', self.pts),
            struct.pack('<i', self.pts_count),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _messages = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _messages.append(_x)

        _pts = reader.read_int()
        _pts_count = reader.read_int()
        return cls(messages=_messages, pts=_pts, pts_count=_pts_count)


class UpdateRecentStickers(TLObject):
    CONSTRUCTOR_ID = 0x9a422c20
    SUBCLASS_OF_ID = 0x9f89304e

    def to_dict(self):
        return {
            '_': 'UpdateRecentStickers'
        }

    def __bytes__(self):
        return b''.join((
            b' ,B\x9a',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class UpdateSavedGifs(TLObject):
    CONSTRUCTOR_ID = 0x9375341e
    SUBCLASS_OF_ID = 0x9f89304e

    def to_dict(self):
        return {
            '_': 'UpdateSavedGifs'
        }

    def __bytes__(self):
        return b''.join((
            b'\x1e4u\x93',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class UpdateServiceNotification(TLObject):
    CONSTRUCTOR_ID = 0xebe46819
    SUBCLASS_OF_ID = 0x9f89304e

    # noinspection PyShadowingBuiltins
    def __init__(self, type: str, message: str, media: 'TypeMessageMedia', entities: List['TypeMessageEntity'], popup: Optional[bool]=None, inbox_date: Optional[datetime]=None):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.type = type
        self.message = message
        self.media = media
        self.entities = entities
        self.popup = popup
        self.inbox_date = inbox_date

    def to_dict(self):
        return {
            '_': 'UpdateServiceNotification',
            'type': self.type,
            'message': self.message,
            'media': self.media.to_dict() if isinstance(self.media, TLObject) else self.media,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities],
            'popup': self.popup,
            'inbox_date': self.inbox_date
        }

    def __bytes__(self):
        return b''.join((
            b'\x19h\xe4\xeb',
            struct.pack('<I', (0 if self.popup is None or self.popup is False else 1) | (0 if self.inbox_date is None or self.inbox_date is False else 2)),
            b'' if self.inbox_date is None or self.inbox_date is False else (self.serialize_datetime(self.inbox_date)),
            self.serialize_bytes(self.type),
            self.serialize_bytes(self.message),
            bytes(self.media),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(bytes(x) for x in self.entities),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _popup = bool(flags & 1)
        if flags & 2:
            _inbox_date = reader.tgread_date()
        else:
            _inbox_date = None
        _type = reader.tgread_string()
        _message = reader.tgread_string()
        _media = reader.tgread_object()
        reader.read_int()
        _entities = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _entities.append(_x)

        return cls(type=_type, message=_message, media=_media, entities=_entities, popup=_popup, inbox_date=_inbox_date)


class UpdateShort(TLObject):
    CONSTRUCTOR_ID = 0x78d4dec1
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, update: 'TypeUpdate', date: Optional[datetime]):
        """
        Constructor for Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.update = update
        self.date = date

    def to_dict(self):
        return {
            '_': 'UpdateShort',
            'update': self.update.to_dict() if isinstance(self.update, TLObject) else self.update,
            'date': self.date
        }

    def __bytes__(self):
        return b''.join((
            b'\xc1\xde\xd4x',
            bytes(self.update),
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _update = reader.tgread_object()
        _date = reader.tgread_date()
        return cls(update=_update, date=_date)


class UpdateShortChatMessage(TLObject):
    CONSTRUCTOR_ID = 0x16812688
    SUBCLASS_OF_ID = 0x8af52aac

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, from_id: int, chat_id: int, message: str, pts: int, pts_count: int, date: Optional[datetime], out: Optional[bool]=None, mentioned: Optional[bool]=None, media_unread: Optional[bool]=None, silent: Optional[bool]=None, fwd_from: Optional['TypeMessageFwdHeader']=None, via_bot_id: Optional[int]=None, reply_to_msg_id: Optional[int]=None, entities: Optional[List['TypeMessageEntity']]=None):
        """
        Constructor for Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.id = id
        self.from_id = from_id
        self.chat_id = chat_id
        self.message = message
        self.pts = pts
        self.pts_count = pts_count
        self.date = date
        self.out = out
        self.mentioned = mentioned
        self.media_unread = media_unread
        self.silent = silent
        self.fwd_from = fwd_from
        self.via_bot_id = via_bot_id
        self.reply_to_msg_id = reply_to_msg_id
        self.entities = entities

    def to_dict(self):
        return {
            '_': 'UpdateShortChatMessage',
            'id': self.id,
            'from_id': self.from_id,
            'chat_id': self.chat_id,
            'message': self.message,
            'pts': self.pts,
            'pts_count': self.pts_count,
            'date': self.date,
            'out': self.out,
            'mentioned': self.mentioned,
            'media_unread': self.media_unread,
            'silent': self.silent,
            'fwd_from': self.fwd_from.to_dict() if isinstance(self.fwd_from, TLObject) else self.fwd_from,
            'via_bot_id': self.via_bot_id,
            'reply_to_msg_id': self.reply_to_msg_id,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities]
        }

    def __bytes__(self):
        return b''.join((
            b'\x88&\x81\x16',
            struct.pack('<I', (0 if self.out is None or self.out is False else 2) | (0 if self.mentioned is None or self.mentioned is False else 16) | (0 if self.media_unread is None or self.media_unread is False else 32) | (0 if self.silent is None or self.silent is False else 8192) | (0 if self.fwd_from is None or self.fwd_from is False else 4) | (0 if self.via_bot_id is None or self.via_bot_id is False else 2048) | (0 if self.reply_to_msg_id is None or self.reply_to_msg_id is False else 8) | (0 if self.entities is None or self.entities is False else 128)),
            struct.pack('<i', self.id),
            struct.pack('<i', self.from_id),
            struct.pack('<i', self.chat_id),
            self.serialize_bytes(self.message),
            struct.pack('<i', self.pts),
            struct.pack('<i', self.pts_count),
            self.serialize_datetime(self.date),
            b'' if self.fwd_from is None or self.fwd_from is False else (bytes(self.fwd_from)),
            b'' if self.via_bot_id is None or self.via_bot_id is False else (struct.pack('<i', self.via_bot_id)),
            b'' if self.reply_to_msg_id is None or self.reply_to_msg_id is False else (struct.pack('<i', self.reply_to_msg_id)),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(bytes(x) for x in self.entities))),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _out = bool(flags & 2)
        _mentioned = bool(flags & 16)
        _media_unread = bool(flags & 32)
        _silent = bool(flags & 8192)
        _id = reader.read_int()
        _from_id = reader.read_int()
        _chat_id = reader.read_int()
        _message = reader.tgread_string()
        _pts = reader.read_int()
        _pts_count = reader.read_int()
        _date = reader.tgread_date()
        if flags & 4:
            _fwd_from = reader.tgread_object()
        else:
            _fwd_from = None
        if flags & 2048:
            _via_bot_id = reader.read_int()
        else:
            _via_bot_id = None
        if flags & 8:
            _reply_to_msg_id = reader.read_int()
        else:
            _reply_to_msg_id = None
        if flags & 128:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        return cls(id=_id, from_id=_from_id, chat_id=_chat_id, message=_message, pts=_pts, pts_count=_pts_count, date=_date, out=_out, mentioned=_mentioned, media_unread=_media_unread, silent=_silent, fwd_from=_fwd_from, via_bot_id=_via_bot_id, reply_to_msg_id=_reply_to_msg_id, entities=_entities)


class UpdateShortMessage(TLObject):
    CONSTRUCTOR_ID = 0x914fbf11
    SUBCLASS_OF_ID = 0x8af52aac

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, user_id: int, message: str, pts: int, pts_count: int, date: Optional[datetime], out: Optional[bool]=None, mentioned: Optional[bool]=None, media_unread: Optional[bool]=None, silent: Optional[bool]=None, fwd_from: Optional['TypeMessageFwdHeader']=None, via_bot_id: Optional[int]=None, reply_to_msg_id: Optional[int]=None, entities: Optional[List['TypeMessageEntity']]=None):
        """
        Constructor for Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.id = id
        self.user_id = user_id
        self.message = message
        self.pts = pts
        self.pts_count = pts_count
        self.date = date
        self.out = out
        self.mentioned = mentioned
        self.media_unread = media_unread
        self.silent = silent
        self.fwd_from = fwd_from
        self.via_bot_id = via_bot_id
        self.reply_to_msg_id = reply_to_msg_id
        self.entities = entities

    def to_dict(self):
        return {
            '_': 'UpdateShortMessage',
            'id': self.id,
            'user_id': self.user_id,
            'message': self.message,
            'pts': self.pts,
            'pts_count': self.pts_count,
            'date': self.date,
            'out': self.out,
            'mentioned': self.mentioned,
            'media_unread': self.media_unread,
            'silent': self.silent,
            'fwd_from': self.fwd_from.to_dict() if isinstance(self.fwd_from, TLObject) else self.fwd_from,
            'via_bot_id': self.via_bot_id,
            'reply_to_msg_id': self.reply_to_msg_id,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities]
        }

    def __bytes__(self):
        return b''.join((
            b'\x11\xbfO\x91',
            struct.pack('<I', (0 if self.out is None or self.out is False else 2) | (0 if self.mentioned is None or self.mentioned is False else 16) | (0 if self.media_unread is None or self.media_unread is False else 32) | (0 if self.silent is None or self.silent is False else 8192) | (0 if self.fwd_from is None or self.fwd_from is False else 4) | (0 if self.via_bot_id is None or self.via_bot_id is False else 2048) | (0 if self.reply_to_msg_id is None or self.reply_to_msg_id is False else 8) | (0 if self.entities is None or self.entities is False else 128)),
            struct.pack('<i', self.id),
            struct.pack('<i', self.user_id),
            self.serialize_bytes(self.message),
            struct.pack('<i', self.pts),
            struct.pack('<i', self.pts_count),
            self.serialize_datetime(self.date),
            b'' if self.fwd_from is None or self.fwd_from is False else (bytes(self.fwd_from)),
            b'' if self.via_bot_id is None or self.via_bot_id is False else (struct.pack('<i', self.via_bot_id)),
            b'' if self.reply_to_msg_id is None or self.reply_to_msg_id is False else (struct.pack('<i', self.reply_to_msg_id)),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(bytes(x) for x in self.entities))),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _out = bool(flags & 2)
        _mentioned = bool(flags & 16)
        _media_unread = bool(flags & 32)
        _silent = bool(flags & 8192)
        _id = reader.read_int()
        _user_id = reader.read_int()
        _message = reader.tgread_string()
        _pts = reader.read_int()
        _pts_count = reader.read_int()
        _date = reader.tgread_date()
        if flags & 4:
            _fwd_from = reader.tgread_object()
        else:
            _fwd_from = None
        if flags & 2048:
            _via_bot_id = reader.read_int()
        else:
            _via_bot_id = None
        if flags & 8:
            _reply_to_msg_id = reader.read_int()
        else:
            _reply_to_msg_id = None
        if flags & 128:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        return cls(id=_id, user_id=_user_id, message=_message, pts=_pts, pts_count=_pts_count, date=_date, out=_out, mentioned=_mentioned, media_unread=_media_unread, silent=_silent, fwd_from=_fwd_from, via_bot_id=_via_bot_id, reply_to_msg_id=_reply_to_msg_id, entities=_entities)


class UpdateShortSentMessage(TLObject):
    CONSTRUCTOR_ID = 0x11f1331c
    SUBCLASS_OF_ID = 0x8af52aac

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, pts: int, pts_count: int, date: Optional[datetime], out: Optional[bool]=None, media: Optional['TypeMessageMedia']=None, entities: Optional[List['TypeMessageEntity']]=None):
        """
        Constructor for Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.id = id
        self.pts = pts
        self.pts_count = pts_count
        self.date = date
        self.out = out
        self.media = media
        self.entities = entities

    def to_dict(self):
        return {
            '_': 'UpdateShortSentMessage',
            'id': self.id,
            'pts': self.pts,
            'pts_count': self.pts_count,
            'date': self.date,
            'out': self.out,
            'media': self.media.to_dict() if isinstance(self.media, TLObject) else self.media,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities]
        }

    def __bytes__(self):
        return b''.join((
            b'\x1c3\xf1\x11',
            struct.pack('<I', (0 if self.out is None or self.out is False else 2) | (0 if self.media is None or self.media is False else 512) | (0 if self.entities is None or self.entities is False else 128)),
            struct.pack('<i', self.id),
            struct.pack('<i', self.pts),
            struct.pack('<i', self.pts_count),
            self.serialize_datetime(self.date),
            b'' if self.media is None or self.media is False else (bytes(self.media)),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(bytes(x) for x in self.entities))),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _out = bool(flags & 2)
        _id = reader.read_int()
        _pts = reader.read_int()
        _pts_count = reader.read_int()
        _date = reader.tgread_date()
        if flags & 512:
            _media = reader.tgread_object()
        else:
            _media = None
        if flags & 128:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        return cls(id=_id, pts=_pts, pts_count=_pts_count, date=_date, out=_out, media=_media, entities=_entities)


class UpdateStickerSets(TLObject):
    CONSTRUCTOR_ID = 0x43ae3dec
    SUBCLASS_OF_ID = 0x9f89304e

    def to_dict(self):
        return {
            '_': 'UpdateStickerSets'
        }

    def __bytes__(self):
        return b''.join((
            b'\xec=\xaeC',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class UpdateStickerSetsOrder(TLObject):
    CONSTRUCTOR_ID = 0xbb2d201
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, order: List[int], masks: Optional[bool]=None):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.order = order
        self.masks = masks

    def to_dict(self):
        return {
            '_': 'UpdateStickerSetsOrder',
            'order': [] if self.order is None else self.order[:],
            'masks': self.masks
        }

    def __bytes__(self):
        return b''.join((
            b'\x01\xd2\xb2\x0b',
            struct.pack('<I', (0 if self.masks is None or self.masks is False else 1)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.order)),b''.join(struct.pack('<q', x) for x in self.order),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _masks = bool(flags & 1)
        reader.read_int()
        _order = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _order.append(_x)

        return cls(order=_order, masks=_masks)


class UpdateTheme(TLObject):
    CONSTRUCTOR_ID = 0x8216fba3
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, theme: 'TypeTheme'):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.theme = theme

    def to_dict(self):
        return {
            '_': 'UpdateTheme',
            'theme': self.theme.to_dict() if isinstance(self.theme, TLObject) else self.theme
        }

    def __bytes__(self):
        return b''.join((
            b'\xa3\xfb\x16\x82',
            bytes(self.theme),
        ))

    @classmethod
    def from_reader(cls, reader):
        _theme = reader.tgread_object()
        return cls(theme=_theme)


class UpdateUserBlocked(TLObject):
    CONSTRUCTOR_ID = 0x80ece81a
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, user_id: int, blocked: bool):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.user_id = user_id
        self.blocked = blocked

    def to_dict(self):
        return {
            '_': 'UpdateUserBlocked',
            'user_id': self.user_id,
            'blocked': self.blocked
        }

    def __bytes__(self):
        return b''.join((
            b'\x1a\xe8\xec\x80',
            struct.pack('<i', self.user_id),
            b'\xb5ur\x99' if self.blocked else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        _blocked = reader.tgread_bool()
        return cls(user_id=_user_id, blocked=_blocked)


class UpdateUserName(TLObject):
    CONSTRUCTOR_ID = 0xa7332b73
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, user_id: int, first_name: str, last_name: str, username: str):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.user_id = user_id
        self.first_name = first_name
        self.last_name = last_name
        self.username = username

    def to_dict(self):
        return {
            '_': 'UpdateUserName',
            'user_id': self.user_id,
            'first_name': self.first_name,
            'last_name': self.last_name,
            'username': self.username
        }

    def __bytes__(self):
        return b''.join((
            b's+3\xa7',
            struct.pack('<i', self.user_id),
            self.serialize_bytes(self.first_name),
            self.serialize_bytes(self.last_name),
            self.serialize_bytes(self.username),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        _first_name = reader.tgread_string()
        _last_name = reader.tgread_string()
        _username = reader.tgread_string()
        return cls(user_id=_user_id, first_name=_first_name, last_name=_last_name, username=_username)


class UpdateUserPhone(TLObject):
    CONSTRUCTOR_ID = 0x12b9417b
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, user_id: int, phone: str):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.user_id = user_id
        self.phone = phone

    def to_dict(self):
        return {
            '_': 'UpdateUserPhone',
            'user_id': self.user_id,
            'phone': self.phone
        }

    def __bytes__(self):
        return b''.join((
            b'{A\xb9\x12',
            struct.pack('<i', self.user_id),
            self.serialize_bytes(self.phone),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        _phone = reader.tgread_string()
        return cls(user_id=_user_id, phone=_phone)


class UpdateUserPhoto(TLObject):
    CONSTRUCTOR_ID = 0x95313b0c
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, user_id: int, date: Optional[datetime], photo: 'TypeUserProfilePhoto', previous: bool):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.user_id = user_id
        self.date = date
        self.photo = photo
        self.previous = previous

    def to_dict(self):
        return {
            '_': 'UpdateUserPhoto',
            'user_id': self.user_id,
            'date': self.date,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'previous': self.previous
        }

    def __bytes__(self):
        return b''.join((
            b'\x0c;1\x95',
            struct.pack('<i', self.user_id),
            self.serialize_datetime(self.date),
            bytes(self.photo),
            b'\xb5ur\x99' if self.previous else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        _date = reader.tgread_date()
        _photo = reader.tgread_object()
        _previous = reader.tgread_bool()
        return cls(user_id=_user_id, date=_date, photo=_photo, previous=_previous)


class UpdateUserPinnedMessage(TLObject):
    CONSTRUCTOR_ID = 0x4c43da18
    SUBCLASS_OF_ID = 0x9f89304e

    # noinspection PyShadowingBuiltins
    def __init__(self, user_id: int, id: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.user_id = user_id
        self.id = id

    def to_dict(self):
        return {
            '_': 'UpdateUserPinnedMessage',
            'user_id': self.user_id,
            'id': self.id
        }

    def __bytes__(self):
        return b''.join((
            b'\x18\xdaCL',
            struct.pack('<i', self.user_id),
            struct.pack('<i', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        _id = reader.read_int()
        return cls(user_id=_user_id, id=_id)


class UpdateUserStatus(TLObject):
    CONSTRUCTOR_ID = 0x1bfbd823
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, user_id: int, status: 'TypeUserStatus'):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.user_id = user_id
        self.status = status

    def to_dict(self):
        return {
            '_': 'UpdateUserStatus',
            'user_id': self.user_id,
            'status': self.status.to_dict() if isinstance(self.status, TLObject) else self.status
        }

    def __bytes__(self):
        return b''.join((
            b'#\xd8\xfb\x1b',
            struct.pack('<i', self.user_id),
            bytes(self.status),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        _status = reader.tgread_object()
        return cls(user_id=_user_id, status=_status)


class UpdateUserTyping(TLObject):
    CONSTRUCTOR_ID = 0x5c486927
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, user_id: int, action: 'TypeSendMessageAction'):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.user_id = user_id
        self.action = action

    def to_dict(self):
        return {
            '_': 'UpdateUserTyping',
            'user_id': self.user_id,
            'action': self.action.to_dict() if isinstance(self.action, TLObject) else self.action
        }

    def __bytes__(self):
        return b''.join((
            b"'iH\\",
            struct.pack('<i', self.user_id),
            bytes(self.action),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_int()
        _action = reader.tgread_object()
        return cls(user_id=_user_id, action=_action)


class UpdateWebPage(TLObject):
    CONSTRUCTOR_ID = 0x7f891213
    SUBCLASS_OF_ID = 0x9f89304e

    def __init__(self, webpage: 'TypeWebPage', pts: int, pts_count: int):
        """
        Constructor for Update: Instance of either UpdateNewMessage, UpdateMessageID, UpdateDeleteMessages, UpdateUserTyping, UpdateChatUserTyping, UpdateChatParticipants, UpdateUserStatus, UpdateUserName, UpdateUserPhoto, UpdateNewEncryptedMessage, UpdateEncryptedChatTyping, UpdateEncryption, UpdateEncryptedMessagesRead, UpdateChatParticipantAdd, UpdateChatParticipantDelete, UpdateDcOptions, UpdateUserBlocked, UpdateNotifySettings, UpdateServiceNotification, UpdatePrivacy, UpdateUserPhone, UpdateReadHistoryInbox, UpdateReadHistoryOutbox, UpdateWebPage, UpdateReadMessagesContents, UpdateChannelTooLong, UpdateChannel, UpdateNewChannelMessage, UpdateReadChannelInbox, UpdateDeleteChannelMessages, UpdateChannelMessageViews, UpdateChatParticipantAdmin, UpdateNewStickerSet, UpdateStickerSetsOrder, UpdateStickerSets, UpdateSavedGifs, UpdateBotInlineQuery, UpdateBotInlineSend, UpdateEditChannelMessage, UpdateChannelPinnedMessage, UpdateBotCallbackQuery, UpdateEditMessage, UpdateInlineBotCallbackQuery, UpdateReadChannelOutbox, UpdateDraftMessage, UpdateReadFeaturedStickers, UpdateRecentStickers, UpdateConfig, UpdatePtsChanged, UpdateChannelWebPage, UpdateDialogPinned, UpdatePinnedDialogs, UpdateBotWebhookJSON, UpdateBotWebhookJSONQuery, UpdateBotShippingQuery, UpdateBotPrecheckoutQuery, UpdatePhoneCall, UpdateLangPackTooLong, UpdateLangPack, UpdateFavedStickers, UpdateChannelReadMessagesContents, UpdateContactsReset, UpdateChannelAvailableMessages, UpdateDialogUnreadMark, UpdateUserPinnedMessage, UpdateChatPinnedMessage, UpdateMessagePoll, UpdateChatDefaultBannedRights, UpdateFolderPeers, UpdatePeerSettings, UpdatePeerLocated, UpdateNewScheduledMessage, UpdateDeleteScheduledMessages, UpdateTheme.
        """
        self.webpage = webpage
        self.pts = pts
        self.pts_count = pts_count

    def to_dict(self):
        return {
            '_': 'UpdateWebPage',
            'webpage': self.webpage.to_dict() if isinstance(self.webpage, TLObject) else self.webpage,
            'pts': self.pts,
            'pts_count': self.pts_count
        }

    def __bytes__(self):
        return b''.join((
            b'\x13\x12\x89\x7f',
            bytes(self.webpage),
            struct.pack('<i', self.pts),
            struct.pack('<i', self.pts_count),
        ))

    @classmethod
    def from_reader(cls, reader):
        _webpage = reader.tgread_object()
        _pts = reader.read_int()
        _pts_count = reader.read_int()
        return cls(webpage=_webpage, pts=_pts, pts_count=_pts_count)


class Updates(TLObject):
    CONSTRUCTOR_ID = 0x74ae4240
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, updates: List['TypeUpdate'], users: List['TypeUser'], chats: List['TypeChat'], date: Optional[datetime], seq: int):
        """
        Constructor for Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.updates = updates
        self.users = users
        self.chats = chats
        self.date = date
        self.seq = seq

    def to_dict(self):
        return {
            '_': 'Updates',
            'updates': [] if self.updates is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.updates],
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users],
            'chats': [] if self.chats is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.chats],
            'date': self.date,
            'seq': self.seq
        }

    def __bytes__(self):
        return b''.join((
            b'@B\xaet',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.updates)),b''.join(bytes(x) for x in self.updates),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(bytes(x) for x in self.users),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(bytes(x) for x in self.chats),
            self.serialize_datetime(self.date),
            struct.pack('<i', self.seq),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _updates = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _updates.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        _date = reader.tgread_date()
        _seq = reader.read_int()
        return cls(updates=_updates, users=_users, chats=_chats, date=_date, seq=_seq)


class UpdatesCombined(TLObject):
    CONSTRUCTOR_ID = 0x725b04c3
    SUBCLASS_OF_ID = 0x8af52aac

    def __init__(self, updates: List['TypeUpdate'], users: List['TypeUser'], chats: List['TypeChat'], date: Optional[datetime], seq_start: int, seq: int):
        """
        Constructor for Updates: Instance of either UpdatesTooLong, UpdateShortMessage, UpdateShortChatMessage, UpdateShort, UpdatesCombined, Updates, UpdateShortSentMessage.
        """
        self.updates = updates
        self.users = users
        self.chats = chats
        self.date = date
        self.seq_start = seq_start
        self.seq = seq

    def to_dict(self):
        return {
            '_': 'UpdatesCombined',
            'updates': [] if self.updates is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.updates],
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users],
            'chats': [] if self.chats is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.chats],
            'date': self.date,
            'seq_start': self.seq_start,
            'seq': self.seq
        }

    def __bytes__(self):
        return b''.join((
            b'\xc3\x04[r',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.updates)),b''.join(bytes(x) for x in self.updates),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(bytes(x) for x in self.users),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(bytes(x) for x in self.chats),
            self.serialize_datetime(self.date),
            struct.pack('<i', self.seq_start),
            struct.pack('<i', self.seq),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _updates = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _updates.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _chats.append(_x)

        _date = reader.tgread_date()
        _seq_start = reader.read_int()
        _seq = reader.read_int()
        return cls(updates=_updates, users=_users, chats=_chats, date=_date, seq_start=_seq_start, seq=_seq)


class UpdatesTooLong(TLObject):
    CONSTRUCTOR_ID = 0xe317af7e
    SUBCLASS_OF_ID = 0x8af52aac

    def to_dict(self):
        return {
            '_': 'UpdatesTooLong'
        }

    def __bytes__(self):
        return b''.join((
            b'~\xaf\x17\xe3',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class UrlAuthResultAccepted(TLObject):
    CONSTRUCTOR_ID = 0x8f8c0e4e
    SUBCLASS_OF_ID = 0x7765cb1e

    def __init__(self, url: str):
        """
        Constructor for UrlAuthResult: Instance of either UrlAuthResultRequest, UrlAuthResultAccepted, UrlAuthResultDefault.
        """
        self.url = url

    def to_dict(self):
        return {
            '_': 'UrlAuthResultAccepted',
            'url': self.url
        }

    def __bytes__(self):
        return b''.join((
            b'N\x0e\x8c\x8f',
            self.serialize_bytes(self.url),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        return cls(url=_url)


class UrlAuthResultDefault(TLObject):
    CONSTRUCTOR_ID = 0xa9d6db1f
    SUBCLASS_OF_ID = 0x7765cb1e

    def to_dict(self):
        return {
            '_': 'UrlAuthResultDefault'
        }

    def __bytes__(self):
        return b''.join((
            b'\x1f\xdb\xd6\xa9',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class UrlAuthResultRequest(TLObject):
    CONSTRUCTOR_ID = 0x92d33a0e
    SUBCLASS_OF_ID = 0x7765cb1e

    def __init__(self, bot: 'TypeUser', domain: str, request_write_access: Optional[bool]=None):
        """
        Constructor for UrlAuthResult: Instance of either UrlAuthResultRequest, UrlAuthResultAccepted, UrlAuthResultDefault.
        """
        self.bot = bot
        self.domain = domain
        self.request_write_access = request_write_access

    def to_dict(self):
        return {
            '_': 'UrlAuthResultRequest',
            'bot': self.bot.to_dict() if isinstance(self.bot, TLObject) else self.bot,
            'domain': self.domain,
            'request_write_access': self.request_write_access
        }

    def __bytes__(self):
        return b''.join((
            b'\x0e:\xd3\x92',
            struct.pack('<I', (0 if self.request_write_access is None or self.request_write_access is False else 1)),
            bytes(self.bot),
            self.serialize_bytes(self.domain),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _request_write_access = bool(flags & 1)
        _bot = reader.tgread_object()
        _domain = reader.tgread_string()
        return cls(bot=_bot, domain=_domain, request_write_access=_request_write_access)


class User(TLObject):
    CONSTRUCTOR_ID = 0x938458c1
    SUBCLASS_OF_ID = 0x2da17977

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, is_self: Optional[bool]=None, contact: Optional[bool]=None, mutual_contact: Optional[bool]=None, deleted: Optional[bool]=None, bot: Optional[bool]=None, bot_chat_history: Optional[bool]=None, bot_nochats: Optional[bool]=None, verified: Optional[bool]=None, restricted: Optional[bool]=None, min: Optional[bool]=None, bot_inline_geo: Optional[bool]=None, support: Optional[bool]=None, scam: Optional[bool]=None, access_hash: Optional[int]=None, first_name: Optional[str]=None, last_name: Optional[str]=None, username: Optional[str]=None, phone: Optional[str]=None, photo: Optional['TypeUserProfilePhoto']=None, status: Optional['TypeUserStatus']=None, bot_info_version: Optional[int]=None, restriction_reason: Optional[List['TypeRestrictionReason']]=None, bot_inline_placeholder: Optional[str]=None, lang_code: Optional[str]=None):
        """
        Constructor for User: Instance of either UserEmpty, User.
        """
        self.id = id
        self.is_self = is_self
        self.contact = contact
        self.mutual_contact = mutual_contact
        self.deleted = deleted
        self.bot = bot
        self.bot_chat_history = bot_chat_history
        self.bot_nochats = bot_nochats
        self.verified = verified
        self.restricted = restricted
        self.min = min
        self.bot_inline_geo = bot_inline_geo
        self.support = support
        self.scam = scam
        self.access_hash = access_hash
        self.first_name = first_name
        self.last_name = last_name
        self.username = username
        self.phone = phone
        self.photo = photo
        self.status = status
        self.bot_info_version = bot_info_version
        self.restriction_reason = restriction_reason
        self.bot_inline_placeholder = bot_inline_placeholder
        self.lang_code = lang_code

    def to_dict(self):
        return {
            '_': 'User',
            'id': self.id,
            'is_self': self.is_self,
            'contact': self.contact,
            'mutual_contact': self.mutual_contact,
            'deleted': self.deleted,
            'bot': self.bot,
            'bot_chat_history': self.bot_chat_history,
            'bot_nochats': self.bot_nochats,
            'verified': self.verified,
            'restricted': self.restricted,
            'min': self.min,
            'bot_inline_geo': self.bot_inline_geo,
            'support': self.support,
            'scam': self.scam,
            'access_hash': self.access_hash,
            'first_name': self.first_name,
            'last_name': self.last_name,
            'username': self.username,
            'phone': self.phone,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'status': self.status.to_dict() if isinstance(self.status, TLObject) else self.status,
            'bot_info_version': self.bot_info_version,
            'restriction_reason': [] if self.restriction_reason is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.restriction_reason],
            'bot_inline_placeholder': self.bot_inline_placeholder,
            'lang_code': self.lang_code
        }

    def __bytes__(self):
        assert ((self.bot or self.bot is not None) and (self.bot_info_version or self.bot_info_version is not None)) or ((self.bot is None or self.bot is False) and (self.bot_info_version is None or self.bot_info_version is False)), 'bot, bot_info_version parameters must all be False-y (like None) or all me True-y'
        assert ((self.restricted or self.restricted is not None) and (self.restriction_reason or self.restriction_reason is not None)) or ((self.restricted is None or self.restricted is False) and (self.restriction_reason is None or self.restriction_reason is False)), 'restricted, restriction_reason parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xc1X\x84\x93',
            struct.pack('<I', (0 if self.is_self is None or self.is_self is False else 1024) | (0 if self.contact is None or self.contact is False else 2048) | (0 if self.mutual_contact is None or self.mutual_contact is False else 4096) | (0 if self.deleted is None or self.deleted is False else 8192) | (0 if self.bot is None or self.bot is False else 16384) | (0 if self.bot_chat_history is None or self.bot_chat_history is False else 32768) | (0 if self.bot_nochats is None or self.bot_nochats is False else 65536) | (0 if self.verified is None or self.verified is False else 131072) | (0 if self.restricted is None or self.restricted is False else 262144) | (0 if self.min is None or self.min is False else 1048576) | (0 if self.bot_inline_geo is None or self.bot_inline_geo is False else 2097152) | (0 if self.support is None or self.support is False else 8388608) | (0 if self.scam is None or self.scam is False else 16777216) | (0 if self.access_hash is None or self.access_hash is False else 1) | (0 if self.first_name is None or self.first_name is False else 2) | (0 if self.last_name is None or self.last_name is False else 4) | (0 if self.username is None or self.username is False else 8) | (0 if self.phone is None or self.phone is False else 16) | (0 if self.photo is None or self.photo is False else 32) | (0 if self.status is None or self.status is False else 64) | (0 if self.bot_info_version is None or self.bot_info_version is False else 16384) | (0 if self.restriction_reason is None or self.restriction_reason is False else 262144) | (0 if self.bot_inline_placeholder is None or self.bot_inline_placeholder is False else 524288) | (0 if self.lang_code is None or self.lang_code is False else 4194304)),
            struct.pack('<i', self.id),
            b'' if self.access_hash is None or self.access_hash is False else (struct.pack('<q', self.access_hash)),
            b'' if self.first_name is None or self.first_name is False else (self.serialize_bytes(self.first_name)),
            b'' if self.last_name is None or self.last_name is False else (self.serialize_bytes(self.last_name)),
            b'' if self.username is None or self.username is False else (self.serialize_bytes(self.username)),
            b'' if self.phone is None or self.phone is False else (self.serialize_bytes(self.phone)),
            b'' if self.photo is None or self.photo is False else (bytes(self.photo)),
            b'' if self.status is None or self.status is False else (bytes(self.status)),
            b'' if self.bot_info_version is None or self.bot_info_version is False else (struct.pack('<i', self.bot_info_version)),
            b'' if self.restriction_reason is None or self.restriction_reason is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.restriction_reason)),b''.join(bytes(x) for x in self.restriction_reason))),
            b'' if self.bot_inline_placeholder is None or self.bot_inline_placeholder is False else (self.serialize_bytes(self.bot_inline_placeholder)),
            b'' if self.lang_code is None or self.lang_code is False else (self.serialize_bytes(self.lang_code)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _is_self = bool(flags & 1024)
        _contact = bool(flags & 2048)
        _mutual_contact = bool(flags & 4096)
        _deleted = bool(flags & 8192)
        _bot = bool(flags & 16384)
        _bot_chat_history = bool(flags & 32768)
        _bot_nochats = bool(flags & 65536)
        _verified = bool(flags & 131072)
        _restricted = bool(flags & 262144)
        _min = bool(flags & 1048576)
        _bot_inline_geo = bool(flags & 2097152)
        _support = bool(flags & 8388608)
        _scam = bool(flags & 16777216)
        _id = reader.read_int()
        if flags & 1:
            _access_hash = reader.read_long()
        else:
            _access_hash = None
        if flags & 2:
            _first_name = reader.tgread_string()
        else:
            _first_name = None
        if flags & 4:
            _last_name = reader.tgread_string()
        else:
            _last_name = None
        if flags & 8:
            _username = reader.tgread_string()
        else:
            _username = None
        if flags & 16:
            _phone = reader.tgread_string()
        else:
            _phone = None
        if flags & 32:
            _photo = reader.tgread_object()
        else:
            _photo = None
        if flags & 64:
            _status = reader.tgread_object()
        else:
            _status = None
        if flags & 16384:
            _bot_info_version = reader.read_int()
        else:
            _bot_info_version = None
        if flags & 262144:
            reader.read_int()
            _restriction_reason = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _restriction_reason.append(_x)

        else:
            _restriction_reason = None
        if flags & 524288:
            _bot_inline_placeholder = reader.tgread_string()
        else:
            _bot_inline_placeholder = None
        if flags & 4194304:
            _lang_code = reader.tgread_string()
        else:
            _lang_code = None
        return cls(id=_id, is_self=_is_self, contact=_contact, mutual_contact=_mutual_contact, deleted=_deleted, bot=_bot, bot_chat_history=_bot_chat_history, bot_nochats=_bot_nochats, verified=_verified, restricted=_restricted, min=_min, bot_inline_geo=_bot_inline_geo, support=_support, scam=_scam, access_hash=_access_hash, first_name=_first_name, last_name=_last_name, username=_username, phone=_phone, photo=_photo, status=_status, bot_info_version=_bot_info_version, restriction_reason=_restriction_reason, bot_inline_placeholder=_bot_inline_placeholder, lang_code=_lang_code)


class UserEmpty(TLObject):
    CONSTRUCTOR_ID = 0x200250ba
    SUBCLASS_OF_ID = 0x2da17977

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        """
        Constructor for User: Instance of either UserEmpty, User.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'UserEmpty',
            'id': self.id
        }

    def __bytes__(self):
        return b''.join((
            b'\xbaP\x02 ',
            struct.pack('<i', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_int()
        return cls(id=_id)


class UserFull(TLObject):
    CONSTRUCTOR_ID = 0xedf17c12
    SUBCLASS_OF_ID = 0x1f4661b9

    def __init__(self, user: 'TypeUser', settings: 'TypePeerSettings', notify_settings: 'TypePeerNotifySettings', common_chats_count: int, blocked: Optional[bool]=None, phone_calls_available: Optional[bool]=None, phone_calls_private: Optional[bool]=None, can_pin_message: Optional[bool]=None, has_scheduled: Optional[bool]=None, about: Optional[str]=None, profile_photo: Optional['TypePhoto']=None, bot_info: Optional['TypeBotInfo']=None, pinned_msg_id: Optional[int]=None, folder_id: Optional[int]=None):
        """
        Constructor for UserFull: Instance of UserFull.
        """
        self.user = user
        self.settings = settings
        self.notify_settings = notify_settings
        self.common_chats_count = common_chats_count
        self.blocked = blocked
        self.phone_calls_available = phone_calls_available
        self.phone_calls_private = phone_calls_private
        self.can_pin_message = can_pin_message
        self.has_scheduled = has_scheduled
        self.about = about
        self.profile_photo = profile_photo
        self.bot_info = bot_info
        self.pinned_msg_id = pinned_msg_id
        self.folder_id = folder_id

    def to_dict(self):
        return {
            '_': 'UserFull',
            'user': self.user.to_dict() if isinstance(self.user, TLObject) else self.user,
            'settings': self.settings.to_dict() if isinstance(self.settings, TLObject) else self.settings,
            'notify_settings': self.notify_settings.to_dict() if isinstance(self.notify_settings, TLObject) else self.notify_settings,
            'common_chats_count': self.common_chats_count,
            'blocked': self.blocked,
            'phone_calls_available': self.phone_calls_available,
            'phone_calls_private': self.phone_calls_private,
            'can_pin_message': self.can_pin_message,
            'has_scheduled': self.has_scheduled,
            'about': self.about,
            'profile_photo': self.profile_photo.to_dict() if isinstance(self.profile_photo, TLObject) else self.profile_photo,
            'bot_info': self.bot_info.to_dict() if isinstance(self.bot_info, TLObject) else self.bot_info,
            'pinned_msg_id': self.pinned_msg_id,
            'folder_id': self.folder_id
        }

    def __bytes__(self):
        return b''.join((
            b'\x12|\xf1\xed',
            struct.pack('<I', (0 if self.blocked is None or self.blocked is False else 1) | (0 if self.phone_calls_available is None or self.phone_calls_available is False else 16) | (0 if self.phone_calls_private is None or self.phone_calls_private is False else 32) | (0 if self.can_pin_message is None or self.can_pin_message is False else 128) | (0 if self.has_scheduled is None or self.has_scheduled is False else 4096) | (0 if self.about is None or self.about is False else 2) | (0 if self.profile_photo is None or self.profile_photo is False else 4) | (0 if self.bot_info is None or self.bot_info is False else 8) | (0 if self.pinned_msg_id is None or self.pinned_msg_id is False else 64) | (0 if self.folder_id is None or self.folder_id is False else 2048)),
            bytes(self.user),
            b'' if self.about is None or self.about is False else (self.serialize_bytes(self.about)),
            bytes(self.settings),
            b'' if self.profile_photo is None or self.profile_photo is False else (bytes(self.profile_photo)),
            bytes(self.notify_settings),
            b'' if self.bot_info is None or self.bot_info is False else (bytes(self.bot_info)),
            b'' if self.pinned_msg_id is None or self.pinned_msg_id is False else (struct.pack('<i', self.pinned_msg_id)),
            struct.pack('<i', self.common_chats_count),
            b'' if self.folder_id is None or self.folder_id is False else (struct.pack('<i', self.folder_id)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _blocked = bool(flags & 1)
        _phone_calls_available = bool(flags & 16)
        _phone_calls_private = bool(flags & 32)
        _can_pin_message = bool(flags & 128)
        _has_scheduled = bool(flags & 4096)
        _user = reader.tgread_object()
        if flags & 2:
            _about = reader.tgread_string()
        else:
            _about = None
        _settings = reader.tgread_object()
        if flags & 4:
            _profile_photo = reader.tgread_object()
        else:
            _profile_photo = None
        _notify_settings = reader.tgread_object()
        if flags & 8:
            _bot_info = reader.tgread_object()
        else:
            _bot_info = None
        if flags & 64:
            _pinned_msg_id = reader.read_int()
        else:
            _pinned_msg_id = None
        _common_chats_count = reader.read_int()
        if flags & 2048:
            _folder_id = reader.read_int()
        else:
            _folder_id = None
        return cls(user=_user, settings=_settings, notify_settings=_notify_settings, common_chats_count=_common_chats_count, blocked=_blocked, phone_calls_available=_phone_calls_available, phone_calls_private=_phone_calls_private, can_pin_message=_can_pin_message, has_scheduled=_has_scheduled, about=_about, profile_photo=_profile_photo, bot_info=_bot_info, pinned_msg_id=_pinned_msg_id, folder_id=_folder_id)


class UserProfilePhoto(TLObject):
    CONSTRUCTOR_ID = 0xecd75d8c
    SUBCLASS_OF_ID = 0xc6338f7d

    def __init__(self, photo_id: int, photo_small: 'TypeFileLocation', photo_big: 'TypeFileLocation', dc_id: int):
        """
        Constructor for UserProfilePhoto: Instance of either UserProfilePhotoEmpty, UserProfilePhoto.
        """
        self.photo_id = photo_id
        self.photo_small = photo_small
        self.photo_big = photo_big
        self.dc_id = dc_id

    def to_dict(self):
        return {
            '_': 'UserProfilePhoto',
            'photo_id': self.photo_id,
            'photo_small': self.photo_small.to_dict() if isinstance(self.photo_small, TLObject) else self.photo_small,
            'photo_big': self.photo_big.to_dict() if isinstance(self.photo_big, TLObject) else self.photo_big,
            'dc_id': self.dc_id
        }

    def __bytes__(self):
        return b''.join((
            b'\x8c]\xd7\xec',
            struct.pack('<q', self.photo_id),
            bytes(self.photo_small),
            bytes(self.photo_big),
            struct.pack('<i', self.dc_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _photo_id = reader.read_long()
        _photo_small = reader.tgread_object()
        _photo_big = reader.tgread_object()
        _dc_id = reader.read_int()
        return cls(photo_id=_photo_id, photo_small=_photo_small, photo_big=_photo_big, dc_id=_dc_id)


class UserProfilePhotoEmpty(TLObject):
    CONSTRUCTOR_ID = 0x4f11bae1
    SUBCLASS_OF_ID = 0xc6338f7d

    def to_dict(self):
        return {
            '_': 'UserProfilePhotoEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'\xe1\xba\x11O',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class UserStatusEmpty(TLObject):
    CONSTRUCTOR_ID = 0x9d05049
    SUBCLASS_OF_ID = 0x5b0b743e

    def to_dict(self):
        return {
            '_': 'UserStatusEmpty'
        }

    def __bytes__(self):
        return b''.join((
            b'IP\xd0\t',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class UserStatusLastMonth(TLObject):
    CONSTRUCTOR_ID = 0x77ebc742
    SUBCLASS_OF_ID = 0x5b0b743e

    def to_dict(self):
        return {
            '_': 'UserStatusLastMonth'
        }

    def __bytes__(self):
        return b''.join((
            b'B\xc7\xebw',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class UserStatusLastWeek(TLObject):
    CONSTRUCTOR_ID = 0x7bf09fc
    SUBCLASS_OF_ID = 0x5b0b743e

    def to_dict(self):
        return {
            '_': 'UserStatusLastWeek'
        }

    def __bytes__(self):
        return b''.join((
            b'\xfc\t\xbf\x07',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class UserStatusOffline(TLObject):
    CONSTRUCTOR_ID = 0x8c703f
    SUBCLASS_OF_ID = 0x5b0b743e

    def __init__(self, was_online: Optional[datetime]):
        """
        Constructor for UserStatus: Instance of either UserStatusEmpty, UserStatusOnline, UserStatusOffline, UserStatusRecently, UserStatusLastWeek, UserStatusLastMonth.
        """
        self.was_online = was_online

    def to_dict(self):
        return {
            '_': 'UserStatusOffline',
            'was_online': self.was_online
        }

    def __bytes__(self):
        return b''.join((
            b'?p\x8c\x00',
            self.serialize_datetime(self.was_online),
        ))

    @classmethod
    def from_reader(cls, reader):
        _was_online = reader.tgread_date()
        return cls(was_online=_was_online)


class UserStatusOnline(TLObject):
    CONSTRUCTOR_ID = 0xedb93949
    SUBCLASS_OF_ID = 0x5b0b743e

    def __init__(self, expires: Optional[datetime]):
        """
        Constructor for UserStatus: Instance of either UserStatusEmpty, UserStatusOnline, UserStatusOffline, UserStatusRecently, UserStatusLastWeek, UserStatusLastMonth.
        """
        self.expires = expires

    def to_dict(self):
        return {
            '_': 'UserStatusOnline',
            'expires': self.expires
        }

    def __bytes__(self):
        return b''.join((
            b'I9\xb9\xed',
            self.serialize_datetime(self.expires),
        ))

    @classmethod
    def from_reader(cls, reader):
        _expires = reader.tgread_date()
        return cls(expires=_expires)


class UserStatusRecently(TLObject):
    CONSTRUCTOR_ID = 0xe26f42f1
    SUBCLASS_OF_ID = 0x5b0b743e

    def to_dict(self):
        return {
            '_': 'UserStatusRecently'
        }

    def __bytes__(self):
        return b''.join((
            b'\xf1Bo\xe2',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class WallPaper(TLObject):
    CONSTRUCTOR_ID = 0xa437c3ed
    SUBCLASS_OF_ID = 0x96a2c98b

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, slug: str, document: 'TypeDocument', creator: Optional[bool]=None, default: Optional[bool]=None, pattern: Optional[bool]=None, dark: Optional[bool]=None, settings: Optional['TypeWallPaperSettings']=None):
        """
        Constructor for WallPaper: Instance of WallPaper.
        """
        self.id = id
        self.access_hash = access_hash
        self.slug = slug
        self.document = document
        self.creator = creator
        self.default = default
        self.pattern = pattern
        self.dark = dark
        self.settings = settings

    def to_dict(self):
        return {
            '_': 'WallPaper',
            'id': self.id,
            'access_hash': self.access_hash,
            'slug': self.slug,
            'document': self.document.to_dict() if isinstance(self.document, TLObject) else self.document,
            'creator': self.creator,
            'default': self.default,
            'pattern': self.pattern,
            'dark': self.dark,
            'settings': self.settings.to_dict() if isinstance(self.settings, TLObject) else self.settings
        }

    def __bytes__(self):
        return b''.join((
            b'\xed\xc37\xa4',
            struct.pack('<q', self.id),
            struct.pack('<I', (0 if self.creator is None or self.creator is False else 1) | (0 if self.default is None or self.default is False else 2) | (0 if self.pattern is None or self.pattern is False else 8) | (0 if self.dark is None or self.dark is False else 16) | (0 if self.settings is None or self.settings is False else 4)),
            struct.pack('<q', self.access_hash),
            self.serialize_bytes(self.slug),
            bytes(self.document),
            b'' if self.settings is None or self.settings is False else (bytes(self.settings)),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        flags = reader.read_int()

        _creator = bool(flags & 1)
        _default = bool(flags & 2)
        _pattern = bool(flags & 8)
        _dark = bool(flags & 16)
        _access_hash = reader.read_long()
        _slug = reader.tgread_string()
        _document = reader.tgread_object()
        if flags & 4:
            _settings = reader.tgread_object()
        else:
            _settings = None
        return cls(id=_id, access_hash=_access_hash, slug=_slug, document=_document, creator=_creator, default=_default, pattern=_pattern, dark=_dark, settings=_settings)


class WallPaperSettings(TLObject):
    CONSTRUCTOR_ID = 0xa12f40b8
    SUBCLASS_OF_ID = 0x4175e312

    def __init__(self, blur: Optional[bool]=None, motion: Optional[bool]=None, background_color: Optional[int]=None, intensity: Optional[int]=None):
        """
        Constructor for WallPaperSettings: Instance of WallPaperSettings.
        """
        self.blur = blur
        self.motion = motion
        self.background_color = background_color
        self.intensity = intensity

    def to_dict(self):
        return {
            '_': 'WallPaperSettings',
            'blur': self.blur,
            'motion': self.motion,
            'background_color': self.background_color,
            'intensity': self.intensity
        }

    def __bytes__(self):
        return b''.join((
            b'\xb8@/\xa1',
            struct.pack('<I', (0 if self.blur is None or self.blur is False else 2) | (0 if self.motion is None or self.motion is False else 4) | (0 if self.background_color is None or self.background_color is False else 1) | (0 if self.intensity is None or self.intensity is False else 8)),
            b'' if self.background_color is None or self.background_color is False else (struct.pack('<i', self.background_color)),
            b'' if self.intensity is None or self.intensity is False else (struct.pack('<i', self.intensity)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _blur = bool(flags & 2)
        _motion = bool(flags & 4)
        if flags & 1:
            _background_color = reader.read_int()
        else:
            _background_color = None
        if flags & 8:
            _intensity = reader.read_int()
        else:
            _intensity = None
        return cls(blur=_blur, motion=_motion, background_color=_background_color, intensity=_intensity)


class WebAuthorization(TLObject):
    CONSTRUCTOR_ID = 0xcac943f2
    SUBCLASS_OF_ID = 0x3764d30

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, bot_id: int, domain: str, browser: str, platform: str, date_created: Optional[datetime], date_active: Optional[datetime], ip: str, region: str):
        """
        Constructor for WebAuthorization: Instance of WebAuthorization.
        """
        self.hash = hash
        self.bot_id = bot_id
        self.domain = domain
        self.browser = browser
        self.platform = platform
        self.date_created = date_created
        self.date_active = date_active
        self.ip = ip
        self.region = region

    def to_dict(self):
        return {
            '_': 'WebAuthorization',
            'hash': self.hash,
            'bot_id': self.bot_id,
            'domain': self.domain,
            'browser': self.browser,
            'platform': self.platform,
            'date_created': self.date_created,
            'date_active': self.date_active,
            'ip': self.ip,
            'region': self.region
        }

    def __bytes__(self):
        return b''.join((
            b'\xf2C\xc9\xca',
            struct.pack('<q', self.hash),
            struct.pack('<i', self.bot_id),
            self.serialize_bytes(self.domain),
            self.serialize_bytes(self.browser),
            self.serialize_bytes(self.platform),
            self.serialize_datetime(self.date_created),
            self.serialize_datetime(self.date_active),
            self.serialize_bytes(self.ip),
            self.serialize_bytes(self.region),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.read_long()
        _bot_id = reader.read_int()
        _domain = reader.tgread_string()
        _browser = reader.tgread_string()
        _platform = reader.tgread_string()
        _date_created = reader.tgread_date()
        _date_active = reader.tgread_date()
        _ip = reader.tgread_string()
        _region = reader.tgread_string()
        return cls(hash=_hash, bot_id=_bot_id, domain=_domain, browser=_browser, platform=_platform, date_created=_date_created, date_active=_date_active, ip=_ip, region=_region)


class WebDocument(TLObject):
    CONSTRUCTOR_ID = 0x1c570ed1
    SUBCLASS_OF_ID = 0x3b642814

    def __init__(self, url: str, access_hash: int, size: int, mime_type: str, attributes: List['TypeDocumentAttribute']):
        """
        Constructor for WebDocument: Instance of either WebDocument, WebDocumentNoProxy.
        """
        self.url = url
        self.access_hash = access_hash
        self.size = size
        self.mime_type = mime_type
        self.attributes = attributes

    def to_dict(self):
        return {
            '_': 'WebDocument',
            'url': self.url,
            'access_hash': self.access_hash,
            'size': self.size,
            'mime_type': self.mime_type,
            'attributes': [] if self.attributes is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.attributes]
        }

    def __bytes__(self):
        return b''.join((
            b'\xd1\x0eW\x1c',
            self.serialize_bytes(self.url),
            struct.pack('<q', self.access_hash),
            struct.pack('<i', self.size),
            self.serialize_bytes(self.mime_type),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.attributes)),b''.join(bytes(x) for x in self.attributes),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        _access_hash = reader.read_long()
        _size = reader.read_int()
        _mime_type = reader.tgread_string()
        reader.read_int()
        _attributes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _attributes.append(_x)

        return cls(url=_url, access_hash=_access_hash, size=_size, mime_type=_mime_type, attributes=_attributes)


class WebDocumentNoProxy(TLObject):
    CONSTRUCTOR_ID = 0xf9c8bcc6
    SUBCLASS_OF_ID = 0x3b642814

    def __init__(self, url: str, size: int, mime_type: str, attributes: List['TypeDocumentAttribute']):
        """
        Constructor for WebDocument: Instance of either WebDocument, WebDocumentNoProxy.
        """
        self.url = url
        self.size = size
        self.mime_type = mime_type
        self.attributes = attributes

    def to_dict(self):
        return {
            '_': 'WebDocumentNoProxy',
            'url': self.url,
            'size': self.size,
            'mime_type': self.mime_type,
            'attributes': [] if self.attributes is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.attributes]
        }

    def __bytes__(self):
        return b''.join((
            b'\xc6\xbc\xc8\xf9',
            self.serialize_bytes(self.url),
            struct.pack('<i', self.size),
            self.serialize_bytes(self.mime_type),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.attributes)),b''.join(bytes(x) for x in self.attributes),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        _size = reader.read_int()
        _mime_type = reader.tgread_string()
        reader.read_int()
        _attributes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _attributes.append(_x)

        return cls(url=_url, size=_size, mime_type=_mime_type, attributes=_attributes)


class WebPage(TLObject):
    CONSTRUCTOR_ID = 0xfa64e172
    SUBCLASS_OF_ID = 0x55a97481

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, url: str, display_url: str, hash: int, type: Optional[str]=None, site_name: Optional[str]=None, title: Optional[str]=None, description: Optional[str]=None, photo: Optional['TypePhoto']=None, embed_url: Optional[str]=None, embed_type: Optional[str]=None, embed_width: Optional[int]=None, embed_height: Optional[int]=None, duration: Optional[int]=None, author: Optional[str]=None, document: Optional['TypeDocument']=None, documents: Optional[List['TypeDocument']]=None, cached_page: Optional['TypePage']=None):
        """
        Constructor for WebPage: Instance of either WebPageEmpty, WebPagePending, WebPage, WebPageNotModified.
        """
        self.id = id
        self.url = url
        self.display_url = display_url
        self.hash = hash
        self.type = type
        self.site_name = site_name
        self.title = title
        self.description = description
        self.photo = photo
        self.embed_url = embed_url
        self.embed_type = embed_type
        self.embed_width = embed_width
        self.embed_height = embed_height
        self.duration = duration
        self.author = author
        self.document = document
        self.documents = documents
        self.cached_page = cached_page

    def to_dict(self):
        return {
            '_': 'WebPage',
            'id': self.id,
            'url': self.url,
            'display_url': self.display_url,
            'hash': self.hash,
            'type': self.type,
            'site_name': self.site_name,
            'title': self.title,
            'description': self.description,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'embed_url': self.embed_url,
            'embed_type': self.embed_type,
            'embed_width': self.embed_width,
            'embed_height': self.embed_height,
            'duration': self.duration,
            'author': self.author,
            'document': self.document.to_dict() if isinstance(self.document, TLObject) else self.document,
            'documents': [] if self.documents is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.documents],
            'cached_page': self.cached_page.to_dict() if isinstance(self.cached_page, TLObject) else self.cached_page
        }

    def __bytes__(self):
        assert ((self.embed_url or self.embed_url is not None) and (self.embed_type or self.embed_type is not None)) or ((self.embed_url is None or self.embed_url is False) and (self.embed_type is None or self.embed_type is False)), 'embed_url, embed_type parameters must all be False-y (like None) or all me True-y'
        assert ((self.embed_width or self.embed_width is not None) and (self.embed_height or self.embed_height is not None)) or ((self.embed_width is None or self.embed_width is False) and (self.embed_height is None or self.embed_height is False)), 'embed_width, embed_height parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'r\xe1d\xfa',
            struct.pack('<I', (0 if self.type is None or self.type is False else 1) | (0 if self.site_name is None or self.site_name is False else 2) | (0 if self.title is None or self.title is False else 4) | (0 if self.description is None or self.description is False else 8) | (0 if self.photo is None or self.photo is False else 16) | (0 if self.embed_url is None or self.embed_url is False else 32) | (0 if self.embed_type is None or self.embed_type is False else 32) | (0 if self.embed_width is None or self.embed_width is False else 64) | (0 if self.embed_height is None or self.embed_height is False else 64) | (0 if self.duration is None or self.duration is False else 128) | (0 if self.author is None or self.author is False else 256) | (0 if self.document is None or self.document is False else 512) | (0 if self.documents is None or self.documents is False else 2048) | (0 if self.cached_page is None or self.cached_page is False else 1024)),
            struct.pack('<q', self.id),
            self.serialize_bytes(self.url),
            self.serialize_bytes(self.display_url),
            struct.pack('<i', self.hash),
            b'' if self.type is None or self.type is False else (self.serialize_bytes(self.type)),
            b'' if self.site_name is None or self.site_name is False else (self.serialize_bytes(self.site_name)),
            b'' if self.title is None or self.title is False else (self.serialize_bytes(self.title)),
            b'' if self.description is None or self.description is False else (self.serialize_bytes(self.description)),
            b'' if self.photo is None or self.photo is False else (bytes(self.photo)),
            b'' if self.embed_url is None or self.embed_url is False else (self.serialize_bytes(self.embed_url)),
            b'' if self.embed_type is None or self.embed_type is False else (self.serialize_bytes(self.embed_type)),
            b'' if self.embed_width is None or self.embed_width is False else (struct.pack('<i', self.embed_width)),
            b'' if self.embed_height is None or self.embed_height is False else (struct.pack('<i', self.embed_height)),
            b'' if self.duration is None or self.duration is False else (struct.pack('<i', self.duration)),
            b'' if self.author is None or self.author is False else (self.serialize_bytes(self.author)),
            b'' if self.document is None or self.document is False else (bytes(self.document)),
            b'' if self.documents is None or self.documents is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.documents)),b''.join(bytes(x) for x in self.documents))),
            b'' if self.cached_page is None or self.cached_page is False else (bytes(self.cached_page)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.read_long()
        _url = reader.tgread_string()
        _display_url = reader.tgread_string()
        _hash = reader.read_int()
        if flags & 1:
            _type = reader.tgread_string()
        else:
            _type = None
        if flags & 2:
            _site_name = reader.tgread_string()
        else:
            _site_name = None
        if flags & 4:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 8:
            _description = reader.tgread_string()
        else:
            _description = None
        if flags & 16:
            _photo = reader.tgread_object()
        else:
            _photo = None
        if flags & 32:
            _embed_url = reader.tgread_string()
        else:
            _embed_url = None
        if flags & 32:
            _embed_type = reader.tgread_string()
        else:
            _embed_type = None
        if flags & 64:
            _embed_width = reader.read_int()
        else:
            _embed_width = None
        if flags & 64:
            _embed_height = reader.read_int()
        else:
            _embed_height = None
        if flags & 128:
            _duration = reader.read_int()
        else:
            _duration = None
        if flags & 256:
            _author = reader.tgread_string()
        else:
            _author = None
        if flags & 512:
            _document = reader.tgread_object()
        else:
            _document = None
        if flags & 2048:
            reader.read_int()
            _documents = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _documents.append(_x)

        else:
            _documents = None
        if flags & 1024:
            _cached_page = reader.tgread_object()
        else:
            _cached_page = None
        return cls(id=_id, url=_url, display_url=_display_url, hash=_hash, type=_type, site_name=_site_name, title=_title, description=_description, photo=_photo, embed_url=_embed_url, embed_type=_embed_type, embed_width=_embed_width, embed_height=_embed_height, duration=_duration, author=_author, document=_document, documents=_documents, cached_page=_cached_page)


class WebPageEmpty(TLObject):
    CONSTRUCTOR_ID = 0xeb1477e8
    SUBCLASS_OF_ID = 0x55a97481

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        """
        Constructor for WebPage: Instance of either WebPageEmpty, WebPagePending, WebPage, WebPageNotModified.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'WebPageEmpty',
            'id': self.id
        }

    def __bytes__(self):
        return b''.join((
            b'\xe8w\x14\xeb',
            struct.pack('<q', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        return cls(id=_id)


class WebPageNotModified(TLObject):
    CONSTRUCTOR_ID = 0x85849473
    SUBCLASS_OF_ID = 0x55a97481

    def to_dict(self):
        return {
            '_': 'WebPageNotModified'
        }

    def __bytes__(self):
        return b''.join((
            b's\x94\x84\x85',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class WebPagePending(TLObject):
    CONSTRUCTOR_ID = 0xc586da1c
    SUBCLASS_OF_ID = 0x55a97481

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, date: Optional[datetime]):
        """
        Constructor for WebPage: Instance of either WebPageEmpty, WebPagePending, WebPage, WebPageNotModified.
        """
        self.id = id
        self.date = date

    def to_dict(self):
        return {
            '_': 'WebPagePending',
            'id': self.id,
            'date': self.date
        }

    def __bytes__(self):
        return b''.join((
            b'\x1c\xda\x86\xc5',
            struct.pack('<q', self.id),
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _date = reader.tgread_date()
        return cls(id=_id, date=_date)

TypeAccessPointRule = AccessPointRule
TypeAccountDaysTTL = AccountDaysTTL
TypeAuthorization = Authorization
TypeAutoDownloadSettings = AutoDownloadSettings
TypeBadMsgNotification = Union[BadMsgNotification,BadServerSalt]
TypeBotCommand = BotCommand
TypeBotInfo = BotInfo
TypeBotInlineResult = Union[BotInlineResult,BotInlineMediaResult]
TypeBotInlineMessage = Union[BotInlineMessageMediaAuto,BotInlineMessageText,BotInlineMessageMediaGeo,BotInlineMessageMediaVenue,BotInlineMessageMediaContact]
TypeCdnConfig = CdnConfig
TypeCdnPublicKey = CdnPublicKey
TypeChat = Union[ChatEmpty,Chat,ChatForbidden,Channel,ChannelForbidden]
TypeChannelAdminLogEvent = ChannelAdminLogEvent
TypeChannelAdminLogEventAction = Union[ChannelAdminLogEventActionChangeTitle,ChannelAdminLogEventActionChangeAbout,ChannelAdminLogEventActionChangeUsername,ChannelAdminLogEventActionChangePhoto,ChannelAdminLogEventActionToggleInvites,ChannelAdminLogEventActionToggleSignatures,ChannelAdminLogEventActionUpdatePinned,ChannelAdminLogEventActionEditMessage,ChannelAdminLogEventActionDeleteMessage,ChannelAdminLogEventActionParticipantJoin,ChannelAdminLogEventActionParticipantLeave,ChannelAdminLogEventActionParticipantInvite,ChannelAdminLogEventActionParticipantToggleBan,ChannelAdminLogEventActionParticipantToggleAdmin,ChannelAdminLogEventActionChangeStickerSet,ChannelAdminLogEventActionTogglePreHistoryHidden,ChannelAdminLogEventActionDefaultBannedRights,ChannelAdminLogEventActionStopPoll,ChannelAdminLogEventActionChangeLinkedChat,ChannelAdminLogEventActionChangeLocation,ChannelAdminLogEventActionToggleSlowMode]
TypeChannelAdminLogEventsFilter = ChannelAdminLogEventsFilter
TypeChatFull = Union[ChatFull,ChannelFull]
TypeChannelLocation = Union[ChannelLocationEmpty,ChannelLocation]
TypeChannelMessagesFilter = Union[ChannelMessagesFilterEmpty,ChannelMessagesFilter]
TypeChannelParticipant = Union[ChannelParticipant,ChannelParticipantSelf,ChannelParticipantCreator,ChannelParticipantAdmin,ChannelParticipantBanned]
TypeChannelParticipantsFilter = Union[ChannelParticipantsRecent,ChannelParticipantsAdmins,ChannelParticipantsKicked,ChannelParticipantsBots,ChannelParticipantsBanned,ChannelParticipantsSearch,ChannelParticipantsContacts]
TypeChatAdminRights = ChatAdminRights
TypeChatBannedRights = ChatBannedRights
TypeChatInvite = Union[ChatInviteAlready,ChatInvite]
TypeExportedChatInvite = Union[ChatInviteEmpty,ChatInviteExported]
TypeChatOnlines = ChatOnlines
TypeChatParticipant = Union[ChatParticipant,ChatParticipantCreator,ChatParticipantAdmin]
TypeChatParticipants = Union[ChatParticipantsForbidden,ChatParticipants]
TypeChatPhoto = Union[ChatPhotoEmpty,ChatPhoto]
TypeClient_DH_Inner_Data = ClientDHInnerData
TypeCodeSettings = CodeSettings
TypeConfig = Config
TypeContact = Contact
TypeContactBlocked = ContactBlocked
TypeContactStatus = ContactStatus
TypeDataJSON = DataJSON
TypeDcOption = DcOption
TypeDestroyAuthKeyRes = Union[DestroyAuthKeyOk,DestroyAuthKeyNone,DestroyAuthKeyFail]
TypeDestroySessionRes = Union[DestroySessionOk,DestroySessionNone]
TypeSet_client_DH_params_answer = Union[DhGenOk,DhGenRetry,DhGenFail]
TypeDialog = Union[Dialog,DialogFolder]
TypeDialogPeer = Union[DialogPeer,DialogPeerFolder]
TypeDocument = Union[DocumentEmpty,Document]
TypeDocumentAttribute = Union[DocumentAttributeImageSize,DocumentAttributeAnimated,DocumentAttributeSticker,DocumentAttributeVideo,DocumentAttributeAudio,DocumentAttributeFilename,DocumentAttributeHasStickers]
TypeDraftMessage = Union[DraftMessageEmpty,DraftMessage]
TypeEmojiKeyword = Union[EmojiKeyword,EmojiKeywordDeleted]
TypeEmojiKeywordsDifference = EmojiKeywordsDifference
TypeEmojiLanguage = EmojiLanguage
TypeEmojiURL = EmojiURL
TypeEncryptedChat = Union[EncryptedChatEmpty,EncryptedChatWaiting,EncryptedChatRequested,EncryptedChat,EncryptedChatDiscarded]
TypeEncryptedFile = Union[EncryptedFileEmpty,EncryptedFile]
TypeEncryptedMessage = Union[EncryptedMessage,EncryptedMessageService]
TypeExportedMessageLink = ExportedMessageLink
TypeFileHash = FileHash
TypeFileLocation = FileLocationToBeDeprecated
TypeFolder = Folder
TypeFolderPeer = FolderPeer
TypeFoundGif = Union[FoundGif,FoundGifCached]
TypeFutureSalt = FutureSalt
TypeFutureSalts = FutureSalts
TypeGame = Game
TypeGeoPoint = Union[GeoPointEmpty,GeoPoint]
TypeHighScore = HighScore
TypeHttpWait = HttpWait
TypeImportedContact = ImportedContact
TypeInlineBotSwitchPM = InlineBotSwitchPM
TypeInputAppEvent = InputAppEvent
TypeInputBotInlineMessage = Union[InputBotInlineMessageMediaAuto,InputBotInlineMessageText,InputBotInlineMessageMediaGeo,InputBotInlineMessageMediaVenue,InputBotInlineMessageMediaContact,InputBotInlineMessageGame]
TypeInputBotInlineMessageID = InputBotInlineMessageID
TypeInputBotInlineResult = Union[InputBotInlineResult,InputBotInlineResultPhoto,InputBotInlineResultDocument,InputBotInlineResultGame]
TypeInputChannel = Union[InputChannelEmpty,InputChannel,InputChannelFromMessage]
TypeInputChatPhoto = Union[InputChatPhotoEmpty,InputChatUploadedPhoto,InputChatPhoto]
TypeInputCheckPasswordSRP = Union[InputCheckPasswordEmpty,InputCheckPasswordSRP]
TypeInputClientProxy = InputClientProxy
TypeInputDialogPeer = Union[InputDialogPeer,InputDialogPeerFolder]
TypeInputDocument = Union[InputDocumentEmpty,InputDocument]
TypeInputFileLocation = Union[InputFileLocation,InputEncryptedFileLocation,InputDocumentFileLocation,InputSecureFileLocation,InputTakeoutFileLocation,InputPhotoFileLocation,InputPeerPhotoFileLocation,InputStickerSetThumb]
TypeInputEncryptedChat = InputEncryptedChat
TypeInputEncryptedFile = Union[InputEncryptedFileEmpty,InputEncryptedFileUploaded,InputEncryptedFile,InputEncryptedFileBigUploaded]
TypeInputFile = Union[InputFile,InputFileBig]
TypeInputFolderPeer = InputFolderPeer
TypeInputGame = Union[InputGameID,InputGameShortName]
TypeInputGeoPoint = Union[InputGeoPointEmpty,InputGeoPoint]
TypeKeyboardButton = Union[KeyboardButton,KeyboardButtonUrl,KeyboardButtonCallback,KeyboardButtonRequestPhone,KeyboardButtonRequestGeoLocation,KeyboardButtonSwitchInline,KeyboardButtonGame,KeyboardButtonBuy,KeyboardButtonUrlAuth,InputKeyboardButtonUrlAuth]
TypeInputMedia = Union[InputMediaEmpty,InputMediaUploadedPhoto,InputMediaPhoto,InputMediaGeoPoint,InputMediaContact,InputMediaUploadedDocument,InputMediaDocument,InputMediaVenue,InputMediaGifExternal,InputMediaPhotoExternal,InputMediaDocumentExternal,InputMediaGame,InputMediaInvoice,InputMediaGeoLive,InputMediaPoll]
TypeMessageEntity = Union[MessageEntityUnknown,MessageEntityMention,MessageEntityHashtag,MessageEntityBotCommand,MessageEntityUrl,MessageEntityEmail,MessageEntityBold,MessageEntityItalic,MessageEntityCode,MessageEntityPre,MessageEntityTextUrl,MessageEntityMentionName,InputMessageEntityMentionName,MessageEntityPhone,MessageEntityCashtag,MessageEntityUnderline,MessageEntityStrike,MessageEntityBlockquote]
TypeInputMessage = Union[InputMessageID,InputMessageReplyTo,InputMessagePinned]
TypeMessagesFilter = Union[InputMessagesFilterEmpty,InputMessagesFilterPhotos,InputMessagesFilterVideo,InputMessagesFilterPhotoVideo,InputMessagesFilterDocument,InputMessagesFilterUrl,InputMessagesFilterGif,InputMessagesFilterVoice,InputMessagesFilterMusic,InputMessagesFilterChatPhotos,InputMessagesFilterPhoneCalls,InputMessagesFilterRoundVoice,InputMessagesFilterRoundVideo,InputMessagesFilterMyMentions,InputMessagesFilterGeo,InputMessagesFilterContacts]
TypeInputNotifyPeer = Union[InputNotifyPeer,InputNotifyUsers,InputNotifyChats,InputNotifyBroadcasts]
TypeInputPaymentCredentials = Union[InputPaymentCredentialsSaved,InputPaymentCredentials,InputPaymentCredentialsApplePay,InputPaymentCredentialsAndroidPay]
TypeInputPeer = Union[InputPeerEmpty,InputPeerSelf,InputPeerChat,InputPeerUser,InputPeerChannel,InputPeerUserFromMessage,InputPeerChannelFromMessage]
TypeInputPeerNotifySettings = InputPeerNotifySettings
TypeInputPhoneCall = InputPhoneCall
TypeInputContact = InputPhoneContact
TypeInputPhoto = Union[InputPhotoEmpty,InputPhoto]
TypeInputPrivacyKey = Union[InputPrivacyKeyStatusTimestamp,InputPrivacyKeyChatInvite,InputPrivacyKeyPhoneCall,InputPrivacyKeyPhoneP2P,InputPrivacyKeyForwards,InputPrivacyKeyProfilePhoto,InputPrivacyKeyPhoneNumber,InputPrivacyKeyAddedByPhone]
TypeInputPrivacyRule = Union[InputPrivacyValueAllowContacts,InputPrivacyValueAllowAll,InputPrivacyValueAllowUsers,InputPrivacyValueDisallowContacts,InputPrivacyValueDisallowAll,InputPrivacyValueDisallowUsers,InputPrivacyValueAllowChatParticipants,InputPrivacyValueDisallowChatParticipants]
TypeReportReason = Union[InputReportReasonSpam,InputReportReasonViolence,InputReportReasonPornography,InputReportReasonChildAbuse,InputReportReasonOther,InputReportReasonCopyright,InputReportReasonGeoIrrelevant]
TypeInputSecureFile = Union[InputSecureFileUploaded,InputSecureFile]
TypeInputSecureValue = InputSecureValue
TypeInputSingleMedia = InputSingleMedia
TypeInputStickerSet = Union[InputStickerSetEmpty,InputStickerSetID,InputStickerSetShortName,InputStickerSetAnimatedEmoji]
TypeInputStickerSetItem = InputStickerSetItem
TypeInputStickeredMedia = Union[InputStickeredMediaPhoto,InputStickeredMediaDocument]
TypeInputTheme = Union[InputTheme,InputThemeSlug]
TypeInputUser = Union[InputUserEmpty,InputUserSelf,InputUser,InputUserFromMessage]
TypeInputWallPaper = Union[InputWallPaper,InputWallPaperSlug]
TypeInputWebDocument = InputWebDocument
TypeInputWebFileLocation = Union[InputWebFileLocation,InputWebFileGeoPointLocation]
TypeInvoice = Invoice
TypeIpPort = Union[IpPort,IpPortSecret]
TypeJSONValue = Union[JsonNull,JsonBool,JsonNumber,JsonString,JsonArray,JsonObject]
TypeJSONObjectValue = JsonObjectValue
TypeKeyboardButtonRow = KeyboardButtonRow
TypeLabeledPrice = LabeledPrice
TypeLangPackDifference = LangPackDifference
TypeLangPackLanguage = LangPackLanguage
TypeLangPackString = Union[LangPackString,LangPackStringPluralized,LangPackStringDeleted]
TypeMaskCoords = MaskCoords
TypeMessage = Union[MessageEmpty,Message,MessageService]
TypeMessageAction = Union[MessageActionEmpty,MessageActionChatCreate,MessageActionChatEditTitle,MessageActionChatEditPhoto,MessageActionChatDeletePhoto,MessageActionChatAddUser,MessageActionChatDeleteUser,MessageActionChatJoinedByLink,MessageActionChannelCreate,MessageActionChatMigrateTo,MessageActionChannelMigrateFrom,MessageActionPinMessage,MessageActionHistoryClear,MessageActionGameScore,MessageActionPaymentSentMe,MessageActionPaymentSent,MessageActionPhoneCall,MessageActionScreenshotTaken,MessageActionCustomAction,MessageActionBotAllowed,MessageActionSecureValuesSentMe,MessageActionSecureValuesSent,MessageActionContactSignUp]
TypeMessageFwdHeader = MessageFwdHeader
TypeMessageMedia = Union[MessageMediaEmpty,MessageMediaPhoto,MessageMediaGeo,MessageMediaContact,MessageMediaUnsupported,MessageMediaDocument,MessageMediaWebPage,MessageMediaVenue,MessageMediaGame,MessageMediaInvoice,MessageMediaGeoLive,MessageMediaPoll]
TypeMessageRange = MessageRange
TypeMsgDetailedInfo = Union[MsgDetailedInfo,MsgNewDetailedInfo]
TypeMsgResendReq = MsgResendReq
TypeMsgsAck = MsgsAck
TypeMsgsAllInfo = MsgsAllInfo
TypeMsgsStateInfo = MsgsStateInfo
TypeMsgsStateReq = MsgsStateReq
TypeNearestDc = NearestDc
TypeNewSession = NewSessionCreated
TypeNotifyPeer = Union[NotifyPeer,NotifyUsers,NotifyChats,NotifyBroadcasts]
TypeP_Q_inner_data = Union[PQInnerData,PQInnerDataDc,PQInnerDataTemp,PQInnerDataTempDc]
TypePage = Page
TypePageBlock = Union[PageBlockUnsupported,PageBlockTitle,PageBlockSubtitle,PageBlockAuthorDate,PageBlockHeader,PageBlockSubheader,PageBlockParagraph,PageBlockPreformatted,PageBlockFooter,PageBlockDivider,PageBlockAnchor,PageBlockList,PageBlockBlockquote,PageBlockPullquote,PageBlockPhoto,PageBlockVideo,PageBlockCover,PageBlockEmbed,PageBlockEmbedPost,PageBlockCollage,PageBlockSlideshow,PageBlockChannel,PageBlockAudio,PageBlockKicker,PageBlockTable,PageBlockOrderedList,PageBlockDetails,PageBlockRelatedArticles,PageBlockMap]
TypePageCaption = PageCaption
TypePageListItem = Union[PageListItemText,PageListItemBlocks]
TypePageListOrderedItem = Union[PageListOrderedItemText,PageListOrderedItemBlocks]
TypePageRelatedArticle = PageRelatedArticle
TypePageTableCell = PageTableCell
TypePageTableRow = PageTableRow
TypePasswordKdfAlgo = Union[PasswordKdfAlgoUnknown,PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow]
TypePaymentCharge = PaymentCharge
TypePaymentRequestedInfo = PaymentRequestedInfo
TypePaymentSavedCredentials = PaymentSavedCredentialsCard
TypePeer = Union[PeerUser,PeerChat,PeerChannel]
TypePeerLocated = PeerLocated
TypePeerNotifySettings = PeerNotifySettings
TypePeerSettings = PeerSettings
TypePhoneCall = Union[PhoneCallEmpty,PhoneCallWaiting,PhoneCallRequested,PhoneCallAccepted,PhoneCall,PhoneCallDiscarded]
TypePhoneCallDiscardReason = Union[PhoneCallDiscardReasonMissed,PhoneCallDiscardReasonDisconnect,PhoneCallDiscardReasonHangup,PhoneCallDiscardReasonBusy]
TypePhoneCallProtocol = PhoneCallProtocol
TypePhoneConnection = PhoneConnection
TypePhoto = Union[PhotoEmpty,Photo]
TypePhotoSize = Union[PhotoSizeEmpty,PhotoSize,PhotoCachedSize,PhotoStrippedSize]
TypePoll = Poll
TypePollAnswer = PollAnswer
TypePollAnswerVoters = PollAnswerVoters
TypePollResults = PollResults
TypePong = Pong
TypePopularContact = PopularContact
TypePostAddress = PostAddress
TypePrivacyKey = Union[PrivacyKeyStatusTimestamp,PrivacyKeyChatInvite,PrivacyKeyPhoneCall,PrivacyKeyPhoneP2P,PrivacyKeyForwards,PrivacyKeyProfilePhoto,PrivacyKeyPhoneNumber,PrivacyKeyAddedByPhone]
TypePrivacyRule = Union[PrivacyValueAllowContacts,PrivacyValueAllowAll,PrivacyValueAllowUsers,PrivacyValueDisallowContacts,PrivacyValueDisallowAll,PrivacyValueDisallowUsers,PrivacyValueAllowChatParticipants,PrivacyValueDisallowChatParticipants]
TypeReceivedNotifyMessage = ReceivedNotifyMessage
TypeRecentMeUrl = Union[RecentMeUrlUnknown,RecentMeUrlUser,RecentMeUrlChat,RecentMeUrlChatInvite,RecentMeUrlStickerSet]
TypeReplyMarkup = Union[ReplyKeyboardHide,ReplyKeyboardForceReply,ReplyKeyboardMarkup,ReplyInlineMarkup]
TypeResPQ = ResPQ
TypeRestrictionReason = RestrictionReason
TypeRpcDropAnswer = Union[RpcAnswerUnknown,RpcAnswerDroppedRunning,RpcAnswerDropped]
TypeRpcError = RpcError
TypeSavedContact = SavedPhoneContact
TypeSecureCredentialsEncrypted = SecureCredentialsEncrypted
TypeSecureData = SecureData
TypeSecureFile = Union[SecureFileEmpty,SecureFile]
TypeSecurePasswordKdfAlgo = Union[SecurePasswordKdfAlgoUnknown,SecurePasswordKdfAlgoPBKDF2HMACSHA512iter100000,SecurePasswordKdfAlgoSHA512]
TypeSecurePlainData = Union[SecurePlainPhone,SecurePlainEmail]
TypeSecureRequiredType = Union[SecureRequiredType,SecureRequiredTypeOneOf]
TypeSecureSecretSettings = SecureSecretSettings
TypeSecureValue = SecureValue
TypeSecureValueError = Union[SecureValueErrorData,SecureValueErrorFrontSide,SecureValueErrorReverseSide,SecureValueErrorSelfie,SecureValueErrorFile,SecureValueErrorFiles,SecureValueError,SecureValueErrorTranslationFile,SecureValueErrorTranslationFiles]
TypeSecureValueHash = SecureValueHash
TypeSecureValueType = Union[SecureValueTypePersonalDetails,SecureValueTypePassport,SecureValueTypeDriverLicense,SecureValueTypeIdentityCard,SecureValueTypeInternalPassport,SecureValueTypeAddress,SecureValueTypeUtilityBill,SecureValueTypeBankStatement,SecureValueTypeRentalAgreement,SecureValueTypePassportRegistration,SecureValueTypeTemporaryRegistration,SecureValueTypePhone,SecureValueTypeEmail]
TypeSendMessageAction = Union[SendMessageTypingAction,SendMessageCancelAction,SendMessageRecordVideoAction,SendMessageUploadVideoAction,SendMessageRecordAudioAction,SendMessageUploadAudioAction,SendMessageUploadPhotoAction,SendMessageUploadDocumentAction,SendMessageGeoLocationAction,SendMessageChooseContactAction,SendMessageGamePlayAction,SendMessageRecordRoundAction,SendMessageUploadRoundAction]
TypeServer_DH_inner_data = ServerDHInnerData
TypeServer_DH_Params = Union[ServerDHParamsFail,ServerDHParamsOk]
TypeShippingOption = ShippingOption
TypeStatsURL = StatsURL
TypeStickerPack = StickerPack
TypeStickerSet = StickerSet
TypeStickerSetCovered = Union[StickerSetCovered,StickerSetMultiCovered]
TypeRichText = Union[TextEmpty,TextPlain,TextBold,TextItalic,TextUnderline,TextStrike,TextFixed,TextUrl,TextEmail,TextConcat,TextSubscript,TextSuperscript,TextMarked,TextPhone,TextImage,TextAnchor]
TypeTheme = Union[ThemeDocumentNotModified,Theme]
TypeTlsBlock = Union[TlsBlockString,TlsBlockRandom,TlsBlockZero,TlsBlockDomain,TlsBlockGrease,TlsBlockScope]
TypeTlsClientHello = TlsClientHello
TypeTopPeer = TopPeer
TypeTopPeerCategory = Union[TopPeerCategoryBotsPM,TopPeerCategoryBotsInline,TopPeerCategoryCorrespondents,TopPeerCategoryGroups,TopPeerCategoryChannels,TopPeerCategoryPhoneCalls,TopPeerCategoryForwardUsers,TopPeerCategoryForwardChats]
TypeTopPeerCategoryPeers = TopPeerCategoryPeers
TypeUpdate = Union[UpdateNewMessage,UpdateMessageID,UpdateDeleteMessages,UpdateUserTyping,UpdateChatUserTyping,UpdateChatParticipants,UpdateUserStatus,UpdateUserName,UpdateUserPhoto,UpdateNewEncryptedMessage,UpdateEncryptedChatTyping,UpdateEncryption,UpdateEncryptedMessagesRead,UpdateChatParticipantAdd,UpdateChatParticipantDelete,UpdateDcOptions,UpdateUserBlocked,UpdateNotifySettings,UpdateServiceNotification,UpdatePrivacy,UpdateUserPhone,UpdateReadHistoryInbox,UpdateReadHistoryOutbox,UpdateWebPage,UpdateReadMessagesContents,UpdateChannelTooLong,UpdateChannel,UpdateNewChannelMessage,UpdateReadChannelInbox,UpdateDeleteChannelMessages,UpdateChannelMessageViews,UpdateChatParticipantAdmin,UpdateNewStickerSet,UpdateStickerSetsOrder,UpdateStickerSets,UpdateSavedGifs,UpdateBotInlineQuery,UpdateBotInlineSend,UpdateEditChannelMessage,UpdateChannelPinnedMessage,UpdateBotCallbackQuery,UpdateEditMessage,UpdateInlineBotCallbackQuery,UpdateReadChannelOutbox,UpdateDraftMessage,UpdateReadFeaturedStickers,UpdateRecentStickers,UpdateConfig,UpdatePtsChanged,UpdateChannelWebPage,UpdateDialogPinned,UpdatePinnedDialogs,UpdateBotWebhookJSON,UpdateBotWebhookJSONQuery,UpdateBotShippingQuery,UpdateBotPrecheckoutQuery,UpdatePhoneCall,UpdateLangPackTooLong,UpdateLangPack,UpdateFavedStickers,UpdateChannelReadMessagesContents,UpdateContactsReset,UpdateChannelAvailableMessages,UpdateDialogUnreadMark,UpdateUserPinnedMessage,UpdateChatPinnedMessage,UpdateMessagePoll,UpdateChatDefaultBannedRights,UpdateFolderPeers,UpdatePeerSettings,UpdatePeerLocated,UpdateNewScheduledMessage,UpdateDeleteScheduledMessages,UpdateTheme]
TypeUpdates = Union[UpdatesTooLong,UpdateShortMessage,UpdateShortChatMessage,UpdateShort,UpdatesCombined,Updates,UpdateShortSentMessage]
TypeUrlAuthResult = Union[UrlAuthResultRequest,UrlAuthResultAccepted,UrlAuthResultDefault]
TypeUser = Union[UserEmpty,User]
TypeUserFull = UserFull
TypeUserProfilePhoto = Union[UserProfilePhotoEmpty,UserProfilePhoto]
TypeUserStatus = Union[UserStatusEmpty,UserStatusOnline,UserStatusOffline,UserStatusRecently,UserStatusLastWeek,UserStatusLastMonth]
TypeWallPaper = WallPaper
TypeWallPaperSettings = WallPaperSettings
TypeWebAuthorization = WebAuthorization
TypeWebDocument = Union[WebDocument,WebDocumentNoProxy]
TypeWebPage = Union[WebPageEmpty,WebPagePending,WebPage,WebPageNotModified]
