# interfaces/error_handler_interface.py
from typing import Protocol

class IErrorHandler(Protocol):
    def get_message(self, error) -> None: ...
    def create_error_log(self, data) -> None: ...
    def get_error_entity(self, error, method, error_type, status_code) -> None: ...
    def resend_error_entity(self, error_entity) -> None: ...
    def handle_error(self, resp, status) -> None: ...
    def get_response_error(self, resp) -> None: ...
    def get_error_type(self, conn) -> None: ...
