# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: get_task_def.sql
import dataclasses
from typing import Optional

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


GET_TASK_DEF = """-- name: get_task_def \\:one
SELECT task_name, cron_expr, source_code, arg_schema, queue, priority, max_retries, timeout_seconds, last_updated FROM hyrex_task_def
WHERE task_name = :p1
"""


@dataclasses.dataclass()
class GetTaskDefParams:
    task_name: str


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def get_task_def(self, arg: GetTaskDefParams) -> Optional[models.HyrexTaskDef]:
        row = self._conn.execute(sqlalchemy.text(GET_TASK_DEF), {"p1": arg.task_name}).first()
        if row is None:
            return None
        return models.HyrexTaskDef(
            task_name=row[0],
            cron_expr=row[1],
            source_code=row[2],
            arg_schema=row[3],
            queue=row[4],
            priority=row[5],
            max_retries=row[6],
            timeout_seconds=row[7],
            last_updated=row[8],
        )


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def get_task_def(self, arg: GetTaskDefParams) -> Optional[models.HyrexTaskDef]:
        row = (await self._conn.execute(sqlalchemy.text(GET_TASK_DEF), {"p1": arg.task_name})).first()
        if row is None:
            return None
        return models.HyrexTaskDef(
            task_name=row[0],
            cron_expr=row[1],
            source_code=row[2],
            arg_schema=row[3],
            queue=row[4],
            priority=row[5],
            max_retries=row[6],
            timeout_seconds=row[7],
            last_updated=row[8],
        )
