# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: get_tasks_paginated.sql
import dataclasses
import datetime
from typing import AsyncIterator, Iterator, Optional

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


GET_TASKS_PAGINATED = """-- name: get_tasks_paginated \\:many
SELECT 
    ROW_NUMBER() OVER (ORDER BY last_updated DESC) as row_number,
    task_name,
    cron_expr,
    source_code,
    last_updated
FROM hyrex_task_def
ORDER BY last_updated DESC
LIMIT :p1 OFFSET :p2
"""


@dataclasses.dataclass()
class GetTasksPaginatedParams:
    limit: int
    offset: int


@dataclasses.dataclass()
class GetTasksPaginatedRow:
    row_number: int
    task_name: str
    cron_expr: Optional[str]
    source_code: Optional[str]
    last_updated: Optional[datetime.datetime]


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def get_tasks_paginated(self, arg: GetTasksPaginatedParams) -> Iterator[GetTasksPaginatedRow]:
        result = self._conn.execute(sqlalchemy.text(GET_TASKS_PAGINATED), {"p1": arg.limit, "p2": arg.offset})
        for row in result:
            yield GetTasksPaginatedRow(
                row_number=row[0],
                task_name=row[1],
                cron_expr=row[2],
                source_code=row[3],
                last_updated=row[4],
            )


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def get_tasks_paginated(self, arg: GetTasksPaginatedParams) -> AsyncIterator[GetTasksPaginatedRow]:
        result = await self._conn.stream(sqlalchemy.text(GET_TASKS_PAGINATED), {"p1": arg.limit, "p2": arg.offset})
        async for row in result:
            yield GetTasksPaginatedRow(
                row_number=row[0],
                task_name=row[1],
                cron_expr=row[2],
                source_code=row[3],
                last_updated=row[4],
            )
