# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: register_workflow.sql
import dataclasses
from typing import Any, Optional

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


REGISTER_WORKFLOW = """-- name: register_workflow \\:exec
INSERT INTO hyrex_workflow (workflow_name, cron_expr, source_code, dag_structure, last_updated)
VALUES (:p1, :p2, :p3, :p4, NOW())
ON CONFLICT (workflow_name)
DO UPDATE SET 
    cron_expr = EXCLUDED.cron_expr,
    source_code = EXCLUDED.source_code,
    dag_structure = EXCLUDED.dag_structure,
    last_updated = NOW()
"""


@dataclasses.dataclass()
class RegisterWorkflowParams:
    workflow_name: str
    cron_expr: Optional[str]
    source_code: Optional[str]
    dag_structure: Optional[Any]


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def register_workflow(self, arg: RegisterWorkflowParams) -> None:
        self._conn.execute(sqlalchemy.text(REGISTER_WORKFLOW), {
            "p1": arg.workflow_name,
            "p2": arg.cron_expr,
            "p3": arg.source_code,
            "p4": arg.dag_structure,
        })


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def register_workflow(self, arg: RegisterWorkflowParams) -> None:
        await self._conn.execute(sqlalchemy.text(REGISTER_WORKFLOW), {
            "p1": arg.workflow_name,
            "p2": arg.cron_expr,
            "p3": arg.source_code,
            "p4": arg.dag_structure,
        })
