# Code generated by sqlc. DO NOT EDIT.
# versions:
#   sqlc v1.29.0
# source: schedule_cron_job_runs_json.sql
import dataclasses
from typing import Any, Optional

import sqlalchemy
import sqlalchemy.ext.asyncio

from . import models


SCHEDULE_CRON_JOB_RUNS_JSON = """-- name: schedule_cron_job_runs_json \\:one
WITH input_data AS (
    SELECT 
        json_array_elements(:p1\\:\\:json) AS run_data
),
converted_runs AS (
    SELECT ARRAY_AGG(
        ROW(
            (run_data->>'jobid')\\:\\:BIGINT,
            run_data->>'command',
            (run_data->>'schedule_time')\\:\\:TIMESTAMPTZ
        )\\:\\:cron_job_run_input
    ) AS runs_array
    FROM input_data
)
SELECT 
    json_build_object(
        'success', success,
        'message', message,
        'inserted_count', inserted_count,
        'runids', runids
    ) AS result
FROM converted_runs, 
LATERAL schedule_cron_job_runs(runs_array)
"""


@dataclasses.dataclass()
class ScheduleCronJobRunsJsonParams:
    runs_json: Any


class Querier:
    def __init__(self, conn: sqlalchemy.engine.Connection):
        self._conn = conn

    def schedule_cron_job_runs_json(self, arg: ScheduleCronJobRunsJsonParams) -> Optional[Any]:
        row = self._conn.execute(sqlalchemy.text(SCHEDULE_CRON_JOB_RUNS_JSON), {"p1": arg.runs_json}).first()
        if row is None:
            return None
        return row[0]


class AsyncQuerier:
    def __init__(self, conn: sqlalchemy.ext.asyncio.AsyncConnection):
        self._conn = conn

    async def schedule_cron_job_runs_json(self, arg: ScheduleCronJobRunsJsonParams) -> Optional[Any]:
        row = (await self._conn.execute(sqlalchemy.text(SCHEDULE_CRON_JOB_RUNS_JSON), {"p1": arg.runs_json})).first()
        if row is None:
            return None
        return row[0]
