/*
 * Decompiled with CFR 0.152.
 */
package com.tecton.udfs.spark3;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0000J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/tecton/udfs/spark3/SparseArray;", "Ljava/io/Serializable;", "()V", "indices", "", "", "registers", "(Ljava/util/List;Ljava/util/List;)V", "getIndices", "()Ljava/util/List;", "setIndices", "(Ljava/util/List;)V", "getRegisters", "setRegisters", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "merge", "toString", "", "java_com_tecton_udfs_spark3-tecton-udfs-lib"})
public final class SparseArray
implements Serializable {
    @NotNull
    private List<Long> indices;
    @NotNull
    private List<Long> registers;

    public SparseArray(@NotNull List<Long> indices, @NotNull List<Long> registers) {
        Intrinsics.checkNotNullParameter(indices, "indices");
        Intrinsics.checkNotNullParameter(registers, "registers");
        this.indices = indices;
        this.registers = registers;
    }

    @NotNull
    public final List<Long> getIndices() {
        return this.indices;
    }

    public final void setIndices(@NotNull List<Long> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.indices = list;
    }

    @NotNull
    public final List<Long> getRegisters() {
        return this.registers;
    }

    public final void setRegisters(@NotNull List<Long> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.registers = list;
    }

    public SparseArray() {
        this(new ArrayList(), new ArrayList());
    }

    @NotNull
    public final SparseArray merge(@NotNull SparseArray other) {
        Intrinsics.checkNotNullParameter(other, "other");
        int iter1 = 0;
        int iter2 = 0;
        while (iter1 < this.indices.size() || iter2 < other.indices.size()) {
            long index = 0L;
            long register = 0L;
            if (iter2 == other.indices.size()) break;
            if (iter1 == this.indices.size() || ((Number)this.indices.get(iter1)).longValue() > ((Number)other.indices.get(iter2)).longValue()) {
                index = ((Number)other.indices.get(iter2)).longValue();
                register = ((Number)other.registers.get(iter2)).longValue();
                this.indices.add(iter1, index);
                this.registers.add(iter1, register);
                ++iter1;
                ++iter2;
                continue;
            }
            if (((Number)this.indices.get(iter1)).longValue() < ((Number)other.indices.get(iter2)).longValue()) {
                ++iter1;
                continue;
            }
            this.registers.set(iter1, Math.max(((Number)this.registers.get(iter1)).longValue(), ((Number)other.registers.get(iter2)).longValue()));
            ++iter1;
            ++iter2;
        }
        return this;
    }

    @NotNull
    public final List<Long> component1() {
        return this.indices;
    }

    @NotNull
    public final List<Long> component2() {
        return this.registers;
    }

    @NotNull
    public final SparseArray copy(@NotNull List<Long> indices, @NotNull List<Long> registers) {
        Intrinsics.checkNotNullParameter(indices, "indices");
        Intrinsics.checkNotNullParameter(registers, "registers");
        return new SparseArray(indices, registers);
    }

    public static /* synthetic */ SparseArray copy$default(SparseArray sparseArray, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            list = sparseArray.indices;
        }
        if ((n & 2) != 0) {
            list2 = sparseArray.registers;
        }
        return sparseArray.copy(list, list2);
    }

    @NotNull
    public String toString() {
        return "SparseArray(indices=" + this.indices + ", registers=" + this.registers + ')';
    }

    public int hashCode() {
        int result = ((Object)this.indices).hashCode();
        result = result * 31 + ((Object)this.registers).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SparseArray)) {
            return false;
        }
        SparseArray sparseArray = (SparseArray)other;
        if (!Intrinsics.areEqual(this.indices, sparseArray.indices)) {
            return false;
        }
        return Intrinsics.areEqual(this.registers, sparseArray.registers);
    }
}

