/*
 * Decompiled with CFR 0.152.
 */
package com.tecton.udfs.spark3;

import com.tecton.udfs.spark3.ApproxPercentilePartialAggKt;
import com.tecton.udfs.spark3.TDigestProcessed;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002Bo\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u001e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J\u000f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J\t\u0010,\u001a\u00020\fH\u00c6\u0003J\u000e\u0010-\u001a\u00020!2\u0006\u0010$\u001a\u00020%Js\u0010.\u001a\u00020\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0013\u00101\u001a\u00020\f2\b\u00102\u001a\u0004\u0018\u000103H\u00d6\u0003J\u000e\u00104\u001a\u00020!2\u0006\u0010$\u001a\u00020%J\t\u00105\u001a\u00020%H\u00d6\u0001J\u0006\u00106\u001a\u00020\u0005J\u0016\u00107\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%J\u0016\u00107\u001a\u00020\u00002\u0006\u00102\u001a\u0002082\u0006\u0010$\u001a\u00020%J$\u00109\u001a\u00020!2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J$\u0010<\u001a\u00020!2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0006\u0010=\u001a\u00020\u0005J\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\f\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0015\u0010@\u001a\u0004\u0018\u00010\u00052\u0006\u0010A\u001a\u00020\u0005\u00a2\u0006\u0002\u0010BJ\u0010\u0010C\u001a\u00020\f2\u0006\u0010$\u001a\u00020%H\u0002J\t\u0010D\u001a\u00020EH\u00d6\u0001R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0011R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000f\"\u0004\b\u0019\u0010\u0011R \u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u000f\"\u0004\b\u001b\u0010\u0011R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006F"}, d2={"Lcom/tecton/udfs/spark3/TDigest;", "Ljava/io/Serializable;", "()V", "processedMeans", "", "", "processedWeights", "tempProcessedMeans", "tempProcessedWeights", "unprocessedMeans", "unprocessedWeights", "usingTempList", "", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Z)V", "getProcessedMeans", "()Ljava/util/List;", "setProcessedMeans", "(Ljava/util/List;)V", "getProcessedWeights", "setProcessedWeights", "getTempProcessedMeans", "setTempProcessedMeans", "getTempProcessedWeights", "setTempProcessedWeights", "getUnprocessedMeans", "setUnprocessedMeans", "getUnprocessedWeights", "setUnprocessedWeights", "getUsingTempList", "()Z", "setUsingTempList", "(Z)V", "addUnprocessed", "", "mean", "weight", "compression", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "compress", "copy", "currentProcessedMeans", "currentProcessedWeights", "equals", "other", "", "finish", "hashCode", "max", "merge", "Lcom/tecton/udfs/spark3/TDigestProcessed;", "mergeProcessed", "otherMeans", "otherWeights", "mergeUnprocessed", "min", "newProcessedMeans", "newProcessedWeights", "quantile", "q", "(D)Ljava/lang/Double;", "shouldCompress", "toString", "", "java_com_tecton_udfs_spark3-tecton-udfs-lib"})
public final class TDigest
implements Serializable {
    @NotNull
    private List<Double> processedMeans;
    @NotNull
    private List<Double> processedWeights;
    @NotNull
    private List<Double> tempProcessedMeans;
    @NotNull
    private List<Double> tempProcessedWeights;
    @NotNull
    private List<Double> unprocessedMeans;
    @NotNull
    private List<Double> unprocessedWeights;
    private boolean usingTempList;

    public TDigest(@NotNull List<Double> processedMeans, @NotNull List<Double> processedWeights, @NotNull List<Double> tempProcessedMeans, @NotNull List<Double> tempProcessedWeights, @NotNull List<Double> unprocessedMeans, @NotNull List<Double> unprocessedWeights, boolean usingTempList) {
        Intrinsics.checkNotNullParameter(processedMeans, "processedMeans");
        Intrinsics.checkNotNullParameter(processedWeights, "processedWeights");
        Intrinsics.checkNotNullParameter(tempProcessedMeans, "tempProcessedMeans");
        Intrinsics.checkNotNullParameter(tempProcessedWeights, "tempProcessedWeights");
        Intrinsics.checkNotNullParameter(unprocessedMeans, "unprocessedMeans");
        Intrinsics.checkNotNullParameter(unprocessedWeights, "unprocessedWeights");
        this.processedMeans = processedMeans;
        this.processedWeights = processedWeights;
        this.tempProcessedMeans = tempProcessedMeans;
        this.tempProcessedWeights = tempProcessedWeights;
        this.unprocessedMeans = unprocessedMeans;
        this.unprocessedWeights = unprocessedWeights;
        this.usingTempList = usingTempList;
    }

    public /* synthetic */ TDigest(List list, List list2, List list3, List list4, List list5, List list6, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        if ((n & 2) != 0) {
            list2 = new ArrayList();
        }
        if ((n & 4) != 0) {
            list3 = new ArrayList();
        }
        if ((n & 8) != 0) {
            list4 = new ArrayList();
        }
        if ((n & 0x10) != 0) {
            list5 = new ArrayList();
        }
        if ((n & 0x20) != 0) {
            list6 = new ArrayList();
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        this(list, list2, list3, list4, list5, list6, bl);
    }

    @NotNull
    public final List<Double> getProcessedMeans() {
        return this.processedMeans;
    }

    public final void setProcessedMeans(@NotNull List<Double> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.processedMeans = list;
    }

    @NotNull
    public final List<Double> getProcessedWeights() {
        return this.processedWeights;
    }

    public final void setProcessedWeights(@NotNull List<Double> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.processedWeights = list;
    }

    @NotNull
    public final List<Double> getTempProcessedMeans() {
        return this.tempProcessedMeans;
    }

    public final void setTempProcessedMeans(@NotNull List<Double> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.tempProcessedMeans = list;
    }

    @NotNull
    public final List<Double> getTempProcessedWeights() {
        return this.tempProcessedWeights;
    }

    public final void setTempProcessedWeights(@NotNull List<Double> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.tempProcessedWeights = list;
    }

    @NotNull
    public final List<Double> getUnprocessedMeans() {
        return this.unprocessedMeans;
    }

    public final void setUnprocessedMeans(@NotNull List<Double> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.unprocessedMeans = list;
    }

    @NotNull
    public final List<Double> getUnprocessedWeights() {
        return this.unprocessedWeights;
    }

    public final void setUnprocessedWeights(@NotNull List<Double> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.unprocessedWeights = list;
    }

    public final boolean getUsingTempList() {
        return this.usingTempList;
    }

    public final void setUsingTempList(boolean bl) {
        this.usingTempList = bl;
    }

    public TDigest() {
        this(new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), false);
    }

    public final void addUnprocessed(double mean, double weight, int compression) {
        if (Double.isInfinite(mean) || Double.isNaN(mean)) {
            return;
        }
        this.unprocessedMeans.add(mean);
        this.unprocessedWeights.add(weight);
        int maxUnprocessed = compression * 10;
        if (this.unprocessedMeans.size() > maxUnprocessed) {
            this.compress(compression);
        }
    }

    private final boolean shouldCompress(int compression) {
        return this.currentProcessedMeans().size() > compression * 10 || this.unprocessedMeans.size() > compression * 10;
    }

    private final void mergeProcessed(List<Double> otherMeans, List<Double> otherWeights) {
        ApproxPercentilePartialAggKt.access$mergeProcessedHelper(this.currentProcessedMeans(), this.currentProcessedWeights(), otherMeans, otherWeights, this.newProcessedMeans(), this.newProcessedWeights());
        this.currentProcessedMeans().clear();
        this.currentProcessedWeights().clear();
        this.usingTempList = !this.usingTempList;
    }

    private final void mergeUnprocessed(List<Double> otherMeans, List<Double> otherWeights) {
        this.unprocessedMeans.addAll((Collection<Double>)otherMeans);
        this.unprocessedWeights.addAll((Collection<Double>)otherWeights);
    }

    @NotNull
    public final TDigest merge(@NotNull TDigest other, int compression) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.mergeProcessed(other.currentProcessedMeans(), other.currentProcessedWeights());
        this.mergeUnprocessed(other.unprocessedMeans, other.unprocessedWeights);
        if (this.shouldCompress(compression)) {
            this.compress(compression);
        }
        return this;
    }

    @NotNull
    public final TDigest merge(@NotNull TDigestProcessed other, int compression) {
        Intrinsics.checkNotNullParameter(other, "other");
        int n = other.getProcessedMeans().size();
        boolean bl = 1 <= n ? n < 3 : false;
        if (bl) {
            int n2 = other.getProcessedMeans().size();
            for (int i = 0; i < n2; ++i) {
                this.addUnprocessed(((Number)other.getProcessedMeans().get(i)).doubleValue(), ((Number)other.getProcessedWeights().get(i)).doubleValue(), compression);
            }
        } else {
            this.mergeProcessed(other.getProcessedMeans(), other.getProcessedWeights());
            if (this.shouldCompress(compression)) {
                this.compress(compression);
            }
        }
        return this;
    }

    public final void finish(int compression) {
        if (!((Collection)this.unprocessedMeans).isEmpty()) {
            this.compress(compression);
        }
    }

    public final void compress(int compression) {
        if (!(this.currentProcessedMeans().size() == this.currentProcessedWeights().size())) {
            boolean $i$a$-require-TDigest$compress$52 = false;
            String $i$a$-require-TDigest$compress$52 = "processedMeans and processedWeights must have the same length";
            throw new IllegalArgumentException($i$a$-require-TDigest$compress$52.toString());
        }
        if (!(this.unprocessedMeans.size() == this.unprocessedWeights.size())) {
            boolean $i$a$-require-TDigest$compress$62 = false;
            String $i$a$-require-TDigest$compress$62 = "unprocessedMeans and unprocessedWeights must have the same length";
            throw new IllegalArgumentException($i$a$-require-TDigest$compress$62.toString());
        }
        if (!this.newProcessedMeans().isEmpty()) {
            boolean $i$a$-require-TDigest$compress$72 = false;
            String $i$a$-require-TDigest$compress$72 = "newProcessedMeans must be empty";
            throw new IllegalArgumentException($i$a$-require-TDigest$compress$72.toString());
        }
        if (!this.newProcessedWeights().isEmpty()) {
            boolean $i$a$-require-TDigest$compress$82 = false;
            String $i$a$-require-TDigest$compress$82 = "newProcessedWeights must be empty";
            throw new IllegalArgumentException($i$a$-require-TDigest$compress$82.toString());
        }
        Iterable $this$sortedBy$iv = CollectionsKt.getIndices((Collection)this.unprocessedMeans);
        boolean $i$f$sortedBy = false;
        List unprocessedSortedIndices = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(this){
            final /* synthetic */ TDigest this$0;
            {
                this.this$0 = tDigest;
            }

            public final int compare(T a, T b) {
                int it = ((Number)a).intValue();
                boolean bl = false;
                Comparable comparable = this.this$0.getUnprocessedMeans().get(it);
                it = ((Number)b).intValue();
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)this.this$0.getUnprocessedMeans().get(it));
            }
        });
        double totalWeight = CollectionsKt.sumOfDouble((Iterable<Double>)this.unprocessedWeights) + CollectionsKt.sumOfDouble((Iterable<Double>)this.currentProcessedWeights());
        double processedWeight = 0.0;
        double startingValue = ApproxPercentilePartialAggKt.k3(0.0, compression, totalWeight);
        double limit = totalWeight * ApproxPercentilePartialAggKt.q3(startingValue + 1.0, compression, totalWeight);
        int iterProcessed = 0;
        int iterUnprocessed = 0;
        double mean = 0.0;
        double weight = 0.0;
        while (iterProcessed < this.currentProcessedMeans().size() || iterUnprocessed < this.unprocessedMeans.size()) {
            if (iterUnprocessed == this.unprocessedMeans.size()) {
                mean = ((Number)this.currentProcessedMeans().get(iterProcessed)).doubleValue();
                weight = ((Number)this.currentProcessedWeights().get(iterProcessed)).doubleValue();
                ++iterProcessed;
            } else {
                int sortedIndex = ((Number)unprocessedSortedIndices.get(iterUnprocessed)).intValue();
                if (iterProcessed == this.currentProcessedMeans().size()) {
                    mean = ((Number)this.unprocessedMeans.get(sortedIndex)).doubleValue();
                    weight = ((Number)this.unprocessedWeights.get(sortedIndex)).doubleValue();
                    ++iterUnprocessed;
                } else if (((Number)this.currentProcessedMeans().get(iterProcessed)).doubleValue() < ((Number)this.unprocessedMeans.get(sortedIndex)).doubleValue()) {
                    mean = ((Number)this.currentProcessedMeans().get(iterProcessed)).doubleValue();
                    weight = ((Number)this.currentProcessedWeights().get(iterProcessed)).doubleValue();
                    ++iterProcessed;
                } else {
                    mean = ((Number)this.unprocessedMeans.get(sortedIndex)).doubleValue();
                    weight = ((Number)this.unprocessedWeights.get(sortedIndex)).doubleValue();
                    ++iterUnprocessed;
                }
            }
            if (this.newProcessedMeans().isEmpty()) {
                this.newProcessedMeans().add(mean);
                this.newProcessedWeights().add(weight);
            } else if (processedWeight + weight <= limit) {
                double newWeight = ((Number)CollectionsKt.last(this.newProcessedWeights())).doubleValue() + weight;
                double newMean = (((Number)CollectionsKt.last(this.newProcessedMeans())).doubleValue() * ((Number)CollectionsKt.last(this.newProcessedWeights())).doubleValue() + mean * weight) / newWeight;
                this.newProcessedMeans().set(this.newProcessedMeans().size() - 1, newMean);
                this.newProcessedWeights().set(this.newProcessedWeights().size() - 1, newWeight);
            } else {
                this.newProcessedMeans().add(mean);
                this.newProcessedWeights().add(weight);
                limit = totalWeight * ApproxPercentilePartialAggKt.q3(ApproxPercentilePartialAggKt.k3(processedWeight / totalWeight, compression, totalWeight) + 1.0, compression, totalWeight);
            }
            processedWeight += weight;
        }
        if (!(!((Collection)this.newProcessedWeights()).isEmpty())) {
            boolean $i$a$-check-TDigest$compress$82 = false;
            String $i$a$-check-TDigest$compress$82 = "processing must create new centroids";
            throw new IllegalStateException($i$a$-check-TDigest$compress$82.toString());
        }
        if (!(((Number)this.newProcessedWeights().get(0)).doubleValue() == 1.0)) {
            boolean $i$a$-check-TDigest$compress$92 = false;
            String $i$a$-check-TDigest$compress$92 = "first centroid must have weight 1.0";
            throw new IllegalStateException($i$a$-check-TDigest$compress$92.toString());
        }
        if (!(((Number)CollectionsKt.last(this.newProcessedWeights())).doubleValue() == 1.0)) {
            boolean bl = false;
            String string = "last centroid must have weight 1.0";
            throw new IllegalStateException(string.toString());
        }
        this.currentProcessedMeans().clear();
        this.currentProcessedWeights().clear();
        this.unprocessedMeans.clear();
        this.unprocessedWeights.clear();
        this.usingTempList = !this.usingTempList;
    }

    @Nullable
    public final Double quantile(double q) {
        if (!(q >= 0.0 && q <= 1.0)) {
            boolean $i$a$-require-TDigest$quantile$52 = false;
            String $i$a$-require-TDigest$quantile$52 = "q must be in the range [0.0, 1.0]";
            throw new IllegalArgumentException($i$a$-require-TDigest$quantile$52.toString());
        }
        if (!this.unprocessedMeans.isEmpty()) {
            boolean $i$a$-require-TDigest$quantile$62 = false;
            String $i$a$-require-TDigest$quantile$62 = "Should not contain unprocessed means when computing quantile";
            throw new IllegalArgumentException($i$a$-require-TDigest$quantile$62.toString());
        }
        if (!this.unprocessedWeights.isEmpty()) {
            boolean $i$a$-require-TDigest$quantile$72 = false;
            String $i$a$-require-TDigest$quantile$72 = "Should not contain unprocessed weights when computing quantile";
            throw new IllegalArgumentException($i$a$-require-TDigest$quantile$72.toString());
        }
        if (this.currentProcessedMeans().isEmpty()) {
            return null;
        }
        if (!(((Number)this.currentProcessedWeights().get(0)).doubleValue() == 1.0 && ((Number)this.currentProcessedWeights().get(this.currentProcessedWeights().size() - 1)).doubleValue() == 1.0)) {
            boolean bl = false;
            String string = "The first and last centroids must have weight 1.0";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.currentProcessedMeans().size() == 1) {
            return this.currentProcessedMeans().get(0);
        }
        double processedWeight = CollectionsKt.sumOfDouble((Iterable<Double>)this.currentProcessedWeights());
        double index = q * processedWeight;
        if (index < 1.0) {
            return this.min();
        }
        if (index > processedWeight - 1.0) {
            return this.max();
        }
        double weightSoFar = ((Number)this.currentProcessedWeights().get(0)).doubleValue() / 2.0;
        int i = 0;
        int n = this.currentProcessedWeights().size() - 2;
        if (i <= n) {
            while (true) {
                double dw;
                if (weightSoFar + (dw = (((Number)this.currentProcessedWeights().get(i)).doubleValue() + ((Number)this.currentProcessedWeights().get(i + 1)).doubleValue()) / 2.0) <= index) {
                    weightSoFar += dw;
                } else {
                    double leftDelta = 0.0;
                    if (((Number)this.currentProcessedWeights().get(i)).doubleValue() == 1.0) {
                        if (index - weightSoFar < 0.5) {
                            return this.currentProcessedMeans().get(i);
                        }
                        leftDelta = 0.5;
                    }
                    double rightDelta = 0.0;
                    if (((Number)this.currentProcessedWeights().get(i + 1)).doubleValue() == 1.0) {
                        if (weightSoFar + dw - index <= 0.5) {
                            return this.currentProcessedMeans().get(i + 1);
                        }
                        rightDelta = 0.5;
                    }
                    double z1 = index - weightSoFar - leftDelta;
                    double z2 = weightSoFar + dw - index - rightDelta;
                    return (((Number)this.currentProcessedMeans().get(i)).doubleValue() * z2 + ((Number)this.currentProcessedMeans().get(i + 1)).doubleValue() * z1) / (z1 + z2);
                }
                if (i == n) break;
                ++i;
            }
        }
        throw new IllegalStateException("should never get here");
    }

    @NotNull
    public final List<Double> currentProcessedMeans() {
        return this.usingTempList ? this.tempProcessedMeans : this.processedMeans;
    }

    @NotNull
    public final List<Double> currentProcessedWeights() {
        return this.usingTempList ? this.tempProcessedWeights : this.processedWeights;
    }

    @NotNull
    public final List<Double> newProcessedMeans() {
        return this.usingTempList ? this.processedMeans : this.tempProcessedMeans;
    }

    @NotNull
    public final List<Double> newProcessedWeights() {
        return this.usingTempList ? this.processedWeights : this.tempProcessedWeights;
    }

    public final double min() {
        if (!(!((Collection)this.currentProcessedMeans()).isEmpty())) {
            boolean bl = false;
            String string = "can only get min if there are centroids ";
            throw new IllegalArgumentException(string.toString());
        }
        return ((Number)this.currentProcessedMeans().get(0)).doubleValue();
    }

    public final double max() {
        if (!(!((Collection)this.currentProcessedMeans()).isEmpty())) {
            boolean bl = false;
            String string = "can only get max if there are centroids ";
            throw new IllegalArgumentException(string.toString());
        }
        return ((Number)this.currentProcessedMeans().get(this.currentProcessedMeans().size() - 1)).doubleValue();
    }

    @NotNull
    public final List<Double> component1() {
        return this.processedMeans;
    }

    @NotNull
    public final List<Double> component2() {
        return this.processedWeights;
    }

    @NotNull
    public final List<Double> component3() {
        return this.tempProcessedMeans;
    }

    @NotNull
    public final List<Double> component4() {
        return this.tempProcessedWeights;
    }

    @NotNull
    public final List<Double> component5() {
        return this.unprocessedMeans;
    }

    @NotNull
    public final List<Double> component6() {
        return this.unprocessedWeights;
    }

    public final boolean component7() {
        return this.usingTempList;
    }

    @NotNull
    public final TDigest copy(@NotNull List<Double> processedMeans, @NotNull List<Double> processedWeights, @NotNull List<Double> tempProcessedMeans, @NotNull List<Double> tempProcessedWeights, @NotNull List<Double> unprocessedMeans, @NotNull List<Double> unprocessedWeights, boolean usingTempList) {
        Intrinsics.checkNotNullParameter(processedMeans, "processedMeans");
        Intrinsics.checkNotNullParameter(processedWeights, "processedWeights");
        Intrinsics.checkNotNullParameter(tempProcessedMeans, "tempProcessedMeans");
        Intrinsics.checkNotNullParameter(tempProcessedWeights, "tempProcessedWeights");
        Intrinsics.checkNotNullParameter(unprocessedMeans, "unprocessedMeans");
        Intrinsics.checkNotNullParameter(unprocessedWeights, "unprocessedWeights");
        return new TDigest(processedMeans, processedWeights, tempProcessedMeans, tempProcessedWeights, unprocessedMeans, unprocessedWeights, usingTempList);
    }

    public static /* synthetic */ TDigest copy$default(TDigest tDigest, List list, List list2, List list3, List list4, List list5, List list6, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            list = tDigest.processedMeans;
        }
        if ((n & 2) != 0) {
            list2 = tDigest.processedWeights;
        }
        if ((n & 4) != 0) {
            list3 = tDigest.tempProcessedMeans;
        }
        if ((n & 8) != 0) {
            list4 = tDigest.tempProcessedWeights;
        }
        if ((n & 0x10) != 0) {
            list5 = tDigest.unprocessedMeans;
        }
        if ((n & 0x20) != 0) {
            list6 = tDigest.unprocessedWeights;
        }
        if ((n & 0x40) != 0) {
            bl = tDigest.usingTempList;
        }
        return tDigest.copy(list, list2, list3, list4, list5, list6, bl);
    }

    @NotNull
    public String toString() {
        return "TDigest(processedMeans=" + this.processedMeans + ", processedWeights=" + this.processedWeights + ", tempProcessedMeans=" + this.tempProcessedMeans + ", tempProcessedWeights=" + this.tempProcessedWeights + ", unprocessedMeans=" + this.unprocessedMeans + ", unprocessedWeights=" + this.unprocessedWeights + ", usingTempList=" + this.usingTempList + ')';
    }

    public int hashCode() {
        int result = ((Object)this.processedMeans).hashCode();
        result = result * 31 + ((Object)this.processedWeights).hashCode();
        result = result * 31 + ((Object)this.tempProcessedMeans).hashCode();
        result = result * 31 + ((Object)this.tempProcessedWeights).hashCode();
        result = result * 31 + ((Object)this.unprocessedMeans).hashCode();
        result = result * 31 + ((Object)this.unprocessedWeights).hashCode();
        int n = this.usingTempList ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TDigest)) {
            return false;
        }
        TDigest tDigest = (TDigest)other;
        if (!Intrinsics.areEqual(this.processedMeans, tDigest.processedMeans)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.processedWeights, tDigest.processedWeights)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tempProcessedMeans, tDigest.tempProcessedMeans)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.tempProcessedWeights, tDigest.tempProcessedWeights)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.unprocessedMeans, tDigest.unprocessedMeans)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.unprocessedWeights, tDigest.unprocessedWeights)) {
            return false;
        }
        return this.usingTempList == tDigest.usingTempList;
    }
}

