# ![logo](hpe.jpg) Hamid Py Engine (HPE)

[![PyPI Version](https://img.shields.io/pypi/v/hpe.svg)](https://pypi.org/project/hpe)  
[![Python Versions](https://img.shields.io/pypi/pyversions/hpe.svg)](https://pypi.org/project/hpe)  
[![PyPI Downloads](https://static.pepy.tech/badge/hpe)](https://pepy.tech/project/hpe)  
[![PyPI Downloads Monthly](https://static.pepy.tech/badge/hpe/month)](https://pepy.tech/project/hpe)  
[![License](https://img.shields.io/github/license/lolgg313/HPE)](./LICENSE)  
[![Last Commit](https://img.shields.io/github/last-commit/lolgg313/HPE)](https://github.com/lolgg313/HPE)  
[![Repo Size](https://img.shields.io/github/repo-size/lolgg313/HPE)](https://github.com/lolgg313/HPE)  
[![Issues](https://img.shields.io/github/issues/lolgg313/HPE)](https://github.com/lolgg313/HPE/issues)  
[![Forks](https://img.shields.io/github/forks/lolgg313/HPE?style=social)](https://github.com/lolgg313/HPE/network)  
[![Stars](https://img.shields.io/github/stars/lolgg313/HPE?style=social)](https://github.com/lolgg313/HPE/stargazers)

> ✨ A lightweight Game engine!

> [!Note]
> `Fixed` TERRAIN EDITOR ( TERRAIN EDITOR had been added with more set of tools. )

# Minimum System
> Cpu core i5 8th gen
> 
> Ram: 8 gb
> 
> Graphic Card: 8 gb vram
> 
> Memory Needed: 512 MB ~ 700 MB

---

![HPE Screenshot 1](1.jpg)
![HPE Screenshot 2](2.jpg)

---

## 📦 Installation

```bash
pip install hpe
```

---

## ⚙️ Add Scripts Path to `PATH` (Windows)

If the `hpe` command is not recognized:

1. Locate your Scripts path:
   ```
   C:\Users\<YourName>\AppData\Roaming\Python\Python313\Scripts
   ```
   Replace `<YourName>` with your actual Windows username.

2. Add to PATH:
   - Press **Win + R**, run `sysdm.cpl`
   - Go to **Advanced** tab > **Environment Variables**
   - Under *User variables*, select **Path** > **Edit** > **New** > paste the path
   - Click OK on all windows and restart your terminal

---

## 🚀 Usage

| Command         | Description                          |
|----------------|--------------------------------------|
| `hpe` / `hpe help` | Show help message                 |
| `hpe run`       | Run the main HPE code                |
| `hpe get`       | Copy `hpe.py` to current directory   |

---

### 🧪 Examples

```bash
hpe
```

```bash
hpe run
```

**Output:**
```
Hello from hpe!
This is the main hpe code.
```

```bash
hpe get
```

**Output:**
```
hpe.py copied to: /current/directory/hpe.py
```
