#ifndef GUARD_ae8173bdb67b8ea50ce75c3912841100
#define GUARD_ae8173bdb67b8ea50ce75c3912841100

#define USING_DUNE_PYTHON 1
#include <config.h>
#include <dune/alugrid/dgf.hh>
#include <dune/alugrid/grid.hh>
#include <dune/fem/gridpart/adaptiveleafgridpart.hh>
#include <dune/fem/gridpart/filter/simple.hh>
#include <dune/fem/gridpart/filteredgridpart.hh>
#include <dune/fempy/py/gridview.hh>
#include <dune/python/grid/gridview.hh>
#include <dune/python/grid/hierarchical.hh>
#include <dune/fem/function/localfunction/bindable.hh>
#include <dune/fem/common/intersectionside.hh>
#include <dune/python/pybind11/pybind11.h>
#include <dune/python/pybind11/extensions.h>
#include <dune/fempy/py/grid/gridpart.hh>
#include <dune/common/exceptions.hh>
#include <dune/fempy/py/ufllocalfunction.hh>

namespace UFLLocalFunctions_ae8173bdb67b8ea50ce75c3912841100
{

  // UFLLocalFunction
// ----------------

template< class GridPart >
struct UFLLocalFunction
  : public Dune::Fem::BindableGridFunctionWithSpace<GridPart,Dune::Dim<2>>
{
  typedef GridPart GridPartType;
  typedef typename GridPartType::GridViewType GridView;
  typedef typename GridView::ctype ctype;
  typedef Dune::Fem::BindableGridFunctionWithSpace<GridPart,Dune::Dim<2>> BaseType;
  typedef Dune::Fem::GridFunctionSpace<GridPartType,Dune::Dim<2>> FunctionSpaceType;
  typedef typename GridPartType::template Codim< 0 >::EntityType EntityType;
  typedef typename GridPartType::IntersectionType IntersectionType;
  typedef typename EntityType::Geometry Geometry;
  typedef typename Geometry::GlobalCoordinate GlobalCoordinateType;
  typedef Dune::Fem::IntersectionSide Side;
  typedef std::tuple<> ConstantTupleType;
  typedef std::tuple<> CoefficientTupleType;
  static constexpr bool gridPartValid = true;
  template< std::size_t i >
  using CoefficientType = std::tuple_element_t< i, CoefficientTupleType >;
  template< std::size_t i >
  using ConstantType = typename std::tuple_element_t< i, ConstantTupleType >::element_type;
  using BaseType::entity;
  using BaseType::geometry;

  UFLLocalFunction ( const GridPartType &gridPart, const std::string &name, int order, const Dune::Fem::ParameterReader &parameter = Dune::Fem::Parameter::container() )
    : BaseType(gridPart,name,order)
  {}

  void bind ( const IntersectionType &intersection, Side side )
  {
    BaseType::bind(intersection, side);
  }

  void bind ( const EntityType &entity )
  {
    BaseType::bind(entity);
  }

  void unbind ()
  {
    BaseType::unbind();
  }

  template< class Point >
  void evaluate ( const Point &x, typename FunctionSpaceType::RangeType &result ) const
  {
    using std::max;
    using std::min;
    using std::sqrt;
    GlobalCoordinateType tmp0 = geometry().global( Dune::Fem::coordinate( x ) );
    const auto tmp1 = tmp0[ 1 ] * tmp0[ 1 ];
    const auto tmp2 = tmp0[ 0 ] * tmp0[ 0 ];
    const auto tmp3 = tmp2 + tmp1;
    const auto tmp4 = 1e-10 + tmp3;
    const auto tmp5 = std::sqrt( tmp4 );
    const auto tmp6 = -1.4 + tmp5;
    const auto tmp7 = 1 + tmp0[ 0 ];
    const auto tmp8 = tmp7 * tmp7;
    const auto tmp9 = tmp1 + tmp8;
    const auto tmp10 = 1e-10 + tmp9;
    const auto tmp11 = std::sqrt( tmp10 );
    const auto tmp12 = -0.5 + tmp11;
    const auto tmp13 = -1 + tmp0[ 0 ];
    const auto tmp14 = tmp13 * tmp13;
    const auto tmp15 = tmp1 + tmp14;
    const auto tmp16 = 1e-10 + tmp15;
    const auto tmp17 = std::sqrt( tmp16 );
    const auto tmp18 = -0.5 + tmp17;
    const auto tmp19 = 0.8 + tmp0[ 1 ];
    const auto tmp20 = tmp19 * tmp19;
    const auto tmp21 = tmp2 + tmp20;
    const auto tmp22 = 1e-10 + tmp21;
    const auto tmp23 = std::sqrt( tmp22 );
    const auto tmp24 = -0.5 + tmp23;
    const auto tmp25 = -1 * tmp24;
    const auto tmp26 = -0.8 + tmp0[ 1 ];
    const auto tmp27 = tmp26 * tmp26;
    const auto tmp28 = tmp2 + tmp27;
    const auto tmp29 = 1e-10 + tmp28;
    const auto tmp30 = std::sqrt( tmp29 );
    const auto tmp31 = -0.5 + tmp30;
    const auto tmp32 = -1 * tmp31;
    const auto tmp33 = -1 + tmp5;
    const auto tmp34 = std::max( tmp33, tmp32 );
    const auto tmp35 = std::max( tmp34, tmp25 );
    const auto tmp36 = std::min( tmp35, tmp18 );
    const auto tmp37 = std::min( tmp36, tmp12 );
    const auto tmp38 = std::max( tmp37, tmp6 );
    const auto tmp39 = 2 * tmp5;
    const auto tmp40 = tmp0[ 0 ] + tmp0[ 0 ];
    const auto tmp41 = tmp40 / tmp39;
    const auto tmp42 = tmp41 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp43 = 2 * tmp30;
    const auto tmp44 = tmp40 / tmp43;
    const auto tmp45 = -1 * tmp44;
    const auto tmp46 = -1 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp47 = 1.0 + tmp46;
    const auto tmp48 = tmp47 * tmp45;
    const auto tmp49 = tmp48 + tmp42;
    const auto tmp50 = tmp49 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp51 = 2 * tmp23;
    const auto tmp52 = tmp40 / tmp51;
    const auto tmp53 = -1 * tmp52;
    const auto tmp54 = -1 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp55 = 1.0 + tmp54;
    const auto tmp56 = tmp55 * tmp53;
    const auto tmp57 = tmp56 + tmp50;
    const auto tmp58 = tmp57 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp59 = 2 * tmp17;
    const auto tmp60 = tmp13 + tmp13;
    const auto tmp61 = tmp60 / tmp59;
    const auto tmp62 = -1 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp63 = 1.0 + tmp62;
    const auto tmp64 = tmp63 * tmp61;
    const auto tmp65 = tmp64 + tmp58;
    const auto tmp66 = tmp65 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp67 = 2 * tmp11;
    const auto tmp68 = tmp7 + tmp7;
    const auto tmp69 = tmp68 / tmp67;
    const auto tmp70 = -1 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp71 = 1.0 + tmp70;
    const auto tmp72 = tmp71 * tmp69;
    const auto tmp73 = tmp72 + tmp66;
    const auto tmp74 = tmp73 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp75 = -1 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp76 = 1.0 + tmp75;
    const auto tmp77 = tmp76 * tmp41;
    const auto tmp78 = tmp77 + tmp74;
    const auto tmp79 = -1 * tmp78;
    const auto tmp80 = tmp79 * tmp38;
    const auto tmp81 = -1 * (tmp38 <= 0.0 ? 1 : 0.0);
    const auto tmp82 = 1 + tmp81;
    const auto tmp83 = tmp82 * tmp80;
    const auto tmp84 = tmp0[ 0 ] + tmp83;
    const auto tmp85 = tmp0[ 1 ] + tmp0[ 1 ];
    const auto tmp86 = tmp85 / tmp39;
    const auto tmp87 = tmp86 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp88 = tmp26 + tmp26;
    const auto tmp89 = tmp88 / tmp43;
    const auto tmp90 = -1 * tmp89;
    const auto tmp91 = tmp47 * tmp90;
    const auto tmp92 = tmp91 + tmp87;
    const auto tmp93 = tmp92 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp94 = tmp19 + tmp19;
    const auto tmp95 = tmp94 / tmp51;
    const auto tmp96 = -1 * tmp95;
    const auto tmp97 = tmp55 * tmp96;
    const auto tmp98 = tmp97 + tmp93;
    const auto tmp99 = tmp98 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp100 = tmp85 / tmp59;
    const auto tmp101 = tmp63 * tmp100;
    const auto tmp102 = tmp101 + tmp99;
    const auto tmp103 = tmp102 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp104 = tmp85 / tmp67;
    const auto tmp105 = tmp71 * tmp104;
    const auto tmp106 = tmp105 + tmp103;
    const auto tmp107 = tmp106 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp108 = tmp76 * tmp86;
    const auto tmp109 = tmp108 + tmp107;
    const auto tmp110 = -1 * tmp109;
    const auto tmp111 = tmp110 * tmp38;
    const auto tmp112 = tmp82 * tmp111;
    const auto tmp113 = tmp0[ 1 ] + tmp112;
    result[ 0 ] = tmp84;
    result[ 1 ] = tmp113;
  }

  template< class Point >
  void jacobian ( const Point &x, typename FunctionSpaceType::JacobianRangeType &result ) const
  {
    using std::max;
    using std::min;
    using std::sqrt;
    GlobalCoordinateType tmp0 = geometry().global( Dune::Fem::coordinate( x ) );
    const auto tmp1 = tmp0[ 1 ] * tmp0[ 1 ];
    const auto tmp2 = tmp0[ 0 ] * tmp0[ 0 ];
    const auto tmp3 = tmp2 + tmp1;
    const auto tmp4 = 1e-10 + tmp3;
    const auto tmp5 = std::sqrt( tmp4 );
    const auto tmp6 = -1.4 + tmp5;
    const auto tmp7 = 1 + tmp0[ 0 ];
    const auto tmp8 = tmp7 * tmp7;
    const auto tmp9 = tmp1 + tmp8;
    const auto tmp10 = 1e-10 + tmp9;
    const auto tmp11 = std::sqrt( tmp10 );
    const auto tmp12 = -0.5 + tmp11;
    const auto tmp13 = -1 + tmp0[ 0 ];
    const auto tmp14 = tmp13 * tmp13;
    const auto tmp15 = tmp1 + tmp14;
    const auto tmp16 = 1e-10 + tmp15;
    const auto tmp17 = std::sqrt( tmp16 );
    const auto tmp18 = -0.5 + tmp17;
    const auto tmp19 = 0.8 + tmp0[ 1 ];
    const auto tmp20 = tmp19 * tmp19;
    const auto tmp21 = tmp2 + tmp20;
    const auto tmp22 = 1e-10 + tmp21;
    const auto tmp23 = std::sqrt( tmp22 );
    const auto tmp24 = -0.5 + tmp23;
    const auto tmp25 = -1 * tmp24;
    const auto tmp26 = -0.8 + tmp0[ 1 ];
    const auto tmp27 = tmp26 * tmp26;
    const auto tmp28 = tmp2 + tmp27;
    const auto tmp29 = 1e-10 + tmp28;
    const auto tmp30 = std::sqrt( tmp29 );
    const auto tmp31 = -0.5 + tmp30;
    const auto tmp32 = -1 * tmp31;
    const auto tmp33 = -1 + tmp5;
    const auto tmp34 = std::max( tmp33, tmp32 );
    const auto tmp35 = std::max( tmp34, tmp25 );
    const auto tmp36 = std::min( tmp35, tmp18 );
    const auto tmp37 = std::min( tmp36, tmp12 );
    const auto tmp38 = std::max( tmp37, tmp6 );
    const auto tmp39 = 2 * tmp5;
    const auto tmp40 = tmp0[ 0 ] + tmp0[ 0 ];
    const auto tmp41 = tmp40 / tmp39;
    const auto tmp42 = 2 * tmp41;
    const auto tmp43 = tmp42 * tmp41;
    const auto tmp44 = -1 * tmp43;
    const auto tmp45 = 2 + tmp44;
    const auto tmp46 = tmp45 / tmp39;
    const auto tmp47 = tmp46 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp48 = 2 * tmp30;
    const auto tmp49 = tmp40 / tmp48;
    const auto tmp50 = 2 * tmp49;
    const auto tmp51 = tmp50 * tmp49;
    const auto tmp52 = -1 * tmp51;
    const auto tmp53 = 2 + tmp52;
    const auto tmp54 = tmp53 / tmp48;
    const auto tmp55 = -1 * tmp54;
    const auto tmp56 = -1 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp57 = 1.0 + tmp56;
    const auto tmp58 = tmp57 * tmp55;
    const auto tmp59 = tmp58 + tmp47;
    const auto tmp60 = tmp59 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp61 = 2 * tmp23;
    const auto tmp62 = tmp40 / tmp61;
    const auto tmp63 = 2 * tmp62;
    const auto tmp64 = tmp63 * tmp62;
    const auto tmp65 = -1 * tmp64;
    const auto tmp66 = 2 + tmp65;
    const auto tmp67 = tmp66 / tmp61;
    const auto tmp68 = -1 * tmp67;
    const auto tmp69 = -1 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp70 = 1.0 + tmp69;
    const auto tmp71 = tmp70 * tmp68;
    const auto tmp72 = tmp71 + tmp60;
    const auto tmp73 = tmp72 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp74 = 2 * tmp17;
    const auto tmp75 = tmp13 + tmp13;
    const auto tmp76 = tmp75 / tmp74;
    const auto tmp77 = 2 * tmp76;
    const auto tmp78 = tmp77 * tmp76;
    const auto tmp79 = -1 * tmp78;
    const auto tmp80 = 2 + tmp79;
    const auto tmp81 = tmp80 / tmp74;
    const auto tmp82 = -1 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp83 = 1.0 + tmp82;
    const auto tmp84 = tmp83 * tmp81;
    const auto tmp85 = tmp84 + tmp73;
    const auto tmp86 = tmp85 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp87 = 2 * tmp11;
    const auto tmp88 = tmp7 + tmp7;
    const auto tmp89 = tmp88 / tmp87;
    const auto tmp90 = 2 * tmp89;
    const auto tmp91 = tmp90 * tmp89;
    const auto tmp92 = -1 * tmp91;
    const auto tmp93 = 2 + tmp92;
    const auto tmp94 = tmp93 / tmp87;
    const auto tmp95 = -1 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp96 = 1.0 + tmp95;
    const auto tmp97 = tmp96 * tmp94;
    const auto tmp98 = tmp97 + tmp86;
    const auto tmp99 = tmp98 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp100 = -1 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp101 = 1.0 + tmp100;
    const auto tmp102 = tmp101 * tmp46;
    const auto tmp103 = tmp102 + tmp99;
    const auto tmp104 = -1 * tmp103;
    const auto tmp105 = tmp104 * tmp38;
    const auto tmp106 = tmp41 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp107 = -1 * tmp49;
    const auto tmp108 = tmp57 * tmp107;
    const auto tmp109 = tmp108 + tmp106;
    const auto tmp110 = tmp109 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp111 = -1 * tmp62;
    const auto tmp112 = tmp70 * tmp111;
    const auto tmp113 = tmp112 + tmp110;
    const auto tmp114 = tmp113 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp115 = tmp83 * tmp76;
    const auto tmp116 = tmp115 + tmp114;
    const auto tmp117 = tmp116 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp118 = tmp96 * tmp89;
    const auto tmp119 = tmp118 + tmp117;
    const auto tmp120 = tmp119 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp121 = tmp101 * tmp41;
    const auto tmp122 = tmp121 + tmp120;
    const auto tmp123 = -1 * tmp122;
    const auto tmp124 = tmp122 * tmp123;
    const auto tmp125 = tmp124 + tmp105;
    const auto tmp126 = -1 * (tmp38 <= 0.0 ? 1 : 0.0);
    const auto tmp127 = 1 + tmp126;
    const auto tmp128 = tmp127 * tmp125;
    const auto tmp129 = 1 + tmp128;
    const auto tmp130 = tmp0[ 1 ] + tmp0[ 1 ];
    const auto tmp131 = tmp130 / tmp39;
    const auto tmp132 = 2 * tmp131;
    const auto tmp133 = tmp132 * tmp41;
    const auto tmp134 = -1 * tmp133;
    const auto tmp135 = tmp134 / tmp39;
    const auto tmp136 = tmp135 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp137 = tmp26 + tmp26;
    const auto tmp138 = tmp137 / tmp48;
    const auto tmp139 = 2 * tmp138;
    const auto tmp140 = tmp139 * tmp49;
    const auto tmp141 = -1 * tmp140;
    const auto tmp142 = tmp141 / tmp48;
    const auto tmp143 = -1 * tmp142;
    const auto tmp144 = tmp57 * tmp143;
    const auto tmp145 = tmp144 + tmp136;
    const auto tmp146 = tmp145 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp147 = tmp19 + tmp19;
    const auto tmp148 = tmp147 / tmp61;
    const auto tmp149 = 2 * tmp148;
    const auto tmp150 = tmp149 * tmp62;
    const auto tmp151 = -1 * tmp150;
    const auto tmp152 = tmp151 / tmp61;
    const auto tmp153 = -1 * tmp152;
    const auto tmp154 = tmp70 * tmp153;
    const auto tmp155 = tmp154 + tmp146;
    const auto tmp156 = tmp155 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp157 = tmp130 / tmp74;
    const auto tmp158 = 2 * tmp157;
    const auto tmp159 = tmp158 * tmp76;
    const auto tmp160 = -1 * tmp159;
    const auto tmp161 = tmp160 / tmp74;
    const auto tmp162 = tmp83 * tmp161;
    const auto tmp163 = tmp162 + tmp156;
    const auto tmp164 = tmp163 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp165 = tmp130 / tmp87;
    const auto tmp166 = 2 * tmp165;
    const auto tmp167 = tmp166 * tmp89;
    const auto tmp168 = -1 * tmp167;
    const auto tmp169 = tmp168 / tmp87;
    const auto tmp170 = tmp96 * tmp169;
    const auto tmp171 = tmp170 + tmp164;
    const auto tmp172 = tmp171 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp173 = tmp101 * tmp135;
    const auto tmp174 = tmp173 + tmp172;
    const auto tmp175 = -1 * tmp174;
    const auto tmp176 = tmp175 * tmp38;
    const auto tmp177 = tmp131 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp178 = -1 * tmp138;
    const auto tmp179 = tmp57 * tmp178;
    const auto tmp180 = tmp179 + tmp177;
    const auto tmp181 = tmp180 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp182 = -1 * tmp148;
    const auto tmp183 = tmp70 * tmp182;
    const auto tmp184 = tmp183 + tmp181;
    const auto tmp185 = tmp184 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp186 = tmp83 * tmp157;
    const auto tmp187 = tmp186 + tmp185;
    const auto tmp188 = tmp187 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp189 = tmp96 * tmp165;
    const auto tmp190 = tmp189 + tmp188;
    const auto tmp191 = tmp190 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp192 = tmp101 * tmp131;
    const auto tmp193 = tmp192 + tmp191;
    const auto tmp194 = tmp193 * tmp123;
    const auto tmp195 = tmp194 + tmp176;
    const auto tmp196 = tmp127 * tmp195;
    const auto tmp197 = tmp42 * tmp131;
    const auto tmp198 = -1 * tmp197;
    const auto tmp199 = tmp198 / tmp39;
    const auto tmp200 = tmp199 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp201 = tmp50 * tmp138;
    const auto tmp202 = -1 * tmp201;
    const auto tmp203 = tmp202 / tmp48;
    const auto tmp204 = -1 * tmp203;
    const auto tmp205 = tmp57 * tmp204;
    const auto tmp206 = tmp205 + tmp200;
    const auto tmp207 = tmp206 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp208 = tmp63 * tmp148;
    const auto tmp209 = -1 * tmp208;
    const auto tmp210 = tmp209 / tmp61;
    const auto tmp211 = -1 * tmp210;
    const auto tmp212 = tmp70 * tmp211;
    const auto tmp213 = tmp212 + tmp207;
    const auto tmp214 = tmp213 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp215 = tmp77 * tmp157;
    const auto tmp216 = -1 * tmp215;
    const auto tmp217 = tmp216 / tmp74;
    const auto tmp218 = tmp83 * tmp217;
    const auto tmp219 = tmp218 + tmp214;
    const auto tmp220 = tmp219 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp221 = tmp90 * tmp165;
    const auto tmp222 = -1 * tmp221;
    const auto tmp223 = tmp222 / tmp87;
    const auto tmp224 = tmp96 * tmp223;
    const auto tmp225 = tmp224 + tmp220;
    const auto tmp226 = tmp225 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp227 = tmp101 * tmp199;
    const auto tmp228 = tmp227 + tmp226;
    const auto tmp229 = -1 * tmp228;
    const auto tmp230 = tmp229 * tmp38;
    const auto tmp231 = -1 * tmp193;
    const auto tmp232 = tmp122 * tmp231;
    const auto tmp233 = tmp232 + tmp230;
    const auto tmp234 = tmp127 * tmp233;
    const auto tmp235 = tmp132 * tmp131;
    const auto tmp236 = -1 * tmp235;
    const auto tmp237 = 2 + tmp236;
    const auto tmp238 = tmp237 / tmp39;
    const auto tmp239 = tmp238 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp240 = tmp139 * tmp138;
    const auto tmp241 = -1 * tmp240;
    const auto tmp242 = 2 + tmp241;
    const auto tmp243 = tmp242 / tmp48;
    const auto tmp244 = -1 * tmp243;
    const auto tmp245 = tmp57 * tmp244;
    const auto tmp246 = tmp245 + tmp239;
    const auto tmp247 = tmp246 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp248 = tmp149 * tmp148;
    const auto tmp249 = -1 * tmp248;
    const auto tmp250 = 2 + tmp249;
    const auto tmp251 = tmp250 / tmp61;
    const auto tmp252 = -1 * tmp251;
    const auto tmp253 = tmp70 * tmp252;
    const auto tmp254 = tmp253 + tmp247;
    const auto tmp255 = tmp254 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp256 = tmp158 * tmp157;
    const auto tmp257 = -1 * tmp256;
    const auto tmp258 = 2 + tmp257;
    const auto tmp259 = tmp258 / tmp74;
    const auto tmp260 = tmp83 * tmp259;
    const auto tmp261 = tmp260 + tmp255;
    const auto tmp262 = tmp261 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp263 = tmp166 * tmp165;
    const auto tmp264 = -1 * tmp263;
    const auto tmp265 = 2 + tmp264;
    const auto tmp266 = tmp265 / tmp87;
    const auto tmp267 = tmp96 * tmp266;
    const auto tmp268 = tmp267 + tmp262;
    const auto tmp269 = tmp268 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp270 = tmp101 * tmp238;
    const auto tmp271 = tmp270 + tmp269;
    const auto tmp272 = -1 * tmp271;
    const auto tmp273 = tmp272 * tmp38;
    const auto tmp274 = tmp193 * tmp231;
    const auto tmp275 = tmp274 + tmp273;
    const auto tmp276 = tmp127 * tmp275;
    const auto tmp277 = 1 + tmp276;
    (result[ 0 ])[ 0 ] = tmp129;
    (result[ 0 ])[ 1 ] = tmp196;
    (result[ 1 ])[ 0 ] = tmp234;
    (result[ 1 ])[ 1 ] = tmp277;
  }

  template< class Point >
  void hessian ( const Point &x, typename FunctionSpaceType::HessianRangeType &result ) const
  {
    using std::max;
    using std::min;
    using std::sqrt;
    GlobalCoordinateType tmp0 = geometry().global( Dune::Fem::coordinate( x ) );
    const auto tmp1 = tmp0[ 1 ] * tmp0[ 1 ];
    const auto tmp2 = tmp0[ 0 ] * tmp0[ 0 ];
    const auto tmp3 = tmp2 + tmp1;
    const auto tmp4 = 1e-10 + tmp3;
    const auto tmp5 = std::sqrt( tmp4 );
    const auto tmp6 = -1.4 + tmp5;
    const auto tmp7 = 1 + tmp0[ 0 ];
    const auto tmp8 = tmp7 * tmp7;
    const auto tmp9 = tmp1 + tmp8;
    const auto tmp10 = 1e-10 + tmp9;
    const auto tmp11 = std::sqrt( tmp10 );
    const auto tmp12 = -0.5 + tmp11;
    const auto tmp13 = -1 + tmp0[ 0 ];
    const auto tmp14 = tmp13 * tmp13;
    const auto tmp15 = tmp1 + tmp14;
    const auto tmp16 = 1e-10 + tmp15;
    const auto tmp17 = std::sqrt( tmp16 );
    const auto tmp18 = -0.5 + tmp17;
    const auto tmp19 = 0.8 + tmp0[ 1 ];
    const auto tmp20 = tmp19 * tmp19;
    const auto tmp21 = tmp2 + tmp20;
    const auto tmp22 = 1e-10 + tmp21;
    const auto tmp23 = std::sqrt( tmp22 );
    const auto tmp24 = -0.5 + tmp23;
    const auto tmp25 = -1 * tmp24;
    const auto tmp26 = -0.8 + tmp0[ 1 ];
    const auto tmp27 = tmp26 * tmp26;
    const auto tmp28 = tmp2 + tmp27;
    const auto tmp29 = 1e-10 + tmp28;
    const auto tmp30 = std::sqrt( tmp29 );
    const auto tmp31 = -0.5 + tmp30;
    const auto tmp32 = -1 * tmp31;
    const auto tmp33 = -1 + tmp5;
    const auto tmp34 = std::max( tmp33, tmp32 );
    const auto tmp35 = std::max( tmp34, tmp25 );
    const auto tmp36 = std::min( tmp35, tmp18 );
    const auto tmp37 = std::min( tmp36, tmp12 );
    const auto tmp38 = std::max( tmp37, tmp6 );
    const auto tmp39 = -1 * (tmp38 <= 0.0 ? 1 : 0.0);
    const auto tmp40 = 1 + tmp39;
    const auto tmp41 = 2 * tmp5;
    const auto tmp42 = tmp0[ 0 ] + tmp0[ 0 ];
    const auto tmp43 = tmp42 / tmp41;
    const auto tmp44 = 2 * tmp43;
    const auto tmp45 = tmp44 * tmp43;
    const auto tmp46 = -1 * tmp45;
    const auto tmp47 = 2 + tmp46;
    const auto tmp48 = tmp47 / tmp41;
    const auto tmp49 = tmp44 * tmp48;
    const auto tmp50 = -1 * tmp49;
    const auto tmp51 = 2 * tmp48;
    const auto tmp52 = tmp51 * tmp43;
    const auto tmp53 = tmp52 + tmp49;
    const auto tmp54 = -1 * tmp53;
    const auto tmp55 = tmp54 + tmp50;
    const auto tmp56 = tmp55 / tmp41;
    const auto tmp57 = tmp56 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp58 = 2 * tmp30;
    const auto tmp59 = tmp42 / tmp58;
    const auto tmp60 = 2 * tmp59;
    const auto tmp61 = tmp60 * tmp59;
    const auto tmp62 = -1 * tmp61;
    const auto tmp63 = 2 + tmp62;
    const auto tmp64 = tmp63 / tmp58;
    const auto tmp65 = tmp60 * tmp64;
    const auto tmp66 = -1 * tmp65;
    const auto tmp67 = 2 * tmp64;
    const auto tmp68 = tmp67 * tmp59;
    const auto tmp69 = tmp68 + tmp65;
    const auto tmp70 = -1 * tmp69;
    const auto tmp71 = tmp70 + tmp66;
    const auto tmp72 = tmp71 / tmp58;
    const auto tmp73 = -1 * tmp72;
    const auto tmp74 = -1 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp75 = 1.0 + tmp74;
    const auto tmp76 = tmp75 * tmp73;
    const auto tmp77 = tmp76 + tmp57;
    const auto tmp78 = tmp77 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp79 = 2 * tmp23;
    const auto tmp80 = tmp42 / tmp79;
    const auto tmp81 = 2 * tmp80;
    const auto tmp82 = tmp81 * tmp80;
    const auto tmp83 = -1 * tmp82;
    const auto tmp84 = 2 + tmp83;
    const auto tmp85 = tmp84 / tmp79;
    const auto tmp86 = tmp81 * tmp85;
    const auto tmp87 = -1 * tmp86;
    const auto tmp88 = 2 * tmp85;
    const auto tmp89 = tmp88 * tmp80;
    const auto tmp90 = tmp89 + tmp86;
    const auto tmp91 = -1 * tmp90;
    const auto tmp92 = tmp91 + tmp87;
    const auto tmp93 = tmp92 / tmp79;
    const auto tmp94 = -1 * tmp93;
    const auto tmp95 = -1 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp96 = 1.0 + tmp95;
    const auto tmp97 = tmp96 * tmp94;
    const auto tmp98 = tmp97 + tmp78;
    const auto tmp99 = tmp98 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp100 = 2 * tmp17;
    const auto tmp101 = tmp13 + tmp13;
    const auto tmp102 = tmp101 / tmp100;
    const auto tmp103 = 2 * tmp102;
    const auto tmp104 = tmp103 * tmp102;
    const auto tmp105 = -1 * tmp104;
    const auto tmp106 = 2 + tmp105;
    const auto tmp107 = tmp106 / tmp100;
    const auto tmp108 = tmp103 * tmp107;
    const auto tmp109 = -1 * tmp108;
    const auto tmp110 = 2 * tmp107;
    const auto tmp111 = tmp110 * tmp102;
    const auto tmp112 = tmp111 + tmp108;
    const auto tmp113 = -1 * tmp112;
    const auto tmp114 = tmp113 + tmp109;
    const auto tmp115 = tmp114 / tmp100;
    const auto tmp116 = -1 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp117 = 1.0 + tmp116;
    const auto tmp118 = tmp117 * tmp115;
    const auto tmp119 = tmp118 + tmp99;
    const auto tmp120 = tmp119 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp121 = 2 * tmp11;
    const auto tmp122 = tmp7 + tmp7;
    const auto tmp123 = tmp122 / tmp121;
    const auto tmp124 = 2 * tmp123;
    const auto tmp125 = tmp124 * tmp123;
    const auto tmp126 = -1 * tmp125;
    const auto tmp127 = 2 + tmp126;
    const auto tmp128 = tmp127 / tmp121;
    const auto tmp129 = tmp124 * tmp128;
    const auto tmp130 = -1 * tmp129;
    const auto tmp131 = 2 * tmp128;
    const auto tmp132 = tmp131 * tmp123;
    const auto tmp133 = tmp132 + tmp129;
    const auto tmp134 = -1 * tmp133;
    const auto tmp135 = tmp134 + tmp130;
    const auto tmp136 = tmp135 / tmp121;
    const auto tmp137 = -1 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp138 = 1.0 + tmp137;
    const auto tmp139 = tmp138 * tmp136;
    const auto tmp140 = tmp139 + tmp120;
    const auto tmp141 = tmp140 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp142 = -1 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp143 = 1.0 + tmp142;
    const auto tmp144 = tmp143 * tmp56;
    const auto tmp145 = tmp144 + tmp141;
    const auto tmp146 = -1 * tmp145;
    const auto tmp147 = tmp146 * tmp38;
    const auto tmp148 = tmp48 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp149 = -1 * tmp64;
    const auto tmp150 = tmp75 * tmp149;
    const auto tmp151 = tmp150 + tmp148;
    const auto tmp152 = tmp151 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp153 = -1 * tmp85;
    const auto tmp154 = tmp96 * tmp153;
    const auto tmp155 = tmp154 + tmp152;
    const auto tmp156 = tmp155 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp157 = tmp117 * tmp107;
    const auto tmp158 = tmp157 + tmp156;
    const auto tmp159 = tmp158 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp160 = tmp138 * tmp128;
    const auto tmp161 = tmp160 + tmp159;
    const auto tmp162 = tmp161 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp163 = tmp143 * tmp48;
    const auto tmp164 = tmp163 + tmp162;
    const auto tmp165 = -1 * tmp164;
    const auto tmp166 = tmp43 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp167 = -1 * tmp59;
    const auto tmp168 = tmp75 * tmp167;
    const auto tmp169 = tmp168 + tmp166;
    const auto tmp170 = tmp169 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp171 = -1 * tmp80;
    const auto tmp172 = tmp96 * tmp171;
    const auto tmp173 = tmp172 + tmp170;
    const auto tmp174 = tmp173 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp175 = tmp117 * tmp102;
    const auto tmp176 = tmp175 + tmp174;
    const auto tmp177 = tmp176 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp178 = tmp138 * tmp123;
    const auto tmp179 = tmp178 + tmp177;
    const auto tmp180 = tmp179 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp181 = tmp143 * tmp43;
    const auto tmp182 = tmp181 + tmp180;
    const auto tmp183 = tmp182 * tmp165;
    const auto tmp184 = tmp183 + tmp147;
    const auto tmp185 = -1 * tmp182;
    const auto tmp186 = tmp164 * tmp185;
    const auto tmp187 = tmp186 + tmp183;
    const auto tmp188 = tmp187 + tmp184;
    const auto tmp189 = tmp188 * tmp40;
    const auto tmp190 = tmp0[ 1 ] + tmp0[ 1 ];
    const auto tmp191 = tmp190 / tmp41;
    const auto tmp192 = 2 * tmp191;
    const auto tmp193 = tmp192 * tmp48;
    const auto tmp194 = -1 * tmp193;
    const auto tmp195 = tmp192 * tmp43;
    const auto tmp196 = -1 * tmp195;
    const auto tmp197 = tmp196 / tmp41;
    const auto tmp198 = tmp44 * tmp197;
    const auto tmp199 = 2 * tmp197;
    const auto tmp200 = tmp199 * tmp43;
    const auto tmp201 = tmp200 + tmp198;
    const auto tmp202 = -1 * tmp201;
    const auto tmp203 = tmp202 + tmp194;
    const auto tmp204 = tmp203 / tmp41;
    const auto tmp205 = tmp204 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp206 = tmp26 + tmp26;
    const auto tmp207 = tmp206 / tmp58;
    const auto tmp208 = 2 * tmp207;
    const auto tmp209 = tmp208 * tmp64;
    const auto tmp210 = -1 * tmp209;
    const auto tmp211 = tmp208 * tmp59;
    const auto tmp212 = -1 * tmp211;
    const auto tmp213 = tmp212 / tmp58;
    const auto tmp214 = tmp60 * tmp213;
    const auto tmp215 = 2 * tmp213;
    const auto tmp216 = tmp215 * tmp59;
    const auto tmp217 = tmp216 + tmp214;
    const auto tmp218 = -1 * tmp217;
    const auto tmp219 = tmp218 + tmp210;
    const auto tmp220 = tmp219 / tmp58;
    const auto tmp221 = -1 * tmp220;
    const auto tmp222 = tmp75 * tmp221;
    const auto tmp223 = tmp222 + tmp205;
    const auto tmp224 = tmp223 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp225 = tmp19 + tmp19;
    const auto tmp226 = tmp225 / tmp79;
    const auto tmp227 = 2 * tmp226;
    const auto tmp228 = tmp227 * tmp85;
    const auto tmp229 = -1 * tmp228;
    const auto tmp230 = tmp227 * tmp80;
    const auto tmp231 = -1 * tmp230;
    const auto tmp232 = tmp231 / tmp79;
    const auto tmp233 = tmp81 * tmp232;
    const auto tmp234 = 2 * tmp232;
    const auto tmp235 = tmp234 * tmp80;
    const auto tmp236 = tmp235 + tmp233;
    const auto tmp237 = -1 * tmp236;
    const auto tmp238 = tmp237 + tmp229;
    const auto tmp239 = tmp238 / tmp79;
    const auto tmp240 = -1 * tmp239;
    const auto tmp241 = tmp96 * tmp240;
    const auto tmp242 = tmp241 + tmp224;
    const auto tmp243 = tmp242 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp244 = tmp190 / tmp100;
    const auto tmp245 = 2 * tmp244;
    const auto tmp246 = tmp245 * tmp107;
    const auto tmp247 = -1 * tmp246;
    const auto tmp248 = tmp245 * tmp102;
    const auto tmp249 = -1 * tmp248;
    const auto tmp250 = tmp249 / tmp100;
    const auto tmp251 = tmp103 * tmp250;
    const auto tmp252 = 2 * tmp250;
    const auto tmp253 = tmp252 * tmp102;
    const auto tmp254 = tmp253 + tmp251;
    const auto tmp255 = -1 * tmp254;
    const auto tmp256 = tmp255 + tmp247;
    const auto tmp257 = tmp256 / tmp100;
    const auto tmp258 = tmp117 * tmp257;
    const auto tmp259 = tmp258 + tmp243;
    const auto tmp260 = tmp259 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp261 = tmp190 / tmp121;
    const auto tmp262 = 2 * tmp261;
    const auto tmp263 = tmp262 * tmp128;
    const auto tmp264 = -1 * tmp263;
    const auto tmp265 = tmp262 * tmp123;
    const auto tmp266 = -1 * tmp265;
    const auto tmp267 = tmp266 / tmp121;
    const auto tmp268 = tmp124 * tmp267;
    const auto tmp269 = 2 * tmp267;
    const auto tmp270 = tmp269 * tmp123;
    const auto tmp271 = tmp270 + tmp268;
    const auto tmp272 = -1 * tmp271;
    const auto tmp273 = tmp272 + tmp264;
    const auto tmp274 = tmp273 / tmp121;
    const auto tmp275 = tmp138 * tmp274;
    const auto tmp276 = tmp275 + tmp260;
    const auto tmp277 = tmp276 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp278 = tmp143 * tmp204;
    const auto tmp279 = tmp278 + tmp277;
    const auto tmp280 = -1 * tmp279;
    const auto tmp281 = tmp280 * tmp38;
    const auto tmp282 = tmp191 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp283 = -1 * tmp207;
    const auto tmp284 = tmp75 * tmp283;
    const auto tmp285 = tmp284 + tmp282;
    const auto tmp286 = tmp285 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp287 = -1 * tmp226;
    const auto tmp288 = tmp96 * tmp287;
    const auto tmp289 = tmp288 + tmp286;
    const auto tmp290 = tmp289 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp291 = tmp117 * tmp244;
    const auto tmp292 = tmp291 + tmp290;
    const auto tmp293 = tmp292 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp294 = tmp138 * tmp261;
    const auto tmp295 = tmp294 + tmp293;
    const auto tmp296 = tmp295 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp297 = tmp143 * tmp191;
    const auto tmp298 = tmp297 + tmp296;
    const auto tmp299 = tmp298 * tmp165;
    const auto tmp300 = tmp299 + tmp281;
    const auto tmp301 = tmp197 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp302 = -1 * tmp213;
    const auto tmp303 = tmp75 * tmp302;
    const auto tmp304 = tmp303 + tmp301;
    const auto tmp305 = tmp304 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp306 = -1 * tmp232;
    const auto tmp307 = tmp96 * tmp306;
    const auto tmp308 = tmp307 + tmp305;
    const auto tmp309 = tmp308 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp310 = tmp117 * tmp250;
    const auto tmp311 = tmp310 + tmp309;
    const auto tmp312 = tmp311 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp313 = tmp138 * tmp267;
    const auto tmp314 = tmp313 + tmp312;
    const auto tmp315 = tmp314 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp316 = tmp143 * tmp197;
    const auto tmp317 = tmp316 + tmp315;
    const auto tmp318 = -1 * tmp317;
    const auto tmp319 = tmp182 * tmp318;
    const auto tmp320 = tmp317 * tmp185;
    const auto tmp321 = tmp320 + tmp319;
    const auto tmp322 = tmp321 + tmp300;
    const auto tmp323 = tmp322 * tmp40;
    const auto tmp324 = -1 * tmp198;
    const auto tmp325 = tmp44 * tmp191;
    const auto tmp326 = -1 * tmp325;
    const auto tmp327 = tmp326 / tmp41;
    const auto tmp328 = 2 * tmp327;
    const auto tmp329 = tmp328 * tmp43;
    const auto tmp330 = tmp329 + tmp193;
    const auto tmp331 = -1 * tmp330;
    const auto tmp332 = tmp331 + tmp324;
    const auto tmp333 = tmp332 / tmp41;
    const auto tmp334 = tmp333 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp335 = -1 * tmp214;
    const auto tmp336 = tmp60 * tmp207;
    const auto tmp337 = -1 * tmp336;
    const auto tmp338 = tmp337 / tmp58;
    const auto tmp339 = 2 * tmp338;
    const auto tmp340 = tmp339 * tmp59;
    const auto tmp341 = tmp340 + tmp209;
    const auto tmp342 = -1 * tmp341;
    const auto tmp343 = tmp342 + tmp335;
    const auto tmp344 = tmp343 / tmp58;
    const auto tmp345 = -1 * tmp344;
    const auto tmp346 = tmp75 * tmp345;
    const auto tmp347 = tmp346 + tmp334;
    const auto tmp348 = tmp347 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp349 = -1 * tmp233;
    const auto tmp350 = tmp81 * tmp226;
    const auto tmp351 = -1 * tmp350;
    const auto tmp352 = tmp351 / tmp79;
    const auto tmp353 = 2 * tmp352;
    const auto tmp354 = tmp353 * tmp80;
    const auto tmp355 = tmp354 + tmp228;
    const auto tmp356 = -1 * tmp355;
    const auto tmp357 = tmp356 + tmp349;
    const auto tmp358 = tmp357 / tmp79;
    const auto tmp359 = -1 * tmp358;
    const auto tmp360 = tmp96 * tmp359;
    const auto tmp361 = tmp360 + tmp348;
    const auto tmp362 = tmp361 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp363 = -1 * tmp251;
    const auto tmp364 = tmp103 * tmp244;
    const auto tmp365 = -1 * tmp364;
    const auto tmp366 = tmp365 / tmp100;
    const auto tmp367 = 2 * tmp366;
    const auto tmp368 = tmp367 * tmp102;
    const auto tmp369 = tmp368 + tmp246;
    const auto tmp370 = -1 * tmp369;
    const auto tmp371 = tmp370 + tmp363;
    const auto tmp372 = tmp371 / tmp100;
    const auto tmp373 = tmp117 * tmp372;
    const auto tmp374 = tmp373 + tmp362;
    const auto tmp375 = tmp374 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp376 = -1 * tmp268;
    const auto tmp377 = tmp124 * tmp261;
    const auto tmp378 = -1 * tmp377;
    const auto tmp379 = tmp378 / tmp121;
    const auto tmp380 = 2 * tmp379;
    const auto tmp381 = tmp380 * tmp123;
    const auto tmp382 = tmp381 + tmp263;
    const auto tmp383 = -1 * tmp382;
    const auto tmp384 = tmp383 + tmp376;
    const auto tmp385 = tmp384 / tmp121;
    const auto tmp386 = tmp138 * tmp385;
    const auto tmp387 = tmp386 + tmp375;
    const auto tmp388 = tmp387 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp389 = tmp143 * tmp333;
    const auto tmp390 = tmp389 + tmp388;
    const auto tmp391 = -1 * tmp390;
    const auto tmp392 = tmp391 * tmp38;
    const auto tmp393 = tmp319 + tmp392;
    const auto tmp394 = tmp327 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp395 = -1 * tmp338;
    const auto tmp396 = tmp75 * tmp395;
    const auto tmp397 = tmp396 + tmp394;
    const auto tmp398 = tmp397 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp399 = -1 * tmp352;
    const auto tmp400 = tmp96 * tmp399;
    const auto tmp401 = tmp400 + tmp398;
    const auto tmp402 = tmp401 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp403 = tmp117 * tmp366;
    const auto tmp404 = tmp403 + tmp402;
    const auto tmp405 = tmp404 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp406 = tmp138 * tmp379;
    const auto tmp407 = tmp406 + tmp405;
    const auto tmp408 = tmp407 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp409 = tmp143 * tmp327;
    const auto tmp410 = tmp409 + tmp408;
    const auto tmp411 = tmp410 * tmp185;
    const auto tmp412 = tmp411 + tmp299;
    const auto tmp413 = tmp412 + tmp393;
    const auto tmp414 = tmp413 * tmp40;
    const auto tmp415 = tmp192 * tmp197;
    const auto tmp416 = -1 * tmp415;
    const auto tmp417 = tmp192 * tmp191;
    const auto tmp418 = -1 * tmp417;
    const auto tmp419 = 2 + tmp418;
    const auto tmp420 = tmp419 / tmp41;
    const auto tmp421 = 2 * tmp420;
    const auto tmp422 = tmp421 * tmp43;
    const auto tmp423 = tmp422 + tmp415;
    const auto tmp424 = -1 * tmp423;
    const auto tmp425 = tmp424 + tmp416;
    const auto tmp426 = tmp425 / tmp41;
    const auto tmp427 = tmp426 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp428 = tmp208 * tmp213;
    const auto tmp429 = -1 * tmp428;
    const auto tmp430 = tmp208 * tmp207;
    const auto tmp431 = -1 * tmp430;
    const auto tmp432 = 2 + tmp431;
    const auto tmp433 = tmp432 / tmp58;
    const auto tmp434 = 2 * tmp433;
    const auto tmp435 = tmp434 * tmp59;
    const auto tmp436 = tmp435 + tmp428;
    const auto tmp437 = -1 * tmp436;
    const auto tmp438 = tmp437 + tmp429;
    const auto tmp439 = tmp438 / tmp58;
    const auto tmp440 = -1 * tmp439;
    const auto tmp441 = tmp75 * tmp440;
    const auto tmp442 = tmp441 + tmp427;
    const auto tmp443 = tmp442 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp444 = tmp227 * tmp232;
    const auto tmp445 = -1 * tmp444;
    const auto tmp446 = tmp227 * tmp226;
    const auto tmp447 = -1 * tmp446;
    const auto tmp448 = 2 + tmp447;
    const auto tmp449 = tmp448 / tmp79;
    const auto tmp450 = 2 * tmp449;
    const auto tmp451 = tmp450 * tmp80;
    const auto tmp452 = tmp451 + tmp444;
    const auto tmp453 = -1 * tmp452;
    const auto tmp454 = tmp453 + tmp445;
    const auto tmp455 = tmp454 / tmp79;
    const auto tmp456 = -1 * tmp455;
    const auto tmp457 = tmp96 * tmp456;
    const auto tmp458 = tmp457 + tmp443;
    const auto tmp459 = tmp458 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp460 = tmp245 * tmp250;
    const auto tmp461 = -1 * tmp460;
    const auto tmp462 = tmp245 * tmp244;
    const auto tmp463 = -1 * tmp462;
    const auto tmp464 = 2 + tmp463;
    const auto tmp465 = tmp464 / tmp100;
    const auto tmp466 = 2 * tmp465;
    const auto tmp467 = tmp466 * tmp102;
    const auto tmp468 = tmp467 + tmp460;
    const auto tmp469 = -1 * tmp468;
    const auto tmp470 = tmp469 + tmp461;
    const auto tmp471 = tmp470 / tmp100;
    const auto tmp472 = tmp117 * tmp471;
    const auto tmp473 = tmp472 + tmp459;
    const auto tmp474 = tmp473 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp475 = tmp262 * tmp267;
    const auto tmp476 = -1 * tmp475;
    const auto tmp477 = tmp262 * tmp261;
    const auto tmp478 = -1 * tmp477;
    const auto tmp479 = 2 + tmp478;
    const auto tmp480 = tmp479 / tmp121;
    const auto tmp481 = 2 * tmp480;
    const auto tmp482 = tmp481 * tmp123;
    const auto tmp483 = tmp482 + tmp475;
    const auto tmp484 = -1 * tmp483;
    const auto tmp485 = tmp484 + tmp476;
    const auto tmp486 = tmp485 / tmp121;
    const auto tmp487 = tmp138 * tmp486;
    const auto tmp488 = tmp487 + tmp474;
    const auto tmp489 = tmp488 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp490 = tmp143 * tmp426;
    const auto tmp491 = tmp490 + tmp489;
    const auto tmp492 = -1 * tmp491;
    const auto tmp493 = tmp492 * tmp38;
    const auto tmp494 = tmp298 * tmp318;
    const auto tmp495 = tmp494 + tmp493;
    const auto tmp496 = tmp420 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp497 = -1 * tmp433;
    const auto tmp498 = tmp75 * tmp497;
    const auto tmp499 = tmp498 + tmp496;
    const auto tmp500 = tmp499 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp501 = -1 * tmp449;
    const auto tmp502 = tmp96 * tmp501;
    const auto tmp503 = tmp502 + tmp500;
    const auto tmp504 = tmp503 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp505 = tmp117 * tmp465;
    const auto tmp506 = tmp505 + tmp504;
    const auto tmp507 = tmp506 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp508 = tmp138 * tmp480;
    const auto tmp509 = tmp508 + tmp507;
    const auto tmp510 = tmp509 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp511 = tmp143 * tmp420;
    const auto tmp512 = tmp511 + tmp510;
    const auto tmp513 = tmp512 * tmp185;
    const auto tmp514 = tmp513 + tmp494;
    const auto tmp515 = tmp514 + tmp495;
    const auto tmp516 = tmp515 * tmp40;
    const auto tmp517 = tmp44 * tmp327;
    const auto tmp518 = -1 * tmp517;
    const auto tmp519 = tmp51 * tmp191;
    const auto tmp520 = tmp519 + tmp517;
    const auto tmp521 = -1 * tmp520;
    const auto tmp522 = tmp521 + tmp518;
    const auto tmp523 = tmp522 / tmp41;
    const auto tmp524 = tmp523 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp525 = tmp60 * tmp338;
    const auto tmp526 = -1 * tmp525;
    const auto tmp527 = tmp67 * tmp207;
    const auto tmp528 = tmp527 + tmp525;
    const auto tmp529 = -1 * tmp528;
    const auto tmp530 = tmp529 + tmp526;
    const auto tmp531 = tmp530 / tmp58;
    const auto tmp532 = -1 * tmp531;
    const auto tmp533 = tmp75 * tmp532;
    const auto tmp534 = tmp533 + tmp524;
    const auto tmp535 = tmp534 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp536 = tmp81 * tmp352;
    const auto tmp537 = -1 * tmp536;
    const auto tmp538 = tmp88 * tmp226;
    const auto tmp539 = tmp538 + tmp536;
    const auto tmp540 = -1 * tmp539;
    const auto tmp541 = tmp540 + tmp537;
    const auto tmp542 = tmp541 / tmp79;
    const auto tmp543 = -1 * tmp542;
    const auto tmp544 = tmp96 * tmp543;
    const auto tmp545 = tmp544 + tmp535;
    const auto tmp546 = tmp545 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp547 = tmp103 * tmp366;
    const auto tmp548 = -1 * tmp547;
    const auto tmp549 = tmp110 * tmp244;
    const auto tmp550 = tmp549 + tmp547;
    const auto tmp551 = -1 * tmp550;
    const auto tmp552 = tmp551 + tmp548;
    const auto tmp553 = tmp552 / tmp100;
    const auto tmp554 = tmp117 * tmp553;
    const auto tmp555 = tmp554 + tmp546;
    const auto tmp556 = tmp555 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp557 = tmp124 * tmp379;
    const auto tmp558 = -1 * tmp557;
    const auto tmp559 = tmp131 * tmp261;
    const auto tmp560 = tmp559 + tmp557;
    const auto tmp561 = -1 * tmp560;
    const auto tmp562 = tmp561 + tmp558;
    const auto tmp563 = tmp562 / tmp121;
    const auto tmp564 = tmp138 * tmp563;
    const auto tmp565 = tmp564 + tmp556;
    const auto tmp566 = tmp565 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp567 = tmp143 * tmp523;
    const auto tmp568 = tmp567 + tmp566;
    const auto tmp569 = -1 * tmp568;
    const auto tmp570 = tmp569 * tmp38;
    const auto tmp571 = -1 * tmp410;
    const auto tmp572 = tmp182 * tmp571;
    const auto tmp573 = tmp572 + tmp570;
    const auto tmp574 = -1 * tmp298;
    const auto tmp575 = tmp164 * tmp574;
    const auto tmp576 = tmp575 + tmp572;
    const auto tmp577 = tmp576 + tmp573;
    const auto tmp578 = tmp577 * tmp40;
    const auto tmp579 = tmp192 * tmp327;
    const auto tmp580 = -1 * tmp579;
    const auto tmp581 = tmp44 * tmp420;
    const auto tmp582 = tmp199 * tmp191;
    const auto tmp583 = tmp582 + tmp581;
    const auto tmp584 = -1 * tmp583;
    const auto tmp585 = tmp584 + tmp580;
    const auto tmp586 = tmp585 / tmp41;
    const auto tmp587 = tmp586 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp588 = tmp208 * tmp338;
    const auto tmp589 = -1 * tmp588;
    const auto tmp590 = tmp60 * tmp433;
    const auto tmp591 = tmp215 * tmp207;
    const auto tmp592 = tmp591 + tmp590;
    const auto tmp593 = -1 * tmp592;
    const auto tmp594 = tmp593 + tmp589;
    const auto tmp595 = tmp594 / tmp58;
    const auto tmp596 = -1 * tmp595;
    const auto tmp597 = tmp75 * tmp596;
    const auto tmp598 = tmp597 + tmp587;
    const auto tmp599 = tmp598 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp600 = tmp227 * tmp352;
    const auto tmp601 = -1 * tmp600;
    const auto tmp602 = tmp81 * tmp449;
    const auto tmp603 = tmp234 * tmp226;
    const auto tmp604 = tmp603 + tmp602;
    const auto tmp605 = -1 * tmp604;
    const auto tmp606 = tmp605 + tmp601;
    const auto tmp607 = tmp606 / tmp79;
    const auto tmp608 = -1 * tmp607;
    const auto tmp609 = tmp96 * tmp608;
    const auto tmp610 = tmp609 + tmp599;
    const auto tmp611 = tmp610 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp612 = tmp245 * tmp366;
    const auto tmp613 = -1 * tmp612;
    const auto tmp614 = tmp103 * tmp465;
    const auto tmp615 = tmp252 * tmp244;
    const auto tmp616 = tmp615 + tmp614;
    const auto tmp617 = -1 * tmp616;
    const auto tmp618 = tmp617 + tmp613;
    const auto tmp619 = tmp618 / tmp100;
    const auto tmp620 = tmp117 * tmp619;
    const auto tmp621 = tmp620 + tmp611;
    const auto tmp622 = tmp621 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp623 = tmp262 * tmp379;
    const auto tmp624 = -1 * tmp623;
    const auto tmp625 = tmp124 * tmp480;
    const auto tmp626 = tmp269 * tmp261;
    const auto tmp627 = tmp626 + tmp625;
    const auto tmp628 = -1 * tmp627;
    const auto tmp629 = tmp628 + tmp624;
    const auto tmp630 = tmp629 / tmp121;
    const auto tmp631 = tmp138 * tmp630;
    const auto tmp632 = tmp631 + tmp622;
    const auto tmp633 = tmp632 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp634 = tmp143 * tmp586;
    const auto tmp635 = tmp634 + tmp633;
    const auto tmp636 = -1 * tmp635;
    const auto tmp637 = tmp636 * tmp38;
    const auto tmp638 = tmp298 * tmp571;
    const auto tmp639 = tmp638 + tmp637;
    const auto tmp640 = -1 * tmp512;
    const auto tmp641 = tmp182 * tmp640;
    const auto tmp642 = tmp317 * tmp574;
    const auto tmp643 = tmp642 + tmp641;
    const auto tmp644 = tmp643 + tmp639;
    const auto tmp645 = tmp644 * tmp40;
    const auto tmp646 = -1 * tmp581;
    const auto tmp647 = tmp328 * tmp191;
    const auto tmp648 = tmp647 + tmp579;
    const auto tmp649 = -1 * tmp648;
    const auto tmp650 = tmp649 + tmp646;
    const auto tmp651 = tmp650 / tmp41;
    const auto tmp652 = tmp651 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp653 = -1 * tmp590;
    const auto tmp654 = tmp339 * tmp207;
    const auto tmp655 = tmp654 + tmp588;
    const auto tmp656 = -1 * tmp655;
    const auto tmp657 = tmp656 + tmp653;
    const auto tmp658 = tmp657 / tmp58;
    const auto tmp659 = -1 * tmp658;
    const auto tmp660 = tmp75 * tmp659;
    const auto tmp661 = tmp660 + tmp652;
    const auto tmp662 = tmp661 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp663 = -1 * tmp602;
    const auto tmp664 = tmp353 * tmp226;
    const auto tmp665 = tmp664 + tmp600;
    const auto tmp666 = -1 * tmp665;
    const auto tmp667 = tmp666 + tmp663;
    const auto tmp668 = tmp667 / tmp79;
    const auto tmp669 = -1 * tmp668;
    const auto tmp670 = tmp96 * tmp669;
    const auto tmp671 = tmp670 + tmp662;
    const auto tmp672 = tmp671 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp673 = -1 * tmp614;
    const auto tmp674 = tmp367 * tmp244;
    const auto tmp675 = tmp674 + tmp612;
    const auto tmp676 = -1 * tmp675;
    const auto tmp677 = tmp676 + tmp673;
    const auto tmp678 = tmp677 / tmp100;
    const auto tmp679 = tmp117 * tmp678;
    const auto tmp680 = tmp679 + tmp672;
    const auto tmp681 = tmp680 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp682 = -1 * tmp625;
    const auto tmp683 = tmp380 * tmp261;
    const auto tmp684 = tmp683 + tmp623;
    const auto tmp685 = -1 * tmp684;
    const auto tmp686 = tmp685 + tmp682;
    const auto tmp687 = tmp686 / tmp121;
    const auto tmp688 = tmp138 * tmp687;
    const auto tmp689 = tmp688 + tmp681;
    const auto tmp690 = tmp689 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp691 = tmp143 * tmp651;
    const auto tmp692 = tmp691 + tmp690;
    const auto tmp693 = -1 * tmp692;
    const auto tmp694 = tmp693 * tmp38;
    const auto tmp695 = tmp641 + tmp694;
    const auto tmp696 = tmp410 * tmp574;
    const auto tmp697 = tmp696 + tmp638;
    const auto tmp698 = tmp697 + tmp695;
    const auto tmp699 = tmp698 * tmp40;
    const auto tmp700 = tmp192 * tmp420;
    const auto tmp701 = -1 * tmp700;
    const auto tmp702 = tmp421 * tmp191;
    const auto tmp703 = tmp702 + tmp700;
    const auto tmp704 = -1 * tmp703;
    const auto tmp705 = tmp704 + tmp701;
    const auto tmp706 = tmp705 / tmp41;
    const auto tmp707 = tmp706 * (tmp33 > tmp32 ? 1 : 0.0);
    const auto tmp708 = tmp208 * tmp433;
    const auto tmp709 = -1 * tmp708;
    const auto tmp710 = tmp434 * tmp207;
    const auto tmp711 = tmp710 + tmp708;
    const auto tmp712 = -1 * tmp711;
    const auto tmp713 = tmp712 + tmp709;
    const auto tmp714 = tmp713 / tmp58;
    const auto tmp715 = -1 * tmp714;
    const auto tmp716 = tmp75 * tmp715;
    const auto tmp717 = tmp716 + tmp707;
    const auto tmp718 = tmp717 * (tmp34 > tmp25 ? 1 : 0.0);
    const auto tmp719 = tmp227 * tmp449;
    const auto tmp720 = -1 * tmp719;
    const auto tmp721 = tmp450 * tmp226;
    const auto tmp722 = tmp721 + tmp719;
    const auto tmp723 = -1 * tmp722;
    const auto tmp724 = tmp723 + tmp720;
    const auto tmp725 = tmp724 / tmp79;
    const auto tmp726 = -1 * tmp725;
    const auto tmp727 = tmp96 * tmp726;
    const auto tmp728 = tmp727 + tmp718;
    const auto tmp729 = tmp728 * (tmp35 < tmp18 ? 1 : 0.0);
    const auto tmp730 = tmp245 * tmp465;
    const auto tmp731 = -1 * tmp730;
    const auto tmp732 = tmp466 * tmp244;
    const auto tmp733 = tmp732 + tmp730;
    const auto tmp734 = -1 * tmp733;
    const auto tmp735 = tmp734 + tmp731;
    const auto tmp736 = tmp735 / tmp100;
    const auto tmp737 = tmp117 * tmp736;
    const auto tmp738 = tmp737 + tmp729;
    const auto tmp739 = tmp738 * (tmp36 < tmp12 ? 1 : 0.0);
    const auto tmp740 = tmp262 * tmp480;
    const auto tmp741 = -1 * tmp740;
    const auto tmp742 = tmp481 * tmp261;
    const auto tmp743 = tmp742 + tmp740;
    const auto tmp744 = -1 * tmp743;
    const auto tmp745 = tmp744 + tmp741;
    const auto tmp746 = tmp745 / tmp121;
    const auto tmp747 = tmp138 * tmp746;
    const auto tmp748 = tmp747 + tmp739;
    const auto tmp749 = tmp748 * (tmp37 > tmp6 ? 1 : 0.0);
    const auto tmp750 = tmp143 * tmp706;
    const auto tmp751 = tmp750 + tmp749;
    const auto tmp752 = -1 * tmp751;
    const auto tmp753 = tmp752 * tmp38;
    const auto tmp754 = tmp298 * tmp640;
    const auto tmp755 = tmp754 + tmp753;
    const auto tmp756 = tmp512 * tmp574;
    const auto tmp757 = tmp756 + tmp754;
    const auto tmp758 = tmp757 + tmp755;
    const auto tmp759 = tmp758 * tmp40;
    ((result[ 0 ])[ 0 ])[ 0 ] = tmp189;
    ((result[ 0 ])[ 0 ])[ 1 ] = tmp323;
    ((result[ 0 ])[ 1 ])[ 0 ] = tmp414;
    ((result[ 0 ])[ 1 ])[ 1 ] = tmp516;
    ((result[ 1 ])[ 0 ])[ 0 ] = tmp578;
    ((result[ 1 ])[ 0 ])[ 1 ] = tmp645;
    ((result[ 1 ])[ 1 ])[ 0 ] = tmp699;
    ((result[ 1 ])[ 1 ])[ 1 ] = tmp759;
  }

  template< std::size_t i >
  const ConstantType< i > &constant () const
  {
    return *std::get< i >( constants_ );
  }

  template< std::size_t i >
  ConstantType< i > &constant ()
  {
    return *std::get< i >( constants_ );
  }
  ConstantTupleType constants_;
  std::tuple<  > coefficients_;
};

} // namespace UFLLocalFunctions_ae8173bdb67b8ea50ce75c3912841100

PYBIND11_MODULE( localfunction_ae8173bdb67b8ea50ce75c3912841100_a524c1196983e65de1c06d7d6afdeb44, module )
{
  typedef UFLLocalFunctions_ae8173bdb67b8ea50ce75c3912841100::UFLLocalFunction< typename Dune::FemPy::GridPart< Dune::Fem::FilteredGridPart< Dune::FemPy::GridPart< Dune::Fem::AdaptiveLeafGridPart< Dune::ALUGrid< 2, 2, Dune::simplex > > >, Dune::Fem::SimpleFilter< Dune::FemPy::GridPart< Dune::Fem::AdaptiveLeafGridPart< Dune::ALUGrid< 2, 2, Dune::simplex > > > >, true > > > LocalFunctionType;
  if constexpr( LocalFunctionType::gridPartValid )
  {
      auto cls = Dune::Python::insertClass<LocalFunctionType>(module,"UFLLocalFunction",Dune::Python::GenerateTypeName("UFLLocalFunctions_ae8173bdb67b8ea50ce75c3912841100::UFLLocalFunction< typename Dune::FemPy::GridPart< Dune::Fem::FilteredGridPart< Dune::FemPy::GridPart< Dune::Fem::AdaptiveLeafGridPart< Dune::ALUGrid< 2, 2, Dune::simplex > > >, Dune::Fem::SimpleFilter< Dune::FemPy::GridPart< Dune::Fem::AdaptiveLeafGridPart< Dune::ALUGrid< 2, 2, Dune::simplex > > > >, true > > >"), Dune::Python::IncludeFiles({"python/dune/generated/localfunction_ae8173bdb67b8ea50ce75c3912841100_a524c1196983e65de1c06d7d6afdeb44.cc"})).first;
      Dune::FemPy::registerUFLLocalFunction( module, cls );
      cls.def( pybind11::init( [] ( pybind11::object gridView, const std::string &name, int order ) {return new LocalFunctionType( Dune::FemPy::gridPart<Dune::Fem::FilteredGridPart< Dune::FemPy::GridPart< Dune::Fem::AdaptiveLeafGridPart< Dune::ALUGrid< 2, 2, Dune::simplex > > >, Dune::Fem::SimpleFilter< Dune::FemPy::GridPart< Dune::Fem::AdaptiveLeafGridPart< Dune::ALUGrid< 2, 2, Dune::simplex > > > >, true >>(gridView),name,order); } ), pybind11::keep_alive< 1, 2 >() );
      cls.def_property_readonly( "virtualized", [] ( LocalFunctionType& ) -> bool { return true;});
  }
}

#endif
