# UiPath LangChain Python SDK

[![PyPI downloads](https://img.shields.io/pypi/dm/uipath-langchain.svg)](https://pypi.org/project/uipath-langchain/)
[![Python versions](https://img.shields.io/pypi/pyversions/uipath-langchain.svg)](https://pypi.org/project/uipath-langchain/)

A Python SDK that enables developers to build and deploy LangGraph agents to the UiPath Cloud Platform. This package provides programmatic interaction with UiPath Cloud Platform services and human-in-the-loop (HITL) semantics through Action Center integration.

This package is an extension to the [UiPath Python SDK](https://github.com/UiPath/uipath-python).

This [quickstart guide](https://uipath.github.io/uipath-python/) walks you through deploying your first agent to UiPath Cloud Platform.

Check out these [sample projects](https://github.com/UiPath/uipath-langchain-python/tree/main/samples) to see the SDK in action.

## Requirements

-   Python 3.10 or higher
-   UiPath Automation Cloud account

## Installation

```bash
pip install uipath-langchain
```

using `uv`:

```bash
uv add uipath-langchain
```

## Configuration

### Environment Variables

Create a `.env` file in your project root with the following variables:

```
UIPATH_URL=https://cloud.uipath.com/ACCOUNT_NAME/TENANT_NAME
UIPATH_ACCESS_TOKEN=YOUR_TOKEN_HERE
```

## Command Line Interface (CLI)

The SDK provides a command-line interface for creating, packaging, and deploying LangGraph Agents:

### Initialize a Project

```bash
uipath init [GRAPH]
```

Creates a `uipath.json` configuration file for your project. If `[GRAPH]` is omitted, it will create an entrypoint for each graph specified in the `langgraph.json` file.

### Authentication

```bash
uipath auth
```

This command opens a browser for authentication and creates/updates your `.env` file with the proper credentials.

### Debug a Project

```bash
uipath run GRAPH [INPUT]
```

Executes the agent with the provided JSON input arguments.

### Package a Project

```bash
uipath pack
```

Packages your project into a `.nupkg` file that can be deployed to UiPath.

**Note:** Your `pyproject.toml` must include:

-   A description field (avoid characters: &, <, >, ", ', ;)
-   Author information

Example:

```toml
description = "Your package description"
authors = [{name = "Your Name", email = "your.email@example.com"}]
```

### Publish a Package

```bash
uipath publish
```

Publishes the most recently created package to your UiPath Orchestrator.

## Project Structure

To properly use the CLI for packaging and publishing, your project should include:

-   A `pyproject.toml` file with project metadata
-   A `langgraph.json` file
-   A `uipath.json` file (generated by `uipath init`)
-   Any Python files needed for your automation

## Development

### Setting Up a Development Environment

Please read our [contribution guidelines](https://github.com/UiPath/uipath-langchain-python/blob/main/CONTRIBUTING.md) before submitting a pull request.
