# Project Samples

## [Multi agent supervisor, researcher, coder](multi-agent-supervisor-researcher-coder)
This sample showcases a multi-agent system, involving a supervisor, a researcher, and a coder working in coordination to tackle complex tasks.

## [Multi agent planner, researcher, coder distributed](multi-agent-planner-researcher-coder-distributed)
Here, a multi-agent system breaks down complex tasks into discreet steps, routing them to specialized agents. Each agent operates **independently** and can be deployed as a separate process. The system includes a planner, researcher, and coder agent.

## [RAG-quiz-generator](RAG-quiz-generator)
The RAG Sample project demonstrates the implementation of a Retrieval-Augmented Generation (RAG) system using [UiPath Context Grounding](https://docs.uipath.com/automation-cloud/automation-cloud/latest/admin-guide/about-context-grounding).

## [Retrieval chain](retrieval-chain)
This example shows how to retrieve relevant documents for a query, using the UiPath Context Grounding vectorstore. It also integrates this into a Langchain retrieval chain for response formulation.

## [Simple local MCP](simple-local-mcp)
This sample shows how to create an agent using LangGraph with multiple tool servers via the MCP (Model Context Protocol) standard.

## [Simple remote MCP](simple-remote-mcp)
This sample demonstrates the creation of an agent using LangGraph, which connects to a remote MCP (Model Context Protocol) Server.

## [Ticket classification](ticket-classification)
This sample demonstrates automatic classification of support tickets into categories. It includes a human approval step via UiPath Action Center.
