# --------------------------------------------------------------------------
# ⚠️ WARNING - AUTO-GENERATED CODE - DO NOT EDIT ⚠️
# ⚙️ Generated by 'python -m opgen'
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License.
# --------------------------------------------------------------------------
# pylint: disable=W0221,W0222,R0901,W0237
# mypy: disable-error-code=override
# ruff: noqa: N801,E741
# ruff: noqa: D214,D402,D405,D411,D412,D416,D417
# --------------------------------------------------------------------------

from __future__ import annotations

from typing import Optional, Sequence, TypeVar, Union

from onnx.defs import get_schema
from typing_extensions import TypeAlias

from onnxscript.onnx_opset._impl.opset17 import Opset17
from onnxscript.onnx_types import (
    BFLOAT16,
    BOOL,
    COMPLEX64,
    COMPLEX128,
    DOUBLE,
    FLOAT,
    FLOAT16,
    INT8,
    INT16,
    INT32,
    INT64,
    STRING,
    UINT8,
    UINT16,
    UINT32,
    UINT64,
)
from onnxscript.values import Op, Opset


class Opset18(Opset17):
    def __new__(cls):
        return Opset.__new__(cls, "", 18)

    T_BitwiseAnd = TypeVar(
        "T_BitwiseAnd", INT16, INT32, INT64, INT8, UINT16, UINT32, UINT64, UINT8
    )

    def BitwiseAnd(self, A: T_BitwiseAnd, B: T_BitwiseAnd) -> T_BitwiseAnd:
        r"""[🌐 BitwiseAnd(18)](https://onnx.ai/onnx/operators/onnx__BitwiseAnd.html#bitwiseand-18 "Online Documentation")


        Returns the tensor resulting from performing the bitwise `and` operation
        elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

        This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check `Broadcasting in ONNX <https://github.com/onnx/onnx/blob/master/docs/Broadcasting.md>`_.


        Args:
            A: (non-differentiable) First input operand for the bitwise operator.

            B: (non-differentiable) Second input operand for the bitwise operator.
        """

        schema = get_schema("BitwiseAnd", 18, "")
        op = Op(self, "BitwiseAnd", schema)
        return op(*self._prepare_inputs(schema, A, B))

    T_BitwiseNot = TypeVar(
        "T_BitwiseNot", INT16, INT32, INT64, INT8, UINT16, UINT32, UINT64, UINT8
    )

    def BitwiseNot(self, X: T_BitwiseNot) -> T_BitwiseNot:
        r"""[🌐 BitwiseNot(18)](https://onnx.ai/onnx/operators/onnx__BitwiseNot.html#bitwisenot-18 "Online Documentation")


        Returns the bitwise not of the input tensor element-wise.


        Args:
            X: (non-differentiable) Input tensor
        """

        schema = get_schema("BitwiseNot", 18, "")
        op = Op(self, "BitwiseNot", schema)
        return op(*self._prepare_inputs(schema, X))

    T_BitwiseOr = TypeVar(
        "T_BitwiseOr", INT16, INT32, INT64, INT8, UINT16, UINT32, UINT64, UINT8
    )

    def BitwiseOr(self, A: T_BitwiseOr, B: T_BitwiseOr) -> T_BitwiseOr:
        r"""[🌐 BitwiseOr(18)](https://onnx.ai/onnx/operators/onnx__BitwiseOr.html#bitwiseor-18 "Online Documentation")


        Returns the tensor resulting from performing the bitwise `or` operation
        elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

        This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check `Broadcasting in ONNX <https://github.com/onnx/onnx/blob/master/docs/Broadcasting.md>`_.


        Args:
            A: (non-differentiable) First input operand for the bitwise operator.

            B: (non-differentiable) Second input operand for the bitwise operator.
        """

        schema = get_schema("BitwiseOr", 18, "")
        op = Op(self, "BitwiseOr", schema)
        return op(*self._prepare_inputs(schema, A, B))

    T_BitwiseXor = TypeVar(
        "T_BitwiseXor", INT16, INT32, INT64, INT8, UINT16, UINT32, UINT64, UINT8
    )

    def BitwiseXor(self, A: T_BitwiseXor, B: T_BitwiseXor) -> T_BitwiseXor:
        r"""[🌐 BitwiseXor(18)](https://onnx.ai/onnx/operators/onnx__BitwiseXor.html#bitwisexor-18 "Online Documentation")


        Returns the tensor resulting from performing the bitwise `xor` operation
        elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

        This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check `Broadcasting in ONNX <https://github.com/onnx/onnx/blob/master/docs/Broadcasting.md>`_.


        Args:
            A: (non-differentiable) First input operand for the bitwise operator.

            B: (non-differentiable) Second input operand for the bitwise operator.
        """

        schema = get_schema("BitwiseXor", 18, "")
        op = Op(self, "BitwiseXor", schema)
        return op(*self._prepare_inputs(schema, A, B))

    T_CenterCropPad = TypeVar(
        "T_CenterCropPad",
        BFLOAT16,
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    Tind_CenterCropPad = TypeVar("Tind_CenterCropPad", INT32, INT64)

    def CenterCropPad(
        self,
        input_data: T_CenterCropPad,
        shape: Tind_CenterCropPad,
        *,
        axes: Optional[Sequence[int]] = None,
    ) -> T_CenterCropPad:
        r"""[🌐 CenterCropPad(18)](https://onnx.ai/onnx/operators/onnx__CenterCropPad.html#centercroppad-18 "Online Documentation")


        Center crop or pad an input to given dimensions.

        The crop/pad dimensions can be specified for a subset of the `axes`; unspecified dimensions will remain unchanged.

        If the input dimensions are larger than the target crop dimensions, a centered cropping window will be extracted
        from the input. The starting value for the cropping window is rounded down, which means that if the difference
        between the input shape and the crop shape is odd, the cropping window will be shifted half a pixel to the left
        of the input center.

        If the input dimensions are smaller than the target crop dimensions, the input will be padded equally on both sides
        to center it in the output. In cases where the total number of padding pixels is odd, an additional pixel will be
        added to the right side.

        The padding value used is zero.


        Args:
            input_data: (differentiable) Input to extract the centered crop from.

            shape: (non-differentiable) 1-D tensor representing the cropping window
                dimensions.

            axes: If provided, it specifies a subset of axes that 'shape' refer to. If
                not provided, all axes are assumed [0, 1, ..., r-1], where r =
                rank(data). Negative value means counting dimensions from the back.
                Accepted range is [-r, r-1], where r = rank(data). Behavior is undefined
                if an axis is repeated.
        """

        schema = get_schema("CenterCropPad", 18, "")
        op = Op(self, "CenterCropPad", schema)
        return op(*self._prepare_inputs(schema, input_data, shape), axes=axes)

    T_Col2Im = TypeVar(
        "T_Col2Im",
        BFLOAT16,
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    def Col2Im(
        self,
        input: T_Col2Im,
        image_shape: INT64,
        block_shape: INT64,
        *,
        dilations: Optional[Sequence[int]] = None,
        pads: Optional[Sequence[int]] = None,
        strides: Optional[Sequence[int]] = None,
    ) -> T_Col2Im:
        r"""[🌐 Col2Im(18)](https://onnx.ai/onnx/operators/onnx__Col2Im.html#col2im-18 "Online Documentation")


        The operator rearranges column blocks back into a multidimensional image

        Col2Im behaves similarly to PyTorch's fold https://pytorch.org/docs/stable/generated/torch.nn.Fold.html,
        but it only supports *batched* multi-dimensional image tensors.
        Another implementation in Python with N-dimension support can be found at https://github.com/f-dangel/unfoldNd/.

        NOTE:
          Although specifying image_shape looks redundant because it could be calculated from
          convolution formulas, it is required as input for more advanced scenarios as explained
          at PyTorch's implementation (https://github.com/pytorch/pytorch/blob/master/aten/src/ATen/native/Col2Im.cpp#L10)


        Args:
            input: (differentiable) Input data tensor to be rearranged from column
                blocks back into an image. This is a 3-dimensional tensor containing [N,
                C * n-ary-product(block_shape), L], where N is batch dimension, C is
                image channel dimension and L is number of blocks.The blocks are
                enumerated in increasing lexicographic-order of their indices.For
                example, with an image-size 10*20 and block-size 9*18, there would be
                2*3 blocks, enumerated in the order block(0, 0), block(0, 1), block(0,
                2), block(1, 0), block(1, 1), block(1, 2).

            image_shape: (non-differentiable) The shape of the spatial dimensions of the
                image after rearranging the column blocks.This is a 1-dimensional tensor
                with size of at least 2, containing the value [H_img, W_img]  for a 2-D
                image or [dim_i1, dim_i2, ..., dim_iN] for a N-D image.

            block_shape: (non-differentiable) The shape of the block to apply on the
                input.This is a 1-dimensional tensor of size of at least 2, containing
                the value [H_block, W_block]  for a 2-D image or [dim_b1, dim_b2, ...,
                dim_bN] for a N-D block.This is the block-shape before dilation is
                applied to it.

            dilations: 1-dimensional tensor with dilation value along each spatial axis
                of the image. If not present, the dilation defaults to 1 along each
                spatial axis of the image.

            pads: 1-dimensional tensor with padding value for the beginning and ending
                along each spatial axis, it can take any value greater than or equal to
                0. The value represent the number of pixels added to the beginning and
                end part of the corresponding axis. `pads` format should be as follow
                [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin is the number
                of pixels added at the beginning of axis `i` and xi_end is the number of
                pixels added at the end of axis `i`. If not present, the padding
                defaults to 0 along start and end of each spatial axis.

            strides: 1-dimensional tensor with stride value along each spatial axis. If
                not present, the stride defaults to 1 along each spatial axis.
        """

        schema = get_schema("Col2Im", 18, "")
        op = Op(self, "Col2Im", schema)
        return op(
            *self._prepare_inputs(schema, input, image_shape, block_shape),
            dilations=dilations,
            pads=pads,
            strides=strides,
        )

    T_LpPool = TypeVar("T_LpPool", DOUBLE, FLOAT, FLOAT16)

    def LpPool(
        self,
        X: T_LpPool,
        *,
        auto_pad: str = "NOTSET",
        ceil_mode: int = 0,
        dilations: Optional[Sequence[int]] = None,
        kernel_shape: Sequence[int],
        p: int = 2,
        pads: Optional[Sequence[int]] = None,
        strides: Optional[Sequence[int]] = None,
    ) -> T_LpPool:
        r"""[🌐 LpPool(18)](https://onnx.ai/onnx/operators/onnx__LpPool.html#lppool-18 "Online Documentation")


         LpPool consumes an input tensor X and applies Lp pooling across
         the tensor according to kernel sizes, stride sizes, and pad lengths.
         Lp pooling consisting of computing the Lp norm on all values of a subset
         of the input tensor according to the kernel size and downsampling the
         data into the output tensor Y for further processing. The output spatial shape will be following:
         ```
         output_spatial_shape[i] = floor((input_spatial_shape[i] + pad_shape[i] - {kernelSpatialShape}) / strides_spatial_shape[i] + 1)
         ```
         or
         ```
         output_spatial_shape[i] = ceil((input_spatial_shape[i] + pad_shape[i] - {kernelSpatialShape}) / strides_spatial_shape[i] + 1)
         ```
         if ceil_mode is enabled `pad_shape[i]` is the sum of pads along axis `i`.

         `auto_pad` is a DEPRECATED attribute. If you are using them currently, the output spatial shape will be following:
         ```
         VALID: output_spatial_shape[i] = ceil((input_spatial_shape[i] - {kernelSpatialShape} + 1) / strides_spatial_shape[i])
         SAME_UPPER or SAME_LOWER: output_spatial_shape[i] = ceil(input_spatial_shape[i] / strides_spatial_shape[i])
         ```
         And pad shape will be following if `SAME_UPPER` or `SAME_LOWER`:
         ```
         pad_shape[i] = (output_spatial_shape[i] - 1) * strides_spatial_shape[i] + {kernelSpatialShape} - input_spatial_shape[i]
         ```

        Args:
            X: (differentiable) Input data tensor from the previous operator; dimensions
                for image case are (N x C x H x W), where N is the batch size, C is the
                number of channels, and H and W are the height and the width of the
                data. For non image case, the dimensions are in the form of (N x C x D1
                x D2 ... Dn), where N is the batch size.

            auto_pad: auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID.
                Where default value is NOTSET, which means explicit padding is used.
                SAME_UPPER or SAME_LOWER mean pad the input so that `output_shape[i] =
                ceil(input_shape[i] / strides[i])` for each axis `i`. The padding is
                split between the two sides equally or almost equally (depending on
                whether it is even or odd). In case the padding is an odd number, the
                extra padding is added at the end for SAME_UPPER and at the beginning
                for SAME_LOWER.

            ceil_mode: Whether to use ceil or floor (default) to compute the output
                shape.

            dilations: dilation value along each spatial axis of the filter. If not
                present, the dilation defaults is 1 along each spatial axis.

            kernel_shape: The size of the kernel along each axis.

            p: p value of the Lp norm used to pool over the input data.

            pads: Padding for the beginning and ending along each spatial axis, it can
                take any value greater than or equal to 0. The value represent the
                number of pixels added to the beginning and end part of the
                corresponding axis. `pads` format should be as follow [x1_begin,
                x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels
                added at the beginning of axis `i` and xi_end, the number of pixels
                added at the end of axis `i`. This attribute cannot be used
                simultaneously with auto_pad attribute. If not present, the padding
                defaults to 0 along start and end of each spatial axis.

            strides: Stride along each spatial axis. If not present, the stride defaults
                to 1 along each spatial axis.
        """

        schema = get_schema("LpPool", 18, "")
        op = Op(self, "LpPool", schema)
        return op(
            *self._prepare_inputs(schema, X),
            auto_pad=auto_pad,
            ceil_mode=ceil_mode,
            dilations=dilations,
            kernel_shape=kernel_shape,
            p=p,
            pads=pads,
            strides=strides,
        )

    T_Mish = TypeVar("T_Mish", DOUBLE, FLOAT, FLOAT16)

    def Mish(self, X: T_Mish) -> T_Mish:
        r"""[🌐 Mish(18)](https://onnx.ai/onnx/operators/onnx__Mish.html#mish-18 "Online Documentation")


        Mish: A Self Regularized Non-Monotonic Neural Activation Function.

        Perform the linear unit element-wise on the input tensor X using formula:

        ::

            mish(x) = x * tanh(softplus(x)) = x * tanh(ln(1 + e^{x}))




        Args:
            X: (differentiable) Input tensor
        """

        schema = get_schema("Mish", 18, "")
        op = Op(self, "Mish", schema)
        return op(*self._prepare_inputs(schema, X))

    O_OptionalGetElement = TypeVar(
        "O_OptionalGetElement",
        Optional[Sequence[BOOL]],
        Optional[Sequence[COMPLEX128]],
        Optional[Sequence[COMPLEX64]],
        Optional[Sequence[DOUBLE]],
        Optional[Sequence[FLOAT]],
        Optional[Sequence[FLOAT16]],
        Optional[Sequence[INT16]],
        Optional[Sequence[INT32]],
        Optional[Sequence[INT64]],
        Optional[Sequence[INT8]],
        Optional[Sequence[STRING]],
        Optional[Sequence[UINT16]],
        Optional[Sequence[UINT32]],
        Optional[Sequence[UINT64]],
        Optional[Sequence[UINT8]],
        Optional[BOOL],
        Optional[COMPLEX128],
        Optional[COMPLEX64],
        Optional[DOUBLE],
        Optional[FLOAT],
        Optional[FLOAT16],
        Optional[INT16],
        Optional[INT32],
        Optional[INT64],
        Optional[INT8],
        Optional[STRING],
        Optional[UINT16],
        Optional[UINT32],
        Optional[UINT64],
        Optional[UINT8],
        Sequence[BOOL],
        Sequence[COMPLEX128],
        Sequence[COMPLEX64],
        Sequence[DOUBLE],
        Sequence[FLOAT],
        Sequence[FLOAT16],
        Sequence[INT16],
        Sequence[INT32],
        Sequence[INT64],
        Sequence[INT8],
        Sequence[STRING],
        Sequence[UINT16],
        Sequence[UINT32],
        Sequence[UINT64],
        Sequence[UINT8],
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    V_OptionalGetElement: TypeAlias = Union[
        Sequence[BOOL],
        Sequence[COMPLEX128],
        Sequence[COMPLEX64],
        Sequence[DOUBLE],
        Sequence[FLOAT],
        Sequence[FLOAT16],
        Sequence[INT16],
        Sequence[INT32],
        Sequence[INT64],
        Sequence[INT8],
        Sequence[STRING],
        Sequence[UINT16],
        Sequence[UINT32],
        Sequence[UINT64],
        Sequence[UINT8],
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    ]

    def OptionalGetElement(self, input: O_OptionalGetElement) -> V_OptionalGetElement:
        r"""[🌐 OptionalGetElement(18)](https://onnx.ai/onnx/operators/onnx__OptionalGetElement.html#optionalgetelement-18 "Online Documentation")


        If the input is a tensor or sequence type, it returns the input.
        If the input is an optional type, it outputs the element in the input.
        It is an error if the input is an empty optional-type (i.e. does not have an element) and the behavior is undefined in this case.


        Args:
            input: The optional input.
        """

        schema = get_schema("OptionalGetElement", 18, "")
        op = Op(self, "OptionalGetElement", schema)
        return op(*self._prepare_inputs(schema, input))

    O_OptionalHasElement = TypeVar(
        "O_OptionalHasElement",
        Optional[Sequence[BOOL]],
        Optional[Sequence[COMPLEX128]],
        Optional[Sequence[COMPLEX64]],
        Optional[Sequence[DOUBLE]],
        Optional[Sequence[FLOAT]],
        Optional[Sequence[FLOAT16]],
        Optional[Sequence[INT16]],
        Optional[Sequence[INT32]],
        Optional[Sequence[INT64]],
        Optional[Sequence[INT8]],
        Optional[Sequence[STRING]],
        Optional[Sequence[UINT16]],
        Optional[Sequence[UINT32]],
        Optional[Sequence[UINT64]],
        Optional[Sequence[UINT8]],
        Optional[BOOL],
        Optional[COMPLEX128],
        Optional[COMPLEX64],
        Optional[DOUBLE],
        Optional[FLOAT],
        Optional[FLOAT16],
        Optional[INT16],
        Optional[INT32],
        Optional[INT64],
        Optional[INT8],
        Optional[STRING],
        Optional[UINT16],
        Optional[UINT32],
        Optional[UINT64],
        Optional[UINT8],
        Sequence[BOOL],
        Sequence[COMPLEX128],
        Sequence[COMPLEX64],
        Sequence[DOUBLE],
        Sequence[FLOAT],
        Sequence[FLOAT16],
        Sequence[INT16],
        Sequence[INT32],
        Sequence[INT64],
        Sequence[INT8],
        Sequence[STRING],
        Sequence[UINT16],
        Sequence[UINT32],
        Sequence[UINT64],
        Sequence[UINT8],
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    B_OptionalHasElement: TypeAlias = BOOL

    def OptionalHasElement(
        self, input: Optional[O_OptionalHasElement] = None
    ) -> B_OptionalHasElement:
        r"""[🌐 OptionalHasElement(18)](https://onnx.ai/onnx/operators/onnx__OptionalHasElement.html#optionalhaselement-18 "Online Documentation")


        Returns true if (1) the input is an optional-type and contains an element,
        or, (2) the input is a tensor or sequence type.
        If the input is not provided or is an empty optional-type, this op returns false.


        Args:
            input: (optional) The optional input.
        """

        schema = get_schema("OptionalHasElement", 18, "")
        op = Op(self, "OptionalHasElement", schema)
        return op(*self._prepare_inputs(schema, input))

    T_Pad = TypeVar(
        "T_Pad",
        BFLOAT16,
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    Tind_Pad = TypeVar("Tind_Pad", INT32, INT64)

    def Pad(
        self,
        data: T_Pad,
        pads: INT64,
        constant_value: Optional[T_Pad] = None,
        axes: Optional[Tind_Pad] = None,
        *,
        mode: str = "constant",
    ) -> T_Pad:
        r"""[🌐 Pad(18)](https://onnx.ai/onnx/operators/onnx__Pad.html#pad-18 "Online Documentation")


        Given a tensor containing the data to be padded (`data`), a tensor containing the number of start and end pad values for axis (`pads`), (optionally) a `mode`, and (optionally) `constant_value`,
        a padded tensor (`output`) is generated.

        The three supported `modes` are (similar to corresponding modes supported by `numpy.pad`):

        1) `constant`(default) - pads with a given constant value as specified by `constant_value` (which defaults to 0, empty string, or False)

        2) `reflect` - pads with the reflection of the vector mirrored on the first and last values of the vector along each axis

        3) `edge` - pads with the edge values of array


        Example 1 (`constant` mode):

        Insert 0 pads to the beginning of the second dimension.

        ::

            data = [
                [1.0, 1.2],
                [2.3, 3.4],
                [4.5, 5.7],
            ]

            pads = [0, 2, 0, 0]

            mode = 'constant'

            constant_value = 0.0

            output = [
                [0.0, 0.0, 1.0, 1.2],
                [0.0, 0.0, 2.3, 3.4],
                [0.0, 0.0, 4.5, 5.7],
            ]



        Example 2 (`reflect` mode):

        ::

            data = [
                [1.0, 1.2],
                [2.3, 3.4],
                [4.5, 5.7],
            ]

            pads = [0, 2, 0, 0]

            mode = 'reflect'

            output = [
                [1.0, 1.2, 1.0, 1.2],
                [2.3, 3.4, 2.3, 3.4],
                [4.5, 5.7, 4.5, 5.7],
            ]



        Example 3 (`edge` mode):

        ::

            data = [
                [1.0, 1.2],
                [2.3, 3.4],
                [4.5, 5.7],
            ]

            pads = [0, 2, 0, 0]

            mode = 'edge'

            output = [
                [1.0, 1.0, 1.0, 1.2],
                [2.3, 2.3, 2.3, 3.4],
                [4.5, 4.5, 4.5, 5.7],
            ]




        Args:
            data: (differentiable) Input tensor.

            pads: (non-differentiable) Tensor of integers indicating the number of
                padding elements to add or remove (if negative) at the beginning and end
                of each axis. For 2D input tensor, it is the number of pixels. `pads`
                should be a 1D tensor of shape [2 * num_axes] where `num_axes` refers to
                the number of elements in the `axes` input or the input rank if `axes`
                are not provided explicitly. `pads` format should be: [x1_begin,
                x2_begin, ..., x1_end, x2_end,...], where xi_begin is the number of pad
                values added at the beginning of axis `axes[i]` and xi_end, the number
                of pad values added at the end of axis `axes[i]`.

            constant_value: (optional, non-differentiable) (Optional) A scalar value to
                be used if the mode chosen is `constant` (by default it is 0, empty
                string or False).

            axes: (optional, non-differentiable) 1-D tensor of axes that `pads` apply
                to. Negative value means counting dimensions from the back. Accepted
                range is [-r, r-1] where r = rank(data). Behavior is undefined if an
                axis is repeated. If not provided, all axes are assumed (`[0, 1, ...,
                input_rank-1]`).

            mode: Supported modes: `constant`(default), `reflect`, `edge`
        """

        schema = get_schema("Pad", 18, "")
        op = Op(self, "Pad", schema)
        return op(*self._prepare_inputs(schema, data, pads, constant_value, axes), mode=mode)

    T_ReduceL1 = TypeVar(
        "T_ReduceL1", BFLOAT16, DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64
    )

    def ReduceL1(
        self,
        data: T_ReduceL1,
        axes: Optional[INT64] = None,
        *,
        keepdims: int = 1,
        noop_with_empty_axes: int = 0,
    ) -> T_ReduceL1:
        r"""[🌐 ReduceL1(18)](https://onnx.ai/onnx/operators/onnx__ReduceL1.html#reducel1-18 "Online Documentation")


        Computes the L1 norm of the input tensor's elements along the provided axes. The resulting
        tensor has the same rank as the input if `keepdims` equals 1. If `keepdims` equals 0, then
        the resulting tensor has the reduced dimension pruned. Input tensors of rank zero are
        valid. Reduction over an empty set of values yields 0.


        The above behavior is similar to numpy, with the exception that numpy defaults `keepdims`
        to `False` instead of `True`.

        Args:
            data: (differentiable) An input tensor.

            axes: (optional, non-differentiable) Optional input list of integers, along
                which to reduce. The default is to reduce over all the dimensions of the
                input tensor if 'noop_with_empty_axes' is false, else act as an Identity
                op when 'noop_with_empty_axes' is true. Accepted range is [-r, r-1]
                where r = rank(data).

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.

            noop_with_empty_axes: Defines behavior if 'axes' is empty. Default behavior
                with 'false' is to reduce all axes. When axes is empty and this
                attribute is set to true, input tensor will not be reduced,and the
                output tensor would be equivalent to input tensor.
        """

        schema = get_schema("ReduceL1", 18, "")
        op = Op(self, "ReduceL1", schema)
        return op(
            *self._prepare_inputs(schema, data, axes),
            keepdims=keepdims,
            noop_with_empty_axes=noop_with_empty_axes,
        )

    T_ReduceL2 = TypeVar(
        "T_ReduceL2", BFLOAT16, DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64
    )

    def ReduceL2(
        self,
        data: T_ReduceL2,
        axes: Optional[INT64] = None,
        *,
        keepdims: int = 1,
        noop_with_empty_axes: int = 0,
    ) -> T_ReduceL2:
        r"""[🌐 ReduceL2(18)](https://onnx.ai/onnx/operators/onnx__ReduceL2.html#reducel2-18 "Online Documentation")


        Computes the L2 norm of the input tensor's elements along the provided axes. The resulting
        tensor has the same rank as the input if `keepdims` equals 1. If `keepdims` equals 0, then
        the resulting tensor has the reduced dimension pruned. Input tensors of rank zero are
        valid. Reduction over an empty set of values yields 0.


        The above behavior is similar to numpy, with the exception that numpy defaults `keepdims`
        to `False` instead of `True`.

        Args:
            data: (differentiable) An input tensor.

            axes: (optional, non-differentiable) Optional input list of integers, along
                which to reduce. The default is to reduce over all the dimensions of the
                input tensor if 'noop_with_empty_axes' is false, else act as an Identity
                op when 'noop_with_empty_axes' is true. Accepted range is [-r, r-1]
                where r = rank(data).

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.

            noop_with_empty_axes: Defines behavior if 'axes' is empty. Default behavior
                with 'false' is to reduce all axes. When axes is empty and this
                attribute is set to true, input tensor will not be reduced,and the
                output tensor would be equivalent to input tensor.
        """

        schema = get_schema("ReduceL2", 18, "")
        op = Op(self, "ReduceL2", schema)
        return op(
            *self._prepare_inputs(schema, data, axes),
            keepdims=keepdims,
            noop_with_empty_axes=noop_with_empty_axes,
        )

    T_ReduceLogSum = TypeVar(
        "T_ReduceLogSum", BFLOAT16, DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64
    )

    def ReduceLogSum(
        self,
        data: T_ReduceLogSum,
        axes: Optional[INT64] = None,
        *,
        keepdims: int = 1,
        noop_with_empty_axes: int = 0,
    ) -> T_ReduceLogSum:
        r"""[🌐 ReduceLogSum(18)](https://onnx.ai/onnx/operators/onnx__ReduceLogSum.html#reducelogsum-18 "Online Documentation")


        Computes the log sum of the input tensor's elements along the provided axes. The resulting
        tensor has the same rank as the input if `keepdims` equals 1. If `keepdims` equals 0, then
        the resulting tensor has the reduced dimension pruned. Input tensors of rank zero are
        valid. Reduction over an empty set of values yields minus infinity (if supported by the datatype) or undefined otherwise.


        The above behavior is similar to numpy, with the exception that numpy defaults `keepdims`
        to `False` instead of `True`.

        Args:
            data: (differentiable) An input tensor.

            axes: (optional, non-differentiable) Optional input list of integers, along
                which to reduce. The default is to reduce over all the dimensions of the
                input tensor if 'noop_with_empty_axes' is false, else act as an Identity
                op when 'noop_with_empty_axes' is true. Accepted range is [-r, r-1]
                where r = rank(data).

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.

            noop_with_empty_axes: Defines behavior if 'axes' is empty. Default behavior
                with 'false' is to reduce all axes. When axes is empty and this
                attribute is set to true, input tensor will not be reduced,and the
                output tensor would be equivalent to input tensor.
        """

        schema = get_schema("ReduceLogSum", 18, "")
        op = Op(self, "ReduceLogSum", schema)
        return op(
            *self._prepare_inputs(schema, data, axes),
            keepdims=keepdims,
            noop_with_empty_axes=noop_with_empty_axes,
        )

    T_ReduceLogSumExp = TypeVar(
        "T_ReduceLogSumExp", BFLOAT16, DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64
    )

    def ReduceLogSumExp(
        self,
        data: T_ReduceLogSumExp,
        axes: Optional[INT64] = None,
        *,
        keepdims: int = 1,
        noop_with_empty_axes: int = 0,
    ) -> T_ReduceLogSumExp:
        r"""[🌐 ReduceLogSumExp(18)](https://onnx.ai/onnx/operators/onnx__ReduceLogSumExp.html#reducelogsumexp-18 "Online Documentation")


        Computes the log sum exponent of the input tensor's elements along the provided axes. The resulting
        tensor has the same rank as the input if `keepdims` equals 1. If `keepdims` equals 0, then
        the resulting tensor has the reduced dimension pruned. Input tensors of rank zero are
        valid. Reduction over an empty set of values yields minus infinity (if supported by the datatype) or undefined otherwise.


        The above behavior is similar to numpy, with the exception that numpy defaults `keepdims`
        to `False` instead of `True`.

        Args:
            data: (differentiable) An input tensor.

            axes: (optional, non-differentiable) Optional input list of integers, along
                which to reduce. The default is to reduce over all the dimensions of the
                input tensor if 'noop_with_empty_axes' is false, else act as an Identity
                op when 'noop_with_empty_axes' is true. Accepted range is [-r, r-1]
                where r = rank(data).

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.

            noop_with_empty_axes: Defines behavior if 'axes' is empty. Default behavior
                with 'false' is to reduce all axes. When axes is empty and this
                attribute is set to true, input tensor will not be reduced,and the
                output tensor would be equivalent to input tensor.
        """

        schema = get_schema("ReduceLogSumExp", 18, "")
        op = Op(self, "ReduceLogSumExp", schema)
        return op(
            *self._prepare_inputs(schema, data, axes),
            keepdims=keepdims,
            noop_with_empty_axes=noop_with_empty_axes,
        )

    T_ReduceMax = TypeVar(
        "T_ReduceMax",
        BFLOAT16,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT32,
        INT64,
        INT8,
        UINT32,
        UINT64,
        UINT8,
    )

    def ReduceMax(
        self,
        data: T_ReduceMax,
        axes: Optional[INT64] = None,
        *,
        keepdims: int = 1,
        noop_with_empty_axes: int = 0,
    ) -> T_ReduceMax:
        r"""[🌐 ReduceMax(18)](https://onnx.ai/onnx/operators/onnx__ReduceMax.html#reducemax-18 "Online Documentation")


        Computes the max of the input tensor's elements along the provided axes. The resulting
        tensor has the same rank as the input if `keepdims` equals 1. If `keepdims` equals 0, then
        the resulting tensor has the reduced dimension pruned. Input tensors of rank zero are
        valid. Reduction over an empty set of values yields minus infinity (if supported by the datatype) or the minimum value of the data type otherwise.


        The above behavior is similar to numpy, with the exception that numpy defaults `keepdims`
        to `False` instead of `True`.

        Args:
            data: (differentiable) An input tensor.

            axes: (optional, non-differentiable) Optional input list of integers, along
                which to reduce. The default is to reduce over all the dimensions of the
                input tensor if 'noop_with_empty_axes' is false, else act as an Identity
                op when 'noop_with_empty_axes' is true. Accepted range is [-r, r-1]
                where r = rank(data).

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.

            noop_with_empty_axes: Defines behavior if 'axes' is empty. Default behavior
                with 'false' is to reduce all axes. When axes is empty and this
                attribute is set to true, input tensor will not be reduced,and the
                output tensor would be equivalent to input tensor.
        """

        schema = get_schema("ReduceMax", 18, "")
        op = Op(self, "ReduceMax", schema)
        return op(
            *self._prepare_inputs(schema, data, axes),
            keepdims=keepdims,
            noop_with_empty_axes=noop_with_empty_axes,
        )

    T_ReduceMean = TypeVar(
        "T_ReduceMean", BFLOAT16, DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64
    )

    def ReduceMean(
        self,
        data: T_ReduceMean,
        axes: Optional[INT64] = None,
        *,
        keepdims: int = 1,
        noop_with_empty_axes: int = 0,
    ) -> T_ReduceMean:
        r"""[🌐 ReduceMean(18)](https://onnx.ai/onnx/operators/onnx__ReduceMean.html#reducemean-18 "Online Documentation")


        Computes the mean of the input tensor's elements along the provided axes. The resulting
        tensor has the same rank as the input if `keepdims` equals 1. If `keepdims` equals 0, then
        the resulting tensor has the reduced dimension pruned. Input tensors of rank zero are
        valid. Reduction over an empty set of values yields undefined.


        The above behavior is similar to numpy, with the exception that numpy defaults `keepdims`
        to `False` instead of `True`.

        Args:
            data: (differentiable) An input tensor.

            axes: (optional, non-differentiable) Optional input list of integers, along
                which to reduce. The default is to reduce over all the dimensions of the
                input tensor if 'noop_with_empty_axes' is false, else act as an Identity
                op when 'noop_with_empty_axes' is true. Accepted range is [-r, r-1]
                where r = rank(data).

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.

            noop_with_empty_axes: Defines behavior if 'axes' is empty. Default behavior
                with 'false' is to reduce all axes. When axes is empty and this
                attribute is set to true, input tensor will not be reduced,and the
                output tensor would be equivalent to input tensor.
        """

        schema = get_schema("ReduceMean", 18, "")
        op = Op(self, "ReduceMean", schema)
        return op(
            *self._prepare_inputs(schema, data, axes),
            keepdims=keepdims,
            noop_with_empty_axes=noop_with_empty_axes,
        )

    T_ReduceMin = TypeVar(
        "T_ReduceMin",
        BFLOAT16,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT32,
        INT64,
        INT8,
        UINT32,
        UINT64,
        UINT8,
    )

    def ReduceMin(
        self,
        data: T_ReduceMin,
        axes: Optional[INT64] = None,
        *,
        keepdims: int = 1,
        noop_with_empty_axes: int = 0,
    ) -> T_ReduceMin:
        r"""[🌐 ReduceMin(18)](https://onnx.ai/onnx/operators/onnx__ReduceMin.html#reducemin-18 "Online Documentation")


        Computes the min of the input tensor's elements along the provided axes. The resulting
        tensor has the same rank as the input if `keepdims` equals 1. If `keepdims` equals 0, then
        the resulting tensor has the reduced dimension pruned. Input tensors of rank zero are
        valid. Reduction over an empty set of values yields plus infinity (if supported by the datatype) or the maximum value of the data type otherwise.


        The above behavior is similar to numpy, with the exception that numpy defaults `keepdims`
        to `False` instead of `True`.

        Args:
            data: (differentiable) An input tensor.

            axes: (optional, non-differentiable) Optional input list of integers, along
                which to reduce. The default is to reduce over all the dimensions of the
                input tensor if 'noop_with_empty_axes' is false, else act as an Identity
                op when 'noop_with_empty_axes' is true. Accepted range is [-r, r-1]
                where r = rank(data).

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.

            noop_with_empty_axes: Defines behavior if 'axes' is empty. Default behavior
                with 'false' is to reduce all axes. When axes is empty and this
                attribute is set to true, input tensor will not be reduced,and the
                output tensor would be equivalent to input tensor.
        """

        schema = get_schema("ReduceMin", 18, "")
        op = Op(self, "ReduceMin", schema)
        return op(
            *self._prepare_inputs(schema, data, axes),
            keepdims=keepdims,
            noop_with_empty_axes=noop_with_empty_axes,
        )

    T_ReduceProd = TypeVar(
        "T_ReduceProd", BFLOAT16, DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64
    )

    def ReduceProd(
        self,
        data: T_ReduceProd,
        axes: Optional[INT64] = None,
        *,
        keepdims: int = 1,
        noop_with_empty_axes: int = 0,
    ) -> T_ReduceProd:
        r"""[🌐 ReduceProd(18)](https://onnx.ai/onnx/operators/onnx__ReduceProd.html#reduceprod-18 "Online Documentation")


        Computes the product of the input tensor's elements along the provided axes. The resulting
        tensor has the same rank as the input if `keepdims` equals 1. If `keepdims` equals 0, then
        the resulting tensor has the reduced dimension pruned. Input tensors of rank zero are
        valid. Reduction over an empty set of values yields 1.


        The above behavior is similar to numpy, with the exception that numpy defaults `keepdims`
        to `False` instead of `True`.

        Args:
            data: (differentiable) An input tensor.

            axes: (optional, non-differentiable) Optional input list of integers, along
                which to reduce. The default is to reduce over all the dimensions of the
                input tensor if 'noop_with_empty_axes' is false, else act as an Identity
                op when 'noop_with_empty_axes' is true. Accepted range is [-r, r-1]
                where r = rank(data).

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.

            noop_with_empty_axes: Defines behavior if 'axes' is empty. Default behavior
                with 'false' is to reduce all axes. When axes is empty and this
                attribute is set to true, input tensor will not be reduced,and the
                output tensor would be equivalent to input tensor.
        """

        schema = get_schema("ReduceProd", 18, "")
        op = Op(self, "ReduceProd", schema)
        return op(
            *self._prepare_inputs(schema, data, axes),
            keepdims=keepdims,
            noop_with_empty_axes=noop_with_empty_axes,
        )

    T_ReduceSumSquare = TypeVar(
        "T_ReduceSumSquare", BFLOAT16, DOUBLE, FLOAT, FLOAT16, INT32, INT64, UINT32, UINT64
    )

    def ReduceSumSquare(
        self,
        data: T_ReduceSumSquare,
        axes: Optional[INT64] = None,
        *,
        keepdims: int = 1,
        noop_with_empty_axes: int = 0,
    ) -> T_ReduceSumSquare:
        r"""[🌐 ReduceSumSquare(18)](https://onnx.ai/onnx/operators/onnx__ReduceSumSquare.html#reducesumsquare-18 "Online Documentation")


        Computes the sum square of the input tensor's elements along the provided axes. The resulting
        tensor has the same rank as the input if `keepdims` equals 1. If `keepdims` equals 0, then
        the resulting tensor has the reduced dimension pruned. Input tensors of rank zero are
        valid. Reduction over an empty set of values yields 0.


        The above behavior is similar to numpy, with the exception that numpy defaults `keepdims`
        to `False` instead of `True`.

        Args:
            data: (differentiable) An input tensor.

            axes: (optional, non-differentiable) Optional input list of integers, along
                which to reduce. The default is to reduce over all the dimensions of the
                input tensor if 'noop_with_empty_axes' is false, else act as an Identity
                op when 'noop_with_empty_axes' is true. Accepted range is [-r, r-1]
                where r = rank(data).

            keepdims: Keep the reduced dimension or not, default 1 means keep reduced
                dimension.

            noop_with_empty_axes: Defines behavior if 'axes' is empty. Default behavior
                with 'false' is to reduce all axes. When axes is empty and this
                attribute is set to true, input tensor will not be reduced,and the
                output tensor would be equivalent to input tensor.
        """

        schema = get_schema("ReduceSumSquare", 18, "")
        op = Op(self, "ReduceSumSquare", schema)
        return op(
            *self._prepare_inputs(schema, data, axes),
            keepdims=keepdims,
            noop_with_empty_axes=noop_with_empty_axes,
        )

    T1_Resize = TypeVar(
        "T1_Resize",
        BFLOAT16,
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    T2_Resize = TypeVar("T2_Resize", DOUBLE, FLOAT, FLOAT16)

    def Resize(
        self,
        X: T1_Resize,
        roi: Optional[T2_Resize] = None,
        scales: Optional[FLOAT] = None,
        sizes: Optional[INT64] = None,
        *,
        antialias: int = 0,
        axes: Optional[Sequence[int]] = None,
        coordinate_transformation_mode: str = "half_pixel",
        cubic_coeff_a: float = -0.75,
        exclude_outside: int = 0,
        extrapolation_value: float = 0.0,
        keep_aspect_ratio_policy: str = "stretch",
        mode: str = "nearest",
        nearest_mode: str = "round_prefer_floor",
    ) -> T1_Resize:
        r"""[🌐 Resize(18)](https://onnx.ai/onnx/operators/onnx__Resize.html#resize-18 "Online Documentation")


        Resize the input tensor. In general, it calculates every value in the output tensor as a weighted average of neighborhood (a.k.a. sampling locations) in the input tensor.
        Each dimension value of the output tensor is: <br/>
          `output_dimension = floor(input_dimension * (roi_end - roi_start) * scale)` <br/>
        if input \"sizes\" is not specified.


        Args:
            X: (differentiable) N-D tensor

            roi: (optional, non-differentiable) 1-D tensor given as [start1, ...,
                startN, end1, ..., endN], where N is the rank of X or the length of
                axes, if provided. The RoIs' coordinates are normalized in the
                coordinate system of the input image. It only takes effect when
                coordinate_transformation_mode is "tf_crop_and_resize"

            scales: (optional, non-differentiable) The scale array along each dimension.
                It takes value greater than 0. If it's less than 1, it's sampling down,
                otherwise, it's upsampling. The number of elements of 'scales' should be
                the same as the rank of input 'X' or the length of 'axes', if provided.
                One of 'scales' and 'sizes' MUST be specified and it is an error if both
                are specified. If 'sizes' is needed, the user can use an empty string as
                the name of 'scales' in this operator's input list.

            sizes: (optional, non-differentiable) Target size of the output tensor. Its
                interpretation depends on the 'keep_aspect_ratio_policy' value.The
                number of elements of 'sizes' should be the same as the rank of input
                'X', or the length of 'axes', if provided. Only one of 'scales' and
                'sizes' can be specified.

            antialias: If set to 1, "linear" and "cubic" interpolation modes will use an
                antialiasing filter when downscaling. Antialiasing is achieved by
                stretching the resampling filter by a factor max(1, 1 / scale), which
                means that when downsampling, more input pixels contribute to an output
                pixel.

            axes: If provided, it specifies a subset of axes that 'roi', 'scales' and
                'sizes' refer to. If not provided, all axes are assumed [0, 1, ...,
                r-1], where r = rank(data). Non-specified dimensions are interpreted as
                non-resizable. Negative value means counting dimensions from the back.
                Accepted range is [-r, r-1], where r = rank(data). Behavior is undefined
                if an axis is repeated.

            coordinate_transformation_mode:
        This attribute describes how to transform
                the coordinate in the resized tensor to the coordinate in the original
                tensor. <br/>

        The coordinate of each dimension is transformed
                individually. Let's describe a case using axis x as an example.
        Denote
                x_resized as the coordinate of axis x in the resized tensor, x_original
                as the coordinate of axis x in the original tensor, `length_original` as
                the length of the original tensor in axis x, length_resized as the
                length of the resized tensor in axis x, roi_x = (start_x, end_x) of the
                axis x in input "roi", `scale = length_resized / length_original`, <br/>
                if coordinate_transformation_mode is `"half_pixel"`, <br/>
        `x_original =
                (x_resized + 0.5) / scale - 0.5` <br/>

        if
                coordinate_transformation_mode is `"pytorch_half_pixel"`, <br/>
                `x_original = length_resized > 1 ? (x_resized + 0.5) / scale - 0.5 : 0`
                <br/>

        if coordinate_transformation_mode is `"align_corners"`, <br/>
                `x_original = x_resized * (length_original - 1) / (length_resized - 1)`
                <br/>

        if coordinate_transformation_mode is `"asymmetric"`, <br/>
                `x_original = x_resized / scale` <br/>

        if
                coordinate_transformation_mode is `"tf_crop_and_resize"`, <br/>
                `x_original = length_resized > 1 ? start_x * (length_original - 1) +
                x_resized * (end_x - start_x) * (length_original - 1) / (length_resized
                - 1) : 0.5 * (start_x + end_x) * (length_original - 1)`
        .

            cubic_coeff_a: The coefficient 'a' used in cubic interpolation. Two common
                choice are -0.5 (in some cases of TensorFlow) and -0.75 (in PyTorch).
                Check out Equation (4) in https://ieeexplore.ieee.org/document/1163711
                for the details. This attribute is valid only if mode is "cubic".

            exclude_outside: If set to 1, the weight of sampling locations outside the
                tensor will be set to 0 and the weight will be renormalized so that
                their sum is 1.0. The default value is 0.

            extrapolation_value: When coordinate_transformation_mode is
                "tf_crop_and_resize" and x_original is outside the range [0,
                length_original - 1], this value is used as the corresponding output
                value. Default is 0.0f.

            keep_aspect_ratio_policy:
        This attribute describes how to interpret the
                `sizes` input with regard to keeping the original aspect ratio of the
                input, and it is not applicable when
        the `scales` input is used. <br/>
                Given a set of `sizes`, associated with a subset of `axes` (explicitly
                provided or default), and assuming `d = axes[i]`, with `i` being the
                index of the provided `sizes`. <br/>

        If `keep_aspect_ratio_policy` is
                `"stretch"`, the original aspect ratio is disregarded, and the input is
                resized to the specified size: <br/>
        `out_size[d] = sizes[i]` <br/>

        If
                `keep_aspect_ratio_policy` is `"not_larger"`, the sizes are adjusted so
                that no extent of the output is larger than the specified size, while
                keeping the original aspect ratio: <br/>
        `scale = Min(sizes[i] /
                in_size[d])` <br/>
        `out_size[d] = round_int(scale * in_size[i])` <br/>
                If `keep_aspect_ratio_policy` is `"not_smaller"`, the sizes are adjusted
                so that no extent of the output is smaller than the specified size,
                while keeping the original aspect ratio: <br/>
        `scale = Max(sizes[i] /
                in_size[d])` <br/>
        `out_size[d] = round_int(scale * in_size[i])` <br/>
                For non-resizable axes (those not specified in `axes`), the output size
                will be equal to the input size.

        Note: `round_int` stands for computing
                the nearest integer value, rounding halfway cases up.

            mode: Three interpolation modes: "nearest" (default), "linear" and "cubic".
                The "linear" mode includes linear interpolation for 1D tensor and
                N-linear interpolation for N-D tensor (for example, bilinear
                interpolation for 2D tensor). The "cubic" mode includes cubic
                interpolation for 1D tensor and N-cubic interpolation for N-D tensor
                (for example, bicubic interpolation for 2D tensor).

            nearest_mode: Four modes: "round_prefer_floor" (default, as known as round
                half down), "round_prefer_ceil" (as known as round half up), "floor",
                "ceil". Only used by nearest interpolation. It indicates how to get
                "nearest" pixel in input tensor from x_original, so this attribute is
                valid only if "mode" is "nearest".
        """

        schema = get_schema("Resize", 18, "")
        op = Op(self, "Resize", schema)
        return op(
            *self._prepare_inputs(schema, X, roi, scales, sizes),
            antialias=antialias,
            axes=axes,
            coordinate_transformation_mode=coordinate_transformation_mode,
            cubic_coeff_a=cubic_coeff_a,
            exclude_outside=exclude_outside,
            extrapolation_value=extrapolation_value,
            keep_aspect_ratio_policy=keep_aspect_ratio_policy,
            mode=mode,
            nearest_mode=nearest_mode,
        )

    T_ScatterElements = TypeVar(
        "T_ScatterElements",
        BFLOAT16,
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    Tind_ScatterElements = TypeVar("Tind_ScatterElements", INT32, INT64)

    def ScatterElements(
        self,
        data: T_ScatterElements,
        indices: Tind_ScatterElements,
        updates: T_ScatterElements,
        *,
        axis: int = 0,
        reduction: str = "none",
    ) -> T_ScatterElements:
        r"""[🌐 ScatterElements(18)](https://onnx.ai/onnx/operators/onnx__ScatterElements.html#scatterelements-18 "Online Documentation")


        ScatterElements takes three inputs `data`, `updates`, and `indices` of the same
        rank r >= 1 and an optional attribute axis that identifies an axis of `data`
        (by default, the outer-most axis, that is axis 0). The output of the operation
        is produced by creating a copy of the input `data`, and then updating its value
        to values specified by `updates` at specific index positions specified by
        `indices`. Its output shape is the same as the shape of `data`.

        For each entry in `updates`, the target index in `data` is obtained by combining
        the corresponding entry in `indices` with the index of the entry itself: the
        index-value for dimension = axis is obtained from the value of the corresponding
        entry in `indices` and the index-value for dimension != axis is obtained from the
        index of the entry itself.

        `reduction` allows specification of an optional reduction operation, which is applied to all values in `updates`
        tensor into `output` at the specified `indices`.
        In cases where `reduction` is set to "none", indices should not have duplicate entries: that is, if idx1 != idx2,
        then indices[idx1] != indices[idx2]. For instance, in a 2-D tensor case, the update
        corresponding to the [i][j] entry is performed as below:
        ::

            output[indices[i][j]][j] = updates[i][j] if axis = 0,
            output[i][indices[i][j]] = updates[i][j] if axis = 1,


        When `reduction` is set to some reduction function `f`, the update corresponding to the [i][j] entry is performed as below:
        ::

            output[indices[i][j]][j] = f(output[indices[i][j]][j], updates[i][j]) if axis = 0,
            output[i][indices[i][j]] = f(output[i][indices[i][j]], updates[i][j]) if axis = 1,


        where the `f` is `+`, `*`, `max` or `min` as specified.

        This operator is the inverse of GatherElements. It is similar to Torch's Scatter operation.

        (Opset 18 change): Adds max/min to the set of allowed reduction ops.

        Example 1:
        ::

            data = [
                [0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0],
                [0.0, 0.0, 0.0],
            ]
            indices = [
                [1, 0, 2],
                [0, 2, 1],
            ]
            updates = [
                [1.0, 1.1, 1.2],
                [2.0, 2.1, 2.2],
            ]
            output = [
                [2.0, 1.1, 0.0]
                [1.0, 0.0, 2.2]
                [0.0, 2.1, 1.2]
            ]


        Example 2:
        ::

            data = [[1.0, 2.0, 3.0, 4.0, 5.0]]
            indices = [[1, 3]]
            updates = [[1.1, 2.1]]
            axis = 1
            output = [[1.0, 1.1, 3.0, 2.1, 5.0]]




        Args:
            data: (differentiable) Tensor of rank r >= 1.

            indices: (non-differentiable) Tensor of int32/int64 indices, of r >= 1 (same
                rank as input). All index values are expected to be within bounds [-s,
                s-1] along axis of size s. It is an error if any of the index values are
                out of bounds.

            updates: (differentiable) Tensor of rank r >=1 (same rank and shape as
                indices)

            axis: Which axis to scatter on. Negative value means counting dimensions
                from the back. Accepted range is [-r, r-1] where r = rank(data).

            reduction: Type of reduction to apply: none (default), add, mul, max, min.
                'none': no reduction applied. 'add':  reduction using the addition
                operation. 'mul': reduction using the multiplication operation.'max':
                reduction using the maximum operation.'min': reduction using the minimum
                operation.
        """

        schema = get_schema("ScatterElements", 18, "")
        op = Op(self, "ScatterElements", schema)
        return op(
            *self._prepare_inputs(schema, data, indices, updates),
            axis=axis,
            reduction=reduction,
        )

    T_ScatterND = TypeVar(
        "T_ScatterND",
        BFLOAT16,
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    def ScatterND(
        self,
        data: T_ScatterND,
        indices: INT64,
        updates: T_ScatterND,
        *,
        reduction: str = "none",
    ) -> T_ScatterND:
        r"""[🌐 ScatterND(18)](https://onnx.ai/onnx/operators/onnx__ScatterND.html#scatternd-18 "Online Documentation")


        ScatterND takes three inputs `data` tensor of rank r >= 1, `indices` tensor of rank q >= 1,
        and `updates` tensor of rank q + r - indices.shape[-1] - 1. The output of the operation
        is produced by creating a copy of the input `data`, and then updating its value to values
        specified by `updates` at specific index positions specified by `indices`. Its output shape
        is the same as the shape of `data`.

        `indices` is an integer tensor. Let k denote indices.shape[-1], the last dimension in the shape of `indices`.
        `indices` is treated as a (q-1)-dimensional tensor of k-tuples, where each k-tuple is a partial-index into `data`.
        Hence, k can be a value at most the rank of `data`. When k equals rank(data), each update entry specifies an
        update to a single element of the tensor. When k is less than rank(data) each update entry specifies an
        update to a slice of the tensor. Index values are allowed to be negative, as per the usual
        convention for counting backwards from the end, but are expected in the valid range.

        `updates` is treated as a (q-1)-dimensional tensor of replacement-slice-values. Thus, the
        first (q-1) dimensions of updates.shape must match the first (q-1) dimensions of indices.shape.
        The remaining dimensions of `updates` correspond to the dimensions of the
        replacement-slice-values. Each replacement-slice-value is a (r-k) dimensional tensor,
        corresponding to the trailing (r-k) dimensions of `data`.  Thus, the shape of `updates`
        must equal indices.shape[0:q-1] ++ data.shape[k:r-1], where ++ denotes the concatenation
        of shapes.

        The `output` is calculated via the following equation:

        ::

            output = np.copy(data)
            update_indices = indices.shape[:-1]
            for idx in np.ndindex(update_indices):
                output[indices[idx]] = updates[idx]



        The order of iteration in the above loop is not specified.
        In particular, indices should not have duplicate entries: that is, if idx1 != idx2, then indices[idx1] != indices[idx2].
        This ensures that the output value does not depend on the iteration order.

        `reduction` allows specification of an optional reduction operation, which is applied to all values in `updates`
        tensor into `output` at the specified `indices`.
        In cases where `reduction` is set to "none", indices should not have duplicate entries: that is, if idx1 != idx2,
        then indices[idx1] != indices[idx2]. This ensures that the output value does not depend on the iteration order.
        When `reduction` is set to some reduction function `f`, `output` is calculated as follows:

        ::

            output = np.copy(data)
            update_indices = indices.shape[:-1]
            for idx in np.ndindex(update_indices):
                output[indices[idx]] = f(output[indices[idx]], updates[idx])



        where the `f` is `+`, `*`, `max` or `min` as specified.

        This operator is the inverse of GatherND.

        (Opset 18 change): Adds max/min to the set of allowed reduction ops.

        Example 1:
        ::

            data    = [1, 2, 3, 4, 5, 6, 7, 8]
            indices = [[4], [3], [1], [7]]
            updates = [9, 10, 11, 12]
            output  = [1, 11, 3, 10, 9, 6, 7, 12]



        Example 2:
        ::

            data    = [[[1, 2, 3, 4], [5, 6, 7, 8], [8, 7, 6, 5], [4, 3, 2, 1]],
                        [[1, 2, 3, 4], [5, 6, 7, 8], [8, 7, 6, 5], [4, 3, 2, 1]],
                        [[8, 7, 6, 5], [4, 3, 2, 1], [1, 2, 3, 4], [5, 6, 7, 8]],
                        [[8, 7, 6, 5], [4, 3, 2, 1], [1, 2, 3, 4], [5, 6, 7, 8]]]
            indices = [[0], [2]]
            updates = [[[5, 5, 5, 5], [6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8]],
                        [[1, 1, 1, 1], [2, 2, 2, 2], [3, 3, 3, 3], [4, 4, 4, 4]]]
            output  = [[[5, 5, 5, 5], [6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8]],
                        [[1, 2, 3, 4], [5, 6, 7, 8], [8, 7, 6, 5], [4, 3, 2, 1]],
                        [[1, 1, 1, 1], [2, 2, 2, 2], [3, 3, 3, 3], [4, 4, 4, 4]],
                        [[8, 7, 6, 5], [4, 3, 2, 1], [1, 2, 3, 4], [5, 6, 7, 8]]]




        Args:
            data: (differentiable) Tensor of rank r >= 1.

            indices: (non-differentiable) Tensor of rank q >= 1.

            updates: (differentiable) Tensor of rank q + r - indices_shape[-1] - 1.

            reduction: Type of reduction to apply: none (default), add, mul, max, min.
                'none': no reduction applied. 'add':  reduction using the addition
                operation. 'mul':  reduction using the addition operation. 'max':
                reduction using the maximum operation.'min': reduction using the minimum
                operation.
        """

        schema = get_schema("ScatterND", 18, "")
        op = Op(self, "ScatterND", schema)
        return op(*self._prepare_inputs(schema, data, indices, updates), reduction=reduction)

    T_Split = TypeVar(
        "T_Split",
        BFLOAT16,
        BOOL,
        COMPLEX128,
        COMPLEX64,
        DOUBLE,
        FLOAT,
        FLOAT16,
        INT16,
        INT32,
        INT64,
        INT8,
        STRING,
        UINT16,
        UINT32,
        UINT64,
        UINT8,
    )

    def Split(
        self,
        input: T_Split,
        split: Optional[INT64] = None,
        *,
        axis: int = 0,
        num_outputs: Optional[int] = None,
    ) -> T_Split:
        r"""[🌐 Split(18)](https://onnx.ai/onnx/operators/onnx__Split.html#split-18 "Online Documentation")

        Split a tensor into a list of tensors, along the specified 'axis'.
        Either input 'split' or the attribute 'num_outputs' should be specified, but not both.
        If the attribute 'num_outputs' is specified, then the tensor is split into equal sized parts.
        If the tensor is not evenly splittable into `num_outputs`, the last chunk will be smaller.
        If the input 'split' is specified, it indicates the sizes of each output in the split.


        Args:
            input: (differentiable) The tensor to split

            split: (optional, non-differentiable) Optional length of each output. Values
                should be >= 0.Sum of the values must be equal to the dim value at
                'axis' specified.

            axis: Which axis to split on. A negative value means counting dimensions
                from the back. Accepted range is [-rank, rank-1] where r = rank(input).

            num_outputs: Number of outputs to split parts of the tensor into. If the
                tensor is not evenly splittable the last chunk will be smaller.
        """

        schema = get_schema("Split", 18, "")
        op = Op(self, "Split", schema)
        return op(
            *self._prepare_inputs(schema, input, split), axis=axis, num_outputs=num_outputs
        )
