# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAdministrativeUnitResult',
    'AwaitableGetAdministrativeUnitResult',
    'get_administrative_unit',
    'get_administrative_unit_output',
]

@pulumi.output_type
class GetAdministrativeUnitResult:
    """
    A collection of values returned by getAdministrativeUnit.
    """
    def __init__(__self__, description=None, display_name=None, id=None, members=None, object_id=None, visibility=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)
        if object_id and not isinstance(object_id, str):
            raise TypeError("Expected argument 'object_id' to be a str")
        pulumi.set(__self__, "object_id", object_id)
        if visibility and not isinstance(visibility, str):
            raise TypeError("Expected argument 'visibility' to be a str")
        pulumi.set(__self__, "visibility", visibility)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the administrative unit.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the administrative unit.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def members(self) -> Sequence[_builtins.str]:
        """
        A list of object IDs of members who are present in this administrative unit.
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> _builtins.str:
        """
        The object ID of the administrative unit.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> _builtins.str:
        """
        Whether the administrative unit _and_ its members are hidden or publicly viewable in the directory. One of: `Hiddenmembership` or `Public`.
        """
        return pulumi.get(self, "visibility")


class AwaitableGetAdministrativeUnitResult(GetAdministrativeUnitResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAdministrativeUnitResult(
            description=self.description,
            display_name=self.display_name,
            id=self.id,
            members=self.members,
            object_id=self.object_id,
            visibility=self.visibility)


def get_administrative_unit(display_name: Optional[_builtins.str] = None,
                            object_id: Optional[_builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAdministrativeUnitResult:
    """
    Gets information about an adminisrative unit in Azure Active Directory.

    ## API Permissions

    The following API permissions are required in order to use this data source.

    When authenticated with a service principal, this data source requires one of the following application roles: `AdministrativeUnit.Read.All` or `Directory.Read.All`

    When authenticated with a user principal, this data source does not require any additional roles.

    ## Example Usage

    ### By Group Display Name)

    *Look up by display name*
    ```python
    import pulumi
    import pulumi_azuread as azuread

    example = azuread.get_administrative_unit(display_name="Example-AU")
    ```

    *Look up by object ID*
    ```python
    import pulumi
    import pulumi_azuread as azuread

    example = azuread.get_administrative_unit(object_id="00000000-0000-0000-0000-000000000000")
    ```


    :param _builtins.str display_name: Specifies the display name of the administrative unit.
    :param _builtins.str object_id: Specifies the object ID of the administrative unit.
           
           > One of `display_name` or `object_id` must be specified.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['objectId'] = object_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azuread:index/getAdministrativeUnit:getAdministrativeUnit', __args__, opts=opts, typ=GetAdministrativeUnitResult).value

    return AwaitableGetAdministrativeUnitResult(
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        members=pulumi.get(__ret__, 'members'),
        object_id=pulumi.get(__ret__, 'object_id'),
        visibility=pulumi.get(__ret__, 'visibility'))
def get_administrative_unit_output(display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   object_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAdministrativeUnitResult]:
    """
    Gets information about an adminisrative unit in Azure Active Directory.

    ## API Permissions

    The following API permissions are required in order to use this data source.

    When authenticated with a service principal, this data source requires one of the following application roles: `AdministrativeUnit.Read.All` or `Directory.Read.All`

    When authenticated with a user principal, this data source does not require any additional roles.

    ## Example Usage

    ### By Group Display Name)

    *Look up by display name*
    ```python
    import pulumi
    import pulumi_azuread as azuread

    example = azuread.get_administrative_unit(display_name="Example-AU")
    ```

    *Look up by object ID*
    ```python
    import pulumi
    import pulumi_azuread as azuread

    example = azuread.get_administrative_unit(object_id="00000000-0000-0000-0000-000000000000")
    ```


    :param _builtins.str display_name: Specifies the display name of the administrative unit.
    :param _builtins.str object_id: Specifies the object ID of the administrative unit.
           
           > One of `display_name` or `object_id` must be specified.
    """
    __args__ = dict()
    __args__['displayName'] = display_name
    __args__['objectId'] = object_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azuread:index/getAdministrativeUnit:getAdministrativeUnit', __args__, opts=opts, typ=GetAdministrativeUnitResult)
    return __ret__.apply(lambda __response__: GetAdministrativeUnitResult(
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        members=pulumi.get(__response__, 'members'),
        object_id=pulumi.get(__response__, 'object_id'),
        visibility=pulumi.get(__response__, 'visibility')))
