# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetDirectoryRolesResult',
    'AwaitableGetDirectoryRolesResult',
    'get_directory_roles',
    'get_directory_roles_output',
]

@pulumi.output_type
class GetDirectoryRolesResult:
    """
    A collection of values returned by getDirectoryRoles.
    """
    def __init__(__self__, id=None, object_ids=None, roles=None, template_ids=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if object_ids and not isinstance(object_ids, list):
            raise TypeError("Expected argument 'object_ids' to be a list")
        pulumi.set(__self__, "object_ids", object_ids)
        if roles and not isinstance(roles, list):
            raise TypeError("Expected argument 'roles' to be a list")
        pulumi.set(__self__, "roles", roles)
        if template_ids and not isinstance(template_ids, list):
            raise TypeError("Expected argument 'template_ids' to be a list")
        pulumi.set(__self__, "template_ids", template_ids)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="objectIds")
    def object_ids(self) -> Sequence[_builtins.str]:
        """
        The object IDs of the roles.
        """
        return pulumi.get(self, "object_ids")

    @_builtins.property
    @pulumi.getter
    def roles(self) -> Sequence['outputs.GetDirectoryRolesRoleResult']:
        """
        A list of users. Each `role` object provides the attributes documented below.
        """
        return pulumi.get(self, "roles")

    @_builtins.property
    @pulumi.getter(name="templateIds")
    def template_ids(self) -> Sequence[_builtins.str]:
        """
        The template IDs of the roles.
        """
        return pulumi.get(self, "template_ids")


class AwaitableGetDirectoryRolesResult(GetDirectoryRolesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDirectoryRolesResult(
            id=self.id,
            object_ids=self.object_ids,
            roles=self.roles,
            template_ids=self.template_ids)


def get_directory_roles(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDirectoryRolesResult:
    """
    Use this data source to access information about activated directory roles within Azure Active Directory.

    ## API Permissions

    The following API permissions are required in order to use this resource.

    When authenticated with a service principal, this resource requires one of the following application roles: `RoleManagement.Read.Directory` or `Directory.Read.All`

    When authenticated with a user principal, this data source does not require any additional roles.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azuread as azuread

    current = azuread.get_directory_roles()
    pulumi.export("roles", current.object_ids)
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azuread:index/getDirectoryRoles:getDirectoryRoles', __args__, opts=opts, typ=GetDirectoryRolesResult).value

    return AwaitableGetDirectoryRolesResult(
        id=pulumi.get(__ret__, 'id'),
        object_ids=pulumi.get(__ret__, 'object_ids'),
        roles=pulumi.get(__ret__, 'roles'),
        template_ids=pulumi.get(__ret__, 'template_ids'))
def get_directory_roles_output(opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDirectoryRolesResult]:
    """
    Use this data source to access information about activated directory roles within Azure Active Directory.

    ## API Permissions

    The following API permissions are required in order to use this resource.

    When authenticated with a service principal, this resource requires one of the following application roles: `RoleManagement.Read.Directory` or `Directory.Read.All`

    When authenticated with a user principal, this data source does not require any additional roles.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azuread as azuread

    current = azuread.get_directory_roles()
    pulumi.export("roles", current.object_ids)
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azuread:index/getDirectoryRoles:getDirectoryRoles', __args__, opts=opts, typ=GetDirectoryRolesResult)
    return __ret__.apply(lambda __response__: GetDirectoryRolesResult(
        id=pulumi.get(__response__, 'id'),
        object_ids=pulumi.get(__response__, 'object_ids'),
        roles=pulumi.get(__response__, 'roles'),
        template_ids=pulumi.get(__response__, 'template_ids')))
