# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetGroupRoleManagementPolicyResult',
    'AwaitableGetGroupRoleManagementPolicyResult',
    'get_group_role_management_policy',
    'get_group_role_management_policy_output',
]

@pulumi.output_type
class GetGroupRoleManagementPolicyResult:
    """
    A collection of values returned by getGroupRoleManagementPolicy.
    """
    def __init__(__self__, description=None, display_name=None, group_id=None, id=None, role_id=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if group_id and not isinstance(group_id, str):
            raise TypeError("Expected argument 'group_id' to be a str")
        pulumi.set(__self__, "group_id", group_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if role_id and not isinstance(role_id, str):
            raise TypeError("Expected argument 'role_id' to be a str")
        pulumi.set(__self__, "role_id", role_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        (String) The description of this policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        (String) The display name of this policy.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> _builtins.str:
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> _builtins.str:
        return pulumi.get(self, "role_id")


class AwaitableGetGroupRoleManagementPolicyResult(GetGroupRoleManagementPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupRoleManagementPolicyResult(
            description=self.description,
            display_name=self.display_name,
            group_id=self.group_id,
            id=self.id,
            role_id=self.role_id)


def get_group_role_management_policy(group_id: Optional[_builtins.str] = None,
                                     role_id: Optional[_builtins.str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupRoleManagementPolicyResult:
    """
    Use this data source to retrieve a role policy for an Azure AD group.

    ## API Permissions

    The following API permissions are required in order to use this resource.

    When authenticated with a service principal, this resource requires the `RoleManagementPolicy.Read.AzureADGroup` Microsoft Graph API permissions.

    When authenticated with a user principal, this resource requires `Global Administrator` directory role, or the `Privileged Role Administrator` role in Identity Governance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azuread as azuread

    example = azuread.Group("example",
        display_name="group-name",
        security_enabled=True)
    owners_policy = azuread.get_group_role_management_policy_output(group_id=example.id,
        role_id="owner")
    ```


    :param _builtins.str group_id: The ID of the Azure AD group for which the policy applies.
    :param _builtins.str role_id: The type of assignment this policy coveres. Can be either `member` or `owner`.
    """
    __args__ = dict()
    __args__['groupId'] = group_id
    __args__['roleId'] = role_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azuread:index/getGroupRoleManagementPolicy:getGroupRoleManagementPolicy', __args__, opts=opts, typ=GetGroupRoleManagementPolicyResult).value

    return AwaitableGetGroupRoleManagementPolicyResult(
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        group_id=pulumi.get(__ret__, 'group_id'),
        id=pulumi.get(__ret__, 'id'),
        role_id=pulumi.get(__ret__, 'role_id'))
def get_group_role_management_policy_output(group_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            role_id: Optional[pulumi.Input[_builtins.str]] = None,
                                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGroupRoleManagementPolicyResult]:
    """
    Use this data source to retrieve a role policy for an Azure AD group.

    ## API Permissions

    The following API permissions are required in order to use this resource.

    When authenticated with a service principal, this resource requires the `RoleManagementPolicy.Read.AzureADGroup` Microsoft Graph API permissions.

    When authenticated with a user principal, this resource requires `Global Administrator` directory role, or the `Privileged Role Administrator` role in Identity Governance.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azuread as azuread

    example = azuread.Group("example",
        display_name="group-name",
        security_enabled=True)
    owners_policy = azuread.get_group_role_management_policy_output(group_id=example.id,
        role_id="owner")
    ```


    :param _builtins.str group_id: The ID of the Azure AD group for which the policy applies.
    :param _builtins.str role_id: The type of assignment this policy coveres. Can be either `member` or `owner`.
    """
    __args__ = dict()
    __args__['groupId'] = group_id
    __args__['roleId'] = role_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azuread:index/getGroupRoleManagementPolicy:getGroupRoleManagementPolicy', __args__, opts=opts, typ=GetGroupRoleManagementPolicyResult)
    return __ret__.apply(lambda __response__: GetGroupRoleManagementPolicyResult(
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        group_id=pulumi.get(__response__, 'group_id'),
        id=pulumi.get(__response__, 'id'),
        role_id=pulumi.get(__response__, 'role_id')))
