# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetGroupsResult',
    'AwaitableGetGroupsResult',
    'get_groups',
    'get_groups_output',
]

@pulumi.output_type
class GetGroupsResult:
    """
    A collection of values returned by getGroups.
    """
    def __init__(__self__, display_name_prefix=None, display_names=None, id=None, ignore_missing=None, mail_enabled=None, object_ids=None, return_all=None, security_enabled=None):
        if display_name_prefix and not isinstance(display_name_prefix, str):
            raise TypeError("Expected argument 'display_name_prefix' to be a str")
        pulumi.set(__self__, "display_name_prefix", display_name_prefix)
        if display_names and not isinstance(display_names, list):
            raise TypeError("Expected argument 'display_names' to be a list")
        pulumi.set(__self__, "display_names", display_names)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ignore_missing and not isinstance(ignore_missing, bool):
            raise TypeError("Expected argument 'ignore_missing' to be a bool")
        pulumi.set(__self__, "ignore_missing", ignore_missing)
        if mail_enabled and not isinstance(mail_enabled, bool):
            raise TypeError("Expected argument 'mail_enabled' to be a bool")
        pulumi.set(__self__, "mail_enabled", mail_enabled)
        if object_ids and not isinstance(object_ids, list):
            raise TypeError("Expected argument 'object_ids' to be a list")
        pulumi.set(__self__, "object_ids", object_ids)
        if return_all and not isinstance(return_all, bool):
            raise TypeError("Expected argument 'return_all' to be a bool")
        pulumi.set(__self__, "return_all", return_all)
        if security_enabled and not isinstance(security_enabled, bool):
            raise TypeError("Expected argument 'security_enabled' to be a bool")
        pulumi.set(__self__, "security_enabled", security_enabled)

    @_builtins.property
    @pulumi.getter(name="displayNamePrefix")
    def display_name_prefix(self) -> _builtins.str:
        return pulumi.get(self, "display_name_prefix")

    @_builtins.property
    @pulumi.getter(name="displayNames")
    def display_names(self) -> Sequence[_builtins.str]:
        """
        The display names of the groups.
        """
        return pulumi.get(self, "display_names")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="ignoreMissing")
    def ignore_missing(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "ignore_missing")

    @_builtins.property
    @pulumi.getter(name="mailEnabled")
    def mail_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "mail_enabled")

    @_builtins.property
    @pulumi.getter(name="objectIds")
    def object_ids(self) -> Sequence[_builtins.str]:
        """
        The object IDs of the groups.
        """
        return pulumi.get(self, "object_ids")

    @_builtins.property
    @pulumi.getter(name="returnAll")
    def return_all(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "return_all")

    @_builtins.property
    @pulumi.getter(name="securityEnabled")
    def security_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "security_enabled")


class AwaitableGetGroupsResult(GetGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetGroupsResult(
            display_name_prefix=self.display_name_prefix,
            display_names=self.display_names,
            id=self.id,
            ignore_missing=self.ignore_missing,
            mail_enabled=self.mail_enabled,
            object_ids=self.object_ids,
            return_all=self.return_all,
            security_enabled=self.security_enabled)


def get_groups(display_name_prefix: Optional[_builtins.str] = None,
               display_names: Optional[Sequence[_builtins.str]] = None,
               ignore_missing: Optional[_builtins.bool] = None,
               mail_enabled: Optional[_builtins.bool] = None,
               object_ids: Optional[Sequence[_builtins.str]] = None,
               return_all: Optional[_builtins.bool] = None,
               security_enabled: Optional[_builtins.bool] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetGroupsResult:
    """
    Gets Object IDs or Display Names for multiple Azure Active Directory groups.

    ## API Permissions

    The following API permissions are required in order to use this data source.

    When authenticated with a service principal, this data source requires one of the following application roles: `Group.Read.All` or `Directory.Read.All`

    When authenticated with a user principal, this data source does not require any additional roles.

    ## Example Usage

    *Look up by group name*
    ```python
    import pulumi
    import pulumi_azuread as azuread

    example = azuread.get_groups(display_names=[
        "group-a",
        "group-b",
    ])
    ```

    *Look up by display name prefix*
    ```python
    import pulumi
    import pulumi_azuread as azuread

    sales = azuread.get_groups(display_name_prefix="sales-")
    ```

    *Look up all groups*
    ```python
    import pulumi
    import pulumi_azuread as azuread

    all = azuread.get_groups(return_all=True)
    ```

    *Look up all mail-enabled groups*
    ```python
    import pulumi
    import pulumi_azuread as azuread

    mail_enabled = azuread.get_groups(mail_enabled=True,
        return_all=True)
    ```

    *Look up all security-enabled groups that are not mail-enabled*
    ```python
    import pulumi
    import pulumi_azuread as azuread

    security_only = azuread.get_groups(mail_enabled=False,
        return_all=True,
        security_enabled=True)
    ```


    :param _builtins.str display_name_prefix: A common display name prefix to match when returning groups.
    :param Sequence[_builtins.str] display_names: The display names of the groups.
    :param _builtins.bool ignore_missing: Ignore missing groups and return groups that were found. The data source will still fail if no groups are found. Cannot be specified with `return_all`. Defaults to `false`.
    :param _builtins.bool mail_enabled: Whether the returned groups should be mail-enabled. By itself this does not exclude security-enabled groups. Setting this to `true` ensures all groups are mail-enabled, and setting to `false` ensures that all groups are _not_ mail-enabled. To ignore this filter, omit the property or set it to null. Cannot be specified together with `object_ids`.
    :param Sequence[_builtins.str] object_ids: The object IDs of the groups.
    :param _builtins.bool return_all: A flag to denote if all groups should be fetched and returned. Cannot be specified wth `ignore_missing`. Defaults to `false`.
    :param _builtins.bool security_enabled: Whether the returned groups should be security-enabled. By itself this does not exclude mail-enabled groups. Setting this to `true` ensures all groups are security-enabled, and setting to `false` ensures that all groups are _not_ security-enabled. To ignore this filter, omit the property or set it to null. Cannot be specified together with `object_ids`.
           
           > One of `display_names`, `display_name_prefix`, `object_ids` or `return_all` should be specified. Either `display_name` or `object_ids` _may_ be specified as an empty list, in which case no results will be returned.
    """
    __args__ = dict()
    __args__['displayNamePrefix'] = display_name_prefix
    __args__['displayNames'] = display_names
    __args__['ignoreMissing'] = ignore_missing
    __args__['mailEnabled'] = mail_enabled
    __args__['objectIds'] = object_ids
    __args__['returnAll'] = return_all
    __args__['securityEnabled'] = security_enabled
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azuread:index/getGroups:getGroups', __args__, opts=opts, typ=GetGroupsResult).value

    return AwaitableGetGroupsResult(
        display_name_prefix=pulumi.get(__ret__, 'display_name_prefix'),
        display_names=pulumi.get(__ret__, 'display_names'),
        id=pulumi.get(__ret__, 'id'),
        ignore_missing=pulumi.get(__ret__, 'ignore_missing'),
        mail_enabled=pulumi.get(__ret__, 'mail_enabled'),
        object_ids=pulumi.get(__ret__, 'object_ids'),
        return_all=pulumi.get(__ret__, 'return_all'),
        security_enabled=pulumi.get(__ret__, 'security_enabled'))
def get_groups_output(display_name_prefix: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                      display_names: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                      ignore_missing: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                      mail_enabled: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                      object_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                      return_all: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                      security_enabled: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetGroupsResult]:
    """
    Gets Object IDs or Display Names for multiple Azure Active Directory groups.

    ## API Permissions

    The following API permissions are required in order to use this data source.

    When authenticated with a service principal, this data source requires one of the following application roles: `Group.Read.All` or `Directory.Read.All`

    When authenticated with a user principal, this data source does not require any additional roles.

    ## Example Usage

    *Look up by group name*
    ```python
    import pulumi
    import pulumi_azuread as azuread

    example = azuread.get_groups(display_names=[
        "group-a",
        "group-b",
    ])
    ```

    *Look up by display name prefix*
    ```python
    import pulumi
    import pulumi_azuread as azuread

    sales = azuread.get_groups(display_name_prefix="sales-")
    ```

    *Look up all groups*
    ```python
    import pulumi
    import pulumi_azuread as azuread

    all = azuread.get_groups(return_all=True)
    ```

    *Look up all mail-enabled groups*
    ```python
    import pulumi
    import pulumi_azuread as azuread

    mail_enabled = azuread.get_groups(mail_enabled=True,
        return_all=True)
    ```

    *Look up all security-enabled groups that are not mail-enabled*
    ```python
    import pulumi
    import pulumi_azuread as azuread

    security_only = azuread.get_groups(mail_enabled=False,
        return_all=True,
        security_enabled=True)
    ```


    :param _builtins.str display_name_prefix: A common display name prefix to match when returning groups.
    :param Sequence[_builtins.str] display_names: The display names of the groups.
    :param _builtins.bool ignore_missing: Ignore missing groups and return groups that were found. The data source will still fail if no groups are found. Cannot be specified with `return_all`. Defaults to `false`.
    :param _builtins.bool mail_enabled: Whether the returned groups should be mail-enabled. By itself this does not exclude security-enabled groups. Setting this to `true` ensures all groups are mail-enabled, and setting to `false` ensures that all groups are _not_ mail-enabled. To ignore this filter, omit the property or set it to null. Cannot be specified together with `object_ids`.
    :param Sequence[_builtins.str] object_ids: The object IDs of the groups.
    :param _builtins.bool return_all: A flag to denote if all groups should be fetched and returned. Cannot be specified wth `ignore_missing`. Defaults to `false`.
    :param _builtins.bool security_enabled: Whether the returned groups should be security-enabled. By itself this does not exclude mail-enabled groups. Setting this to `true` ensures all groups are security-enabled, and setting to `false` ensures that all groups are _not_ security-enabled. To ignore this filter, omit the property or set it to null. Cannot be specified together with `object_ids`.
           
           > One of `display_names`, `display_name_prefix`, `object_ids` or `return_all` should be specified. Either `display_name` or `object_ids` _may_ be specified as an empty list, in which case no results will be returned.
    """
    __args__ = dict()
    __args__['displayNamePrefix'] = display_name_prefix
    __args__['displayNames'] = display_names
    __args__['ignoreMissing'] = ignore_missing
    __args__['mailEnabled'] = mail_enabled
    __args__['objectIds'] = object_ids
    __args__['returnAll'] = return_all
    __args__['securityEnabled'] = security_enabled
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azuread:index/getGroups:getGroups', __args__, opts=opts, typ=GetGroupsResult)
    return __ret__.apply(lambda __response__: GetGroupsResult(
        display_name_prefix=pulumi.get(__response__, 'display_name_prefix'),
        display_names=pulumi.get(__response__, 'display_names'),
        id=pulumi.get(__response__, 'id'),
        ignore_missing=pulumi.get(__response__, 'ignore_missing'),
        mail_enabled=pulumi.get(__response__, 'mail_enabled'),
        object_ids=pulumi.get(__response__, 'object_ids'),
        return_all=pulumi.get(__response__, 'return_all'),
        security_enabled=pulumi.get(__response__, 'security_enabled')))
