# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GroupArgs', 'Group']

@pulumi.input_type
class GroupArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 administrative_unit_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 assignable_to_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_subscribe_new_members: Optional[pulumi.Input[_builtins.bool]] = None,
                 behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_membership: Optional[pulumi.Input['GroupDynamicMembershipArgs']] = None,
                 external_senders_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_from_address_lists: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_from_outlook_clients: Optional[pulumi.Input[_builtins.bool]] = None,
                 mail_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 mail_nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 onpremises_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 owners: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 prevent_duplicate_names: Optional[pulumi.Input[_builtins.bool]] = None,
                 provisioning_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 theme: Optional[pulumi.Input[_builtins.str]] = None,
                 types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 writeback_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Group resource.
        :param pulumi.Input[_builtins.str] display_name: The display name for the group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] administrative_unit_ids: The object IDs of administrative units in which the group is a member. If specified, new groups will be created in the scope of the first administrative unit and added to the others. If empty, new groups will be created at the tenant level.
               
               > **Caution** When using the AdministrativeUnitMember resource, or the `members` property of the AdministrativeUnit resource, to manage Administrative Unit membership for a group, you will need to use an `ignore_changes = [administrative_unit_ids]` lifecycle meta argument for the `Group` resource, in order to avoid a persistent diff.
        :param pulumi.Input[_builtins.bool] assignable_to_role: Indicates whether this group can be assigned to an Azure Active Directory role. Defaults to `false`. Can only be set to `true` for security-enabled groups. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] auto_subscribe_new_members: Indicates whether new members added to the group will be auto-subscribed to receive email notifications. Can only be set for Unified groups.
               
               > **Known Permissions Issue** The `auto_subscribe_new_members` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] behaviors: A set of behaviors for a Microsoft 365 group. Possible values are `AllowOnlyMembersToPost`, `HideGroupInOutlook`, `SkipExchangeInstantOn`, `SubscribeMembersToCalendarEventsDisabled`, `SubscribeNewGroupMembers` and `WelcomeEmailDisabled`. See [official documentation](https://docs.microsoft.com/en-us/graph/group-set-options) for more details. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: The description for the group.
        :param pulumi.Input['GroupDynamicMembershipArgs'] dynamic_membership: A `dynamic_membership` block as documented below. Required when `types` contains `DynamicMembership`. Cannot be used with the `members` property.
        :param pulumi.Input[_builtins.bool] external_senders_allowed: Indicates whether people external to the organization can send messages to the group. Can only be set for Unified groups.
               
               > **Known Permissions Issue** The `external_senders_allowed` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        :param pulumi.Input[_builtins.bool] hide_from_address_lists: Indicates whether the group is displayed in certain parts of the Outlook user interface: in the Address Book, in address lists for selecting message recipients, and in the Browse Groups dialog for searching groups. Can only be set for Unified groups.
               
               > **Known Permissions Issue** The `hide_from_address_lists` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        :param pulumi.Input[_builtins.bool] hide_from_outlook_clients: Indicates whether the group is displayed in Outlook clients, such as Outlook for Windows and Outlook on the web. Can only be set for Unified groups.
               
               > **Known Permissions Issue** The `hide_from_outlook_clients` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        :param pulumi.Input[_builtins.bool] mail_enabled: Whether the group is a mail enabled, with a shared group mailbox. At least one of `mail_enabled` or `security_enabled` must be specified. Only Microsoft 365 groups can be mail enabled (see the `types` property).
        :param pulumi.Input[_builtins.str] mail_nickname: The mail alias for the group, unique in the organisation. Required for mail-enabled groups. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: A set of members who should be present in this group. Supported object types are Users, Groups or Service Principals. Cannot be used with the `dynamic_membership` block.
               
               !> **Warning** Do not use the `members` property at the same time as the GroupMember resource for the same group. Doing so will cause a conflict and group members will be removed.
        :param pulumi.Input[_builtins.str] onpremises_group_type: The on-premises group type that the AAD group will be written as, when writeback is enabled. Possible values are `UniversalDistributionGroup`, `UniversalMailEnabledSecurityGroup`, or `UniversalSecurityGroup`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] owners: A set of owners who own this group. Supported object types are Users or Service Principals
        :param pulumi.Input[_builtins.bool] prevent_duplicate_names: If `true`, will return an error if an existing group is found with the same name. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] provisioning_options: A set of provisioning options for a Microsoft 365 group. The only supported value is `Team`. See [official documentation](https://docs.microsoft.com/en-us/graph/group-set-options) for details. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] security_enabled: Whether the group is a security group for controlling access to in-app resources. At least one of `security_enabled` or `mail_enabled` must be specified. A Microsoft 365 group can be security enabled _and_ mail enabled (see the `types` property).
        :param pulumi.Input[_builtins.str] theme: The colour theme for a Microsoft 365 group. Possible values are `Blue`, `Green`, `Orange`, `Pink`, `Purple`, `Red` or `Teal`. By default, no theme is set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] types: A set of group types to configure for the group. Supported values are `DynamicMembership`, which denotes a group with dynamic membership, and `Unified`, which specifies a Microsoft 365 group. Required when `mail_enabled` is true. Changing this forces a new resource to be created.
               
               > **Supported Group Types** At present, only security groups and Microsoft 365 groups can be created or managed with this resource. Distribution groups and mail-enabled security groups are not supported. Microsoft 365 groups can be security-enabled.
        :param pulumi.Input[_builtins.str] visibility: The group join policy and group content visibility. Possible values are `Private`, `Public`, or `Hiddenmembership`. Only Microsoft 365 groups can have `Hiddenmembership` visibility and this value must be set when the group is created. By default, security groups will receive `Private` visibility and Microsoft 365 groups will receive `Public` visibility.
               
               > **Group Name Uniqueness** Group names are not unique within Azure Active Directory. Use the `prevent_duplicate_names` argument to check for existing groups if you want to avoid name collisions.
        :param pulumi.Input[_builtins.bool] writeback_enabled: Whether the group will be written back to the configured on-premises Active Directory when Azure AD Connect is used.
        """
        pulumi.set(__self__, "display_name", display_name)
        if administrative_unit_ids is not None:
            pulumi.set(__self__, "administrative_unit_ids", administrative_unit_ids)
        if assignable_to_role is not None:
            pulumi.set(__self__, "assignable_to_role", assignable_to_role)
        if auto_subscribe_new_members is not None:
            pulumi.set(__self__, "auto_subscribe_new_members", auto_subscribe_new_members)
        if behaviors is not None:
            pulumi.set(__self__, "behaviors", behaviors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dynamic_membership is not None:
            pulumi.set(__self__, "dynamic_membership", dynamic_membership)
        if external_senders_allowed is not None:
            pulumi.set(__self__, "external_senders_allowed", external_senders_allowed)
        if hide_from_address_lists is not None:
            pulumi.set(__self__, "hide_from_address_lists", hide_from_address_lists)
        if hide_from_outlook_clients is not None:
            pulumi.set(__self__, "hide_from_outlook_clients", hide_from_outlook_clients)
        if mail_enabled is not None:
            pulumi.set(__self__, "mail_enabled", mail_enabled)
        if mail_nickname is not None:
            pulumi.set(__self__, "mail_nickname", mail_nickname)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if onpremises_group_type is not None:
            pulumi.set(__self__, "onpremises_group_type", onpremises_group_type)
        if owners is not None:
            pulumi.set(__self__, "owners", owners)
        if prevent_duplicate_names is not None:
            pulumi.set(__self__, "prevent_duplicate_names", prevent_duplicate_names)
        if provisioning_options is not None:
            pulumi.set(__self__, "provisioning_options", provisioning_options)
        if security_enabled is not None:
            pulumi.set(__self__, "security_enabled", security_enabled)
        if theme is not None:
            pulumi.set(__self__, "theme", theme)
        if types is not None:
            pulumi.set(__self__, "types", types)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)
        if writeback_enabled is not None:
            pulumi.set(__self__, "writeback_enabled", writeback_enabled)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        The display name for the group.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="administrativeUnitIds")
    def administrative_unit_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The object IDs of administrative units in which the group is a member. If specified, new groups will be created in the scope of the first administrative unit and added to the others. If empty, new groups will be created at the tenant level.

        > **Caution** When using the AdministrativeUnitMember resource, or the `members` property of the AdministrativeUnit resource, to manage Administrative Unit membership for a group, you will need to use an `ignore_changes = [administrative_unit_ids]` lifecycle meta argument for the `Group` resource, in order to avoid a persistent diff.
        """
        return pulumi.get(self, "administrative_unit_ids")

    @administrative_unit_ids.setter
    def administrative_unit_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "administrative_unit_ids", value)

    @_builtins.property
    @pulumi.getter(name="assignableToRole")
    def assignable_to_role(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether this group can be assigned to an Azure Active Directory role. Defaults to `false`. Can only be set to `true` for security-enabled groups. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "assignable_to_role")

    @assignable_to_role.setter
    def assignable_to_role(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "assignable_to_role", value)

    @_builtins.property
    @pulumi.getter(name="autoSubscribeNewMembers")
    def auto_subscribe_new_members(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether new members added to the group will be auto-subscribed to receive email notifications. Can only be set for Unified groups.

        > **Known Permissions Issue** The `auto_subscribe_new_members` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        """
        return pulumi.get(self, "auto_subscribe_new_members")

    @auto_subscribe_new_members.setter
    def auto_subscribe_new_members(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_subscribe_new_members", value)

    @_builtins.property
    @pulumi.getter
    def behaviors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of behaviors for a Microsoft 365 group. Possible values are `AllowOnlyMembersToPost`, `HideGroupInOutlook`, `SkipExchangeInstantOn`, `SubscribeMembersToCalendarEventsDisabled`, `SubscribeNewGroupMembers` and `WelcomeEmailDisabled`. See [official documentation](https://docs.microsoft.com/en-us/graph/group-set-options) for more details. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "behaviors")

    @behaviors.setter
    def behaviors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "behaviors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dynamicMembership")
    def dynamic_membership(self) -> Optional[pulumi.Input['GroupDynamicMembershipArgs']]:
        """
        A `dynamic_membership` block as documented below. Required when `types` contains `DynamicMembership`. Cannot be used with the `members` property.
        """
        return pulumi.get(self, "dynamic_membership")

    @dynamic_membership.setter
    def dynamic_membership(self, value: Optional[pulumi.Input['GroupDynamicMembershipArgs']]):
        pulumi.set(self, "dynamic_membership", value)

    @_builtins.property
    @pulumi.getter(name="externalSendersAllowed")
    def external_senders_allowed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether people external to the organization can send messages to the group. Can only be set for Unified groups.

        > **Known Permissions Issue** The `external_senders_allowed` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        """
        return pulumi.get(self, "external_senders_allowed")

    @external_senders_allowed.setter
    def external_senders_allowed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external_senders_allowed", value)

    @_builtins.property
    @pulumi.getter(name="hideFromAddressLists")
    def hide_from_address_lists(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the group is displayed in certain parts of the Outlook user interface: in the Address Book, in address lists for selecting message recipients, and in the Browse Groups dialog for searching groups. Can only be set for Unified groups.

        > **Known Permissions Issue** The `hide_from_address_lists` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        """
        return pulumi.get(self, "hide_from_address_lists")

    @hide_from_address_lists.setter
    def hide_from_address_lists(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_from_address_lists", value)

    @_builtins.property
    @pulumi.getter(name="hideFromOutlookClients")
    def hide_from_outlook_clients(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the group is displayed in Outlook clients, such as Outlook for Windows and Outlook on the web. Can only be set for Unified groups.

        > **Known Permissions Issue** The `hide_from_outlook_clients` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        """
        return pulumi.get(self, "hide_from_outlook_clients")

    @hide_from_outlook_clients.setter
    def hide_from_outlook_clients(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_from_outlook_clients", value)

    @_builtins.property
    @pulumi.getter(name="mailEnabled")
    def mail_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the group is a mail enabled, with a shared group mailbox. At least one of `mail_enabled` or `security_enabled` must be specified. Only Microsoft 365 groups can be mail enabled (see the `types` property).
        """
        return pulumi.get(self, "mail_enabled")

    @mail_enabled.setter
    def mail_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mail_enabled", value)

    @_builtins.property
    @pulumi.getter(name="mailNickname")
    def mail_nickname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mail alias for the group, unique in the organisation. Required for mail-enabled groups. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "mail_nickname")

    @mail_nickname.setter
    def mail_nickname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mail_nickname", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of members who should be present in this group. Supported object types are Users, Groups or Service Principals. Cannot be used with the `dynamic_membership` block.

        !> **Warning** Do not use the `members` property at the same time as the GroupMember resource for the same group. Doing so will cause a conflict and group members will be removed.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter(name="onpremisesGroupType")
    def onpremises_group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The on-premises group type that the AAD group will be written as, when writeback is enabled. Possible values are `UniversalDistributionGroup`, `UniversalMailEnabledSecurityGroup`, or `UniversalSecurityGroup`.
        """
        return pulumi.get(self, "onpremises_group_type")

    @onpremises_group_type.setter
    def onpremises_group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "onpremises_group_type", value)

    @_builtins.property
    @pulumi.getter
    def owners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of owners who own this group. Supported object types are Users or Service Principals
        """
        return pulumi.get(self, "owners")

    @owners.setter
    def owners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "owners", value)

    @_builtins.property
    @pulumi.getter(name="preventDuplicateNames")
    def prevent_duplicate_names(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, will return an error if an existing group is found with the same name. Defaults to `false`.
        """
        return pulumi.get(self, "prevent_duplicate_names")

    @prevent_duplicate_names.setter
    def prevent_duplicate_names(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prevent_duplicate_names", value)

    @_builtins.property
    @pulumi.getter(name="provisioningOptions")
    def provisioning_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of provisioning options for a Microsoft 365 group. The only supported value is `Team`. See [official documentation](https://docs.microsoft.com/en-us/graph/group-set-options) for details. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "provisioning_options")

    @provisioning_options.setter
    def provisioning_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "provisioning_options", value)

    @_builtins.property
    @pulumi.getter(name="securityEnabled")
    def security_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the group is a security group for controlling access to in-app resources. At least one of `security_enabled` or `mail_enabled` must be specified. A Microsoft 365 group can be security enabled _and_ mail enabled (see the `types` property).
        """
        return pulumi.get(self, "security_enabled")

    @security_enabled.setter
    def security_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "security_enabled", value)

    @_builtins.property
    @pulumi.getter
    def theme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The colour theme for a Microsoft 365 group. Possible values are `Blue`, `Green`, `Orange`, `Pink`, `Purple`, `Red` or `Teal`. By default, no theme is set.
        """
        return pulumi.get(self, "theme")

    @theme.setter
    def theme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "theme", value)

    @_builtins.property
    @pulumi.getter
    def types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of group types to configure for the group. Supported values are `DynamicMembership`, which denotes a group with dynamic membership, and `Unified`, which specifies a Microsoft 365 group. Required when `mail_enabled` is true. Changing this forces a new resource to be created.

        > **Supported Group Types** At present, only security groups and Microsoft 365 groups can be created or managed with this resource. Distribution groups and mail-enabled security groups are not supported. Microsoft 365 groups can be security-enabled.
        """
        return pulumi.get(self, "types")

    @types.setter
    def types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "types", value)

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The group join policy and group content visibility. Possible values are `Private`, `Public`, or `Hiddenmembership`. Only Microsoft 365 groups can have `Hiddenmembership` visibility and this value must be set when the group is created. By default, security groups will receive `Private` visibility and Microsoft 365 groups will receive `Public` visibility.

        > **Group Name Uniqueness** Group names are not unique within Azure Active Directory. Use the `prevent_duplicate_names` argument to check for existing groups if you want to avoid name collisions.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "visibility", value)

    @_builtins.property
    @pulumi.getter(name="writebackEnabled")
    def writeback_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the group will be written back to the configured on-premises Active Directory when Azure AD Connect is used.
        """
        return pulumi.get(self, "writeback_enabled")

    @writeback_enabled.setter
    def writeback_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "writeback_enabled", value)


@pulumi.input_type
class _GroupState:
    def __init__(__self__, *,
                 administrative_unit_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 assignable_to_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_subscribe_new_members: Optional[pulumi.Input[_builtins.bool]] = None,
                 behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_membership: Optional[pulumi.Input['GroupDynamicMembershipArgs']] = None,
                 external_senders_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_from_address_lists: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_from_outlook_clients: Optional[pulumi.Input[_builtins.bool]] = None,
                 mail: Optional[pulumi.Input[_builtins.str]] = None,
                 mail_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 mail_nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 object_id: Optional[pulumi.Input[_builtins.str]] = None,
                 onpremises_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 onpremises_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 onpremises_netbios_name: Optional[pulumi.Input[_builtins.str]] = None,
                 onpremises_sam_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 onpremises_security_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 onpremises_sync_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 owners: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 preferred_language: Optional[pulumi.Input[_builtins.str]] = None,
                 prevent_duplicate_names: Optional[pulumi.Input[_builtins.bool]] = None,
                 provisioning_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 proxy_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 theme: Optional[pulumi.Input[_builtins.str]] = None,
                 types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 writeback_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Group resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] administrative_unit_ids: The object IDs of administrative units in which the group is a member. If specified, new groups will be created in the scope of the first administrative unit and added to the others. If empty, new groups will be created at the tenant level.
               
               > **Caution** When using the AdministrativeUnitMember resource, or the `members` property of the AdministrativeUnit resource, to manage Administrative Unit membership for a group, you will need to use an `ignore_changes = [administrative_unit_ids]` lifecycle meta argument for the `Group` resource, in order to avoid a persistent diff.
        :param pulumi.Input[_builtins.bool] assignable_to_role: Indicates whether this group can be assigned to an Azure Active Directory role. Defaults to `false`. Can only be set to `true` for security-enabled groups. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] auto_subscribe_new_members: Indicates whether new members added to the group will be auto-subscribed to receive email notifications. Can only be set for Unified groups.
               
               > **Known Permissions Issue** The `auto_subscribe_new_members` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] behaviors: A set of behaviors for a Microsoft 365 group. Possible values are `AllowOnlyMembersToPost`, `HideGroupInOutlook`, `SkipExchangeInstantOn`, `SubscribeMembersToCalendarEventsDisabled`, `SubscribeNewGroupMembers` and `WelcomeEmailDisabled`. See [official documentation](https://docs.microsoft.com/en-us/graph/group-set-options) for more details. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: The description for the group.
        :param pulumi.Input[_builtins.str] display_name: The display name for the group.
        :param pulumi.Input['GroupDynamicMembershipArgs'] dynamic_membership: A `dynamic_membership` block as documented below. Required when `types` contains `DynamicMembership`. Cannot be used with the `members` property.
        :param pulumi.Input[_builtins.bool] external_senders_allowed: Indicates whether people external to the organization can send messages to the group. Can only be set for Unified groups.
               
               > **Known Permissions Issue** The `external_senders_allowed` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        :param pulumi.Input[_builtins.bool] hide_from_address_lists: Indicates whether the group is displayed in certain parts of the Outlook user interface: in the Address Book, in address lists for selecting message recipients, and in the Browse Groups dialog for searching groups. Can only be set for Unified groups.
               
               > **Known Permissions Issue** The `hide_from_address_lists` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        :param pulumi.Input[_builtins.bool] hide_from_outlook_clients: Indicates whether the group is displayed in Outlook clients, such as Outlook for Windows and Outlook on the web. Can only be set for Unified groups.
               
               > **Known Permissions Issue** The `hide_from_outlook_clients` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        :param pulumi.Input[_builtins.str] mail: The SMTP address for the group.
        :param pulumi.Input[_builtins.bool] mail_enabled: Whether the group is a mail enabled, with a shared group mailbox. At least one of `mail_enabled` or `security_enabled` must be specified. Only Microsoft 365 groups can be mail enabled (see the `types` property).
        :param pulumi.Input[_builtins.str] mail_nickname: The mail alias for the group, unique in the organisation. Required for mail-enabled groups. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: A set of members who should be present in this group. Supported object types are Users, Groups or Service Principals. Cannot be used with the `dynamic_membership` block.
               
               !> **Warning** Do not use the `members` property at the same time as the GroupMember resource for the same group. Doing so will cause a conflict and group members will be removed.
        :param pulumi.Input[_builtins.str] object_id: The object ID of the group.
        :param pulumi.Input[_builtins.str] onpremises_domain_name: The on-premises FQDN, also called dnsDomainName, synchronised from the on-premises directory when Azure AD Connect is used.
        :param pulumi.Input[_builtins.str] onpremises_group_type: The on-premises group type that the AAD group will be written as, when writeback is enabled. Possible values are `UniversalDistributionGroup`, `UniversalMailEnabledSecurityGroup`, or `UniversalSecurityGroup`.
        :param pulumi.Input[_builtins.str] onpremises_netbios_name: The on-premises NetBIOS name, synchronised from the on-premises directory when Azure AD Connect is used.
        :param pulumi.Input[_builtins.str] onpremises_sam_account_name: The on-premises SAM account name, synchronised from the on-premises directory when Azure AD Connect is used.
        :param pulumi.Input[_builtins.str] onpremises_security_identifier: The on-premises security identifier (SID), synchronised from the on-premises directory when Azure AD Connect is used.
        :param pulumi.Input[_builtins.bool] onpremises_sync_enabled: Whether this group is synchronised from an on-premises directory (`true`), no longer synchronised (`false`), or has never been synchronised (`null`).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] owners: A set of owners who own this group. Supported object types are Users or Service Principals
        :param pulumi.Input[_builtins.str] preferred_language: The preferred language for a Microsoft 365 group, in ISO 639-1 notation.
        :param pulumi.Input[_builtins.bool] prevent_duplicate_names: If `true`, will return an error if an existing group is found with the same name. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] provisioning_options: A set of provisioning options for a Microsoft 365 group. The only supported value is `Team`. See [official documentation](https://docs.microsoft.com/en-us/graph/group-set-options) for details. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] proxy_addresses: List of email addresses for the group that direct to the same group mailbox.
        :param pulumi.Input[_builtins.bool] security_enabled: Whether the group is a security group for controlling access to in-app resources. At least one of `security_enabled` or `mail_enabled` must be specified. A Microsoft 365 group can be security enabled _and_ mail enabled (see the `types` property).
        :param pulumi.Input[_builtins.str] theme: The colour theme for a Microsoft 365 group. Possible values are `Blue`, `Green`, `Orange`, `Pink`, `Purple`, `Red` or `Teal`. By default, no theme is set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] types: A set of group types to configure for the group. Supported values are `DynamicMembership`, which denotes a group with dynamic membership, and `Unified`, which specifies a Microsoft 365 group. Required when `mail_enabled` is true. Changing this forces a new resource to be created.
               
               > **Supported Group Types** At present, only security groups and Microsoft 365 groups can be created or managed with this resource. Distribution groups and mail-enabled security groups are not supported. Microsoft 365 groups can be security-enabled.
        :param pulumi.Input[_builtins.str] visibility: The group join policy and group content visibility. Possible values are `Private`, `Public`, or `Hiddenmembership`. Only Microsoft 365 groups can have `Hiddenmembership` visibility and this value must be set when the group is created. By default, security groups will receive `Private` visibility and Microsoft 365 groups will receive `Public` visibility.
               
               > **Group Name Uniqueness** Group names are not unique within Azure Active Directory. Use the `prevent_duplicate_names` argument to check for existing groups if you want to avoid name collisions.
        :param pulumi.Input[_builtins.bool] writeback_enabled: Whether the group will be written back to the configured on-premises Active Directory when Azure AD Connect is used.
        """
        if administrative_unit_ids is not None:
            pulumi.set(__self__, "administrative_unit_ids", administrative_unit_ids)
        if assignable_to_role is not None:
            pulumi.set(__self__, "assignable_to_role", assignable_to_role)
        if auto_subscribe_new_members is not None:
            pulumi.set(__self__, "auto_subscribe_new_members", auto_subscribe_new_members)
        if behaviors is not None:
            pulumi.set(__self__, "behaviors", behaviors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dynamic_membership is not None:
            pulumi.set(__self__, "dynamic_membership", dynamic_membership)
        if external_senders_allowed is not None:
            pulumi.set(__self__, "external_senders_allowed", external_senders_allowed)
        if hide_from_address_lists is not None:
            pulumi.set(__self__, "hide_from_address_lists", hide_from_address_lists)
        if hide_from_outlook_clients is not None:
            pulumi.set(__self__, "hide_from_outlook_clients", hide_from_outlook_clients)
        if mail is not None:
            pulumi.set(__self__, "mail", mail)
        if mail_enabled is not None:
            pulumi.set(__self__, "mail_enabled", mail_enabled)
        if mail_nickname is not None:
            pulumi.set(__self__, "mail_nickname", mail_nickname)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)
        if onpremises_domain_name is not None:
            pulumi.set(__self__, "onpremises_domain_name", onpremises_domain_name)
        if onpremises_group_type is not None:
            pulumi.set(__self__, "onpremises_group_type", onpremises_group_type)
        if onpremises_netbios_name is not None:
            pulumi.set(__self__, "onpremises_netbios_name", onpremises_netbios_name)
        if onpremises_sam_account_name is not None:
            pulumi.set(__self__, "onpremises_sam_account_name", onpremises_sam_account_name)
        if onpremises_security_identifier is not None:
            pulumi.set(__self__, "onpremises_security_identifier", onpremises_security_identifier)
        if onpremises_sync_enabled is not None:
            pulumi.set(__self__, "onpremises_sync_enabled", onpremises_sync_enabled)
        if owners is not None:
            pulumi.set(__self__, "owners", owners)
        if preferred_language is not None:
            pulumi.set(__self__, "preferred_language", preferred_language)
        if prevent_duplicate_names is not None:
            pulumi.set(__self__, "prevent_duplicate_names", prevent_duplicate_names)
        if provisioning_options is not None:
            pulumi.set(__self__, "provisioning_options", provisioning_options)
        if proxy_addresses is not None:
            pulumi.set(__self__, "proxy_addresses", proxy_addresses)
        if security_enabled is not None:
            pulumi.set(__self__, "security_enabled", security_enabled)
        if theme is not None:
            pulumi.set(__self__, "theme", theme)
        if types is not None:
            pulumi.set(__self__, "types", types)
        if visibility is not None:
            pulumi.set(__self__, "visibility", visibility)
        if writeback_enabled is not None:
            pulumi.set(__self__, "writeback_enabled", writeback_enabled)

    @_builtins.property
    @pulumi.getter(name="administrativeUnitIds")
    def administrative_unit_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The object IDs of administrative units in which the group is a member. If specified, new groups will be created in the scope of the first administrative unit and added to the others. If empty, new groups will be created at the tenant level.

        > **Caution** When using the AdministrativeUnitMember resource, or the `members` property of the AdministrativeUnit resource, to manage Administrative Unit membership for a group, you will need to use an `ignore_changes = [administrative_unit_ids]` lifecycle meta argument for the `Group` resource, in order to avoid a persistent diff.
        """
        return pulumi.get(self, "administrative_unit_ids")

    @administrative_unit_ids.setter
    def administrative_unit_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "administrative_unit_ids", value)

    @_builtins.property
    @pulumi.getter(name="assignableToRole")
    def assignable_to_role(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether this group can be assigned to an Azure Active Directory role. Defaults to `false`. Can only be set to `true` for security-enabled groups. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "assignable_to_role")

    @assignable_to_role.setter
    def assignable_to_role(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "assignable_to_role", value)

    @_builtins.property
    @pulumi.getter(name="autoSubscribeNewMembers")
    def auto_subscribe_new_members(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether new members added to the group will be auto-subscribed to receive email notifications. Can only be set for Unified groups.

        > **Known Permissions Issue** The `auto_subscribe_new_members` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        """
        return pulumi.get(self, "auto_subscribe_new_members")

    @auto_subscribe_new_members.setter
    def auto_subscribe_new_members(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_subscribe_new_members", value)

    @_builtins.property
    @pulumi.getter
    def behaviors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of behaviors for a Microsoft 365 group. Possible values are `AllowOnlyMembersToPost`, `HideGroupInOutlook`, `SkipExchangeInstantOn`, `SubscribeMembersToCalendarEventsDisabled`, `SubscribeNewGroupMembers` and `WelcomeEmailDisabled`. See [official documentation](https://docs.microsoft.com/en-us/graph/group-set-options) for more details. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "behaviors")

    @behaviors.setter
    def behaviors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "behaviors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name for the group.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="dynamicMembership")
    def dynamic_membership(self) -> Optional[pulumi.Input['GroupDynamicMembershipArgs']]:
        """
        A `dynamic_membership` block as documented below. Required when `types` contains `DynamicMembership`. Cannot be used with the `members` property.
        """
        return pulumi.get(self, "dynamic_membership")

    @dynamic_membership.setter
    def dynamic_membership(self, value: Optional[pulumi.Input['GroupDynamicMembershipArgs']]):
        pulumi.set(self, "dynamic_membership", value)

    @_builtins.property
    @pulumi.getter(name="externalSendersAllowed")
    def external_senders_allowed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether people external to the organization can send messages to the group. Can only be set for Unified groups.

        > **Known Permissions Issue** The `external_senders_allowed` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        """
        return pulumi.get(self, "external_senders_allowed")

    @external_senders_allowed.setter
    def external_senders_allowed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "external_senders_allowed", value)

    @_builtins.property
    @pulumi.getter(name="hideFromAddressLists")
    def hide_from_address_lists(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the group is displayed in certain parts of the Outlook user interface: in the Address Book, in address lists for selecting message recipients, and in the Browse Groups dialog for searching groups. Can only be set for Unified groups.

        > **Known Permissions Issue** The `hide_from_address_lists` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        """
        return pulumi.get(self, "hide_from_address_lists")

    @hide_from_address_lists.setter
    def hide_from_address_lists(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_from_address_lists", value)

    @_builtins.property
    @pulumi.getter(name="hideFromOutlookClients")
    def hide_from_outlook_clients(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the group is displayed in Outlook clients, such as Outlook for Windows and Outlook on the web. Can only be set for Unified groups.

        > **Known Permissions Issue** The `hide_from_outlook_clients` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        """
        return pulumi.get(self, "hide_from_outlook_clients")

    @hide_from_outlook_clients.setter
    def hide_from_outlook_clients(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hide_from_outlook_clients", value)

    @_builtins.property
    @pulumi.getter
    def mail(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SMTP address for the group.
        """
        return pulumi.get(self, "mail")

    @mail.setter
    def mail(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mail", value)

    @_builtins.property
    @pulumi.getter(name="mailEnabled")
    def mail_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the group is a mail enabled, with a shared group mailbox. At least one of `mail_enabled` or `security_enabled` must be specified. Only Microsoft 365 groups can be mail enabled (see the `types` property).
        """
        return pulumi.get(self, "mail_enabled")

    @mail_enabled.setter
    def mail_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "mail_enabled", value)

    @_builtins.property
    @pulumi.getter(name="mailNickname")
    def mail_nickname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mail alias for the group, unique in the organisation. Required for mail-enabled groups. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "mail_nickname")

    @mail_nickname.setter
    def mail_nickname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mail_nickname", value)

    @_builtins.property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of members who should be present in this group. Supported object types are Users, Groups or Service Principals. Cannot be used with the `dynamic_membership` block.

        !> **Warning** Do not use the `members` property at the same time as the GroupMember resource for the same group. Doing so will cause a conflict and group members will be removed.
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "members", value)

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The object ID of the group.
        """
        return pulumi.get(self, "object_id")

    @object_id.setter
    def object_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_id", value)

    @_builtins.property
    @pulumi.getter(name="onpremisesDomainName")
    def onpremises_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The on-premises FQDN, also called dnsDomainName, synchronised from the on-premises directory when Azure AD Connect is used.
        """
        return pulumi.get(self, "onpremises_domain_name")

    @onpremises_domain_name.setter
    def onpremises_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "onpremises_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="onpremisesGroupType")
    def onpremises_group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The on-premises group type that the AAD group will be written as, when writeback is enabled. Possible values are `UniversalDistributionGroup`, `UniversalMailEnabledSecurityGroup`, or `UniversalSecurityGroup`.
        """
        return pulumi.get(self, "onpremises_group_type")

    @onpremises_group_type.setter
    def onpremises_group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "onpremises_group_type", value)

    @_builtins.property
    @pulumi.getter(name="onpremisesNetbiosName")
    def onpremises_netbios_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The on-premises NetBIOS name, synchronised from the on-premises directory when Azure AD Connect is used.
        """
        return pulumi.get(self, "onpremises_netbios_name")

    @onpremises_netbios_name.setter
    def onpremises_netbios_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "onpremises_netbios_name", value)

    @_builtins.property
    @pulumi.getter(name="onpremisesSamAccountName")
    def onpremises_sam_account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The on-premises SAM account name, synchronised from the on-premises directory when Azure AD Connect is used.
        """
        return pulumi.get(self, "onpremises_sam_account_name")

    @onpremises_sam_account_name.setter
    def onpremises_sam_account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "onpremises_sam_account_name", value)

    @_builtins.property
    @pulumi.getter(name="onpremisesSecurityIdentifier")
    def onpremises_security_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The on-premises security identifier (SID), synchronised from the on-premises directory when Azure AD Connect is used.
        """
        return pulumi.get(self, "onpremises_security_identifier")

    @onpremises_security_identifier.setter
    def onpremises_security_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "onpremises_security_identifier", value)

    @_builtins.property
    @pulumi.getter(name="onpremisesSyncEnabled")
    def onpremises_sync_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this group is synchronised from an on-premises directory (`true`), no longer synchronised (`false`), or has never been synchronised (`null`).
        """
        return pulumi.get(self, "onpremises_sync_enabled")

    @onpremises_sync_enabled.setter
    def onpremises_sync_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "onpremises_sync_enabled", value)

    @_builtins.property
    @pulumi.getter
    def owners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of owners who own this group. Supported object types are Users or Service Principals
        """
        return pulumi.get(self, "owners")

    @owners.setter
    def owners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "owners", value)

    @_builtins.property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The preferred language for a Microsoft 365 group, in ISO 639-1 notation.
        """
        return pulumi.get(self, "preferred_language")

    @preferred_language.setter
    def preferred_language(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_language", value)

    @_builtins.property
    @pulumi.getter(name="preventDuplicateNames")
    def prevent_duplicate_names(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If `true`, will return an error if an existing group is found with the same name. Defaults to `false`.
        """
        return pulumi.get(self, "prevent_duplicate_names")

    @prevent_duplicate_names.setter
    def prevent_duplicate_names(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "prevent_duplicate_names", value)

    @_builtins.property
    @pulumi.getter(name="provisioningOptions")
    def provisioning_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of provisioning options for a Microsoft 365 group. The only supported value is `Team`. See [official documentation](https://docs.microsoft.com/en-us/graph/group-set-options) for details. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "provisioning_options")

    @provisioning_options.setter
    def provisioning_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "provisioning_options", value)

    @_builtins.property
    @pulumi.getter(name="proxyAddresses")
    def proxy_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of email addresses for the group that direct to the same group mailbox.
        """
        return pulumi.get(self, "proxy_addresses")

    @proxy_addresses.setter
    def proxy_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "proxy_addresses", value)

    @_builtins.property
    @pulumi.getter(name="securityEnabled")
    def security_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the group is a security group for controlling access to in-app resources. At least one of `security_enabled` or `mail_enabled` must be specified. A Microsoft 365 group can be security enabled _and_ mail enabled (see the `types` property).
        """
        return pulumi.get(self, "security_enabled")

    @security_enabled.setter
    def security_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "security_enabled", value)

    @_builtins.property
    @pulumi.getter
    def theme(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The colour theme for a Microsoft 365 group. Possible values are `Blue`, `Green`, `Orange`, `Pink`, `Purple`, `Red` or `Teal`. By default, no theme is set.
        """
        return pulumi.get(self, "theme")

    @theme.setter
    def theme(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "theme", value)

    @_builtins.property
    @pulumi.getter
    def types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A set of group types to configure for the group. Supported values are `DynamicMembership`, which denotes a group with dynamic membership, and `Unified`, which specifies a Microsoft 365 group. Required when `mail_enabled` is true. Changing this forces a new resource to be created.

        > **Supported Group Types** At present, only security groups and Microsoft 365 groups can be created or managed with this resource. Distribution groups and mail-enabled security groups are not supported. Microsoft 365 groups can be security-enabled.
        """
        return pulumi.get(self, "types")

    @types.setter
    def types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "types", value)

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The group join policy and group content visibility. Possible values are `Private`, `Public`, or `Hiddenmembership`. Only Microsoft 365 groups can have `Hiddenmembership` visibility and this value must be set when the group is created. By default, security groups will receive `Private` visibility and Microsoft 365 groups will receive `Public` visibility.

        > **Group Name Uniqueness** Group names are not unique within Azure Active Directory. Use the `prevent_duplicate_names` argument to check for existing groups if you want to avoid name collisions.
        """
        return pulumi.get(self, "visibility")

    @visibility.setter
    def visibility(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "visibility", value)

    @_builtins.property
    @pulumi.getter(name="writebackEnabled")
    def writeback_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the group will be written back to the configured on-premises Active Directory when Azure AD Connect is used.
        """
        return pulumi.get(self, "writeback_enabled")

    @writeback_enabled.setter
    def writeback_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "writeback_enabled", value)


@pulumi.type_token("azuread:index/group:Group")
class Group(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrative_unit_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 assignable_to_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_subscribe_new_members: Optional[pulumi.Input[_builtins.bool]] = None,
                 behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_membership: Optional[pulumi.Input[Union['GroupDynamicMembershipArgs', 'GroupDynamicMembershipArgsDict']]] = None,
                 external_senders_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_from_address_lists: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_from_outlook_clients: Optional[pulumi.Input[_builtins.bool]] = None,
                 mail_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 mail_nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 onpremises_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 owners: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 prevent_duplicate_names: Optional[pulumi.Input[_builtins.bool]] = None,
                 provisioning_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 theme: Optional[pulumi.Input[_builtins.str]] = None,
                 types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 writeback_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a group within Azure Active Directory.

        ## API Permissions

        The following API permissions are required in order to use this resource.

        When authenticated with a service principal, this resource requires one of the following application roles: `Group.ReadWrite.All` or `Directory.ReadWrite.All`.

        Alternatively, if the authenticated service principal is also an owner of the group being managed, this resource can use the application role: `Group.Create`.

        If using the `assignable_to_role` property, this resource additionally requires the `RoleManagement.ReadWrite.Directory` application role.

        If specifying owners for a group, which are user principals, this resource additionally requires one of the following application roles: `User.Read.All`, `User.ReadWrite.All`, `Directory.Read.All` or `Directory.ReadWrite.All`

        When authenticated with a user principal, this resource requires one of the following directory roles: `Groups Administrator`, `User Administrator` or `Global Administrator`

        When creating this resource in administrative units exclusively, the directory role `Groups Administrator` is required to be scoped on any administrative unit used. Additionally, it must be possible to read the administrative units being used, which can be granted through the `AdministrativeUnit.Read.All` or `Directory.Read.All` application roles.

        The `external_senders_allowed`, `auto_subscribe_new_members`, `hide_from_address_lists` and `hide_from_outlook_clients` properties can only be configured when authenticating as a user and cannot be configured when authenticating as a service principal. Additionally, the user being used for authentication must be a Member of the tenant where the group is being managed and _not_ a Guest. This is a known API issue; please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) official documentation.

        ## Example Usage

        *Basic example*

        ```python
        import pulumi
        import pulumi_azuread as azuread

        current = azuread.get_client_config()
        example = azuread.Group("example",
            display_name="example",
            owners=[current.object_id],
            security_enabled=True)
        ```

        *Microsoft 365 group*

        ```python
        import pulumi
        import pulumi_azuread as azuread

        current = azuread.get_client_config()
        group_owner = azuread.User("group_owner",
            user_principal_name="example-group-owner@example.com",
            display_name="Group Owner",
            mail_nickname="example-group-owner",
            password="SecretP@sswd99!")
        example = azuread.Group("example",
            display_name="example",
            mail_enabled=True,
            mail_nickname="ExampleGroup",
            security_enabled=True,
            types=["Unified"],
            owners=[
                current.object_id,
                group_owner.object_id,
            ])
        ```

        *Group with members*

        ## Import

        Groups can be imported using their object ID, e.g.

        ```sh
        $ pulumi import azuread:index/group:Group my_group /groups/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] administrative_unit_ids: The object IDs of administrative units in which the group is a member. If specified, new groups will be created in the scope of the first administrative unit and added to the others. If empty, new groups will be created at the tenant level.
               
               > **Caution** When using the AdministrativeUnitMember resource, or the `members` property of the AdministrativeUnit resource, to manage Administrative Unit membership for a group, you will need to use an `ignore_changes = [administrative_unit_ids]` lifecycle meta argument for the `Group` resource, in order to avoid a persistent diff.
        :param pulumi.Input[_builtins.bool] assignable_to_role: Indicates whether this group can be assigned to an Azure Active Directory role. Defaults to `false`. Can only be set to `true` for security-enabled groups. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] auto_subscribe_new_members: Indicates whether new members added to the group will be auto-subscribed to receive email notifications. Can only be set for Unified groups.
               
               > **Known Permissions Issue** The `auto_subscribe_new_members` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] behaviors: A set of behaviors for a Microsoft 365 group. Possible values are `AllowOnlyMembersToPost`, `HideGroupInOutlook`, `SkipExchangeInstantOn`, `SubscribeMembersToCalendarEventsDisabled`, `SubscribeNewGroupMembers` and `WelcomeEmailDisabled`. See [official documentation](https://docs.microsoft.com/en-us/graph/group-set-options) for more details. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: The description for the group.
        :param pulumi.Input[_builtins.str] display_name: The display name for the group.
        :param pulumi.Input[Union['GroupDynamicMembershipArgs', 'GroupDynamicMembershipArgsDict']] dynamic_membership: A `dynamic_membership` block as documented below. Required when `types` contains `DynamicMembership`. Cannot be used with the `members` property.
        :param pulumi.Input[_builtins.bool] external_senders_allowed: Indicates whether people external to the organization can send messages to the group. Can only be set for Unified groups.
               
               > **Known Permissions Issue** The `external_senders_allowed` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        :param pulumi.Input[_builtins.bool] hide_from_address_lists: Indicates whether the group is displayed in certain parts of the Outlook user interface: in the Address Book, in address lists for selecting message recipients, and in the Browse Groups dialog for searching groups. Can only be set for Unified groups.
               
               > **Known Permissions Issue** The `hide_from_address_lists` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        :param pulumi.Input[_builtins.bool] hide_from_outlook_clients: Indicates whether the group is displayed in Outlook clients, such as Outlook for Windows and Outlook on the web. Can only be set for Unified groups.
               
               > **Known Permissions Issue** The `hide_from_outlook_clients` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        :param pulumi.Input[_builtins.bool] mail_enabled: Whether the group is a mail enabled, with a shared group mailbox. At least one of `mail_enabled` or `security_enabled` must be specified. Only Microsoft 365 groups can be mail enabled (see the `types` property).
        :param pulumi.Input[_builtins.str] mail_nickname: The mail alias for the group, unique in the organisation. Required for mail-enabled groups. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: A set of members who should be present in this group. Supported object types are Users, Groups or Service Principals. Cannot be used with the `dynamic_membership` block.
               
               !> **Warning** Do not use the `members` property at the same time as the GroupMember resource for the same group. Doing so will cause a conflict and group members will be removed.
        :param pulumi.Input[_builtins.str] onpremises_group_type: The on-premises group type that the AAD group will be written as, when writeback is enabled. Possible values are `UniversalDistributionGroup`, `UniversalMailEnabledSecurityGroup`, or `UniversalSecurityGroup`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] owners: A set of owners who own this group. Supported object types are Users or Service Principals
        :param pulumi.Input[_builtins.bool] prevent_duplicate_names: If `true`, will return an error if an existing group is found with the same name. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] provisioning_options: A set of provisioning options for a Microsoft 365 group. The only supported value is `Team`. See [official documentation](https://docs.microsoft.com/en-us/graph/group-set-options) for details. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] security_enabled: Whether the group is a security group for controlling access to in-app resources. At least one of `security_enabled` or `mail_enabled` must be specified. A Microsoft 365 group can be security enabled _and_ mail enabled (see the `types` property).
        :param pulumi.Input[_builtins.str] theme: The colour theme for a Microsoft 365 group. Possible values are `Blue`, `Green`, `Orange`, `Pink`, `Purple`, `Red` or `Teal`. By default, no theme is set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] types: A set of group types to configure for the group. Supported values are `DynamicMembership`, which denotes a group with dynamic membership, and `Unified`, which specifies a Microsoft 365 group. Required when `mail_enabled` is true. Changing this forces a new resource to be created.
               
               > **Supported Group Types** At present, only security groups and Microsoft 365 groups can be created or managed with this resource. Distribution groups and mail-enabled security groups are not supported. Microsoft 365 groups can be security-enabled.
        :param pulumi.Input[_builtins.str] visibility: The group join policy and group content visibility. Possible values are `Private`, `Public`, or `Hiddenmembership`. Only Microsoft 365 groups can have `Hiddenmembership` visibility and this value must be set when the group is created. By default, security groups will receive `Private` visibility and Microsoft 365 groups will receive `Public` visibility.
               
               > **Group Name Uniqueness** Group names are not unique within Azure Active Directory. Use the `prevent_duplicate_names` argument to check for existing groups if you want to avoid name collisions.
        :param pulumi.Input[_builtins.bool] writeback_enabled: Whether the group will be written back to the configured on-premises Active Directory when Azure AD Connect is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a group within Azure Active Directory.

        ## API Permissions

        The following API permissions are required in order to use this resource.

        When authenticated with a service principal, this resource requires one of the following application roles: `Group.ReadWrite.All` or `Directory.ReadWrite.All`.

        Alternatively, if the authenticated service principal is also an owner of the group being managed, this resource can use the application role: `Group.Create`.

        If using the `assignable_to_role` property, this resource additionally requires the `RoleManagement.ReadWrite.Directory` application role.

        If specifying owners for a group, which are user principals, this resource additionally requires one of the following application roles: `User.Read.All`, `User.ReadWrite.All`, `Directory.Read.All` or `Directory.ReadWrite.All`

        When authenticated with a user principal, this resource requires one of the following directory roles: `Groups Administrator`, `User Administrator` or `Global Administrator`

        When creating this resource in administrative units exclusively, the directory role `Groups Administrator` is required to be scoped on any administrative unit used. Additionally, it must be possible to read the administrative units being used, which can be granted through the `AdministrativeUnit.Read.All` or `Directory.Read.All` application roles.

        The `external_senders_allowed`, `auto_subscribe_new_members`, `hide_from_address_lists` and `hide_from_outlook_clients` properties can only be configured when authenticating as a user and cannot be configured when authenticating as a service principal. Additionally, the user being used for authentication must be a Member of the tenant where the group is being managed and _not_ a Guest. This is a known API issue; please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) official documentation.

        ## Example Usage

        *Basic example*

        ```python
        import pulumi
        import pulumi_azuread as azuread

        current = azuread.get_client_config()
        example = azuread.Group("example",
            display_name="example",
            owners=[current.object_id],
            security_enabled=True)
        ```

        *Microsoft 365 group*

        ```python
        import pulumi
        import pulumi_azuread as azuread

        current = azuread.get_client_config()
        group_owner = azuread.User("group_owner",
            user_principal_name="example-group-owner@example.com",
            display_name="Group Owner",
            mail_nickname="example-group-owner",
            password="SecretP@sswd99!")
        example = azuread.Group("example",
            display_name="example",
            mail_enabled=True,
            mail_nickname="ExampleGroup",
            security_enabled=True,
            types=["Unified"],
            owners=[
                current.object_id,
                group_owner.object_id,
            ])
        ```

        *Group with members*

        ## Import

        Groups can be imported using their object ID, e.g.

        ```sh
        $ pulumi import azuread:index/group:Group my_group /groups/00000000-0000-0000-0000-000000000000
        ```

        :param str resource_name: The name of the resource.
        :param GroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrative_unit_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 assignable_to_role: Optional[pulumi.Input[_builtins.bool]] = None,
                 auto_subscribe_new_members: Optional[pulumi.Input[_builtins.bool]] = None,
                 behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_membership: Optional[pulumi.Input[Union['GroupDynamicMembershipArgs', 'GroupDynamicMembershipArgsDict']]] = None,
                 external_senders_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_from_address_lists: Optional[pulumi.Input[_builtins.bool]] = None,
                 hide_from_outlook_clients: Optional[pulumi.Input[_builtins.bool]] = None,
                 mail_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 mail_nickname: Optional[pulumi.Input[_builtins.str]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 onpremises_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 owners: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 prevent_duplicate_names: Optional[pulumi.Input[_builtins.bool]] = None,
                 provisioning_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 theme: Optional[pulumi.Input[_builtins.str]] = None,
                 types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 visibility: Optional[pulumi.Input[_builtins.str]] = None,
                 writeback_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupArgs.__new__(GroupArgs)

            __props__.__dict__["administrative_unit_ids"] = administrative_unit_ids
            __props__.__dict__["assignable_to_role"] = assignable_to_role
            __props__.__dict__["auto_subscribe_new_members"] = auto_subscribe_new_members
            __props__.__dict__["behaviors"] = behaviors
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["dynamic_membership"] = dynamic_membership
            __props__.__dict__["external_senders_allowed"] = external_senders_allowed
            __props__.__dict__["hide_from_address_lists"] = hide_from_address_lists
            __props__.__dict__["hide_from_outlook_clients"] = hide_from_outlook_clients
            __props__.__dict__["mail_enabled"] = mail_enabled
            __props__.__dict__["mail_nickname"] = mail_nickname
            __props__.__dict__["members"] = members
            __props__.__dict__["onpremises_group_type"] = onpremises_group_type
            __props__.__dict__["owners"] = owners
            __props__.__dict__["prevent_duplicate_names"] = prevent_duplicate_names
            __props__.__dict__["provisioning_options"] = provisioning_options
            __props__.__dict__["security_enabled"] = security_enabled
            __props__.__dict__["theme"] = theme
            __props__.__dict__["types"] = types
            __props__.__dict__["visibility"] = visibility
            __props__.__dict__["writeback_enabled"] = writeback_enabled
            __props__.__dict__["mail"] = None
            __props__.__dict__["object_id"] = None
            __props__.__dict__["onpremises_domain_name"] = None
            __props__.__dict__["onpremises_netbios_name"] = None
            __props__.__dict__["onpremises_sam_account_name"] = None
            __props__.__dict__["onpremises_security_identifier"] = None
            __props__.__dict__["onpremises_sync_enabled"] = None
            __props__.__dict__["preferred_language"] = None
            __props__.__dict__["proxy_addresses"] = None
        super(Group, __self__).__init__(
            'azuread:index/group:Group',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            administrative_unit_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            assignable_to_role: Optional[pulumi.Input[_builtins.bool]] = None,
            auto_subscribe_new_members: Optional[pulumi.Input[_builtins.bool]] = None,
            behaviors: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            dynamic_membership: Optional[pulumi.Input[Union['GroupDynamicMembershipArgs', 'GroupDynamicMembershipArgsDict']]] = None,
            external_senders_allowed: Optional[pulumi.Input[_builtins.bool]] = None,
            hide_from_address_lists: Optional[pulumi.Input[_builtins.bool]] = None,
            hide_from_outlook_clients: Optional[pulumi.Input[_builtins.bool]] = None,
            mail: Optional[pulumi.Input[_builtins.str]] = None,
            mail_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            mail_nickname: Optional[pulumi.Input[_builtins.str]] = None,
            members: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            object_id: Optional[pulumi.Input[_builtins.str]] = None,
            onpremises_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
            onpremises_group_type: Optional[pulumi.Input[_builtins.str]] = None,
            onpremises_netbios_name: Optional[pulumi.Input[_builtins.str]] = None,
            onpremises_sam_account_name: Optional[pulumi.Input[_builtins.str]] = None,
            onpremises_security_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            onpremises_sync_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            owners: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            preferred_language: Optional[pulumi.Input[_builtins.str]] = None,
            prevent_duplicate_names: Optional[pulumi.Input[_builtins.bool]] = None,
            provisioning_options: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            proxy_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            security_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            theme: Optional[pulumi.Input[_builtins.str]] = None,
            types: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            visibility: Optional[pulumi.Input[_builtins.str]] = None,
            writeback_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Group':
        """
        Get an existing Group resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] administrative_unit_ids: The object IDs of administrative units in which the group is a member. If specified, new groups will be created in the scope of the first administrative unit and added to the others. If empty, new groups will be created at the tenant level.
               
               > **Caution** When using the AdministrativeUnitMember resource, or the `members` property of the AdministrativeUnit resource, to manage Administrative Unit membership for a group, you will need to use an `ignore_changes = [administrative_unit_ids]` lifecycle meta argument for the `Group` resource, in order to avoid a persistent diff.
        :param pulumi.Input[_builtins.bool] assignable_to_role: Indicates whether this group can be assigned to an Azure Active Directory role. Defaults to `false`. Can only be set to `true` for security-enabled groups. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] auto_subscribe_new_members: Indicates whether new members added to the group will be auto-subscribed to receive email notifications. Can only be set for Unified groups.
               
               > **Known Permissions Issue** The `auto_subscribe_new_members` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] behaviors: A set of behaviors for a Microsoft 365 group. Possible values are `AllowOnlyMembersToPost`, `HideGroupInOutlook`, `SkipExchangeInstantOn`, `SubscribeMembersToCalendarEventsDisabled`, `SubscribeNewGroupMembers` and `WelcomeEmailDisabled`. See [official documentation](https://docs.microsoft.com/en-us/graph/group-set-options) for more details. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: The description for the group.
        :param pulumi.Input[_builtins.str] display_name: The display name for the group.
        :param pulumi.Input[Union['GroupDynamicMembershipArgs', 'GroupDynamicMembershipArgsDict']] dynamic_membership: A `dynamic_membership` block as documented below. Required when `types` contains `DynamicMembership`. Cannot be used with the `members` property.
        :param pulumi.Input[_builtins.bool] external_senders_allowed: Indicates whether people external to the organization can send messages to the group. Can only be set for Unified groups.
               
               > **Known Permissions Issue** The `external_senders_allowed` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        :param pulumi.Input[_builtins.bool] hide_from_address_lists: Indicates whether the group is displayed in certain parts of the Outlook user interface: in the Address Book, in address lists for selecting message recipients, and in the Browse Groups dialog for searching groups. Can only be set for Unified groups.
               
               > **Known Permissions Issue** The `hide_from_address_lists` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        :param pulumi.Input[_builtins.bool] hide_from_outlook_clients: Indicates whether the group is displayed in Outlook clients, such as Outlook for Windows and Outlook on the web. Can only be set for Unified groups.
               
               > **Known Permissions Issue** The `hide_from_outlook_clients` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        :param pulumi.Input[_builtins.str] mail: The SMTP address for the group.
        :param pulumi.Input[_builtins.bool] mail_enabled: Whether the group is a mail enabled, with a shared group mailbox. At least one of `mail_enabled` or `security_enabled` must be specified. Only Microsoft 365 groups can be mail enabled (see the `types` property).
        :param pulumi.Input[_builtins.str] mail_nickname: The mail alias for the group, unique in the organisation. Required for mail-enabled groups. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] members: A set of members who should be present in this group. Supported object types are Users, Groups or Service Principals. Cannot be used with the `dynamic_membership` block.
               
               !> **Warning** Do not use the `members` property at the same time as the GroupMember resource for the same group. Doing so will cause a conflict and group members will be removed.
        :param pulumi.Input[_builtins.str] object_id: The object ID of the group.
        :param pulumi.Input[_builtins.str] onpremises_domain_name: The on-premises FQDN, also called dnsDomainName, synchronised from the on-premises directory when Azure AD Connect is used.
        :param pulumi.Input[_builtins.str] onpremises_group_type: The on-premises group type that the AAD group will be written as, when writeback is enabled. Possible values are `UniversalDistributionGroup`, `UniversalMailEnabledSecurityGroup`, or `UniversalSecurityGroup`.
        :param pulumi.Input[_builtins.str] onpremises_netbios_name: The on-premises NetBIOS name, synchronised from the on-premises directory when Azure AD Connect is used.
        :param pulumi.Input[_builtins.str] onpremises_sam_account_name: The on-premises SAM account name, synchronised from the on-premises directory when Azure AD Connect is used.
        :param pulumi.Input[_builtins.str] onpremises_security_identifier: The on-premises security identifier (SID), synchronised from the on-premises directory when Azure AD Connect is used.
        :param pulumi.Input[_builtins.bool] onpremises_sync_enabled: Whether this group is synchronised from an on-premises directory (`true`), no longer synchronised (`false`), or has never been synchronised (`null`).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] owners: A set of owners who own this group. Supported object types are Users or Service Principals
        :param pulumi.Input[_builtins.str] preferred_language: The preferred language for a Microsoft 365 group, in ISO 639-1 notation.
        :param pulumi.Input[_builtins.bool] prevent_duplicate_names: If `true`, will return an error if an existing group is found with the same name. Defaults to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] provisioning_options: A set of provisioning options for a Microsoft 365 group. The only supported value is `Team`. See [official documentation](https://docs.microsoft.com/en-us/graph/group-set-options) for details. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] proxy_addresses: List of email addresses for the group that direct to the same group mailbox.
        :param pulumi.Input[_builtins.bool] security_enabled: Whether the group is a security group for controlling access to in-app resources. At least one of `security_enabled` or `mail_enabled` must be specified. A Microsoft 365 group can be security enabled _and_ mail enabled (see the `types` property).
        :param pulumi.Input[_builtins.str] theme: The colour theme for a Microsoft 365 group. Possible values are `Blue`, `Green`, `Orange`, `Pink`, `Purple`, `Red` or `Teal`. By default, no theme is set.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] types: A set of group types to configure for the group. Supported values are `DynamicMembership`, which denotes a group with dynamic membership, and `Unified`, which specifies a Microsoft 365 group. Required when `mail_enabled` is true. Changing this forces a new resource to be created.
               
               > **Supported Group Types** At present, only security groups and Microsoft 365 groups can be created or managed with this resource. Distribution groups and mail-enabled security groups are not supported. Microsoft 365 groups can be security-enabled.
        :param pulumi.Input[_builtins.str] visibility: The group join policy and group content visibility. Possible values are `Private`, `Public`, or `Hiddenmembership`. Only Microsoft 365 groups can have `Hiddenmembership` visibility and this value must be set when the group is created. By default, security groups will receive `Private` visibility and Microsoft 365 groups will receive `Public` visibility.
               
               > **Group Name Uniqueness** Group names are not unique within Azure Active Directory. Use the `prevent_duplicate_names` argument to check for existing groups if you want to avoid name collisions.
        :param pulumi.Input[_builtins.bool] writeback_enabled: Whether the group will be written back to the configured on-premises Active Directory when Azure AD Connect is used.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupState.__new__(_GroupState)

        __props__.__dict__["administrative_unit_ids"] = administrative_unit_ids
        __props__.__dict__["assignable_to_role"] = assignable_to_role
        __props__.__dict__["auto_subscribe_new_members"] = auto_subscribe_new_members
        __props__.__dict__["behaviors"] = behaviors
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dynamic_membership"] = dynamic_membership
        __props__.__dict__["external_senders_allowed"] = external_senders_allowed
        __props__.__dict__["hide_from_address_lists"] = hide_from_address_lists
        __props__.__dict__["hide_from_outlook_clients"] = hide_from_outlook_clients
        __props__.__dict__["mail"] = mail
        __props__.__dict__["mail_enabled"] = mail_enabled
        __props__.__dict__["mail_nickname"] = mail_nickname
        __props__.__dict__["members"] = members
        __props__.__dict__["object_id"] = object_id
        __props__.__dict__["onpremises_domain_name"] = onpremises_domain_name
        __props__.__dict__["onpremises_group_type"] = onpremises_group_type
        __props__.__dict__["onpremises_netbios_name"] = onpremises_netbios_name
        __props__.__dict__["onpremises_sam_account_name"] = onpremises_sam_account_name
        __props__.__dict__["onpremises_security_identifier"] = onpremises_security_identifier
        __props__.__dict__["onpremises_sync_enabled"] = onpremises_sync_enabled
        __props__.__dict__["owners"] = owners
        __props__.__dict__["preferred_language"] = preferred_language
        __props__.__dict__["prevent_duplicate_names"] = prevent_duplicate_names
        __props__.__dict__["provisioning_options"] = provisioning_options
        __props__.__dict__["proxy_addresses"] = proxy_addresses
        __props__.__dict__["security_enabled"] = security_enabled
        __props__.__dict__["theme"] = theme
        __props__.__dict__["types"] = types
        __props__.__dict__["visibility"] = visibility
        __props__.__dict__["writeback_enabled"] = writeback_enabled
        return Group(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="administrativeUnitIds")
    def administrative_unit_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The object IDs of administrative units in which the group is a member. If specified, new groups will be created in the scope of the first administrative unit and added to the others. If empty, new groups will be created at the tenant level.

        > **Caution** When using the AdministrativeUnitMember resource, or the `members` property of the AdministrativeUnit resource, to manage Administrative Unit membership for a group, you will need to use an `ignore_changes = [administrative_unit_ids]` lifecycle meta argument for the `Group` resource, in order to avoid a persistent diff.
        """
        return pulumi.get(self, "administrative_unit_ids")

    @_builtins.property
    @pulumi.getter(name="assignableToRole")
    def assignable_to_role(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Indicates whether this group can be assigned to an Azure Active Directory role. Defaults to `false`. Can only be set to `true` for security-enabled groups. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "assignable_to_role")

    @_builtins.property
    @pulumi.getter(name="autoSubscribeNewMembers")
    def auto_subscribe_new_members(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether new members added to the group will be auto-subscribed to receive email notifications. Can only be set for Unified groups.

        > **Known Permissions Issue** The `auto_subscribe_new_members` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        """
        return pulumi.get(self, "auto_subscribe_new_members")

    @_builtins.property
    @pulumi.getter
    def behaviors(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A set of behaviors for a Microsoft 365 group. Possible values are `AllowOnlyMembersToPost`, `HideGroupInOutlook`, `SkipExchangeInstantOn`, `SubscribeMembersToCalendarEventsDisabled`, `SubscribeNewGroupMembers` and `WelcomeEmailDisabled`. See [official documentation](https://docs.microsoft.com/en-us/graph/group-set-options) for more details. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "behaviors")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description for the group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name for the group.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="dynamicMembership")
    def dynamic_membership(self) -> pulumi.Output[Optional['outputs.GroupDynamicMembership']]:
        """
        A `dynamic_membership` block as documented below. Required when `types` contains `DynamicMembership`. Cannot be used with the `members` property.
        """
        return pulumi.get(self, "dynamic_membership")

    @_builtins.property
    @pulumi.getter(name="externalSendersAllowed")
    def external_senders_allowed(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether people external to the organization can send messages to the group. Can only be set for Unified groups.

        > **Known Permissions Issue** The `external_senders_allowed` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        """
        return pulumi.get(self, "external_senders_allowed")

    @_builtins.property
    @pulumi.getter(name="hideFromAddressLists")
    def hide_from_address_lists(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the group is displayed in certain parts of the Outlook user interface: in the Address Book, in address lists for selecting message recipients, and in the Browse Groups dialog for searching groups. Can only be set for Unified groups.

        > **Known Permissions Issue** The `hide_from_address_lists` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        """
        return pulumi.get(self, "hide_from_address_lists")

    @_builtins.property
    @pulumi.getter(name="hideFromOutlookClients")
    def hide_from_outlook_clients(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the group is displayed in Outlook clients, such as Outlook for Windows and Outlook on the web. Can only be set for Unified groups.

        > **Known Permissions Issue** The `hide_from_outlook_clients` property can only be set when authenticating as a Member user of the tenant and _not_ when authenticating as a Guest user or as a service principal. Please see the [Microsoft Graph Known Issues](https://docs.microsoft.com/en-us/graph/known-issues#groups) documentation.
        """
        return pulumi.get(self, "hide_from_outlook_clients")

    @_builtins.property
    @pulumi.getter
    def mail(self) -> pulumi.Output[_builtins.str]:
        """
        The SMTP address for the group.
        """
        return pulumi.get(self, "mail")

    @_builtins.property
    @pulumi.getter(name="mailEnabled")
    def mail_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the group is a mail enabled, with a shared group mailbox. At least one of `mail_enabled` or `security_enabled` must be specified. Only Microsoft 365 groups can be mail enabled (see the `types` property).
        """
        return pulumi.get(self, "mail_enabled")

    @_builtins.property
    @pulumi.getter(name="mailNickname")
    def mail_nickname(self) -> pulumi.Output[_builtins.str]:
        """
        The mail alias for the group, unique in the organisation. Required for mail-enabled groups. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "mail_nickname")

    @_builtins.property
    @pulumi.getter
    def members(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A set of members who should be present in this group. Supported object types are Users, Groups or Service Principals. Cannot be used with the `dynamic_membership` block.

        !> **Warning** Do not use the `members` property at the same time as the GroupMember resource for the same group. Doing so will cause a conflict and group members will be removed.
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> pulumi.Output[_builtins.str]:
        """
        The object ID of the group.
        """
        return pulumi.get(self, "object_id")

    @_builtins.property
    @pulumi.getter(name="onpremisesDomainName")
    def onpremises_domain_name(self) -> pulumi.Output[_builtins.str]:
        """
        The on-premises FQDN, also called dnsDomainName, synchronised from the on-premises directory when Azure AD Connect is used.
        """
        return pulumi.get(self, "onpremises_domain_name")

    @_builtins.property
    @pulumi.getter(name="onpremisesGroupType")
    def onpremises_group_type(self) -> pulumi.Output[_builtins.str]:
        """
        The on-premises group type that the AAD group will be written as, when writeback is enabled. Possible values are `UniversalDistributionGroup`, `UniversalMailEnabledSecurityGroup`, or `UniversalSecurityGroup`.
        """
        return pulumi.get(self, "onpremises_group_type")

    @_builtins.property
    @pulumi.getter(name="onpremisesNetbiosName")
    def onpremises_netbios_name(self) -> pulumi.Output[_builtins.str]:
        """
        The on-premises NetBIOS name, synchronised from the on-premises directory when Azure AD Connect is used.
        """
        return pulumi.get(self, "onpremises_netbios_name")

    @_builtins.property
    @pulumi.getter(name="onpremisesSamAccountName")
    def onpremises_sam_account_name(self) -> pulumi.Output[_builtins.str]:
        """
        The on-premises SAM account name, synchronised from the on-premises directory when Azure AD Connect is used.
        """
        return pulumi.get(self, "onpremises_sam_account_name")

    @_builtins.property
    @pulumi.getter(name="onpremisesSecurityIdentifier")
    def onpremises_security_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The on-premises security identifier (SID), synchronised from the on-premises directory when Azure AD Connect is used.
        """
        return pulumi.get(self, "onpremises_security_identifier")

    @_builtins.property
    @pulumi.getter(name="onpremisesSyncEnabled")
    def onpremises_sync_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether this group is synchronised from an on-premises directory (`true`), no longer synchronised (`false`), or has never been synchronised (`null`).
        """
        return pulumi.get(self, "onpremises_sync_enabled")

    @_builtins.property
    @pulumi.getter
    def owners(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A set of owners who own this group. Supported object types are Users or Service Principals
        """
        return pulumi.get(self, "owners")

    @_builtins.property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> pulumi.Output[_builtins.str]:
        """
        The preferred language for a Microsoft 365 group, in ISO 639-1 notation.
        """
        return pulumi.get(self, "preferred_language")

    @_builtins.property
    @pulumi.getter(name="preventDuplicateNames")
    def prevent_duplicate_names(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If `true`, will return an error if an existing group is found with the same name. Defaults to `false`.
        """
        return pulumi.get(self, "prevent_duplicate_names")

    @_builtins.property
    @pulumi.getter(name="provisioningOptions")
    def provisioning_options(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A set of provisioning options for a Microsoft 365 group. The only supported value is `Team`. See [official documentation](https://docs.microsoft.com/en-us/graph/group-set-options) for details. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "provisioning_options")

    @_builtins.property
    @pulumi.getter(name="proxyAddresses")
    def proxy_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of email addresses for the group that direct to the same group mailbox.
        """
        return pulumi.get(self, "proxy_addresses")

    @_builtins.property
    @pulumi.getter(name="securityEnabled")
    def security_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the group is a security group for controlling access to in-app resources. At least one of `security_enabled` or `mail_enabled` must be specified. A Microsoft 365 group can be security enabled _and_ mail enabled (see the `types` property).
        """
        return pulumi.get(self, "security_enabled")

    @_builtins.property
    @pulumi.getter
    def theme(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The colour theme for a Microsoft 365 group. Possible values are `Blue`, `Green`, `Orange`, `Pink`, `Purple`, `Red` or `Teal`. By default, no theme is set.
        """
        return pulumi.get(self, "theme")

    @_builtins.property
    @pulumi.getter
    def types(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A set of group types to configure for the group. Supported values are `DynamicMembership`, which denotes a group with dynamic membership, and `Unified`, which specifies a Microsoft 365 group. Required when `mail_enabled` is true. Changing this forces a new resource to be created.

        > **Supported Group Types** At present, only security groups and Microsoft 365 groups can be created or managed with this resource. Distribution groups and mail-enabled security groups are not supported. Microsoft 365 groups can be security-enabled.
        """
        return pulumi.get(self, "types")

    @_builtins.property
    @pulumi.getter
    def visibility(self) -> pulumi.Output[_builtins.str]:
        """
        The group join policy and group content visibility. Possible values are `Private`, `Public`, or `Hiddenmembership`. Only Microsoft 365 groups can have `Hiddenmembership` visibility and this value must be set when the group is created. By default, security groups will receive `Private` visibility and Microsoft 365 groups will receive `Public` visibility.

        > **Group Name Uniqueness** Group names are not unique within Azure Active Directory. Use the `prevent_duplicate_names` argument to check for existing groups if you want to avoid name collisions.
        """
        return pulumi.get(self, "visibility")

    @_builtins.property
    @pulumi.getter(name="writebackEnabled")
    def writeback_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the group will be written back to the configured on-premises Active Directory when Azure AD Connect is used.
        """
        return pulumi.get(self, "writeback_enabled")

