# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InvitationArgs', 'Invitation']

@pulumi.input_type
class InvitationArgs:
    def __init__(__self__, *,
                 redirect_url: pulumi.Input[_builtins.str],
                 user_email_address: pulumi.Input[_builtins.str],
                 message: Optional[pulumi.Input['InvitationMessageArgs']] = None,
                 user_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Invitation resource.
        :param pulumi.Input[_builtins.str] redirect_url: The URL that the user should be redirected to once the invitation is redeemed.
        :param pulumi.Input[_builtins.str] user_email_address: The email address of the user being invited.
        :param pulumi.Input['InvitationMessageArgs'] message: A `message` block as documented below, which configures the message being sent to the invited user. If this block is omitted, no message will be sent.
        :param pulumi.Input[_builtins.str] user_display_name: The display name of the user being invited.
        :param pulumi.Input[_builtins.str] user_type: The user type of the user being invited. Must be one of `Guest` or `Member`. Only Global Administrators can invite users as members. Defaults to `Guest`.
        """
        pulumi.set(__self__, "redirect_url", redirect_url)
        pulumi.set(__self__, "user_email_address", user_email_address)
        if message is not None:
            pulumi.set(__self__, "message", message)
        if user_display_name is not None:
            pulumi.set(__self__, "user_display_name", user_display_name)
        if user_type is not None:
            pulumi.set(__self__, "user_type", user_type)

    @_builtins.property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> pulumi.Input[_builtins.str]:
        """
        The URL that the user should be redirected to once the invitation is redeemed.
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "redirect_url", value)

    @_builtins.property
    @pulumi.getter(name="userEmailAddress")
    def user_email_address(self) -> pulumi.Input[_builtins.str]:
        """
        The email address of the user being invited.
        """
        return pulumi.get(self, "user_email_address")

    @user_email_address.setter
    def user_email_address(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_email_address", value)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input['InvitationMessageArgs']]:
        """
        A `message` block as documented below, which configures the message being sent to the invited user. If this block is omitted, no message will be sent.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input['InvitationMessageArgs']]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter(name="userDisplayName")
    def user_display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the user being invited.
        """
        return pulumi.get(self, "user_display_name")

    @user_display_name.setter
    def user_display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_display_name", value)

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user type of the user being invited. Must be one of `Guest` or `Member`. Only Global Administrators can invite users as members. Defaults to `Guest`.
        """
        return pulumi.get(self, "user_type")

    @user_type.setter
    def user_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_type", value)


@pulumi.input_type
class _InvitationState:
    def __init__(__self__, *,
                 message: Optional[pulumi.Input['InvitationMessageArgs']] = None,
                 redeem_url: Optional[pulumi.Input[_builtins.str]] = None,
                 redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 user_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_email_address: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Invitation resources.
        :param pulumi.Input['InvitationMessageArgs'] message: A `message` block as documented below, which configures the message being sent to the invited user. If this block is omitted, no message will be sent.
        :param pulumi.Input[_builtins.str] redeem_url: The URL the user can use to redeem their invitation.
        :param pulumi.Input[_builtins.str] redirect_url: The URL that the user should be redirected to once the invitation is redeemed.
        :param pulumi.Input[_builtins.str] user_display_name: The display name of the user being invited.
        :param pulumi.Input[_builtins.str] user_email_address: The email address of the user being invited.
        :param pulumi.Input[_builtins.str] user_id: Object ID of the invited user.
        :param pulumi.Input[_builtins.str] user_type: The user type of the user being invited. Must be one of `Guest` or `Member`. Only Global Administrators can invite users as members. Defaults to `Guest`.
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if redeem_url is not None:
            pulumi.set(__self__, "redeem_url", redeem_url)
        if redirect_url is not None:
            pulumi.set(__self__, "redirect_url", redirect_url)
        if user_display_name is not None:
            pulumi.set(__self__, "user_display_name", user_display_name)
        if user_email_address is not None:
            pulumi.set(__self__, "user_email_address", user_email_address)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if user_type is not None:
            pulumi.set(__self__, "user_type", user_type)

    @_builtins.property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input['InvitationMessageArgs']]:
        """
        A `message` block as documented below, which configures the message being sent to the invited user. If this block is omitted, no message will be sent.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input['InvitationMessageArgs']]):
        pulumi.set(self, "message", value)

    @_builtins.property
    @pulumi.getter(name="redeemUrl")
    def redeem_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL the user can use to redeem their invitation.
        """
        return pulumi.get(self, "redeem_url")

    @redeem_url.setter
    def redeem_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redeem_url", value)

    @_builtins.property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URL that the user should be redirected to once the invitation is redeemed.
        """
        return pulumi.get(self, "redirect_url")

    @redirect_url.setter
    def redirect_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redirect_url", value)

    @_builtins.property
    @pulumi.getter(name="userDisplayName")
    def user_display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the user being invited.
        """
        return pulumi.get(self, "user_display_name")

    @user_display_name.setter
    def user_display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_display_name", value)

    @_builtins.property
    @pulumi.getter(name="userEmailAddress")
    def user_email_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email address of the user being invited.
        """
        return pulumi.get(self, "user_email_address")

    @user_email_address.setter
    def user_email_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_email_address", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Object ID of the invited user.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user type of the user being invited. Must be one of `Guest` or `Member`. Only Global Administrators can invite users as members. Defaults to `Guest`.
        """
        return pulumi.get(self, "user_type")

    @user_type.setter
    def user_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_type", value)


@pulumi.type_token("azuread:index/invitation:Invitation")
class Invitation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 message: Optional[pulumi.Input[Union['InvitationMessageArgs', 'InvitationMessageArgsDict']]] = None,
                 redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 user_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_email_address: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an invitation of a guest user within Azure Active Directory.

        ## API Permissions

        The following API permissions are required in order to use this resource.

        When authenticated with a service principal, this resource requires one of the following application roles: `User.Invite.All`, `User.ReadWrite.All` or `Directory.ReadWrite.All`

        When authenticated with a user principal, this resource requires one of the following directory roles: `Guest Inviter`, `User Administrator` or `Global Administrator`

        ## Example Usage

        *Basic example*

        ```python
        import pulumi
        import pulumi_azuread as azuread

        example = azuread.Invitation("example",
            user_email_address="jdoe@example.com",
            redirect_url="https://portal.azure.com")
        ```

        *Invitation with standard message*

        ```python
        import pulumi
        import pulumi_azuread as azuread

        example = azuread.Invitation("example",
            user_email_address="jdoe@example.com",
            redirect_url="https://portal.azure.com",
            message={
                "language": "en-US",
            })
        ```

        *Invitation with custom message body and an additional recipient*

        ```python
        import pulumi
        import pulumi_azuread as azuread

        example = azuread.Invitation("example",
            user_display_name="Bob Bobson",
            user_email_address="bbobson@example.com",
            redirect_url="https://portal.azure.com",
            message={
                "additional_recipients": "aaliceberg@example.com",
                "body": "Hello there! You are invited to join my Azure tenant!",
            })
        ```

        ## Import

        This resource does not support importing.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InvitationMessageArgs', 'InvitationMessageArgsDict']] message: A `message` block as documented below, which configures the message being sent to the invited user. If this block is omitted, no message will be sent.
        :param pulumi.Input[_builtins.str] redirect_url: The URL that the user should be redirected to once the invitation is redeemed.
        :param pulumi.Input[_builtins.str] user_display_name: The display name of the user being invited.
        :param pulumi.Input[_builtins.str] user_email_address: The email address of the user being invited.
        :param pulumi.Input[_builtins.str] user_type: The user type of the user being invited. Must be one of `Guest` or `Member`. Only Global Administrators can invite users as members. Defaults to `Guest`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InvitationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an invitation of a guest user within Azure Active Directory.

        ## API Permissions

        The following API permissions are required in order to use this resource.

        When authenticated with a service principal, this resource requires one of the following application roles: `User.Invite.All`, `User.ReadWrite.All` or `Directory.ReadWrite.All`

        When authenticated with a user principal, this resource requires one of the following directory roles: `Guest Inviter`, `User Administrator` or `Global Administrator`

        ## Example Usage

        *Basic example*

        ```python
        import pulumi
        import pulumi_azuread as azuread

        example = azuread.Invitation("example",
            user_email_address="jdoe@example.com",
            redirect_url="https://portal.azure.com")
        ```

        *Invitation with standard message*

        ```python
        import pulumi
        import pulumi_azuread as azuread

        example = azuread.Invitation("example",
            user_email_address="jdoe@example.com",
            redirect_url="https://portal.azure.com",
            message={
                "language": "en-US",
            })
        ```

        *Invitation with custom message body and an additional recipient*

        ```python
        import pulumi
        import pulumi_azuread as azuread

        example = azuread.Invitation("example",
            user_display_name="Bob Bobson",
            user_email_address="bbobson@example.com",
            redirect_url="https://portal.azure.com",
            message={
                "additional_recipients": "aaliceberg@example.com",
                "body": "Hello there! You are invited to join my Azure tenant!",
            })
        ```

        ## Import

        This resource does not support importing.

        :param str resource_name: The name of the resource.
        :param InvitationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InvitationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 message: Optional[pulumi.Input[Union['InvitationMessageArgs', 'InvitationMessageArgsDict']]] = None,
                 redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
                 user_display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_email_address: Optional[pulumi.Input[_builtins.str]] = None,
                 user_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InvitationArgs.__new__(InvitationArgs)

            __props__.__dict__["message"] = message
            if redirect_url is None and not opts.urn:
                raise TypeError("Missing required property 'redirect_url'")
            __props__.__dict__["redirect_url"] = redirect_url
            __props__.__dict__["user_display_name"] = user_display_name
            if user_email_address is None and not opts.urn:
                raise TypeError("Missing required property 'user_email_address'")
            __props__.__dict__["user_email_address"] = user_email_address
            __props__.__dict__["user_type"] = user_type
            __props__.__dict__["redeem_url"] = None
            __props__.__dict__["user_id"] = None
        super(Invitation, __self__).__init__(
            'azuread:index/invitation:Invitation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            message: Optional[pulumi.Input[Union['InvitationMessageArgs', 'InvitationMessageArgsDict']]] = None,
            redeem_url: Optional[pulumi.Input[_builtins.str]] = None,
            redirect_url: Optional[pulumi.Input[_builtins.str]] = None,
            user_display_name: Optional[pulumi.Input[_builtins.str]] = None,
            user_email_address: Optional[pulumi.Input[_builtins.str]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Invitation':
        """
        Get an existing Invitation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InvitationMessageArgs', 'InvitationMessageArgsDict']] message: A `message` block as documented below, which configures the message being sent to the invited user. If this block is omitted, no message will be sent.
        :param pulumi.Input[_builtins.str] redeem_url: The URL the user can use to redeem their invitation.
        :param pulumi.Input[_builtins.str] redirect_url: The URL that the user should be redirected to once the invitation is redeemed.
        :param pulumi.Input[_builtins.str] user_display_name: The display name of the user being invited.
        :param pulumi.Input[_builtins.str] user_email_address: The email address of the user being invited.
        :param pulumi.Input[_builtins.str] user_id: Object ID of the invited user.
        :param pulumi.Input[_builtins.str] user_type: The user type of the user being invited. Must be one of `Guest` or `Member`. Only Global Administrators can invite users as members. Defaults to `Guest`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InvitationState.__new__(_InvitationState)

        __props__.__dict__["message"] = message
        __props__.__dict__["redeem_url"] = redeem_url
        __props__.__dict__["redirect_url"] = redirect_url
        __props__.__dict__["user_display_name"] = user_display_name
        __props__.__dict__["user_email_address"] = user_email_address
        __props__.__dict__["user_id"] = user_id
        __props__.__dict__["user_type"] = user_type
        return Invitation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def message(self) -> pulumi.Output[Optional['outputs.InvitationMessage']]:
        """
        A `message` block as documented below, which configures the message being sent to the invited user. If this block is omitted, no message will be sent.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter(name="redeemUrl")
    def redeem_url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL the user can use to redeem their invitation.
        """
        return pulumi.get(self, "redeem_url")

    @_builtins.property
    @pulumi.getter(name="redirectUrl")
    def redirect_url(self) -> pulumi.Output[_builtins.str]:
        """
        The URL that the user should be redirected to once the invitation is redeemed.
        """
        return pulumi.get(self, "redirect_url")

    @_builtins.property
    @pulumi.getter(name="userDisplayName")
    def user_display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The display name of the user being invited.
        """
        return pulumi.get(self, "user_display_name")

    @_builtins.property
    @pulumi.getter(name="userEmailAddress")
    def user_email_address(self) -> pulumi.Output[_builtins.str]:
        """
        The email address of the user being invited.
        """
        return pulumi.get(self, "user_email_address")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[_builtins.str]:
        """
        Object ID of the invited user.
        """
        return pulumi.get(self, "user_id")

    @_builtins.property
    @pulumi.getter(name="userType")
    def user_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The user type of the user being invited. Must be one of `Guest` or `Member`. Only Global Administrators can invite users as members. Defaults to `Guest`.
        """
        return pulumi.get(self, "user_type")

