<p align="center">
  <img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/print_pop_logo.png" alt="PrintPop logo" width="400"/>
</p>

---

## 🎨 PrintPop V 0.2.1

Styled console printing made simple — color, format, and clarity in one package.

---

[![Python](https://img.shields.io/badge/python-3.10%2B-blue)](https://www.python.org/downloads/)
[![License](https://img.shields.io/badge/license-MIT-green)](LICENSE)
[![GitHub Stars](https://img.shields.io/github/stars/rlapine/printpop?style=social)](https://github.com/rlapine/printpop/stargazers)
[![GitHub Forks](https://img.shields.io/github/forks/rlapine/printpop?style=social)](https://github.com/rlapine/printpop/network/members)

---

## ✨ Overview

PrintPop is a lightweight Python utility for printing beautifully formatted text in the console. Use named HTML-safe colors, custom RGB values, and popular text styles to make CLI output clearer and more expressive.

Designed to work across platforms (Windows, macOS, Linux), and built for developers, educators, and CLI power users.

---

## 📦 Installation

`pip install printpop`

---

## ⚙️ Features

- ✅ Uses wrapper functions for quick integration  
- ✅ Built entirely on standard libraries
- ✅ Named HTML-Safe Colors: Use intuitive color names like "salmon", "skyblue", or "goldenrod" for quick readability.
- ✅ Custom RGB Styling: Define any RGB values for precise color output—ideal for branding or design-themed CLI tools.
- ✅ Text Style Formatting: Combine bold, italic, underline, and more for expressive output.
- ✅ Background Colors: Control the background with both named and RGB values for contrast-rich displays.
- ✅ Cross-Platform ANSI Support: Works reliably on Windows, macOS, and Linux terminals using ANSI escape codes.
- ✅ Convenient Wrapper Functions: print_bold(), print_rgb(), print_formatted()—no need to remember styling syntax.
- ✅ Interactive CLI Demo: Run console_test.py to preview styles, test terminal capabilities, or explore colors hands-on.
- ✅ No Dependencies: Fully standalone—just install and start printing with color.

---

## ✍️ API Overview

- `print_<color>(text_to_print: str)`: print functions for over 140 HTML safe named colors.  
- `print_bold(text_to_print: str)`: Prints bold.  
- `print_dim(text_to_print: str)`: Prints dim. 
- `print_italic(text_to_print: str)`: Prints italic. 
- `print_underline(text_to_print: str)`: Prints underline.   
- `print_blink(text_to_print: str)`: Prints blink.   
- `print_inverse(text_to_print: str)`: Prints inverse. 
- `print_hidden(text_to_print: str)`: Prints hidden. 
- `print_strikethrough(text_to_print: str)`: Prints strikethrough. 
- `print_rgb(text_to_print: str, r: int, g: int, b: int)`: Prints text in rgb color. 
- `print_color(text_to_print: str, color: str, background: bool)`: Prints background in color if backround is True.
- `print_formatted(text_to_print: str, bold: bool, ...`: Prints with formats and colors.

---

## 🔧 Usage Examples

```
from printpop import print_bold, print_rgb, print_formatted, print_red, print_color

# Emphasize with bold
print_bold("This text is bold.")

# Custom RGB
print_rgb("This text is soft purple", r=150, g=120, b=180)

# Combine styles
print_formatted("This text is bold, italic, salmon colored with lightcoral background", bold=True, italic=True, color="salmon", back_color="lightcoral")

# Print color name
print_red("This text is red")

# Use named HTML-safe foreground/background colors
print_color("This text is fuchsia", color = "fuchsia" )

# Use any rgb color
print_rgb("This text is one of 16,777,216 possible colors", r = 101, g = 201, b = 113)

# Use any rgb color for background
print_rgb("This text has one of 16,777,216 possible background colors", r = 37, g = 249, b = 201, background = True)

# Combine multiple text styles and colors
print_formatted("This text is bold, underlined, red with yellow background and it is blinking.",
    bold=True,
    dim=False,
    italic=False,
    underline=True,
    blink=True,
    inverse=False,
    hidden=False,
    strikethrough=False,
    color="red",
    back_color="yellow"
)
```
<p align="left">
  <img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/colorprinter_usage_output.png" alt="console output" width="800"/>
</p>

---

## 🌈 Supported Colors

printpop includes wrapper functions for over 140 HTML name safe colors

```
print_aliceblue()
print_antiquewhite()
print_aqua()
print_aquamarine()
...
```

<table>
<tbody>
<tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/aliceblue.png" alt="aliceblue"></td><td>aliceblue</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/antiquewhite.png" alt="antiquewhite"></td><td>antiquewhite</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/aqua.png" alt="aqua"></td><td>aqua</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/aquamarine.png" alt="aquamarine"></td><td>aquamarine</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/azure.png" alt="azure"></td><td>azure</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/bisque.png" alt="bisque"></td><td>bisque</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/blanchedalmond.png" alt="blanchedalmond"></td><td>blanchedalmond</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/blue.png" alt="blue"></td><td>blue</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/blueviolet.png" alt="blueviolet"></td><td>blueviolet</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/brown.png" alt="brown"></td><td>brown</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/burlywood.png" alt="burlywood"></td><td>burlywood</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/cadetblue.png" alt="cadetblue"></td><td>cadetblue</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/chartreuse.png" alt="chartreuse"></td><td>chartreuse</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/chocolate.png" alt="chocolate"></td><td>chocolate</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/coral.png" alt="coral"></td><td>coral</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/cornflowerblue.png" alt="cornflowerblue"></td><td>cornflowerblue</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/cornsilk.png" alt="cornsilk"></td><td>cornsilk</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/crimson.png" alt="crimson"></td><td>crimson</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/cyan.png" alt="cyan"></td><td>cyan</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/darkblue.png" alt="darkblue"></td><td>darkblue</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/darkcyan.png" alt="darkcyan"></td><td>darkcyan</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/darkgray.png" alt="darkgray"></td><td>darkgray</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/darkgreen.png" alt="darkgreen"></td><td>darkgreen</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/darkgrey.png" alt="darkgrey"></td><td>darkgrey</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/darkkhaki.png" alt="darkkhaki"></td><td>darkkhaki</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/darkmagenta.png" alt="darkmagenta"></td><td>darkmagenta</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/darkolivegreen.png" alt="darkolivegreen"></td><td>darkolivegreen</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/darkorange.png" alt="darkorange"></td><td>darkorange</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/darkorchid.png" alt="darkorchid"></td><td>darkorchid</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/darkred.png" alt="darkred"></td><td>darkred</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/darksalmon.png" alt="darksalmon"></td><td>darksalmon</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/darkseagreen.png" alt="darkseagreen"></td><td>darkseagreen</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/darkslateblue.png" alt="darkslateblue"></td><td>darkslateblue</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/darkslategray.png" alt="darkslategray"></td><td>darkslategray</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/darkslategrey.png" alt="darkslategrey"></td><td>darkslategrey</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/darkturquoise.png" alt="darkturquoise"></td><td>darkturquoise</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/darkviolet.png" alt="darkviolet"></td><td>darkviolet</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/deeppink.png" alt="deeppink"></td><td>deeppink</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/deepskyblue.png" alt="deepskyblue"></td><td>deepskyblue</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/dimgray.png" alt="dimgray"></td><td>dimgray</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/dimgrey.png" alt="dimgrey"></td><td>dimgrey</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/dodgerblue.png" alt="dodgerblue"></td><td>dodgerblue</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/firebrick.png" alt="firebrick"></td><td>firebrick</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/floralwhite.png" alt="floralwhite"></td><td>floralwhite</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/forestgreen.png" alt="forestgreen"></td><td>forestgreen</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/fuchsia.png" alt="fuchsia"></td><td>fuchsia</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/gainsboro.png" alt="gainsboro"></td><td>gainsboro</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/ghostwhite.png" alt="ghostwhite"></td><td>ghostwhite</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/gold.png" alt="gold"></td><td>gold</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/gray.png" alt="gray"></td><td>gray</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/green.png" alt="green"></td><td>green</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/greenyellow.png" alt="greenyellow"></td><td>greenyellow</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/grey.png" alt="grey"></td><td>grey</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/honeydew.png" alt="honeydew"></td><td>honeydew</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/hotpink.png" alt="hotpink"></td><td>hotpink</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/indianred.png" alt="indianred"></td><td>indianred</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/indigo.png" alt="indigo"></td><td>indigo</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/ivory.png" alt="ivory"></td><td>ivory</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/khaki.png" alt="khaki"></td><td>khaki</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/lavender.png" alt="lavender"></td><td>lavender</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/lavenderblush.png" alt="lavenderblush"></td><td>lavenderblush</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/lawngreen.png" alt="lawngreen"></td><td>lawngreen</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/lemonchiffon.png" alt="lemonchiffon"></td><td>lemonchiffon</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/lightblue.png" alt="lightblue"></td><td>lightblue</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/lightcoral.png" alt="lightcoral"></td><td>lightcoral</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/lightcyan.png" alt="lightcyan"></td><td>lightcyan</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/lightgoldenrodyellow.png" alt="lightgoldenrodyellow"></td><td>lightgoldenrodyellow</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/lightgray.png" alt="lightgray"></td><td>lightgray</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/lightgreen.png" alt="lightgreen"></td><td>lightgreen</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/lightgrey.png" alt="lightgrey"></td><td>lightgrey</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/lightpink.png" alt="lightpink"></td><td>lightpink</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/lightsalmon.png" alt="lightsalmon"></td><td>lightsalmon</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/lightseagreen.png" alt="lightseagreen"></td><td>lightseagreen</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/lightskyblue.png" alt="lightskyblue"></td><td>lightskyblue</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/lightslategray.png" alt="lightslategray"></td><td>lightslategray</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/lightslategrey.png" alt="lightslategrey"></td><td>lightslategrey</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/lightsteelblue.png" alt="lightsteelblue"></td><td>lightsteelblue</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/lightyellow.png" alt="lightyellow"></td><td>lightyellow</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/lime.png" alt="lime"></td><td>lime</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/limegreen.png" alt="limegreen"></td><td>limegreen</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/linen.png" alt="linen"></td><td>linen</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/magenta.png" alt="magenta"></td><td>magenta</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/mediumaquamarine.png" alt="mediumaquamarine"></td><td>mediumaquamarine</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/mediumblue.png" alt="mediumblue"></td><td>mediumblue</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/mediumorchid.png" alt="mediumorchid"></td><td>mediumorchid</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/mediumpurple.png" alt="mediumpurple"></td><td>mediumpurple</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/mediumseagreen.png" alt="mediumseagreen"></td><td>mediumseagreen</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/mediumslateblue.png" alt="mediumslateblue"></td><td>mediumslateblue</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/mediumspringgreen.png" alt="mediumspringgreen"></td><td>mediumspringgreen</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/mediumturquoise.png" alt="mediumturquoise"></td><td>mediumturquoise</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/mediumvioletred.png" alt="mediumvioletred"></td><td>mediumvioletred</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/midnightblue.png" alt="midnightblue"></td><td>midnightblue</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/mintcream.png" alt="mintcream"></td><td>mintcream</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/mistyrose.png" alt="mistyrose"></td><td>mistyrose</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/moccasin.png" alt="moccasin"></td><td>moccasin</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/navy.png" alt="navy"></td><td>navy</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/oldlace.png" alt="oldlace"></td><td>oldlace</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/olive.png" alt="olive"></td><td>olive</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/olivedrab.png" alt="olivedrab"></td><td>olivedrab</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/orange.png" alt="orange"></td><td>orange</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/orangered.png" alt="orangered"></td><td>orangered</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/orchid.png" alt="orchid"></td><td>orchid</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/palegoldenrod.png" alt="palegoldenrod"></td><td>palegoldenrod</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/palegreen.png" alt="palegreen"></td><td>palegreen</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/paleturquoise.png" alt="paleturquoise"></td><td>paleturquoise</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/palevioletred.png" alt="palevioletred"></td><td>palevioletred</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/papayawhip.png" alt="papayawhip"></td><td>papayawhip</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/peachpuff.png" alt="peachpuff"></td><td>peachpuff</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/peru.png" alt="peru"></td><td>peru</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/pink.png" alt="pink"></td><td>pink</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/plum.png" alt="plum"></td><td>plum</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/powderblue.png" alt="powderblue"></td><td>powderblue</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/purple.png" alt="purple"></td><td>purple</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/rebeccapurple.png" alt="rebeccapurple"></td><td>rebeccapurple</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/red.png" alt="red"></td><td>red</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/rosybrown.png" alt="rosybrown"></td><td>rosybrown</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/royalblue.png" alt="royalblue"></td><td>royalblue</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/saddlebrown.png" alt="saddlebrown"></td><td>saddlebrown</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/salmon.png" alt="salmon"></td><td>salmon</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/sandybrown.png" alt="sandybrown"></td><td>sandybrown</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/seagreen.png" alt="seagreen"></td><td>seagreen</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/seashell.png" alt="seashell"></td><td>seashell</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/sienna.png" alt="sienna"></td><td>sienna</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/silver.png" alt="silver"></td><td>silver</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/skyblue.png" alt="skyblue"></td><td>skyblue</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/slateblue.png" alt="slateblue"></td><td>slateblue</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/slategray.png" alt="slategray"></td><td>slategray</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/slategrey.png" alt="slategrey"></td><td>slategrey</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/snow.png" alt="snow"></td><td>snow</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/springgreen.png" alt="springgreen"></td><td>springgreen</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/steelblue.png" alt="steelblue"></td><td>steelblue</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/tan.png" alt="tan"></td><td>tan</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/teal.png" alt="teal"></td><td>teal</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/thistle.png" alt="thistle"></td><td>thistle</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/tomato.png" alt="tomato"></td><td>tomato</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/turquoise.png" alt="turquoise"></td><td>turquoise</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/violet.png" alt="violet"></td><td>violet</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/wheat.png" alt="wheat"></td><td>wheat</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/white.png" alt="white"></td><td>white</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/whitesmoke.png" alt="whitesmoke"></td><td>whitesmoke</td>
</tr>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/yellow.png" alt="yellow"></td><td>yellow</td>
<td><img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/yellowgreen.png" alt="yellowgreen"></td><td>yellowgreen</td>
</table>
</tbody>

---

## 🔤 Supported Formats

printpop includes wrapper functions for ANSI formats:

```
print_bold()
print_dim()
print_italic()
print_underline()
print_blink()
print_inverse()
print_hidden()
print_strikethrough()
```

---

## 🔧 Built-in demo:

`python printpop`

<p align="left">
  <img src="https://raw.githubusercontent.com/rlapine/printpop/refs/heads/main/assets/color_samples.png" alt="console output" width="800"/>
</p>

---

## 📁 Package Structure
```
printpop/
├── printpop/              # Folder for images, badges, or other static assets
│   ├── core.py            # Public functions and console test
│   ├── color_printer.py   # Core ANSI logic
│   ├── __init__.py        # Package init
├── assets/                # Folder for images, badges, or other static assets
│   ├── print_pop_logo.png           # Logo for documentation
│   ├── colorprinter_usage_output.png   # Console output 
│   ├── color_samples.png               # Console output
|   ├── <color>.png                     # HTML safe name color samples
├── pyproject.toml
├── setup.cfg
├── setup.py
└── README.md              # Documentation
```

---

## 🤝 Contributing

Pull requests welcome! If you spot formatting quirks, want to add new named colors or extend features (like terminal detection or theme presets), feel free to collaborate.

To contribute:

Fork the repo

Add your changes with Google-style comments

Submit a pull request with a clear description

For style consistency, follow the Python Google Style Guide for functions and comments.

---

## 📄 License

This project is licensed under the [MIT License](LICENSE).

---

## 👤 Author

Created by Ryan LaPine [@rlapine](https://github.com/rlapine) — a technically skilled developer focused on clarity, maintainability, and audience-ready documentation. This class is part of a broader effort to build reusable, well-documented tools for data-driven projects.

---

## 📬 Contact

Feel free to reach out with questions or collaboration ideas:

📧 github.stunt845@passinbox.com  
🔗 GitHub: [@rlapine](https://github.com/rlapine)