# Generated by Django 4.1.7 on 2023-03-30 08:36

import ckeditor_uploader.fields
import django.contrib.gis.db.models.fields
import django.core.validators
import django.db.models.deletion
import django.utils.timezone
import django_enum.fields
from django.conf import settings
from django.db import migrations, models

import slm.models.alerts
import slm.models.sitelog
import slm.models.system


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("auth", "0012_alter_user_first_name_max_length"),
    ]

    operations = [
        migrations.CreateModel(
            name="User",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("password", models.CharField(max_length=128, verbose_name="password")),
                (
                    "last_login",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="last login"
                    ),
                ),
                (
                    "email",
                    models.EmailField(
                        max_length=255,
                        null=True,
                        unique=True,
                        verbose_name="Email Address",
                    ),
                ),
                (
                    "first_name",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=255,
                        null=True,
                        verbose_name="First Name",
                    ),
                ),
                (
                    "last_name",
                    models.CharField(
                        blank=True,
                        default="",
                        max_length=255,
                        null=True,
                        verbose_name="Last Name",
                    ),
                ),
                (
                    "is_superuser",
                    models.BooleanField(
                        db_index=True,
                        default=False,
                        help_text="Designates whether the user has unlimited access.",
                        verbose_name="Superuser",
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        db_index=True,
                        default=True,
                        help_text="Designates whether this user should be treated as active. Unselect this instead of deleting accounts.",
                        verbose_name="Active",
                    ),
                ),
                (
                    "date_joined",
                    models.DateTimeField(
                        auto_now_add=True, db_index=True, verbose_name="Date Joined"
                    ),
                ),
                (
                    "last_activity",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=None,
                        editable=False,
                        null=True,
                        verbose_name="Last Activity",
                    ),
                ),
                (
                    "silence_alerts",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        default=True,
                        help_text="If set to true this user will not be sent any alert emails by the system. Note: this does not apply to account related emails (i.e. password resets).",
                    ),
                ),
                (
                    "html_emails",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        default=True,
                        help_text="Receive HTML in email communications.",
                        verbose_name="HTML Emails",
                    ),
                ),
            ],
            options={
                "permissions": [
                    ("propose_sites", "May propose new sites for their agencies."),
                    ("moderate_sites", "May publish logs for sites in their agencies."),
                ],
            },
        ),
        migrations.CreateModel(
            name="About",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "content",
                    ckeditor_uploader.fields.RichTextUploadingField(
                        blank=True, default=""
                    ),
                ),
            ],
            options={
                "verbose_name": "Page Content: About",
                "verbose_name_plural": "Page Content: About",
            },
        ),
        migrations.CreateModel(
            name="Agency",
            fields=[
                ("id", models.AutoField(primary_key=True, serialize=False)),
                (
                    "name",
                    models.CharField(
                        blank=True, db_index=True, max_length=100, null=True
                    ),
                ),
                (
                    "shortname",
                    models.CharField(
                        blank=True, db_index=True, max_length=20, null=True
                    ),
                ),
                ("url", models.URLField(blank=True, max_length=255, null=True)),
                ("address", models.CharField(blank=True, max_length=50, null=True)),
                ("address2", models.CharField(blank=True, max_length=50, null=True)),
                ("city", models.CharField(blank=True, max_length=50, null=True)),
                ("state", models.CharField(blank=True, max_length=30, null=True)),
                ("postal_code", models.CharField(blank=True, max_length=20, null=True)),
                ("country", models.CharField(blank=True, max_length=50, null=True)),
                ("phone1", models.CharField(blank=True, max_length=20, null=True)),
                ("phone2", models.CharField(blank=True, max_length=20, null=True)),
                ("email1", models.EmailField(blank=True, max_length=100, null=True)),
                ("email2", models.EmailField(blank=True, max_length=100, null=True)),
                ("contact", models.CharField(blank=True, max_length=50, null=True)),
                ("other", models.TextField(blank=True, null=True)),
                ("active", models.BooleanField(blank=True, default=True)),
                ("created", models.DateTimeField(auto_now_add=True)),
                (
                    "public",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        default=True,
                        help_text="Set to false to exclude all sites affiliated with this agency from public exposure.",
                    ),
                ),
            ],
            options={
                "managed": True,
            },
        ),
        migrations.CreateModel(
            name="Alert",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "header",
                    models.CharField(
                        default="",
                        help_text="A short description of the alert.",
                        max_length=50,
                    ),
                ),
                (
                    "detail",
                    ckeditor_uploader.fields.RichTextUploadingField(
                        blank=True,
                        default="",
                        help_text="Longer description containing details of the alert.",
                    ),
                ),
                (
                    "level",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        choices=[(1, "NOTICE"), (2, "WARNING"), (3, "ERROR")],
                        db_index=True,
                        help_text="The severity level of this alert.",
                    ),
                ),
                (
                    "timestamp",
                    models.DateTimeField(
                        auto_now_add=True,
                        db_index=True,
                        help_text="The time the alert was created.",
                    ),
                ),
                (
                    "sticky",
                    models.BooleanField(
                        blank=True,
                        default=False,
                        help_text="Do not allow target users to clear this alert, only admins may clear.",
                    ),
                ),
                (
                    "priority",
                    models.IntegerField(
                        blank=True,
                        db_index=True,
                        default=0,
                        help_text="The priority ordering for this alert. Alerts are shown by decreasing priority order first then by decreasing timestamp order.",
                    ),
                ),
                (
                    "expires",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Automatically remove this alert after this time.",
                        null=True,
                    ),
                ),
                (
                    "send_email",
                    models.BooleanField(
                        default=False,
                        help_text="If true, an email will be sent for this alert to every targeted user.",
                    ),
                ),
                (
                    "issuer",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        help_text="The issuing user (if any).",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "polymorphic_ctype",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="polymorphic_%(app_label)s.%(class)s_set+",
                        to="contenttypes.contenttype",
                    ),
                ),
            ],
            options={
                "verbose_name": "Alerts",
                "verbose_name_plural": " Alerts",
                "ordering": ("-priority", "-timestamp"),
            },
        ),
        migrations.CreateModel(
            name="Help",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "content",
                    ckeditor_uploader.fields.RichTextUploadingField(
                        blank=True, default=""
                    ),
                ),
            ],
            options={
                "verbose_name": "Page Content: Help",
                "verbose_name_plural": "Page Content: Help",
            },
        ),
        migrations.CreateModel(
            name="Manufacturer",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(db_index=True, max_length=45, unique=True)),
            ],
            options={
                "managed": True,
            },
        ),
        migrations.CreateModel(
            name="Radome",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "model",
                    models.CharField(
                        db_index=True,
                        help_text="The alphanumeric model of designation of this equipment.",
                        max_length=50,
                        unique=True,
                    ),
                ),
                (
                    "description",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The equipment characteristics.",
                        max_length=500,
                    ),
                ),
                (
                    "state",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        choices=[(100, "Active"), (101, "Legacy"), (102, "Unverified")],
                        db_index=True,
                        default=102,
                        help_text="Has this equipment been verified and is it in active production?",
                    ),
                ),
                (
                    "manufacturer",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        help_text="The manufacturing organization.",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="%(class)ss",
                        to="slm.manufacturer",
                    ),
                ),
            ],
            options={
                "ordering": ("model",),
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Receiver",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "model",
                    models.CharField(
                        db_index=True,
                        help_text="The alphanumeric model of designation of this equipment.",
                        max_length=50,
                        unique=True,
                    ),
                ),
                (
                    "description",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The equipment characteristics.",
                        max_length=500,
                    ),
                ),
                (
                    "state",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        choices=[(100, "Active"), (101, "Legacy"), (102, "Unverified")],
                        db_index=True,
                        default=102,
                        help_text="Has this equipment been verified and is it in active production?",
                    ),
                ),
                (
                    "manufacturer",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        help_text="The manufacturing organization.",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="%(class)ss",
                        to="slm.manufacturer",
                    ),
                ),
            ],
            options={
                "ordering": ("model",),
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SatelliteSystem",
            fields=[
                (
                    "name",
                    models.CharField(
                        db_index=True, max_length=16, primary_key=True, serialize=False
                    ),
                ),
                ("order", models.IntegerField(blank=True, db_index=True, default=0)),
            ],
            options={
                "verbose_name_plural": "Satellite Systems",
                "ordering": ("order",),
            },
        ),
        migrations.CreateModel(
            name="Site",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        help_text="This is the 9 Character station name (XXXXMRCCC) used in RINEX 3 filenames Format: (XXXX - existing four character IGS station name, M - Monument or marker number (0-9), R - Receiver number (0-9), CCC - Three digit ISO 3166-1 country code)",
                        max_length=9,
                        unique=True,
                        validators=[
                            django.core.validators.RegexValidator(
                                "[\\w]{4}[\\d]{2}[\\w]{3}"
                            )
                        ],
                    ),
                ),
                (
                    "status",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        blank=True,
                        choices=[
                            (1, "Former"),
                            (2, "Proposed"),
                            (3, "Updated"),
                            (4, "Published"),
                            (5, "Empty"),
                            (6, "Suspended"),
                        ],
                        db_index=True,
                        default=2,
                        help_text="The current status of the site.",
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(
                        blank=True,
                        db_index=True,
                        default=0,
                        help_text="The number of flags the most recent site log version has.",
                    ),
                ),
                (
                    "max_alert",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        blank=True,
                        choices=[(1, "NOTICE"), (2, "WARNING"), (3, "ERROR")],
                        db_index=True,
                        default=None,
                        help_text="The number of flags the most recent site log version has.",
                        null=True,
                    ),
                ),
                ("preferred", models.IntegerField(blank=True, default=0)),
                ("modified_user", models.IntegerField(blank=True, default=0)),
                (
                    "created",
                    models.DateTimeField(
                        auto_now_add=True,
                        db_index=True,
                        help_text="The time this site was first registered.",
                        null=True,
                    ),
                ),
                (
                    "join_date",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        help_text="The date this site was first published.",
                        null=True,
                    ),
                ),
                (
                    "last_publish",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="The publish date of the current log file.",
                        null=True,
                    ),
                ),
                (
                    "last_update",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="The time of the most recent update to the site log.",
                        null=True,
                    ),
                ),
                (
                    "agencies",
                    models.ManyToManyField(related_name="sites", to="slm.agency"),
                ),
                (
                    "last_user",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        help_text="The last user to make edits to the site log.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="recent_sites",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "owner",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="SiteTideGauge",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("distance", models.IntegerField(blank=True, db_index=True)),
            ],
            options={
                "ordering": ("site", "distance"),
            },
        ),
        migrations.CreateModel(
            name="AgencyAlert",
            fields=[
                (
                    "alert_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="slm.alert",
                    ),
                ),
            ],
            options={
                "verbose_name": "Agency Alert",
                "verbose_name_plural": " Alerts: Agency",
            },
            bases=("slm.alert",),
        ),
        migrations.CreateModel(
            name="GeodesyMLInvalid",
            fields=[
                (
                    "alert_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="slm.alert",
                    ),
                ),
                (
                    "file",
                    models.FileField(
                        help_text="A pointer to the uploaded file on disk.",
                        max_length=255,
                        upload_to=slm.models.system.site_upload_path,
                    ),
                ),
                (
                    "size",
                    models.PositiveIntegerField(blank=True, default=None, null=True),
                ),
                (
                    "thumbnail",
                    models.ImageField(
                        blank=True,
                        default=None,
                        help_text="A pointer to the generated thumbnail file on disk.",
                        null=True,
                        upload_to=slm.models.system.site_thumbnail_path,
                    ),
                ),
                (
                    "mimetype",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="The mimetype of the file.",
                        max_length=255,
                    ),
                ),
                (
                    "file_type",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        choices=[(1, "Site Log"), (2, "Site Image"), (3, "Attachment")],
                        db_index=True,
                        default=3,
                        help_text="The file type of the upload.",
                    ),
                ),
                (
                    "log_format",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        choices=[(1, "Legacy (ASCII)"), (2, "GeodesyML"), (3, "JSON")],
                        db_index=True,
                        default=None,
                        help_text="The site log format. (Only if file_type is Site Log)",
                        null=True,
                    ),
                ),
                ("findings", models.JSONField()),
                (
                    "schema",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        choices=[(1, "GeodesyML/0.4"), (2, "GeodesyML/0.5")],
                        default=2,
                        help_text="The schema version that failed validation.",
                    ),
                ),
                (
                    "published",
                    models.BooleanField(
                        help_text="True if this alert was issued from the published version of the site log."
                    ),
                ),
            ],
            options={
                "verbose_name": "GeodesyML Invalid",
                "verbose_name_plural": " Alerts: GeodesyML Invalid",
            },
            bases=(slm.models.alerts.AutomatedAlertMixin, "slm.alert", models.Model),
        ),
        migrations.CreateModel(
            name="ImportAlert",
            fields=[
                (
                    "alert_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="slm.alert",
                    ),
                ),
            ],
            options={
                "verbose_name": "Import Alert",
                "verbose_name_plural": " Alerts: Import",
            },
            bases=("slm.alert",),
        ),
        migrations.CreateModel(
            name="UserProfile",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "phone1",
                    models.CharField(
                        blank=True,
                        default=None,
                        max_length=20,
                        null=True,
                        verbose_name="Primary Phone Number",
                    ),
                ),
                (
                    "phone2",
                    models.CharField(
                        blank=True,
                        default=None,
                        max_length=20,
                        null=True,
                        verbose_name="Secondary Phone Number",
                    ),
                ),
                (
                    "address1",
                    models.CharField(
                        blank=True,
                        default=None,
                        max_length=255,
                        null=True,
                        verbose_name="Address Line 1",
                    ),
                ),
                (
                    "address2",
                    models.CharField(
                        blank=True,
                        default=None,
                        max_length=255,
                        null=True,
                        verbose_name="Address Line 2",
                    ),
                ),
                (
                    "address3",
                    models.CharField(
                        blank=True,
                        default=None,
                        max_length=255,
                        null=True,
                        verbose_name="Address Line 3",
                    ),
                ),
                (
                    "city",
                    models.CharField(
                        blank=True,
                        default=None,
                        max_length=100,
                        null=True,
                        verbose_name="City",
                    ),
                ),
                (
                    "state_province",
                    models.CharField(
                        blank=True,
                        default=None,
                        max_length=100,
                        null=True,
                        verbose_name="State/Province",
                    ),
                ),
                (
                    "country",
                    models.CharField(
                        blank=True,
                        default=None,
                        max_length=75,
                        null=True,
                        verbose_name="Country",
                    ),
                ),
                (
                    "postal_code",
                    models.CharField(
                        blank=True, max_length=10, null=True, verbose_name="Postal Code"
                    ),
                ),
                (
                    "registration_agency",
                    models.CharField(
                        blank=True,
                        default=None,
                        max_length=40,
                        null=True,
                        verbose_name="Registration Agency",
                    ),
                ),
                (
                    "user",
                    models.OneToOneField(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="profile",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="TideGauge",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(blank=True, db_index=True, max_length=128)),
                (
                    "position",
                    django.contrib.gis.db.models.fields.PointField(
                        blank=True, geography=True, null=True, srid=4326
                    ),
                ),
                ("sonel_id", models.IntegerField(blank=True, db_index=True, null=True)),
                (
                    "sites",
                    models.ManyToManyField(
                        related_name="tide_gauges",
                        through="slm.SiteTideGauge",
                        to="slm.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Tide Gauge",
                "verbose_name_plural": "Tide Gauges",
                "ordering": ("name",),
            },
        ),
        migrations.CreateModel(
            name="SiteWaterVaporRadiometer",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("edited", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("published", models.BooleanField(db_index=True, default=False)),
                (
                    "_flags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(db_index=True, default=0),
                ),
                (
                    "subsection",
                    models.PositiveSmallIntegerField(blank=True, db_index=True),
                ),
                ("is_deleted", models.BooleanField(blank=True, default=False)),
                (
                    "inserted",
                    models.DateTimeField(
                        db_index=True, default=django.utils.timezone.now
                    ),
                ),
                (
                    "manufacturer",
                    models.CharField(
                        db_index=True,
                        help_text="Enter manufacturer's name",
                        max_length=255,
                        verbose_name="Manufacturer",
                    ),
                ),
                (
                    "serial_number",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter the serial number of the sensor",
                        max_length=50,
                        verbose_name="Serial Number",
                    ),
                ),
                (
                    "height_diff",
                    models.FloatField(
                        db_index=True,
                        help_text="In meters, enter the difference in height between the sensor and the GNSS antenna. Positive number indicates the sensor is above the GNSS antenna. Decimeter accuracy preferred. Format: (m)",
                        null=True,
                        verbose_name="Height Diff to Ant (m)",
                    ),
                ),
                (
                    "calibration",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the date the sensor was calibrated. Format: (CCYY-MM-DD)",
                        null=True,
                        verbose_name="Calibration Date",
                    ),
                ),
                (
                    "effective_start",
                    models.DateField(
                        db_index=True,
                        help_text="Enter the effective start date for the sensor. Format: (CCYY-MM-DD)",
                        null=True,
                    ),
                ),
                (
                    "effective_end",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the effective end date for the sensor. Format: (CCYY-MM-DD)",
                        null=True,
                    ),
                ),
                (
                    "notes",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Enter any additional information relevant to the sensor. Format: (multiple lines)",
                        verbose_name="Notes",
                    ),
                ),
                (
                    "model",
                    models.CharField(
                        db_index=True,
                        help_text="Enter water vapor radiometer",
                        max_length=255,
                        verbose_name="Water Vapor Radiometer",
                    ),
                ),
                (
                    "distance_to_antenna",
                    models.FloatField(
                        db_index=True,
                        default=None,
                        help_text="Enter the horizontal distance between the WVR and the GNSS antenna to the nearest meter. Format: (m)",
                        null=True,
                        verbose_name="Distance to Antenna (m)",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="sitetidegauge",
            name="gauge",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="site_distances",
                to="slm.tidegauge",
            ),
        ),
        migrations.AddField(
            model_name="sitetidegauge",
            name="site",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="tide_gauge_distances",
                to="slm.site",
            ),
        ),
        migrations.CreateModel(
            name="SiteTemperatureSensor",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("edited", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("published", models.BooleanField(db_index=True, default=False)),
                (
                    "_flags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(db_index=True, default=0),
                ),
                (
                    "subsection",
                    models.PositiveSmallIntegerField(blank=True, db_index=True),
                ),
                ("is_deleted", models.BooleanField(blank=True, default=False)),
                (
                    "inserted",
                    models.DateTimeField(
                        db_index=True, default=django.utils.timezone.now
                    ),
                ),
                (
                    "manufacturer",
                    models.CharField(
                        db_index=True,
                        help_text="Enter manufacturer's name",
                        max_length=255,
                        verbose_name="Manufacturer",
                    ),
                ),
                (
                    "serial_number",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter the serial number of the sensor",
                        max_length=50,
                        verbose_name="Serial Number",
                    ),
                ),
                (
                    "height_diff",
                    models.FloatField(
                        db_index=True,
                        help_text="In meters, enter the difference in height between the sensor and the GNSS antenna. Positive number indicates the sensor is above the GNSS antenna. Decimeter accuracy preferred. Format: (m)",
                        null=True,
                        verbose_name="Height Diff to Ant (m)",
                    ),
                ),
                (
                    "calibration",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the date the sensor was calibrated. Format: (CCYY-MM-DD)",
                        null=True,
                        verbose_name="Calibration Date",
                    ),
                ),
                (
                    "effective_start",
                    models.DateField(
                        db_index=True,
                        help_text="Enter the effective start date for the sensor. Format: (CCYY-MM-DD)",
                        null=True,
                    ),
                ),
                (
                    "effective_end",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the effective end date for the sensor. Format: (CCYY-MM-DD)",
                        null=True,
                    ),
                ),
                (
                    "notes",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Enter any additional information relevant to the sensor. Format: (multiple lines)",
                        verbose_name="Notes",
                    ),
                ),
                (
                    "model",
                    models.CharField(
                        db_index=True,
                        help_text="Enter temperature sensor model",
                        max_length=255,
                        verbose_name="Temp. Sensor Model",
                    ),
                ),
                (
                    "sampling_interval",
                    models.PositiveSmallIntegerField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the sample interval in seconds. Format: (sec)",
                        null=True,
                        verbose_name="Data Sampling Interval",
                    ),
                ),
                (
                    "accuracy",
                    models.FloatField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the accuracy in degrees Centigrade. Format: (deg C)",
                        null=True,
                        verbose_name="Accuracy (deg C)",
                    ),
                ),
                (
                    "aspiration",
                    django_enum.fields.EnumCharField(
                        blank=True,
                        choices=[("U", "UNASPIRATED"), ("N", "NATURAL"), ("F", "FAN")],
                        db_index=True,
                        default=None,
                        help_text="Enter the aspiration type if known. Format: (UNASPIRATED/NATURAL/FAN/etc)",
                        max_length=50,
                        null=True,
                        verbose_name="Aspiration",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SiteSignalObstructions",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("edited", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("published", models.BooleanField(db_index=True, default=False)),
                (
                    "_flags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(db_index=True, default=0),
                ),
                (
                    "subsection",
                    models.PositiveSmallIntegerField(blank=True, db_index=True),
                ),
                ("is_deleted", models.BooleanField(blank=True, default=False)),
                (
                    "inserted",
                    models.DateTimeField(
                        db_index=True, default=django.utils.timezone.now
                    ),
                ),
                (
                    "effective_start",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the effective start date for the condition. Format: (CCYY-MM-DD)",
                        null=True,
                    ),
                ),
                (
                    "effective_end",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the effective end date for the condition. Format: (CCYY-MM-DD)",
                        null=True,
                    ),
                ),
                (
                    "additional_information",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Enter additional relevant information about any radio interferences. Format: (multiple lines)",
                        verbose_name="Additional Information",
                    ),
                ),
                (
                    "obstructions",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Describe any potential signal obstructions near the GNSS station. Format: (TREES/BUILDLINGS/etc)",
                        max_length=50,
                        verbose_name="Signal Obstructions",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SiteResponsibleAgency",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("edited", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("published", models.BooleanField(db_index=True, default=False)),
                (
                    "_flags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(db_index=True, default=0),
                ),
                (
                    "agency",
                    models.TextField(
                        help_text="Enter contact agency name",
                        max_length=300,
                        verbose_name="Agency",
                    ),
                ),
                (
                    "preferred_abbreviation",
                    models.CharField(
                        db_index=True,
                        help_text="Enter the contact agency's preferred abbreviation",
                        max_length=50,
                        verbose_name="Preferred Abbreviation",
                    ),
                ),
                (
                    "mailing_address",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Enter agency mailing address",
                        max_length=300,
                        verbose_name="Mailing Address",
                    ),
                ),
                (
                    "primary_name",
                    models.CharField(
                        db_index=True,
                        help_text="Enter primary contact organization name",
                        max_length=50,
                        verbose_name="Contact Name",
                    ),
                ),
                (
                    "primary_phone1",
                    models.CharField(
                        db_index=True,
                        help_text="Enter primary contact primary phone number",
                        max_length=50,
                        verbose_name="Telephone (primary)",
                    ),
                ),
                (
                    "primary_phone2",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter primary contact secondary phone number",
                        max_length=50,
                        verbose_name="Telephone (secondary)",
                    ),
                ),
                (
                    "primary_fax",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter primary contact organization fax number",
                        max_length=50,
                        verbose_name="Fax",
                    ),
                ),
                (
                    "primary_email",
                    models.EmailField(
                        db_index=True,
                        help_text="Enter primary contact organization email address. MUST be a generic email, no personal email addresses.",
                        max_length=254,
                        verbose_name="E-mail",
                    ),
                ),
                (
                    "secondary_name",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter secondary contact name",
                        max_length=50,
                        verbose_name="Contact Name",
                    ),
                ),
                (
                    "secondary_phone1",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter secondary contact primary phone number",
                        max_length=50,
                        verbose_name="Telephone (primary)",
                    ),
                ),
                (
                    "secondary_phone2",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter secondary contact secondary phone number",
                        max_length=50,
                        verbose_name="Telephone (secondary)",
                    ),
                ),
                (
                    "secondary_fax",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter secondary contact fax number",
                        max_length=50,
                        verbose_name="Fax",
                    ),
                ),
                (
                    "secondary_email",
                    models.EmailField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter secondary contact email address",
                        max_length=254,
                        verbose_name="E-mail",
                    ),
                ),
                (
                    "additional_information",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Enter additional relevant information regarding operational contacts. Format: (multiple lines).",
                        verbose_name="Additional Information",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SiteRadioInterferences",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("edited", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("published", models.BooleanField(db_index=True, default=False)),
                (
                    "_flags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(db_index=True, default=0),
                ),
                (
                    "subsection",
                    models.PositiveSmallIntegerField(blank=True, db_index=True),
                ),
                ("is_deleted", models.BooleanField(blank=True, default=False)),
                (
                    "inserted",
                    models.DateTimeField(
                        db_index=True, default=django.utils.timezone.now
                    ),
                ),
                (
                    "effective_start",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the effective start date for the condition. Format: (CCYY-MM-DD)",
                        null=True,
                    ),
                ),
                (
                    "effective_end",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the effective end date for the condition. Format: (CCYY-MM-DD)",
                        null=True,
                    ),
                ),
                (
                    "additional_information",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Enter additional relevant information about any radio interferences. Format: (multiple lines)",
                        verbose_name="Additional Information",
                    ),
                ),
                (
                    "interferences",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter all sources of radio interference near the GNSS station. Format: (TV/CELL PHONE ANTENNA/RADAR/etc)",
                        max_length=50,
                        verbose_name="Radio Interferences",
                    ),
                ),
                (
                    "degradations",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Describe any observed degradations in the GNSS data that are presumed to result from radio interference. Format: (SN RATIO/DATA GAPS/etc)",
                        max_length=50,
                        verbose_name="Observed Degradations",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SitePressureSensor",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("edited", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("published", models.BooleanField(db_index=True, default=False)),
                (
                    "_flags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(db_index=True, default=0),
                ),
                (
                    "subsection",
                    models.PositiveSmallIntegerField(blank=True, db_index=True),
                ),
                ("is_deleted", models.BooleanField(blank=True, default=False)),
                (
                    "inserted",
                    models.DateTimeField(
                        db_index=True, default=django.utils.timezone.now
                    ),
                ),
                (
                    "manufacturer",
                    models.CharField(
                        db_index=True,
                        help_text="Enter manufacturer's name",
                        max_length=255,
                        verbose_name="Manufacturer",
                    ),
                ),
                (
                    "serial_number",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter the serial number of the sensor",
                        max_length=50,
                        verbose_name="Serial Number",
                    ),
                ),
                (
                    "height_diff",
                    models.FloatField(
                        db_index=True,
                        help_text="In meters, enter the difference in height between the sensor and the GNSS antenna. Positive number indicates the sensor is above the GNSS antenna. Decimeter accuracy preferred. Format: (m)",
                        null=True,
                        verbose_name="Height Diff to Ant (m)",
                    ),
                ),
                (
                    "calibration",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the date the sensor was calibrated. Format: (CCYY-MM-DD)",
                        null=True,
                        verbose_name="Calibration Date",
                    ),
                ),
                (
                    "effective_start",
                    models.DateField(
                        db_index=True,
                        help_text="Enter the effective start date for the sensor. Format: (CCYY-MM-DD)",
                        null=True,
                    ),
                ),
                (
                    "effective_end",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the effective end date for the sensor. Format: (CCYY-MM-DD)",
                        null=True,
                    ),
                ),
                (
                    "notes",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Enter any additional information relevant to the sensor. Format: (multiple lines)",
                        verbose_name="Notes",
                    ),
                ),
                (
                    "model",
                    models.CharField(
                        db_index=True,
                        help_text="Enter pressure sensor model",
                        max_length=255,
                        verbose_name="Pressure Sensor Model",
                    ),
                ),
                (
                    "sampling_interval",
                    models.PositiveSmallIntegerField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the sample interval in seconds. Format: (sec)",
                        null=True,
                        verbose_name="Data Sampling Interval",
                    ),
                ),
                (
                    "accuracy",
                    models.FloatField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the accuracy in hectopascal. Format: (hPa)",
                        null=True,
                        verbose_name="Accuracy (hPa)",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SiteOperationalContact",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("edited", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("published", models.BooleanField(db_index=True, default=False)),
                (
                    "_flags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(db_index=True, default=0),
                ),
                (
                    "agency",
                    models.TextField(
                        help_text="Enter contact agency name",
                        max_length=300,
                        verbose_name="Agency",
                    ),
                ),
                (
                    "preferred_abbreviation",
                    models.CharField(
                        db_index=True,
                        help_text="Enter the contact agency's preferred abbreviation",
                        max_length=50,
                        verbose_name="Preferred Abbreviation",
                    ),
                ),
                (
                    "mailing_address",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Enter agency mailing address",
                        max_length=300,
                        verbose_name="Mailing Address",
                    ),
                ),
                (
                    "primary_name",
                    models.CharField(
                        db_index=True,
                        help_text="Enter primary contact organization name",
                        max_length=50,
                        verbose_name="Contact Name",
                    ),
                ),
                (
                    "primary_phone1",
                    models.CharField(
                        db_index=True,
                        help_text="Enter primary contact primary phone number",
                        max_length=50,
                        verbose_name="Telephone (primary)",
                    ),
                ),
                (
                    "primary_phone2",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter primary contact secondary phone number",
                        max_length=50,
                        verbose_name="Telephone (secondary)",
                    ),
                ),
                (
                    "primary_fax",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter primary contact organization fax number",
                        max_length=50,
                        verbose_name="Fax",
                    ),
                ),
                (
                    "primary_email",
                    models.EmailField(
                        db_index=True,
                        help_text="Enter primary contact organization email address. MUST be a generic email, no personal email addresses.",
                        max_length=254,
                        verbose_name="E-mail",
                    ),
                ),
                (
                    "secondary_name",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter secondary contact name",
                        max_length=50,
                        verbose_name="Contact Name",
                    ),
                ),
                (
                    "secondary_phone1",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter secondary contact primary phone number",
                        max_length=50,
                        verbose_name="Telephone (primary)",
                    ),
                ),
                (
                    "secondary_phone2",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter secondary contact secondary phone number",
                        max_length=50,
                        verbose_name="Telephone (secondary)",
                    ),
                ),
                (
                    "secondary_fax",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter secondary contact fax number",
                        max_length=50,
                        verbose_name="Fax",
                    ),
                ),
                (
                    "secondary_email",
                    models.EmailField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter secondary contact email address",
                        max_length=254,
                        verbose_name="E-mail",
                    ),
                ),
                (
                    "additional_information",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Enter additional relevant information regarding operational contacts. Format: (multiple lines).",
                        verbose_name="Additional Information",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SiteMultiPathSources",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("edited", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("published", models.BooleanField(db_index=True, default=False)),
                (
                    "_flags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(db_index=True, default=0),
                ),
                (
                    "subsection",
                    models.PositiveSmallIntegerField(blank=True, db_index=True),
                ),
                ("is_deleted", models.BooleanField(blank=True, default=False)),
                (
                    "inserted",
                    models.DateTimeField(
                        db_index=True, default=django.utils.timezone.now
                    ),
                ),
                (
                    "effective_start",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the effective start date for the condition. Format: (CCYY-MM-DD)",
                        null=True,
                    ),
                ),
                (
                    "effective_end",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the effective end date for the condition. Format: (CCYY-MM-DD)",
                        null=True,
                    ),
                ),
                (
                    "additional_information",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Enter additional relevant information about any radio interferences. Format: (multiple lines)",
                        verbose_name="Additional Information",
                    ),
                ),
                (
                    "sources",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Describe any potential multipath sources near the GNSS station. Format: .(METAL ROOF/DOME/VLBI ANTENNA/etc)",
                        max_length=50,
                        verbose_name="Multipath Sources",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SiteHumiditySensor",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("edited", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("published", models.BooleanField(db_index=True, default=False)),
                (
                    "_flags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(db_index=True, default=0),
                ),
                (
                    "subsection",
                    models.PositiveSmallIntegerField(blank=True, db_index=True),
                ),
                ("is_deleted", models.BooleanField(blank=True, default=False)),
                (
                    "inserted",
                    models.DateTimeField(
                        db_index=True, default=django.utils.timezone.now
                    ),
                ),
                (
                    "manufacturer",
                    models.CharField(
                        db_index=True,
                        help_text="Enter manufacturer's name",
                        max_length=255,
                        verbose_name="Manufacturer",
                    ),
                ),
                (
                    "serial_number",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter the serial number of the sensor",
                        max_length=50,
                        verbose_name="Serial Number",
                    ),
                ),
                (
                    "height_diff",
                    models.FloatField(
                        db_index=True,
                        help_text="In meters, enter the difference in height between the sensor and the GNSS antenna. Positive number indicates the sensor is above the GNSS antenna. Decimeter accuracy preferred. Format: (m)",
                        null=True,
                        verbose_name="Height Diff to Ant (m)",
                    ),
                ),
                (
                    "calibration",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the date the sensor was calibrated. Format: (CCYY-MM-DD)",
                        null=True,
                        verbose_name="Calibration Date",
                    ),
                ),
                (
                    "effective_start",
                    models.DateField(
                        db_index=True,
                        help_text="Enter the effective start date for the sensor. Format: (CCYY-MM-DD)",
                        null=True,
                    ),
                ),
                (
                    "effective_end",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the effective end date for the sensor. Format: (CCYY-MM-DD)",
                        null=True,
                    ),
                ),
                (
                    "notes",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Enter any additional information relevant to the sensor. Format: (multiple lines)",
                        verbose_name="Notes",
                    ),
                ),
                (
                    "model",
                    models.CharField(
                        db_index=True,
                        help_text="Enter humidity sensor model",
                        max_length=255,
                        verbose_name="Humidity Sensor Model",
                    ),
                ),
                (
                    "sampling_interval",
                    models.PositiveSmallIntegerField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the sample interval in seconds. Format: (sec)",
                        null=True,
                        verbose_name="Data Sampling Interval (sec)",
                    ),
                ),
                (
                    "accuracy",
                    models.FloatField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the accuracy in % relative humidity. Format: (% rel h)",
                        null=True,
                        verbose_name="Accuracy (% rel h)",
                    ),
                ),
                (
                    "aspiration",
                    django_enum.fields.EnumCharField(
                        blank=True,
                        choices=[("U", "UNASPIRATED"), ("N", "NATURAL"), ("F", "FAN")],
                        db_index=True,
                        default=None,
                        help_text="Enter the aspiration type if known. Format: (UNASPIRATED/NATURAL/FAN/etc)",
                        max_length=50,
                        null=True,
                        verbose_name="Aspiration",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SiteFileUpload",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "timestamp",
                    models.DateTimeField(
                        auto_now_add=True,
                        db_index=True,
                        help_text="When the file was uploaded.",
                    ),
                ),
                (
                    "file",
                    models.FileField(
                        help_text="A pointer to the uploaded file on disk.",
                        max_length=255,
                        upload_to=slm.models.system.site_upload_path,
                    ),
                ),
                (
                    "size",
                    models.PositiveIntegerField(blank=True, default=None, null=True),
                ),
                (
                    "thumbnail",
                    models.ImageField(
                        blank=True,
                        default=None,
                        help_text="A pointer to the generated thumbnail file on disk.",
                        null=True,
                        upload_to=slm.models.system.site_thumbnail_path,
                    ),
                ),
                (
                    "mimetype",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="The mimetype of the file.",
                        max_length=255,
                    ),
                ),
                (
                    "file_type",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        choices=[(1, "Site Log"), (2, "Site Image"), (3, "Attachment")],
                        db_index=True,
                        default=3,
                        help_text="The file type of the upload.",
                    ),
                ),
                (
                    "log_format",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        choices=[(1, "Legacy (ASCII)"), (2, "GeodesyML"), (3, "JSON")],
                        db_index=True,
                        default=None,
                        help_text="The site log format. (Only if file_type is Site Log)",
                        null=True,
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True, help_text="The name of the file.", max_length=255
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="The date and time the file was created.",
                        null=True,
                    ),
                ),
                (
                    "status",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        blank=True,
                        choices=[
                            (1, "Unpublished File"),
                            (2, "Published File"),
                            (3, "Invalid Site Log"),
                            (4, "Warnings Site Log"),
                            (5, "Valid Site Log"),
                        ],
                        db_index=True,
                        default=1,
                        help_text="The status of the file. This will also depend on what type the file is.",
                    ),
                ),
                (
                    "context",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="A description of what this file is (optional).",
                    ),
                ),
                (
                    "direction",
                    django_enum.fields.EnumCharField(
                        blank=True,
                        choices=[
                            ("N", "North"),
                            ("S", "South"),
                            ("E", "East"),
                            ("W", "West"),
                            ("NW", "North West"),
                            ("NE", "North East"),
                            ("SW", "South West"),
                            ("SE", "South East"),
                        ],
                        default=None,
                        help_text="For images taken at the site, this is the cardinal direction the camera was pointing towards.",
                        max_length=2,
                        null=True,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        help_text="The site this file is attached to.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)ss",
                        to="slm.site",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        default=None,
                        help_text="The user that uploaded the file.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "Site File Uploads",
                "ordering": ("-timestamp",),
            },
        ),
        migrations.CreateModel(
            name="Network",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(db_index=True, max_length=100)),
                (
                    "public",
                    models.BooleanField(
                        blank=True,
                        db_index=True,
                        default=True,
                        help_text="If false, this network will not appear in publicly facing data,interfaces and APIs.",
                    ),
                ),
                (
                    "sites",
                    models.ManyToManyField(related_name="networks", to="slm.site"),
                ),
            ],
        ),
        migrations.CreateModel(
            name="LogEntry",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("timestamp", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("epoch", models.DateTimeField(blank=True, db_index=True)),
                (
                    "type",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        choices=[
                            (1, "New Site"),
                            (2, "Add"),
                            (3, "Update"),
                            (4, "Delete"),
                            (5, "Publish"),
                            (6, "Log Upload"),
                            (7, "File Upload"),
                        ]
                    ),
                ),
                (
                    "site_log_id",
                    models.PositiveIntegerField(blank=True, default=None, null=True),
                ),
                (
                    "ip",
                    models.GenericIPAddressField(blank=True, default=None, null=True),
                ),
                (
                    "polymorphic_ctype",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="polymorphic_%(app_label)s.%(class)s_set+",
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="slm.site",
                    ),
                ),
                (
                    "site_log_type",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="logentries",
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="logentries",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "ordering": ("-timestamp",),
            },
        ),
        migrations.CreateModel(
            name="DataCenter",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255, unique=True)),
                ("url", models.URLField(max_length=255, unique=True)),
                ("description", models.TextField(blank=True)),
                ("ftp", models.URLField(max_length=255, unique=True)),
                ("ftp_user", models.CharField(blank=True, max_length=255)),
                ("ftp_password", models.CharField(blank=True, max_length=255)),
                ("ftp_root", models.CharField(blank=True, max_length=255)),
                (
                    "agency",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="data_centers",
                        to="slm.agency",
                    ),
                ),
            ],
            options={
                "verbose_name": "Data Center",
                "verbose_name_plural": "Data Centers",
                "ordering": ("name",),
            },
        ),
        migrations.CreateModel(
            name="DataAvailability",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "rinex_version",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        choices=[
                            (2, "RINEX 2"),
                            (3, "RINEX 3"),
                            (4, "RINEX 4"),
                            (211, "RINEX 2.11"),
                            (300, "RINEX 3.00"),
                            (301, "RINEX 3.01"),
                            (302, "RINEX 3.02"),
                            (303, "RINEX 3.03"),
                            (304, "RINEX 3.04"),
                            (305, "RINEX 3.05"),
                            (400, "RINEX 4.00"),
                        ],
                        db_index=True,
                        default=True,
                        null=True,
                    ),
                ),
                (
                    "rate",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        choices=[(1, "Daily"), (2, "Hourly"), (3, "High Rate")],
                        db_index=True,
                        default=1,
                        null=True,
                    ),
                ),
                ("last", models.DateField(db_index=True)),
                (
                    "data_centers",
                    models.ManyToManyField(blank=True, to="slm.datacenter"),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ArchiveIndex",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("begin", models.DateTimeField(db_index=True)),
                ("end", models.DateTimeField(db_index=True, null=True)),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="indexes",
                        to="slm.site",
                    ),
                ),
            ],
            options={
                "ordering": ("-begin",),
            },
        ),
        migrations.CreateModel(
            name="ArchivedSiteLog",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "timestamp",
                    models.DateTimeField(
                        auto_now_add=True,
                        db_index=True,
                        help_text="When the file was uploaded.",
                    ),
                ),
                (
                    "file",
                    models.FileField(
                        help_text="A pointer to the uploaded file on disk.",
                        max_length=255,
                        upload_to=slm.models.system.site_upload_path,
                    ),
                ),
                (
                    "size",
                    models.PositiveIntegerField(blank=True, default=None, null=True),
                ),
                (
                    "thumbnail",
                    models.ImageField(
                        blank=True,
                        default=None,
                        help_text="A pointer to the generated thumbnail file on disk.",
                        null=True,
                        upload_to=slm.models.system.site_thumbnail_path,
                    ),
                ),
                (
                    "mimetype",
                    models.CharField(
                        db_index=True,
                        default="",
                        help_text="The mimetype of the file.",
                        max_length=255,
                    ),
                ),
                (
                    "file_type",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        choices=[(1, "Site Log"), (2, "Site Image"), (3, "Attachment")],
                        db_index=True,
                        default=3,
                        help_text="The file type of the upload.",
                    ),
                ),
                (
                    "log_format",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        choices=[(1, "Legacy (ASCII)"), (2, "GeodesyML"), (3, "JSON")],
                        db_index=True,
                        default=None,
                        help_text="The site log format. (Only if file_type is Site Log)",
                        null=True,
                    ),
                ),
                ("name", models.CharField(max_length=50)),
                (
                    "index",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="files",
                        to="slm.archiveindex",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        help_text="The site this file is attached to.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)ss",
                        to="slm.site",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Antenna",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "model",
                    models.CharField(
                        db_index=True,
                        help_text="The alphanumeric model of designation of this equipment.",
                        max_length=50,
                        unique=True,
                    ),
                ),
                (
                    "description",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The equipment characteristics.",
                        max_length=500,
                    ),
                ),
                (
                    "state",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        choices=[(100, "Active"), (101, "Legacy"), (102, "Unverified")],
                        db_index=True,
                        default=102,
                        help_text="Has this equipment been verified and is it in active production?",
                    ),
                ),
                ("graphic", models.TextField(blank=True, default="")),
                (
                    "reference_point",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        blank=True,
                        choices=[
                            (1, "BAM (Bottom of Antenna Mount)"),
                            (2, "BCR (Bottom of Chokering)"),
                            (3, "BDG (Bottom of Dome Ground Plane)"),
                            (4, "BGP (Bottom of Ground Plane)"),
                            (5, "BPA (Bottom of Preamplifier)"),
                            (6, "TCR (Top of Chokering)"),
                            (7, "TDG (Top of Dome Ground Plane)"),
                            (8, "TGP (Top of Ground Plane)"),
                            (9, "TOP (Top of Pole)"),
                            (10, "TPA (Top of Preamplifier)"),
                        ],
                        db_index=True,
                        default=None,
                        help_text="Locate your antenna in the file https://files.igs.org/pub/station/general/antenna.gra. Indicate the three-letter abbreviation for the point which is indicated equivalent to ARP for your antenna. Contact the Central Bureau if your antenna does not appear. Format: (BPA/BCR/XXX from antenna.gra; see instr.)",
                        null=True,
                        verbose_name="Antenna Reference Point",
                    ),
                ),
                (
                    "features",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        blank=True,
                        choices=[
                            (1, "Man-Machine Interface"),
                            (2, "North Orientation Mark"),
                            (3, "Receiver Connector"),
                            (4, "Battery Compartment Door Release"),
                            (5, "Bottom of Tear Drop Shape"),
                            (6, "Mounted Compass"),
                            (7, "Display/Digital Readout"),
                            (8, "Cap or Cover for Drying Agent"),
                            (9, "PC Card Slot"),
                            (10, "Tape Measure Tab or Notch for Slant Height Pole"),
                            (11, "Nonspecific Cable Connector"),
                            (12, "External Controller Connector"),
                            (13, "Data Cable Connector"),
                            (14, "Power Port"),
                            (15, "RTK Connector"),
                            (16, "Unknown"),
                        ],
                        db_index=True,
                        default=None,
                        help_text='NOM/RXC/XXX from "antenna.gra"; see NRP abbreviations.',
                        null=True,
                        verbose_name="Antenna Features",
                    ),
                ),
                (
                    "manufacturer",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        help_text="The manufacturing organization.",
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="%(class)ss",
                        to="slm.manufacturer",
                    ),
                ),
            ],
            options={
                "ordering": ("model",),
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="AntCal",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "method",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        blank=True,
                        choices=[
                            (0, "CONVERTED"),
                            (1, "ROBOT"),
                            (2, "FIELD"),
                            (3, "CHAMBER"),
                            (4, "COPIED"),
                        ],
                        db_index=True,
                        help_text="The method of calibration.",
                        null=True,
                    ),
                ),
                (
                    "calibrated",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        help_text="The date the calibration was done.",
                        null=True,
                    ),
                ),
                (
                    "num_antennas",
                    models.PositiveSmallIntegerField(
                        default=None,
                        help_text="The number of antennas that were calibrated.",
                        null=True,
                    ),
                ),
                (
                    "agency",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="The agency performing the calibration.",
                        max_length=50,
                    ),
                ),
                ("dazi", models.FloatField(blank=True, null=True)),
                ("zen1", models.FloatField(blank=True, null=True)),
                ("zen2", models.FloatField(blank=True, null=True)),
                ("dzen", models.FloatField(blank=True, null=True)),
                (
                    "antenna",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="calibrations",
                        to="slm.antenna",
                    ),
                ),
                (
                    "radome",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="calibrations",
                        to="slm.radome",
                    ),
                ),
            ],
            options={
                "verbose_name": "Antenna Calibration",
                "verbose_name_plural": "Antenna Calibrations",
            },
        ),
        migrations.AddField(
            model_name="user",
            name="agencies",
            field=models.ManyToManyField(
                blank=True,
                help_text="The agencies this user is a member of. At bare minimum this user will have edit permissions for all these agency sites.",
                related_name="users",
                to="slm.agency",
                verbose_name="Agency",
            ),
        ),
        migrations.AddField(
            model_name="user",
            name="groups",
            field=models.ManyToManyField(
                blank=True,
                help_text="The groups this user belongs to. A user will get all permissions granted to each of their groups.",
                related_name="user_set",
                related_query_name="user",
                to="auth.group",
                verbose_name="groups",
            ),
        ),
        migrations.AddField(
            model_name="user",
            name="user_permissions",
            field=models.ManyToManyField(
                blank=True,
                help_text="Specific permissions for this user.",
                related_name="user_set",
                related_query_name="user",
                to="auth.permission",
                verbose_name="user permissions",
            ),
        ),
        migrations.CreateModel(
            name="UserAlert",
            fields=[
                (
                    "alert_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="slm.alert",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        help_text="Only this user will see this alert.",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="alerts",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "User Alert",
                "verbose_name_plural": " Alerts: User",
            },
            bases=("slm.alert",),
        ),
        migrations.CreateModel(
            name="UpdatesRejected",
            fields=[
                (
                    "alert_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="slm.alert",
                    ),
                ),
                (
                    "requester",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "site",
                    models.OneToOneField(
                        blank=True,
                        default=None,
                        help_text="The site this alert applies to.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="updates_rejected",
                        to="slm.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Updates Rejected",
                "verbose_name_plural": " Alerts: Updates Rejected",
            },
            bases=(slm.models.alerts.AutomatedAlertMixin, "slm.alert"),
        ),
        migrations.CreateModel(
            name="SiteSurveyedLocalTies",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("edited", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("published", models.BooleanField(db_index=True, default=False)),
                (
                    "_flags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(db_index=True, default=0),
                ),
                (
                    "subsection",
                    models.PositiveSmallIntegerField(blank=True, db_index=True),
                ),
                ("is_deleted", models.BooleanField(blank=True, default=False)),
                (
                    "inserted",
                    models.DateTimeField(
                        db_index=True, default=django.utils.timezone.now
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter name of Tied Marker",
                        max_length=50,
                        verbose_name="Tied Marker Name",
                    ),
                ),
                (
                    "usage",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter the purpose of the tied marker such as SLR, VLBI, DORIS, or other. Format: (SLR/VLBI/LOCAL CONTROL/FOOTPRINT/etc)",
                        max_length=50,
                        verbose_name="Tied Marker Usage",
                    ),
                ),
                (
                    "cdp_number",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter the NASA CDP identifier if available. Format: (A4)",
                        max_length=50,
                        verbose_name="Tied Marker CDP Number",
                    ),
                ),
                (
                    "domes_number",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter the tied marker DOMES number if available. Format: (A9)",
                        max_length=50,
                        verbose_name="Tied Marker DOMES Number",
                    ),
                ),
                (
                    "diff_xyz",
                    django.contrib.gis.db.models.fields.PointField(
                        db_index=True,
                        dim=3,
                        help_text="Enter the differential ITRF coordinates to one millimeter precision. Format: dx, dy, dz (m)",
                        null=True,
                        srid=7789,
                        verbose_name="Δ XYZ (m)",
                    ),
                ),
                (
                    "accuracy",
                    models.FloatField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the accuracy of the tied survey. Format: (mm).",
                        null=True,
                        verbose_name="Accuracy (mm)",
                    ),
                ),
                (
                    "survey_method",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter the source or the survey method used to determine the differential coordinates, such as GNSS survey, conventional survey, or other. Format: (GPS CAMPAIGN/TRILATERATION/TRIANGULATION/etc)",
                        max_length=50,
                        verbose_name="Survey method",
                    ),
                ),
                (
                    "measured",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the date of the survey local ties measurement. Format: (CCYY-MM-DDThh:mmZ)",
                        null=True,
                        verbose_name="Date Measured (UTC)",
                    ),
                ),
                (
                    "additional_information",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Enter any additional information relevant to surveyed local ties. Format: (multiple lines)",
                        verbose_name="Additional Information",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
            options={
                "ordering": ("-edited",),
                "abstract": False,
                "unique_together": {("site", "published", "subsection")},
                "index_together": {
                    ("site", "edited", "published"),
                    ("site", "edited", "published", "subsection"),
                    ("site", "edited"),
                    ("site", "edited", "subsection"),
                },
            },
        ),
        migrations.CreateModel(
            name="SiteReceiver",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("edited", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("published", models.BooleanField(db_index=True, default=False)),
                (
                    "_flags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(db_index=True, default=0),
                ),
                (
                    "subsection",
                    models.PositiveSmallIntegerField(blank=True, db_index=True),
                ),
                ("is_deleted", models.BooleanField(blank=True, default=False)),
                (
                    "inserted",
                    models.DateTimeField(
                        db_index=True, default=django.utils.timezone.now
                    ),
                ),
                (
                    "serial_number",
                    models.CharField(
                        db_index=True,
                        help_text="Enter the receiver serial number. Format: (A20, but note the first A5 is used in SINEX)",
                        max_length=50,
                        verbose_name="Serial Number",
                    ),
                ),
                (
                    "firmware",
                    models.CharField(
                        db_index=True,
                        help_text="Enter the receiver firmware version. Format: (A11)",
                        max_length=50,
                        verbose_name="Firmware Version",
                    ),
                ),
                (
                    "elevation_cutoff",
                    models.FloatField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Please respond with the tracking cutoff as set in the receiver, regardless of terrain or obstructions in the area. Format: (deg)",
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(-5),
                            django.core.validators.MaxValueValidator(15),
                        ],
                        verbose_name="Elevation Cutoff Setting (°)",
                    ),
                ),
                (
                    "installed",
                    models.DateTimeField(
                        db_index=True,
                        help_text="Enter the date and time the receiver was installed. Format: (CCYY-MM-DDThh:mmZ)",
                        null=True,
                        verbose_name="Date Installed (UTC)",
                    ),
                ),
                (
                    "removed",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the date and time the receiver was removed. It is important that the date removed is entered BEFORE the addition of a new receiver. Format: (CCYY-MM-DDThh:mmZ)",
                        null=True,
                        verbose_name="Date Removed (UTC)",
                    ),
                ),
                (
                    "temp_stabilized",
                    models.BooleanField(
                        blank=True,
                        default=None,
                        help_text="If null (default) the temperature stabilization status is unknown. If true the receiver is in a temperature stabilized environment, if false the receiver is not in a temperature stabilized environment.",
                        null=True,
                        verbose_name="Temperature Stabilized",
                    ),
                ),
                (
                    "temp_nominal",
                    models.FloatField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="If the receiver is in a temperature controlled environment, please enter the approximate temperature of that environment. Format: (°C)",
                        null=True,
                        verbose_name="Nominal Temperature (°C)",
                    ),
                ),
                (
                    "temp_deviation",
                    models.FloatField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="If the receiver is in a temperature controlled environment, please enter the expected temperature deviation from nominal of that environment. Format: (± °C)",
                        null=True,
                        verbose_name="Temperature Deviation (± °C)",
                    ),
                ),
                (
                    "additional_info",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Enter any additional relevant information about the receiver. Format: (multiple lines)",
                        verbose_name="Additional Information",
                    ),
                ),
                (
                    "receiver_type",
                    models.ForeignKey(
                        help_text="Please find your receiver in https://files.igs.org/pub/station/general/rcvr_ant.tab and use the official name, taking care to get capital letters, hyphens, etc. exactly correct. If you do not find a listing for your receiver, please notify the IGS Central Bureau. Format: (A20, from rcvr_ant.tab; see instructions)",
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="site_receivers",
                        to="slm.receiver",
                        verbose_name="Receiver Type",
                    ),
                ),
                (
                    "satellite_system",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Check all GNSS systems that apply",
                        to="slm.satellitesystem",
                        verbose_name="Satellite System",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
            options={
                "ordering": ("-edited",),
                "abstract": False,
                "unique_together": {("site", "published", "subsection")},
                "index_together": {
                    ("site", "edited", "published"),
                    ("site", "edited", "published", "subsection"),
                    ("site", "edited"),
                    ("site", "edited", "subsection"),
                },
            },
        ),
        migrations.CreateModel(
            name="SiteOtherInstrumentation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("edited", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("published", models.BooleanField(db_index=True, default=False)),
                (
                    "_flags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(db_index=True, default=0),
                ),
                (
                    "subsection",
                    models.PositiveSmallIntegerField(blank=True, db_index=True),
                ),
                ("is_deleted", models.BooleanField(blank=True, default=False)),
                (
                    "inserted",
                    models.DateTimeField(
                        db_index=True, default=django.utils.timezone.now
                    ),
                ),
                (
                    "instrumentation",
                    models.TextField(
                        help_text="Enter any other relevant information regarding meteorological instrumentation near the site. Format: (multiple lines)",
                        verbose_name="Other Instrumentation",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
            options={
                "ordering": ("-edited",),
                "abstract": False,
                "unique_together": {("site", "published", "subsection")},
                "index_together": {
                    ("site", "edited", "published"),
                    ("site", "edited", "published", "subsection"),
                    ("site", "edited"),
                    ("site", "edited", "subsection"),
                },
            },
        ),
        migrations.CreateModel(
            name="SiteMoreInformation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("edited", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("published", models.BooleanField(db_index=True, default=False)),
                (
                    "_flags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(db_index=True, default=0),
                ),
                (
                    "primary",
                    models.CharField(
                        db_index=True,
                        help_text="Enter the name of the primary operational data center",
                        max_length=50,
                        verbose_name="Primary Data Center",
                    ),
                ),
                (
                    "secondary",
                    models.CharField(
                        db_index=True,
                        help_text="Enter the name of the secondary or backup data center",
                        max_length=50,
                        verbose_name="Secondary Data Center",
                    ),
                ),
                (
                    "more_info",
                    models.URLField(
                        blank=True,
                        db_index=True,
                        default="",
                        verbose_name="URL for More Information",
                    ),
                ),
                (
                    "sitemap",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter the site map URL",
                        max_length=255,
                        verbose_name="Site Map",
                    ),
                ),
                (
                    "site_diagram",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter URL for site diagram",
                        max_length=255,
                        verbose_name="Site Diagram",
                    ),
                ),
                (
                    "horizon_mask",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter Horizon mask URL",
                        max_length=255,
                        verbose_name="Horizon Mask",
                    ),
                ),
                (
                    "monument_description",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter monument description URL",
                        max_length=255,
                        verbose_name="Monument Description",
                    ),
                ),
                (
                    "site_picture",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter site pictures URL",
                        max_length=255,
                        verbose_name="Site Pictures",
                    ),
                ),
                (
                    "additional_information",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Enter additional relevant information. Format: (multiple lines)",
                        verbose_name="Additional Information",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
            options={
                "ordering": ("-edited",),
                "abstract": False,
                "unique_together": {("site", "published")},
                "index_together": {
                    ("site", "edited", "published"),
                    ("edited", "published"),
                    ("site", "edited"),
                },
            },
        ),
        migrations.CreateModel(
            name="SiteLocation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("edited", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("published", models.BooleanField(db_index=True, default=False)),
                (
                    "_flags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(db_index=True, default=0),
                ),
                (
                    "city",
                    models.CharField(
                        db_index=True,
                        help_text="Enter the city or town the site is located in",
                        max_length=50,
                        verbose_name="City or Town",
                    ),
                ),
                (
                    "state",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter the state or province the site is located in",
                        max_length=50,
                        verbose_name="State or Province",
                    ),
                ),
                (
                    "country",
                    django_enum.fields.EnumCharField(
                        choices=[
                            ("AD", "Andorra"),
                            ("AE", "United Arab Emirates (the)"),
                            ("AF", "Afghanistan"),
                            ("AG", "Antigua and Barbuda"),
                            ("AI", "Anguilla"),
                            ("AL", "Albania"),
                            ("AM", "Armenia"),
                            ("AO", "Angola"),
                            ("AQ", "Antarctica"),
                            ("AR", "Argentina"),
                            ("AS", "American Samoa"),
                            ("AT", "Austria"),
                            ("AU", "Australia"),
                            ("AW", "Aruba"),
                            ("AX", "Åland Islands"),
                            ("AZ", "Azerbaijan"),
                            ("BA", "Bosnia and Herzegovina"),
                            ("BB", "Barbados"),
                            ("BD", "Bangladesh"),
                            ("BE", "Belgium"),
                            ("BF", "Burkina Faso"),
                            ("BG", "Bulgaria"),
                            ("BH", "Bahrain"),
                            ("BI", "Burundi"),
                            ("BJ", "Benin"),
                            ("BL", "Saint Barthélemy"),
                            ("BM", "Bermuda"),
                            ("BN", "Brunei Darussalam"),
                            ("BO", "Bolivia (Plurinational State of)"),
                            ("BQ", "Bonaire, Sint Eustatius and Saba"),
                            ("BR", "Brazil"),
                            ("BS", "Bahamas (the)"),
                            ("BT", "Bhutan"),
                            ("BV", "Bouvet Island"),
                            ("BW", "Botswana"),
                            ("BY", "Belarus"),
                            ("BZ", "Belize"),
                            ("CA", "Canada"),
                            ("CC", "Cocos (Keeling) Islands (the)"),
                            ("CD", "Congo (the Democratic Republic of the)"),
                            ("CF", "Central African Republic (the)"),
                            ("CG", "Congo (the)"),
                            ("CH", "Switzerland"),
                            ("CI", "Côte d'Ivoire"),
                            ("CK", "Cook Islands (the)"),
                            ("CL", "Chile"),
                            ("CM", "Cameroon"),
                            ("CN", "China"),
                            ("CO", "Colombia"),
                            ("CR", "Costa Rica"),
                            ("CU", "Cuba"),
                            ("CV", "Cabo Verde"),
                            ("CW", "Curaçao"),
                            ("CX", "Christmas Island"),
                            ("CY", "Cyprus"),
                            ("CZ", "Czechia"),
                            ("DE", "Germany"),
                            ("DJ", "Djibouti"),
                            ("DK", "Denmark"),
                            ("DM", "Dominica"),
                            ("DO", "Dominican Republic (the)"),
                            ("DZ", "Algeria"),
                            ("EC", "Ecuador"),
                            ("EE", "Estonia"),
                            ("EG", "Egypt"),
                            ("EH", "Western Sahara*"),
                            ("ER", "Eritrea"),
                            ("ES", "Spain"),
                            ("ET", "Ethiopia"),
                            ("FI", "Finland"),
                            ("FJ", "Fiji"),
                            ("FK", "Falkland Islands (the) [Malvinas]"),
                            ("FM", "Micronesia (Federated States of)"),
                            ("FO", "Faroe Islands (the)"),
                            ("FR", "France"),
                            ("GA", "Gabon"),
                            (
                                "GB",
                                "United Kingdom of Great Britain and Northern Ireland (the)",
                            ),
                            ("GD", "Grenada"),
                            ("GE", "Georgia"),
                            ("GF", "French Guiana"),
                            ("GG", "Guernsey"),
                            ("GH", "Ghana"),
                            ("GI", "Gibraltar"),
                            ("GL", "Greenland"),
                            ("GM", "Gambia (the)"),
                            ("GN", "Guinea"),
                            ("GP", "Guadeloupe"),
                            ("GQ", "Equatorial Guinea"),
                            ("GR", "Greece"),
                            ("GS", "South Georgia and the South Sandwich Islands"),
                            ("GT", "Guatemala"),
                            ("GU", "Guam"),
                            ("GW", "Guinea-Bissau"),
                            ("GY", "Guyana"),
                            ("HK", "Hong Kong"),
                            ("HM", "Heard Island and McDonald Islands"),
                            ("HN", "Honduras"),
                            ("HR", "Croatia"),
                            ("HT", "Haiti"),
                            ("HU", "Hungary"),
                            ("ID", "Indonesia"),
                            ("IE", "Ireland"),
                            ("IL", "Israel"),
                            ("IM", "Isle of Man"),
                            ("IN", "India"),
                            ("IO", "British Indian Ocean Territory (the)"),
                            ("IQ", "Iraq"),
                            ("IR", "Iran (Islamic Republic of)"),
                            ("IS", "Iceland"),
                            ("IT", "Italy"),
                            ("JE", "Jersey"),
                            ("JM", "Jamaica"),
                            ("JO", "Jordan"),
                            ("JP", "Japan"),
                            ("KE", "Kenya"),
                            ("KG", "Kyrgyzstan"),
                            ("KH", "Cambodia"),
                            ("KI", "Kiribati"),
                            ("KM", "Comoros (the)"),
                            ("KN", "Saint Kitts and Nevis"),
                            ("KP", "Korea (the Democratic People's Republic of)"),
                            ("KR", "Korea (the Republic of)"),
                            ("KW", "Kuwait"),
                            ("KY", "Cayman Islands (the)"),
                            ("KZ", "Kazakhstan"),
                            ("LA", "Lao People's Democratic Republic (the)"),
                            ("LB", "Lebanon"),
                            ("LC", "Saint Lucia"),
                            ("LI", "Liechtenstein"),
                            ("LK", "Sri Lanka"),
                            ("LR", "Liberia"),
                            ("LS", "Lesotho"),
                            ("LT", "Lithuania"),
                            ("LU", "Luxembourg"),
                            ("LV", "Latvia"),
                            ("LY", "Libya"),
                            ("MA", "Morocco"),
                            ("MC", "Monaco"),
                            ("MD", "Moldova (the Republic of)"),
                            ("ME", "Montenegro"),
                            ("MF", "Saint Martin (French part)"),
                            ("MG", "Madagascar"),
                            ("MH", "Marshall Islands (the)"),
                            ("MK", "North Macedonia"),
                            ("ML", "Mali"),
                            ("MM", "Myanmar"),
                            ("MN", "Mongolia"),
                            ("MO", "Macao"),
                            ("MP", "Northern Mariana Islands (the)"),
                            ("MQ", "Martinique"),
                            ("MR", "Mauritania"),
                            ("MS", "Montserrat"),
                            ("MT", "Malta"),
                            ("MU", "Mauritius"),
                            ("MV", "Maldives"),
                            ("MW", "Malawi"),
                            ("MX", "Mexico"),
                            ("MY", "Malaysia"),
                            ("MZ", "Mozambique"),
                            ("NA", "Namibia"),
                            ("NC", "New Caledonia"),
                            ("NE", "Niger (the)"),
                            ("NF", "Norfolk Island"),
                            ("NG", "Nigeria"),
                            ("NI", "Nicaragua"),
                            ("NL", "Netherlands (the)"),
                            ("NO", "Norway"),
                            ("NP", "Nepal"),
                            ("NR", "Nauru"),
                            ("NU", "Niue"),
                            ("NZ", "New Zealand"),
                            ("OM", "Oman"),
                            ("PA", "Panama"),
                            ("PE", "Peru"),
                            ("PF", "French Polynesia"),
                            ("PG", "Papua New Guinea"),
                            ("PH", "Philippines (the)"),
                            ("PK", "Pakistan"),
                            ("PL", "Poland"),
                            ("PM", "Saint Pierre and Miquelon"),
                            ("PN", "Pitcairn"),
                            ("PR", "Puerto Rico"),
                            ("PS", "Palestine, State of"),
                            ("PT", "Portugal"),
                            ("PW", "Palau"),
                            ("PY", "Paraguay"),
                            ("QA", "Qatar"),
                            ("RE", "Réunion"),
                            ("RO", "Romania"),
                            ("RS", "Serbia"),
                            ("RU", "Russian Federation (the)"),
                            ("RW", "Rwanda"),
                            ("SA", "Saudi Arabia"),
                            ("SB", "Solomon Islands"),
                            ("SC", "Seychelles"),
                            ("SD", "Sudan (the)"),
                            ("SE", "Sweden"),
                            ("SG", "Singapore"),
                            ("SH", "Saint Helena, Ascension and Tristan da Cunha"),
                            ("SI", "Slovenia"),
                            ("SJ", "Svalbard and Jan Mayen"),
                            ("SK", "Slovakia"),
                            ("SL", "Sierra Leone"),
                            ("SM", "San Marino"),
                            ("SN", "Senegal"),
                            ("SO", "Somalia"),
                            ("SR", "Suriname"),
                            ("SS", "South Sudan"),
                            ("ST", "Sao Tome and Principe"),
                            ("SV", "El Salvador"),
                            ("SX", "Sint Maarten (Dutch part)"),
                            ("SY", "Syrian Arab Republic (the)"),
                            ("SZ", "Eswatini"),
                            ("TC", "Turks and Caicos Islands (the)"),
                            ("TD", "Chad"),
                            ("TF", "French Southern Territories (the)"),
                            ("TG", "Togo"),
                            ("TH", "Thailand"),
                            ("TJ", "Tajikistan"),
                            ("TK", "Tokelau"),
                            ("TL", "Timor-Leste"),
                            ("TM", "Turkmenistan"),
                            ("TN", "Tunisia"),
                            ("TO", "Tonga"),
                            ("TR", "Türkiye"),
                            ("TT", "Trinidad and Tobago"),
                            ("TV", "Tuvalu"),
                            ("TW", "Taiwan"),
                            ("TZ", "Tanzania, the United Republic of"),
                            ("UA", "Ukraine"),
                            ("UG", "Uganda"),
                            ("UM", "United States Minor Outlying Islands (the)"),
                            ("US", "United States of America (the)"),
                            ("UY", "Uruguay"),
                            ("UZ", "Uzbekistan"),
                            ("VA", "Holy See (the)"),
                            ("VC", "Saint Vincent and the Grenadines"),
                            ("VE", "Venezuela (Bolivarian Republic of)"),
                            ("VG", "Virgin Islands (British)"),
                            ("VI", "Virgin Islands (U.S.)"),
                            ("VN", "Viet Nam"),
                            ("VU", "Vanuatu"),
                            ("WF", "Wallis and Futuna"),
                            ("WS", "Samoa"),
                            ("YE", "Yemen"),
                            ("YT", "Mayotte"),
                            ("ZA", "South Africa"),
                            ("ZM", "Zambia"),
                            ("ZW", "Zimbabwe"),
                        ],
                        db_index=True,
                        help_text="Enter the country/region the site is located in",
                        max_length=100,
                        null=True,
                        verbose_name="Country or Region",
                    ),
                ),
                (
                    "tectonic",
                    django_enum.fields.EnumCharField(
                        blank=True,
                        choices=[
                            ("AF", "African"),
                            ("AN", "Antarctic"),
                            ("AR", "Arabian"),
                            ("AU", "Australian"),
                            ("CA", "Caribbean"),
                            ("CO", "Cocos"),
                            ("EU", "Eurasian"),
                            ("IN", "Indian"),
                            ("JU", "Juan de Fuca"),
                            ("NZ", "Nazca"),
                            ("NA", "North American"),
                            ("PA", "Pacific"),
                            ("PH", "Philippine"),
                            ("SC", "Scotia"),
                            ("SA", "South American"),
                            ("NU", "Nubia"),
                            ("SO", "Somalia"),
                            ("MA", "Mariana"),
                        ],
                        db_index=True,
                        default=None,
                        help_text="Select the primary tectonic plate that the GNSS site occupies",
                        max_length=50,
                        null=True,
                        verbose_name="Tectonic Plate",
                    ),
                ),
                (
                    "xyz",
                    django.contrib.gis.db.models.fields.PointField(
                        db_index=True,
                        dim=3,
                        help_text="Enter the ITRF position to a one meter precision. Format (m)",
                        null=True,
                        srid=7789,
                        verbose_name="Position (X, Y, Z)",
                    ),
                ),
                (
                    "llh",
                    django.contrib.gis.db.models.fields.PointField(
                        db_index=True,
                        dim=3,
                        help_text="Enter the ITRF latitude and longitude in decimal degrees and elevation in meters to one meter precision. Note, legacy site log format is (+/-DDMMSS.SS) and elevation may be given to more decimal places than F7.1. F7.1 is the minimum for the SINEX format.",
                        null=True,
                        srid=4979,
                        verbose_name="Position (Lat, Lon, Elev)",
                    ),
                ),
                (
                    "additional_information",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Describe the source of these coordinates or any other relevant information. Format: (multiple lines)",
                        verbose_name="Additional Information",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
            options={
                "ordering": ("-edited",),
                "abstract": False,
                "unique_together": {("site", "published")},
                "index_together": {
                    ("site", "edited", "published"),
                    ("edited", "published"),
                    ("site", "edited"),
                },
            },
        ),
        migrations.CreateModel(
            name="SiteLocalEpisodicEffects",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("edited", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("published", models.BooleanField(db_index=True, default=False)),
                (
                    "_flags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(db_index=True, default=0),
                ),
                (
                    "subsection",
                    models.PositiveSmallIntegerField(blank=True, db_index=True),
                ),
                ("is_deleted", models.BooleanField(blank=True, default=False)),
                (
                    "inserted",
                    models.DateTimeField(
                        db_index=True, default=django.utils.timezone.now
                    ),
                ),
                (
                    "event",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Describe any events near the GNSS station that may affect data quality such as tree clearing, construction, or weather events. Format: (TREE CLEARING/CONSTRUCTION/etc)",
                        verbose_name="Event",
                    ),
                ),
                (
                    "effective_start",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the effective start date for the local episodic effect. Format: (CCYY-MM-DD)",
                        null=True,
                    ),
                ),
                (
                    "effective_end",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the effective end date for the local episodic effect. Format: (CCYY-MM-DD)",
                        null=True,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
            options={
                "ordering": ("-edited",),
                "abstract": False,
                "unique_together": {("site", "published", "subsection")},
                "index_together": {
                    ("site", "edited", "published"),
                    ("site", "edited", "published", "subsection"),
                    ("site", "edited"),
                    ("site", "edited", "subsection"),
                },
            },
        ),
        migrations.CreateModel(
            name="SiteIdentification",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("edited", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("published", models.BooleanField(db_index=True, default=False)),
                (
                    "_flags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(db_index=True, default=0),
                ),
                (
                    "site_name",
                    models.CharField(
                        db_index=True,
                        help_text="Enter the name of the site.",
                        max_length=255,
                        verbose_name="Site Name",
                    ),
                ),
                (
                    "monument_inscription",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter what is stamped on the monument",
                        max_length=50,
                        verbose_name="Monument Inscription",
                    ),
                ),
                (
                    "iers_domes_number",
                    models.CharField(
                        db_index=True,
                        help_text="This is strictly required. See https://itrf.ign.fr/en/network/domes/request to obtain one. Format: 9 character alphanumeric (A9)",
                        max_length=9,
                        verbose_name="IERS DOMES Number",
                    ),
                ),
                (
                    "cdp_number",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter the NASA CDP identifier if available. Format: 4 character alphanumeric (A4)",
                        max_length=50,
                        verbose_name="CDP Number",
                    ),
                ),
                (
                    "date_installed",
                    models.DateTimeField(
                        db_index=True,
                        help_text="Enter the original date that this site was included in the IGS. Format: (CCYY-MM-DDThh:mmZ)",
                        null=True,
                        verbose_name="Date Installed (UTC)",
                    ),
                ),
                (
                    "monument_description",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Provide a general description of the GNSS monument. Format: (PILLAR/BRASS PLATE/STEEL MAST/etc)",
                        max_length=50,
                        verbose_name="Monument Description",
                    ),
                ),
                (
                    "monument_height",
                    models.FloatField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the height of the monument above the ground surface in meters. Units: (m)",
                        null=True,
                        verbose_name="Height of the Monument (m)",
                    ),
                ),
                (
                    "monument_foundation",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Describe how the GNSS monument is attached to the ground. Format: (STEEL RODS, CONCRETE BLOCK, ROOF, etc)",
                        max_length=50,
                        verbose_name="Monument Foundation",
                    ),
                ),
                (
                    "foundation_depth",
                    models.FloatField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the depth of the monument foundation below the ground surface in meters. Format: (m)",
                        null=True,
                        verbose_name="Foundation Depth (m)",
                    ),
                ),
                (
                    "marker_description",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Describe the actual physical marker reference point. Format: (CHISELLED CROSS/DIVOT/BRASS NAIL/etc)",
                        max_length=50,
                        verbose_name="Marker Description",
                    ),
                ),
                (
                    "geologic_characteristic",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Describe the general geologic characteristics of the GNSS site. Format: (BEDROCK/CLAY/CONGLOMERATE/GRAVEL/SAND/etc)",
                        max_length=50,
                        verbose_name="Geologic Characteristic",
                    ),
                ),
                (
                    "bedrock_type",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="If the site is located on bedrock, describe the nature of that bedrock. Format: (IGNEOUS/METAMORPHIC/SEDIMENTARY)",
                        max_length=50,
                        verbose_name="Bedrock Type",
                    ),
                ),
                (
                    "bedrock_condition",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="If the site is located on bedrock, describe the condition of that bedrock. Format: (FRESH/JOINTED/WEATHERED)",
                        max_length=50,
                        verbose_name="Bedrock Condition",
                    ),
                ),
                (
                    "fracture_spacing",
                    django_enum.fields.EnumCharField(
                        blank=True,
                        choices=[
                            ("1", "1-10 cm"),
                            ("11", "11-50 cm"),
                            ("51", "51-200 cm"),
                            ("200", "over 200 cm"),
                        ],
                        db_index=True,
                        default=None,
                        help_text="If known, describe the fracture spacing of the bedrock. Format: (1-10 cm/11-50 cm/51-200 cm/over 200 cm)",
                        max_length=50,
                        null=True,
                        verbose_name="Fracture Spacing",
                    ),
                ),
                (
                    "fault_zones",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter the name of any known faults near the site. Format: (YES/NO/Name of the zone)",
                        max_length=50,
                        verbose_name="Fault Zones Nearby",
                    ),
                ),
                (
                    "distance",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Describe proximity of the site to any known faults. Format: (multiple lines)",
                        verbose_name="Distance/activity",
                    ),
                ),
                (
                    "additional_information",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Enter any additional information about the geologic characteristics of the GNSS site. Format: (multiple lines)",
                        verbose_name="Additional Information",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
            options={
                "ordering": ("-edited",),
                "abstract": False,
                "unique_together": {("site", "published")},
                "index_together": {
                    ("site", "edited", "published"),
                    ("edited", "published"),
                    ("site", "edited"),
                },
            },
        ),
        migrations.CreateModel(
            name="SiteFrequencyStandard",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("edited", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("published", models.BooleanField(db_index=True, default=False)),
                (
                    "_flags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(db_index=True, default=0),
                ),
                (
                    "subsection",
                    models.PositiveSmallIntegerField(blank=True, db_index=True),
                ),
                ("is_deleted", models.BooleanField(blank=True, default=False)),
                (
                    "inserted",
                    models.DateTimeField(
                        db_index=True, default=django.utils.timezone.now
                    ),
                ),
                (
                    "standard_type",
                    django_enum.fields.EnumCharField(
                        choices=[
                            ("I", "INTERNAL"),
                            ("H", "EXTERNAL H-MASER"),
                            ("C", "EXTERNAL CESIUM"),
                            ("R", "EXTERNAL RUBIDIUM"),
                            ("Q", "EXTERNAL QUARTZ"),
                        ],
                        db_index=True,
                        help_text="Select whether the frequency standard is INTERNAL or EXTERNAL and describe the oscillator type. Format: (INTERNAL or EXTERNAL H-MASER/CESIUM/etc)",
                        max_length=50,
                        null=True,
                        verbose_name="Standard Type",
                    ),
                ),
                (
                    "input_frequency",
                    models.FloatField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the input frequency in MHz if known.",
                        null=True,
                        verbose_name="Input Frequency (MHz)",
                    ),
                ),
                (
                    "notes",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Enter any additional information relevant to frequency standard. Format: (multiple lines)",
                        verbose_name="Notes",
                    ),
                ),
                (
                    "effective_start",
                    models.DateField(
                        db_index=True,
                        help_text="Enter the effective start date for the frequency standard. Format: (CCYY-MM-DD)",
                        null=True,
                    ),
                ),
                (
                    "effective_end",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the effective end date for the frequency standard. Format: (CCYY-MM-DD)",
                        null=True,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
            options={
                "ordering": ("-edited",),
                "abstract": False,
                "unique_together": {("site", "published", "subsection")},
                "index_together": {
                    ("site", "edited", "published"),
                    ("site", "edited", "published", "subsection"),
                    ("site", "edited"),
                    ("site", "edited", "subsection"),
                },
            },
        ),
        migrations.CreateModel(
            name="SiteForm",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("edited", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("published", models.BooleanField(db_index=True, default=False)),
                (
                    "_flags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(db_index=True, default=0),
                ),
                (
                    "prepared_by",
                    models.CharField(
                        blank=True,
                        help_text="Enter the name of who prepared this site log",
                        max_length=50,
                        verbose_name="Prepared by (full name)",
                    ),
                ),
                (
                    "date_prepared",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        help_text="Enter the date the site log was prepared (CCYY-MM-DD).",
                        null=True,
                        verbose_name="Date Prepared",
                    ),
                ),
                (
                    "report_type",
                    models.CharField(
                        blank=True,
                        default=None,
                        help_text="Enter type of report. Example: (UPDATE).",
                        max_length=50,
                        verbose_name="Report Type",
                    ),
                ),
                (
                    "modified_section",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Enter the sections which have changed from the previous version of the log. Example: (3.2, 4.2)",
                        verbose_name="Modified/Added Sections",
                    ),
                ),
                (
                    "previous",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="slm.archiveindex",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
            options={
                "ordering": ("-edited",),
                "abstract": False,
                "unique_together": {("site", "published")},
                "index_together": {
                    ("site", "edited", "published"),
                    ("edited", "published"),
                    ("site", "edited"),
                },
            },
        ),
        migrations.CreateModel(
            name="SiteCollocation",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("edited", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("published", models.BooleanField(db_index=True, default=False)),
                (
                    "_flags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(db_index=True, default=0),
                ),
                (
                    "subsection",
                    models.PositiveSmallIntegerField(blank=True, db_index=True),
                ),
                ("is_deleted", models.BooleanField(blank=True, default=False)),
                (
                    "inserted",
                    models.DateTimeField(
                        db_index=True, default=django.utils.timezone.now
                    ),
                ),
                (
                    "instrument_type",
                    models.CharField(
                        db_index=True,
                        help_text="Select all collocated instrument types that apply",
                        max_length=50,
                        verbose_name="Instrumentation Type",
                    ),
                ),
                (
                    "status",
                    django_enum.fields.EnumCharField(
                        choices=[("P", "PERMANENT"), ("M", "MOBILE")],
                        db_index=True,
                        default=None,
                        help_text="Select appropriate status",
                        max_length=50,
                        null=True,
                        verbose_name="Status",
                    ),
                ),
                (
                    "notes",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Enter any additional information relevant to collocation. Format: (multiple lines)",
                        verbose_name="Notes",
                    ),
                ),
                (
                    "effective_start",
                    models.DateField(
                        db_index=True,
                        help_text="Enter the effective start date of the collocated instrument. Format: (CCYY-MM-DD)",
                        max_length=50,
                        null=True,
                    ),
                ),
                (
                    "effective_end",
                    models.DateField(
                        blank=True,
                        db_index=True,
                        help_text="Enter the effective end date of the collocated instrument. Format: (CCYY-MM-DD)",
                        max_length=50,
                        null=True,
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
            options={
                "ordering": ("-edited",),
                "abstract": False,
                "unique_together": {("site", "published", "subsection")},
                "index_together": {
                    ("site", "edited", "published"),
                    ("site", "edited", "published", "subsection"),
                    ("site", "edited"),
                    ("site", "edited", "subsection"),
                },
            },
        ),
        migrations.CreateModel(
            name="SiteAntenna",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("edited", models.DateTimeField(auto_now_add=True, db_index=True)),
                ("published", models.BooleanField(db_index=True, default=False)),
                (
                    "_flags",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=slm.models.sitelog.DefaultToStrEncoder,
                    ),
                ),
                (
                    "num_flags",
                    models.PositiveSmallIntegerField(db_index=True, default=0),
                ),
                (
                    "subsection",
                    models.PositiveSmallIntegerField(blank=True, db_index=True),
                ),
                ("is_deleted", models.BooleanField(blank=True, default=False)),
                (
                    "inserted",
                    models.DateTimeField(
                        db_index=True, default=django.utils.timezone.now
                    ),
                ),
                (
                    "serial_number",
                    models.CharField(
                        db_index=True,
                        help_text="Only Alpha Numeric Chars and - . Symbols allowed",
                        max_length=128,
                        verbose_name="Serial Number",
                    ),
                ),
                (
                    "reference_point",
                    django_enum.fields.EnumPositiveSmallIntegerField(
                        choices=[
                            (1, "BAM (Bottom of Antenna Mount)"),
                            (2, "BCR (Bottom of Chokering)"),
                            (3, "BDG (Bottom of Dome Ground Plane)"),
                            (4, "BGP (Bottom of Ground Plane)"),
                            (5, "BPA (Bottom of Preamplifier)"),
                            (6, "TCR (Top of Chokering)"),
                            (7, "TDG (Top of Dome Ground Plane)"),
                            (8, "TGP (Top of Ground Plane)"),
                            (9, "TOP (Top of Pole)"),
                            (10, "TPA (Top of Preamplifier)"),
                        ],
                        db_index=True,
                        help_text="Locate your antenna in the file https://files.igs.org/pub/station/general/antenna.gra. Indicate the three-letter abbreviation for the point which is indicated equivalent to ARP for your antenna. Contact the Central Bureau if your antenna does not appear. Format: (BPA/BCR/XXX from antenna.gra; see instr.)",
                        null=True,
                        verbose_name="Antenna Reference Point",
                    ),
                ),
                (
                    "marker_enu",
                    django.contrib.gis.db.models.fields.PointField(
                        dim=3,
                        help_text="ENU eccentricity is the offset between the ARP and marker described in section 1 measured to an accuracy of 1mm. Format: (F8.4) Value 0 is OK",
                        srid=0,
                        verbose_name="Marker->ARP ENU Ecc (m)",
                    ),
                ),
                (
                    "alignment",
                    models.FloatField(
                        db_index=True,
                        help_text='Enter the clockwise offset from true north in degrees. The positive direction is clockwise, so that due east would be equivalent to a response of "+90". Format: (deg; + is clockwise/east)',
                        null=True,
                        validators=[
                            django.core.validators.MinValueValidator(-180),
                            django.core.validators.MaxValueValidator(180),
                        ],
                        verbose_name="Alignment from True N (°)",
                    ),
                ),
                (
                    "radome_serial_number",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter the serial number of the radome if available",
                        max_length=50,
                        verbose_name="Radome Serial Number",
                    ),
                ),
                (
                    "cable_type",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        default="",
                        help_text="Enter the antenna cable specification if know. Format: (vendor & type number)",
                        max_length=50,
                        verbose_name="Antenna Cable Type",
                    ),
                ),
                (
                    "cable_length",
                    models.FloatField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the antenna cable length in meters. Format: (m)",
                        null=True,
                        verbose_name="Antenna Cable Length",
                    ),
                ),
                (
                    "installed",
                    models.DateTimeField(
                        db_index=True,
                        help_text="Enter the date the receiver was installed. Format: (CCYY-MM-DDThh:mmZ)",
                        verbose_name="Date Installed (UTC)",
                    ),
                ),
                (
                    "removed",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=None,
                        help_text="Enter the date the receiver was removed. It is important that the date removed is entered before the addition of a new receiver. Format: (CCYY-MM-DDThh:mmZ)",
                        null=True,
                        verbose_name="Date Removed (UTC)",
                    ),
                ),
                (
                    "additional_information",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Enter additional relevant information about the antenna, cable and radome. Indicate if a signal splitter has been used. Format: (multiple lines)",
                        verbose_name="Additional Information",
                    ),
                ),
                (
                    "custom_graphic",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="Custom antenna graphic - if different than the default.",
                    ),
                ),
                (
                    "antenna_type",
                    models.ForeignKey(
                        help_text='Please find your antenna radome type in https://files.igs.org/pub/station/general/rcvr_ant.tab and use the official name, taking care to get capital letters, hyphens, etc. exactly correct. The radome code from rcvr_ant.tab must be indicated in columns 17-20 of the Antenna Type, use "NONE" if no radome is installed. The antenna+radome pair must have an entry in https://files.igs.org/pub/station/general/igs05.atx with zenith- and azimuth-dependent calibration values down to the horizon. If not, notify the CB. Format: (A20, from rcvr_ant.tab; see instructions)',
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="site_antennas",
                        to="slm.antenna",
                        verbose_name="Antenna Type",
                    ),
                ),
                (
                    "radome_type",
                    models.ForeignKey(
                        help_text='Please find your antenna radome type in https://files.igs.org/pub/station/general/rcvr_ant.tab and use the official name, taking care to get capital letters, hyphens, etc. exactly correct. The radome code from rcvr_ant.tab must be indicated in columns 17-20 of the Antenna Type, use "NONE" if no radome is installed. The antenna+radome pair must have an entry in https://files.igs.org/pub/station/general/igs05.atx with zenith- and azimuth-dependent calibration values down to the horizon. If not, notify the CB. Format: (A20, from rcvr_ant.tab; see instructions)',
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="site_radomes",
                        to="slm.radome",
                        verbose_name="Antenna Radome Type",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="slm.site"
                    ),
                ),
            ],
            options={
                "ordering": ("-edited",),
                "abstract": False,
                "unique_together": {("site", "published", "subsection")},
                "index_together": {
                    ("site", "edited", "published"),
                    ("site", "edited", "published", "subsection"),
                    ("site", "edited"),
                    ("site", "edited", "subsection"),
                },
            },
        ),
        migrations.CreateModel(
            name="SiteAlert",
            fields=[
                (
                    "alert_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="slm.alert",
                    ),
                ),
                (
                    "site",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        help_text="Only users with access to this site will see this alert.",
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="alerts",
                        to="slm.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Site Alert",
                "verbose_name_plural": " Alerts: Site",
            },
            bases=("slm.alert",),
        ),
        migrations.CreateModel(
            name="ReviewRequested",
            fields=[
                (
                    "alert_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="slm.alert",
                    ),
                ),
                (
                    "site",
                    models.OneToOneField(
                        blank=True,
                        default=None,
                        help_text="The site this alert applies to.",
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="review_requested",
                        to="slm.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "Review Requested",
                "verbose_name_plural": " Alerts: Review Requested",
            },
            bases=(slm.models.alerts.AutomatedAlertMixin, "slm.alert"),
        ),
        migrations.AddIndex(
            model_name="logentry",
            index=models.Index(
                fields=["site_log_type", "site_log_id"],
                name="slm_logentr_site_lo_7a2af7_idx",
            ),
        ),
        migrations.AddField(
            model_name="importalert",
            name="site",
            field=models.OneToOneField(
                help_text="Only users with access to this site will see this alert.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="import_alert",
                to="slm.site",
            ),
        ),
        migrations.AddField(
            model_name="geodesymlinvalid",
            name="site",
            field=models.OneToOneField(
                blank=True,
                default=None,
                help_text="The site this alert applies to.",
                on_delete=django.db.models.deletion.CASCADE,
                related_name="geodesymlinvalid",
                to="slm.site",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="dataavailability",
            unique_together={("site", "rinex_version", "rate", "last")},
        ),
        migrations.AlterIndexTogether(
            name="dataavailability",
            index_together={
                ("site", "rinex_version", "rate", "last"),
                ("site", "rinex_version"),
                ("site", "rinex_version", "last"),
                ("site", "last"),
                ("site", "rinex_version", "rate"),
            },
        ),
        migrations.AlterUniqueTogether(
            name="archiveindex",
            unique_together={("site", "end"), ("site", "begin")},
        ),
        migrations.AlterIndexTogether(
            name="archiveindex",
            index_together={("begin", "end"), ("site", "begin", "end")},
        ),
        migrations.AlterUniqueTogether(
            name="archivedsitelog",
            unique_together={("index", "log_format")},
        ),
        migrations.AlterUniqueTogether(
            name="antcal",
            unique_together={("antenna", "radome")},
        ),
        migrations.AlterIndexTogether(
            name="antcal",
            index_together={("antenna", "radome")},
        ),
        migrations.AddField(
            model_name="agencyalert",
            name="agency",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="Only members of this agency will see this alert.",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="alerts",
                to="slm.agency",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="updatesrejected",
            unique_together={("site",)},
        ),
        migrations.AlterUniqueTogether(
            name="reviewrequested",
            unique_together={("site",)},
        ),
        migrations.AlterUniqueTogether(
            name="geodesymlinvalid",
            unique_together={("site",)},
        ),
    ]
