# Generated by Django 4.1.8 on 2023-04-21 14:28

import django.contrib.gis.db.models.fields
import django.core.validators
import django_enum.fields
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("slm", "0009_alter_archiveindex_end"),
    ]

    operations = [
        migrations.AlterField(
            model_name="dataavailability",
            name="rinex_version",
            field=django_enum.fields.EnumPositiveSmallIntegerField(
                choices=[
                    (1, "RINEX 1"),
                    (2, "RINEX 2"),
                    (3, "RINEX 3"),
                    (4, "RINEX 4"),
                    (211, "RINEX 2.11"),
                    (300, "RINEX 3.00"),
                    (301, "RINEX 3.01"),
                    (302, "RINEX 3.02"),
                    (303, "RINEX 3.03"),
                    (304, "RINEX 3.04"),
                    (305, "RINEX 3.05"),
                    (400, "RINEX 4.00"),
                ],
                db_index=True,
                default=1,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="siteantenna",
            name="alignment",
            field=models.FloatField(
                blank=True,
                db_index=True,
                default=None,
                help_text='Enter the clockwise offset from true north in degrees. The positive direction is clockwise, so that due east would be equivalent to a response of "+90". Format: (deg; + is clockwise/east)',
                null=True,
                validators=[
                    django.core.validators.MinValueValidator(-180),
                    django.core.validators.MaxValueValidator(180),
                ],
                verbose_name="Alignment from True N (°)",
            ),
        ),
        migrations.AlterField(
            model_name="siteantenna",
            name="marker_enu",
            field=django.contrib.gis.db.models.fields.PointField(
                blank=True,
                default=None,
                dim=3,
                help_text="East-North-Up eccentricity is the offset between the ARP and marker described in section 1 measured to an accuracy of 1mm. Format: (F8.4) Value 0 is OK",
                null=True,
                srid=0,
                verbose_name="Marker->ARP ENU Ecc (m)",
            ),
        ),
        migrations.AlterField(
            model_name="siteantenna",
            name="reference_point",
            field=django_enum.fields.EnumPositiveSmallIntegerField(
                blank=True,
                choices=[
                    (1, "BAM (Bottom of Antenna Mount)"),
                    (2, "BCR (Bottom of Chokering)"),
                    (3, "BDG (Bottom of Dome Ground Plane)"),
                    (4, "BGP (Bottom of Ground Plane)"),
                    (5, "BPA (Bottom of Preamplifier)"),
                    (6, "TCR (Top of Chokering)"),
                    (7, "TDG (Top of Dome Ground Plane)"),
                    (8, "TGP (Top of Ground Plane)"),
                    (9, "TOP (Top of Pole)"),
                    (10, "TPA (Top of Preamplifier)"),
                ],
                db_index=True,
                default=None,
                help_text="Locate your antenna in the file https://files.igs.org/pub/station/general/antenna.gra. Indicate the three-letter abbreviation for the point which is indicated equivalent to ARP for your antenna. Contact the Central Bureau if your antenna does not appear. Format: (BPA/BCR/XXX from antenna.gra; see instr.)",
                null=True,
                verbose_name="Antenna Reference Point",
            ),
        ),
        migrations.AlterField(
            model_name="siteantenna",
            name="serial_number",
            field=models.CharField(
                blank=True,
                db_index=True,
                help_text="Only Alpha Numeric Chars and - . Symbols allowed",
                max_length=128,
                verbose_name="Serial Number",
            ),
        ),
        migrations.AlterField(
            model_name="sitecollocation",
            name="effective_end",
            field=models.DateField(
                blank=True,
                db_index=True,
                default=None,
                help_text="Enter the effective end date of the collocated instrument. Format: (CCYY-MM-DD)",
                max_length=50,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="sitecollocation",
            name="effective_start",
            field=models.DateField(
                blank=True,
                db_index=True,
                default=None,
                help_text="Enter the effective start date of the collocated instrument. Format: (CCYY-MM-DD)",
                max_length=50,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="sitecollocation",
            name="instrument_type",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="Select all collocated instrument types that apply",
                max_length=50,
                verbose_name="Instrumentation Type",
            ),
        ),
        migrations.AlterField(
            model_name="sitecollocation",
            name="status",
            field=django_enum.fields.EnumCharField(
                blank=True,
                choices=[("P", "PERMANENT"), ("M", "MOBILE")],
                db_index=True,
                default=None,
                help_text="Select appropriate status",
                max_length=50,
                null=True,
                verbose_name="Status",
            ),
        ),
        migrations.AlterField(
            model_name="sitefrequencystandard",
            name="effective_start",
            field=models.DateField(
                blank=True,
                db_index=True,
                default=None,
                help_text="Enter the effective start date for the frequency standard. Format: (CCYY-MM-DD)",
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="sitefrequencystandard",
            name="standard_type",
            field=django_enum.fields.EnumCharField(
                blank=True,
                choices=[
                    ("I", "INTERNAL"),
                    ("H", "EXTERNAL H-MASER"),
                    ("C", "EXTERNAL CESIUM"),
                    ("R", "EXTERNAL RUBIDIUM"),
                    ("Q", "EXTERNAL QUARTZ"),
                ],
                db_index=True,
                default=None,
                help_text="Select whether the frequency standard is INTERNAL or EXTERNAL and describe the oscillator type. Format: (INTERNAL or EXTERNAL H-MASER/CESIUM/etc)",
                max_length=50,
                null=True,
                verbose_name="Standard Type",
            ),
        ),
        migrations.AlterField(
            model_name="sitehumiditysensor",
            name="height_diff",
            field=models.FloatField(
                blank=True,
                db_index=True,
                default=None,
                help_text="In meters, enter the difference in height between the sensor and the GNSS antenna. Positive number indicates the sensor is above the GNSS antenna. Decimeter accuracy preferred. Format: (m)",
                null=True,
                verbose_name="Height Diff to Ant (m)",
            ),
        ),
        migrations.AlterField(
            model_name="sitehumiditysensor",
            name="manufacturer",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter manufacturer's name",
                max_length=255,
                verbose_name="Manufacturer",
            ),
        ),
        migrations.AlterField(
            model_name="sitehumiditysensor",
            name="model",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter humidity sensor model",
                max_length=255,
                verbose_name="Humidity Sensor Model",
            ),
        ),
        migrations.AlterField(
            model_name="siteidentification",
            name="date_installed",
            field=models.DateTimeField(
                blank=True,
                db_index=True,
                help_text="Enter the original date that this site was included in the IGS. Format: (CCYY-MM-DDThh:mmZ)",
                null=True,
                verbose_name="Date Installed (UTC)",
            ),
        ),
        migrations.AlterField(
            model_name="siteidentification",
            name="iers_domes_number",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="This is strictly required. See https://itrf.ign.fr/en/network/domes/request to obtain one. Format: 9 character alphanumeric (A9)",
                max_length=9,
                verbose_name="IERS DOMES Number",
            ),
        ),
        migrations.AlterField(
            model_name="siteidentification",
            name="site_name",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter the name of the site.",
                max_length=255,
                verbose_name="Site Name",
            ),
        ),
        migrations.AlterField(
            model_name="sitelocation",
            name="city",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter the city or town the site is located in",
                max_length=50,
                verbose_name="City or Town",
            ),
        ),
        migrations.AlterField(
            model_name="sitelocation",
            name="country",
            field=django_enum.fields.EnumCharField(
                blank=True,
                choices=[
                    ("AD", "Andorra"),
                    ("AE", "United Arab Emirates (the)"),
                    ("AF", "Afghanistan"),
                    ("AG", "Antigua and Barbuda"),
                    ("AI", "Anguilla"),
                    ("AL", "Albania"),
                    ("AM", "Armenia"),
                    ("AO", "Angola"),
                    ("AQ", "Antarctica"),
                    ("AR", "Argentina"),
                    ("AS", "American Samoa"),
                    ("AT", "Austria"),
                    ("AU", "Australia"),
                    ("AW", "Aruba"),
                    ("AX", "Åland Islands"),
                    ("AZ", "Azerbaijan"),
                    ("BA", "Bosnia and Herzegovina"),
                    ("BB", "Barbados"),
                    ("BD", "Bangladesh"),
                    ("BE", "Belgium"),
                    ("BF", "Burkina Faso"),
                    ("BG", "Bulgaria"),
                    ("BH", "Bahrain"),
                    ("BI", "Burundi"),
                    ("BJ", "Benin"),
                    ("BL", "Saint Barthélemy"),
                    ("BM", "Bermuda"),
                    ("BN", "Brunei Darussalam"),
                    ("BO", "Bolivia (Plurinational State of)"),
                    ("BQ", "Bonaire, Sint Eustatius and Saba"),
                    ("BR", "Brazil"),
                    ("BS", "Bahamas (the)"),
                    ("BT", "Bhutan"),
                    ("BV", "Bouvet Island"),
                    ("BW", "Botswana"),
                    ("BY", "Belarus"),
                    ("BZ", "Belize"),
                    ("CA", "Canada"),
                    ("CC", "Cocos (Keeling) Islands (the)"),
                    ("CD", "Congo (the Democratic Republic of the)"),
                    ("CF", "Central African Republic (the)"),
                    ("CG", "Congo (the)"),
                    ("CH", "Switzerland"),
                    ("CI", "Côte d'Ivoire"),
                    ("CK", "Cook Islands (the)"),
                    ("CL", "Chile"),
                    ("CM", "Cameroon"),
                    ("CN", "China"),
                    ("CO", "Colombia"),
                    ("CR", "Costa Rica"),
                    ("CU", "Cuba"),
                    ("CV", "Cabo Verde"),
                    ("CW", "Curaçao"),
                    ("CX", "Christmas Island"),
                    ("CY", "Cyprus"),
                    ("CZ", "Czechia"),
                    ("DE", "Germany"),
                    ("DJ", "Djibouti"),
                    ("DK", "Denmark"),
                    ("DM", "Dominica"),
                    ("DO", "Dominican Republic (the)"),
                    ("DZ", "Algeria"),
                    ("EC", "Ecuador"),
                    ("EE", "Estonia"),
                    ("EG", "Egypt"),
                    ("EH", "Western Sahara*"),
                    ("ER", "Eritrea"),
                    ("ES", "Spain"),
                    ("ET", "Ethiopia"),
                    ("FI", "Finland"),
                    ("FJ", "Fiji"),
                    ("FK", "Falkland Islands (the) [Malvinas]"),
                    ("FM", "Micronesia (Federated States of)"),
                    ("FO", "Faroe Islands (the)"),
                    ("FR", "France"),
                    ("GA", "Gabon"),
                    (
                        "GB",
                        "United Kingdom of Great Britain and Northern Ireland (the)",
                    ),
                    ("GD", "Grenada"),
                    ("GE", "Georgia"),
                    ("GF", "French Guiana"),
                    ("GG", "Guernsey"),
                    ("GH", "Ghana"),
                    ("GI", "Gibraltar"),
                    ("GL", "Greenland"),
                    ("GM", "Gambia (the)"),
                    ("GN", "Guinea"),
                    ("GP", "Guadeloupe"),
                    ("GQ", "Equatorial Guinea"),
                    ("GR", "Greece"),
                    ("GS", "South Georgia and the South Sandwich Islands"),
                    ("GT", "Guatemala"),
                    ("GU", "Guam"),
                    ("GW", "Guinea-Bissau"),
                    ("GY", "Guyana"),
                    ("HK", "Hong Kong"),
                    ("HM", "Heard Island and McDonald Islands"),
                    ("HN", "Honduras"),
                    ("HR", "Croatia"),
                    ("HT", "Haiti"),
                    ("HU", "Hungary"),
                    ("ID", "Indonesia"),
                    ("IE", "Ireland"),
                    ("IL", "Israel"),
                    ("IM", "Isle of Man"),
                    ("IN", "India"),
                    ("IO", "British Indian Ocean Territory (the)"),
                    ("IQ", "Iraq"),
                    ("IR", "Iran (Islamic Republic of)"),
                    ("IS", "Iceland"),
                    ("IT", "Italy"),
                    ("JE", "Jersey"),
                    ("JM", "Jamaica"),
                    ("JO", "Jordan"),
                    ("JP", "Japan"),
                    ("KE", "Kenya"),
                    ("KG", "Kyrgyzstan"),
                    ("KH", "Cambodia"),
                    ("KI", "Kiribati"),
                    ("KM", "Comoros (the)"),
                    ("KN", "Saint Kitts and Nevis"),
                    ("KP", "Korea (the Democratic People's Republic of)"),
                    ("KR", "Korea (the Republic of)"),
                    ("KW", "Kuwait"),
                    ("KY", "Cayman Islands (the)"),
                    ("KZ", "Kazakhstan"),
                    ("LA", "Lao People's Democratic Republic (the)"),
                    ("LB", "Lebanon"),
                    ("LC", "Saint Lucia"),
                    ("LI", "Liechtenstein"),
                    ("LK", "Sri Lanka"),
                    ("LR", "Liberia"),
                    ("LS", "Lesotho"),
                    ("LT", "Lithuania"),
                    ("LU", "Luxembourg"),
                    ("LV", "Latvia"),
                    ("LY", "Libya"),
                    ("MA", "Morocco"),
                    ("MC", "Monaco"),
                    ("MD", "Moldova (the Republic of)"),
                    ("ME", "Montenegro"),
                    ("MF", "Saint Martin (French part)"),
                    ("MG", "Madagascar"),
                    ("MH", "Marshall Islands (the)"),
                    ("MK", "North Macedonia"),
                    ("ML", "Mali"),
                    ("MM", "Myanmar"),
                    ("MN", "Mongolia"),
                    ("MO", "Macao"),
                    ("MP", "Northern Mariana Islands (the)"),
                    ("MQ", "Martinique"),
                    ("MR", "Mauritania"),
                    ("MS", "Montserrat"),
                    ("MT", "Malta"),
                    ("MU", "Mauritius"),
                    ("MV", "Maldives"),
                    ("MW", "Malawi"),
                    ("MX", "Mexico"),
                    ("MY", "Malaysia"),
                    ("MZ", "Mozambique"),
                    ("NA", "Namibia"),
                    ("NC", "New Caledonia"),
                    ("NE", "Niger (the)"),
                    ("NF", "Norfolk Island"),
                    ("NG", "Nigeria"),
                    ("NI", "Nicaragua"),
                    ("NL", "Netherlands (the)"),
                    ("NO", "Norway"),
                    ("NP", "Nepal"),
                    ("NR", "Nauru"),
                    ("NU", "Niue"),
                    ("NZ", "New Zealand"),
                    ("OM", "Oman"),
                    ("PA", "Panama"),
                    ("PE", "Peru"),
                    ("PF", "French Polynesia"),
                    ("PG", "Papua New Guinea"),
                    ("PH", "Philippines (the)"),
                    ("PK", "Pakistan"),
                    ("PL", "Poland"),
                    ("PM", "Saint Pierre and Miquelon"),
                    ("PN", "Pitcairn"),
                    ("PR", "Puerto Rico"),
                    ("PS", "Palestine, State of"),
                    ("PT", "Portugal"),
                    ("PW", "Palau"),
                    ("PY", "Paraguay"),
                    ("QA", "Qatar"),
                    ("RE", "Réunion"),
                    ("RO", "Romania"),
                    ("RS", "Serbia"),
                    ("RU", "Russian Federation (the)"),
                    ("RW", "Rwanda"),
                    ("SA", "Saudi Arabia"),
                    ("SB", "Solomon Islands"),
                    ("SC", "Seychelles"),
                    ("SD", "Sudan (the)"),
                    ("SE", "Sweden"),
                    ("SG", "Singapore"),
                    ("SH", "Saint Helena, Ascension and Tristan da Cunha"),
                    ("SI", "Slovenia"),
                    ("SJ", "Svalbard and Jan Mayen"),
                    ("SK", "Slovakia"),
                    ("SL", "Sierra Leone"),
                    ("SM", "San Marino"),
                    ("SN", "Senegal"),
                    ("SO", "Somalia"),
                    ("SR", "Suriname"),
                    ("SS", "South Sudan"),
                    ("ST", "Sao Tome and Principe"),
                    ("SV", "El Salvador"),
                    ("SX", "Sint Maarten (Dutch part)"),
                    ("SY", "Syrian Arab Republic (the)"),
                    ("SZ", "Eswatini"),
                    ("TC", "Turks and Caicos Islands (the)"),
                    ("TD", "Chad"),
                    ("TF", "French Southern Territories (the)"),
                    ("TG", "Togo"),
                    ("TH", "Thailand"),
                    ("TJ", "Tajikistan"),
                    ("TK", "Tokelau"),
                    ("TL", "Timor-Leste"),
                    ("TM", "Turkmenistan"),
                    ("TN", "Tunisia"),
                    ("TO", "Tonga"),
                    ("TR", "Türkiye"),
                    ("TT", "Trinidad and Tobago"),
                    ("TV", "Tuvalu"),
                    ("TW", "Taiwan"),
                    ("TZ", "Tanzania, the United Republic of"),
                    ("UA", "Ukraine"),
                    ("UG", "Uganda"),
                    ("UM", "United States Minor Outlying Islands (the)"),
                    ("US", "United States of America (the)"),
                    ("UY", "Uruguay"),
                    ("UZ", "Uzbekistan"),
                    ("VA", "Holy See (the)"),
                    ("VC", "Saint Vincent and the Grenadines"),
                    ("VE", "Venezuela (Bolivarian Republic of)"),
                    ("VG", "Virgin Islands (British)"),
                    ("VI", "Virgin Islands (U.S.)"),
                    ("VN", "Viet Nam"),
                    ("VU", "Vanuatu"),
                    ("WF", "Wallis and Futuna"),
                    ("WS", "Samoa"),
                    ("YE", "Yemen"),
                    ("YT", "Mayotte"),
                    ("ZA", "South Africa"),
                    ("ZM", "Zambia"),
                    ("ZW", "Zimbabwe"),
                ],
                db_index=True,
                default=None,
                help_text="Enter the country/region the site is located in",
                max_length=100,
                null=True,
                verbose_name="Country or Region",
            ),
        ),
        migrations.AlterField(
            model_name="sitelocation",
            name="xyz",
            field=django.contrib.gis.db.models.fields.PointField(
                blank=True,
                db_index=True,
                dim=3,
                help_text="Enter the ITRF position to a one meter precision. Format (m)",
                null=True,
                srid=7789,
                verbose_name="Position (X, Y, Z) (m)",
            ),
        ),
        migrations.AlterField(
            model_name="sitemoreinformation",
            name="primary",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter the name of the primary operational data center",
                max_length=50,
                verbose_name="Primary Data Center",
            ),
        ),
        migrations.AlterField(
            model_name="sitemoreinformation",
            name="secondary",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter the name of the secondary or backup data center",
                max_length=50,
                verbose_name="Secondary Data Center",
            ),
        ),
        migrations.AlterField(
            model_name="siteoperationalcontact",
            name="agency",
            field=models.TextField(
                blank=True,
                default="",
                help_text="Enter contact agency name",
                max_length=300,
                verbose_name="Agency",
            ),
        ),
        migrations.AlterField(
            model_name="siteoperationalcontact",
            name="preferred_abbreviation",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter the contact agency's preferred abbreviation",
                max_length=50,
                verbose_name="Preferred Abbreviation",
            ),
        ),
        migrations.AlterField(
            model_name="siteoperationalcontact",
            name="primary_email",
            field=models.EmailField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter primary contact organization email address. MUST be a generic email, no personal email addresses.",
                max_length=254,
                verbose_name="E-mail",
            ),
        ),
        migrations.AlterField(
            model_name="siteoperationalcontact",
            name="primary_name",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter primary contact organization name",
                max_length=50,
                verbose_name="Contact Name",
            ),
        ),
        migrations.AlterField(
            model_name="siteoperationalcontact",
            name="primary_phone1",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter primary contact primary phone number",
                max_length=50,
                verbose_name="Telephone (primary)",
            ),
        ),
        migrations.AlterField(
            model_name="siteotherinstrumentation",
            name="instrumentation",
            field=models.TextField(
                blank=True,
                default="",
                help_text="Enter any other relevant information regarding meteorological instrumentation near the site. Format: (multiple lines)",
                verbose_name="Other Instrumentation",
            ),
        ),
        migrations.AlterField(
            model_name="sitepressuresensor",
            name="height_diff",
            field=models.FloatField(
                blank=True,
                db_index=True,
                default=None,
                help_text="In meters, enter the difference in height between the sensor and the GNSS antenna. Positive number indicates the sensor is above the GNSS antenna. Decimeter accuracy preferred. Format: (m)",
                null=True,
                verbose_name="Height Diff to Ant (m)",
            ),
        ),
        migrations.AlterField(
            model_name="sitepressuresensor",
            name="manufacturer",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter manufacturer's name",
                max_length=255,
                verbose_name="Manufacturer",
            ),
        ),
        migrations.AlterField(
            model_name="sitereceiver",
            name="firmware",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter the receiver firmware version. Format: (A11)",
                max_length=50,
                verbose_name="Firmware Version",
            ),
        ),
        migrations.AlterField(
            model_name="sitereceiver",
            name="serial_number",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter the receiver serial number. Format: (A20, but note the first A5 is used in SINEX)",
                max_length=50,
                verbose_name="Serial Number",
            ),
        ),
        migrations.AlterField(
            model_name="siteresponsibleagency",
            name="agency",
            field=models.TextField(
                blank=True,
                default="",
                help_text="Enter contact agency name",
                max_length=300,
                verbose_name="Agency",
            ),
        ),
        migrations.AlterField(
            model_name="siteresponsibleagency",
            name="preferred_abbreviation",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter the contact agency's preferred abbreviation",
                max_length=50,
                verbose_name="Preferred Abbreviation",
            ),
        ),
        migrations.AlterField(
            model_name="siteresponsibleagency",
            name="primary_email",
            field=models.EmailField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter primary contact organization email address. MUST be a generic email, no personal email addresses.",
                max_length=254,
                verbose_name="E-mail",
            ),
        ),
        migrations.AlterField(
            model_name="siteresponsibleagency",
            name="primary_name",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter primary contact organization name",
                max_length=50,
                verbose_name="Contact Name",
            ),
        ),
        migrations.AlterField(
            model_name="siteresponsibleagency",
            name="primary_phone1",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter primary contact primary phone number",
                max_length=50,
                verbose_name="Telephone (primary)",
            ),
        ),
        migrations.AlterField(
            model_name="sitesurveyedlocalties",
            name="diff_xyz",
            field=django.contrib.gis.db.models.fields.PointField(
                blank=True,
                db_index=True,
                default=None,
                dim=3,
                help_text="Enter the differential ITRF coordinates to one millimeter precision. Format: dx, dy, dz (m)",
                null=True,
                srid=7789,
                verbose_name="Δ XYZ (m)",
            ),
        ),
        migrations.AlterField(
            model_name="sitetemperaturesensor",
            name="height_diff",
            field=models.FloatField(
                blank=True,
                db_index=True,
                default=None,
                help_text="In meters, enter the difference in height between the sensor and the GNSS antenna. Positive number indicates the sensor is above the GNSS antenna. Decimeter accuracy preferred. Format: (m)",
                null=True,
                verbose_name="Height Diff to Ant (m)",
            ),
        ),
        migrations.AlterField(
            model_name="sitetemperaturesensor",
            name="manufacturer",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter manufacturer's name",
                max_length=255,
                verbose_name="Manufacturer",
            ),
        ),
        migrations.AlterField(
            model_name="sitetemperaturesensor",
            name="model",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter temperature sensor model",
                max_length=255,
                verbose_name="Temp. Sensor Model",
            ),
        ),
        migrations.AlterField(
            model_name="sitewatervaporradiometer",
            name="distance_to_antenna",
            field=models.FloatField(
                blank=True,
                db_index=True,
                default=None,
                help_text="Enter the horizontal distance between the WVR and the GNSS antenna to the nearest meter. Format: (m)",
                null=True,
                verbose_name="Distance to Antenna (m)",
            ),
        ),
        migrations.AlterField(
            model_name="sitewatervaporradiometer",
            name="height_diff",
            field=models.FloatField(
                blank=True,
                db_index=True,
                default=None,
                help_text="In meters, enter the difference in height between the sensor and the GNSS antenna. Positive number indicates the sensor is above the GNSS antenna. Decimeter accuracy preferred. Format: (m)",
                null=True,
                verbose_name="Height Diff to Ant (m)",
            ),
        ),
        migrations.AlterField(
            model_name="sitewatervaporradiometer",
            name="manufacturer",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter manufacturer's name",
                max_length=255,
                verbose_name="Manufacturer",
            ),
        ),
        migrations.AlterField(
            model_name="sitewatervaporradiometer",
            name="model",
            field=models.CharField(
                blank=True,
                db_index=True,
                default="",
                help_text="Enter water vapor radiometer",
                max_length=255,
                verbose_name="Water Vapor Radiometer",
            ),
        ),
    ]
