# Generated by Django 4.2.6 on 2023-10-13 18:30

from django.db import migrations
from django.db.models import Q


def clean_duplicate_logs(apps, schema_editor):
    total_deleted = 0
    LogEntry = apps.get_model("slm", "LogEntry")
    deleted_pks = set()
    for log_entry in LogEntry.objects.all():
        if log_entry.pk in deleted_pks:
            continue
        to_delete = LogEntry.objects.filter(
            Q(type=log_entry.type)
            & Q(timestamp=log_entry.timestamp)
            & (Q(site=log_entry.site) if log_entry.site else Q(site__isnull=True))
            & (
                Q(section=log_entry.section)
                if log_entry.section
                else Q(section=log_entry.section)
            )
            & (
                Q(subsection=log_entry.subsection)
                if log_entry.subsection
                else Q(subsection=log_entry.subsection)
            )
        ).exclude(pk=log_entry.pk)
        if to_delete.count():
            deleted_pks.update(to_delete.values_list("pk"))
            deleted, _ = to_delete.delete()
            total_deleted += deleted

    if total_deleted:
        print(f"Removed {total_deleted} duplicate log entries.")


class Migration(migrations.Migration):
    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("slm", "0016_alter_antenna_description_alter_radome_description_and_more"),
    ]

    operations = [
        migrations.AlterIndexTogether(
            name="logentry",
            index_together={("timestamp", "type", "site", "section", "subsection")},
        ),
        migrations.RunPython(
            clean_duplicate_logs, migrations.RunPython.noop, elidable=True
        ),
        migrations.AlterUniqueTogether(
            name="logentry",
            unique_together={("timestamp", "type", "site", "section", "subsection")},
        ),
    ]
