# Generated by Django 4.2.6 on 2023-10-27 17:00

import django.contrib.gis.db.models.fields
import django_enum.fields
from django.contrib.gis.geos import Point
from django.db import migrations


def switch_enu_to_une(apps, schema_editor):
    SiteAntenna = apps.get_model("slm", "SiteAntenna")
    for antenna in SiteAntenna.objects.filter(marker_enu__isnull=False):
        antenna.marker_une = Point(*(reversed(antenna.marker_enu)))
        antenna.save()


def switch_une_to_enu(apps, schema_editor):
    SiteAntenna = apps.get_model("slm", "SiteAntenna")
    for antenna in SiteAntenna.objects.filter(marker_une__isnull=False):
        antenna.marker_enu = Point(*(reversed(antenna.marker_une)))
        antenna.save()


class Migration(migrations.Migration):
    dependencies = [
        ("slm", "0018_alter_siteantenna_options_and_more"),
    ]

    operations = [
        migrations.AddField(
            model_name="siteantenna",
            name="marker_une",
            field=django.contrib.gis.db.models.fields.PointField(
                blank=True,
                default=None,
                dim=3,
                help_text="Up-North-East eccentricity is the offset between the ARP and marker described in section 1 measured to an accuracy of 1mm. Format: (F8.4) Value 0 is OK",
                null=True,
                srid=0,
                verbose_name="Marker->ARP UNE Ecc (m)",
            ),
        ),
        migrations.RunPython(switch_enu_to_une, switch_une_to_enu, elidable=True),
        migrations.RemoveField(
            model_name="siteantenna",
            name="marker_enu",
        ),
        migrations.AlterField(
            model_name="antenna",
            name="features",
            field=django_enum.fields.EnumPositiveSmallIntegerField(
                blank=True,
                choices=[
                    (1, "(MMI) Man-Machine Interface"),
                    (2, "(NOM) North Orientation Mark"),
                    (3, "(RXC) Receiver Connector"),
                    (4, "(BAT) Battery Compartment Door Release"),
                    (5, "(BTD) Bottom of Tear Drop Shape"),
                    (6, "(CMP) Mounted Compass"),
                    (7, "(DIS) Display/Digital Readout"),
                    (8, "(DRY) Cap or Cover for Drying Agent"),
                    (9, "(PCS) PC Card Slot"),
                    (10, "(TMT) Tape Measure Tab or Notch for Slant Height Pole"),
                    (11, "(CAC) Nonspecific Cable Connector"),
                    (12, "(CTC) External Controller Connector"),
                    (13, "(DAC) Data Cable Connector"),
                    (14, "(PWC) Power Port"),
                    (15, "(RTC) RTK Connector"),
                    (16, "(UNK) Unknown"),
                ],
                db_index=True,
                default=None,
                help_text='NOM/RXC/XXX from "antenna.gra"; see NRP abbreviations.',
                null=True,
                verbose_name="Antenna Features",
            ),
        ),
        migrations.AlterField(
            model_name="logentry",
            name="type",
            field=django_enum.fields.EnumPositiveSmallIntegerField(
                choices=[
                    (1, "Site Proposed"),
                    (2, "Add"),
                    (3, "Update"),
                    (4, "Delete"),
                    (5, "Publish"),
                    (6, "Log Upload"),
                    (7, "Image Upload"),
                    (8, "Attachment Upload"),
                    (9, "Image Published"),
                    (10, "Attachment Published"),
                    (11, "Image Unpublished"),
                    (12, "Attachment Unpublished"),
                    (13, "Image Deleted"),
                    (14, "Attachment Deleted"),
                    (15, "Revert"),
                ],
                db_index=True,
            ),
        ),
    ]
