# Generated by Django 4.2.11 on 2024-04-21 03:43

import django_enum.fields
from django.db import migrations


def populate_gml_versions(apps, schema_editor):
    ArchivedSiteLog = apps.get_model("slm", "ArchivedSiteLog")
    ArchivedSiteLog.objects.filter(log_format=2).update(gml_version=2)


class Migration(migrations.Migration):
    dependencies = [
        (
            "slm",
            "0022_rename_antcal_antenna_radome_slm_antcal_antenna_20827a_idx_and_more",
        ),
    ]

    operations = [
        migrations.AddField(
            model_name="archivedsitelog",
            name="gml_version",
            field=django_enum.fields.EnumPositiveSmallIntegerField(
                choices=[(1, "GeodesyML/0.4"), (2, "GeodesyML/0.5")],
                db_index=True,
                default=None,
                help_text="The Geodesy ML version. (Only if file_type is GeodesyML)",
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="geodesymlinvalid",
            name="gml_version",
            field=django_enum.fields.EnumPositiveSmallIntegerField(
                choices=[(1, "GeodesyML/0.4"), (2, "GeodesyML/0.5")],
                db_index=True,
                default=None,
                help_text="The Geodesy ML version. (Only if file_type is GeodesyML)",
                null=True,
            ),
        ),
        migrations.AddField(
            model_name="sitefileupload",
            name="gml_version",
            field=django_enum.fields.EnumPositiveSmallIntegerField(
                choices=[(1, "GeodesyML/0.4"), (2, "GeodesyML/0.5")],
                db_index=True,
                default=None,
                help_text="The Geodesy ML version. (Only if file_type is GeodesyML)",
                null=True,
            ),
        ),
        migrations.RunPython(populate_gml_versions, elidable=True),
    ]
