# Generated by Django 4.2.20 on 2025-05-08 19:52

from datetime import timedelta

import django.contrib.postgres.constraints
import django.contrib.postgres.fields.ranges
from django.contrib.postgres.fields.ranges import DateTimeTZRange
from django.db import migrations, models


def populate_valid_range(apps, schema_editor):
    ArchiveIndex = apps.get_model("slm", "ArchiveIndex")

    for row in ArchiveIndex.objects.all():
        begin = row.begin
        end = row.end
        if begin == end:
            # add a little salt
            end = end + timedelta(seconds=1)
        ArchiveIndex.objects.filter(pk=row.pk).update(
            valid_range=DateTimeTZRange(begin, end)
        )


def reverse_valid_range(apps, schema_editor):
    ArchiveIndex = apps.get_model("slm", "ArchiveIndex")

    for row in ArchiveIndex.objects.all():
        begin = row.valid_range.lower if row.valid_range else None
        end = row.valid_range.upper if row.valid_range else None
        ArchiveIndex.objects.filter(pk=row.pk).update(begin=begin, end=end)


class Migration(migrations.Migration):
    dependencies = [
        ("slm", "0031_alter_antenna_features"),
    ]

    operations = [
        migrations.RunSQL("CREATE EXTENSION IF NOT EXISTS citext;"),
        migrations.RunSQL("CREATE EXTENSION IF NOT EXISTS btree_gist;"),
        migrations.AddField(
            model_name="archiveindex",
            name="valid_range",
            field=django.contrib.postgres.fields.ranges.DateTimeRangeField(
                blank=True, db_index=True, null=True
            ),
        ),
        migrations.AddIndex(
            model_name="archiveindex",
            index=models.Index(
                fields=["site", "valid_range"], name="slm_archive_site_id_5a8c6e_idx"
            ),
        ),
        migrations.AddConstraint(
            model_name="archiveindex",
            constraint=django.contrib.postgres.constraints.ExclusionConstraint(
                expressions=[("site", "="), ("valid_range", "&&")],
                name="no_overlapping_ranges_per_site",
            ),
        ),
        migrations.RunPython(populate_valid_range, reverse_code=reverse_valid_range),
        migrations.AlterModelOptions(
            name="archiveindex",
            options={
                "ordering": ("-valid_range",),
                "verbose_name": "Archive Index",
                "verbose_name_plural": "Archive Index",
            },
        ),
        migrations.RemoveIndex(
            model_name="archiveindex",
            name="slm_archive_begin_b89d03_idx",
        ),
        migrations.RemoveIndex(
            model_name="archiveindex",
            name="slm_archive_site_id_c1b6a6_idx",
        ),
        migrations.AlterUniqueTogether(
            name="archiveindex",
            unique_together=set(),
        ),
        migrations.RemoveField(
            model_name="archiveindex",
            name="begin",
        ),
        migrations.RemoveField(
            model_name="archiveindex",
            name="end",
        ),
    ]
