from unittest import TestCase

from slm.defines import ISOCountry


class TestISOCountry(TestCase):
    def test_equality(self):
        self.assertEqual(ISOCountry.AD, 20)
        self.assertEqual(ISOCountry.AD.label, "Andorra")
        self.assertEqual(ISOCountry.AD.alpha2, "AD")
        self.assertEqual(ISOCountry.AD.short_name, "Andorra")
        self.assertEqual(ISOCountry.AD, ISOCountry("Andorra"))
        self.assertEqual(ISOCountry.AD, "AD")
        self.assertEqual(ISOCountry.AD, "AND")
        self.assertEqual(ISOCountry.AD, "Andorra")
        self.assertEqual(ISOCountry.AD, "ANDORRA")
        self.assertEqual(str(ISOCountry.AD), "AD")
        self.assertEqual(ISOCountry.AD, "the Principality of Andorra")
        self.assertEqual(ISOCountry.AD, "THE PRINCIPALITY OF ANDORRA")

        self.assertEqual(ISOCountry.AE, 784)
        self.assertEqual(ISOCountry.AE.label, "United Arab Emirates (the)")
        self.assertEqual(ISOCountry.AE.alpha2, "AE")
        self.assertEqual(ISOCountry.AE.short_name, "United Arab Emirates (the)")
        self.assertEqual(ISOCountry.AE, ISOCountry("United Arab Emirates (the)"))
        self.assertEqual(ISOCountry.AE, "AE")
        self.assertEqual(ISOCountry.AE, "ARE")
        self.assertEqual(ISOCountry.AE, "United Arab Emirates (the)")
        self.assertEqual(ISOCountry.AE, "UNITED ARAB EMIRATES (THE)")
        self.assertEqual(str(ISOCountry.AE), "AE")
        self.assertEqual(ISOCountry.AE, "the United Arab Emirates")
        self.assertEqual(ISOCountry.AE, "THE UNITED ARAB EMIRATES")

        self.assertEqual(ISOCountry.AF, 4)
        self.assertEqual(ISOCountry.AF.label, "Afghanistan")
        self.assertEqual(ISOCountry.AF.alpha2, "AF")
        self.assertEqual(ISOCountry.AF.short_name, "Afghanistan")
        self.assertEqual(ISOCountry.AF, ISOCountry("Afghanistan"))
        self.assertEqual(ISOCountry.AF, "AF")
        self.assertEqual(ISOCountry.AF, "AFG")
        self.assertEqual(ISOCountry.AF, "Afghanistan")
        self.assertEqual(ISOCountry.AF, "AFGHANISTAN")
        self.assertEqual(str(ISOCountry.AF), "AF")
        self.assertEqual(ISOCountry.AF, "the Islamic Republic of Afghanistan")
        self.assertEqual(ISOCountry.AF, "THE ISLAMIC REPUBLIC OF AFGHANISTAN")

        self.assertEqual(ISOCountry.AG, 28)
        self.assertEqual(ISOCountry.AG.label, "Antigua and Barbuda")
        self.assertEqual(ISOCountry.AG.alpha2, "AG")
        self.assertEqual(ISOCountry.AG.short_name, "Antigua and Barbuda")
        self.assertEqual(ISOCountry.AG, ISOCountry("Antigua and Barbuda"))
        self.assertEqual(ISOCountry.AG, "AG")
        self.assertEqual(ISOCountry.AG, "ATG")
        self.assertEqual(ISOCountry.AG, "Antigua and Barbuda")
        self.assertEqual(ISOCountry.AG, "ANTIGUA AND BARBUDA")
        self.assertEqual(str(ISOCountry.AG), "AG")

        self.assertEqual(ISOCountry.AI, 660)
        self.assertEqual(ISOCountry.AI.label, "Anguilla")
        self.assertEqual(ISOCountry.AI.alpha2, "AI")
        self.assertEqual(ISOCountry.AI.short_name, "Anguilla")
        self.assertEqual(ISOCountry.AI, ISOCountry("Anguilla"))
        self.assertEqual(ISOCountry.AI, "AI")
        self.assertEqual(ISOCountry.AI, "AIA")
        self.assertEqual(ISOCountry.AI, "Anguilla")
        self.assertEqual(ISOCountry.AI, "ANGUILLA")
        self.assertEqual(str(ISOCountry.AI), "AI")

        self.assertEqual(ISOCountry.AL, 8)
        self.assertEqual(ISOCountry.AL.label, "Albania")
        self.assertEqual(ISOCountry.AL.alpha2, "AL")
        self.assertEqual(ISOCountry.AL.short_name, "Albania")
        self.assertEqual(ISOCountry.AL, ISOCountry("Albania"))
        self.assertEqual(ISOCountry.AL, "AL")
        self.assertEqual(ISOCountry.AL, "ALB")
        self.assertEqual(ISOCountry.AL, "Albania")
        self.assertEqual(ISOCountry.AL, "ALBANIA")
        self.assertEqual(str(ISOCountry.AL), "AL")
        self.assertEqual(ISOCountry.AL, "the Republic of Albania")
        self.assertEqual(ISOCountry.AL, "THE REPUBLIC OF ALBANIA")

        self.assertEqual(ISOCountry.AM, 51)
        self.assertEqual(ISOCountry.AM.label, "Armenia")
        self.assertEqual(ISOCountry.AM.alpha2, "AM")
        self.assertEqual(ISOCountry.AM.short_name, "Armenia")
        self.assertEqual(ISOCountry.AM, ISOCountry("Armenia"))
        self.assertEqual(ISOCountry.AM, "AM")
        self.assertEqual(ISOCountry.AM, "ARM")
        self.assertEqual(ISOCountry.AM, "Armenia")
        self.assertEqual(ISOCountry.AM, "ARMENIA")
        self.assertEqual(str(ISOCountry.AM), "AM")
        self.assertEqual(ISOCountry.AM, "the Republic of Armenia")
        self.assertEqual(ISOCountry.AM, "THE REPUBLIC OF ARMENIA")

        self.assertEqual(ISOCountry.AO, 24)
        self.assertEqual(ISOCountry.AO.label, "Angola")
        self.assertEqual(ISOCountry.AO.alpha2, "AO")
        self.assertEqual(ISOCountry.AO.short_name, "Angola")
        self.assertEqual(ISOCountry.AO, ISOCountry("Angola"))
        self.assertEqual(ISOCountry.AO, "AO")
        self.assertEqual(ISOCountry.AO, "AGO")
        self.assertEqual(ISOCountry.AO, "Angola")
        self.assertEqual(ISOCountry.AO, "ANGOLA")
        self.assertEqual(str(ISOCountry.AO), "AO")
        self.assertEqual(ISOCountry.AO, "the Republic of Angola")
        self.assertEqual(ISOCountry.AO, "THE REPUBLIC OF ANGOLA")

        self.assertEqual(ISOCountry.AQ, 10)
        self.assertEqual(ISOCountry.AQ.label, "Antarctica")
        self.assertEqual(ISOCountry.AQ.alpha2, "AQ")
        self.assertEqual(ISOCountry.AQ.short_name, "Antarctica")
        self.assertEqual(ISOCountry.AQ, ISOCountry("Antarctica"))
        self.assertEqual(ISOCountry.AQ, "AQ")
        self.assertEqual(ISOCountry.AQ, "ATA")
        self.assertEqual(ISOCountry.AQ, "Antarctica")
        self.assertEqual(ISOCountry.AQ, "ANTARCTICA")
        self.assertEqual(str(ISOCountry.AQ), "AQ")

        self.assertEqual(ISOCountry.AR, 32)
        self.assertEqual(ISOCountry.AR.label, "Argentina")
        self.assertEqual(ISOCountry.AR.alpha2, "AR")
        self.assertEqual(ISOCountry.AR.short_name, "Argentina")
        self.assertEqual(ISOCountry.AR, ISOCountry("Argentina"))
        self.assertEqual(ISOCountry.AR, "AR")
        self.assertEqual(ISOCountry.AR, "ARG")
        self.assertEqual(ISOCountry.AR, "Argentina")
        self.assertEqual(ISOCountry.AR, "ARGENTINA")
        self.assertEqual(str(ISOCountry.AR), "AR")
        self.assertEqual(ISOCountry.AR, "the Argentine Republic")
        self.assertEqual(ISOCountry.AR, "THE ARGENTINE REPUBLIC")

        self.assertEqual(ISOCountry.AS, 16)
        self.assertEqual(ISOCountry.AS.label, "American Samoa")
        self.assertEqual(ISOCountry.AS.alpha2, "AS")
        self.assertEqual(ISOCountry.AS.short_name, "American Samoa")
        self.assertEqual(ISOCountry.AS, ISOCountry("American Samoa"))
        self.assertEqual(ISOCountry.AS, "AS")
        self.assertEqual(ISOCountry.AS, "ASM")
        self.assertEqual(ISOCountry.AS, "American Samoa")
        self.assertEqual(ISOCountry.AS, "AMERICAN SAMOA")
        self.assertEqual(str(ISOCountry.AS), "AS")

        self.assertEqual(ISOCountry.AT, 40)
        self.assertEqual(ISOCountry.AT.label, "Austria")
        self.assertEqual(ISOCountry.AT.alpha2, "AT")
        self.assertEqual(ISOCountry.AT.short_name, "Austria")
        self.assertEqual(ISOCountry.AT, ISOCountry("Austria"))
        self.assertEqual(ISOCountry.AT, "AT")
        self.assertEqual(ISOCountry.AT, "AUT")
        self.assertEqual(ISOCountry.AT, "Austria")
        self.assertEqual(ISOCountry.AT, "AUSTRIA")
        self.assertEqual(str(ISOCountry.AT), "AT")
        self.assertEqual(ISOCountry.AT, "the Republic of Austria")
        self.assertEqual(ISOCountry.AT, "THE REPUBLIC OF AUSTRIA")

        self.assertEqual(ISOCountry.AU, 36)
        self.assertEqual(ISOCountry.AU.label, "Australia")
        self.assertEqual(ISOCountry.AU.alpha2, "AU")
        self.assertEqual(ISOCountry.AU.short_name, "Australia")
        self.assertEqual(ISOCountry.AU, ISOCountry("Australia"))
        self.assertEqual(ISOCountry.AU, "AU")
        self.assertEqual(ISOCountry.AU, "AUS")
        self.assertEqual(ISOCountry.AU, "Australia")
        self.assertEqual(ISOCountry.AU, "AUSTRALIA")
        self.assertEqual(str(ISOCountry.AU), "AU")

        self.assertEqual(ISOCountry.AW, 533)
        self.assertEqual(ISOCountry.AW.label, "Aruba")
        self.assertEqual(ISOCountry.AW.alpha2, "AW")
        self.assertEqual(ISOCountry.AW.short_name, "Aruba")
        self.assertEqual(ISOCountry.AW, ISOCountry("Aruba"))
        self.assertEqual(ISOCountry.AW, "AW")
        self.assertEqual(ISOCountry.AW, "ABW")
        self.assertEqual(ISOCountry.AW, "Aruba")
        self.assertEqual(ISOCountry.AW, "ARUBA")
        self.assertEqual(str(ISOCountry.AW), "AW")

        self.assertEqual(ISOCountry.AX, 248)
        self.assertEqual(ISOCountry.AX.label, "Åland Islands")
        self.assertEqual(ISOCountry.AX.alpha2, "AX")
        self.assertEqual(ISOCountry.AX.short_name, "Åland Islands")
        self.assertEqual(ISOCountry.AX, ISOCountry("Åland Islands"))
        self.assertEqual(ISOCountry.AX, "AX")
        self.assertEqual(ISOCountry.AX, "ALA")
        self.assertEqual(ISOCountry.AX, "Åland Islands")
        self.assertEqual(ISOCountry.AX, "ÅLAND ISLANDS")
        self.assertEqual(str(ISOCountry.AX), "AX")

        self.assertEqual(ISOCountry.AZ, 31)
        self.assertEqual(ISOCountry.AZ.label, "Azerbaijan")
        self.assertEqual(ISOCountry.AZ.alpha2, "AZ")
        self.assertEqual(ISOCountry.AZ.short_name, "Azerbaijan")
        self.assertEqual(ISOCountry.AZ, ISOCountry("Azerbaijan"))
        self.assertEqual(ISOCountry.AZ, "AZ")
        self.assertEqual(ISOCountry.AZ, "AZE")
        self.assertEqual(ISOCountry.AZ, "Azerbaijan")
        self.assertEqual(ISOCountry.AZ, "AZERBAIJAN")
        self.assertEqual(str(ISOCountry.AZ), "AZ")
        self.assertEqual(ISOCountry.AZ, "the Republic of Azerbaijan")
        self.assertEqual(ISOCountry.AZ, "THE REPUBLIC OF AZERBAIJAN")

        self.assertEqual(ISOCountry.BA, 70)
        self.assertEqual(ISOCountry.BA.label, "Bosnia and Herzegovina")
        self.assertEqual(ISOCountry.BA.alpha2, "BA")
        self.assertEqual(ISOCountry.BA.short_name, "Bosnia and Herzegovina")
        self.assertEqual(ISOCountry.BA, ISOCountry("Bosnia and Herzegovina"))
        self.assertEqual(ISOCountry.BA, "BA")
        self.assertEqual(ISOCountry.BA, "BIH")
        self.assertEqual(ISOCountry.BA, "Bosnia and Herzegovina")
        self.assertEqual(ISOCountry.BA, "BOSNIA AND HERZEGOVINA")
        self.assertEqual(str(ISOCountry.BA), "BA")

        self.assertEqual(ISOCountry.BB, 52)
        self.assertEqual(ISOCountry.BB.label, "Barbados")
        self.assertEqual(ISOCountry.BB.alpha2, "BB")
        self.assertEqual(ISOCountry.BB.short_name, "Barbados")
        self.assertEqual(ISOCountry.BB, ISOCountry("Barbados"))
        self.assertEqual(ISOCountry.BB, "BB")
        self.assertEqual(ISOCountry.BB, "BRB")
        self.assertEqual(ISOCountry.BB, "Barbados")
        self.assertEqual(ISOCountry.BB, "BARBADOS")
        self.assertEqual(str(ISOCountry.BB), "BB")

        self.assertEqual(ISOCountry.BD, 50)
        self.assertEqual(ISOCountry.BD.label, "Bangladesh")
        self.assertEqual(ISOCountry.BD.alpha2, "BD")
        self.assertEqual(ISOCountry.BD.short_name, "Bangladesh")
        self.assertEqual(ISOCountry.BD, ISOCountry("Bangladesh"))
        self.assertEqual(ISOCountry.BD, "BD")
        self.assertEqual(ISOCountry.BD, "BGD")
        self.assertEqual(ISOCountry.BD, "Bangladesh")
        self.assertEqual(ISOCountry.BD, "BANGLADESH")
        self.assertEqual(str(ISOCountry.BD), "BD")
        self.assertEqual(ISOCountry.BD, "the People's Republic of Bangladesh")
        self.assertEqual(ISOCountry.BD, "THE PEOPLE'S REPUBLIC OF BANGLADESH")

        self.assertEqual(ISOCountry.BE, 56)
        self.assertEqual(ISOCountry.BE.label, "Belgium")
        self.assertEqual(ISOCountry.BE.alpha2, "BE")
        self.assertEqual(ISOCountry.BE.short_name, "Belgium")
        self.assertEqual(ISOCountry.BE, ISOCountry("Belgium"))
        self.assertEqual(ISOCountry.BE, "BE")
        self.assertEqual(ISOCountry.BE, "BEL")
        self.assertEqual(ISOCountry.BE, "Belgium")
        self.assertEqual(ISOCountry.BE, "BELGIUM")
        self.assertEqual(str(ISOCountry.BE), "BE")
        self.assertEqual(ISOCountry.BE, "the Kingdom of Belgium")
        self.assertEqual(ISOCountry.BE, "THE KINGDOM OF BELGIUM")

        self.assertEqual(ISOCountry.BF, 854)
        self.assertEqual(ISOCountry.BF.label, "Burkina Faso")
        self.assertEqual(ISOCountry.BF.alpha2, "BF")
        self.assertEqual(ISOCountry.BF.short_name, "Burkina Faso")
        self.assertEqual(ISOCountry.BF, ISOCountry("Burkina Faso"))
        self.assertEqual(ISOCountry.BF, "BF")
        self.assertEqual(ISOCountry.BF, "BFA")
        self.assertEqual(ISOCountry.BF, "Burkina Faso")
        self.assertEqual(ISOCountry.BF, "BURKINA FASO")
        self.assertEqual(str(ISOCountry.BF), "BF")

        self.assertEqual(ISOCountry.BG, 100)
        self.assertEqual(ISOCountry.BG.label, "Bulgaria")
        self.assertEqual(ISOCountry.BG.alpha2, "BG")
        self.assertEqual(ISOCountry.BG.short_name, "Bulgaria")
        self.assertEqual(ISOCountry.BG, ISOCountry("Bulgaria"))
        self.assertEqual(ISOCountry.BG, "BG")
        self.assertEqual(ISOCountry.BG, "BGR")
        self.assertEqual(ISOCountry.BG, "Bulgaria")
        self.assertEqual(ISOCountry.BG, "BULGARIA")
        self.assertEqual(str(ISOCountry.BG), "BG")
        self.assertEqual(ISOCountry.BG, "the Republic of Bulgaria")
        self.assertEqual(ISOCountry.BG, "THE REPUBLIC OF BULGARIA")

        self.assertEqual(ISOCountry.BH, 48)
        self.assertEqual(ISOCountry.BH.label, "Bahrain")
        self.assertEqual(ISOCountry.BH.alpha2, "BH")
        self.assertEqual(ISOCountry.BH.short_name, "Bahrain")
        self.assertEqual(ISOCountry.BH, ISOCountry("Bahrain"))
        self.assertEqual(ISOCountry.BH, "BH")
        self.assertEqual(ISOCountry.BH, "BHR")
        self.assertEqual(ISOCountry.BH, "Bahrain")
        self.assertEqual(ISOCountry.BH, "BAHRAIN")
        self.assertEqual(str(ISOCountry.BH), "BH")
        self.assertEqual(ISOCountry.BH, "the Kingdom of Bahrain")
        self.assertEqual(ISOCountry.BH, "THE KINGDOM OF BAHRAIN")

        self.assertEqual(ISOCountry.BI, 108)
        self.assertEqual(ISOCountry.BI.label, "Burundi")
        self.assertEqual(ISOCountry.BI.alpha2, "BI")
        self.assertEqual(ISOCountry.BI.short_name, "Burundi")
        self.assertEqual(ISOCountry.BI, ISOCountry("Burundi"))
        self.assertEqual(ISOCountry.BI, "BI")
        self.assertEqual(ISOCountry.BI, "BDI")
        self.assertEqual(ISOCountry.BI, "Burundi")
        self.assertEqual(ISOCountry.BI, "BURUNDI")
        self.assertEqual(str(ISOCountry.BI), "BI")
        self.assertEqual(ISOCountry.BI, "the Republic of Burundi")
        self.assertEqual(ISOCountry.BI, "THE REPUBLIC OF BURUNDI")

        self.assertEqual(ISOCountry.BJ, 204)
        self.assertEqual(ISOCountry.BJ.label, "Benin")
        self.assertEqual(ISOCountry.BJ.alpha2, "BJ")
        self.assertEqual(ISOCountry.BJ.short_name, "Benin")
        self.assertEqual(ISOCountry.BJ, ISOCountry("Benin"))
        self.assertEqual(ISOCountry.BJ, "BJ")
        self.assertEqual(ISOCountry.BJ, "BEN")
        self.assertEqual(ISOCountry.BJ, "Benin")
        self.assertEqual(ISOCountry.BJ, "BENIN")
        self.assertEqual(str(ISOCountry.BJ), "BJ")
        self.assertEqual(ISOCountry.BJ, "the Republic of Benin")
        self.assertEqual(ISOCountry.BJ, "THE REPUBLIC OF BENIN")

        self.assertEqual(ISOCountry.BL, 652)
        self.assertEqual(ISOCountry.BL.label, "Saint Barthélemy")
        self.assertEqual(ISOCountry.BL.alpha2, "BL")
        self.assertEqual(ISOCountry.BL.short_name, "Saint Barthélemy")
        self.assertEqual(ISOCountry.BL, ISOCountry("Saint Barthélemy"))
        self.assertEqual(ISOCountry.BL, "BL")
        self.assertEqual(ISOCountry.BL, "BLM")
        self.assertEqual(ISOCountry.BL, "Saint Barthélemy")
        self.assertEqual(ISOCountry.BL, "SAINT BARTHÉLEMY")
        self.assertEqual(str(ISOCountry.BL), "BL")

        self.assertEqual(ISOCountry.BM, 60)
        self.assertEqual(ISOCountry.BM.label, "Bermuda")
        self.assertEqual(ISOCountry.BM.alpha2, "BM")
        self.assertEqual(ISOCountry.BM.short_name, "Bermuda")
        self.assertEqual(ISOCountry.BM, ISOCountry("Bermuda"))
        self.assertEqual(ISOCountry.BM, "BM")
        self.assertEqual(ISOCountry.BM, "BMU")
        self.assertEqual(ISOCountry.BM, "Bermuda")
        self.assertEqual(ISOCountry.BM, "BERMUDA")
        self.assertEqual(str(ISOCountry.BM), "BM")

        self.assertEqual(ISOCountry.BN, 96)
        self.assertEqual(ISOCountry.BN.label, "Brunei Darussalam")
        self.assertEqual(ISOCountry.BN.alpha2, "BN")
        self.assertEqual(ISOCountry.BN.short_name, "Brunei Darussalam")
        self.assertEqual(ISOCountry.BN, ISOCountry("Brunei Darussalam"))
        self.assertEqual(ISOCountry.BN, "BN")
        self.assertEqual(ISOCountry.BN, "BRN")
        self.assertEqual(ISOCountry.BN, "Brunei Darussalam")
        self.assertEqual(ISOCountry.BN, "BRUNEI DARUSSALAM")
        self.assertEqual(str(ISOCountry.BN), "BN")

        self.assertEqual(ISOCountry.BO, 68)
        self.assertEqual(ISOCountry.BO.label, "Bolivia (Plurinational State of)")
        self.assertEqual(ISOCountry.BO.alpha2, "BO")
        self.assertEqual(ISOCountry.BO.short_name, "Bolivia (Plurinational State of)")
        self.assertEqual(ISOCountry.BO, ISOCountry("Bolivia (Plurinational State of)"))
        self.assertEqual(ISOCountry.BO, "BO")
        self.assertEqual(ISOCountry.BO, "BOL")
        self.assertEqual(ISOCountry.BO, "Bolivia (Plurinational State of)")
        self.assertEqual(ISOCountry.BO, "BOLIVIA (PLURINATIONAL STATE OF)")
        self.assertEqual(str(ISOCountry.BO), "BO")
        self.assertEqual(ISOCountry.BO, "the Plurinational State of Bolivia")
        self.assertEqual(ISOCountry.BO, "THE PLURINATIONAL STATE OF BOLIVIA")

        self.assertEqual(ISOCountry.BQ, 535)
        self.assertEqual(ISOCountry.BQ.label, "Bonaire, Sint Eustatius and Saba")
        self.assertEqual(ISOCountry.BQ.alpha2, "BQ")
        self.assertEqual(ISOCountry.BQ.short_name, "Bonaire, Sint Eustatius and Saba")
        self.assertEqual(ISOCountry.BQ, ISOCountry("Bonaire, Sint Eustatius and Saba"))
        self.assertEqual(ISOCountry.BQ, "BQ")
        self.assertEqual(ISOCountry.BQ, "BES")
        self.assertEqual(ISOCountry.BQ, "Bonaire, Sint Eustatius and Saba")
        self.assertEqual(ISOCountry.BQ, "BONAIRE, SINT EUSTATIUS AND SABA")
        self.assertEqual(str(ISOCountry.BQ), "BQ")

        self.assertEqual(ISOCountry.BR, 76)
        self.assertEqual(ISOCountry.BR.label, "Brazil")
        self.assertEqual(ISOCountry.BR.alpha2, "BR")
        self.assertEqual(ISOCountry.BR.short_name, "Brazil")
        self.assertEqual(ISOCountry.BR, ISOCountry("Brazil"))
        self.assertEqual(ISOCountry.BR, "BR")
        self.assertEqual(ISOCountry.BR, "BRA")
        self.assertEqual(ISOCountry.BR, "Brazil")
        self.assertEqual(ISOCountry.BR, "BRAZIL")
        self.assertEqual(str(ISOCountry.BR), "BR")
        self.assertEqual(ISOCountry.BR, "the Federative Republic of Brazil")
        self.assertEqual(ISOCountry.BR, "THE FEDERATIVE REPUBLIC OF BRAZIL")

        self.assertEqual(ISOCountry.BS, 44)
        self.assertEqual(ISOCountry.BS.label, "Bahamas (the)")
        self.assertEqual(ISOCountry.BS.alpha2, "BS")
        self.assertEqual(ISOCountry.BS.short_name, "Bahamas (the)")
        self.assertEqual(ISOCountry.BS, ISOCountry("Bahamas (the)"))
        self.assertEqual(ISOCountry.BS, "BS")
        self.assertEqual(ISOCountry.BS, "BHS")
        self.assertEqual(ISOCountry.BS, "Bahamas (the)")
        self.assertEqual(ISOCountry.BS, "BAHAMAS (THE)")
        self.assertEqual(str(ISOCountry.BS), "BS")
        self.assertEqual(ISOCountry.BS, "the Commonwealth of the Bahamas")
        self.assertEqual(ISOCountry.BS, "THE COMMONWEALTH OF THE BAHAMAS")

        self.assertEqual(ISOCountry.BT, 64)
        self.assertEqual(ISOCountry.BT.label, "Bhutan")
        self.assertEqual(ISOCountry.BT.alpha2, "BT")
        self.assertEqual(ISOCountry.BT.short_name, "Bhutan")
        self.assertEqual(ISOCountry.BT, ISOCountry("Bhutan"))
        self.assertEqual(ISOCountry.BT, "BT")
        self.assertEqual(ISOCountry.BT, "BTN")
        self.assertEqual(ISOCountry.BT, "Bhutan")
        self.assertEqual(ISOCountry.BT, "BHUTAN")
        self.assertEqual(str(ISOCountry.BT), "BT")
        self.assertEqual(ISOCountry.BT, "the Kingdom of Bhutan")
        self.assertEqual(ISOCountry.BT, "THE KINGDOM OF BHUTAN")

        self.assertEqual(ISOCountry.BV, 74)
        self.assertEqual(ISOCountry.BV.label, "Bouvet Island")
        self.assertEqual(ISOCountry.BV.alpha2, "BV")
        self.assertEqual(ISOCountry.BV.short_name, "Bouvet Island")
        self.assertEqual(ISOCountry.BV, ISOCountry("Bouvet Island"))
        self.assertEqual(ISOCountry.BV, "BV")
        self.assertEqual(ISOCountry.BV, "BVT")
        self.assertEqual(ISOCountry.BV, "Bouvet Island")
        self.assertEqual(ISOCountry.BV, "BOUVET ISLAND")
        self.assertEqual(str(ISOCountry.BV), "BV")

        self.assertEqual(ISOCountry.BW, 72)
        self.assertEqual(ISOCountry.BW.label, "Botswana")
        self.assertEqual(ISOCountry.BW.alpha2, "BW")
        self.assertEqual(ISOCountry.BW.short_name, "Botswana")
        self.assertEqual(ISOCountry.BW, ISOCountry("Botswana"))
        self.assertEqual(ISOCountry.BW, "BW")
        self.assertEqual(ISOCountry.BW, "BWA")
        self.assertEqual(ISOCountry.BW, "Botswana")
        self.assertEqual(ISOCountry.BW, "BOTSWANA")
        self.assertEqual(str(ISOCountry.BW), "BW")
        self.assertEqual(ISOCountry.BW, "the Republic of Botswana")
        self.assertEqual(ISOCountry.BW, "THE REPUBLIC OF BOTSWANA")

        self.assertEqual(ISOCountry.BY, 112)
        self.assertEqual(ISOCountry.BY.label, "Belarus")
        self.assertEqual(ISOCountry.BY.alpha2, "BY")
        self.assertEqual(ISOCountry.BY.short_name, "Belarus")
        self.assertEqual(ISOCountry.BY, ISOCountry("Belarus"))
        self.assertEqual(ISOCountry.BY, "BY")
        self.assertEqual(ISOCountry.BY, "BLR")
        self.assertEqual(ISOCountry.BY, "Belarus")
        self.assertEqual(ISOCountry.BY, "BELARUS")
        self.assertEqual(str(ISOCountry.BY), "BY")
        self.assertEqual(ISOCountry.BY, "the Republic of Belarus")
        self.assertEqual(ISOCountry.BY, "THE REPUBLIC OF BELARUS")

        self.assertEqual(ISOCountry.BZ, 84)
        self.assertEqual(ISOCountry.BZ.label, "Belize")
        self.assertEqual(ISOCountry.BZ.alpha2, "BZ")
        self.assertEqual(ISOCountry.BZ.short_name, "Belize")
        self.assertEqual(ISOCountry.BZ, ISOCountry("Belize"))
        self.assertEqual(ISOCountry.BZ, "BZ")
        self.assertEqual(ISOCountry.BZ, "BLZ")
        self.assertEqual(ISOCountry.BZ, "Belize")
        self.assertEqual(ISOCountry.BZ, "BELIZE")
        self.assertEqual(str(ISOCountry.BZ), "BZ")

        self.assertEqual(ISOCountry.CA, 124)
        self.assertEqual(ISOCountry.CA.label, "Canada")
        self.assertEqual(ISOCountry.CA.alpha2, "CA")
        self.assertEqual(ISOCountry.CA.short_name, "Canada")
        self.assertEqual(ISOCountry.CA, ISOCountry("Canada"))
        self.assertEqual(ISOCountry.CA, "CA")
        self.assertEqual(ISOCountry.CA, "CAN")
        self.assertEqual(ISOCountry.CA, "Canada")
        self.assertEqual(ISOCountry.CA, "CANADA")
        self.assertEqual(str(ISOCountry.CA), "CA")

        self.assertEqual(ISOCountry.CC, 166)
        self.assertEqual(ISOCountry.CC.label, "Cocos (Keeling) Islands (the)")
        self.assertEqual(ISOCountry.CC.alpha2, "CC")
        self.assertEqual(ISOCountry.CC.short_name, "Cocos (Keeling) Islands (the)")
        self.assertEqual(ISOCountry.CC, ISOCountry("Cocos (Keeling) Islands (the)"))
        self.assertEqual(ISOCountry.CC, "CC")
        self.assertEqual(ISOCountry.CC, "CCK")
        self.assertEqual(ISOCountry.CC, "Cocos (Keeling) Islands (the)")
        self.assertEqual(ISOCountry.CC, "COCOS (KEELING) ISLANDS (THE)")
        self.assertEqual(str(ISOCountry.CC), "CC")

        self.assertEqual(ISOCountry.CD, 180)
        self.assertEqual(ISOCountry.CD.label, "Congo (the Democratic Republic of the)")
        self.assertEqual(ISOCountry.CD.alpha2, "CD")
        self.assertEqual(
            ISOCountry.CD.short_name, "Congo (the Democratic Republic of the)"
        )
        self.assertEqual(
            ISOCountry.CD, ISOCountry("Congo (the Democratic Republic of the)")
        )
        self.assertEqual(ISOCountry.CD, "CD")
        self.assertEqual(ISOCountry.CD, "COD")
        self.assertEqual(ISOCountry.CD, "Congo (the Democratic Republic of the)")
        self.assertEqual(ISOCountry.CD, "CONGO (THE DEMOCRATIC REPUBLIC OF THE)")
        self.assertEqual(str(ISOCountry.CD), "CD")
        self.assertEqual(ISOCountry.CD, "the Democratic Republic of the Congo")
        self.assertEqual(ISOCountry.CD, "THE DEMOCRATIC REPUBLIC OF THE CONGO")

        self.assertEqual(ISOCountry.CF, 140)
        self.assertEqual(ISOCountry.CF.label, "Central African Republic (the)")
        self.assertEqual(ISOCountry.CF.alpha2, "CF")
        self.assertEqual(ISOCountry.CF.short_name, "Central African Republic (the)")
        self.assertEqual(ISOCountry.CF, ISOCountry("Central African Republic (the)"))
        self.assertEqual(ISOCountry.CF, "CF")
        self.assertEqual(ISOCountry.CF, "CAF")
        self.assertEqual(ISOCountry.CF, "Central African Republic (the)")
        self.assertEqual(ISOCountry.CF, "CENTRAL AFRICAN REPUBLIC (THE)")
        self.assertEqual(str(ISOCountry.CF), "CF")
        self.assertEqual(ISOCountry.CF, "the Central African Republic")
        self.assertEqual(ISOCountry.CF, "THE CENTRAL AFRICAN REPUBLIC")

        self.assertEqual(ISOCountry.CG, 178)
        self.assertEqual(ISOCountry.CG.label, "Congo (the)")
        self.assertEqual(ISOCountry.CG.alpha2, "CG")
        self.assertEqual(ISOCountry.CG.short_name, "Congo (the)")
        self.assertEqual(ISOCountry.CG, ISOCountry("Congo (the)"))
        self.assertEqual(ISOCountry.CG, "CG")
        self.assertEqual(ISOCountry.CG, "COG")
        self.assertEqual(ISOCountry.CG, "Congo (the)")
        self.assertEqual(ISOCountry.CG, "CONGO (THE)")
        self.assertEqual(str(ISOCountry.CG), "CG")
        self.assertEqual(ISOCountry.CG, "the Republic of the Congo")
        self.assertEqual(ISOCountry.CG, "THE REPUBLIC OF THE CONGO")

        self.assertEqual(ISOCountry.CH, 756)
        self.assertEqual(ISOCountry.CH.label, "Switzerland")
        self.assertEqual(ISOCountry.CH.alpha2, "CH")
        self.assertEqual(ISOCountry.CH.short_name, "Switzerland")
        self.assertEqual(ISOCountry.CH, ISOCountry("Switzerland"))
        self.assertEqual(ISOCountry.CH, "CH")
        self.assertEqual(ISOCountry.CH, "CHE")
        self.assertEqual(ISOCountry.CH, "Switzerland")
        self.assertEqual(ISOCountry.CH, "SWITZERLAND")
        self.assertEqual(str(ISOCountry.CH), "CH")
        self.assertEqual(ISOCountry.CH, "the Swiss Confederation")
        self.assertEqual(ISOCountry.CH, "THE SWISS CONFEDERATION")

        self.assertEqual(ISOCountry.CI, 384)
        self.assertEqual(ISOCountry.CI.label, "Côte d'Ivoire")
        self.assertEqual(ISOCountry.CI.alpha2, "CI")
        self.assertEqual(ISOCountry.CI.short_name, "Côte d'Ivoire")
        self.assertEqual(ISOCountry.CI, ISOCountry("Côte d'Ivoire"))
        self.assertEqual(ISOCountry.CI, "CI")
        self.assertEqual(ISOCountry.CI, "CIV")
        self.assertEqual(ISOCountry.CI, "Côte d'Ivoire")
        self.assertEqual(ISOCountry.CI, "CÔTE D'IVOIRE")
        self.assertEqual(str(ISOCountry.CI), "CI")
        self.assertEqual(ISOCountry.CI, "the Republic of Côte d'Ivoire")
        self.assertEqual(ISOCountry.CI, "THE REPUBLIC OF CÔTE D'IVOIRE")

        self.assertEqual(ISOCountry.CK, 184)
        self.assertEqual(ISOCountry.CK.label, "Cook Islands (the)")
        self.assertEqual(ISOCountry.CK.alpha2, "CK")
        self.assertEqual(ISOCountry.CK.short_name, "Cook Islands (the)")
        self.assertEqual(ISOCountry.CK, ISOCountry("Cook Islands (the)"))
        self.assertEqual(ISOCountry.CK, "CK")
        self.assertEqual(ISOCountry.CK, "COK")
        self.assertEqual(ISOCountry.CK, "Cook Islands (the)")
        self.assertEqual(ISOCountry.CK, "COOK ISLANDS (THE)")
        self.assertEqual(str(ISOCountry.CK), "CK")

        self.assertEqual(ISOCountry.CL, 152)
        self.assertEqual(ISOCountry.CL.label, "Chile")
        self.assertEqual(ISOCountry.CL.alpha2, "CL")
        self.assertEqual(ISOCountry.CL.short_name, "Chile")
        self.assertEqual(ISOCountry.CL, ISOCountry("Chile"))
        self.assertEqual(ISOCountry.CL, "CL")
        self.assertEqual(ISOCountry.CL, "CHL")
        self.assertEqual(ISOCountry.CL, "Chile")
        self.assertEqual(ISOCountry.CL, "CHILE")
        self.assertEqual(str(ISOCountry.CL), "CL")
        self.assertEqual(ISOCountry.CL, "the Republic of Chile")
        self.assertEqual(ISOCountry.CL, "THE REPUBLIC OF CHILE")

        self.assertEqual(ISOCountry.CM, 120)
        self.assertEqual(ISOCountry.CM.label, "Cameroon")
        self.assertEqual(ISOCountry.CM.alpha2, "CM")
        self.assertEqual(ISOCountry.CM.short_name, "Cameroon")
        self.assertEqual(ISOCountry.CM, ISOCountry("Cameroon"))
        self.assertEqual(ISOCountry.CM, "CM")
        self.assertEqual(ISOCountry.CM, "CMR")
        self.assertEqual(ISOCountry.CM, "Cameroon")
        self.assertEqual(ISOCountry.CM, "CAMEROON")
        self.assertEqual(str(ISOCountry.CM), "CM")
        self.assertEqual(ISOCountry.CM, "the Republic of Cameroon")
        self.assertEqual(ISOCountry.CM, "THE REPUBLIC OF CAMEROON")

        self.assertEqual(ISOCountry.CN, 156)
        self.assertEqual(ISOCountry.CN.label, "China")
        self.assertEqual(ISOCountry.CN.alpha2, "CN")
        self.assertEqual(ISOCountry.CN.short_name, "China")
        self.assertEqual(ISOCountry.CN, ISOCountry("China"))
        self.assertEqual(ISOCountry.CN, "CN")
        self.assertEqual(ISOCountry.CN, "CHN")
        self.assertEqual(ISOCountry.CN, "China")
        self.assertEqual(ISOCountry.CN, "CHINA")
        self.assertEqual(str(ISOCountry.CN), "CN")
        self.assertEqual(ISOCountry.CN, "the People's Republic of China")
        self.assertEqual(ISOCountry.CN, "THE PEOPLE'S REPUBLIC OF CHINA")

        self.assertEqual(ISOCountry.CO, 170)
        self.assertEqual(ISOCountry.CO.label, "Colombia")
        self.assertEqual(ISOCountry.CO.alpha2, "CO")
        self.assertEqual(ISOCountry.CO.short_name, "Colombia")
        self.assertEqual(ISOCountry.CO, ISOCountry("Colombia"))
        self.assertEqual(ISOCountry.CO, "CO")
        self.assertEqual(ISOCountry.CO, "COL")
        self.assertEqual(ISOCountry.CO, "Colombia")
        self.assertEqual(ISOCountry.CO, "COLOMBIA")
        self.assertEqual(str(ISOCountry.CO), "CO")
        self.assertEqual(ISOCountry.CO, "the Republic of Colombia")
        self.assertEqual(ISOCountry.CO, "THE REPUBLIC OF COLOMBIA")

        self.assertEqual(ISOCountry.CR, 188)
        self.assertEqual(ISOCountry.CR.label, "Costa Rica")
        self.assertEqual(ISOCountry.CR.alpha2, "CR")
        self.assertEqual(ISOCountry.CR.short_name, "Costa Rica")
        self.assertEqual(ISOCountry.CR, ISOCountry("Costa Rica"))
        self.assertEqual(ISOCountry.CR, "CR")
        self.assertEqual(ISOCountry.CR, "CRI")
        self.assertEqual(ISOCountry.CR, "Costa Rica")
        self.assertEqual(ISOCountry.CR, "COSTA RICA")
        self.assertEqual(str(ISOCountry.CR), "CR")
        self.assertEqual(ISOCountry.CR, "the Republic of Costa Rica")
        self.assertEqual(ISOCountry.CR, "THE REPUBLIC OF COSTA RICA")

        self.assertEqual(ISOCountry.CU, 192)
        self.assertEqual(ISOCountry.CU.label, "Cuba")
        self.assertEqual(ISOCountry.CU.alpha2, "CU")
        self.assertEqual(ISOCountry.CU.short_name, "Cuba")
        self.assertEqual(ISOCountry.CU, ISOCountry("Cuba"))
        self.assertEqual(ISOCountry.CU, "CU")
        self.assertEqual(ISOCountry.CU, "CUB")
        self.assertEqual(ISOCountry.CU, "Cuba")
        self.assertEqual(ISOCountry.CU, "CUBA")
        self.assertEqual(str(ISOCountry.CU), "CU")
        self.assertEqual(ISOCountry.CU, "the Republic of Cuba")
        self.assertEqual(ISOCountry.CU, "THE REPUBLIC OF CUBA")

        self.assertEqual(ISOCountry.CV, 132)
        self.assertEqual(ISOCountry.CV.label, "Cabo Verde")
        self.assertEqual(ISOCountry.CV.alpha2, "CV")
        self.assertEqual(ISOCountry.CV.short_name, "Cabo Verde")
        self.assertEqual(ISOCountry.CV, ISOCountry("Cabo Verde"))
        self.assertEqual(ISOCountry.CV, "CV")
        self.assertEqual(ISOCountry.CV, "CPV")
        self.assertEqual(ISOCountry.CV, "Cabo Verde")
        self.assertEqual(ISOCountry.CV, "CABO VERDE")
        self.assertEqual(str(ISOCountry.CV), "CV")
        self.assertEqual(ISOCountry.CV, "the Republic of Cabo Verde")
        self.assertEqual(ISOCountry.CV, "THE REPUBLIC OF CABO VERDE")

        self.assertEqual(ISOCountry.CW, 531)
        self.assertEqual(ISOCountry.CW.label, "Curaçao")
        self.assertEqual(ISOCountry.CW.alpha2, "CW")
        self.assertEqual(ISOCountry.CW.short_name, "Curaçao")
        self.assertEqual(ISOCountry.CW, ISOCountry("Curaçao"))
        self.assertEqual(ISOCountry.CW, "CW")
        self.assertEqual(ISOCountry.CW, "CUW")
        self.assertEqual(ISOCountry.CW, "Curaçao")
        self.assertEqual(ISOCountry.CW, "CURAÇAO")
        self.assertEqual(str(ISOCountry.CW), "CW")

        self.assertEqual(ISOCountry.CX, 162)
        self.assertEqual(ISOCountry.CX.label, "Christmas Island")
        self.assertEqual(ISOCountry.CX.alpha2, "CX")
        self.assertEqual(ISOCountry.CX.short_name, "Christmas Island")
        self.assertEqual(ISOCountry.CX, ISOCountry("Christmas Island"))
        self.assertEqual(ISOCountry.CX, "CX")
        self.assertEqual(ISOCountry.CX, "CXR")
        self.assertEqual(ISOCountry.CX, "Christmas Island")
        self.assertEqual(ISOCountry.CX, "CHRISTMAS ISLAND")
        self.assertEqual(str(ISOCountry.CX), "CX")

        self.assertEqual(ISOCountry.CY, 196)
        self.assertEqual(ISOCountry.CY.label, "Cyprus")
        self.assertEqual(ISOCountry.CY.alpha2, "CY")
        self.assertEqual(ISOCountry.CY.short_name, "Cyprus")
        self.assertEqual(ISOCountry.CY, ISOCountry("Cyprus"))
        self.assertEqual(ISOCountry.CY, "CY")
        self.assertEqual(ISOCountry.CY, "CYP")
        self.assertEqual(ISOCountry.CY, "Cyprus")
        self.assertEqual(ISOCountry.CY, "CYPRUS")
        self.assertEqual(str(ISOCountry.CY), "CY")
        self.assertEqual(ISOCountry.CY, "the Republic of Cyprus")
        self.assertEqual(ISOCountry.CY, "THE REPUBLIC OF CYPRUS")

        self.assertEqual(ISOCountry.CZ, 203)
        self.assertEqual(ISOCountry.CZ.label, "Czechia")
        self.assertEqual(ISOCountry.CZ.alpha2, "CZ")
        self.assertEqual(ISOCountry.CZ.short_name, "Czechia")
        self.assertEqual(ISOCountry.CZ, ISOCountry("Czechia"))
        self.assertEqual(ISOCountry.CZ, "CZ")
        self.assertEqual(ISOCountry.CZ, "CZE")
        self.assertEqual(ISOCountry.CZ, "Czechia")
        self.assertEqual(ISOCountry.CZ, "CZECHIA")
        self.assertEqual(str(ISOCountry.CZ), "CZ")
        self.assertEqual(ISOCountry.CZ, "the Czech Republic")
        self.assertEqual(ISOCountry.CZ, "THE CZECH REPUBLIC")

        self.assertEqual(ISOCountry.DE, 276)
        self.assertEqual(ISOCountry.DE.label, "Germany")
        self.assertEqual(ISOCountry.DE.alpha2, "DE")
        self.assertEqual(ISOCountry.DE.short_name, "Germany")
        self.assertEqual(ISOCountry.DE, ISOCountry("Germany"))
        self.assertEqual(ISOCountry.DE, "DE")
        self.assertEqual(ISOCountry.DE, "DEU")
        self.assertEqual(ISOCountry.DE, "Germany")
        self.assertEqual(ISOCountry.DE, "GERMANY")
        self.assertEqual(str(ISOCountry.DE), "DE")
        self.assertEqual(ISOCountry.DE, "the Federal Republic of Germany")
        self.assertEqual(ISOCountry.DE, "THE FEDERAL REPUBLIC OF GERMANY")

        self.assertEqual(ISOCountry.DJ, 262)
        self.assertEqual(ISOCountry.DJ.label, "Djibouti")
        self.assertEqual(ISOCountry.DJ.alpha2, "DJ")
        self.assertEqual(ISOCountry.DJ.short_name, "Djibouti")
        self.assertEqual(ISOCountry.DJ, ISOCountry("Djibouti"))
        self.assertEqual(ISOCountry.DJ, "DJ")
        self.assertEqual(ISOCountry.DJ, "DJI")
        self.assertEqual(ISOCountry.DJ, "Djibouti")
        self.assertEqual(ISOCountry.DJ, "DJIBOUTI")
        self.assertEqual(str(ISOCountry.DJ), "DJ")
        self.assertEqual(ISOCountry.DJ, "the Republic of Djibouti")
        self.assertEqual(ISOCountry.DJ, "THE REPUBLIC OF DJIBOUTI")

        self.assertEqual(ISOCountry.DK, 208)
        self.assertEqual(ISOCountry.DK.label, "Denmark")
        self.assertEqual(ISOCountry.DK.alpha2, "DK")
        self.assertEqual(ISOCountry.DK.short_name, "Denmark")
        self.assertEqual(ISOCountry.DK, ISOCountry("Denmark"))
        self.assertEqual(ISOCountry.DK, "DK")
        self.assertEqual(ISOCountry.DK, "DNK")
        self.assertEqual(ISOCountry.DK, "Denmark")
        self.assertEqual(ISOCountry.DK, "DENMARK")
        self.assertEqual(str(ISOCountry.DK), "DK")
        self.assertEqual(ISOCountry.DK, "the Kingdom of Denmark")
        self.assertEqual(ISOCountry.DK, "THE KINGDOM OF DENMARK")

        self.assertEqual(ISOCountry.DM, 212)
        self.assertEqual(ISOCountry.DM.label, "Dominica")
        self.assertEqual(ISOCountry.DM.alpha2, "DM")
        self.assertEqual(ISOCountry.DM.short_name, "Dominica")
        self.assertEqual(ISOCountry.DM, ISOCountry("Dominica"))
        self.assertEqual(ISOCountry.DM, "DM")
        self.assertEqual(ISOCountry.DM, "DMA")
        self.assertEqual(ISOCountry.DM, "Dominica")
        self.assertEqual(ISOCountry.DM, "DOMINICA")
        self.assertEqual(str(ISOCountry.DM), "DM")
        self.assertEqual(ISOCountry.DM, "the Commonwealth of Dominica")
        self.assertEqual(ISOCountry.DM, "THE COMMONWEALTH OF DOMINICA")

        self.assertEqual(ISOCountry.DO, 214)
        self.assertEqual(ISOCountry.DO.label, "Dominican Republic (the)")
        self.assertEqual(ISOCountry.DO.alpha2, "DO")
        self.assertEqual(ISOCountry.DO.short_name, "Dominican Republic (the)")
        self.assertEqual(ISOCountry.DO, ISOCountry("Dominican Republic (the)"))
        self.assertEqual(ISOCountry.DO, "DO")
        self.assertEqual(ISOCountry.DO, "DOM")
        self.assertEqual(ISOCountry.DO, "Dominican Republic (the)")
        self.assertEqual(ISOCountry.DO, "DOMINICAN REPUBLIC (THE)")
        self.assertEqual(str(ISOCountry.DO), "DO")
        self.assertEqual(ISOCountry.DO, "the Dominican Republic")
        self.assertEqual(ISOCountry.DO, "THE DOMINICAN REPUBLIC")

        self.assertEqual(ISOCountry.DZ, 12)
        self.assertEqual(ISOCountry.DZ.label, "Algeria")
        self.assertEqual(ISOCountry.DZ.alpha2, "DZ")
        self.assertEqual(ISOCountry.DZ.short_name, "Algeria")
        self.assertEqual(ISOCountry.DZ, ISOCountry("Algeria"))
        self.assertEqual(ISOCountry.DZ, "DZ")
        self.assertEqual(ISOCountry.DZ, "DZA")
        self.assertEqual(ISOCountry.DZ, "Algeria")
        self.assertEqual(ISOCountry.DZ, "ALGERIA")
        self.assertEqual(str(ISOCountry.DZ), "DZ")
        self.assertEqual(ISOCountry.DZ, "the People's Democratic Republic of Algeria")
        self.assertEqual(ISOCountry.DZ, "THE PEOPLE'S DEMOCRATIC REPUBLIC OF ALGERIA")

        self.assertEqual(ISOCountry.EC, 218)
        self.assertEqual(ISOCountry.EC.label, "Ecuador")
        self.assertEqual(ISOCountry.EC.alpha2, "EC")
        self.assertEqual(ISOCountry.EC.short_name, "Ecuador")
        self.assertEqual(ISOCountry.EC, ISOCountry("Ecuador"))
        self.assertEqual(ISOCountry.EC, "EC")
        self.assertEqual(ISOCountry.EC, "ECU")
        self.assertEqual(ISOCountry.EC, "Ecuador")
        self.assertEqual(ISOCountry.EC, "ECUADOR")
        self.assertEqual(str(ISOCountry.EC), "EC")
        self.assertEqual(ISOCountry.EC, "the Republic of Ecuador")
        self.assertEqual(ISOCountry.EC, "THE REPUBLIC OF ECUADOR")

        self.assertEqual(ISOCountry.EE, 233)
        self.assertEqual(ISOCountry.EE.label, "Estonia")
        self.assertEqual(ISOCountry.EE.alpha2, "EE")
        self.assertEqual(ISOCountry.EE.short_name, "Estonia")
        self.assertEqual(ISOCountry.EE, ISOCountry("Estonia"))
        self.assertEqual(ISOCountry.EE, "EE")
        self.assertEqual(ISOCountry.EE, "EST")
        self.assertEqual(ISOCountry.EE, "Estonia")
        self.assertEqual(ISOCountry.EE, "ESTONIA")
        self.assertEqual(str(ISOCountry.EE), "EE")
        self.assertEqual(ISOCountry.EE, "the Republic of Estonia")
        self.assertEqual(ISOCountry.EE, "THE REPUBLIC OF ESTONIA")

        self.assertEqual(ISOCountry.EG, 818)
        self.assertEqual(ISOCountry.EG.label, "Egypt")
        self.assertEqual(ISOCountry.EG.alpha2, "EG")
        self.assertEqual(ISOCountry.EG.short_name, "Egypt")
        self.assertEqual(ISOCountry.EG, ISOCountry("Egypt"))
        self.assertEqual(ISOCountry.EG, "EG")
        self.assertEqual(ISOCountry.EG, "EGY")
        self.assertEqual(ISOCountry.EG, "Egypt")
        self.assertEqual(ISOCountry.EG, "EGYPT")
        self.assertEqual(str(ISOCountry.EG), "EG")
        self.assertEqual(ISOCountry.EG, "the Arab Republic of Egypt")
        self.assertEqual(ISOCountry.EG, "THE ARAB REPUBLIC OF EGYPT")

        self.assertEqual(ISOCountry.EH, 732)
        self.assertEqual(ISOCountry.EH.label, "Western Sahara*")
        self.assertEqual(ISOCountry.EH.alpha2, "EH")
        self.assertEqual(ISOCountry.EH.short_name, "Western Sahara*")
        self.assertEqual(ISOCountry.EH, ISOCountry("Western Sahara*"))
        self.assertEqual(ISOCountry.EH, "EH")
        self.assertEqual(ISOCountry.EH, "ESH")
        self.assertEqual(ISOCountry.EH, "Western Sahara*")
        self.assertEqual(ISOCountry.EH, "WESTERN SAHARA*")
        self.assertEqual(str(ISOCountry.EH), "EH")

        self.assertEqual(ISOCountry.ER, 232)
        self.assertEqual(ISOCountry.ER.label, "Eritrea")
        self.assertEqual(ISOCountry.ER.alpha2, "ER")
        self.assertEqual(ISOCountry.ER.short_name, "Eritrea")
        self.assertEqual(ISOCountry.ER, ISOCountry("Eritrea"))
        self.assertEqual(ISOCountry.ER, "ER")
        self.assertEqual(ISOCountry.ER, "ERI")
        self.assertEqual(ISOCountry.ER, "Eritrea")
        self.assertEqual(ISOCountry.ER, "ERITREA")
        self.assertEqual(str(ISOCountry.ER), "ER")
        self.assertEqual(ISOCountry.ER, "the State of Eritrea")
        self.assertEqual(ISOCountry.ER, "THE STATE OF ERITREA")

        self.assertEqual(ISOCountry.ES, 724)
        self.assertEqual(ISOCountry.ES.label, "Spain")
        self.assertEqual(ISOCountry.ES.alpha2, "ES")
        self.assertEqual(ISOCountry.ES.short_name, "Spain")
        self.assertEqual(ISOCountry.ES, ISOCountry("Spain"))
        self.assertEqual(ISOCountry.ES, "ES")
        self.assertEqual(ISOCountry.ES, "ESP")
        self.assertEqual(ISOCountry.ES, "Spain")
        self.assertEqual(ISOCountry.ES, "SPAIN")
        self.assertEqual(str(ISOCountry.ES), "ES")
        self.assertEqual(ISOCountry.ES, "the Kingdom of Spain")
        self.assertEqual(ISOCountry.ES, "THE KINGDOM OF SPAIN")

        self.assertEqual(ISOCountry.ET, 231)
        self.assertEqual(ISOCountry.ET.label, "Ethiopia")
        self.assertEqual(ISOCountry.ET.alpha2, "ET")
        self.assertEqual(ISOCountry.ET.short_name, "Ethiopia")
        self.assertEqual(ISOCountry.ET, ISOCountry("Ethiopia"))
        self.assertEqual(ISOCountry.ET, "ET")
        self.assertEqual(ISOCountry.ET, "ETH")
        self.assertEqual(ISOCountry.ET, "Ethiopia")
        self.assertEqual(ISOCountry.ET, "ETHIOPIA")
        self.assertEqual(str(ISOCountry.ET), "ET")
        self.assertEqual(ISOCountry.ET, "the Federal Democratic Republic of Ethiopia")
        self.assertEqual(ISOCountry.ET, "THE FEDERAL DEMOCRATIC REPUBLIC OF ETHIOPIA")

        self.assertEqual(ISOCountry.FI, 246)
        self.assertEqual(ISOCountry.FI.label, "Finland")
        self.assertEqual(ISOCountry.FI.alpha2, "FI")
        self.assertEqual(ISOCountry.FI.short_name, "Finland")
        self.assertEqual(ISOCountry.FI, ISOCountry("Finland"))
        self.assertEqual(ISOCountry.FI, "FI")
        self.assertEqual(ISOCountry.FI, "FIN")
        self.assertEqual(ISOCountry.FI, "Finland")
        self.assertEqual(ISOCountry.FI, "FINLAND")
        self.assertEqual(str(ISOCountry.FI), "FI")
        self.assertEqual(ISOCountry.FI, "the Republic of Finland")
        self.assertEqual(ISOCountry.FI, "THE REPUBLIC OF FINLAND")

        self.assertEqual(ISOCountry.FJ, 242)
        self.assertEqual(ISOCountry.FJ.label, "Fiji")
        self.assertEqual(ISOCountry.FJ.alpha2, "FJ")
        self.assertEqual(ISOCountry.FJ.short_name, "Fiji")
        self.assertEqual(ISOCountry.FJ, ISOCountry("Fiji"))
        self.assertEqual(ISOCountry.FJ, "FJ")
        self.assertEqual(ISOCountry.FJ, "FJI")
        self.assertEqual(ISOCountry.FJ, "Fiji")
        self.assertEqual(ISOCountry.FJ, "FIJI")
        self.assertEqual(str(ISOCountry.FJ), "FJ")
        self.assertEqual(ISOCountry.FJ, "the Republic of Fiji")
        self.assertEqual(ISOCountry.FJ, "THE REPUBLIC OF FIJI")

        self.assertEqual(ISOCountry.FK, 238)
        self.assertEqual(ISOCountry.FK.label, "Falkland Islands (the) [Malvinas]")
        self.assertEqual(ISOCountry.FK.alpha2, "FK")
        self.assertEqual(ISOCountry.FK.short_name, "Falkland Islands (the) [Malvinas]")
        self.assertEqual(ISOCountry.FK, ISOCountry("Falkland Islands (the) [Malvinas]"))
        self.assertEqual(ISOCountry.FK, "FK")
        self.assertEqual(ISOCountry.FK, "FLK")
        self.assertEqual(ISOCountry.FK, "Falkland Islands (the) [Malvinas]")
        self.assertEqual(ISOCountry.FK, "FALKLAND ISLANDS (THE) [MALVINAS]")
        self.assertEqual(str(ISOCountry.FK), "FK")

        self.assertEqual(ISOCountry.FM, 583)
        self.assertEqual(ISOCountry.FM.label, "Micronesia (Federated States of)")
        self.assertEqual(ISOCountry.FM.alpha2, "FM")
        self.assertEqual(ISOCountry.FM.short_name, "Micronesia (Federated States of)")
        self.assertEqual(ISOCountry.FM, ISOCountry("Micronesia (Federated States of)"))
        self.assertEqual(ISOCountry.FM, "FM")
        self.assertEqual(ISOCountry.FM, "FSM")
        self.assertEqual(ISOCountry.FM, "Micronesia (Federated States of)")
        self.assertEqual(ISOCountry.FM, "MICRONESIA (FEDERATED STATES OF)")
        self.assertEqual(str(ISOCountry.FM), "FM")
        self.assertEqual(ISOCountry.FM, "the Federated States of Micronesia")
        self.assertEqual(ISOCountry.FM, "THE FEDERATED STATES OF MICRONESIA")

        self.assertEqual(ISOCountry.FO, 234)
        self.assertEqual(ISOCountry.FO.label, "Faroe Islands (the)")
        self.assertEqual(ISOCountry.FO.alpha2, "FO")
        self.assertEqual(ISOCountry.FO.short_name, "Faroe Islands (the)")
        self.assertEqual(ISOCountry.FO, ISOCountry("Faroe Islands (the)"))
        self.assertEqual(ISOCountry.FO, "FO")
        self.assertEqual(ISOCountry.FO, "FRO")
        self.assertEqual(ISOCountry.FO, "Faroe Islands (the)")
        self.assertEqual(ISOCountry.FO, "FAROE ISLANDS (THE)")
        self.assertEqual(str(ISOCountry.FO), "FO")

        self.assertEqual(ISOCountry.FR, 250)
        self.assertEqual(ISOCountry.FR.label, "France")
        self.assertEqual(ISOCountry.FR.alpha2, "FR")
        self.assertEqual(ISOCountry.FR.short_name, "France")
        self.assertEqual(ISOCountry.FR, ISOCountry("France"))
        self.assertEqual(ISOCountry.FR, "FR")
        self.assertEqual(ISOCountry.FR, "FRA")
        self.assertEqual(ISOCountry.FR, "France")
        self.assertEqual(ISOCountry.FR, "FRANCE")
        self.assertEqual(str(ISOCountry.FR), "FR")
        self.assertEqual(ISOCountry.FR, "the French Republic")
        self.assertEqual(ISOCountry.FR, "THE FRENCH REPUBLIC")

        self.assertEqual(ISOCountry.GA, 266)
        self.assertEqual(ISOCountry.GA.label, "Gabon")
        self.assertEqual(ISOCountry.GA.alpha2, "GA")
        self.assertEqual(ISOCountry.GA.short_name, "Gabon")
        self.assertEqual(ISOCountry.GA, ISOCountry("Gabon"))
        self.assertEqual(ISOCountry.GA, "GA")
        self.assertEqual(ISOCountry.GA, "GAB")
        self.assertEqual(ISOCountry.GA, "Gabon")
        self.assertEqual(ISOCountry.GA, "GABON")
        self.assertEqual(str(ISOCountry.GA), "GA")
        self.assertEqual(ISOCountry.GA, "the Gabonese Republic")
        self.assertEqual(ISOCountry.GA, "THE GABONESE REPUBLIC")

        self.assertEqual(ISOCountry.GB, 826)
        self.assertEqual(
            ISOCountry.GB.label,
            "United Kingdom of Great Britain and Northern Ireland (the)",
        )
        self.assertEqual(ISOCountry.GB.alpha2, "GB")
        self.assertEqual(
            ISOCountry.GB.short_name,
            "United Kingdom of Great Britain and Northern Ireland (the)",
        )
        self.assertEqual(
            ISOCountry.GB,
            ISOCountry("United Kingdom of Great Britain and Northern Ireland (the)"),
        )
        self.assertEqual(ISOCountry.GB, "GB")
        self.assertEqual(ISOCountry.GB, "GBR")
        self.assertEqual(
            ISOCountry.GB, "United Kingdom of Great Britain and Northern Ireland (the)"
        )
        self.assertEqual(
            ISOCountry.GB, "UNITED KINGDOM OF GREAT BRITAIN AND NORTHERN IRELAND (THE)"
        )
        self.assertEqual(str(ISOCountry.GB), "GB")
        self.assertEqual(
            ISOCountry.GB, "the United Kingdom of Great Britain and Northern Ireland"
        )
        self.assertEqual(
            ISOCountry.GB, "THE UNITED KINGDOM OF GREAT BRITAIN AND NORTHERN IRELAND"
        )

        self.assertEqual(ISOCountry.GD, 308)
        self.assertEqual(ISOCountry.GD.label, "Grenada")
        self.assertEqual(ISOCountry.GD.alpha2, "GD")
        self.assertEqual(ISOCountry.GD.short_name, "Grenada")
        self.assertEqual(ISOCountry.GD, ISOCountry("Grenada"))
        self.assertEqual(ISOCountry.GD, "GD")
        self.assertEqual(ISOCountry.GD, "GRD")
        self.assertEqual(ISOCountry.GD, "Grenada")
        self.assertEqual(ISOCountry.GD, "GRENADA")
        self.assertEqual(str(ISOCountry.GD), "GD")

        self.assertEqual(ISOCountry.GE, 268)
        self.assertEqual(ISOCountry.GE.label, "Georgia")
        self.assertEqual(ISOCountry.GE.alpha2, "GE")
        self.assertEqual(ISOCountry.GE.short_name, "Georgia")
        self.assertEqual(ISOCountry.GE, ISOCountry("Georgia"))
        self.assertEqual(ISOCountry.GE, "GE")
        self.assertEqual(ISOCountry.GE, "GEO")
        self.assertEqual(ISOCountry.GE, "Georgia")
        self.assertEqual(ISOCountry.GE, "GEORGIA")
        self.assertEqual(str(ISOCountry.GE), "GE")

        self.assertEqual(ISOCountry.GF, 254)
        self.assertEqual(ISOCountry.GF.label, "French Guiana")
        self.assertEqual(ISOCountry.GF.alpha2, "GF")
        self.assertEqual(ISOCountry.GF.short_name, "French Guiana")
        self.assertEqual(ISOCountry.GF, ISOCountry("French Guiana"))
        self.assertEqual(ISOCountry.GF, "GF")
        self.assertEqual(ISOCountry.GF, "GUF")
        self.assertEqual(ISOCountry.GF, "French Guiana")
        self.assertEqual(ISOCountry.GF, "FRENCH GUIANA")
        self.assertEqual(str(ISOCountry.GF), "GF")

        self.assertEqual(ISOCountry.GG, 831)
        self.assertEqual(ISOCountry.GG.label, "Guernsey")
        self.assertEqual(ISOCountry.GG.alpha2, "GG")
        self.assertEqual(ISOCountry.GG.short_name, "Guernsey")
        self.assertEqual(ISOCountry.GG, ISOCountry("Guernsey"))
        self.assertEqual(ISOCountry.GG, "GG")
        self.assertEqual(ISOCountry.GG, "GGY")
        self.assertEqual(ISOCountry.GG, "Guernsey")
        self.assertEqual(ISOCountry.GG, "GUERNSEY")
        self.assertEqual(str(ISOCountry.GG), "GG")

        self.assertEqual(ISOCountry.GH, 288)
        self.assertEqual(ISOCountry.GH.label, "Ghana")
        self.assertEqual(ISOCountry.GH.alpha2, "GH")
        self.assertEqual(ISOCountry.GH.short_name, "Ghana")
        self.assertEqual(ISOCountry.GH, ISOCountry("Ghana"))
        self.assertEqual(ISOCountry.GH, "GH")
        self.assertEqual(ISOCountry.GH, "GHA")
        self.assertEqual(ISOCountry.GH, "Ghana")
        self.assertEqual(ISOCountry.GH, "GHANA")
        self.assertEqual(str(ISOCountry.GH), "GH")
        self.assertEqual(ISOCountry.GH, "the Republic of Ghana")
        self.assertEqual(ISOCountry.GH, "THE REPUBLIC OF GHANA")

        self.assertEqual(ISOCountry.GI, 292)
        self.assertEqual(ISOCountry.GI.label, "Gibraltar")
        self.assertEqual(ISOCountry.GI.alpha2, "GI")
        self.assertEqual(ISOCountry.GI.short_name, "Gibraltar")
        self.assertEqual(ISOCountry.GI, ISOCountry("Gibraltar"))
        self.assertEqual(ISOCountry.GI, "GI")
        self.assertEqual(ISOCountry.GI, "GIB")
        self.assertEqual(ISOCountry.GI, "Gibraltar")
        self.assertEqual(ISOCountry.GI, "GIBRALTAR")
        self.assertEqual(str(ISOCountry.GI), "GI")

        self.assertEqual(ISOCountry.GL, 304)
        self.assertEqual(ISOCountry.GL.label, "Greenland")
        self.assertEqual(ISOCountry.GL.alpha2, "GL")
        self.assertEqual(ISOCountry.GL.short_name, "Greenland")
        self.assertEqual(ISOCountry.GL, ISOCountry("Greenland"))
        self.assertEqual(ISOCountry.GL, "GL")
        self.assertEqual(ISOCountry.GL, "GRL")
        self.assertEqual(ISOCountry.GL, "Greenland")
        self.assertEqual(ISOCountry.GL, "GREENLAND")
        self.assertEqual(str(ISOCountry.GL), "GL")

        self.assertEqual(ISOCountry.GM, 270)
        self.assertEqual(ISOCountry.GM.label, "Gambia (the)")
        self.assertEqual(ISOCountry.GM.alpha2, "GM")
        self.assertEqual(ISOCountry.GM.short_name, "Gambia (the)")
        self.assertEqual(ISOCountry.GM, ISOCountry("Gambia (the)"))
        self.assertEqual(ISOCountry.GM, "GM")
        self.assertEqual(ISOCountry.GM, "GMB")
        self.assertEqual(ISOCountry.GM, "Gambia (the)")
        self.assertEqual(ISOCountry.GM, "GAMBIA (THE)")
        self.assertEqual(str(ISOCountry.GM), "GM")
        self.assertEqual(ISOCountry.GM, "the Republic of the Gambia")
        self.assertEqual(ISOCountry.GM, "THE REPUBLIC OF THE GAMBIA")

        self.assertEqual(ISOCountry.GN, 324)
        self.assertEqual(ISOCountry.GN.label, "Guinea")
        self.assertEqual(ISOCountry.GN.alpha2, "GN")
        self.assertEqual(ISOCountry.GN.short_name, "Guinea")
        self.assertEqual(ISOCountry.GN, ISOCountry("Guinea"))
        self.assertEqual(ISOCountry.GN, "GN")
        self.assertEqual(ISOCountry.GN, "GIN")
        self.assertEqual(ISOCountry.GN, "Guinea")
        self.assertEqual(ISOCountry.GN, "GUINEA")
        self.assertEqual(str(ISOCountry.GN), "GN")
        self.assertEqual(ISOCountry.GN, "the Republic of Guinea")
        self.assertEqual(ISOCountry.GN, "THE REPUBLIC OF GUINEA")

        self.assertEqual(ISOCountry.GP, 312)
        self.assertEqual(ISOCountry.GP.label, "Guadeloupe")
        self.assertEqual(ISOCountry.GP.alpha2, "GP")
        self.assertEqual(ISOCountry.GP.short_name, "Guadeloupe")
        self.assertEqual(ISOCountry.GP, ISOCountry("Guadeloupe"))
        self.assertEqual(ISOCountry.GP, "GP")
        self.assertEqual(ISOCountry.GP, "GLP")
        self.assertEqual(ISOCountry.GP, "Guadeloupe")
        self.assertEqual(ISOCountry.GP, "GUADELOUPE")
        self.assertEqual(str(ISOCountry.GP), "GP")

        self.assertEqual(ISOCountry.GQ, 226)
        self.assertEqual(ISOCountry.GQ.label, "Equatorial Guinea")
        self.assertEqual(ISOCountry.GQ.alpha2, "GQ")
        self.assertEqual(ISOCountry.GQ.short_name, "Equatorial Guinea")
        self.assertEqual(ISOCountry.GQ, ISOCountry("Equatorial Guinea"))
        self.assertEqual(ISOCountry.GQ, "GQ")
        self.assertEqual(ISOCountry.GQ, "GNQ")
        self.assertEqual(ISOCountry.GQ, "Equatorial Guinea")
        self.assertEqual(ISOCountry.GQ, "EQUATORIAL GUINEA")
        self.assertEqual(str(ISOCountry.GQ), "GQ")
        self.assertEqual(ISOCountry.GQ, "the Republic of Equatorial Guinea")
        self.assertEqual(ISOCountry.GQ, "THE REPUBLIC OF EQUATORIAL GUINEA")

        self.assertEqual(ISOCountry.GR, 300)
        self.assertEqual(ISOCountry.GR.label, "Greece")
        self.assertEqual(ISOCountry.GR.alpha2, "GR")
        self.assertEqual(ISOCountry.GR.short_name, "Greece")
        self.assertEqual(ISOCountry.GR, ISOCountry("Greece"))
        self.assertEqual(ISOCountry.GR, "GR")
        self.assertEqual(ISOCountry.GR, "GRC")
        self.assertEqual(ISOCountry.GR, "Greece")
        self.assertEqual(ISOCountry.GR, "GREECE")
        self.assertEqual(str(ISOCountry.GR), "GR")
        self.assertEqual(ISOCountry.GR, "the Hellenic Republic")
        self.assertEqual(ISOCountry.GR, "THE HELLENIC REPUBLIC")

        self.assertEqual(ISOCountry.GS, 239)
        self.assertEqual(
            ISOCountry.GS.label, "South Georgia and the South Sandwich Islands"
        )
        self.assertEqual(ISOCountry.GS.alpha2, "GS")
        self.assertEqual(
            ISOCountry.GS.short_name, "South Georgia and the South Sandwich Islands"
        )
        self.assertEqual(
            ISOCountry.GS, ISOCountry("South Georgia and the South Sandwich Islands")
        )
        self.assertEqual(ISOCountry.GS, "GS")
        self.assertEqual(ISOCountry.GS, "SGS")
        self.assertEqual(ISOCountry.GS, "South Georgia and the South Sandwich Islands")
        self.assertEqual(ISOCountry.GS, "SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS")
        self.assertEqual(str(ISOCountry.GS), "GS")

        self.assertEqual(ISOCountry.GT, 320)
        self.assertEqual(ISOCountry.GT.label, "Guatemala")
        self.assertEqual(ISOCountry.GT.alpha2, "GT")
        self.assertEqual(ISOCountry.GT.short_name, "Guatemala")
        self.assertEqual(ISOCountry.GT, ISOCountry("Guatemala"))
        self.assertEqual(ISOCountry.GT, "GT")
        self.assertEqual(ISOCountry.GT, "GTM")
        self.assertEqual(ISOCountry.GT, "Guatemala")
        self.assertEqual(ISOCountry.GT, "GUATEMALA")
        self.assertEqual(str(ISOCountry.GT), "GT")
        self.assertEqual(ISOCountry.GT, "the Republic of Guatemala")
        self.assertEqual(ISOCountry.GT, "THE REPUBLIC OF GUATEMALA")

        self.assertEqual(ISOCountry.GU, 316)
        self.assertEqual(ISOCountry.GU.label, "Guam")
        self.assertEqual(ISOCountry.GU.alpha2, "GU")
        self.assertEqual(ISOCountry.GU.short_name, "Guam")
        self.assertEqual(ISOCountry.GU, ISOCountry("Guam"))
        self.assertEqual(ISOCountry.GU, "GU")
        self.assertEqual(ISOCountry.GU, "GUM")
        self.assertEqual(ISOCountry.GU, "Guam")
        self.assertEqual(ISOCountry.GU, "GUAM")
        self.assertEqual(str(ISOCountry.GU), "GU")

        self.assertEqual(ISOCountry.GW, 624)
        self.assertEqual(ISOCountry.GW.label, "Guinea-Bissau")
        self.assertEqual(ISOCountry.GW.alpha2, "GW")
        self.assertEqual(ISOCountry.GW.short_name, "Guinea-Bissau")
        self.assertEqual(ISOCountry.GW, ISOCountry("Guinea-Bissau"))
        self.assertEqual(ISOCountry.GW, "GW")
        self.assertEqual(ISOCountry.GW, "GNB")
        self.assertEqual(ISOCountry.GW, "Guinea-Bissau")
        self.assertEqual(ISOCountry.GW, "GUINEA-BISSAU")
        self.assertEqual(str(ISOCountry.GW), "GW")
        self.assertEqual(ISOCountry.GW, "the Republic of Guinea-Bissau")
        self.assertEqual(ISOCountry.GW, "THE REPUBLIC OF GUINEA-BISSAU")

        self.assertEqual(ISOCountry.GY, 328)
        self.assertEqual(ISOCountry.GY.label, "Guyana")
        self.assertEqual(ISOCountry.GY.alpha2, "GY")
        self.assertEqual(ISOCountry.GY.short_name, "Guyana")
        self.assertEqual(ISOCountry.GY, ISOCountry("Guyana"))
        self.assertEqual(ISOCountry.GY, "GY")
        self.assertEqual(ISOCountry.GY, "GUY")
        self.assertEqual(ISOCountry.GY, "Guyana")
        self.assertEqual(ISOCountry.GY, "GUYANA")
        self.assertEqual(str(ISOCountry.GY), "GY")
        self.assertEqual(ISOCountry.GY, "the Co-operative Republic of Guyana")
        self.assertEqual(ISOCountry.GY, "THE CO-OPERATIVE REPUBLIC OF GUYANA")

        self.assertEqual(ISOCountry.HK, 344)
        self.assertEqual(ISOCountry.HK.label, "Hong Kong")
        self.assertEqual(ISOCountry.HK.alpha2, "HK")
        self.assertEqual(ISOCountry.HK.short_name, "Hong Kong")
        self.assertEqual(ISOCountry.HK, ISOCountry("Hong Kong"))
        self.assertEqual(ISOCountry.HK, "HK")
        self.assertEqual(ISOCountry.HK, "HKG")
        self.assertEqual(ISOCountry.HK, "Hong Kong")
        self.assertEqual(ISOCountry.HK, "HONG KONG")
        self.assertEqual(str(ISOCountry.HK), "HK")
        self.assertEqual(
            ISOCountry.HK, "the Hong Kong Special Administrative Region of China"
        )
        self.assertEqual(
            ISOCountry.HK, "THE HONG KONG SPECIAL ADMINISTRATIVE REGION OF CHINA"
        )

        self.assertEqual(ISOCountry.HM, 334)
        self.assertEqual(ISOCountry.HM.label, "Heard Island and McDonald Islands")
        self.assertEqual(ISOCountry.HM.alpha2, "HM")
        self.assertEqual(ISOCountry.HM.short_name, "Heard Island and McDonald Islands")
        self.assertEqual(ISOCountry.HM, ISOCountry("Heard Island and McDonald Islands"))
        self.assertEqual(ISOCountry.HM, "HM")
        self.assertEqual(ISOCountry.HM, "HMD")
        self.assertEqual(ISOCountry.HM, "Heard Island and McDonald Islands")
        self.assertEqual(ISOCountry.HM, "HEARD ISLAND AND MCDONALD ISLANDS")
        self.assertEqual(str(ISOCountry.HM), "HM")

        self.assertEqual(ISOCountry.HN, 340)
        self.assertEqual(ISOCountry.HN.label, "Honduras")
        self.assertEqual(ISOCountry.HN.alpha2, "HN")
        self.assertEqual(ISOCountry.HN.short_name, "Honduras")
        self.assertEqual(ISOCountry.HN, ISOCountry("Honduras"))
        self.assertEqual(ISOCountry.HN, "HN")
        self.assertEqual(ISOCountry.HN, "HND")
        self.assertEqual(ISOCountry.HN, "Honduras")
        self.assertEqual(ISOCountry.HN, "HONDURAS")
        self.assertEqual(str(ISOCountry.HN), "HN")
        self.assertEqual(ISOCountry.HN, "the Republic of Honduras")
        self.assertEqual(ISOCountry.HN, "THE REPUBLIC OF HONDURAS")

        self.assertEqual(ISOCountry.HR, 191)
        self.assertEqual(ISOCountry.HR.label, "Croatia")
        self.assertEqual(ISOCountry.HR.alpha2, "HR")
        self.assertEqual(ISOCountry.HR.short_name, "Croatia")
        self.assertEqual(ISOCountry.HR, ISOCountry("Croatia"))
        self.assertEqual(ISOCountry.HR, "HR")
        self.assertEqual(ISOCountry.HR, "HRV")
        self.assertEqual(ISOCountry.HR, "Croatia")
        self.assertEqual(ISOCountry.HR, "CROATIA")
        self.assertEqual(str(ISOCountry.HR), "HR")
        self.assertEqual(ISOCountry.HR, "the Republic of Croatia")
        self.assertEqual(ISOCountry.HR, "THE REPUBLIC OF CROATIA")

        self.assertEqual(ISOCountry.HT, 332)
        self.assertEqual(ISOCountry.HT.label, "Haiti")
        self.assertEqual(ISOCountry.HT.alpha2, "HT")
        self.assertEqual(ISOCountry.HT.short_name, "Haiti")
        self.assertEqual(ISOCountry.HT, ISOCountry("Haiti"))
        self.assertEqual(ISOCountry.HT, "HT")
        self.assertEqual(ISOCountry.HT, "HTI")
        self.assertEqual(ISOCountry.HT, "Haiti")
        self.assertEqual(ISOCountry.HT, "HAITI")
        self.assertEqual(str(ISOCountry.HT), "HT")
        self.assertEqual(ISOCountry.HT, "the Republic of Haiti")
        self.assertEqual(ISOCountry.HT, "THE REPUBLIC OF HAITI")

        self.assertEqual(ISOCountry.HU, 348)
        self.assertEqual(ISOCountry.HU.label, "Hungary")
        self.assertEqual(ISOCountry.HU.alpha2, "HU")
        self.assertEqual(ISOCountry.HU.short_name, "Hungary")
        self.assertEqual(ISOCountry.HU, ISOCountry("Hungary"))
        self.assertEqual(ISOCountry.HU, "HU")
        self.assertEqual(ISOCountry.HU, "HUN")
        self.assertEqual(ISOCountry.HU, "Hungary")
        self.assertEqual(ISOCountry.HU, "HUNGARY")
        self.assertEqual(str(ISOCountry.HU), "HU")

        self.assertEqual(ISOCountry.ID, 360)
        self.assertEqual(ISOCountry.ID.label, "Indonesia")
        self.assertEqual(ISOCountry.ID.alpha2, "ID")
        self.assertEqual(ISOCountry.ID.short_name, "Indonesia")
        self.assertEqual(ISOCountry.ID, ISOCountry("Indonesia"))
        self.assertEqual(ISOCountry.ID, "ID")
        self.assertEqual(ISOCountry.ID, "IDN")
        self.assertEqual(ISOCountry.ID, "Indonesia")
        self.assertEqual(ISOCountry.ID, "INDONESIA")
        self.assertEqual(str(ISOCountry.ID), "ID")
        self.assertEqual(ISOCountry.ID, "the Republic of Indonesia")
        self.assertEqual(ISOCountry.ID, "THE REPUBLIC OF INDONESIA")

        self.assertEqual(ISOCountry.IE, 372)
        self.assertEqual(ISOCountry.IE.label, "Ireland")
        self.assertEqual(ISOCountry.IE.alpha2, "IE")
        self.assertEqual(ISOCountry.IE.short_name, "Ireland")
        self.assertEqual(ISOCountry.IE, ISOCountry("Ireland"))
        self.assertEqual(ISOCountry.IE, "IE")
        self.assertEqual(ISOCountry.IE, "IRL")
        self.assertEqual(ISOCountry.IE, "Ireland")
        self.assertEqual(ISOCountry.IE, "IRELAND")
        self.assertEqual(str(ISOCountry.IE), "IE")

        self.assertEqual(ISOCountry.IL, 376)
        self.assertEqual(ISOCountry.IL.label, "Israel")
        self.assertEqual(ISOCountry.IL.alpha2, "IL")
        self.assertEqual(ISOCountry.IL.short_name, "Israel")
        self.assertEqual(ISOCountry.IL, ISOCountry("Israel"))
        self.assertEqual(ISOCountry.IL, "IL")
        self.assertEqual(ISOCountry.IL, "ISR")
        self.assertEqual(ISOCountry.IL, "Israel")
        self.assertEqual(ISOCountry.IL, "ISRAEL")
        self.assertEqual(str(ISOCountry.IL), "IL")
        self.assertEqual(ISOCountry.IL, "the State of Israel")
        self.assertEqual(ISOCountry.IL, "THE STATE OF ISRAEL")

        self.assertEqual(ISOCountry.IM, 833)
        self.assertEqual(ISOCountry.IM.label, "Isle of Man")
        self.assertEqual(ISOCountry.IM.alpha2, "IM")
        self.assertEqual(ISOCountry.IM.short_name, "Isle of Man")
        self.assertEqual(ISOCountry.IM, ISOCountry("Isle of Man"))
        self.assertEqual(ISOCountry.IM, "IM")
        self.assertEqual(ISOCountry.IM, "IMN")
        self.assertEqual(ISOCountry.IM, "Isle of Man")
        self.assertEqual(ISOCountry.IM, "ISLE OF MAN")
        self.assertEqual(str(ISOCountry.IM), "IM")

        self.assertEqual(ISOCountry.IN, 356)
        self.assertEqual(ISOCountry.IN.label, "India")
        self.assertEqual(ISOCountry.IN.alpha2, "IN")
        self.assertEqual(ISOCountry.IN.short_name, "India")
        self.assertEqual(ISOCountry.IN, ISOCountry("India"))
        self.assertEqual(ISOCountry.IN, "IN")
        self.assertEqual(ISOCountry.IN, "IND")
        self.assertEqual(ISOCountry.IN, "India")
        self.assertEqual(ISOCountry.IN, "INDIA")
        self.assertEqual(str(ISOCountry.IN), "IN")
        self.assertEqual(ISOCountry.IN, "the Republic of India")
        self.assertEqual(ISOCountry.IN, "THE REPUBLIC OF INDIA")

        self.assertEqual(ISOCountry.IO, 86)
        self.assertEqual(ISOCountry.IO.label, "British Indian Ocean Territory (the)")
        self.assertEqual(ISOCountry.IO.alpha2, "IO")
        self.assertEqual(
            ISOCountry.IO.short_name, "British Indian Ocean Territory (the)"
        )
        self.assertEqual(
            ISOCountry.IO, ISOCountry("British Indian Ocean Territory (the)")
        )
        self.assertEqual(ISOCountry.IO, "IO")
        self.assertEqual(ISOCountry.IO, "IOT")
        self.assertEqual(ISOCountry.IO, "British Indian Ocean Territory (the)")
        self.assertEqual(ISOCountry.IO, "BRITISH INDIAN OCEAN TERRITORY (THE)")
        self.assertEqual(str(ISOCountry.IO), "IO")

        self.assertEqual(ISOCountry.IQ, 368)
        self.assertEqual(ISOCountry.IQ.label, "Iraq")
        self.assertEqual(ISOCountry.IQ.alpha2, "IQ")
        self.assertEqual(ISOCountry.IQ.short_name, "Iraq")
        self.assertEqual(ISOCountry.IQ, ISOCountry("Iraq"))
        self.assertEqual(ISOCountry.IQ, "IQ")
        self.assertEqual(ISOCountry.IQ, "IRQ")
        self.assertEqual(ISOCountry.IQ, "Iraq")
        self.assertEqual(ISOCountry.IQ, "IRAQ")
        self.assertEqual(str(ISOCountry.IQ), "IQ")
        self.assertEqual(ISOCountry.IQ, "the Republic of Iraq")
        self.assertEqual(ISOCountry.IQ, "THE REPUBLIC OF IRAQ")

        self.assertEqual(ISOCountry.IR, 364)
        self.assertEqual(ISOCountry.IR.label, "Iran (Islamic Republic of)")
        self.assertEqual(ISOCountry.IR.alpha2, "IR")
        self.assertEqual(ISOCountry.IR.short_name, "Iran (Islamic Republic of)")
        self.assertEqual(ISOCountry.IR, ISOCountry("Iran (Islamic Republic of)"))
        self.assertEqual(ISOCountry.IR, "IR")
        self.assertEqual(ISOCountry.IR, "IRN")
        self.assertEqual(ISOCountry.IR, "Iran (Islamic Republic of)")
        self.assertEqual(ISOCountry.IR, "IRAN (ISLAMIC REPUBLIC OF)")
        self.assertEqual(str(ISOCountry.IR), "IR")
        self.assertEqual(ISOCountry.IR, "the Islamic Republic of Iran")
        self.assertEqual(ISOCountry.IR, "THE ISLAMIC REPUBLIC OF IRAN")

        self.assertEqual(ISOCountry.IS, 352)
        self.assertEqual(ISOCountry.IS.label, "Iceland")
        self.assertEqual(ISOCountry.IS.alpha2, "IS")
        self.assertEqual(ISOCountry.IS.short_name, "Iceland")
        self.assertEqual(ISOCountry.IS, ISOCountry("Iceland"))
        self.assertEqual(ISOCountry.IS, "IS")
        self.assertEqual(ISOCountry.IS, "ISL")
        self.assertEqual(ISOCountry.IS, "Iceland")
        self.assertEqual(ISOCountry.IS, "ICELAND")
        self.assertEqual(str(ISOCountry.IS), "IS")
        self.assertEqual(ISOCountry.IS, "the Republic of Iceland")
        self.assertEqual(ISOCountry.IS, "THE REPUBLIC OF ICELAND")

        self.assertEqual(ISOCountry.IT, 380)
        self.assertEqual(ISOCountry.IT.label, "Italy")
        self.assertEqual(ISOCountry.IT.alpha2, "IT")
        self.assertEqual(ISOCountry.IT.short_name, "Italy")
        self.assertEqual(ISOCountry.IT, ISOCountry("Italy"))
        self.assertEqual(ISOCountry.IT, "IT")
        self.assertEqual(ISOCountry.IT, "ITA")
        self.assertEqual(ISOCountry.IT, "Italy")
        self.assertEqual(ISOCountry.IT, "ITALY")
        self.assertEqual(str(ISOCountry.IT), "IT")
        self.assertEqual(ISOCountry.IT, "the Republic of Italy")
        self.assertEqual(ISOCountry.IT, "THE REPUBLIC OF ITALY")

        self.assertEqual(ISOCountry.JE, 832)
        self.assertEqual(ISOCountry.JE.label, "Jersey")
        self.assertEqual(ISOCountry.JE.alpha2, "JE")
        self.assertEqual(ISOCountry.JE.short_name, "Jersey")
        self.assertEqual(ISOCountry.JE, ISOCountry("Jersey"))
        self.assertEqual(ISOCountry.JE, "JE")
        self.assertEqual(ISOCountry.JE, "JEY")
        self.assertEqual(ISOCountry.JE, "Jersey")
        self.assertEqual(ISOCountry.JE, "JERSEY")
        self.assertEqual(str(ISOCountry.JE), "JE")

        self.assertEqual(ISOCountry.JM, 388)
        self.assertEqual(ISOCountry.JM.label, "Jamaica")
        self.assertEqual(ISOCountry.JM.alpha2, "JM")
        self.assertEqual(ISOCountry.JM.short_name, "Jamaica")
        self.assertEqual(ISOCountry.JM, ISOCountry("Jamaica"))
        self.assertEqual(ISOCountry.JM, "JM")
        self.assertEqual(ISOCountry.JM, "JAM")
        self.assertEqual(ISOCountry.JM, "Jamaica")
        self.assertEqual(ISOCountry.JM, "JAMAICA")
        self.assertEqual(str(ISOCountry.JM), "JM")

        self.assertEqual(ISOCountry.JO, 400)
        self.assertEqual(ISOCountry.JO.label, "Jordan")
        self.assertEqual(ISOCountry.JO.alpha2, "JO")
        self.assertEqual(ISOCountry.JO.short_name, "Jordan")
        self.assertEqual(ISOCountry.JO, ISOCountry("Jordan"))
        self.assertEqual(ISOCountry.JO, "JO")
        self.assertEqual(ISOCountry.JO, "JOR")
        self.assertEqual(ISOCountry.JO, "Jordan")
        self.assertEqual(ISOCountry.JO, "JORDAN")
        self.assertEqual(str(ISOCountry.JO), "JO")
        self.assertEqual(ISOCountry.JO, "the Hashemite Kingdom of Jordan")
        self.assertEqual(ISOCountry.JO, "THE HASHEMITE KINGDOM OF JORDAN")

        self.assertEqual(ISOCountry.JP, 392)
        self.assertEqual(ISOCountry.JP.label, "Japan")
        self.assertEqual(ISOCountry.JP.alpha2, "JP")
        self.assertEqual(ISOCountry.JP.short_name, "Japan")
        self.assertEqual(ISOCountry.JP, ISOCountry("Japan"))
        self.assertEqual(ISOCountry.JP, "JP")
        self.assertEqual(ISOCountry.JP, "JPN")
        self.assertEqual(ISOCountry.JP, "Japan")
        self.assertEqual(ISOCountry.JP, "JAPAN")
        self.assertEqual(str(ISOCountry.JP), "JP")

        self.assertEqual(ISOCountry.KE, 404)
        self.assertEqual(ISOCountry.KE.label, "Kenya")
        self.assertEqual(ISOCountry.KE.alpha2, "KE")
        self.assertEqual(ISOCountry.KE.short_name, "Kenya")
        self.assertEqual(ISOCountry.KE, ISOCountry("Kenya"))
        self.assertEqual(ISOCountry.KE, "KE")
        self.assertEqual(ISOCountry.KE, "KEN")
        self.assertEqual(ISOCountry.KE, "Kenya")
        self.assertEqual(ISOCountry.KE, "KENYA")
        self.assertEqual(str(ISOCountry.KE), "KE")
        self.assertEqual(ISOCountry.KE, "the Republic of Kenya")
        self.assertEqual(ISOCountry.KE, "THE REPUBLIC OF KENYA")

        self.assertEqual(ISOCountry.KG, 417)
        self.assertEqual(ISOCountry.KG.label, "Kyrgyzstan")
        self.assertEqual(ISOCountry.KG.alpha2, "KG")
        self.assertEqual(ISOCountry.KG.short_name, "Kyrgyzstan")
        self.assertEqual(ISOCountry.KG, ISOCountry("Kyrgyzstan"))
        self.assertEqual(ISOCountry.KG, "KG")
        self.assertEqual(ISOCountry.KG, "KGZ")
        self.assertEqual(ISOCountry.KG, "Kyrgyzstan")
        self.assertEqual(ISOCountry.KG, "KYRGYZSTAN")
        self.assertEqual(str(ISOCountry.KG), "KG")
        self.assertEqual(ISOCountry.KG, "the Kyrgyz Republic")
        self.assertEqual(ISOCountry.KG, "THE KYRGYZ REPUBLIC")

        self.assertEqual(ISOCountry.KH, 116)
        self.assertEqual(ISOCountry.KH.label, "Cambodia")
        self.assertEqual(ISOCountry.KH.alpha2, "KH")
        self.assertEqual(ISOCountry.KH.short_name, "Cambodia")
        self.assertEqual(ISOCountry.KH, ISOCountry("Cambodia"))
        self.assertEqual(ISOCountry.KH, "KH")
        self.assertEqual(ISOCountry.KH, "KHM")
        self.assertEqual(ISOCountry.KH, "Cambodia")
        self.assertEqual(ISOCountry.KH, "CAMBODIA")
        self.assertEqual(str(ISOCountry.KH), "KH")
        self.assertEqual(ISOCountry.KH, "the Kingdom of Cambodia")
        self.assertEqual(ISOCountry.KH, "THE KINGDOM OF CAMBODIA")

        self.assertEqual(ISOCountry.KI, 296)
        self.assertEqual(ISOCountry.KI.label, "Kiribati")
        self.assertEqual(ISOCountry.KI.alpha2, "KI")
        self.assertEqual(ISOCountry.KI.short_name, "Kiribati")
        self.assertEqual(ISOCountry.KI, ISOCountry("Kiribati"))
        self.assertEqual(ISOCountry.KI, "KI")
        self.assertEqual(ISOCountry.KI, "KIR")
        self.assertEqual(ISOCountry.KI, "Kiribati")
        self.assertEqual(ISOCountry.KI, "KIRIBATI")
        self.assertEqual(str(ISOCountry.KI), "KI")
        self.assertEqual(ISOCountry.KI, "the Republic of Kiribati")
        self.assertEqual(ISOCountry.KI, "THE REPUBLIC OF KIRIBATI")

        self.assertEqual(ISOCountry.KM, 174)
        self.assertEqual(ISOCountry.KM.label, "Comoros (the)")
        self.assertEqual(ISOCountry.KM.alpha2, "KM")
        self.assertEqual(ISOCountry.KM.short_name, "Comoros (the)")
        self.assertEqual(ISOCountry.KM, ISOCountry("Comoros (the)"))
        self.assertEqual(ISOCountry.KM, "KM")
        self.assertEqual(ISOCountry.KM, "COM")
        self.assertEqual(ISOCountry.KM, "Comoros (the)")
        self.assertEqual(ISOCountry.KM, "COMOROS (THE)")
        self.assertEqual(str(ISOCountry.KM), "KM")
        self.assertEqual(ISOCountry.KM, "the Union of the Comoros")
        self.assertEqual(ISOCountry.KM, "THE UNION OF THE COMOROS")

        self.assertEqual(ISOCountry.KN, 659)
        self.assertEqual(ISOCountry.KN.label, "Saint Kitts and Nevis")
        self.assertEqual(ISOCountry.KN.alpha2, "KN")
        self.assertEqual(ISOCountry.KN.short_name, "Saint Kitts and Nevis")
        self.assertEqual(ISOCountry.KN, ISOCountry("Saint Kitts and Nevis"))
        self.assertEqual(ISOCountry.KN, "KN")
        self.assertEqual(ISOCountry.KN, "KNA")
        self.assertEqual(ISOCountry.KN, "Saint Kitts and Nevis")
        self.assertEqual(ISOCountry.KN, "SAINT KITTS AND NEVIS")
        self.assertEqual(str(ISOCountry.KN), "KN")

        self.assertEqual(ISOCountry.KP, 408)
        self.assertEqual(
            ISOCountry.KP.label, "Korea (the Democratic People's Republic of)"
        )
        self.assertEqual(ISOCountry.KP.alpha2, "KP")
        self.assertEqual(
            ISOCountry.KP.short_name, "Korea (the Democratic People's Republic of)"
        )
        self.assertEqual(
            ISOCountry.KP, ISOCountry("Korea (the Democratic People's Republic of)")
        )
        self.assertEqual(ISOCountry.KP, "KP")
        self.assertEqual(ISOCountry.KP, "PRK")
        self.assertEqual(ISOCountry.KP, "Korea (the Democratic People's Republic of)")
        self.assertEqual(ISOCountry.KP, "KOREA (THE DEMOCRATIC PEOPLE'S REPUBLIC OF)")
        self.assertEqual(str(ISOCountry.KP), "KP")
        self.assertEqual(ISOCountry.KP, "the Democratic People's Republic of Korea")
        self.assertEqual(ISOCountry.KP, "THE DEMOCRATIC PEOPLE'S REPUBLIC OF KOREA")

        self.assertEqual(ISOCountry.KR, 410)
        self.assertEqual(ISOCountry.KR.label, "Korea (the Republic of)")
        self.assertEqual(ISOCountry.KR.alpha2, "KR")
        self.assertEqual(ISOCountry.KR.short_name, "Korea (the Republic of)")
        self.assertEqual(ISOCountry.KR, ISOCountry("Korea (the Republic of)"))
        self.assertEqual(ISOCountry.KR, "KR")
        self.assertEqual(ISOCountry.KR, "KOR")
        self.assertEqual(ISOCountry.KR, "Korea (the Republic of)")
        self.assertEqual(ISOCountry.KR, "KOREA (THE REPUBLIC OF)")
        self.assertEqual(str(ISOCountry.KR), "KR")
        self.assertEqual(ISOCountry.KR, "the Republic of Korea")
        self.assertEqual(ISOCountry.KR, "THE REPUBLIC OF KOREA")

        self.assertEqual(ISOCountry.KW, 414)
        self.assertEqual(ISOCountry.KW.label, "Kuwait")
        self.assertEqual(ISOCountry.KW.alpha2, "KW")
        self.assertEqual(ISOCountry.KW.short_name, "Kuwait")
        self.assertEqual(ISOCountry.KW, ISOCountry("Kuwait"))
        self.assertEqual(ISOCountry.KW, "KW")
        self.assertEqual(ISOCountry.KW, "KWT")
        self.assertEqual(ISOCountry.KW, "Kuwait")
        self.assertEqual(ISOCountry.KW, "KUWAIT")
        self.assertEqual(str(ISOCountry.KW), "KW")
        self.assertEqual(ISOCountry.KW, "the State of Kuwait")
        self.assertEqual(ISOCountry.KW, "THE STATE OF KUWAIT")

        self.assertEqual(ISOCountry.KY, 136)
        self.assertEqual(ISOCountry.KY.label, "Cayman Islands (the)")
        self.assertEqual(ISOCountry.KY.alpha2, "KY")
        self.assertEqual(ISOCountry.KY.short_name, "Cayman Islands (the)")
        self.assertEqual(ISOCountry.KY, ISOCountry("Cayman Islands (the)"))
        self.assertEqual(ISOCountry.KY, "KY")
        self.assertEqual(ISOCountry.KY, "CYM")
        self.assertEqual(ISOCountry.KY, "Cayman Islands (the)")
        self.assertEqual(ISOCountry.KY, "CAYMAN ISLANDS (THE)")
        self.assertEqual(str(ISOCountry.KY), "KY")

        self.assertEqual(ISOCountry.KZ, 398)
        self.assertEqual(ISOCountry.KZ.label, "Kazakhstan")
        self.assertEqual(ISOCountry.KZ.alpha2, "KZ")
        self.assertEqual(ISOCountry.KZ.short_name, "Kazakhstan")
        self.assertEqual(ISOCountry.KZ, ISOCountry("Kazakhstan"))
        self.assertEqual(ISOCountry.KZ, "KZ")
        self.assertEqual(ISOCountry.KZ, "KAZ")
        self.assertEqual(ISOCountry.KZ, "Kazakhstan")
        self.assertEqual(ISOCountry.KZ, "KAZAKHSTAN")
        self.assertEqual(str(ISOCountry.KZ), "KZ")
        self.assertEqual(ISOCountry.KZ, "the Republic of Kazakhstan")
        self.assertEqual(ISOCountry.KZ, "THE REPUBLIC OF KAZAKHSTAN")

        self.assertEqual(ISOCountry.LA, 418)
        self.assertEqual(ISOCountry.LA.label, "Lao People's Democratic Republic (the)")
        self.assertEqual(ISOCountry.LA.alpha2, "LA")
        self.assertEqual(
            ISOCountry.LA.short_name, "Lao People's Democratic Republic (the)"
        )
        self.assertEqual(
            ISOCountry.LA, ISOCountry("Lao People's Democratic Republic (the)")
        )
        self.assertEqual(ISOCountry.LA, "LA")
        self.assertEqual(ISOCountry.LA, "LAO")
        self.assertEqual(ISOCountry.LA, "Lao People's Democratic Republic (the)")
        self.assertEqual(ISOCountry.LA, "LAO PEOPLE'S DEMOCRATIC REPUBLIC (THE)")
        self.assertEqual(str(ISOCountry.LA), "LA")
        self.assertEqual(ISOCountry.LA, "the Lao People's Democratic Republic")
        self.assertEqual(ISOCountry.LA, "THE LAO PEOPLE'S DEMOCRATIC REPUBLIC")

        self.assertEqual(ISOCountry.LB, 422)
        self.assertEqual(ISOCountry.LB.label, "Lebanon")
        self.assertEqual(ISOCountry.LB.alpha2, "LB")
        self.assertEqual(ISOCountry.LB.short_name, "Lebanon")
        self.assertEqual(ISOCountry.LB, ISOCountry("Lebanon"))
        self.assertEqual(ISOCountry.LB, "LB")
        self.assertEqual(ISOCountry.LB, "LBN")
        self.assertEqual(ISOCountry.LB, "Lebanon")
        self.assertEqual(ISOCountry.LB, "LEBANON")
        self.assertEqual(str(ISOCountry.LB), "LB")
        self.assertEqual(ISOCountry.LB, "the Lebanese Republic")
        self.assertEqual(ISOCountry.LB, "THE LEBANESE REPUBLIC")

        self.assertEqual(ISOCountry.LC, 662)
        self.assertEqual(ISOCountry.LC.label, "Saint Lucia")
        self.assertEqual(ISOCountry.LC.alpha2, "LC")
        self.assertEqual(ISOCountry.LC.short_name, "Saint Lucia")
        self.assertEqual(ISOCountry.LC, ISOCountry("Saint Lucia"))
        self.assertEqual(ISOCountry.LC, "LC")
        self.assertEqual(ISOCountry.LC, "LCA")
        self.assertEqual(ISOCountry.LC, "Saint Lucia")
        self.assertEqual(ISOCountry.LC, "SAINT LUCIA")
        self.assertEqual(str(ISOCountry.LC), "LC")

        self.assertEqual(ISOCountry.LI, 438)
        self.assertEqual(ISOCountry.LI.label, "Liechtenstein")
        self.assertEqual(ISOCountry.LI.alpha2, "LI")
        self.assertEqual(ISOCountry.LI.short_name, "Liechtenstein")
        self.assertEqual(ISOCountry.LI, ISOCountry("Liechtenstein"))
        self.assertEqual(ISOCountry.LI, "LI")
        self.assertEqual(ISOCountry.LI, "LIE")
        self.assertEqual(ISOCountry.LI, "Liechtenstein")
        self.assertEqual(ISOCountry.LI, "LIECHTENSTEIN")
        self.assertEqual(str(ISOCountry.LI), "LI")
        self.assertEqual(ISOCountry.LI, "the Principality of Liechtenstein")
        self.assertEqual(ISOCountry.LI, "THE PRINCIPALITY OF LIECHTENSTEIN")

        self.assertEqual(ISOCountry.LK, 144)
        self.assertEqual(ISOCountry.LK.label, "Sri Lanka")
        self.assertEqual(ISOCountry.LK.alpha2, "LK")
        self.assertEqual(ISOCountry.LK.short_name, "Sri Lanka")
        self.assertEqual(ISOCountry.LK, ISOCountry("Sri Lanka"))
        self.assertEqual(ISOCountry.LK, "LK")
        self.assertEqual(ISOCountry.LK, "LKA")
        self.assertEqual(ISOCountry.LK, "Sri Lanka")
        self.assertEqual(ISOCountry.LK, "SRI LANKA")
        self.assertEqual(str(ISOCountry.LK), "LK")
        self.assertEqual(
            ISOCountry.LK, "the Democratic Socialist Republic of Sri Lanka"
        )
        self.assertEqual(
            ISOCountry.LK, "THE DEMOCRATIC SOCIALIST REPUBLIC OF SRI LANKA"
        )

        self.assertEqual(ISOCountry.LR, 430)
        self.assertEqual(ISOCountry.LR.label, "Liberia")
        self.assertEqual(ISOCountry.LR.alpha2, "LR")
        self.assertEqual(ISOCountry.LR.short_name, "Liberia")
        self.assertEqual(ISOCountry.LR, ISOCountry("Liberia"))
        self.assertEqual(ISOCountry.LR, "LR")
        self.assertEqual(ISOCountry.LR, "LBR")
        self.assertEqual(ISOCountry.LR, "Liberia")
        self.assertEqual(ISOCountry.LR, "LIBERIA")
        self.assertEqual(str(ISOCountry.LR), "LR")
        self.assertEqual(ISOCountry.LR, "the Republic of Liberia")
        self.assertEqual(ISOCountry.LR, "THE REPUBLIC OF LIBERIA")

        self.assertEqual(ISOCountry.LS, 426)
        self.assertEqual(ISOCountry.LS.label, "Lesotho")
        self.assertEqual(ISOCountry.LS.alpha2, "LS")
        self.assertEqual(ISOCountry.LS.short_name, "Lesotho")
        self.assertEqual(ISOCountry.LS, ISOCountry("Lesotho"))
        self.assertEqual(ISOCountry.LS, "LS")
        self.assertEqual(ISOCountry.LS, "LSO")
        self.assertEqual(ISOCountry.LS, "Lesotho")
        self.assertEqual(ISOCountry.LS, "LESOTHO")
        self.assertEqual(str(ISOCountry.LS), "LS")
        self.assertEqual(ISOCountry.LS, "the Kingdom of Lesotho")
        self.assertEqual(ISOCountry.LS, "THE KINGDOM OF LESOTHO")

        self.assertEqual(ISOCountry.LT, 440)
        self.assertEqual(ISOCountry.LT.label, "Lithuania")
        self.assertEqual(ISOCountry.LT.alpha2, "LT")
        self.assertEqual(ISOCountry.LT.short_name, "Lithuania")
        self.assertEqual(ISOCountry.LT, ISOCountry("Lithuania"))
        self.assertEqual(ISOCountry.LT, "LT")
        self.assertEqual(ISOCountry.LT, "LTU")
        self.assertEqual(ISOCountry.LT, "Lithuania")
        self.assertEqual(ISOCountry.LT, "LITHUANIA")
        self.assertEqual(str(ISOCountry.LT), "LT")
        self.assertEqual(ISOCountry.LT, "the Republic of Lithuania")
        self.assertEqual(ISOCountry.LT, "THE REPUBLIC OF LITHUANIA")

        self.assertEqual(ISOCountry.LU, 442)
        self.assertEqual(ISOCountry.LU.label, "Luxembourg")
        self.assertEqual(ISOCountry.LU.alpha2, "LU")
        self.assertEqual(ISOCountry.LU.short_name, "Luxembourg")
        self.assertEqual(ISOCountry.LU, ISOCountry("Luxembourg"))
        self.assertEqual(ISOCountry.LU, "LU")
        self.assertEqual(ISOCountry.LU, "LUX")
        self.assertEqual(ISOCountry.LU, "Luxembourg")
        self.assertEqual(ISOCountry.LU, "LUXEMBOURG")
        self.assertEqual(str(ISOCountry.LU), "LU")
        self.assertEqual(ISOCountry.LU, "the Grand Duchy of Luxembourg")
        self.assertEqual(ISOCountry.LU, "THE GRAND DUCHY OF LUXEMBOURG")

        self.assertEqual(ISOCountry.LV, 428)
        self.assertEqual(ISOCountry.LV.label, "Latvia")
        self.assertEqual(ISOCountry.LV.alpha2, "LV")
        self.assertEqual(ISOCountry.LV.short_name, "Latvia")
        self.assertEqual(ISOCountry.LV, ISOCountry("Latvia"))
        self.assertEqual(ISOCountry.LV, "LV")
        self.assertEqual(ISOCountry.LV, "LVA")
        self.assertEqual(ISOCountry.LV, "Latvia")
        self.assertEqual(ISOCountry.LV, "LATVIA")
        self.assertEqual(str(ISOCountry.LV), "LV")
        self.assertEqual(ISOCountry.LV, "the Republic of Latvia")
        self.assertEqual(ISOCountry.LV, "THE REPUBLIC OF LATVIA")

        self.assertEqual(ISOCountry.LY, 434)
        self.assertEqual(ISOCountry.LY.label, "Libya")
        self.assertEqual(ISOCountry.LY.alpha2, "LY")
        self.assertEqual(ISOCountry.LY.short_name, "Libya")
        self.assertEqual(ISOCountry.LY, ISOCountry("Libya"))
        self.assertEqual(ISOCountry.LY, "LY")
        self.assertEqual(ISOCountry.LY, "LBY")
        self.assertEqual(ISOCountry.LY, "Libya")
        self.assertEqual(ISOCountry.LY, "LIBYA")
        self.assertEqual(str(ISOCountry.LY), "LY")
        self.assertEqual(ISOCountry.LY, "the State of Libya")
        self.assertEqual(ISOCountry.LY, "THE STATE OF LIBYA")

        self.assertEqual(ISOCountry.MA, 504)
        self.assertEqual(ISOCountry.MA.label, "Morocco")
        self.assertEqual(ISOCountry.MA.alpha2, "MA")
        self.assertEqual(ISOCountry.MA.short_name, "Morocco")
        self.assertEqual(ISOCountry.MA, ISOCountry("Morocco"))
        self.assertEqual(ISOCountry.MA, "MA")
        self.assertEqual(ISOCountry.MA, "MAR")
        self.assertEqual(ISOCountry.MA, "Morocco")
        self.assertEqual(ISOCountry.MA, "MOROCCO")
        self.assertEqual(str(ISOCountry.MA), "MA")
        self.assertEqual(ISOCountry.MA, "the Kingdom of Morocco")
        self.assertEqual(ISOCountry.MA, "THE KINGDOM OF MOROCCO")

        self.assertEqual(ISOCountry.MC, 492)
        self.assertEqual(ISOCountry.MC.label, "Monaco")
        self.assertEqual(ISOCountry.MC.alpha2, "MC")
        self.assertEqual(ISOCountry.MC.short_name, "Monaco")
        self.assertEqual(ISOCountry.MC, ISOCountry("Monaco"))
        self.assertEqual(ISOCountry.MC, "MC")
        self.assertEqual(ISOCountry.MC, "MCO")
        self.assertEqual(ISOCountry.MC, "Monaco")
        self.assertEqual(ISOCountry.MC, "MONACO")
        self.assertEqual(str(ISOCountry.MC), "MC")
        self.assertEqual(ISOCountry.MC, "the Principality of Monaco")
        self.assertEqual(ISOCountry.MC, "THE PRINCIPALITY OF MONACO")

        self.assertEqual(ISOCountry.MD, 498)
        self.assertEqual(ISOCountry.MD.label, "Moldova (the Republic of)")
        self.assertEqual(ISOCountry.MD.alpha2, "MD")
        self.assertEqual(ISOCountry.MD.short_name, "Moldova (the Republic of)")
        self.assertEqual(ISOCountry.MD, ISOCountry("Moldova (the Republic of)"))
        self.assertEqual(ISOCountry.MD, "MD")
        self.assertEqual(ISOCountry.MD, "MDA")
        self.assertEqual(ISOCountry.MD, "Moldova (the Republic of)")
        self.assertEqual(ISOCountry.MD, "MOLDOVA (THE REPUBLIC OF)")
        self.assertEqual(str(ISOCountry.MD), "MD")
        self.assertEqual(ISOCountry.MD, "the Republic of Moldova")
        self.assertEqual(ISOCountry.MD, "THE REPUBLIC OF MOLDOVA")

        self.assertEqual(ISOCountry.ME, 499)
        self.assertEqual(ISOCountry.ME.label, "Montenegro")
        self.assertEqual(ISOCountry.ME.alpha2, "ME")
        self.assertEqual(ISOCountry.ME.short_name, "Montenegro")
        self.assertEqual(ISOCountry.ME, ISOCountry("Montenegro"))
        self.assertEqual(ISOCountry.ME, "ME")
        self.assertEqual(ISOCountry.ME, "MNE")
        self.assertEqual(ISOCountry.ME, "Montenegro")
        self.assertEqual(ISOCountry.ME, "MONTENEGRO")
        self.assertEqual(str(ISOCountry.ME), "ME")

        self.assertEqual(ISOCountry.MF, 663)
        self.assertEqual(ISOCountry.MF.label, "Saint Martin (French part)")
        self.assertEqual(ISOCountry.MF.alpha2, "MF")
        self.assertEqual(ISOCountry.MF.short_name, "Saint Martin (French part)")
        self.assertEqual(ISOCountry.MF, ISOCountry("Saint Martin (French part)"))
        self.assertEqual(ISOCountry.MF, "MF")
        self.assertEqual(ISOCountry.MF, "MAF")
        self.assertEqual(ISOCountry.MF, "Saint Martin (French part)")
        self.assertEqual(ISOCountry.MF, "SAINT MARTIN (FRENCH PART)")
        self.assertEqual(str(ISOCountry.MF), "MF")

        self.assertEqual(ISOCountry.MG, 450)
        self.assertEqual(ISOCountry.MG.label, "Madagascar")
        self.assertEqual(ISOCountry.MG.alpha2, "MG")
        self.assertEqual(ISOCountry.MG.short_name, "Madagascar")
        self.assertEqual(ISOCountry.MG, ISOCountry("Madagascar"))
        self.assertEqual(ISOCountry.MG, "MG")
        self.assertEqual(ISOCountry.MG, "MDG")
        self.assertEqual(ISOCountry.MG, "Madagascar")
        self.assertEqual(ISOCountry.MG, "MADAGASCAR")
        self.assertEqual(str(ISOCountry.MG), "MG")
        self.assertEqual(ISOCountry.MG, "the Republic of Madagascar")
        self.assertEqual(ISOCountry.MG, "THE REPUBLIC OF MADAGASCAR")

        self.assertEqual(ISOCountry.MH, 584)
        self.assertEqual(ISOCountry.MH.label, "Marshall Islands (the)")
        self.assertEqual(ISOCountry.MH.alpha2, "MH")
        self.assertEqual(ISOCountry.MH.short_name, "Marshall Islands (the)")
        self.assertEqual(ISOCountry.MH, ISOCountry("Marshall Islands (the)"))
        self.assertEqual(ISOCountry.MH, "MH")
        self.assertEqual(ISOCountry.MH, "MHL")
        self.assertEqual(ISOCountry.MH, "Marshall Islands (the)")
        self.assertEqual(ISOCountry.MH, "MARSHALL ISLANDS (THE)")
        self.assertEqual(str(ISOCountry.MH), "MH")
        self.assertEqual(ISOCountry.MH, "the Republic of the Marshall Islands")
        self.assertEqual(ISOCountry.MH, "THE REPUBLIC OF THE MARSHALL ISLANDS")

        self.assertEqual(ISOCountry.MK, 807)
        self.assertEqual(ISOCountry.MK.label, "North Macedonia")
        self.assertEqual(ISOCountry.MK.alpha2, "MK")
        self.assertEqual(ISOCountry.MK.short_name, "North Macedonia")
        self.assertEqual(ISOCountry.MK, ISOCountry("North Macedonia"))
        self.assertEqual(ISOCountry.MK, "MK")
        self.assertEqual(ISOCountry.MK, "MKD")
        self.assertEqual(ISOCountry.MK, "North Macedonia")
        self.assertEqual(ISOCountry.MK, "NORTH MACEDONIA")
        self.assertEqual(str(ISOCountry.MK), "MK")
        self.assertEqual(ISOCountry.MK, "the Republic of North Macedonia")
        self.assertEqual(ISOCountry.MK, "THE REPUBLIC OF NORTH MACEDONIA")

        self.assertEqual(ISOCountry.ML, 466)
        self.assertEqual(ISOCountry.ML.label, "Mali")
        self.assertEqual(ISOCountry.ML.alpha2, "ML")
        self.assertEqual(ISOCountry.ML.short_name, "Mali")
        self.assertEqual(ISOCountry.ML, ISOCountry("Mali"))
        self.assertEqual(ISOCountry.ML, "ML")
        self.assertEqual(ISOCountry.ML, "MLI")
        self.assertEqual(ISOCountry.ML, "Mali")
        self.assertEqual(ISOCountry.ML, "MALI")
        self.assertEqual(str(ISOCountry.ML), "ML")
        self.assertEqual(ISOCountry.ML, "the Republic of Mali")
        self.assertEqual(ISOCountry.ML, "THE REPUBLIC OF MALI")

        self.assertEqual(ISOCountry.MM, 104)
        self.assertEqual(ISOCountry.MM.label, "Myanmar")
        self.assertEqual(ISOCountry.MM.alpha2, "MM")
        self.assertEqual(ISOCountry.MM.short_name, "Myanmar")
        self.assertEqual(ISOCountry.MM, ISOCountry("Myanmar"))
        self.assertEqual(ISOCountry.MM, "MM")
        self.assertEqual(ISOCountry.MM, "MMR")
        self.assertEqual(ISOCountry.MM, "Myanmar")
        self.assertEqual(ISOCountry.MM, "MYANMAR")
        self.assertEqual(str(ISOCountry.MM), "MM")
        self.assertEqual(ISOCountry.MM, "the Republic of the Union of Myanmar")
        self.assertEqual(ISOCountry.MM, "THE REPUBLIC OF THE UNION OF MYANMAR")

        self.assertEqual(ISOCountry.MN, 496)
        self.assertEqual(ISOCountry.MN.label, "Mongolia")
        self.assertEqual(ISOCountry.MN.alpha2, "MN")
        self.assertEqual(ISOCountry.MN.short_name, "Mongolia")
        self.assertEqual(ISOCountry.MN, ISOCountry("Mongolia"))
        self.assertEqual(ISOCountry.MN, "MN")
        self.assertEqual(ISOCountry.MN, "MNG")
        self.assertEqual(ISOCountry.MN, "Mongolia")
        self.assertEqual(ISOCountry.MN, "MONGOLIA")
        self.assertEqual(str(ISOCountry.MN), "MN")

        self.assertEqual(ISOCountry.MO, 446)
        self.assertEqual(ISOCountry.MO.label, "Macao")
        self.assertEqual(ISOCountry.MO.alpha2, "MO")
        self.assertEqual(ISOCountry.MO.short_name, "Macao")
        self.assertEqual(ISOCountry.MO, ISOCountry("Macao"))
        self.assertEqual(ISOCountry.MO, "MO")
        self.assertEqual(ISOCountry.MO, "MAC")
        self.assertEqual(ISOCountry.MO, "Macao")
        self.assertEqual(ISOCountry.MO, "MACAO")
        self.assertEqual(str(ISOCountry.MO), "MO")
        self.assertEqual(ISOCountry.MO, "Macao Special Administrative Region of China")
        self.assertEqual(ISOCountry.MO, "MACAO SPECIAL ADMINISTRATIVE REGION OF CHINA")

        self.assertEqual(ISOCountry.MP, 580)
        self.assertEqual(ISOCountry.MP.label, "Northern Mariana Islands (the)")
        self.assertEqual(ISOCountry.MP.alpha2, "MP")
        self.assertEqual(ISOCountry.MP.short_name, "Northern Mariana Islands (the)")
        self.assertEqual(ISOCountry.MP, ISOCountry("Northern Mariana Islands (the)"))
        self.assertEqual(ISOCountry.MP, "MP")
        self.assertEqual(ISOCountry.MP, "MNP")
        self.assertEqual(ISOCountry.MP, "Northern Mariana Islands (the)")
        self.assertEqual(ISOCountry.MP, "NORTHERN MARIANA ISLANDS (THE)")
        self.assertEqual(str(ISOCountry.MP), "MP")
        self.assertEqual(
            ISOCountry.MP, "the Commonwealth of the Northern Mariana Islands"
        )
        self.assertEqual(
            ISOCountry.MP, "THE COMMONWEALTH OF THE NORTHERN MARIANA ISLANDS"
        )

        self.assertEqual(ISOCountry.MQ, 474)
        self.assertEqual(ISOCountry.MQ.label, "Martinique")
        self.assertEqual(ISOCountry.MQ.alpha2, "MQ")
        self.assertEqual(ISOCountry.MQ.short_name, "Martinique")
        self.assertEqual(ISOCountry.MQ, ISOCountry("Martinique"))
        self.assertEqual(ISOCountry.MQ, "MQ")
        self.assertEqual(ISOCountry.MQ, "MTQ")
        self.assertEqual(ISOCountry.MQ, "Martinique")
        self.assertEqual(ISOCountry.MQ, "MARTINIQUE")
        self.assertEqual(str(ISOCountry.MQ), "MQ")

        self.assertEqual(ISOCountry.MR, 478)
        self.assertEqual(ISOCountry.MR.label, "Mauritania")
        self.assertEqual(ISOCountry.MR.alpha2, "MR")
        self.assertEqual(ISOCountry.MR.short_name, "Mauritania")
        self.assertEqual(ISOCountry.MR, ISOCountry("Mauritania"))
        self.assertEqual(ISOCountry.MR, "MR")
        self.assertEqual(ISOCountry.MR, "MRT")
        self.assertEqual(ISOCountry.MR, "Mauritania")
        self.assertEqual(ISOCountry.MR, "MAURITANIA")
        self.assertEqual(str(ISOCountry.MR), "MR")
        self.assertEqual(ISOCountry.MR, "the Islamic Republic of Mauritania")
        self.assertEqual(ISOCountry.MR, "THE ISLAMIC REPUBLIC OF MAURITANIA")

        self.assertEqual(ISOCountry.MS, 500)
        self.assertEqual(ISOCountry.MS.label, "Montserrat")
        self.assertEqual(ISOCountry.MS.alpha2, "MS")
        self.assertEqual(ISOCountry.MS.short_name, "Montserrat")
        self.assertEqual(ISOCountry.MS, ISOCountry("Montserrat"))
        self.assertEqual(ISOCountry.MS, "MS")
        self.assertEqual(ISOCountry.MS, "MSR")
        self.assertEqual(ISOCountry.MS, "Montserrat")
        self.assertEqual(ISOCountry.MS, "MONTSERRAT")
        self.assertEqual(str(ISOCountry.MS), "MS")

        self.assertEqual(ISOCountry.MT, 470)
        self.assertEqual(ISOCountry.MT.label, "Malta")
        self.assertEqual(ISOCountry.MT.alpha2, "MT")
        self.assertEqual(ISOCountry.MT.short_name, "Malta")
        self.assertEqual(ISOCountry.MT, ISOCountry("Malta"))
        self.assertEqual(ISOCountry.MT, "MT")
        self.assertEqual(ISOCountry.MT, "MLT")
        self.assertEqual(ISOCountry.MT, "Malta")
        self.assertEqual(ISOCountry.MT, "MALTA")
        self.assertEqual(str(ISOCountry.MT), "MT")
        self.assertEqual(ISOCountry.MT, "the Republic of Malta")
        self.assertEqual(ISOCountry.MT, "THE REPUBLIC OF MALTA")

        self.assertEqual(ISOCountry.MU, 480)
        self.assertEqual(ISOCountry.MU.label, "Mauritius")
        self.assertEqual(ISOCountry.MU.alpha2, "MU")
        self.assertEqual(ISOCountry.MU.short_name, "Mauritius")
        self.assertEqual(ISOCountry.MU, ISOCountry("Mauritius"))
        self.assertEqual(ISOCountry.MU, "MU")
        self.assertEqual(ISOCountry.MU, "MUS")
        self.assertEqual(ISOCountry.MU, "Mauritius")
        self.assertEqual(ISOCountry.MU, "MAURITIUS")
        self.assertEqual(str(ISOCountry.MU), "MU")
        self.assertEqual(ISOCountry.MU, "the Republic of Mauritius")
        self.assertEqual(ISOCountry.MU, "THE REPUBLIC OF MAURITIUS")

        self.assertEqual(ISOCountry.MV, 462)
        self.assertEqual(ISOCountry.MV.label, "Maldives")
        self.assertEqual(ISOCountry.MV.alpha2, "MV")
        self.assertEqual(ISOCountry.MV.short_name, "Maldives")
        self.assertEqual(ISOCountry.MV, ISOCountry("Maldives"))
        self.assertEqual(ISOCountry.MV, "MV")
        self.assertEqual(ISOCountry.MV, "MDV")
        self.assertEqual(ISOCountry.MV, "Maldives")
        self.assertEqual(ISOCountry.MV, "MALDIVES")
        self.assertEqual(str(ISOCountry.MV), "MV")
        self.assertEqual(ISOCountry.MV, "the Republic of Maldives")
        self.assertEqual(ISOCountry.MV, "THE REPUBLIC OF MALDIVES")

        self.assertEqual(ISOCountry.MW, 454)
        self.assertEqual(ISOCountry.MW.label, "Malawi")
        self.assertEqual(ISOCountry.MW.alpha2, "MW")
        self.assertEqual(ISOCountry.MW.short_name, "Malawi")
        self.assertEqual(ISOCountry.MW, ISOCountry("Malawi"))
        self.assertEqual(ISOCountry.MW, "MW")
        self.assertEqual(ISOCountry.MW, "MWI")
        self.assertEqual(ISOCountry.MW, "Malawi")
        self.assertEqual(ISOCountry.MW, "MALAWI")
        self.assertEqual(str(ISOCountry.MW), "MW")
        self.assertEqual(ISOCountry.MW, "the Republic of Malawi")
        self.assertEqual(ISOCountry.MW, "THE REPUBLIC OF MALAWI")

        self.assertEqual(ISOCountry.MX, 484)
        self.assertEqual(ISOCountry.MX.label, "Mexico")
        self.assertEqual(ISOCountry.MX.alpha2, "MX")
        self.assertEqual(ISOCountry.MX.short_name, "Mexico")
        self.assertEqual(ISOCountry.MX, ISOCountry("Mexico"))
        self.assertEqual(ISOCountry.MX, "MX")
        self.assertEqual(ISOCountry.MX, "MEX")
        self.assertEqual(ISOCountry.MX, "Mexico")
        self.assertEqual(ISOCountry.MX, "MEXICO")
        self.assertEqual(str(ISOCountry.MX), "MX")
        self.assertEqual(ISOCountry.MX, "the United Mexican States")
        self.assertEqual(ISOCountry.MX, "THE UNITED MEXICAN STATES")

        self.assertEqual(ISOCountry.MY, 458)
        self.assertEqual(ISOCountry.MY.label, "Malaysia")
        self.assertEqual(ISOCountry.MY.alpha2, "MY")
        self.assertEqual(ISOCountry.MY.short_name, "Malaysia")
        self.assertEqual(ISOCountry.MY, ISOCountry("Malaysia"))
        self.assertEqual(ISOCountry.MY, "MY")
        self.assertEqual(ISOCountry.MY, "MYS")
        self.assertEqual(ISOCountry.MY, "Malaysia")
        self.assertEqual(ISOCountry.MY, "MALAYSIA")
        self.assertEqual(str(ISOCountry.MY), "MY")

        self.assertEqual(ISOCountry.MZ, 508)
        self.assertEqual(ISOCountry.MZ.label, "Mozambique")
        self.assertEqual(ISOCountry.MZ.alpha2, "MZ")
        self.assertEqual(ISOCountry.MZ.short_name, "Mozambique")
        self.assertEqual(ISOCountry.MZ, ISOCountry("Mozambique"))
        self.assertEqual(ISOCountry.MZ, "MZ")
        self.assertEqual(ISOCountry.MZ, "MOZ")
        self.assertEqual(ISOCountry.MZ, "Mozambique")
        self.assertEqual(ISOCountry.MZ, "MOZAMBIQUE")
        self.assertEqual(str(ISOCountry.MZ), "MZ")
        self.assertEqual(ISOCountry.MZ, "the Republic of Mozambique")
        self.assertEqual(ISOCountry.MZ, "THE REPUBLIC OF MOZAMBIQUE")

        self.assertEqual(ISOCountry.NA, 516)
        self.assertEqual(ISOCountry.NA.label, "Namibia")
        self.assertEqual(ISOCountry.NA.alpha2, "NA")
        self.assertEqual(ISOCountry.NA.short_name, "Namibia")
        self.assertEqual(ISOCountry.NA, ISOCountry("Namibia"))
        self.assertEqual(ISOCountry.NA, "NA")
        self.assertEqual(ISOCountry.NA, "NAM")
        self.assertEqual(ISOCountry.NA, "Namibia")
        self.assertEqual(ISOCountry.NA, "NAMIBIA")
        self.assertEqual(str(ISOCountry.NA), "NA")
        self.assertEqual(ISOCountry.NA, "the Republic of Namibia")
        self.assertEqual(ISOCountry.NA, "THE REPUBLIC OF NAMIBIA")

        self.assertEqual(ISOCountry.NC, 540)
        self.assertEqual(ISOCountry.NC.label, "New Caledonia")
        self.assertEqual(ISOCountry.NC.alpha2, "NC")
        self.assertEqual(ISOCountry.NC.short_name, "New Caledonia")
        self.assertEqual(ISOCountry.NC, ISOCountry("New Caledonia"))
        self.assertEqual(ISOCountry.NC, "NC")
        self.assertEqual(ISOCountry.NC, "NCL")
        self.assertEqual(ISOCountry.NC, "New Caledonia")
        self.assertEqual(ISOCountry.NC, "NEW CALEDONIA")
        self.assertEqual(str(ISOCountry.NC), "NC")

        self.assertEqual(ISOCountry.NE, 562)
        self.assertEqual(ISOCountry.NE.label, "Niger (the)")
        self.assertEqual(ISOCountry.NE.alpha2, "NE")
        self.assertEqual(ISOCountry.NE.short_name, "Niger (the)")
        self.assertEqual(ISOCountry.NE, ISOCountry("Niger (the)"))
        self.assertEqual(ISOCountry.NE, "NE")
        self.assertEqual(ISOCountry.NE, "NER")
        self.assertEqual(ISOCountry.NE, "Niger (the)")
        self.assertEqual(ISOCountry.NE, "NIGER (THE)")
        self.assertEqual(str(ISOCountry.NE), "NE")
        self.assertEqual(ISOCountry.NE, "the Republic of the Niger")
        self.assertEqual(ISOCountry.NE, "THE REPUBLIC OF THE NIGER")

        self.assertEqual(ISOCountry.NF, 574)
        self.assertEqual(ISOCountry.NF.label, "Norfolk Island")
        self.assertEqual(ISOCountry.NF.alpha2, "NF")
        self.assertEqual(ISOCountry.NF.short_name, "Norfolk Island")
        self.assertEqual(ISOCountry.NF, ISOCountry("Norfolk Island"))
        self.assertEqual(ISOCountry.NF, "NF")
        self.assertEqual(ISOCountry.NF, "NFK")
        self.assertEqual(ISOCountry.NF, "Norfolk Island")
        self.assertEqual(ISOCountry.NF, "NORFOLK ISLAND")
        self.assertEqual(str(ISOCountry.NF), "NF")

        self.assertEqual(ISOCountry.NG, 566)
        self.assertEqual(ISOCountry.NG.label, "Nigeria")
        self.assertEqual(ISOCountry.NG.alpha2, "NG")
        self.assertEqual(ISOCountry.NG.short_name, "Nigeria")
        self.assertEqual(ISOCountry.NG, ISOCountry("Nigeria"))
        self.assertEqual(ISOCountry.NG, "NG")
        self.assertEqual(ISOCountry.NG, "NGA")
        self.assertEqual(ISOCountry.NG, "Nigeria")
        self.assertEqual(ISOCountry.NG, "NIGERIA")
        self.assertEqual(str(ISOCountry.NG), "NG")
        self.assertEqual(ISOCountry.NG, "the Federal Republic of Nigeria")
        self.assertEqual(ISOCountry.NG, "THE FEDERAL REPUBLIC OF NIGERIA")

        self.assertEqual(ISOCountry.NI, 558)
        self.assertEqual(ISOCountry.NI.label, "Nicaragua")
        self.assertEqual(ISOCountry.NI.alpha2, "NI")
        self.assertEqual(ISOCountry.NI.short_name, "Nicaragua")
        self.assertEqual(ISOCountry.NI, ISOCountry("Nicaragua"))
        self.assertEqual(ISOCountry.NI, "NI")
        self.assertEqual(ISOCountry.NI, "NIC")
        self.assertEqual(ISOCountry.NI, "Nicaragua")
        self.assertEqual(ISOCountry.NI, "NICARAGUA")
        self.assertEqual(str(ISOCountry.NI), "NI")
        self.assertEqual(ISOCountry.NI, "the Republic of Nicaragua")
        self.assertEqual(ISOCountry.NI, "THE REPUBLIC OF NICARAGUA")

        self.assertEqual(ISOCountry.NL, 528)
        self.assertEqual(ISOCountry.NL.label, "Netherlands (the)")
        self.assertEqual(ISOCountry.NL.alpha2, "NL")
        self.assertEqual(ISOCountry.NL.short_name, "Netherlands (the)")
        self.assertEqual(ISOCountry.NL, ISOCountry("Netherlands (the)"))
        self.assertEqual(ISOCountry.NL, "NL")
        self.assertEqual(ISOCountry.NL, "NLD")
        self.assertEqual(ISOCountry.NL, "Netherlands (the)")
        self.assertEqual(ISOCountry.NL, "NETHERLANDS (THE)")
        self.assertEqual(str(ISOCountry.NL), "NL")
        self.assertEqual(ISOCountry.NL, "the Kingdom of the Netherlands")
        self.assertEqual(ISOCountry.NL, "THE KINGDOM OF THE NETHERLANDS")

        self.assertEqual(ISOCountry.NO, 578)
        self.assertEqual(ISOCountry.NO.label, "Norway")
        self.assertEqual(ISOCountry.NO.alpha2, "NO")
        self.assertEqual(ISOCountry.NO.short_name, "Norway")
        self.assertEqual(ISOCountry.NO, ISOCountry("Norway"))
        self.assertEqual(ISOCountry.NO, "NO")
        self.assertEqual(ISOCountry.NO, "NOR")
        self.assertEqual(ISOCountry.NO, "Norway")
        self.assertEqual(ISOCountry.NO, "NORWAY")
        self.assertEqual(str(ISOCountry.NO), "NO")
        self.assertEqual(ISOCountry.NO, "the Kingdom of Norway")
        self.assertEqual(ISOCountry.NO, "THE KINGDOM OF NORWAY")

        self.assertEqual(ISOCountry.NP, 524)
        self.assertEqual(ISOCountry.NP.label, "Nepal")
        self.assertEqual(ISOCountry.NP.alpha2, "NP")
        self.assertEqual(ISOCountry.NP.short_name, "Nepal")
        self.assertEqual(ISOCountry.NP, ISOCountry("Nepal"))
        self.assertEqual(ISOCountry.NP, "NP")
        self.assertEqual(ISOCountry.NP, "NPL")
        self.assertEqual(ISOCountry.NP, "Nepal")
        self.assertEqual(ISOCountry.NP, "NEPAL")
        self.assertEqual(str(ISOCountry.NP), "NP")

        self.assertEqual(ISOCountry.NR, 520)
        self.assertEqual(ISOCountry.NR.label, "Nauru")
        self.assertEqual(ISOCountry.NR.alpha2, "NR")
        self.assertEqual(ISOCountry.NR.short_name, "Nauru")
        self.assertEqual(ISOCountry.NR, ISOCountry("Nauru"))
        self.assertEqual(ISOCountry.NR, "NR")
        self.assertEqual(ISOCountry.NR, "NRU")
        self.assertEqual(ISOCountry.NR, "Nauru")
        self.assertEqual(ISOCountry.NR, "NAURU")
        self.assertEqual(str(ISOCountry.NR), "NR")
        self.assertEqual(ISOCountry.NR, "the Republic of Nauru")
        self.assertEqual(ISOCountry.NR, "THE REPUBLIC OF NAURU")

        self.assertEqual(ISOCountry.NU, 570)
        self.assertEqual(ISOCountry.NU.label, "Niue")
        self.assertEqual(ISOCountry.NU.alpha2, "NU")
        self.assertEqual(ISOCountry.NU.short_name, "Niue")
        self.assertEqual(ISOCountry.NU, ISOCountry("Niue"))
        self.assertEqual(ISOCountry.NU, "NU")
        self.assertEqual(ISOCountry.NU, "NIU")
        self.assertEqual(ISOCountry.NU, "Niue")
        self.assertEqual(ISOCountry.NU, "NIUE")
        self.assertEqual(str(ISOCountry.NU), "NU")

        self.assertEqual(ISOCountry.NZ, 554)
        self.assertEqual(ISOCountry.NZ.label, "New Zealand")
        self.assertEqual(ISOCountry.NZ.alpha2, "NZ")
        self.assertEqual(ISOCountry.NZ.short_name, "New Zealand")
        self.assertEqual(ISOCountry.NZ, ISOCountry("New Zealand"))
        self.assertEqual(ISOCountry.NZ, "NZ")
        self.assertEqual(ISOCountry.NZ, "NZL")
        self.assertEqual(ISOCountry.NZ, "New Zealand")
        self.assertEqual(ISOCountry.NZ, "NEW ZEALAND")
        self.assertEqual(str(ISOCountry.NZ), "NZ")

        self.assertEqual(ISOCountry.OM, 512)
        self.assertEqual(ISOCountry.OM.label, "Oman")
        self.assertEqual(ISOCountry.OM.alpha2, "OM")
        self.assertEqual(ISOCountry.OM.short_name, "Oman")
        self.assertEqual(ISOCountry.OM, ISOCountry("Oman"))
        self.assertEqual(ISOCountry.OM, "OM")
        self.assertEqual(ISOCountry.OM, "OMN")
        self.assertEqual(ISOCountry.OM, "Oman")
        self.assertEqual(ISOCountry.OM, "OMAN")
        self.assertEqual(str(ISOCountry.OM), "OM")
        self.assertEqual(ISOCountry.OM, "the Sultanate of Oman")
        self.assertEqual(ISOCountry.OM, "THE SULTANATE OF OMAN")

        self.assertEqual(ISOCountry.PA, 591)
        self.assertEqual(ISOCountry.PA.label, "Panama")
        self.assertEqual(ISOCountry.PA.alpha2, "PA")
        self.assertEqual(ISOCountry.PA.short_name, "Panama")
        self.assertEqual(ISOCountry.PA, ISOCountry("Panama"))
        self.assertEqual(ISOCountry.PA, "PA")
        self.assertEqual(ISOCountry.PA, "PAN")
        self.assertEqual(ISOCountry.PA, "Panama")
        self.assertEqual(ISOCountry.PA, "PANAMA")
        self.assertEqual(str(ISOCountry.PA), "PA")
        self.assertEqual(ISOCountry.PA, "the Republic of Panama")
        self.assertEqual(ISOCountry.PA, "THE REPUBLIC OF PANAMA")

        self.assertEqual(ISOCountry.PE, 604)
        self.assertEqual(ISOCountry.PE.label, "Peru")
        self.assertEqual(ISOCountry.PE.alpha2, "PE")
        self.assertEqual(ISOCountry.PE.short_name, "Peru")
        self.assertEqual(ISOCountry.PE, ISOCountry("Peru"))
        self.assertEqual(ISOCountry.PE, "PE")
        self.assertEqual(ISOCountry.PE, "PER")
        self.assertEqual(ISOCountry.PE, "Peru")
        self.assertEqual(ISOCountry.PE, "PERU")
        self.assertEqual(str(ISOCountry.PE), "PE")
        self.assertEqual(ISOCountry.PE, "the Republic of Peru")
        self.assertEqual(ISOCountry.PE, "THE REPUBLIC OF PERU")

        self.assertEqual(ISOCountry.PF, 258)
        self.assertEqual(ISOCountry.PF.label, "French Polynesia")
        self.assertEqual(ISOCountry.PF.alpha2, "PF")
        self.assertEqual(ISOCountry.PF.short_name, "French Polynesia")
        self.assertEqual(ISOCountry.PF, ISOCountry("French Polynesia"))
        self.assertEqual(ISOCountry.PF, "PF")
        self.assertEqual(ISOCountry.PF, "PYF")
        self.assertEqual(ISOCountry.PF, "French Polynesia")
        self.assertEqual(ISOCountry.PF, "FRENCH POLYNESIA")
        self.assertEqual(str(ISOCountry.PF), "PF")

        self.assertEqual(ISOCountry.PG, 598)
        self.assertEqual(ISOCountry.PG.label, "Papua New Guinea")
        self.assertEqual(ISOCountry.PG.alpha2, "PG")
        self.assertEqual(ISOCountry.PG.short_name, "Papua New Guinea")
        self.assertEqual(ISOCountry.PG, ISOCountry("Papua New Guinea"))
        self.assertEqual(ISOCountry.PG, "PG")
        self.assertEqual(ISOCountry.PG, "PNG")
        self.assertEqual(ISOCountry.PG, "Papua New Guinea")
        self.assertEqual(ISOCountry.PG, "PAPUA NEW GUINEA")
        self.assertEqual(str(ISOCountry.PG), "PG")
        self.assertEqual(ISOCountry.PG, "the Independent State of Papua New Guinea")
        self.assertEqual(ISOCountry.PG, "THE INDEPENDENT STATE OF PAPUA NEW GUINEA")

        self.assertEqual(ISOCountry.PH, 608)
        self.assertEqual(ISOCountry.PH.label, "Philippines (the)")
        self.assertEqual(ISOCountry.PH.alpha2, "PH")
        self.assertEqual(ISOCountry.PH.short_name, "Philippines (the)")
        self.assertEqual(ISOCountry.PH, ISOCountry("Philippines (the)"))
        self.assertEqual(ISOCountry.PH, "PH")
        self.assertEqual(ISOCountry.PH, "PHL")
        self.assertEqual(ISOCountry.PH, "Philippines (the)")
        self.assertEqual(ISOCountry.PH, "PHILIPPINES (THE)")
        self.assertEqual(str(ISOCountry.PH), "PH")
        self.assertEqual(ISOCountry.PH, "the Republic of the Philippines")
        self.assertEqual(ISOCountry.PH, "THE REPUBLIC OF THE PHILIPPINES")

        self.assertEqual(ISOCountry.PK, 586)
        self.assertEqual(ISOCountry.PK.label, "Pakistan")
        self.assertEqual(ISOCountry.PK.alpha2, "PK")
        self.assertEqual(ISOCountry.PK.short_name, "Pakistan")
        self.assertEqual(ISOCountry.PK, ISOCountry("Pakistan"))
        self.assertEqual(ISOCountry.PK, "PK")
        self.assertEqual(ISOCountry.PK, "PAK")
        self.assertEqual(ISOCountry.PK, "Pakistan")
        self.assertEqual(ISOCountry.PK, "PAKISTAN")
        self.assertEqual(str(ISOCountry.PK), "PK")
        self.assertEqual(ISOCountry.PK, "the Islamic Republic of Pakistan")
        self.assertEqual(ISOCountry.PK, "THE ISLAMIC REPUBLIC OF PAKISTAN")

        self.assertEqual(ISOCountry.PL, 616)
        self.assertEqual(ISOCountry.PL.label, "Poland")
        self.assertEqual(ISOCountry.PL.alpha2, "PL")
        self.assertEqual(ISOCountry.PL.short_name, "Poland")
        self.assertEqual(ISOCountry.PL, ISOCountry("Poland"))
        self.assertEqual(ISOCountry.PL, "PL")
        self.assertEqual(ISOCountry.PL, "POL")
        self.assertEqual(ISOCountry.PL, "Poland")
        self.assertEqual(ISOCountry.PL, "POLAND")
        self.assertEqual(str(ISOCountry.PL), "PL")
        self.assertEqual(ISOCountry.PL, "the Republic of Poland")
        self.assertEqual(ISOCountry.PL, "THE REPUBLIC OF POLAND")

        self.assertEqual(ISOCountry.PM, 666)
        self.assertEqual(ISOCountry.PM.label, "Saint Pierre and Miquelon")
        self.assertEqual(ISOCountry.PM.alpha2, "PM")
        self.assertEqual(ISOCountry.PM.short_name, "Saint Pierre and Miquelon")
        self.assertEqual(ISOCountry.PM, ISOCountry("Saint Pierre and Miquelon"))
        self.assertEqual(ISOCountry.PM, "PM")
        self.assertEqual(ISOCountry.PM, "SPM")
        self.assertEqual(ISOCountry.PM, "Saint Pierre and Miquelon")
        self.assertEqual(ISOCountry.PM, "SAINT PIERRE AND MIQUELON")
        self.assertEqual(str(ISOCountry.PM), "PM")

        self.assertEqual(ISOCountry.PN, 612)
        self.assertEqual(ISOCountry.PN.label, "Pitcairn")
        self.assertEqual(ISOCountry.PN.alpha2, "PN")
        self.assertEqual(ISOCountry.PN.short_name, "Pitcairn")
        self.assertEqual(ISOCountry.PN, ISOCountry("Pitcairn"))
        self.assertEqual(ISOCountry.PN, "PN")
        self.assertEqual(ISOCountry.PN, "PCN")
        self.assertEqual(ISOCountry.PN, "Pitcairn")
        self.assertEqual(ISOCountry.PN, "PITCAIRN")
        self.assertEqual(str(ISOCountry.PN), "PN")

        self.assertEqual(ISOCountry.PR, 630)
        self.assertEqual(ISOCountry.PR.label, "Puerto Rico")
        self.assertEqual(ISOCountry.PR.alpha2, "PR")
        self.assertEqual(ISOCountry.PR.short_name, "Puerto Rico")
        self.assertEqual(ISOCountry.PR, ISOCountry("Puerto Rico"))
        self.assertEqual(ISOCountry.PR, "PR")
        self.assertEqual(ISOCountry.PR, "PRI")
        self.assertEqual(ISOCountry.PR, "Puerto Rico")
        self.assertEqual(ISOCountry.PR, "PUERTO RICO")
        self.assertEqual(str(ISOCountry.PR), "PR")

        self.assertEqual(ISOCountry.PS, 275)
        self.assertEqual(ISOCountry.PS.label, "Palestine, State of")
        self.assertEqual(ISOCountry.PS.alpha2, "PS")
        self.assertEqual(ISOCountry.PS.short_name, "Palestine, State of")
        self.assertEqual(ISOCountry.PS, ISOCountry("Palestine, State of"))
        self.assertEqual(ISOCountry.PS, "PS")
        self.assertEqual(ISOCountry.PS, "PSE")
        self.assertEqual(ISOCountry.PS, "Palestine, State of")
        self.assertEqual(ISOCountry.PS, "PALESTINE, STATE OF")
        self.assertEqual(str(ISOCountry.PS), "PS")
        self.assertEqual(ISOCountry.PS, "the State of Palestine")
        self.assertEqual(ISOCountry.PS, "THE STATE OF PALESTINE")

        self.assertEqual(ISOCountry.PT, 620)
        self.assertEqual(ISOCountry.PT.label, "Portugal")
        self.assertEqual(ISOCountry.PT.alpha2, "PT")
        self.assertEqual(ISOCountry.PT.short_name, "Portugal")
        self.assertEqual(ISOCountry.PT, ISOCountry("Portugal"))
        self.assertEqual(ISOCountry.PT, "PT")
        self.assertEqual(ISOCountry.PT, "PRT")
        self.assertEqual(ISOCountry.PT, "Portugal")
        self.assertEqual(ISOCountry.PT, "PORTUGAL")
        self.assertEqual(str(ISOCountry.PT), "PT")
        self.assertEqual(ISOCountry.PT, "the Portuguese Republic")
        self.assertEqual(ISOCountry.PT, "THE PORTUGUESE REPUBLIC")

        self.assertEqual(ISOCountry.PW, 585)
        self.assertEqual(ISOCountry.PW.label, "Palau")
        self.assertEqual(ISOCountry.PW.alpha2, "PW")
        self.assertEqual(ISOCountry.PW.short_name, "Palau")
        self.assertEqual(ISOCountry.PW, ISOCountry("Palau"))
        self.assertEqual(ISOCountry.PW, "PW")
        self.assertEqual(ISOCountry.PW, "PLW")
        self.assertEqual(ISOCountry.PW, "Palau")
        self.assertEqual(ISOCountry.PW, "PALAU")
        self.assertEqual(str(ISOCountry.PW), "PW")
        self.assertEqual(ISOCountry.PW, "the Republic of Palau")
        self.assertEqual(ISOCountry.PW, "THE REPUBLIC OF PALAU")

        self.assertEqual(ISOCountry.PY, 600)
        self.assertEqual(ISOCountry.PY.label, "Paraguay")
        self.assertEqual(ISOCountry.PY.alpha2, "PY")
        self.assertEqual(ISOCountry.PY.short_name, "Paraguay")
        self.assertEqual(ISOCountry.PY, ISOCountry("Paraguay"))
        self.assertEqual(ISOCountry.PY, "PY")
        self.assertEqual(ISOCountry.PY, "PRY")
        self.assertEqual(ISOCountry.PY, "Paraguay")
        self.assertEqual(ISOCountry.PY, "PARAGUAY")
        self.assertEqual(str(ISOCountry.PY), "PY")
        self.assertEqual(ISOCountry.PY, "the Republic of Paraguay")
        self.assertEqual(ISOCountry.PY, "THE REPUBLIC OF PARAGUAY")

        self.assertEqual(ISOCountry.QA, 634)
        self.assertEqual(ISOCountry.QA.label, "Qatar")
        self.assertEqual(ISOCountry.QA.alpha2, "QA")
        self.assertEqual(ISOCountry.QA.short_name, "Qatar")
        self.assertEqual(ISOCountry.QA, ISOCountry("Qatar"))
        self.assertEqual(ISOCountry.QA, "QA")
        self.assertEqual(ISOCountry.QA, "QAT")
        self.assertEqual(ISOCountry.QA, "Qatar")
        self.assertEqual(ISOCountry.QA, "QATAR")
        self.assertEqual(str(ISOCountry.QA), "QA")
        self.assertEqual(ISOCountry.QA, "the State of Qatar")
        self.assertEqual(ISOCountry.QA, "THE STATE OF QATAR")

        self.assertEqual(ISOCountry.RE, 638)
        self.assertEqual(ISOCountry.RE.label, "Réunion")
        self.assertEqual(ISOCountry.RE.alpha2, "RE")
        self.assertEqual(ISOCountry.RE.short_name, "Réunion")
        self.assertEqual(ISOCountry.RE, ISOCountry("Réunion"))
        self.assertEqual(ISOCountry.RE, "RE")
        self.assertEqual(ISOCountry.RE, "REU")
        self.assertEqual(ISOCountry.RE, "Réunion")
        self.assertEqual(ISOCountry.RE, "RÉUNION")
        self.assertEqual(str(ISOCountry.RE), "RE")

        self.assertEqual(ISOCountry.RO, 642)
        self.assertEqual(ISOCountry.RO.label, "Romania")
        self.assertEqual(ISOCountry.RO.alpha2, "RO")
        self.assertEqual(ISOCountry.RO.short_name, "Romania")
        self.assertEqual(ISOCountry.RO, ISOCountry("Romania"))
        self.assertEqual(ISOCountry.RO, "RO")
        self.assertEqual(ISOCountry.RO, "ROU")
        self.assertEqual(ISOCountry.RO, "Romania")
        self.assertEqual(ISOCountry.RO, "ROMANIA")
        self.assertEqual(str(ISOCountry.RO), "RO")

        self.assertEqual(ISOCountry.RS, 688)
        self.assertEqual(ISOCountry.RS.label, "Serbia")
        self.assertEqual(ISOCountry.RS.alpha2, "RS")
        self.assertEqual(ISOCountry.RS.short_name, "Serbia")
        self.assertEqual(ISOCountry.RS, ISOCountry("Serbia"))
        self.assertEqual(ISOCountry.RS, "RS")
        self.assertEqual(ISOCountry.RS, "SRB")
        self.assertEqual(ISOCountry.RS, "Serbia")
        self.assertEqual(ISOCountry.RS, "SERBIA")
        self.assertEqual(str(ISOCountry.RS), "RS")
        self.assertEqual(ISOCountry.RS, "the Republic of Serbia")
        self.assertEqual(ISOCountry.RS, "THE REPUBLIC OF SERBIA")

        self.assertEqual(ISOCountry.RU, 643)
        self.assertEqual(ISOCountry.RU.label, "Russian Federation (the)")
        self.assertEqual(ISOCountry.RU.alpha2, "RU")
        self.assertEqual(ISOCountry.RU.short_name, "Russian Federation (the)")
        self.assertEqual(ISOCountry.RU, ISOCountry("Russian Federation (the)"))
        self.assertEqual(ISOCountry.RU, "RU")
        self.assertEqual(ISOCountry.RU, "RUS")
        self.assertEqual(ISOCountry.RU, "Russian Federation (the)")
        self.assertEqual(ISOCountry.RU, "RUSSIAN FEDERATION (THE)")
        self.assertEqual(str(ISOCountry.RU), "RU")
        self.assertEqual(ISOCountry.RU, "the Russian Federation")
        self.assertEqual(ISOCountry.RU, "THE RUSSIAN FEDERATION")

        self.assertEqual(ISOCountry.RW, 646)
        self.assertEqual(ISOCountry.RW.label, "Rwanda")
        self.assertEqual(ISOCountry.RW.alpha2, "RW")
        self.assertEqual(ISOCountry.RW.short_name, "Rwanda")
        self.assertEqual(ISOCountry.RW, ISOCountry("Rwanda"))
        self.assertEqual(ISOCountry.RW, "RW")
        self.assertEqual(ISOCountry.RW, "RWA")
        self.assertEqual(ISOCountry.RW, "Rwanda")
        self.assertEqual(ISOCountry.RW, "RWANDA")
        self.assertEqual(str(ISOCountry.RW), "RW")
        self.assertEqual(ISOCountry.RW, "the Republic of Rwanda")
        self.assertEqual(ISOCountry.RW, "THE REPUBLIC OF RWANDA")

        self.assertEqual(ISOCountry.SA, 682)
        self.assertEqual(ISOCountry.SA.label, "Saudi Arabia")
        self.assertEqual(ISOCountry.SA.alpha2, "SA")
        self.assertEqual(ISOCountry.SA.short_name, "Saudi Arabia")
        self.assertEqual(ISOCountry.SA, ISOCountry("Saudi Arabia"))
        self.assertEqual(ISOCountry.SA, "SA")
        self.assertEqual(ISOCountry.SA, "SAU")
        self.assertEqual(ISOCountry.SA, "Saudi Arabia")
        self.assertEqual(ISOCountry.SA, "SAUDI ARABIA")
        self.assertEqual(str(ISOCountry.SA), "SA")
        self.assertEqual(ISOCountry.SA, "the Kingdom of Saudi Arabia")
        self.assertEqual(ISOCountry.SA, "THE KINGDOM OF SAUDI ARABIA")

        self.assertEqual(ISOCountry.SB, 90)
        self.assertEqual(ISOCountry.SB.label, "Solomon Islands")
        self.assertEqual(ISOCountry.SB.alpha2, "SB")
        self.assertEqual(ISOCountry.SB.short_name, "Solomon Islands")
        self.assertEqual(ISOCountry.SB, ISOCountry("Solomon Islands"))
        self.assertEqual(ISOCountry.SB, "SB")
        self.assertEqual(ISOCountry.SB, "SLB")
        self.assertEqual(ISOCountry.SB, "Solomon Islands")
        self.assertEqual(ISOCountry.SB, "SOLOMON ISLANDS")
        self.assertEqual(str(ISOCountry.SB), "SB")

        self.assertEqual(ISOCountry.SC, 690)
        self.assertEqual(ISOCountry.SC.label, "Seychelles")
        self.assertEqual(ISOCountry.SC.alpha2, "SC")
        self.assertEqual(ISOCountry.SC.short_name, "Seychelles")
        self.assertEqual(ISOCountry.SC, ISOCountry("Seychelles"))
        self.assertEqual(ISOCountry.SC, "SC")
        self.assertEqual(ISOCountry.SC, "SYC")
        self.assertEqual(ISOCountry.SC, "Seychelles")
        self.assertEqual(ISOCountry.SC, "SEYCHELLES")
        self.assertEqual(str(ISOCountry.SC), "SC")
        self.assertEqual(ISOCountry.SC, "the Republic of Seychelles")
        self.assertEqual(ISOCountry.SC, "THE REPUBLIC OF SEYCHELLES")

        self.assertEqual(ISOCountry.SD, 729)
        self.assertEqual(ISOCountry.SD.label, "Sudan (the)")
        self.assertEqual(ISOCountry.SD.alpha2, "SD")
        self.assertEqual(ISOCountry.SD.short_name, "Sudan (the)")
        self.assertEqual(ISOCountry.SD, ISOCountry("Sudan (the)"))
        self.assertEqual(ISOCountry.SD, "SD")
        self.assertEqual(ISOCountry.SD, "SDN")
        self.assertEqual(ISOCountry.SD, "Sudan (the)")
        self.assertEqual(ISOCountry.SD, "SUDAN (THE)")
        self.assertEqual(str(ISOCountry.SD), "SD")
        self.assertEqual(ISOCountry.SD, "the Republic of the Sudan")
        self.assertEqual(ISOCountry.SD, "THE REPUBLIC OF THE SUDAN")

        self.assertEqual(ISOCountry.SE, 752)
        self.assertEqual(ISOCountry.SE.label, "Sweden")
        self.assertEqual(ISOCountry.SE.alpha2, "SE")
        self.assertEqual(ISOCountry.SE.short_name, "Sweden")
        self.assertEqual(ISOCountry.SE, ISOCountry("Sweden"))
        self.assertEqual(ISOCountry.SE, "SE")
        self.assertEqual(ISOCountry.SE, "SWE")
        self.assertEqual(ISOCountry.SE, "Sweden")
        self.assertEqual(ISOCountry.SE, "SWEDEN")
        self.assertEqual(str(ISOCountry.SE), "SE")
        self.assertEqual(ISOCountry.SE, "the Kingdom of Sweden")
        self.assertEqual(ISOCountry.SE, "THE KINGDOM OF SWEDEN")

        self.assertEqual(ISOCountry.SG, 702)
        self.assertEqual(ISOCountry.SG.label, "Singapore")
        self.assertEqual(ISOCountry.SG.alpha2, "SG")
        self.assertEqual(ISOCountry.SG.short_name, "Singapore")
        self.assertEqual(ISOCountry.SG, ISOCountry("Singapore"))
        self.assertEqual(ISOCountry.SG, "SG")
        self.assertEqual(ISOCountry.SG, "SGP")
        self.assertEqual(ISOCountry.SG, "Singapore")
        self.assertEqual(ISOCountry.SG, "SINGAPORE")
        self.assertEqual(str(ISOCountry.SG), "SG")
        self.assertEqual(ISOCountry.SG, "the Republic of Singapore")
        self.assertEqual(ISOCountry.SG, "THE REPUBLIC OF SINGAPORE")

        self.assertEqual(ISOCountry.SH, 654)
        self.assertEqual(
            ISOCountry.SH.label, "Saint Helena, Ascension and Tristan da Cunha"
        )
        self.assertEqual(ISOCountry.SH.alpha2, "SH")
        self.assertEqual(
            ISOCountry.SH.short_name, "Saint Helena, Ascension and Tristan da Cunha"
        )
        self.assertEqual(
            ISOCountry.SH, ISOCountry("Saint Helena, Ascension and Tristan da Cunha")
        )
        self.assertEqual(ISOCountry.SH, "SH")
        self.assertEqual(ISOCountry.SH, "SHN")
        self.assertEqual(ISOCountry.SH, "Saint Helena, Ascension and Tristan da Cunha")
        self.assertEqual(ISOCountry.SH, "SAINT HELENA, ASCENSION AND TRISTAN DA CUNHA")
        self.assertEqual(str(ISOCountry.SH), "SH")

        self.assertEqual(ISOCountry.SI, 705)
        self.assertEqual(ISOCountry.SI.label, "Slovenia")
        self.assertEqual(ISOCountry.SI.alpha2, "SI")
        self.assertEqual(ISOCountry.SI.short_name, "Slovenia")
        self.assertEqual(ISOCountry.SI, ISOCountry("Slovenia"))
        self.assertEqual(ISOCountry.SI, "SI")
        self.assertEqual(ISOCountry.SI, "SVN")
        self.assertEqual(ISOCountry.SI, "Slovenia")
        self.assertEqual(ISOCountry.SI, "SLOVENIA")
        self.assertEqual(str(ISOCountry.SI), "SI")
        self.assertEqual(ISOCountry.SI, "the Republic of Slovenia")
        self.assertEqual(ISOCountry.SI, "THE REPUBLIC OF SLOVENIA")

        self.assertEqual(ISOCountry.SJ, 744)
        self.assertEqual(ISOCountry.SJ.label, "Svalbard and Jan Mayen")
        self.assertEqual(ISOCountry.SJ.alpha2, "SJ")
        self.assertEqual(ISOCountry.SJ.short_name, "Svalbard and Jan Mayen")
        self.assertEqual(ISOCountry.SJ, ISOCountry("Svalbard and Jan Mayen"))
        self.assertEqual(ISOCountry.SJ, "SJ")
        self.assertEqual(ISOCountry.SJ, "SJM")
        self.assertEqual(ISOCountry.SJ, "Svalbard and Jan Mayen")
        self.assertEqual(ISOCountry.SJ, "SVALBARD AND JAN MAYEN")
        self.assertEqual(str(ISOCountry.SJ), "SJ")

        self.assertEqual(ISOCountry.SK, 703)
        self.assertEqual(ISOCountry.SK.label, "Slovakia")
        self.assertEqual(ISOCountry.SK.alpha2, "SK")
        self.assertEqual(ISOCountry.SK.short_name, "Slovakia")
        self.assertEqual(ISOCountry.SK, ISOCountry("Slovakia"))
        self.assertEqual(ISOCountry.SK, "SK")
        self.assertEqual(ISOCountry.SK, "SVK")
        self.assertEqual(ISOCountry.SK, "Slovakia")
        self.assertEqual(ISOCountry.SK, "SLOVAKIA")
        self.assertEqual(str(ISOCountry.SK), "SK")
        self.assertEqual(ISOCountry.SK, "the Slovak Republic")
        self.assertEqual(ISOCountry.SK, "THE SLOVAK REPUBLIC")

        self.assertEqual(ISOCountry.SL, 694)
        self.assertEqual(ISOCountry.SL.label, "Sierra Leone")
        self.assertEqual(ISOCountry.SL.alpha2, "SL")
        self.assertEqual(ISOCountry.SL.short_name, "Sierra Leone")
        self.assertEqual(ISOCountry.SL, ISOCountry("Sierra Leone"))
        self.assertEqual(ISOCountry.SL, "SL")
        self.assertEqual(ISOCountry.SL, "SLE")
        self.assertEqual(ISOCountry.SL, "Sierra Leone")
        self.assertEqual(ISOCountry.SL, "SIERRA LEONE")
        self.assertEqual(str(ISOCountry.SL), "SL")
        self.assertEqual(ISOCountry.SL, "the Republic of Sierra Leone")
        self.assertEqual(ISOCountry.SL, "THE REPUBLIC OF SIERRA LEONE")

        self.assertEqual(ISOCountry.SM, 674)
        self.assertEqual(ISOCountry.SM.label, "San Marino")
        self.assertEqual(ISOCountry.SM.alpha2, "SM")
        self.assertEqual(ISOCountry.SM.short_name, "San Marino")
        self.assertEqual(ISOCountry.SM, ISOCountry("San Marino"))
        self.assertEqual(ISOCountry.SM, "SM")
        self.assertEqual(ISOCountry.SM, "SMR")
        self.assertEqual(ISOCountry.SM, "San Marino")
        self.assertEqual(ISOCountry.SM, "SAN MARINO")
        self.assertEqual(str(ISOCountry.SM), "SM")
        self.assertEqual(ISOCountry.SM, "the Republic of San Marino")
        self.assertEqual(ISOCountry.SM, "THE REPUBLIC OF SAN MARINO")

        self.assertEqual(ISOCountry.SN, 686)
        self.assertEqual(ISOCountry.SN.label, "Senegal")
        self.assertEqual(ISOCountry.SN.alpha2, "SN")
        self.assertEqual(ISOCountry.SN.short_name, "Senegal")
        self.assertEqual(ISOCountry.SN, ISOCountry("Senegal"))
        self.assertEqual(ISOCountry.SN, "SN")
        self.assertEqual(ISOCountry.SN, "SEN")
        self.assertEqual(ISOCountry.SN, "Senegal")
        self.assertEqual(ISOCountry.SN, "SENEGAL")
        self.assertEqual(str(ISOCountry.SN), "SN")
        self.assertEqual(ISOCountry.SN, "the Republic of Senegal")
        self.assertEqual(ISOCountry.SN, "THE REPUBLIC OF SENEGAL")

        self.assertEqual(ISOCountry.SO, 706)
        self.assertEqual(ISOCountry.SO.label, "Somalia")
        self.assertEqual(ISOCountry.SO.alpha2, "SO")
        self.assertEqual(ISOCountry.SO.short_name, "Somalia")
        self.assertEqual(ISOCountry.SO, ISOCountry("Somalia"))
        self.assertEqual(ISOCountry.SO, "SO")
        self.assertEqual(ISOCountry.SO, "SOM")
        self.assertEqual(ISOCountry.SO, "Somalia")
        self.assertEqual(ISOCountry.SO, "SOMALIA")
        self.assertEqual(str(ISOCountry.SO), "SO")
        self.assertEqual(ISOCountry.SO, "the Federal Republic of Somalia")
        self.assertEqual(ISOCountry.SO, "THE FEDERAL REPUBLIC OF SOMALIA")

        self.assertEqual(ISOCountry.SR, 740)
        self.assertEqual(ISOCountry.SR.label, "Suriname")
        self.assertEqual(ISOCountry.SR.alpha2, "SR")
        self.assertEqual(ISOCountry.SR.short_name, "Suriname")
        self.assertEqual(ISOCountry.SR, ISOCountry("Suriname"))
        self.assertEqual(ISOCountry.SR, "SR")
        self.assertEqual(ISOCountry.SR, "SUR")
        self.assertEqual(ISOCountry.SR, "Suriname")
        self.assertEqual(ISOCountry.SR, "SURINAME")
        self.assertEqual(str(ISOCountry.SR), "SR")
        self.assertEqual(ISOCountry.SR, "the Republic of Suriname")
        self.assertEqual(ISOCountry.SR, "THE REPUBLIC OF SURINAME")

        self.assertEqual(ISOCountry.SS, 728)
        self.assertEqual(ISOCountry.SS.label, "South Sudan")
        self.assertEqual(ISOCountry.SS.alpha2, "SS")
        self.assertEqual(ISOCountry.SS.short_name, "South Sudan")
        self.assertEqual(ISOCountry.SS, ISOCountry("South Sudan"))
        self.assertEqual(ISOCountry.SS, "SS")
        self.assertEqual(ISOCountry.SS, "SSD")
        self.assertEqual(ISOCountry.SS, "South Sudan")
        self.assertEqual(ISOCountry.SS, "SOUTH SUDAN")
        self.assertEqual(str(ISOCountry.SS), "SS")
        self.assertEqual(ISOCountry.SS, "the Republic of South Sudan")
        self.assertEqual(ISOCountry.SS, "THE REPUBLIC OF SOUTH SUDAN")

        self.assertEqual(ISOCountry.ST, 678)
        self.assertEqual(ISOCountry.ST.label, "Sao Tome and Principe")
        self.assertEqual(ISOCountry.ST.alpha2, "ST")
        self.assertEqual(ISOCountry.ST.short_name, "Sao Tome and Principe")
        self.assertEqual(ISOCountry.ST, ISOCountry("Sao Tome and Principe"))
        self.assertEqual(ISOCountry.ST, "ST")
        self.assertEqual(ISOCountry.ST, "STP")
        self.assertEqual(ISOCountry.ST, "Sao Tome and Principe")
        self.assertEqual(ISOCountry.ST, "SAO TOME AND PRINCIPE")
        self.assertEqual(str(ISOCountry.ST), "ST")
        self.assertEqual(
            ISOCountry.ST, "the Democratic Republic of Sao Tome and Principe"
        )
        self.assertEqual(
            ISOCountry.ST, "THE DEMOCRATIC REPUBLIC OF SAO TOME AND PRINCIPE"
        )

        self.assertEqual(ISOCountry.SV, 222)
        self.assertEqual(ISOCountry.SV.label, "El Salvador")
        self.assertEqual(ISOCountry.SV.alpha2, "SV")
        self.assertEqual(ISOCountry.SV.short_name, "El Salvador")
        self.assertEqual(ISOCountry.SV, ISOCountry("El Salvador"))
        self.assertEqual(ISOCountry.SV, "SV")
        self.assertEqual(ISOCountry.SV, "SLV")
        self.assertEqual(ISOCountry.SV, "El Salvador")
        self.assertEqual(ISOCountry.SV, "EL SALVADOR")
        self.assertEqual(str(ISOCountry.SV), "SV")
        self.assertEqual(ISOCountry.SV, "the Republic of El Salvador")
        self.assertEqual(ISOCountry.SV, "THE REPUBLIC OF EL SALVADOR")

        self.assertEqual(ISOCountry.SX, 534)
        self.assertEqual(ISOCountry.SX.label, "Sint Maarten (Dutch part)")
        self.assertEqual(ISOCountry.SX.alpha2, "SX")
        self.assertEqual(ISOCountry.SX.short_name, "Sint Maarten (Dutch part)")
        self.assertEqual(ISOCountry.SX, ISOCountry("Sint Maarten (Dutch part)"))
        self.assertEqual(ISOCountry.SX, "SX")
        self.assertEqual(ISOCountry.SX, "SXM")
        self.assertEqual(ISOCountry.SX, "Sint Maarten (Dutch part)")
        self.assertEqual(ISOCountry.SX, "SINT MAARTEN (DUTCH PART)")
        self.assertEqual(str(ISOCountry.SX), "SX")

        self.assertEqual(ISOCountry.SY, 760)
        self.assertEqual(ISOCountry.SY.label, "Syrian Arab Republic (the)")
        self.assertEqual(ISOCountry.SY.alpha2, "SY")
        self.assertEqual(ISOCountry.SY.short_name, "Syrian Arab Republic (the)")
        self.assertEqual(ISOCountry.SY, ISOCountry("Syrian Arab Republic (the)"))
        self.assertEqual(ISOCountry.SY, "SY")
        self.assertEqual(ISOCountry.SY, "SYR")
        self.assertEqual(ISOCountry.SY, "Syrian Arab Republic (the)")
        self.assertEqual(ISOCountry.SY, "SYRIAN ARAB REPUBLIC (THE)")
        self.assertEqual(str(ISOCountry.SY), "SY")
        self.assertEqual(ISOCountry.SY, "the Syrian Arab Republic")
        self.assertEqual(ISOCountry.SY, "THE SYRIAN ARAB REPUBLIC")

        self.assertEqual(ISOCountry.SZ, 748)
        self.assertEqual(ISOCountry.SZ.label, "Eswatini")
        self.assertEqual(ISOCountry.SZ.alpha2, "SZ")
        self.assertEqual(ISOCountry.SZ.short_name, "Eswatini")
        self.assertEqual(ISOCountry.SZ, ISOCountry("Eswatini"))
        self.assertEqual(ISOCountry.SZ, "SZ")
        self.assertEqual(ISOCountry.SZ, "SWZ")
        self.assertEqual(ISOCountry.SZ, "Eswatini")
        self.assertEqual(ISOCountry.SZ, "ESWATINI")
        self.assertEqual(str(ISOCountry.SZ), "SZ")
        self.assertEqual(ISOCountry.SZ, "the Kingdom of Eswatini")
        self.assertEqual(ISOCountry.SZ, "THE KINGDOM OF ESWATINI")

        self.assertEqual(ISOCountry.TC, 796)
        self.assertEqual(ISOCountry.TC.label, "Turks and Caicos Islands (the)")
        self.assertEqual(ISOCountry.TC.alpha2, "TC")
        self.assertEqual(ISOCountry.TC.short_name, "Turks and Caicos Islands (the)")
        self.assertEqual(ISOCountry.TC, ISOCountry("Turks and Caicos Islands (the)"))
        self.assertEqual(ISOCountry.TC, "TC")
        self.assertEqual(ISOCountry.TC, "TCA")
        self.assertEqual(ISOCountry.TC, "Turks and Caicos Islands (the)")
        self.assertEqual(ISOCountry.TC, "TURKS AND CAICOS ISLANDS (THE)")
        self.assertEqual(str(ISOCountry.TC), "TC")

        self.assertEqual(ISOCountry.TD, 148)
        self.assertEqual(ISOCountry.TD.label, "Chad")
        self.assertEqual(ISOCountry.TD.alpha2, "TD")
        self.assertEqual(ISOCountry.TD.short_name, "Chad")
        self.assertEqual(ISOCountry.TD, ISOCountry("Chad"))
        self.assertEqual(ISOCountry.TD, "TD")
        self.assertEqual(ISOCountry.TD, "TCD")
        self.assertEqual(ISOCountry.TD, "Chad")
        self.assertEqual(ISOCountry.TD, "CHAD")
        self.assertEqual(str(ISOCountry.TD), "TD")
        self.assertEqual(ISOCountry.TD, "the Republic of Chad")
        self.assertEqual(ISOCountry.TD, "THE REPUBLIC OF CHAD")

        self.assertEqual(ISOCountry.TF, 260)
        self.assertEqual(ISOCountry.TF.label, "French Southern Territories (the)")
        self.assertEqual(ISOCountry.TF.alpha2, "TF")
        self.assertEqual(ISOCountry.TF.short_name, "French Southern Territories (the)")
        self.assertEqual(ISOCountry.TF, ISOCountry("French Southern Territories (the)"))
        self.assertEqual(ISOCountry.TF, "TF")
        self.assertEqual(ISOCountry.TF, "ATF")
        self.assertEqual(ISOCountry.TF, "French Southern Territories (the)")
        self.assertEqual(ISOCountry.TF, "FRENCH SOUTHERN TERRITORIES (THE)")
        self.assertEqual(str(ISOCountry.TF), "TF")

        self.assertEqual(ISOCountry.TG, 768)
        self.assertEqual(ISOCountry.TG.label, "Togo")
        self.assertEqual(ISOCountry.TG.alpha2, "TG")
        self.assertEqual(ISOCountry.TG.short_name, "Togo")
        self.assertEqual(ISOCountry.TG, ISOCountry("Togo"))
        self.assertEqual(ISOCountry.TG, "TG")
        self.assertEqual(ISOCountry.TG, "TGO")
        self.assertEqual(ISOCountry.TG, "Togo")
        self.assertEqual(ISOCountry.TG, "TOGO")
        self.assertEqual(str(ISOCountry.TG), "TG")
        self.assertEqual(ISOCountry.TG, "the Togolese Republic")
        self.assertEqual(ISOCountry.TG, "THE TOGOLESE REPUBLIC")

        self.assertEqual(ISOCountry.TH, 764)
        self.assertEqual(ISOCountry.TH.label, "Thailand")
        self.assertEqual(ISOCountry.TH.alpha2, "TH")
        self.assertEqual(ISOCountry.TH.short_name, "Thailand")
        self.assertEqual(ISOCountry.TH, ISOCountry("Thailand"))
        self.assertEqual(ISOCountry.TH, "TH")
        self.assertEqual(ISOCountry.TH, "THA")
        self.assertEqual(ISOCountry.TH, "Thailand")
        self.assertEqual(ISOCountry.TH, "THAILAND")
        self.assertEqual(str(ISOCountry.TH), "TH")
        self.assertEqual(ISOCountry.TH, "the Kingdom of Thailand")
        self.assertEqual(ISOCountry.TH, "THE KINGDOM OF THAILAND")

        self.assertEqual(ISOCountry.TJ, 762)
        self.assertEqual(ISOCountry.TJ.label, "Tajikistan")
        self.assertEqual(ISOCountry.TJ.alpha2, "TJ")
        self.assertEqual(ISOCountry.TJ.short_name, "Tajikistan")
        self.assertEqual(ISOCountry.TJ, ISOCountry("Tajikistan"))
        self.assertEqual(ISOCountry.TJ, "TJ")
        self.assertEqual(ISOCountry.TJ, "TJK")
        self.assertEqual(ISOCountry.TJ, "Tajikistan")
        self.assertEqual(ISOCountry.TJ, "TAJIKISTAN")
        self.assertEqual(str(ISOCountry.TJ), "TJ")
        self.assertEqual(ISOCountry.TJ, "the Republic of Tajikistan")
        self.assertEqual(ISOCountry.TJ, "THE REPUBLIC OF TAJIKISTAN")

        self.assertEqual(ISOCountry.TK, 772)
        self.assertEqual(ISOCountry.TK.label, "Tokelau")
        self.assertEqual(ISOCountry.TK.alpha2, "TK")
        self.assertEqual(ISOCountry.TK.short_name, "Tokelau")
        self.assertEqual(ISOCountry.TK, ISOCountry("Tokelau"))
        self.assertEqual(ISOCountry.TK, "TK")
        self.assertEqual(ISOCountry.TK, "TKL")
        self.assertEqual(ISOCountry.TK, "Tokelau")
        self.assertEqual(ISOCountry.TK, "TOKELAU")
        self.assertEqual(str(ISOCountry.TK), "TK")

        self.assertEqual(ISOCountry.TL, 626)
        self.assertEqual(ISOCountry.TL.label, "Timor-Leste")
        self.assertEqual(ISOCountry.TL.alpha2, "TL")
        self.assertEqual(ISOCountry.TL.short_name, "Timor-Leste")
        self.assertEqual(ISOCountry.TL, ISOCountry("Timor-Leste"))
        self.assertEqual(ISOCountry.TL, "TL")
        self.assertEqual(ISOCountry.TL, "TLS")
        self.assertEqual(ISOCountry.TL, "Timor-Leste")
        self.assertEqual(ISOCountry.TL, "TIMOR-LESTE")
        self.assertEqual(str(ISOCountry.TL), "TL")
        self.assertEqual(ISOCountry.TL, "the Democratic Republic of Timor-Leste")
        self.assertEqual(ISOCountry.TL, "THE DEMOCRATIC REPUBLIC OF TIMOR-LESTE")

        self.assertEqual(ISOCountry.TM, 795)
        self.assertEqual(ISOCountry.TM.label, "Turkmenistan")
        self.assertEqual(ISOCountry.TM.alpha2, "TM")
        self.assertEqual(ISOCountry.TM.short_name, "Turkmenistan")
        self.assertEqual(ISOCountry.TM, ISOCountry("Turkmenistan"))
        self.assertEqual(ISOCountry.TM, "TM")
        self.assertEqual(ISOCountry.TM, "TKM")
        self.assertEqual(ISOCountry.TM, "Turkmenistan")
        self.assertEqual(ISOCountry.TM, "TURKMENISTAN")
        self.assertEqual(str(ISOCountry.TM), "TM")

        self.assertEqual(ISOCountry.TN, 788)
        self.assertEqual(ISOCountry.TN.label, "Tunisia")
        self.assertEqual(ISOCountry.TN.alpha2, "TN")
        self.assertEqual(ISOCountry.TN.short_name, "Tunisia")
        self.assertEqual(ISOCountry.TN, ISOCountry("Tunisia"))
        self.assertEqual(ISOCountry.TN, "TN")
        self.assertEqual(ISOCountry.TN, "TUN")
        self.assertEqual(ISOCountry.TN, "Tunisia")
        self.assertEqual(ISOCountry.TN, "TUNISIA")
        self.assertEqual(str(ISOCountry.TN), "TN")
        self.assertEqual(ISOCountry.TN, "the Republic of Tunisia")
        self.assertEqual(ISOCountry.TN, "THE REPUBLIC OF TUNISIA")

        self.assertEqual(ISOCountry.TO, 776)
        self.assertEqual(ISOCountry.TO.label, "Tonga")
        self.assertEqual(ISOCountry.TO.alpha2, "TO")
        self.assertEqual(ISOCountry.TO.short_name, "Tonga")
        self.assertEqual(ISOCountry.TO, ISOCountry("Tonga"))
        self.assertEqual(ISOCountry.TO, "TO")
        self.assertEqual(ISOCountry.TO, "TON")
        self.assertEqual(ISOCountry.TO, "Tonga")
        self.assertEqual(ISOCountry.TO, "TONGA")
        self.assertEqual(str(ISOCountry.TO), "TO")
        self.assertEqual(ISOCountry.TO, "the Kingdom of Tonga")
        self.assertEqual(ISOCountry.TO, "THE KINGDOM OF TONGA")

        self.assertEqual(ISOCountry.TR, 792)
        self.assertEqual(ISOCountry.TR.label, "Türkiye")
        self.assertEqual(ISOCountry.TR.alpha2, "TR")
        self.assertEqual(ISOCountry.TR.short_name, "Türkiye")
        self.assertEqual(ISOCountry.TR, ISOCountry("Türkiye"))
        self.assertEqual(ISOCountry.TR, "TR")
        self.assertEqual(ISOCountry.TR, "TUR")
        self.assertEqual(ISOCountry.TR, "Türkiye")
        self.assertEqual(ISOCountry.TR, "TÜRKIYE")
        self.assertEqual(str(ISOCountry.TR), "TR")
        self.assertEqual(ISOCountry.TR, "the Republic of Türkiye")
        self.assertEqual(ISOCountry.TR, "THE REPUBLIC OF TÜRKIYE")

        self.assertEqual(ISOCountry.TT, 780)
        self.assertEqual(ISOCountry.TT.label, "Trinidad and Tobago")
        self.assertEqual(ISOCountry.TT.alpha2, "TT")
        self.assertEqual(ISOCountry.TT.short_name, "Trinidad and Tobago")
        self.assertEqual(ISOCountry.TT, ISOCountry("Trinidad and Tobago"))
        self.assertEqual(ISOCountry.TT, "TT")
        self.assertEqual(ISOCountry.TT, "TTO")
        self.assertEqual(ISOCountry.TT, "Trinidad and Tobago")
        self.assertEqual(ISOCountry.TT, "TRINIDAD AND TOBAGO")
        self.assertEqual(str(ISOCountry.TT), "TT")
        self.assertEqual(ISOCountry.TT, "the Republic of Trinidad and Tobago")
        self.assertEqual(ISOCountry.TT, "THE REPUBLIC OF TRINIDAD AND TOBAGO")

        self.assertEqual(ISOCountry.TV, 798)
        self.assertEqual(ISOCountry.TV.label, "Tuvalu")
        self.assertEqual(ISOCountry.TV.alpha2, "TV")
        self.assertEqual(ISOCountry.TV.short_name, "Tuvalu")
        self.assertEqual(ISOCountry.TV, ISOCountry("Tuvalu"))
        self.assertEqual(ISOCountry.TV, "TV")
        self.assertEqual(ISOCountry.TV, "TUV")
        self.assertEqual(ISOCountry.TV, "Tuvalu")
        self.assertEqual(ISOCountry.TV, "TUVALU")
        self.assertEqual(str(ISOCountry.TV), "TV")

        self.assertEqual(ISOCountry.TW, 158)
        self.assertEqual(ISOCountry.TW.label, "Taiwan")
        self.assertEqual(ISOCountry.TW.alpha2, "TW")
        self.assertEqual(ISOCountry.TW.short_name, "Taiwan")
        self.assertEqual(ISOCountry.TW, ISOCountry("Taiwan (Province of China)"))
        self.assertEqual(ISOCountry.TW, "TW")
        self.assertEqual(ISOCountry.TW, "TWN")
        self.assertEqual(ISOCountry.TW, "Taiwan")
        self.assertEqual(ISOCountry.TW, "TAIWAN (PROVINCE OF CHINA)")
        self.assertEqual(str(ISOCountry.TW), "TW")

        self.assertEqual(ISOCountry.TZ, 834)
        self.assertEqual(ISOCountry.TZ.label, "Tanzania, the United Republic of")
        self.assertEqual(ISOCountry.TZ.alpha2, "TZ")
        self.assertEqual(ISOCountry.TZ.short_name, "Tanzania, the United Republic of")
        self.assertEqual(ISOCountry.TZ, ISOCountry("Tanzania, the United Republic of"))
        self.assertEqual(ISOCountry.TZ, "TZ")
        self.assertEqual(ISOCountry.TZ, "TZA")
        self.assertEqual(ISOCountry.TZ, "Tanzania, the United Republic of")
        self.assertEqual(ISOCountry.TZ, "TANZANIA, THE UNITED REPUBLIC OF")
        self.assertEqual(str(ISOCountry.TZ), "TZ")
        self.assertEqual(ISOCountry.TZ, "the United Republic of Tanzania")
        self.assertEqual(ISOCountry.TZ, "THE UNITED REPUBLIC OF TANZANIA")

        self.assertEqual(ISOCountry.UA, 804)
        self.assertEqual(ISOCountry.UA.label, "Ukraine")
        self.assertEqual(ISOCountry.UA.alpha2, "UA")
        self.assertEqual(ISOCountry.UA.short_name, "Ukraine")
        self.assertEqual(ISOCountry.UA, ISOCountry("Ukraine"))
        self.assertEqual(ISOCountry.UA, "UA")
        self.assertEqual(ISOCountry.UA, "UKR")
        self.assertEqual(ISOCountry.UA, "Ukraine")
        self.assertEqual(ISOCountry.UA, "UKRAINE")
        self.assertEqual(str(ISOCountry.UA), "UA")

        self.assertEqual(ISOCountry.UG, 800)
        self.assertEqual(ISOCountry.UG.label, "Uganda")
        self.assertEqual(ISOCountry.UG.alpha2, "UG")
        self.assertEqual(ISOCountry.UG.short_name, "Uganda")
        self.assertEqual(ISOCountry.UG, ISOCountry("Uganda"))
        self.assertEqual(ISOCountry.UG, "UG")
        self.assertEqual(ISOCountry.UG, "UGA")
        self.assertEqual(ISOCountry.UG, "Uganda")
        self.assertEqual(ISOCountry.UG, "UGANDA")
        self.assertEqual(str(ISOCountry.UG), "UG")
        self.assertEqual(ISOCountry.UG, "the Republic of Uganda")
        self.assertEqual(ISOCountry.UG, "THE REPUBLIC OF UGANDA")

        self.assertEqual(ISOCountry.UM, 581)
        self.assertEqual(
            ISOCountry.UM.label, "United States Minor Outlying Islands (the)"
        )
        self.assertEqual(ISOCountry.UM.alpha2, "UM")
        self.assertEqual(
            ISOCountry.UM.short_name, "United States Minor Outlying Islands (the)"
        )
        self.assertEqual(
            ISOCountry.UM, ISOCountry("United States Minor Outlying Islands (the)")
        )
        self.assertEqual(ISOCountry.UM, "UM")
        self.assertEqual(ISOCountry.UM, "UMI")
        self.assertEqual(ISOCountry.UM, "United States Minor Outlying Islands (the)")
        self.assertEqual(ISOCountry.UM, "UNITED STATES MINOR OUTLYING ISLANDS (THE)")
        self.assertEqual(str(ISOCountry.UM), "UM")

        self.assertEqual(ISOCountry.US, 840)
        self.assertEqual(ISOCountry.US.label, "United States of America (the)")
        self.assertEqual(ISOCountry.US.alpha2, "US")
        self.assertEqual(ISOCountry.US.short_name, "United States of America (the)")
        self.assertEqual(ISOCountry.US, ISOCountry("United States of America (the)"))
        self.assertEqual(ISOCountry.US, "US")
        self.assertEqual(ISOCountry.US, "USA")
        self.assertEqual(ISOCountry.US, "United States of America (the)")
        self.assertEqual(ISOCountry.US, "UNITED STATES OF AMERICA (THE)")
        self.assertEqual(str(ISOCountry.US), "US")
        self.assertEqual(ISOCountry.US, "the United States of America")
        self.assertEqual(ISOCountry.US, "THE UNITED STATES OF AMERICA")

        self.assertEqual(ISOCountry.UY, 858)
        self.assertEqual(ISOCountry.UY.label, "Uruguay")
        self.assertEqual(ISOCountry.UY.alpha2, "UY")
        self.assertEqual(ISOCountry.UY.short_name, "Uruguay")
        self.assertEqual(ISOCountry.UY, ISOCountry("Uruguay"))
        self.assertEqual(ISOCountry.UY, "UY")
        self.assertEqual(ISOCountry.UY, "URY")
        self.assertEqual(ISOCountry.UY, "Uruguay")
        self.assertEqual(ISOCountry.UY, "URUGUAY")
        self.assertEqual(str(ISOCountry.UY), "UY")
        self.assertEqual(ISOCountry.UY, "the Eastern Republic of Uruguay")
        self.assertEqual(ISOCountry.UY, "THE EASTERN REPUBLIC OF URUGUAY")

        self.assertEqual(ISOCountry.UZ, 860)
        self.assertEqual(ISOCountry.UZ.label, "Uzbekistan")
        self.assertEqual(ISOCountry.UZ.alpha2, "UZ")
        self.assertEqual(ISOCountry.UZ.short_name, "Uzbekistan")
        self.assertEqual(ISOCountry.UZ, ISOCountry("Uzbekistan"))
        self.assertEqual(ISOCountry.UZ, "UZ")
        self.assertEqual(ISOCountry.UZ, "UZB")
        self.assertEqual(ISOCountry.UZ, "Uzbekistan")
        self.assertEqual(ISOCountry.UZ, "UZBEKISTAN")
        self.assertEqual(str(ISOCountry.UZ), "UZ")
        self.assertEqual(ISOCountry.UZ, "the Republic of Uzbekistan")
        self.assertEqual(ISOCountry.UZ, "THE REPUBLIC OF UZBEKISTAN")

        self.assertEqual(ISOCountry.VA, 336)
        self.assertEqual(ISOCountry.VA.label, "Holy See (the)")
        self.assertEqual(ISOCountry.VA.alpha2, "VA")
        self.assertEqual(ISOCountry.VA.short_name, "Holy See (the)")
        self.assertEqual(ISOCountry.VA, ISOCountry("Holy See (the)"))
        self.assertEqual(ISOCountry.VA, "VA")
        self.assertEqual(ISOCountry.VA, "VAT")
        self.assertEqual(ISOCountry.VA, "Holy See (the)")
        self.assertEqual(ISOCountry.VA, "HOLY SEE (THE)")
        self.assertEqual(str(ISOCountry.VA), "VA")

        self.assertEqual(ISOCountry.VC, 670)
        self.assertEqual(ISOCountry.VC.label, "Saint Vincent and the Grenadines")
        self.assertEqual(ISOCountry.VC.alpha2, "VC")
        self.assertEqual(ISOCountry.VC.short_name, "Saint Vincent and the Grenadines")
        self.assertEqual(ISOCountry.VC, ISOCountry("Saint Vincent and the Grenadines"))
        self.assertEqual(ISOCountry.VC, "VC")
        self.assertEqual(ISOCountry.VC, "VCT")
        self.assertEqual(ISOCountry.VC, "Saint Vincent and the Grenadines")
        self.assertEqual(ISOCountry.VC, "SAINT VINCENT AND THE GRENADINES")
        self.assertEqual(str(ISOCountry.VC), "VC")

        self.assertEqual(ISOCountry.VE, 862)
        self.assertEqual(ISOCountry.VE.label, "Venezuela (Bolivarian Republic of)")
        self.assertEqual(ISOCountry.VE.alpha2, "VE")
        self.assertEqual(ISOCountry.VE.short_name, "Venezuela (Bolivarian Republic of)")
        self.assertEqual(
            ISOCountry.VE, ISOCountry("Venezuela (Bolivarian Republic of)")
        )
        self.assertEqual(ISOCountry.VE, "VE")
        self.assertEqual(ISOCountry.VE, "VEN")
        self.assertEqual(ISOCountry.VE, "Venezuela (Bolivarian Republic of)")
        self.assertEqual(ISOCountry.VE, "VENEZUELA (BOLIVARIAN REPUBLIC OF)")
        self.assertEqual(str(ISOCountry.VE), "VE")
        self.assertEqual(ISOCountry.VE, "the Bolivarian Republic of Venezuela")
        self.assertEqual(ISOCountry.VE, "THE BOLIVARIAN REPUBLIC OF VENEZUELA")

        self.assertEqual(ISOCountry.VG, 92)
        self.assertEqual(ISOCountry.VG.label, "Virgin Islands (British)")
        self.assertEqual(ISOCountry.VG.alpha2, "VG")
        self.assertEqual(ISOCountry.VG.short_name, "Virgin Islands (British)")
        self.assertEqual(ISOCountry.VG, ISOCountry("Virgin Islands (British)"))
        self.assertEqual(ISOCountry.VG, "VG")
        self.assertEqual(ISOCountry.VG, "VGB")
        self.assertEqual(ISOCountry.VG, "Virgin Islands (British)")
        self.assertEqual(ISOCountry.VG, "VIRGIN ISLANDS (BRITISH)")
        self.assertEqual(str(ISOCountry.VG), "VG")
        self.assertEqual(ISOCountry.VG, "British Virgin Islands (the)")
        self.assertEqual(ISOCountry.VG, "BRITISH VIRGIN ISLANDS (THE)")

        self.assertEqual(ISOCountry.VI, 850)
        self.assertEqual(ISOCountry.VI.label, "Virgin Islands (U.S.)")
        self.assertEqual(ISOCountry.VI.alpha2, "VI")
        self.assertEqual(ISOCountry.VI.short_name, "Virgin Islands (U.S.)")
        self.assertEqual(ISOCountry.VI, ISOCountry("Virgin Islands (U.S.)"))
        self.assertEqual(ISOCountry.VI, "VI")
        self.assertEqual(ISOCountry.VI, "VIR")
        self.assertEqual(ISOCountry.VI, "Virgin Islands (U.S.)")
        self.assertEqual(ISOCountry.VI, "VIRGIN ISLANDS (U.S.)")
        self.assertEqual(str(ISOCountry.VI), "VI")
        self.assertEqual(ISOCountry.VI, "the Virgin Islands of the United States")
        self.assertEqual(ISOCountry.VI, "THE VIRGIN ISLANDS OF THE UNITED STATES")

        self.assertEqual(ISOCountry.VN, 704)
        self.assertEqual(ISOCountry.VN.label, "Viet Nam")
        self.assertEqual(ISOCountry.VN.alpha2, "VN")
        self.assertEqual(ISOCountry.VN.short_name, "Viet Nam")
        self.assertEqual(ISOCountry.VN, ISOCountry("Viet Nam"))
        self.assertEqual(ISOCountry.VN, "VN")
        self.assertEqual(ISOCountry.VN, "VNM")
        self.assertEqual(ISOCountry.VN, "Viet Nam")
        self.assertEqual(ISOCountry.VN, "VIET NAM")
        self.assertEqual(str(ISOCountry.VN), "VN")
        self.assertEqual(ISOCountry.VN, "the Socialist Republic of Viet Nam")
        self.assertEqual(ISOCountry.VN, "THE SOCIALIST REPUBLIC OF VIET NAM")

        self.assertEqual(ISOCountry.VU, 548)
        self.assertEqual(ISOCountry.VU.label, "Vanuatu")
        self.assertEqual(ISOCountry.VU.alpha2, "VU")
        self.assertEqual(ISOCountry.VU.short_name, "Vanuatu")
        self.assertEqual(ISOCountry.VU, ISOCountry("Vanuatu"))
        self.assertEqual(ISOCountry.VU, "VU")
        self.assertEqual(ISOCountry.VU, "VUT")
        self.assertEqual(ISOCountry.VU, "Vanuatu")
        self.assertEqual(ISOCountry.VU, "VANUATU")
        self.assertEqual(str(ISOCountry.VU), "VU")
        self.assertEqual(ISOCountry.VU, "the Republic of Vanuatu")
        self.assertEqual(ISOCountry.VU, "THE REPUBLIC OF VANUATU")

        self.assertEqual(ISOCountry.WF, 876)
        self.assertEqual(ISOCountry.WF.label, "Wallis and Futuna")
        self.assertEqual(ISOCountry.WF.alpha2, "WF")
        self.assertEqual(ISOCountry.WF.short_name, "Wallis and Futuna")
        self.assertEqual(ISOCountry.WF, ISOCountry("Wallis and Futuna"))
        self.assertEqual(ISOCountry.WF, "WF")
        self.assertEqual(ISOCountry.WF, "WLF")
        self.assertEqual(ISOCountry.WF, "Wallis and Futuna")
        self.assertEqual(ISOCountry.WF, "WALLIS AND FUTUNA")
        self.assertEqual(str(ISOCountry.WF), "WF")
        self.assertEqual(ISOCountry.WF, "Wallis and Futuna Islands")
        self.assertEqual(ISOCountry.WF, "WALLIS AND FUTUNA ISLANDS")

        self.assertEqual(ISOCountry.WS, 882)
        self.assertEqual(ISOCountry.WS.label, "Samoa")
        self.assertEqual(ISOCountry.WS.alpha2, "WS")
        self.assertEqual(ISOCountry.WS.short_name, "Samoa")
        self.assertEqual(ISOCountry.WS, ISOCountry("Samoa"))
        self.assertEqual(ISOCountry.WS, "WS")
        self.assertEqual(ISOCountry.WS, "WSM")
        self.assertEqual(ISOCountry.WS, "Samoa")
        self.assertEqual(ISOCountry.WS, "SAMOA")
        self.assertEqual(str(ISOCountry.WS), "WS")
        self.assertEqual(ISOCountry.WS, "the Independent State of Samoa")
        self.assertEqual(ISOCountry.WS, "THE INDEPENDENT STATE OF SAMOA")

        self.assertEqual(ISOCountry.YE, 887)
        self.assertEqual(ISOCountry.YE.label, "Yemen")
        self.assertEqual(ISOCountry.YE.alpha2, "YE")
        self.assertEqual(ISOCountry.YE.short_name, "Yemen")
        self.assertEqual(ISOCountry.YE, ISOCountry("Yemen"))
        self.assertEqual(ISOCountry.YE, "YE")
        self.assertEqual(ISOCountry.YE, "YEM")
        self.assertEqual(ISOCountry.YE, "Yemen")
        self.assertEqual(ISOCountry.YE, "YEMEN")
        self.assertEqual(str(ISOCountry.YE), "YE")
        self.assertEqual(ISOCountry.YE, "the Republic of Yemen")
        self.assertEqual(ISOCountry.YE, "THE REPUBLIC OF YEMEN")

        self.assertEqual(ISOCountry.YT, 175)
        self.assertEqual(ISOCountry.YT.label, "Mayotte")
        self.assertEqual(ISOCountry.YT.alpha2, "YT")
        self.assertEqual(ISOCountry.YT.short_name, "Mayotte")
        self.assertEqual(ISOCountry.YT, ISOCountry("Mayotte"))
        self.assertEqual(ISOCountry.YT, "YT")
        self.assertEqual(ISOCountry.YT, "MYT")
        self.assertEqual(ISOCountry.YT, "Mayotte")
        self.assertEqual(ISOCountry.YT, "MAYOTTE")
        self.assertEqual(str(ISOCountry.YT), "YT")

        self.assertEqual(ISOCountry.ZA, 710)
        self.assertEqual(ISOCountry.ZA.label, "South Africa")
        self.assertEqual(ISOCountry.ZA.alpha2, "ZA")
        self.assertEqual(ISOCountry.ZA.short_name, "South Africa")
        self.assertEqual(ISOCountry.ZA, ISOCountry("South Africa"))
        self.assertEqual(ISOCountry.ZA, "ZA")
        self.assertEqual(ISOCountry.ZA, "ZAF")
        self.assertEqual(ISOCountry.ZA, "South Africa")
        self.assertEqual(ISOCountry.ZA, "SOUTH AFRICA")
        self.assertEqual(str(ISOCountry.ZA), "ZA")
        self.assertEqual(ISOCountry.ZA, "the Republic of South Africa")
        self.assertEqual(ISOCountry.ZA, "THE REPUBLIC OF SOUTH AFRICA")

        self.assertEqual(ISOCountry.ZM, 894)
        self.assertEqual(ISOCountry.ZM.label, "Zambia")
        self.assertEqual(ISOCountry.ZM.alpha2, "ZM")
        self.assertEqual(ISOCountry.ZM.short_name, "Zambia")
        self.assertEqual(ISOCountry.ZM, ISOCountry("Zambia"))
        self.assertEqual(ISOCountry.ZM, "ZM")
        self.assertEqual(ISOCountry.ZM, "ZMB")
        self.assertEqual(ISOCountry.ZM, "Zambia")
        self.assertEqual(ISOCountry.ZM, "ZAMBIA")
        self.assertEqual(str(ISOCountry.ZM), "ZM")
        self.assertEqual(ISOCountry.ZM, "the Republic of Zambia")
        self.assertEqual(ISOCountry.ZM, "THE REPUBLIC OF ZAMBIA")

        self.assertEqual(ISOCountry.ZW, 716)
        self.assertEqual(ISOCountry.ZW.label, "Zimbabwe")
        self.assertEqual(ISOCountry.ZW.alpha2, "ZW")
        self.assertEqual(ISOCountry.ZW.short_name, "Zimbabwe")
        self.assertEqual(ISOCountry.ZW, ISOCountry("Zimbabwe"))
        self.assertEqual(ISOCountry.ZW, "ZW")
        self.assertEqual(ISOCountry.ZW, "ZWE")
        self.assertEqual(ISOCountry.ZW, "Zimbabwe")
        self.assertEqual(ISOCountry.ZW, "ZIMBABWE")
        self.assertEqual(str(ISOCountry.ZW), "ZW")
        self.assertEqual(ISOCountry.ZW, "the Republic of Zimbabwe")
        self.assertEqual(ISOCountry.ZW, "THE REPUBLIC OF ZIMBABWE")

    def test_independent(self):
        self.assertEqual(ISOCountry.AD.independent, True)
        self.assertEqual(ISOCountry.AE.independent, True)
        self.assertEqual(ISOCountry.AF.independent, True)
        self.assertEqual(ISOCountry.AG.independent, True)
        self.assertEqual(ISOCountry.AI.independent, False)
        self.assertEqual(ISOCountry.AL.independent, True)
        self.assertEqual(ISOCountry.AM.independent, True)
        self.assertEqual(ISOCountry.AO.independent, True)
        self.assertEqual(ISOCountry.AQ.independent, False)
        self.assertEqual(ISOCountry.AR.independent, True)
        self.assertEqual(ISOCountry.AS.independent, False)
        self.assertEqual(ISOCountry.AT.independent, True)
        self.assertEqual(ISOCountry.AU.independent, True)
        self.assertEqual(ISOCountry.AW.independent, False)
        self.assertEqual(ISOCountry.AX.independent, False)
        self.assertEqual(ISOCountry.AZ.independent, True)
        self.assertEqual(ISOCountry.BA.independent, True)
        self.assertEqual(ISOCountry.BB.independent, True)
        self.assertEqual(ISOCountry.BD.independent, True)
        self.assertEqual(ISOCountry.BE.independent, True)
        self.assertEqual(ISOCountry.BF.independent, True)
        self.assertEqual(ISOCountry.BG.independent, True)
        self.assertEqual(ISOCountry.BH.independent, True)
        self.assertEqual(ISOCountry.BI.independent, True)
        self.assertEqual(ISOCountry.BJ.independent, True)
        self.assertEqual(ISOCountry.BL.independent, False)
        self.assertEqual(ISOCountry.BM.independent, False)
        self.assertEqual(ISOCountry.BN.independent, True)
        self.assertEqual(ISOCountry.BO.independent, True)
        self.assertEqual(ISOCountry.BQ.independent, False)
        self.assertEqual(ISOCountry.BR.independent, True)
        self.assertEqual(ISOCountry.BS.independent, True)
        self.assertEqual(ISOCountry.BT.independent, True)
        self.assertEqual(ISOCountry.BV.independent, False)
        self.assertEqual(ISOCountry.BW.independent, True)
        self.assertEqual(ISOCountry.BY.independent, True)
        self.assertEqual(ISOCountry.BZ.independent, True)
        self.assertEqual(ISOCountry.CA.independent, True)
        self.assertEqual(ISOCountry.CC.independent, False)
        self.assertEqual(ISOCountry.CD.independent, True)
        self.assertEqual(ISOCountry.CF.independent, True)
        self.assertEqual(ISOCountry.CG.independent, True)
        self.assertEqual(ISOCountry.CH.independent, True)
        self.assertEqual(ISOCountry.CI.independent, True)
        self.assertEqual(ISOCountry.CK.independent, False)
        self.assertEqual(ISOCountry.CL.independent, True)
        self.assertEqual(ISOCountry.CM.independent, True)
        self.assertEqual(ISOCountry.CN.independent, True)
        self.assertEqual(ISOCountry.CO.independent, True)
        self.assertEqual(ISOCountry.CR.independent, True)
        self.assertEqual(ISOCountry.CU.independent, True)
        self.assertEqual(ISOCountry.CV.independent, True)
        self.assertEqual(ISOCountry.CW.independent, False)
        self.assertEqual(ISOCountry.CX.independent, False)
        self.assertEqual(ISOCountry.CY.independent, True)
        self.assertEqual(ISOCountry.CZ.independent, True)
        self.assertEqual(ISOCountry.DE.independent, True)
        self.assertEqual(ISOCountry.DJ.independent, True)
        self.assertEqual(ISOCountry.DK.independent, True)
        self.assertEqual(ISOCountry.DM.independent, True)
        self.assertEqual(ISOCountry.DO.independent, True)
        self.assertEqual(ISOCountry.DZ.independent, True)
        self.assertEqual(ISOCountry.EC.independent, True)
        self.assertEqual(ISOCountry.EE.independent, True)
        self.assertEqual(ISOCountry.EG.independent, True)
        self.assertEqual(ISOCountry.EH.independent, False)
        self.assertEqual(ISOCountry.ER.independent, True)
        self.assertEqual(ISOCountry.ES.independent, True)
        self.assertEqual(ISOCountry.ET.independent, True)
        self.assertEqual(ISOCountry.FI.independent, True)
        self.assertEqual(ISOCountry.FJ.independent, True)
        self.assertEqual(ISOCountry.FK.independent, False)
        self.assertEqual(ISOCountry.FM.independent, True)
        self.assertEqual(ISOCountry.FO.independent, False)
        self.assertEqual(ISOCountry.FR.independent, True)
        self.assertEqual(ISOCountry.GA.independent, True)
        self.assertEqual(ISOCountry.GB.independent, True)
        self.assertEqual(ISOCountry.GD.independent, True)
        self.assertEqual(ISOCountry.GE.independent, True)
        self.assertEqual(ISOCountry.GF.independent, False)
        self.assertEqual(ISOCountry.GG.independent, False)
        self.assertEqual(ISOCountry.GH.independent, True)
        self.assertEqual(ISOCountry.GI.independent, False)
        self.assertEqual(ISOCountry.GL.independent, False)
        self.assertEqual(ISOCountry.GM.independent, True)
        self.assertEqual(ISOCountry.GN.independent, True)
        self.assertEqual(ISOCountry.GP.independent, False)
        self.assertEqual(ISOCountry.GQ.independent, True)
        self.assertEqual(ISOCountry.GR.independent, True)
        self.assertEqual(ISOCountry.GS.independent, False)
        self.assertEqual(ISOCountry.GT.independent, True)
        self.assertEqual(ISOCountry.GU.independent, False)
        self.assertEqual(ISOCountry.GW.independent, True)
        self.assertEqual(ISOCountry.GY.independent, True)
        self.assertEqual(ISOCountry.HK.independent, False)
        self.assertEqual(ISOCountry.HM.independent, False)
        self.assertEqual(ISOCountry.HN.independent, True)
        self.assertEqual(ISOCountry.HR.independent, True)
        self.assertEqual(ISOCountry.HT.independent, True)
        self.assertEqual(ISOCountry.HU.independent, True)
        self.assertEqual(ISOCountry.ID.independent, True)
        self.assertEqual(ISOCountry.IE.independent, True)
        self.assertEqual(ISOCountry.IL.independent, True)
        self.assertEqual(ISOCountry.IM.independent, False)
        self.assertEqual(ISOCountry.IN.independent, True)
        self.assertEqual(ISOCountry.IO.independent, False)
        self.assertEqual(ISOCountry.IQ.independent, True)
        self.assertEqual(ISOCountry.IR.independent, True)
        self.assertEqual(ISOCountry.IS.independent, True)
        self.assertEqual(ISOCountry.IT.independent, True)
        self.assertEqual(ISOCountry.JE.independent, False)
        self.assertEqual(ISOCountry.JM.independent, True)
        self.assertEqual(ISOCountry.JO.independent, True)
        self.assertEqual(ISOCountry.JP.independent, True)
        self.assertEqual(ISOCountry.KE.independent, True)
        self.assertEqual(ISOCountry.KG.independent, True)
        self.assertEqual(ISOCountry.KH.independent, True)
        self.assertEqual(ISOCountry.KI.independent, True)
        self.assertEqual(ISOCountry.KM.independent, True)
        self.assertEqual(ISOCountry.KN.independent, True)
        self.assertEqual(ISOCountry.KP.independent, True)
        self.assertEqual(ISOCountry.KR.independent, True)
        self.assertEqual(ISOCountry.KW.independent, True)
        self.assertEqual(ISOCountry.KY.independent, False)
        self.assertEqual(ISOCountry.KZ.independent, True)
        self.assertEqual(ISOCountry.LA.independent, True)
        self.assertEqual(ISOCountry.LB.independent, True)
        self.assertEqual(ISOCountry.LC.independent, True)
        self.assertEqual(ISOCountry.LI.independent, True)
        self.assertEqual(ISOCountry.LK.independent, True)
        self.assertEqual(ISOCountry.LR.independent, True)
        self.assertEqual(ISOCountry.LS.independent, True)
        self.assertEqual(ISOCountry.LT.independent, True)
        self.assertEqual(ISOCountry.LU.independent, True)
        self.assertEqual(ISOCountry.LV.independent, True)
        self.assertEqual(ISOCountry.LY.independent, True)
        self.assertEqual(ISOCountry.MA.independent, True)
        self.assertEqual(ISOCountry.MC.independent, True)
        self.assertEqual(ISOCountry.MD.independent, True)
        self.assertEqual(ISOCountry.ME.independent, True)
        self.assertEqual(ISOCountry.MF.independent, False)
        self.assertEqual(ISOCountry.MG.independent, True)
        self.assertEqual(ISOCountry.MH.independent, True)
        self.assertEqual(ISOCountry.MK.independent, True)
        self.assertEqual(ISOCountry.ML.independent, True)
        self.assertEqual(ISOCountry.MM.independent, True)
        self.assertEqual(ISOCountry.MN.independent, True)
        self.assertEqual(ISOCountry.MO.independent, False)
        self.assertEqual(ISOCountry.MP.independent, False)
        self.assertEqual(ISOCountry.MQ.independent, False)
        self.assertEqual(ISOCountry.MR.independent, True)
        self.assertEqual(ISOCountry.MS.independent, False)
        self.assertEqual(ISOCountry.MT.independent, True)
        self.assertEqual(ISOCountry.MU.independent, True)
        self.assertEqual(ISOCountry.MV.independent, True)
        self.assertEqual(ISOCountry.MW.independent, True)
        self.assertEqual(ISOCountry.MX.independent, True)
        self.assertEqual(ISOCountry.MY.independent, True)
        self.assertEqual(ISOCountry.MZ.independent, True)
        self.assertEqual(ISOCountry.NA.independent, True)
        self.assertEqual(ISOCountry.NC.independent, False)
        self.assertEqual(ISOCountry.NE.independent, True)
        self.assertEqual(ISOCountry.NF.independent, False)
        self.assertEqual(ISOCountry.NG.independent, True)
        self.assertEqual(ISOCountry.NI.independent, True)
        self.assertEqual(ISOCountry.NL.independent, True)
        self.assertEqual(ISOCountry.NO.independent, True)
        self.assertEqual(ISOCountry.NP.independent, True)
        self.assertEqual(ISOCountry.NR.independent, True)
        self.assertEqual(ISOCountry.NU.independent, False)
        self.assertEqual(ISOCountry.NZ.independent, True)
        self.assertEqual(ISOCountry.OM.independent, True)
        self.assertEqual(ISOCountry.PA.independent, True)
        self.assertEqual(ISOCountry.PE.independent, True)
        self.assertEqual(ISOCountry.PF.independent, False)
        self.assertEqual(ISOCountry.PG.independent, True)
        self.assertEqual(ISOCountry.PH.independent, True)
        self.assertEqual(ISOCountry.PK.independent, True)
        self.assertEqual(ISOCountry.PL.independent, True)
        self.assertEqual(ISOCountry.PM.independent, False)
        self.assertEqual(ISOCountry.PN.independent, False)
        self.assertEqual(ISOCountry.PR.independent, False)
        self.assertEqual(ISOCountry.PS.independent, False)
        self.assertEqual(ISOCountry.PT.independent, True)
        self.assertEqual(ISOCountry.PW.independent, True)
        self.assertEqual(ISOCountry.PY.independent, True)
        self.assertEqual(ISOCountry.QA.independent, True)
        self.assertEqual(ISOCountry.RE.independent, False)
        self.assertEqual(ISOCountry.RO.independent, True)
        self.assertEqual(ISOCountry.RS.independent, True)
        self.assertEqual(ISOCountry.RU.independent, True)
        self.assertEqual(ISOCountry.RW.independent, True)
        self.assertEqual(ISOCountry.SA.independent, True)
        self.assertEqual(ISOCountry.SB.independent, True)
        self.assertEqual(ISOCountry.SC.independent, True)
        self.assertEqual(ISOCountry.SD.independent, True)
        self.assertEqual(ISOCountry.SE.independent, True)
        self.assertEqual(ISOCountry.SG.independent, True)
        self.assertEqual(ISOCountry.SH.independent, False)
        self.assertEqual(ISOCountry.SI.independent, True)
        self.assertEqual(ISOCountry.SJ.independent, False)
        self.assertEqual(ISOCountry.SK.independent, True)
        self.assertEqual(ISOCountry.SL.independent, True)
        self.assertEqual(ISOCountry.SM.independent, True)
        self.assertEqual(ISOCountry.SN.independent, True)
        self.assertEqual(ISOCountry.SO.independent, True)
        self.assertEqual(ISOCountry.SR.independent, True)
        self.assertEqual(ISOCountry.SS.independent, True)
        self.assertEqual(ISOCountry.ST.independent, True)
        self.assertEqual(ISOCountry.SV.independent, True)
        self.assertEqual(ISOCountry.SX.independent, False)
        self.assertEqual(ISOCountry.SY.independent, True)
        self.assertEqual(ISOCountry.SZ.independent, True)
        self.assertEqual(ISOCountry.TC.independent, False)
        self.assertEqual(ISOCountry.TD.independent, True)
        self.assertEqual(ISOCountry.TF.independent, False)
        self.assertEqual(ISOCountry.TG.independent, True)
        self.assertEqual(ISOCountry.TH.independent, True)
        self.assertEqual(ISOCountry.TJ.independent, True)
        self.assertEqual(ISOCountry.TK.independent, False)
        self.assertEqual(ISOCountry.TL.independent, True)
        self.assertEqual(ISOCountry.TM.independent, True)
        self.assertEqual(ISOCountry.TN.independent, True)
        self.assertEqual(ISOCountry.TO.independent, True)
        self.assertEqual(ISOCountry.TR.independent, True)
        self.assertEqual(ISOCountry.TT.independent, True)
        self.assertEqual(ISOCountry.TV.independent, True)
        self.assertEqual(ISOCountry.TW.independent, False)
        self.assertEqual(ISOCountry.TZ.independent, True)
        self.assertEqual(ISOCountry.UA.independent, True)
        self.assertEqual(ISOCountry.UG.independent, True)
        self.assertEqual(ISOCountry.UM.independent, False)
        self.assertEqual(ISOCountry.US.independent, True)
        self.assertEqual(ISOCountry.UY.independent, True)
        self.assertEqual(ISOCountry.UZ.independent, True)
        self.assertEqual(ISOCountry.VA.independent, True)
        self.assertEqual(ISOCountry.VC.independent, True)
        self.assertEqual(ISOCountry.VE.independent, True)
        self.assertEqual(ISOCountry.VG.independent, False)
        self.assertEqual(ISOCountry.VI.independent, False)
        self.assertEqual(ISOCountry.VN.independent, True)
        self.assertEqual(ISOCountry.VU.independent, True)
        self.assertEqual(ISOCountry.WF.independent, False)
        self.assertEqual(ISOCountry.WS.independent, True)
        self.assertEqual(ISOCountry.YE.independent, True)
        self.assertEqual(ISOCountry.YT.independent, False)
        self.assertEqual(ISOCountry.ZA.independent, True)
        self.assertEqual(ISOCountry.ZM.independent, True)
        self.assertEqual(ISOCountry.ZW.independent, True)
