"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlobalAuroraRDSSlaveInfra = exports.GlobalAuroraRDSMaster = exports.InstanceTypeEnum = exports.MySQLtimeZone = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const ec2 = require("@aws-cdk/aws-ec2");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const logs = require("@aws-cdk/aws-logs");
const rds = require("@aws-cdk/aws-rds");
const cdk = require("@aws-cdk/core");
const cr = require("@aws-cdk/custom-resources");
var MySQLtimeZone;
(function (MySQLtimeZone) {
    /**
     * TIME ZONE UTC
     */
    MySQLtimeZone["UTC"] = "UTC";
    /**
     * TIME ZONE Asia/Taipei
     */
    MySQLtimeZone["ASIA_TAIPEI"] = "Asia/Taipei";
    /**
     * TIME ZONE Africa/Cairo
     */
    MySQLtimeZone["AFRICA_CAIRO"] = "Africa/Cairo";
    /**
     * TIME ZONE Asia/Bangkok
     */
    MySQLtimeZone["ASIA_BANGKOK"] = "Asia/Bangkok";
    /**
     * TIME ZONE Australia/Darwin
     */
    MySQLtimeZone["AUSTRALIA_DARWIN"] = "Australia/Darwin";
    /**
     * TIME ZONE Africa/Casablanca
     */
    MySQLtimeZone["AFRICA_CASABLANCA"] = "Africa/Casablanca";
    /**
     * TIME ZONE Asia/Beirut
     */
    MySQLtimeZone["ASIA_BEIRUT"] = "Asia/Beirut";
    /**
     * TIME ZONE Australia/Hobart
     */
    MySQLtimeZone["AUSTRALIA_HOBART"] = "Australia/Hobart";
    /**
     * TIME ZONE Africa/Harare
     */
    MySQLtimeZone["AFRICA_HARARE"] = "Africa/Harare";
    /**
     * TIME ZONE Asia/Calcutta
     */
    MySQLtimeZone["ASIA_CALCUTTA"] = "Asia/Calcutta";
    /**
     * TIME ZONE Australia/Perth
     */
    MySQLtimeZone["AUSTRALIA_PERTH"] = "Australia/Perth";
    /**
     * TIME ZONE Africa/Monrovia
     */
    MySQLtimeZone["AFRICA_MONROVIA"] = "Africa/Monrovia";
    /**
     * TIME ZONE Asia/Damascus
     */
    MySQLtimeZone["ASIA_DAMASCUS"] = "Asia/Damascus";
    /**
     * TIME ZONE Australia/Sydney
     */
    MySQLtimeZone["AUSTRALIA_SYDNEY"] = "Australia/Sydney";
    /**
     * TIME ZONE Africa/Nairobi
     */
    MySQLtimeZone["AFRICA_NAIROBI"] = "Africa/Nairobi";
    /**
     * TIME ZONE Asia/Dhaka
     */
    MySQLtimeZone["ASIA_DHAKA"] = "Asia/Dhaka";
    /**
     * TIME ZONE Brazil/East
     */
    MySQLtimeZone["BRAZIL_EAST"] = "Brazil/East";
    /**
     * TIME ZONE Africa/Tripoli
     */
    MySQLtimeZone["AFRICA_TRIPOLI"] = "Africa/Tripoli";
    /**
     * TIME ZONE Asia/Irkutsk
     */
    MySQLtimeZone["ASIA_IRKUTSK"] = "Asia/Irkutsk";
    /**
     * TIME ZONE Canada/Newfoundland
     */
    MySQLtimeZone["CANADA_NEWFOUNDLAND"] = "Canada/Newfoundland";
    /**
     * TIME ZONE Africa/Windhoek
     */
    MySQLtimeZone["AFRICA_WINDHOEK"] = "Africa/Windhoek";
    /**
     * TIME ZONE Asia/Jerusalem
     */
    MySQLtimeZone["ASIA_JERUSALEM"] = "Asia/Jerusalem";
    /**
     * TIME ZONE Canada/Saskatchewan
     */
    MySQLtimeZone["CANADA_SASKATCHEWAN"] = "Canada/Saskatchewan";
    /**
     * TIME ZONE America/Araguaina
     */
    MySQLtimeZone["AMERICA_ARAGUAINA"] = "America/Araguaina";
    /**
     * TIME ZONE Asia/Kabul
     */
    MySQLtimeZone["ASIA_KABUL"] = "Asia/Kabul";
    /**
     * TIME ZONE Europe/Amsterdam
     */
    MySQLtimeZone["EUROPE_AMSTERDAM"] = "Europe/Amsterdam";
    /**
     * TIME ZONE America/Asuncion
     */
    MySQLtimeZone["AMERICA_ASUNCION"] = "America/Asuncion";
    /**
     * TIME ZONE Asia/Karachi
     */
    MySQLtimeZone["ASIA_KARACHI"] = "Asia/Karachi";
    /**
     * TIME ZONE Europe/Athens
     */
    MySQLtimeZone["EUROPE_ATHENS"] = "Europe/Athens";
    /**
     * TIME ZONE America/Bogota
     */
    MySQLtimeZone["AMERICA_BOGOTA"] = "America/Bogota";
    /**
     * TIME ZONE Asia/Kathmandu
     */
    MySQLtimeZone["ASIA_KATHMANDU"] = "Asia/Kathmandu";
    /**
     * TIME ZONE Europe/Dublin
     */
    MySQLtimeZone["EUROPE_DUBLIN"] = "Europe/Dublin";
    /**
     * TIME ZONE America/Caracas
     */
    MySQLtimeZone["AMERICA_CARACAS"] = "America/Caracas";
    /**
    * TIME ZONE Asia/Krasnoyarsk
    */
    MySQLtimeZone["ASIA_KRASNOYARSK"] = "Asia/Krasnoyarsk";
    /**
     * TIME ZONE Europe/Helsinki
     */
    MySQLtimeZone["EUROPE_HELSINKI"] = "Europe/Helsinki";
    /**
     * TIME ZONE America/Chihuahua
     */
    MySQLtimeZone["AMERICA_CHIHUAHUA"] = "America/Chihuahua";
    /**
     * TIME ZONE Asia/Magadan
     */
    MySQLtimeZone["ASIA_MAGADAN"] = "Asia/Magadan";
    /**
     * TIME ZONE Europe/Istanbul
     */
    MySQLtimeZone["EUROPE_ISTANBUL"] = "Europe/Istanbul";
    /**
     * TIME ZONE America/Cuiaba
     */
    MySQLtimeZone["AMERICA_CUIABA"] = "America/Cuiaba";
    /**
     * TIME ZONE Asia/Muscat
     */
    MySQLtimeZone["ASIA_MUSCAT"] = "Asia/Muscat";
    /**
     * TIME ZONE Europe/Kaliningrad
     */
    MySQLtimeZone["EUROPE_KALININGRAD"] = "Europe/Kaliningrad";
    /**
     * TIME ZONE America/Denver
     */
    MySQLtimeZone["AMERICA_DENVER"] = "America/Denver";
    /**
     * TIME ZONE Asia/Novosibirsk
     */
    MySQLtimeZone["ASIA_NOVOSIBIRSK"] = "Asia/Novosibirsk";
    /**
     * TIME ZONE Europe/Moscow'
     */
    MySQLtimeZone["EUROPE_MOSCOW"] = "Europe/Moscow";
    /**
     * TIME ZONE America/Fortaleza
     */
    MySQLtimeZone["AMERICA_FORTALEZA"] = "America/Fortaleza";
    /**
     * TIME ZONE Asia/Riyadh
     */
    MySQLtimeZone["ASIA_RIYADH"] = "Asia/Riyadh";
    /**
     * TIME ZONE Europe/Paris
     */
    MySQLtimeZone["EUROPE_PARIS"] = "Europe/Paris";
    /**
     * TIME ZONE America/Guatemala
     */
    MySQLtimeZone["AMERICA_GUATEMALA"] = "America/Guatemala";
    /**
     * TIME ZONE Asia/Seoul
     */
    MySQLtimeZone["ASIA_SEOUL"] = "Asia/Seoul";
    /**
     * TIME ZONE Europe/Prague
     */
    MySQLtimeZone["EUROPE_PRAGUE"] = "Europe/Prague";
    /**
     * TIME ZONE America/Halifax
     */
    MySQLtimeZone["AMERICA_HALIFAX"] = "America/Halifax";
    /**
     * TIME ZONE Asia/Shanghai
     */
    MySQLtimeZone["ASIA_SHANGHAI"] = "Asia/Shanghai";
    /**
     * TIME ZONE Europe/Sarajevo
     */
    MySQLtimeZone["EUROPE_SARAJEVO"] = "Europe/Sarajevo";
    /**
     * TIME ZONE America/Manaus
     */
    MySQLtimeZone["AMERICA_MANAUS"] = "America/Manaus";
    /**
     * TIME ZONE Asia/Singapore
     */
    MySQLtimeZone["ASIA_SINGAPORE"] = "Asia/Singapore";
    /**
     * TIME ZONE Pacific/Auckland
     */
    MySQLtimeZone["PACIFIC_AUCKLAND"] = "Pacific/Auckland";
    /**
     * TIME ZONE America/Matamoros
     */
    MySQLtimeZone["AMERICA_MATAMOROS"] = "America/Matamoros";
    /**
     * TIME ZONE Pacific/Fiji
     */
    MySQLtimeZone["PACIFIC_FIJI"] = "Pacific/Fiji";
    /**
     * TIME ZONE America/Monterrey
     */
    MySQLtimeZone["AMERICA_MONTERREY"] = "America/Monterrey";
    /**
     * TIME ZONE Asia/Tehran
     */
    MySQLtimeZone["ASIA_TEHRAN"] = "Asia/Tehran";
    /**
     * TIME ZONE Pacific/Guam
     */
    MySQLtimeZone["PACIFIC_GUAM"] = "Pacific/Guam";
    /**
     * TIME ZONE America/Montevideo
     */
    MySQLtimeZone["AMERICA_MONTEVIDEO"] = "America/Montevideo";
    /**
     * TIME ZONE Asia/Tokyo
     */
    MySQLtimeZone["ASIA_TOKYO"] = "Asia/Tokyo";
    /**
     * TIME ZONE Pacific/Honolulu
     */
    MySQLtimeZone["PACIFIC_HONOLULU"] = "Pacific/Honolulu";
    /**
     * TIME ZONE America/Phoenix
     */
    MySQLtimeZone["AMERICA_PHOENIX"] = "America/Phoenix";
    /**
     * TIME ZONE Asia/Ulaanbaatar
     */
    MySQLtimeZone["ASIA_ULAANBAATAR"] = "Asia/Ulaanbaatar";
    /**
     * TIME ZONE Pacific/Samoa
     */
    MySQLtimeZone["PACIFIC_SAMOA"] = "Pacific/Samoa";
    /**
     * TIME ZONE America/Santiago
     */
    MySQLtimeZone["AMERICA_SANTIAGO"] = "America/Santiago";
    /**
     * TIME ZONE Asia/Vladivostok
     */
    MySQLtimeZone["ASIA_VLADIVOSTOK"] = "Asia/Vladivostok";
    /**
     * TIME ZONE US/Alaska
     */
    MySQLtimeZone["US_ALASKA"] = "US/Alaska";
    /**
     * TIME ZONE America/Tijuana
     */
    MySQLtimeZone["AMERICA_TIJUANA"] = "America/Tijuana";
    /**
     * TIME ZONE Asia/Yakutsk
     */
    MySQLtimeZone["ASIA_YAKUTSK"] = "Asia/Yakutsk";
    /**
     * TIME ZONE US/Central
     */
    MySQLtimeZone["US_CENTRAL"] = "US/Central";
    /**
     * TIME ZONE Asia/Amman
     */
    MySQLtimeZone["ASIA_AMMAN"] = "Asia/Amman";
    /**
     * TIME ZONE Asia/Yerevan
     */
    MySQLtimeZone["ASIA_YEREVAN"] = "Asia/Yerevan";
    /**
    * TIME ZONE US/Eastern
    */
    MySQLtimeZone["US_EASTERN"] = "US/Eastern";
    /**
     * TIME ZONE Asia/Ashgabat
     */
    MySQLtimeZone["ASIA_ASHGABAT"] = "Asia/Ashgabat";
    /**
     * TIME ZONE Atlantic/Azores
     */
    MySQLtimeZone["ATLANTIC_AZORES"] = "Atlantic/Azores";
    /**
     * TIME ZONE US/East-Indiana
     */
    MySQLtimeZone["US_EAST_INDIANA"] = "US/East-Indiana";
    /**
     * TIME ZONE Asia/Baghdad
     */
    MySQLtimeZone["ASIA_BAGHDAD"] = "Asia/Baghdad";
    /**
     * TIME ZONE Australia/Adelaide
     */
    MySQLtimeZone["AUSTRALIA_ADELAIDE"] = "Australia/Adelaide";
    /**
     * TIME ZONE US/Pacific
     */
    MySQLtimeZone["US_PACIFIC"] = "US/Pacific";
    /**
     * TIME ZONE Asia/Baku
     */
    MySQLtimeZone["ASIA_BAKU"] = "Asia/Baku";
    /**
     * TIME ZONE Australia/Brisbane
     */
    MySQLtimeZone["AUSTRALIA_BRISBANE"] = "Australia/Brisbane";
})(MySQLtimeZone = exports.MySQLtimeZone || (exports.MySQLtimeZone = {}));
var InstanceTypeEnum;
(function (InstanceTypeEnum) {
    /**
     * db Instance Type r4.large
     */
    InstanceTypeEnum["R4_LARGE"] = "r4.large";
    /**
     * db Instance Type r4.xlarge
     */
    InstanceTypeEnum["R4_XLARGE"] = "r4.xlarge";
    /**
     * db Instance Type r4.2xlarge
     */
    InstanceTypeEnum["R4_2XLARGE"] = "r4.2xlarge";
    /**
     * db Instance Type r4.4xlarge
     */
    InstanceTypeEnum["R4_4XLARGE"] = "r4.4xlarge";
    /**
     * db Instance Type r4.8xlarge
     */
    InstanceTypeEnum["R4_8XLARGE"] = "r4.8xlarge";
    /**
     * db Instance Type r4.16xlarge
     */
    InstanceTypeEnum["R4_16XLARGE"] = "r4.16xlarge";
    /**
     * db Instance Type r5.large
     */
    InstanceTypeEnum["R5_LARGE"] = "r5.large";
    /**
     * db Instance Type r5.xlarge
     */
    InstanceTypeEnum["R5_XLARGE"] = "r5.xlarge";
    /**
     * db Instance Type r5.2xlarge
     */
    InstanceTypeEnum["R5_2XLARGE"] = "r5.2xlarge";
    /**
     * db Instance Type r5.4xlarge
     */
    InstanceTypeEnum["R5_4XLARGE"] = "r5.4xlarge";
    /**
     * db Instance Type r5.8xlarge
     */
    InstanceTypeEnum["R5_8XLARGE"] = "r5.8xlarge";
    /**
     * db Instance Type r5.12xlarge
     */
    InstanceTypeEnum["R5_12XLARGE"] = "r5.12xlarge";
    /**
     * db Instance Type r5.16xlarge
     */
    InstanceTypeEnum["R5_16XLARGE"] = "r5.16xlarge";
    /**
     * db Instance Type r5.24xlarge
     */
    InstanceTypeEnum["R5_24XLARGE"] = "r5.24xlarge";
    /**
     * db Instance Type r6g.large
     */
    InstanceTypeEnum["R6G_LARGE"] = "r6g.large";
    /**
     * db Instance Type r6g.xlarge
     */
    InstanceTypeEnum["R6G_XLARGE"] = "r6g.xlarge";
    /**
     * db Instance Type r6g.2xlarge
     */
    InstanceTypeEnum["R6G_2XLARGE"] = "r6g.2xlarge";
    /**
     * db Instance Type r6g.4xlarge
     */
    InstanceTypeEnum["R6G_4XLARGE"] = "r6g.4xlarge";
    /**
     * db Instance Type r6g.8xlarge
     */
    InstanceTypeEnum["R6G_8XLARGE"] = "r6g.8xlarge";
    /**
     * db Instance Type r6g.12xlarge
     */
    InstanceTypeEnum["R6G_12XLARGE"] = "r6g.12xlarge";
    /**
     * db Instance Type r6g.16xlarge
     */
    InstanceTypeEnum["R6G_16XLARGE"] = "r6g.16xlarge";
})(InstanceTypeEnum = exports.InstanceTypeEnum || (exports.InstanceTypeEnum = {}));
const GlobalAuroraRDSSupportRegion = ['us-east-1', 'us-east-2', 'us-west-1', 'us-west-2', 'eu-west-1', 'eu-west-2', 'eu-west-3', 'eu-central-1',
    'ap-south-1', 'ap-southeast-1', 'ap-southeast-2', 'ap-northeast-1', 'ap-northeast-2', 'ca-central-1'];
class GlobalAuroraRDSMaster extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const stack = cdk.Stack.of(this);
        if (GlobalAuroraRDSSupportRegion.indexOf(stack.region) == -1) {
            throw new Error(`This region ${stack.region} not Support Global RDS !!!`);
        }
        let rdsCredentials;
        if (props?.rdsPassword) {
            rdsCredentials = {
                username: props?.dbUserName ?? 'sysadmin',
                password: cdk.SecretValue.plainText(props?.rdsPassword),
            };
        }
        else {
            rdsCredentials = {
                username: props?.dbUserName ?? 'sysadmin',
            };
        }
        ;
        // Mysql need (MySQL 5.6 / version > 5.6.10a) , Postgres need (version 10.11 , 10.12 , 11.7 or later)
        this.engineVersion = props?.engineVersion ?? rds.DatabaseClusterEngine.auroraMysql({
            version: rds.AuroraMysqlEngineVersion.VER_2_07_1,
        });
        this.rdsInstanceType = props?.instanceType ?? InstanceTypeEnum.R5_LARGE;
        // Master region Vpc
        const rdsVpc = props?.vpc ?? new ec2.Vpc(this, 'RDSVpcRegionMaster', {
            cidr: '10.108.0.0/16',
            enableDnsHostnames: true,
            enableDnsSupport: true,
            natGateways: 1,
        });
        this.dbClusterpPG = props?.dbClusterpPG ?? new rds.ParameterGroup(this, 'dbClusterparametergroup', {
            engine: this.engineVersion,
            parameters: props?.parameters ?? {
                time_zone: props?.timeZone ?? MySQLtimeZone.UTC,
            },
        });
        let rdsVpcSubnetSelect = ec2.SubnetType.PRIVATE;
        if (this.azOfSubnets(rdsVpc.privateSubnets) === 0) {
            rdsVpcSubnetSelect = ec2.SubnetType.PUBLIC;
        }
        this.rdsCluster = new rds.DatabaseCluster(this, 'RDSCluster', {
            engine: this.engineVersion,
            parameterGroup: this.dbClusterpPG,
            clusterIdentifier: `${stack.stackName.toLowerCase()}-primary`,
            credentials: rdsCredentials,
            instances: 1,
            instanceProps: {
                // if want publicAccess , need to define vpcSubnets: { subnetType: ec2.SubnetType.PUBLIC } ,
                vpc: rdsVpc,
                vpcSubnets: { subnetType: rdsVpcSubnetSelect },
                instanceType: new ec2.InstanceType(this.rdsInstanceType),
            },
            removalPolicy: cdk.RemovalPolicy.DESTROY,
            defaultDatabaseName: props?.defaultDatabaseName ?? 'globaldatabase',
        });
        this.rdsPassword = `Please use this command get password back , aws secretsmanager get-secret-value --secret-id ${this.rdsCluster.secret?.secretName}` ?? props?.rdsPassword;
        ;
        this.rdsCluster.node.addDependency(rdsVpc);
        this.rdsCluster.connections.allowDefaultPortFrom(ec2.Peer.ipv4(rdsVpc.vpcCidrBlock));
        // custom resource policy
        const CustomResourcePolicy = new iam.PolicyStatement({
            resources: ['*'],
            actions: ['rds:CreateGlobalCluster', 'rds:DeleteGlobalCluster', 'rds:RemoveFromGlobalCluster', 'rds:ModifyGlobalCluster'],
        });
        // Upgrade database to Global.
        const onEvent = new lambda.Function(this, 'onEventHandler', {
            runtime: lambda.Runtime.PYTHON_3_8,
            code: lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'global_index.on_event',
            timeout: cdk.Duration.minutes(5),
        });
        const UpgradeglobaldbProvider = new cr.Provider(this, 'UpgradeglobaldbProvider', {
            onEventHandler: onEvent,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        this.crGlobalRDSProvider = new cdk.CustomResource(this, 'CRUpgradeglobaldbProvider', {
            resourceType: 'Custom::UpgradeGlobalClusterProvider',
            serviceToken: UpgradeglobaldbProvider.serviceToken,
            properties: {
                SourceDBClusterIdentifier: `arn:aws:rds:${stack.region}:${stack.account}:cluster:${this.rdsCluster.clusterIdentifier}`,
                GlobalClusterIdentifier: `global-${stack.stackName.toLowerCase()}`,
            },
        });
        this.crGlobalRDSProvider.node.addDependency(this.rdsCluster);
        onEvent.role?.addToPrincipalPolicy(CustomResourcePolicy);
        this.rdsIsPublic = rdsVpcSubnetSelect;
        new cdk.CfnOutput(this, 'RDSisPublic', {
            value: this.rdsIsPublic,
        });
        this.rdsClusterarn = `arn:aws:rds:${stack.region}:${stack.account}:cluster:${this.rdsCluster.clusterIdentifier}`;
        new cdk.CfnOutput(this, 'RDSClusterarn', {
            value: this.rdsClusterarn,
        });
        this.globalClusterIdentifier = `global-${stack.stackName.toLowerCase()}`;
        new cdk.CfnOutput(this, 'GlobalClusterIdentifier', {
            value: this.globalClusterIdentifier,
        });
        this.engine = cdk.Token.asString(this.crGlobalRDSProvider.getAtt('Engine'));
        new cdk.CfnOutput(this, 'Engine', {
            value: this.engine,
        });
        this.clusterEngineVersion = cdk.Token.asString(this.crGlobalRDSProvider.getAtt('EngineVersion'));
        new cdk.CfnOutput(this, 'clusterEngineVersion', {
            value: this.clusterEngineVersion,
        });
        this.globalClusterArn = cdk.Token.asString(this.crGlobalRDSProvider.getAtt('GlobalClusterArn'));
        new cdk.CfnOutput(this, 'GlobalClusterArn', {
            value: this.globalClusterArn,
        });
        new cdk.CfnOutput(this, 'GlobalClusterPrimaryEndpoint', {
            value: this.rdsCluster.clusterEndpoint.hostname,
        });
    }
    azOfSubnets(subnets) {
        return new Set(subnets.map(subnet => subnet.availabilityZone)).size;
    }
    addRegionalCluster(scope, id, options) {
        const stack = cdk.Stack.of(scope);
        // custom resource policy
        const CustomResourcePolicy = new iam.PolicyStatement({
            resources: ['*'],
            actions: [
                'rds:CreateGlobalCluster', 'rds:DeleteGlobalCluster', 'rds:RemoveFromGlobalCluster', 'rds:ModifyGlobalCluster',
                'rds:CreateDBCluster', 'rds:CreateDBInstance', 'rds:DeleteDBCluster', 'rds:DeleteDBInstance', 'rds:DescribeDBInstances',
                'rds:DescribeGlobalClusters',
            ],
        });
        // Upgrade database to Global.
        const onEvent = new lambda.Function(scope, `${id}-addRegionalonEvent`, {
            runtime: lambda.Runtime.PYTHON_3_8,
            code: lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'add_region_index.on_event',
            timeout: cdk.Duration.minutes(10),
        });
        const isComplete = new lambda.Function(scope, `${id}-IsComplete`, {
            code: lambda.Code.fromAsset(path.join(__dirname, '../custom-resource-handler')),
            handler: 'add_region_index.is_complete',
            runtime: lambda.Runtime.PYTHON_3_8,
            timeout: cdk.Duration.minutes(10),
            role: onEvent.role,
        });
        const addRegionalProvider = new cr.Provider(scope, `${id}-addRegionalProvider`, {
            onEventHandler: onEvent,
            isCompleteHandler: isComplete,
            logRetention: logs.RetentionDays.ONE_DAY,
        });
        const secondRDSClusterArn = `arn:aws:rds:${options.region}:${stack.account}:cluster:${stack.stackName.toLowerCase()}-${options.region}`;
        const seconddbInstanceIdentifier = `${stack.stackName.toLowerCase()}-${options.region}-1`;
        const CRSecondRDSProvider = new cdk.CustomResource(scope, `${id}-addRegionalCustomResource`, {
            resourceType: 'Custom::addRegionalClusterProvider',
            serviceToken: addRegionalProvider.serviceToken,
            properties: {
                SourceDBClusterIdentifier: this.rdsClusterarn,
                GlobalClusterIdentifier: this.globalClusterIdentifier,
                REGION: options.region,
                DBSubnetGroupName: options.dbSubnetGroupName,
                Engine: this.engine,
                EngineVersion: this.clusterEngineVersion,
                ClusterIdentifier: `${stack.stackName.toLowerCase()}-${options.region}`,
                InstanceType: this.rdsInstanceType,
                rdsIsPublic: this.rdsIsPublic,
                secondRDSClusterArn,
                seconddbInstanceIdentifier,
                securityGroup: options.securityGroupId,
                dbParameterGroup: options.dbParameterGroup,
            },
        });
        CRSecondRDSProvider.node.addDependency(this.crGlobalRDSProvider);
        onEvent.role?.addToPrincipalPolicy(CustomResourcePolicy);
        new cdk.CfnOutput(scope, 'secondRDSClusterArn', {
            value: secondRDSClusterArn,
        });
        new cdk.CfnOutput(scope, 'seconddbInstanceIdentifier', {
            value: seconddbInstanceIdentifier,
        });
    }
}
exports.GlobalAuroraRDSMaster = GlobalAuroraRDSMaster;
_a = JSII_RTTI_SYMBOL_1;
GlobalAuroraRDSMaster[_a] = { fqn: "cdk-aurora-globaldatabase.GlobalAuroraRDSMaster", version: "1.1.439" };
class GlobalAuroraRDSSlaveInfra extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const stack = cdk.Stack.of(this);
        if (GlobalAuroraRDSSupportRegion.indexOf(stack.region) == -1) {
            throw new Error(`This region ${stack.region} not Support Global RDS !!!`);
        }
        // Slave region Vpc
        const rdsVpcSecond = props?.vpc ?? new ec2.Vpc(this, 'RDSVpcRegionSlave', {
            cidr: '10.109.0.0/16',
            enableDnsHostnames: true,
            enableDnsSupport: true,
            natGateways: 1,
        });
        const DBsubnetType = props?.subnetType ?? ec2.SubnetType.PRIVATE;
        if (DBsubnetType === ec2.SubnetType.PUBLIC) {
            const PublicSubnet = rdsVpcSecond.selectSubnets({ subnetType: ec2.SubnetType.PUBLIC });
            this.dbSubnetGroup = new rds.CfnDBSubnetGroup(this, 'Subnets', {
                dbSubnetGroupName: `${stack.stackName.toLowerCase()}-publicsubnetgroup`,
                dbSubnetGroupDescription: 'Public Subnets for database',
                subnetIds: PublicSubnet.subnetIds,
            });
            cdk.Tags.of(this.dbSubnetGroup).add('Name', 'PublicDBSubnetGroup');
            this.dbSubnetGroup.node.addDependency(rdsVpcSecond);
        }
        else {
            const PrivateSubnet = rdsVpcSecond.selectSubnets({ subnetType: ec2.SubnetType.PRIVATE });
            this.dbSubnetGroup = new rds.CfnDBSubnetGroup(this, 'Subnets', {
                dbSubnetGroupName: `${stack.stackName.toLowerCase()}-privatesubnetgroup`,
                dbSubnetGroupDescription: 'Private Subnets for database',
                subnetIds: PrivateSubnet.subnetIds,
            });
            cdk.Tags.of(this.dbSubnetGroup).add('Name', 'PrivateDBSubnetGroup');
            this.dbSubnetGroup.node.addDependency(rdsVpcSecond);
        }
        new cdk.CfnOutput(this, 'newDBSubnetGroup', {
            value: `${this.dbSubnetGroup.dbSubnetGroupName}`,
        });
        new cdk.CfnOutput(this, 'stackRegion', {
            value: `${stack.region}`,
        });
    }
}
exports.GlobalAuroraRDSSlaveInfra = GlobalAuroraRDSSlaveInfra;
_b = JSII_RTTI_SYMBOL_1;
GlobalAuroraRDSSlaveInfra[_b] = { fqn: "cdk-aurora-globaldatabase.GlobalAuroraRDSSlaveInfra", version: "1.1.439" };
//# sourceMappingURL=data:application/json;base64,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