# sciexplorer

A Python package for scientific exploration.

## Installation

You can install sciexplorer using pip:

```bash
pip install sciexplorer
```

For development installation:

```bash
pip install -e ".[dev]"
```

## Usage

```python
import sciexplorer

# Your code here
```

## Features

- Feature 1
- Feature 2
- Feature 3

## Development

### Setup

1. Clone the repository:
```bash
git clone https://github.com/yourusername/sciexplorer.git
cd sciexplorer
```

2. Install development dependencies:
```bash
pip install -e ".[dev]"
```

### Running Tests

```bash
pytest
```

### Code Formatting

```bash
black sciexplorer tests
```

### Type Checking

```bash
mypy sciexplorer
```

## Contributing

Contributions are welcome! Please feel free to submit a Pull Request.

## License

This project is licensed under the MIT License - see the LICENSE file for details.

## Publishing to PyPI

To publish this package to PyPI:

1. Install build tools:
```bash
pip install build twine
```

2. Build the package:
```bash
python -m build
```

3. Upload to TestPyPI (optional, for testing):
```bash
python -m twine upload --repository testpypi dist/*
```

4. Upload to PyPI:
```bash
python -m twine upload dist/*
```

Make sure you have a PyPI account and have configured your credentials before publishing.
