import os
import sys
import typing

from monkay.asgi import Lifespan

from lilya.cli.directives.operations.shell.utils import import_objects
from lilya.cli.terminal import Print
from lilya.conf import settings

printer = Print()


def vi_mode() -> typing.Any:
    editor = os.environ.get("EDITOR")
    if not editor:
        return False
    editor = os.path.basename(editor)
    return editor.startswith("vi") or editor.endswith("vim")


def get_ptpython(app: typing.Any, options: typing.Any = None) -> typing.Any:
    """Gets the PTPython shell.

    Loads the initial configurations from the main lilya settings
    and boots up the kernel.
    """
    try:
        from ptpython.repl import embed, run_config

        async def run_ptpython() -> None:
            imported_objects = import_objects(app)
            history_filename = os.path.expanduser("~/.ptpython_history")

            config_file = os.path.expanduser(settings.ptpython_config_file)
            async with Lifespan(app):
                await embed(
                    globals=imported_objects,
                    history_filename=history_filename,
                    vi_mode=vi_mode(),
                    configure=run_config if os.path.exists(config_file) else None,
                    return_asyncio_coroutine=True,
                )

    except ImportError:
        error = "You must have PTPython installed to run this. Run `pip install ptpython`"
        printer.write_error(error)
        sys.exit(1)

    return run_ptpython
