"""Package-level initialization."""

# -----------------------------------------------------------------------------
# copyright (c) 2023-2025, UChicago Argonne, LLC
#
# Distributed under the terms of the
# Argonne National Laboratory Open Source License.
#
# The full license is in the file LICENSE, distributed with this software.
# -----------------------------------------------------------------------------

import importlib.metadata

__settings_orgName__ = "bluesky"
"""GitHub organization/user name"""

__package_name__ = "hklpy2"
"""GitHub repository name and Python package name."""


def _get_version(version_module=None):
    """
    Return package version.

    Priority:

    1. From ``_version.py`` (generated by ``setuptools_scm``) if exists.
    2. Try ``importlib.metadata.version()``.
    3. Fall back to a safe default.
    """
    # 1) try generated version file (recommended)
    if version_module is not None:
        ver = getattr(version_module, "version", None)
        if ver:
            return ver

    # 2) try importlib.metadata
    try:
        return importlib.metadata.version(__package_name__)
    except Exception:
        pass

    # 3) fallback
    return "0+unknown"


__version__ = _get_version()  # Must define before these imports.
"""Package version string."""

from .backends import SolverBase  # noqa: E402, F401
from .blocks.configure import Configuration  # noqa: E402, F401
from .blocks.lattice import SI_LATTICE_PARAMETER  # noqa: E402, F401
from .diffract import DiffractometerBase  # noqa: E402, F401
from .diffract import creator  # noqa: E402, F401, F403
from .diffract import diffractometer_class_factory  # noqa: E402, F401, F403
from .incident import A_KEV  # noqa: E402, F401
from .misc import SOLVER_ENTRYPOINT_GROUP  # noqa: E402, F401
from .misc import ConfigurationRunWrapper  # noqa: E402, F401
from .misc import SolverError  # noqa: E402, F401
from .misc import get_solver  # noqa: E402, F401
from .misc import solver_factory  # noqa: E402, F401
from .misc import solvers  # noqa: E402, F401

if __name__ == "__main__":
    print(f"Package version: {__version__}")
