import logging

logger = logging.getLogger(__name__)

try:
    from weave.scorers.classification_scorer import MultiTaskBinaryClassificationF1
    from weave.scorers.coherence_scorer import WeaveCoherenceScorerV1
    from weave.scorers.context_relevance_scorer import WeaveContextRelevanceScorerV1
    from weave.scorers.fluency_scorer import WeaveFluencyScorerV1
    from weave.scorers.hallucination_scorer import (
        HallucinationFreeScorer,
        WeaveHallucinationScorerV1,
    )
    from weave.scorers.json_scorer import ValidJSONScorer
    from weave.scorers.llm_as_a_judge_scorer import LLMAsAJudgeScorer
    from weave.scorers.moderation_scorer import (
        OpenAIModerationScorer,
        WeaveBiasScorerV1,
        WeaveToxicityScorerV1,
    )
    from weave.scorers.presidio_guardrail import PresidioScorer
    from weave.scorers.prompt_injection_guardrail import PromptInjectionLLMGuardrail
    from weave.scorers.pydantic_scorer import PydanticScorer
    from weave.scorers.ragas_scorer import (
        ContextEntityRecallScorer,
        ContextRelevancyScorer,
    )
    from weave.scorers.scorer_types import LLMScorer
    from weave.scorers.similarity_scorer import EmbeddingSimilarityScorer
    from weave.scorers.string_scorer import LevenshteinScorer, StringMatchScorer
    from weave.scorers.summarization_scorer import SummarizationScorer
    from weave.scorers.trust_scorer import WeaveTrustScorerV1
    from weave.scorers.xml_scorer import ValidXMLScorer
except ModuleNotFoundError as e:
    raise ImportError(
        "Scorer dependencies are missing.  Please install them with `pip install weave[scorers]`"
    ) from e

__all__ = [
    "ContextEntityRecallScorer",
    "ContextRelevancyScorer",
    "EmbeddingSimilarityScorer",
    "HallucinationFreeScorer",
    "LLMAsAJudgeScorer",
    "LLMScorer",
    "LevenshteinScorer",
    "LevenshteinScorer",
    "MultiTaskBinaryClassificationF1",
    "OpenAIModerationScorer",
    "PresidioScorer",
    "PromptInjectionLLMGuardrail",
    "PydanticScorer",
    "StringMatchScorer",
    "SummarizationScorer",
    "ValidJSONScorer",
    "ValidXMLScorer",
    "WeaveBiasScorerV1",
    "WeaveCoherenceScorerV1",
    "WeaveContextRelevanceScorerV1",
    "WeaveFluencyScorerV1",
    "WeaveHallucinationScorerV1",
    "WeaveToxicityScorerV1",
    "WeaveTrustScorerV1",
]
