# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.2.1
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from uuid import UUID
from authentik_client.models.country_code_enum import CountryCodeEnum
from authentik_client.models.detailed_country_field import DetailedCountryField
from typing import Optional, Set
from typing_extensions import Self

class GeoIPPolicy(BaseModel):
    """
    GeoIP Policy Serializer
    """ # noqa: E501
    pk: UUID
    name: StrictStr
    execution_logging: Optional[StrictBool] = Field(default=None, description="When this option is enabled, all executions of this policy will be logged. By default, only execution errors are logged.")
    component: StrictStr = Field(description="Get object component so that we know how to edit the object")
    verbose_name: StrictStr = Field(description="Return object's verbose_name")
    verbose_name_plural: StrictStr = Field(description="Return object's plural verbose_name")
    meta_model_name: StrictStr = Field(description="Return internal model name")
    bound_to: StrictInt = Field(description="Return objects policy is bound to")
    asns: Optional[List[Annotated[int, Field(le=2147483647, strict=True, ge=-2147483648)]]] = None
    countries: Annotated[List[CountryCodeEnum], Field(max_length=249)]
    countries_obj: List[DetailedCountryField]
    check_history_distance: Optional[StrictBool] = None
    history_max_distance_km: Optional[Annotated[int, Field(le=9223372036854775807, strict=True, ge=0)]] = None
    distance_tolerance_km: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=0)]] = None
    history_login_count: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=0)]] = None
    check_impossible_travel: Optional[StrictBool] = None
    impossible_tolerance_km: Optional[Annotated[int, Field(le=2147483647, strict=True, ge=0)]] = None
    __properties: ClassVar[List[str]] = ["pk", "name", "execution_logging", "component", "verbose_name", "verbose_name_plural", "meta_model_name", "bound_to", "asns", "countries", "countries_obj", "check_history_distance", "history_max_distance_km", "distance_tolerance_km", "history_login_count", "check_impossible_travel", "impossible_tolerance_km"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GeoIPPolicy from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "pk",
            "component",
            "verbose_name",
            "verbose_name_plural",
            "meta_model_name",
            "bound_to",
            "countries_obj",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in countries_obj (list)
        _items = []
        if self.countries_obj:
            for _item_countries_obj in self.countries_obj:
                if _item_countries_obj:
                    _items.append(_item_countries_obj.to_dict())
            _dict['countries_obj'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GeoIPPolicy from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pk": obj.get("pk"),
            "name": obj.get("name"),
            "execution_logging": obj.get("execution_logging"),
            "component": obj.get("component"),
            "verbose_name": obj.get("verbose_name"),
            "verbose_name_plural": obj.get("verbose_name_plural"),
            "meta_model_name": obj.get("meta_model_name"),
            "bound_to": obj.get("bound_to"),
            "asns": obj.get("asns"),
            "countries": obj.get("countries"),
            "countries_obj": [DetailedCountryField.from_dict(_item) for _item in obj["countries_obj"]] if obj.get("countries_obj") is not None else None,
            "check_history_distance": obj.get("check_history_distance"),
            "history_max_distance_km": obj.get("history_max_distance_km"),
            "distance_tolerance_km": obj.get("distance_tolerance_km"),
            "history_login_count": obj.get("history_login_count"),
            "check_impossible_travel": obj.get("check_impossible_travel"),
            "impossible_tolerance_km": obj.get("impossible_tolerance_km")
        })
        return _obj


