# coding: utf-8

"""
    authentik

    Making authentication simple.

    The version of the OpenAPI document: 2025.2.1
    Contact: hello@goauthentik.io
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from uuid import UUID
from authentik_client.models.proxy_mode import ProxyMode
from authentik_client.models.redirect_uri import RedirectURI
from typing import Optional, Set
from typing_extensions import Self

class ProxyProvider(BaseModel):
    """
    ProxyProvider Serializer
    """ # noqa: E501
    pk: StrictInt
    name: StrictStr
    authentication_flow: Optional[UUID] = Field(default=None, description="Flow used for authentication when the associated application is accessed by an un-authenticated user.")
    authorization_flow: UUID = Field(description="Flow used when authorizing this provider.")
    invalidation_flow: UUID = Field(description="Flow used ending the session from a provider.")
    property_mappings: Optional[List[UUID]] = None
    component: StrictStr = Field(description="Get object component so that we know how to edit the object")
    assigned_application_slug: StrictStr = Field(description="Internal application name, used in URLs.")
    assigned_application_name: StrictStr = Field(description="Application's display Name.")
    assigned_backchannel_application_slug: StrictStr = Field(description="Internal application name, used in URLs.")
    assigned_backchannel_application_name: StrictStr = Field(description="Application's display Name.")
    verbose_name: StrictStr = Field(description="Return object's verbose_name")
    verbose_name_plural: StrictStr = Field(description="Return object's plural verbose_name")
    meta_model_name: StrictStr = Field(description="Return internal model name")
    client_id: StrictStr
    internal_host: Optional[StrictStr] = None
    external_host: StrictStr
    internal_host_ssl_validation: Optional[StrictBool] = Field(default=None, description="Validate SSL Certificates of upstream servers")
    certificate: Optional[UUID] = None
    skip_path_regex: Optional[StrictStr] = Field(default=None, description="Regular expressions for which authentication is not required. Each new line is interpreted as a new Regular Expression.")
    basic_auth_enabled: Optional[StrictBool] = Field(default=None, description="Set a custom HTTP-Basic Authentication header based on values from authentik.")
    basic_auth_password_attribute: Optional[StrictStr] = Field(default=None, description="User/Group Attribute used for the password part of the HTTP-Basic Header.")
    basic_auth_user_attribute: Optional[StrictStr] = Field(default=None, description="User/Group Attribute used for the user part of the HTTP-Basic Header. If not set, the user's Email address is used.")
    mode: Optional[ProxyMode] = Field(default=None, description="Enable support for forwardAuth in traefik and nginx auth_request. Exclusive with internal_host.")
    intercept_header_auth: Optional[StrictBool] = Field(default=None, description="When enabled, this provider will intercept the authorization header and authenticate requests based on its value.")
    redirect_uris: List[RedirectURI]
    cookie_domain: Optional[StrictStr] = None
    jwt_federation_sources: Optional[List[UUID]] = None
    jwt_federation_providers: Optional[List[StrictInt]] = None
    access_token_validity: Optional[StrictStr] = Field(default=None, description="Tokens not valid on or after current time + this value (Format: hours=1;minutes=2;seconds=3).")
    refresh_token_validity: Optional[StrictStr] = Field(default=None, description="Tokens not valid on or after current time + this value (Format: hours=1;minutes=2;seconds=3).")
    outpost_set: List[StrictStr]
    __properties: ClassVar[List[str]] = ["pk", "name", "authentication_flow", "authorization_flow", "invalidation_flow", "property_mappings", "component", "assigned_application_slug", "assigned_application_name", "assigned_backchannel_application_slug", "assigned_backchannel_application_name", "verbose_name", "verbose_name_plural", "meta_model_name", "client_id", "internal_host", "external_host", "internal_host_ssl_validation", "certificate", "skip_path_regex", "basic_auth_enabled", "basic_auth_password_attribute", "basic_auth_user_attribute", "mode", "intercept_header_auth", "redirect_uris", "cookie_domain", "jwt_federation_sources", "jwt_federation_providers", "access_token_validity", "refresh_token_validity", "outpost_set"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProxyProvider from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "pk",
            "component",
            "assigned_application_slug",
            "assigned_application_name",
            "assigned_backchannel_application_slug",
            "assigned_backchannel_application_name",
            "verbose_name",
            "verbose_name_plural",
            "meta_model_name",
            "client_id",
            "redirect_uris",
            "outpost_set",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in redirect_uris (list)
        _items = []
        if self.redirect_uris:
            for _item_redirect_uris in self.redirect_uris:
                if _item_redirect_uris:
                    _items.append(_item_redirect_uris.to_dict())
            _dict['redirect_uris'] = _items
        # set to None if authentication_flow (nullable) is None
        # and model_fields_set contains the field
        if self.authentication_flow is None and "authentication_flow" in self.model_fields_set:
            _dict['authentication_flow'] = None

        # set to None if certificate (nullable) is None
        # and model_fields_set contains the field
        if self.certificate is None and "certificate" in self.model_fields_set:
            _dict['certificate'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProxyProvider from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "pk": obj.get("pk"),
            "name": obj.get("name"),
            "authentication_flow": obj.get("authentication_flow"),
            "authorization_flow": obj.get("authorization_flow"),
            "invalidation_flow": obj.get("invalidation_flow"),
            "property_mappings": obj.get("property_mappings"),
            "component": obj.get("component"),
            "assigned_application_slug": obj.get("assigned_application_slug"),
            "assigned_application_name": obj.get("assigned_application_name"),
            "assigned_backchannel_application_slug": obj.get("assigned_backchannel_application_slug"),
            "assigned_backchannel_application_name": obj.get("assigned_backchannel_application_name"),
            "verbose_name": obj.get("verbose_name"),
            "verbose_name_plural": obj.get("verbose_name_plural"),
            "meta_model_name": obj.get("meta_model_name"),
            "client_id": obj.get("client_id"),
            "internal_host": obj.get("internal_host"),
            "external_host": obj.get("external_host"),
            "internal_host_ssl_validation": obj.get("internal_host_ssl_validation"),
            "certificate": obj.get("certificate"),
            "skip_path_regex": obj.get("skip_path_regex"),
            "basic_auth_enabled": obj.get("basic_auth_enabled"),
            "basic_auth_password_attribute": obj.get("basic_auth_password_attribute"),
            "basic_auth_user_attribute": obj.get("basic_auth_user_attribute"),
            "mode": obj.get("mode"),
            "intercept_header_auth": obj.get("intercept_header_auth"),
            "redirect_uris": [RedirectURI.from_dict(_item) for _item in obj["redirect_uris"]] if obj.get("redirect_uris") is not None else None,
            "cookie_domain": obj.get("cookie_domain"),
            "jwt_federation_sources": obj.get("jwt_federation_sources"),
            "jwt_federation_providers": obj.get("jwt_federation_providers"),
            "access_token_validity": obj.get("access_token_validity"),
            "refresh_token_validity": obj.get("refresh_token_validity"),
            "outpost_set": obj.get("outpost_set")
        })
        return _obj


