import { aws_events as events } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * @stability stable
 */
export interface OnDeployProps {
    /**
     * The number of minutes to add to the current time when generating the expression.
     *
     * Should exceed the expected time for the appropriate resources to converge.
     *
     * @default 10
     * @stability stable
     */
    readonly offsetMinutes?: number;
}
/**
 * @stability stable
 */
export interface AtProps {
    /**
     * The future date to use for one time event.
     *
     * @stability stable
     */
    readonly date: Date;
}
export declare function dateToCron(date: Date): string;
/**
 * @stability stable
 */
export declare class OnDeploy extends Construct {
    /**
     * @stability stable
     */
    readonly schedule: events.Schedule;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: OnDeployProps);
}
/**
 * @stability stable
 */
export declare class At extends Construct {
    /**
     * @stability stable
     */
    readonly schedule: events.Schedule;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: AtProps);
}
