"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.At = exports.OnDeploy = exports.dateToCron = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
function dateToCron(date) {
    const minutes = date.getUTCMinutes();
    const hours = date.getUTCHours();
    const days = date.getUTCDay();
    const months = date.getUTCMonth() + 1;
    const years = date.getUTCFullYear();
    return `${minutes} ${hours} ${days} ${months} ? ${years}`;
}
exports.dateToCron = dateToCron;
;
/**
 * @stability stable
 */
class OnDeploy extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        const date = new Date();
        const minutesToAdd = props.offsetMinutes || 10;
        const future = new Date(date.getTime() + minutesToAdd * 60000);
        this.schedule = aws_cdk_lib_1.aws_events.Schedule.expression('cron(' + dateToCron(future) + ')');
    }
}
exports.OnDeploy = OnDeploy;
_a = JSII_RTTI_SYMBOL_1;
OnDeploy[_a] = { fqn: "@renovosolutions/cdk-library-one-time-event.OnDeploy", version: "2.0.20" };
/**
 * @stability stable
 */
class At extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.schedule = aws_cdk_lib_1.aws_events.Schedule.expression('cron(' + dateToCron(props.date) + ')');
    }
}
exports.At = At;
_b = JSII_RTTI_SYMBOL_1;
At[_b] = { fqn: "@renovosolutions/cdk-library-one-time-event.At", version: "2.0.20" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw2Q0FBbUQ7QUFDbkQsMkNBQXVDO0FBWXZDLFNBQWdCLFVBQVUsQ0FBQyxJQUFTO0lBQ2xDLE1BQU0sT0FBTyxHQUFHLElBQUksQ0FBQyxhQUFhLEVBQUUsQ0FBQztJQUNyQyxNQUFNLEtBQUssR0FBRyxJQUFJLENBQUMsV0FBVyxFQUFFLENBQUM7SUFDakMsTUFBTSxJQUFJLEdBQUcsSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDO0lBQzlCLE1BQU0sTUFBTSxHQUFHLElBQUksQ0FBQyxXQUFXLEVBQUUsR0FBRyxDQUFDLENBQUM7SUFDdEMsTUFBTSxLQUFLLEdBQUcsSUFBSSxDQUFDLGNBQWMsRUFBRSxDQUFDO0lBRXBDLE9BQU8sR0FBRyxPQUFPLElBQUksS0FBSyxJQUFJLElBQUksSUFBSSxNQUFNLE1BQU0sS0FBSyxFQUFFLENBQUM7QUFDNUQsQ0FBQztBQVJELGdDQVFDO0FBQUEsQ0FBQzs7OztBQUVGLE1BQWEsUUFBUyxTQUFRLHNCQUFTOzs7O0lBSXJDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBb0I7UUFDNUQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLElBQUksR0FBRyxJQUFJLElBQUksRUFBRSxDQUFDO1FBQ3hCLE1BQU0sWUFBWSxHQUFHLEtBQUssQ0FBQyxhQUFhLElBQUksRUFBRSxDQUFDO1FBQy9DLE1BQU0sTUFBTSxHQUFHLElBQUksSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsR0FBRyxZQUFZLEdBQUcsS0FBSyxDQUFDLENBQUM7UUFFL0QsSUFBSSxDQUFDLFFBQVEsR0FBRyx3QkFBTSxDQUFDLFFBQVEsQ0FBQyxVQUFVLENBQUMsT0FBTyxHQUFHLFVBQVUsQ0FBQyxNQUFNLENBQUMsR0FBRyxHQUFHLENBQUMsQ0FBQztJQUNqRixDQUFDOztBQVpILDRCQWFDOzs7Ozs7QUFFRCxNQUFhLEVBQUcsU0FBUSxzQkFBUzs7OztJQUkvQixZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQWM7UUFDdEQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixJQUFJLENBQUMsUUFBUSxHQUFHLHdCQUFNLENBQUMsUUFBUSxDQUFDLFVBQVUsQ0FBQyxPQUFPLEdBQUcsVUFBVSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsR0FBRyxHQUFHLENBQUMsQ0FBQztJQUNyRixDQUFDOztBQVJILGdCQVNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgYXdzX2V2ZW50cyBhcyBldmVudHMgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuZXhwb3J0IGludGVyZmFjZSBPbkRlcGxveVByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBvZmZzZXRNaW51dGVzPzogbnVtYmVyO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIEF0UHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGF0ZTogRGF0ZTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGRhdGVUb0Nyb24oZGF0ZTpEYXRlKSB7XG4gIGNvbnN0IG1pbnV0ZXMgPSBkYXRlLmdldFVUQ01pbnV0ZXMoKTtcbiAgY29uc3QgaG91cnMgPSBkYXRlLmdldFVUQ0hvdXJzKCk7XG4gIGNvbnN0IGRheXMgPSBkYXRlLmdldFVUQ0RheSgpO1xuICBjb25zdCBtb250aHMgPSBkYXRlLmdldFVUQ01vbnRoKCkgKyAxO1xuICBjb25zdCB5ZWFycyA9IGRhdGUuZ2V0VVRDRnVsbFllYXIoKTtcblxuICByZXR1cm4gYCR7bWludXRlc30gJHtob3Vyc30gJHtkYXlzfSAke21vbnRoc30gPyAke3llYXJzfWA7XG59O1xuXG5leHBvcnQgY2xhc3MgT25EZXBsb3kgZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuXG4gIHB1YmxpYyByZWFkb25seSBzY2hlZHVsZTogZXZlbnRzLlNjaGVkdWxlO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBPbkRlcGxveVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGNvbnN0IGRhdGUgPSBuZXcgRGF0ZSgpO1xuICAgIGNvbnN0IG1pbnV0ZXNUb0FkZCA9IHByb3BzLm9mZnNldE1pbnV0ZXMgfHwgMTA7XG4gICAgY29uc3QgZnV0dXJlID0gbmV3IERhdGUoZGF0ZS5nZXRUaW1lKCkgKyBtaW51dGVzVG9BZGQgKiA2MDAwMCk7XG5cbiAgICB0aGlzLnNjaGVkdWxlID0gZXZlbnRzLlNjaGVkdWxlLmV4cHJlc3Npb24oJ2Nyb24oJyArIGRhdGVUb0Nyb24oZnV0dXJlKSArICcpJyk7XG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIEF0IGV4dGVuZHMgQ29uc3RydWN0IHtcblxuICBwdWJsaWMgcmVhZG9ubHkgc2NoZWR1bGU6IGV2ZW50cy5TY2hlZHVsZTtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogQXRQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICB0aGlzLnNjaGVkdWxlID0gZXZlbnRzLlNjaGVkdWxlLmV4cHJlc3Npb24oJ2Nyb24oJyArIGRhdGVUb0Nyb24ocHJvcHMuZGF0ZSkgKyAnKScpO1xuICB9XG59XG4iXX0=