#|
#|  Copyright The Telepact Authors
#|
#|  Licensed under the Apache License, Version 2.0 (the "License");
#|  you may not use this file except in compliance with the License.
#|  You may obtain a copy of the License at
#|
#|  https://www.apache.org/licenses/LICENSE-2.0
#|
#|  Unless required by applicable law or agreed to in writing, software
#|  distributed under the License is distributed on an "AS IS" BASIS,
#|  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#|  See the License for the specific language governing permissions and
#|  limitations under the License.
#|

class BinaryEncoding:
    def __init__(self, binary_encoding_map: dict[str, int], checksum: int) -> None:
        self.encode_map: dict[str, int] = binary_encoding_map
        self.decode_map: dict[int, str] = {
            v: k for k, v in binary_encoding_map.items()}
        self.checksum: int = checksum
