# Configuration file for the Sphinx documentation builder.
#
# For the full list of built-in configuration values, see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Project information -----------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#project-information

import sys
import os

sys.path.insert(0, os.path.abspath('../..'))
from cace import __version__

project = 'CACE'
copyright = '2025, CACE Contributors'
author = 'Tim Edwards, Leo Moser'
release = __version__

# -- General configuration ---------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#general-configuration

extensions = ['myst_parser']

source_suffix = {
    '.md': 'markdown',
    '.rst': 'restructuredtext',
}

templates_path = ['_templates']
exclude_patterns = []


# -- Options for HTML output -------------------------------------------------
# https://www.sphinx-doc.org/en/master/usage/configuration.html#options-for-html-output
html_title = 'CACE Documentation'
html_theme = 'furo'
html_static_path = ['_static']

# Auto-generated header anchors.
# https://myst-parser.readthedocs.io/en/stable/syntax/optional.html#syntax-header-anchors
myst_heading_anchors = 2
