# Datasheet Format

```{note}
Prior to June 2024 CACE used the datasheet version 4.0 text format. This format is now deprecated, please export your datasheet in the new YAML format.
```

The CACE datasheet contains the specification of your design and other important information. It acts as both documentation for the specifiaction but also as input for CACE. 

The following sections describe the structure of the datasheet.

## Metadata

Example entry:

```yaml
name: ota-5t
description: A simple 5 transistor OTA
PDK: sky130A
cace_format: 5.0
```

- `name:	<string>`
    > Name of the design (cell name)

- `description:	<string>`
    > Description of the design

- `PDK:	<string>`
    > Name of the PDK (no spaces)

- `cace_format:	<string>`
    > Format version of the datasheet. Current version: `5.2`.

## Authorship

Example entry:

```yaml
authorship:
  designer: Leo Moser
  company: Efabless
  creation_date: May 27, 2024
  license: Apache 2.0
```

- `designer: <string>`
    > The person to whom the design is attributed.

- `company:	<string>` (optional)
    > The name of a company, if applicable.

- `institution:	<string>` (optional)
    > The name of an institution, if applicable.

- `email: <string>` (optional)
    > E-mail for contact information.

- `creation_date: <datestamp>`
    > Date that the CACE setup was made, or any meaningful date
    for the creation of the design.

- `modification_date: <datestamp>`
    > Generally handled by the tools to specify when the characterization
    file was last updated.

- `license:	<string>`
    > A known license type, such as "Apache 2.0".

## Paths

The paths section is used to tell CACE where to find certain files of your design or where to generate files for simulation.

Example entry:

```yaml
paths:
  root: ..
  schematic: xschem
  layout: gds
  netlist: netlist
  documentation: doc
```

- `root: <path>`
	> This is the location of the project and the root of all the other
	paths in this dictionary. Normally it is set to `..` to refer to the parent directory of `cace/`.

- `schematic: <path>`
	> Location of any schematics (xschem) and symbols for the design. The xschemrc should be located here.

- `magic: <path>` (optional)
	> Location of any layout in magic (.mag) format.

- `layout: <path>`
	> Location of any layout in GDS (.gds or .gds.gz) format. Note that any magic layout (if given) will be converted to GDS and saved here.

- `netlist:	<path>`
	> Location of all SPICE netlists.
	This netlist is usually automatically generated by cace, with subdirectories for each netlist type according to the netlist	source (see `--source` option):  "schematic", "layout" (for LVS), "pex" (C-parasitic extracted layout), and "rcx" (R-C-parasitic	extracted layout).

- `documentation: <path>`
    > Location for the auto-generated documentation of the design.

- `runs: <path>` (optional)
	> Location for the run directory.

## Pins

The pins of the design, mainly used for documentation purposes. The names of the pins are checked against the schematic.

Example entry:

```yaml
pins:
  VDD:
    description: Power supply
    direction: inout
    type: power
    Vmin: 1.7
    Vmax: 1.9
    Imin: 0
    Imax: 0.01
  ...
```

- `name:	<string>`
	> The pin name.  Must match the name on the schematic or netlist.
	Vectors should be indexed with ":" and will be expanded when
	needed.  "b7:0" expands to "b7, b6, b5, ..." while "b[7:0]"
	expands to "b[7], b[6], b[5], ..." (Note that this is more
	flexible than the convention for condition names described
	below.)

- `description:	<string>`
	> Text description of the pin. May contain spaces.

- `type:	<string>`
	> The type may be one of "digital", "signal", "power", or "ground".
	
- `direction:	<string>`
	> The direction may be one of "input", "output", or "inout".

- `Vmin:	<number>|<expression>`
	> The pin minimum voltage may be a value or may be referenced to
	another pin;  and may be referenced to another pin with an offset
	(e.g., "vss - 0.3").

- `Vmax:	<number>|<expression>`
	> The pin maximum voltage may be a value or may be referenced to
	another pin;  and may be referenced to another pin with an offset
	(e.g., "vdd + 0.3").

- `Imin:	<number>|<expression>`
	> The pin maximum sink current -a minimum value if specified as
    a negative current- may be a value or may be referenced to another
    pin; and may be referenced to another pin with an offset. 

- `Imax:	<number>|<expression>`
	> The pin maximum source current may be a value or may be referenced to
	another pin;  and may be referenced to another pin with an offset. 

## Default Conditions

The default conditions under which to evaluate the parameters.

Example entry:

```yaml
default_conditions:
  corner:
    display: Corner
    description: The corner of the wafer
    typical: tt
    unit: V
  ...
```

- `name: <string>`
	> The name of the condition;  this name is meaningful because it
	will match a variable name used in a schematic or netlist.  The
	representation in the netlist is always ${<string>} to prevent
	accidental substitutions of matching strings.  Any set of signals
	can be bundled, but the delimiters for the bundle must be brackets;
	e.g., b[7:0], with single bits called out as, e.g., b[0].

- `description: <string>`
	> A description of the condition.

- `display: <string>`
	> A short, typically one-word value to display for the condition.

- `unit: <string>`
	> The unit of measure used to display the condition value.

- `typical: <value>`
	> If present, the default typical value of the condition.

- `maximum: <value>`
	> If present, the default maximum value of the condition.

- `minimum: <value>`
	> If present, the default minimum value of the condition.

- `enumerate: <values>`
	> If present, instead of min/typ/max values, the values are
	enumerated from a space-separated list supplied in <values>
	(see above; long lists may be backslash-newline terminated).

- `step: linear|logarithmic`
	> If not present, then only values min/typ/max are evaluated.
	If present, then values are automatically enumerated from
	min to max inclusive either in linear (default) or logarithmic
	progression.  If typ exists and is not in the enumeration,
	then it is evaluated in addition.

- `stepsize: <value>`
	> If not present, then a stepsize of 1 is assumed for linear
	enumeration or 2 for logarithmic enumeration.  Otherwise,
	the enumeration steps by <value> additive values for linear
	enumeration or <value> multiplicative values for logarithmic
	enumeration.

## Parameters

Example entry:

```yaml
parameters:
  dc_params:
    spec:
      a0:
        display: DC gain
        description: The DC gain of the OTA
        unit: V/V
        minimum:
          value: 50
        typical:
          value: any
        maximum:
          value: any
      ugf:
        display: Unity Gain Frequency
        description: The unity gain frequency of the OTA
        unit: Hz
        minimum:
          value: 1e6
        typical:
          value: any
        maximum:
          value: any
      pm:
        display: Phase Margin
        description: The phase margin of the OTA
        unit: °
        minimum:
          value: 60
        typical:
          value: any
        maximum:
          value: any
    tool:
      ngspice:
        template: ac.sch
        format: ascii
        suffix: .data
        variables: [a0, ugf, pm]
    plot:
      gain_vs_temperature:
        type: xyplot
        xaxis: temperature
        yaxis: a0
      phase_margin_vs_corner:
        type: xyplot
        xaxis: corner
        yaxis: pm
    conditions:
      corner:
        enumerate: [tt, ff, ss] # fs, sf
      temperature:
        minimum: -40
        typical: 27
        maximum: 130
```

- `description: <string>`
	> A global description of the parameter.

- `display: <string>`
	> A global short description to display for the parameter.
	
- `unit: <string>`
	> The global unit measurement of the parameter.
	Same format as "unit" for conditions.

- `spec: <dictionary>`
	> The target specification for the parameter (see below).

- `tool: <list>`
	> The tool which is used to run the parameter. It can either be a single name if the default settings are sufficient, or a dictionary with tool-specific settings.

- `conditions: <dictionary>`
	> All the conditions to be applied to the measurement of the
	parameter that are considered to be fixed with respect
	to the parameter result (see "variables" below).

- `variables: <list>`
	> Used for specifying `display` and `unit` attributes for results that are used for plotting.

- `plot: <dictionary>`
	> Describes how to make data plots for the parameter
	(where result is plotted rather than generating a single set
	of min/typ/max values).

### Conditions

Example entry:

```yaml
    conditions:
      vdd:
        typical: '1.8'
      vcm:
        typical: '0.9'
      corner:
        enumerate: [tt, ff, ss]
```

The "conditions" dictionary entries are the same as the
`default_conditions` dictionary, above.  The `default_conditions`
dictionary is applied to every condition before adding or
overwriting with the specific conditions listed for the
parameter. Conditions are only meaningful when the
condition name exists as a placeholder in the template file.

### Specification

Example entry:

```yaml
    spec:
      area:
        display: Area
        description: Total circuit layout area
        unit: µm²
        maximum:
          value: 600
      width:
        display: Width
        description: Total circuit layout width
        unit: µm
        maximum:
          value: any
```

The specification entry specifies the limits for results returned by the tool of the parameter. For example, if a tool returns `area` and `width` as a result, then the limits can be defined as seen above. Additionally, `display`, `description` and `unit` can be set per result and overwrite the global values.

- ```yaml
  minimum:
	value: <value>|any
	fail: <bool>
    calculation: <calculation>
	limit: <limit>
  ```
	> Specifies the target value for the parameter minimum
	value.  If not specified, then no minimum is measured.  If "any"
	is given as the value, then the minimum is measured but there
	is no target value.
	By default, the parameter is marked as failing if the
	measured value is out of spec. By setting `fail: false`, it
	is not checked agains the limit. If `calculation` and `limit`
	is specified, then it overrides	the default calculation and limit of `minimum` and `above`.

- ```yaml
  typical:
	value: <value>|any
	fail: <bool>
   calculation: <calculation>
	limit: <limit>
  ```
	> Specifies the target value for the parameter typical
	value.  If not specified, then no typical is measured.  If "any"
	is given as the value, then the typical is measured but there
	is no target value.  If "fail" is specified as "true", then parameter is marked as failing if the measured value is out of
	spec (failing on a typical value is rarely if ever used).
	If `calculation` and `limit` is specified, then it overrides	the default calculation and limit of `average` and `exact`.

- ```yaml
  maximum:
	value: <value>|any
	fail: <bool>
    calculation: <calculation>
	limit: <limit>
  ```
	> Specifies the target value for the parameter maximum
	value.  If not specified, then no maximum is measured.  If "any"
	is given as the value, then the maximum is measured but there
	is no target value.  If "fail" is also specified as "true", then parameter is marked as failing if the measured value is out of
	spec. If `calculation` and `limit` is specified, then it overrides the default calculation and limit of `maximum` and `below`.

### Tool

For an overview of which tools are currently supported by CACE, please have a look at {doc}`tools`.

Example entry:

```yaml
    tool:
      ngspice:
        template: ac.sch
        format: ascii
        suffix: .data
        variables: [a0, ugf, pm]
```

The toolname specififes which tool is used by CACE. Each tool may stay on its own or accept a range of arguments to change its behavior.

### Variables

Example entry:

```yaml
    variables:
      time:
        display: Time
        unit: ms
      Vinp:
        display: Vinp
        unit: V
      result:
        display: Vout
        unit: V
```

Variable entries are used for plotting to specify the `display` and `unit` entry of results.

- `display: <string>`
	> This value is text to display on the graph.

- `unit: <value>`
	> This is the unit that will be displayed after the display string.


### Plots

Example entry:

```yaml
    plot:
      transient:
        suffix: .svg
        xaxis: time
        yaxis: [Vout, Vinp]
```

- `type: <string>` (optional)
	> The type of plot to make. If this record is missing from the
	dictionary, then plot type "xyplot" is assumed by default.
	Otherwise, the value should be one of "xyplot", "histogram",
	"semilogx", "semilogy", or "loglog".

- `xaxis: <name>`
	> Variable to be plotted on the graph X axis.

- `yaxis: <name>|<list[name]>`
	> Variables to be plotted on the graph Y axis.

- `title: <string>` (optional)
	> A title for the graph.

- `limits: <false|true|auto>` (optional)
  - `false` - do not show limits
  - `true` - always show limits
  - `auto` - show limits if they are in the yrange

    The default setting for `limits` is auto.

Plots are made from measured columnar data which may be from a "wrdata"
command in ngspice or an "echo" statement directed to a file.

<!--

### Measure

"measure" dictionary:

```yaml
    measure:
    - tool: octave
      filename: dnl.m
```

Additional entries are tools that operate on the output of
the simulator to produce the final results for the datasheet.
They may be number-crunching tools like "octave" for compute-
intensive evaluations, or they may be a script like python
(using numpy or scipy) or bash.  The purpose of "measure" is
to modify the result produced by the simulation, including
removing variables from the result list.

- `calc: <string>`
	> This specifies an internal calculation understood by CACE to apply
	to the testbench result (see "caculations", below).

- `tool: <string>`
	> This specifies an external tool to use to make the measurement,
	typically octave.  It must also specify a filename of a script
	to run (see below).  

- `filename: <string>`
	> The filename is the name of a script to pass to the tool given as the
	value to the "tool" keyword (e.g., a ".m" script to pass to octave).
	The script must accept one argument, which is a filename consisting
	of the parameter name followed by ".dat".  It is a list of all
	results and the set of conditions for each.  Currently, ".dat" is in
	octave format, but should support JSON format for python scripts.
	The output of the "evaluate" tool is a single list of results that
	replaces (in order) the result list passed to the tool.  Currently,
	the output is passed in stdout, and is a list of "result" values
	that replaces the existing "result" values in the testbench.

Internal calculation (measurement) methods:

	> time:
	remove:
	rebase:
	abs:
	negate:
	add:
	subtract:
	multiply:
	clip:
	mean:
	risingedge:
	fallingedge:
	stabletime:
	inside:

-->
