# Version 4.0 format description

```{warning}
Prior to June 2024 CACE used the datasheet version 4.0 text format. This format is now deprecated, please export your datasheet in the new YAML format.
```

## NOTE

CACE files prior to version 4 (November 2023) are in JSON format
and can be run through the script `cace_compat.py` to produce a
version 4.0 text format.

## Syntax

Every line is either a key:value pair or a key:dictionary or a key:list,
or a blank line, or a comment.

A comment is any line beginning with `#`.

A blank line is any line consisting only of spaces, tabs, and a newline.

For key:value, the format is

	<key>:	<value>

1. Spaces outside of <key> and <value> are optional.
2. A keyword must be alphanumeric only; it cannot contain spaces.
3. The value may not begin with a space character but may contain space
   characters. If the value is interpreted as a string, the spaces are
   taken literally. If the value has multiple parts, then the spaces
   (or tabs) separate the entries.
4. The key: value assignment ends with a newline. The <value> may be
   made multi-line by ending lines with backslash-newline.

For key:dictionary, the format is

	<key> {
		<dictionary>
	}

1. The <dictionary> is a set of one or more newline-separated key:value
   pairs in the format described above, but may also be a nested
   key:dictionary or key:list.
2. Each key in the dictionary must be unique.

For key:list, the format is

	<key> {
		<dictionary>

		+
		<dictionary>

		+
		<dictionary>

		...
	}

1. Each <dictionary> is a dictionary as described above (one or more newline-
   separated key:value pairs, key:dictionary, or nested key:list).
2. The "+" may be on its own line or precede the first dictionary keyword,
   separated by space.  A blank line preceding the "+" is optional.
3. Each key within a dictionary must be unique, but different dictionaries
   in the list will contain the same keywords.

All entries in the file are from the ASCII character set. Non-ASCII characters
can be handled with known keywords in braces, such as (but not limited to):

	{degrees}
	{micro}
	{sigma}
	{ohms}
	{squared}
	{sqrt}

Dictionaries are generally searched for known keys but unknown keys are not
flagged. Therefore comments and other non-critical information can be put
in otherwise unused dictionary keys. The key "note" is considered the
proper way to pass comments about the contents of a specific dictionary;
these can end up as notes in a formatted datasheet output.

##  Characterization file contents

The top level file itself is a dictionary of `<key>`:`<value>`, `<key>`:`<dictionary>`,
or `<key>`:`<list>` entries. The top-level dictionary does not have a key and is
not delimited by braces. The file starts with the first key in the dictionary.

Top-level dictionary:

	name:	<string>
	Name of the design (cell name)

	description:	<string>
	Description of the design

	commit:  <hash-value>
	Commit hash of the repository of this IP

	PDK:	<string>
	Name of the PDK (no spaces)

	pins:	<list>
	List of I/O pins in the design (see below)

	default_conditions: <list>
	List of conditions used for parameters with default values (see below)

	electrical_parameters: <list>
	List of specified electical parameters, for spec and measurement (see below).

	physical_parameters: <list>
	List of specified physical parameters, for spec and measurement (see below).

The order of entries is not meaningful except that `default_conditions` must be
declared before `electrical_parameters`, since the electrical parameters will
take default conditions before applying specific conditions.

### Authorship

"authorship" dictionary:

	designer:	<name>
	The person to whom the design is attributed

	company:	<name>
	The name of a company, if applicable.  This is generally for
	reference and may be replaced by "institution" or other key.

	creation_date:	<datestamp>
	Date that the CACE setup was made, or any meaningful date
	for the creation of the design.

	modification_date: <datestamp> 
	Generally handled by the tools to specify when the characterization
	file was last updated.

	license:	<string>
	A known license type, such as "Apache 2.0".

### Paths

"paths" dictionary:

	documentation:	<path>
	Location of any documentation for the design.

	schematic:	<path>
	Location of any schematics (xschem) and symbols for the design.

	verilog:	<path>
	Location of any structural verilog used in the design.

	magic:		<path>
	Location of any layout in magic (.mag) format.

	layout:		<path>
	Location of any layout in GDS (.gds or .gds.gz) format.

	netlist:	<path>
	Location of all SPICE netlists.
	This netlist is usually automatically generated by cace_regenerate.py,
	with subdirectories for each netlist type according to the netlist
	source (see "-source" option):  "schematic", "layout" (for LVS),
	"pex" (C-parasitic extracted layout), and "rcx" (R-C-parasitic
	extracted layout).

	verilog:	<path>
	Location of any verilog netlists (structural verilog).

	testbench:	<path>
	Location of schematics and/or netlists used by the CACE system for
	running characterization simulations.

	simulation:	<path>
	Location of files used for simulation (e.g., netlists created by
	CACE through variable substitution into the testbench templates)
	and simulation results.

	reports:	<path>
	Reports and log files generated by CACE.

	root:		<path>
	This is the location of the project and the root of all the other
	paths in this dictionary.  It is automatically inserted by CACE.

### Dependencies

"dependencies" list:

	Each entry in the list is a project on which the design under
	test is dependent.  Each entry lists a dictionary with the
	following dictionary entries:

	name:	<string>
	Name of the dependency

	path:	<path>
	Path to the dependency (may be relative or absolute, but
	preferably relative for portability).

	repository: <url>
	Location of the project repository of the dependency, so that
	if the dependency does not exist, it can be cloned into the
	target path on demand.
	
	commit: <hash>
	Commit hash of the repository of the dependency to use in this
	project.  TBD:  Various values that define actions such as updating
	the repository.

### Pins

"pins" dictionary:
	
	name:	<string>
	The pin name.  Must match the name on the schematic or netlist.
	Vectors should be indexed with ":" and will be expanded when
	needed.  "b7:0" expands to "b7, b6, b5, ..." while "b[7:0]"
	expands to "b[7], b[6], b[5], ..." (Note that this is more
	flexible than the convention for condition names described
	below.)

	description:	<string>
	Text description of the pin.  May contain spaces.

	type:	<string>
	The type may be one of "digital", "signal", "power", or "ground".
	
	direction:	<string>
	The direction may be one of "input", "output", or "inout".

	Vmin:	<number>|<expression>
	The pin minimum voltage may be a value or may be referenced to
	another pin;  and may be referenced to another pin with an offset
	(e.g., "vss - 0.3").

	Vmax:	<number>|<expression>
	The pin minimum voltage may be a value or may be referenced to
	another pin;  and may be referenced to another pin with an offset
	(e.g., "vdd + 0.3").

### Default conditions

"default_conditions" dictionary:

	name: <string>
	The name of the condition;  this name is meaningful because it
	will match a variable name used in a schematic or netlist.  The
	representation in the netlist is always ${<string>} to prevent
	accidental substitutions of matching strings.  Any set of signals
	can be bundled, but the delimiters for the bundle must be brackets;
	e.g., b[7:0], with single bits called out as, e.g., b[0].

	description: <string>
	A description of the condition.

	display: <string>
	A short, typically one-word value to display for the condition
	in a datasheet or GUI.

	unit: <string>
	The unit of measure used to display the condition value.

	typical: <value>
	If present, the default typical value of the condition.

	maximum: <value>
	If present, the default maximum value of the condition.

	minimum: <value>
	If present, the default minimum value of the condition.

	enumerate: <values>
	If present, instead of min/typ/max values, the values are
	enumerated from a space-separated list supplied in <values>
	(see above; long lists may be backslash-newline terminated).

	step: linear|logarithmic
	If not present, then only values min/typ/max are evaluated.
	If present, then values are automatically enumerated from
	min to max inclusive either in linear (default) or logarithmic
	progression.  If typ exists and is not in the enumeration,
	then it is evaluated in addition.

	stepsize: <value>
	If not present, then a stepsize of 1 is assumed for linear
	enumeration or 2 for logarithmic enumeration.  Otherwise,
	the enumeration steps by <value> additive values for linear
	enumeration or <value> multiplicative values for logarithmic
	enumeration.

### Parameter conditions

"conditions" dictionary:

	The "conditions" dictionary entries are the same as the
	"default_conditions" dictionary, above.  The "default_conditions"
	dictionary is applied to every condition before adding or
	overwriting with the specific conditions listed for the
	electrical parameter.  Conditions are only meaningful when the
	condition name exists in the netlist to be simulated or the file
	to be evaluated (see "simulate" and "measure" entries).

### Electrical conditions

"electrical_parameters" dictionary:

	name: <string>
	A name for the electrical parameter (used only for bookkeeping
	purposes).

	description: <string>
	A description of the electrical parameter (may contain spaces)

	display: <string>
	A short description to display for the electrical parameter
	on a datasheet or GUI.
	
	unit: <string>
	The unit measurement of the electrical parameter result value.
	Same format as "unit" for conditions.

	spec: <dictionary>
	The target specification for the electrical parameter (see below).

	results: <list>
	The results corresponding to the spec, with dictionary entries
	similar to "spec".  It is a list because specs may be measured
	at the schematic stage of design, layout for LVS, or layout
	with parasitics (see "results" dictionary definition, below).
	
	simulate: <list>
	How to collect data for measurement.  Normally this list is a
	single item, as there is only one way to simulate a parameter.
	However, cosimulations or other complex setups may require
	additional entries.  Each entry in the list is a tool or script
	to be run to produce simulation results.

	measure: <list>
	How to measure the electrical parameter or collect data for
	measurement.  Each entry in the list is a tool or script to
	be run in sequence (see "measure" dictionary definiton, below).

	conditions: <dictionary>
	All the conditions to be applied to the measurement of the
	electrical parameter that are considered to be fixed with respect
	to the electrical parameter result (see "variables" below).

	variables: <list>
	Enumerates the variables that are enumerated within the simulation
	and output but which are not conditions (e.g., time).  The 'result'
	variable (the one representing the electrical parameter) is already
	specified in the parameter and does not need to be in the 'variables'
	list.

	plot: <dictionary>
	Describes how to make a data plot for the electrical parameter
	(where result is plotted rather than generating a single set
	of min/typ/max values).  Requires a corresponding "variables"
	list.

	testbenches: <list>
	This entry is automatically generated by CACE and enumerates all
	of the testbenches to be simulated and evaluated, and the results.

### Specification

"spec" dictionary:

	minimum: <value>|any  [fail]	[<calculation>-<limit>]
	Specifies the target value for the electrical parameter minimum
	value.  If not specified, then no minimum is measured.  If "any"
	is given as the value, then the minimum is measured but there
	is no target value.  If "fail" is also specified, then electrical
	parameter is marked as failing if the measured value is out of
	spec.  If <calculation>-<limit> is specified, then it overrides
	the default calculation of "minimum-above"

	typical: <value>|any  [fail]	[<calculation>-<limit>]
	Specifies the target value for the electrical parameter typical
	value.  If not specified, then no typical is measured.  If "any"
	is given as the value, then the typical is measured but there
	is no target value.  If "fail" is also specified, then electrical
	parameter is marked as failing if the measured value is out of
	spec (failing on a typical value is rarely if ever used).
	If <calculation>-<limit> is specified, then it overrides the
	default calculation of "average-exact"

	maximum: <value>|any  [fail]	[<calculation>-<limit>]
	Specifies the target value for the electrical parameter maximum
	value.  If not specified, then no maximum is measured.  If "any"
	is given as the value, then the maximum is measured but there
	is no target value.  If "fail" is also specified, then electrical
	parameter is marked as failing if the measured value is out of
	spec.  If <calculation>-<limit> is specified, then it overrides
	the default calculation of "maximum-below"

### Results

"results" dictionary:

	A set of results that is the measurement counterpart to the
	"spec" dictionary for an electrical parameter.  The difference
	is that it includes a key "name" that specifies the netlist
	source used for the simulations, which is one of "schematic"
	(for schematic captured netlist), "layout" (layout extracted
	netlists), "pex" (parasitic capacitance extracted layout), or
	"rcx" (parasitic capacitance and resistance extracted layout).
	The entries for "minimum", "typical", and "maximum" have a
	value which is the measured value, and a score ("pass" or
	"fail") indictating whether the value is in spec or not.

	name: schematic|layout|pex|rcx
	minimum: <value> [pass|fail]
	typical: <value> [pass|fail]
	maximum: <value> [pass|fail]

### Variables

"variables" list:

	A variable is any property that affects the electrical parameter
	result but which is not a condition.  A variable may be used in
	a plot to graph the result vs. something that is not a condition.
	Otherwise, all variables must be eliminated during the course of
	evaluation.  Note:  Use of "collate" in a "simulate" dictionary
	will force any condition in the collated list to become a
	variable, as if it were produced by the simulation instead of
	being passed to it.

	name: <string>
	The name is a placeholder for bookkeeping, except for string
	"result" which indicates that the condition in this dictionary
	is the result vector to be plotted.

	display: <string>
	This value is text to display on the graph, which may appear
	in a key if the value is not for data corresponding to the
	graph X or Y axis.

	unit: <value>
	This is the unit that will be displayed after the display
	string.

### Simulation information

"simulate" dictionary:

	tool: <string>
	This specifies the (software) tool that is used to make the
	measurement or to evaluate the measurement result.  Typically
	the first entry will always be "ngspice" for most electrical
	parameters.  For physical parameters, it will be a scripting
	language like "python" or "bash".  The output of "measure" is
	an annotated parameter entry with a "results" section added
	(see above).

	template: <string>
	This specifies the name of the file that is used as the template for
	simulation.  The conditions for the specific measurement are
	determined, and the condition values are variable-substituted in the
	template, and then the resulting set of files is passed to the tool.

	format: <string>
	This specifies the format of the simulation output.  The string
	must be in the form:
		<format> .<suffix> <condition|variable> ...
	The format line informs CACE how to merge results from multiple
	simulation runs for the same electrical parameter by describing
	the format of the tool's output file and its contents.  <format>
	is currently "ascii" (however, "raw" for SPICE raw files will be
	supported in the future, and "vcd" files may be produced from
	verilog cosimulation);  these are limited to formats understood
	by, and handled by, CACE code.  <suffix> is the filename suffix of
	the output file, which otherwise must have the same root name as
	the file passed to the tool.  <variable> may be one of "result"
	for the result value, "time" for a time value, "null" for any value
	that is not evaluated, or any condition or variable name.  If any
	condition name appears in the format string, then there must be
	enough lines of output in the file to match the number of conditions
	simulated.  This is used for sweeps and plots.

	collate: <condition> ...
	This specifies that the simulation output should be collated from
	runs over all the specified conditions before passing the result
	to the first "measure" handler.

### Measurement information

"measure" dictionary:

	Additional entries are tools that operate on the output of
	the simulator to produce the final results for the datasheet.
	They may be number-crunching tools like "octave" for compute-
	intensive evaluations, or they may be a script like python
	(using numpy or scipy) or bash.  The purpose of "measure" is
	to modify the result produced by the simulation, including
	removing variables from the result list.

	calc: <string>
	This specifies an internal calculation understood by CACE to apply
	to the testbench result (see "caculations", below).

	tool: <string>
	This specifies an external tool to use to make the measurement,
	typically octave.  It must also specify a filename of a script
	to run (see below).  

	filename: <string>
	The filename is the name of a script to pass to the tool given as the
	value to the "tool" keyword (e.g., a ".m" script to pass to octave).
	The script must accept one argument, which is a filename consisting
	of the parameter name followed by ".dat".  It is a list of all
	results and the set of conditions for each.  Currently, ".dat" is in
	octave format, but should support JSON format for python scripts.
	The output of the "evaluate" tool is a single list of results that
	replaces (in order) the result list passed to the tool.  Currently,
	the output is passed in stdout, and is a list of "result" values
	that replaces the existing "result" values in the testbench.

### Internal calculations

Internal calculation (measurement) methods:

	time:
	remove:
	rebase:
	abs:
	negate:
	add:
	subtract:
	multiply:
	clip:
	mean:
	risingedge:
	fallingedge:
	stabletime:
	inside:
	
### Plots

"plot" dictionary:

	filename: <string>
	Name of a graphic format and filename to use for graph output.
	Plots are done with python matplotlib, so it must be a format
	known to matplotlib.

	type: <string>
	The type of plot to make.  If this record is missing from the
	dictionary, then plot type "xyplot" is assumed by default.
	Otherwise, the value should be one of "xyplot", "histogram",
	"semilogx", "semilogy", or "loglog".

	xaxis: <name>
	Condition to be plotted on the graph X axis, as determined
	from the condition related to <name> in the "variables"
	section.  The X-axis label is taken from the variable entry
	as well.

	yaxis: <name>
	Condition to be plotted on the graph Y axis, as determined
	from the condition related to <name> in the "variables"
	section.  The Y-axis label is taken from the variable entry
	as well.

	title: <string>
	A title for the graph.

Plots are made from measured columnar data which may be from a "wrdata"
command in ngspice, an "echo" statement directed to a file, or a raw file;
regardless, each column will be either a condition or a result.  Conditions
produced by plot-generating tools may contain vectors not in the listed
conditions for the electrical parameter, such as TIME for time or TRACE for
the result.
	
### Testbenches

"testbenches" dictionary:

	filename: <string>
	The name of the filename passed to the simulator.

	conditions: <list>
	The value of all fixed conditions for this simulation.

	results: <list>
	The results from the simulation.  Each item is a nested list
	containing result values.  The order and meaning of the
	results is specified by the "format" entry.  After running each
	calculation defined in the "measure" list, the results are
	updated and the format of the testbench is modified to reflect
	the update.

	format: <list>
	The format of the results list for the testbench.  The format
	is itself a list of which the first item should always be
	"result", referring to the electrical parameter itself, and
	optionally followed by one or more variable names.  Each item
	in the "results" list must have the same number of entries as
	the format, and entries must match the order of the entries
	in the format.

### Physical parameters

"physical_parameters" list:

	The physical parameters list has the same keywords as the
	electrical parameters, except that the parameters are
	physical measurements of the layout such as area, width,
	height, max metal layer, and may include number of DRC
	or LVS errors.

	Dictionary keys that are shared with "electrical_parameters"
	are: name, status, description, display, unit, and spec.

	The "evaluate" dictionary is unique to physical parameters
	and takes the place of "simulate" and "measure" for electrical
	parameters (see below).

### Evaluation information

"evaluate" dictionary:

	The "evaluate" dictionary is unique to the physical_parameters
	dictionaries.  It describes how to obtain a specific physical
	or other non-electrical parameter, such as cell size or number
	of DRC or LVS errors.  Running the tool must produce a single
	value as output, which is then checked against the spec to
	provide a pass/fail result.

	tool:		<string>
	The name of a tool to use for the evaluation.  This may be an
	internal procedure known to CACE (see list below).  If not, then
	it must be a standard application or interpreter (such as python).
	The filename (see below) is passed to the tool as the argument.
	Any options to pass to the tool should be included in the string.

	filename:	<name>
	The name of a script or filename to pass to the tool specified
	by "tool", if the tool is not an internal procedure.  The file
	<name> should exist in the testbench directory.

### Internal physical parameter tools

Internal physical parameter (evaluation) tools:

	cace_drc:	Returns the number of DRC errors found in the design.
			The result is generally useful only as being zero or
			non-zero.

	cace_lvs:	Returns the number of LVS errors found in the design.
			The result is generally useful only as being zero or
			non-zero.

	cace_area:	Returns the area of the layout.

	cace_width:	Returns the width of the layout.

	cace_length:	Returns the length of the layout.
